/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;

public class JavaNetURLConnectionWrapper
extends URLConnection {
    private ResourceConnection connection;

    private JavaNetURLConnectionWrapper(URL uRL, ResourceConnection resourceConnection) {
        super(uRL);
        this.connection = resourceConnection;
    }

    public static URLConnection createWrapper(ResourceConnection resourceConnection) throws IOException {
        URI uRI = resourceConnection.getURI();
        URL uRL = null;
        try {
            String string = uRI.toExternalForm();
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new JavaNetURLConnectionWrapper(uRL, resourceConnection);
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public String getContentType() {
        return this.connection.getContentType();
    }

    public Object getContent() throws IOException {
        return this.connection.getContent();
    }

    public Object getContent(Class[] classArray) throws IOException {
        return this.connection.getContent(classArray);
    }

    public void connect() throws IOException {
        this.connection.connect();
    }

    public int getContentLength() {
        return this.connection.getContentLength();
    }

    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    public String getHeaderField(int n) {
        return this.connection.getHeaderField(n);
    }

    public String getHeaderField(String string) {
        return this.connection.getHeaderField(string);
    }

    public String getHeaderFieldKey(int n) {
        return this.connection.getHeaderFieldKey(n);
    }
}

