/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.EditorPane;
import WIMSchem.Molecule;
import WIMSchem.ds.DataTableModel;
import WIMSchem.ds.EditWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

class TableMoleculeEditor
extends AbstractCellEditor
implements TableCellEditor {
    EditorPane edview = null;

    public boolean isCellEditable(EventObject e) {
        if (e instanceof KeyEvent) {
            KeyEvent ev = (KeyEvent)e;
            return ev.getKeyChar() == ' ';
        }
        if (e instanceof MouseEvent) {
            MouseEvent ev = (MouseEvent)e;
            return ev.getClickCount() == 2 && ev.getButton() == 1;
        }
        return false;
    }

    public void setMolecule(Molecule mol) {
        this.edview.replace(mol);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        Molecule mol = (Molecule)value;
        DataTableModel model = (DataTableModel)table.getModel();
        if (mol == null) {
            mol = new Molecule();
        }
        this.edview = new EditorPane();
        this.edview.setOpaque(true);
        this.edview.setEditable(false);
        this.edview.setAutoScale(true);
        Color sel = table.getSelectionBackground();
        Color dark = sel.darker();
        this.edview.setBackground(dark);
        this.edview.replace(mol);
        EditWindow edwin = new EditWindow(mol.clone(), model, this);
        this.addCellEditorListener(edwin);
        SwingUtilities.invokeLater(new PopMeUp(edwin));
        return this.edview;
    }

    public Object getCellEditorValue() {
        return this.edview == null ? null : this.edview.molData();
    }

    class PopMeUp
    implements Runnable {
        JFrame win;

        PopMeUp(JFrame win) {
            this.win = win;
        }

        public void run() {
            this.win.setVisible(true);
            this.win.requestFocus();
        }
    }
}

