!***********************************************************************
! Application defaults for xfm.
! Defaults are commented out (have a ! in front of them)
! (Don't forget to remove the ! in front of those you change)
!***********************************************************************
!********** Version of xfm this is made for **********
Xfm.appDefsVersion: 1.5

!***********************some Colors*******************
Xfm*highlightColor: midnight blue
Xfm*foreground: black
Xfm*background: grey77
Xfm*fmLog*log_text.background: white
!!Xfm*viewport.icon box*Toggle.foreground: midnight blue

!****************some files and filepaths:************
! bitmap and pixmap path:
!Xfm.bitmapPath: DATADIR/bitmaps:/usr/include/X11/bitmaps
!Xfm.pixmapPath: DATADIR/icons:DATADIR/pixmaps:/usr/include/X11/pixmaps
! Search for Application Files:

!Xfm.systemwideApplicationDataFile: APPDIR/Apps.xfm
!Xfm.applicationDataFile: ~/.xfm/Apps.xfm
!Xfm.systemwideApplicationDataDir: APPDIR
!Xfm.applicationDataDir: ~/.xfm

! store CopyPaste between Application windows in here:
!Xfm.applicationDataClip: ~/.xfm/.XfmClip

! Config files:
!Xfm.systemwideDevFile: CONFDIR/xfm_dev
!Xfm.systemwideMailcapFile: CONFDIR/xfm_mailcap
!Xfm.systemwideMimeTypesFile: CONFDIR/xfm_mime.types
!Xfm.systemwideMagicFile: CONFDIR/xfm_magic
!Xfm.devFile: ~/.xfm/xfm_dev
!Xfm.mailcapFile: ~/.xfm/xfm_mailcap
!Xfm.magicFile: ~/.xfm/xfm_magic
!Xfm.mimeTypesFile: ~/.xfm/xfm_mime.types

!*****************Asking questions********************

!Xfm.confirmDeletes: True
!Xfm.confirmDeleteFolder: True
!Xfm.confirmMoves: True
!Xfm.confirmCopies: True
!Xfm.confirmOverwrite: True
!Xfm.confirmQuit: True

!**********************Echoing************************

!Xfm.echoActions: False

!******************what and how to show****************
! TODO: move them to Xfm
!Xfm.showOwner: True
!Xfm.showDate: True
!Xfm.showPermissions: True
!Xfm.showLength: True
!Xfm.showInode: True
!Xfm.showType: True
!Xfm.showGroup: True
!Xfm.showLinks: True
!Xfm.defaultDisplayType: Icons
!Xfm.initialDisplayType: Icons
!Xfm.defaultSortType: SortByName

!****************fall-back programs*******************
Xfm.editor: nedit
Xfm.viewer: xless
!Xfm.xTerminal: x-terminal-emulator -e
!Xfm.xTerminalAlone: x-terminal-emulator
!Xfm.shell: /bin/sh

!*******Specify which window to show at startup*******
! if none is True and no -filemgr nor -appmgr is in the command line
! both are shown:

!Xfm.appmgr:  False
!Xfm.filemgr: False

!***********************fonts*************************
! to set all fonts:
Xfm*Font: XtDefaultFont
! some special Fonts:
Xfm.iconFont: -adobe-helvetica-medium-r-*-*-10-*
Xfm.buttonFont: -adobe-helvetica-medium-r-*-*-12-*
Xfm.menuFont: -adobe-helvetica-medium-r-*-*-12-*
Xfm.labelFont: -adobe-helvetica-medium-r-*-*-12-*
Xfm.statusFont: -adobe-helvetica-medium-r-*-*-12-*
Xfm.boldFont: -adobe-helvetica-bold-r-*-*-12-*
! this should be a fixed width font:
Xfm.cellFont: fixed
Xfm*fmLog*AsciiSink.font: -*-lucidatypewriter-medium-r-*-*-12-*
!**********************geometry***********************
! application window
Xfm.Geometry:	240x345+565+130
! file windows:
Xfm.initGeometry:	555x345+5+130
Xfm.file windows.Geometry:	555x345
! Layout in Icons mode:
!Xfm*IconFileList.entrySep:	2
!Xfm*IconFileList.topSep:	2
!Xfm*IconFileList.leftSep:	2
!Xfm*IconFileList.labelSep:	2
! number of columns, 0=as much as fit:
!Xfm*IconFileList.nHoriz:	0
! minimal width of icons:
!Xfm*IconFileList.minIconWidth:		0
! minimal height of icons:
!Xfm*IconFileList.minIconHeight:	0
! maximal length of text below an icon:
!Xfm*IconFileList.maxLabelWidth:	150
! Layout in Text mode:
!Xfm*TextFileList.entrySep:	2
!Xfm*TextFileList.topSep:	2
!Xfm*TextFileList.leftSep:	2
!Xfm*TextFileList.tabSep:	4
! TODO: move show* here?
!***********************different stuff***************
! hopefully not needed:
!Xfm.BourneShells: AUTO
! number of history entries to keep
!Xfm.historyMaxN: 30
! tolarance for matching colors
!Xfm.colorCloseness: 40000
! seperator between file names for the clipboard
! a space, escaped with a \ before it:
!Xfm.selectionPathsSeparator: \  
! miliseconds between folder updates
!Xfm.updateInterval: 10000
! reread permissions every n-th update (0=disable)
Xfm.hardUpdateTicks: 10
! miliseconds between double clicks:
!Xfm.doubleClickTime: 300
! ignore magic rules needing so much look-ahead in a file
!Xfm.maxMagicRead: 1024

!**********************************************************
! translations (key and mouse bindings in the following format)
! should be called baseTranslations in the app-defaults file
! so that a .Xresources file can have .translations items for
! just the changed items.
!
! mouse and key bindings for File Window in Icon view:
!Xfm*IconFileList.baseTranslations:#override\n\
    <Enter>                : dispatchDirFile(fileHighlight,fileMaybeHighlight,"")\n\
    <Leave>                : resetCursor()\n\
    Shift <Btn1Down>,<Btn1Up> : fileToggle()\n\
    <Btn1Up>(2)            : dispatchDirFile(fileOpenDir,fileExecAction,"")\n\
    <Btn1Down>,<Btn1Up>    : fileSelect()\n\
    <Btn1Down>,<Motion>    : fileBeginDrag(1,move)\n\
    <Btn2Down>,<Btn2Up>    : fileToggle()\n\
    <Btn2Down>,<Motion>    : fileBeginDrag(2,copy)\n\
    Any<Btn3Down>          : grabMouseForPopup(dispatchDirFile,dirPopup,filePopup,"")\n\
    Any<Btn4Down>          : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>          : ViewportScroll(+0.1,V)\n\
    Shift   <Key>n         : notify(*folder*new)\n\
    Shift   <Key>g         : notify(*folder*goto)\n\
    Shift   <Key>h         : notify(*folder*home)\n\
    Shift   <Key>u         : notify(*folder*up)\n\
    Shift   <Key>c         : notify(*folder*clone)\n\
    Shift   <Key>q         : notify(*folder*close)\n\
    Ctrl    <Key>r         : notify(*view*tree)\n\
    Ctrl    <Key>i         : notify(*view*icons)\n\
    Ctrl    <Key>t         : notify(*view*text)\n\
    Ctrl    <Key>n         : notify("*view*sort by name")\n\
    Ctrl    <Key>s         : notify("*view*sort by size")\n\
    Ctrl    <Key>d         : notify("*view*sort by mtime")\n\
    Ctrl    <Key>f         : notify(*view*filter)\n\
    Ctrl    <Key>h         : notify("*view*hide folders")\n\
    Ctrl    <Key>m         : notify("*view*mix folders/files")\n\
    Ctrl    <Key>u         : notify("*view*show hidden files")\n\
    Ctrl    <Key>l         : notify("*view*show log")\n\
    <Key>n                 : notify(*file*new)\n\
    <Key>m                 : notify(*file*move)\n\
    <Key>c                 : notify(*file*copy)\n\
    <Key>l                 : notify(*file*link)\n\
    <Key>d                 : notify(*file*delete)\n\
    <Key>Delete            : notify(*file*delete)\n\
    <Key>BackSpace         : notify(*file*delete)\n\
    <Key>s                 : notify(*file*select)\n\
    <Key>a                 : notify("*file*select all")\n\
    <Key>u                 : notify("*file*deselect all")\n\
    <Key>o                 : notify("*file*own Selection")\n\
    <Key>x                 : notify(*file*xterm)\n\
    <Key>q                 : notify(*file*quit)\n

! mouse and key bindings for FileWindow in Text view:
!Xfm*TextFileList.baseTranslations:#override\n\
    <Enter>                : dispatchDirFile(fileHighlight,fileMaybeHighlight,"")\n\
    <Leave>                : resetCursor()\n\
    Shift  <Btn1Down>,<Btn1Up> : fileToggle()\n\
    <Btn1Up>(2)            : dispatchDirFile(fileOpenDir,fileExecAction,"")\n\
    <Btn1Down>,<Btn1Up>    : fileSelect()\n\
    <Btn1Down>,<Motion>    : fileBeginDrag(1,move)\n\
    <Btn2Down>,<Btn2Up>    : fileToggle()\n\
    <Btn2Down>,<Motion>    : fileBeginDrag(2,copy)\n\
    Any<Btn3Down>          : grabMouseForPopup(dispatchDirFile,dirPopup,filePopup,"")\n\
    Any<Btn4Down>          : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>          : ViewportScroll(+0.1,V)\n\
    Shift   <Key>n         : notify(*folder*new)\n\
    Shift   <Key>g         : notify(*folder*goto)\n\
    Shift   <Key>h         : notify(*folder*home)\n\
    Shift   <Key>u         : notify(*folder*up)\n\
    Shift   <Key>c         : notify(*folder*clone)\n\
    Shift   <Key>q         : notify(*folder*close)\n\
    Ctrl    <Key>r         : notify(*view*tree)\n\
    Ctrl    <Key>i         : notify(*view*icons)\n\
    Ctrl    <Key>t         : notify(*view*text)\n\
    Ctrl    <Key>n         : notify("*view*sort by name")\n\
    Ctrl    <Key>s         : notify("*view*sort by size")\n\
    Ctrl    <Key>d         : notify("*view*sort by mtime")\n\
    Ctrl    <Key>f         : notify(*view*filter)\n\
    Ctrl    <Key>h         : notify("*view*hide folders")\n\
    Ctrl    <Key>m         : notify("*view*mix folders/files")\n\
    Ctrl    <Key>u         : notify("*view*show hidden files")\n\
    <Key>n                 : notify(*file*new)\n\
    <Key>m                 : notify(*file*move)\n\
    <Key>c                 : notify(*file*copy)\n\
    <Key>l                 : notify(*file*link)\n\
    <Key>d                 : notify(*file*delete)\n\
    <Key>Delete            : notify(*file*delete)\n\
    <Key>BackSpace         : notify(*file*delete)\n\
    <Key>s                 : notify(*file*select)\n\
    <Key>a                 : notify("*file*select all")\n\
    <Key>u                 : notify("*file*deselect all")\n\
    <Key>o                 : notify("*file*own Selection")\n\
    <Key>x                 : notify(*file*xterm)\n\
    <Key>q                 : notify(*file*quit)\n

!**************remove some borders********************
! these are some fall-back defaults. There is no easy
! way to specify them in the program in a way they can
! be changed here or in a user's .Xresources file without
! being in here, so here they are:
Xfm*Command.cursor: hand2
Xfm*Command*borderWidth: 0
Xfm*viewport*Command*shadowWidth: 0
Xfm*MenuButton.cursor: hand2
Xfm*popup form*bitmap.borderWidth: 0
Xfm*popup form*label.borderWidth: 0
Xfm*button box.orientation: horizontal
Xfm*button box.borderWidth: 0
Xfm*file window*viewport.borderWidth: 0
Xfm*viewport.icon box*Label.borderWidth: 0
Xfm*viewport.icon box.Command.borderWidth: 0
Xfm*viewport.icon box.Form.borderWidth: 0
Xfm*viewport.icon box*Toggle.borderWidth: 1
Xfm*chmod*Label.borderWidth: 0
Xfm*info*Label.borderWidth: 0
Xfm*error*Label.borderWidth: 0
Xfm*confirm*Label.borderWidth: 0
Xfm*fm_history.label:   Path history
Xfm*fm_history*SmeLine.lineWidth: 1
! the translations for the Application Window
Xfm*awform*icon box.baseTranslations: #override\n\
    <Btn2Up>            : dummy()\n\
    <Btn3Up>            : dummy()\n\
    Any<Btn3Down>       : appPopup()\n\
    <Enter>             : appTrackCursor()\n\
    <Leave>             : appTrackCursor()\n\
    Any<Btn4Down>       : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>       : ViewportScroll(+0.1,V)\n
Xfm*awform*icon box*label.baseTranslations: #override\n\
    Any<Btn4Down>       : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>       : ViewportScroll(+0.1,V)\n\
    <Enter>             : appTrackCursor()\n\
    <Leave>             : appTrackCursor()\n
Xfm*awform*icon box*icon.baseTranslations:#override\n\
    Any<Btn4Down>       : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>       : ViewportScroll(+0.1,V)\n\
    <Enter>             : appMaybeHighlight()\n\
    <Leave>             : unhighlight()\n\
    <Btn1Up>(2)         : runApp()\n\
    <Btn1Down>,<Btn1Up> : appSelect()\n\
    <Btn1Down>,<Leave>  : appBeginDrag(1,move)\n\
    <Btn2Down>,<Btn2Up> : appToggle()\n\
    <Btn2Down>,<Leave>  : appBeginDrag(2,copy)\n
! the translations for the folderlabel of a file window
Xfm*file window*folderlabel.baseTranslations: #override\n\
    Any<Btn3Down>	: FmUpdateHistory(fm_history) MenuPopup(fm_history)\n\
    <Btn1Up>(2)         : fileRefresh()\n
! the file window main viewport:
Xfm*file window*viewport.baseTranslations: #override\n\
    <Enter>		: trackCursor()\n\
    <Leave>		: trackCursor()\n\
    Any<Btn4Down>       : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>       : ViewportScroll(+0.1,V)\n
! the translations for the Tree View of a file window:
Xfm*file window*icon box*tree_icon.baseTranslations: #override\n\
    <Enter>             : fileHighlight()\n\
    <Leave>             : resetCursor()\n\
    Shift <Btn1Down>,<Btn1Up> : fileToggle()\n\
    <Btn1Down>,<Btn1Up> : fileSelect()\n\
    <Btn1Down>,<Leave>  : fileBeginDrag(1,move)\n\
    <Btn2Down>,<Btn2Up> : fileToggle()\n\
    <Btn2Down>,<Leave>  : fileBeginDrag(2,copy)\n\
    <Btn3Down>          : dirPopup()\n\
    Any<Btn4Down>       : ViewportScroll(-0.1,V)\n\
    Any<Btn5Down>       : ViewportScroll(+0.1,V)\n\
    Shift   <Key>n      : notify(*folder*new)\n\
    Shift   <Key>g      : notify(*folder*goto)\n\
    Shift   <Key>h      : notify(*folder*home)\n\
    Shift   <Key>u      : notify(*folder*up)\n\
    Shift   <Key>c      : notify(*folder*clone)\n\
    Shift   <Key>q      : notify(*folder*close)\n\
    Ctrl    <Key>r      : notify(*view*tree)\n\
    Ctrl    <Key>i      : notify(*view*icons)\n\
    Ctrl    <Key>t      : notify(*view*text)\n
! the translations for the text fields:
Xfm*TextField.baseTranslations:#override\n\
    Any<Btn3Down>: FocusSet() FmUpdateHistory(fm_history) MenuPopup(fm_history)\n\
    Shift <Key>Tab:FocusTraverse(b)\n\
    <Key>Tab:FocusTraverse()\n\
    <FocusIn>:Detail_NotifyAncestor(CursorState,a)\n\
    <FocusOut>:Detail_NotifyAncestor(CursorState,i)\n\
    <Btn1Up>:FocusSet() HighlightExtend() MakeSelection(PRIMARY)\n\
    <Btn2Up>:FocusSet() MoveCursor() InsertSelection(PRIMARY)\n\
    <Enter>:\n\
    <Leave>:\n\
    <Key>Escape: \n\
    <Key>Return: \n\
    <Key>Linefeed:\n
! first popdown menu, then trigger action:
Xfm*SimpleMenu.baseTranslations:#override\n\
		<BtnUp>: popdown() notify() unhighlight()\n
! accelerators for some Buttons:
Xfm*button box*cancel.accelerators:#override\n\
    <ClientMessage>WM_PROTOCOLS: set() notify() unset()\n\
    <Key>Escape: set() notify() unset()\n
Xfm*about*button box*ok.accelerators:#override\n\
    <ClientMessage>WM_PROTOCOLS: set() notify() unset()\n\
    <Key>Escape: set() notify() unset()\n
Xfm*button box*ok.accelerators:#override\n\
    <Key>Return: set() notify() unset()\n\
    <Key>Linefeed: set() notify() unset()\n
Xfm*button box*replace.accelerators:#override\n\
    <Key>Return: set() notify() unset()\n\
    <Key>Linefeed: set() notify() unset()\n
Xfm*button box*install.accelerators:#override\n\
    <Key>Return: set() notify() unset()\n\
    <Key>Linefeed: set() notify() unset()\n
Xfm*fmLog*Hide.accelerators:#override\n\
    <ClientMessage>WM_PROTOCOLS: set() notify() unset()\n\
    <Key>Return: set() notify() unset()\n\
    <Key>Linefeed: set() notify() unset()\n
Xfm*fmLog*Clear Log.accelerators:#override\n\
    <Key>Delete: set() notify() unset()\n
!***Info for the Log window:****
! Some settings for the log window
Xfm*fmLog.title: Xfm output log
! You can enable the horizontal scrollbar if you want:
Xfm*fmLog*Text.scrollHorizontal: whenNeeded
! The initial value of the 'auto popup' toggle which
! determines if the Log window pops up automatically
! when new data is available.
Xfm*fmLog*Auto Flag.state: True
Xfm*fmLog.width:515
Xfm*fmLog.height:200
