// **********************************************************************
//
// Copyright (c) 2003-2013 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

#include <Ice/Ice.h>
#include <TestCommon.h>
#include <Test.h>
#include <Dispatcher.h>

DEFINE_TEST("client")

using namespace std;

int
run(int, char**, const Ice::CommunicatorPtr& communicator)
{
    void allTests(const Ice::CommunicatorPtr&);
    allTests(communicator);
    return EXIT_SUCCESS;
}

int
main(int argc, char* argv[])
{
    int status;
    Ice::CommunicatorPtr communicator;
    
    try
    {
        Ice::InitializationData initData;
        initData.properties = Ice::createProperties(argc, argv);
#ifdef ICE_CPP11
        Ice::DispatcherPtr dispatcher = new Dispatcher();
        initData.dispatcher = Ice::newDispatcher(
            [=](const Ice::DispatcherCallPtr& call, const Ice::ConnectionPtr& conn)
                {
                    dispatcher->dispatch(call, conn);
                });
#else
        initData.dispatcher = new Dispatcher();
#endif
        communicator = Ice::initialize(argc, argv, initData);
        

        status = run(argc, argv, communicator);
    }
    catch(const Ice::Exception& ex)
    {
        cerr << ex << endl;
        status = EXIT_FAILURE;
    }

    if(communicator)
    {
        try
        {
            communicator->destroy();
        }
        catch(const Ice::Exception& ex)
        {
            cerr << ex << endl;
            status = EXIT_FAILURE;
        }
    }
    Dispatcher::terminate();
    return status;
}
