/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2024 Realtek Corporation. All rights reserved
 */

#include "../r8169_compat.h"
#include "../r8169_dash.h"
#include "../r8169_hw.h"
#include "../r8169_phy.h"
#include "rtl8168fp.h"

/* For RTL8168FP, CFG_METHOD_31,32,33,34 */

/* ------------------------------------MAC 8168FP--------------------------------------- */

static void
rtl8168_set_mac_mcu_8168fp_1(struct rtl_hw *hw)
{
	u16 i;

	rtl_hw_disable_mac_mcu_bps(hw);
	if (hw->HwPkgDet == 0x00 || hw->HwPkgDet == 0x0F) {
		static const u16 mcu_patch_code_8168fp_1_1[] = {
			0xE00A, 0xE0C1, 0xE104, 0xE108, 0xE10D, 0xE112, 0xE11C, 0xE121, 0xE000,
			0xE0C8, 0xB400, 0xC1FE, 0x49E2, 0xF04C, 0x49EA, 0xF04A, 0x74E6, 0xC246,
			0x7542, 0x73EC, 0x1800, 0x49C0, 0xF10D, 0x49C1, 0xF10B, 0x49C2, 0xF109,
			0x49B0, 0xF107, 0x49B1, 0xF105, 0x7220, 0x49A2, 0xF102, 0xE002, 0x4800,
			0x49D0, 0xF10A, 0x49D1, 0xF108, 0x49D2, 0xF106, 0x49D3, 0xF104, 0x49DF,
			0xF102, 0xE00C, 0x4801, 0x72E4, 0x49AD, 0xF108, 0xC225, 0x6741, 0x48F0,
			0x8F41, 0x4870, 0x8F41, 0xC7CF, 0x49B5, 0xF01F, 0x49B2, 0xF00B, 0x4980,
			0xF003, 0x484E, 0x94E7, 0x4981, 0xF004, 0x485E, 0xC212, 0x9543, 0xE071,
			0x49B6, 0xF003, 0x49B3, 0xF10F, 0x4980, 0xF003, 0x484E, 0x94E7, 0x4981,
			0xF004, 0x485E, 0xC204, 0x9543, 0xE005, 0xE000, 0xE0FC, 0xE0FA, 0xE065,
			0x49B7, 0xF007, 0x4980, 0xF005, 0x1A38, 0x46D4, 0x1200, 0xF109, 0x4981,
			0xF055, 0x49C3, 0xF105, 0x1A30, 0x46D5, 0x1200, 0xF04F, 0x7220, 0x49A2,
			0xF130, 0x49C1, 0xF12E, 0x49B0, 0xF12C, 0xC2E6, 0x7240, 0x49A8, 0xF003,
			0x49D0, 0xF126, 0x49A9, 0xF003, 0x49D1, 0xF122, 0x49AA, 0xF003, 0x49D2,
			0xF11E, 0x49AB, 0xF003, 0x49DF, 0xF11A, 0x49AC, 0xF003, 0x49D3, 0xF116,
			0x4980, 0xF003, 0x49C7, 0xF105, 0x4981, 0xF02C, 0x49D7, 0xF02A, 0x49C0,
			0xF00C, 0xC721, 0x62F4, 0x49A0, 0xF008, 0x49A4, 0xF106, 0x4824, 0x8AF4,
			0xC71A, 0x1A40, 0x9AE0, 0x49B6, 0xF017, 0x200E, 0xC7B8, 0x72E0, 0x4710,
			0x92E1, 0xC70E, 0x77E0, 0x49F0, 0xF112, 0xC70B, 0x77E0, 0x27FE, 0x1AFA,
			0x4317, 0xC705, 0x9AE2, 0x1A11, 0x8AE0, 0xE008, 0xE41C, 0xC0AE, 0xD23A,
			0xC7A2, 0x74E6, 0x484F, 0x94E7, 0xC79E, 0x8CE6, 0x8BEC, 0xC29C, 0x8D42,
			0x7220, 0xB000, 0xC502, 0xBD00, 0x0932, 0xB400, 0xC240, 0xC340, 0x7060,
			0x498F, 0xF014, 0x488F, 0x9061, 0x744C, 0x49C3, 0xF004, 0x7562, 0x485E,
			0x9563, 0x7446, 0x49C3, 0xF106, 0x7562, 0x1C30, 0x46E5, 0x1200, 0xF004,
			0x7446, 0x484F, 0x9447, 0xC32A, 0x7466, 0x49C0, 0xF00F, 0x48C0, 0x9C66,
			0x7446, 0x4840, 0x4841, 0x4842, 0x9C46, 0x744C, 0x4840, 0x9C4C, 0x744A,
			0x484A, 0x9C4A, 0xE013, 0x498E, 0xF011, 0x488E, 0x9061, 0x744C, 0x49C3,
			0xF004, 0x7446, 0x484E, 0x9447, 0x7446, 0x1D38, 0x46EC, 0x1500, 0xF004,
			0x7446, 0x484F, 0x9447, 0xB000, 0xC502, 0xBD00, 0x074C, 0xE000, 0xE0FC,
			0xE0C0, 0x4830, 0x4837, 0xC502, 0xBD00, 0x0978, 0x63E2, 0x4830, 0x4837,
			0xC502, 0xBD00, 0x09FE, 0x73E2, 0x4830, 0x8BE2, 0xC302, 0xBB00, 0x0A12,
			0x73E2, 0x48B0, 0x48B3, 0x48B4, 0x48B5, 0x48B6, 0x48B7, 0x8BE2, 0xC302,
			0xBB00, 0x0A5A, 0x73E2, 0x4830, 0x8BE2, 0xC302, 0xBB00, 0x0A6C, 0x73E2,
			0x4830, 0x4837, 0xC502, 0xBD00, 0x0A86
		};

		for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168fp_1_1); i++)
			rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168fp_1_1[i]);

		rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

		rtl_mac_ocp_write(hw, 0xFC28, 0x0890);
		rtl_mac_ocp_write(hw, 0xFC2A, 0x0712);
		rtl_mac_ocp_write(hw, 0xFC2C, 0x0974);
		rtl_mac_ocp_write(hw, 0xFC2E, 0x09FC);
		rtl_mac_ocp_write(hw, 0xFC30, 0x0A0E);
		rtl_mac_ocp_write(hw, 0xFC32, 0x0A56);
		rtl_mac_ocp_write(hw, 0xFC34, 0x0A68);
		rtl_mac_ocp_write(hw, 0xFC36, 0x0A84);

		/* Set bp enable*/
		if (hw->HwPkgDet == 0x00)
			rtl_mac_ocp_write(hw, 0xFC38, 0x00FC);
		else if (hw->HwPkgDet == 0x0F)
			rtl_mac_ocp_write(hw, 0xFC38, 0x00FF);
	} else if (hw->HwPkgDet == 0x05 || hw->HwPkgDet == 0x06) {
		static const u16 mcu_patch_code_8168fp_1_2[] = {
			0xE008, 0xE00A, 0xE031, 0xE033, 0xE035, 0xE144, 0xE166, 0xE168, 0xC502,
			0xBD00, 0x0000, 0xC725, 0x75E0, 0x48D0, 0x9DE0, 0xC722, 0x75E0, 0x1C78,
			0x416C, 0x1530, 0xF111, 0xC71D, 0x75F6, 0x49D1, 0xF00D, 0x75E0, 0x1C1F,
			0x416C, 0x1502, 0xF108, 0x75FA, 0x49D3, 0xF005, 0x75EC, 0x9DE4, 0x4853,
			0x9DFA, 0xC70B, 0x75E0, 0x4852, 0x4850, 0x9DE0, 0xC602, 0xBE00, 0x04B8,
			0xE420, 0xE000, 0xE0FC, 0xE43C, 0xDC00, 0xEB00, 0xC202, 0xBA00, 0x0000,
			0xC002, 0xB800, 0x0000, 0xB401, 0xB402, 0xB403, 0xB404, 0xB405, 0xB406,
			0xC44D, 0xC54D, 0x1867, 0xE8A2, 0x2318, 0x276E, 0x1601, 0xF106, 0x1A07,
			0xE861, 0xE86B, 0xE873, 0xE037, 0x231E, 0x276E, 0x1602, 0xF10B, 0x1A07,
			0xE858, 0xE862, 0xC247, 0xC344, 0xE8E3, 0xC73B, 0x66E0, 0xE8B5, 0xE029,
			0x231A, 0x276C, 0xC733, 0x9EE0, 0x1866, 0xE885, 0x251C, 0x120F, 0xF011,
			0x1209, 0xF011, 0x2014, 0x240E, 0x1000, 0xF007, 0x120C, 0xF00D, 0x1203,
			0xF00D, 0x1200, 0xF00D, 0x120C, 0xF00D, 0x1203, 0xF00D, 0x1A03, 0xE00C,
			0x1A07, 0xE00A, 0x1A00, 0xE008, 0x1A01, 0xE006, 0x1A02, 0xE004, 0x1A04,
			0xE002, 0x1A05, 0xE829, 0xE833, 0xB006, 0xB005, 0xB004, 0xB003, 0xB002,
			0xB001, 0x60C4, 0xC702, 0xBF00, 0x2786, 0xDD00, 0xD030, 0xE0C4, 0xE0F8,
			0xDC42, 0xD3F0, 0x0000, 0x0004, 0x0007, 0x0014, 0x0090, 0x1000, 0x0F00,
			0x1004, 0x1008, 0x3000, 0x3004, 0x3008, 0x4000, 0x7777, 0x8000, 0x8001,
			0x8008, 0x8003, 0x8004, 0xC000, 0xC004, 0xF004, 0xFFFF, 0xB406, 0xB407,
			0xC6E5, 0x77C0, 0x27F3, 0x23F3, 0x47FA, 0x9FC0, 0xB007, 0xB006, 0xFF80,
			0xB405, 0xB407, 0xC7D8, 0x75E0, 0x48D0, 0x9DE0, 0xB007, 0xB005, 0xFF80,
			0xB401, 0xC0EA, 0xC2DC, 0xC3D8, 0xE865, 0xC0D3, 0xC1E0, 0xC2E3, 0xE861,
			0xE817, 0xC0CD, 0xC2CF, 0xE85D, 0xC0C9, 0xC1D6, 0xC2DB, 0xE859, 0xE80F,
			0xC1C7, 0xC2CE, 0xE855, 0xC0C0, 0xC1D1, 0xC2D3, 0xE851, 0xE807, 0xC0BE,
			0xC2C2, 0xE84D, 0xE803, 0xB001, 0xFF80, 0xB402, 0xC2C6, 0xE859, 0x499F,
			0xF1FE, 0xB002, 0xFF80, 0xB402, 0xB403, 0xB407, 0xE821, 0x8882, 0x1980,
			0x8983, 0xE81D, 0x7180, 0x218B, 0x25BB, 0x1310, 0xF014, 0x1310, 0xFB03,
			0x1F20, 0x38FB, 0x3288, 0x434B, 0x2491, 0x430B, 0x1F0F, 0x38FB, 0x4313,
			0x2121, 0x4353, 0x2521, 0x418A, 0x6282, 0x2527, 0x212F, 0x418A, 0xB007,
			0xB003, 0xB002, 0xFF80, 0x6183, 0x2496, 0x1100, 0xF1FD, 0xFF80, 0x4800,
			0x4801, 0xC213, 0xC313, 0xE815, 0x4860, 0x8EE0, 0xC210, 0xC310, 0xE822,
			0x481E, 0xC20C, 0xC30C, 0xE80C, 0xC206, 0x7358, 0x483A, 0x9B58, 0xFF80,
			0xE8E0, 0xE000, 0x1008, 0x0F00, 0x800C, 0x0F00, 0xB407, 0xB406, 0xB403,
			0xC7F7, 0x98E0, 0x99E2, 0x9AE4, 0x21B2, 0x4831, 0x483F, 0x9BE6, 0x66E7,
			0x49E6, 0xF1FE, 0xB003, 0xB006, 0xB007, 0xFF80, 0xB407, 0xB406, 0xB403,
			0xC7E5, 0x9AE4, 0x21B2, 0x4831, 0x9BE6, 0x66E7, 0x49E6, 0xF1FE, 0x70E0,
			0x71E2, 0xB003, 0xB006, 0xB007, 0xFF80, 0x4882, 0xB406, 0xB405, 0xC71E,
			0x76E0, 0x1D78, 0x4175, 0x1630, 0xF10C, 0xC715, 0x76E0, 0x4861, 0x9EE0,
			0xC713, 0x1EFF, 0x9EE2, 0x75E0, 0x4850, 0x9DE0, 0xE005, 0xC70B, 0x76E0,
			0x4865, 0x9EE0, 0xB005, 0xB006, 0xC708, 0xC102, 0xB900, 0x279E, 0xEB16,
			0xEB00, 0xE43C, 0xDC00, 0xD3EC, 0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00,
			0x0000
		};

		for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168fp_1_2); i++)
			rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168fp_1_2[i]);

		rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

		rtl_mac_ocp_write(hw, 0xFC28, 0x0000);
		rtl_mac_ocp_write(hw, 0xFC2A, 0x04b4);
		rtl_mac_ocp_write(hw, 0xFC2C, 0x0000);
		rtl_mac_ocp_write(hw, 0xFC2E, 0x0000);
		rtl_mac_ocp_write(hw, 0xFC30, 0x0000);
		rtl_mac_ocp_write(hw, 0xFC32, 0x279C);
		rtl_mac_ocp_write(hw, 0xFC34, 0x0000);
		rtl_mac_ocp_write(hw, 0xFC36, 0x0000);

		/* Set bp enable*/
		rtl_mac_ocp_write(hw, 0xFC38, 0x0022);
	}
}

static void
rtl8168_set_mac_mcu_8168fp_8116as_2(struct rtl_hw *hw)
{
	u16 i;
	static const u16 mcu_patch_code_8168fp_8116as_2[] = {
		0xE008, 0xE00A, 0xE00F, 0xE014, 0xE016, 0xE018, 0xE01A, 0xE01C, 0xC602,
		0xBE00, 0x2AB2, 0x1BC0, 0x46EB, 0x1BFE, 0xC102, 0xB900, 0x0B1A, 0x1BC0,
		0x46EB, 0x1B7E, 0xC102, 0xB900, 0x0BEA, 0xC602, 0xBE00, 0x0000, 0xC602,
		0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000, 0xC602,
		0xBE00, 0x0000
	};

	rtl_hw_disable_mac_mcu_bps(hw);

	for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168fp_8116as_2); i++)
		rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168fp_8116as_2[i]);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x2AAC);
	rtl_mac_ocp_write(hw, 0xFC2A, 0x0B14);
	rtl_mac_ocp_write(hw, 0xFC2C, 0x0BE4);

	rtl_mac_ocp_write(hw, 0xFC38, 0x0007);
}

static void
_rtl8168_set_mac_mcu_8168fp_2(struct rtl_hw *hw)
{
	u16 i;
	static const u16 mcu_patch_code_8168fp_2[] = {
		0xE008, 0xE00A, 0xE00F, 0xE014, 0xE05F, 0xE064, 0xE066, 0xE068, 0xC602,
		0xBE00, 0x0000, 0x1BC0, 0x46EB, 0x1BFE, 0xC102, 0xB900, 0x0B1A, 0x1BC0,
		0x46EB, 0x1B7E, 0xC102, 0xB900, 0x0BEA, 0xB400, 0xB401, 0xB402, 0xB403,
		0xB404, 0xB405, 0xC03A, 0x7206, 0x49AE, 0xF1FE, 0xC137, 0x9904, 0xC136,
		0x9906, 0x7206, 0x49AE, 0xF1FE, 0x7200, 0x49A0, 0xF10B, 0xC52F, 0xC12E,
		0xC232, 0xC332, 0xE812, 0xC331, 0xE810, 0xC330, 0xE80E, 0xE018, 0xC126,
		0xC229, 0xC525, 0xC328, 0xE808, 0xC523, 0xC326, 0xE805, 0xC521, 0xC324,
		0xE802, 0xE00C, 0x740E, 0x49CE, 0xF1FE, 0x9908, 0x9D0A, 0x9A0C, 0x9B0E,
		0x740E, 0x49CE, 0xF1FE, 0xFF80, 0xB005, 0xB004, 0xB003, 0xB002, 0xB001,
		0xB000, 0xC604, 0xC002, 0xB800, 0x2A5E, 0xE000, 0xE8E0, 0xF128, 0x3DC2,
		0xFFFF, 0x10EC, 0x816A, 0x816D, 0x816C, 0xF000, 0x8002, 0x8004, 0x8007,
		0x48C1, 0x48C2, 0x9C46, 0xC402, 0xBC00, 0x07BC, 0xC602, 0xBE00, 0x0000,
		0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000
	};

	rtl_hw_disable_mac_mcu_bps(hw);

	for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168fp_2); i++)
		rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168fp_2[i]);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x2AAC);
	rtl_mac_ocp_write(hw, 0xFC2A, 0x0B14);
	rtl_mac_ocp_write(hw, 0xFC2C, 0x0BE4);
	rtl_mac_ocp_write(hw, 0xFC2E, 0x2A5C);

	if (rtl8168_check_dash_other_fun_present(hw))
		rtl_mac_ocp_write(hw, 0xFC38, 0x0006);
	else
		rtl_mac_ocp_write(hw, 0xFC38, 0x000E);
}

static void
rtl8168_set_mac_mcu_8168fp_2(struct rtl_hw *hw)
{
	if (hw->HwSuppSerDesPhyVer == 1)
		rtl8168_set_mac_mcu_8168fp_8116as_2(hw);
	else
		_rtl8168_set_mac_mcu_8168fp_2(hw);
}

static void
rtl8168_set_mac_mcu_8168fp_3(struct rtl_hw *hw)
{
	u16 i;
	static const u16 mcu_patch_code_8168fp_3[] = {
		0xE008, 0xE053, 0xE058, 0xE05A, 0xE05C, 0xE05E, 0xE060, 0xE062, 0xB400,
		0xB401, 0xB402, 0xB403, 0xB404, 0xB405, 0xC03A, 0x7206, 0x49AE, 0xF1FE,
		0xC137, 0x9904, 0xC136, 0x9906, 0x7206, 0x49AE, 0xF1FE, 0x7200, 0x49A0,
		0xF10B, 0xC52F, 0xC12E, 0xC232, 0xC332, 0xE812, 0xC331, 0xE810, 0xC330,
		0xE80E, 0xE018, 0xC126, 0xC229, 0xC525, 0xC328, 0xE808, 0xC523, 0xC326,
		0xE805, 0xC521, 0xC324, 0xE802, 0xE00C, 0x740E, 0x49CE, 0xF1FE, 0x9908,
		0x9D0A, 0x9A0C, 0x9B0E, 0x740E, 0x49CE, 0xF1FE, 0xFF80, 0xB005, 0xB004,
		0xB003, 0xB002, 0xB001, 0xB000, 0xC604, 0xC002, 0xB800, 0x2B16, 0xE000,
		0xE8E0, 0xF128, 0x3DC2, 0xFFFF, 0x10EC, 0x816A, 0x816D, 0x816C, 0xF000,
		0x8002, 0x8004, 0x8007, 0x48C1, 0x48C2, 0x9C46, 0xC402, 0xBC00, 0x07BC,
		0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000,
		0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000, 0xC602, 0xBE00, 0x0000
	};

	rtl_hw_disable_mac_mcu_bps(hw);

	for (i = 0; i < ARRAY_SIZE(mcu_patch_code_8168fp_3); i++)
		rtl_mac_ocp_write(hw, 0xF800 + i * 2, mcu_patch_code_8168fp_3[i]);

	rtl_mac_ocp_write(hw, 0xFC26, 0x8000);

	rtl_mac_ocp_write(hw, 0xFC28, 0x2B14);

	if (rtl8168_check_dash_other_fun_present(hw))
		rtl_mac_ocp_write(hw, 0xFC38, 0x0000);
	else
		rtl_mac_ocp_write(hw, 0xFC38, 0x0001);
}

/* ------------------------------------PHY 8168FP------------------------------------- */

void
hw_mac_mcu_config_8168fp(struct rtl_hw *hw)
{
	if (hw->NotWrMcuPatchCode)
		return;

	switch (hw->mcfg) {
	case CFG_METHOD_31:
		rtl8168_set_mac_mcu_8168fp_1(hw);
		break;
	case CFG_METHOD_32:
		rtl8168_set_mac_mcu_8168fp_2(hw);
		break;
	case CFG_METHOD_33:
	case CFG_METHOD_34:
		rtl8168_set_mac_mcu_8168fp_3(hw);
		break;
	}
}
