---
name: Bug Report
about: Report a problem with HAProxy to help us resolve it.
labels: 'type: bug, status: needs-triage'
---

<!--

Welcome! - We kindly ask that you:

  1. Fill out the issue template below - not doing so needs a good reason.
  2. Use the forum or the mailing list if you have a question rather than a bug or feature request.

The forum is at: https://discourse.haproxy.org/

The mailing list (no need to subscribe) is: haproxy@formilux.org
Subscribe to the list: haproxy+subscribe@formilux.org
Unsubscribe from the list: haproxy+unsubscribe@formilux.org

Forum and mailing list are correct places for questions about HAProxy or general suggestions
and topics, e.g. usage or documentation questions! This issue tracker is for tracking bugs and
feature requests directly relating to the development of the software itself.

Thanks for understanding, and for contributing to the project!

-->


## Detailed description of the problem

<!--
In this section, please try to concentrate on observations. Only describe what you
observed directly.
-->

## Expected behavior

<!--
Explain why you consider the described behavior (above) to be wrong. What did you expect instead?

Most likely this is a mismatch between HAProxy's documentation and HAProxy's behavior.
-->

## Steps to reproduce the behavior

<!--
The more time you spend describing an easy way to reproduce the behavior (if
this is possible), the easier it is for the project developers to fix it!
-->

1. 
2. 
3. 

## Do you have any idea what may have caused this?

## Do you have an idea how to solve the issue?

## What is your configuration?

<!--
Include as much configuration as possible, including global and default sections.
Replace confidential data like domain names and IP addresses.

Put it in code blocks ```:
-->

```
(paste your output here)
```

## Output of `haproxy -vv` and `uname -a`

<!-- Put it in code blocks ```: -->

```
(paste your output here)
```

## If HAProxy crashed: Last outputs and backtraces

<!--
If HAProxy crashed then please provide:

  1. The last output from your HAProxy logs (e.g. from journalctl or syslog).
  2. A backtrace from a coredump (`t a a bt full`).

Put all results in code blocks ```:
-->

```
(paste your output here)
```

## Additional information (if helpful)

<!--
Any additional information about your environment that may be useful to know about. For example:
  - Any local patches applied.
  - Environment specificities
  - Unusual workload
  - Interesting observations or coindidences with events on other components
-->
