// SPDX-License-Identifier: GPL-2.0-or-later
/*

  Broadcom B43 wireless driver
  IEEE 802.11n 2059 radio device data tables

  Copyright (c) 2011 Rafał Miłecki <zajec5@gmail.com>


*/

#include "b43.h"
#include "radio_2059.h"

/* Extracted from MMIO dump of 6.30.223.141 */
static u16 r2059_phy_rev1_init[][2] = {
	{ 0x051, 0x70 }, { 0x05a, 0x03 }, { 0x079, 0x01 }, { 0x082, 0x70 },
	{ 0x083, 0x00 }, { 0x084, 0x70 }, { 0x09a, 0x7f }, { 0x0b6, 0x10 },
	{ 0x188, 0x05 },
};

#define RADIOREGS(r00, r01, r02, r03, r04, r05, r06, r07, r08, r09, \
		  r10, r11, r12, r13, r14, r15, r16, r17, r18, r19, \
		  r20) \
	.radio_syn16			= r00,	\
	.radio_syn17			= r01,	\
	.radio_syn22			= r02,	\
	.radio_syn25			= r03,	\
	.radio_syn27			= r04,	\
	.radio_syn28			= r05,	\
	.radio_syn29			= r06,	\
	.radio_syn2c			= r07,	\
	.radio_syn2d			= r08,	\
	.radio_syn37			= r09,	\
	.radio_syn41			= r10,	\
	.radio_syn43			= r11,	\
	.radio_syn47			= r12,	\
	.radio_rxtx4a			= r13,	\
	.radio_rxtx58			= r14,	\
	.radio_rxtx5a			= r15,	\
	.radio_rxtx6a			= r16,	\
	.radio_rxtx6d			= r17,	\
	.radio_rxtx6e			= r18,	\
	.radio_rxtx92			= r19,	\
	.radio_rxtx98			= r20

#define PHYREGS(r0, r1, r2, r3, r4, r5)	\
	.phy_regs.bw1	= r0,	\
	.phy_regs.bw2	= r1,	\
	.phy_regs.bw3	= r2,	\
	.phy_regs.bw4	= r3,	\
	.phy_regs.bw5	= r4,	\
	.phy_regs.bw6	= r5

/* Extracted from MMIO dump of 6.30.223.141
 * TODO: Values for channels 12 & 13 are outdated (from some old 5.x driver)!
 */
static const struct b43_phy_ht_channeltab_e_radio2059 b43_phy_ht_channeltab_radio2059[] = {
	{
		.freq			= 2412,
		RADIOREGS(0x48, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x6c,
			  0x09, 0x0f, 0x0a, 0x00, 0x0a, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0xd0, 0x00),
		PHYREGS(0x03c9, 0x03c5, 0x03c1, 0x043a, 0x043f, 0x0443),
	},
	{
		.freq			= 2417,
		RADIOREGS(0x4b, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x71,
			  0x09, 0x0f, 0x0a, 0x00, 0x0a, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0xd0, 0x00),
		PHYREGS(0x03cb, 0x03c7, 0x03c3, 0x0438, 0x043d, 0x0441),
	},
	{
		.freq			= 2422,
		RADIOREGS(0x4e, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x76,
			  0x09, 0x0f, 0x09, 0x00, 0x09, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0xd0, 0x00),
		PHYREGS(0x03cd, 0x03c9, 0x03c5, 0x0436, 0x043a, 0x043f),
	},
	{
		.freq			= 2427,
		RADIOREGS(0x52, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x7b,
			  0x09, 0x0f, 0x09, 0x00, 0x09, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0xa0, 0x00),
		PHYREGS(0x03cf, 0x03cb, 0x03c7, 0x0434, 0x0438, 0x043d),
	},
	{
		.freq			= 2432,
		RADIOREGS(0x55, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x80,
			  0x09, 0x0f, 0x08, 0x00, 0x08, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0xa0, 0x00),
		PHYREGS(0x03d1, 0x03cd, 0x03c9, 0x0431, 0x0436, 0x043a),
	},
	{
		.freq			= 2437,
		RADIOREGS(0x58, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x85,
			  0x09, 0x0f, 0x08, 0x00, 0x08, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0xa0, 0x00),
		PHYREGS(0x03d3, 0x03cf, 0x03cb, 0x042f, 0x0434, 0x0438),
	},
	{
		.freq			= 2442,
		RADIOREGS(0x5c, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x8a,
			  0x09, 0x0f, 0x07, 0x00, 0x07, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0x80, 0x00),
		PHYREGS(0x03d5, 0x03d1, 0x03cd, 0x042d, 0x0431, 0x0436),
	},
	{
		.freq			= 2447,
		RADIOREGS(0x5f, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x8f,
			  0x09, 0x0f, 0x07, 0x00, 0x07, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0x80, 0x00),
		PHYREGS(0x03d7, 0x03d3, 0x03cf, 0x042b, 0x042f, 0x0434),
	},
	{
		.freq			= 2452,
		RADIOREGS(0x62, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x94,
			  0x09, 0x0f, 0x07, 0x00, 0x07, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0x80, 0x00),
		PHYREGS(0x03d9, 0x03d5, 0x03d1, 0x0429, 0x042d, 0x0431),
	},
	{
		.freq			= 2457,
		RADIOREGS(0x66, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x99,
			  0x09, 0x0f, 0x06, 0x00, 0x06, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0x60, 0x00),
		PHYREGS(0x03db, 0x03d7, 0x03d3, 0x0427, 0x042b, 0x042f),
	},
	{
		.freq			= 2462,
		RADIOREGS(0x69, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0x9e,
			  0x09, 0x0f, 0x06, 0x00, 0x06, 0x00, 0x61, 0x73,
			  0x00, 0x00, 0x00, 0x60, 0x00),
		PHYREGS(0x03dd, 0x03d9, 0x03d5, 0x0424, 0x0429, 0x042d),
	},
  {	.freq			= 2467,
	RADIOREGS(0x6c, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0xa3,
		  0x09, 0x0f, 0x05, 0x00, 0x05, 0x00, 0x61, 0x03,
		  0x00, 0x00, 0x00, 0xf0, 0x00),
	PHYREGS(0x03df, 0x03db, 0x03d7, 0x0422, 0x0427, 0x042b),
  },
  {	.freq			= 2472,
	RADIOREGS(0x70, 0x16, 0x30, 0x1b, 0x0a, 0x0a, 0x30, 0xa8,
		  0x09, 0x0f, 0x05, 0x00, 0x05, 0x00, 0x61, 0x03,
		  0x00, 0x00, 0x00, 0xf0, 0x00),
	PHYREGS(0x03e1, 0x03dd, 0x03d9, 0x0420, 0x0424, 0x0429),
  },
	{
		.freq			= 5180,
		RADIOREGS(0xbe, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x06,
			  0x02, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00,
			  0x0f, 0x4f, 0xa3, 0x00, 0xfc),
		PHYREGS(0x081c, 0x0818, 0x0814, 0x01f9, 0x01fa, 0x01fb),
	},
	{
		.freq			= 5200,
		RADIOREGS(0xc5, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x08,
			  0x02, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00,
			  0x0f, 0x4f, 0x93, 0x00, 0xfb),
		PHYREGS(0x0824, 0x0820, 0x081c, 0x01f7, 0x01f8, 0x01f9),
	},
	{
		.freq			= 5220,
		RADIOREGS(0xcc, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x0a,
			  0x02, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00,
			  0x0f, 0x4f, 0x93, 0x00, 0xea),
		PHYREGS(0x082c, 0x0828, 0x0824, 0x01f5, 0x01f6, 0x01f7),
	},
	{
		.freq			= 5240,
		RADIOREGS(0xd2, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x0c,
			  0x02, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00,
			  0x0f, 0x4f, 0x93, 0x00, 0xda),
		PHYREGS(0x0834, 0x0830, 0x082c, 0x01f3, 0x01f4, 0x01f5),
	},
	{
		.freq			= 5260,
		RADIOREGS(0xd9, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x0e,
			  0x02, 0x0b, 0x00, 0x0b, 0x00, 0x0b, 0x00, 0x00,
			  0x0f, 0x4f, 0x93, 0x00, 0xca),
		PHYREGS(0x083c, 0x0838, 0x0834, 0x01f1, 0x01f2, 0x01f3),
	},
	{
		.freq			= 5280,
		RADIOREGS(0xe0, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x10,
			  0x02, 0x0b, 0x00, 0x0b, 0x00, 0x0b, 0x00, 0x00,
			  0x0f, 0x4f, 0x93, 0x00, 0xb9),
		PHYREGS(0x0844, 0x0840, 0x083c, 0x01f0, 0x01f0, 0x01f1),
	},
	{
		.freq			= 5300,
		RADIOREGS(0xe6, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x12,
			  0x02, 0x0b, 0x00, 0x0b, 0x00, 0x0b, 0x00, 0x00,
			  0x0f, 0x4c, 0x83, 0x00, 0xb8),
		PHYREGS(0x084c, 0x0848, 0x0844, 0x01ee, 0x01ef, 0x01f0),
	},
	{
		.freq			= 5320,
		RADIOREGS(0xed, 0x16, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x14,
			  0x02, 0x0b, 0x00, 0x0b, 0x00, 0x0b, 0x00, 0x00,
			  0x0f, 0x4c, 0x83, 0x00, 0xa8),
		PHYREGS(0x0854, 0x0850, 0x084c, 0x01ec, 0x01ed, 0x01ee),
	},
	{
		.freq			= 5500,
		RADIOREGS(0x29, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x26,
			  0x02, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x00,
			  0x0a, 0x46, 0x43, 0x00, 0x75),
		PHYREGS(0x089c, 0x0898, 0x0894, 0x01dc, 0x01dd, 0x01dd),
	},
	{
		.freq			= 5520,
		RADIOREGS(0x30, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x28,
			  0x02, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
			  0x0a, 0x46, 0x43, 0x00, 0x75),
		PHYREGS(0x08a4, 0x08a0, 0x089c, 0x01da, 0x01db, 0x01dc),
	},
	{
		.freq			= 5540,
		RADIOREGS(0x36, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x2a,
			  0x02, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
			  0x0a, 0x46, 0x43, 0x00, 0x75),
		PHYREGS(0x08ac, 0x08a8, 0x08a4, 0x01d8, 0x01d9, 0x01da),
	},
	{
		.freq			= 5560,
		RADIOREGS(0x3d, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x2c,
			  0x02, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
			  0x0a, 0x46, 0x43, 0x00, 0x75),
		PHYREGS(0x08b4, 0x08b0, 0x08ac, 0x01d7, 0x01d7, 0x01d8),
	},
	{
		.freq			= 5580,
		RADIOREGS(0x44, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x2e,
			  0x02, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
			  0x0a, 0x46, 0x43, 0x00, 0x74),
		PHYREGS(0x08bc, 0x08b8, 0x08b4, 0x01d5, 0x01d6, 0x01d7),
	},
	{
		.freq			= 5600,
		RADIOREGS(0x4a, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x30,
			  0x02, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
			  0x09, 0x44, 0x23, 0x00, 0x54),
		PHYREGS(0x08c4, 0x08c0, 0x08bc, 0x01d3, 0x01d4, 0x01d5),
	},
	{
		.freq			= 5620,
		RADIOREGS(0x51, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x32,
			  0x02, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
			  0x09, 0x44, 0x23, 0x00, 0x54),
		PHYREGS(0x08cc, 0x08c8, 0x08c4, 0x01d2, 0x01d2, 0x01d3),
	},
	{
		.freq			= 5640,
		RADIOREGS(0x58, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x34,
			  0x02, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
			  0x09, 0x44, 0x23, 0x00, 0x43),
		PHYREGS(0x08d4, 0x08d0, 0x08cc, 0x01d0, 0x01d1, 0x01d2),
	},
	{
		.freq			= 5660,
		RADIOREGS(0x5e, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x36,
			  0x02, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
			  0x09, 0x43, 0x23, 0x00, 0x43),
		PHYREGS(0x08dc, 0x08d8, 0x08d4, 0x01ce, 0x01cf, 0x01d0),
	},
	{
		.freq			= 5680,
		RADIOREGS(0x65, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x38,
			  0x02, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
			  0x09, 0x42, 0x23, 0x00, 0x43),
		PHYREGS(0x08e4, 0x08e0, 0x08dc, 0x01cd, 0x01ce, 0x01ce),
	},
	{
		.freq			= 5700,
		RADIOREGS(0x6c, 0x17, 0x10, 0x1f, 0x08, 0x08, 0x3f, 0x3a,
			  0x02, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
			  0x08, 0x42, 0x13, 0x00, 0x32),
		PHYREGS(0x08ec, 0x08e8, 0x08e4, 0x01cb, 0x01cc, 0x01cd),
	},
	{
		.freq			= 5745,
		RADIOREGS(0x7b, 0x17, 0x20, 0x1f, 0x08, 0x08, 0x3f, 0x7d,
			  0x04, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x00,
			  0x08, 0x42, 0x13, 0x00, 0x21),
		PHYREGS(0x08fe, 0x08fa, 0x08f6, 0x01c8, 0x01c8, 0x01c9),
	},
	{
		.freq			= 5765,
		RADIOREGS(0x81, 0x17, 0x20, 0x1f, 0x08, 0x08, 0x3f, 0x81,
			  0x04, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x00,
			  0x08, 0x42, 0x13, 0x00, 0x11),
		PHYREGS(0x0906, 0x0902, 0x08fe, 0x01c6, 0x01c7, 0x01c8),
	},
	{
		.freq			= 5785,
		RADIOREGS(0x88, 0x17, 0x20, 0x1f, 0x08, 0x08, 0x3f, 0x85,
			  0x04, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x00,
			  0x08, 0x42, 0x13, 0x00, 0x00),
		PHYREGS(0x090e, 0x090a, 0x0906, 0x01c4, 0x01c5, 0x01c6),
	},
	{
		.freq			= 5805,
		RADIOREGS(0x8f, 0x17, 0x20, 0x1f, 0x08, 0x08, 0x3f, 0x89,
			  0x04, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x00,
			  0x06, 0x41, 0x03, 0x00, 0x00),
		PHYREGS(0x0916, 0x0912, 0x090e, 0x01c3, 0x01c4, 0x01c4),
	},
	{
		.freq			= 5825,
		RADIOREGS(0x95, 0x17, 0x20, 0x1f, 0x08, 0x08, 0x3f, 0x8d,
			  0x04, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x00,
			  0x06, 0x41, 0x03, 0x00, 0x00),
		PHYREGS(0x091e, 0x091a, 0x0916, 0x01c1, 0x01c2, 0x01c3),
	},
};

void r2059_upload_inittabs(struct b43_wldev *dev)
{
	struct b43_phy *phy = &dev->phy;
	u16 *table = NULL;
	u16 size, i;

	switch (phy->rev) {
	case 1:
		table = r2059_phy_rev1_init[0];
		size = ARRAY_SIZE(r2059_phy_rev1_init);
		break;
	default:
		B43_WARN_ON(1);
		return;
	}

	for (i = 0; i < size; i++, table += 2)
		b43_radio_write(dev, R2059_ALL | table[0], table[1]);
}

const struct b43_phy_ht_channeltab_e_radio2059
*b43_phy_ht_get_channeltab_e_r2059(struct b43_wldev *dev, u16 freq)
{
	const struct b43_phy_ht_channeltab_e_radio2059 *e;
	unsigned int i;

	e = b43_phy_ht_channeltab_radio2059;
	for (i = 0; i < ARRAY_SIZE(b43_phy_ht_channeltab_radio2059); i++, e++) {
		if (e->freq == freq)
			return e;
	}

	return NULL;
}
