; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare void @use(i32)

define i32 @sub_to_and(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 0, [[TMP1]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %x, %y
  %xor = xor i32 %x, %y
  %sub = sub i32 %xor, %or
  ret i32 %sub
}

define i32 @sub_to_and_extra_use_sub(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and_extra_use_sub(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 0, [[TMP1]]
; CHECK-NEXT:    call void @use(i32 [[SUB]])
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %x, %y
  %xor = xor i32 %x, %y
  %sub = sub i32 %xor, %or
  call void @use(i32 %sub)
  ret i32 %sub
}

define i32 @sub_to_and_extra_use_and(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and_extra_use_and(
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @use(i32 [[XOR]])
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X]], [[Y]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 0, [[TMP1]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %x, %y
  %xor = xor i32 %x, %y
  call void @use(i32 %xor)
  %sub = sub i32 %xor, %or
  ret i32 %sub
}

define i32 @sub_to_and_extra_use_or(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and_extra_use_or(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @use(i32 [[OR]])
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X]], [[Y]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 0, [[TMP1]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %x, %y
  call void @use(i32 %or)
  %xor = xor i32 %x, %y
  %sub = sub i32 %xor, %or
  ret i32 %sub
}

define i32 @sub_to_and_or_commuted(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and_or_commuted(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 0, [[TMP1]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %y, %x
  %xor = xor i32 %x, %y
  %sub = sub i32 %xor, %or
  ret i32 %sub
}

define i32 @sub_to_and_and_commuted(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and_and_commuted(
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 0, [[TMP1]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %x, %y
  %xor = xor i32 %y, %x
  %sub = sub i32 %xor, %or
  ret i32 %sub
}

define <2 x i32> @sub_to_and_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @sub_to_and_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[SUB:%.*]] = sub <2 x i32> zeroinitializer, [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SUB]]
;
  %or = or <2 x i32> %x, %y
  %xor = xor <2 x i32> %y, %x
  %sub = sub <2 x i32> %xor, %or
  ret <2 x i32> %sub
}

; Negative tests

define i32 @sub_to_and_extra_use_and_or(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_to_and_extra_use_and_or(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @use(i32 [[OR]])
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[X]], [[Y]]
; CHECK-NEXT:    call void @use(i32 [[XOR]])
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[XOR]], [[OR]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %or = or i32 %x, %y
  call void @use(i32 %or)
  %xor = xor i32 %x, %y
  call void @use(i32 %xor)
  %sub = sub i32 %xor, %or
  ret i32 %sub
}
