; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -arm-parallel-dsp -dce -mtriple=armv7-a -S %s -o - | FileCheck %s

define i32 @single_block(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @single_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP3]], i32 [[ACC:%.*]])
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  %res = add i32 %add, %acc
  ret i32 %res
}

define i64 @single_block_64(ptr %a, ptr %b, i64 %acc) {
; CHECK-LABEL: @single_block_64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP1]], i32 [[TMP3]], i64 [[ACC:%.*]])
; CHECK-NEXT:    ret i64 [[TMP4]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %sext.mul.0 = sext i32 %mul.0 to i64
  %sext.mul.1 = sext i32 %mul.1 to i64
  %add = add i64 %sext.mul.0, %sext.mul.1
  %res = add i64 %add, %acc
  ret i64 %res
}

define i32 @multi_block(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @multi_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP3]], i32 0)
; CHECK-NEXT:    br label [[BB_1:%.*]]
; CHECK:       bb.1:
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[TMP4]], [[ACC:%.*]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  br label %bb.1

bb.1:
  %res = add i32 %add, %acc
  ret i32 %res
}

define i64 @multi_block_64(ptr %a, ptr %b, i64 %acc) {
; CHECK-LABEL: @multi_block_64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[TMP4:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP1]], i32 [[TMP3]], i64 0)
; CHECK-NEXT:    br label [[BB_1:%.*]]
; CHECK:       bb.1:
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[TMP4]], [[ACC:%.*]]
; CHECK-NEXT:    ret i64 [[RES]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %sext.mul.0 = sext i32 %mul.0 to i64
  %sext.mul.1 = sext i32 %mul.1 to i64
  %add = add i64 %sext.mul.0, %sext.mul.1
  br label %bb.1

bb.1:
  %res = add i64 %add, %acc
  ret i64 %res
}

define i32 @multi_block_1(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @multi_block_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[SEXT_A_0]], [[SEXT_B_0]]
; CHECK-NEXT:    br label [[BB_1:%.*]]
; CHECK:       bb.1:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B]], i32 1
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[SEXT_A_1]], [[SEXT_B_1]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC:%.*]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  br label %bb.1

bb.1:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  %res = add i32 %add, %acc
  ret i32 %res
}

; TODO: Four smlads should be generated here, but mul.0 and mul.3 remain as
; scalars.
define i32 @num_load_limit(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @num_load_limit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP10]]
; CHECK-NEXT:    [[ADDR_B_3:%.*]] = getelementptr i16, ptr [[B]], i32 3
; CHECK-NEXT:    [[LD_B_3:%.*]] = load i16, ptr [[ADDR_B_3]], align 2
; CHECK-NEXT:    [[SEXT_B_3:%.*]] = sext i16 [[LD_B_3]] to i32
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP6]], [[SEXT_B_3]]
; CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[MUL_3]], [[ACC:%.*]]
; CHECK-NEXT:    [[TMP12:%.*]] = add i32 [[MUL_0]], [[TMP11]]
; CHECK-NEXT:    [[TMP13:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 [[TMP12]])
; CHECK-NEXT:    [[ADDR_A_4:%.*]] = getelementptr i16, ptr [[A]], i32 4
; CHECK-NEXT:    [[ADDR_B_4:%.*]] = getelementptr i16, ptr [[B]], i32 4
; CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ADDR_A_4]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[ADDR_B_4]], align 2
; CHECK-NEXT:    [[TMP18:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP15]], i32 [[TMP17]], i32 [[TMP13]])
; CHECK-NEXT:    [[ADDR_A_6:%.*]] = getelementptr i16, ptr [[A]], i32 6
; CHECK-NEXT:    [[ADDR_B_6:%.*]] = getelementptr i16, ptr [[B]], i32 6
; CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[ADDR_A_6]], align 2
; CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[ADDR_B_6]], align 2
; CHECK-NEXT:    [[TMP23:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP20]], i32 [[TMP22]], i32 [[TMP18]])
; CHECK-NEXT:    ret i32 [[TMP23]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add.0 = add i32 %mul.0, %mul.1

  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %ld.a.2 = load i16, ptr %addr.a.2
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %ld.b.2 = load i16, ptr %addr.b.2
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %mul.2 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %addr.b.3 = getelementptr i16, ptr %b, i32 3
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %ld.b.3 = load i16, ptr %addr.b.3
  %sext.b.3 = sext i16 %ld.b.3 to i32
  %mul.3 = mul i32 %sext.a.1, %sext.b.3
  %add.3 = add i32 %mul.2, %mul.3

  %addr.a.4 = getelementptr i16, ptr %a, i32 4
  %addr.b.4 = getelementptr i16, ptr %b, i32 4
  %ld.a.4 = load i16, ptr %addr.a.4
  %sext.a.4 = sext i16 %ld.a.4 to i32
  %ld.b.4 = load i16, ptr %addr.b.4
  %sext.b.4 = sext i16 %ld.b.4 to i32
  %mul.4 = mul i32 %sext.a.4, %sext.b.4
  %addr.a.5 = getelementptr i16, ptr %a, i32 5
  %addr.b.5 = getelementptr i16, ptr %b, i32 5
  %ld.a.5 = load i16, ptr %addr.a.5
  %sext.a.5 = sext i16 %ld.a.5 to i32
  %ld.b.5 = load i16, ptr %addr.b.5
  %sext.b.5 = sext i16 %ld.b.5 to i32
  %mul.5 = mul i32 %sext.a.5, %sext.b.5
  %add.5 = add i32 %mul.4, %mul.5

  %addr.a.6 = getelementptr i16, ptr %a, i32 6
  %addr.b.6 = getelementptr i16, ptr %b, i32 6
  %ld.a.6 = load i16, ptr %addr.a.6
  %sext.a.6 = sext i16 %ld.a.6 to i32
  %ld.b.6 = load i16, ptr %addr.b.6
  %sext.b.6 = sext i16 %ld.b.6 to i32
  %mul.6 = mul i32 %sext.a.6, %sext.b.6
  %addr.a.7 = getelementptr i16, ptr %a, i32 7
  %addr.b.7 = getelementptr i16, ptr %b, i32 7
  %ld.a.7 = load i16, ptr %addr.a.7
  %sext.a.7 = sext i16 %ld.a.7 to i32
  %ld.b.7 = load i16, ptr %addr.b.7
  %sext.b.7 = sext i16 %ld.b.7 to i32
  %mul.7 = mul i32 %sext.a.7, %sext.b.7
  %add.7 = add i32 %mul.6, %mul.7

  %add.10 = add i32 %add.7, %add.5
  %add.11 = add i32 %add.3, %add.0
  %add.12 = add i32 %add.10, %add.11
  %res = add i32 %add.12, %acc
  ret i32 %res
}

define i32 @too_many_loads(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @too_many_loads(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A:%.*]], align 2
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B:%.*]], align 2
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[SEXT_A_0]], [[SEXT_B_0]]
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B]], i32 1
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[SEXT_A_1]], [[SEXT_B_1]]
; CHECK-NEXT:    [[ADD_0:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[SEXT_A_0]], [[SEXT_B_0]]
; CHECK-NEXT:    [[ADDR_B_3:%.*]] = getelementptr i16, ptr [[B]], i32 3
; CHECK-NEXT:    [[LD_B_3:%.*]] = load i16, ptr [[ADDR_B_3]], align 2
; CHECK-NEXT:    [[SEXT_B_3:%.*]] = sext i16 [[LD_B_3]] to i32
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[SEXT_A_1]], [[SEXT_B_3]]
; CHECK-NEXT:    [[ADD_3:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADDR_A_4:%.*]] = getelementptr i16, ptr [[A]], i32 4
; CHECK-NEXT:    [[ADDR_B_4:%.*]] = getelementptr i16, ptr [[B]], i32 4
; CHECK-NEXT:    [[LD_A_4:%.*]] = load i16, ptr [[ADDR_A_4]], align 2
; CHECK-NEXT:    [[SEXT_A_4:%.*]] = sext i16 [[LD_A_4]] to i32
; CHECK-NEXT:    [[LD_B_4:%.*]] = load i16, ptr [[ADDR_B_4]], align 2
; CHECK-NEXT:    [[SEXT_B_4:%.*]] = sext i16 [[LD_B_4]] to i32
; CHECK-NEXT:    [[MUL_4:%.*]] = mul i32 [[SEXT_A_4]], [[SEXT_B_4]]
; CHECK-NEXT:    [[ADDR_A_5:%.*]] = getelementptr i16, ptr [[A]], i32 5
; CHECK-NEXT:    [[ADDR_B_5:%.*]] = getelementptr i16, ptr [[B]], i32 5
; CHECK-NEXT:    [[LD_A_5:%.*]] = load i16, ptr [[ADDR_A_5]], align 2
; CHECK-NEXT:    [[SEXT_A_5:%.*]] = sext i16 [[LD_A_5]] to i32
; CHECK-NEXT:    [[LD_B_5:%.*]] = load i16, ptr [[ADDR_B_5]], align 2
; CHECK-NEXT:    [[SEXT_B_5:%.*]] = sext i16 [[LD_B_5]] to i32
; CHECK-NEXT:    [[MUL_5:%.*]] = mul i32 [[SEXT_A_5]], [[SEXT_B_5]]
; CHECK-NEXT:    [[ADD_5:%.*]] = add i32 [[MUL_4]], [[MUL_5]]
; CHECK-NEXT:    [[ADDR_A_6:%.*]] = getelementptr i16, ptr [[A]], i32 6
; CHECK-NEXT:    [[ADDR_B_6:%.*]] = getelementptr i16, ptr [[B]], i32 6
; CHECK-NEXT:    [[LD_A_6:%.*]] = load i16, ptr [[ADDR_A_6]], align 2
; CHECK-NEXT:    [[SEXT_A_6:%.*]] = sext i16 [[LD_A_6]] to i32
; CHECK-NEXT:    [[LD_B_6:%.*]] = load i16, ptr [[ADDR_B_6]], align 2
; CHECK-NEXT:    [[SEXT_B_6:%.*]] = sext i16 [[LD_B_6]] to i32
; CHECK-NEXT:    [[MUL_6:%.*]] = mul i32 [[SEXT_A_6]], [[SEXT_B_6]]
; CHECK-NEXT:    [[ADDR_A_7:%.*]] = getelementptr i16, ptr [[A]], i32 7
; CHECK-NEXT:    [[ADDR_B_7:%.*]] = getelementptr i16, ptr [[B]], i32 7
; CHECK-NEXT:    [[LD_A_7:%.*]] = load i16, ptr [[ADDR_A_7]], align 2
; CHECK-NEXT:    [[SEXT_A_7:%.*]] = sext i16 [[LD_A_7]] to i32
; CHECK-NEXT:    [[LD_B_7:%.*]] = load i16, ptr [[ADDR_B_7]], align 2
; CHECK-NEXT:    [[SEXT_B_7:%.*]] = sext i16 [[LD_B_7]] to i32
; CHECK-NEXT:    [[MUL_7:%.*]] = mul i32 [[SEXT_A_7]], [[SEXT_B_7]]
; CHECK-NEXT:    [[ADD_7:%.*]] = add i32 [[MUL_6]], [[MUL_7]]
; CHECK-NEXT:    [[ADDR_A_8:%.*]] = getelementptr i16, ptr [[A]], i32 7
; CHECK-NEXT:    [[ADDR_B_8:%.*]] = getelementptr i16, ptr [[B]], i32 7
; CHECK-NEXT:    [[LD_A_8:%.*]] = load i16, ptr [[ADDR_A_8]], align 2
; CHECK-NEXT:    [[SEXT_A_8:%.*]] = sext i16 [[LD_A_8]] to i32
; CHECK-NEXT:    [[LD_B_8:%.*]] = load i16, ptr [[ADDR_B_8]], align 2
; CHECK-NEXT:    [[SEXT_B_8:%.*]] = sext i16 [[LD_B_8]] to i32
; CHECK-NEXT:    [[MUL_8:%.*]] = mul i32 [[SEXT_A_8]], [[SEXT_B_8]]
; CHECK-NEXT:    [[ADD_10:%.*]] = add i32 [[ADD_7]], [[ADD_5]]
; CHECK-NEXT:    [[ADD_11:%.*]] = add i32 [[ADD_3]], [[ADD_0]]
; CHECK-NEXT:    [[ADD_12:%.*]] = add i32 [[ADD_10]], [[ADD_11]]
; CHECK-NEXT:    [[ADD_13:%.*]] = add i32 [[ADD_12]], [[ACC:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_13]], [[MUL_8]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.1 = load i16, ptr %addr.a.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add.0 = add i32 %mul.0, %mul.1

  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.b.2 = getelementptr i16, ptr %b, i32 2
  %ld.a.2 = load i16, ptr %addr.a.2
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %ld.b.2 = load i16, ptr %addr.b.2
  %sext.b.2 = sext i16 %ld.b.2 to i32
  %mul.2 = mul i32 %sext.a.0, %sext.b.0
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %addr.b.3 = getelementptr i16, ptr %b, i32 3
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %ld.b.3 = load i16, ptr %addr.b.3
  %sext.b.3 = sext i16 %ld.b.3 to i32
  %mul.3 = mul i32 %sext.a.1, %sext.b.3
  %add.3 = add i32 %mul.2, %mul.3

  %addr.a.4 = getelementptr i16, ptr %a, i32 4
  %addr.b.4 = getelementptr i16, ptr %b, i32 4
  %ld.a.4 = load i16, ptr %addr.a.4
  %sext.a.4 = sext i16 %ld.a.4 to i32
  %ld.b.4 = load i16, ptr %addr.b.4
  %sext.b.4 = sext i16 %ld.b.4 to i32
  %mul.4 = mul i32 %sext.a.4, %sext.b.4
  %addr.a.5 = getelementptr i16, ptr %a, i32 5
  %addr.b.5 = getelementptr i16, ptr %b, i32 5
  %ld.a.5 = load i16, ptr %addr.a.5
  %sext.a.5 = sext i16 %ld.a.5 to i32
  %ld.b.5 = load i16, ptr %addr.b.5
  %sext.b.5 = sext i16 %ld.b.5 to i32
  %mul.5 = mul i32 %sext.a.5, %sext.b.5
  %add.5 = add i32 %mul.4, %mul.5

  %addr.a.6 = getelementptr i16, ptr %a, i32 6
  %addr.b.6 = getelementptr i16, ptr %b, i32 6
  %ld.a.6 = load i16, ptr %addr.a.6
  %sext.a.6 = sext i16 %ld.a.6 to i32
  %ld.b.6 = load i16, ptr %addr.b.6
  %sext.b.6 = sext i16 %ld.b.6 to i32
  %mul.6 = mul i32 %sext.a.6, %sext.b.6
  %addr.a.7 = getelementptr i16, ptr %a, i32 7
  %addr.b.7 = getelementptr i16, ptr %b, i32 7
  %ld.a.7 = load i16, ptr %addr.a.7
  %sext.a.7 = sext i16 %ld.a.7 to i32
  %ld.b.7 = load i16, ptr %addr.b.7
  %sext.b.7 = sext i16 %ld.b.7 to i32
  %mul.7 = mul i32 %sext.a.7, %sext.b.7
  %add.7 = add i32 %mul.6, %mul.7

  %addr.a.8 = getelementptr i16, ptr %a, i32 7
  %addr.b.8 = getelementptr i16, ptr %b, i32 7
  %ld.a.8 = load i16, ptr %addr.a.8
  %sext.a.8 = sext i16 %ld.a.8 to i32
  %ld.b.8 = load i16, ptr %addr.b.8
  %sext.b.8 = sext i16 %ld.b.8 to i32
  %mul.8 = mul i32 %sext.a.8, %sext.b.8

  %add.10 = add i32 %add.7, %add.5
  %add.11 = add i32 %add.3, %add.0
  %add.12 = add i32 %add.10, %add.11
  %add.13 = add i32 %add.12, %acc
  %res = add i32 %add.13, %mul.8
  ret i32 %res
}
