; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+bmi2 | FileCheck %s
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+bmi2 | FileCheck %s -check-prefix=CHECK32

@fill_table32 = internal unnamed_addr constant [32 x i32] [i32 0, i32 1, i32 3, i32 7, i32 15, i32 31, i32 63, i32 127, i32 255, i32 511, i32 1023, i32 2047, i32 4095, i32 8191, i32 16383, i32 32767, i32 65535, i32 131071, i32 262143, i32 524287, i32 1048575, i32 2097151, i32 4194303, i32 8388607, i32 16777215, i32 33554431, i32 67108863, i32 134217727, i32 268435455, i32 536870911, i32 1073741823, i32 2147483647], align 16
@fill_table32_partial = internal unnamed_addr constant [17 x i32] [i32 0, i32 1, i32 3, i32 7, i32 15, i32 31, i32 63, i32 127, i32 255, i32 511, i32 1023, i32 2047, i32 4095, i32 8191, i32 16383, i32 32767, i32 65535], align 16
@fill_table64 = internal unnamed_addr constant [64 x i64] [i64 0, i64 1, i64 3, i64 7, i64 15, i64 31, i64 63, i64 127, i64 255, i64 511, i64 1023, i64 2047, i64 4095, i64 8191, i64 16383, i64 32767, i64 65535, i64 131071, i64 262143, i64 524287, i64 1048575, i64 2097151, i64 4194303, i64 8388607, i64 16777215, i64 33554431, i64 67108863, i64 134217727, i64 268435455, i64 536870911, i64 1073741823, i64 2147483647, i64 4294967295, i64 8589934591, i64 17179869183, i64 34359738367, i64 68719476735, i64 137438953471, i64 274877906943, i64 549755813887, i64 1099511627775, i64 2199023255551, i64 4398046511103, i64 8796093022207, i64 17592186044415, i64 35184372088831, i64 70368744177663, i64 140737488355327, i64 281474976710655, i64 562949953421311, i64 1125899906842623, i64 2251799813685247, i64 4503599627370495, i64 9007199254740991, i64 18014398509481983, i64 36028797018963967, i64 72057594037927935, i64 144115188075855871, i64 288230376151711743, i64 576460752303423487, i64 1152921504606846975, i64 2305843009213693951, i64 4611686018427387903, i64 9223372036854775807], align 16
@fill_table64_partial = internal unnamed_addr constant [51 x i64] [i64 0, i64 1, i64 3, i64 7, i64 15, i64 31, i64 63, i64 127, i64 255, i64 511, i64 1023, i64 2047, i64 4095, i64 8191, i64 16383, i64 32767, i64 65535, i64 131071, i64 262143, i64 524287, i64 1048575, i64 2097151, i64 4194303, i64 8388607, i64 16777215, i64 33554431, i64 67108863, i64 134217727, i64 268435455, i64 536870911, i64 1073741823, i64 2147483647, i64 4294967295, i64 8589934591, i64 17179869183, i64 34359738367, i64 68719476735, i64 137438953471, i64 274877906943, i64 549755813887, i64 1099511627775, i64 2199023255551, i64 4398046511103, i64 8796093022207, i64 17592186044415, i64 35184372088831, i64 70368744177663, i64 140737488355327, i64 281474976710655, i64 562949953421311, i64 1125899906842623], align 16

define i32 @f32_bzhi(i32 %x, i32 %y) local_unnamed_addr {
; CHECK-LABEL: f32_bzhi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bzhil %esi, %edi, %eax
; CHECK-NEXT:    retq
;
; CHECK32-LABEL: f32_bzhi:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    bzhil %eax, {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    retl
entry:
  %idxprom = sext i32 %y to i64
  %arrayidx = getelementptr inbounds [32 x i32], [32 x i32]* @fill_table32, i64 0, i64 %idxprom
  %0 = load i32, i32* %arrayidx, align 4
  %and = and i32 %0, %x
  ret i32 %and
}

define i32 @f32_bzhi_partial(i32 %x, i32 %y) local_unnamed_addr {
; CHECK-LABEL: f32_bzhi_partial:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bzhil %esi, %edi, %eax
; CHECK-NEXT:    retq
;
; CHECK32-LABEL: f32_bzhi_partial:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    bzhil %eax, {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    retl
entry:
  %idxprom = sext i32 %y to i64
  %arrayidx = getelementptr inbounds [17 x i32], [17 x i32]* @fill_table32_partial, i64 0, i64 %idxprom
  %0 = load i32, i32* %arrayidx, align 4
  %and = and i32 %0, %x
  ret i32 %and
}

define i64 @f64_bzhi(i64 %x, i64 %y) local_unnamed_addr {
; CHECK-LABEL: f64_bzhi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bzhiq %rsi, %rdi, %rax
; CHECK-NEXT:    retq
;
; CHECK32-LABEL: f64_bzhi:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl fill_table64+4(,%eax,8), %edx
; CHECK32-NEXT:    movl fill_table64(,%eax,8), %eax
; CHECK32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; CHECK32-NEXT:    retl
entry:
  %arrayidx = getelementptr inbounds [64 x i64], [64 x i64]* @fill_table64, i64 0, i64 %y
  %0 = load i64, i64* %arrayidx, align 8
  %and = and i64 %0, %x
  ret i64 %and
}

define i64 @f64_bzhi_partial(i64 %x, i64 %y) local_unnamed_addr {
; CHECK-LABEL: f64_bzhi_partial:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bzhiq %rsi, %rdi, %rax
; CHECK-NEXT:    retq
;
; CHECK32-LABEL: f64_bzhi_partial:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    movl fill_table64_partial+4(,%eax,8), %edx
; CHECK32-NEXT:    movl fill_table64_partial(,%eax,8), %eax
; CHECK32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; CHECK32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; CHECK32-NEXT:    retl
entry:
  %arrayidx = getelementptr inbounds [51 x i64], [51 x i64]* @fill_table64_partial, i64 0, i64 %y
  %0 = load i64, i64* %arrayidx, align 8
  %and = and i64 %0, %x
  ret i64 %and
}

