#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

typedef signed char __s8;

typedef unsigned char __u8;

typedef short int __s16;

typedef short unsigned int __u16;

typedef int __s32;

typedef unsigned int __u32;

typedef long long int __s64;

typedef long long unsigned int __u64;

typedef __s8 s8;

typedef __u8 u8;

typedef __s16 s16;

typedef __u16 u16;

typedef __s32 s32;

typedef __u32 u32;

typedef __s64 s64;

typedef __u64 u64;

enum {
	false = 0,
	true = 1,
};

typedef long int __kernel_long_t;

typedef long unsigned int __kernel_ulong_t;

typedef int __kernel_pid_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_gid32_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef __kernel_long_t __kernel_clock_t;

typedef int __kernel_timer_t;

typedef int __kernel_clockid_t;

typedef unsigned int __poll_t;

typedef u32 __kernel_dev_t;

typedef __kernel_dev_t dev_t;

typedef short unsigned int umode_t;

typedef __kernel_pid_t pid_t;

typedef __kernel_clockid_t clockid_t;

typedef _Bool bool;

typedef __kernel_uid32_t uid_t;

typedef __kernel_gid32_t gid_t;

typedef long unsigned int uintptr_t;

typedef __kernel_loff_t loff_t;

typedef __kernel_size_t size_t;

typedef __kernel_ssize_t ssize_t;

typedef s32 int32_t;

typedef u32 uint32_t;

typedef u64 sector_t;

typedef u64 blkcnt_t;

typedef unsigned int gfp_t;

typedef unsigned int fmode_t;

typedef u64 phys_addr_t;

typedef struct {
	int counter;
} atomic_t;

typedef struct {
	s64 counter;
} atomic64_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

struct hlist_node;

struct hlist_head {
	struct hlist_node *first;
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 19,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_MAX = 524288,
};

struct perf_event_attr {
	__u32 type;
	__u32 size;
	__u64 config;
	union {
		__u64 sample_period;
		__u64 sample_freq;
	};
	__u64 sample_type;
	__u64 read_format;
	__u64 disabled: 1;
	__u64 inherit: 1;
	__u64 pinned: 1;
	__u64 exclusive: 1;
	__u64 exclude_user: 1;
	__u64 exclude_kernel: 1;
	__u64 exclude_hv: 1;
	__u64 exclude_idle: 1;
	__u64 mmap: 1;
	__u64 comm: 1;
	__u64 freq: 1;
	__u64 inherit_stat: 1;
	__u64 enable_on_exec: 1;
	__u64 task: 1;
	__u64 watermark: 1;
	__u64 precise_ip: 2;
	__u64 mmap_data: 1;
	__u64 sample_id_all: 1;
	__u64 exclude_host: 1;
	__u64 exclude_guest: 1;
	__u64 exclude_callchain_kernel: 1;
	__u64 exclude_callchain_user: 1;
	__u64 mmap2: 1;
	__u64 comm_exec: 1;
	__u64 use_clockid: 1;
	__u64 context_switch: 1;
	__u64 write_backward: 1;
	__u64 namespaces: 1;
	__u64 ksymbol: 1;
	__u64 bpf_event: 1;
	__u64 aux_output: 1;
	__u64 cgroup: 1;
	__u64 text_poke: 1;
	__u64 build_id: 1;
	__u64 inherit_thread: 1;
	__u64 remove_on_exec: 1;
	__u64 sigtrap: 1;
	__u64 __reserved_1: 26;
	union {
		__u32 wakeup_events;
		__u32 wakeup_watermark;
	};
	__u32 bp_type;
	union {
		__u64 bp_addr;
		__u64 kprobe_func;
		__u64 uprobe_path;
		__u64 config1;
	};
	union {
		__u64 bp_len;
		__u64 kprobe_addr;
		__u64 probe_offset;
		__u64 config2;
	};
	__u64 branch_sample_type;
	__u64 sample_regs_user;
	__u32 sample_stack_user;
	__s32 clockid;
	__u64 sample_regs_intr;
	__u32 aux_watermark;
	__u16 sample_max_stack;
	__u16 __reserved_2;
	__u32 aux_sample_size;
	__u32 __reserved_3;
	__u64 sig_data;
	__u64 config3;
};

struct perf_event_mmap_page {
	__u32 version;
	__u32 compat_version;
	__u32 lock;
	__u32 index;
	__s64 offset;
	__u64 time_enabled;
	__u64 time_running;
	union {
		__u64 capabilities;
		struct {
			__u64 cap_bit0: 1;
			__u64 cap_bit0_is_deprecated: 1;
			__u64 cap_user_rdpmc: 1;
			__u64 cap_user_time: 1;
			__u64 cap_user_time_zero: 1;
			__u64 cap_user_time_short: 1;
			__u64 cap_____res: 58;
		};
	};
	__u16 pmc_width;
	__u16 time_shift;
	__u32 time_mult;
	__u64 time_offset;
	__u64 time_zero;
	__u32 size;
	__u32 __reserved_1;
	__u64 time_cycles;
	__u64 time_mask;
	__u8 __reserved[928];
	__u64 data_head;
	__u64 data_tail;
	__u64 data_offset;
	__u64 data_size;
	__u64 aux_head;
	__u64 aux_tail;
	__u64 aux_offset;
	__u64 aux_size;
};

union perf_mem_data_src {
	__u64 val;
	struct {
		__u64 mem_op: 5;
		__u64 mem_lvl: 14;
		__u64 mem_snoop: 5;
		__u64 mem_lock: 2;
		__u64 mem_dtlb: 7;
		__u64 mem_lvl_num: 4;
		__u64 mem_remote: 1;
		__u64 mem_snoopx: 2;
		__u64 mem_blk: 3;
		__u64 mem_hops: 3;
		__u64 mem_rsvd: 18;
	};
};

struct perf_branch_entry {
	__u64 from;
	__u64 to;
	__u64 mispred: 1;
	__u64 predicted: 1;
	__u64 in_tx: 1;
	__u64 abort: 1;
	__u64 cycles: 16;
	__u64 type: 4;
	__u64 spec: 2;
	__u64 new_type: 4;
	__u64 priv: 3;
	__u64 reserved: 31;
};

union perf_sample_weight {
	__u64 full;
	struct {
		__u32 var1_dw;
		__u16 var2_w;
		__u16 var3_w;
	};
};

struct lockdep_subclass_key {
	char __one_byte;
};

struct lock_class_key {
	union {
		struct hlist_node hash_entry;
		struct lockdep_subclass_key subkeys[8];
	};
};

struct fs_context;

struct fs_parameter_spec;

struct dentry;

struct super_block;

struct module;

struct file_system_type {
	const char *name;
	int fs_flags;
	int (*init_fs_context)(struct fs_context *);
	const struct fs_parameter_spec *parameters;
	struct dentry * (*mount)(struct file_system_type *, int, const char *, void *);
	void (*kill_sb)(struct super_block *);
	struct module *owner;
	struct file_system_type *next;
	struct hlist_head fs_supers;
	struct lock_class_key s_lock_key;
	struct lock_class_key s_umount_key;
	struct lock_class_key s_vfs_rename_key;
	struct lock_class_key s_writers_key[3];
	struct lock_class_key i_lock_key;
	struct lock_class_key i_mutex_key;
	struct lock_class_key invalidate_lock_key;
	struct lock_class_key i_mutex_dir_key;
};

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

enum lockdep_wait_type {
	LD_WAIT_INV = 0,
	LD_WAIT_FREE = 1,
	LD_WAIT_SPIN = 2,
	LD_WAIT_CONFIG = 2,
	LD_WAIT_SLEEP = 3,
	LD_WAIT_MAX = 4,
};

struct lockdep_map;

typedef int (*lock_cmp_fn)(const struct lockdep_map *, const struct lockdep_map *);

struct lock_class;

struct lockdep_map {
	struct lock_class_key *key;
	struct lock_class *class_cache[2];
	const char *name;
	u8 wait_type_outer;
	u8 wait_type_inner;
	u8 lock_type;
};

typedef void (*lock_print_fn)(const struct lockdep_map *);

struct lock_trace;

struct lock_class {
	struct hlist_node hash_entry;
	struct list_head lock_entry;
	struct list_head locks_after;
	struct list_head locks_before;
	const struct lockdep_subclass_key *key;
	lock_cmp_fn cmp_fn;
	lock_print_fn print_fn;
	unsigned int subclass;
	unsigned int dep_gen_id;
	long unsigned int usage_mask;
	const struct lock_trace *usage_traces[10];
	int name_version;
	const char *name;
	u8 wait_type_inner;
	u8 wait_type_outer;
	u8 lock_type;
};

struct lock_trace {
	struct hlist_node hash_entry;
	u32 hash;
	u32 nr_entries;
	long unsigned int entries[0];
};

struct raw_spinlock {
	arch_spinlock_t raw_lock;
	unsigned int magic;
	unsigned int owner_cpu;
	void *owner;
	struct lockdep_map dep_map;
};

typedef struct raw_spinlock raw_spinlock_t;

struct ratelimit_state {
	raw_spinlock_t lock;
	int interval;
	int burst;
	int printed;
	int missed;
	long unsigned int begin;
	long unsigned int flags;
};

typedef void *fl_owner_t;

struct file;

struct kiocb;

struct iov_iter;

struct io_comp_batch;

struct dir_context;

struct poll_table_struct;

struct vm_area_struct;

struct inode;

struct file_lock;

struct pipe_inode_info;

struct seq_file;

struct io_uring_cmd;

struct file_operations {
	struct module *owner;
	loff_t (*llseek)(struct file *, loff_t, int);
	ssize_t (*read)(struct file *, char *, size_t, loff_t *);
	ssize_t (*write)(struct file *, const char *, size_t, loff_t *);
	ssize_t (*read_iter)(struct kiocb *, struct iov_iter *);
	ssize_t (*write_iter)(struct kiocb *, struct iov_iter *);
	int (*iopoll)(struct kiocb *, struct io_comp_batch *, unsigned int);
	int (*iterate_shared)(struct file *, struct dir_context *);
	__poll_t (*poll)(struct file *, struct poll_table_struct *);
	long int (*unlocked_ioctl)(struct file *, unsigned int, long unsigned int);
	long int (*compat_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*mmap)(struct file *, struct vm_area_struct *);
	long unsigned int mmap_supported_flags;
	int (*open)(struct inode *, struct file *);
	int (*flush)(struct file *, fl_owner_t);
	int (*release)(struct inode *, struct file *);
	int (*fsync)(struct file *, loff_t, loff_t, int);
	int (*fasync)(int, struct file *, int);
	int (*lock)(struct file *, int, struct file_lock *);
	long unsigned int (*get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
	int (*check_flags)(int);
	int (*flock)(struct file *, int, struct file_lock *);
	ssize_t (*splice_write)(struct pipe_inode_info *, struct file *, loff_t *, size_t, unsigned int);
	ssize_t (*splice_read)(struct file *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
	void (*splice_eof)(struct file *);
	int (*setlease)(struct file *, int, struct file_lock **, void **);
	long int (*fallocate)(struct file *, int, loff_t, loff_t);
	void (*show_fdinfo)(struct seq_file *, struct file *);
	ssize_t (*copy_file_range)(struct file *, loff_t, struct file *, loff_t, size_t, unsigned int);
	loff_t (*remap_file_range)(struct file *, loff_t, struct file *, loff_t, loff_t, unsigned int);
	int (*fadvise)(struct file *, loff_t, loff_t, int);
	int (*uring_cmd)(struct io_uring_cmd *, unsigned int);
	int (*uring_cmd_iopoll)(struct io_uring_cmd *, struct io_comp_batch *, unsigned int);
};

struct static_call_site {
	s32 addr;
	s32 key;
};

struct static_call_mod {
	struct static_call_mod *next;
	struct module *mod;
	struct static_call_site *sites;
};

struct static_call_key {
	void *func;
	union {
		long unsigned int type;
		struct static_call_mod *mods;
		struct static_call_site *sites;
	};
};

struct thread_info {
	long unsigned int flags;
	long unsigned int syscall_work;
	u32 status;
	u32 cpu;
};

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

struct load_weight {
	long unsigned int weight;
	u32 inv_weight;
};

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct util_est {
	unsigned int enqueued;
	unsigned int ewma;
};

struct sched_avg {
	u64 last_update_time;
	u64 load_sum;
	u64 runnable_sum;
	u32 util_sum;
	u32 period_contrib;
	long unsigned int load_avg;
	long unsigned int runnable_avg;
	long unsigned int util_avg;
	struct util_est util_est;
};

struct cfs_rq;

struct sched_entity {
	struct load_weight load;
	struct rb_node run_node;
	u64 deadline;
	u64 min_deadline;
	struct list_head group_node;
	unsigned int on_rq;
	u64 exec_start;
	u64 sum_exec_runtime;
	u64 prev_sum_exec_runtime;
	u64 vruntime;
	s64 vlag;
	u64 slice;
	u64 nr_migrations;
	int depth;
	struct sched_entity *parent;
	struct cfs_rq *cfs_rq;
	struct cfs_rq *my_q;
	long unsigned int runnable_weight;
	long: 64;
	long: 64;
	struct sched_avg avg;
};

struct sched_rt_entity {
	struct list_head run_list;
	long unsigned int timeout;
	long unsigned int watchdog_stamp;
	unsigned int time_slice;
	short unsigned int on_rq;
	short unsigned int on_list;
	struct sched_rt_entity *back;
};

typedef s64 ktime_t;

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct sched_dl_entity {
	struct rb_node rb_node;
	u64 dl_runtime;
	u64 dl_deadline;
	u64 dl_period;
	u64 dl_bw;
	u64 dl_density;
	s64 runtime;
	u64 deadline;
	unsigned int flags;
	unsigned int dl_throttled: 1;
	unsigned int dl_yielded: 1;
	unsigned int dl_non_contending: 1;
	unsigned int dl_overrun: 1;
	struct hrtimer dl_timer;
	struct hrtimer inactive_timer;
	struct sched_dl_entity *pi_se;
};

struct sched_statistics {
	u64 wait_start;
	u64 wait_max;
	u64 wait_count;
	u64 wait_sum;
	u64 iowait_count;
	u64 iowait_sum;
	u64 sleep_start;
	u64 sleep_max;
	s64 sum_sleep_runtime;
	u64 block_start;
	u64 block_max;
	s64 sum_block_runtime;
	u64 exec_max;
	u64 slice_max;
	u64 nr_migrations_cold;
	u64 nr_failed_migrations_affine;
	u64 nr_failed_migrations_running;
	u64 nr_failed_migrations_hot;
	u64 nr_forced_migrations;
	u64 nr_wakeups;
	u64 nr_wakeups_sync;
	u64 nr_wakeups_migrate;
	u64 nr_wakeups_local;
	u64 nr_wakeups_remote;
	u64 nr_wakeups_affine;
	u64 nr_wakeups_affine_attempts;
	u64 nr_wakeups_passive;
	u64 nr_wakeups_idle;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct cpumask {
	long unsigned int bits[2];
};

typedef struct cpumask cpumask_t;

union rcu_special {
	struct {
		u8 blocked;
		u8 need_qs;
		u8 exp_hint;
		u8 need_mb;
	} b;
	u32 s;
};

struct sched_info {
	long unsigned int pcount;
	long long unsigned int run_delay;
	long long unsigned int last_arrival;
	long long unsigned int last_queued;
};

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

struct __kernel_timespec;

struct old_timespec32;

struct pollfd;

struct restart_block {
	long unsigned int arch_data;
	long int (*fn)(struct restart_block *);
	union {
		struct {
			u32 *uaddr;
			u32 val;
			u32 flags;
			u32 bitset;
			u64 time;
			u32 *uaddr2;
		} futex;
		struct {
			clockid_t clockid;
			enum timespec_type type;
			union {
				struct __kernel_timespec *rmtp;
				struct old_timespec32 *compat_rmtp;
			};
			u64 expires;
		} nanosleep;
		struct {
			struct pollfd *ufds;
			int nfds;
			int has_timeout;
			long unsigned int tv_sec;
			long unsigned int tv_nsec;
		} poll;
	};
};

struct prev_cputime {
	u64 utime;
	u64 stime;
	raw_spinlock_t lock;
};

struct rb_root {
	struct rb_node *rb_node;
};

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
};

struct timerqueue_head {
	struct rb_root_cached rb_root;
};

struct posix_cputimer_base {
	u64 nextevt;
	struct timerqueue_head tqhead;
};

struct posix_cputimers {
	struct posix_cputimer_base bases[3];
	unsigned int timers_active;
	unsigned int expiry_active;
};

typedef atomic64_t atomic_long_t;

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
	void *magic;
	struct lockdep_map dep_map;
};

struct posix_cputimers_work {
	struct callback_head work;
	struct mutex mutex;
	unsigned int scheduled;
};

struct sem_undo_list;

struct sysv_sem {
	struct sem_undo_list *undo_list;
};

struct sysv_shm {
	struct list_head shm_clist;
};

typedef struct {
	long unsigned int sig[1];
} sigset_t;

struct sigpending {
	struct list_head list;
	sigset_t signal;
};

typedef struct {
	uid_t val;
} kuid_t;

struct seccomp_filter;

struct seccomp {
	int mode;
	atomic_t filter_count;
	struct seccomp_filter *filter;
};

struct syscall_user_dispatch {
	char *selector;
	long unsigned int offset;
	long unsigned int len;
	bool on_dispatch;
};

struct spinlock {
	union {
		struct raw_spinlock rlock;
		struct {
			u8 __padding[24];
			struct lockdep_map dep_map;
		};
	};
};

typedef struct spinlock spinlock_t;

struct wake_q_node {
	struct wake_q_node *next;
};

struct irqtrace_events {
	unsigned int irq_events;
	long unsigned int hardirq_enable_ip;
	long unsigned int hardirq_disable_ip;
	unsigned int hardirq_enable_event;
	unsigned int hardirq_disable_event;
	long unsigned int softirq_disable_ip;
	long unsigned int softirq_enable_ip;
	unsigned int softirq_disable_event;
	unsigned int softirq_enable_event;
};

struct held_lock {
	u64 prev_chain_key;
	long unsigned int acquire_ip;
	struct lockdep_map *instance;
	struct lockdep_map *nest_lock;
	unsigned int class_idx: 13;
	unsigned int irq_context: 2;
	unsigned int trylock: 1;
	unsigned int read: 2;
	unsigned int check: 1;
	unsigned int hardirqs_off: 1;
	unsigned int sync: 1;
	unsigned int references: 11;
	unsigned int pin_count;
};

struct task_io_accounting {
	u64 rchar;
	u64 wchar;
	u64 syscr;
	u64 syscw;
	u64 read_bytes;
	u64 write_bytes;
	u64 cancelled_write_bytes;
};

typedef struct {
	long unsigned int bits[1];
} nodemask_t;

struct seqcount {
	unsigned int sequence;
	struct lockdep_map dep_map;
};

typedef struct seqcount seqcount_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
	spinlock_t *lock;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct arch_tlbflush_unmap_batch {
	struct cpumask cpumask;
};

struct tlbflush_unmap_batch {
	struct arch_tlbflush_unmap_batch arch;
	bool flush_required;
	bool writable;
};

struct page;

struct page_frag {
	struct page *page;
	__u32 offset;
	__u32 size;
};

struct kmap_ctrl {};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
	struct lockdep_map lockdep_map;
};

struct llist_head {
	struct llist_node *first;
};

struct desc_struct {
	u16 limit0;
	u16 base0;
	u16 base1: 8;
	u16 type: 4;
	u16 s: 1;
	u16 dpl: 2;
	u16 p: 1;
	u16 limit1: 4;
	u16 avl: 1;
	u16 l: 1;
	u16 d: 1;
	u16 g: 1;
	u16 base2: 8;
};

struct fpu_state_perm {
	u64 __state_perm;
	unsigned int __state_size;
	unsigned int __user_state_size;
};

struct fregs_state {
	u32 cwd;
	u32 swd;
	u32 twd;
	u32 fip;
	u32 fcs;
	u32 foo;
	u32 fos;
	u32 st_space[20];
	u32 status;
};

struct fxregs_state {
	u16 cwd;
	u16 swd;
	u16 twd;
	u16 fop;
	union {
		struct {
			u64 rip;
			u64 rdp;
		};
		struct {
			u32 fip;
			u32 fcs;
			u32 foo;
			u32 fos;
		};
	};
	u32 mxcsr;
	u32 mxcsr_mask;
	u32 st_space[32];
	u32 xmm_space[64];
	u32 padding[12];
	union {
		u32 padding1[12];
		u32 sw_reserved[12];
	};
};

struct math_emu_info;

struct swregs_state {
	u32 cwd;
	u32 swd;
	u32 twd;
	u32 fip;
	u32 fcs;
	u32 foo;
	u32 fos;
	u32 st_space[20];
	u8 ftop;
	u8 changed;
	u8 lookahead;
	u8 no_update;
	u8 rm;
	u8 alimit;
	struct math_emu_info *info;
	u32 entry_eip;
};

struct xstate_header {
	u64 xfeatures;
	u64 xcomp_bv;
	u64 reserved[6];
};

struct xregs_state {
	struct fxregs_state i387;
	struct xstate_header header;
	u8 extended_state_area[0];
};

union fpregs_state {
	struct fregs_state fsave;
	struct fxregs_state fxsave;
	struct swregs_state soft;
	struct xregs_state xsave;
	u8 __padding[4096];
};

struct fpstate {
	unsigned int size;
	unsigned int user_size;
	u64 xfeatures;
	u64 user_xfeatures;
	u64 xfd;
	unsigned int is_valloc: 1;
	unsigned int is_guest: 1;
	unsigned int is_confidential: 1;
	unsigned int in_use: 1;
	long: 64;
	long: 64;
	long: 64;
	union fpregs_state regs;
};

struct fpu {
	unsigned int last_cpu;
	long unsigned int avx512_timestamp;
	struct fpstate *fpstate;
	struct fpstate *__task_fpstate;
	struct fpu_state_perm perm;
	struct fpu_state_perm guest_perm;
	struct fpstate __fpstate;
};

struct perf_event;

struct io_bitmap;

struct thread_struct {
	struct desc_struct tls_array[3];
	long unsigned int sp;
	short unsigned int es;
	short unsigned int ds;
	short unsigned int fsindex;
	short unsigned int gsindex;
	long unsigned int fsbase;
	long unsigned int gsbase;
	struct perf_event *ptrace_bps[4];
	long unsigned int virtual_dr6;
	long unsigned int ptrace_dr7;
	long unsigned int cr2;
	long unsigned int trap_nr;
	long unsigned int error_code;
	struct io_bitmap *io_bitmap;
	long unsigned int iopl_emul;
	unsigned int iopl_warn: 1;
	unsigned int sig_on_uaccess_err: 1;
	u32 pkru;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct fpu fpu;
};

struct sched_class;

struct task_group;

struct rcu_node;

struct mm_struct;

struct address_space;

struct pid;

struct completion;

struct cred;

struct key;

struct nameidata;

struct fs_struct;

struct files_struct;

struct io_uring_task;

struct nsproxy;

struct signal_struct;

struct sighand_struct;

struct audit_context;

struct rt_mutex_waiter;

struct mutex_waiter;

struct bio_list;

struct blk_plug;

struct reclaim_state;

struct io_context;

struct capture_control;

struct kernel_siginfo;

typedef struct kernel_siginfo kernel_siginfo_t;

struct css_set;

struct robust_list_head;

struct futex_pi_state;

struct perf_event_context;

struct mempolicy;

struct numa_group;

struct rseq;

struct task_delay_info;

struct ftrace_ret_stack;

struct mem_cgroup;

struct gendisk;

struct uprobe_task;

struct vm_struct;

struct bpf_local_storage;

struct bpf_run_ctx;

struct task_struct {
	struct thread_info thread_info;
	unsigned int __state;
	unsigned int saved_state;
	void *stack;
	refcount_t usage;
	unsigned int flags;
	unsigned int ptrace;
	int on_cpu;
	struct __call_single_node wake_entry;
	unsigned int wakee_flips;
	long unsigned int wakee_flip_decay_ts;
	struct task_struct *last_wakee;
	int recent_used_cpu;
	int wake_cpu;
	int on_rq;
	int prio;
	int static_prio;
	int normal_prio;
	unsigned int rt_priority;
	struct sched_entity se;
	struct sched_rt_entity rt;
	struct sched_dl_entity dl;
	const struct sched_class *sched_class;
	struct task_group *sched_task_group;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct sched_statistics stats;
	unsigned int btrace_seq;
	unsigned int policy;
	int nr_cpus_allowed;
	const cpumask_t *cpus_ptr;
	cpumask_t *user_cpus_ptr;
	cpumask_t cpus_mask;
	void *migration_pending;
	short unsigned int migration_disabled;
	short unsigned int migration_flags;
	int rcu_read_lock_nesting;
	union rcu_special rcu_read_unlock_special;
	struct list_head rcu_node_entry;
	struct rcu_node *rcu_blocked_node;
	long unsigned int rcu_tasks_nvcsw;
	u8 rcu_tasks_holdout;
	u8 rcu_tasks_idx;
	int rcu_tasks_idle_cpu;
	struct list_head rcu_tasks_holdout_list;
	int trc_reader_nesting;
	int trc_ipi_to_cpu;
	union rcu_special trc_reader_special;
	struct list_head trc_holdout_list;
	struct list_head trc_blkd_node;
	int trc_blkd_cpu;
	struct sched_info sched_info;
	struct list_head tasks;
	struct plist_node pushable_tasks;
	struct rb_node pushable_dl_tasks;
	struct mm_struct *mm;
	struct mm_struct *active_mm;
	struct address_space *faults_disabled_mapping;
	int exit_state;
	int exit_code;
	int exit_signal;
	int pdeath_signal;
	long unsigned int jobctl;
	unsigned int personality;
	unsigned int sched_reset_on_fork: 1;
	unsigned int sched_contributes_to_load: 1;
	unsigned int sched_migrated: 1;
	long: 29;
	unsigned int sched_remote_wakeup: 1;
	unsigned int sched_rt_mutex: 1;
	unsigned int in_execve: 1;
	unsigned int in_iowait: 1;
	unsigned int restore_sigmask: 1;
	unsigned int in_user_fault: 1;
	unsigned int brk_randomized: 1;
	unsigned int no_cgroup_migration: 1;
	unsigned int frozen: 1;
	unsigned int use_memdelay: 1;
	unsigned int in_eventfd: 1;
	unsigned int reported_split_lock: 1;
	unsigned int in_thrashing: 1;
	long unsigned int atomic_flags;
	struct restart_block restart_block;
	pid_t pid;
	pid_t tgid;
	long unsigned int stack_canary;
	struct task_struct *real_parent;
	struct task_struct *parent;
	struct list_head children;
	struct list_head sibling;
	struct task_struct *group_leader;
	struct list_head ptraced;
	struct list_head ptrace_entry;
	struct pid *thread_pid;
	struct hlist_node pid_links[4];
	struct list_head thread_group;
	struct list_head thread_node;
	struct completion *vfork_done;
	int *set_child_tid;
	int *clear_child_tid;
	void *worker_private;
	u64 utime;
	u64 stime;
	u64 gtime;
	struct prev_cputime prev_cputime;
	long unsigned int nvcsw;
	long unsigned int nivcsw;
	u64 start_time;
	u64 start_boottime;
	long unsigned int min_flt;
	long unsigned int maj_flt;
	struct posix_cputimers posix_cputimers;
	struct posix_cputimers_work posix_cputimers_work;
	const struct cred *ptracer_cred;
	const struct cred *real_cred;
	const struct cred *cred;
	struct key *cached_requested_key;
	char comm[16];
	struct nameidata *nameidata;
	struct sysv_sem sysvsem;
	struct sysv_shm sysvshm;
	long unsigned int last_switch_count;
	long unsigned int last_switch_time;
	struct fs_struct *fs;
	struct files_struct *files;
	struct io_uring_task *io_uring;
	struct nsproxy *nsproxy;
	struct signal_struct *signal;
	struct sighand_struct *sighand;
	sigset_t blocked;
	sigset_t real_blocked;
	sigset_t saved_sigmask;
	struct sigpending pending;
	long unsigned int sas_ss_sp;
	size_t sas_ss_size;
	unsigned int sas_ss_flags;
	struct callback_head *task_works;
	struct audit_context *audit_context;
	kuid_t loginuid;
	unsigned int sessionid;
	struct seccomp seccomp;
	struct syscall_user_dispatch syscall_dispatch;
	u64 parent_exec_id;
	u64 self_exec_id;
	spinlock_t alloc_lock;
	raw_spinlock_t pi_lock;
	struct wake_q_node wake_q;
	struct rb_root_cached pi_waiters;
	struct task_struct *pi_top_task;
	struct rt_mutex_waiter *pi_blocked_on;
	struct mutex_waiter *blocked_on;
	int non_block_count;
	struct irqtrace_events irqtrace;
	unsigned int hardirq_threaded;
	u64 hardirq_chain_key;
	int softirqs_enabled;
	int softirq_context;
	int irq_config;
	u64 curr_chain_key;
	int lockdep_depth;
	unsigned int lockdep_recursion;
	struct held_lock held_locks[48];
	void *journal_info;
	struct bio_list *bio_list;
	struct blk_plug *plug;
	struct reclaim_state *reclaim_state;
	struct io_context *io_context;
	struct capture_control *capture_control;
	long unsigned int ptrace_message;
	kernel_siginfo_t *last_siginfo;
	struct task_io_accounting ioac;
	u64 acct_rss_mem1;
	u64 acct_vm_mem1;
	u64 acct_timexpd;
	nodemask_t mems_allowed;
	seqcount_spinlock_t mems_allowed_seq;
	int cpuset_mem_spread_rotor;
	int cpuset_slab_spread_rotor;
	struct css_set *cgroups;
	struct list_head cg_list;
	struct robust_list_head *robust_list;
	struct list_head pi_state_list;
	struct futex_pi_state *pi_state_cache;
	struct mutex futex_exit_mutex;
	unsigned int futex_state;
	struct perf_event_context *perf_event_ctxp;
	struct mutex perf_event_mutex;
	struct list_head perf_event_list;
	struct mempolicy *mempolicy;
	short int il_prev;
	short int pref_node_fork;
	int numa_scan_seq;
	unsigned int numa_scan_period;
	unsigned int numa_scan_period_max;
	int numa_preferred_nid;
	long unsigned int numa_migrate_retry;
	u64 node_stamp;
	u64 last_task_numa_placement;
	u64 last_sum_exec_runtime;
	struct callback_head numa_work;
	struct numa_group *numa_group;
	long unsigned int *numa_faults;
	long unsigned int total_numa_faults;
	long unsigned int numa_faults_locality[3];
	long unsigned int numa_pages_migrated;
	struct rseq *rseq;
	u32 rseq_len;
	u32 rseq_sig;
	long unsigned int rseq_event_mask;
	int mm_cid;
	int last_mm_cid;
	int migrate_from_cpu;
	int mm_cid_active;
	struct callback_head cid_work;
	struct tlbflush_unmap_batch tlb_ubc;
	struct pipe_inode_info *splice_pipe;
	struct page_frag task_frag;
	struct task_delay_info *delays;
	int make_it_fail;
	unsigned int fail_nth;
	int nr_dirtied;
	int nr_dirtied_pause;
	long unsigned int dirty_paused_when;
	u64 timer_slack_ns;
	u64 default_timer_slack_ns;
	int curr_ret_stack;
	int curr_ret_depth;
	struct ftrace_ret_stack *ret_stack;
	long long unsigned int ftrace_timestamp;
	atomic_t trace_overrun;
	atomic_t tracing_graph_pause;
	long unsigned int trace_recursion;
	struct mem_cgroup *memcg_in_oom;
	gfp_t memcg_oom_gfp_mask;
	int memcg_oom_order;
	unsigned int memcg_nr_pages_over_high;
	struct mem_cgroup *active_memcg;
	struct gendisk *throttle_disk;
	struct uprobe_task *utask;
	struct kmap_ctrl kmap_ctrl;
	long unsigned int task_state_change;
	struct callback_head rcu;
	refcount_t rcu_users;
	int pagefault_disabled;
	struct task_struct *oom_reaper_list;
	struct timer_list oom_reaper_timer;
	struct vm_struct *stack_vm_area;
	refcount_t stack_refcount;
	void *security;
	struct bpf_local_storage *bpf_storage;
	struct bpf_run_ctx *bpf_ctx;
	void *mce_vaddr;
	__u64 mce_kflags;
	u64 mce_addr;
	__u64 mce_ripv: 1;
	__u64 mce_whole_page: 1;
	__u64 __mce_reserved: 62;
	struct callback_head mce_kill_me;
	int mce_count;
	struct llist_head kretprobe_instances;
	struct llist_head rethooks;
	struct callback_head l1d_flush_kill;
	long: 64;
	struct thread_struct thread;
};

struct pcpu_hot {
	union {
		struct {
			struct task_struct *current_task;
			int preempt_count;
			int cpu_number;
			u64 call_depth;
			long unsigned int top_of_stack;
			void *hardirq_stack_ptr;
			u16 softirq_pending;
			bool hardirq_stack_inuse;
		};
		u8 pad[64];
	};
};

struct jump_entry {
	s32 code;
	s32 target;
	long int key;
};

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		long unsigned int type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	};
};

struct static_key_false {
	struct static_key key;
};

struct orc_entry {
	s16 sp_offset;
	s16 bp_offset;
	unsigned int sp_reg: 4;
	unsigned int bp_reg: 4;
	unsigned int type: 3;
	unsigned int signal: 1;
} __attribute__((packed));

struct bug_entry {
	int bug_addr_disp;
	int file_disp;
	short unsigned int line;
	short unsigned int flags;
};

typedef __s64 time64_t;

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
};

struct timespec64 {
	time64_t tv_sec;
	long int tv_nsec;
};

typedef s32 old_time32_t;

struct old_timespec32 {
	old_time32_t tv_sec;
	s32 tv_nsec;
};

struct range {
	u64 start;
	u64 end;
};

struct pt_regs {
	long unsigned int r15;
	long unsigned int r14;
	long unsigned int r13;
	long unsigned int r12;
	long unsigned int bp;
	long unsigned int bx;
	long unsigned int r11;
	long unsigned int r10;
	long unsigned int r9;
	long unsigned int r8;
	long unsigned int ax;
	long unsigned int cx;
	long unsigned int dx;
	long unsigned int si;
	long unsigned int di;
	long unsigned int orig_ax;
	long unsigned int ip;
	long unsigned int cs;
	long unsigned int flags;
	long unsigned int sp;
	long unsigned int ss;
};

struct math_emu_info {
	long int ___orig_eip;
	struct pt_regs *regs;
};

typedef long unsigned int pteval_t;

typedef long unsigned int pmdval_t;

typedef long unsigned int pudval_t;

typedef long unsigned int pgdval_t;

typedef long unsigned int pgprotval_t;

typedef struct {
	pteval_t pte;
} pte_t;

typedef struct {
	pmdval_t pmd;
} pmd_t;

struct pgprot {
	pgprotval_t pgprot;
};

typedef struct pgprot pgprot_t;

typedef struct {
	pgdval_t pgd;
} pgd_t;

typedef struct {
	pudval_t pud;
} pud_t;

typedef struct page *pgtable_t;

struct page_pool;

struct dev_pagemap;

struct page {
	long unsigned int flags;
	union {
		struct {
			union {
				struct list_head lru;
				struct {
					void *__filler;
					unsigned int mlock_count;
				};
				struct list_head buddy_list;
				struct list_head pcp_list;
			};
			struct address_space *mapping;
			union {
				long unsigned int index;
				long unsigned int share;
			};
			long unsigned int private;
		};
		struct {
			long unsigned int pp_magic;
			struct page_pool *pp;
			long unsigned int _pp_mapping_pad;
			long unsigned int dma_addr;
			atomic_long_t pp_frag_count;
		};
		struct {
			long unsigned int compound_head;
		};
		struct {
			struct dev_pagemap *pgmap;
			void *zone_device_data;
		};
		struct callback_head callback_head;
	};
	union {
		atomic_t _mapcount;
		unsigned int page_type;
	};
	atomic_t _refcount;
	long unsigned int memcg_data;
};

struct tracepoint_func {
	void *func;
	void *data;
	int prio;
};

struct tracepoint {
	const char *name;
	struct static_key key;
	struct static_call_key *static_call_key;
	void *static_call_tramp;
	void *iterator;
	void *probestub;
	int (*regfunc)();
	void (*unregfunc)();
	struct tracepoint_func *funcs;
};

typedef const int tracepoint_ptr_t;

struct bpf_raw_event_map {
	struct tracepoint *tp;
	void *bpf_func;
	u32 num_args;
	u32 writable_size;
	long: 64;
};

struct cpuinfo_topology {
	u32 apicid;
	u32 initial_apicid;
	u32 pkg_id;
	u32 die_id;
	u32 cu_id;
	u32 core_id;
	u32 logical_pkg_id;
	u32 logical_die_id;
	u32 llc_id;
	u32 l2c_id;
};

struct cpuinfo_x86 {
	__u8 x86;
	__u8 x86_vendor;
	__u8 x86_model;
	__u8 x86_stepping;
	int x86_tlbsize;
	__u32 vmx_capability[5];
	__u8 x86_virt_bits;
	__u8 x86_phys_bits;
	__u8 x86_coreid_bits;
	__u32 extended_cpuid_level;
	int cpuid_level;
	union {
		__u32 x86_capability[23];
		long unsigned int x86_capability_alignment;
	};
	char x86_vendor_id[16];
	char x86_model_id[64];
	struct cpuinfo_topology topo;
	unsigned int x86_cache_size;
	int x86_cache_alignment;
	int x86_cache_max_rmid;
	int x86_cache_occ_scale;
	int x86_cache_mbm_width_offset;
	int x86_power;
	long unsigned int loops_per_jiffy;
	u64 ppin;
	u16 x86_max_cores;
	u16 x86_clflush_size;
	u16 booted_cores;
	u16 cpu_index;
	bool smt_active;
	u32 microcode;
	u8 x86_cache_bits;
	unsigned int initialized: 1;
};

struct seq_operations {
	void * (*start)(struct seq_file *, loff_t *);
	void (*stop)(struct seq_file *, void *);
	void * (*next)(struct seq_file *, void *, loff_t *);
	int (*show)(struct seq_file *, void *);
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_t a;
} local64_t;

struct hw_perf_event_extra {
	u64 config;
	unsigned int reg;
	int alloc;
	int idx;
};

struct arch_hw_breakpoint {
	long unsigned int address;
	long unsigned int mask;
	u8 len;
	u8 type;
};

struct rhash_head {
	struct rhash_head *next;
};

struct rhlist_head {
	struct rhash_head rhead;
	struct rhlist_head *next;
};

struct hw_perf_event {
	union {
		struct {
			u64 config;
			u64 last_tag;
			long unsigned int config_base;
			long unsigned int event_base;
			int event_base_rdpmc;
			int idx;
			int last_cpu;
			int flags;
			struct hw_perf_event_extra extra_reg;
			struct hw_perf_event_extra branch_reg;
		};
		struct {
			struct hrtimer hrtimer;
		};
		struct {
			struct list_head tp_list;
		};
		struct {
			u64 pwr_acc;
			u64 ptsc;
		};
		struct {
			struct arch_hw_breakpoint info;
			struct rhlist_head bp_list;
		};
		struct {
			u8 iommu_bank;
			u8 iommu_cntr;
			u16 padding;
			u64 conf;
			u64 conf1;
		};
	};
	struct task_struct *target;
	void *addr_filters;
	long unsigned int addr_filters_gen;
	int state;
	local64_t prev_count;
	u64 sample_period;
	union {
		struct {
			u64 last_period;
			local64_t period_left;
		};
		struct {
			u64 saved_metric;
			u64 saved_slots;
		};
	};
	u64 interrupts_seq;
	u64 interrupts;
	u64 freq_time_stamp;
	u64 freq_count_stamp;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

struct rcuwait {
	struct task_struct *task;
};

struct irq_work {
	struct __call_single_node node;
	void (*func)(struct irq_work *);
	struct rcuwait irqwait;
};

struct perf_addr_filters_head {
	struct list_head list;
	raw_spinlock_t lock;
	unsigned int nr_file_filters;
};

struct perf_sample_data;

typedef void (*perf_overflow_handler_t)(struct perf_event *, struct perf_sample_data *, struct pt_regs *);

struct ftrace_ops;

struct ftrace_regs;

typedef void (*ftrace_func_t)(long unsigned int, long unsigned int, struct ftrace_ops *, struct ftrace_regs *);

struct ftrace_hash;

struct ftrace_ops_hash {
	struct ftrace_hash *notrace_hash;
	struct ftrace_hash *filter_hash;
	struct mutex regex_lock;
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

typedef int (*ftrace_ops_func_t)(struct ftrace_ops *, enum ftrace_ops_cmd);

struct ftrace_ops {
	ftrace_func_t func;
	struct ftrace_ops *next;
	long unsigned int flags;
	void *private;
	ftrace_func_t saved_func;
	struct ftrace_ops_hash local_hash;
	struct ftrace_ops_hash *func_hash;
	struct ftrace_ops_hash old_hash;
	long unsigned int trampoline;
	long unsigned int trampoline_size;
	struct list_head list;
	ftrace_ops_func_t ops_func;
	long unsigned int direct_call;
};

struct pmu;

struct perf_event_pmu_context;

struct perf_buffer;

struct fasync_struct;

struct perf_addr_filter_range;

struct pid_namespace;

struct bpf_prog;

struct trace_event_call;

struct event_filter;

struct perf_cgroup;

struct perf_event {
	struct list_head event_entry;
	struct list_head sibling_list;
	struct list_head active_list;
	struct rb_node group_node;
	u64 group_index;
	struct list_head migrate_entry;
	struct hlist_node hlist_entry;
	struct list_head active_entry;
	int nr_siblings;
	int event_caps;
	int group_caps;
	unsigned int group_generation;
	struct perf_event *group_leader;
	struct pmu *pmu;
	void *pmu_private;
	enum perf_event_state state;
	unsigned int attach_state;
	local64_t count;
	atomic64_t child_count;
	u64 total_time_enabled;
	u64 total_time_running;
	u64 tstamp;
	struct perf_event_attr attr;
	u16 header_size;
	u16 id_header_size;
	u16 read_size;
	struct hw_perf_event hw;
	struct perf_event_context *ctx;
	struct perf_event_pmu_context *pmu_ctx;
	atomic_long_t refcount;
	atomic64_t child_total_time_enabled;
	atomic64_t child_total_time_running;
	struct mutex child_mutex;
	struct list_head child_list;
	struct perf_event *parent;
	int oncpu;
	int cpu;
	struct list_head owner_entry;
	struct task_struct *owner;
	struct mutex mmap_mutex;
	atomic_t mmap_count;
	struct perf_buffer *rb;
	struct list_head rb_entry;
	long unsigned int rcu_batches;
	int rcu_pending;
	wait_queue_head_t waitq;
	struct fasync_struct *fasync;
	unsigned int pending_wakeup;
	unsigned int pending_kill;
	unsigned int pending_disable;
	unsigned int pending_sigtrap;
	long unsigned int pending_addr;
	struct irq_work pending_irq;
	struct callback_head pending_task;
	unsigned int pending_work;
	atomic_t event_limit;
	struct perf_addr_filters_head addr_filters;
	struct perf_addr_filter_range *addr_filter_ranges;
	long unsigned int addr_filters_gen;
	struct perf_event *aux_event;
	void (*destroy)(struct perf_event *);
	struct callback_head callback_head;
	struct pid_namespace *ns;
	u64 id;
	atomic64_t lost_samples;
	u64 (*clock)();
	perf_overflow_handler_t overflow_handler;
	void *overflow_handler_context;
	perf_overflow_handler_t orig_overflow_handler;
	struct bpf_prog *prog;
	u64 bpf_cookie;
	struct trace_event_call *tp_event;
	struct event_filter *filter;
	struct ftrace_ops ftrace_ops;
	struct perf_cgroup *cgrp;
	void *security;
	struct list_head sb_list;
	__u32 orig_type;
};

typedef void (*smp_call_func_t)(void *);

typedef bool (*smp_cond_func_t)(int, void *);

typedef struct {
	arch_rwlock_t raw_lock;
	unsigned int magic;
	unsigned int owner_cpu;
	void *owner;
	struct lockdep_map dep_map;
} rwlock_t;

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

struct upid {
	int nr;
	struct pid_namespace *ns;
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
};

struct idr {
	struct xarray idr_rt;
	unsigned int idr_base;
	unsigned int idr_next;
};

struct proc_ns_operations;

struct ns_common {
	atomic_long_t stashed;
	const struct proc_ns_operations *ops;
	unsigned int inum;
	refcount_t count;
};

struct kmem_cache;

struct fs_pin;

struct user_namespace;

struct ucounts;

struct pid_namespace {
	struct idr idr;
	struct callback_head rcu;
	unsigned int pid_allocated;
	struct task_struct *child_reaper;
	struct kmem_cache *pid_cachep;
	unsigned int level;
	struct pid_namespace *parent;
	struct fs_pin *bacct;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	int reboot;
	struct ns_common ns;
	int memfd_noexec_scope;
};

struct pid {
	refcount_t count;
	unsigned int level;
	spinlock_t lock;
	struct hlist_head tasks[4];
	struct hlist_head inodes;
	wait_queue_head_t wait_pidfd;
	struct callback_head rcu;
	struct upid numbers[0];
};

struct uid_gid_extent {
	u32 first;
	u32 lower_first;
	u32 count;
};

struct uid_gid_map {
	u32 nr_extents;
	union {
		struct uid_gid_extent extent[5];
		struct {
			struct uid_gid_extent *forward;
			struct uid_gid_extent *reverse;
		};
	};
};

typedef struct {
	gid_t val;
} kgid_t;

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
	void *magic;
	struct lockdep_map dep_map;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
	struct lockdep_map lockdep_map;
};

struct ctl_table;

struct ctl_table_root;

struct ctl_table_set;

struct ctl_dir;

struct ctl_node;

struct ctl_table_header {
	union {
		struct {
			struct ctl_table *ctl_table;
			int ctl_table_size;
			int used;
			int count;
			int nreg;
		};
		struct callback_head rcu;
	};
	struct completion *unregistering;
	struct ctl_table *ctl_table_arg;
	struct ctl_table_root *root;
	struct ctl_table_set *set;
	struct ctl_dir *parent;
	struct ctl_node *node;
	struct hlist_head inodes;
};

struct ctl_dir {
	struct ctl_table_header header;
	struct rb_root root;
};

struct ctl_table_set {
	int (*is_seen)(struct ctl_table_set *);
	struct ctl_dir dir;
};

struct binfmt_misc;

struct user_namespace {
	struct uid_gid_map uid_map;
	struct uid_gid_map gid_map;
	struct uid_gid_map projid_map;
	struct user_namespace *parent;
	int level;
	kuid_t owner;
	kgid_t group;
	struct ns_common ns;
	long unsigned int flags;
	bool parent_could_setfcap;
	struct list_head keyring_name_list;
	struct key *user_keyring_register;
	struct rw_semaphore keyring_sem;
	struct work_struct work;
	struct ctl_table_set set;
	struct ctl_table_header *sysctls;
	struct ucounts *ucounts;
	long int ucount_max[10];
	long int rlimit_max[4];
	struct binfmt_misc *binfmt_misc;
};

struct workqueue_struct;

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct seqcount_raw_spinlock {
	seqcount_t seqcount;
	raw_spinlock_t *lock;
};

typedef struct seqcount_raw_spinlock seqcount_raw_spinlock_t;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

struct hrtimer_cpu_base;

struct hrtimer_clock_base {
	struct hrtimer_cpu_base *cpu_base;
	unsigned int index;
	clockid_t clockid;
	seqcount_raw_spinlock_t seq;
	struct hrtimer *running;
	struct timerqueue_head active;
	ktime_t (*get_time)();
	ktime_t offset;
	long: 64;
	long: 64;
};

struct hrtimer_cpu_base {
	raw_spinlock_t lock;
	unsigned int cpu;
	unsigned int active_bases;
	unsigned int clock_was_set_seq;
	unsigned int hres_active: 1;
	unsigned int in_hrtirq: 1;
	unsigned int hang_detected: 1;
	unsigned int softirq_activated: 1;
	unsigned int nr_events;
	short unsigned int nr_retries;
	short unsigned int nr_hangs;
	unsigned int max_hang_time;
	ktime_t expires_next;
	struct hrtimer *next_timer;
	ktime_t softirq_expires_next;
	struct hrtimer *softirq_next_timer;
	struct hrtimer_clock_base clock_base[8];
};

struct rlimit {
	__kernel_ulong_t rlim_cur;
	__kernel_ulong_t rlim_max;
};

struct task_cputime {
	u64 stime;
	u64 utime;
	long long unsigned int sum_exec_runtime;
};

typedef void __signalfn_t(int);

typedef __signalfn_t *__sighandler_t;

typedef void __restorefn_t();

typedef __restorefn_t *__sigrestore_t;

union sigval {
	int sival_int;
	void *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void *_lower;
				void *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long int _band;
		int _fd;
	} _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct kernel_siginfo {
	struct {
		int si_signo;
		int si_errno;
		int si_code;
		union __sifields _sifields;
	};
};

struct ucounts {
	struct hlist_node node;
	struct user_namespace *ns;
	kuid_t uid;
	atomic_t count;
	atomic_long_t ucount[10];
	atomic_long_t rlimit[4];
};

struct sigaction {
	__sighandler_t sa_handler;
	long unsigned int sa_flags;
	__sigrestore_t sa_restorer;
	sigset_t sa_mask;
};

struct k_sigaction {
	struct sigaction sa;
};

struct cpu_itimer {
	u64 expires;
	u64 incr;
};

struct task_cputime_atomic {
	atomic64_t utime;
	atomic64_t stime;
	atomic64_t sum_exec_runtime;
};

struct thread_group_cputimer {
	struct task_cputime_atomic cputime_atomic;
};

struct pacct_struct {
	int ac_flag;
	long int ac_exitcode;
	long unsigned int ac_mem;
	u64 ac_utime;
	u64 ac_stime;
	long unsigned int ac_minflt;
	long unsigned int ac_majflt;
};

struct core_state;

struct tty_struct;

struct taskstats;

struct tty_audit_buf;

struct signal_struct {
	refcount_t sigcnt;
	atomic_t live;
	int nr_threads;
	int quick_threads;
	struct list_head thread_head;
	wait_queue_head_t wait_chldexit;
	struct task_struct *curr_target;
	struct sigpending shared_pending;
	struct hlist_head multiprocess;
	int group_exit_code;
	int notify_count;
	struct task_struct *group_exec_task;
	int group_stop_count;
	unsigned int flags;
	struct core_state *core_state;
	unsigned int is_child_subreaper: 1;
	unsigned int has_child_subreaper: 1;
	unsigned int next_posix_timer_id;
	struct list_head posix_timers;
	struct hrtimer real_timer;
	ktime_t it_real_incr;
	struct cpu_itimer it[2];
	struct thread_group_cputimer cputimer;
	struct posix_cputimers posix_cputimers;
	struct pid *pids[4];
	struct pid *tty_old_pgrp;
	int leader;
	struct tty_struct *tty;
	seqlock_t stats_lock;
	u64 utime;
	u64 stime;
	u64 cutime;
	u64 cstime;
	u64 gtime;
	u64 cgtime;
	struct prev_cputime prev_cputime;
	long unsigned int nvcsw;
	long unsigned int nivcsw;
	long unsigned int cnvcsw;
	long unsigned int cnivcsw;
	long unsigned int min_flt;
	long unsigned int maj_flt;
	long unsigned int cmin_flt;
	long unsigned int cmaj_flt;
	long unsigned int inblock;
	long unsigned int oublock;
	long unsigned int cinblock;
	long unsigned int coublock;
	long unsigned int maxrss;
	long unsigned int cmaxrss;
	struct task_io_accounting ioac;
	long long unsigned int sum_sched_runtime;
	struct rlimit rlim[16];
	struct pacct_struct pacct;
	struct taskstats *stats;
	unsigned int audit_tty;
	struct tty_audit_buf *tty_audit_buf;
	bool oom_flag_origin;
	short int oom_score_adj;
	short int oom_score_adj_min;
	struct mm_struct *oom_mm;
	struct mutex cred_guard_mutex;
	struct rw_semaphore exec_update_lock;
};

struct rseq {
	__u32 cpu_id_start;
	__u32 cpu_id;
	__u64 rseq_cs;
	__u32 flags;
	__u32 node_id;
	__u32 mm_cid;
	char end[0];
};

struct rq;

struct rq_flags;

struct affinity_context;

struct sched_class {
	void (*enqueue_task)(struct rq *, struct task_struct *, int);
	void (*dequeue_task)(struct rq *, struct task_struct *, int);
	void (*yield_task)(struct rq *);
	bool (*yield_to_task)(struct rq *, struct task_struct *);
	void (*wakeup_preempt)(struct rq *, struct task_struct *, int);
	struct task_struct * (*pick_next_task)(struct rq *);
	void (*put_prev_task)(struct rq *, struct task_struct *);
	void (*set_next_task)(struct rq *, struct task_struct *, bool);
	int (*balance)(struct rq *, struct task_struct *, struct rq_flags *);
	int (*select_task_rq)(struct task_struct *, int, int);
	struct task_struct * (*pick_task)(struct rq *);
	void (*migrate_task_rq)(struct task_struct *, int);
	void (*task_woken)(struct rq *, struct task_struct *);
	void (*set_cpus_allowed)(struct task_struct *, struct affinity_context *);
	void (*rq_online)(struct rq *);
	void (*rq_offline)(struct rq *);
	struct rq * (*find_lock_rq)(struct task_struct *, struct rq *);
	void (*task_tick)(struct rq *, struct task_struct *, int);
	void (*task_fork)(struct task_struct *);
	void (*task_dead)(struct task_struct *);
	void (*switched_from)(struct rq *, struct task_struct *);
	void (*switched_to)(struct rq *, struct task_struct *);
	void (*prio_changed)(struct rq *, struct task_struct *, int);
	unsigned int (*get_rr_interval)(struct rq *, struct task_struct *);
	void (*update_curr)(struct rq *);
	void (*task_change_group)(struct task_struct *);
};

typedef struct lockdep_map *lockdep_map_p;

struct maple_tree {
	union {
		spinlock_t ma_lock;
		lockdep_map_p ma_external_lock;
	};
	unsigned int ma_flags;
	void *ma_root;
};

struct percpu_counter {
	raw_spinlock_t lock;
	s64 count;
	struct list_head list;
	s32 *counters;
};

struct ldt_struct;

struct vdso_image;

typedef struct {
	u64 ctx_id;
	atomic64_t tlb_gen;
	struct rw_semaphore ldt_usr_sem;
	struct ldt_struct *ldt;
	long unsigned int flags;
	struct mutex lock;
	void *vdso;
	const struct vdso_image *vdso_image;
	atomic_t perf_rdpmc_allowed;
	u16 pkey_allocation_map;
	s16 execute_only_pkey;
} mm_context_t;

struct xol_area;

struct uprobes_state {
	struct xol_area *xol_area;
};

struct mm_cid;

struct linux_binfmt;

struct kioctx_table;

struct mm_struct {
	struct {
		struct {
			atomic_t mm_count;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
			long: 64;
		};
		struct maple_tree mm_mt;
		long unsigned int (*get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
		long unsigned int mmap_base;
		long unsigned int mmap_legacy_base;
		long unsigned int task_size;
		pgd_t *pgd;
		atomic_t membarrier_state;
		atomic_t mm_users;
		struct mm_cid *pcpu_cid;
		long unsigned int mm_cid_next_scan;
		atomic_long_t pgtables_bytes;
		int map_count;
		spinlock_t page_table_lock;
		struct rw_semaphore mmap_lock;
		struct list_head mmlist;
		int mm_lock_seq;
		long unsigned int hiwater_rss;
		long unsigned int hiwater_vm;
		long unsigned int total_vm;
		long unsigned int locked_vm;
		atomic64_t pinned_vm;
		long unsigned int data_vm;
		long unsigned int exec_vm;
		long unsigned int stack_vm;
		long unsigned int def_flags;
		seqcount_t write_protect_seq;
		spinlock_t arg_lock;
		long unsigned int start_code;
		long unsigned int end_code;
		long unsigned int start_data;
		long unsigned int end_data;
		long unsigned int start_brk;
		long unsigned int brk;
		long unsigned int start_stack;
		long unsigned int arg_start;
		long unsigned int arg_end;
		long unsigned int env_start;
		long unsigned int env_end;
		long unsigned int saved_auxv[50];
		struct percpu_counter rss_stat[4];
		struct linux_binfmt *binfmt;
		mm_context_t context;
		long unsigned int flags;
		spinlock_t ioctx_lock;
		struct kioctx_table *ioctx_table;
		struct task_struct *owner;
		struct user_namespace *user_ns;
		struct file *exe_file;
		long unsigned int numa_next_scan;
		long unsigned int numa_scan_offset;
		int numa_scan_seq;
		atomic_t tlb_flush_pending;
		atomic_t tlb_flush_batched;
		struct uprobes_state uprobes_state;
		atomic_long_t hugetlb_usage;
		struct work_struct async_put_work;
		long unsigned int ksm_merging_pages;
		long unsigned int ksm_rmap_items;
		long unsigned int ksm_zero_pages;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	long unsigned int cpu_bitmap[0];
};

typedef u32 errseq_t;

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	struct rb_root_cached i_mmap;
	long unsigned int nrpages;
	long unsigned int writeback_index;
	const struct address_space_operations *a_ops;
	long unsigned int flags;
	struct rw_semaphore i_mmap_rwsem;
	errseq_t wb_err;
	spinlock_t private_lock;
	struct list_head private_list;
	void *private_data;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

typedef struct {
	u64 val;
} kernel_cap_t;

struct user_struct;

struct group_info;

struct cred {
	atomic_t usage;
	atomic_t subscribers;
	void *put_addr;
	unsigned int magic;
	kuid_t uid;
	kgid_t gid;
	kuid_t suid;
	kgid_t sgid;
	kuid_t euid;
	kgid_t egid;
	kuid_t fsuid;
	kgid_t fsgid;
	unsigned int securebits;
	kernel_cap_t cap_inheritable;
	kernel_cap_t cap_permitted;
	kernel_cap_t cap_effective;
	kernel_cap_t cap_bset;
	kernel_cap_t cap_ambient;
	unsigned char jit_keyring;
	struct key *session_keyring;
	struct key *process_keyring;
	struct key *thread_keyring;
	struct key *request_key_auth;
	void *security;
	struct user_struct *user;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct group_info *group_info;
	union {
		int non_rcu;
		struct callback_head rcu;
	};
};

typedef int32_t key_serial_t;

typedef uint32_t key_perm_t;

struct key_type;

struct key_tag;

struct keyring_index_key {
	long unsigned int hash;
	union {
		struct {
			u16 desc_len;
			char desc[6];
		};
		long unsigned int x;
	};
	struct key_type *type;
	struct key_tag *domain_tag;
	const char *description;
};

union key_payload {
	void *rcu_data0;
	void *data[4];
};

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	long unsigned int nr_leaves_on_tree;
};

struct key_user;

struct key_restriction;

struct key {
	refcount_t usage;
	key_serial_t serial;
	union {
		struct list_head graveyard_link;
		struct rb_node serial_node;
	};
	struct rw_semaphore sem;
	struct key_user *user;
	void *security;
	union {
		time64_t expiry;
		time64_t revoked_at;
	};
	time64_t last_used_at;
	kuid_t uid;
	kgid_t gid;
	key_perm_t perm;
	short unsigned int quotalen;
	short unsigned int datalen;
	short int state;
	long unsigned int flags;
	union {
		struct keyring_index_key index_key;
		struct {
			long unsigned int hash;
			long unsigned int len_desc;
			struct key_type *type;
			struct key_tag *domain_tag;
			char *description;
		};
	};
	union {
		union key_payload payload;
		struct {
			struct list_head name_link;
			struct assoc_array keys;
		};
	};
	struct key_restriction *restrict_link;
};

struct uts_namespace;

struct ipc_namespace;

struct mnt_namespace;

struct net;

struct time_namespace;

struct cgroup_namespace;

struct nsproxy {
	refcount_t count;
	struct uts_namespace *uts_ns;
	struct ipc_namespace *ipc_ns;
	struct mnt_namespace *mnt_ns;
	struct pid_namespace *pid_ns_for_children;
	struct net *net_ns;
	struct time_namespace *time_ns;
	struct time_namespace *time_ns_for_children;
	struct cgroup_namespace *cgroup_ns;
};

struct sighand_struct {
	spinlock_t siglock;
	refcount_t count;
	wait_queue_head_t signalfd_wqh;
	struct k_sigaction action[64];
};

struct io_context {
	atomic_long_t refcount;
	atomic_t active_ref;
	short unsigned int ioprio;
};

struct cgroup_subsys_state;

struct cgroup;

struct css_set {
	struct cgroup_subsys_state *subsys[10];
	refcount_t refcount;
	struct css_set *dom_cset;
	struct cgroup *dfl_cgrp;
	int nr_tasks;
	struct list_head tasks;
	struct list_head mg_tasks;
	struct list_head dying_tasks;
	struct list_head task_iters;
	struct list_head e_cset_node[10];
	struct list_head threaded_csets;
	struct list_head threaded_csets_node;
	struct hlist_node hlist;
	struct list_head cgrp_links;
	struct list_head mg_src_preload_node;
	struct list_head mg_dst_preload_node;
	struct list_head mg_node;
	struct cgroup *mg_src_cgrp;
	struct cgroup *mg_dst_cgrp;
	struct css_set *mg_dst_cset;
	bool dead;
	struct callback_head callback_head;
};

struct perf_event_groups {
	struct rb_root tree;
	u64 index;
};

struct perf_event_context {
	raw_spinlock_t lock;
	struct mutex mutex;
	struct list_head pmu_ctx_list;
	struct perf_event_groups pinned_groups;
	struct perf_event_groups flexible_groups;
	struct list_head event_list;
	int nr_events;
	int nr_user;
	int is_active;
	int nr_task_data;
	int nr_stat;
	int nr_freq;
	int rotate_disable;
	refcount_t refcount;
	struct task_struct *task;
	u64 time;
	u64 timestamp;
	u64 timeoffset;
	struct perf_event_context *parent_ctx;
	u64 parent_gen;
	u64 generation;
	int pin_count;
	int nr_cgroups;
	struct callback_head callback_head;
	local_t nr_pending;
};

struct ftrace_ret_stack {
	long unsigned int ret;
	long unsigned int func;
	long long unsigned int calltime;
	long unsigned int *retp;
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

struct arch_uprobe_task {
	long unsigned int saved_scratch_register;
	unsigned int saved_trap_nr;
	unsigned int saved_tf;
};

struct uprobe;

struct return_instance;

struct uprobe_task {
	enum uprobe_task_state state;
	union {
		struct {
			struct arch_uprobe_task autask;
			long unsigned int vaddr;
		};
		struct {
			struct callback_head dup_xol_work;
			long unsigned int dup_xol_addr;
		};
	};
	struct uprobe *active_uprobe;
	long unsigned int xol_vaddr;
	struct return_instance *return_instances;
	unsigned int depth;
};

struct vm_struct {
	struct vm_struct *next;
	void *addr;
	long unsigned int size;
	long unsigned int flags;
	struct page **pages;
	unsigned int page_order;
	unsigned int nr_pages;
	phys_addr_t phys_addr;
	const void *caller;
};

struct kref {
	refcount_t refcount;
};

struct rcu_segcblist {
	struct callback_head *head;
	struct callback_head **tails[4];
	long unsigned int gp_seq[4];
	long int len;
	long int seglen[4];
	u8 flags;
};

struct srcu_node;

struct srcu_struct;

struct srcu_data {
	atomic_long_t srcu_lock_count[2];
	atomic_long_t srcu_unlock_count[2];
	int srcu_nmi_safety;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t lock;
	struct rcu_segcblist srcu_cblist;
	long unsigned int srcu_gp_seq_needed;
	long unsigned int srcu_gp_seq_needed_exp;
	bool srcu_cblist_invoking;
	struct timer_list delay_work;
	struct work_struct work;
	struct callback_head srcu_barrier_head;
	struct srcu_node *mynode;
	long unsigned int grpmask;
	int cpu;
	struct srcu_struct *ssp;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct srcu_node {
	spinlock_t lock;
	long unsigned int srcu_have_cbs[4];
	long unsigned int srcu_data_have_cbs[4];
	long unsigned int srcu_gp_seq_needed_exp;
	struct srcu_node *srcu_parent;
	int grplo;
	int grphi;
};

struct srcu_usage;

struct srcu_struct {
	unsigned int srcu_idx;
	struct srcu_data *sda;
	struct lockdep_map dep_map;
	struct srcu_usage *srcu_sup;
};

struct srcu_usage {
	struct srcu_node *node;
	struct srcu_node *level[3];
	int srcu_size_state;
	struct mutex srcu_cb_mutex;
	spinlock_t lock;
	struct mutex srcu_gp_mutex;
	long unsigned int srcu_gp_seq;
	long unsigned int srcu_gp_seq_needed;
	long unsigned int srcu_gp_seq_needed_exp;
	long unsigned int srcu_gp_start;
	long unsigned int srcu_last_gp_end;
	long unsigned int srcu_size_jiffies;
	long unsigned int srcu_n_lock_retries;
	long unsigned int srcu_n_exp_nodelay;
	bool sda_is_static;
	long unsigned int srcu_barrier_seq;
	struct mutex srcu_barrier_mutex;
	struct completion srcu_barrier_completion;
	atomic_t srcu_barrier_cpu_cnt;
	long unsigned int reschedule_jiffies;
	long unsigned int reschedule_count;
	struct delayed_work work;
	struct srcu_struct *srcu_ssp;
};

struct return_instance {
	struct uprobe *uprobe;
	long unsigned int func;
	long unsigned int stack;
	long unsigned int orig_ret_vaddr;
	bool chained;
	struct return_instance *next;
};

struct ldt_struct {
	struct desc_struct *entries;
	unsigned int nr_entries;
	int slot;
};

struct vdso_image {
	void *data;
	long unsigned int size;
	long unsigned int alt;
	long unsigned int alt_len;
	long unsigned int extable_base;
	long unsigned int extable_len;
	const void *extable;
	long int sym_vvar_start;
	long int sym_vvar_page;
	long int sym_pvclock_page;
	long int sym_hvclock_page;
	long int sym_timens_page;
	long int sym_VDSO32_NOTE_MASK;
	long int sym___kernel_sigreturn;
	long int sym___kernel_rt_sigreturn;
	long int sym___kernel_vsyscall;
	long int sym_int80_landing_pad;
	long int sym_vdso32_sigreturn_landing_pad;
	long int sym_vdso32_rt_sigreturn_landing_pad;
};

struct vmem_altmap {
	long unsigned int base_pfn;
	const long unsigned int end_pfn;
	const long unsigned int reserve;
	long unsigned int free;
	long unsigned int align;
	long unsigned int alloc;
};

struct percpu_ref_data;

struct percpu_ref {
	long unsigned int percpu_count_ptr;
	struct percpu_ref_data *data;
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

struct dev_pagemap_ops;

struct dev_pagemap {
	struct vmem_altmap altmap;
	struct percpu_ref ref;
	struct completion done;
	enum memory_type type;
	unsigned int flags;
	long unsigned int vmemmap_shift;
	const struct dev_pagemap_ops *ops;
	void *owner;
	int nr_range;
	union {
		struct range range;
		struct {
			struct {} __empty_ranges;
			struct range ranges[0];
		};
	};
};

typedef struct {
	long unsigned int val;
} swp_entry_t;

struct folio {
	union {
		struct {
			long unsigned int flags;
			union {
				struct list_head lru;
				struct {
					void *__filler;
					unsigned int mlock_count;
				};
			};
			struct address_space *mapping;
			long unsigned int index;
			union {
				void *private;
				swp_entry_t swap;
			};
			atomic_t _mapcount;
			atomic_t _refcount;
			long unsigned int memcg_data;
		};
		struct page page;
	};
	union {
		struct {
			long unsigned int _flags_1;
			long unsigned int _head_1;
			long unsigned int _folio_avail;
			atomic_t _entire_mapcount;
			atomic_t _nr_pages_mapped;
			atomic_t _pincount;
			unsigned int _folio_nr_pages;
		};
		struct page __page_1;
	};
	union {
		struct {
			long unsigned int _flags_2;
			long unsigned int _head_2;
			void *_hugetlb_subpool;
			void *_hugetlb_cgroup;
			void *_hugetlb_cgroup_rsvd;
			void *_hugetlb_hwpoison;
		};
		struct {
			long unsigned int _flags_2a;
			long unsigned int _head_2a;
			struct list_head _deferred_list;
		};
		struct page __page_2;
	};
};

typedef long unsigned int vm_flags_t;

struct fown_struct {
	rwlock_t lock;
	struct pid *pid;
	enum pid_type pid_type;
	kuid_t uid;
	kuid_t euid;
	int signum;
};

struct file_ra_state {
	long unsigned int start;
	unsigned int size;
	unsigned int async_size;
	unsigned int ra_pages;
	unsigned int mmap_miss;
	loff_t prev_pos;
};

struct vfsmount;

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};

struct file {
	union {
		struct llist_node f_llist;
		struct callback_head f_rcuhead;
		unsigned int f_iocb_flags;
	};
	spinlock_t f_lock;
	fmode_t f_mode;
	atomic_long_t f_count;
	struct mutex f_pos_lock;
	loff_t f_pos;
	unsigned int f_flags;
	struct fown_struct f_owner;
	const struct cred *f_cred;
	struct file_ra_state f_ra;
	struct path f_path;
	struct inode *f_inode;
	const struct file_operations *f_op;
	u64 f_version;
	void *f_security;
	void *private_data;
	struct hlist_head *f_ep;
	struct address_space *f_mapping;
	errseq_t f_wb_err;
	errseq_t f_sb_err;
};

struct userfaultfd_ctx;

struct vm_userfaultfd_ctx {
	struct userfaultfd_ctx *ctx;
};

struct vma_lock {
	struct rw_semaphore lock;
};

struct vma_numab_state {
	long unsigned int next_scan;
	long unsigned int pids_active_reset;
	long unsigned int pids_active[2];
	int prev_scan_seq;
};

struct anon_vma;

struct vm_operations_struct;

struct vm_area_struct {
	union {
		struct {
			long unsigned int vm_start;
			long unsigned int vm_end;
		};
		struct callback_head vm_rcu;
	};
	struct mm_struct *vm_mm;
	pgprot_t vm_page_prot;
	union {
		const vm_flags_t vm_flags;
		vm_flags_t __vm_flags;
	};
	int vm_lock_seq;
	struct vma_lock *vm_lock;
	bool detached;
	struct {
		struct rb_node rb;
		long unsigned int rb_subtree_last;
	} shared;
	struct list_head anon_vma_chain;
	struct anon_vma *anon_vma;
	const struct vm_operations_struct *vm_ops;
	long unsigned int vm_pgoff;
	struct file *vm_file;
	void *vm_private_data;
	atomic_long_t swap_readahead_info;
	struct mempolicy *vm_policy;
	struct vma_numab_state *numab_state;
	struct vm_userfaultfd_ctx vm_userfaultfd_ctx;
};

typedef unsigned int vm_fault_t;

struct vm_fault;

struct vm_operations_struct {
	void (*open)(struct vm_area_struct *);
	void (*close)(struct vm_area_struct *);
	int (*may_split)(struct vm_area_struct *, long unsigned int);
	int (*mremap)(struct vm_area_struct *);
	int (*mprotect)(struct vm_area_struct *, long unsigned int, long unsigned int, long unsigned int);
	vm_fault_t (*fault)(struct vm_fault *);
	vm_fault_t (*huge_fault)(struct vm_fault *, unsigned int);
	vm_fault_t (*map_pages)(struct vm_fault *, long unsigned int, long unsigned int);
	long unsigned int (*pagesize)(struct vm_area_struct *);
	vm_fault_t (*page_mkwrite)(struct vm_fault *);
	vm_fault_t (*pfn_mkwrite)(struct vm_fault *);
	int (*access)(struct vm_area_struct *, long unsigned int, void *, int, int);
	const char * (*name)(struct vm_area_struct *);
	int (*set_policy)(struct vm_area_struct *, struct mempolicy *);
	struct mempolicy * (*get_policy)(struct vm_area_struct *, long unsigned int);
	struct page * (*find_special_page)(struct vm_area_struct *, long unsigned int);
};

struct mm_cid {
	u64 time;
	int cid;
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

struct vm_fault {
	const struct {
		struct vm_area_struct *vma;
		gfp_t gfp_mask;
		long unsigned int pgoff;
		long unsigned int address;
		long unsigned int real_address;
	};
	enum fault_flag flags;
	pmd_t *pmd;
	pud_t *pud;
	union {
		pte_t orig_pte;
		pmd_t orig_pmd;
	};
	struct page *cow_page;
	struct page *page;
	pte_t *pte;
	spinlock_t *ptl;
	pgtable_t prealloc_pte;
};

struct exception_table_entry {
	int insn;
	int fixup;
	int data;
};

struct cgroup_subsys;

struct cgroup_subsys_state {
	struct cgroup *cgroup;
	struct cgroup_subsys *ss;
	struct percpu_ref refcnt;
	struct list_head sibling;
	struct list_head children;
	struct list_head rstat_css_node;
	int id;
	unsigned int flags;
	u64 serial_nr;
	atomic_t online_cnt;
	struct work_struct destroy_work;
	struct rcu_work destroy_rwork;
	struct cgroup_subsys_state *parent;
};

struct kernfs_node;

struct cgroup_file {
	struct kernfs_node *kn;
	long unsigned int notified_at;
	struct timer_list notify_timer;
};

struct cgroup_base_stat {
	struct task_cputime cputime;
};

struct bpf_prog_array;

struct cgroup_bpf {
	struct bpf_prog_array *effective[38];
	struct hlist_head progs[38];
	u8 flags[38];
	struct list_head storages;
	struct bpf_prog_array *inactive;
	struct percpu_ref refcnt;
	struct work_struct release_work;
};

struct cgroup_freezer_state {
	bool freeze;
	int e_freeze;
	int nr_frozen_descendants;
	int nr_frozen_tasks;
};

struct cgroup_root;

struct cgroup_rstat_cpu;

struct psi_group;

struct cgroup {
	struct cgroup_subsys_state self;
	long unsigned int flags;
	int level;
	int max_depth;
	int nr_descendants;
	int nr_dying_descendants;
	int max_descendants;
	int nr_populated_csets;
	int nr_populated_domain_children;
	int nr_populated_threaded_children;
	int nr_threaded_children;
	struct kernfs_node *kn;
	struct cgroup_file procs_file;
	struct cgroup_file events_file;
	struct cgroup_file psi_files[0];
	u16 subtree_control;
	u16 subtree_ss_mask;
	u16 old_subtree_control;
	u16 old_subtree_ss_mask;
	struct cgroup_subsys_state *subsys[10];
	struct cgroup_root *root;
	struct list_head cset_links;
	struct list_head e_csets[10];
	struct cgroup *dom_cgrp;
	struct cgroup *old_dom_cgrp;
	struct cgroup_rstat_cpu *rstat_cpu;
	struct list_head rstat_css_list;
	struct cgroup_base_stat last_bstat;
	struct cgroup_base_stat bstat;
	struct prev_cputime prev_cputime;
	struct list_head pidlists;
	struct mutex pidlist_mutex;
	wait_queue_head_t offline_waitq;
	struct work_struct release_agent_work;
	struct psi_group *psi;
	struct cgroup_bpf bpf;
	atomic_t congestion_count;
	struct cgroup_freezer_state freezer;
	struct bpf_local_storage *bpf_cgrp_storage;
	struct cgroup *ancestors[0];
};

typedef int proc_handler(struct ctl_table *, int, void *, size_t *, loff_t *);

struct ctl_table_poll;

struct ctl_table {
	const char *procname;
	void *data;
	int maxlen;
	umode_t mode;
	enum {
		SYSCTL_TABLE_TYPE_DEFAULT = 0,
		SYSCTL_TABLE_TYPE_PERMANENTLY_EMPTY = 1,
	} type;
	proc_handler *proc_handler;
	struct ctl_table_poll *poll;
	void *extra1;
	void *extra2;
};

struct ctl_table_poll {
	atomic_t event;
	wait_queue_head_t wait;
};

struct ctl_node {
	struct rb_node node;
	struct ctl_table_header *header;
};

struct ctl_table_root {
	struct ctl_table_set default_set;
	struct ctl_table_set * (*lookup)(struct ctl_table_root *);
	void (*set_ownership)(struct ctl_table_header *, struct ctl_table *, kuid_t *, kgid_t *);
	int (*permissions)(struct ctl_table_header *, struct ctl_table *);
};

struct key_tag {
	struct callback_head rcu;
	refcount_t usage;
	bool removed;
};

typedef int (*request_key_actor_t)(struct key *, void *);

struct key_preparsed_payload;

struct key_match_data;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct key_type {
	const char *name;
	size_t def_datalen;
	unsigned int flags;
	int (*vet_description)(const char *);
	int (*preparse)(struct key_preparsed_payload *);
	void (*free_preparse)(struct key_preparsed_payload *);
	int (*instantiate)(struct key *, struct key_preparsed_payload *);
	int (*update)(struct key *, struct key_preparsed_payload *);
	int (*match_preparse)(struct key_match_data *);
	void (*match_free)(struct key_match_data *);
	void (*revoke)(struct key *);
	void (*destroy)(struct key *);
	void (*describe)(const struct key *, struct seq_file *);
	long int (*read)(const struct key *, char *, size_t);
	request_key_actor_t request_key;
	struct key_restriction * (*lookup_restriction)(const char *);
	int (*asym_query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*asym_eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*asym_verify_signature)(struct kernel_pkey_params *, const void *, const void *);
	struct list_head link;
	struct lock_class_key lock_class;
};

typedef int (*key_restrict_link_func_t)(struct key *, const struct key_type *, const union key_payload *, struct key *);

struct key_restriction {
	key_restrict_link_func_t check;
	struct key *key;
	struct key_type *keytype;
};

struct user_struct {
	refcount_t __count;
	struct percpu_counter epoll_watches;
	long unsigned int unix_inflight;
	atomic_long_t pipe_bufs;
	struct hlist_node uidhash_node;
	kuid_t uid;
	atomic_long_t locked_vm;
	struct ratelimit_state ratelimit;
};

struct group_info {
	refcount_t usage;
	int ngroups;
	kgid_t gid[0];
};

struct core_thread {
	struct task_struct *task;
	struct core_thread *next;
};

struct core_state {
	atomic_t nr_threads;
	struct core_thread dumper;
	struct completion startup;
};

struct taskstats {
	__u16 version;
	__u32 ac_exitcode;
	__u8 ac_flag;
	__u8 ac_nice;
	__u64 cpu_count;
	__u64 cpu_delay_total;
	__u64 blkio_count;
	__u64 blkio_delay_total;
	__u64 swapin_count;
	__u64 swapin_delay_total;
	__u64 cpu_run_real_total;
	__u64 cpu_run_virtual_total;
	char ac_comm[32];
	__u8 ac_sched;
	__u8 ac_pad[3];
	long: 0;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u64 ac_etime;
	__u64 ac_utime;
	__u64 ac_stime;
	__u64 ac_minflt;
	__u64 ac_majflt;
	__u64 coremem;
	__u64 virtmem;
	__u64 hiwater_rss;
	__u64 hiwater_vm;
	__u64 read_char;
	__u64 write_char;
	__u64 read_syscalls;
	__u64 write_syscalls;
	__u64 read_bytes;
	__u64 write_bytes;
	__u64 cancelled_write_bytes;
	__u64 nvcsw;
	__u64 nivcsw;
	__u64 ac_utimescaled;
	__u64 ac_stimescaled;
	__u64 cpu_scaled_run_real_total;
	__u64 freepages_count;
	__u64 freepages_delay_total;
	__u64 thrashing_count;
	__u64 thrashing_delay_total;
	__u64 ac_btime64;
	__u64 compact_count;
	__u64 compact_delay_total;
	__u32 ac_tgid;
	__u64 ac_tgetime;
	__u64 ac_exe_dev;
	__u64 ac_exe_inode;
	__u64 wpcopy_count;
	__u64 wpcopy_delay_total;
	__u64 irq_count;
	__u64 irq_delay_total;
};

typedef void percpu_ref_func_t(struct percpu_ref *);

struct percpu_ref_data {
	atomic_long_t count;
	percpu_ref_func_t *release;
	percpu_ref_func_t *confirm_switch;
	bool force_atomic: 1;
	bool allow_reinit: 1;
	struct callback_head rcu;
	struct percpu_ref *ref;
};

struct shrink_control {
	gfp_t gfp_mask;
	int nid;
	long unsigned int nr_to_scan;
	long unsigned int nr_scanned;
	struct mem_cgroup *memcg;
};

struct shrinker {
	long unsigned int (*count_objects)(struct shrinker *, struct shrink_control *);
	long unsigned int (*scan_objects)(struct shrinker *, struct shrink_control *);
	long int batch;
	int seeks;
	unsigned int flags;
	struct list_head list;
	int id;
	atomic_long_t *nr_deferred;
};

struct dev_pagemap_ops {
	void (*page_free)(struct page *);
	vm_fault_t (*migrate_to_ram)(struct vm_fault *);
	int (*memory_failure)(struct dev_pagemap *, long unsigned int, long unsigned int, int);
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_DMA = 2,
	KMALLOC_CGROUP = 3,
	NR_KMALLOC_TYPES = 4,
};

struct hlist_bl_node;

struct hlist_bl_head {
	struct hlist_bl_node *first;
};

struct hlist_bl_node {
	struct hlist_bl_node *next;
	struct hlist_bl_node **pprev;
};

struct lockref {
	union {
		struct {
			spinlock_t lock;
			int count;
		};
	};
};

struct qstr {
	union {
		struct {
			u32 hash;
			u32 len;
		};
		u64 hash_len;
	};
	const unsigned char *name;
};

struct dentry_operations;

struct dentry {
	unsigned int d_flags;
	seqcount_spinlock_t d_seq;
	struct hlist_bl_node d_hash;
	struct dentry *d_parent;
	struct qstr d_name;
	struct inode *d_inode;
	unsigned char d_iname[32];
	struct lockref d_lockref;
	const struct dentry_operations *d_op;
	struct super_block *d_sb;
	long unsigned int d_time;
	void *d_fsdata;
	union {
		struct list_head d_lru;
		wait_queue_head_t *d_wait;
	};
	struct list_head d_child;
	struct list_head d_subdirs;
	union {
		struct hlist_node d_alias;
		struct hlist_bl_node d_in_lookup_hash;
		struct callback_head d_rcu;
	} d_u;
};

struct posix_acl;

struct inode_operations;

struct bdi_writeback;

struct file_lock_context;

struct cdev;

struct fsnotify_mark_connector;

struct inode {
	umode_t i_mode;
	short unsigned int i_opflags;
	kuid_t i_uid;
	kgid_t i_gid;
	unsigned int i_flags;
	struct posix_acl *i_acl;
	struct posix_acl *i_default_acl;
	const struct inode_operations *i_op;
	struct super_block *i_sb;
	struct address_space *i_mapping;
	void *i_security;
	long unsigned int i_ino;
	union {
		const unsigned int i_nlink;
		unsigned int __i_nlink;
	};
	dev_t i_rdev;
	loff_t i_size;
	struct timespec64 __i_atime;
	struct timespec64 __i_mtime;
	struct timespec64 __i_ctime;
	spinlock_t i_lock;
	short unsigned int i_bytes;
	u8 i_blkbits;
	u8 i_write_hint;
	blkcnt_t i_blocks;
	long unsigned int i_state;
	struct rw_semaphore i_rwsem;
	long unsigned int dirtied_when;
	long unsigned int dirtied_time_when;
	struct hlist_node i_hash;
	struct list_head i_io_list;
	struct bdi_writeback *i_wb;
	int i_wb_frn_winner;
	u16 i_wb_frn_avg_time;
	u16 i_wb_frn_history;
	struct list_head i_lru;
	struct list_head i_sb_list;
	struct list_head i_wb_list;
	union {
		struct hlist_head i_dentry;
		struct callback_head i_rcu;
	};
	atomic64_t i_version;
	atomic64_t i_sequence;
	atomic_t i_count;
	atomic_t i_dio_count;
	atomic_t i_writecount;
	atomic_t i_readcount;
	union {
		const struct file_operations *i_fop;
		void (*free_inode)(struct inode *);
	};
	struct file_lock_context *i_flctx;
	struct address_space i_data;
	struct list_head i_devices;
	union {
		struct pipe_inode_info *i_pipe;
		struct cdev *i_cdev;
		char *i_link;
		unsigned int i_dir_seq;
	};
	__u32 i_generation;
	__u32 i_fsnotify_mask;
	struct fsnotify_mark_connector *i_fsnotify_marks;
	void *i_private;
};

struct dentry_operations {
	int (*d_revalidate)(struct dentry *, unsigned int);
	int (*d_weak_revalidate)(struct dentry *, unsigned int);
	int (*d_hash)(const struct dentry *, struct qstr *);
	int (*d_compare)(const struct dentry *, unsigned int, const char *, const struct qstr *);
	int (*d_delete)(const struct dentry *);
	int (*d_init)(struct dentry *);
	void (*d_release)(struct dentry *);
	void (*d_prune)(struct dentry *);
	void (*d_iput)(struct dentry *, struct inode *);
	char * (*d_dname)(struct dentry *, char *, int);
	struct vfsmount * (*d_automount)(struct path *);
	int (*d_manage)(const struct path *, bool);
	struct dentry * (*d_real)(struct dentry *, const struct inode *);
	long: 64;
	long: 64;
	long: 64;
};

struct mtd_info;

typedef long long int qsize_t;

struct quota_format_type;

struct mem_dqinfo {
	struct quota_format_type *dqi_format;
	int dqi_fmt_id;
	struct list_head dqi_dirty_list;
	long unsigned int dqi_flags;
	unsigned int dqi_bgrace;
	unsigned int dqi_igrace;
	qsize_t dqi_max_spc_limit;
	qsize_t dqi_max_ino_limit;
	void *dqi_priv;
};

struct quota_format_ops;

struct quota_info {
	unsigned int flags;
	struct rw_semaphore dqio_sem;
	struct inode *files[3];
	struct mem_dqinfo info[3];
	const struct quota_format_ops *ops[3];
};

struct rcu_sync {
	int gp_state;
	int gp_count;
	wait_queue_head_t gp_wait;
	struct callback_head cb_head;
};

struct percpu_rw_semaphore {
	struct rcu_sync rss;
	unsigned int *read_count;
	struct rcuwait writer;
	wait_queue_head_t waiters;
	atomic_t block;
	struct lockdep_map dep_map;
};

struct sb_writers {
	short unsigned int frozen;
	short unsigned int freeze_holders;
	struct percpu_rw_semaphore rw_sem[3];
};

typedef struct {
	__u8 b[16];
} uuid_t;

struct list_lru_node;

struct list_lru {
	struct list_lru_node *node;
	struct list_head list;
	int shrinker_id;
	bool memcg_aware;
	struct xarray xa;
};

struct super_operations;

struct dquot_operations;

struct quotactl_ops;

struct export_operations;

struct xattr_handler;

struct block_device;

struct bdev_handle;

struct backing_dev_info;

struct super_block {
	struct list_head s_list;
	dev_t s_dev;
	unsigned char s_blocksize_bits;
	long unsigned int s_blocksize;
	loff_t s_maxbytes;
	struct file_system_type *s_type;
	const struct super_operations *s_op;
	const struct dquot_operations *dq_op;
	const struct quotactl_ops *s_qcop;
	const struct export_operations *s_export_op;
	long unsigned int s_flags;
	long unsigned int s_iflags;
	long unsigned int s_magic;
	struct dentry *s_root;
	struct rw_semaphore s_umount;
	int s_count;
	atomic_t s_active;
	void *s_security;
	const struct xattr_handler * const *s_xattr;
	struct hlist_bl_head s_roots;
	struct list_head s_mounts;
	struct block_device *s_bdev;
	struct bdev_handle *s_bdev_handle;
	struct backing_dev_info *s_bdi;
	struct mtd_info *s_mtd;
	struct hlist_node s_instances;
	unsigned int s_quota_types;
	struct quota_info s_dquot;
	struct sb_writers s_writers;
	void *s_fs_info;
	u32 s_time_gran;
	time64_t s_time_min;
	time64_t s_time_max;
	__u32 s_fsnotify_mask;
	struct fsnotify_mark_connector *s_fsnotify_marks;
	char s_id[32];
	uuid_t s_uuid;
	unsigned int s_max_links;
	struct mutex s_vfs_rename_mutex;
	const char *s_subtype;
	const struct dentry_operations *s_d_op;
	struct shrinker s_shrink;
	atomic_long_t s_remove_count;
	atomic_long_t s_fsnotify_connectors;
	int s_readonly_remount;
	errseq_t s_wb_err;
	struct workqueue_struct *s_dio_done_wq;
	struct hlist_head s_pins;
	struct user_namespace *s_user_ns;
	struct list_lru s_dentry_lru;
	struct list_lru s_inode_lru;
	struct callback_head rcu;
	struct work_struct destroy_work;
	struct mutex s_sync_lock;
	int s_stack_depth;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t s_inode_list_lock;
	struct list_head s_inodes;
	spinlock_t s_inode_wblist_lock;
	struct list_head s_inodes_wb;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct mnt_idmap;

struct vfsmount {
	struct dentry *mnt_root;
	struct super_block *mnt_sb;
	int mnt_flags;
	struct mnt_idmap *mnt_idmap;
};

struct kstat {
	u32 result_mask;
	umode_t mode;
	unsigned int nlink;
	uint32_t blksize;
	u64 attributes;
	u64 attributes_mask;
	u64 ino;
	dev_t dev;
	dev_t rdev;
	kuid_t uid;
	kgid_t gid;
	loff_t size;
	struct timespec64 atime;
	struct timespec64 mtime;
	struct timespec64 ctime;
	struct timespec64 btime;
	u64 blocks;
	u64 mnt_id;
	u32 dio_mem_align;
	u32 dio_offset_align;
	u64 change_cookie;
};

struct list_lru_one {
	struct list_head list;
	long int nr_items;
};

struct list_lru_node {
	spinlock_t lock;
	struct list_lru_one lru;
	long int nr_items;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
	MIGRATE_SYNC_NO_COPY = 3,
};

struct delayed_call {
	void (*fn)(void *);
	void *arg;
};

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	gid_t val;
} vfsgid_t;

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long int);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	};
};

struct iattr {
	unsigned int ia_valid;
	umode_t ia_mode;
	union {
		kuid_t ia_uid;
		vfsuid_t ia_vfsuid;
	};
	union {
		kgid_t ia_gid;
		vfsgid_t ia_vfsgid;
	};
	loff_t ia_size;
	struct timespec64 ia_atime;
	struct timespec64 ia_mtime;
	struct timespec64 ia_ctime;
	struct file *ia_file;
};

typedef __kernel_uid32_t projid_t;

typedef struct {
	projid_t val;
} kprojid_t;

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

struct kqid {
	union {
		kuid_t uid;
		kgid_t gid;
		kprojid_t projid;
	};
	enum quota_type type;
};

struct mem_dqblk {
	qsize_t dqb_bhardlimit;
	qsize_t dqb_bsoftlimit;
	qsize_t dqb_curspace;
	qsize_t dqb_rsvspace;
	qsize_t dqb_ihardlimit;
	qsize_t dqb_isoftlimit;
	qsize_t dqb_curinodes;
	time64_t dqb_btime;
	time64_t dqb_itime;
};

struct dquot {
	struct hlist_node dq_hash;
	struct list_head dq_inuse;
	struct list_head dq_free;
	struct list_head dq_dirty;
	struct mutex dq_lock;
	spinlock_t dq_dqb_lock;
	atomic_t dq_count;
	struct super_block *dq_sb;
	struct kqid dq_id;
	loff_t dq_off;
	long unsigned int dq_flags;
	struct mem_dqblk dq_dqb;
};

struct quota_format_type {
	int qf_fmt_id;
	const struct quota_format_ops *qf_ops;
	struct module *qf_owner;
	struct quota_format_type *qf_next;
};

struct quota_format_ops {
	int (*check_quota_file)(struct super_block *, int);
	int (*read_file_info)(struct super_block *, int);
	int (*write_file_info)(struct super_block *, int);
	int (*free_file_info)(struct super_block *, int);
	int (*read_dqblk)(struct dquot *);
	int (*commit_dqblk)(struct dquot *);
	int (*release_dqblk)(struct dquot *);
	int (*get_next_id)(struct super_block *, struct kqid *);
};

struct dquot_operations {
	int (*write_dquot)(struct dquot *);
	struct dquot * (*alloc_dquot)(struct super_block *, int);
	void (*destroy_dquot)(struct dquot *);
	int (*acquire_dquot)(struct dquot *);
	int (*release_dquot)(struct dquot *);
	int (*mark_dirty)(struct dquot *);
	int (*write_info)(struct super_block *, int);
	qsize_t * (*get_reserved_space)(struct inode *);
	int (*get_projid)(struct inode *, kprojid_t *);
	int (*get_inode_usage)(struct inode *, qsize_t *);
	int (*get_next_id)(struct super_block *, struct kqid *);
};

struct qc_dqblk {
	int d_fieldmask;
	u64 d_spc_hardlimit;
	u64 d_spc_softlimit;
	u64 d_ino_hardlimit;
	u64 d_ino_softlimit;
	u64 d_space;
	u64 d_ino_count;
	s64 d_ino_timer;
	s64 d_spc_timer;
	int d_ino_warns;
	int d_spc_warns;
	u64 d_rt_spc_hardlimit;
	u64 d_rt_spc_softlimit;
	u64 d_rt_space;
	s64 d_rt_spc_timer;
	int d_rt_spc_warns;
};

struct qc_type_state {
	unsigned int flags;
	unsigned int spc_timelimit;
	unsigned int ino_timelimit;
	unsigned int rt_spc_timelimit;
	unsigned int spc_warnlimit;
	unsigned int ino_warnlimit;
	unsigned int rt_spc_warnlimit;
	long long unsigned int ino;
	blkcnt_t blocks;
	blkcnt_t nextents;
};

struct qc_state {
	unsigned int s_incoredqs;
	struct qc_type_state s_state[3];
};

struct qc_info {
	int i_fieldmask;
	unsigned int i_flags;
	unsigned int i_spc_timelimit;
	unsigned int i_ino_timelimit;
	unsigned int i_rt_spc_timelimit;
	unsigned int i_spc_warnlimit;
	unsigned int i_ino_warnlimit;
	unsigned int i_rt_spc_warnlimit;
};

struct quotactl_ops {
	int (*quota_on)(struct super_block *, int, int, const struct path *);
	int (*quota_off)(struct super_block *, int);
	int (*quota_enable)(struct super_block *, unsigned int);
	int (*quota_disable)(struct super_block *, unsigned int);
	int (*quota_sync)(struct super_block *, int);
	int (*set_info)(struct super_block *, int, struct qc_info *);
	int (*get_dqblk)(struct super_block *, struct kqid, struct qc_dqblk *);
	int (*get_nextdqblk)(struct super_block *, struct kqid *, struct qc_dqblk *);
	int (*set_dqblk)(struct super_block *, struct kqid, struct qc_dqblk *);
	int (*get_state)(struct super_block *, struct qc_state *);
	int (*rm_xquota)(struct super_block *, unsigned int);
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

struct kset;

struct kobj_type;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct module_param_attrs;

struct module_kobject {
	struct kobject kobj;
	struct module *mod;
	struct kobject *drivers_dir;
	struct module_param_attrs *mp;
	struct completion *kobj_completion;
};

struct latch_tree_node {
	struct rb_node node[2];
};

struct mod_tree_node {
	struct module *mod;
	struct latch_tree_node node;
};

struct module_memory {
	void *base;
	unsigned int size;
	struct mod_tree_node mtn;
};

struct mod_arch_specific {
	unsigned int num_orcs;
	int *orc_unwind_ip;
	struct orc_entry *orc_unwind;
};

struct elf64_sym;

typedef struct elf64_sym Elf64_Sym;

struct mod_kallsyms {
	Elf64_Sym *symtab;
	unsigned int num_symtab;
	char *strtab;
	char *typetab;
};

struct module_attribute;

struct kernel_symbol;

struct kernel_param;

struct module_sect_attrs;

struct module_notes_attrs;

struct trace_eval_map;

struct error_injection_entry;

struct module {
	enum module_state state;
	struct list_head list;
	char name[56];
	struct module_kobject mkobj;
	struct module_attribute *modinfo_attrs;
	const char *version;
	const char *srcversion;
	struct kobject *holders_dir;
	const struct kernel_symbol *syms;
	const s32 *crcs;
	unsigned int num_syms;
	struct mutex param_lock;
	struct kernel_param *kp;
	unsigned int num_kp;
	unsigned int num_gpl_syms;
	const struct kernel_symbol *gpl_syms;
	const s32 *gpl_crcs;
	bool using_gplonly_symbols;
	bool sig_ok;
	bool async_probe_requested;
	unsigned int num_exentries;
	struct exception_table_entry *extable;
	int (*init)();
	long: 64;
	long: 64;
	struct module_memory mem[7];
	struct mod_arch_specific arch;
	long unsigned int taints;
	unsigned int num_bugs;
	struct list_head bug_list;
	struct bug_entry *bug_table;
	struct mod_kallsyms *kallsyms;
	struct mod_kallsyms core_kallsyms;
	struct module_sect_attrs *sect_attrs;
	struct module_notes_attrs *notes_attrs;
	char *args;
	void *percpu;
	unsigned int percpu_size;
	void *noinstr_text_start;
	unsigned int noinstr_text_size;
	unsigned int num_tracepoints;
	tracepoint_ptr_t *tracepoints_ptrs;
	unsigned int num_srcu_structs;
	struct srcu_struct **srcu_struct_ptrs;
	unsigned int num_bpf_raw_events;
	struct bpf_raw_event_map *bpf_raw_events;
	unsigned int btf_data_size;
	void *btf_data;
	struct jump_entry *jump_entries;
	unsigned int num_jump_entries;
	unsigned int num_trace_bprintk_fmt;
	const char **trace_bprintk_fmt_start;
	struct trace_event_call **trace_events;
	unsigned int num_trace_events;
	struct trace_eval_map **trace_evals;
	unsigned int num_trace_evals;
	unsigned int num_ftrace_callsites;
	long unsigned int *ftrace_callsites;
	void *kprobes_text_start;
	unsigned int kprobes_text_size;
	long unsigned int *kprobe_blacklist;
	unsigned int num_kprobe_blacklist;
	int num_static_call_sites;
	struct static_call_site *static_call_sites;
	struct list_head source_list;
	struct list_head target_list;
	void (*exit)();
	atomic_t refcnt;
	struct error_injection_entry *ei_funcs;
	unsigned int num_ei_funcs;
	long: 64;
};

struct writeback_control;

struct readahead_control;

struct swap_info_struct;

struct address_space_operations {
	int (*writepage)(struct page *, struct writeback_control *);
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(struct file *, struct address_space *, loff_t, unsigned int, struct page **, void **);
	int (*write_end)(struct file *, struct address_space *, loff_t, unsigned int, unsigned int, struct page *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_page)(struct address_space *, struct page *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
};

struct fiemap_extent_info;

struct fileattr;

struct offset_ctx;

struct inode_operations {
	struct dentry * (*lookup)(struct inode *, struct dentry *, unsigned int);
	const char * (*get_link)(struct dentry *, struct inode *, struct delayed_call *);
	int (*permission)(struct mnt_idmap *, struct inode *, int);
	struct posix_acl * (*get_inode_acl)(struct inode *, int, bool);
	int (*readlink)(struct dentry *, char *, int);
	int (*create)(struct mnt_idmap *, struct inode *, struct dentry *, umode_t, bool);
	int (*link)(struct dentry *, struct inode *, struct dentry *);
	int (*unlink)(struct inode *, struct dentry *);
	int (*symlink)(struct mnt_idmap *, struct inode *, struct dentry *, const char *);
	int (*mkdir)(struct mnt_idmap *, struct inode *, struct dentry *, umode_t);
	int (*rmdir)(struct inode *, struct dentry *);
	int (*mknod)(struct mnt_idmap *, struct inode *, struct dentry *, umode_t, dev_t);
	int (*rename)(struct mnt_idmap *, struct inode *, struct dentry *, struct inode *, struct dentry *, unsigned int);
	int (*setattr)(struct mnt_idmap *, struct dentry *, struct iattr *);
	int (*getattr)(struct mnt_idmap *, const struct path *, struct kstat *, u32, unsigned int);
	ssize_t (*listxattr)(struct dentry *, char *, size_t);
	int (*fiemap)(struct inode *, struct fiemap_extent_info *, u64, u64);
	int (*update_time)(struct inode *, int);
	int (*atomic_open)(struct inode *, struct dentry *, struct file *, unsigned int, umode_t);
	int (*tmpfile)(struct mnt_idmap *, struct inode *, struct file *, umode_t);
	struct posix_acl * (*get_acl)(struct mnt_idmap *, struct dentry *, int);
	int (*set_acl)(struct mnt_idmap *, struct dentry *, struct posix_acl *, int);
	int (*fileattr_set)(struct mnt_idmap *, struct dentry *, struct fileattr *);
	int (*fileattr_get)(struct dentry *, struct fileattr *);
	struct offset_ctx * (*get_offset_ctx)(struct inode *);
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct fasync_struct {
	rwlock_t fa_lock;
	int magic;
	int fa_fd;
	struct fasync_struct *fa_next;
	struct file *fa_file;
	struct callback_head fa_rcu;
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
};

struct kstatfs;

struct super_operations {
	struct inode * (*alloc_inode)(struct super_block *);
	void (*destroy_inode)(struct inode *);
	void (*free_inode)(struct inode *);
	void (*dirty_inode)(struct inode *, int);
	int (*write_inode)(struct inode *, struct writeback_control *);
	int (*drop_inode)(struct inode *);
	void (*evict_inode)(struct inode *);
	void (*put_super)(struct super_block *);
	int (*sync_fs)(struct super_block *, int);
	int (*freeze_super)(struct super_block *, enum freeze_holder);
	int (*freeze_fs)(struct super_block *);
	int (*thaw_super)(struct super_block *, enum freeze_holder);
	int (*unfreeze_fs)(struct super_block *);
	int (*statfs)(struct dentry *, struct kstatfs *);
	int (*remount_fs)(struct super_block *, int *, char *);
	void (*umount_begin)(struct super_block *);
	int (*show_options)(struct seq_file *, struct dentry *);
	int (*show_devname)(struct seq_file *, struct dentry *);
	int (*show_path)(struct seq_file *, struct dentry *);
	int (*show_stats)(struct seq_file *, struct dentry *);
	long int (*nr_cached_objects)(struct super_block *, struct shrink_control *);
	long int (*free_cached_objects)(struct super_block *, struct shrink_control *);
	void (*shutdown)(struct super_block *);
};

struct fid;

struct iomap;

struct export_operations {
	int (*encode_fh)(struct inode *, __u32 *, int *, struct inode *);
	struct dentry * (*fh_to_dentry)(struct super_block *, struct fid *, int, int);
	struct dentry * (*fh_to_parent)(struct super_block *, struct fid *, int, int);
	int (*get_name)(struct dentry *, char *, struct dentry *);
	struct dentry * (*get_parent)(struct dentry *);
	int (*commit_metadata)(struct inode *);
	int (*get_uuid)(struct super_block *, u8 *, u32 *, u64 *);
	int (*map_blocks)(struct inode *, loff_t, u64, struct iomap *, bool, u32 *);
	int (*commit_blocks)(struct inode *, struct iomap *, int, struct iattr *);
	long unsigned int flags;
};

struct xattr_handler {
	const char *name;
	const char *prefix;
	int flags;
	bool (*list)(struct dentry *);
	int (*get)(const struct xattr_handler *, struct dentry *, struct inode *, const char *, void *, size_t);
	int (*set)(const struct xattr_handler *, struct mnt_idmap *, struct dentry *, struct inode *, const char *, const void *, size_t, int);
};

typedef bool (*filldir_t)(struct dir_context *, const char *, int, loff_t, u64, unsigned int);

struct dir_context {
	filldir_t actor;
	loff_t pos;
};

struct seq_file {
	char *buf;
	size_t size;
	size_t from;
	size_t count;
	size_t pad_until;
	loff_t index;
	loff_t read_pos;
	struct mutex lock;
	const struct seq_operations *op;
	int poll_event;
	const struct file *file;
	void *private;
};

struct offset_ctx {
	struct xarray xa;
	u32 next_offset;
};

struct p_log;

struct fs_parameter;

struct fs_parse_result;

typedef int fs_param_type(struct p_log *, const struct fs_parameter_spec *, struct fs_parameter *, struct fs_parse_result *);

struct fs_parameter_spec {
	const char *name;
	fs_param_type *type;
	u8 opt;
	short unsigned int flags;
	const void *data;
};

struct attribute;

struct bin_attribute;

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, struct bin_attribute *, int);
	struct attribute **attrs;
	struct bin_attribute **bin_attrs;
};

struct cgroup_namespace {
	struct ns_common ns;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct css_set *root_cset;
};

struct nsset;

struct proc_ns_operations {
	const char *name;
	const char *real_ns_name;
	int type;
	struct ns_common * (*get)(struct task_struct *);
	void (*put)(struct ns_common *);
	int (*install)(struct nsset *, struct ns_common *);
	struct user_namespace * (*owner)(struct ns_common *);
	struct ns_common * (*get_parent)(struct ns_common *);
};

struct kernfs_root;

struct kernfs_elem_dir {
	long unsigned int subdirs;
	struct rb_root children;
	struct kernfs_root *root;
	long unsigned int rev;
};

struct kernfs_elem_symlink {
	struct kernfs_node *target_kn;
};

struct kernfs_ops;

struct kernfs_open_node;

struct kernfs_elem_attr {
	const struct kernfs_ops *ops;
	struct kernfs_open_node *open;
	loff_t size;
	struct kernfs_node *notify_next;
};

struct kernfs_iattrs;

struct kernfs_node {
	atomic_t count;
	atomic_t active;
	struct lockdep_map dep_map;
	struct kernfs_node *parent;
	const char *name;
	struct rb_node rb;
	const void *ns;
	unsigned int hash;
	union {
		struct kernfs_elem_dir dir;
		struct kernfs_elem_symlink symlink;
		struct kernfs_elem_attr attr;
	};
	void *priv;
	u64 id;
	short unsigned int flags;
	umode_t mode;
	struct kernfs_iattrs *iattr;
};

struct kernfs_open_file;

struct kernfs_ops {
	int (*open)(struct kernfs_open_file *);
	void (*release)(struct kernfs_open_file *);
	int (*seq_show)(struct seq_file *, void *);
	void * (*seq_start)(struct seq_file *, loff_t *);
	void * (*seq_next)(struct seq_file *, void *, loff_t *);
	void (*seq_stop)(struct seq_file *, void *);
	ssize_t (*read)(struct kernfs_open_file *, char *, size_t, loff_t);
	size_t atomic_write_len;
	bool prealloc;
	ssize_t (*write)(struct kernfs_open_file *, char *, size_t, loff_t);
	__poll_t (*poll)(struct kernfs_open_file *, struct poll_table_struct *);
	int (*mmap)(struct kernfs_open_file *, struct vm_area_struct *);
};

struct kernfs_open_file {
	struct kernfs_node *kn;
	struct file *file;
	struct seq_file *seq_file;
	void *priv;
	struct mutex mutex;
	struct mutex prealloc_mutex;
	int event;
	struct list_head list;
	char *prealloc_buf;
	size_t atomic_write_len;
	bool mmapped: 1;
	bool released: 1;
	const struct vm_operations_struct *vm_ops;
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

struct sock;

struct kobj_ns_type_operations {
	enum kobj_ns_type type;
	bool (*current_may_mount)();
	void * (*grab_current_ns)();
	const void * (*netlink_ns)(struct sock *);
	const void * (*initial_ns)();
	void (*drop_ns)(void *);
};

struct attribute {
	const char *name;
	umode_t mode;
	bool ignore_lockdep: 1;
	struct lock_class_key *key;
	struct lock_class_key skey;
};

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)();
	ssize_t (*read)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	int (*mmap)(struct file *, struct kobject *, struct bin_attribute *, struct vm_area_struct *);
};

struct sysfs_ops {
	ssize_t (*show)(struct kobject *, struct attribute *, char *);
	ssize_t (*store)(struct kobject *, struct attribute *, const char *, size_t);
};

struct kset_uevent_ops;

struct kset {
	struct list_head list;
	spinlock_t list_lock;
	struct kobject kobj;
	const struct kset_uevent_ops *uevent_ops;
};

struct kobj_type {
	void (*release)(struct kobject *);
	const struct sysfs_ops *sysfs_ops;
	const struct attribute_group **default_groups;
	const struct kobj_ns_type_operations * (*child_ns_type)(const struct kobject *);
	const void * (*namespace)(const struct kobject *);
	void (*get_ownership)(const struct kobject *, kuid_t *, kgid_t *);
};

struct kobj_uevent_env {
	char *argv[3];
	char *envp[64];
	int envp_idx;
	char buf[2048];
	int buflen;
};

struct kset_uevent_ops {
	int (* const filter)(const struct kobject *);
	const char * (* const name)(const struct kobject *);
	int (* const uevent)(const struct kobject *, struct kobj_uevent_env *);
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct device;

struct dev_pm_ops {
	int (*prepare)(struct device *);
	void (*complete)(struct device *);
	int (*suspend)(struct device *);
	int (*resume)(struct device *);
	int (*freeze)(struct device *);
	int (*thaw)(struct device *);
	int (*poweroff)(struct device *);
	int (*restore)(struct device *);
	int (*suspend_late)(struct device *);
	int (*resume_early)(struct device *);
	int (*freeze_late)(struct device *);
	int (*thaw_early)(struct device *);
	int (*poweroff_late)(struct device *);
	int (*restore_early)(struct device *);
	int (*suspend_noirq)(struct device *);
	int (*resume_noirq)(struct device *);
	int (*freeze_noirq)(struct device *);
	int (*thaw_noirq)(struct device *);
	int (*poweroff_noirq)(struct device *);
	int (*restore_noirq)(struct device *);
	int (*runtime_suspend)(struct device *);
	int (*runtime_resume)(struct device *);
	int (*runtime_idle)(struct device *);
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	unsigned int can_wakeup: 1;
	unsigned int async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	unsigned int must_resume: 1;
	unsigned int may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	unsigned int idle_notification: 1;
	unsigned int request_pending: 1;
	unsigned int deferred_resume: 1;
	unsigned int needs_force_resume: 1;
	unsigned int runtime_auto: 1;
	bool ignore_children: 1;
	unsigned int no_callbacks: 1;
	unsigned int irq_safe: 1;
	unsigned int use_autosuspend: 1;
	unsigned int timer_autosuspends: 1;
	unsigned int memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct dma_map_ops;

struct bus_dma_region;

struct device_dma_parameters;

struct cma;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct dev_msi_info msi;
	const struct dma_map_ops *dma_ops;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct cma *cma_area;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
};

struct pm_subsys_data {
	spinlock_t lock;
	unsigned int refcount;
};

struct wakeup_source {
	const char *name;
	int id;
	struct list_head entry;
	spinlock_t lock;
	struct wake_irq *wakeirq;
	struct timer_list timer;
	long unsigned int timer_expires;
	ktime_t total_time;
	ktime_t max_time;
	ktime_t last_time;
	ktime_t start_prevent_time;
	ktime_t prevent_sleep_time;
	long unsigned int event_count;
	long unsigned int active_count;
	long unsigned int relax_count;
	long unsigned int expire_count;
	long unsigned int wakeup_count;
	struct device *dev;
	bool active: 1;
	bool autosleep_enabled: 1;
};

struct dev_pm_domain {
	struct dev_pm_ops ops;
	int (*start)(struct device *);
	void (*detach)(struct device *, bool);
	int (*activate)(struct device *);
	void (*sync)(struct device *);
	void (*dismiss)(struct device *);
	int (*set_performance_state)(struct device *, unsigned int);
};

struct iommu_ops;

struct bus_type {
	const char *name;
	const char *dev_name;
	const struct attribute_group **bus_groups;
	const struct attribute_group **dev_groups;
	const struct attribute_group **drv_groups;
	int (*match)(struct device *, struct device_driver *);
	int (*uevent)(const struct device *, struct kobj_uevent_env *);
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	void (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*online)(struct device *);
	int (*offline)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	int (*num_vf)(struct device *);
	int (*dma_configure)(struct device *);
	void (*dma_cleanup)(struct device *);
	const struct dev_pm_ops *pm;
	const struct iommu_ops *iommu_ops;
	bool need_parent_lock;
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

struct of_device_id;

struct acpi_device_id;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
};

enum iommu_dev_features {
	IOMMU_DEV_FEAT_SVA = 0,
	IOMMU_DEV_FEAT_IOPF = 1,
};

typedef unsigned int ioasid_t;

struct iommu_domain;

struct iommu_device;

struct of_phandle_args;

struct iommu_fault_event;

struct iommu_page_response;

struct iommu_domain_ops;

struct iommu_ops {
	bool (*capable)(struct device *, enum iommu_cap);
	void * (*hw_info)(struct device *, u32 *, u32 *);
	struct iommu_domain * (*domain_alloc)(unsigned int);
	struct iommu_device * (*probe_device)(struct device *);
	void (*release_device)(struct device *);
	void (*probe_finalize)(struct device *);
	void (*set_platform_dma_ops)(struct device *);
	struct iommu_group * (*device_group)(struct device *);
	void (*get_resv_regions)(struct device *, struct list_head *);
	int (*of_xlate)(struct device *, struct of_phandle_args *);
	bool (*is_attach_deferred)(struct device *);
	int (*dev_enable_feat)(struct device *, enum iommu_dev_features);
	int (*dev_disable_feat)(struct device *, enum iommu_dev_features);
	int (*page_response)(struct device *, struct iommu_fault_event *, struct iommu_page_response *);
	int (*def_domain_type)(struct device *);
	void (*remove_dev_pasid)(struct device *, ioasid_t);
	const struct iommu_domain_ops *default_domain_ops;
	long unsigned int pgsize_bitmap;
	struct module *owner;
};

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
};

struct device_type {
	const char *name;
	const struct attribute_group **groups;
	int (*uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *, kuid_t *, kgid_t *);
	void (*release)(struct device *);
	const struct dev_pm_ops *pm;
};

typedef __u64 Elf64_Addr;

typedef __u16 Elf64_Half;

typedef __u32 Elf64_Word;

typedef __u64 Elf64_Xword;

struct elf64_sym {
	Elf64_Word st_name;
	unsigned char st_info;
	unsigned char st_other;
	Elf64_Half st_shndx;
	Elf64_Addr st_value;
	Elf64_Xword st_size;
};

struct kernel_param_ops {
	unsigned int flags;
	int (*set)(const char *, const struct kernel_param *);
	int (*get)(char *, const struct kernel_param *);
	void (*free)(void *);
};

struct kparam_string;

struct kparam_array;

struct kernel_param {
	const char *name;
	struct module *mod;
	const struct kernel_param_ops *ops;
	const u16 perm;
	s8 level;
	u8 flags;
	union {
		void *arg;
		const struct kparam_string *str;
		const struct kparam_array *arr;
	};
};

struct kparam_string {
	unsigned int maxlen;
	char *string;
};

struct kparam_array {
	unsigned int max;
	unsigned int elemsize;
	unsigned int *num;
	const struct kernel_param_ops *ops;
	void *elem;
};

struct error_injection_entry {
	long unsigned int addr;
	int etype;
};

struct module_attribute {
	struct attribute attr;
	ssize_t (*show)(struct module_attribute *, struct module_kobject *, char *);
	ssize_t (*store)(struct module_attribute *, struct module_kobject *, const char *, size_t);
	void (*setup)(struct module *, const char *);
	int (*test)(struct module *);
	void (*free)(struct module *);
};

struct kernel_symbol {
	int value_offset;
	int name_offset;
	int namespace_offset;
};

struct trace_eval_map {
	const char *system;
	const char *eval_string;
	long unsigned int eval_value;
};

struct of_device_id {
	char name[32];
	char type[32];
	char compatible[128];
	const void *data;
};

typedef long unsigned int kernel_ulong_t;

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct device_dma_parameters {
	unsigned int max_segment_size;
	unsigned int min_align_mask;
	long unsigned int segment_boundary_mask;
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

struct device_physical_location {
	enum device_physical_location_panel panel;
	enum device_physical_location_vertical_position vertical_position;
	enum device_physical_location_horizontal_position horizontal_position;
	bool dock;
	bool lid;
};

typedef u64 dma_addr_t;

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

struct sg_table;

struct scatterlist;

struct dma_map_ops {
	unsigned int flags;
	void * (*alloc)(struct device *, size_t, dma_addr_t *, gfp_t, long unsigned int);
	void (*free)(struct device *, size_t, void *, dma_addr_t, long unsigned int);
	struct page * (*alloc_pages)(struct device *, size_t, dma_addr_t *, enum dma_data_direction, gfp_t);
	void (*free_pages)(struct device *, size_t, struct page *, dma_addr_t, enum dma_data_direction);
	struct sg_table * (*alloc_noncontiguous)(struct device *, size_t, enum dma_data_direction, gfp_t, long unsigned int);
	void (*free_noncontiguous)(struct device *, size_t, struct sg_table *, enum dma_data_direction);
	int (*mmap)(struct device *, struct vm_area_struct *, void *, dma_addr_t, size_t, long unsigned int);
	int (*get_sgtable)(struct device *, struct sg_table *, void *, dma_addr_t, size_t, long unsigned int);
	dma_addr_t (*map_page)(struct device *, struct page *, long unsigned int, size_t, enum dma_data_direction, long unsigned int);
	void (*unmap_page)(struct device *, dma_addr_t, size_t, enum dma_data_direction, long unsigned int);
	int (*map_sg)(struct device *, struct scatterlist *, int, enum dma_data_direction, long unsigned int);
	void (*unmap_sg)(struct device *, struct scatterlist *, int, enum dma_data_direction, long unsigned int);
	dma_addr_t (*map_resource)(struct device *, phys_addr_t, size_t, enum dma_data_direction, long unsigned int);
	void (*unmap_resource)(struct device *, dma_addr_t, size_t, enum dma_data_direction, long unsigned int);
	void (*sync_single_for_cpu)(struct device *, dma_addr_t, size_t, enum dma_data_direction);
	void (*sync_single_for_device)(struct device *, dma_addr_t, size_t, enum dma_data_direction);
	void (*sync_sg_for_cpu)(struct device *, struct scatterlist *, int, enum dma_data_direction);
	void (*sync_sg_for_device)(struct device *, struct scatterlist *, int, enum dma_data_direction);
	void (*cache_sync)(struct device *, void *, size_t, enum dma_data_direction);
	int (*dma_supported)(struct device *, u64);
	u64 (*get_required_mask)(struct device *);
	size_t (*max_mapping_size)(struct device *);
	size_t (*opt_mapping_size)();
	long unsigned int (*get_merge_boundary)(struct device *);
};

struct bus_dma_region {
	phys_addr_t cpu_start;
	dma_addr_t dma_start;
	u64 size;
	u64 offset;
};

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_APB_DEAD = 8,
	CPUHP_X86_MCE_DEAD = 9,
	CPUHP_VIRT_NET_DEAD = 10,
	CPUHP_IBMVNIC_DEAD = 11,
	CPUHP_SLUB_DEAD = 12,
	CPUHP_DEBUG_OBJ_DEAD = 13,
	CPUHP_MM_WRITEBACK_DEAD = 14,
	CPUHP_MM_DEMOTION_DEAD = 15,
	CPUHP_MM_VMSTAT_DEAD = 16,
	CPUHP_SOFTIRQ_DEAD = 17,
	CPUHP_NET_MVNETA_DEAD = 18,
	CPUHP_CPUIDLE_DEAD = 19,
	CPUHP_ARM64_FPSIMD_DEAD = 20,
	CPUHP_ARM_OMAP_WAKE_DEAD = 21,
	CPUHP_IRQ_POLL_DEAD = 22,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 23,
	CPUHP_BIO_DEAD = 24,
	CPUHP_ACPI_CPUDRV_DEAD = 25,
	CPUHP_S390_PFAULT_DEAD = 26,
	CPUHP_BLK_MQ_DEAD = 27,
	CPUHP_FS_BUFF_DEAD = 28,
	CPUHP_PRINTK_DEAD = 29,
	CPUHP_MM_MEMCQ_DEAD = 30,
	CPUHP_PERCPU_CNT_DEAD = 31,
	CPUHP_RADIX_DEAD = 32,
	CPUHP_PAGE_ALLOC = 33,
	CPUHP_NET_DEV_DEAD = 34,
	CPUHP_PCI_XGENE_DEAD = 35,
	CPUHP_IOMMU_IOVA_DEAD = 36,
	CPUHP_LUSTRE_CFS_DEAD = 37,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 38,
	CPUHP_PADATA_DEAD = 39,
	CPUHP_AP_DTPM_CPU_DEAD = 40,
	CPUHP_RANDOM_PREPARE = 41,
	CPUHP_WORKQUEUE_PREP = 42,
	CPUHP_POWER_NUMA_PREPARE = 43,
	CPUHP_HRTIMERS_PREPARE = 44,
	CPUHP_PROFILE_PREPARE = 45,
	CPUHP_X2APIC_PREPARE = 46,
	CPUHP_SMPCFD_PREPARE = 47,
	CPUHP_RELAY_PREPARE = 48,
	CPUHP_SLAB_PREPARE = 49,
	CPUHP_MD_RAID5_PREPARE = 50,
	CPUHP_RCUTREE_PREP = 51,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 52,
	CPUHP_POWERPC_PMAC_PREPARE = 53,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 54,
	CPUHP_XEN_PREPARE = 55,
	CPUHP_XEN_EVTCHN_PREPARE = 56,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 57,
	CPUHP_SH_SH3X_PREPARE = 58,
	CPUHP_NET_FLOW_PREPARE = 59,
	CPUHP_TOPOLOGY_PREPARE = 60,
	CPUHP_NET_IUCV_PREPARE = 61,
	CPUHP_ARM_BL_PREPARE = 62,
	CPUHP_TRACE_RB_PREPARE = 63,
	CPUHP_MM_ZS_PREPARE = 64,
	CPUHP_MM_ZSWP_MEM_PREPARE = 65,
	CPUHP_MM_ZSWP_POOL_PREPARE = 66,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 67,
	CPUHP_ZCOMP_PREPARE = 68,
	CPUHP_TIMERS_PREPARE = 69,
	CPUHP_MIPS_SOC_PREPARE = 70,
	CPUHP_BP_PREPARE_DYN = 71,
	CPUHP_BP_PREPARE_DYN_END = 91,
	CPUHP_BP_KICK_AP = 92,
	CPUHP_BRINGUP_CPU = 93,
	CPUHP_AP_IDLE_DEAD = 94,
	CPUHP_AP_OFFLINE = 95,
	CPUHP_AP_CACHECTRL_STARTING = 96,
	CPUHP_AP_SCHED_STARTING = 97,
	CPUHP_AP_RCUTREE_DYING = 98,
	CPUHP_AP_CPU_PM_STARTING = 99,
	CPUHP_AP_IRQ_GIC_STARTING = 100,
	CPUHP_AP_IRQ_HIP04_STARTING = 101,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 102,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 103,
	CPUHP_AP_IRQ_BCM2836_STARTING = 104,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 105,
	CPUHP_AP_IRQ_RISCV_STARTING = 106,
	CPUHP_AP_IRQ_LOONGARCH_STARTING = 107,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 108,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 109,
	CPUHP_AP_MICROCODE_LOADER = 110,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 111,
	CPUHP_AP_PERF_X86_STARTING = 112,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 113,
	CPUHP_AP_PERF_X86_CQM_STARTING = 114,
	CPUHP_AP_PERF_X86_CSTATE_STARTING = 115,
	CPUHP_AP_PERF_XTENSA_STARTING = 116,
	CPUHP_AP_MIPS_OP_LOONGSON3_STARTING = 117,
	CPUHP_AP_ARM_VFP_STARTING = 118,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 119,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 120,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 121,
	CPUHP_AP_PERF_ARM_STARTING = 122,
	CPUHP_AP_PERF_RISCV_STARTING = 123,
	CPUHP_AP_ARM_L2X0_STARTING = 124,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 125,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 126,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 127,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 128,
	CPUHP_AP_JCORE_TIMER_STARTING = 129,
	CPUHP_AP_ARM_TWD_STARTING = 130,
	CPUHP_AP_QCOM_TIMER_STARTING = 131,
	CPUHP_AP_TEGRA_TIMER_STARTING = 132,
	CPUHP_AP_ARMADA_TIMER_STARTING = 133,
	CPUHP_AP_MARCO_TIMER_STARTING = 134,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 135,
	CPUHP_AP_ARC_TIMER_STARTING = 136,
	CPUHP_AP_RISCV_TIMER_STARTING = 137,
	CPUHP_AP_CLINT_TIMER_STARTING = 138,
	CPUHP_AP_CSKY_TIMER_STARTING = 139,
	CPUHP_AP_TI_GP_TIMER_STARTING = 140,
	CPUHP_AP_HYPERV_TIMER_STARTING = 141,
	CPUHP_AP_DUMMY_TIMER_STARTING = 142,
	CPUHP_AP_ARM_XEN_STARTING = 143,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 144,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 145,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 146,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 147,
	CPUHP_AP_SMPCFD_DYING = 148,
	CPUHP_AP_X86_TBOOT_DYING = 149,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 150,
	CPUHP_AP_ONLINE = 151,
	CPUHP_TEARDOWN_CPU = 152,
	CPUHP_AP_ONLINE_IDLE = 153,
	CPUHP_AP_HYPERV_ONLINE = 154,
	CPUHP_AP_KVM_ONLINE = 155,
	CPUHP_AP_SCHED_WAIT_EMPTY = 156,
	CPUHP_AP_SMPBOOT_THREADS = 157,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 158,
	CPUHP_AP_BLK_MQ_ONLINE = 159,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 160,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 161,
	CPUHP_AP_PERF_ONLINE = 162,
	CPUHP_AP_PERF_X86_ONLINE = 163,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 164,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 165,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 166,
	CPUHP_AP_PERF_X86_RAPL_ONLINE = 167,
	CPUHP_AP_PERF_X86_CQM_ONLINE = 168,
	CPUHP_AP_PERF_X86_CSTATE_ONLINE = 169,
	CPUHP_AP_PERF_X86_IDXD_ONLINE = 170,
	CPUHP_AP_PERF_S390_CF_ONLINE = 171,
	CPUHP_AP_PERF_S390_SF_ONLINE = 172,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 173,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 174,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 175,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 176,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 177,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 178,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 179,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 180,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 181,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 182,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 183,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 184,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 185,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 186,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 187,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 188,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 189,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 190,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 191,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 192,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 193,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 194,
	CPUHP_AP_PERF_CSKY_ONLINE = 195,
	CPUHP_AP_WATCHDOG_ONLINE = 196,
	CPUHP_AP_WORKQUEUE_ONLINE = 197,
	CPUHP_AP_RANDOM_ONLINE = 198,
	CPUHP_AP_RCUTREE_ONLINE = 199,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 200,
	CPUHP_AP_ONLINE_DYN = 201,
	CPUHP_AP_ONLINE_DYN_END = 231,
	CPUHP_AP_MM_DEMOTION_ONLINE = 232,
	CPUHP_AP_X86_HPET_ONLINE = 233,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 234,
	CPUHP_AP_ACTIVE = 235,
	CPUHP_ONLINE = 236,
};

struct x86_pmu_capability {
	int version;
	int num_counters_gp;
	int num_counters_fixed;
	int bit_width_gp;
	int bit_width_fixed;
	unsigned int events_mask;
	int events_mask_len;
	unsigned int pebs_ept: 1;
};

struct debug_store {
	u64 bts_buffer_base;
	u64 bts_index;
	u64 bts_absolute_maximum;
	u64 bts_interrupt_threshold;
	u64 pebs_buffer_base;
	u64 pebs_index;
	u64 pebs_absolute_maximum;
	u64 pebs_interrupt_threshold;
	u64 pebs_event_reset[48];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum stack_type {
	STACK_TYPE_UNKNOWN = 0,
	STACK_TYPE_TASK = 1,
	STACK_TYPE_IRQ = 2,
	STACK_TYPE_SOFTIRQ = 3,
	STACK_TYPE_ENTRY = 4,
	STACK_TYPE_EXCEPTION = 5,
	STACK_TYPE_EXCEPTION_LAST = 10,
};

struct stack_info {
	enum stack_type type;
	long unsigned int *begin;
	long unsigned int *end;
	long unsigned int *next_sp;
};

struct stack_frame {
	struct stack_frame *next_frame;
	long unsigned int return_address;
};

struct perf_guest_switch_msr {
	unsigned int msr;
	u64 host;
	u64 guest;
};

struct perf_cpu_pmu_context;

struct perf_output_handle;

struct pmu {
	struct list_head entry;
	struct module *module;
	struct device *dev;
	struct device *parent;
	const struct attribute_group **attr_groups;
	const struct attribute_group **attr_update;
	const char *name;
	int type;
	int capabilities;
	int *pmu_disable_count;
	struct perf_cpu_pmu_context *cpu_pmu_context;
	atomic_t exclusive_cnt;
	int task_ctx_nr;
	int hrtimer_interval_ms;
	unsigned int nr_addr_filters;
	void (*pmu_enable)(struct pmu *);
	void (*pmu_disable)(struct pmu *);
	int (*event_init)(struct perf_event *);
	void (*event_mapped)(struct perf_event *, struct mm_struct *);
	void (*event_unmapped)(struct perf_event *, struct mm_struct *);
	int (*add)(struct perf_event *, int);
	void (*del)(struct perf_event *, int);
	void (*start)(struct perf_event *, int);
	void (*stop)(struct perf_event *, int);
	void (*read)(struct perf_event *);
	void (*start_txn)(struct pmu *, unsigned int);
	int (*commit_txn)(struct pmu *);
	void (*cancel_txn)(struct pmu *);
	int (*event_idx)(struct perf_event *);
	void (*sched_task)(struct perf_event_pmu_context *, bool);
	struct kmem_cache *task_ctx_cache;
	void (*swap_task_ctx)(struct perf_event_pmu_context *, struct perf_event_pmu_context *);
	void * (*setup_aux)(struct perf_event *, void **, int, bool);
	void (*free_aux)(void *);
	long int (*snapshot_aux)(struct perf_event *, struct perf_output_handle *, long unsigned int);
	int (*addr_filters_validate)(struct list_head *);
	void (*addr_filters_sync)(struct perf_event *);
	int (*aux_output_match)(struct perf_event *);
	bool (*filter)(struct pmu *, int);
	int (*check_period)(struct perf_event *, u64);
};

typedef struct {
	unsigned int __nmi_count;
	unsigned int apic_timer_irqs;
	unsigned int irq_spurious_count;
	unsigned int icr_read_retry_count;
	unsigned int kvm_posted_intr_ipis;
	unsigned int kvm_posted_intr_wakeup_ipis;
	unsigned int kvm_posted_intr_nested_ipis;
	unsigned int x86_platform_ipis;
	unsigned int apic_perf_irqs;
	unsigned int apic_irq_work_irqs;
	unsigned int irq_resched_count;
	unsigned int irq_call_count;
	unsigned int irq_tlb_count;
	unsigned int irq_thermal_count;
	unsigned int irq_threshold_count;
	unsigned int irq_deferred_error_count;
} irq_cpustat_t;

struct ftrace_regs {
	struct pt_regs regs;
};

struct perf_regs {
	__u64 abi;
	struct pt_regs *regs;
};

enum perf_event_x86_regs {
	PERF_REG_X86_AX = 0,
	PERF_REG_X86_BX = 1,
	PERF_REG_X86_CX = 2,
	PERF_REG_X86_DX = 3,
	PERF_REG_X86_SI = 4,
	PERF_REG_X86_DI = 5,
	PERF_REG_X86_BP = 6,
	PERF_REG_X86_SP = 7,
	PERF_REG_X86_IP = 8,
	PERF_REG_X86_FLAGS = 9,
	PERF_REG_X86_CS = 10,
	PERF_REG_X86_SS = 11,
	PERF_REG_X86_DS = 12,
	PERF_REG_X86_ES = 13,
	PERF_REG_X86_FS = 14,
	PERF_REG_X86_GS = 15,
	PERF_REG_X86_R8 = 16,
	PERF_REG_X86_R9 = 17,
	PERF_REG_X86_R10 = 18,
	PERF_REG_X86_R11 = 19,
	PERF_REG_X86_R12 = 20,
	PERF_REG_X86_R13 = 21,
	PERF_REG_X86_R14 = 22,
	PERF_REG_X86_R15 = 23,
	PERF_REG_X86_32_MAX = 16,
	PERF_REG_X86_64_MAX = 24,
	PERF_REG_X86_XMM0 = 32,
	PERF_REG_X86_XMM1 = 34,
	PERF_REG_X86_XMM2 = 36,
	PERF_REG_X86_XMM3 = 38,
	PERF_REG_X86_XMM4 = 40,
	PERF_REG_X86_XMM5 = 42,
	PERF_REG_X86_XMM6 = 44,
	PERF_REG_X86_XMM7 = 46,
	PERF_REG_X86_XMM8 = 48,
	PERF_REG_X86_XMM9 = 50,
	PERF_REG_X86_XMM10 = 52,
	PERF_REG_X86_XMM11 = 54,
	PERF_REG_X86_XMM12 = 56,
	PERF_REG_X86_XMM13 = 58,
	PERF_REG_X86_XMM14 = 60,
	PERF_REG_X86_XMM15 = 62,
	PERF_REG_X86_XMM_MAX = 64,
};

struct u64_stats_sync {};

struct psi_group {};

struct cgroup_taskset;

struct cftype;

struct cgroup_subsys {
	struct cgroup_subsys_state * (*css_alloc)(struct cgroup_subsys_state *);
	int (*css_online)(struct cgroup_subsys_state *);
	void (*css_offline)(struct cgroup_subsys_state *);
	void (*css_released)(struct cgroup_subsys_state *);
	void (*css_free)(struct cgroup_subsys_state *);
	void (*css_reset)(struct cgroup_subsys_state *);
	void (*css_rstat_flush)(struct cgroup_subsys_state *, int);
	int (*css_extra_stat_show)(struct seq_file *, struct cgroup_subsys_state *);
	int (*css_local_stat_show)(struct seq_file *, struct cgroup_subsys_state *);
	int (*can_attach)(struct cgroup_taskset *);
	void (*cancel_attach)(struct cgroup_taskset *);
	void (*attach)(struct cgroup_taskset *);
	void (*post_attach)();
	int (*can_fork)(struct task_struct *, struct css_set *);
	void (*cancel_fork)(struct task_struct *, struct css_set *);
	void (*fork)(struct task_struct *);
	void (*exit)(struct task_struct *);
	void (*release)(struct task_struct *);
	void (*bind)(struct cgroup_subsys_state *);
	bool early_init: 1;
	bool implicit_on_dfl: 1;
	bool threaded: 1;
	int id;
	const char *name;
	const char *legacy_name;
	struct cgroup_root *root;
	struct idr css_idr;
	struct list_head cfts;
	struct cftype *dfl_cftypes;
	struct cftype *legacy_cftypes;
	unsigned int depends_on;
};

struct cgroup_rstat_cpu {
	struct u64_stats_sync bsync;
	struct cgroup_base_stat bstat;
	struct cgroup_base_stat last_bstat;
	struct cgroup_base_stat subtree_bstat;
	struct cgroup_base_stat last_subtree_bstat;
	struct cgroup *updated_children;
	struct cgroup *updated_next;
};

struct cgroup_root {
	struct kernfs_root *kf_root;
	unsigned int subsys_mask;
	int hierarchy_id;
	struct cgroup cgrp;
	struct cgroup *cgrp_ancestor_storage;
	atomic_t nr_cgrps;
	struct list_head root_list;
	unsigned int flags;
	char release_agent_path[4096];
	char name[64];
};

struct cftype {
	char name[64];
	long unsigned int private;
	size_t max_write_len;
	unsigned int flags;
	unsigned int file_offset;
	struct cgroup_subsys *ss;
	struct list_head node;
	struct kernfs_ops *kf_ops;
	int (*open)(struct kernfs_open_file *);
	void (*release)(struct kernfs_open_file *);
	u64 (*read_u64)(struct cgroup_subsys_state *, struct cftype *);
	s64 (*read_s64)(struct cgroup_subsys_state *, struct cftype *);
	int (*seq_show)(struct seq_file *, void *);
	void * (*seq_start)(struct seq_file *, loff_t *);
	void * (*seq_next)(struct seq_file *, void *, loff_t *);
	void (*seq_stop)(struct seq_file *, void *);
	int (*write_u64)(struct cgroup_subsys_state *, struct cftype *, u64);
	int (*write_s64)(struct cgroup_subsys_state *, struct cftype *, s64);
	ssize_t (*write)(struct kernfs_open_file *, char *, size_t, loff_t);
	__poll_t (*poll)(struct kernfs_open_file *, struct poll_table_struct *);
	struct lock_class_key lockdep_key;
};

struct perf_callchain_entry {
	__u64 nr;
	__u64 ip[0];
};

struct perf_callchain_entry_ctx {
	struct perf_callchain_entry *entry;
	u32 max_stack;
	u32 nr;
	short int contexts;
	bool contexts_maxed;
};

typedef long unsigned int (*perf_copy_f)(void *, const void *, long unsigned int, long unsigned int);

struct perf_raw_frag {
	union {
		struct perf_raw_frag *next;
		long unsigned int pad;
	};
	perf_copy_f copy;
	void *data;
	u32 size;
} __attribute__((packed));

struct perf_raw_record {
	struct perf_raw_frag frag;
	u32 size;
};

struct perf_branch_stack {
	__u64 nr;
	__u64 hw_idx;
	struct perf_branch_entry entries[0];
};

struct perf_event_pmu_context {
	struct pmu *pmu;
	struct perf_event_context *ctx;
	struct list_head pmu_ctx_entry;
	struct list_head pinned_active;
	struct list_head flexible_active;
	unsigned int embedded: 1;
	unsigned int nr_events;
	unsigned int nr_cgroups;
	atomic_t refcount;
	struct callback_head callback_head;
	void *task_ctx_data;
	int rotate_necessary;
};

struct perf_cpu_pmu_context {
	struct perf_event_pmu_context epc;
	struct perf_event_pmu_context *task_epc;
	struct list_head sched_cb_entry;
	int sched_cb_usage;
	int active_oncpu;
	int exclusive;
	raw_spinlock_t hrtimer_lock;
	struct hrtimer hrtimer;
	ktime_t hrtimer_interval;
	unsigned int hrtimer_active;
};

struct perf_output_handle {
	struct perf_event *event;
	struct perf_buffer *rb;
	long unsigned int wakeup;
	long unsigned int size;
	u64 aux_flags;
	union {
		void *addr;
		long unsigned int head;
	};
	int page;
};

struct perf_addr_filter_range {
	long unsigned int start;
	long unsigned int size;
};

struct perf_sample_data {
	u64 sample_flags;
	u64 period;
	u64 dyn_size;
	u64 type;
	struct {
		u32 pid;
		u32 tid;
	} tid_entry;
	u64 time;
	u64 id;
	struct {
		u32 cpu;
		u32 reserved;
	} cpu_entry;
	u64 ip;
	struct perf_callchain_entry *callchain;
	struct perf_raw_record *raw;
	struct perf_branch_stack *br_stack;
	union perf_sample_weight weight;
	union perf_mem_data_src data_src;
	u64 txn;
	struct perf_regs regs_user;
	struct perf_regs regs_intr;
	u64 stack_user_size;
	u64 stream_id;
	u64 cgroup;
	u64 addr;
	u64 phys_addr;
	u64 data_page_size;
	u64 code_page_size;
	u64 aux_size;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct perf_cgroup_info;

struct perf_cgroup {
	struct cgroup_subsys_state css;
	struct perf_cgroup_info *info;
};

struct perf_cgroup_info {
	u64 time;
	u64 timestamp;
	u64 timeoffset;
	int active;
};

struct perf_pmu_events_attr {
	struct device_attribute attr;
	u64 id;
	const char *event_str;
};

struct perf_pmu_events_ht_attr {
	struct device_attribute attr;
	u64 id;
	const char *event_str_ht;
	const char *event_str_noht;
};

struct perf_pmu_events_hybrid_attr {
	struct device_attribute attr;
	u64 id;
	const char *event_str;
	u64 pmu_type;
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

struct fwnode_reference_args;

struct fwnode_endpoint;

struct fwnode_operations {
	struct fwnode_handle * (*get)(struct fwnode_handle *);
	void (*put)(struct fwnode_handle *);
	bool (*device_is_available)(const struct fwnode_handle *);
	const void * (*device_get_match_data)(const struct fwnode_handle *, const struct device *);
	bool (*device_dma_supported)(const struct fwnode_handle *);
	enum dev_dma_attr (*device_get_dma_attr)(const struct fwnode_handle *);
	bool (*property_present)(const struct fwnode_handle *, const char *);
	int (*property_read_int_array)(const struct fwnode_handle *, const char *, unsigned int, void *, size_t);
	int (*property_read_string_array)(const struct fwnode_handle *, const char *, const char **, size_t);
	const char * (*get_name)(const struct fwnode_handle *);
	const char * (*get_name_prefix)(const struct fwnode_handle *);
	struct fwnode_handle * (*get_parent)(const struct fwnode_handle *);
	struct fwnode_handle * (*get_next_child_node)(const struct fwnode_handle *, struct fwnode_handle *);
	struct fwnode_handle * (*get_named_child_node)(const struct fwnode_handle *, const char *);
	int (*get_reference_args)(const struct fwnode_handle *, const char *, const char *, unsigned int, unsigned int, struct fwnode_reference_args *);
	struct fwnode_handle * (*graph_get_next_endpoint)(const struct fwnode_handle *, struct fwnode_handle *);
	struct fwnode_handle * (*graph_get_remote_endpoint)(const struct fwnode_handle *);
	struct fwnode_handle * (*graph_get_port_parent)(struct fwnode_handle *);
	int (*graph_parse_endpoint)(const struct fwnode_handle *, struct fwnode_endpoint *);
	void * (*iomap)(struct fwnode_handle *, int);
	int (*irq_get)(const struct fwnode_handle *, unsigned int);
	int (*add_links)(struct fwnode_handle *);
};

struct fwnode_endpoint {
	unsigned int port;
	unsigned int id;
	const struct fwnode_handle *local_fwnode;
};

struct fwnode_reference_args {
	struct fwnode_handle *fwnode;
	unsigned int nargs;
	u64 args[8];
};

enum {
	NMI_LOCAL = 0,
	NMI_UNKNOWN = 1,
	NMI_SERR = 2,
	NMI_IO_CHECK = 3,
	NMI_MAX = 4,
};

typedef int (*nmi_handler_t)(unsigned int, struct pt_regs *);

struct nmiaction {
	struct list_head list;
	nmi_handler_t handler;
	u64 max_duration;
	long unsigned int flags;
	const char *name;
};

struct gdt_page {
	struct desc_struct gdt[16];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct cyc2ns_data {
	u32 cyc2ns_mul;
	u32 cyc2ns_shift;
	u64 cyc2ns_offset;
};

struct unwind_state {
	struct stack_info stack_info;
	long unsigned int stack_mask;
	struct task_struct *task;
	int graph_idx;
	struct llist_node *kr_cur;
	bool error;
	bool signal;
	bool full_regs;
	long unsigned int sp;
	long unsigned int bp;
	long unsigned int ip;
	struct pt_regs *regs;
	struct pt_regs *prev_regs;
};

enum extra_reg_type {
	EXTRA_REG_NONE = -1,
	EXTRA_REG_RSP_0 = 0,
	EXTRA_REG_RSP_1 = 1,
	EXTRA_REG_LBR = 2,
	EXTRA_REG_LDLAT = 3,
	EXTRA_REG_FE = 4,
	EXTRA_REG_SNOOP_0 = 5,
	EXTRA_REG_SNOOP_1 = 6,
	EXTRA_REG_MAX = 7,
};

struct event_constraint {
	union {
		long unsigned int idxmsk[1];
		u64 idxmsk64;
	};
	u64 code;
	u64 cmask;
	int weight;
	int overlap;
	int flags;
	unsigned int size;
};

enum {
	PERF_X86_EVENT_PEBS_LDLAT = 1,
	PERF_X86_EVENT_PEBS_ST = 2,
	PERF_X86_EVENT_PEBS_ST_HSW = 4,
	PERF_X86_EVENT_PEBS_LD_HSW = 8,
	PERF_X86_EVENT_PEBS_NA_HSW = 16,
	PERF_X86_EVENT_EXCL = 32,
	PERF_X86_EVENT_DYNAMIC = 64,
	PERF_X86_EVENT_EXCL_ACCT = 256,
	PERF_X86_EVENT_AUTO_RELOAD = 512,
	PERF_X86_EVENT_LARGE_PEBS = 1024,
	PERF_X86_EVENT_PEBS_VIA_PT = 2048,
	PERF_X86_EVENT_PAIR = 4096,
	PERF_X86_EVENT_LBR_SELECT = 8192,
	PERF_X86_EVENT_TOPDOWN = 16384,
	PERF_X86_EVENT_PEBS_STLAT = 32768,
	PERF_X86_EVENT_AMD_BRS = 65536,
	PERF_X86_EVENT_PEBS_LAT_HYBRID = 131072,
};

struct amd_nb {
	int nb_id;
	int refcnt;
	struct perf_event *owners[64];
	struct event_constraint event_constraints[64];
};

struct er_account {
	raw_spinlock_t lock;
	u64 config;
	u64 reg;
	atomic_t ref;
};

struct intel_shared_regs {
	struct er_account regs[7];
	int refcnt;
	unsigned int core_id;
};

enum intel_excl_state_type {
	INTEL_EXCL_UNUSED = 0,
	INTEL_EXCL_SHARED = 1,
	INTEL_EXCL_EXCLUSIVE = 2,
};

struct intel_excl_states {
	enum intel_excl_state_type state[64];
	bool sched_started;
};

struct intel_excl_cntrs {
	raw_spinlock_t lock;
	struct intel_excl_states states[2];
	union {
		u16 has_exclusive[2];
		u32 exclusive_present;
	};
	int refcnt;
	unsigned int core_id;
};

enum {
	X86_PERF_KFREE_SHARED = 0,
	X86_PERF_KFREE_EXCL = 1,
	X86_PERF_KFREE_MAX = 2,
};

struct cpu_hw_events {
	struct perf_event *events[64];
	long unsigned int active_mask[1];
	long unsigned int dirty[1];
	int enabled;
	int n_events;
	int n_added;
	int n_txn;
	int n_txn_pair;
	int n_txn_metric;
	int assign[64];
	u64 tags[64];
	struct perf_event *event_list[64];
	struct event_constraint *event_constraint[64];
	int n_excl;
	unsigned int txn_flags;
	int is_fake;
	struct debug_store *ds;
	void *ds_pebs_vaddr;
	void *ds_bts_vaddr;
	u64 pebs_enabled;
	int n_pebs;
	int n_large_pebs;
	int n_pebs_via_pt;
	int pebs_output;
	u64 pebs_data_cfg;
	u64 active_pebs_data_cfg;
	int pebs_record_size;
	u64 fixed_ctrl_val;
	u64 active_fixed_ctrl_val;
	int lbr_users;
	int lbr_pebs_users;
	struct perf_branch_stack lbr_stack;
	struct perf_branch_entry lbr_entries[32];
	union {
		struct er_account *lbr_sel;
		struct er_account *lbr_ctl;
	};
	u64 br_sel;
	void *last_task_ctx;
	int last_log_id;
	int lbr_select;
	void *lbr_xsave;
	u64 intel_ctrl_guest_mask;
	u64 intel_ctrl_host_mask;
	struct perf_guest_switch_msr guest_switch_msrs[64];
	u64 intel_cp_status;
	struct intel_shared_regs *shared_regs;
	struct event_constraint *constraint_list;
	struct intel_excl_cntrs *excl_cntrs;
	int excl_thread_id;
	u64 tfa_shadow;
	int n_metric;
	struct amd_nb *amd_nb;
	int brs_active;
	u64 perf_ctr_virt_mask;
	int n_pair;
	void *kfree_on_online[2];
	struct pmu *pmu;
};

struct extra_reg {
	unsigned int event;
	unsigned int msr;
	u64 config_mask;
	u64 valid_mask;
	int idx;
	bool extra_msr_access;
};

union perf_capabilities {
	struct {
		u64 lbr_format: 6;
		u64 pebs_trap: 1;
		u64 pebs_arch_reg: 1;
		u64 pebs_format: 4;
		u64 smm_freeze: 1;
		u64 full_width_write: 1;
		u64 pebs_baseline: 1;
		u64 perf_metrics: 1;
		u64 pebs_output_pt_available: 1;
		u64 pebs_timing_info: 1;
		u64 anythread_deprecated: 1;
	};
	u64 capabilities;
};

struct x86_pmu_quirk {
	struct x86_pmu_quirk *next;
	void (*func)();
};

enum {
	x86_lbr_exclusive_lbr = 0,
	x86_lbr_exclusive_bts = 1,
	x86_lbr_exclusive_pt = 2,
	x86_lbr_exclusive_max = 3,
};

enum hybrid_cpu_type {
	HYBRID_INTEL_NONE = 0,
	HYBRID_INTEL_ATOM = 32,
	HYBRID_INTEL_CORE = 64,
};

enum hybrid_pmu_type {
	not_hybrid = 0,
	hybrid_small = 1,
	hybrid_big = 2,
	hybrid_big_small = 3,
};

struct x86_hybrid_pmu {
	struct pmu pmu;
	const char *name;
	enum hybrid_pmu_type pmu_type;
	cpumask_t supported_cpus;
	union perf_capabilities intel_cap;
	u64 intel_ctrl;
	int max_pebs_events;
	int num_counters;
	int num_counters_fixed;
	struct event_constraint unconstrained;
	u64 hw_cache_event_ids[42];
	u64 hw_cache_extra_regs[42];
	struct event_constraint *event_constraints;
	struct event_constraint *pebs_constraints;
	struct extra_reg *extra_regs;
	unsigned int late_ack: 1;
	unsigned int mid_ack: 1;
	unsigned int enabled_ack: 1;
	u64 pebs_data_source[16];
};

struct x86_pmu {
	const char *name;
	int version;
	int (*handle_irq)(struct pt_regs *);
	void (*disable_all)();
	void (*enable_all)(int);
	void (*enable)(struct perf_event *);
	void (*disable)(struct perf_event *);
	void (*assign)(struct perf_event *, int);
	void (*add)(struct perf_event *);
	void (*del)(struct perf_event *);
	void (*read)(struct perf_event *);
	int (*set_period)(struct perf_event *);
	u64 (*update)(struct perf_event *);
	int (*hw_config)(struct perf_event *);
	int (*schedule_events)(struct cpu_hw_events *, int, int *);
	unsigned int eventsel;
	unsigned int perfctr;
	int (*addr_offset)(int, bool);
	int (*rdpmc_index)(int);
	u64 (*event_map)(int);
	int max_events;
	int num_counters;
	int num_counters_fixed;
	int cntval_bits;
	u64 cntval_mask;
	union {
		long unsigned int events_maskl;
		long unsigned int events_mask[1];
	};
	int events_mask_len;
	int apic;
	u64 max_period;
	struct event_constraint * (*get_event_constraints)(struct cpu_hw_events *, int, struct perf_event *);
	void (*put_event_constraints)(struct cpu_hw_events *, struct perf_event *);
	void (*start_scheduling)(struct cpu_hw_events *);
	void (*commit_scheduling)(struct cpu_hw_events *, int, int);
	void (*stop_scheduling)(struct cpu_hw_events *);
	struct event_constraint *event_constraints;
	struct x86_pmu_quirk *quirks;
	void (*limit_period)(struct perf_event *, s64 *);
	unsigned int late_ack: 1;
	unsigned int mid_ack: 1;
	unsigned int enabled_ack: 1;
	int attr_rdpmc_broken;
	int attr_rdpmc;
	struct attribute **format_attrs;
	ssize_t (*events_sysfs_show)(char *, u64);
	const struct attribute_group **attr_update;
	long unsigned int attr_freeze_on_smi;
	int (*cpu_prepare)(int);
	void (*cpu_starting)(int);
	void (*cpu_dying)(int);
	void (*cpu_dead)(int);
	void (*check_microcode)();
	void (*sched_task)(struct perf_event_pmu_context *, bool);
	u64 intel_ctrl;
	union perf_capabilities intel_cap;
	unsigned int bts: 1;
	unsigned int bts_active: 1;
	unsigned int pebs: 1;
	unsigned int pebs_active: 1;
	unsigned int pebs_broken: 1;
	unsigned int pebs_prec_dist: 1;
	unsigned int pebs_no_tlb: 1;
	unsigned int pebs_no_isolation: 1;
	unsigned int pebs_block: 1;
	unsigned int pebs_ept: 1;
	int pebs_record_size;
	int pebs_buffer_size;
	int max_pebs_events;
	void (*drain_pebs)(struct pt_regs *, struct perf_sample_data *);
	struct event_constraint *pebs_constraints;
	void (*pebs_aliases)(struct perf_event *);
	u64 (*pebs_latency_data)(struct perf_event *, u64);
	long unsigned int large_pebs_flags;
	u64 rtm_abort_event;
	u64 pebs_capable;
	unsigned int lbr_tos;
	unsigned int lbr_from;
	unsigned int lbr_to;
	unsigned int lbr_info;
	unsigned int lbr_nr;
	union {
		u64 lbr_sel_mask;
		u64 lbr_ctl_mask;
	};
	union {
		const int *lbr_sel_map;
		int *lbr_ctl_map;
	};
	bool lbr_double_abort;
	bool lbr_pt_coexist;
	unsigned int lbr_has_info: 1;
	unsigned int lbr_has_tsx: 1;
	unsigned int lbr_from_flags: 1;
	unsigned int lbr_to_cycles: 1;
	unsigned int lbr_depth_mask: 8;
	unsigned int lbr_deep_c_reset: 1;
	unsigned int lbr_lip: 1;
	unsigned int lbr_cpl: 1;
	unsigned int lbr_filter: 1;
	unsigned int lbr_call_stack: 1;
	unsigned int lbr_mispred: 1;
	unsigned int lbr_timed_lbr: 1;
	unsigned int lbr_br_type: 1;
	void (*lbr_reset)();
	void (*lbr_read)(struct cpu_hw_events *);
	void (*lbr_save)(void *);
	void (*lbr_restore)(void *);
	atomic_t lbr_exclusive[3];
	int num_topdown_events;
	void (*swap_task_ctx)(struct perf_event_pmu_context *, struct perf_event_pmu_context *);
	unsigned int amd_nb_constraints: 1;
	u64 perf_ctr_pair_en;
	struct extra_reg *extra_regs;
	unsigned int flags;
	struct perf_guest_switch_msr * (*guest_get_msrs)(int *, void *);
	int (*check_period)(struct perf_event *, u64);
	int (*aux_output_match)(struct perf_event *);
	void (*filter)(struct pmu *, int, bool *);
	int num_hybrid_pmus;
	struct x86_hybrid_pmu *hybrid_pmu;
	enum hybrid_cpu_type (*get_hybrid_cpu_type)();
};

struct sched_state {
	int weight;
	int event;
	int counter;
	int unassigned;
	int nr_gp;
	u64 used;
};

struct perf_sched {
	int max_weight;
	int max_events;
	int max_gp;
	int saved_states;
	struct event_constraint **constraints;
	struct sched_state state;
	struct sched_state saved[2];
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum tlb_infos {
	ENTRIES = 0,
	NR_INFO = 1,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_FREE_CMA_PAGES = 9,
	NR_VM_ZONE_STAT_ITEMS = 10,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_SWAPCACHE = 40,
	PGPROMOTE_SUCCESS = 41,
	PGPROMOTE_CANDIDATE = 42,
	NR_VM_NODE_STAT_ITEMS = 43,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum {
	TASK_COMM_LEN = 16,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

struct perf_msr {
	u64 msr;
	struct attribute_group *grp;
	bool (*test)(int, void *);
	bool no_check;
	u64 mask;
};

typedef unsigned int insn_attr_t;

typedef unsigned char insn_byte_t;

typedef int insn_value_t;

struct insn_field {
	union {
		insn_value_t value;
		insn_byte_t bytes[4];
	};
	unsigned char got;
	unsigned char nbytes;
};

struct insn {
	struct insn_field prefixes;
	struct insn_field rex_prefix;
	struct insn_field vex_prefix;
	struct insn_field opcode;
	struct insn_field modrm;
	struct insn_field sib;
	struct insn_field displacement;
	union {
		struct insn_field immediate;
		struct insn_field moffset1;
		struct insn_field immediate1;
	};
	union {
		struct insn_field moffset2;
		struct insn_field immediate2;
	};
	int emulate_prefix_size;
	insn_attr_t attr;
	unsigned char opnd_bytes;
	unsigned char addr_bytes;
	unsigned char length;
	unsigned char x86_64;
	const insn_byte_t *kaddr;
	const insn_byte_t *end_kaddr;
	const insn_byte_t *next_byte;
};

enum {
	PERF_BR_UNKNOWN = 0,
	PERF_BR_COND = 1,
	PERF_BR_UNCOND = 2,
	PERF_BR_IND = 3,
	PERF_BR_CALL = 4,
	PERF_BR_IND_CALL = 5,
	PERF_BR_RET = 6,
	PERF_BR_SYSCALL = 7,
	PERF_BR_SYSRET = 8,
	PERF_BR_COND_CALL = 9,
	PERF_BR_COND_RET = 10,
	PERF_BR_ERET = 11,
	PERF_BR_IRQ = 12,
	PERF_BR_SERROR = 13,
	PERF_BR_NO_TX = 14,
	PERF_BR_EXTEND_ABI = 15,
	PERF_BR_MAX = 16,
};

enum {
	X86_BR_NONE = 0,
	X86_BR_USER = 1,
	X86_BR_KERNEL = 2,
	X86_BR_CALL = 4,
	X86_BR_RET = 8,
	X86_BR_SYSCALL = 16,
	X86_BR_SYSRET = 32,
	X86_BR_INT = 64,
	X86_BR_IRET = 128,
	X86_BR_JCC = 256,
	X86_BR_JMP = 512,
	X86_BR_IRQ = 1024,
	X86_BR_IND_CALL = 2048,
	X86_BR_ABORT = 4096,
	X86_BR_IN_TX = 8192,
	X86_BR_NO_TX = 16384,
	X86_BR_ZERO_CALL = 32768,
	X86_BR_CALL_STACK = 65536,
	X86_BR_IND_JMP = 131072,
	X86_BR_TYPE_SAVE = 262144,
};

typedef void (*exitcall_t)();

typedef struct cpumask cpumask_var_t[1];

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

struct x86_cpu_id {
	__u16 vendor;
	__u16 family;
	__u16 model;
	__u16 steppings;
	__u16 feature;
	kernel_ulong_t driver_data;
};

enum perf_rapl_events {
	PERF_RAPL_PP0 = 0,
	PERF_RAPL_PKG = 1,
	PERF_RAPL_RAM = 2,
	PERF_RAPL_PP1 = 3,
	PERF_RAPL_PSYS = 4,
	PERF_RAPL_MAX = 5,
	NR_RAPL_DOMAINS = 5,
};

struct rapl_pmu {
	raw_spinlock_t lock;
	int n_active;
	int cpu;
	struct list_head active_list;
	struct pmu *pmu;
	ktime_t timer_interval;
	struct hrtimer hrtimer;
};

struct rapl_pmus {
	struct pmu pmu;
	unsigned int maxdie;
	struct rapl_pmu *pmus[0];
};

enum rapl_unit_quirk {
	RAPL_UNIT_QUIRK_NONE = 0,
	RAPL_UNIT_QUIRK_INTEL_HSW = 1,
	RAPL_UNIT_QUIRK_INTEL_SPR = 2,
};

struct rapl_model {
	struct perf_msr *rapl_msrs;
	long unsigned int events;
	unsigned int msr_power_unit;
	enum rapl_unit_quirk unit_quirk;
};

union cpuid_0x80000022_ebx {
	struct {
		unsigned int num_core_pmc: 4;
		unsigned int lbr_v2_stack_sz: 6;
		unsigned int num_df_pmc: 6;
		unsigned int num_umc_pmc: 6;
	} split;
	unsigned int full;
};

typedef void amd_pmu_branch_reset_t();

enum {
	PERF_BR_SPEC_NA = 0,
	PERF_BR_SPEC_WRONG_PATH = 1,
	PERF_BR_NON_SPEC_CORRECT_PATH = 2,
	PERF_BR_SPEC_CORRECT_PATH = 3,
	PERF_BR_SPEC_MAX = 4,
};

struct branch_entry {
	union {
		struct {
			u64 ip: 58;
			u64 ip_sign_ext: 5;
			u64 mispredict: 1;
		} split;
		u64 full;
	} from;
	union {
		struct {
			u64 ip: 58;
			u64 ip_sign_ext: 3;
			u64 reserved: 1;
			u64 spec: 1;
			u64 valid: 1;
		} split;
		u64 full;
	} to;
};

typedef phys_addr_t resource_size_t;

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct pci_device_id {
	__u32 vendor;
	__u32 device;
	__u32 subvendor;
	__u32 subdevice;
	__u32 class;
	__u32 class_mask;
	kernel_ulong_t driver_data;
	__u32 override_only;
};

struct pci_bus;

struct hotplug_slot;

struct pci_slot {
	struct pci_bus *bus;
	struct list_head list;
	struct hotplug_slot *hotplug;
	unsigned char number;
	struct kobject kobj;
};

typedef short unsigned int pci_bus_flags_t;

struct pci_dev;

struct pci_ops;

struct proc_dir_entry;

struct pci_bus {
	struct list_head node;
	struct pci_bus *parent;
	struct list_head children;
	struct list_head devices;
	struct pci_dev *self;
	struct list_head slots;
	struct resource *resource[4];
	struct list_head resources;
	struct resource busn_res;
	struct pci_ops *ops;
	void *sysdata;
	struct proc_dir_entry *procdir;
	unsigned char number;
	unsigned char primary;
	unsigned char max_bus_speed;
	unsigned char cur_bus_speed;
	char name[48];
	short unsigned int bridge_ctl;
	pci_bus_flags_t bus_flags;
	struct device *bridge;
	struct device dev;
	struct bin_attribute *legacy_io;
	struct bin_attribute *legacy_mem;
	unsigned int is_added: 1;
	unsigned int unsafe_warn: 1;
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

typedef int pci_power_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pcie_reset_state_t;

typedef short unsigned int pci_dev_flags_t;

struct pci_vpd {
	struct mutex lock;
	unsigned int len;
	u8 cap;
};

struct rcec_ea;

struct pci_driver;

struct pcie_link_state;

struct pci_sriov;

struct pci_dev {
	struct list_head bus_list;
	struct pci_bus *bus;
	struct pci_bus *subordinate;
	void *sysdata;
	struct proc_dir_entry *procent;
	struct pci_slot *slot;
	unsigned int devfn;
	short unsigned int vendor;
	short unsigned int device;
	short unsigned int subsystem_vendor;
	short unsigned int subsystem_device;
	unsigned int class;
	u8 revision;
	u8 hdr_type;
	struct rcec_ea *rcec_ea;
	struct pci_dev *rcec;
	u32 devcap;
	u8 pcie_cap;
	u8 msi_cap;
	u8 msix_cap;
	u8 pcie_mpss: 3;
	u8 rom_base_reg;
	u8 pin;
	u16 pcie_flags_reg;
	long unsigned int *dma_alias_mask;
	struct pci_driver *driver;
	u64 dma_mask;
	struct device_dma_parameters dma_parms;
	pci_power_t current_state;
	u8 pm_cap;
	unsigned int imm_ready: 1;
	unsigned int pme_support: 5;
	unsigned int pme_poll: 1;
	unsigned int d1_support: 1;
	unsigned int d2_support: 1;
	unsigned int no_d1d2: 1;
	unsigned int no_d3cold: 1;
	unsigned int bridge_d3: 1;
	unsigned int d3cold_allowed: 1;
	unsigned int mmio_always_on: 1;
	unsigned int wakeup_prepared: 1;
	unsigned int skip_bus_pm: 1;
	unsigned int ignore_hotplug: 1;
	unsigned int hotplug_user_indicators: 1;
	unsigned int clear_retrain_link: 1;
	unsigned int d3hot_delay;
	unsigned int d3cold_delay;
	struct pcie_link_state *link_state;
	u16 l1ss;
	unsigned int ltr_path: 1;
	unsigned int pasid_no_tlp: 1;
	unsigned int eetlp_prefix_path: 1;
	pci_channel_state_t error_state;
	struct device dev;
	int cfg_size;
	unsigned int irq;
	struct resource resource[17];
	struct resource driver_exclusive_resource;
	bool match_driver;
	unsigned int transparent: 1;
	unsigned int io_window: 1;
	unsigned int pref_window: 1;
	unsigned int pref_64_window: 1;
	unsigned int multifunction: 1;
	unsigned int is_busmaster: 1;
	unsigned int no_msi: 1;
	unsigned int no_64bit_msi: 1;
	unsigned int block_cfg_access: 1;
	unsigned int broken_parity_status: 1;
	unsigned int irq_reroute_variant: 2;
	unsigned int msi_enabled: 1;
	unsigned int msix_enabled: 1;
	unsigned int ari_enabled: 1;
	unsigned int ats_enabled: 1;
	unsigned int pasid_enabled: 1;
	unsigned int pri_enabled: 1;
	unsigned int is_managed: 1;
	unsigned int is_msi_managed: 1;
	unsigned int needs_freset: 1;
	unsigned int state_saved: 1;
	unsigned int is_physfn: 1;
	unsigned int is_virtfn: 1;
	unsigned int is_hotplug_bridge: 1;
	unsigned int shpc_managed: 1;
	unsigned int is_thunderbolt: 1;
	unsigned int untrusted: 1;
	unsigned int external_facing: 1;
	unsigned int broken_intx_masking: 1;
	unsigned int io_window_1k: 1;
	unsigned int irq_managed: 1;
	unsigned int non_compliant_bars: 1;
	unsigned int is_probed: 1;
	unsigned int link_active_reporting: 1;
	unsigned int no_vf_scan: 1;
	unsigned int no_command_memory: 1;
	unsigned int rom_bar_overlap: 1;
	unsigned int rom_attr_enabled: 1;
	pci_dev_flags_t dev_flags;
	atomic_t enable_cnt;
	spinlock_t pcie_cap_lock;
	u32 saved_config_space[16];
	struct hlist_head saved_cap_space;
	struct bin_attribute *res_attr[17];
	struct bin_attribute *res_attr_wc[17];
	void *msix_base;
	raw_spinlock_t msi_lock;
	struct pci_vpd vpd;
	union {
		struct pci_sriov *sriov;
		struct pci_dev *physfn;
	};
	u16 ats_cap;
	u8 ats_stu;
	u16 acs_cap;
	phys_addr_t rom;
	size_t romlen;
	const char *driver_override;
	long unsigned int priv_flags;
	u8 reset_methods[7];
};

struct pci_dynids {
	spinlock_t lock;
	struct list_head list;
};

struct pci_error_handlers;

struct pci_driver {
	struct list_head node;
	const char *name;
	const struct pci_device_id *id_table;
	int (*probe)(struct pci_dev *, const struct pci_device_id *);
	void (*remove)(struct pci_dev *);
	int (*suspend)(struct pci_dev *, pm_message_t);
	int (*resume)(struct pci_dev *);
	void (*shutdown)(struct pci_dev *);
	int (*sriov_configure)(struct pci_dev *, int);
	int (*sriov_set_msix_vec_count)(struct pci_dev *, int);
	u32 (*sriov_get_vf_total_msix)(struct pci_dev *);
	const struct pci_error_handlers *err_handler;
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	struct device_driver driver;
	struct pci_dynids dynids;
	bool driver_managed_dma;
};

struct pci_ops {
	int (*add_bus)(struct pci_bus *);
	void (*remove_bus)(struct pci_bus *);
	void * (*map_bus)(struct pci_bus *, unsigned int, int);
	int (*read)(struct pci_bus *, unsigned int, int, int, u32 *);
	int (*write)(struct pci_bus *, unsigned int, int, int, u32);
};

typedef unsigned int pci_ers_result_t;

struct pci_error_handlers {
	pci_ers_result_t (*error_detected)(struct pci_dev *, pci_channel_state_t);
	pci_ers_result_t (*mmio_enabled)(struct pci_dev *);
	pci_ers_result_t (*slot_reset)(struct pci_dev *);
	void (*reset_prepare)(struct pci_dev *);
	void (*reset_done)(struct pci_dev *);
	void (*resume)(struct pci_dev *);
	void (*cor_error_detected)(struct pci_dev *);
};

struct syscore_ops {
	struct list_head node;
	int (*suspend)();
	void (*resume)();
	void (*shutdown)();
};

union ibs_fetch_ctl {
	__u64 val;
	struct {
		__u64 fetch_maxcnt: 16;
		__u64 fetch_cnt: 16;
		__u64 fetch_lat: 16;
		__u64 fetch_en: 1;
		__u64 fetch_val: 1;
		__u64 fetch_comp: 1;
		__u64 ic_miss: 1;
		__u64 phy_addr_valid: 1;
		__u64 l1tlb_pgsz: 2;
		__u64 l1tlb_miss: 1;
		__u64 l2tlb_miss: 1;
		__u64 rand_en: 1;
		__u64 fetch_l2_miss: 1;
		__u64 l3_miss_only: 1;
		__u64 fetch_oc_miss: 1;
		__u64 fetch_l3_miss: 1;
		__u64 reserved: 2;
	};
};

union ibs_op_ctl {
	__u64 val;
	struct {
		__u64 opmaxcnt: 16;
		__u64 l3_miss_only: 1;
		__u64 op_en: 1;
		__u64 op_val: 1;
		__u64 cnt_ctl: 1;
		__u64 opmaxcnt_ext: 7;
		__u64 reserved0: 5;
		__u64 opcurcnt: 27;
		__u64 reserved1: 5;
	};
};

union ibs_op_data {
	__u64 val;
	struct {
		__u64 comp_to_ret_ctr: 16;
		__u64 tag_to_ret_ctr: 16;
		__u64 reserved1: 2;
		__u64 op_return: 1;
		__u64 op_brn_taken: 1;
		__u64 op_brn_misp: 1;
		__u64 op_brn_ret: 1;
		__u64 op_rip_invalid: 1;
		__u64 op_brn_fuse: 1;
		__u64 op_microcode: 1;
		__u64 reserved2: 23;
	};
};

union ibs_op_data2 {
	__u64 val;
	struct {
		__u64 data_src_lo: 3;
		__u64 reserved0: 1;
		__u64 rmt_node: 1;
		__u64 cache_hit_st: 1;
		__u64 data_src_hi: 2;
		__u64 reserved1: 56;
	};
};

union ibs_op_data3 {
	__u64 val;
	struct {
		__u64 ld_op: 1;
		__u64 st_op: 1;
		__u64 dc_l1tlb_miss: 1;
		__u64 dc_l2tlb_miss: 1;
		__u64 dc_l1tlb_hit_2m: 1;
		__u64 dc_l1tlb_hit_1g: 1;
		__u64 dc_l2tlb_hit_2m: 1;
		__u64 dc_miss: 1;
		__u64 dc_mis_acc: 1;
		__u64 reserved: 4;
		__u64 dc_wc_mem_acc: 1;
		__u64 dc_uc_mem_acc: 1;
		__u64 dc_locked_op: 1;
		__u64 dc_miss_no_mab_alloc: 1;
		__u64 dc_lin_addr_valid: 1;
		__u64 dc_phy_addr_valid: 1;
		__u64 dc_l2_tlb_hit_1g: 1;
		__u64 l2_miss: 1;
		__u64 sw_pf: 1;
		__u64 op_mem_width: 4;
		__u64 op_dc_miss_open_mem_reqs: 6;
		__u64 dc_miss_lat: 16;
		__u64 tlb_refill_lat: 16;
	};
};

struct perf_ibs_data {
	u32 size;
	union {
		u32 data[0];
		u32 caps;
	};
	u64 regs[8];
};

enum ibs_states {
	IBS_ENABLED = 0,
	IBS_STARTED = 1,
	IBS_STOPPING = 2,
	IBS_STOPPED = 3,
	IBS_MAX_STATES = 4,
};

struct cpu_perf_ibs {
	struct perf_event *event;
	long unsigned int state[1];
};

struct perf_ibs {
	struct pmu pmu;
	unsigned int msr;
	u64 config_mask;
	u64 cnt_mask;
	u64 enable_mask;
	u64 valid_mask;
	u64 max_period;
	long unsigned int offset_mask[1];
	int offset_max;
	unsigned int fetch_count_reset_broken: 1;
	unsigned int fetch_ignore_if_zero_rip: 1;
	struct cpu_perf_ibs *pcpu;
	u64 (*get_count)(u64);
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_error = 10,
	PG_slab = 11,
	PG_owner_priv_1 = 12,
	PG_arch_1 = 13,
	PG_reserved = 14,
	PG_private = 15,
	PG_private_2 = 16,
	PG_mappedtodisk = 17,
	PG_reclaim = 18,
	PG_swapbacked = 19,
	PG_unevictable = 20,
	PG_mlocked = 21,
	PG_uncached = 22,
	PG_hwpoison = 23,
	__NR_PAGEFLAGS = 24,
	PG_readahead = 18,
	PG_anon_exclusive = 17,
	PG_checked = 12,
	PG_swapcache = 12,
	PG_fscache = 16,
	PG_pinned = 12,
	PG_savepinned = 4,
	PG_foreign = 12,
	PG_xen_remapped = 12,
	PG_isolated = 18,
	PG_reported = 3,
	PG_has_hwpoisoned = 10,
	PG_hugetlb = 8,
	PG_large_rmappable = 9,
};

struct bts_ctx {
	struct perf_output_handle handle;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct debug_store ds_back;
	int state;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum {
	BTS_STATE_STOPPED = 0,
	BTS_STATE_INACTIVE = 1,
	BTS_STATE_ACTIVE = 2,
};

struct bts_phys {
	struct page *page;
	long unsigned int size;
	long unsigned int offset;
	long unsigned int displacement;
};

struct bts_buffer {
	size_t real_size;
	unsigned int nr_pages;
	unsigned int nr_bufs;
	unsigned int cur_buf;
	bool snapshot;
	local_t data_size;
	local_t head;
	long unsigned int end;
	void **data_pages;
	struct bts_phys buf[0];
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, long unsigned int, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block *next;
	int priority;
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

struct acpi_device;

struct pci_sysdata {
	int domain;
	int node;
	struct acpi_device *companion;
	void *iommu;
	void *fwnode;
};

struct pci_extra_dev {
	struct pci_dev *dev[4];
};

struct intel_uncore_pmu;

struct intel_uncore_ops;

struct uncore_event_desc;

struct freerunning_counters;

struct intel_uncore_topology;

struct intel_uncore_type {
	const char *name;
	int num_counters;
	int num_boxes;
	int perf_ctr_bits;
	int fixed_ctr_bits;
	int num_freerunning_types;
	int type_id;
	unsigned int perf_ctr;
	unsigned int event_ctl;
	unsigned int event_mask;
	unsigned int event_mask_ext;
	unsigned int fixed_ctr;
	unsigned int fixed_ctl;
	unsigned int box_ctl;
	u64 *box_ctls;
	union {
		unsigned int msr_offset;
		unsigned int mmio_offset;
	};
	unsigned int mmio_map_size;
	unsigned int num_shared_regs: 8;
	unsigned int single_fixed: 1;
	unsigned int pair_ctr_ctl: 1;
	union {
		unsigned int *msr_offsets;
		unsigned int *pci_offsets;
		unsigned int *mmio_offsets;
	};
	unsigned int *box_ids;
	struct event_constraint unconstrainted;
	struct event_constraint *constraints;
	struct intel_uncore_pmu *pmus;
	struct intel_uncore_ops *ops;
	struct uncore_event_desc *event_descs;
	struct freerunning_counters *freerunning;
	const struct attribute_group *attr_groups[4];
	const struct attribute_group **attr_update;
	struct pmu *pmu;
	struct intel_uncore_topology **topology;
	int (*get_topology)(struct intel_uncore_type *);
	void (*set_mapping)(struct intel_uncore_type *);
	void (*cleanup_mapping)(struct intel_uncore_type *);
};

struct intel_uncore_box;

struct intel_uncore_pmu {
	struct pmu pmu;
	char name[32];
	int pmu_idx;
	int func_id;
	bool registered;
	atomic_t activeboxes;
	struct intel_uncore_type *type;
	struct intel_uncore_box **boxes;
};

struct intel_uncore_ops {
	void (*init_box)(struct intel_uncore_box *);
	void (*exit_box)(struct intel_uncore_box *);
	void (*disable_box)(struct intel_uncore_box *);
	void (*enable_box)(struct intel_uncore_box *);
	void (*disable_event)(struct intel_uncore_box *, struct perf_event *);
	void (*enable_event)(struct intel_uncore_box *, struct perf_event *);
	u64 (*read_counter)(struct intel_uncore_box *, struct perf_event *);
	int (*hw_config)(struct intel_uncore_box *, struct perf_event *);
	struct event_constraint * (*get_constraint)(struct intel_uncore_box *, struct perf_event *);
	void (*put_constraint)(struct intel_uncore_box *, struct perf_event *);
};

struct uncore_event_desc {
	struct device_attribute attr;
	const char *config;
};

struct freerunning_counters {
	unsigned int counter_base;
	unsigned int counter_offset;
	unsigned int box_offset;
	unsigned int num_counters;
	unsigned int bits;
	unsigned int *box_offsets;
};

struct uncore_iio_topology;

struct uncore_upi_topology;

struct intel_uncore_topology {
	int pmu_idx;
	union {
		void *untyped;
		struct uncore_iio_topology *iio;
		struct uncore_upi_topology *upi;
	};
};

struct intel_uncore_extra_reg {
	raw_spinlock_t lock;
	u64 config;
	u64 config1;
	u64 config2;
	atomic_t ref;
};

struct intel_uncore_box {
	int dieid;
	int n_active;
	int n_events;
	int cpu;
	long unsigned int flags;
	atomic_t refcnt;
	struct perf_event *events[10];
	struct perf_event *event_list[10];
	struct event_constraint *event_constraint[10];
	long unsigned int active_mask[1];
	u64 tags[10];
	struct pci_dev *pci_dev;
	struct intel_uncore_pmu *pmu;
	u64 hrtimer_duration;
	struct hrtimer hrtimer;
	struct list_head list;
	struct list_head active_list;
	void *io_addr;
	struct intel_uncore_extra_reg shared_regs[0];
};

struct uncore_iio_topology {
	int pci_bus_no;
	int segment;
};

struct uncore_upi_topology {
	int die_to;
	int pmu_idx_to;
	int enabled;
};

struct pci2phy_map {
	struct list_head list;
	int segment;
	int pbus_to_dieid[256];
};

struct intel_uncore_init_fun {
	void (*cpu_init)();
	int (*pci_init)();
	void (*mmio_init)();
	bool use_discovery;
	int *uncore_units_ignore;
};

struct pollfd {
	int fd;
	short int events;
	short int revents;
};

struct io_bitmap {
	u64 sequence;
	refcount_t refcnt;
	unsigned int max;
	long unsigned int bitmap[1024];
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum cpu_idle_type {
	CPU_IDLE = 0,
	CPU_NOT_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_PKG_RESOURCES = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	EI_ETYPE_NULL = 0,
	EI_ETYPE_ERRNO = 1,
	EI_ETYPE_ERRNO_NULL = 2,
	EI_ETYPE_TRUE = 3,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

struct trace_event_functions;

struct trace_event {
	struct hlist_node node;
	int type;
	struct trace_event_functions *funcs;
};

struct trace_event_class;

struct trace_event_call {
	struct list_head list;
	struct trace_event_class *class;
	union {
		char *name;
		struct tracepoint *tp;
	};
	struct trace_event event;
	char *print_fmt;
	struct event_filter *filter;
	union {
		void *module;
		atomic_t refcnt;
	};
	void *data;
	int flags;
	int perf_refcount;
	struct hlist_head *perf_events;
	struct bpf_prog_array *prog_array;
	int (*perf_perm)(struct trace_event_call *, struct perf_event *);
};

struct seq_buf {
	char *buffer;
	size_t size;
	size_t len;
	loff_t readpos;
};

struct trace_seq {
	char buffer[4096];
	struct seq_buf seq;
	int full;
};

enum exception_stack_ordering {
	ESTACK_DF = 0,
	ESTACK_NMI = 1,
	ESTACK_DB = 2,
	ESTACK_MCE = 3,
	ESTACK_VC = 4,
	ESTACK_VC2 = 5,
	N_EXCEPTION_STACKS = 6,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_COUNTS = 10,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	NR_STATS = 10,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 37,
	MAX_CGROUP_BPF_ATTACH_TYPE = 38,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	hugetlb_cgrp_id = 9,
	CGROUP_SUBSYS_COUNT = 10,
};

struct trace_entry {
	short unsigned int type;
	unsigned char flags;
	unsigned char preempt_count;
	int pid;
};

struct trace_array;

struct tracer;

struct array_buffer;

struct ring_buffer_iter;

struct trace_iterator {
	struct trace_array *tr;
	struct tracer *trace;
	struct array_buffer *array_buffer;
	void *private;
	int cpu_file;
	struct mutex mutex;
	struct ring_buffer_iter **buffer_iter;
	long unsigned int iter_flags;
	void *temp;
	unsigned int temp_size;
	char *fmt;
	unsigned int fmt_size;
	long int wait_index;
	struct trace_seq tmp_seq;
	cpumask_var_t started;
	bool snapshot;
	struct trace_seq seq;
	struct trace_entry *ent;
	long unsigned int lost_events;
	int leftover;
	int ent_size;
	int cpu;
	u64 ts;
	loff_t pos;
	long int idx;
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

typedef enum print_line_t (*trace_print_func)(struct trace_iterator *, int, struct trace_event *);

struct trace_event_functions {
	trace_print_func trace;
	trace_print_func raw;
	trace_print_func hex;
	trace_print_func binary;
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

struct trace_event_fields {
	const char *type;
	union {
		struct {
			const char *name;
			const int size;
			const int align;
			const int is_signed;
			const int filter_type;
			const int len;
		};
		int (*define_fields)(struct trace_event_call *);
	};
};

struct trace_event_class {
	const char *system;
	void *probe;
	void *perf_probe;
	int (*reg)(struct trace_event_call *, enum trace_reg, void *);
	struct trace_event_fields *fields_array;
	struct list_head * (*get_fields)(struct trace_event_call *);
	struct list_head fields;
	int (*raw_init)(struct trace_event_call *);
};

enum {
	TRACE_EVENT_FL_FILTERED_BIT = 0,
	TRACE_EVENT_FL_CAP_ANY_BIT = 1,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 3,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 4,
	TRACE_EVENT_FL_DYNAMIC_BIT = 5,
	TRACE_EVENT_FL_KPROBE_BIT = 6,
	TRACE_EVENT_FL_UPROBE_BIT = 7,
	TRACE_EVENT_FL_EPROBE_BIT = 8,
	TRACE_EVENT_FL_FPROBE_BIT = 9,
	TRACE_EVENT_FL_CUSTOM_BIT = 10,
};

enum {
	TRACE_EVENT_FL_FILTERED = 1,
	TRACE_EVENT_FL_CAP_ANY = 2,
	TRACE_EVENT_FL_NO_SET_FILTER = 4,
	TRACE_EVENT_FL_IGNORE_ENABLE = 8,
	TRACE_EVENT_FL_TRACEPOINT = 16,
	TRACE_EVENT_FL_DYNAMIC = 32,
	TRACE_EVENT_FL_KPROBE = 64,
	TRACE_EVENT_FL_UPROBE = 128,
	TRACE_EVENT_FL_EPROBE = 256,
	TRACE_EVENT_FL_FPROBE = 512,
	TRACE_EVENT_FL_CUSTOM = 1024,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
};

struct syscall_metadata {
	const char *name;
	int syscall_nr;
	int nb_args;
	const char **types;
	const char **args;
	struct list_head enter_fields;
	struct trace_event_call *enter_event;
	struct trace_event_call *exit_event;
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_DMA32 = 5,
	PGALLOC_NORMAL = 6,
	PGALLOC_MOVABLE = 7,
	ALLOCSTALL_DMA = 8,
	ALLOCSTALL_DMA32 = 9,
	ALLOCSTALL_NORMAL = 10,
	ALLOCSTALL_MOVABLE = 11,
	PGSCAN_SKIP_DMA = 12,
	PGSCAN_SKIP_DMA32 = 13,
	PGSCAN_SKIP_NORMAL = 14,
	PGSCAN_SKIP_MOVABLE = 15,
	PGFREE = 16,
	PGACTIVATE = 17,
	PGDEACTIVATE = 18,
	PGLAZYFREE = 19,
	PGFAULT = 20,
	PGMAJFAULT = 21,
	PGLAZYFREED = 22,
	PGREFILL = 23,
	PGREUSE = 24,
	PGSTEAL_KSWAPD = 25,
	PGSTEAL_DIRECT = 26,
	PGSTEAL_KHUGEPAGED = 27,
	PGDEMOTE_KSWAPD = 28,
	PGDEMOTE_DIRECT = 29,
	PGDEMOTE_KHUGEPAGED = 30,
	PGSCAN_KSWAPD = 31,
	PGSCAN_DIRECT = 32,
	PGSCAN_KHUGEPAGED = 33,
	PGSCAN_DIRECT_THROTTLE = 34,
	PGSCAN_ANON = 35,
	PGSCAN_FILE = 36,
	PGSTEAL_ANON = 37,
	PGSTEAL_FILE = 38,
	PGSCAN_ZONE_RECLAIM_FAILED = 39,
	PGINODESTEAL = 40,
	SLABS_SCANNED = 41,
	KSWAPD_INODESTEAL = 42,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 43,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 44,
	PAGEOUTRUN = 45,
	PGROTATED = 46,
	DROP_PAGECACHE = 47,
	DROP_SLAB = 48,
	OOM_KILL = 49,
	NUMA_PTE_UPDATES = 50,
	NUMA_HUGE_PTE_UPDATES = 51,
	NUMA_HINT_FAULTS = 52,
	NUMA_HINT_FAULTS_LOCAL = 53,
	NUMA_PAGE_MIGRATE = 54,
	PGMIGRATE_SUCCESS = 55,
	PGMIGRATE_FAIL = 56,
	THP_MIGRATION_SUCCESS = 57,
	THP_MIGRATION_FAIL = 58,
	THP_MIGRATION_SPLIT = 59,
	COMPACTMIGRATE_SCANNED = 60,
	COMPACTFREE_SCANNED = 61,
	COMPACTISOLATED = 62,
	COMPACTSTALL = 63,
	COMPACTFAIL = 64,
	COMPACTSUCCESS = 65,
	KCOMPACTD_WAKE = 66,
	KCOMPACTD_MIGRATE_SCANNED = 67,
	KCOMPACTD_FREE_SCANNED = 68,
	HTLB_BUDDY_PGALLOC = 69,
	HTLB_BUDDY_PGALLOC_FAIL = 70,
	CMA_ALLOC_SUCCESS = 71,
	CMA_ALLOC_FAIL = 72,
	UNEVICTABLE_PGCULLED = 73,
	UNEVICTABLE_PGSCANNED = 74,
	UNEVICTABLE_PGRESCUED = 75,
	UNEVICTABLE_PGMLOCKED = 76,
	UNEVICTABLE_PGMUNLOCKED = 77,
	UNEVICTABLE_PGCLEARED = 78,
	UNEVICTABLE_PGSTRANDED = 79,
	THP_FAULT_ALLOC = 80,
	THP_FAULT_FALLBACK = 81,
	THP_FAULT_FALLBACK_CHARGE = 82,
	THP_COLLAPSE_ALLOC = 83,
	THP_COLLAPSE_ALLOC_FAILED = 84,
	THP_FILE_ALLOC = 85,
	THP_FILE_FALLBACK = 86,
	THP_FILE_FALLBACK_CHARGE = 87,
	THP_FILE_MAPPED = 88,
	THP_SPLIT_PAGE = 89,
	THP_SPLIT_PAGE_FAILED = 90,
	THP_DEFERRED_SPLIT_PAGE = 91,
	THP_SPLIT_PMD = 92,
	THP_SCAN_EXCEED_NONE_PTE = 93,
	THP_SCAN_EXCEED_SWAP_PTE = 94,
	THP_SCAN_EXCEED_SHARED_PTE = 95,
	THP_SPLIT_PUD = 96,
	THP_ZERO_PAGE_ALLOC = 97,
	THP_ZERO_PAGE_ALLOC_FAILED = 98,
	THP_SWPOUT = 99,
	THP_SWPOUT_FALLBACK = 100,
	SWAP_RA = 101,
	SWAP_RA_HIT = 102,
	KSM_SWPIN_COPY = 103,
	COW_KSM = 104,
	DIRECT_MAP_LEVEL2_SPLIT = 105,
	DIRECT_MAP_LEVEL3_SPLIT = 106,
	NR_VM_EVENT_ITEMS = 107,
};

enum psc_op {
	SNP_PAGE_STATE_PRIVATE = 1,
	SNP_PAGE_STATE_SHARED = 2,
};

struct obs_kernel_param {
	const char *str;
	int (*setup_func)(char *);
	int early;
};

struct user_desc {
	unsigned int entry_number;
	unsigned int base_addr;
	unsigned int limit;
	unsigned int seg_32bit: 1;
	unsigned int contents: 2;
	unsigned int read_exec_only: 1;
	unsigned int limit_in_pages: 1;
	unsigned int seg_not_present: 1;
	unsigned int useable: 1;
	unsigned int lm: 1;
};

enum {
	DESC_TSS = 9,
	DESC_LDT = 2,
	DESCTYPE_S = 16,
};

struct ldttss_desc {
	u16 limit0;
	u16 base0;
	u16 base1: 8;
	u16 type: 5;
	u16 dpl: 2;
	u16 p: 1;
	u16 limit1: 4;
	u16 zero0: 3;
	u16 g: 1;
	u16 base2: 8;
	u32 base3;
	u32 zero1;
};

typedef struct ldttss_desc tss_desc;

struct desc_ptr {
	short unsigned int size;
	long unsigned int address;
} __attribute__((packed));

struct x86_hw_tss {
	u32 reserved1;
	u64 sp0;
	u64 sp1;
	u64 sp2;
	u64 reserved2;
	u64 ist[7];
	u32 reserved3;
	u32 reserved4;
	u16 reserved5;
	u16 io_bitmap_base;
} __attribute__((packed));

struct entry_stack {
	char stack[4096];
};

struct entry_stack_page {
	struct entry_stack stack;
};

struct x86_io_bitmap {
	u64 prev_sequence;
	unsigned int prev_max;
	long unsigned int bitmap[1025];
	long unsigned int mapall[1025];
};

struct tss_struct {
	struct x86_hw_tss x86_tss;
	struct x86_io_bitmap io_bitmap;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum idle_boot_override {
	IDLE_NO_OVERRIDE = 0,
	IDLE_HALT = 1,
	IDLE_NOMWAIT = 2,
	IDLE_POLL = 3,
};

struct smp_ops {
	void (*smp_prepare_boot_cpu)();
	void (*smp_prepare_cpus)(unsigned int);
	void (*smp_cpus_done)(unsigned int);
	void (*stop_other_cpus)(int);
	void (*crash_stop_other_cpus)();
	void (*smp_send_reschedule)(int);
	void (*cleanup_dead_cpu)(unsigned int);
	void (*poll_sync_state)();
	int (*kick_ap_alive)(unsigned int, struct task_struct *);
	int (*cpu_disable)();
	void (*cpu_die)(unsigned int);
	void (*play_dead)();
	void (*send_call_func_ipi)(const struct cpumask *);
	void (*send_call_func_single_ipi)(int);
};

struct blocking_notifier_head {
	struct rw_semaphore rwsem;
	struct notifier_block *head;
};

struct plist_head {
	struct list_head node_list;
};

struct tlb_context {
	u64 ctx_id;
	u64 tlb_gen;
};

struct tlb_state {
	struct mm_struct *loaded_mm;
	union {
		struct mm_struct *last_user_mm;
		long unsigned int last_user_mm_spec;
	};
	u16 loaded_mm_asid;
	u16 next_asid;
	bool invalidate_other;
	short unsigned int user_pcid_flush_mask;
	long unsigned int cr4;
	struct tlb_context ctxs[6];
};

struct kernel_clone_args {
	u64 flags;
	int *pidfd;
	int *child_tid;
	int *parent_tid;
	const char *name;
	int exit_signal;
	u32 kthread: 1;
	u32 io_thread: 1;
	u32 user_worker: 1;
	u32 no_files: 1;
	long unsigned int stack;
	long unsigned int stack_size;
	long unsigned int tls;
	pid_t *set_tid;
	size_t set_tid_size;
	int cgroup;
	int idle;
	int (*fn)(void *);
	void *fn_arg;
	struct cgroup *cgrp;
	struct css_set *cset;
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

struct pm_qos_constraints {
	struct plist_head list;
	s32 target_value;
	s32 default_value;
	s32 no_constraint_value;
	enum pm_qos_type type;
	struct blocking_notifier_head *notifiers;
};

struct freq_constraints {
	struct pm_qos_constraints min_freq;
	struct blocking_notifier_head min_freq_notifiers;
	struct pm_qos_constraints max_freq;
	struct blocking_notifier_head max_freq_notifiers;
};

struct pm_qos_flags {
	struct list_head list;
	s32 effective_flags;
};

struct dev_pm_qos_request;

struct dev_pm_qos {
	struct pm_qos_constraints resume_latency;
	struct pm_qos_constraints latency_tolerance;
	struct freq_constraints freq;
	struct pm_qos_flags flags;
	struct dev_pm_qos_request *resume_latency_req;
	struct dev_pm_qos_request *latency_tolerance_req;
	struct dev_pm_qos_request *flags_req;
};

typedef u32 phandle;

struct property;

struct device_node {
	const char *name;
	phandle phandle;
	const char *full_name;
	struct fwnode_handle fwnode;
	struct property *properties;
	struct property *deadprops;
	struct device_node *parent;
	struct device_node *child;
	struct device_node *sibling;
	long unsigned int _flags;
	void *data;
};

struct property {
	char *name;
	int length;
	void *value;
	struct property *next;
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

struct new_utsname {
	char sysname[65];
	char nodename[65];
	char release[65];
	char version[65];
	char machine[65];
	char domainname[65];
};

struct uts_namespace {
	struct new_utsname name;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct ns_common ns;
};

struct debug_store_buffers {
	char bts_buffer[65536];
	char pebs_buffer[65536];
};

struct cea_exception_stacks {
	char DF_stack_guard[4096];
	char DF_stack[8192];
	char NMI_stack_guard[4096];
	char NMI_stack[8192];
	char DB_stack_guard[4096];
	char DB_stack[8192];
	char MCE_stack_guard[4096];
	char MCE_stack[8192];
	char VC_stack_guard[4096];
	char VC_stack[8192];
	char VC2_stack_guard[4096];
	char VC2_stack[8192];
	char IST_top_guard[4096];
};

struct cpu_entry_area {
	char gdt[4096];
	struct entry_stack_page entry_stack_page;
	struct tss_struct tss;
	struct cea_exception_stacks estacks;
	struct debug_store cpu_debug_store;
	struct debug_store_buffers cpu_debug_buffers;
};

struct pm_qos_flags_request {
	struct list_head node;
	s32 flags;
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

struct dev_pm_qos_request {
	enum dev_pm_qos_req_type type;
	union {
		struct plist_node pnode;
		struct pm_qos_flags_request flr;
		struct freq_qos_request freq;
	} data;
	struct device *dev;
};

struct inactive_task_frame {
	long unsigned int r15;
	long unsigned int r14;
	long unsigned int r13;
	long unsigned int r12;
	long unsigned int bx;
	long unsigned int bp;
	long unsigned int ret_addr;
};

struct fork_frame {
	struct inactive_task_frame frame;
	struct pt_regs regs;
};

struct ssb_state {
	struct ssb_state *shared_state;
	raw_spinlock_t lock;
	unsigned int disable_state;
	long unsigned int local_state;
};

struct irqentry_state {
	union {
		bool exit_rcu;
		bool lockdep;
	};
};

typedef struct irqentry_state irqentry_state_t;

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum allow_write_msrs {
	MSR_WRITES_ON = 0,
	MSR_WRITES_OFF = 1,
	MSR_WRITES_DEFAULT = 2,
};

struct objpool_slot {
	uint32_t head;
	uint32_t tail;
	uint32_t last;
	uint32_t mask;
	void *entries[0];
};

struct objpool_head;

typedef int (*objpool_fini_cb)(struct objpool_head *, void *);

struct objpool_head {
	int obj_size;
	int nr_objs;
	int nr_cpus;
	int capacity;
	gfp_t gfp;
	refcount_t ref;
	long unsigned int flags;
	struct objpool_slot **cpu_slots;
	objpool_fini_cb release;
	void *context;
};

struct rethook_node;

typedef void (*rethook_handler_t)(struct rethook_node *, void *, long unsigned int, struct pt_regs *);

struct rethook;

struct rethook_node {
	struct callback_head rcu;
	struct llist_node llist;
	struct rethook *rethook;
	long unsigned int ret_addr;
	long unsigned int frame;
};

struct rethook {
	void *data;
	rethook_handler_t handler;
	struct objpool_head pool;
	struct callback_head rcu;
};

enum insn_mode {
	INSN_MODE_32 = 0,
	INSN_MODE_64 = 1,
	INSN_MODE_KERN = 2,
	INSN_NUM_MODES = 3,
};

typedef u8 kprobe_opcode_t;

struct kprobe;

struct arch_specific_insn {
	kprobe_opcode_t *insn;
	unsigned int boostable: 1;
	unsigned char size;
	union {
		unsigned char opcode;
		struct {
			unsigned char type;
		} jcc;
		struct {
			unsigned char type;
			unsigned char asize;
		} loop;
		struct {
			unsigned char reg;
		} indirect;
	};
	s32 rel32;
	void (*emulate_op)(struct kprobe *, struct pt_regs *);
	int tp_len;
};

typedef int (*kprobe_pre_handler_t)(struct kprobe *, struct pt_regs *);

typedef void (*kprobe_post_handler_t)(struct kprobe *, struct pt_regs *, long unsigned int);

struct kprobe {
	struct hlist_node hlist;
	struct list_head list;
	long unsigned int nmissed;
	kprobe_opcode_t *addr;
	const char *symbol_name;
	unsigned int offset;
	kprobe_pre_handler_t pre_handler;
	kprobe_post_handler_t post_handler;
	kprobe_opcode_t opcode;
	struct arch_specific_insn ainsn;
	u32 flags;
};

struct prev_kprobe {
	struct kprobe *kp;
	long unsigned int status;
	long unsigned int old_flags;
	long unsigned int saved_flags;
};

struct kprobe_ctlblk {
	long unsigned int kprobe_status;
	long unsigned int kprobe_old_flags;
	long unsigned int kprobe_saved_flags;
	struct prev_kprobe prev_kprobe;
};

struct kretprobe_blackpoint {
	const char *name;
	void *addr;
};

struct kprobe_insn_cache {
	struct mutex mutex;
	void * (*alloc)();
	void (*free)(void *);
	const char *sym;
	struct list_head pages;
	size_t insn_size;
	int nr_garbage;
};

struct __arch_relative_insn {
	u8 op;
	s32 raddr;
} __attribute__((packed));

typedef unsigned int uint;

struct screen_info {
	__u8 orig_x;
	__u8 orig_y;
	__u16 ext_mem_k;
	__u16 orig_video_page;
	__u8 orig_video_mode;
	__u8 orig_video_cols;
	__u8 flags;
	__u8 unused2;
	__u16 orig_video_ega_bx;
	__u16 unused3;
	__u8 orig_video_lines;
	__u8 orig_video_isVGA;
	__u16 orig_video_points;
	__u16 lfb_width;
	__u16 lfb_height;
	__u16 lfb_depth;
	__u32 lfb_base;
	__u32 lfb_size;
	__u16 cl_magic;
	__u16 cl_offset;
	__u16 lfb_linelength;
	__u8 red_size;
	__u8 red_pos;
	__u8 green_size;
	__u8 green_pos;
	__u8 blue_size;
	__u8 blue_pos;
	__u8 rsvd_size;
	__u8 rsvd_pos;
	__u16 vesapm_seg;
	__u16 vesapm_off;
	__u16 pages;
	__u16 vesa_attributes;
	__u32 capabilities;
	__u32 ext_lfb_base;
	__u8 _reserved[2];
} __attribute__((packed));

struct apm_bios_info {
	__u16 version;
	__u16 cseg;
	__u32 offset;
	__u16 cseg_16;
	__u16 dseg;
	__u16 flags;
	__u16 cseg_len;
	__u16 cseg_16_len;
	__u16 dseg_len;
};

struct edd_device_params {
	__u16 length;
	__u16 info_flags;
	__u32 num_default_cylinders;
	__u32 num_default_heads;
	__u32 sectors_per_track;
	__u64 number_of_sectors;
	__u16 bytes_per_sector;
	__u32 dpte_ptr;
	__u16 key;
	__u8 device_path_info_length;
	__u8 reserved2;
	__u16 reserved3;
	__u8 host_bus_type[4];
	__u8 interface_type[8];
	union {
		struct {
			__u16 base_address;
			__u16 reserved1;
			__u32 reserved2;
		} isa;
		struct {
			__u8 bus;
			__u8 slot;
			__u8 function;
			__u8 channel;
			__u32 reserved;
		} pci;
		struct {
			__u64 reserved;
		} ibnd;
		struct {
			__u64 reserved;
		} xprs;
		struct {
			__u64 reserved;
		} htpt;
		struct {
			__u64 reserved;
		} unknown;
	} interface_path;
	union {
		struct {
			__u8 device;
			__u8 reserved1;
			__u16 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} ata;
		struct {
			__u8 device;
			__u8 lun;
			__u8 reserved1;
			__u8 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} atapi;
		struct {
			__u16 id;
			__u64 lun;
			__u16 reserved1;
			__u32 reserved2;
		} __attribute__((packed)) scsi;
		struct {
			__u64 serial_number;
			__u64 reserved;
		} usb;
		struct {
			__u64 eui;
			__u64 reserved;
		} i1394;
		struct {
			__u64 wwid;
			__u64 lun;
		} fibre;
		struct {
			__u64 identity_tag;
			__u64 reserved;
		} i2o;
		struct {
			__u32 array_number;
			__u32 reserved1;
			__u64 reserved2;
		} raid;
		struct {
			__u8 device;
			__u8 reserved1;
			__u16 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} sata;
		struct {
			__u64 reserved1;
			__u64 reserved2;
		} unknown;
	} device_path;
	__u8 reserved4;
	__u8 checksum;
} __attribute__((packed));

struct edd_info {
	__u8 device;
	__u8 version;
	__u16 interface_support;
	__u16 legacy_max_cylinder;
	__u8 legacy_max_head;
	__u8 legacy_sectors_per_track;
	struct edd_device_params params;
};

struct ist_info {
	__u32 signature;
	__u32 command;
	__u32 event;
	__u32 perf_level;
};

struct edid_info {
	unsigned char dummy[128];
};

struct setup_header {
	__u8 setup_sects;
	__u16 root_flags;
	__u32 syssize;
	__u16 ram_size;
	__u16 vid_mode;
	__u16 root_dev;
	__u16 boot_flag;
	__u16 jump;
	__u32 header;
	__u16 version;
	__u32 realmode_swtch;
	__u16 start_sys_seg;
	__u16 kernel_version;
	__u8 type_of_loader;
	__u8 loadflags;
	__u16 setup_move_size;
	__u32 code32_start;
	__u32 ramdisk_image;
	__u32 ramdisk_size;
	__u32 bootsect_kludge;
	__u16 heap_end_ptr;
	__u8 ext_loader_ver;
	__u8 ext_loader_type;
	__u32 cmd_line_ptr;
	__u32 initrd_addr_max;
	__u32 kernel_alignment;
	__u8 relocatable_kernel;
	__u8 min_alignment;
	__u16 xloadflags;
	__u32 cmdline_size;
	__u32 hardware_subarch;
	__u64 hardware_subarch_data;
	__u32 payload_offset;
	__u32 payload_length;
	__u64 setup_data;
	__u64 pref_address;
	__u32 init_size;
	__u32 handover_offset;
	__u32 kernel_info_offset;
} __attribute__((packed));

struct sys_desc_table {
	__u16 length;
	__u8 table[14];
};

struct olpc_ofw_header {
	__u32 ofw_magic;
	__u32 ofw_version;
	__u32 cif_handler;
	__u32 irq_desc_table;
};

struct efi_info {
	__u32 efi_loader_signature;
	__u32 efi_systab;
	__u32 efi_memdesc_size;
	__u32 efi_memdesc_version;
	__u32 efi_memmap;
	__u32 efi_memmap_size;
	__u32 efi_systab_hi;
	__u32 efi_memmap_hi;
};

struct boot_e820_entry {
	__u64 addr;
	__u64 size;
	__u32 type;
} __attribute__((packed));

struct boot_params {
	struct screen_info screen_info;
	struct apm_bios_info apm_bios_info;
	__u8 _pad2[4];
	__u64 tboot_addr;
	struct ist_info ist_info;
	__u64 acpi_rsdp_addr;
	__u8 _pad3[8];
	__u8 hd0_info[16];
	__u8 hd1_info[16];
	struct sys_desc_table sys_desc_table;
	struct olpc_ofw_header olpc_ofw_header;
	__u32 ext_ramdisk_image;
	__u32 ext_ramdisk_size;
	__u32 ext_cmd_line_ptr;
	__u8 _pad4[112];
	__u32 cc_blob_address;
	struct edid_info edid_info;
	struct efi_info efi_info;
	__u32 alt_mem_k;
	__u32 scratch;
	__u8 e820_entries;
	__u8 eddbuf_entries;
	__u8 edd_mbr_sig_buf_entries;
	__u8 kbd_status;
	__u8 secure_boot;
	__u8 _pad5[2];
	__u8 sentinel;
	__u8 _pad6[1];
	struct setup_header hdr;
	__u8 _pad7[36];
	__u32 edd_mbr_sig_buffer[16];
	struct boot_e820_entry e820_table[128];
	__u8 _pad8[48];
	struct edd_info eddbuf[6];
	__u8 _pad9[276];
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
};

struct tty_driver;

struct console {
	char name[16];
	void (*write)(struct console *, const char *, unsigned int);
	int (*read)(struct console *, char *, unsigned int);
	struct tty_driver * (*device)(struct console *, int *);
	void (*unblank)();
	int (*setup)(struct console *, char *);
	int (*exit)(struct console *);
	int (*match)(struct console *, char *, int, char *);
	short int flags;
	short int index;
	int cflag;
	uint ispeed;
	uint ospeed;
	u64 seq;
	long unsigned int dropped;
	void *data;
	struct hlist_node node;
};

struct amd_nb_bus_dev_range {
	u8 bus;
	u8 dev_base;
	u8 dev_limit;
};

struct amd_l3_cache {
	unsigned int indices;
	u8 subcaches[4];
};

struct threshold_block {
	unsigned int block;
	unsigned int bank;
	unsigned int cpu;
	u32 address;
	u16 interrupt_enable;
	bool interrupt_capable;
	u16 threshold_limit;
	struct kobject kobj;
	struct list_head miscj;
};

struct threshold_bank {
	struct kobject *kobj;
	struct threshold_block *blocks;
	refcount_t cpus;
	unsigned int shared;
};

struct amd_northbridge {
	struct pci_dev *root;
	struct pci_dev *misc;
	struct pci_dev *link;
	struct amd_l3_cache l3_cache;
	struct threshold_bank *bank4;
};

struct amd_northbridge_info {
	u16 num;
	u64 flags;
	struct amd_northbridge *nb;
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_HOTPLUG_DISABLED = 6,
};

struct exception_stacks {
	char DF_stack_guard[0];
	char DF_stack[8192];
	char NMI_stack_guard[0];
	char NMI_stack[8192];
	char DB_stack_guard[0];
	char DB_stack[8192];
	char MCE_stack_guard[0];
	char MCE_stack[8192];
	char VC_stack_guard[0];
	char VC_stack[0];
	char VC2_stack_guard[0];
	char VC2_stack[0];
	char IST_top_guard[0];
};

struct cacheline_padding {
	char x[0];
};

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
};

typedef struct wait_queue_entry wait_queue_entry_t;

struct mem_cgroup_id {
	int id;
	refcount_t ref;
};

struct page_counter {
	atomic_long_t usage;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	long unsigned int emin;
	atomic_long_t min_usage;
	atomic_long_t children_min_usage;
	long unsigned int elow;
	atomic_long_t low_usage;
	atomic_long_t children_low_usage;
	long unsigned int watermark;
	long unsigned int failcnt;
	struct cacheline_padding _pad2_;
	long unsigned int min;
	long unsigned int low;
	long unsigned int high;
	long unsigned int max;
	struct page_counter *parent;
	long: 64;
	long: 64;
	long: 64;
};

struct vmpressure {
	long unsigned int scanned;
	long unsigned int reclaimed;
	long unsigned int tree_scanned;
	long unsigned int tree_reclaimed;
	spinlock_t sr_lock;
	struct list_head events;
	struct mutex events_lock;
	struct work_struct work;
};

struct mem_cgroup_threshold_ary;

struct mem_cgroup_thresholds {
	struct mem_cgroup_threshold_ary *primary;
	struct mem_cgroup_threshold_ary *spare;
};

struct fprop_global {
	struct percpu_counter events;
	unsigned int period;
	seqcount_t sequence;
};

struct wb_domain {
	spinlock_t lock;
	struct fprop_global completions;
	struct timer_list period_timer;
	long unsigned int period_time;
	long unsigned int dirty_limit_tstamp;
	long unsigned int dirty_limit;
};

struct wb_completion {
	atomic_t cnt;
	wait_queue_head_t *waitq;
};

struct memcg_cgwb_frn {
	u64 bdi_id;
	int memcg_id;
	u64 at;
	struct wb_completion done;
};

struct deferred_split {
	spinlock_t split_queue_lock;
	struct list_head split_queue;
	long unsigned int split_queue_len;
};

struct memcg_vmstats;

struct obj_cgroup;

struct memcg_vmstats_percpu;

struct mem_cgroup_per_node;

struct mem_cgroup {
	struct cgroup_subsys_state css;
	struct mem_cgroup_id id;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct page_counter memory;
	union {
		struct page_counter swap;
		struct page_counter memsw;
	};
	struct page_counter kmem;
	struct page_counter tcpmem;
	struct work_struct high_work;
	long unsigned int soft_limit;
	struct vmpressure vmpressure;
	bool oom_group;
	bool oom_lock;
	int under_oom;
	int swappiness;
	int oom_kill_disable;
	struct cgroup_file events_file;
	struct cgroup_file events_local_file;
	struct cgroup_file swap_events_file;
	struct mutex thresholds_lock;
	struct mem_cgroup_thresholds thresholds;
	struct mem_cgroup_thresholds memsw_thresholds;
	struct list_head oom_notify;
	long unsigned int move_charge_at_immigrate;
	spinlock_t move_lock;
	long unsigned int move_lock_flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	struct memcg_vmstats *vmstats;
	atomic_long_t memory_events[9];
	atomic_long_t memory_events_local[9];
	long unsigned int socket_pressure;
	bool tcpmem_active;
	int tcpmem_pressure;
	int kmemcg_id;
	struct obj_cgroup *objcg;
	struct list_head objcg_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad2_;
	atomic_t moving_account;
	struct task_struct *move_lock_task;
	struct memcg_vmstats_percpu *vmstats_percpu;
	struct list_head cgwb_list;
	struct wb_domain cgwb_domain;
	struct memcg_cgwb_frn cgwb_frn[4];
	struct list_head event_list;
	spinlock_t event_list_lock;
	struct deferred_split deferred_split_queue;
	struct mem_cgroup_per_node *nodeinfo[0];
	long: 64;
	long: 64;
};

struct mempolicy {
	atomic_t refcnt;
	short unsigned int mode;
	short unsigned int flags;
	nodemask_t nodes;
	int home_node;
	union {
		nodemask_t cpuset_mems_allowed;
		nodemask_t user_nodemask;
	} w;
};

struct free_area {
	struct list_head free_list[6];
	long unsigned int nr_free;
};

struct pglist_data;

struct lruvec {
	struct list_head lists[5];
	spinlock_t lru_lock;
	long unsigned int anon_cost;
	long unsigned int file_cost;
	atomic_long_t nonresident_age;
	long unsigned int refaults[2];
	long unsigned int flags;
	struct pglist_data *pgdat;
};

struct per_cpu_pages;

struct per_cpu_zonestat;

struct zone {
	long unsigned int _watermark[4];
	long unsigned int watermark_boost;
	long unsigned int nr_reserved_highatomic;
	long int lowmem_reserve[4];
	int node;
	struct pglist_data *zone_pgdat;
	struct per_cpu_pages *per_cpu_pageset;
	struct per_cpu_zonestat *per_cpu_zonestats;
	int pageset_high;
	int pageset_batch;
	long unsigned int zone_start_pfn;
	atomic_long_t managed_pages;
	long unsigned int spanned_pages;
	long unsigned int present_pages;
	long unsigned int cma_pages;
	const char *name;
	long unsigned int nr_isolate_pageblock;
	int initialized;
	long: 64;
	struct cacheline_padding _pad1_;
	struct free_area free_area[11];
	long unsigned int flags;
	spinlock_t lock;
	struct cacheline_padding _pad2_;
	long unsigned int percpu_drift_mark;
	long unsigned int compact_cached_free_pfn;
	long unsigned int compact_cached_migrate_pfn[2];
	long unsigned int compact_init_migrate_pfn;
	long unsigned int compact_init_free_pfn;
	unsigned int compact_considered;
	unsigned int compact_defer_shift;
	int compact_order_failed;
	bool compact_blockskip_flush;
	bool contiguous;
	long: 0;
	struct cacheline_padding _pad3_;
	atomic_long_t vm_stat[10];
	atomic_long_t vm_numa_event[6];
};

struct zoneref {
	struct zone *zone;
	int zone_idx;
};

struct zonelist {
	struct zoneref _zonerefs[257];
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_DMA32 = 1,
	ZONE_NORMAL = 2,
	ZONE_MOVABLE = 3,
	__MAX_NR_ZONES = 4,
};

struct memory_failure_stats {
	long unsigned int total;
	long unsigned int ignored;
	long unsigned int failed;
	long unsigned int delayed;
	long unsigned int recovered;
};

struct per_cpu_nodestat;

struct memory_tier;

struct pglist_data {
	struct zone node_zones[4];
	struct zonelist node_zonelists[2];
	int nr_zones;
	long unsigned int node_start_pfn;
	long unsigned int node_present_pages;
	long unsigned int node_spanned_pages;
	int node_id;
	wait_queue_head_t kswapd_wait;
	wait_queue_head_t pfmemalloc_wait;
	wait_queue_head_t reclaim_wait[4];
	atomic_t nr_writeback_throttled;
	long unsigned int nr_reclaim_start;
	struct task_struct *kswapd;
	int kswapd_order;
	enum zone_type kswapd_highest_zoneidx;
	int kswapd_failures;
	int kcompactd_max_order;
	enum zone_type kcompactd_highest_zoneidx;
	wait_queue_head_t kcompactd_wait;
	struct task_struct *kcompactd;
	bool proactive_compact_trigger;
	long unsigned int totalreserve_pages;
	long unsigned int min_unmapped_pages;
	long unsigned int min_slab_pages;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad1_;
	struct deferred_split deferred_split_queue;
	unsigned int nbp_rl_start;
	long unsigned int nbp_rl_nr_cand;
	unsigned int nbp_threshold;
	unsigned int nbp_th_start;
	long unsigned int nbp_th_nr_cand;
	struct lruvec __lruvec;
	long unsigned int flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cacheline_padding _pad2_;
	struct per_cpu_nodestat *per_cpu_nodestats;
	atomic_long_t vm_stat[43];
	struct memory_tier *memtier;
	struct memory_failure_stats mf_stats;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct per_cpu_pages {
	spinlock_t lock;
	int count;
	int high;
	int batch;
	short int free_factor;
	short int expire;
	struct list_head lists[13];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct per_cpu_zonestat {
	s8 vm_stat_diff[10];
	s8 stat_threshold;
	long unsigned int vm_numa_event[6];
};

struct per_cpu_nodestat {
	s8 stat_threshold;
	s8 vm_node_stat_diff[43];
};

struct bio;

struct bio_list {
	struct bio *head;
	struct bio *tail;
};

struct reclaim_state {
	long unsigned int reclaimed;
};

struct wait_page_queue {
	struct folio *folio;
	int bit_nr;
	wait_queue_entry_t wait;
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

struct swap_iocb;

struct writeback_control {
	long int nr_to_write;
	long int pages_skipped;
	loff_t range_start;
	loff_t range_end;
	enum writeback_sync_modes sync_mode;
	unsigned int for_kupdate: 1;
	unsigned int for_background: 1;
	unsigned int tagged_writepages: 1;
	unsigned int for_reclaim: 1;
	unsigned int range_cyclic: 1;
	unsigned int for_sync: 1;
	unsigned int unpinned_fscache_wb: 1;
	unsigned int no_cgroup_owner: 1;
	struct swap_iocb **swap_plug;
	struct bdi_writeback *wb;
	struct inode *inode;
	int wb_id;
	int wb_lcand_id;
	int wb_tcand_id;
	size_t wb_bytes;
	size_t wb_lcand_bytes;
	size_t wb_tcand_bytes;
};

struct readahead_control {
	struct file *file;
	struct address_space *mapping;
	struct file_ra_state *ra;
	long unsigned int _index;
	unsigned int _nr_pages;
	unsigned int _batch_count;
	bool _workingset;
	long unsigned int _pflags;
};

struct iovec {
	void *iov_base;
	__kernel_size_t iov_len;
};

struct kvec;

struct bio_vec;

struct iov_iter {
	u8 iter_type;
	bool copy_mc;
	bool nofault;
	bool data_source;
	size_t iov_offset;
	union {
		struct iovec __ubuf_iovec;
		struct {
			union {
				const struct iovec *__iov;
				const struct kvec *kvec;
				const struct bio_vec *bvec;
				struct xarray *xarray;
				void *ubuf;
			};
			size_t count;
		};
	};
	union {
		long unsigned int nr_segs;
		loff_t xarray_start;
	};
};

struct swap_cluster_info {
	spinlock_t lock;
	unsigned int data: 24;
	unsigned int flags: 8;
};

struct swap_cluster_list {
	struct swap_cluster_info head;
	struct swap_cluster_info tail;
};

struct percpu_cluster;

struct swap_info_struct {
	struct percpu_ref users;
	long unsigned int flags;
	short int prio;
	struct plist_node list;
	signed char type;
	unsigned int max;
	unsigned char *swap_map;
	struct swap_cluster_info *cluster_info;
	struct swap_cluster_list free_clusters;
	unsigned int lowest_bit;
	unsigned int highest_bit;
	unsigned int pages;
	unsigned int inuse_pages;
	unsigned int cluster_next;
	unsigned int cluster_nr;
	unsigned int *cluster_next_cpu;
	struct percpu_cluster *percpu_cluster;
	struct rb_root swap_extent_root;
	struct bdev_handle *bdev_handle;
	struct block_device *bdev;
	struct file *swap_file;
	unsigned int old_block_size;
	struct completion comp;
	spinlock_t lock;
	spinlock_t cont_lock;
	struct work_struct discard_work;
	struct swap_cluster_list discard_clusters;
	struct plist_node avail_lists[0];
};

struct fprop_local_percpu {
	struct percpu_counter events;
	unsigned int period;
	raw_spinlock_t lock;
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

struct bdi_writeback {
	struct backing_dev_info *bdi;
	long unsigned int state;
	long unsigned int last_old_flush;
	struct list_head b_dirty;
	struct list_head b_io;
	struct list_head b_more_io;
	struct list_head b_dirty_time;
	spinlock_t list_lock;
	atomic_t writeback_inodes;
	struct percpu_counter stat[4];
	long unsigned int bw_time_stamp;
	long unsigned int dirtied_stamp;
	long unsigned int written_stamp;
	long unsigned int write_bandwidth;
	long unsigned int avg_write_bandwidth;
	long unsigned int dirty_ratelimit;
	long unsigned int balanced_dirty_ratelimit;
	struct fprop_local_percpu completions;
	int dirty_exceeded;
	enum wb_reason start_all_reason;
	spinlock_t work_lock;
	struct list_head work_list;
	struct delayed_work dwork;
	struct delayed_work bw_dwork;
	long unsigned int dirty_sleep;
	struct list_head bdi_node;
	struct percpu_ref refcnt;
	struct fprop_local_percpu memcg_completions;
	struct cgroup_subsys_state *memcg_css;
	struct cgroup_subsys_state *blkcg_css;
	struct list_head memcg_node;
	struct list_head blkcg_node;
	struct list_head b_attached;
	struct list_head offline_node;
	union {
		struct work_struct release_work;
		struct callback_head rcu;
	};
};

struct request_queue;

struct disk_stats;

struct blk_holder_ops;

struct partition_meta_info;

struct block_device {
	sector_t bd_start_sect;
	sector_t bd_nr_sectors;
	struct gendisk *bd_disk;
	struct request_queue *bd_queue;
	struct disk_stats *bd_stats;
	long unsigned int bd_stamp;
	bool bd_read_only;
	u8 bd_partno;
	bool bd_write_holder;
	bool bd_has_submit_bio;
	dev_t bd_dev;
	atomic_t bd_openers;
	spinlock_t bd_size_lock;
	struct inode *bd_inode;
	void *bd_claiming;
	void *bd_holder;
	const struct blk_holder_ops *bd_holder_ops;
	struct mutex bd_holder_lock;
	int bd_fsfreeze_count;
	int bd_holders;
	struct kobject *bd_holder_dir;
	struct mutex bd_fsfreeze_mutex;
	struct super_block *bd_fsfreeze_sb;
	struct partition_meta_info *bd_meta_info;
	struct device bd_device;
};

struct backing_dev_info {
	u64 id;
	struct rb_node rb_node;
	struct list_head bdi_list;
	long unsigned int ra_pages;
	long unsigned int io_pages;
	struct kref refcnt;
	unsigned int capabilities;
	unsigned int min_ratio;
	unsigned int max_ratio;
	unsigned int max_prop_frac;
	atomic_long_t tot_write_bandwidth;
	struct bdi_writeback wb;
	struct list_head wb_list;
	struct xarray cgwb_tree;
	struct mutex cgwb_release_mutex;
	struct rw_semaphore wb_switch_rwsem;
	wait_queue_head_t wb_waitq;
	struct device *dev;
	char dev_name[64];
	struct device *owner;
	struct timer_list laptop_mode_wb_timer;
	struct dentry *debug_dir;
};

typedef __u32 blk_opf_t;

typedef u8 blk_status_t;

struct bvec_iter {
	sector_t bi_sector;
	unsigned int bi_size;
	unsigned int bi_idx;
	unsigned int bi_bvec_done;
} __attribute__((packed));

typedef unsigned int blk_qc_t;

typedef void bio_end_io_t(struct bio *);

struct bio_issue {
	u64 value;
};

struct bio_vec {
	struct page *bv_page;
	unsigned int bv_len;
	unsigned int bv_offset;
};

struct blkcg_gq;

struct bio_set;

struct bio {
	struct bio *bi_next;
	struct block_device *bi_bdev;
	blk_opf_t bi_opf;
	short unsigned int bi_flags;
	short unsigned int bi_ioprio;
	blk_status_t bi_status;
	atomic_t __bi_remaining;
	struct bvec_iter bi_iter;
	blk_qc_t bi_cookie;
	bio_end_io_t *bi_end_io;
	void *bi_private;
	struct blkcg_gq *bi_blkg;
	struct bio_issue bi_issue;
	union {};
	short unsigned int bi_vcnt;
	short unsigned int bi_max_vecs;
	atomic_t __bi_cnt;
	struct bio_vec *bi_io_vec;
	struct bio_set *bi_pool;
	struct bio_vec bi_inline_vecs[0];
};

struct vm_unmapped_area_info {
	long unsigned int flags;
	long unsigned int length;
	long unsigned int low_limit;
	long unsigned int high_limit;
	long unsigned int align_mask;
	long unsigned int align_offset;
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

struct blk_holder_ops {
	void (*mark_dead)(struct block_device *, bool);
	void (*sync)(struct block_device *);
};

typedef void *mempool_alloc_t(gfp_t, void *);

typedef void mempool_free_t(void *, void *);

struct mempool_s {
	spinlock_t lock;
	int min_nr;
	int curr_nr;
	void **elements;
	void *pool_data;
	mempool_alloc_t *alloc;
	mempool_free_t *free;
	wait_queue_head_t wait;
};

typedef struct mempool_s mempool_t;

struct bio_alloc_cache;

struct bio_set {
	struct kmem_cache *bio_slab;
	unsigned int front_pad;
	struct bio_alloc_cache *cache;
	mempool_t bio_pool;
	mempool_t bvec_pool;
	unsigned int back_pad;
	spinlock_t rescue_lock;
	struct bio_list rescue_list;
	struct work_struct rescue_work;
	struct workqueue_struct *rescue_workqueue;
	struct hlist_node cpuhp_dead;
};

struct kvec {
	void *iov_base;
	size_t iov_len;
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

struct mem_cgroup_reclaim_iter {
	struct mem_cgroup *position;
	unsigned int generation;
};

struct shrinker_info {
	struct callback_head rcu;
	atomic_long_t *nr_deferred;
	long unsigned int *map;
	int map_nr_max;
};

struct lruvec_stats_percpu {
	long int state[43];
	long int state_prev[43];
};

struct lruvec_stats {
	long int state[43];
	long int state_local[43];
	long int state_pending[43];
};

struct mem_cgroup_per_node {
	struct lruvec lruvec;
	struct lruvec_stats_percpu *lruvec_stats_percpu;
	struct lruvec_stats lruvec_stats;
	long unsigned int lru_zone_size[20];
	struct mem_cgroup_reclaim_iter iter;
	struct shrinker_info *shrinker_info;
	struct rb_node tree_node;
	long unsigned int usage_in_excess;
	bool on_tree;
	struct mem_cgroup *memcg;
};

struct eventfd_ctx;

struct mem_cgroup_threshold {
	struct eventfd_ctx *eventfd;
	long unsigned int threshold;
};

struct mem_cgroup_threshold_ary {
	int current_threshold;
	unsigned int size;
	struct mem_cgroup_threshold entries[0];
};

struct obj_cgroup {
	struct percpu_ref refcnt;
	struct mem_cgroup *memcg;
	atomic_t nr_charged_bytes;
	union {
		struct list_head list;
		struct callback_head rcu;
	};
};

struct percpu_cluster {
	struct swap_cluster_info index;
	unsigned int next;
};

struct hstate;

struct hugepage_subpool {
	spinlock_t lock;
	long int count;
	long int max_hpages;
	long int used_hpages;
	struct hstate *hstate;
	long int min_hpages;
	long int rsv_hpages;
};

struct hstate {
	struct mutex resize_lock;
	int next_nid_to_alloc;
	int next_nid_to_free;
	unsigned int order;
	unsigned int demote_order;
	long unsigned int mask;
	long unsigned int max_huge_pages;
	long unsigned int nr_huge_pages;
	long unsigned int free_huge_pages;
	long unsigned int resv_huge_pages;
	long unsigned int surplus_huge_pages;
	long unsigned int nr_overcommit_huge_pages;
	struct list_head hugepage_activelist;
	struct list_head hugepage_freelists[64];
	unsigned int max_huge_pages_node[64];
	unsigned int nr_huge_pages_node[64];
	unsigned int free_huge_pages_node[64];
	unsigned int surplus_huge_pages_node[64];
	struct cftype cgroup_files_dfl[8];
	struct cftype cgroup_files_legacy[10];
	char name[32];
};

struct hugetlbfs_sb_info {
	long int max_inodes;
	long int free_inodes;
	spinlock_t stat_lock;
	struct hstate *hstate;
	struct hugepage_subpool *spool;
	kuid_t uid;
	kgid_t gid;
	umode_t mode;
};

struct trace_print_flags {
	long unsigned int mask;
	const char *name;
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

typedef irqreturn_t (*irq_handler_t)(int, void *);

struct irqaction {
	irq_handler_t handler;
	void *dev_id;
	void *percpu_dev_id;
	struct irqaction *next;
	irq_handler_t thread_fn;
	struct task_struct *thread;
	struct irqaction *secondary;
	unsigned int irq;
	unsigned int flags;
	long unsigned int thread_flags;
	long unsigned int thread_mask;
	const char *name;
	struct proc_dir_entry *dir;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct softirq_action {
	void (*action)(struct softirq_action *);
};

struct tasklet_struct {
	struct tasklet_struct *next;
	long unsigned int state;
	atomic_t count;
	bool use_callback;
	union {
		void (*func)(long unsigned int);
		void (*callback)(struct tasklet_struct *);
	};
	long unsigned int data;
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

struct kernel_stat {
	long unsigned int irqs_sum;
	unsigned int softirqs[10];
};

struct wait_bit_key {
	void *flags;
	int bit_nr;
	long unsigned int timeout;
};

struct wait_bit_queue_entry {
	struct wait_bit_key key;
	struct wait_queue_entry wq_entry;
};

struct smp_hotplug_thread {
	struct task_struct **store;
	struct list_head list;
	int (*thread_should_run)(unsigned int);
	void (*thread_fn)(unsigned int);
	void (*create)(unsigned int);
	void (*setup)(unsigned int);
	void (*cleanup)(unsigned int, bool);
	void (*park)(unsigned int);
	void (*unpark)(unsigned int);
	bool selfparking;
	const char *thread_comm;
};

struct ring_buffer_event {
	u32 type_len: 5;
	u32 time_delta: 27;
	u32 array[0];
};

struct trace_buffer;

struct trace_event_file;

struct trace_event_buffer {
	struct trace_buffer *buffer;
	struct ring_buffer_event *event;
	struct trace_event_file *trace_file;
	void *entry;
	unsigned int trace_ctx;
	struct pt_regs *regs;
};

struct eventfs_file;

struct trace_subsystem_dir;

struct trace_event_file {
	struct list_head list;
	struct trace_event_call *event_call;
	struct event_filter *filter;
	struct eventfs_file *ef;
	struct trace_array *tr;
	struct trace_subsystem_dir *system;
	struct list_head triggers;
	long unsigned int flags;
	atomic_t sm_ref;
	atomic_t tm_ref;
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

struct trace_event_raw_irq_handler_entry {
	struct trace_entry ent;
	int irq;
	u32 __data_loc_name;
	char __data[0];
};

struct trace_event_raw_irq_handler_exit {
	struct trace_entry ent;
	int irq;
	int ret;
	char __data[0];
};

struct trace_event_raw_softirq {
	struct trace_entry ent;
	unsigned int vec;
	char __data[0];
};

struct trace_event_raw_tasklet {
	struct trace_entry ent;
	void *tasklet;
	void *func;
	char __data[0];
};

struct trace_event_data_offsets_irq_handler_entry {
	u32 name;
};

struct trace_event_data_offsets_irq_handler_exit {};

struct trace_event_data_offsets_softirq {};

struct trace_event_data_offsets_tasklet {};

typedef void (*btf_trace_irq_handler_entry)(void *, int, struct irqaction *);

typedef void (*btf_trace_irq_handler_exit)(void *, int, struct irqaction *, int);

typedef void (*btf_trace_softirq_entry)(void *, unsigned int);

typedef void (*btf_trace_softirq_exit)(void *, unsigned int);

typedef void (*btf_trace_softirq_raise)(void *, unsigned int);

typedef void (*btf_trace_tasklet_entry)(void *, struct tasklet_struct *, void *);

typedef void (*btf_trace_tasklet_exit)(void *, struct tasklet_struct *, void *);

struct tasklet_head {
	struct tasklet_struct *head;
	struct tasklet_struct **tail;
};

enum lockdep_lock_type {
	LD_LOCK_NORMAL = 0,
	LD_LOCK_PERCPU = 1,
	LD_LOCK_WAIT_OVERRIDE = 2,
	LD_LOCK_MAX = 3,
};

struct smpboot_thread_data {
	unsigned int cpu;
	unsigned int status;
	struct smp_hotplug_thread *ht;
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

typedef __u16 __be16;

typedef __u32 __be32;

typedef __u32 __wsum;

typedef u64 uint64_t;

typedef unsigned int slab_flags_t;

typedef void (*rcu_callback_t)(struct callback_head *);

struct pin_cookie {
	unsigned int val;
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

struct static_key_true {
	struct static_key key;
};

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_preempt_t;

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef int (*task_call_f)(struct task_struct *, void *);

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct mutex *class_mutex_t;

struct raw_notifier_head {
	struct notifier_block *head;
};

struct linux_binprm;

struct coredump_params;

struct linux_binfmt {
	struct list_head lh;
	struct module *module;
	int (*load_binary)(struct linux_binprm *);
	int (*load_shlib)(struct file *);
	int (*core_dump)(struct coredump_params *);
	long unsigned int min_coredump;
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

struct rhashtable;

struct rhashtable_compare_arg {
	struct rhashtable *ht;
	const void *key;
};

typedef u32 (*rht_hashfn_t)(const void *, u32, u32);

typedef u32 (*rht_obj_hashfn_t)(const void *, u32, u32);

typedef int (*rht_obj_cmpfn_t)(struct rhashtable_compare_arg *, const void *);

struct rhashtable_params {
	u16 nelem_hint;
	u16 key_len;
	u16 key_offset;
	u16 head_offset;
	unsigned int max_size;
	u16 min_size;
	bool automatic_shrinking;
	rht_hashfn_t hashfn;
	rht_obj_hashfn_t obj_hashfn;
	rht_obj_cmpfn_t obj_cmpfn;
};

struct bucket_table;

struct rhashtable {
	struct bucket_table *tbl;
	unsigned int key_len;
	unsigned int max_elems;
	struct rhashtable_params p;
	bool rhlist;
	struct work_struct run_work;
	struct mutex mutex;
	spinlock_t lock;
	atomic_t nelems;
};

struct dl_bw {
	raw_spinlock_t lock;
	u64 bw;
	u64 total_bw;
};

struct cpudl_item;

struct cpudl {
	raw_spinlock_t lock;
	int size;
	cpumask_var_t free_cpus;
	struct cpudl_item *elements;
};

struct cpupri_vec {
	atomic_t count;
	cpumask_var_t mask;
};

struct cpupri {
	struct cpupri_vec pri_to_cpu[101];
	int *cpu_to_pri;
};

struct perf_domain;

struct root_domain {
	atomic_t refcount;
	atomic_t rto_count;
	struct callback_head rcu;
	cpumask_var_t span;
	cpumask_var_t online;
	int overload;
	int overutilized;
	cpumask_var_t dlo_mask;
	atomic_t dlo_count;
	struct dl_bw dl_bw;
	struct cpudl cpudl;
	u64 visit_gen;
	struct irq_work rto_push_work;
	raw_spinlock_t rto_lock;
	int rto_loop;
	int rto_cpu;
	atomic_t rto_loop_next;
	atomic_t rto_loop_start;
	cpumask_var_t rto_mask;
	struct cpupri cpupri;
	long unsigned int max_cpu_capacity;
	struct perf_domain *pd;
};

struct sched_param {
	int sched_priority;
};

struct cfs_rq {
	struct load_weight load;
	unsigned int nr_running;
	unsigned int h_nr_running;
	unsigned int idle_nr_running;
	unsigned int idle_h_nr_running;
	s64 avg_vruntime;
	u64 avg_load;
	u64 exec_clock;
	u64 min_vruntime;
	struct rb_root_cached tasks_timeline;
	struct sched_entity *curr;
	struct sched_entity *next;
	unsigned int nr_spread_over;
	long: 64;
	long: 64;
	long: 64;
	struct sched_avg avg;
	struct {
		raw_spinlock_t lock;
		int nr;
		long unsigned int load_avg;
		long unsigned int util_avg;
		long unsigned int runnable_avg;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	} removed;
	u64 last_update_tg_load_avg;
	long unsigned int tg_load_avg_contrib;
	long int propagate;
	long int prop_runnable_sum;
	long unsigned int h_load;
	u64 last_h_load_update;
	struct sched_entity *h_load_next;
	struct rq *rq;
	int on_list;
	struct list_head leaf_cfs_rq_list;
	struct task_group *tg;
	int idle;
	int runtime_enabled;
	s64 runtime_remaining;
	u64 throttled_pelt_idle;
	u64 throttled_clock;
	u64 throttled_clock_pelt;
	u64 throttled_clock_pelt_time;
	u64 throttled_clock_self;
	u64 throttled_clock_self_time;
	int throttled;
	int throttle_count;
	struct list_head throttled_list;
	struct list_head throttled_csd_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct cfs_bandwidth {
	raw_spinlock_t lock;
	ktime_t period;
	u64 quota;
	u64 runtime;
	u64 burst;
	u64 runtime_snap;
	s64 hierarchical_quota;
	u8 idle;
	u8 period_active;
	u8 slack_started;
	struct hrtimer period_timer;
	struct hrtimer slack_timer;
	struct list_head throttled_cfs_rq;
	int nr_periods;
	int nr_throttled;
	int nr_burst;
	u64 throttled_time;
	u64 burst_time;
};

struct task_group {
	struct cgroup_subsys_state css;
	struct sched_entity **se;
	struct cfs_rq **cfs_rq;
	long unsigned int shares;
	int idle;
	long: 64;
	atomic_long_t load_avg;
	struct callback_head rcu;
	struct list_head list;
	struct task_group *parent;
	struct list_head siblings;
	struct list_head children;
	struct cfs_bandwidth cfs_bandwidth;
	long: 64;
};

struct io_ring_ctx;

struct io_wq;

struct io_uring_task {
	int cached_refs;
	const struct io_ring_ctx *last;
	struct io_wq *io_wq;
	struct file *registered_rings[16];
	struct xarray xa;
	struct wait_queue_head wait;
	atomic_t in_cancel;
	atomic_t inflight_tracked;
	struct percpu_counter inflight;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct {
		struct llist_head task_list;
		struct callback_head task_work;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
};

struct request;

struct blk_plug {
	struct request *mq_list;
	struct request *cached_rq;
	short unsigned int nr_ios;
	short unsigned int rq_count;
	bool multiple_queues;
	bool has_elevator;
	struct list_head cb_list;
};

struct task_delay_info {
	raw_spinlock_t lock;
	u64 blkio_start;
	u64 blkio_delay;
	u64 swapin_start;
	u64 swapin_delay;
	u32 blkio_count;
	u32 swapin_count;
	u64 freepages_start;
	u64 freepages_delay;
	u64 thrashing_start;
	u64 thrashing_delay;
	u64 compact_start;
	u64 compact_delay;
	u64 wpcopy_start;
	u64 wpcopy_delay;
	u64 irq_delay;
	u32 freepages_count;
	u32 thrashing_count;
	u32 compact_count;
	u32 wpcopy_count;
	u32 irq_count;
};

typedef unsigned int blk_mode_t;

struct block_device_operations;

struct timer_rand_state;

struct disk_events;

struct badblocks;

struct blk_independent_access_ranges;

struct gendisk {
	int major;
	int first_minor;
	int minors;
	char disk_name[32];
	short unsigned int events;
	short unsigned int event_flags;
	struct xarray part_tbl;
	struct block_device *part0;
	const struct block_device_operations *fops;
	struct request_queue *queue;
	void *private_data;
	struct bio_set bio_split;
	int flags;
	long unsigned int state;
	struct mutex open_mutex;
	unsigned int open_partitions;
	struct backing_dev_info *bdi;
	struct kobject queue_kobj;
	struct kobject *slave_dir;
	struct timer_rand_state *random;
	atomic_t sync_io;
	struct disk_events *ev;
	int node_id;
	struct badblocks *bb;
	struct lockdep_map lockdep_map;
	u64 diskseq;
	blk_mode_t open_mode;
	struct blk_independent_access_ranges *ia_ranges;
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum blk_bounce {
	BLK_BOUNCE_NONE = 0,
	BLK_BOUNCE_HIGH = 1,
};

enum blk_zoned_model {
	BLK_ZONED_NONE = 0,
	BLK_ZONED_HA = 1,
	BLK_ZONED_HM = 2,
};

struct queue_limits {
	enum blk_bounce bounce;
	long unsigned int seg_boundary_mask;
	long unsigned int virt_boundary_mask;
	unsigned int max_hw_sectors;
	unsigned int max_dev_sectors;
	unsigned int chunk_sectors;
	unsigned int max_sectors;
	unsigned int max_user_sectors;
	unsigned int max_segment_size;
	unsigned int physical_block_size;
	unsigned int logical_block_size;
	unsigned int alignment_offset;
	unsigned int io_min;
	unsigned int io_opt;
	unsigned int max_discard_sectors;
	unsigned int max_hw_discard_sectors;
	unsigned int max_secure_erase_sectors;
	unsigned int max_write_zeroes_sectors;
	unsigned int max_zone_append_sectors;
	unsigned int discard_granularity;
	unsigned int discard_alignment;
	unsigned int zone_write_granularity;
	short unsigned int max_segments;
	short unsigned int max_integrity_segments;
	short unsigned int max_discard_segments;
	unsigned char misaligned;
	unsigned char discard_misaligned;
	unsigned char raid_partial_stripes_expensive;
	enum blk_zoned_model zoned;
	unsigned int dma_alignment;
};

struct elevator_queue;

struct blk_queue_stats;

struct rq_qos;

struct blk_mq_ops;

struct blk_mq_ctx;

struct blk_mq_tags;

struct blk_trace;

struct blk_flush_queue;

struct throtl_data;

struct blk_mq_tag_set;

struct request_queue {
	struct request *last_merge;
	struct elevator_queue *elevator;
	struct percpu_ref q_usage_counter;
	struct blk_queue_stats *stats;
	struct rq_qos *rq_qos;
	struct mutex rq_qos_mutex;
	const struct blk_mq_ops *mq_ops;
	struct blk_mq_ctx *queue_ctx;
	unsigned int queue_depth;
	struct xarray hctx_table;
	unsigned int nr_hw_queues;
	void *queuedata;
	long unsigned int queue_flags;
	atomic_t pm_only;
	int id;
	spinlock_t queue_lock;
	struct gendisk *disk;
	refcount_t refs;
	struct kobject *mq_kobj;
	struct device *dev;
	enum rpm_status rpm_status;
	long unsigned int nr_requests;
	unsigned int dma_pad_mask;
	unsigned int rq_timeout;
	struct timer_list timeout;
	struct work_struct timeout_work;
	atomic_t nr_active_requests_shared_tags;
	struct blk_mq_tags *sched_shared_tags;
	struct list_head icq_list;
	long unsigned int blkcg_pols[1];
	struct blkcg_gq *root_blkg;
	struct list_head blkg_list;
	struct mutex blkcg_mutex;
	struct queue_limits limits;
	unsigned int required_elevator_features;
	int node;
	struct blk_trace *blk_trace;
	struct blk_flush_queue *fq;
	struct list_head flush_list;
	struct list_head requeue_list;
	spinlock_t requeue_lock;
	struct delayed_work requeue_work;
	struct mutex sysfs_lock;
	struct mutex sysfs_dir_lock;
	struct list_head unused_hctx_list;
	spinlock_t unused_hctx_lock;
	int mq_freeze_depth;
	struct throtl_data *td;
	struct callback_head callback_head;
	wait_queue_head_t mq_freeze_wq;
	struct mutex mq_freeze_lock;
	int quiesce_depth;
	struct blk_mq_tag_set *tag_set;
	struct list_head tag_set_list;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct dentry *rqos_debugfs_dir;
	struct mutex debugfs_mutex;
	bool mq_sysfs_init_done;
};

typedef int __kernel_rwf_t;

struct bdev_handle {
	struct block_device *bdev;
	void *holder;
	blk_mode_t mode;
};

struct io_comp_batch {
	struct request *req_list;
	bool need_ts;
	void (*complete)(struct io_comp_batch *);
};

enum ctx_state {
	CONTEXT_DISABLED = -1,
	CONTEXT_KERNEL = 0,
	CONTEXT_IDLE = 1,
	CONTEXT_USER = 2,
	CONTEXT_GUEST = 3,
	CONTEXT_MAX = 4,
};

struct sched_domain_attr {
	int relax_domain_level;
};

struct sched_domain_shared {
	atomic_t ref;
	atomic_t nr_busy_cpus;
	int has_idle_cores;
	int nr_idle_scan;
};

struct sched_group;

struct sched_domain {
	struct sched_domain *parent;
	struct sched_domain *child;
	struct sched_group *groups;
	long unsigned int min_interval;
	long unsigned int max_interval;
	unsigned int busy_factor;
	unsigned int imbalance_pct;
	unsigned int cache_nice_tries;
	unsigned int imb_numa_nr;
	int nohz_idle;
	int flags;
	int level;
	long unsigned int last_balance;
	unsigned int balance_interval;
	unsigned int nr_balance_failed;
	u64 max_newidle_lb_cost;
	long unsigned int last_decay_max_lb_cost;
	unsigned int lb_count[3];
	unsigned int lb_failed[3];
	unsigned int lb_balanced[3];
	unsigned int lb_imbalance[3];
	unsigned int lb_gained[3];
	unsigned int lb_hot_gained[3];
	unsigned int lb_nobusyg[3];
	unsigned int lb_nobusyq[3];
	unsigned int alb_count;
	unsigned int alb_failed;
	unsigned int alb_pushed;
	unsigned int sbe_count;
	unsigned int sbe_balanced;
	unsigned int sbe_pushed;
	unsigned int sbf_count;
	unsigned int sbf_balanced;
	unsigned int sbf_pushed;
	unsigned int ttwu_wake_remote;
	unsigned int ttwu_move_affine;
	unsigned int ttwu_move_balance;
	char *name;
	union {
		void *private;
		struct callback_head rcu;
	};
	struct sched_domain_shared *shared;
	unsigned int span_weight;
	long unsigned int span[0];
};

struct sched_group_capacity;

struct sched_group {
	struct sched_group *next;
	atomic_t ref;
	unsigned int group_weight;
	unsigned int cores;
	struct sched_group_capacity *sgc;
	int asym_prefer_cpu;
	int flags;
	long unsigned int cpumask[0];
};

struct sched_group_capacity {
	atomic_t ref;
	long unsigned int capacity;
	long unsigned int min_capacity;
	long unsigned int max_capacity;
	long unsigned int next_update;
	int imbalance;
	int id;
	long unsigned int cpumask[0];
};

struct em_perf_state {
	long unsigned int frequency;
	long unsigned int power;
	long unsigned int cost;
	long unsigned int flags;
};

struct em_perf_domain {
	struct em_perf_state *table;
	int nr_perf_states;
	long unsigned int flags;
	long unsigned int cpus[0];
};

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

struct ref_tracker_dir {};

struct prot_inuse;

struct netns_core {
	struct ctl_table_header *sysctl_hdr;
	int sysctl_somaxconn;
	u8 sysctl_txrehash;
	struct prot_inuse *prot_inuse;
	struct cpumask *rps_default_mask;
};

struct ipstats_mib;

struct tcp_mib;

struct linux_mib;

struct udp_mib;

struct linux_tls_mib;

struct mptcp_mib;

struct icmp_mib;

struct icmpmsg_mib;

struct icmpv6_mib;

struct icmpv6msg_mib;

struct netns_mib {
	struct ipstats_mib *ip_statistics;
	struct ipstats_mib *ipv6_statistics;
	struct tcp_mib *tcp_statistics;
	struct linux_mib *net_statistics;
	struct udp_mib *udp_statistics;
	struct udp_mib *udp_stats_in6;
	struct linux_tls_mib *tls_statistics;
	struct mptcp_mib *mptcp_statistics;
	struct udp_mib *udplite_statistics;
	struct udp_mib *udplite_stats_in6;
	struct icmp_mib *icmp_statistics;
	struct icmpmsg_mib *icmpmsg_statistics;
	struct icmpv6_mib *icmpv6_statistics;
	struct icmpv6msg_mib *icmpv6msg_statistics;
	struct proc_dir_entry *proc_net_devsnmp6;
};

struct netns_packet {
	struct mutex sklist_lock;
	struct hlist_head sklist;
};

struct unix_table {
	spinlock_t *locks;
	struct hlist_head *buckets;
};

struct netns_unix {
	struct unix_table table;
	int sysctl_max_dgram_qlen;
	struct ctl_table_header *ctl;
};

struct netns_nexthop {
	struct rb_root rb_root;
	struct hlist_head *devhash;
	unsigned int seq;
	u32 last_id_allocated;
	struct blocking_notifier_head notifier_chain;
};

struct inet_hashinfo;

struct inet_timewait_death_row {
	refcount_t tw_refcount;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct inet_hashinfo *hashinfo;
	int sysctl_max_tw_buckets;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct local_ports {
	seqlock_t lock;
	int range[2];
	bool warned;
};

struct ping_group_range {
	seqlock_t lock;
	kgid_t range[2];
};

typedef struct {
	u64 key[2];
} siphash_key_t;

struct udp_table;

struct ipv4_devconf;

struct ip_ra_chain;

struct fib_rules_ops;

struct fib_table;

struct inet_peer_base;

struct fqdir;

struct tcp_congestion_ops;

struct tcp_fastopen_context;

struct mr_table;

struct fib_notifier_ops;

struct netns_ipv4 {
	struct inet_timewait_death_row tcp_death_row;
	struct udp_table *udp_table;
	struct ctl_table_header *forw_hdr;
	struct ctl_table_header *frags_hdr;
	struct ctl_table_header *ipv4_hdr;
	struct ctl_table_header *route_hdr;
	struct ctl_table_header *xfrm4_hdr;
	struct ipv4_devconf *devconf_all;
	struct ipv4_devconf *devconf_dflt;
	struct ip_ra_chain *ra_chain;
	struct mutex ra_mutex;
	struct fib_rules_ops *rules_ops;
	struct fib_table *fib_main;
	struct fib_table *fib_default;
	unsigned int fib_rules_require_fldissect;
	bool fib_has_custom_rules;
	bool fib_has_custom_local_routes;
	bool fib_offload_disabled;
	u8 sysctl_tcp_shrink_window;
	struct hlist_head *fib_table_hash;
	struct sock *fibnl;
	struct sock *mc_autojoin_sk;
	struct inet_peer_base *peers;
	struct fqdir *fqdir;
	u8 sysctl_icmp_echo_ignore_all;
	u8 sysctl_icmp_echo_enable_probe;
	u8 sysctl_icmp_echo_ignore_broadcasts;
	u8 sysctl_icmp_ignore_bogus_error_responses;
	u8 sysctl_icmp_errors_use_inbound_ifaddr;
	int sysctl_icmp_ratelimit;
	int sysctl_icmp_ratemask;
	u32 ip_rt_min_pmtu;
	int ip_rt_mtu_expires;
	int ip_rt_min_advmss;
	struct local_ports ip_local_ports;
	u8 sysctl_tcp_ecn;
	u8 sysctl_tcp_ecn_fallback;
	u8 sysctl_ip_default_ttl;
	u8 sysctl_ip_no_pmtu_disc;
	u8 sysctl_ip_fwd_use_pmtu;
	u8 sysctl_ip_fwd_update_priority;
	u8 sysctl_ip_nonlocal_bind;
	u8 sysctl_ip_autobind_reuse;
	u8 sysctl_ip_dynaddr;
	u8 sysctl_ip_early_demux;
	u8 sysctl_raw_l3mdev_accept;
	u8 sysctl_tcp_early_demux;
	u8 sysctl_udp_early_demux;
	u8 sysctl_nexthop_compat_mode;
	u8 sysctl_fwmark_reflect;
	u8 sysctl_tcp_fwmark_accept;
	u8 sysctl_tcp_l3mdev_accept;
	u8 sysctl_tcp_mtu_probing;
	int sysctl_tcp_mtu_probe_floor;
	int sysctl_tcp_base_mss;
	int sysctl_tcp_min_snd_mss;
	int sysctl_tcp_probe_threshold;
	u32 sysctl_tcp_probe_interval;
	int sysctl_tcp_keepalive_time;
	int sysctl_tcp_keepalive_intvl;
	u8 sysctl_tcp_keepalive_probes;
	u8 sysctl_tcp_syn_retries;
	u8 sysctl_tcp_synack_retries;
	u8 sysctl_tcp_syncookies;
	u8 sysctl_tcp_migrate_req;
	u8 sysctl_tcp_comp_sack_nr;
	u8 sysctl_tcp_backlog_ack_defer;
	u8 sysctl_tcp_pingpong_thresh;
	int sysctl_tcp_reordering;
	u8 sysctl_tcp_retries1;
	u8 sysctl_tcp_retries2;
	u8 sysctl_tcp_orphan_retries;
	u8 sysctl_tcp_tw_reuse;
	int sysctl_tcp_fin_timeout;
	unsigned int sysctl_tcp_notsent_lowat;
	u8 sysctl_tcp_sack;
	u8 sysctl_tcp_window_scaling;
	u8 sysctl_tcp_timestamps;
	u8 sysctl_tcp_early_retrans;
	u8 sysctl_tcp_recovery;
	u8 sysctl_tcp_thin_linear_timeouts;
	u8 sysctl_tcp_slow_start_after_idle;
	u8 sysctl_tcp_retrans_collapse;
	u8 sysctl_tcp_stdurg;
	u8 sysctl_tcp_rfc1337;
	u8 sysctl_tcp_abort_on_overflow;
	u8 sysctl_tcp_fack;
	int sysctl_tcp_max_reordering;
	int sysctl_tcp_adv_win_scale;
	u8 sysctl_tcp_dsack;
	u8 sysctl_tcp_app_win;
	u8 sysctl_tcp_frto;
	u8 sysctl_tcp_nometrics_save;
	u8 sysctl_tcp_no_ssthresh_metrics_save;
	u8 sysctl_tcp_moderate_rcvbuf;
	u8 sysctl_tcp_tso_win_divisor;
	u8 sysctl_tcp_workaround_signed_windows;
	int sysctl_tcp_limit_output_bytes;
	int sysctl_tcp_challenge_ack_limit;
	int sysctl_tcp_min_rtt_wlen;
	u8 sysctl_tcp_min_tso_segs;
	u8 sysctl_tcp_tso_rtt_log;
	u8 sysctl_tcp_autocorking;
	u8 sysctl_tcp_reflect_tos;
	int sysctl_tcp_invalid_ratelimit;
	int sysctl_tcp_pacing_ss_ratio;
	int sysctl_tcp_pacing_ca_ratio;
	int sysctl_tcp_wmem[3];
	int sysctl_tcp_rmem[3];
	unsigned int sysctl_tcp_child_ehash_entries;
	long unsigned int sysctl_tcp_comp_sack_delay_ns;
	long unsigned int sysctl_tcp_comp_sack_slack_ns;
	int sysctl_max_syn_backlog;
	int sysctl_tcp_fastopen;
	const struct tcp_congestion_ops *tcp_congestion_control;
	struct tcp_fastopen_context *tcp_fastopen_ctx;
	unsigned int sysctl_tcp_fastopen_blackhole_timeout;
	atomic_t tfo_active_disable_times;
	long unsigned int tfo_active_disable_stamp;
	u32 tcp_challenge_timestamp;
	u32 tcp_challenge_count;
	u8 sysctl_tcp_plb_enabled;
	u8 sysctl_tcp_plb_idle_rehash_rounds;
	u8 sysctl_tcp_plb_rehash_rounds;
	u8 sysctl_tcp_plb_suspend_rto_sec;
	int sysctl_tcp_plb_cong_thresh;
	int sysctl_udp_wmem_min;
	int sysctl_udp_rmem_min;
	u8 sysctl_fib_notify_on_flag_change;
	u8 sysctl_tcp_syn_linear_timeouts;
	u8 sysctl_udp_l3mdev_accept;
	u8 sysctl_igmp_llm_reports;
	int sysctl_igmp_max_memberships;
	int sysctl_igmp_max_msf;
	int sysctl_igmp_qrv;
	struct ping_group_range ping_group_range;
	atomic_t dev_addr_genid;
	unsigned int sysctl_udp_child_hash_entries;
	long unsigned int *sysctl_local_reserved_ports;
	int sysctl_ip_prot_sock;
	struct mr_table *mrt;
	u32 sysctl_fib_multipath_hash_fields;
	u8 sysctl_fib_multipath_use_neigh;
	u8 sysctl_fib_multipath_hash_policy;
	struct fib_notifier_ops *notifier_ops;
	unsigned int fib_seq;
	struct fib_notifier_ops *ipmr_notifier_ops;
	unsigned int ipmr_seq;
	atomic_t rt_genid;
	siphash_key_t ip_id_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct dst_entry;

struct net_device;

struct sk_buff;

struct neighbour;

struct dst_ops {
	short unsigned int family;
	unsigned int gc_thresh;
	void (*gc)(struct dst_ops *);
	struct dst_entry * (*check)(struct dst_entry *, __u32);
	unsigned int (*default_advmss)(const struct dst_entry *);
	unsigned int (*mtu)(const struct dst_entry *);
	u32 * (*cow_metrics)(struct dst_entry *, long unsigned int);
	void (*destroy)(struct dst_entry *);
	void (*ifdown)(struct dst_entry *, struct net_device *);
	struct dst_entry * (*negative_advice)(struct dst_entry *);
	void (*link_failure)(struct sk_buff *);
	void (*update_pmtu)(struct dst_entry *, struct sock *, struct sk_buff *, u32, bool);
	void (*redirect)(struct dst_entry *, struct sock *, struct sk_buff *);
	int (*local_out)(struct net *, struct sock *, struct sk_buff *);
	struct neighbour * (*neigh_lookup)(const struct dst_entry *, struct sk_buff *, const void *);
	void (*confirm_neigh)(const struct dst_entry *, const void *);
	struct kmem_cache *kmem_cachep;
	struct percpu_counter pcpuc_entries;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct netns_sysctl_ipv6 {
	struct ctl_table_header *hdr;
	struct ctl_table_header *route_hdr;
	struct ctl_table_header *icmp_hdr;
	struct ctl_table_header *frags_hdr;
	struct ctl_table_header *xfrm6_hdr;
	int flush_delay;
	int ip6_rt_max_size;
	int ip6_rt_gc_min_interval;
	int ip6_rt_gc_timeout;
	int ip6_rt_gc_interval;
	int ip6_rt_gc_elasticity;
	int ip6_rt_mtu_expires;
	int ip6_rt_min_advmss;
	u32 multipath_hash_fields;
	u8 multipath_hash_policy;
	u8 bindv6only;
	u8 flowlabel_consistency;
	u8 auto_flowlabels;
	int icmpv6_time;
	u8 icmpv6_echo_ignore_all;
	u8 icmpv6_echo_ignore_multicast;
	u8 icmpv6_echo_ignore_anycast;
	long unsigned int icmpv6_ratemask[4];
	long unsigned int *icmpv6_ratemask_ptr;
	u8 anycast_src_echo_reply;
	u8 ip_nonlocal_bind;
	u8 fwmark_reflect;
	u8 flowlabel_state_ranges;
	int idgen_retries;
	int idgen_delay;
	int flowlabel_reflect;
	int max_dst_opts_cnt;
	int max_hbh_opts_cnt;
	int max_dst_opts_len;
	int max_hbh_opts_len;
	int seg6_flowlabel;
	u32 ioam6_id;
	u64 ioam6_id_wide;
	u8 skip_notify_on_dev_down;
	u8 fib_notify_on_flag_change;
	u8 icmpv6_error_anycast_as_unicast;
};

struct ipv6_devconf;

struct fib6_info;

struct rt6_info;

struct rt6_statistics;

struct fib6_table;

struct seg6_pernet_data;

struct ioam6_pernet_data;

struct netns_ipv6 {
	struct dst_ops ip6_dst_ops;
	struct netns_sysctl_ipv6 sysctl;
	struct ipv6_devconf *devconf_all;
	struct ipv6_devconf *devconf_dflt;
	struct inet_peer_base *peers;
	struct fqdir *fqdir;
	struct fib6_info *fib6_null_entry;
	struct rt6_info *ip6_null_entry;
	struct rt6_statistics *rt6_stats;
	struct timer_list ip6_fib_timer;
	struct hlist_head *fib_table_hash;
	struct fib6_table *fib6_main_tbl;
	struct list_head fib6_walkers;
	rwlock_t fib6_walker_lock;
	spinlock_t fib6_gc_lock;
	atomic_t ip6_rt_gc_expire;
	long unsigned int ip6_rt_last_gc;
	unsigned char flowlabel_has_excl;
	bool fib6_has_custom_rules;
	unsigned int fib6_rules_require_fldissect;
	unsigned int fib6_routes_require_src;
	struct rt6_info *ip6_prohibit_entry;
	struct rt6_info *ip6_blk_hole_entry;
	struct fib6_table *fib6_local_tbl;
	struct fib_rules_ops *fib6_rules_ops;
	struct sock *ndisc_sk;
	struct sock *tcp_sk;
	struct sock *igmp_sk;
	struct sock *mc_autojoin_sk;
	struct hlist_head *inet6_addr_lst;
	spinlock_t addrconf_hash_lock;
	struct delayed_work addr_chk_work;
	atomic_t dev_addr_genid;
	atomic_t fib6_sernum;
	struct seg6_pernet_data *seg6_data;
	struct fib_notifier_ops *notifier_ops;
	struct fib_notifier_ops *ip6mr_notifier_ops;
	unsigned int ipmr_seq;
	struct {
		struct hlist_head head;
		spinlock_t lock;
		u32 seq;
	} ip6addrlbl_table;
	struct ioam6_pernet_data *ioam6_data;
	long: 64;
	long: 64;
};

struct nf_logger;

struct nf_hook_entries;

struct netns_nf {
	struct proc_dir_entry *proc_netfilter;
	const struct nf_logger *nf_loggers[11];
	struct ctl_table_header *nf_log_dir_header;
	struct nf_hook_entries *hooks_ipv4[5];
	struct nf_hook_entries *hooks_ipv6[5];
	unsigned int defrag_ipv4_users;
	unsigned int defrag_ipv6_users;
};

struct nf_ct_event_notifier;

struct nf_generic_net {
	unsigned int timeout;
};

struct nf_tcp_net {
	unsigned int timeouts[14];
	u8 tcp_loose;
	u8 tcp_be_liberal;
	u8 tcp_max_retrans;
	u8 tcp_ignore_invalid_rst;
};

struct nf_udp_net {
	unsigned int timeouts[2];
};

struct nf_icmp_net {
	unsigned int timeout;
};

struct nf_dccp_net {
	u8 dccp_loose;
	unsigned int dccp_timeout[10];
};

struct nf_sctp_net {
	unsigned int timeouts[10];
};

struct nf_ip_net {
	struct nf_generic_net generic;
	struct nf_tcp_net tcp;
	struct nf_udp_net udp;
	struct nf_icmp_net icmp;
	struct nf_icmp_net icmpv6;
	struct nf_dccp_net dccp;
	struct nf_sctp_net sctp;
};

struct ip_conntrack_stat;

struct netns_ct {
	u8 sysctl_log_invalid;
	u8 sysctl_events;
	u8 sysctl_acct;
	u8 sysctl_tstamp;
	u8 sysctl_checksum;
	struct ip_conntrack_stat *stat;
	struct nf_ct_event_notifier *nf_conntrack_event_cb;
	struct nf_ip_net nf_ct_proto;
};

struct netns_bpf {
	struct bpf_prog_array *run_array[2];
	struct bpf_prog *progs[2];
	struct list_head links[2];
};

struct xfrm_policy_hash {
	struct hlist_head *table;
	unsigned int hmask;
	u8 dbits4;
	u8 sbits4;
	u8 dbits6;
	u8 sbits6;
};

struct xfrm_policy_hthresh {
	struct work_struct work;
	seqlock_t lock;
	u8 lbits4;
	u8 rbits4;
	u8 lbits6;
	u8 rbits6;
};

struct netns_xfrm {
	struct list_head state_all;
	struct hlist_head *state_bydst;
	struct hlist_head *state_bysrc;
	struct hlist_head *state_byspi;
	struct hlist_head *state_byseq;
	unsigned int state_hmask;
	unsigned int state_num;
	struct work_struct state_hash_work;
	struct list_head policy_all;
	struct hlist_head *policy_byidx;
	unsigned int policy_idx_hmask;
	unsigned int idx_generator;
	struct hlist_head policy_inexact[3];
	struct xfrm_policy_hash policy_bydst[3];
	unsigned int policy_count[6];
	struct work_struct policy_hash_work;
	struct xfrm_policy_hthresh policy_hthresh;
	struct list_head inexact_bins;
	struct sock *nlsk;
	struct sock *nlsk_stash;
	u32 sysctl_aevent_etime;
	u32 sysctl_aevent_rseqth;
	int sysctl_larval_drop;
	u32 sysctl_acq_expires;
	u8 policy_default[3];
	struct ctl_table_header *sysctl_hdr;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct dst_ops xfrm4_dst_ops;
	struct dst_ops xfrm6_dst_ops;
	spinlock_t xfrm_state_lock;
	seqcount_spinlock_t xfrm_state_hash_generation;
	seqcount_spinlock_t xfrm_policy_hash_generation;
	spinlock_t xfrm_policy_lock;
	struct mutex xfrm_cfg_mutex;
};

struct mpls_route;

struct netns_mpls {
	int ip_ttl_propagate;
	int default_ttl;
	size_t platform_labels;
	struct mpls_route **platform_label;
	struct ctl_table_header *ctl;
};

struct netns_xdp {
	struct mutex lock;
	struct hlist_head list;
};

struct uevent_sock;

struct net_generic;

struct net {
	refcount_t passive;
	spinlock_t rules_mod_lock;
	atomic_t dev_unreg_count;
	unsigned int dev_base_seq;
	u32 ifindex;
	spinlock_t nsid_lock;
	atomic_t fnhe_genid;
	struct list_head list;
	struct list_head exit_list;
	struct llist_node cleanup_list;
	struct key_tag *key_domain;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct idr netns_ids;
	struct ns_common ns;
	struct ref_tracker_dir refcnt_tracker;
	struct ref_tracker_dir notrefcnt_tracker;
	struct list_head dev_base_head;
	struct proc_dir_entry *proc_net;
	struct proc_dir_entry *proc_net_stat;
	struct ctl_table_set sysctls;
	struct sock *rtnl;
	struct sock *genl_sock;
	struct uevent_sock *uevent_sock;
	struct hlist_head *dev_name_head;
	struct hlist_head *dev_index_head;
	struct xarray dev_by_index;
	struct raw_notifier_head netdev_chain;
	u32 hash_mix;
	struct net_device *loopback_dev;
	struct list_head rules_ops;
	struct netns_core core;
	struct netns_mib mib;
	struct netns_packet packet;
	struct netns_unix unx;
	struct netns_nexthop nexthop;
	long: 64;
	struct netns_ipv4 ipv4;
	struct netns_ipv6 ipv6;
	struct netns_nf nf;
	struct netns_ct ct;
	struct net_generic *gen;
	struct netns_bpf bpf;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct netns_xfrm xfrm;
	u64 net_cookie;
	struct netns_mpls mpls;
	struct netns_xdp xdp;
	struct sock *diag_nlsk;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct binfmt_misc {
	struct list_head entries;
	rwlock_t entries_lock;
	bool enabled;
};

struct kernel_cpustat {
	u64 cpustat[10];
};

struct kthread_work;

typedef void (*kthread_work_func_t)(struct kthread_work *);

struct kthread_worker;

struct kthread_work {
	struct list_head node;
	kthread_work_func_t func;
	struct kthread_worker *worker;
	int canceling;
};

struct kthread_worker {
	unsigned int flags;
	raw_spinlock_t lock;
	struct list_head work_list;
	struct list_head delayed_work_list;
	struct task_struct *task;
	struct kthread_work *current_work;
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum hk_type {
	HK_TYPE_TIMER = 0,
	HK_TYPE_RCU = 1,
	HK_TYPE_MISC = 2,
	HK_TYPE_SCHED = 3,
	HK_TYPE_TICK = 4,
	HK_TYPE_DOMAIN = 5,
	HK_TYPE_WQ = 6,
	HK_TYPE_MANAGED_IRQ = 7,
	HK_TYPE_KTHREAD = 8,
	HK_TYPE_MAX = 9,
};

struct partition_meta_info {
	char uuid[37];
	u8 volname[64];
};

struct blk_zone {
	__u64 start;
	__u64 len;
	__u64 wp;
	__u8 type;
	__u8 cond;
	__u8 non_seq;
	__u8 reset;
	__u8 resv[4];
	__u64 capacity;
	__u8 reserved[24];
};

typedef int (*report_zones_cb)(struct blk_zone *, unsigned int, void *);

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

struct hd_geometry;

struct pr_ops;

struct block_device_operations {
	void (*submit_bio)(struct bio *);
	int (*poll_bio)(struct bio *, struct io_comp_batch *, unsigned int);
	int (*open)(struct gendisk *, blk_mode_t);
	void (*release)(struct gendisk *);
	int (*ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	int (*compat_ioctl)(struct block_device *, blk_mode_t, unsigned int, long unsigned int);
	unsigned int (*check_events)(struct gendisk *, unsigned int);
	void (*unlock_native_capacity)(struct gendisk *);
	int (*getgeo)(struct block_device *, struct hd_geometry *);
	int (*set_read_only)(struct block_device *, bool);
	void (*free_disk)(struct gendisk *);
	void (*swap_slot_free_notify)(struct block_device *, long unsigned int);
	int (*report_zones)(struct gendisk *, sector_t, unsigned int, report_zones_cb, void *);
	char * (*devnode)(struct gendisk *, umode_t *);
	int (*get_unique_id)(struct gendisk *, u8 *, enum blk_unique_id);
	struct module *owner;
	const struct pr_ops *pr_ops;
	int (*alternative_gpt_sector)(struct gendisk *, sector_t *);
};

struct blk_independent_access_range {
	struct kobject kobj;
	sector_t sector;
	sector_t nr_sectors;
};

struct blk_independent_access_ranges {
	struct kobject kobj;
	bool sysfs_registered;
	unsigned int nr_ia_ranges;
	struct blk_independent_access_range ia_range[0];
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

struct blk_mq_hw_ctx;

struct blk_mq_queue_data;

struct blk_mq_ops {
	blk_status_t (*queue_rq)(struct blk_mq_hw_ctx *, const struct blk_mq_queue_data *);
	void (*commit_rqs)(struct blk_mq_hw_ctx *);
	void (*queue_rqs)(struct request **);
	int (*get_budget)(struct request_queue *);
	void (*put_budget)(struct request_queue *, int);
	void (*set_rq_budget_token)(struct request *, int);
	int (*get_rq_budget_token)(struct request *);
	enum blk_eh_timer_return (*timeout)(struct request *);
	int (*poll)(struct blk_mq_hw_ctx *, struct io_comp_batch *);
	void (*complete)(struct request *);
	int (*init_hctx)(struct blk_mq_hw_ctx *, void *, unsigned int);
	void (*exit_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	int (*init_request)(struct blk_mq_tag_set *, struct request *, unsigned int, unsigned int);
	void (*exit_request)(struct blk_mq_tag_set *, struct request *, unsigned int);
	void (*cleanup_rq)(struct request *);
	bool (*busy)(struct request_queue *);
	void (*map_queues)(struct blk_mq_tag_set *);
	void (*show_rq)(struct seq_file *, struct request *);
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

struct pr_keys;

struct pr_held_reservation;

struct pr_ops {
	int (*pr_register)(struct block_device *, u64, u64, u32);
	int (*pr_reserve)(struct block_device *, u64, enum pr_type, u32);
	int (*pr_release)(struct block_device *, u64, enum pr_type);
	int (*pr_preempt)(struct block_device *, u64, u64, enum pr_type, bool);
	int (*pr_clear)(struct block_device *, u64);
	int (*pr_read_keys)(struct block_device *, struct pr_keys *);
	int (*pr_read_reservation)(struct block_device *, struct pr_held_reservation *);
};

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTREQUESTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	IPSTATS_MIB_OUTPKTS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_DELAYEDACKS = 16,
	LINUX_MIB_DELAYEDACKLOCKED = 17,
	LINUX_MIB_DELAYEDACKLOST = 18,
	LINUX_MIB_LISTENOVERFLOWS = 19,
	LINUX_MIB_LISTENDROPS = 20,
	LINUX_MIB_TCPHPHITS = 21,
	LINUX_MIB_TCPPUREACKS = 22,
	LINUX_MIB_TCPHPACKS = 23,
	LINUX_MIB_TCPRENORECOVERY = 24,
	LINUX_MIB_TCPSACKRECOVERY = 25,
	LINUX_MIB_TCPSACKRENEGING = 26,
	LINUX_MIB_TCPSACKREORDER = 27,
	LINUX_MIB_TCPRENOREORDER = 28,
	LINUX_MIB_TCPTSREORDER = 29,
	LINUX_MIB_TCPFULLUNDO = 30,
	LINUX_MIB_TCPPARTIALUNDO = 31,
	LINUX_MIB_TCPDSACKUNDO = 32,
	LINUX_MIB_TCPLOSSUNDO = 33,
	LINUX_MIB_TCPLOSTRETRANSMIT = 34,
	LINUX_MIB_TCPRENOFAILURES = 35,
	LINUX_MIB_TCPSACKFAILURES = 36,
	LINUX_MIB_TCPLOSSFAILURES = 37,
	LINUX_MIB_TCPFASTRETRANS = 38,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 39,
	LINUX_MIB_TCPTIMEOUTS = 40,
	LINUX_MIB_TCPLOSSPROBES = 41,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 42,
	LINUX_MIB_TCPRENORECOVERYFAIL = 43,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 44,
	LINUX_MIB_TCPRCVCOLLAPSED = 45,
	LINUX_MIB_TCPDSACKOLDSENT = 46,
	LINUX_MIB_TCPDSACKOFOSENT = 47,
	LINUX_MIB_TCPDSACKRECV = 48,
	LINUX_MIB_TCPDSACKOFORECV = 49,
	LINUX_MIB_TCPABORTONDATA = 50,
	LINUX_MIB_TCPABORTONCLOSE = 51,
	LINUX_MIB_TCPABORTONMEMORY = 52,
	LINUX_MIB_TCPABORTONTIMEOUT = 53,
	LINUX_MIB_TCPABORTONLINGER = 54,
	LINUX_MIB_TCPABORTFAILED = 55,
	LINUX_MIB_TCPMEMORYPRESSURES = 56,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 57,
	LINUX_MIB_TCPSACKDISCARD = 58,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 59,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 60,
	LINUX_MIB_TCPSPURIOUSRTOS = 61,
	LINUX_MIB_TCPMD5NOTFOUND = 62,
	LINUX_MIB_TCPMD5UNEXPECTED = 63,
	LINUX_MIB_TCPMD5FAILURE = 64,
	LINUX_MIB_SACKSHIFTED = 65,
	LINUX_MIB_SACKMERGED = 66,
	LINUX_MIB_SACKSHIFTFALLBACK = 67,
	LINUX_MIB_TCPBACKLOGDROP = 68,
	LINUX_MIB_PFMEMALLOCDROP = 69,
	LINUX_MIB_TCPMINTTLDROP = 70,
	LINUX_MIB_TCPDEFERACCEPTDROP = 71,
	LINUX_MIB_IPRPFILTER = 72,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 73,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 74,
	LINUX_MIB_TCPREQQFULLDROP = 75,
	LINUX_MIB_TCPRETRANSFAIL = 76,
	LINUX_MIB_TCPRCVCOALESCE = 77,
	LINUX_MIB_TCPBACKLOGCOALESCE = 78,
	LINUX_MIB_TCPOFOQUEUE = 79,
	LINUX_MIB_TCPOFODROP = 80,
	LINUX_MIB_TCPOFOMERGE = 81,
	LINUX_MIB_TCPCHALLENGEACK = 82,
	LINUX_MIB_TCPSYNCHALLENGE = 83,
	LINUX_MIB_TCPFASTOPENACTIVE = 84,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 85,
	LINUX_MIB_TCPFASTOPENPASSIVE = 86,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 87,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 88,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 89,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 90,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 91,
	LINUX_MIB_BUSYPOLLRXPACKETS = 92,
	LINUX_MIB_TCPAUTOCORKING = 93,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 94,
	LINUX_MIB_TCPTOZEROWINDOWADV = 95,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 96,
	LINUX_MIB_TCPSYNRETRANS = 97,
	LINUX_MIB_TCPORIGDATASENT = 98,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 99,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 100,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 101,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 102,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 103,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 104,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 105,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 106,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 107,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 108,
	LINUX_MIB_TCPWINPROBE = 109,
	LINUX_MIB_TCPKEEPALIVE = 110,
	LINUX_MIB_TCPMTUPFAIL = 111,
	LINUX_MIB_TCPMTUPSUCCESS = 112,
	LINUX_MIB_TCPDELIVERED = 113,
	LINUX_MIB_TCPDELIVEREDCE = 114,
	LINUX_MIB_TCPACKCOMPRESSED = 115,
	LINUX_MIB_TCPZEROWINDOWDROP = 116,
	LINUX_MIB_TCPRCVQDROP = 117,
	LINUX_MIB_TCPWQUEUETOOBIG = 118,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 119,
	LINUX_MIB_TCPTIMEOUTREHASH = 120,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 121,
	LINUX_MIB_TCPDSACKRECVSEGS = 122,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 123,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 124,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 125,
	LINUX_MIB_TCPPLBREHASH = 126,
	LINUX_MIB_TCPAOREQUIRED = 127,
	LINUX_MIB_TCPAOBAD = 128,
	LINUX_MIB_TCPAOKEYNOTFOUND = 129,
	LINUX_MIB_TCPAOGOOD = 130,
	LINUX_MIB_TCPAODROPPEDICMPS = 131,
	__LINUX_MIB_MAX = 132,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	__LINUX_MIB_XFRMMAX = 29,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	__LINUX_MIB_TLSMAX = 13,
};

struct ipstats_mib {
	u64 mibs[38];
	struct u64_stats_sync syncp;
};

struct icmp_mib {
	long unsigned int mibs[30];
};

struct icmpmsg_mib {
	atomic_long_t mibs[512];
};

struct icmpv6_mib {
	long unsigned int mibs[7];
};

struct icmpv6msg_mib {
	atomic_long_t mibs[512];
};

struct tcp_mib {
	long unsigned int mibs[16];
};

struct udp_mib {
	long unsigned int mibs[10];
};

struct linux_mib {
	long unsigned int mibs[132];
};

struct linux_tls_mib {
	long unsigned int mibs[13];
};

struct inet_frags;

struct fqdir {
	long int high_thresh;
	long int low_thresh;
	int timeout;
	int max_dist;
	struct inet_frags *f;
	struct net *net;
	bool dead;
	long: 64;
	long: 64;
	struct rhashtable rhashtable;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	atomic_long_t mem;
	struct work_struct destroy_work;
	struct llist_node free_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct inet_frag_queue;

struct inet_frags {
	unsigned int qsize;
	void (*constructor)(struct inet_frag_queue *, const void *);
	void (*destructor)(struct inet_frag_queue *);
	void (*frag_expire)(struct timer_list *);
	struct kmem_cache *frags_cachep;
	const char *frags_cache_name;
	struct rhashtable_params rhash_params;
	refcount_t refcnt;
	struct completion completion;
};

struct frag_v4_compare_key {
	__be32 saddr;
	__be32 daddr;
	u32 user;
	u32 vif;
	__be16 id;
	u16 protocol;
};

struct frag_v6_compare_key {
	struct in6_addr saddr;
	struct in6_addr daddr;
	u32 user;
	__be32 id;
	u32 iif;
};

struct inet_frag_queue {
	struct rhash_head node;
	union {
		struct frag_v4_compare_key v4;
		struct frag_v6_compare_key v6;
	} key;
	struct timer_list timer;
	spinlock_t lock;
	refcount_t refcnt;
	struct rb_root rb_fragments;
	struct sk_buff *fragments_tail;
	struct sk_buff *last_run_head;
	ktime_t stamp;
	int len;
	int meat;
	u8 mono_delivery_time;
	__u8 flags;
	u16 max_size;
	struct fqdir *fqdir;
	struct callback_head rcu;
};

typedef unsigned int sk_buff_data_t;

struct skb_ext;

struct sk_buff {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
			union {
				struct net_device *dev;
				long unsigned int dev_scratch;
			};
		};
		struct rb_node rbnode;
		struct list_head list;
		struct llist_node ll_node;
	};
	union {
		struct sock *sk;
		int ip_defrag_offset;
	};
	union {
		ktime_t tstamp;
		u64 skb_mstamp_ns;
	};
	char cb[48];
	union {
		struct {
			long unsigned int _skb_refdst;
			void (*destructor)(struct sk_buff *);
		};
		struct list_head tcp_tsorted_anchor;
		long unsigned int _sk_redir;
	};
	long unsigned int _nfct;
	unsigned int len;
	unsigned int data_len;
	__u16 mac_len;
	__u16 hdr_len;
	__u16 queue_mapping;
	__u8 __cloned_offset[0];
	__u8 cloned: 1;
	__u8 nohdr: 1;
	__u8 fclone: 2;
	__u8 peeked: 1;
	__u8 head_frag: 1;
	__u8 pfmemalloc: 1;
	__u8 pp_recycle: 1;
	__u8 active_extensions;
	union {
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 mono_delivery_time: 1;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 redirected: 1;
			__u8 nf_skip_egress: 1;
			__u8 slow_gro: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			__u32 secmark;
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		};
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 mono_delivery_time: 1;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 redirected: 1;
			__u8 nf_skip_egress: 1;
			__u8 slow_gro: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			__u32 secmark;
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		} headers;
	};
	sk_buff_data_t tail;
	sk_buff_data_t end;
	unsigned char *head;
	unsigned char *data;
	unsigned int truesize;
	refcount_t users;
	struct skb_ext *extensions;
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

struct ack_sample;

struct rate_sample;

union tcp_cc_info;

struct tcp_congestion_ops {
	u32 (*ssthresh)(struct sock *);
	void (*cong_avoid)(struct sock *, u32, u32);
	void (*set_state)(struct sock *, u8);
	void (*cwnd_event)(struct sock *, enum tcp_ca_event);
	void (*in_ack_event)(struct sock *, u32);
	void (*pkts_acked)(struct sock *, const struct ack_sample *);
	u32 (*min_tso_segs)(struct sock *);
	void (*cong_control)(struct sock *, const struct rate_sample *);
	u32 (*undo_cwnd)(struct sock *);
	u32 (*sndbuf_expand)(struct sock *);
	size_t (*get_info)(struct sock *, u32, int *, union tcp_cc_info *);
	char name[16];
	struct module *owner;
	struct list_head list;
	u32 key;
	u32 flags;
	void (*init)(struct sock *);
	void (*release)(struct sock *);
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {} netdevice_tracker;

struct xfrm_state;

struct uncached_list;

struct lwtunnel_state;

struct dst_entry {
	struct net_device *dev;
	struct dst_ops *ops;
	long unsigned int _metrics;
	long unsigned int expires;
	struct xfrm_state *xfrm;
	int (*input)(struct sk_buff *);
	int (*output)(struct net *, struct sock *, struct sk_buff *);
	short unsigned int flags;
	short int obsolete;
	short unsigned int header_len;
	short unsigned int trailer_len;
	rcuref_t __rcuref;
	int __use;
	long unsigned int lastuse;
	struct callback_head callback_head;
	short int error;
	short int __pad;
	__u32 tclassid;
	netdevice_tracker dev_tracker;
	struct list_head rt_uncached;
	struct uncached_list *rt_uncached_list;
	struct lwtunnel_state *lwtstate;
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

typedef u8 u_int8_t;

struct nf_loginfo;

typedef void nf_logfn(struct net *, u_int8_t, unsigned int, const struct sk_buff *, const struct net_device *, const struct net_device *, const struct nf_loginfo *, const char *);

struct nf_logger {
	char *name;
	enum nf_log_type type;
	nf_logfn *logfn;
	struct module *me;
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

struct ip_conntrack_stat {
	unsigned int found;
	unsigned int invalid;
	unsigned int insert;
	unsigned int insert_failed;
	unsigned int clash_resolve;
	unsigned int drop;
	unsigned int early_drop;
	unsigned int error;
	unsigned int expect_new;
	unsigned int expect_create;
	unsigned int expect_delete;
	unsigned int search_restart;
	unsigned int chaintoolong;
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

struct skb_ext {
	refcount_t refcnt;
	u8 offset[3];
	u8 chunks;
	char data[0];
};

enum skb_ext_id {
	SKB_EXT_SEC_PATH = 0,
	TC_SKB_EXT = 1,
	SKB_EXT_MPTCP = 2,
	SKB_EXT_NUM = 3,
};

struct wake_q_head {
	struct wake_q_node *first;
	struct wake_q_node **lastp;
};

struct sched_attr {
	__u32 size;
	__u32 sched_policy;
	__u64 sched_flags;
	__s32 sched_nice;
	__u32 sched_priority;
	__u64 sched_runtime;
	__u64 sched_deadline;
	__u64 sched_period;
	__u32 sched_util_min;
	__u32 sched_util_max;
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

struct linux_binprm {
	struct vm_area_struct *vma;
	long unsigned int vma_pages;
	struct mm_struct *mm;
	long unsigned int p;
	long unsigned int argmin;
	unsigned int have_execfd: 1;
	unsigned int execfd_creds: 1;
	unsigned int secureexec: 1;
	unsigned int point_of_no_return: 1;
	struct file *executable;
	struct file *interpreter;
	struct file *file;
	struct cred *cred;
	int unsafe;
	unsigned int per_clear;
	int argc;
	int envc;
	const char *filename;
	const char *interp;
	const char *fdpath;
	unsigned int interp_flags;
	int execfd;
	long unsigned int loader;
	long unsigned int exec;
	struct rlimit rlim_stack;
	char buf[256];
};

struct trace_event_raw_sched_kthread_stop {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	char __data[0];
};

struct trace_event_raw_sched_kthread_stop_ret {
	struct trace_entry ent;
	int ret;
	char __data[0];
};

struct trace_event_raw_sched_kthread_work_queue_work {
	struct trace_entry ent;
	void *work;
	void *function;
	void *worker;
	char __data[0];
};

struct trace_event_raw_sched_kthread_work_execute_start {
	struct trace_entry ent;
	void *work;
	void *function;
	char __data[0];
};

struct trace_event_raw_sched_kthread_work_execute_end {
	struct trace_entry ent;
	void *work;
	void *function;
	char __data[0];
};

struct trace_event_raw_sched_wakeup_template {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	int prio;
	int target_cpu;
	char __data[0];
};

struct trace_event_raw_sched_switch {
	struct trace_entry ent;
	char prev_comm[16];
	pid_t prev_pid;
	int prev_prio;
	long int prev_state;
	char next_comm[16];
	pid_t next_pid;
	int next_prio;
	char __data[0];
};

struct trace_event_raw_sched_migrate_task {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	int prio;
	int orig_cpu;
	int dest_cpu;
	char __data[0];
};

struct trace_event_raw_sched_process_template {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	int prio;
	char __data[0];
};

struct trace_event_raw_sched_process_wait {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	int prio;
	char __data[0];
};

struct trace_event_raw_sched_process_fork {
	struct trace_entry ent;
	char parent_comm[16];
	pid_t parent_pid;
	char child_comm[16];
	pid_t child_pid;
	char __data[0];
};

struct trace_event_raw_sched_process_exec {
	struct trace_entry ent;
	u32 __data_loc_filename;
	pid_t pid;
	pid_t old_pid;
	char __data[0];
};

struct trace_event_raw_sched_stat_template {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	u64 delay;
	char __data[0];
};

struct trace_event_raw_sched_stat_runtime {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	u64 runtime;
	u64 vruntime;
	char __data[0];
};

struct trace_event_raw_sched_pi_setprio {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	int oldprio;
	int newprio;
	char __data[0];
};

struct trace_event_raw_sched_process_hang {
	struct trace_entry ent;
	char comm[16];
	pid_t pid;
	char __data[0];
};

struct trace_event_raw_sched_move_numa {
	struct trace_entry ent;
	pid_t pid;
	pid_t tgid;
	pid_t ngid;
	int src_cpu;
	int src_nid;
	int dst_cpu;
	int dst_nid;
	char __data[0];
};

struct trace_event_raw_sched_numa_pair_template {
	struct trace_entry ent;
	pid_t src_pid;
	pid_t src_tgid;
	pid_t src_ngid;
	int src_cpu;
	int src_nid;
	pid_t dst_pid;
	pid_t dst_tgid;
	pid_t dst_ngid;
	int dst_cpu;
	int dst_nid;
	char __data[0];
};

struct trace_event_raw_sched_skip_vma_numa {
	struct trace_entry ent;
	long unsigned int numa_scan_offset;
	long unsigned int vm_start;
	long unsigned int vm_end;
	enum numa_vmaskip_reason reason;
	char __data[0];
};

struct trace_event_raw_sched_wake_idle_without_ipi {
	struct trace_entry ent;
	int cpu;
	char __data[0];
};

struct trace_event_data_offsets_sched_kthread_stop {};

struct trace_event_data_offsets_sched_kthread_stop_ret {};

struct trace_event_data_offsets_sched_kthread_work_queue_work {};

struct trace_event_data_offsets_sched_kthread_work_execute_start {};

struct trace_event_data_offsets_sched_kthread_work_execute_end {};

struct trace_event_data_offsets_sched_wakeup_template {};

struct trace_event_data_offsets_sched_switch {};

struct trace_event_data_offsets_sched_migrate_task {};

struct trace_event_data_offsets_sched_process_template {};

struct trace_event_data_offsets_sched_process_wait {};

struct trace_event_data_offsets_sched_process_fork {};

struct trace_event_data_offsets_sched_process_exec {
	u32 filename;
};

struct trace_event_data_offsets_sched_stat_template {};

struct trace_event_data_offsets_sched_stat_runtime {};

struct trace_event_data_offsets_sched_pi_setprio {};

struct trace_event_data_offsets_sched_process_hang {};

struct trace_event_data_offsets_sched_move_numa {};

struct trace_event_data_offsets_sched_numa_pair_template {};

struct trace_event_data_offsets_sched_skip_vma_numa {};

struct trace_event_data_offsets_sched_wake_idle_without_ipi {};

typedef void (*btf_trace_sched_kthread_stop)(void *, struct task_struct *);

typedef void (*btf_trace_sched_kthread_stop_ret)(void *, int);

typedef void (*btf_trace_sched_kthread_work_queue_work)(void *, struct kthread_worker *, struct kthread_work *);

typedef void (*btf_trace_sched_kthread_work_execute_start)(void *, struct kthread_work *);

typedef void (*btf_trace_sched_kthread_work_execute_end)(void *, struct kthread_work *, kthread_work_func_t);

typedef void (*btf_trace_sched_waking)(void *, struct task_struct *);

typedef void (*btf_trace_sched_wakeup)(void *, struct task_struct *);

typedef void (*btf_trace_sched_wakeup_new)(void *, struct task_struct *);

typedef void (*btf_trace_sched_switch)(void *, bool, struct task_struct *, struct task_struct *, unsigned int);

typedef void (*btf_trace_sched_migrate_task)(void *, struct task_struct *, int);

typedef void (*btf_trace_sched_process_free)(void *, struct task_struct *);

typedef void (*btf_trace_sched_process_exit)(void *, struct task_struct *);

typedef void (*btf_trace_sched_wait_task)(void *, struct task_struct *);

typedef void (*btf_trace_sched_process_wait)(void *, struct pid *);

typedef void (*btf_trace_sched_process_fork)(void *, struct task_struct *, struct task_struct *);

typedef void (*btf_trace_sched_process_exec)(void *, struct task_struct *, pid_t, struct linux_binprm *);

typedef void (*btf_trace_sched_stat_wait)(void *, struct task_struct *, u64);

typedef void (*btf_trace_sched_stat_sleep)(void *, struct task_struct *, u64);

typedef void (*btf_trace_sched_stat_iowait)(void *, struct task_struct *, u64);

typedef void (*btf_trace_sched_stat_blocked)(void *, struct task_struct *, u64);

typedef void (*btf_trace_sched_stat_runtime)(void *, struct task_struct *, u64, u64);

typedef void (*btf_trace_sched_pi_setprio)(void *, struct task_struct *, struct task_struct *);

typedef void (*btf_trace_sched_process_hang)(void *, struct task_struct *);

typedef void (*btf_trace_sched_move_numa)(void *, struct task_struct *, int, int);

typedef void (*btf_trace_sched_stick_numa)(void *, struct task_struct *, int, struct task_struct *, int);

typedef void (*btf_trace_sched_swap_numa)(void *, struct task_struct *, int, struct task_struct *, int);

typedef void (*btf_trace_sched_skip_vma_numa)(void *, struct mm_struct *, struct vm_area_struct *, enum numa_vmaskip_reason);

typedef void (*btf_trace_sched_wake_idle_without_ipi)(void *, int);

typedef void (*btf_trace_pelt_cfs_tp)(void *, struct cfs_rq *);

typedef void (*btf_trace_pelt_rt_tp)(void *, struct rq *);

struct rt_prio_array {
	long unsigned int bitmap[2];
	struct list_head queue[100];
};

struct rt_rq {
	struct rt_prio_array active;
	unsigned int rt_nr_running;
	unsigned int rr_nr_running;
	struct {
		int curr;
		int next;
	} highest_prio;
	int overloaded;
	struct plist_head pushable_tasks;
	int rt_queued;
	int rt_throttled;
	u64 rt_time;
	u64 rt_runtime;
	raw_spinlock_t rt_runtime_lock;
};

struct dl_rq {
	struct rb_root_cached root;
	unsigned int dl_nr_running;
	struct {
		u64 curr;
		u64 next;
	} earliest_dl;
	int overloaded;
	struct rb_root_cached pushable_dl_tasks_root;
	u64 running_bw;
	u64 this_bw;
	u64 extra_bw;
	u64 max_bw;
	u64 bw_ratio;
};

typedef int (*cpu_stop_fn_t)(void *);

struct cpu_stop_done;

struct cpu_stop_work {
	struct list_head list;
	cpu_stop_fn_t fn;
	long unsigned int caller;
	void *arg;
	struct cpu_stop_done *done;
};

struct balance_callback;

struct cpuidle_state;

struct rq {
	raw_spinlock_t __lock;
	unsigned int nr_running;
	unsigned int nr_numa_running;
	unsigned int nr_preferred_running;
	unsigned int numa_migrate_on;
	long unsigned int last_blocked_load_update_tick;
	unsigned int has_blocked_load;
	call_single_data_t nohz_csd;
	unsigned int nohz_tick_stopped;
	atomic_t nohz_flags;
	unsigned int ttwu_pending;
	u64 nr_switches;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct cfs_rq cfs;
	struct rt_rq rt;
	struct dl_rq dl;
	struct list_head leaf_cfs_rq_list;
	struct list_head *tmp_alone_branch;
	unsigned int nr_uninterruptible;
	struct task_struct *curr;
	struct task_struct *idle;
	struct task_struct *stop;
	long unsigned int next_balance;
	struct mm_struct *prev_mm;
	unsigned int clock_update_flags;
	u64 clock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u64 clock_task;
	u64 clock_pelt;
	long unsigned int lost_idle_time;
	u64 clock_pelt_idle;
	u64 clock_idle;
	atomic_t nr_iowait;
	u64 last_seen_need_resched_ns;
	int ticks_without_resched;
	int membarrier_state;
	struct root_domain *rd;
	struct sched_domain *sd;
	long unsigned int cpu_capacity;
	struct balance_callback *balance_callback;
	unsigned char nohz_idle_balance;
	unsigned char idle_balance;
	long unsigned int misfit_task_load;
	int active_balance;
	int push_cpu;
	struct cpu_stop_work active_balance_work;
	int cpu;
	int online;
	struct list_head cfs_tasks;
	struct sched_avg avg_rt;
	struct sched_avg avg_dl;
	u64 idle_stamp;
	u64 avg_idle;
	u64 max_idle_balance_cost;
	struct rcuwait hotplug_wait;
	long unsigned int calc_load_update;
	long int calc_load_active;
	long: 64;
	long: 64;
	call_single_data_t hrtick_csd;
	struct hrtimer hrtick_timer;
	ktime_t hrtick_time;
	struct sched_info rq_sched_info;
	long long unsigned int rq_cpu_time;
	unsigned int yld_count;
	unsigned int sched_count;
	unsigned int sched_goidle;
	unsigned int ttwu_count;
	unsigned int ttwu_local;
	struct cpuidle_state *idle_state;
	unsigned int nr_pinned;
	unsigned int push_busy;
	struct cpu_stop_work push_work;
	cpumask_var_t scratch_mask;
	long: 64;
	call_single_data_t cfsb_csd;
	struct list_head cfsb_csd_list;
	long: 64;
	long: 64;
};

typedef void (*btf_trace_pelt_dl_tp)(void *, struct rq *);

typedef void (*btf_trace_pelt_thermal_tp)(void *, struct rq *);

typedef void (*btf_trace_pelt_irq_tp)(void *, struct rq *);

typedef void (*btf_trace_pelt_se_tp)(void *, struct sched_entity *);

typedef void (*btf_trace_sched_cpu_capacity_tp)(void *, struct rq *);

typedef void (*btf_trace_sched_overutilized_tp)(void *, struct root_domain *, bool);

typedef void (*btf_trace_sched_util_est_cfs_tp)(void *, struct cfs_rq *);

typedef void (*btf_trace_sched_util_est_se_tp)(void *, struct sched_entity *);

typedef void (*btf_trace_sched_update_nr_running_tp)(void *, struct rq *, int);

typedef void (*btf_trace_sched_compute_energy_tp)(void *, struct task_struct *, int, long unsigned int, long unsigned int, long unsigned int);

struct trace_event_raw_ipi_raise {
	struct trace_entry ent;
	u32 __data_loc_target_cpus;
	const char *reason;
	char __data[0];
};

struct trace_event_raw_ipi_send_cpu {
	struct trace_entry ent;
	unsigned int cpu;
	void *callsite;
	void *callback;
	char __data[0];
};

struct trace_event_raw_ipi_send_cpumask {
	struct trace_entry ent;
	u32 __data_loc_cpumask;
	void *callsite;
	void *callback;
	char __data[0];
};

struct trace_event_raw_ipi_handler {
	struct trace_entry ent;
	const char *reason;
	char __data[0];
};

struct trace_event_data_offsets_ipi_raise {
	u32 target_cpus;
};

struct trace_event_data_offsets_ipi_send_cpu {};

struct trace_event_data_offsets_ipi_send_cpumask {
	u32 cpumask;
};

struct trace_event_data_offsets_ipi_handler {};

typedef void (*btf_trace_ipi_raise)(void *, const struct cpumask *, const char *);

typedef void (*btf_trace_ipi_send_cpu)(void *, const unsigned int, long unsigned int, void *);

typedef void (*btf_trace_ipi_send_cpumask)(void *, const struct cpumask *, long unsigned int, void *);

typedef void (*btf_trace_ipi_entry)(void *, const char *);

typedef void (*btf_trace_ipi_exit)(void *, const char *);

struct cpudl_item {
	u64 dl;
	int cpu;
	int idx;
};

struct rt_bandwidth {
	raw_spinlock_t rt_runtime_lock;
	ktime_t rt_period;
	u64 rt_runtime;
	struct hrtimer rt_period_timer;
	unsigned int rt_period_active;
};

typedef int (*tg_visitor)(struct task_group *, void *);

struct perf_domain {
	struct em_perf_domain *em_pd;
	struct perf_domain *next;
	struct callback_head rcu;
};

struct balance_callback {
	struct balance_callback *next;
	void (*func)(struct rq *);
};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

struct sched_entity_stats {
	struct sched_entity se;
	struct sched_statistics stats;
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_RUN_TO_PARITY = 2,
	__SCHED_FEAT_NEXT_BUDDY = 3,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 4,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 5,
	__SCHED_FEAT_HRTICK = 6,
	__SCHED_FEAT_HRTICK_DL = 7,
	__SCHED_FEAT_DOUBLE_TICK = 8,
	__SCHED_FEAT_NONTASK_CAPACITY = 9,
	__SCHED_FEAT_TTWU_QUEUE = 10,
	__SCHED_FEAT_SIS_UTIL = 11,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 12,
	__SCHED_FEAT_RT_PUSH_IPI = 13,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 14,
	__SCHED_FEAT_LB_MIN = 15,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 16,
	__SCHED_FEAT_WA_IDLE = 17,
	__SCHED_FEAT_WA_WEIGHT = 18,
	__SCHED_FEAT_WA_BIAS = 19,
	__SCHED_FEAT_UTIL_EST = 20,
	__SCHED_FEAT_UTIL_EST_FASTUP = 21,
	__SCHED_FEAT_LATENCY_WARN = 22,
	__SCHED_FEAT_HZ_BW = 23,
	__SCHED_FEAT_NR = 24,
};

struct affinity_context {
	const struct cpumask *new_mask;
	struct cpumask *user_mask;
	unsigned int flags;
};

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} class_double_raw_spinlock_t;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

enum cpu_util_type {
	FREQUENCY_UTIL = 0,
	ENERGY_UTIL = 1,
};

typedef void (*task_work_func_t)(struct callback_head *);

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
};

struct io_uring_sqe {
	__u8 opcode;
	__u8 flags;
	__u16 ioprio;
	__s32 fd;
	union {
		__u64 off;
		__u64 addr2;
		struct {
			__u32 cmd_op;
			__u32 __pad1;
		};
	};
	union {
		__u64 addr;
		__u64 splice_off_in;
		struct {
			__u32 level;
			__u32 optname;
		};
	};
	__u32 len;
	union {
		__kernel_rwf_t rw_flags;
		__u32 fsync_flags;
		__u16 poll_events;
		__u32 poll32_events;
		__u32 sync_range_flags;
		__u32 msg_flags;
		__u32 timeout_flags;
		__u32 accept_flags;
		__u32 cancel_flags;
		__u32 open_flags;
		__u32 statx_flags;
		__u32 fadvise_advice;
		__u32 splice_flags;
		__u32 rename_flags;
		__u32 unlink_flags;
		__u32 hardlink_flags;
		__u32 xattr_flags;
		__u32 msg_ring_flags;
		__u32 uring_cmd_flags;
		__u32 waitid_flags;
		__u32 futex_flags;
	};
	__u64 user_data;
	union {
		__u16 buf_index;
		__u16 buf_group;
	};
	__u16 personality;
	union {
		__s32 splice_fd_in;
		__u32 file_index;
		__u32 optlen;
		struct {
			__u16 addr_len;
			__u16 __pad3[1];
		};
	};
	union {
		struct {
			__u64 addr3;
			__u64 __pad2[1];
		};
		__u64 optval;
		__u8 cmd[0];
	};
};

enum {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_LAST = 54,
};

struct io_uring_cqe {
	__u64 user_data;
	__s32 res;
	__u32 flags;
	__u64 big_cqe[0];
};

enum {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_LAST = 26,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

struct io_wq_work_node {
	struct io_wq_work_node *next;
};

struct io_wq_work_list {
	struct io_wq_work_node *first;
	struct io_wq_work_node *last;
};

struct io_wq_work {
	struct io_wq_work_node list;
	unsigned int flags;
	int cancel_seq;
};

struct io_fixed_file {
	long unsigned int file_ptr;
};

struct io_file_table {
	struct io_fixed_file *files;
	long unsigned int *bitmap;
	unsigned int alloc_hint;
};

struct io_hash_bucket {
	spinlock_t lock;
	struct hlist_head list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct io_hash_table {
	struct io_hash_bucket *hbs;
	unsigned int hash_bits;
};

struct io_kiocb;

struct io_submit_link {
	struct io_kiocb *head;
	struct io_kiocb *last;
};

struct io_submit_state {
	struct io_wq_work_node free_list;
	struct io_wq_work_list compl_reqs;
	struct io_submit_link link;
	bool plug_started;
	bool need_plug;
	short unsigned int submit_nr;
	unsigned int cqes_count;
	struct blk_plug plug;
};

struct io_alloc_cache {
	struct io_wq_work_node list;
	unsigned int nr_cached;
	unsigned int max_cached;
	size_t elem_size;
};

struct io_restriction {
	long unsigned int register_op[1];
	long unsigned int sqe_op[1];
	u8 sqe_flags_allowed;
	u8 sqe_flags_required;
	bool registered;
};

struct io_rings;

struct io_rsrc_node;

struct io_mapped_ubuf;

struct io_buffer_list;

struct io_ev_fd;

struct io_sq_data;

struct io_rsrc_data;

struct socket;

struct io_wq_hash;

struct io_ring_ctx {
	struct {
		unsigned int flags;
		unsigned int drain_next: 1;
		unsigned int restricted: 1;
		unsigned int off_timeout_used: 1;
		unsigned int drain_active: 1;
		unsigned int has_evfd: 1;
		unsigned int task_complete: 1;
		unsigned int lockless_cq: 1;
		unsigned int syscall_iopoll: 1;
		unsigned int poll_activated: 1;
		unsigned int drain_disabled: 1;
		unsigned int compat: 1;
		struct task_struct *submitter_task;
		struct io_rings *rings;
		struct percpu_ref refs;
		enum task_work_notify_mode notify_method;
		long: 64;
		long: 64;
	};
	struct {
		struct mutex uring_lock;
		u32 *sq_array;
		struct io_uring_sqe *sq_sqes;
		unsigned int cached_sq_head;
		unsigned int sq_entries;
		struct io_rsrc_node *rsrc_node;
		atomic_t cancel_seq;
		struct io_file_table file_table;
		unsigned int nr_user_files;
		unsigned int nr_user_bufs;
		struct io_mapped_ubuf **user_bufs;
		struct io_submit_state submit_state;
		struct io_buffer_list *io_bl;
		struct xarray io_bl_xa;
		struct io_hash_table cancel_table_locked;
		struct io_alloc_cache apoll_cache;
		struct io_alloc_cache netmsg_cache;
		struct io_wq_work_list iopoll_list;
		bool poll_multi_queue;
		struct hlist_head cancelable_uring_cmd;
		long: 64;
		long: 64;
	};
	struct {
		struct io_uring_cqe *cqe_cached;
		struct io_uring_cqe *cqe_sentinel;
		unsigned int cached_cq_tail;
		unsigned int cq_entries;
		struct io_ev_fd *io_ev_fd;
		unsigned int cq_extra;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		struct llist_head work_llist;
		long unsigned int check_cq;
		atomic_t cq_wait_nr;
		atomic_t cq_timeouts;
		struct wait_queue_head cq_wait;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		spinlock_t timeout_lock;
		struct list_head timeout_list;
		struct list_head ltimeout_list;
		unsigned int cq_last_tm_flush;
		long: 64;
		long: 64;
		long: 64;
	};
	struct io_uring_cqe completion_cqes[16];
	spinlock_t completion_lock;
	struct io_wq_work_list locked_free_list;
	unsigned int locked_free_nr;
	struct list_head io_buffers_comp;
	struct list_head cq_overflow_list;
	struct io_hash_table cancel_table;
	struct hlist_head waitid_list;
	struct hlist_head futex_list;
	struct io_alloc_cache futex_cache;
	const struct cred *sq_creds;
	struct io_sq_data *sq_data;
	struct wait_queue_head sqo_sq_wait;
	struct list_head sqd_list;
	unsigned int file_alloc_start;
	unsigned int file_alloc_end;
	struct xarray personalities;
	u32 pers_next;
	struct list_head io_buffers_cache;
	struct wait_queue_head poll_wq;
	struct io_restriction restrictions;
	struct io_mapped_ubuf *dummy_ubuf;
	struct io_rsrc_data *file_data;
	struct io_rsrc_data *buf_data;
	struct list_head rsrc_ref_list;
	struct io_alloc_cache rsrc_node_cache;
	struct wait_queue_head rsrc_quiesce_wq;
	unsigned int rsrc_quiesce;
	struct socket *ring_sock;
	struct io_wq_hash *hash_map;
	struct user_struct *user;
	struct mm_struct *mm_account;
	struct llist_head fallback_llist;
	struct delayed_work fallback_work;
	struct work_struct exit_work;
	struct list_head tctx_list;
	struct completion ref_comp;
	u32 iowq_limits[2];
	bool iowq_limits_set;
	struct callback_head poll_wq_task_work;
	struct list_head defer_list;
	unsigned int sq_thread_idle;
	unsigned int evfd_last_cq_tail;
	short unsigned int n_ring_pages;
	short unsigned int n_sqe_pages;
	struct page **ring_pages;
	struct page **sqe_pages;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct io_uring {
	u32 head;
	u32 tail;
};

struct io_rings {
	struct io_uring sq;
	struct io_uring cq;
	u32 sq_ring_mask;
	u32 cq_ring_mask;
	u32 sq_ring_entries;
	u32 cq_ring_entries;
	u32 sq_dropped;
	atomic_t sq_flags;
	u32 cq_flags;
	u32 cq_overflow;
	long: 64;
	long: 64;
	struct io_uring_cqe cqes[0];
};

struct io_cmd_data {
	struct file *file;
	__u8 data[56];
};

struct io_cqe {
	__u64 user_data;
	__s32 res;
	union {
		__u32 flags;
		int fd;
	};
};

struct io_tw_state;

typedef void (*io_req_tw_func_t)(struct io_kiocb *, struct io_tw_state *);

struct io_task_work {
	struct llist_node node;
	io_req_tw_func_t func;
};

struct io_buffer;

struct async_poll;

struct io_kiocb {
	union {
		struct file *file;
		struct io_cmd_data cmd;
	};
	u8 opcode;
	u8 iopoll_completed;
	u16 buf_index;
	unsigned int flags;
	struct io_cqe cqe;
	struct io_ring_ctx *ctx;
	struct task_struct *task;
	struct io_rsrc_node *rsrc_node;
	union {
		struct io_mapped_ubuf *imu;
		struct io_buffer *kbuf;
		struct io_buffer_list *buf_list;
	};
	union {
		struct io_wq_work_node comp_list;
		__poll_t apoll_events;
	};
	atomic_t refs;
	atomic_t poll_refs;
	struct io_task_work io_task_work;
	unsigned int nr_tw;
	struct hlist_node hash_node;
	struct async_poll *apoll;
	void *async_data;
	struct io_kiocb *link;
	const struct cred *creds;
	struct io_wq_work work;
	struct {
		u64 extra1;
		u64 extra2;
	} big_cqe;
};

struct io_ev_fd {
	struct eventfd_ctx *cq_ev_fd;
	unsigned int eventfd_async: 1;
	struct callback_head rcu;
	atomic_t refs;
	atomic_t ops;
};

struct io_wq_hash {
	refcount_t refs;
	long unsigned int map;
	struct wait_queue_head wait;
};

struct io_tw_state {
	bool locked;
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_BUFFER_SELECTED_BIT = 15,
	REQ_F_BUFFER_RING_BIT = 16,
	REQ_F_REISSUE_BIT = 17,
	REQ_F_CREDS_BIT = 18,
	REQ_F_REFCOUNT_BIT = 19,
	REQ_F_ARM_LTIMEOUT_BIT = 20,
	REQ_F_ASYNC_DATA_BIT = 21,
	REQ_F_SKIP_LINK_CQES_BIT = 22,
	REQ_F_SINGLE_POLL_BIT = 23,
	REQ_F_DOUBLE_POLL_BIT = 24,
	REQ_F_PARTIAL_IO_BIT = 25,
	REQ_F_APOLL_MULTISHOT_BIT = 26,
	REQ_F_CLEAR_POLLIN_BIT = 27,
	REQ_F_HASH_LOCKED_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	__REQ_F_LAST_BIT = 31,
};

struct set_affinity_pending;

struct migration_arg {
	struct task_struct *task;
	int dest_cpu;
	struct set_affinity_pending *pending;
};

struct set_affinity_pending {
	refcount_t refs;
	unsigned int stop_pending;
	struct completion done;
	struct cpu_stop_work stop_work;
	struct migration_arg arg;
};

struct migration_swap_arg {
	struct task_struct *src_task;
	struct task_struct *dst_task;
	int src_cpu;
	int dst_cpu;
};

typedef struct task_struct *class_find_get_task_t;

enum {
	preempt_dynamic_undefined = -1,
	preempt_dynamic_none = 0,
	preempt_dynamic_voluntary = 1,
	preempt_dynamic_full = 2,
};

struct cfs_schedulable_data {
	struct task_group *tg;
	u64 period;
	u64 quota;
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

union cpumask_rcuhead {
	cpumask_t cpumask;
	struct callback_head rcu;
};

typedef s64 int64_t;

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

struct clock_event_device;

struct tick_device {
	struct clock_event_device *evtdev;
	enum tick_device_mode mode;
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

struct clock_event_device {
	void (*event_handler)(struct clock_event_device *);
	int (*set_next_event)(long unsigned int, struct clock_event_device *);
	int (*set_next_ktime)(ktime_t, struct clock_event_device *);
	ktime_t next_event;
	u64 max_delta_ns;
	u64 min_delta_ns;
	u32 mult;
	u32 shift;
	enum clock_event_state state_use_accessors;
	unsigned int features;
	long unsigned int retries;
	int (*set_state_periodic)(struct clock_event_device *);
	int (*set_state_oneshot)(struct clock_event_device *);
	int (*set_state_oneshot_stopped)(struct clock_event_device *);
	int (*set_state_shutdown)(struct clock_event_device *);
	int (*tick_resume)(struct clock_event_device *);
	void (*broadcast)(const struct cpumask *);
	void (*suspend)(struct clock_event_device *);
	void (*resume)(struct clock_event_device *);
	long unsigned int min_delta_ticks;
	long unsigned int max_delta_ticks;
	const char *name;
	int rating;
	int irq;
	int bound_on;
	const struct cpumask *cpumask;
	struct list_head list;
	struct module *owner;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ce_unbind {
	struct clock_event_device *ce;
	int res;
};

struct bpf_run_ctx {};

struct proc_ops {
	unsigned int proc_flags;
	int (*proc_open)(struct inode *, struct file *);
	ssize_t (*proc_read)(struct file *, char *, size_t, loff_t *);
	ssize_t (*proc_read_iter)(struct kiocb *, struct iov_iter *);
	ssize_t (*proc_write)(struct file *, const char *, size_t, loff_t *);
	loff_t (*proc_lseek)(struct file *, loff_t, int);
	int (*proc_release)(struct inode *, struct file *);
	__poll_t (*proc_poll)(struct file *, struct poll_table_struct *);
	long int (*proc_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*proc_mmap)(struct file *, struct vm_area_struct *);
	long unsigned int (*proc_get_unmapped_area)(struct file *, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
};

struct bpf_insn {
	__u8 code;
	__u8 dst_reg: 4;
	__u8 src_reg: 4;
	__s16 off;
	__s32 imm;
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

union bpf_iter_link_info {
	struct {
		__u32 map_fd;
	} map;
	struct {
		enum bpf_cgroup_iter_order order;
		__u32 cgroup_fd;
		__u64 cgroup_id;
	} cgroup;
	struct {
		__u32 tid;
		__u32 pid;
		__u32 pid_fd;
	} task;
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	__MAX_BPF_ATTACH_TYPE = 56,
};

union bpf_attr {
	struct {
		__u32 map_type;
		__u32 key_size;
		__u32 value_size;
		__u32 max_entries;
		__u32 map_flags;
		__u32 inner_map_fd;
		__u32 numa_node;
		char map_name[16];
		__u32 map_ifindex;
		__u32 btf_fd;
		__u32 btf_key_type_id;
		__u32 btf_value_type_id;
		__u32 btf_vmlinux_value_type_id;
		__u64 map_extra;
	};
	struct {
		__u32 map_fd;
		__u64 key;
		union {
			__u64 value;
			__u64 next_key;
		};
		__u64 flags;
	};
	struct {
		__u64 in_batch;
		__u64 out_batch;
		__u64 keys;
		__u64 values;
		__u32 count;
		__u32 map_fd;
		__u64 elem_flags;
		__u64 flags;
	} batch;
	struct {
		__u32 prog_type;
		__u32 insn_cnt;
		__u64 insns;
		__u64 license;
		__u32 log_level;
		__u32 log_size;
		__u64 log_buf;
		__u32 kern_version;
		__u32 prog_flags;
		char prog_name[16];
		__u32 prog_ifindex;
		__u32 expected_attach_type;
		__u32 prog_btf_fd;
		__u32 func_info_rec_size;
		__u64 func_info;
		__u32 func_info_cnt;
		__u32 line_info_rec_size;
		__u64 line_info;
		__u32 line_info_cnt;
		__u32 attach_btf_id;
		union {
			__u32 attach_prog_fd;
			__u32 attach_btf_obj_fd;
		};
		__u32 core_relo_cnt;
		__u64 fd_array;
		__u64 core_relos;
		__u32 core_relo_rec_size;
		__u32 log_true_size;
	};
	struct {
		__u64 pathname;
		__u32 bpf_fd;
		__u32 file_flags;
		__s32 path_fd;
	};
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_bpf_fd;
		__u32 attach_type;
		__u32 attach_flags;
		__u32 replace_bpf_fd;
		union {
			__u32 relative_fd;
			__u32 relative_id;
		};
		__u64 expected_revision;
	};
	struct {
		__u32 prog_fd;
		__u32 retval;
		__u32 data_size_in;
		__u32 data_size_out;
		__u64 data_in;
		__u64 data_out;
		__u32 repeat;
		__u32 duration;
		__u32 ctx_size_in;
		__u32 ctx_size_out;
		__u64 ctx_in;
		__u64 ctx_out;
		__u32 flags;
		__u32 cpu;
		__u32 batch_size;
	} test;
	struct {
		union {
			__u32 start_id;
			__u32 prog_id;
			__u32 map_id;
			__u32 btf_id;
			__u32 link_id;
		};
		__u32 next_id;
		__u32 open_flags;
	};
	struct {
		__u32 bpf_fd;
		__u32 info_len;
		__u64 info;
	} info;
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 query_flags;
		__u32 attach_flags;
		__u64 prog_ids;
		union {
			__u32 prog_cnt;
			__u32 count;
		};
		__u64 prog_attach_flags;
		__u64 link_ids;
		__u64 link_attach_flags;
		__u64 revision;
	} query;
	struct {
		__u64 name;
		__u32 prog_fd;
	} raw_tracepoint;
	struct {
		__u64 btf;
		__u64 btf_log_buf;
		__u32 btf_size;
		__u32 btf_log_size;
		__u32 btf_log_level;
		__u32 btf_log_true_size;
	};
	struct {
		__u32 pid;
		__u32 fd;
		__u32 flags;
		__u32 buf_len;
		__u64 buf;
		__u32 prog_id;
		__u32 fd_type;
		__u64 probe_offset;
		__u64 probe_addr;
	} task_fd_query;
	struct {
		union {
			__u32 prog_fd;
			__u32 map_fd;
		};
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 flags;
		union {
			__u32 target_btf_id;
			struct {
				__u64 iter_info;
				__u32 iter_info_len;
			};
			struct {
				__u64 bpf_cookie;
			} perf_event;
			struct {
				__u32 flags;
				__u32 cnt;
				__u64 syms;
				__u64 addrs;
				__u64 cookies;
			} kprobe_multi;
			struct {
				__u32 target_btf_id;
				__u64 cookie;
			} tracing;
			struct {
				__u32 pf;
				__u32 hooknum;
				__s32 priority;
				__u32 flags;
			} netfilter;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} tcx;
			struct {
				__u64 path;
				__u64 offsets;
				__u64 ref_ctr_offsets;
				__u64 cookies;
				__u32 cnt;
				__u32 flags;
				__u32 pid;
			} uprobe_multi;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} netkit;
		};
	} link_create;
	struct {
		__u32 link_fd;
		union {
			__u32 new_prog_fd;
			__u32 new_map_fd;
		};
		__u32 flags;
		union {
			__u32 old_prog_fd;
			__u32 old_map_fd;
		};
	} link_update;
	struct {
		__u32 link_fd;
	} link_detach;
	struct {
		__u32 type;
	} enable_stats;
	struct {
		__u32 link_fd;
		__u32 flags;
	} iter_create;
	struct {
		__u32 prog_fd;
		__u32 map_fd;
		__u32 flags;
	} prog_bind_map;
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

struct bpf_link_info {
	__u32 type;
	__u32 id;
	__u32 prog_id;
	union {
		struct {
			__u64 tp_name;
			__u32 tp_name_len;
		} raw_tracepoint;
		struct {
			__u32 attach_type;
			__u32 target_obj_id;
			__u32 target_btf_id;
		} tracing;
		struct {
			__u64 cgroup_id;
			__u32 attach_type;
		} cgroup;
		struct {
			__u64 target_name;
			__u32 target_name_len;
			union {
				struct {
					__u32 map_id;
				} map;
			};
			union {
				struct {
					__u64 cgroup_id;
					__u32 order;
				} cgroup;
				struct {
					__u32 tid;
					__u32 pid;
				} task;
			};
		} iter;
		struct {
			__u32 netns_ino;
			__u32 attach_type;
		} netns;
		struct {
			__u32 ifindex;
		} xdp;
		struct {
			__u32 map_id;
		} struct_ops;
		struct {
			__u32 pf;
			__u32 hooknum;
			__s32 priority;
			__u32 flags;
		} netfilter;
		struct {
			__u64 addrs;
			__u32 count;
			__u32 flags;
			__u64 missed;
		} kprobe_multi;
		struct {
			__u32 type;
			union {
				struct {
					__u64 file_name;
					__u32 name_len;
					__u32 offset;
				} uprobe;
				struct {
					__u64 func_name;
					__u32 name_len;
					__u32 offset;
					__u64 addr;
					__u64 missed;
				} kprobe;
				struct {
					__u64 tp_name;
					__u32 name_len;
				} tracepoint;
				struct {
					__u64 config;
					__u32 type;
				} event;
			};
		} perf_event;
		struct {
			__u32 ifindex;
			__u32 attach_type;
		} tcx;
		struct {
			__u32 ifindex;
			__u32 attach_type;
		} netkit;
	};
};

struct bpf_func_info {
	__u32 insn_off;
	__u32 type_id;
};

struct bpf_line_info {
	__u32 insn_off;
	__u32 file_name_off;
	__u32 line_off;
	__u32 line_col;
};

struct sock_filter {
	__u16 code;
	__u8 jt;
	__u8 jf;
	__u32 k;
};

struct btf_type {
	__u32 name_off;
	__u32 info;
	union {
		__u32 size;
		__u32 type;
	};
};

struct bpf_prog_stats;

struct bpf_prog_aux;

struct sock_fprog_kern;

struct bpf_prog {
	u16 pages;
	u16 jited: 1;
	u16 jit_requested: 1;
	u16 gpl_compatible: 1;
	u16 cb_access: 1;
	u16 dst_needed: 1;
	u16 blinding_requested: 1;
	u16 blinded: 1;
	u16 is_func: 1;
	u16 kprobe_override: 1;
	u16 has_callchain_buf: 1;
	u16 enforce_expected_attach_type: 1;
	u16 call_get_stack: 1;
	u16 call_get_func_ip: 1;
	u16 tstamp_type_access: 1;
	enum bpf_prog_type type;
	enum bpf_attach_type expected_attach_type;
	u32 len;
	u32 jited_len;
	u8 tag[8];
	struct bpf_prog_stats *stats;
	int *active;
	unsigned int (*bpf_func)(const void *, const struct bpf_insn *);
	struct bpf_prog_aux *aux;
	struct sock_fprog_kern *orig_prog;
	union {
		struct {
			struct {} __empty_insns;
			struct sock_filter insns[0];
		};
		struct {
			struct {} __empty_insnsi;
			struct bpf_insn insnsi[0];
		};
	};
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
};

typedef void (*btf_dtor_kfunc_t)(void *);

struct btf;

struct btf_field_kptr {
	struct btf *btf;
	struct module *module;
	btf_dtor_kfunc_t dtor;
	u32 btf_id;
};

struct btf_record;

struct btf_field_graph_root {
	struct btf *btf;
	u32 value_btf_id;
	u32 node_offset;
	struct btf_record *value_rec;
};

struct btf_field {
	u32 offset;
	u32 size;
	enum btf_field_type type;
	union {
		struct btf_field_kptr kptr;
		struct btf_field_graph_root graph_root;
	};
};

struct btf_record {
	u32 cnt;
	u32 field_mask;
	int spin_lock_off;
	int timer_off;
	int refcount_off;
	struct btf_field fields[0];
};

typedef struct {
	local64_t v;
} u64_stats_t;

struct bpf_cgroup_storage;

struct bpf_prog_array_item {
	struct bpf_prog *prog;
	union {
		struct bpf_cgroup_storage *cgroup_storage[2];
		u64 bpf_cookie;
	};
};

struct bpf_prog_array {
	struct callback_head rcu;
	struct bpf_prog_array_item items[0];
};

typedef u64 (*bpf_callback_t)(u64, u64, u64, u64, u64);

struct bpf_iter_aux_info;

typedef int (*bpf_iter_init_seq_priv_t)(void *, struct bpf_iter_aux_info *);

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

struct bpf_map;

struct bpf_iter_aux_info {
	struct bpf_map *map;
	struct {
		struct cgroup *start;
		enum bpf_cgroup_iter_order order;
	} cgroup;
	struct {
		enum bpf_iter_task_type type;
		u32 pid;
	} task;
};

typedef void (*bpf_iter_fini_seq_priv_t)(void *);

struct bpf_iter_seq_info {
	const struct seq_operations *seq_ops;
	bpf_iter_init_seq_priv_t init_seq_private;
	bpf_iter_fini_seq_priv_t fini_seq_private;
	u32 seq_priv_size;
};

struct bpf_local_storage_map;

struct bpf_verifier_env;

struct bpf_func_state;

struct bpf_map_ops {
	int (*map_alloc_check)(union bpf_attr *);
	struct bpf_map * (*map_alloc)(union bpf_attr *);
	void (*map_release)(struct bpf_map *, struct file *);
	void (*map_free)(struct bpf_map *);
	int (*map_get_next_key)(struct bpf_map *, void *, void *);
	void (*map_release_uref)(struct bpf_map *);
	void * (*map_lookup_elem_sys_only)(struct bpf_map *, void *);
	int (*map_lookup_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	int (*map_lookup_and_delete_elem)(struct bpf_map *, void *, void *, u64);
	int (*map_lookup_and_delete_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	int (*map_update_batch)(struct bpf_map *, struct file *, const union bpf_attr *, union bpf_attr *);
	int (*map_delete_batch)(struct bpf_map *, const union bpf_attr *, union bpf_attr *);
	void * (*map_lookup_elem)(struct bpf_map *, void *);
	long int (*map_update_elem)(struct bpf_map *, void *, void *, u64);
	long int (*map_delete_elem)(struct bpf_map *, void *);
	long int (*map_push_elem)(struct bpf_map *, void *, u64);
	long int (*map_pop_elem)(struct bpf_map *, void *);
	long int (*map_peek_elem)(struct bpf_map *, void *);
	void * (*map_lookup_percpu_elem)(struct bpf_map *, void *, u32);
	void * (*map_fd_get_ptr)(struct bpf_map *, struct file *, int);
	void (*map_fd_put_ptr)(void *);
	int (*map_gen_lookup)(struct bpf_map *, struct bpf_insn *);
	u32 (*map_fd_sys_lookup_elem)(void *);
	void (*map_seq_show_elem)(struct bpf_map *, void *, struct seq_file *);
	int (*map_check_btf)(const struct bpf_map *, const struct btf *, const struct btf_type *, const struct btf_type *);
	int (*map_poke_track)(struct bpf_map *, struct bpf_prog_aux *);
	void (*map_poke_untrack)(struct bpf_map *, struct bpf_prog_aux *);
	void (*map_poke_run)(struct bpf_map *, u32, struct bpf_prog *, struct bpf_prog *);
	int (*map_direct_value_addr)(const struct bpf_map *, u64 *, u32);
	int (*map_direct_value_meta)(const struct bpf_map *, u64, u32 *);
	int (*map_mmap)(struct bpf_map *, struct vm_area_struct *);
	__poll_t (*map_poll)(struct bpf_map *, struct file *, struct poll_table_struct *);
	int (*map_local_storage_charge)(struct bpf_local_storage_map *, void *, u32);
	void (*map_local_storage_uncharge)(struct bpf_local_storage_map *, void *, u32);
	struct bpf_local_storage ** (*map_owner_storage_ptr)(void *);
	long int (*map_redirect)(struct bpf_map *, u64, u64);
	bool (*map_meta_equal)(const struct bpf_map *, const struct bpf_map *);
	int (*map_set_for_each_callback_args)(struct bpf_verifier_env *, struct bpf_func_state *, struct bpf_func_state *);
	long int (*map_for_each_callback)(struct bpf_map *, bpf_callback_t, void *, u64);
	u64 (*map_mem_usage)(const struct bpf_map *);
	int *map_btf_id;
	const struct bpf_iter_seq_info *iter_seq_info;
};

struct bpf_map {
	const struct bpf_map_ops *ops;
	struct bpf_map *inner_map_meta;
	void *security;
	enum bpf_map_type map_type;
	u32 key_size;
	u32 value_size;
	u32 max_entries;
	u64 map_extra;
	u32 map_flags;
	u32 id;
	struct btf_record *record;
	int numa_node;
	u32 btf_key_type_id;
	u32 btf_value_type_id;
	u32 btf_vmlinux_value_type_id;
	struct btf *btf;
	struct obj_cgroup *objcg;
	char name[16];
	long: 64;
	long: 64;
	atomic64_t refcnt;
	atomic64_t usercnt;
	struct work_struct work;
	struct mutex freeze_mutex;
	atomic64_t writecnt;
	struct {
		spinlock_t lock;
		enum bpf_prog_type type;
		bool jited;
		bool xdp_has_frags;
	} owner;
	bool bypass_spec_v1;
	bool frozen;
	s64 *elem_count;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct btf_header {
	__u16 magic;
	__u8 version;
	__u8 flags;
	__u32 hdr_len;
	__u32 type_off;
	__u32 type_len;
	__u32 str_off;
	__u32 str_len;
};

struct btf_kfunc_set_tab;

struct btf_id_dtor_kfunc_tab;

struct btf_struct_metas;

struct btf {
	void *data;
	struct btf_type **types;
	u32 *resolved_ids;
	u32 *resolved_sizes;
	const char *strings;
	void *nohdr_data;
	struct btf_header hdr;
	u32 nr_types;
	u32 types_size;
	u32 data_size;
	refcount_t refcnt;
	u32 id;
	struct callback_head rcu;
	struct btf_kfunc_set_tab *kfunc_set_tab;
	struct btf_id_dtor_kfunc_tab *dtor_kfunc_tab;
	struct btf_struct_metas *struct_meta_tab;
	struct btf *base_btf;
	u32 start_id;
	u32 start_str_off;
	char name[56];
	bool kernel_btf;
};

struct bpf_ksym {
	long unsigned int start;
	long unsigned int end;
	char name[512];
	struct list_head lnode;
	struct latch_tree_node tnode;
	bool prog;
};

struct bpf_ctx_arg_aux;

struct bpf_trampoline;

struct bpf_jit_poke_descriptor;

struct bpf_kfunc_desc_tab;

struct bpf_kfunc_btf_tab;

struct bpf_prog_ops;

struct btf_mod_pair;

struct bpf_prog_offload;

struct bpf_func_info_aux;

struct bpf_prog_aux {
	atomic64_t refcnt;
	u32 used_map_cnt;
	u32 used_btf_cnt;
	u32 max_ctx_offset;
	u32 max_pkt_offset;
	u32 max_tp_access;
	u32 stack_depth;
	u32 id;
	u32 func_cnt;
	u32 real_func_cnt;
	u32 func_idx;
	u32 attach_btf_id;
	u32 ctx_arg_info_size;
	u32 max_rdonly_access;
	u32 max_rdwr_access;
	struct btf *attach_btf;
	const struct bpf_ctx_arg_aux *ctx_arg_info;
	struct mutex dst_mutex;
	struct bpf_prog *dst_prog;
	struct bpf_trampoline *dst_trampoline;
	enum bpf_prog_type saved_dst_prog_type;
	enum bpf_attach_type saved_dst_attach_type;
	bool verifier_zext;
	bool dev_bound;
	bool offload_requested;
	bool attach_btf_trace;
	bool func_proto_unreliable;
	bool sleepable;
	bool tail_call_reachable;
	bool xdp_has_frags;
	bool exception_cb;
	bool exception_boundary;
	const struct btf_type *attach_func_proto;
	const char *attach_func_name;
	struct bpf_prog **func;
	void *jit_data;
	struct bpf_jit_poke_descriptor *poke_tab;
	struct bpf_kfunc_desc_tab *kfunc_tab;
	struct bpf_kfunc_btf_tab *kfunc_btf_tab;
	u32 size_poke_tab;
	struct bpf_ksym ksym;
	const struct bpf_prog_ops *ops;
	struct bpf_map **used_maps;
	struct mutex used_maps_mutex;
	struct btf_mod_pair *used_btfs;
	struct bpf_prog *prog;
	struct user_struct *user;
	u64 load_time;
	u32 verified_insns;
	int cgroup_atype;
	struct bpf_map *cgroup_storage[2];
	char name[16];
	unsigned int (*bpf_exception_cb)(u64, u64, u64);
	void *security;
	struct bpf_prog_offload *offload;
	struct btf *btf;
	struct bpf_func_info *func_info;
	struct bpf_func_info_aux *func_info_aux;
	struct bpf_line_info *linfo;
	void **jited_linfo;
	u32 func_info_cnt;
	u32 nr_linfo;
	u32 linfo_idx;
	struct module *mod;
	u32 num_exentries;
	struct exception_table_entry *extable;
	union {
		struct work_struct work;
		struct callback_head rcu;
	};
};

struct bpf_offloaded_map;

struct bpf_map_dev_ops {
	int (*map_get_next_key)(struct bpf_offloaded_map *, void *, void *);
	int (*map_lookup_elem)(struct bpf_offloaded_map *, void *, void *);
	int (*map_update_elem)(struct bpf_offloaded_map *, void *, void *, u64);
	int (*map_delete_elem)(struct bpf_offloaded_map *, void *);
};

struct bpf_offloaded_map {
	struct bpf_map map;
	struct net_device *netdev;
	const struct bpf_map_dev_ops *dev_ops;
	void *dev_priv;
	struct list_head offloads;
	long: 64;
	long: 64;
	long: 64;
};

typedef u32 xdp_features_t;

typedef u64 netdev_features_t;

struct net_device_stats {
	union {
		long unsigned int rx_packets;
		atomic_long_t __rx_packets;
	};
	union {
		long unsigned int tx_packets;
		atomic_long_t __tx_packets;
	};
	union {
		long unsigned int rx_bytes;
		atomic_long_t __rx_bytes;
	};
	union {
		long unsigned int tx_bytes;
		atomic_long_t __tx_bytes;
	};
	union {
		long unsigned int rx_errors;
		atomic_long_t __rx_errors;
	};
	union {
		long unsigned int tx_errors;
		atomic_long_t __tx_errors;
	};
	union {
		long unsigned int rx_dropped;
		atomic_long_t __rx_dropped;
	};
	union {
		long unsigned int tx_dropped;
		atomic_long_t __tx_dropped;
	};
	union {
		long unsigned int multicast;
		atomic_long_t __multicast;
	};
	union {
		long unsigned int collisions;
		atomic_long_t __collisions;
	};
	union {
		long unsigned int rx_length_errors;
		atomic_long_t __rx_length_errors;
	};
	union {
		long unsigned int rx_over_errors;
		atomic_long_t __rx_over_errors;
	};
	union {
		long unsigned int rx_crc_errors;
		atomic_long_t __rx_crc_errors;
	};
	union {
		long unsigned int rx_frame_errors;
		atomic_long_t __rx_frame_errors;
	};
	union {
		long unsigned int rx_fifo_errors;
		atomic_long_t __rx_fifo_errors;
	};
	union {
		long unsigned int rx_missed_errors;
		atomic_long_t __rx_missed_errors;
	};
	union {
		long unsigned int tx_aborted_errors;
		atomic_long_t __tx_aborted_errors;
	};
	union {
		long unsigned int tx_carrier_errors;
		atomic_long_t __tx_carrier_errors;
	};
	union {
		long unsigned int tx_fifo_errors;
		atomic_long_t __tx_fifo_errors;
	};
	union {
		long unsigned int tx_heartbeat_errors;
		atomic_long_t __tx_heartbeat_errors;
	};
	union {
		long unsigned int tx_window_errors;
		atomic_long_t __tx_window_errors;
	};
	union {
		long unsigned int rx_compressed;
		atomic_long_t __rx_compressed;
	};
	union {
		long unsigned int tx_compressed;
		atomic_long_t __tx_compressed;
	};
};

struct netdev_hw_addr_list {
	struct list_head list;
	int count;
	struct rb_root tree;
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

typedef rx_handler_result_t rx_handler_func_t(struct sk_buff **);

typedef struct {
	struct net *net;
} possible_net_t;

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

struct netdev_tc_txq {
	u16 count;
	u16 offset;
};

struct sfp_bus;

struct bpf_xdp_link;

struct bpf_xdp_entity {
	struct bpf_prog *prog;
	struct bpf_xdp_link *link;
};

struct netdev_name_node;

struct dev_ifalias;

struct net_device_ops;

struct xdp_metadata_ops;

struct net_device_core_stats;

struct ethtool_ops;

struct l3mdev_ops;

struct ndisc_ops;

struct header_ops;

struct in_device;

struct inet6_dev;

struct vlan_info;

struct mpls_dev;

struct netdev_rx_queue;

struct bpf_mprog_entry;

struct netdev_queue;

struct cpu_rmap;

struct Qdisc;

struct xdp_dev_bulk_queue;

struct xps_dev_maps;

struct pcpu_lstats;

struct pcpu_sw_netstats;

struct pcpu_dstats;

struct rtnl_link_ops;

struct dcbnl_rtnl_ops;

struct phy_device;

struct udp_tunnel_nic_info;

struct udp_tunnel_nic;

struct rtnl_hw_stats64;

struct devlink_port;

struct net_device {
	char name[16];
	struct netdev_name_node *name_node;
	struct dev_ifalias *ifalias;
	long unsigned int mem_end;
	long unsigned int mem_start;
	long unsigned int base_addr;
	long unsigned int state;
	struct list_head dev_list;
	struct list_head napi_list;
	struct list_head unreg_list;
	struct list_head close_list;
	struct list_head ptype_all;
	struct list_head ptype_specific;
	struct {
		struct list_head upper;
		struct list_head lower;
	} adj_list;
	unsigned int flags;
	xdp_features_t xdp_features;
	long long unsigned int priv_flags;
	const struct net_device_ops *netdev_ops;
	const struct xdp_metadata_ops *xdp_metadata_ops;
	int ifindex;
	short unsigned int gflags;
	short unsigned int hard_header_len;
	unsigned int mtu;
	short unsigned int needed_headroom;
	short unsigned int needed_tailroom;
	netdev_features_t features;
	netdev_features_t hw_features;
	netdev_features_t wanted_features;
	netdev_features_t vlan_features;
	netdev_features_t hw_enc_features;
	netdev_features_t mpls_features;
	netdev_features_t gso_partial_features;
	unsigned int min_mtu;
	unsigned int max_mtu;
	short unsigned int type;
	unsigned char min_header_len;
	unsigned char name_assign_type;
	int group;
	struct net_device_stats stats;
	struct net_device_core_stats *core_stats;
	atomic_t carrier_up_count;
	atomic_t carrier_down_count;
	const struct ethtool_ops *ethtool_ops;
	const struct l3mdev_ops *l3mdev_ops;
	const struct ndisc_ops *ndisc_ops;
	const struct header_ops *header_ops;
	unsigned char operstate;
	unsigned char link_mode;
	unsigned char if_port;
	unsigned char dma;
	unsigned char perm_addr[32];
	unsigned char addr_assign_type;
	unsigned char addr_len;
	unsigned char upper_level;
	unsigned char lower_level;
	short unsigned int neigh_priv_len;
	short unsigned int dev_id;
	short unsigned int dev_port;
	short unsigned int padded;
	spinlock_t addr_list_lock;
	int irq;
	struct netdev_hw_addr_list uc;
	struct netdev_hw_addr_list mc;
	struct netdev_hw_addr_list dev_addrs;
	struct kset *queues_kset;
	struct list_head unlink_list;
	unsigned int promiscuity;
	unsigned int allmulti;
	bool uc_promisc;
	unsigned char nested_level;
	struct in_device *ip_ptr;
	struct inet6_dev *ip6_ptr;
	struct vlan_info *vlan_info;
	struct mpls_dev *mpls_ptr;
	const unsigned char *dev_addr;
	struct netdev_rx_queue *_rx;
	unsigned int num_rx_queues;
	unsigned int real_num_rx_queues;
	struct bpf_prog *xdp_prog;
	long unsigned int gro_flush_timeout;
	int napi_defer_hard_irqs;
	unsigned int gro_max_size;
	unsigned int gro_ipv4_max_size;
	unsigned int xdp_zc_max_segs;
	rx_handler_func_t *rx_handler;
	void *rx_handler_data;
	struct bpf_mprog_entry *tcx_ingress;
	struct netdev_queue *ingress_queue;
	struct nf_hook_entries *nf_hooks_ingress;
	unsigned char broadcast[32];
	struct cpu_rmap *rx_cpu_rmap;
	struct hlist_node index_hlist;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct netdev_queue *_tx;
	unsigned int num_tx_queues;
	unsigned int real_num_tx_queues;
	struct Qdisc *qdisc;
	unsigned int tx_queue_len;
	spinlock_t tx_global_lock;
	struct xdp_dev_bulk_queue *xdp_bulkq;
	struct xps_dev_maps *xps_maps[2];
	struct bpf_mprog_entry *tcx_egress;
	struct nf_hook_entries *nf_hooks_egress;
	struct hlist_head qdisc_hash[16];
	struct timer_list watchdog_timer;
	int watchdog_timeo;
	u32 proto_down_reason;
	struct list_head todo_list;
	int *pcpu_refcnt;
	struct ref_tracker_dir refcnt_tracker;
	struct list_head link_watch_list;
	enum {
		NETREG_UNINITIALIZED = 0,
		NETREG_REGISTERED = 1,
		NETREG_UNREGISTERING = 2,
		NETREG_UNREGISTERED = 3,
		NETREG_RELEASED = 4,
		NETREG_DUMMY = 5,
	} reg_state: 8;
	bool dismantle;
	enum {
		RTNL_LINK_INITIALIZED = 0,
		RTNL_LINK_INITIALIZING = 1,
	} rtnl_link_state: 16;
	bool needs_free_netdev;
	void (*priv_destructor)(struct net_device *);
	possible_net_t nd_net;
	void *ml_priv;
	enum netdev_ml_priv_type ml_priv_type;
	union {
		struct pcpu_lstats *lstats;
		struct pcpu_sw_netstats *tstats;
		struct pcpu_dstats *dstats;
	};
	struct device dev;
	const struct attribute_group *sysfs_groups[4];
	const struct attribute_group *sysfs_rx_queue_group;
	const struct rtnl_link_ops *rtnl_link_ops;
	unsigned int gso_max_size;
	unsigned int tso_max_size;
	u16 gso_max_segs;
	u16 tso_max_segs;
	unsigned int gso_ipv4_max_size;
	const struct dcbnl_rtnl_ops *dcbnl_ops;
	s16 num_tc;
	struct netdev_tc_txq tc_to_txq[16];
	u8 prio_tc_map[16];
	struct phy_device *phydev;
	struct sfp_bus *sfp_bus;
	struct lock_class_key *qdisc_tx_busylock;
	bool proto_down;
	unsigned int wol_enabled: 1;
	unsigned int threaded: 1;
	struct list_head net_notifier_list;
	const struct udp_tunnel_nic_info *udp_tunnel_nic_info;
	struct udp_tunnel_nic *udp_tunnel_nic;
	struct bpf_xdp_entity xdp_state[3];
	u8 dev_addr_shadow[32];
	netdevice_tracker linkwatch_dev_tracker;
	netdevice_tracker watchdog_dev_tracker;
	netdevice_tracker dev_registered_tracker;
	struct rtnl_hw_stats64 *offload_xstats_l3;
	struct devlink_port *devlink_port;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_CONST_SIZE = 5,
	ARG_CONST_SIZE_OR_ZERO = 6,
	ARG_PTR_TO_CTX = 7,
	ARG_ANYTHING = 8,
	ARG_PTR_TO_SPIN_LOCK = 9,
	ARG_PTR_TO_SOCK_COMMON = 10,
	ARG_PTR_TO_INT = 11,
	ARG_PTR_TO_LONG = 12,
	ARG_PTR_TO_SOCKET = 13,
	ARG_PTR_TO_BTF_ID = 14,
	ARG_PTR_TO_RINGBUF_MEM = 15,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 16,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 17,
	ARG_PTR_TO_PERCPU_BTF_ID = 18,
	ARG_PTR_TO_FUNC = 19,
	ARG_PTR_TO_STACK = 20,
	ARG_PTR_TO_CONST_STR = 21,
	ARG_PTR_TO_TIMER = 22,
	ARG_PTR_TO_KPTR = 23,
	ARG_PTR_TO_DYNPTR = 24,
	__BPF_ARG_TYPE_MAX = 25,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 263,
	ARG_PTR_TO_SOCKET_OR_NULL = 269,
	ARG_PTR_TO_STACK_OR_NULL = 276,
	ARG_PTR_TO_BTF_ID_OR_NULL = 270,
	ARG_PTR_TO_UNINIT_MEM = 32772,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 33554431,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 33554431,
};

struct bpf_func_proto {
	u64 (*func)(u64, u64, u64, u64, u64);
	bool gpl_only;
	bool pkt_access;
	bool might_sleep;
	enum bpf_return_type ret_type;
	union {
		struct {
			enum bpf_arg_type arg1_type;
			enum bpf_arg_type arg2_type;
			enum bpf_arg_type arg3_type;
			enum bpf_arg_type arg4_type;
			enum bpf_arg_type arg5_type;
		};
		enum bpf_arg_type arg_type[5];
	};
	union {
		struct {
			u32 *arg1_btf_id;
			u32 *arg2_btf_id;
			u32 *arg3_btf_id;
			u32 *arg4_btf_id;
			u32 *arg5_btf_id;
		};
		u32 *arg_btf_id[5];
		struct {
			size_t arg1_size;
			size_t arg2_size;
			size_t arg3_size;
			size_t arg4_size;
			size_t arg5_size;
		};
		size_t arg_size[5];
	};
	int *ret_btf_id;
	bool (*allowed)(const struct bpf_prog *);
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_BUF = 18,
	PTR_TO_FUNC = 19,
	CONST_PTR_TO_DYNPTR = 20,
	__BPF_REG_TYPE_MAX = 21,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 33554431,
};

struct bpf_prog_ops {
	int (*test_run)(struct bpf_prog *, const union bpf_attr *, union bpf_attr *);
};

struct bpf_offload_dev;

struct bpf_prog_offload {
	struct bpf_prog *prog;
	struct net_device *netdev;
	struct bpf_offload_dev *offdev;
	void *dev_priv;
	struct list_head offloads;
	bool dev_state;
	bool opt_failed;
	void *jited_image;
	u32 jited_len;
};

struct btf_func_model {
	u8 ret_size;
	u8 ret_flags;
	u8 nr_args;
	u8 arg_size[12];
	u8 arg_flags[12];
};

struct bpf_tramp_image {
	void *image;
	struct bpf_ksym ksym;
	struct percpu_ref pcref;
	void *ip_after_call;
	void *ip_epilogue;
	union {
		struct callback_head rcu;
		struct work_struct work;
	};
};

struct bpf_trampoline {
	struct hlist_node hlist;
	struct ftrace_ops *fops;
	struct mutex mutex;
	refcount_t refcnt;
	u32 flags;
	u64 key;
	struct {
		struct btf_func_model model;
		void *addr;
		bool ftrace_managed;
	} func;
	struct bpf_prog *extension_prog;
	struct hlist_head progs_hlist[3];
	int progs_cnt[3];
	struct bpf_tramp_image *cur_image;
	struct module *mod;
};

struct bpf_func_info_aux {
	u16 linkage;
	bool unreliable;
};

struct bpf_jit_poke_descriptor {
	void *tailcall_target;
	void *tailcall_bypass;
	void *bypass_addr;
	void *aux;
	union {
		struct {
			struct bpf_map *map;
			u32 key;
		} tail_call;
	};
	bool tailcall_target_stable;
	u8 adj_off;
	u16 reason;
	u32 insn_idx;
};

struct bpf_ctx_arg_aux {
	u32 offset;
	enum bpf_reg_type reg_type;
	u32 btf_id;
};

struct btf_mod_pair {
	struct btf *btf;
	struct module *module;
};

struct bpf_prog_stats {
	u64_stats_t cnt;
	u64_stats_t nsecs;
	u64_stats_t misses;
	struct u64_stats_sync syncp;
	long: 64;
};

struct sock_fprog_kern {
	u16 len;
	struct sock_filter *filter;
};

typedef int (*bpf_iter_attach_target_t)(struct bpf_prog *, union bpf_iter_link_info *, struct bpf_iter_aux_info *);

typedef void (*bpf_iter_detach_target_t)(struct bpf_iter_aux_info *);

typedef void (*bpf_iter_show_fdinfo_t)(const struct bpf_iter_aux_info *, struct seq_file *);

typedef int (*bpf_iter_fill_link_info_t)(const struct bpf_iter_aux_info *, struct bpf_link_info *);

typedef const struct bpf_func_proto * (*bpf_iter_get_func_proto_t)(enum bpf_func_id, const struct bpf_prog *);

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

struct bpf_iter_reg {
	const char *target;
	bpf_iter_attach_target_t attach_target;
	bpf_iter_detach_target_t detach_target;
	bpf_iter_show_fdinfo_t show_fdinfo;
	bpf_iter_fill_link_info_t fill_link_info;
	bpf_iter_get_func_proto_t get_func_proto;
	u32 ctx_arg_info_size;
	u32 feature;
	struct bpf_ctx_arg_aux ctx_arg_info[2];
	const struct bpf_iter_seq_info *seq_info;
};

struct bpf_iter_meta {
	union {
		struct seq_file *seq;
	};
	u64 session_id;
	u64 seq_num;
};

typedef short unsigned int __kernel_sa_family_t;

typedef __kernel_sa_family_t sa_family_t;

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} __empty_sa_data;
			char sa_data[0];
		};
	};
};

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct ifmap {
	long unsigned int mem_start;
	long unsigned int mem_end;
	short unsigned int base_addr;
	unsigned char irq;
	unsigned char dma;
	unsigned char port;
};

struct if_settings {
	unsigned int type;
	unsigned int size;
	union {
		raw_hdlc_proto *raw_hdlc;
		cisco_proto *cisco;
		fr_proto *fr;
		fr_proto_pvc *fr_pvc;
		fr_proto_pvc_info *fr_pvc_info;
		x25_hdlc_proto *x25;
		sync_serial_settings *sync;
		te1_settings *te1;
	} ifs_ifsu;
};

struct ifreq {
	union {
		char ifrn_name[16];
	} ifr_ifrn;
	union {
		struct sockaddr ifru_addr;
		struct sockaddr ifru_dstaddr;
		struct sockaddr ifru_broadaddr;
		struct sockaddr ifru_netmask;
		struct sockaddr ifru_hwaddr;
		short int ifru_flags;
		int ifru_ivalue;
		int ifru_mtu;
		struct ifmap ifru_map;
		char ifru_slave[16];
		char ifru_newname[16];
		void *ifru_data;
		struct if_settings ifru_settings;
	} ifr_ifru;
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_PKT_TOO_SMALL = 4,
	SKB_DROP_REASON_TCP_CSUM = 5,
	SKB_DROP_REASON_SOCKET_FILTER = 6,
	SKB_DROP_REASON_UDP_CSUM = 7,
	SKB_DROP_REASON_NETFILTER_DROP = 8,
	SKB_DROP_REASON_OTHERHOST = 9,
	SKB_DROP_REASON_IP_CSUM = 10,
	SKB_DROP_REASON_IP_INHDR = 11,
	SKB_DROP_REASON_IP_RPFILTER = 12,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 13,
	SKB_DROP_REASON_XFRM_POLICY = 14,
	SKB_DROP_REASON_IP_NOPROTO = 15,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 16,
	SKB_DROP_REASON_PROTO_MEM = 17,
	SKB_DROP_REASON_TCP_AUTH_HDR = 18,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 19,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 20,
	SKB_DROP_REASON_TCP_MD5FAILURE = 21,
	SKB_DROP_REASON_TCP_AONOTFOUND = 22,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 23,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 24,
	SKB_DROP_REASON_TCP_AOFAILURE = 25,
	SKB_DROP_REASON_SOCKET_BACKLOG = 26,
	SKB_DROP_REASON_TCP_FLAGS = 27,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 28,
	SKB_DROP_REASON_TCP_OLD_DATA = 29,
	SKB_DROP_REASON_TCP_OVERWINDOW = 30,
	SKB_DROP_REASON_TCP_OFOMERGE = 31,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 32,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 33,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 34,
	SKB_DROP_REASON_TCP_RESET = 35,
	SKB_DROP_REASON_TCP_INVALID_SYN = 36,
	SKB_DROP_REASON_TCP_CLOSE = 37,
	SKB_DROP_REASON_TCP_FASTOPEN = 38,
	SKB_DROP_REASON_TCP_OLD_ACK = 39,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 40,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 41,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 42,
	SKB_DROP_REASON_TCP_OFO_DROP = 43,
	SKB_DROP_REASON_IP_OUTNOROUTES = 44,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 45,
	SKB_DROP_REASON_IPV6DISABLED = 46,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 47,
	SKB_DROP_REASON_NEIGH_FAILED = 48,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 49,
	SKB_DROP_REASON_NEIGH_DEAD = 50,
	SKB_DROP_REASON_TC_EGRESS = 51,
	SKB_DROP_REASON_QDISC_DROP = 52,
	SKB_DROP_REASON_CPU_BACKLOG = 53,
	SKB_DROP_REASON_XDP = 54,
	SKB_DROP_REASON_TC_INGRESS = 55,
	SKB_DROP_REASON_UNHANDLED_PROTO = 56,
	SKB_DROP_REASON_SKB_CSUM = 57,
	SKB_DROP_REASON_SKB_GSO_SEG = 58,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 59,
	SKB_DROP_REASON_DEV_HDR = 60,
	SKB_DROP_REASON_DEV_READY = 61,
	SKB_DROP_REASON_FULL_RING = 62,
	SKB_DROP_REASON_NOMEM = 63,
	SKB_DROP_REASON_HDR_TRUNC = 64,
	SKB_DROP_REASON_TAP_FILTER = 65,
	SKB_DROP_REASON_TAP_TXFILTER = 66,
	SKB_DROP_REASON_ICMP_CSUM = 67,
	SKB_DROP_REASON_INVALID_PROTO = 68,
	SKB_DROP_REASON_IP_INADDRERRORS = 69,
	SKB_DROP_REASON_IP_INNOROUTES = 70,
	SKB_DROP_REASON_PKT_TOO_BIG = 71,
	SKB_DROP_REASON_DUP_FRAG = 72,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 73,
	SKB_DROP_REASON_FRAG_TOO_FAR = 74,
	SKB_DROP_REASON_TCP_MINTTL = 75,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 76,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 77,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 78,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 79,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 80,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 81,
	SKB_DROP_REASON_QUEUE_PURGE = 82,
	SKB_DROP_REASON_TC_ERROR = 83,
	SKB_DROP_REASON_MAX = 84,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct skb_shared_hwtstamps {
	union {
		ktime_t hwtstamp;
		void *netdev_data;
	};
};

struct dql {
	unsigned int num_queued;
	unsigned int adj_limit;
	unsigned int last_obj_cnt;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	unsigned int limit;
	unsigned int num_completed;
	unsigned int prev_ovlimit;
	unsigned int prev_num_queued;
	unsigned int prev_last_obj_cnt;
	unsigned int lowest_slack;
	long unsigned int slack_start_time;
	unsigned int max_limit;
	unsigned int min_limit;
	unsigned int slack_hold_time;
	long: 64;
	long: 64;
};

struct hh_cache {
	unsigned int hh_len;
	seqlock_t hh_lock;
	long unsigned int hh_data[12];
};

struct neigh_table;

struct neigh_parms;

struct neigh_ops;

struct neighbour {
	struct neighbour *next;
	struct neigh_table *tbl;
	struct neigh_parms *parms;
	long unsigned int confirmed;
	long unsigned int updated;
	rwlock_t lock;
	refcount_t refcnt;
	unsigned int arp_queue_len_bytes;
	struct sk_buff_head arp_queue;
	struct timer_list timer;
	long unsigned int used;
	atomic_t probes;
	u8 nud_state;
	u8 type;
	u8 dead;
	u8 protocol;
	u32 flags;
	seqlock_t ha_lock;
	unsigned char ha[32];
	struct hh_cache hh;
	int (*output)(struct neighbour *, struct sk_buff *);
	const struct neigh_ops *ops;
	struct list_head gc_list;
	struct list_head managed_list;
	struct callback_head rcu;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	u8 primary_key[0];
};

struct ieee_ets {
	__u8 willing;
	__u8 ets_cap;
	__u8 cbs;
	__u8 tc_tx_bw[8];
	__u8 tc_rx_bw[8];
	__u8 tc_tsa[8];
	__u8 prio_tc[8];
	__u8 tc_reco_bw[8];
	__u8 tc_reco_tsa[8];
	__u8 reco_prio_tc[8];
};

struct ieee_maxrate {
	__u64 tc_maxrate[8];
};

struct ieee_qcn {
	__u8 rpg_enable[8];
	__u32 rppp_max_rps[8];
	__u32 rpg_time_reset[8];
	__u32 rpg_byte_reset[8];
	__u32 rpg_threshold[8];
	__u32 rpg_max_rate[8];
	__u32 rpg_ai_rate[8];
	__u32 rpg_hai_rate[8];
	__u32 rpg_gd[8];
	__u32 rpg_min_dec_fac[8];
	__u32 rpg_min_rate[8];
	__u32 cndd_state_machine[8];
};

struct ieee_qcn_stats {
	__u64 rppp_rp_centiseconds[8];
	__u32 rppp_created_rps[8];
};

struct ieee_pfc {
	__u8 pfc_cap;
	__u8 pfc_en;
	__u8 mbc;
	__u16 delay;
	__u64 requests[8];
	__u64 indications[8];
};

struct dcbnl_buffer {
	__u8 prio2buffer[8];
	__u32 buffer_size[8];
	__u32 total_size;
};

struct cee_pg {
	__u8 willing;
	__u8 error;
	__u8 pg_en;
	__u8 tcs_supported;
	__u8 pg_bw[8];
	__u8 prio_pg[8];
};

struct cee_pfc {
	__u8 willing;
	__u8 error;
	__u8 pfc_en;
	__u8 tcs_supported;
};

struct dcb_app {
	__u8 selector;
	__u8 priority;
	__u16 protocol;
};

struct dcb_peer_app_info {
	__u8 willing;
	__u8 error;
};

struct dcbnl_rtnl_ops {
	int (*ieee_getets)(struct net_device *, struct ieee_ets *);
	int (*ieee_setets)(struct net_device *, struct ieee_ets *);
	int (*ieee_getmaxrate)(struct net_device *, struct ieee_maxrate *);
	int (*ieee_setmaxrate)(struct net_device *, struct ieee_maxrate *);
	int (*ieee_getqcn)(struct net_device *, struct ieee_qcn *);
	int (*ieee_setqcn)(struct net_device *, struct ieee_qcn *);
	int (*ieee_getqcnstats)(struct net_device *, struct ieee_qcn_stats *);
	int (*ieee_getpfc)(struct net_device *, struct ieee_pfc *);
	int (*ieee_setpfc)(struct net_device *, struct ieee_pfc *);
	int (*ieee_getapp)(struct net_device *, struct dcb_app *);
	int (*ieee_setapp)(struct net_device *, struct dcb_app *);
	int (*ieee_delapp)(struct net_device *, struct dcb_app *);
	int (*ieee_peer_getets)(struct net_device *, struct ieee_ets *);
	int (*ieee_peer_getpfc)(struct net_device *, struct ieee_pfc *);
	u8 (*getstate)(struct net_device *);
	u8 (*setstate)(struct net_device *, u8);
	void (*getpermhwaddr)(struct net_device *, u8 *);
	void (*setpgtccfgtx)(struct net_device *, int, u8, u8, u8, u8);
	void (*setpgbwgcfgtx)(struct net_device *, int, u8);
	void (*setpgtccfgrx)(struct net_device *, int, u8, u8, u8, u8);
	void (*setpgbwgcfgrx)(struct net_device *, int, u8);
	void (*getpgtccfgtx)(struct net_device *, int, u8 *, u8 *, u8 *, u8 *);
	void (*getpgbwgcfgtx)(struct net_device *, int, u8 *);
	void (*getpgtccfgrx)(struct net_device *, int, u8 *, u8 *, u8 *, u8 *);
	void (*getpgbwgcfgrx)(struct net_device *, int, u8 *);
	void (*setpfccfg)(struct net_device *, int, u8);
	void (*getpfccfg)(struct net_device *, int, u8 *);
	u8 (*setall)(struct net_device *);
	u8 (*getcap)(struct net_device *, int, u8 *);
	int (*getnumtcs)(struct net_device *, int, u8 *);
	int (*setnumtcs)(struct net_device *, int, u8);
	u8 (*getpfcstate)(struct net_device *);
	void (*setpfcstate)(struct net_device *, u8);
	void (*getbcncfg)(struct net_device *, int, u32 *);
	void (*setbcncfg)(struct net_device *, int, u32);
	void (*getbcnrp)(struct net_device *, int, u8 *);
	void (*setbcnrp)(struct net_device *, int, u8);
	int (*setapp)(struct net_device *, u8, u16, u8);
	int (*getapp)(struct net_device *, u8, u16);
	u8 (*getfeatcfg)(struct net_device *, int, u8 *);
	u8 (*setfeatcfg)(struct net_device *, int, u8);
	u8 (*getdcbx)(struct net_device *);
	u8 (*setdcbx)(struct net_device *, u8);
	int (*peer_getappinfo)(struct net_device *, struct dcb_peer_app_info *, u16 *);
	int (*peer_getapptable)(struct net_device *, struct dcb_app *);
	int (*cee_peer_getpg)(struct net_device *, struct cee_pg *);
	int (*cee_peer_getpfc)(struct net_device *, struct cee_pfc *);
	int (*dcbnl_getbuffer)(struct net_device *, struct dcbnl_buffer *);
	int (*dcbnl_setbuffer)(struct net_device *, struct dcbnl_buffer *);
	int (*dcbnl_setapptrust)(struct net_device *, u8 *, int);
	int (*dcbnl_getapptrust)(struct net_device *, u8 *, int *);
	int (*dcbnl_setrewr)(struct net_device *, struct dcb_app *);
	int (*dcbnl_delrewr)(struct net_device *, struct dcb_app *);
};

struct nlmsghdr {
	__u32 nlmsg_len;
	__u16 nlmsg_type;
	__u16 nlmsg_flags;
	__u32 nlmsg_seq;
	__u32 nlmsg_pid;
};

struct nlattr {
	__u16 nla_len;
	__u16 nla_type;
};

struct nla_policy;

struct netlink_ext_ack {
	const char *_msg;
	const struct nlattr *bad_attr;
	const struct nla_policy *policy;
	const struct nlattr *miss_nest;
	u16 miss_type;
	u8 cookie[20];
	u8 cookie_len;
	char _msg_buf[80];
};

struct netlink_range_validation;

struct netlink_range_validation_signed;

struct nla_policy {
	u8 type;
	u8 validation_type;
	u16 len;
	union {
		u16 strict_start_type;
		const u32 bitfield32_valid;
		const u32 mask;
		const char *reject_message;
		const struct nla_policy *nested_policy;
		const struct netlink_range_validation *range;
		const struct netlink_range_validation_signed *range_signed;
		struct {
			s16 min;
			s16 max;
		};
		int (*validate)(const struct nlattr *, struct netlink_ext_ack *);
	};
};

struct netlink_callback {
	struct sk_buff *skb;
	const struct nlmsghdr *nlh;
	int (*dump)(struct sk_buff *, struct netlink_callback *);
	int (*done)(struct netlink_callback *);
	void *data;
	struct module *module;
	struct netlink_ext_ack *extack;
	u16 family;
	u16 answer_flags;
	u32 min_dump_alloc;
	unsigned int prev_seq;
	unsigned int seq;
	bool strict_check;
	union {
		u8 ctx[48];
		long int args[6];
	};
};

struct ndmsg {
	__u8 ndm_family;
	__u8 ndm_pad1;
	__u16 ndm_pad2;
	__s32 ndm_ifindex;
	__u16 ndm_state;
	__u8 ndm_flags;
	__u8 ndm_type;
};

struct rtnl_link_stats64 {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 rx_errors;
	__u64 tx_errors;
	__u64 rx_dropped;
	__u64 tx_dropped;
	__u64 multicast;
	__u64 collisions;
	__u64 rx_length_errors;
	__u64 rx_over_errors;
	__u64 rx_crc_errors;
	__u64 rx_frame_errors;
	__u64 rx_fifo_errors;
	__u64 rx_missed_errors;
	__u64 tx_aborted_errors;
	__u64 tx_carrier_errors;
	__u64 tx_fifo_errors;
	__u64 tx_heartbeat_errors;
	__u64 tx_window_errors;
	__u64 rx_compressed;
	__u64 tx_compressed;
	__u64 rx_nohandler;
	__u64 rx_otherhost_dropped;
};

struct rtnl_hw_stats64 {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 rx_errors;
	__u64 tx_errors;
	__u64 rx_dropped;
	__u64 tx_dropped;
	__u64 multicast;
};

struct ifla_vf_guid {
	__u32 vf;
	__u64 guid;
};

struct ifla_vf_stats {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 broadcast;
	__u64 multicast;
	__u64 rx_dropped;
	__u64 tx_dropped;
};

struct ifla_vf_info {
	__u32 vf;
	__u8 mac[32];
	__u32 vlan;
	__u32 qos;
	__u32 spoofchk;
	__u32 linkstate;
	__u32 min_tx_rate;
	__u32 max_tx_rate;
	__u32 rss_query_en;
	__u32 trusted;
	__be16 vlan_proto;
};

struct tc_stats {
	__u64 bytes;
	__u32 packets;
	__u32 drops;
	__u32 overlimits;
	__u32 bps;
	__u32 pps;
	__u32 qlen;
	__u32 backlog;
};

struct tc_sizespec {
	unsigned char cell_log;
	unsigned char size_log;
	short int cell_align;
	int overhead;
	unsigned int linklayer;
	unsigned int mpu;
	unsigned int mtu;
	unsigned int tsize;
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

struct net_device_core_stats {
	long unsigned int rx_dropped;
	long unsigned int tx_dropped;
	long unsigned int rx_nohandler;
	long unsigned int rx_otherhost_dropped;
};

struct header_ops {
	int (*create)(struct sk_buff *, struct net_device *, short unsigned int, const void *, const void *, unsigned int);
	int (*parse)(const struct sk_buff *, unsigned char *);
	int (*cache)(const struct neighbour *, struct hh_cache *, __be16);
	void (*cache_update)(struct hh_cache *, const struct net_device *, const unsigned char *);
	bool (*validate)(const char *, unsigned int);
	__be16 (*parse_protocol)(const struct sk_buff *);
};

struct xsk_buff_pool;

struct netdev_queue {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct Qdisc *qdisc;
	struct Qdisc *qdisc_sleeping;
	struct kobject kobj;
	int numa_node;
	long unsigned int tx_maxrate;
	atomic_long_t trans_timeout;
	struct net_device *sb_dev;
	struct xsk_buff_pool *pool;
	spinlock_t _xmit_lock;
	int xmit_lock_owner;
	long unsigned int trans_start;
	long unsigned int state;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct dql dql;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct Qdisc_ops;

struct qdisc_size_table;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
};

struct xps_map {
	unsigned int len;
	unsigned int alloc_len;
	struct callback_head rcu;
	u16 queues[0];
};

struct xps_dev_maps {
	struct callback_head rcu;
	unsigned int nr_ids;
	s16 num_tc;
	struct xps_map *attr_map[0];
};

struct netdev_phys_item_id {
	unsigned char id[32];
	unsigned char id_len;
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

struct net_device_path {
	enum net_device_path_type type;
	const struct net_device *dev;
	union {
		struct {
			u16 id;
			__be16 proto;
			u8 h_dest[6];
		} encap;
		struct {
			enum {
				DEV_PATH_BR_VLAN_KEEP = 0,
				DEV_PATH_BR_VLAN_TAG = 1,
				DEV_PATH_BR_VLAN_UNTAG = 2,
				DEV_PATH_BR_VLAN_UNTAG_HW = 3,
			} vlan_mode;
			u16 vlan_id;
			__be16 vlan_proto;
		} bridge;
		struct {
			int port;
			u16 proto;
		} dsa;
		struct {
			u8 wdma_idx;
			u8 queue;
			u16 wcid;
			u8 bss;
			u8 amsdu;
		} mtk_wdma;
	};
};

struct net_device_path_ctx {
	const struct net_device *dev;
	u8 daddr[6];
	int num_vlans;
	struct {
		u16 id;
		__be16 proto;
	} vlan[2];
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

struct netdev_bpf {
	enum bpf_netdev_command command;
	union {
		struct {
			u32 flags;
			struct bpf_prog *prog;
			struct netlink_ext_ack *extack;
		};
		struct {
			struct bpf_offloaded_map *offmap;
		};
		struct {
			struct xsk_buff_pool *pool;
			u16 queue_id;
		} xsk;
	};
};

struct dev_ifalias {
	struct callback_head rcuhead;
	char ifalias[0];
};

struct xdp_frame;

struct xdp_buff;

struct ip_tunnel_parm;

struct kernel_hwtstamp_config;

struct net_device_ops {
	int (*ndo_init)(struct net_device *);
	void (*ndo_uninit)(struct net_device *);
	int (*ndo_open)(struct net_device *);
	int (*ndo_stop)(struct net_device *);
	netdev_tx_t (*ndo_start_xmit)(struct sk_buff *, struct net_device *);
	netdev_features_t (*ndo_features_check)(struct sk_buff *, struct net_device *, netdev_features_t);
	u16 (*ndo_select_queue)(struct net_device *, struct sk_buff *, struct net_device *);
	void (*ndo_change_rx_flags)(struct net_device *, int);
	void (*ndo_set_rx_mode)(struct net_device *);
	int (*ndo_set_mac_address)(struct net_device *, void *);
	int (*ndo_validate_addr)(struct net_device *);
	int (*ndo_do_ioctl)(struct net_device *, struct ifreq *, int);
	int (*ndo_eth_ioctl)(struct net_device *, struct ifreq *, int);
	int (*ndo_siocbond)(struct net_device *, struct ifreq *, int);
	int (*ndo_siocwandev)(struct net_device *, struct if_settings *);
	int (*ndo_siocdevprivate)(struct net_device *, struct ifreq *, void *, int);
	int (*ndo_set_config)(struct net_device *, struct ifmap *);
	int (*ndo_change_mtu)(struct net_device *, int);
	int (*ndo_neigh_setup)(struct net_device *, struct neigh_parms *);
	void (*ndo_tx_timeout)(struct net_device *, unsigned int);
	void (*ndo_get_stats64)(struct net_device *, struct rtnl_link_stats64 *);
	bool (*ndo_has_offload_stats)(const struct net_device *, int);
	int (*ndo_get_offload_stats)(int, const struct net_device *, void *);
	struct net_device_stats * (*ndo_get_stats)(struct net_device *);
	int (*ndo_vlan_rx_add_vid)(struct net_device *, __be16, u16);
	int (*ndo_vlan_rx_kill_vid)(struct net_device *, __be16, u16);
	int (*ndo_set_vf_mac)(struct net_device *, int, u8 *);
	int (*ndo_set_vf_vlan)(struct net_device *, int, u16, u8, __be16);
	int (*ndo_set_vf_rate)(struct net_device *, int, int, int);
	int (*ndo_set_vf_spoofchk)(struct net_device *, int, bool);
	int (*ndo_set_vf_trust)(struct net_device *, int, bool);
	int (*ndo_get_vf_config)(struct net_device *, int, struct ifla_vf_info *);
	int (*ndo_set_vf_link_state)(struct net_device *, int, int);
	int (*ndo_get_vf_stats)(struct net_device *, int, struct ifla_vf_stats *);
	int (*ndo_set_vf_port)(struct net_device *, int, struct nlattr **);
	int (*ndo_get_vf_port)(struct net_device *, int, struct sk_buff *);
	int (*ndo_get_vf_guid)(struct net_device *, int, struct ifla_vf_guid *, struct ifla_vf_guid *);
	int (*ndo_set_vf_guid)(struct net_device *, int, u64, int);
	int (*ndo_set_vf_rss_query_en)(struct net_device *, int, bool);
	int (*ndo_setup_tc)(struct net_device *, enum tc_setup_type, void *);
	int (*ndo_rx_flow_steer)(struct net_device *, const struct sk_buff *, u16, u32);
	int (*ndo_add_slave)(struct net_device *, struct net_device *, struct netlink_ext_ack *);
	int (*ndo_del_slave)(struct net_device *, struct net_device *);
	struct net_device * (*ndo_get_xmit_slave)(struct net_device *, struct sk_buff *, bool);
	struct net_device * (*ndo_sk_get_lower_dev)(struct net_device *, struct sock *);
	netdev_features_t (*ndo_fix_features)(struct net_device *, netdev_features_t);
	int (*ndo_set_features)(struct net_device *, netdev_features_t);
	int (*ndo_neigh_construct)(struct net_device *, struct neighbour *);
	void (*ndo_neigh_destroy)(struct net_device *, struct neighbour *);
	int (*ndo_fdb_add)(struct ndmsg *, struct nlattr **, struct net_device *, const unsigned char *, u16, u16, struct netlink_ext_ack *);
	int (*ndo_fdb_del)(struct ndmsg *, struct nlattr **, struct net_device *, const unsigned char *, u16, struct netlink_ext_ack *);
	int (*ndo_fdb_del_bulk)(struct nlmsghdr *, struct net_device *, struct netlink_ext_ack *);
	int (*ndo_fdb_dump)(struct sk_buff *, struct netlink_callback *, struct net_device *, struct net_device *, int *);
	int (*ndo_fdb_get)(struct sk_buff *, struct nlattr **, struct net_device *, const unsigned char *, u16, u32, u32, struct netlink_ext_ack *);
	int (*ndo_mdb_add)(struct net_device *, struct nlattr **, u16, struct netlink_ext_ack *);
	int (*ndo_mdb_del)(struct net_device *, struct nlattr **, struct netlink_ext_ack *);
	int (*ndo_mdb_dump)(struct net_device *, struct sk_buff *, struct netlink_callback *);
	int (*ndo_mdb_get)(struct net_device *, struct nlattr **, u32, u32, struct netlink_ext_ack *);
	int (*ndo_bridge_setlink)(struct net_device *, struct nlmsghdr *, u16, struct netlink_ext_ack *);
	int (*ndo_bridge_getlink)(struct sk_buff *, u32, u32, struct net_device *, u32, int);
	int (*ndo_bridge_dellink)(struct net_device *, struct nlmsghdr *, u16);
	int (*ndo_change_carrier)(struct net_device *, bool);
	int (*ndo_get_phys_port_id)(struct net_device *, struct netdev_phys_item_id *);
	int (*ndo_get_port_parent_id)(struct net_device *, struct netdev_phys_item_id *);
	int (*ndo_get_phys_port_name)(struct net_device *, char *, size_t);
	void * (*ndo_dfwd_add_station)(struct net_device *, struct net_device *);
	void (*ndo_dfwd_del_station)(struct net_device *, void *);
	int (*ndo_set_tx_maxrate)(struct net_device *, int, u32);
	int (*ndo_get_iflink)(const struct net_device *);
	int (*ndo_fill_metadata_dst)(struct net_device *, struct sk_buff *);
	void (*ndo_set_rx_headroom)(struct net_device *, int);
	int (*ndo_bpf)(struct net_device *, struct netdev_bpf *);
	int (*ndo_xdp_xmit)(struct net_device *, int, struct xdp_frame **, u32);
	struct net_device * (*ndo_xdp_get_xmit_slave)(struct net_device *, struct xdp_buff *);
	int (*ndo_xsk_wakeup)(struct net_device *, u32, u32);
	int (*ndo_tunnel_ctl)(struct net_device *, struct ip_tunnel_parm *, int);
	struct net_device * (*ndo_get_peer_dev)(struct net_device *);
	int (*ndo_fill_forward_path)(struct net_device_path_ctx *, struct net_device_path *);
	ktime_t (*ndo_get_tstamp)(struct net_device *, const struct skb_shared_hwtstamps *, bool);
	int (*ndo_hwtstamp_get)(struct net_device *, struct kernel_hwtstamp_config *);
	int (*ndo_hwtstamp_set)(struct net_device *, struct kernel_hwtstamp_config *, struct netlink_ext_ack *);
};

struct pcpu_lstats {
	u64_stats_t packets;
	u64_stats_t bytes;
	struct u64_stats_sync syncp;
};

struct pcpu_sw_netstats {
	u64_stats_t rx_packets;
	u64_stats_t rx_bytes;
	u64_stats_t tx_packets;
	u64_stats_t tx_bytes;
	struct u64_stats_sync syncp;
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

struct xdp_md;

struct xdp_metadata_ops {
	int (*xmo_rx_timestamp)(const struct xdp_md *, u64 *);
	int (*xmo_rx_hash)(const struct xdp_md *, u32 *, enum xdp_rss_hash_type *);
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

struct ethtool_drvinfo;

struct ethtool_regs;

struct ethtool_wolinfo;

struct ethtool_link_ext_state_info;

struct ethtool_link_ext_stats;

struct ethtool_eeprom;

struct ethtool_coalesce;

struct kernel_ethtool_coalesce;

struct ethtool_ringparam;

struct kernel_ethtool_ringparam;

struct ethtool_pause_stats;

struct ethtool_pauseparam;

struct ethtool_test;

struct ethtool_stats;

struct ethtool_rxnfc;

struct ethtool_flash;

struct ethtool_channels;

struct ethtool_dump;

struct ethtool_ts_info;

struct ethtool_modinfo;

struct ethtool_eee;

struct ethtool_tunable;

struct ethtool_link_ksettings;

struct ethtool_fec_stats;

struct ethtool_fecparam;

struct ethtool_module_eeprom;

struct ethtool_eth_phy_stats;

struct ethtool_eth_mac_stats;

struct ethtool_eth_ctrl_stats;

struct ethtool_rmon_stats;

struct ethtool_rmon_hist_range;

struct ethtool_module_power_mode_params;

struct ethtool_mm_state;

struct ethtool_mm_cfg;

struct ethtool_mm_stats;

struct ethtool_ops {
	u32 cap_link_lanes_supported: 1;
	u32 supported_coalesce_params;
	u32 supported_ring_params;
	void (*get_drvinfo)(struct net_device *, struct ethtool_drvinfo *);
	int (*get_regs_len)(struct net_device *);
	void (*get_regs)(struct net_device *, struct ethtool_regs *, void *);
	void (*get_wol)(struct net_device *, struct ethtool_wolinfo *);
	int (*set_wol)(struct net_device *, struct ethtool_wolinfo *);
	u32 (*get_msglevel)(struct net_device *);
	void (*set_msglevel)(struct net_device *, u32);
	int (*nway_reset)(struct net_device *);
	u32 (*get_link)(struct net_device *);
	int (*get_link_ext_state)(struct net_device *, struct ethtool_link_ext_state_info *);
	void (*get_link_ext_stats)(struct net_device *, struct ethtool_link_ext_stats *);
	int (*get_eeprom_len)(struct net_device *);
	int (*get_eeprom)(struct net_device *, struct ethtool_eeprom *, u8 *);
	int (*set_eeprom)(struct net_device *, struct ethtool_eeprom *, u8 *);
	int (*get_coalesce)(struct net_device *, struct ethtool_coalesce *, struct kernel_ethtool_coalesce *, struct netlink_ext_ack *);
	int (*set_coalesce)(struct net_device *, struct ethtool_coalesce *, struct kernel_ethtool_coalesce *, struct netlink_ext_ack *);
	void (*get_ringparam)(struct net_device *, struct ethtool_ringparam *, struct kernel_ethtool_ringparam *, struct netlink_ext_ack *);
	int (*set_ringparam)(struct net_device *, struct ethtool_ringparam *, struct kernel_ethtool_ringparam *, struct netlink_ext_ack *);
	void (*get_pause_stats)(struct net_device *, struct ethtool_pause_stats *);
	void (*get_pauseparam)(struct net_device *, struct ethtool_pauseparam *);
	int (*set_pauseparam)(struct net_device *, struct ethtool_pauseparam *);
	void (*self_test)(struct net_device *, struct ethtool_test *, u64 *);
	void (*get_strings)(struct net_device *, u32, u8 *);
	int (*set_phys_id)(struct net_device *, enum ethtool_phys_id_state);
	void (*get_ethtool_stats)(struct net_device *, struct ethtool_stats *, u64 *);
	int (*begin)(struct net_device *);
	void (*complete)(struct net_device *);
	u32 (*get_priv_flags)(struct net_device *);
	int (*set_priv_flags)(struct net_device *, u32);
	int (*get_sset_count)(struct net_device *, int);
	int (*get_rxnfc)(struct net_device *, struct ethtool_rxnfc *, u32 *);
	int (*set_rxnfc)(struct net_device *, struct ethtool_rxnfc *);
	int (*flash_device)(struct net_device *, struct ethtool_flash *);
	int (*reset)(struct net_device *, u32 *);
	u32 (*get_rxfh_key_size)(struct net_device *);
	u32 (*get_rxfh_indir_size)(struct net_device *);
	int (*get_rxfh)(struct net_device *, u32 *, u8 *, u8 *);
	int (*set_rxfh)(struct net_device *, const u32 *, const u8 *, const u8);
	int (*get_rxfh_context)(struct net_device *, u32 *, u8 *, u8 *, u32);
	int (*set_rxfh_context)(struct net_device *, const u32 *, const u8 *, const u8, u32 *, bool);
	void (*get_channels)(struct net_device *, struct ethtool_channels *);
	int (*set_channels)(struct net_device *, struct ethtool_channels *);
	int (*get_dump_flag)(struct net_device *, struct ethtool_dump *);
	int (*get_dump_data)(struct net_device *, struct ethtool_dump *, void *);
	int (*set_dump)(struct net_device *, struct ethtool_dump *);
	int (*get_ts_info)(struct net_device *, struct ethtool_ts_info *);
	int (*get_module_info)(struct net_device *, struct ethtool_modinfo *);
	int (*get_module_eeprom)(struct net_device *, struct ethtool_eeprom *, u8 *);
	int (*get_eee)(struct net_device *, struct ethtool_eee *);
	int (*set_eee)(struct net_device *, struct ethtool_eee *);
	int (*get_tunable)(struct net_device *, const struct ethtool_tunable *, void *);
	int (*set_tunable)(struct net_device *, const struct ethtool_tunable *, const void *);
	int (*get_per_queue_coalesce)(struct net_device *, u32, struct ethtool_coalesce *);
	int (*set_per_queue_coalesce)(struct net_device *, u32, struct ethtool_coalesce *);
	int (*get_link_ksettings)(struct net_device *, struct ethtool_link_ksettings *);
	int (*set_link_ksettings)(struct net_device *, const struct ethtool_link_ksettings *);
	void (*get_fec_stats)(struct net_device *, struct ethtool_fec_stats *);
	int (*get_fecparam)(struct net_device *, struct ethtool_fecparam *);
	int (*set_fecparam)(struct net_device *, struct ethtool_fecparam *);
	void (*get_ethtool_phy_stats)(struct net_device *, struct ethtool_stats *, u64 *);
	int (*get_phy_tunable)(struct net_device *, const struct ethtool_tunable *, void *);
	int (*set_phy_tunable)(struct net_device *, const struct ethtool_tunable *, const void *);
	int (*get_module_eeprom_by_page)(struct net_device *, const struct ethtool_module_eeprom *, struct netlink_ext_ack *);
	void (*get_eth_phy_stats)(struct net_device *, struct ethtool_eth_phy_stats *);
	void (*get_eth_mac_stats)(struct net_device *, struct ethtool_eth_mac_stats *);
	void (*get_eth_ctrl_stats)(struct net_device *, struct ethtool_eth_ctrl_stats *);
	void (*get_rmon_stats)(struct net_device *, struct ethtool_rmon_stats *, const struct ethtool_rmon_hist_range **);
	int (*get_module_power_mode)(struct net_device *, struct ethtool_module_power_mode_params *, struct netlink_ext_ack *);
	int (*set_module_power_mode)(struct net_device *, const struct ethtool_module_power_mode_params *, struct netlink_ext_ack *);
	int (*get_mm)(struct net_device *, struct ethtool_mm_state *);
	int (*set_mm)(struct net_device *, struct ethtool_mm_cfg *, struct netlink_ext_ack *);
	void (*get_mm_stats)(struct net_device *, struct ethtool_mm_stats *);
};

struct flowi6;

struct l3mdev_ops {
	u32 (*l3mdev_fib_table)(const struct net_device *);
	struct sk_buff * (*l3mdev_l3_rcv)(struct net_device *, struct sk_buff *, u16);
	struct sk_buff * (*l3mdev_l3_out)(struct net_device *, struct sock *, struct sk_buff *, u16);
	struct dst_entry * (*l3mdev_link_scope_lookup)(const struct net_device *, struct flowi6 *);
};

struct nd_opt_hdr;

struct ndisc_options;

struct prefix_info;

struct ndisc_ops {
	int (*is_useropt)(u8);
	int (*parse_options)(const struct net_device *, struct nd_opt_hdr *, struct ndisc_options *);
	void (*update)(const struct net_device *, struct neighbour *, u32, u8, const struct ndisc_options *);
	int (*opt_addr_space)(const struct net_device *, u8, struct neighbour *, u8 *, u8 **);
	void (*fill_addr_option)(const struct net_device *, struct sk_buff *, u8, const u8 *);
	void (*prefix_rcv_add_addr)(struct net *, struct net_device *, const struct prefix_info *, struct inet6_dev *, struct in6_addr *, int, u32, bool, bool, __u32, u32, bool);
};

struct rtnl_link_ops {
	struct list_head list;
	const char *kind;
	size_t priv_size;
	struct net_device * (*alloc)(struct nlattr **, const char *, unsigned char, unsigned int, unsigned int);
	void (*setup)(struct net_device *);
	bool netns_refund;
	unsigned int maxtype;
	const struct nla_policy *policy;
	int (*validate)(struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	int (*newlink)(struct net *, struct net_device *, struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	int (*changelink)(struct net_device *, struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	void (*dellink)(struct net_device *, struct list_head *);
	size_t (*get_size)(const struct net_device *);
	int (*fill_info)(struct sk_buff *, const struct net_device *);
	size_t (*get_xstats_size)(const struct net_device *);
	int (*fill_xstats)(struct sk_buff *, const struct net_device *);
	unsigned int (*get_num_tx_queues)();
	unsigned int (*get_num_rx_queues)();
	unsigned int slave_maxtype;
	const struct nla_policy *slave_policy;
	int (*slave_changelink)(struct net_device *, struct net_device *, struct nlattr **, struct nlattr **, struct netlink_ext_ack *);
	size_t (*get_slave_size)(const struct net_device *, const struct net_device *);
	int (*fill_slave_info)(struct sk_buff *, const struct net_device *, const struct net_device *);
	struct net * (*get_link_net)(const struct net_device *);
	size_t (*get_linkxstats_size)(const struct net_device *, int);
	int (*fill_linkxstats)(struct sk_buff *, const struct net_device *, int *, int);
};

struct udp_tunnel_nic_table_info {
	unsigned int n_entries;
	unsigned int tunnel_types;
};

struct udp_tunnel_info;

struct udp_tunnel_nic_shared;

struct udp_tunnel_nic_info {
	int (*set_port)(struct net_device *, unsigned int, unsigned int, struct udp_tunnel_info *);
	int (*unset_port)(struct net_device *, unsigned int, unsigned int, struct udp_tunnel_info *);
	int (*sync_table)(struct net_device *, unsigned int);
	struct udp_tunnel_nic_shared *shared;
	unsigned int flags;
	struct udp_tunnel_nic_table_info tables[4];
};

struct tcmsg {
	unsigned char tcm_family;
	unsigned char tcm__pad1;
	short unsigned int tcm__pad2;
	int tcm_ifindex;
	__u32 tcm_handle;
	__u32 tcm_parent;
	__u32 tcm_info;
};

struct gnet_dump {
	spinlock_t *lock;
	struct sk_buff *skb;
	struct nlattr *tail;
	int compat_tc_stats;
	int compat_xstats;
	int padattr;
	void *xstats;
	int xstats_len;
	struct tc_stats tc_stats;
};

struct netlink_range_validation {
	u64 min;
	u64 max;
};

struct netlink_range_validation_signed {
	s64 min;
	s64 max;
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

struct flow_block {
	struct list_head cb_list;
};

typedef int flow_setup_cb_t(enum tc_setup_type, void *, void *);

struct qdisc_size_table {
	struct callback_head rcu;
	struct list_head list;
	struct tc_sizespec szopts;
	int refcnt;
	u16 data[0];
};

struct Qdisc_class_ops;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct qdisc_walker;

struct tcf_block;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct tcf_chain;

struct tcf_block {
	struct mutex lock;
	struct list_head chain_list;
	u32 index;
	u32 classid;
	refcount_t refcnt;
	struct net *net;
	struct Qdisc *q;
	struct rw_semaphore cb_lock;
	struct flow_block flow_block;
	struct list_head owner_list;
	bool keep_dst;
	atomic_t offloadcnt;
	unsigned int nooffloaddevcnt;
	unsigned int lockeddevcnt;
	struct {
		struct tcf_chain *chain;
		struct list_head filter_chain_list;
	} chain0;
	struct callback_head rcu;
	struct hlist_head proto_destroy_ht[128];
	struct mutex proto_destroy_lock;
};

struct tcf_result;

struct tcf_proto_ops;

struct tcf_proto {
	struct tcf_proto *next;
	void *root;
	int (*classify)(struct sk_buff *, const struct tcf_proto *, struct tcf_result *);
	__be16 protocol;
	u32 prio;
	void *data;
	const struct tcf_proto_ops *ops;
	struct tcf_chain *chain;
	spinlock_t lock;
	bool deleting;
	refcount_t refcnt;
	struct callback_head rcu;
	struct hlist_node destroy_ht_node;
};

struct tcf_result {
	union {
		struct {
			long unsigned int class;
			u32 classid;
		};
		const struct tcf_proto *goto_tp;
	};
	enum skb_drop_reason drop_reason;
};

struct tcf_walker;

struct tcf_exts;

struct tcf_proto_ops {
	struct list_head head;
	char kind[16];
	int (*classify)(struct sk_buff *, const struct tcf_proto *, struct tcf_result *);
	int (*init)(struct tcf_proto *);
	void (*destroy)(struct tcf_proto *, bool, struct netlink_ext_ack *);
	void * (*get)(struct tcf_proto *, u32);
	void (*put)(struct tcf_proto *, void *);
	int (*change)(struct net *, struct sk_buff *, struct tcf_proto *, long unsigned int, u32, struct nlattr **, void **, u32, struct netlink_ext_ack *);
	int (*delete)(struct tcf_proto *, void *, bool *, bool, struct netlink_ext_ack *);
	bool (*delete_empty)(struct tcf_proto *);
	void (*walk)(struct tcf_proto *, struct tcf_walker *, bool);
	int (*reoffload)(struct tcf_proto *, bool, flow_setup_cb_t *, void *, struct netlink_ext_ack *);
	void (*hw_add)(struct tcf_proto *, void *);
	void (*hw_del)(struct tcf_proto *, void *);
	void (*bind_class)(void *, u32, long unsigned int, void *, long unsigned int);
	void * (*tmplt_create)(struct net *, struct tcf_chain *, struct nlattr **, struct netlink_ext_ack *);
	void (*tmplt_destroy)(void *);
	struct tcf_exts * (*get_exts)(const struct tcf_proto *, u32);
	int (*dump)(struct net *, struct tcf_proto *, void *, struct sk_buff *, struct tcmsg *, bool);
	int (*terse_dump)(struct net *, struct tcf_proto *, void *, struct sk_buff *, struct tcmsg *, bool);
	int (*tmplt_dump)(struct sk_buff *, struct net *, void *);
	struct module *owner;
	int flags;
};

struct tcf_chain {
	struct mutex filter_chain_lock;
	struct tcf_proto *filter_chain;
	struct list_head list;
	struct tcf_block *block;
	u32 index;
	unsigned int refcnt;
	unsigned int action_refcnt;
	bool explicitly_created;
	bool flushing;
	const struct tcf_proto_ops *tmplt_ops;
	void *tmplt_priv;
	struct callback_head rcu;
};

struct kallsym_iter {
	loff_t pos;
	loff_t pos_mod_end;
	loff_t pos_ftrace_mod_end;
	loff_t pos_bpf_end;
	long unsigned int value;
	unsigned int nameoff;
	char type;
	char name[512];
	char module_name[56];
	int exported;
	int show_value;
};

struct bpf_iter__ksym {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct kallsym_iter *ksym;
	};
};

struct __va_list_tag {
	unsigned int gp_offset;
	unsigned int fp_offset;
	void *overflow_arg_area;
	void *reg_save_area;
};

typedef __builtin_va_list va_list;

typedef unsigned int xa_mark_t;

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

struct ida {
	struct xarray xa;
};

struct ftrace_hash {
	long unsigned int size_bits;
	struct hlist_head *buckets;
	long unsigned int count;
	long unsigned int flags;
	struct callback_head rcu;
};

struct prog_entry;

struct event_filter {
	struct prog_entry *prog;
	char *filter_string;
};

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu *data;
	u64 time_start;
	int cpu;
};

struct trace_pid_list;

struct trace_options;

struct trace_func_repeats;

struct trace_array {
	struct list_head list;
	char *name;
	struct array_buffer array_buffer;
	struct trace_pid_list *filtered_pids;
	struct trace_pid_list *filtered_no_pids;
	arch_spinlock_t max_lock;
	int buffer_disabled;
	int sys_refcount_enter;
	int sys_refcount_exit;
	struct trace_event_file *enter_syscall_files[457];
	struct trace_event_file *exit_syscall_files[457];
	int stop_count;
	int clock_id;
	int nr_topts;
	bool clear_trace;
	int buffer_percent;
	unsigned int n_err_log_entries;
	struct tracer *current_trace;
	unsigned int trace_flags;
	unsigned char trace_flags_index[32];
	unsigned int flags;
	raw_spinlock_t start_lock;
	struct list_head err_log;
	struct dentry *dir;
	struct dentry *options;
	struct dentry *percpu_dir;
	struct dentry *event_dir;
	struct trace_options *topts;
	struct list_head systems;
	struct list_head events;
	struct trace_event_file *trace_marker_file;
	cpumask_var_t tracing_cpumask;
	cpumask_var_t pipe_cpumask;
	int ref;
	int trace_ref;
	struct ftrace_ops *ops;
	struct trace_pid_list *function_pids;
	struct trace_pid_list *function_no_pids;
	struct list_head func_probes;
	struct list_head mod_trace;
	struct list_head mod_notrace;
	int function_enabled;
	int no_filter_buffering_ref;
	struct list_head hist_vars;
	struct trace_func_repeats *last_func_repeats;
};

struct tracer_flags;

struct tracer {
	const char *name;
	int (*init)(struct trace_array *);
	void (*reset)(struct trace_array *);
	void (*start)(struct trace_array *);
	void (*stop)(struct trace_array *);
	int (*update_thresh)(struct trace_array *);
	void (*open)(struct trace_iterator *);
	void (*pipe_open)(struct trace_iterator *);
	void (*close)(struct trace_iterator *);
	void (*pipe_close)(struct trace_iterator *);
	ssize_t (*read)(struct trace_iterator *, struct file *, char *, size_t, loff_t *);
	ssize_t (*splice_read)(struct trace_iterator *, struct file *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
	void (*print_header)(struct seq_file *);
	enum print_line_t (*print_line)(struct trace_iterator *);
	int (*set_flag)(struct trace_array *, u32, u32, int);
	int (*flag_changed)(struct trace_array *, u32, int);
	struct tracer *next;
	struct tracer_flags *flags;
	int enabled;
	bool print_max;
	bool allow_instances;
	bool noboot;
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_IRQS_NOSUPPORT = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

struct event_subsystem;

struct trace_subsystem_dir {
	struct list_head list;
	struct event_subsystem *subsystem;
	struct trace_array *tr;
	struct eventfs_file *ef;
	int ref_count;
	int nr_events;
};

union lower_chunk {
	union lower_chunk *next;
	long unsigned int data[256];
};

union upper_chunk {
	union upper_chunk *next;
	union lower_chunk *data[256];
};

struct trace_pid_list {
	raw_spinlock_t lock;
	struct irq_work refill_irqwork;
	union upper_chunk *upper[256];
	union upper_chunk *upper_list;
	union lower_chunk *lower_list;
	int free_upper_chunks;
	int free_lower_chunks;
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_USER_STACK = 12,
	TRACE_BLK = 13,
	TRACE_BPUTS = 14,
	TRACE_HWLAT = 15,
	TRACE_OSNOISE = 16,
	TRACE_TIMERLAT = 17,
	TRACE_RAW_DATA = 18,
	TRACE_FUNC_REPEATS = 19,
	__TRACE_LAST_TYPE = 20,
};

struct ftrace_entry {
	struct trace_entry ent;
	long unsigned int ip;
	long unsigned int parent_ip;
};

struct ctx_switch_entry {
	struct trace_entry ent;
	unsigned int prev_pid;
	unsigned int next_pid;
	unsigned int next_cpu;
	unsigned char prev_prio;
	unsigned char prev_state;
	unsigned char next_prio;
	unsigned char next_state;
};

struct stack_entry {
	struct trace_entry ent;
	int size;
	long unsigned int caller[0];
};

struct userstack_entry {
	struct trace_entry ent;
	unsigned int tgid;
	long unsigned int caller[8];
};

struct bprint_entry {
	struct trace_entry ent;
	long unsigned int ip;
	const char *fmt;
	u32 buf[0];
};

struct print_entry {
	struct trace_entry ent;
	long unsigned int ip;
	char buf[0];
};

struct raw_data_entry {
	struct trace_entry ent;
	unsigned int id;
	char buf[0];
};

struct bputs_entry {
	struct trace_entry ent;
	long unsigned int ip;
	const char *str;
};

struct hwlat_entry {
	struct trace_entry ent;
	u64 duration;
	u64 outer_duration;
	u64 nmi_total_ts;
	struct timespec64 timestamp;
	unsigned int nmi_count;
	unsigned int seqnum;
	unsigned int count;
};

struct func_repeats_entry {
	struct trace_entry ent;
	long unsigned int ip;
	long unsigned int parent_ip;
	u16 count;
	u16 top_delta_ts;
	u32 bottom_delta_ts;
};

struct osnoise_entry {
	struct trace_entry ent;
	u64 noise;
	u64 runtime;
	u64 max_sample;
	unsigned int hw_count;
	unsigned int nmi_count;
	unsigned int irq_count;
	unsigned int softirq_count;
	unsigned int thread_count;
};

struct timerlat_entry {
	struct trace_entry ent;
	unsigned int seqnum;
	int context;
	u64 timer_latency;
};

struct trace_array_cpu {
	atomic_t disabled;
	void *buffer_page;
	long unsigned int entries;
	long unsigned int saved_latency;
	long unsigned int critical_start;
	long unsigned int critical_end;
	long unsigned int critical_sequence;
	long unsigned int nice;
	long unsigned int policy;
	long unsigned int rt_priority;
	long unsigned int skipped_entries;
	u64 preempt_timestamp;
	pid_t pid;
	kuid_t uid;
	char comm[16];
	int ftrace_ignore_pid;
	bool ignore_pid;
};

struct trace_option_dentry;

struct trace_options {
	struct tracer *tracer;
	struct trace_option_dentry *topts;
};

struct tracer_opt;

struct trace_option_dentry {
	struct tracer_opt *opt;
	struct tracer_flags *flags;
	struct trace_array *tr;
	struct dentry *entry;
};

struct trace_func_repeats {
	long unsigned int ip;
	long unsigned int parent_ip;
	long unsigned int count;
	u64 ts_last_call;
};

struct tracer_opt {
	const char *name;
	u32 bit;
};

struct tracer_flags {
	u32 val;
	struct tracer_opt *opts;
	struct tracer *trace;
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 23,
	TRACE_ITER_HASH_PTR_BIT = 24,
	TRACE_ITER_FUNCTION_BIT = 25,
	TRACE_ITER_FUNC_FORK_BIT = 26,
	TRACE_ITER_DISPLAY_GRAPH_BIT = 27,
	TRACE_ITER_STACKTRACE_BIT = 28,
	TRACE_ITER_LAST_BIT = 29,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_PAUSE_ON_TRACE = 8388608,
	TRACE_ITER_HASH_PTR = 16777216,
	TRACE_ITER_FUNCTION = 33554432,
	TRACE_ITER_FUNC_FORK = 67108864,
	TRACE_ITER_DISPLAY_GRAPH = 134217728,
	TRACE_ITER_STACKTRACE = 268435456,
};

struct ftrace_event_field {
	struct list_head link;
	const char *name;
	const char *type;
	int filter_type;
	int offset;
	int size;
	int is_signed;
	int len;
};

struct event_subsystem {
	struct list_head list;
	const char *name;
	struct event_filter *filter;
	int ref_count;
};

struct trace_mark {
	long long unsigned int val;
	char sym;
};

typedef long int (*sys_call_ptr_t)(const struct pt_regs *);

struct syscall_trace_enter {
	struct trace_entry ent;
	int nr;
	long unsigned int args[0];
};

struct syscall_trace_exit {
	struct trace_entry ent;
	int nr;
	long int ret;
};

struct syscall_tp_t {
	struct trace_entry ent;
	int syscall_nr;
	long unsigned int ret;
};

struct syscall_tp_t___2 {
	struct trace_entry ent;
	int syscall_nr;
	long unsigned int args[6];
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

struct btf_member {
	__u32 name_off;
	__u32 type;
	__u32 offset;
};

struct btf_param {
	__u32 name_off;
	__u32 type;
};

struct btf_anon_stack {
	u32 tid;
	u32 offset;
};

typedef __u64 __be64;

struct bpf_cgroup_storage_key {
	__u64 cgroup_inode_id;
	__u32 attach_type;
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum uprobe_filter_ctx {
	UPROBE_FILTER_REGISTER = 0,
	UPROBE_FILTER_UNREGISTER = 1,
	UPROBE_FILTER_MMAP = 2,
};

struct uprobe_consumer {
	int (*handler)(struct uprobe_consumer *, struct pt_regs *);
	int (*ret_handler)(struct uprobe_consumer *, long unsigned int, struct pt_regs *);
	bool (*filter)(struct uprobe_consumer *, enum uprobe_filter_ctx, struct mm_struct *);
	struct uprobe_consumer *next;
};

struct hlist_nulls_node {
	struct hlist_nulls_node *next;
	struct hlist_nulls_node **pprev;
};

typedef __u64 __addrpair;

typedef __u32 __portpair;

struct proto;

struct sock_common {
	union {
		__addrpair skc_addrpair;
		struct {
			__be32 skc_daddr;
			__be32 skc_rcv_saddr;
		};
	};
	union {
		unsigned int skc_hash;
		__u16 skc_u16hashes[2];
	};
	union {
		__portpair skc_portpair;
		struct {
			__be16 skc_dport;
			__u16 skc_num;
		};
	};
	short unsigned int skc_family;
	volatile unsigned char skc_state;
	unsigned char skc_reuse: 4;
	unsigned char skc_reuseport: 1;
	unsigned char skc_ipv6only: 1;
	unsigned char skc_net_refcnt: 1;
	int skc_bound_dev_if;
	union {
		struct hlist_node skc_bind_node;
		struct hlist_node skc_portaddr_node;
	};
	struct proto *skc_prot;
	possible_net_t skc_net;
	struct in6_addr skc_v6_daddr;
	struct in6_addr skc_v6_rcv_saddr;
	atomic64_t skc_cookie;
	union {
		long unsigned int skc_flags;
		struct sock *skc_listener;
		struct inet_timewait_death_row *skc_tw_dr;
	};
	int skc_dontcopy_begin[0];
	union {
		struct hlist_node skc_node;
		struct hlist_nulls_node skc_nulls_node;
	};
	short unsigned int skc_tx_queue_mapping;
	short unsigned int skc_rx_queue_mapping;
	union {
		int skc_incoming_cpu;
		u32 skc_rcv_wnd;
		u32 skc_tw_rcv_nxt;
	};
	refcount_t skc_refcnt;
	int skc_dontcopy_end[0];
	union {
		u32 skc_rxhash;
		u32 skc_window_clamp;
		u32 skc_tw_snd_nxt;
	};
};

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
	struct lockdep_map dep_map;
} socket_lock_t;

struct sock_cgroup_data {
	struct cgroup *cgroup;
	u32 classid;
};

typedef struct {} netns_tracker;

struct sk_filter;

struct socket_wq;

struct xfrm_policy;

struct sock_reuseport;

struct sock {
	struct sock_common __sk_common;
	struct dst_entry *sk_rx_dst;
	int sk_rx_dst_ifindex;
	u32 sk_rx_dst_cookie;
	socket_lock_t sk_lock;
	atomic_t sk_drops;
	int sk_rcvlowat;
	struct sk_buff_head sk_error_queue;
	struct sk_buff_head sk_receive_queue;
	struct {
		atomic_t rmem_alloc;
		int len;
		struct sk_buff *head;
		struct sk_buff *tail;
	} sk_backlog;
	int sk_forward_alloc;
	u32 sk_reserved_mem;
	unsigned int sk_ll_usec;
	unsigned int sk_napi_id;
	int sk_rcvbuf;
	int sk_disconnects;
	struct sk_filter *sk_filter;
	union {
		struct socket_wq *sk_wq;
		struct socket_wq *sk_wq_raw;
	};
	struct xfrm_policy *sk_policy[2];
	struct dst_entry *sk_dst_cache;
	atomic_t sk_omem_alloc;
	int sk_sndbuf;
	int sk_wmem_queued;
	refcount_t sk_wmem_alloc;
	long unsigned int sk_tsq_flags;
	union {
		struct sk_buff *sk_send_head;
		struct rb_root tcp_rtx_queue;
	};
	struct sk_buff_head sk_write_queue;
	__s32 sk_peek_off;
	int sk_write_pending;
	__u32 sk_dst_pending_confirm;
	u32 sk_pacing_status;
	long int sk_sndtimeo;
	struct timer_list sk_timer;
	__u32 sk_priority;
	__u32 sk_mark;
	long unsigned int sk_pacing_rate;
	long unsigned int sk_max_pacing_rate;
	struct page_frag sk_frag;
	netdev_features_t sk_route_caps;
	int sk_gso_type;
	unsigned int sk_gso_max_size;
	gfp_t sk_allocation;
	__u32 sk_txhash;
	u8 sk_gso_disabled: 1;
	u8 sk_kern_sock: 1;
	u8 sk_no_check_tx: 1;
	u8 sk_no_check_rx: 1;
	u8 sk_userlocks: 4;
	u8 sk_pacing_shift;
	u16 sk_type;
	u16 sk_protocol;
	u16 sk_gso_max_segs;
	long unsigned int sk_lingertime;
	struct proto *sk_prot_creator;
	rwlock_t sk_callback_lock;
	int sk_err;
	int sk_err_soft;
	u32 sk_ack_backlog;
	u32 sk_max_ack_backlog;
	kuid_t sk_uid;
	u8 sk_txrehash;
	u8 sk_prefer_busy_poll;
	u16 sk_busy_poll_budget;
	spinlock_t sk_peer_lock;
	int sk_bind_phc;
	struct pid *sk_peer_pid;
	const struct cred *sk_peer_cred;
	long int sk_rcvtimeo;
	ktime_t sk_stamp;
	atomic_t sk_tskey;
	atomic_t sk_zckey;
	u32 sk_tsflags;
	u8 sk_shutdown;
	u8 sk_clockid;
	u8 sk_txtime_deadline_mode: 1;
	u8 sk_txtime_report_errors: 1;
	u8 sk_txtime_unused: 6;
	bool sk_use_task_frag;
	struct socket *sk_socket;
	void *sk_user_data;
	void *sk_security;
	struct sock_cgroup_data sk_cgrp_data;
	struct mem_cgroup *sk_memcg;
	void (*sk_state_change)(struct sock *);
	void (*sk_data_ready)(struct sock *);
	void (*sk_write_space)(struct sock *);
	void (*sk_error_report)(struct sock *);
	int (*sk_backlog_rcv)(struct sock *, struct sk_buff *);
	void (*sk_destruct)(struct sock *);
	struct sock_reuseport *sk_reuseport_cb;
	struct bpf_local_storage *sk_bpf_storage;
	struct callback_head sk_rcu;
	netns_tracker ns_tracker;
	struct hlist_node sk_bind2_node;
};

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef unsigned int (*bpf_func_t)(const void *, const struct bpf_insn *);

struct bpf_storage_buffer;

struct bpf_cgroup_storage_map;

struct bpf_cgroup_storage {
	union {
		struct bpf_storage_buffer *buf;
		void *percpu_buf;
	};
	struct bpf_cgroup_storage_map *map;
	struct bpf_cgroup_storage_key key;
	struct list_head list_map;
	struct list_head list_cg;
	struct rb_node node;
	struct callback_head rcu;
};

struct bpf_trace_run_ctx {
	struct bpf_run_ctx run_ctx;
	u64 bpf_cookie;
	bool is_uprobe;
};

typedef u32 (*bpf_prog_run_fn)(const struct bpf_prog *, const void *);

struct flowi_tunnel {
	__be64 tun_id;
};

struct flowi_common {
	int flowic_oif;
	int flowic_iif;
	int flowic_l3mdev;
	__u32 flowic_mark;
	__u8 flowic_tos;
	__u8 flowic_scope;
	__u8 flowic_proto;
	__u8 flowic_flags;
	__u32 flowic_secid;
	kuid_t flowic_uid;
	struct flowi_tunnel flowic_tun_key;
	__u32 flowic_multipath_hash;
};

union flowi_uli {
	struct {
		__be16 dport;
		__be16 sport;
	} ports;
	struct {
		__u8 type;
		__u8 code;
	} icmpt;
	__be32 gre_key;
	struct {
		__u8 type;
	} mht;
};

struct flowi4 {
	struct flowi_common __fl_common;
	__be32 saddr;
	__be32 daddr;
	union flowi_uli uli;
};

struct flowi6 {
	struct flowi_common __fl_common;
	struct in6_addr daddr;
	struct in6_addr saddr;
	__be32 flowlabel;
	union flowi_uli uli;
	__u32 mp_hash;
};

struct flowi {
	union {
		struct flowi_common __fl_common;
		struct flowi4 ip4;
		struct flowi6 ip6;
	} u;
};

struct prot_inuse {
	int all;
	int val[64];
};

struct fib_rule;

struct fib_lookup_arg;

struct fib_rule_hdr;

struct fib_rules_ops {
	int family;
	struct list_head list;
	int rule_size;
	int addr_size;
	int unresolved_rules;
	int nr_goto_rules;
	unsigned int fib_rules_seq;
	int (*action)(struct fib_rule *, struct flowi *, int, struct fib_lookup_arg *);
	bool (*suppress)(struct fib_rule *, int, struct fib_lookup_arg *);
	int (*match)(struct fib_rule *, struct flowi *, int);
	int (*configure)(struct fib_rule *, struct sk_buff *, struct fib_rule_hdr *, struct nlattr **, struct netlink_ext_ack *);
	int (*delete)(struct fib_rule *);
	int (*compare)(struct fib_rule *, struct fib_rule_hdr *, struct nlattr **);
	int (*fill)(struct fib_rule *, struct sk_buff *, struct fib_rule_hdr *);
	size_t (*nlmsg_payload)(struct fib_rule *);
	void (*flush_cache)(struct fib_rules_ops *);
	int nlgroup;
	struct list_head rules_list;
	struct module *owner;
	struct net *fro_net;
	struct callback_head rcu;
};

struct fib_notifier_ops {
	int family;
	struct list_head list;
	unsigned int (*fib_seq_read)(struct net *);
	int (*fib_dump)(struct net *, struct notifier_block *, struct netlink_ext_ack *);
	struct module *owner;
	struct callback_head rcu;
};

struct ubuf_info;

struct msghdr {
	void *msg_name;
	int msg_namelen;
	int msg_inq;
	struct iov_iter msg_iter;
	union {
		void *msg_control;
		void *msg_control_user;
	};
	bool msg_control_is_user: 1;
	bool msg_get_inq: 1;
	unsigned int msg_flags;
	__kernel_size_t msg_controllen;
	struct kiocb *msg_iocb;
	struct ubuf_info *msg_ubuf;
	int (*sg_from_iter)(struct sock *, struct sk_buff *, struct iov_iter *, size_t);
};

struct ubuf_info {
	void (*callback)(struct sk_buff *, struct ubuf_info *, bool);
	refcount_t refcnt;
	u8 flags;
};

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

struct socket_wq {
	wait_queue_head_t wait;
	struct fasync_struct *fasync_list;
	long unsigned int flags;
	struct callback_head rcu;
	long: 64;
	long: 64;
};

struct proto_ops;

struct socket {
	socket_state state;
	short int type;
	long unsigned int flags;
	struct file *file;
	struct sock *sk;
	const struct proto_ops *ops;
	long: 64;
	long: 64;
	long: 64;
	struct socket_wq wq;
};

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef int (*sk_read_actor_t)(read_descriptor_t *, struct sk_buff *, unsigned int, size_t);

typedef int (*skb_read_actor_t)(struct sock *, struct sk_buff *);

struct proto_ops {
	int family;
	struct module *owner;
	int (*release)(struct socket *);
	int (*bind)(struct socket *, struct sockaddr *, int);
	int (*connect)(struct socket *, struct sockaddr *, int, int);
	int (*socketpair)(struct socket *, struct socket *);
	int (*accept)(struct socket *, struct socket *, int, bool);
	int (*getname)(struct socket *, struct sockaddr *, int);
	__poll_t (*poll)(struct file *, struct socket *, struct poll_table_struct *);
	int (*ioctl)(struct socket *, unsigned int, long unsigned int);
	int (*gettstamp)(struct socket *, void *, bool, bool);
	int (*listen)(struct socket *, int);
	int (*shutdown)(struct socket *, int);
	int (*setsockopt)(struct socket *, int, int, sockptr_t, unsigned int);
	int (*getsockopt)(struct socket *, int, int, char *, int *);
	void (*show_fdinfo)(struct seq_file *, struct socket *);
	int (*sendmsg)(struct socket *, struct msghdr *, size_t);
	int (*recvmsg)(struct socket *, struct msghdr *, size_t, int);
	int (*mmap)(struct file *, struct socket *, struct vm_area_struct *);
	ssize_t (*splice_read)(struct socket *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
	void (*splice_eof)(struct socket *);
	int (*set_peek_off)(struct sock *, int);
	int (*peek_len)(struct socket *);
	int (*read_sock)(struct sock *, read_descriptor_t *, sk_read_actor_t);
	int (*read_skb)(struct sock *, skb_read_actor_t);
	int (*sendmsg_locked)(struct sock *, struct msghdr *, size_t);
	int (*set_rcvlowat)(struct sock *, int);
};

struct neigh_parms {
	possible_net_t net;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct list_head list;
	int (*neigh_setup)(struct neighbour *);
	struct neigh_table *tbl;
	void *sysctl_table;
	int dead;
	refcount_t refcnt;
	struct callback_head callback_head;
	int reachable_time;
	u32 qlen;
	int data[14];
	long unsigned int data_state[1];
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 0,
	HWTSTAMP_SOURCE_PHYLIB = 1,
};

struct kernel_hwtstamp_config {
	int flags;
	int tx_type;
	int rx_filter;
	struct ifreq *ifr;
	bool copied_to_user;
	enum hwtstamp_source source;
};

struct pneigh_entry;

struct neigh_statistics;

struct neigh_hash_table;

struct neigh_table {
	int family;
	unsigned int entry_size;
	unsigned int key_len;
	__be16 protocol;
	__u32 (*hash)(const void *, const struct net_device *, __u32 *);
	bool (*key_eq)(const struct neighbour *, const void *);
	int (*constructor)(struct neighbour *);
	int (*pconstructor)(struct pneigh_entry *);
	void (*pdestructor)(struct pneigh_entry *);
	void (*proxy_redo)(struct sk_buff *);
	int (*is_multicast)(const void *);
	bool (*allow_add)(const struct net_device *, struct netlink_ext_ack *);
	char *id;
	struct neigh_parms parms;
	struct list_head parms_list;
	int gc_interval;
	int gc_thresh1;
	int gc_thresh2;
	int gc_thresh3;
	long unsigned int last_flush;
	struct delayed_work gc_work;
	struct delayed_work managed_work;
	struct timer_list proxy_timer;
	struct sk_buff_head proxy_queue;
	atomic_t entries;
	atomic_t gc_entries;
	struct list_head gc_list;
	struct list_head managed_list;
	rwlock_t lock;
	long unsigned int last_rand;
	struct neigh_statistics *stats;
	struct neigh_hash_table *nht;
	struct pneigh_entry **phash_buckets;
};

struct neigh_statistics {
	long unsigned int allocs;
	long unsigned int destroys;
	long unsigned int hash_grows;
	long unsigned int res_failed;
	long unsigned int lookups;
	long unsigned int hits;
	long unsigned int rcv_probes_mcast;
	long unsigned int rcv_probes_ucast;
	long unsigned int periodic_gc_runs;
	long unsigned int forced_gc_runs;
	long unsigned int unres_discards;
	long unsigned int table_fulls;
};

struct neigh_ops {
	int family;
	void (*solicit)(struct neighbour *, struct sk_buff *);
	void (*error_report)(struct neighbour *, struct sk_buff *);
	int (*output)(struct neighbour *, struct sk_buff *);
	int (*connected_output)(struct neighbour *, struct sk_buff *);
};

struct pneigh_entry {
	struct pneigh_entry *next;
	possible_net_t net;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	u32 flags;
	u8 protocol;
	u32 key[0];
};

struct neigh_hash_table {
	struct neighbour **hash_buckets;
	unsigned int hash_shift;
	__u32 hash_rnd[4];
	struct callback_head rcu;
};

struct fib_rule_hdr {
	__u8 family;
	__u8 dst_len;
	__u8 src_len;
	__u8 tos;
	__u8 table;
	__u8 res1;
	__u8 res2;
	__u8 action;
	__u32 flags;
};

struct fib_rule_port_range {
	__u16 start;
	__u16 end;
};

struct fib_kuid_range {
	kuid_t start;
	kuid_t end;
};

struct fib_rule {
	struct list_head list;
	int iifindex;
	int oifindex;
	u32 mark;
	u32 mark_mask;
	u32 flags;
	u32 table;
	u8 action;
	u8 l3mdev;
	u8 proto;
	u8 ip_proto;
	u32 target;
	__be64 tun_id;
	struct fib_rule *ctarget;
	struct net *fr_net;
	refcount_t refcnt;
	u32 pref;
	int suppress_ifgroup;
	int suppress_prefixlen;
	char iifname[16];
	char oifname[16];
	struct fib_kuid_range uid_range;
	struct fib_rule_port_range sport_range;
	struct fib_rule_port_range dport_range;
	struct callback_head rcu;
};

struct fib_lookup_arg {
	void *lookup_ptr;
	const void *lookup_data;
	void *result;
	struct fib_rule *rule;
	u32 table;
	int flags;
};

struct smc_hashinfo;

struct sk_psock;

struct request_sock_ops;

struct timewait_sock_ops;

struct raw_hashinfo;

struct proto {
	void (*close)(struct sock *, long int);
	int (*pre_connect)(struct sock *, struct sockaddr *, int);
	int (*connect)(struct sock *, struct sockaddr *, int);
	int (*disconnect)(struct sock *, int);
	struct sock * (*accept)(struct sock *, int, int *, bool);
	int (*ioctl)(struct sock *, int, int *);
	int (*init)(struct sock *);
	void (*destroy)(struct sock *);
	void (*shutdown)(struct sock *, int);
	int (*setsockopt)(struct sock *, int, int, sockptr_t, unsigned int);
	int (*getsockopt)(struct sock *, int, int, char *, int *);
	void (*keepalive)(struct sock *, int);
	int (*sendmsg)(struct sock *, struct msghdr *, size_t);
	int (*recvmsg)(struct sock *, struct msghdr *, size_t, int, int *);
	void (*splice_eof)(struct socket *);
	int (*bind)(struct sock *, struct sockaddr *, int);
	int (*bind_add)(struct sock *, struct sockaddr *, int);
	int (*backlog_rcv)(struct sock *, struct sk_buff *);
	bool (*bpf_bypass_getsockopt)(int, int);
	void (*release_cb)(struct sock *);
	int (*hash)(struct sock *);
	void (*unhash)(struct sock *);
	void (*rehash)(struct sock *);
	int (*get_port)(struct sock *, short unsigned int);
	void (*put_port)(struct sock *);
	int (*psock_update_sk_prot)(struct sock *, struct sk_psock *, bool);
	unsigned int inuse_idx;
	int (*forward_alloc_get)(const struct sock *);
	bool (*stream_memory_free)(const struct sock *, int);
	bool (*sock_is_readable)(struct sock *);
	void (*enter_memory_pressure)(struct sock *);
	void (*leave_memory_pressure)(struct sock *);
	atomic_long_t *memory_allocated;
	int *per_cpu_fw_alloc;
	struct percpu_counter *sockets_allocated;
	long unsigned int *memory_pressure;
	long int *sysctl_mem;
	int *sysctl_wmem;
	int *sysctl_rmem;
	u32 sysctl_wmem_offset;
	u32 sysctl_rmem_offset;
	int max_header;
	bool no_autobind;
	struct kmem_cache *slab;
	unsigned int obj_size;
	unsigned int ipv6_pinfo_offset;
	slab_flags_t slab_flags;
	unsigned int useroffset;
	unsigned int usersize;
	unsigned int *orphan_count;
	struct request_sock_ops *rsk_prot;
	struct timewait_sock_ops *twsk_prot;
	union {
		struct inet_hashinfo *hashinfo;
		struct udp_table *udp_table;
		struct raw_hashinfo *raw_hash;
		struct smc_hashinfo *smc_hash;
	} h;
	struct module *owner;
	char name[32];
	struct list_head node;
	int (*diag_destroy)(struct sock *, int);
};

struct sk_filter {
	refcount_t refcnt;
	struct callback_head rcu;
	struct bpf_prog *prog;
};

struct bpf_storage_buffer {
	struct callback_head rcu;
	char data[0];
};

typedef unsigned int (*bpf_dispatcher_fn)(const void *, const struct bpf_insn *, unsigned int (*)(const void *, const struct bpf_insn *));

struct dyn_event;

struct dyn_event_operations {
	struct list_head list;
	int (*create)(const char *);
	int (*show)(struct seq_file *, struct dyn_event *);
	bool (*is_busy)(struct dyn_event *);
	int (*free)(struct dyn_event *);
	bool (*match)(const char *, const char *, int, const char **, struct dyn_event *);
};

struct dyn_event {
	struct list_head list;
	struct dyn_event_operations *ops;
};

typedef int (*print_type_func_t)(struct trace_seq *, void *, void *);

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_DEREF = 10,
	FETCH_OP_UDEREF = 11,
	FETCH_OP_ST_RAW = 12,
	FETCH_OP_ST_MEM = 13,
	FETCH_OP_ST_UMEM = 14,
	FETCH_OP_ST_STRING = 15,
	FETCH_OP_ST_USTRING = 16,
	FETCH_OP_ST_SYMSTR = 17,
	FETCH_OP_MOD_BF = 18,
	FETCH_OP_LP_ARRAY = 19,
	FETCH_OP_TP_ARG = 20,
	FETCH_OP_END = 21,
	FETCH_NOP_SYMBOL = 22,
};

struct fetch_insn {
	enum fetch_op op;
	union {
		unsigned int param;
		struct {
			unsigned int size;
			int offset;
		};
		struct {
			unsigned char basesize;
			unsigned char lshift;
			unsigned char rshift;
		};
		long unsigned int immediate;
		void *data;
	};
};

struct fetch_type {
	const char *name;
	size_t size;
	bool is_signed;
	bool is_string;
	print_type_func_t print;
	const char *fmt;
	const char *fmttype;
};

struct probe_arg {
	struct fetch_insn *code;
	bool dynamic;
	unsigned int offset;
	unsigned int count;
	const char *name;
	const char *comm;
	char *fmt;
	const struct fetch_type *type;
};

struct trace_uprobe_filter {
	rwlock_t rwlock;
	int nr_systemwide;
	struct list_head perf_events;
};

struct trace_probe_event {
	unsigned int flags;
	struct trace_event_class class;
	struct trace_event_call call;
	struct list_head files;
	struct list_head probes;
	struct trace_uprobe_filter filter[0];
};

struct trace_probe {
	struct list_head list;
	struct trace_probe_event *event;
	ssize_t size;
	unsigned int nr_args;
	struct probe_arg args[0];
};

struct event_file_link {
	struct trace_event_file *file;
	struct list_head list;
};

struct traceprobe_parse_context {
	struct trace_event_call *event;
	const char *funcname;
	const struct btf_type *proto;
	const struct btf_param *params;
	s32 nr_params;
	struct btf *btf;
	const struct btf_type *last_type;
	u32 last_bitoffs;
	u32 last_bitsize;
	unsigned int flags;
	int offset;
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_ADDR_SUFFIX = 13,
	TP_ERR_NO_GROUP_NAME = 14,
	TP_ERR_GROUP_TOO_LONG = 15,
	TP_ERR_BAD_GROUP_NAME = 16,
	TP_ERR_NO_EVENT_NAME = 17,
	TP_ERR_EVENT_TOO_LONG = 18,
	TP_ERR_BAD_EVENT_NAME = 19,
	TP_ERR_EVENT_EXIST = 20,
	TP_ERR_RETVAL_ON_PROBE = 21,
	TP_ERR_NO_RETVAL = 22,
	TP_ERR_BAD_STACK_NUM = 23,
	TP_ERR_BAD_ARG_NUM = 24,
	TP_ERR_BAD_VAR = 25,
	TP_ERR_BAD_REG_NAME = 26,
	TP_ERR_BAD_MEM_ADDR = 27,
	TP_ERR_BAD_IMM = 28,
	TP_ERR_IMMSTR_NO_CLOSE = 29,
	TP_ERR_FILE_ON_KPROBE = 30,
	TP_ERR_BAD_FILE_OFFS = 31,
	TP_ERR_SYM_ON_UPROBE = 32,
	TP_ERR_TOO_MANY_OPS = 33,
	TP_ERR_DEREF_NEED_BRACE = 34,
	TP_ERR_BAD_DEREF_OFFS = 35,
	TP_ERR_DEREF_OPEN_BRACE = 36,
	TP_ERR_COMM_CANT_DEREF = 37,
	TP_ERR_BAD_FETCH_ARG = 38,
	TP_ERR_ARRAY_NO_CLOSE = 39,
	TP_ERR_BAD_ARRAY_SUFFIX = 40,
	TP_ERR_BAD_ARRAY_NUM = 41,
	TP_ERR_ARRAY_TOO_BIG = 42,
	TP_ERR_BAD_TYPE = 43,
	TP_ERR_BAD_STRING = 44,
	TP_ERR_BAD_SYMSTRING = 45,
	TP_ERR_BAD_BITFIELD = 46,
	TP_ERR_ARG_NAME_TOO_LONG = 47,
	TP_ERR_NO_ARG_NAME = 48,
	TP_ERR_BAD_ARG_NAME = 49,
	TP_ERR_USED_ARG_NAME = 50,
	TP_ERR_ARG_TOO_LONG = 51,
	TP_ERR_NO_ARG_BODY = 52,
	TP_ERR_BAD_INSN_BNDRY = 53,
	TP_ERR_FAIL_REG_PROBE = 54,
	TP_ERR_DIFF_PROBE_TYPE = 55,
	TP_ERR_DIFF_ARG_TYPE = 56,
	TP_ERR_SAME_PROBE = 57,
	TP_ERR_NO_EVENT_INFO = 58,
	TP_ERR_BAD_ATTACH_EVENT = 59,
	TP_ERR_BAD_ATTACH_ARG = 60,
	TP_ERR_NO_EP_FILTER = 61,
	TP_ERR_NOSUP_BTFARG = 62,
	TP_ERR_NO_BTFARG = 63,
	TP_ERR_NO_BTF_ENTRY = 64,
	TP_ERR_BAD_VAR_ARGS = 65,
	TP_ERR_NOFENTRY_ARGS = 66,
	TP_ERR_DOUBLE_ARGS = 67,
	TP_ERR_ARGS_2LONG = 68,
	TP_ERR_ARGIDX_2BIG = 69,
	TP_ERR_NO_PTR_STRCT = 70,
	TP_ERR_NOSUP_DAT_ARG = 71,
	TP_ERR_BAD_HYPHEN = 72,
	TP_ERR_NO_BTF_FIELD = 73,
	TP_ERR_BAD_BTF_TID = 74,
	TP_ERR_BAD_TYPE4STR = 75,
};

struct trace_uprobe;

struct uprobe_dispatch_data {
	struct trace_uprobe *tu;
	long unsigned int bp_addr;
};

struct trace_uprobe {
	struct dyn_event devent;
	struct uprobe_consumer consumer;
	struct path path;
	struct inode *inode;
	char *filename;
	long unsigned int offset;
	long unsigned int ref_ctr_offset;
	long unsigned int nhit;
	struct trace_probe tp;
};

struct uprobe_trace_entry_head {
	struct trace_entry ent;
	long unsigned int vaddr[0];
};

struct uprobe_cpu_buffer {
	struct mutex mutex;
	void *buf;
};

typedef bool (*filter_func_t)(struct uprobe_consumer *, enum uprobe_filter_ctx, struct mm_struct *);

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	__BPF_TYPE_FLAG_MAX = 16777217,
	__BPF_TYPE_LAST_FLAG = 16777216,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

struct bpf_queue_stack {
	struct bpf_map map;
	raw_spinlock_t lock;
	u32 head;
	u32 tail;
	u32 size;
	long: 0;
	char elements[0];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum {
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

struct xdp_md {
	__u32 data;
	__u32 data_end;
	__u32 data_meta;
	__u32 ingress_ifindex;
	__u32 rx_queue_index;
	__u32 egress_ifindex;
};

struct bpf_cpumap_val {
	__u32 qsize;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

enum {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 128,
	WORK_STRUCT_FLAG_BITS = 8,
	WORK_OFFQ_FLAG_BASE = 4,
	__WORK_OFFQ_CANCELING = 4,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_POOL_SHIFT = 5,
	WORK_OFFQ_LEFT = 59,
	WORK_OFFQ_POOL_BITS = 31,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 24,
};

struct rhash_lock_head;

struct bucket_table {
	unsigned int size;
	unsigned int nest;
	u32 hash_rnd;
	struct list_head walkers;
	struct callback_head rcu;
	struct bucket_table *future_tbl;
	struct lockdep_map dep_map;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct rhash_lock_head *buckets[0];
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

struct xdp_mem_info {
	u32 type;
	u32 id;
};

struct xdp_frame {
	void *data;
	u16 len;
	u16 headroom;
	u32 metasize;
	struct xdp_mem_info mem;
	struct net_device *dev_rx;
	u32 frame_sz;
	u32 flags;
};

struct xdp_rxq_info;

struct xdp_txq_info;

struct xdp_buff {
	void *data;
	void *data_end;
	void *data_meta;
	void *data_hard_start;
	struct xdp_rxq_info *rxq;
	struct xdp_txq_info *txq;
	u32 frame_sz;
	u32 flags;
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1ULL,
	IFF_EBRIDGE = 2ULL,
	IFF_BONDING = 4ULL,
	IFF_ISATAP = 8ULL,
	IFF_WAN_HDLC = 16ULL,
	IFF_XMIT_DST_RELEASE = 32ULL,
	IFF_DONT_BRIDGE = 64ULL,
	IFF_DISABLE_NETPOLL = 128ULL,
	IFF_MACVLAN_PORT = 256ULL,
	IFF_BRIDGE_PORT = 512ULL,
	IFF_OVS_DATAPATH = 1024ULL,
	IFF_TX_SKB_SHARING = 2048ULL,
	IFF_UNICAST_FLT = 4096ULL,
	IFF_TEAM_PORT = 8192ULL,
	IFF_SUPP_NOFCS = 16384ULL,
	IFF_LIVE_ADDR_CHANGE = 32768ULL,
	IFF_MACVLAN = 65536ULL,
	IFF_XMIT_DST_RELEASE_PERM = 131072ULL,
	IFF_L3MDEV_MASTER = 262144ULL,
	IFF_NO_QUEUE = 524288ULL,
	IFF_OPENVSWITCH = 1048576ULL,
	IFF_L3MDEV_SLAVE = 2097152ULL,
	IFF_TEAM = 4194304ULL,
	IFF_RXFH_CONFIGURED = 8388608ULL,
	IFF_PHONY_HEADROOM = 16777216ULL,
	IFF_MACSEC = 33554432ULL,
	IFF_NO_RX_HANDLER = 67108864ULL,
	IFF_FAILOVER = 134217728ULL,
	IFF_FAILOVER_SLAVE = 268435456ULL,
	IFF_L3MDEV_RX_HANDLER = 536870912ULL,
	IFF_NO_ADDRCONF = 1073741824ULL,
	IFF_TX_SKB_NO_LINEAR = 2147483648ULL,
	IFF_CHANGE_PROTO_DOWN = 4294967296ULL,
	IFF_SEE_ALL_HWTSTAMP_REQUESTS = 8589934592ULL,
};

struct bpf_nh_params {
	u32 nh_family;
	union {
		u32 ipv4_nh;
		struct in6_addr ipv6_nh;
	};
};

struct bpf_redirect_info {
	u64 tgt_index;
	void *tgt_value;
	struct bpf_map *map;
	u32 flags;
	u32 kern_flags;
	u32 map_id;
	enum bpf_map_type map_type;
	struct bpf_nh_params nh;
};

struct ptr_ring {
	int producer;
	spinlock_t producer_lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	int consumer_head;
	int consumer_tail;
	spinlock_t consumer_lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	int size;
	int batch;
	void **queue;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xdp_rxq_info {
	struct net_device *dev;
	u32 queue_index;
	u32 reg_state;
	struct xdp_mem_info mem;
	unsigned int napi_id;
	u32 frag_size;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct xdp_txq_info {
	struct net_device *dev;
};

struct xdp_cpumap_stats {
	unsigned int redirect;
	unsigned int pass;
	unsigned int drop;
};

struct rhash_lock_head {};

struct bpf_cpu_map_entry;

struct xdp_bulk_queue {
	void *q[8];
	struct list_head flush_node;
	struct bpf_cpu_map_entry *obj;
	unsigned int count;
};

struct bpf_cpu_map_entry {
	u32 cpu;
	int map_id;
	struct xdp_bulk_queue *bulkq;
	struct ptr_ring *queue;
	struct task_struct *kthread;
	struct bpf_cpumap_val value;
	struct bpf_prog *prog;
	struct completion kthread_running;
	struct rcu_work free_work;
};

struct bpf_cpu_map {
	struct bpf_map map;
	struct bpf_cpu_map_entry **cpu_map;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct maple_alloc {
	long unsigned int total;
	unsigned char node_count;
	unsigned int request_count;
	struct maple_alloc *slot[30];
};

struct maple_enode;

struct ma_state {
	struct maple_tree *tree;
	long unsigned int index;
	long unsigned int last;
	struct maple_enode *node;
	long unsigned int min;
	long unsigned int max;
	struct maple_alloc *alloc;
	unsigned char depth;
	unsigned char offset;
	unsigned char mas_flags;
};

typedef u8 uprobe_opcode_t;

struct uprobe_xol_ops;

struct arch_uprobe {
	union {
		u8 insn[16];
		u8 ixol[16];
	};
	const struct uprobe_xol_ops *ops;
	union {
		struct {
			s32 offs;
			u8 ilen;
			u8 opc1;
		} branch;
		struct {
			u8 fixups;
			u8 ilen;
		} defparam;
		struct {
			u8 reg_offset;
			u8 ilen;
		} push;
	};
};

struct uprobe_xol_ops {
	bool (*emulate)(struct arch_uprobe *, struct pt_regs *);
	int (*pre_xol)(struct arch_uprobe *, struct pt_regs *);
	int (*post_xol)(struct arch_uprobe *, struct pt_regs *);
	void (*abort)(struct arch_uprobe *, struct pt_regs *);
};

struct uprobe {
	struct rb_node rb_node;
	refcount_t ref;
	struct rw_semaphore register_rwsem;
	struct rw_semaphore consumer_rwsem;
	struct list_head pending_list;
	struct uprobe_consumer *consumers;
	struct inode *inode;
	loff_t offset;
	loff_t ref_ctr_offset;
	long unsigned int flags;
	struct arch_uprobe arch;
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

struct vm_special_mapping {
	const char *name;
	struct page **pages;
	vm_fault_t (*fault)(const struct vm_special_mapping *, struct vm_area_struct *, struct vm_fault *);
	int (*mremap)(const struct vm_special_mapping *, struct vm_area_struct *);
};

struct xol_area {
	wait_queue_head_t wq;
	atomic_t slot_count;
	long unsigned int *bitmap;
	struct vm_special_mapping xol_mapping;
	struct page *pages[2];
	long unsigned int vaddr;
};

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	long unsigned int num_children;
	long unsigned int num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
};

struct vma_iterator {
	struct ma_state mas;
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

struct mmu_notifier_range {
	long unsigned int start;
	long unsigned int end;
};

struct fc_log;

struct p_log {
	const char *prefix;
	struct fc_log *log;
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

struct fs_context_operations;

struct fs_context {
	const struct fs_context_operations *ops;
	struct mutex uapi_mutex;
	struct file_system_type *fs_type;
	void *fs_private;
	void *sget_key;
	struct dentry *root;
	struct user_namespace *user_ns;
	struct net *net_ns;
	const struct cred *cred;
	struct p_log log;
	const char *source;
	void *security;
	void *s_fs_info;
	unsigned int sb_flags;
	unsigned int sb_flags_mask;
	unsigned int s_iflags;
	enum fs_context_purpose purpose: 8;
	enum fs_context_phase phase: 8;
	bool need_free: 1;
	bool global: 1;
	bool oldapi: 1;
	bool exclusive: 1;
};

struct audit_names;

struct filename {
	const char *name;
	const char *uptr;
	atomic_t refcnt;
	struct audit_names *aname;
	const char iname[0];
};

typedef int filler_t(struct file *, struct folio *);

typedef unsigned int fgf_t;

struct page_vma_mapped_walk {
	long unsigned int pfn;
	long unsigned int nr_pages;
	long unsigned int pgoff;
	struct vm_area_struct *vma;
	long unsigned int address;
	pmd_t *pmd;
	pte_t *pte;
	spinlock_t *ptl;
	unsigned int flags;
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

struct fs_parameter {
	const char *key;
	enum fs_value_type type: 8;
	union {
		char *string;
		void *blob;
		struct filename *name;
		struct file *file;
	};
	size_t size;
	int dirfd;
};

struct fc_log {
	refcount_t usage;
	u8 head;
	u8 tail;
	u8 need_free;
	struct module *owner;
	char *buffer[8];
};

struct fs_context_operations {
	void (*free)(struct fs_context *);
	int (*dup)(struct fs_context *, struct fs_context *);
	int (*parse_param)(struct fs_context *, struct fs_parameter *);
	int (*parse_monolithic)(struct fs_context *, void *);
	int (*get_tree)(struct fs_context *);
	int (*reconfigure)(struct fs_context *);
};

struct fs_parse_result {
	bool negated;
	union {
		bool boolean;
		int int_32;
		unsigned int uint_32;
		u64 uint_64;
	};
};

struct delayed_uprobe {
	struct list_head list;
	struct uprobe *uprobe;
	struct mm_struct *mm;
};

struct __uprobe_key {
	struct inode *inode;
	loff_t offset;
};

struct map_info {
	struct map_info *next;
	struct mm_struct *mm;
	long unsigned int vaddr;
};

enum {
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_ORDERED_EXPLICIT = 524288,
	WQ_MAX_ACTIVE = 512,
	WQ_UNBOUND_MAX_ACTIVE = 512,
	WQ_DFL_ACTIVE = 256,
};

struct compact_control;

struct capture_control {
	struct compact_control *cc;
	struct page *page;
};

struct xa_node {
	unsigned char shift;
	unsigned char offset;
	unsigned char count;
	unsigned char nr_values;
	struct xa_node *parent;
	struct xarray *array;
	union {
		struct list_head private_list;
		struct callback_head callback_head;
	};
	void *slots[64];
	union {
		long unsigned int tags[3];
		long unsigned int marks[3];
	};
};

struct radix_tree_iter {
	long unsigned int index;
	long unsigned int next_index;
	long unsigned int tags;
	struct xa_node *node;
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

struct compact_control {
	struct list_head freepages;
	struct list_head migratepages;
	unsigned int nr_freepages;
	unsigned int nr_migratepages;
	long unsigned int free_pfn;
	long unsigned int migrate_pfn;
	long unsigned int fast_start_pfn;
	struct zone *zone;
	long unsigned int total_migrate_scanned;
	long unsigned int total_free_scanned;
	short unsigned int fast_search_fail;
	short int search_order;
	const gfp_t gfp_mask;
	int order;
	int migratetype;
	const unsigned int alloc_flags;
	const int highest_zoneidx;
	enum migrate_mode mode;
	bool ignore_skip_hint;
	bool no_set_skip_hint;
	bool ignore_block_suitable;
	bool direct_compaction;
	bool proactive_compaction;
	bool whole_zone;
	bool contended;
	bool finish_pageblock;
	bool alloc_contig;
};

typedef long unsigned int p4dval_t;

typedef struct {
	p4dval_t p4d;
} p4d_t;

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

struct mm_walk;

struct mm_walk_ops {
	int (*pgd_entry)(pgd_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*p4d_entry)(p4d_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pud_entry)(pud_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pmd_entry)(pmd_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pte_entry)(pte_t *, long unsigned int, long unsigned int, struct mm_walk *);
	int (*pte_hole)(long unsigned int, long unsigned int, int, struct mm_walk *);
	int (*hugetlb_entry)(pte_t *, long unsigned int, long unsigned int, long unsigned int, struct mm_walk *);
	int (*test_walk)(long unsigned int, long unsigned int, struct mm_walk *);
	int (*pre_vma)(long unsigned int, long unsigned int, struct mm_walk *);
	void (*post_vma)(struct mm_walk *);
	enum page_walk_lock walk_lock;
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

struct mm_walk {
	const struct mm_walk_ops *ops;
	struct mm_struct *mm;
	pgd_t *pgd;
	struct vm_area_struct *vma;
	enum page_walk_action action;
	bool no_vma;
	void *private;
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_SECONDARY_DOMAIN = 1,
	MSI_MAX_DEVICE_IRQDOMAINS = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

typedef struct pglist_data pg_data_t;

struct mem_section_usage {
	long unsigned int subsection_map[1];
	long unsigned int pageblock_flags[0];
};

struct mem_section {
	long unsigned int section_mem_map;
	struct mem_section_usage *usage;
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_MAP_LAST_BIT = 4,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

typedef __kernel_ulong_t ino_t;

typedef unsigned int isolate_mode_t;

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_TYPES = 9,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
};

enum mf_result {
	MF_IGNORED = 0,
	MF_FAILED = 1,
	MF_DELAYED = 2,
	MF_RECOVERED = 3,
};

enum mf_action_page_type {
	MF_MSG_KERNEL = 0,
	MF_MSG_KERNEL_HIGH_ORDER = 1,
	MF_MSG_SLAB = 2,
	MF_MSG_DIFFERENT_COMPOUND = 3,
	MF_MSG_HUGE = 4,
	MF_MSG_FREE_HUGE = 5,
	MF_MSG_UNMAP_FAILED = 6,
	MF_MSG_DIRTY_SWAPCACHE = 7,
	MF_MSG_CLEAN_SWAPCACHE = 8,
	MF_MSG_DIRTY_MLOCKED_LRU = 9,
	MF_MSG_CLEAN_MLOCKED_LRU = 10,
	MF_MSG_DIRTY_UNEVICTABLE_LRU = 11,
	MF_MSG_CLEAN_UNEVICTABLE_LRU = 12,
	MF_MSG_DIRTY_LRU = 13,
	MF_MSG_CLEAN_LRU = 14,
	MF_MSG_TRUNCATED_LRU = 15,
	MF_MSG_BUDDY = 16,
	MF_MSG_DAX = 17,
	MF_MSG_UNSPLIT_THP = 18,
	MF_MSG_UNKNOWN = 19,
};

typedef long unsigned int dax_entry_t;

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_LARGE_FOLIO_SUPPORT = 6,
	AS_RELEASE_ALWAYS = 7,
};

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	long unsigned int rb_subtree_last;
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

struct rmap_walk_control {
	void *arg;
	bool try_lock;
	bool contended;
	bool (*rmap_one)(struct folio *, struct vm_area_struct *, long unsigned int, void *);
	int (*done)(struct folio *);
	struct anon_vma * (*anon_lock)(struct folio *, struct rmap_walk_control *);
	bool (*invalid_vma)(struct vm_area_struct *, void *);
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	__NR_HPAGEFLAGS = 6,
};

typedef struct folio *new_folio_t(struct folio *, long unsigned int);

typedef void free_folio_t(struct folio *, long unsigned int);

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct migration_target_control {
	int nid;
	nodemask_t *nmask;
	gfp_t gfp_mask;
};

struct to_kill {
	struct list_head nd;
	struct task_struct *tsk;
	long unsigned int addr;
	short int size_shift;
};

struct hwpoison_walk {
	struct to_kill tk;
	long unsigned int pfn;
	int flags;
};

struct page_state {
	long unsigned int mask;
	long unsigned int res;
	enum mf_action_page_type type;
	int (*action)(struct page_state *, struct page *);
};

struct raw_hwp_page {
	struct llist_node node;
	struct page *page;
};

struct memory_failure_entry {
	long unsigned int pfn;
	int flags;
};

struct memory_failure_cpu {
	struct {
		union {
			struct __kfifo kfifo;
			struct memory_failure_entry *type;
			const struct memory_failure_entry *const_type;
			char (*rectype)[0];
			struct memory_failure_entry *ptr;
			const struct memory_failure_entry *ptr_const;
		};
		struct memory_failure_entry buf[16];
	} fifo;
	spinlock_t lock;
	struct work_struct work;
};

typedef struct {
	int val[2];
} __kernel_fsid_t;

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

struct name_snapshot {
	struct qstr name;
	unsigned char inline_name[32];
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
};

typedef enum lru_status (*list_lru_walk_cb)(struct list_head *, struct list_lru_one *, spinlock_t *, void *);

typedef struct fsnotify_mark_connector *fsnotify_connp_t;

struct fsnotify_mark_connector {
	spinlock_t lock;
	short unsigned int type;
	short unsigned int flags;
	__kernel_fsid_t fsid;
	union {
		fsnotify_connp_t *obj;
		struct fsnotify_mark_connector *destroy_next;
	};
	struct hlist_head list;
};

struct mount;

struct mnt_namespace {
	struct ns_common ns;
	struct mount *root;
	struct list_head list;
	spinlock_t ns_lock;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	u64 seq;
	wait_queue_head_t poll;
	u64 event;
	unsigned int mounts;
	unsigned int pending_mounts;
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_PATH = 1,
	FSNOTIFY_EVENT_INODE = 2,
	FSNOTIFY_EVENT_DENTRY = 3,
	FSNOTIFY_EVENT_ERROR = 4,
};

struct fs_pin {
	wait_queue_head_t wait;
	int done;
	struct hlist_node s_list;
	struct hlist_node m_list;
	void (*kill)(struct fs_pin *);
};

struct mnt_pcp;

struct mountpoint;

struct mount {
	struct hlist_node mnt_hash;
	struct mount *mnt_parent;
	struct dentry *mnt_mountpoint;
	struct vfsmount mnt;
	union {
		struct callback_head mnt_rcu;
		struct llist_node mnt_llist;
	};
	struct mnt_pcp *mnt_pcp;
	struct list_head mnt_mounts;
	struct list_head mnt_child;
	struct list_head mnt_instance;
	const char *mnt_devname;
	struct list_head mnt_list;
	struct list_head mnt_expire;
	struct list_head mnt_share;
	struct list_head mnt_slave_list;
	struct list_head mnt_slave;
	struct mount *mnt_master;
	struct mnt_namespace *mnt_ns;
	struct mountpoint *mnt_mp;
	union {
		struct hlist_node mnt_mp_list;
		struct hlist_node mnt_umount;
	};
	struct list_head mnt_umounting;
	struct fsnotify_mark_connector *mnt_fsnotify_marks;
	__u32 mnt_fsnotify_mask;
	int mnt_id;
	int mnt_group_id;
	int mnt_expiry_mark;
	struct hlist_head mnt_pins;
	struct hlist_head mnt_stuck_children;
};

struct mnt_pcp {
	int mnt_count;
	int mnt_writers;
};

struct mountpoint {
	struct hlist_node m_hash;
	struct dentry *m_dentry;
	struct hlist_head m_list;
	int m_count;
};

struct dentry_stat_t {
	long int nr_dentry;
	long int nr_unused;
	long int age_limit;
	long int want_pages;
	long int nr_negative;
	long int dummy;
};

struct external_name {
	union {
		atomic_t count;
		struct callback_head head;
	} u;
	unsigned char name[0];
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

struct check_mount {
	struct vfsmount *mnt;
	unsigned int mounted;
};

struct select_data {
	struct dentry *start;
	union {
		long int found;
		struct dentry *victim;
	};
	struct list_head dispose;
};

typedef int __kernel_daddr_t;

struct ustat {
	__kernel_daddr_t f_tfree;
	long unsigned int f_tinode;
	char f_fname[6];
	char f_fpack[6];
};

struct kstatfs {
	long int f_type;
	long int f_bsize;
	u64 f_blocks;
	u64 f_bfree;
	u64 f_bavail;
	u64 f_files;
	u64 f_ffree;
	__kernel_fsid_t f_fsid;
	long int f_namelen;
	long int f_frsize;
	long int f_flags;
	long int f_spare[4];
};

struct fd {
	struct file *file;
	unsigned int flags;
};

struct statfs {
	__kernel_long_t f_type;
	__kernel_long_t f_bsize;
	__kernel_long_t f_blocks;
	__kernel_long_t f_bfree;
	__kernel_long_t f_bavail;
	__kernel_long_t f_files;
	__kernel_long_t f_ffree;
	__kernel_fsid_t f_fsid;
	__kernel_long_t f_namelen;
	__kernel_long_t f_frsize;
	__kernel_long_t f_flags;
	__kernel_long_t f_spare[4];
};

struct statfs64 {
	__kernel_long_t f_type;
	__kernel_long_t f_bsize;
	__u64 f_blocks;
	__u64 f_bfree;
	__u64 f_bavail;
	__u64 f_files;
	__u64 f_ffree;
	__kernel_fsid_t f_fsid;
	__kernel_long_t f_namelen;
	__kernel_long_t f_frsize;
	__kernel_long_t f_flags;
	__kernel_long_t f_spare[4];
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct itimerspec64 {
	struct timespec64 it_interval;
	struct timespec64 it_value;
};

struct old_itimerspec32 {
	struct old_timespec32 it_interval;
	struct old_timespec32 it_value;
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum alarmtimer_restart {
	ALARMTIMER_NORESTART = 0,
	ALARMTIMER_RESTART = 1,
};

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	enum alarmtimer_restart (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
};

typedef struct poll_table_struct poll_table;

struct timens_offsets {
	struct timespec64 monotonic;
	struct timespec64 boottime;
};

struct time_namespace {
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct ns_common ns;
	struct timens_offsets offsets;
	struct page *vvar_page;
	bool frozen_offsets;
};

struct timerfd_ctx {
	union {
		struct hrtimer tmr;
		struct alarm alarm;
	} t;
	ktime_t tintv;
	ktime_t moffs;
	wait_queue_head_t wqh;
	u64 ticks;
	int clockid;
	short unsigned int expired;
	short unsigned int settime_flags;
	struct callback_head rcu;
	struct list_head clist;
	spinlock_t cancel_lock;
	bool might_cancel;
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_BOUNCED = 2,
	BIO_QUIET = 3,
	BIO_CHAIN = 4,
	BIO_REFFED = 5,
	BIO_BPS_THROTTLED = 6,
	BIO_TRACE_COMPLETION = 7,
	BIO_CGROUP_ACCT = 8,
	BIO_QOS_THROTTLED = 9,
	BIO_QOS_MERGED = 10,
	BIO_REMAPPED = 11,
	BIO_ZONE_WRITE_LOCKED = 12,
	BIO_FLAG_LAST = 13,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_APPEND = 13,
	REQ_OP_ZONE_RESET = 15,
	REQ_OP_ZONE_RESET_ALL = 17,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_NOUNMAP = 27,
	__REQ_NR_BITS = 28,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_XARRAY = 4,
	ITER_DISCARD = 5,
};

struct dax_device;

struct iomap_folio_ops;

struct iomap {
	u64 addr;
	loff_t offset;
	u64 length;
	u16 type;
	u16 flags;
	struct block_device *bdev;
	struct dax_device *dax_dev;
	void *inline_data;
	void *private;
	const struct iomap_folio_ops *folio_ops;
	u64 validity_cookie;
};

struct iomap_iter;

struct iomap_folio_ops {
	struct folio * (*get_folio)(struct iomap_iter *, loff_t, unsigned int);
	void (*put_folio)(struct inode *, loff_t, unsigned int, struct folio *);
	bool (*iomap_valid)(struct inode *, const struct iomap *);
};

struct iomap_iter {
	struct inode *inode;
	loff_t pos;
	u64 len;
	s64 processed;
	unsigned int flags;
	struct iomap iomap;
	struct iomap srcmap;
	void *private;
};

struct iomap_ops {
	int (*iomap_begin)(struct inode *, loff_t, loff_t, unsigned int, struct iomap *, struct iomap *);
	int (*iomap_end)(struct inode *, loff_t, loff_t, ssize_t, unsigned int, struct iomap *);
};

struct iomap_dio_ops {
	int (*end_io)(struct kiocb *, ssize_t, int, unsigned int);
	void (*submit_io)(const struct iomap_iter *, struct bio *, loff_t);
	struct bio_set *bio_set;
};

struct iomap_dio {
	struct kiocb *iocb;
	const struct iomap_dio_ops *dops;
	loff_t i_size;
	loff_t size;
	atomic_t ref;
	unsigned int flags;
	int error;
	size_t done_before;
	bool wait_for_completion;
	union {
		struct {
			struct iov_iter *iter;
			struct task_struct *waiter;
		} submit;
		struct {
			struct work_struct work;
		} aio;
	};
};

typedef unsigned int __kernel_uid_t;

typedef unsigned int __kernel_gid_t;

typedef u32 nlink_t;

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct nsset {
	unsigned int flags;
	struct nsproxy *nsproxy;
	struct fs_struct *fs;
	const struct cred *cred;
};

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[27];

typedef __u64 Elf64_Off;

struct elf64_hdr {
	unsigned char e_ident[16];
	Elf64_Half e_type;
	Elf64_Half e_machine;
	Elf64_Word e_version;
	Elf64_Addr e_entry;
	Elf64_Off e_phoff;
	Elf64_Off e_shoff;
	Elf64_Word e_flags;
	Elf64_Half e_ehsize;
	Elf64_Half e_phentsize;
	Elf64_Half e_phnum;
	Elf64_Half e_shentsize;
	Elf64_Half e_shnum;
	Elf64_Half e_shstrndx;
};

struct elf64_phdr {
	Elf64_Word p_type;
	Elf64_Word p_flags;
	Elf64_Off p_offset;
	Elf64_Addr p_vaddr;
	Elf64_Addr p_paddr;
	Elf64_Xword p_filesz;
	Elf64_Xword p_memsz;
	Elf64_Xword p_align;
};

struct elf64_note {
	Elf64_Word n_namesz;
	Elf64_Word n_descsz;
	Elf64_Word n_type;
};

struct elf_siginfo {
	int si_signo;
	int si_code;
	int si_errno;
};

struct elf_prstatus_common {
	struct elf_siginfo pr_info;
	short int pr_cursig;
	long unsigned int pr_sigpend;
	long unsigned int pr_sighold;
	pid_t pr_pid;
	pid_t pr_ppid;
	pid_t pr_pgrp;
	pid_t pr_sid;
	struct __kernel_old_timeval pr_utime;
	struct __kernel_old_timeval pr_stime;
	struct __kernel_old_timeval pr_cutime;
	struct __kernel_old_timeval pr_cstime;
};

struct elf_prstatus {
	struct elf_prstatus_common common;
	elf_gregset_t pr_reg;
	int pr_fpvalid;
};

struct elf_prpsinfo {
	char pr_state;
	char pr_sname;
	char pr_zomb;
	char pr_nice;
	long unsigned int pr_flag;
	__kernel_uid_t pr_uid;
	__kernel_gid_t pr_gid;
	pid_t pr_pid;
	pid_t pr_ppid;
	pid_t pr_pgrp;
	pid_t pr_sid;
	char pr_fname[16];
	char pr_psargs[80];
};

typedef int (*proc_write_t)(struct file *, char *, size_t);

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

struct kcore_list {
	struct list_head list;
	long unsigned int addr;
	size_t size;
	int type;
};

struct proc_dir_entry {
	atomic_t in_use;
	refcount_t refcnt;
	struct list_head pde_openers;
	spinlock_t pde_unload_lock;
	struct completion *pde_unload_completion;
	const struct inode_operations *proc_iops;
	union {
		const struct proc_ops *proc_ops;
		const struct file_operations *proc_dir_ops;
	};
	const struct dentry_operations *proc_dops;
	union {
		const struct seq_operations *seq_ops;
		int (*single_show)(struct seq_file *, void *);
	};
	proc_write_t write;
	void *data;
	unsigned int state_size;
	unsigned int low_ino;
	nlink_t nlink;
	kuid_t uid;
	kgid_t gid;
	loff_t size;
	struct proc_dir_entry *parent;
	struct rb_root subdir;
	struct rb_node subdir_node;
	char *name;
	umode_t mode;
	u8 flags;
	u8 namelen;
	char inline_name[0];
};

typedef __u16 __le16;

typedef __u32 __le32;

typedef __u64 __le64;

struct buffer_head;

typedef void bh_end_io_t(struct buffer_head *, int);

struct buffer_head {
	long unsigned int b_state;
	struct buffer_head *b_this_page;
	union {
		struct page *b_page;
		struct folio *b_folio;
	};
	sector_t b_blocknr;
	size_t b_size;
	char *b_data;
	struct block_device *b_bdev;
	bh_end_io_t *b_end_io;
	void *b_private;
	struct list_head b_assoc_buffers;
	struct address_space *b_assoc_map;
	atomic_t b_count;
	spinlock_t b_uptodate_lock;
};

struct fiemap_extent;

struct fiemap_extent_info {
	unsigned int fi_flags;
	unsigned int fi_extents_mapped;
	unsigned int fi_extents_max;
	struct fiemap_extent *fi_extents_start;
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

typedef unsigned int tid_t;

struct transaction_chp_stats_s {
	long unsigned int cs_chp_time;
	__u32 cs_forced_to_close;
	__u32 cs_written;
	__u32 cs_dropped;
};

struct journal_s;

typedef struct journal_s journal_t;

struct journal_head;

struct transaction_s;

typedef struct transaction_s transaction_t;

struct transaction_s {
	journal_t *t_journal;
	tid_t t_tid;
	enum {
		T_RUNNING = 0,
		T_LOCKED = 1,
		T_SWITCH = 2,
		T_FLUSH = 3,
		T_COMMIT = 4,
		T_COMMIT_DFLUSH = 5,
		T_COMMIT_JFLUSH = 6,
		T_COMMIT_CALLBACK = 7,
		T_FINISHED = 8,
	} t_state;
	long unsigned int t_log_start;
	int t_nr_buffers;
	struct journal_head *t_reserved_list;
	struct journal_head *t_buffers;
	struct journal_head *t_forget;
	struct journal_head *t_checkpoint_list;
	struct journal_head *t_shadow_list;
	struct list_head t_inode_list;
	long unsigned int t_max_wait;
	long unsigned int t_start;
	long unsigned int t_requested;
	struct transaction_chp_stats_s t_chp_stats;
	atomic_t t_updates;
	atomic_t t_outstanding_credits;
	atomic_t t_outstanding_revokes;
	atomic_t t_handle_count;
	transaction_t *t_cpnext;
	transaction_t *t_cpprev;
	long unsigned int t_expires;
	ktime_t t_start_time;
	unsigned int t_synchronous_commit: 1;
	int t_need_data_flush;
	struct list_head t_private_list;
};

struct jbd2_buffer_trigger_type;

struct journal_head {
	struct buffer_head *b_bh;
	spinlock_t b_state_lock;
	int b_jcount;
	unsigned int b_jlist;
	unsigned int b_modified;
	char *b_frozen_data;
	char *b_committed_data;
	transaction_t *b_transaction;
	transaction_t *b_next_transaction;
	struct journal_head *b_tnext;
	struct journal_head *b_tprev;
	transaction_t *b_cp_transaction;
	struct journal_head *b_cpnext;
	struct journal_head *b_cpprev;
	struct jbd2_buffer_trigger_type *b_triggers;
	struct jbd2_buffer_trigger_type *b_frozen_triggers;
};

struct jbd2_buffer_trigger_type {
	void (*t_frozen)(struct jbd2_buffer_trigger_type *, struct buffer_head *, void *, size_t);
	void (*t_abort)(struct jbd2_buffer_trigger_type *, struct buffer_head *);
};

struct crypto_alg;

struct crypto_tfm {
	refcount_t refcnt;
	u32 crt_flags;
	int node;
	void (*exit)(struct crypto_tfm *);
	struct crypto_alg *__crt_alg;
	void *__crt_ctx[0];
};

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct compress_alg {
	int (*coa_compress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
	int (*coa_decompress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
		struct compress_alg compress;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct crypto_instance;

struct crypto_type {
	unsigned int (*ctxsize)(struct crypto_alg *, u32, u32);
	unsigned int (*extsize)(struct crypto_alg *);
	int (*init_tfm)(struct crypto_tfm *);
	void (*show)(struct seq_file *, struct crypto_alg *);
	int (*report)(struct sk_buff *, struct crypto_alg *);
	void (*free)(struct crypto_instance *);
	unsigned int type;
	unsigned int maskclear;
	unsigned int maskset;
	unsigned int tfmsize;
};

struct crypto_shash;

struct shash_desc {
	struct crypto_shash *tfm;
	void *__ctx[0];
};

struct crypto_shash {
	unsigned int descsize;
	struct crypto_tfm base;
};

struct jbd2_journal_handle;

typedef struct jbd2_journal_handle handle_t;

struct jbd2_journal_handle {
	union {
		transaction_t *h_transaction;
		journal_t *h_journal;
	};
	handle_t *h_rsv_handle;
	int h_total_credits;
	int h_revoke_credits;
	int h_revoke_credits_requested;
	int h_ref;
	int h_err;
	unsigned int h_sync: 1;
	unsigned int h_jdata: 1;
	unsigned int h_reserved: 1;
	unsigned int h_aborted: 1;
	unsigned int h_type: 8;
	unsigned int h_line_no: 16;
	long unsigned int h_start_jiffies;
	unsigned int h_requested_credits;
	unsigned int saved_alloc_context;
};

struct transaction_run_stats_s {
	long unsigned int rs_wait;
	long unsigned int rs_request_delay;
	long unsigned int rs_running;
	long unsigned int rs_locked;
	long unsigned int rs_flushing;
	long unsigned int rs_logging;
	__u32 rs_handle_count;
	__u32 rs_blocks;
	__u32 rs_blocks_logged;
};

struct transaction_stats_s {
	long unsigned int ts_tid;
	long unsigned int ts_requested;
	struct transaction_run_stats_s run;
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

struct journal_superblock_s;

typedef struct journal_superblock_s journal_superblock_t;

struct jbd2_revoke_table_s;

struct jbd2_inode;

struct journal_s {
	long unsigned int j_flags;
	long unsigned int j_atomic_flags;
	int j_errno;
	struct mutex j_abort_mutex;
	struct buffer_head *j_sb_buffer;
	journal_superblock_t *j_superblock;
	rwlock_t j_state_lock;
	int j_barrier_count;
	struct mutex j_barrier;
	transaction_t *j_running_transaction;
	transaction_t *j_committing_transaction;
	transaction_t *j_checkpoint_transactions;
	wait_queue_head_t j_wait_transaction_locked;
	wait_queue_head_t j_wait_done_commit;
	wait_queue_head_t j_wait_commit;
	wait_queue_head_t j_wait_updates;
	wait_queue_head_t j_wait_reserved;
	wait_queue_head_t j_fc_wait;
	struct mutex j_checkpoint_mutex;
	struct buffer_head *j_chkpt_bhs[64];
	struct shrinker j_shrinker;
	struct percpu_counter j_checkpoint_jh_count;
	transaction_t *j_shrink_transaction;
	long unsigned int j_head;
	long unsigned int j_tail;
	long unsigned int j_free;
	long unsigned int j_first;
	long unsigned int j_last;
	long unsigned int j_fc_first;
	long unsigned int j_fc_off;
	long unsigned int j_fc_last;
	struct block_device *j_dev;
	int j_blocksize;
	long long unsigned int j_blk_offset;
	char j_devname[56];
	struct block_device *j_fs_dev;
	unsigned int j_total_len;
	atomic_t j_reserved_credits;
	spinlock_t j_list_lock;
	struct inode *j_inode;
	tid_t j_tail_sequence;
	tid_t j_transaction_sequence;
	tid_t j_commit_sequence;
	tid_t j_commit_request;
	__u8 j_uuid[16];
	struct task_struct *j_task;
	int j_max_transaction_buffers;
	int j_revoke_records_per_block;
	long unsigned int j_commit_interval;
	struct timer_list j_commit_timer;
	spinlock_t j_revoke_lock;
	struct jbd2_revoke_table_s *j_revoke;
	struct jbd2_revoke_table_s *j_revoke_table[2];
	struct buffer_head **j_wbuf;
	struct buffer_head **j_fc_wbuf;
	int j_wbufsize;
	int j_fc_wbufsize;
	pid_t j_last_sync_writer;
	u64 j_average_commit_time;
	u32 j_min_batch_time;
	u32 j_max_batch_time;
	void (*j_commit_callback)(journal_t *, transaction_t *);
	int (*j_submit_inode_data_buffers)(struct jbd2_inode *);
	int (*j_finish_inode_data_buffers)(struct jbd2_inode *);
	spinlock_t j_history_lock;
	struct proc_dir_entry *j_proc_entry;
	struct transaction_stats_s j_stats;
	unsigned int j_failed_commit;
	void *j_private;
	struct crypto_shash *j_chksum_driver;
	__u32 j_csum_seed;
	struct lockdep_map j_trans_commit_map;
	void (*j_fc_cleanup_callback)(struct journal_s *, int, tid_t);
	int (*j_fc_replay_callback)(struct journal_s *, struct buffer_head *, enum passtype, int, tid_t);
	int (*j_bmap)(struct journal_s *, sector_t *);
};

struct journal_header_s {
	__be32 h_magic;
	__be32 h_blocktype;
	__be32 h_sequence;
};

typedef struct journal_header_s journal_header_t;

struct journal_superblock_s {
	journal_header_t s_header;
	__be32 s_blocksize;
	__be32 s_maxlen;
	__be32 s_first;
	__be32 s_sequence;
	__be32 s_start;
	__be32 s_errno;
	__be32 s_feature_compat;
	__be32 s_feature_incompat;
	__be32 s_feature_ro_compat;
	__u8 s_uuid[16];
	__be32 s_nr_users;
	__be32 s_dynsuper;
	__be32 s_max_transaction;
	__be32 s_max_trans_data;
	__u8 s_checksum_type;
	__u8 s_padding2[3];
	__be32 s_num_fc_blks;
	__be32 s_head;
	__u32 s_padding[40];
	__be32 s_checksum;
	__u8 s_users[768];
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

struct jbd2_inode {
	transaction_t *i_transaction;
	transaction_t *i_next_transaction;
	struct list_head i_list;
	struct inode *i_vfs_inode;
	long unsigned int i_flags;
	loff_t i_dirty_start;
	loff_t i_dirty_end;
};

struct fiemap_extent {
	__u64 fe_logical;
	__u64 fe_physical;
	__u64 fe_length;
	__u64 fe_reserved64[2];
	__u32 fe_flags;
	__u32 fe_reserved[3];
};

struct bgl_lock {
	spinlock_t lock;
};

struct blockgroup_lock {
	struct bgl_lock locks[128];
};

struct fscrypt_dummy_policy {};

typedef int ext4_grpblk_t;

typedef long long unsigned int ext4_fsblk_t;

typedef __u32 ext4_lblk_t;

typedef unsigned int ext4_group_t;

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

struct ext4_allocation_request {
	struct inode *inode;
	unsigned int len;
	ext4_lblk_t logical;
	ext4_lblk_t lleft;
	ext4_lblk_t lright;
	ext4_fsblk_t goal;
	ext4_fsblk_t pleft;
	ext4_fsblk_t pright;
	unsigned int flags;
};

struct ext4_map_blocks {
	ext4_fsblk_t m_pblk;
	ext4_lblk_t m_lblk;
	unsigned int m_len;
	unsigned int m_flags;
};

struct ext4_system_blocks {
	struct rb_root root;
	struct callback_head rcu;
};

struct ext4_io_end_vec {
	struct list_head list;
	loff_t offset;
	ssize_t size;
};

struct ext4_io_end {
	struct list_head list;
	handle_t *handle;
	struct inode *inode;
	struct bio *bio;
	unsigned int flag;
	refcount_t count;
	struct list_head list_vec;
};

typedef struct ext4_io_end ext4_io_end_t;

struct flex_groups {
	atomic64_t free_clusters;
	atomic_t free_inodes;
	atomic_t used_dirs;
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

struct extent_status {
	struct rb_node rb_node;
	ext4_lblk_t es_lblk;
	ext4_lblk_t es_len;
	ext4_fsblk_t es_pblk;
};

struct ext4_es_tree {
	struct rb_root root;
	struct extent_status *cache_es;
};

struct ext4_es_stats {
	long unsigned int es_stats_shrunk;
	struct percpu_counter es_stats_cache_hits;
	struct percpu_counter es_stats_cache_misses;
	u64 es_stats_scan_time;
	u64 es_stats_max_scan_time;
	struct percpu_counter es_stats_all_cnt;
	struct percpu_counter es_stats_shk_cnt;
};

struct ext4_pending_tree {
	struct rb_root root;
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

struct ext4_fc_stats {
	unsigned int fc_ineligible_reason_count[10];
	long unsigned int fc_num_commits;
	long unsigned int fc_ineligible_commits;
	long unsigned int fc_failed_commits;
	long unsigned int fc_skipped_commits;
	long unsigned int fc_numblks;
	u64 s_fc_avg_commit_time;
};

struct ext4_fc_alloc_region {
	ext4_lblk_t lblk;
	ext4_fsblk_t pblk;
	int ino;
	int len;
};

struct ext4_fc_replay_state {
	int fc_replay_num_tags;
	int fc_replay_expected_off;
	int fc_current_pass;
	int fc_cur_tag;
	int fc_crc;
	struct ext4_fc_alloc_region *fc_regions;
	int fc_regions_size;
	int fc_regions_used;
	int fc_regions_valid;
	int *fc_modified_inodes;
	int fc_modified_inodes_used;
	int fc_modified_inodes_size;
};

struct ext4_inode_info {
	__le32 i_data[15];
	__u32 i_dtime;
	ext4_fsblk_t i_file_acl;
	ext4_group_t i_block_group;
	ext4_lblk_t i_dir_start_lookup;
	long unsigned int i_flags;
	struct rw_semaphore xattr_sem;
	union {
		struct list_head i_orphan;
		unsigned int i_orphan_idx;
	};
	struct list_head i_fc_dilist;
	struct list_head i_fc_list;
	ext4_lblk_t i_fc_lblk_start;
	ext4_lblk_t i_fc_lblk_len;
	atomic_t i_fc_updates;
	wait_queue_head_t i_fc_wait;
	struct mutex i_fc_lock;
	loff_t i_disksize;
	struct rw_semaphore i_data_sem;
	struct inode vfs_inode;
	struct jbd2_inode *jinode;
	spinlock_t i_raw_lock;
	struct timespec64 i_crtime;
	atomic_t i_prealloc_active;
	struct rb_root i_prealloc_node;
	rwlock_t i_prealloc_lock;
	struct ext4_es_tree i_es_tree;
	rwlock_t i_es_lock;
	struct list_head i_es_list;
	unsigned int i_es_all_nr;
	unsigned int i_es_shk_nr;
	ext4_lblk_t i_es_shrink_lblk;
	ext4_group_t i_last_alloc_group;
	unsigned int i_reserved_data_blocks;
	struct ext4_pending_tree i_pending_tree;
	__u16 i_extra_isize;
	u16 i_inline_off;
	u16 i_inline_size;
	spinlock_t i_completed_io_lock;
	struct list_head i_rsv_conversion_list;
	struct work_struct i_rsv_conversion_work;
	atomic_t i_unwritten;
	spinlock_t i_block_reservation_lock;
	tid_t i_sync_tid;
	tid_t i_datasync_tid;
	__u32 i_csum_seed;
	kprojid_t i_projid;
};

struct ext4_super_block {
	__le32 s_inodes_count;
	__le32 s_blocks_count_lo;
	__le32 s_r_blocks_count_lo;
	__le32 s_free_blocks_count_lo;
	__le32 s_free_inodes_count;
	__le32 s_first_data_block;
	__le32 s_log_block_size;
	__le32 s_log_cluster_size;
	__le32 s_blocks_per_group;
	__le32 s_clusters_per_group;
	__le32 s_inodes_per_group;
	__le32 s_mtime;
	__le32 s_wtime;
	__le16 s_mnt_count;
	__le16 s_max_mnt_count;
	__le16 s_magic;
	__le16 s_state;
	__le16 s_errors;
	__le16 s_minor_rev_level;
	__le32 s_lastcheck;
	__le32 s_checkinterval;
	__le32 s_creator_os;
	__le32 s_rev_level;
	__le16 s_def_resuid;
	__le16 s_def_resgid;
	__le32 s_first_ino;
	__le16 s_inode_size;
	__le16 s_block_group_nr;
	__le32 s_feature_compat;
	__le32 s_feature_incompat;
	__le32 s_feature_ro_compat;
	__u8 s_uuid[16];
	char s_volume_name[16];
	char s_last_mounted[64];
	__le32 s_algorithm_usage_bitmap;
	__u8 s_prealloc_blocks;
	__u8 s_prealloc_dir_blocks;
	__le16 s_reserved_gdt_blocks;
	__u8 s_journal_uuid[16];
	__le32 s_journal_inum;
	__le32 s_journal_dev;
	__le32 s_last_orphan;
	__le32 s_hash_seed[4];
	__u8 s_def_hash_version;
	__u8 s_jnl_backup_type;
	__le16 s_desc_size;
	__le32 s_default_mount_opts;
	__le32 s_first_meta_bg;
	__le32 s_mkfs_time;
	__le32 s_jnl_blocks[17];
	__le32 s_blocks_count_hi;
	__le32 s_r_blocks_count_hi;
	__le32 s_free_blocks_count_hi;
	__le16 s_min_extra_isize;
	__le16 s_want_extra_isize;
	__le32 s_flags;
	__le16 s_raid_stride;
	__le16 s_mmp_update_interval;
	__le64 s_mmp_block;
	__le32 s_raid_stripe_width;
	__u8 s_log_groups_per_flex;
	__u8 s_checksum_type;
	__u8 s_encryption_level;
	__u8 s_reserved_pad;
	__le64 s_kbytes_written;
	__le32 s_snapshot_inum;
	__le32 s_snapshot_id;
	__le64 s_snapshot_r_blocks_count;
	__le32 s_snapshot_list;
	__le32 s_error_count;
	__le32 s_first_error_time;
	__le32 s_first_error_ino;
	__le64 s_first_error_block;
	__u8 s_first_error_func[32];
	__le32 s_first_error_line;
	__le32 s_last_error_time;
	__le32 s_last_error_ino;
	__le32 s_last_error_line;
	__le64 s_last_error_block;
	__u8 s_last_error_func[32];
	__u8 s_mount_opts[64];
	__le32 s_usr_quota_inum;
	__le32 s_grp_quota_inum;
	__le32 s_overhead_clusters;
	__le32 s_backup_bgs[2];
	__u8 s_encrypt_algos[4];
	__u8 s_encrypt_pw_salt[16];
	__le32 s_lpf_ino;
	__le32 s_prj_quota_inum;
	__le32 s_checksum_seed;
	__u8 s_wtime_hi;
	__u8 s_mtime_hi;
	__u8 s_mkfs_time_hi;
	__u8 s_lastcheck_hi;
	__u8 s_first_error_time_hi;
	__u8 s_last_error_time_hi;
	__u8 s_first_error_errcode;
	__u8 s_last_error_errcode;
	__le16 s_encoding;
	__le16 s_encoding_flags;
	__le32 s_orphan_file_inum;
	__le32 s_reserved[94];
	__le32 s_checksum;
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

struct ext4_journal_trigger {
	struct jbd2_buffer_trigger_type tr_triggers;
	struct super_block *sb;
};

struct ext4_orphan_block {
	atomic_t ob_free_entries;
	struct buffer_head *ob_bh;
};

struct ext4_orphan_info {
	int of_blocks;
	__u32 of_csum_seed;
	struct ext4_orphan_block *of_binfo;
};

struct ext4_group_info;

struct ext4_locality_group;

struct ext4_li_request;

struct mb_cache;

struct ext4_sb_info {
	long unsigned int s_desc_size;
	long unsigned int s_inodes_per_block;
	long unsigned int s_blocks_per_group;
	long unsigned int s_clusters_per_group;
	long unsigned int s_inodes_per_group;
	long unsigned int s_itb_per_group;
	long unsigned int s_gdb_count;
	long unsigned int s_desc_per_block;
	ext4_group_t s_groups_count;
	ext4_group_t s_blockfile_groups;
	long unsigned int s_overhead;
	unsigned int s_cluster_ratio;
	unsigned int s_cluster_bits;
	loff_t s_bitmap_maxbytes;
	struct buffer_head *s_sbh;
	struct ext4_super_block *s_es;
	struct buffer_head **s_group_desc;
	unsigned int s_mount_opt;
	unsigned int s_mount_opt2;
	long unsigned int s_mount_flags;
	unsigned int s_def_mount_opt;
	unsigned int s_def_mount_opt2;
	ext4_fsblk_t s_sb_block;
	atomic64_t s_resv_clusters;
	kuid_t s_resuid;
	kgid_t s_resgid;
	short unsigned int s_mount_state;
	short unsigned int s_pad;
	int s_addr_per_block_bits;
	int s_desc_per_block_bits;
	int s_inode_size;
	int s_first_ino;
	unsigned int s_inode_readahead_blks;
	unsigned int s_inode_goal;
	u32 s_hash_seed[4];
	int s_def_hash_version;
	int s_hash_unsigned;
	struct percpu_counter s_freeclusters_counter;
	struct percpu_counter s_freeinodes_counter;
	struct percpu_counter s_dirs_counter;
	struct percpu_counter s_dirtyclusters_counter;
	struct percpu_counter s_sra_exceeded_retry_limit;
	struct blockgroup_lock *s_blockgroup_lock;
	struct proc_dir_entry *s_proc;
	struct kobject s_kobj;
	struct completion s_kobj_unregister;
	struct super_block *s_sb;
	struct buffer_head *s_mmp_bh;
	struct journal_s *s_journal;
	long unsigned int s_ext4_flags;
	struct mutex s_orphan_lock;
	struct list_head s_orphan;
	struct ext4_orphan_info s_orphan_info;
	long unsigned int s_commit_interval;
	u32 s_max_batch_time;
	u32 s_min_batch_time;
	struct bdev_handle *s_journal_bdev_handle;
	unsigned int s_want_extra_isize;
	struct ext4_system_blocks *s_system_blks;
	struct ext4_group_info ***s_group_info;
	struct inode *s_buddy_cache;
	spinlock_t s_md_lock;
	short unsigned int *s_mb_offsets;
	unsigned int *s_mb_maxs;
	unsigned int s_group_info_size;
	unsigned int s_mb_free_pending;
	struct list_head s_freed_data_list;
	struct list_head s_discard_list;
	struct work_struct s_discard_work;
	atomic_t s_retry_alloc_pending;
	struct list_head *s_mb_avg_fragment_size;
	rwlock_t *s_mb_avg_fragment_size_locks;
	struct list_head *s_mb_largest_free_orders;
	rwlock_t *s_mb_largest_free_orders_locks;
	long unsigned int s_stripe;
	unsigned int s_mb_max_linear_groups;
	unsigned int s_mb_stream_request;
	unsigned int s_mb_max_to_scan;
	unsigned int s_mb_min_to_scan;
	unsigned int s_mb_stats;
	unsigned int s_mb_order2_reqs;
	unsigned int s_mb_group_prealloc;
	unsigned int s_max_dir_size_kb;
	long unsigned int s_mb_last_group;
	long unsigned int s_mb_last_start;
	unsigned int s_mb_prefetch;
	unsigned int s_mb_prefetch_limit;
	unsigned int s_mb_best_avail_max_trim_order;
	atomic_t s_bal_reqs;
	atomic_t s_bal_success;
	atomic_t s_bal_allocated;
	atomic_t s_bal_ex_scanned;
	atomic_t s_bal_cX_ex_scanned[5];
	atomic_t s_bal_groups_scanned;
	atomic_t s_bal_goals;
	atomic_t s_bal_len_goals;
	atomic_t s_bal_breaks;
	atomic_t s_bal_2orders;
	atomic_t s_bal_p2_aligned_bad_suggestions;
	atomic_t s_bal_goal_fast_bad_suggestions;
	atomic_t s_bal_best_avail_bad_suggestions;
	atomic64_t s_bal_cX_groups_considered[5];
	atomic64_t s_bal_cX_hits[5];
	atomic64_t s_bal_cX_failed[5];
	atomic_t s_mb_buddies_generated;
	atomic64_t s_mb_generation_time;
	atomic_t s_mb_lost_chunks;
	atomic_t s_mb_preallocated;
	atomic_t s_mb_discarded;
	atomic_t s_lock_busy;
	struct ext4_locality_group *s_locality_groups;
	long unsigned int s_sectors_written_start;
	u64 s_kbytes_written;
	unsigned int s_extent_max_zeroout_kb;
	unsigned int s_log_groups_per_flex;
	struct flex_groups **s_flex_groups;
	ext4_group_t s_flex_groups_allocated;
	struct workqueue_struct *rsv_conversion_wq;
	struct timer_list s_err_report;
	struct ext4_li_request *s_li_request;
	unsigned int s_li_wait_mult;
	struct task_struct *s_mmp_tsk;
	long unsigned int s_last_trim_minblks;
	struct crypto_shash *s_chksum_driver;
	__u32 s_csum_seed;
	struct shrinker s_es_shrinker;
	struct list_head s_es_list;
	long int s_es_nr_inode;
	struct ext4_es_stats s_es_stats;
	struct mb_cache *s_ea_block_cache;
	struct mb_cache *s_ea_inode_cache;
	long: 64;
	long: 64;
	spinlock_t s_es_lock;
	struct ext4_journal_trigger s_journal_triggers[1];
	struct ratelimit_state s_err_ratelimit_state;
	struct ratelimit_state s_warning_ratelimit_state;
	struct ratelimit_state s_msg_ratelimit_state;
	atomic_t s_warning_count;
	atomic_t s_msg_count;
	struct fscrypt_dummy_policy s_dummy_enc_policy;
	struct percpu_rw_semaphore s_writepages_rwsem;
	struct dax_device *s_daxdev;
	u64 s_dax_part_off;
	errseq_t s_bdev_wb_err;
	spinlock_t s_bdev_wb_lock;
	spinlock_t s_error_lock;
	int s_add_error_count;
	int s_first_error_code;
	__u32 s_first_error_line;
	__u32 s_first_error_ino;
	__u64 s_first_error_block;
	const char *s_first_error_func;
	time64_t s_first_error_time;
	int s_last_error_code;
	__u32 s_last_error_line;
	__u32 s_last_error_ino;
	__u64 s_last_error_block;
	const char *s_last_error_func;
	time64_t s_last_error_time;
	struct work_struct s_sb_upd_work;
	atomic_t s_fc_subtid;
	struct list_head s_fc_q[2];
	struct list_head s_fc_dentry_q[2];
	unsigned int s_fc_bytes;
	spinlock_t s_fc_lock;
	struct buffer_head *s_fc_bh;
	struct ext4_fc_stats s_fc_stats;
	tid_t s_fc_ineligible_tid;
	struct ext4_fc_replay_state s_fc_replay_state;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ext4_group_info {
	long unsigned int bb_state;
	struct rb_root bb_free_root;
	ext4_grpblk_t bb_first_free;
	ext4_grpblk_t bb_free;
	ext4_grpblk_t bb_fragments;
	int bb_avg_fragment_size_order;
	ext4_grpblk_t bb_largest_free_order;
	ext4_group_t bb_group;
	struct list_head bb_prealloc_list;
	struct rw_semaphore alloc_sem;
	struct list_head bb_avg_fragment_size_node;
	struct list_head bb_largest_free_order_node;
	ext4_grpblk_t bb_counters[0];
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

struct ext4_li_request {
	struct super_block *lr_super;
	enum ext4_li_mode lr_mode;
	ext4_group_t lr_first_not_zeroed;
	ext4_group_t lr_next_group;
	struct list_head lr_request;
	long unsigned int lr_next_sched;
	long unsigned int lr_timeout;
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

struct ext4_iloc {
	struct buffer_head *bh;
	long unsigned int offset;
	ext4_group_t block_group;
};

struct ext4_extent_tail {
	__le32 et_checksum;
};

struct ext4_extent {
	__le32 ee_block;
	__le16 ee_len;
	__le16 ee_start_hi;
	__le32 ee_start_lo;
};

struct ext4_extent_idx {
	__le32 ei_block;
	__le32 ei_leaf_lo;
	__le16 ei_leaf_hi;
	__u16 ei_unused;
};

struct ext4_extent_header {
	__le16 eh_magic;
	__le16 eh_entries;
	__le16 eh_max;
	__le16 eh_depth;
	__le32 eh_generation;
};

struct ext4_ext_path {
	ext4_fsblk_t p_block;
	__u16 p_depth;
	__u16 p_maxdepth;
	struct ext4_extent *p_ext;
	struct ext4_extent_idx *p_idx;
	struct ext4_extent_header *p_hdr;
	struct buffer_head *p_bh;
};

struct partial_cluster {
	ext4_fsblk_t pclu;
	ext4_lblk_t lblk;
	enum {
		initial = 0,
		tofree = 1,
		nofree = 2,
	} state;
};

struct jbd2_journal_block_tail {
	__be32 t_checksum;
};

struct trace_event_raw_jbd2_checkpoint {
	struct trace_entry ent;
	dev_t dev;
	int result;
	char __data[0];
};

struct trace_event_raw_jbd2_commit {
	struct trace_entry ent;
	dev_t dev;
	char sync_commit;
	tid_t transaction;
	char __data[0];
};

struct trace_event_raw_jbd2_end_commit {
	struct trace_entry ent;
	dev_t dev;
	char sync_commit;
	tid_t transaction;
	tid_t head;
	char __data[0];
};

struct trace_event_raw_jbd2_submit_inode_data {
	struct trace_entry ent;
	dev_t dev;
	ino_t ino;
	char __data[0];
};

struct trace_event_raw_jbd2_handle_start_class {
	struct trace_entry ent;
	dev_t dev;
	tid_t tid;
	unsigned int type;
	unsigned int line_no;
	int requested_blocks;
	char __data[0];
};

struct trace_event_raw_jbd2_handle_extend {
	struct trace_entry ent;
	dev_t dev;
	tid_t tid;
	unsigned int type;
	unsigned int line_no;
	int buffer_credits;
	int requested_blocks;
	char __data[0];
};

struct trace_event_raw_jbd2_handle_stats {
	struct trace_entry ent;
	dev_t dev;
	tid_t tid;
	unsigned int type;
	unsigned int line_no;
	int interval;
	int sync;
	int requested_blocks;
	int dirtied_blocks;
	char __data[0];
};

struct trace_event_raw_jbd2_run_stats {
	struct trace_entry ent;
	dev_t dev;
	tid_t tid;
	long unsigned int wait;
	long unsigned int request_delay;
	long unsigned int running;
	long unsigned int locked;
	long unsigned int flushing;
	long unsigned int logging;
	__u32 handle_count;
	__u32 blocks;
	__u32 blocks_logged;
	char __data[0];
};

struct trace_event_raw_jbd2_checkpoint_stats {
	struct trace_entry ent;
	dev_t dev;
	tid_t tid;
	long unsigned int chp_time;
	__u32 forced_to_close;
	__u32 written;
	__u32 dropped;
	char __data[0];
};

struct trace_event_raw_jbd2_update_log_tail {
	struct trace_entry ent;
	dev_t dev;
	tid_t tail_sequence;
	tid_t first_tid;
	long unsigned int block_nr;
	long unsigned int freed;
	char __data[0];
};

struct trace_event_raw_jbd2_write_superblock {
	struct trace_entry ent;
	dev_t dev;
	blk_opf_t write_flags;
	char __data[0];
};

struct trace_event_raw_jbd2_lock_buffer_stall {
	struct trace_entry ent;
	dev_t dev;
	long unsigned int stall_ms;
	char __data[0];
};

struct trace_event_raw_jbd2_journal_shrink {
	struct trace_entry ent;
	dev_t dev;
	long unsigned int nr_to_scan;
	long unsigned int count;
	char __data[0];
};

struct trace_event_raw_jbd2_shrink_scan_exit {
	struct trace_entry ent;
	dev_t dev;
	long unsigned int nr_to_scan;
	long unsigned int nr_shrunk;
	long unsigned int count;
	char __data[0];
};

struct trace_event_raw_jbd2_shrink_checkpoint_list {
	struct trace_entry ent;
	dev_t dev;
	tid_t first_tid;
	tid_t tid;
	tid_t last_tid;
	long unsigned int nr_freed;
	tid_t next_tid;
	char __data[0];
};

struct trace_event_data_offsets_jbd2_checkpoint {};

struct trace_event_data_offsets_jbd2_commit {};

struct trace_event_data_offsets_jbd2_end_commit {};

struct trace_event_data_offsets_jbd2_submit_inode_data {};

struct trace_event_data_offsets_jbd2_handle_start_class {};

struct trace_event_data_offsets_jbd2_handle_extend {};

struct trace_event_data_offsets_jbd2_handle_stats {};

struct trace_event_data_offsets_jbd2_run_stats {};

struct trace_event_data_offsets_jbd2_checkpoint_stats {};

struct trace_event_data_offsets_jbd2_update_log_tail {};

struct trace_event_data_offsets_jbd2_write_superblock {};

struct trace_event_data_offsets_jbd2_lock_buffer_stall {};

struct trace_event_data_offsets_jbd2_journal_shrink {};

struct trace_event_data_offsets_jbd2_shrink_scan_exit {};

struct trace_event_data_offsets_jbd2_shrink_checkpoint_list {};

typedef void (*btf_trace_jbd2_checkpoint)(void *, journal_t *, int);

typedef void (*btf_trace_jbd2_start_commit)(void *, journal_t *, transaction_t *);

typedef void (*btf_trace_jbd2_commit_locking)(void *, journal_t *, transaction_t *);

typedef void (*btf_trace_jbd2_commit_flushing)(void *, journal_t *, transaction_t *);

typedef void (*btf_trace_jbd2_commit_logging)(void *, journal_t *, transaction_t *);

typedef void (*btf_trace_jbd2_drop_transaction)(void *, journal_t *, transaction_t *);

typedef void (*btf_trace_jbd2_end_commit)(void *, journal_t *, transaction_t *);

typedef void (*btf_trace_jbd2_submit_inode_data)(void *, struct inode *);

typedef void (*btf_trace_jbd2_handle_start)(void *, dev_t, tid_t, unsigned int, unsigned int, int);

typedef void (*btf_trace_jbd2_handle_restart)(void *, dev_t, tid_t, unsigned int, unsigned int, int);

typedef void (*btf_trace_jbd2_handle_extend)(void *, dev_t, tid_t, unsigned int, unsigned int, int, int);

typedef void (*btf_trace_jbd2_handle_stats)(void *, dev_t, tid_t, unsigned int, unsigned int, int, int, int, int);

typedef void (*btf_trace_jbd2_run_stats)(void *, dev_t, tid_t, struct transaction_run_stats_s *);

typedef void (*btf_trace_jbd2_checkpoint_stats)(void *, dev_t, tid_t, struct transaction_chp_stats_s *);

typedef void (*btf_trace_jbd2_update_log_tail)(void *, journal_t *, tid_t, long unsigned int, long unsigned int);

typedef void (*btf_trace_jbd2_write_superblock)(void *, journal_t *, blk_opf_t);

typedef void (*btf_trace_jbd2_lock_buffer_stall)(void *, dev_t, long unsigned int);

typedef void (*btf_trace_jbd2_shrink_count)(void *, journal_t *, long unsigned int, long unsigned int);

typedef void (*btf_trace_jbd2_shrink_scan_enter)(void *, journal_t *, long unsigned int, long unsigned int);

typedef void (*btf_trace_jbd2_shrink_scan_exit)(void *, journal_t *, long unsigned int, long unsigned int, long unsigned int);

typedef void (*btf_trace_jbd2_shrink_checkpoint_list)(void *, journal_t *, tid_t, tid_t, tid_t, long unsigned int, tid_t);

struct jbd2_stats_proc_session {
	journal_t *journal;
	struct transaction_stats_s *stats;
	int start;
	int max;
};

typedef int __kernel_key_t;

typedef __kernel_key_t key_t;

struct timezone {
	int tz_minuteswest;
	int tz_dsttime;
};

struct kern_ipc_perm {
	spinlock_t lock;
	bool deleted;
	int id;
	key_t key;
	kuid_t uid;
	kgid_t gid;
	kuid_t cuid;
	kgid_t cgid;
	umode_t mode;
	long unsigned int seq;
	void *security;
	struct rhash_head khtnode;
	struct callback_head rcu;
	refcount_t refcount;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct sembuf {
	short unsigned int sem_num;
	short int sem_op;
	short int sem_flg;
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

struct __key_reference_with_attributes;

typedef struct __key_reference_with_attributes *key_ref_t;

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

struct xattr;

typedef int (*initxattrs)(struct inode *, const struct xattr *, void *);

struct xattr {
	const char *name;
	void *value;
	size_t value_len;
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

struct msg_msg;

struct request_sock;

struct sctp_association;

struct audit_krule;

union security_list_options {
	int (*binder_set_context_mgr)(const struct cred *);
	int (*binder_transaction)(const struct cred *, const struct cred *);
	int (*binder_transfer_binder)(const struct cred *, const struct cred *);
	int (*binder_transfer_file)(const struct cred *, const struct cred *, const struct file *);
	int (*ptrace_access_check)(struct task_struct *, unsigned int);
	int (*ptrace_traceme)(struct task_struct *);
	int (*capget)(const struct task_struct *, kernel_cap_t *, kernel_cap_t *, kernel_cap_t *);
	int (*capset)(struct cred *, const struct cred *, const kernel_cap_t *, const kernel_cap_t *, const kernel_cap_t *);
	int (*capable)(const struct cred *, struct user_namespace *, int, unsigned int);
	int (*quotactl)(int, int, int, const struct super_block *);
	int (*quota_on)(struct dentry *);
	int (*syslog)(int);
	int (*settime)(const struct timespec64 *, const struct timezone *);
	int (*vm_enough_memory)(struct mm_struct *, long int);
	int (*bprm_creds_for_exec)(struct linux_binprm *);
	int (*bprm_creds_from_file)(struct linux_binprm *, const struct file *);
	int (*bprm_check_security)(struct linux_binprm *);
	void (*bprm_committing_creds)(const struct linux_binprm *);
	void (*bprm_committed_creds)(const struct linux_binprm *);
	int (*fs_context_submount)(struct fs_context *, struct super_block *);
	int (*fs_context_dup)(struct fs_context *, struct fs_context *);
	int (*fs_context_parse_param)(struct fs_context *, struct fs_parameter *);
	int (*sb_alloc_security)(struct super_block *);
	void (*sb_delete)(struct super_block *);
	void (*sb_free_security)(struct super_block *);
	void (*sb_free_mnt_opts)(void *);
	int (*sb_eat_lsm_opts)(char *, void **);
	int (*sb_mnt_opts_compat)(struct super_block *, void *);
	int (*sb_remount)(struct super_block *, void *);
	int (*sb_kern_mount)(const struct super_block *);
	int (*sb_show_options)(struct seq_file *, struct super_block *);
	int (*sb_statfs)(struct dentry *);
	int (*sb_mount)(const char *, const struct path *, const char *, long unsigned int, void *);
	int (*sb_umount)(struct vfsmount *, int);
	int (*sb_pivotroot)(const struct path *, const struct path *);
	int (*sb_set_mnt_opts)(struct super_block *, void *, long unsigned int, long unsigned int *);
	int (*sb_clone_mnt_opts)(const struct super_block *, struct super_block *, long unsigned int, long unsigned int *);
	int (*move_mount)(const struct path *, const struct path *);
	int (*dentry_init_security)(struct dentry *, int, const struct qstr *, const char **, void **, u32 *);
	int (*dentry_create_files_as)(struct dentry *, int, struct qstr *, const struct cred *, struct cred *);
	int (*path_notify)(const struct path *, u64, unsigned int);
	int (*inode_alloc_security)(struct inode *);
	void (*inode_free_security)(struct inode *);
	int (*inode_init_security)(struct inode *, struct inode *, const struct qstr *, struct xattr *, int *);
	int (*inode_init_security_anon)(struct inode *, const struct qstr *, const struct inode *);
	int (*inode_create)(struct inode *, struct dentry *, umode_t);
	int (*inode_link)(struct dentry *, struct inode *, struct dentry *);
	int (*inode_unlink)(struct inode *, struct dentry *);
	int (*inode_symlink)(struct inode *, struct dentry *, const char *);
	int (*inode_mkdir)(struct inode *, struct dentry *, umode_t);
	int (*inode_rmdir)(struct inode *, struct dentry *);
	int (*inode_mknod)(struct inode *, struct dentry *, umode_t, dev_t);
	int (*inode_rename)(struct inode *, struct dentry *, struct inode *, struct dentry *);
	int (*inode_readlink)(struct dentry *);
	int (*inode_follow_link)(struct dentry *, struct inode *, bool);
	int (*inode_permission)(struct inode *, int);
	int (*inode_setattr)(struct dentry *, struct iattr *);
	int (*inode_getattr)(const struct path *);
	int (*inode_setxattr)(struct mnt_idmap *, struct dentry *, const char *, const void *, size_t, int);
	void (*inode_post_setxattr)(struct dentry *, const char *, const void *, size_t, int);
	int (*inode_getxattr)(struct dentry *, const char *);
	int (*inode_listxattr)(struct dentry *);
	int (*inode_removexattr)(struct mnt_idmap *, struct dentry *, const char *);
	int (*inode_set_acl)(struct mnt_idmap *, struct dentry *, const char *, struct posix_acl *);
	int (*inode_get_acl)(struct mnt_idmap *, struct dentry *, const char *);
	int (*inode_remove_acl)(struct mnt_idmap *, struct dentry *, const char *);
	int (*inode_need_killpriv)(struct dentry *);
	int (*inode_killpriv)(struct mnt_idmap *, struct dentry *);
	int (*inode_getsecurity)(struct mnt_idmap *, struct inode *, const char *, void **, bool);
	int (*inode_setsecurity)(struct inode *, const char *, const void *, size_t, int);
	int (*inode_listsecurity)(struct inode *, char *, size_t);
	void (*inode_getsecid)(struct inode *, u32 *);
	int (*inode_copy_up)(struct dentry *, struct cred **);
	int (*inode_copy_up_xattr)(const char *);
	int (*kernfs_init_security)(struct kernfs_node *, struct kernfs_node *);
	int (*file_permission)(struct file *, int);
	int (*file_alloc_security)(struct file *);
	void (*file_free_security)(struct file *);
	int (*file_ioctl)(struct file *, unsigned int, long unsigned int);
	int (*mmap_addr)(long unsigned int);
	int (*mmap_file)(struct file *, long unsigned int, long unsigned int, long unsigned int);
	int (*file_mprotect)(struct vm_area_struct *, long unsigned int, long unsigned int);
	int (*file_lock)(struct file *, unsigned int);
	int (*file_fcntl)(struct file *, unsigned int, long unsigned int);
	void (*file_set_fowner)(struct file *);
	int (*file_send_sigiotask)(struct task_struct *, struct fown_struct *, int);
	int (*file_receive)(struct file *);
	int (*file_open)(struct file *);
	int (*file_truncate)(struct file *);
	int (*task_alloc)(struct task_struct *, long unsigned int);
	void (*task_free)(struct task_struct *);
	int (*cred_alloc_blank)(struct cred *, gfp_t);
	void (*cred_free)(struct cred *);
	int (*cred_prepare)(struct cred *, const struct cred *, gfp_t);
	void (*cred_transfer)(struct cred *, const struct cred *);
	void (*cred_getsecid)(const struct cred *, u32 *);
	int (*kernel_act_as)(struct cred *, u32);
	int (*kernel_create_files_as)(struct cred *, struct inode *);
	int (*kernel_module_request)(char *);
	int (*kernel_load_data)(enum kernel_load_data_id, bool);
	int (*kernel_post_load_data)(char *, loff_t, enum kernel_load_data_id, char *);
	int (*kernel_read_file)(struct file *, enum kernel_read_file_id, bool);
	int (*kernel_post_read_file)(struct file *, char *, loff_t, enum kernel_read_file_id);
	int (*task_fix_setuid)(struct cred *, const struct cred *, int);
	int (*task_fix_setgid)(struct cred *, const struct cred *, int);
	int (*task_fix_setgroups)(struct cred *, const struct cred *);
	int (*task_setpgid)(struct task_struct *, pid_t);
	int (*task_getpgid)(struct task_struct *);
	int (*task_getsid)(struct task_struct *);
	void (*current_getsecid_subj)(u32 *);
	void (*task_getsecid_obj)(struct task_struct *, u32 *);
	int (*task_setnice)(struct task_struct *, int);
	int (*task_setioprio)(struct task_struct *, int);
	int (*task_getioprio)(struct task_struct *);
	int (*task_prlimit)(const struct cred *, const struct cred *, unsigned int);
	int (*task_setrlimit)(struct task_struct *, unsigned int, struct rlimit *);
	int (*task_setscheduler)(struct task_struct *);
	int (*task_getscheduler)(struct task_struct *);
	int (*task_movememory)(struct task_struct *);
	int (*task_kill)(struct task_struct *, struct kernel_siginfo *, int, const struct cred *);
	int (*task_prctl)(int, long unsigned int, long unsigned int, long unsigned int, long unsigned int);
	void (*task_to_inode)(struct task_struct *, struct inode *);
	int (*userns_create)(const struct cred *);
	int (*ipc_permission)(struct kern_ipc_perm *, short int);
	void (*ipc_getsecid)(struct kern_ipc_perm *, u32 *);
	int (*msg_msg_alloc_security)(struct msg_msg *);
	void (*msg_msg_free_security)(struct msg_msg *);
	int (*msg_queue_alloc_security)(struct kern_ipc_perm *);
	void (*msg_queue_free_security)(struct kern_ipc_perm *);
	int (*msg_queue_associate)(struct kern_ipc_perm *, int);
	int (*msg_queue_msgctl)(struct kern_ipc_perm *, int);
	int (*msg_queue_msgsnd)(struct kern_ipc_perm *, struct msg_msg *, int);
	int (*msg_queue_msgrcv)(struct kern_ipc_perm *, struct msg_msg *, struct task_struct *, long int, int);
	int (*shm_alloc_security)(struct kern_ipc_perm *);
	void (*shm_free_security)(struct kern_ipc_perm *);
	int (*shm_associate)(struct kern_ipc_perm *, int);
	int (*shm_shmctl)(struct kern_ipc_perm *, int);
	int (*shm_shmat)(struct kern_ipc_perm *, char *, int);
	int (*sem_alloc_security)(struct kern_ipc_perm *);
	void (*sem_free_security)(struct kern_ipc_perm *);
	int (*sem_associate)(struct kern_ipc_perm *, int);
	int (*sem_semctl)(struct kern_ipc_perm *, int);
	int (*sem_semop)(struct kern_ipc_perm *, struct sembuf *, unsigned int, int);
	int (*netlink_send)(struct sock *, struct sk_buff *);
	void (*d_instantiate)(struct dentry *, struct inode *);
	int (*getprocattr)(struct task_struct *, const char *, char **);
	int (*setprocattr)(const char *, void *, size_t);
	int (*ismaclabel)(const char *);
	int (*secid_to_secctx)(u32, char **, u32 *);
	int (*secctx_to_secid)(const char *, u32, u32 *);
	void (*release_secctx)(char *, u32);
	void (*inode_invalidate_secctx)(struct inode *);
	int (*inode_notifysecctx)(struct inode *, void *, u32);
	int (*inode_setsecctx)(struct dentry *, void *, u32);
	int (*inode_getsecctx)(struct inode *, void **, u32 *);
	int (*unix_stream_connect)(struct sock *, struct sock *, struct sock *);
	int (*unix_may_send)(struct socket *, struct socket *);
	int (*socket_create)(int, int, int, int);
	int (*socket_post_create)(struct socket *, int, int, int, int);
	int (*socket_socketpair)(struct socket *, struct socket *);
	int (*socket_bind)(struct socket *, struct sockaddr *, int);
	int (*socket_connect)(struct socket *, struct sockaddr *, int);
	int (*socket_listen)(struct socket *, int);
	int (*socket_accept)(struct socket *, struct socket *);
	int (*socket_sendmsg)(struct socket *, struct msghdr *, int);
	int (*socket_recvmsg)(struct socket *, struct msghdr *, int, int);
	int (*socket_getsockname)(struct socket *);
	int (*socket_getpeername)(struct socket *);
	int (*socket_getsockopt)(struct socket *, int, int);
	int (*socket_setsockopt)(struct socket *, int, int);
	int (*socket_shutdown)(struct socket *, int);
	int (*socket_sock_rcv_skb)(struct sock *, struct sk_buff *);
	int (*socket_getpeersec_stream)(struct socket *, sockptr_t, sockptr_t, unsigned int);
	int (*socket_getpeersec_dgram)(struct socket *, struct sk_buff *, u32 *);
	int (*sk_alloc_security)(struct sock *, int, gfp_t);
	void (*sk_free_security)(struct sock *);
	void (*sk_clone_security)(const struct sock *, struct sock *);
	void (*sk_getsecid)(const struct sock *, u32 *);
	void (*sock_graft)(struct sock *, struct socket *);
	int (*inet_conn_request)(const struct sock *, struct sk_buff *, struct request_sock *);
	void (*inet_csk_clone)(struct sock *, const struct request_sock *);
	void (*inet_conn_established)(struct sock *, struct sk_buff *);
	int (*secmark_relabel_packet)(u32);
	void (*secmark_refcount_inc)();
	void (*secmark_refcount_dec)();
	void (*req_classify_flow)(const struct request_sock *, struct flowi_common *);
	int (*tun_dev_alloc_security)(void **);
	void (*tun_dev_free_security)(void *);
	int (*tun_dev_create)();
	int (*tun_dev_attach_queue)(void *);
	int (*tun_dev_attach)(struct sock *, void *);
	int (*tun_dev_open)(void *);
	int (*sctp_assoc_request)(struct sctp_association *, struct sk_buff *);
	int (*sctp_bind_connect)(struct sock *, int, struct sockaddr *, int);
	void (*sctp_sk_clone)(struct sctp_association *, struct sock *, struct sock *);
	int (*sctp_assoc_established)(struct sctp_association *, struct sk_buff *);
	int (*mptcp_add_subflow)(struct sock *, struct sock *);
	int (*key_alloc)(struct key *, const struct cred *, long unsigned int);
	void (*key_free)(struct key *);
	int (*key_permission)(key_ref_t, const struct cred *, enum key_need_perm);
	int (*key_getsecurity)(struct key *, char **);
	int (*audit_rule_init)(u32, u32, char *, void **);
	int (*audit_rule_known)(struct audit_krule *);
	int (*audit_rule_match)(u32, u32, u32, void *);
	void (*audit_rule_free)(void *);
	int (*bpf)(int, union bpf_attr *, unsigned int);
	int (*bpf_map)(struct bpf_map *, fmode_t);
	int (*bpf_prog)(struct bpf_prog *);
	int (*bpf_map_alloc_security)(struct bpf_map *);
	void (*bpf_map_free_security)(struct bpf_map *);
	int (*bpf_prog_alloc_security)(struct bpf_prog_aux *);
	void (*bpf_prog_free_security)(struct bpf_prog_aux *);
	int (*locked_down)(enum lockdown_reason);
	int (*perf_event_open)(struct perf_event_attr *, int);
	int (*perf_event_alloc)(struct perf_event *);
	void (*perf_event_free)(struct perf_event *);
	int (*perf_event_read)(struct perf_event *);
	int (*perf_event_write)(struct perf_event *);
	int (*uring_override_creds)(const struct cred *);
	int (*uring_sqpoll)();
	int (*uring_cmd)(struct io_uring_cmd *);
};

struct msg_msgseg;

struct msg_msg {
	struct list_head m_list;
	long int m_type;
	size_t m_ts;
	struct msg_msgseg *next;
	void *security;
};

struct saved_syn;

struct request_sock {
	struct sock_common __req_common;
	struct request_sock *dl_next;
	u16 mss;
	u8 num_retrans;
	u8 syncookie: 1;
	u8 num_timeout: 7;
	u32 ts_recent;
	struct timer_list rsk_timer;
	const struct request_sock_ops *rsk_ops;
	struct sock *sk;
	struct saved_syn *saved_syn;
	u32 secid;
	u32 peer_secid;
	u32 timeout;
};

struct audit_field;

struct audit_watch;

struct audit_tree;

struct audit_fsnotify_mark;

struct audit_krule {
	u32 pflags;
	u32 flags;
	u32 listnr;
	u32 action;
	u32 mask[64];
	u32 buflen;
	u32 field_count;
	char *filterkey;
	struct audit_field *fields;
	struct audit_field *arch_f;
	struct audit_field *inode_f;
	struct audit_watch *watch;
	struct audit_tree *tree;
	struct audit_fsnotify_mark *exe;
	struct list_head rlist;
	struct list_head list;
	u64 prio;
};

struct security_hook_heads {
	struct hlist_head binder_set_context_mgr;
	struct hlist_head binder_transaction;
	struct hlist_head binder_transfer_binder;
	struct hlist_head binder_transfer_file;
	struct hlist_head ptrace_access_check;
	struct hlist_head ptrace_traceme;
	struct hlist_head capget;
	struct hlist_head capset;
	struct hlist_head capable;
	struct hlist_head quotactl;
	struct hlist_head quota_on;
	struct hlist_head syslog;
	struct hlist_head settime;
	struct hlist_head vm_enough_memory;
	struct hlist_head bprm_creds_for_exec;
	struct hlist_head bprm_creds_from_file;
	struct hlist_head bprm_check_security;
	struct hlist_head bprm_committing_creds;
	struct hlist_head bprm_committed_creds;
	struct hlist_head fs_context_submount;
	struct hlist_head fs_context_dup;
	struct hlist_head fs_context_parse_param;
	struct hlist_head sb_alloc_security;
	struct hlist_head sb_delete;
	struct hlist_head sb_free_security;
	struct hlist_head sb_free_mnt_opts;
	struct hlist_head sb_eat_lsm_opts;
	struct hlist_head sb_mnt_opts_compat;
	struct hlist_head sb_remount;
	struct hlist_head sb_kern_mount;
	struct hlist_head sb_show_options;
	struct hlist_head sb_statfs;
	struct hlist_head sb_mount;
	struct hlist_head sb_umount;
	struct hlist_head sb_pivotroot;
	struct hlist_head sb_set_mnt_opts;
	struct hlist_head sb_clone_mnt_opts;
	struct hlist_head move_mount;
	struct hlist_head dentry_init_security;
	struct hlist_head dentry_create_files_as;
	struct hlist_head path_notify;
	struct hlist_head inode_alloc_security;
	struct hlist_head inode_free_security;
	struct hlist_head inode_init_security;
	struct hlist_head inode_init_security_anon;
	struct hlist_head inode_create;
	struct hlist_head inode_link;
	struct hlist_head inode_unlink;
	struct hlist_head inode_symlink;
	struct hlist_head inode_mkdir;
	struct hlist_head inode_rmdir;
	struct hlist_head inode_mknod;
	struct hlist_head inode_rename;
	struct hlist_head inode_readlink;
	struct hlist_head inode_follow_link;
	struct hlist_head inode_permission;
	struct hlist_head inode_setattr;
	struct hlist_head inode_getattr;
	struct hlist_head inode_setxattr;
	struct hlist_head inode_post_setxattr;
	struct hlist_head inode_getxattr;
	struct hlist_head inode_listxattr;
	struct hlist_head inode_removexattr;
	struct hlist_head inode_set_acl;
	struct hlist_head inode_get_acl;
	struct hlist_head inode_remove_acl;
	struct hlist_head inode_need_killpriv;
	struct hlist_head inode_killpriv;
	struct hlist_head inode_getsecurity;
	struct hlist_head inode_setsecurity;
	struct hlist_head inode_listsecurity;
	struct hlist_head inode_getsecid;
	struct hlist_head inode_copy_up;
	struct hlist_head inode_copy_up_xattr;
	struct hlist_head kernfs_init_security;
	struct hlist_head file_permission;
	struct hlist_head file_alloc_security;
	struct hlist_head file_free_security;
	struct hlist_head file_ioctl;
	struct hlist_head mmap_addr;
	struct hlist_head mmap_file;
	struct hlist_head file_mprotect;
	struct hlist_head file_lock;
	struct hlist_head file_fcntl;
	struct hlist_head file_set_fowner;
	struct hlist_head file_send_sigiotask;
	struct hlist_head file_receive;
	struct hlist_head file_open;
	struct hlist_head file_truncate;
	struct hlist_head task_alloc;
	struct hlist_head task_free;
	struct hlist_head cred_alloc_blank;
	struct hlist_head cred_free;
	struct hlist_head cred_prepare;
	struct hlist_head cred_transfer;
	struct hlist_head cred_getsecid;
	struct hlist_head kernel_act_as;
	struct hlist_head kernel_create_files_as;
	struct hlist_head kernel_module_request;
	struct hlist_head kernel_load_data;
	struct hlist_head kernel_post_load_data;
	struct hlist_head kernel_read_file;
	struct hlist_head kernel_post_read_file;
	struct hlist_head task_fix_setuid;
	struct hlist_head task_fix_setgid;
	struct hlist_head task_fix_setgroups;
	struct hlist_head task_setpgid;
	struct hlist_head task_getpgid;
	struct hlist_head task_getsid;
	struct hlist_head current_getsecid_subj;
	struct hlist_head task_getsecid_obj;
	struct hlist_head task_setnice;
	struct hlist_head task_setioprio;
	struct hlist_head task_getioprio;
	struct hlist_head task_prlimit;
	struct hlist_head task_setrlimit;
	struct hlist_head task_setscheduler;
	struct hlist_head task_getscheduler;
	struct hlist_head task_movememory;
	struct hlist_head task_kill;
	struct hlist_head task_prctl;
	struct hlist_head task_to_inode;
	struct hlist_head userns_create;
	struct hlist_head ipc_permission;
	struct hlist_head ipc_getsecid;
	struct hlist_head msg_msg_alloc_security;
	struct hlist_head msg_msg_free_security;
	struct hlist_head msg_queue_alloc_security;
	struct hlist_head msg_queue_free_security;
	struct hlist_head msg_queue_associate;
	struct hlist_head msg_queue_msgctl;
	struct hlist_head msg_queue_msgsnd;
	struct hlist_head msg_queue_msgrcv;
	struct hlist_head shm_alloc_security;
	struct hlist_head shm_free_security;
	struct hlist_head shm_associate;
	struct hlist_head shm_shmctl;
	struct hlist_head shm_shmat;
	struct hlist_head sem_alloc_security;
	struct hlist_head sem_free_security;
	struct hlist_head sem_associate;
	struct hlist_head sem_semctl;
	struct hlist_head sem_semop;
	struct hlist_head netlink_send;
	struct hlist_head d_instantiate;
	struct hlist_head getprocattr;
	struct hlist_head setprocattr;
	struct hlist_head ismaclabel;
	struct hlist_head secid_to_secctx;
	struct hlist_head secctx_to_secid;
	struct hlist_head release_secctx;
	struct hlist_head inode_invalidate_secctx;
	struct hlist_head inode_notifysecctx;
	struct hlist_head inode_setsecctx;
	struct hlist_head inode_getsecctx;
	struct hlist_head unix_stream_connect;
	struct hlist_head unix_may_send;
	struct hlist_head socket_create;
	struct hlist_head socket_post_create;
	struct hlist_head socket_socketpair;
	struct hlist_head socket_bind;
	struct hlist_head socket_connect;
	struct hlist_head socket_listen;
	struct hlist_head socket_accept;
	struct hlist_head socket_sendmsg;
	struct hlist_head socket_recvmsg;
	struct hlist_head socket_getsockname;
	struct hlist_head socket_getpeername;
	struct hlist_head socket_getsockopt;
	struct hlist_head socket_setsockopt;
	struct hlist_head socket_shutdown;
	struct hlist_head socket_sock_rcv_skb;
	struct hlist_head socket_getpeersec_stream;
	struct hlist_head socket_getpeersec_dgram;
	struct hlist_head sk_alloc_security;
	struct hlist_head sk_free_security;
	struct hlist_head sk_clone_security;
	struct hlist_head sk_getsecid;
	struct hlist_head sock_graft;
	struct hlist_head inet_conn_request;
	struct hlist_head inet_csk_clone;
	struct hlist_head inet_conn_established;
	struct hlist_head secmark_relabel_packet;
	struct hlist_head secmark_refcount_inc;
	struct hlist_head secmark_refcount_dec;
	struct hlist_head req_classify_flow;
	struct hlist_head tun_dev_alloc_security;
	struct hlist_head tun_dev_free_security;
	struct hlist_head tun_dev_create;
	struct hlist_head tun_dev_attach_queue;
	struct hlist_head tun_dev_attach;
	struct hlist_head tun_dev_open;
	struct hlist_head sctp_assoc_request;
	struct hlist_head sctp_bind_connect;
	struct hlist_head sctp_sk_clone;
	struct hlist_head sctp_assoc_established;
	struct hlist_head mptcp_add_subflow;
	struct hlist_head key_alloc;
	struct hlist_head key_free;
	struct hlist_head key_permission;
	struct hlist_head key_getsecurity;
	struct hlist_head audit_rule_init;
	struct hlist_head audit_rule_known;
	struct hlist_head audit_rule_match;
	struct hlist_head audit_rule_free;
	struct hlist_head bpf;
	struct hlist_head bpf_map;
	struct hlist_head bpf_prog;
	struct hlist_head bpf_map_alloc_security;
	struct hlist_head bpf_map_free_security;
	struct hlist_head bpf_prog_alloc_security;
	struct hlist_head bpf_prog_free_security;
	struct hlist_head locked_down;
	struct hlist_head perf_event_open;
	struct hlist_head perf_event_alloc;
	struct hlist_head perf_event_free;
	struct hlist_head perf_event_read;
	struct hlist_head perf_event_write;
	struct hlist_head uring_override_creds;
	struct hlist_head uring_sqpoll;
	struct hlist_head uring_cmd;
};

struct security_hook_list {
	struct hlist_node list;
	struct hlist_head *head;
	union security_list_options hook;
	const char *lsm;
};

struct lsm_blob_sizes {
	int lbs_cred;
	int lbs_file;
	int lbs_inode;
	int lbs_superblock;
	int lbs_ipc;
	int lbs_msg_msg;
	int lbs_task;
	int lbs_xattr_count;
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

struct lsm_info {
	const char *name;
	enum lsm_order order;
	long unsigned int flags;
	int *enabled;
	int (*init)();
	struct lsm_blob_sizes *blobs;
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO__LAST = 20,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

struct audit_field {
	u32 type;
	union {
		u32 val;
		kuid_t uid;
		kgid_t gid;
		struct {
			char *lsm_str;
			void *lsm_rule;
		};
	};
	u32 op;
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

struct cdev {
	struct kobject kobj;
	struct module *owner;
	const struct file_operations *ops;
	struct list_head list;
	dev_t dev;
	unsigned int count;
};

struct tpm_digest {
	u16 alg_id;
	u8 digest[64];
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum integrity_status {
	INTEGRITY_PASS = 0,
	INTEGRITY_PASS_IMMUTABLE = 1,
	INTEGRITY_FAIL = 2,
	INTEGRITY_FAIL_IMMUTABLE = 3,
	INTEGRITY_NOLABEL = 4,
	INTEGRITY_NOXATTRS = 5,
	INTEGRITY_UNKNOWN = 6,
};

enum evm_ima_xattr_type {
	IMA_XATTR_DIGEST = 1,
	EVM_XATTR_HMAC = 2,
	EVM_IMA_XATTR_DIGSIG = 3,
	IMA_XATTR_DIGEST_NG = 4,
	EVM_XATTR_PORTABLE_DIGSIG = 5,
	IMA_VERITY_DIGSIG = 6,
	IMA_XATTR_LAST = 7,
};

struct evm_ima_xattr_data {
	u8 type;
	u8 data[0];
};

struct ima_digest_data {
	u8 algo;
	u8 length;
	union {
		struct {
			u8 unused;
			u8 type;
		} sha1;
		struct {
			u8 type;
			u8 algo;
		} ng;
		u8 data[2];
	} xattr;
	u8 digest[0];
};

struct ima_max_digest_data {
	struct ima_digest_data hdr;
	u8 digest[64];
};

struct integrity_iint_cache {
	struct rb_node rb_node;
	struct mutex mutex;
	struct inode *inode;
	u64 version;
	long unsigned int flags;
	long unsigned int measured_pcrs;
	long unsigned int atomic_flags;
	enum integrity_status ima_file_status: 4;
	enum integrity_status ima_mmap_status: 4;
	enum integrity_status ima_bprm_status: 4;
	enum integrity_status ima_read_status: 4;
	enum integrity_status ima_creds_status: 4;
	enum integrity_status evm_status: 4;
	struct ima_digest_data *ima_hash;
};

enum ima_show_type {
	IMA_SHOW_BINARY = 0,
	IMA_SHOW_BINARY_NO_FIELD_LEN = 1,
	IMA_SHOW_BINARY_OLD_STRING_FMT = 2,
	IMA_SHOW_ASCII = 3,
};

struct modsig;

struct ima_event_data {
	struct integrity_iint_cache *iint;
	struct file *file;
	const unsigned char *filename;
	struct evm_ima_xattr_data *xattr_value;
	int xattr_len;
	const struct modsig *modsig;
	const char *violation;
	const void *buf;
	int buf_len;
};

struct ima_field_data {
	u8 *data;
	u32 len;
};

struct ima_template_field {
	const char field_id[16];
	int (*field_init)(struct ima_event_data *, struct ima_field_data *);
	void (*field_show)(struct seq_file *, enum ima_show_type, struct ima_field_data *);
};

struct ima_template_desc {
	struct list_head list;
	char *name;
	char *fmt;
	int num_fields;
	const struct ima_template_field **fields;
};

struct ima_template_entry {
	int pcr;
	struct tpm_digest *digests;
	struct ima_template_desc *template_desc;
	u32 template_data_len;
	struct ima_field_data template_data[0];
};

enum ima_hooks {
	NONE = 0,
	FILE_CHECK = 1,
	MMAP_CHECK = 2,
	MMAP_CHECK_REQPROT = 3,
	BPRM_CHECK = 4,
	CREDS_CHECK = 5,
	POST_SETATTR = 6,
	MODULE_CHECK = 7,
	FIRMWARE_CHECK = 8,
	KEXEC_KERNEL_CHECK = 9,
	KEXEC_INITRAMFS_CHECK = 10,
	POLICY_CHECK = 11,
	KEXEC_CMDLINE = 12,
	KEY_CHECK = 13,
	CRITICAL_DATA = 14,
	SETXATTR_CHECK = 15,
	MAX_CHECK = 16,
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct aead_request {
	struct crypto_async_request base;
	unsigned int assoclen;
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	void *__ctx[0];
};

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
	unsigned int dma_flags;
};

struct crypto_istat_aead {
	atomic64_t encrypt_cnt;
	atomic64_t encrypt_tlen;
	atomic64_t decrypt_cnt;
	atomic64_t decrypt_tlen;
	atomic64_t err_cnt;
};

struct crypto_aead;

struct aead_alg {
	int (*setkey)(struct crypto_aead *, const u8 *, unsigned int);
	int (*setauthsize)(struct crypto_aead *, unsigned int);
	int (*encrypt)(struct aead_request *);
	int (*decrypt)(struct aead_request *);
	int (*init)(struct crypto_aead *);
	void (*exit)(struct crypto_aead *);
	unsigned int ivsize;
	unsigned int maxauthsize;
	unsigned int chunksize;
	struct crypto_alg base;
};

struct crypto_aead {
	unsigned int authsize;
	unsigned int reqsize;
	struct crypto_tfm base;
};

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	};
	struct work_struct free_work;
	void *__ctx[0];
};

struct crypto_spawn {
	struct list_head list;
	struct crypto_alg *alg;
	union {
		struct crypto_instance *inst;
		struct crypto_spawn *next;
	};
	const struct crypto_type *frontend;
	u32 mask;
	bool dead;
	bool registered;
};

struct rtattr;

struct crypto_template {
	struct list_head list;
	struct hlist_head instances;
	struct module *module;
	int (*create)(struct crypto_template *, struct rtattr **);
	char name[128];
};

struct aead_instance {
	void (*free)(struct aead_instance *);
	union {
		struct {
			char head[64];
			struct crypto_instance base;
		} s;
		struct aead_alg alg;
	};
};

struct crypto_aead_spawn {
	struct crypto_spawn base;
};

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	struct crypto_alg base;
};

struct shash_alg {
	int (*init)(struct shash_desc *);
	int (*update)(struct shash_desc *, const u8 *, unsigned int);
	int (*final)(struct shash_desc *, u8 *);
	int (*finup)(struct shash_desc *, const u8 *, unsigned int, u8 *);
	int (*digest)(struct shash_desc *, const u8 *, unsigned int, u8 *);
	int (*export)(struct shash_desc *, void *);
	int (*import)(struct shash_desc *, const void *);
	int (*setkey)(struct crypto_shash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_shash *);
	void (*exit_tfm)(struct crypto_shash *);
	int (*clone_tfm)(struct crypto_shash *, struct crypto_shash *);
	unsigned int descsize;
	union {
		struct {
			unsigned int digestsize;
			unsigned int statesize;
			struct crypto_alg base;
		};
		struct hash_alg_common halg;
	};
};

struct sha1_state {
	u32 state[5];
	u64 count;
	u8 buffer[64];
};

typedef void sha1_block_fn(struct sha1_state *, const u8 *, int);

struct sockaddr_alg_new {
	__u16 salg_family;
	__u8 salg_type[14];
	__u32 salg_feat;
	__u32 salg_mask;
	__u8 salg_name[0];
};

struct af_alg_iv {
	__u32 ivlen;
	__u8 iv[0];
};

struct sg_table {
	struct scatterlist *sgl;
	unsigned int nents;
	unsigned int orig_nents;
};

typedef unsigned int iov_iter_extraction_t;

struct cmsghdr {
	__kernel_size_t cmsg_len;
	int cmsg_level;
	int cmsg_type;
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

struct net_proto_family {
	int family;
	int (*create)(struct net *, struct socket *, int, int);
	struct module *owner;
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_MAX_STATES = 13,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
};

struct crypto_wait {
	struct completion completion;
	int err;
};

struct skcipher_request {
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	struct crypto_async_request base;
	void *__ctx[0];
};

struct af_alg_type;

struct alg_sock {
	struct sock sk;
	struct sock *parent;
	atomic_t refcnt;
	atomic_t nokey_refcnt;
	const struct af_alg_type *type;
	void *private;
};

struct af_alg_type {
	void * (*bind)(const char *, u32, u32);
	void (*release)(void *);
	int (*setkey)(void *, const u8 *, unsigned int);
	int (*setentropy)(void *, sockptr_t, unsigned int);
	int (*accept)(void *, struct sock *);
	int (*accept_nokey)(void *, struct sock *);
	int (*setauthsize)(void *, unsigned int);
	struct proto_ops *ops;
	struct proto_ops *ops_nokey;
	struct module *owner;
	char name[14];
};

struct af_alg_control {
	struct af_alg_iv *iv;
	int op;
	unsigned int aead_assoclen;
};

struct af_alg_sgl {
	struct sg_table sgt;
	struct scatterlist sgl[17];
	bool need_unpin;
};

struct af_alg_tsgl {
	struct list_head list;
	unsigned int cur;
	struct scatterlist sg[0];
};

struct af_alg_rsgl {
	struct af_alg_sgl sgl;
	struct list_head list;
	size_t sg_num_bytes;
};

struct af_alg_async_req {
	struct kiocb *iocb;
	struct sock *sk;
	struct af_alg_rsgl first_rsgl;
	struct af_alg_rsgl *last_rsgl;
	struct list_head rsgl_list;
	struct scatterlist *tsgl;
	unsigned int tsgl_entries;
	unsigned int outlen;
	unsigned int areqlen;
	union {
		struct aead_request aead_req;
		struct skcipher_request skcipher_req;
	} cra_u;
};

struct af_alg_ctx {
	struct list_head tsgl_list;
	void *iv;
	size_t aead_assoclen;
	struct crypto_wait wait;
	size_t used;
	atomic_t rcvused;
	bool more;
	bool merge;
	bool enc;
	bool init;
	unsigned int len;
};

struct key_preparsed_payload {
	const char *orig_description;
	char *description;
	union key_payload payload;
	const void *data;
	size_t datalen;
	size_t quotalen;
	time64_t expiry;
};

struct key_match_data {
	bool (*cmp)(const struct key *, const struct key_match_data *);
	const void *raw_data;
	void *preparsed;
	unsigned int lookup_type;
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

struct kernel_pkey_params {
	struct key *key;
	const char *encoding;
	const char *hash_algo;
	char *info;
	__u32 in_len;
	union {
		__u32 out_len;
		__u32 in2_len;
	};
	enum kernel_pkey_operation op: 8;
};

struct user_key_payload {
	struct callback_head rcu;
	short unsigned int datalen;
	long: 0;
	char data[0];
};

struct alg_type_list {
	const struct af_alg_type *type;
	struct list_head list;
};

struct RigidDiskBlock {
	__be32 rdb_ID;
	__be32 rdb_SummedLongs;
	__be32 rdb_ChkSum;
	__be32 rdb_HostID;
	__be32 rdb_BlockBytes;
	__be32 rdb_Flags;
	__be32 rdb_BadBlockList;
	__be32 rdb_PartitionList;
	__be32 rdb_FileSysHeaderList;
	__be32 rdb_DriveInit;
	__be32 rdb_Reserved1[6];
	__be32 rdb_Cylinders;
	__be32 rdb_Sectors;
	__be32 rdb_Heads;
	__be32 rdb_Interleave;
	__be32 rdb_Park;
	__be32 rdb_Reserved2[3];
	__be32 rdb_WritePreComp;
	__be32 rdb_ReducedWrite;
	__be32 rdb_StepRate;
	__be32 rdb_Reserved3[5];
	__be32 rdb_RDBBlocksLo;
	__be32 rdb_RDBBlocksHi;
	__be32 rdb_LoCylinder;
	__be32 rdb_HiCylinder;
	__be32 rdb_CylBlocks;
	__be32 rdb_AutoParkSeconds;
	__be32 rdb_HighRDSKBlock;
	__be32 rdb_Reserved4;
	char rdb_DiskVendor[8];
	char rdb_DiskProduct[16];
	char rdb_DiskRevision[4];
	char rdb_ControllerVendor[8];
	char rdb_ControllerProduct[16];
	char rdb_ControllerRevision[4];
	__be32 rdb_Reserved5[10];
};

struct PartitionBlock {
	__be32 pb_ID;
	__be32 pb_SummedLongs;
	__be32 pb_ChkSum;
	__be32 pb_HostID;
	__be32 pb_Next;
	__be32 pb_Flags;
	__be32 pb_Reserved1[2];
	__be32 pb_DevFlags;
	__u8 pb_DriveName[32];
	__be32 pb_Reserved2[15];
	__be32 pb_Environment[17];
	__be32 pb_EReserved[15];
};

struct io_cq {
	struct request_queue *q;
	struct io_context *ioc;
	union {
		struct list_head q_node;
		struct kmem_cache *__rcu_icq_cache;
	};
	union {
		struct hlist_node ioc_node;
		struct callback_head __rcu_head;
	};
	unsigned int flags;
};

struct sbitmap_word {
	long unsigned int word;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long unsigned int cleared;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct sbitmap {
	unsigned int depth;
	unsigned int shift;
	unsigned int map_nr;
	bool round_robin;
	struct sbitmap_word *map;
	unsigned int *alloc_hint;
};

struct sbq_wait_state {
	wait_queue_head_t wait;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct sbitmap_queue {
	struct sbitmap sb;
	unsigned int wake_batch;
	atomic_t wake_index;
	struct sbq_wait_state *ws;
	atomic_t ws_active;
	unsigned int min_shallow_depth;
	atomic_t completion_cnt;
	atomic_t wakeup_cnt;
};

typedef __u32 req_flags_t;

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

typedef enum rq_end_io_ret rq_end_io_fn(struct request *, blk_status_t);

struct request {
	struct request_queue *q;
	struct blk_mq_ctx *mq_ctx;
	struct blk_mq_hw_ctx *mq_hctx;
	blk_opf_t cmd_flags;
	req_flags_t rq_flags;
	int tag;
	int internal_tag;
	unsigned int timeout;
	unsigned int __data_len;
	sector_t __sector;
	struct bio *bio;
	struct bio *biotail;
	union {
		struct list_head queuelist;
		struct request *rq_next;
	};
	struct block_device *part;
	u64 start_time_ns;
	u64 io_start_time_ns;
	short unsigned int stats_sectors;
	short unsigned int nr_phys_segments;
	short unsigned int ioprio;
	enum mq_rq_state state;
	atomic_t ref;
	long unsigned int deadline;
	union {
		struct hlist_node hash;
		struct llist_node ipi_list;
	};
	union {
		struct rb_node rb_node;
		struct bio_vec special_vec;
	};
	struct {
		struct io_cq *icq;
		void *priv[2];
	} elv;
	struct {
		unsigned int seq;
		rq_end_io_fn *saved_end_io;
	} flush;
	u64 fifo_time;
	rq_end_io_fn *end_io;
	void *end_io_data;
};

struct blk_mq_tags {
	unsigned int nr_tags;
	unsigned int nr_reserved_tags;
	unsigned int active_queues;
	struct sbitmap_queue bitmap_tags;
	struct sbitmap_queue breserved_tags;
	struct request **rqs;
	struct request **static_rqs;
	struct list_head page_list;
	spinlock_t lock;
};

struct blk_flush_queue {
	spinlock_t mq_flush_lock;
	unsigned int flush_pending_idx: 1;
	unsigned int flush_running_idx: 1;
	blk_status_t rq_status;
	long unsigned int flush_pending_since;
	struct list_head flush_queue[2];
	long unsigned int flush_data_in_flight;
	struct request *flush_rq;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
};

struct blk_mq_hw_ctx {
	struct {
		spinlock_t lock;
		struct list_head dispatch;
		long unsigned int state;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct delayed_work run_work;
	cpumask_var_t cpumask;
	int next_cpu;
	int next_cpu_batch;
	long unsigned int flags;
	void *sched_data;
	struct request_queue *queue;
	struct blk_flush_queue *fq;
	void *driver_data;
	struct sbitmap ctx_map;
	struct blk_mq_ctx *dispatch_from;
	unsigned int dispatch_busy;
	short unsigned int type;
	short unsigned int nr_ctx;
	struct blk_mq_ctx **ctxs;
	spinlock_t dispatch_wait_lock;
	wait_queue_entry_t dispatch_wait;
	atomic_t wait_index;
	struct blk_mq_tags *tags;
	struct blk_mq_tags *sched_tags;
	long unsigned int run;
	unsigned int numa_node;
	unsigned int queue_num;
	atomic_t nr_active;
	struct hlist_node cpuhp_online;
	struct hlist_node cpuhp_dead;
	struct kobject kobj;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct list_head hctx_list;
	long: 64;
};

struct blk_mq_queue_data {
	struct request *rq;
	bool last;
};

struct parsed_partitions {
	struct gendisk *disk;
	char name[32];
	struct {
		sector_t from;
		sector_t size;
		int flags;
		bool has_info;
		struct partition_meta_info info;
	} *parts;
	int next;
	int limit;
	bool access_beyond_eod;
	char *pp_buf;
};

typedef struct {
	struct folio *v;
} Sector;

typedef __kernel_clock_t clock_t;

struct sg_io_v4 {
	__s32 guard;
	__u32 protocol;
	__u32 subprotocol;
	__u32 request_len;
	__u64 request;
	__u64 request_tag;
	__u32 request_attr;
	__u32 request_priority;
	__u32 request_extra;
	__u32 max_response_len;
	__u64 response;
	__u32 dout_iovec_count;
	__u32 dout_xfer_len;
	__u32 din_iovec_count;
	__u32 din_xfer_len;
	__u64 dout_xferp;
	__u64 din_xferp;
	__u32 timeout;
	__u32 flags;
	__u64 usr_ptr;
	__u32 spare_in;
	__u32 driver_status;
	__u32 transport_status;
	__u32 device_status;
	__u32 retry_delay;
	__u32 info;
	__u32 duration;
	__u32 response_len;
	__s32 din_resid;
	__s32 dout_resid;
	__u64 generated_tag;
	__u32 spare_out;
	__u32 padding;
};

typedef int bsg_sg_io_fn(struct request_queue *, struct sg_io_v4 *, bool, unsigned int);

struct bsg_device {
	struct request_queue *queue;
	struct device device;
	struct cdev cdev;
	int max_queue;
	unsigned int timeout;
	unsigned int reserved_size;
	bsg_sg_io_fn *sg_io_fn;
};

struct io_uring_cmd {
	struct file *file;
	const struct io_uring_sqe *sqe;
	union {
		void (*task_work_cb)(struct io_uring_cmd *, unsigned int);
		void *cookie;
	};
	u32 cmd_op;
	u32 flags;
	u8 pdu[32];
};

struct io_uring_file_index_range {
	__u32 off;
	__u32 len;
	__u64 resv;
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
};

struct io_cache_entry {
	struct io_wq_work_node node;
};

struct io_rsrc_put {
	u64 tag;
	union {
		void *rsrc;
		struct file *file;
		struct io_mapped_ubuf *buf;
	};
};

struct io_rsrc_node {
	union {
		struct io_cache_entry cache;
		struct io_ring_ctx *ctx;
	};
	int refs;
	bool empty;
	u16 type;
	struct list_head node;
	struct io_rsrc_put item;
};

struct io_mapped_ubuf {
	u64 ubuf;
	u64 ubuf_end;
	unsigned int nr_bvecs;
	long unsigned int acct_pages;
	struct bio_vec bvec[0];
};

struct io_rsrc_data {
	struct io_ring_ctx *ctx;
	u64 **tags;
	unsigned int nr;
	u16 rsrc_type;
	bool quiesce;
};

struct rusage {
	struct __kernel_old_timeval ru_utime;
	struct __kernel_old_timeval ru_stime;
	__kernel_long_t ru_maxrss;
	__kernel_long_t ru_ixrss;
	__kernel_long_t ru_idrss;
	__kernel_long_t ru_isrss;
	__kernel_long_t ru_minflt;
	__kernel_long_t ru_majflt;
	__kernel_long_t ru_nswap;
	__kernel_long_t ru_inblock;
	__kernel_long_t ru_oublock;
	__kernel_long_t ru_msgsnd;
	__kernel_long_t ru_msgrcv;
	__kernel_long_t ru_nsignals;
	__kernel_long_t ru_nvcsw;
	__kernel_long_t ru_nivcsw;
};

struct siginfo {
	union {
		struct {
			int si_signo;
			int si_errno;
			int si_code;
			union __sifields _sifields;
		};
		int _si_pad[32];
	};
};

struct __large_struct {
	long unsigned int buf[100];
};

enum {
	REQ_F_FIXED_FILE = 1,
	REQ_F_IO_DRAIN = 2,
	REQ_F_LINK = 4,
	REQ_F_HARDLINK = 8,
	REQ_F_FORCE_ASYNC = 16,
	REQ_F_BUFFER_SELECT = 32,
	REQ_F_CQE_SKIP = 64,
	REQ_F_FAIL = 256,
	REQ_F_INFLIGHT = 512,
	REQ_F_CUR_POS = 1024,
	REQ_F_NOWAIT = 2048,
	REQ_F_LINK_TIMEOUT = 4096,
	REQ_F_NEED_CLEANUP = 8192,
	REQ_F_POLLED = 16384,
	REQ_F_BUFFER_SELECTED = 32768,
	REQ_F_BUFFER_RING = 65536,
	REQ_F_REISSUE = 131072,
	REQ_F_SUPPORT_NOWAIT = 536870912,
	REQ_F_ISREG = 1073741824,
	REQ_F_CREDS = 262144,
	REQ_F_REFCOUNT = 524288,
	REQ_F_ARM_LTIMEOUT = 1048576,
	REQ_F_ASYNC_DATA = 2097152,
	REQ_F_SKIP_LINK_CQES = 4194304,
	REQ_F_SINGLE_POLL = 8388608,
	REQ_F_DOUBLE_POLL = 16777216,
	REQ_F_PARTIAL_IO = 33554432,
	REQ_F_APOLL_MULTISHOT = 67108864,
	REQ_F_CLEAR_POLLIN = 134217728,
	REQ_F_HASH_LOCKED = 268435456,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_STOP_MULTISHOT = -125,
};

struct io_cancel_data {
	struct io_ring_ctx *ctx;
	union {
		u64 data;
		struct file *file;
	};
	u8 opcode;
	u32 flags;
	int seq;
};

struct waitid_info {
	pid_t pid;
	uid_t uid;
	int status;
	int cause;
};

struct wait_opts {
	enum pid_type wo_type;
	int wo_flags;
	struct pid *wo_pid;
	struct waitid_info *wo_info;
	int wo_stat;
	struct rusage *wo_rusage;
	wait_queue_entry_t child_wait;
	int notask_error;
};

struct io_waitid_async {
	struct io_kiocb *req;
	struct wait_opts wo;
};

struct io_waitid {
	struct file *file;
	int which;
	pid_t upid;
	int options;
	atomic_t refs;
	struct wait_queue_head *head;
	struct siginfo *infop;
	struct waitid_info info;
};

typedef struct {
	__be64 a;
	__be64 b;
} be128;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

struct gf128mul_4k {
	be128 t[256];
};

struct gf128mul_64k {
	struct gf128mul_4k *t[16];
};

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef int mpi_size_t;

typedef mpi_limb_t UWtype;

typedef unsigned int UHWtype;

typedef long unsigned int ulong;

struct gcry_mpi {
	int alloced;
	int nlimbs;
	int nbits;
	int sign;
	unsigned int flags;
	mpi_limb_t *d;
};

typedef struct gcry_mpi *MPI;

enum gcry_mpi_constants {
	MPI_C_ZERO = 0,
	MPI_C_ONE = 1,
	MPI_C_TWO = 2,
	MPI_C_THREE = 3,
	MPI_C_FOUR = 4,
	MPI_C_EIGHT = 5,
};

struct barrett_ctx_s;

typedef struct barrett_ctx_s *mpi_barrett_t;

struct gcry_mpi_point {
	MPI x;
	MPI y;
	MPI z;
};

typedef struct gcry_mpi_point *MPI_POINT;

enum gcry_mpi_ec_models {
	MPI_EC_WEIERSTRASS = 0,
	MPI_EC_MONTGOMERY = 1,
	MPI_EC_EDWARDS = 2,
};

enum ecc_dialects {
	ECC_DIALECT_STANDARD = 0,
	ECC_DIALECT_ED25519 = 1,
	ECC_DIALECT_SAFECURVE = 2,
};

struct mpi_ec_ctx {
	enum gcry_mpi_ec_models model;
	enum ecc_dialects dialect;
	int flags;
	unsigned int nbits;
	MPI p;
	MPI a;
	MPI b;
	MPI_POINT G;
	MPI n;
	unsigned int h;
	MPI_POINT Q;
	MPI d;
	const char *name;
	struct {
		struct {
			unsigned int a_is_pminus3: 1;
			unsigned int two_inv_p: 1;
		} valid;
		int a_is_pminus3;
		MPI two_inv_p;
		mpi_barrett_t p_barrett;
		MPI scratch[11];
	} t;
	void (*addm)(MPI, MPI, MPI, struct mpi_ec_ctx *);
	void (*subm)(MPI, MPI, MPI, struct mpi_ec_ctx *);
	void (*mulm)(MPI, MPI, MPI, struct mpi_ec_ctx *);
	void (*pow2)(MPI, const MPI, struct mpi_ec_ctx *);
	void (*mul2)(MPI, MPI, struct mpi_ec_ctx *);
};

struct field_table {
	const char *p;
	void (*addm)(MPI, MPI, MPI, struct mpi_ec_ctx *);
	void (*subm)(MPI, MPI, MPI, struct mpi_ec_ctx *);
	void (*mulm)(MPI, MPI, MPI, struct mpi_ec_ctx *);
	void (*mul2)(MPI, MPI, struct mpi_ec_ctx *);
	void (*pow2)(MPI, const MPI, struct mpi_ec_ctx *);
};

struct assoc_array_ops {
	long unsigned int (*get_key_chunk)(const void *, int);
	long unsigned int (*get_object_key_chunk)(const void *, int);
	bool (*compare_object)(const void *, const void *);
	int (*diff_objects)(const void *, const void *);
	void (*free_object)(void *);
};

struct assoc_array_node {
	struct assoc_array_ptr *back_pointer;
	u8 parent_slot;
	struct assoc_array_ptr *slots[16];
	long unsigned int nr_leaves_on_branch;
};

struct assoc_array_shortcut {
	struct assoc_array_ptr *back_pointer;
	int parent_slot;
	int skip_to_level;
	struct assoc_array_ptr *next_node;
	long unsigned int index_key[0];
};

struct assoc_array_edit {
	struct callback_head rcu;
	struct assoc_array *array;
	const struct assoc_array_ops *ops;
	const struct assoc_array_ops *ops_for_excised_subtree;
	struct assoc_array_ptr *leaf;
	struct assoc_array_ptr **leaf_p;
	struct assoc_array_ptr *dead_leaf;
	struct assoc_array_ptr *new_meta[3];
	struct assoc_array_ptr *excised_meta[1];
	struct assoc_array_ptr *excised_subtree;
	struct assoc_array_ptr **set_backpointers[16];
	struct assoc_array_ptr *set_backpointers_to;
	struct assoc_array_node *adjust_count_on;
	long int adjust_count_by;
	struct {
		struct assoc_array_ptr **ptr;
		struct assoc_array_ptr *to;
	} set[2];
	struct {
		u8 *p;
		u8 to;
	} set_parent_slot[1];
	u8 segment_cache[17];
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

struct assoc_array_walk_result {
	struct {
		struct assoc_array_node *node;
		int level;
		int slot;
	} terminal_node;
	struct {
		struct assoc_array_shortcut *shortcut;
		int level;
		int sc_level;
		long unsigned int sc_segments;
		long unsigned int dissimilarity;
	} wrong_shortcut;
};

struct assoc_array_delete_collapse_context {
	struct assoc_array_node *node;
	const void *skip_leaf;
	int slot;
};

typedef s16 int16_t;

typedef u8 uint8_t;

typedef u16 uint16_t;

typedef uint8_t BYTE;

typedef uint8_t U8;

typedef uint16_t U16;

typedef int16_t S16;

typedef uint32_t U32;

typedef uint64_t U64;

typedef struct {
	size_t bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef U32 HUF_DTable;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[218];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef U32 rankValCol_t[13];

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[218];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef long unsigned int irq_hw_number_t;

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_PCI_DEVICE_IMS = 15,
};

struct irq_domain_ops;

struct irq_domain_chip_generic;

struct msi_parent_ops;

struct irq_data;

struct irq_domain {
	struct list_head link;
	const char *name;
	const struct irq_domain_ops *ops;
	void *host_data;
	unsigned int flags;
	unsigned int mapcount;
	struct mutex mutex;
	struct irq_domain *root;
	struct fwnode_handle *fwnode;
	enum irq_domain_bus_token bus_token;
	struct irq_domain_chip_generic *gc;
	struct device *dev;
	struct device *pm_dev;
	struct irq_domain *parent;
	const struct msi_parent_ops *msi_parent_ops;
	irq_hw_number_t hwirq_max;
	unsigned int revmap_size;
	struct xarray revmap_tree;
	struct irq_data *revmap[0];
};

struct driver_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device_driver *, char *);
	ssize_t (*store)(struct device_driver *, const char *, size_t);
};

struct msi_dev_domain {
	struct xarray store;
	struct irq_domain *domain;
};

struct platform_msi_priv_data;

struct msi_device_data {
	long unsigned int properties;
	struct platform_msi_priv_data *platform_data;
	struct mutex mutex;
	struct msi_dev_domain __domains[2];
	long unsigned int __iter_idx;
};

struct iopf_device_param;

struct iommu_fault_param;

struct iommu_fwspec;

struct dev_iommu {
	struct mutex lock;
	struct iommu_fault_param *fault_param;
	struct iopf_device_param *iopf_param;
	struct iommu_fwspec *fwspec;
	struct iommu_device *iommu_dev;
	void *priv;
	u32 max_pasids;
	u32 attach_deferred: 1;
	u32 pci_32bit_workaround: 1;
	u32 require_direct: 1;
};

struct irq_affinity_notify {
	unsigned int irq;
	struct kref kref;
	struct work_struct work;
	void (*notify)(struct irq_affinity_notify *, const cpumask_t *);
	void (*release)(struct kref *);
};

struct irq_affinity_desc {
	struct cpumask mask;
	unsigned int is_managed: 1;
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

union msi_instance_cookie {
	u64 value;
	void *ptr;
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

struct pci_sriov {
	int pos;
	int nres;
	u32 cap;
	u16 ctrl;
	u16 total_VFs;
	u16 initial_VFs;
	u16 num_VFs;
	u16 offset;
	u16 stride;
	u16 vf_device;
	u32 pgsz;
	u8 link;
	u8 max_VF_buses;
	u16 driver_max_VFs;
	struct pci_dev *dev;
	struct pci_dev *self;
	u32 class;
	u8 hdr_type;
	u16 subsystem_vendor;
	u16 subsystem_device;
	resource_size_t barsz[6];
	bool drivers_autoprobe;
};

struct rcec_ea {
	u8 nextbusn;
	u8 lastbusn;
	u32 bitmap;
};

typedef void *acpi_handle;

struct acpi_device_status {
	u32 present: 1;
	u32 enabled: 1;
	u32 show_in_ui: 1;
	u32 functional: 1;
	u32 battery_present: 1;
	u32 reserved: 27;
};

struct acpi_device_flags {
	u32 dynamic_status: 1;
	u32 removable: 1;
	u32 ejectable: 1;
	u32 power_manageable: 1;
	u32 match_driver: 1;
	u32 initialized: 1;
	u32 visited: 1;
	u32 hotplug_notify: 1;
	u32 is_dock_station: 1;
	u32 of_compatible_ok: 1;
	u32 coherent_dma: 1;
	u32 cca_seen: 1;
	u32 enumeration_by_parent: 1;
	u32 honor_deps: 1;
	u32 reserved: 18;
};

typedef char acpi_bus_id[8];

struct acpi_pnp_type {
	u32 hardware_id: 1;
	u32 bus_address: 1;
	u32 platform_id: 1;
	u32 backlight: 1;
	u32 reserved: 28;
};

typedef u64 acpi_bus_address;

typedef char acpi_device_name[40];

typedef char acpi_device_class[20];

union acpi_object;

struct acpi_device_pnp {
	acpi_bus_id bus_id;
	int instance_no;
	struct acpi_pnp_type type;
	acpi_bus_address bus_address;
	char *unique_id;
	struct list_head ids;
	acpi_device_name device_name;
	acpi_device_class device_class;
	union acpi_object *str_obj;
};

struct acpi_device_power_flags {
	u32 explicit_get: 1;
	u32 power_resources: 1;
	u32 inrush_current: 1;
	u32 power_removed: 1;
	u32 ignore_parent: 1;
	u32 dsw_present: 1;
	u32 reserved: 26;
};

struct acpi_device_power_state {
	struct {
		u8 valid: 1;
		u8 explicit_set: 1;
		u8 reserved: 6;
	} flags;
	int power;
	int latency;
	struct list_head resources;
};

struct acpi_device_power {
	int state;
	struct acpi_device_power_flags flags;
	struct acpi_device_power_state states[5];
	u8 state_for_enumeration;
};

struct acpi_device_wakeup_flags {
	u8 valid: 1;
	u8 notifier_present: 1;
};

struct acpi_device_wakeup_context {
	void (*func)(struct acpi_device_wakeup_context *);
	struct device *dev;
};

struct acpi_device_wakeup {
	acpi_handle gpe_device;
	u64 gpe_number;
	u64 sleep_state;
	struct list_head resources;
	struct acpi_device_wakeup_flags flags;
	struct acpi_device_wakeup_context context;
	struct wakeup_source *ws;
	int prepare_count;
	int enable_count;
};

struct acpi_device_perf_flags {
	u8 reserved: 8;
};

struct acpi_device_perf_state;

struct acpi_device_perf {
	int state;
	struct acpi_device_perf_flags flags;
	int state_count;
	struct acpi_device_perf_state *states;
};

struct acpi_device_dir {
	struct proc_dir_entry *entry;
};

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
};

struct acpi_scan_handler;

struct acpi_hotplug_context;

struct acpi_gpio_mapping;

struct acpi_device {
	u32 pld_crc;
	int device_type;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct list_head wakeup_list;
	struct list_head del_list;
	struct acpi_device_status status;
	struct acpi_device_flags flags;
	struct acpi_device_pnp pnp;
	struct acpi_device_power power;
	struct acpi_device_wakeup wakeup;
	struct acpi_device_perf performance;
	struct acpi_device_dir dir;
	struct acpi_device_data data;
	struct acpi_scan_handler *handler;
	struct acpi_hotplug_context *hp;
	const struct acpi_gpio_mapping *driver_gpios;
	void *driver_data;
	struct device dev;
	unsigned int physical_node_count;
	unsigned int dep_unmet;
	struct list_head physical_node_list;
	struct mutex physical_node_lock;
	void (*remove)(struct acpi_device *);
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

struct of_phandle_args {
	struct device_node *np;
	int args_count;
	uint32_t args[16];
};

typedef u64 acpi_io_address;

typedef u32 acpi_object_type;

union acpi_object {
	acpi_object_type type;
	struct {
		acpi_object_type type;
		u64 value;
	} integer;
	struct {
		acpi_object_type type;
		u32 length;
		char *pointer;
	} string;
	struct {
		acpi_object_type type;
		u32 length;
		u8 *pointer;
	} buffer;
	struct {
		acpi_object_type type;
		u32 count;
		union acpi_object *elements;
	} package;
	struct {
		acpi_object_type type;
		acpi_object_type actual_type;
		acpi_handle handle;
	} reference;
	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} processor;
	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} power_resource;
};

struct acpi_hotplug_profile {
	struct kobject kobj;
	int (*scan_dependent)(struct acpi_device *);
	void (*notify_online)(struct acpi_device *);
	bool enabled: 1;
	bool demand_offline: 1;
};

struct acpi_scan_handler {
	const struct acpi_device_id *ids;
	struct list_head list_node;
	bool (*match)(const char *, const struct acpi_device_id **);
	int (*attach)(struct acpi_device *, const struct acpi_device_id *);
	void (*detach)(struct acpi_device *);
	void (*bind)(struct device *);
	void (*unbind)(struct device *);
	struct acpi_hotplug_profile hotplug;
};

struct acpi_hotplug_context {
	struct acpi_device *self;
	int (*notify)(struct acpi_device *, u32);
	void (*uevent)(struct acpi_device *, u32);
	void (*fixup)(struct acpi_device *);
};

struct acpi_device_perf_state {
	struct {
		u8 valid: 1;
		u8 reserved: 7;
	} flags;
	u8 power;
	u8 performance;
	int latency;
};

struct acpi_gpio_params;

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
};

struct iommu_fault_unrecoverable {
	__u32 reason;
	__u32 flags;
	__u32 pasid;
	__u32 perm;
	__u64 addr;
	__u64 fetch_addr;
};

struct iommu_fault_page_request {
	__u32 flags;
	__u32 pasid;
	__u32 grpid;
	__u32 perm;
	__u64 addr;
	__u64 private_data[2];
};

struct iommu_fault {
	__u32 type;
	__u32 padding;
	union {
		struct iommu_fault_unrecoverable event;
		struct iommu_fault_page_request prm;
		__u8 padding2[56];
	};
};

enum iommu_page_response_code {
	IOMMU_PAGE_RESP_SUCCESS = 0,
	IOMMU_PAGE_RESP_INVALID = 1,
	IOMMU_PAGE_RESP_FAILURE = 2,
};

struct iommu_page_response {
	__u32 argsz;
	__u32 version;
	__u32 flags;
	__u32 pasid;
	__u32 grpid;
	__u32 code;
};

typedef int (*iommu_fault_handler_t)(struct iommu_domain *, struct device *, long unsigned int, int, void *);

struct iommu_domain_geometry {
	dma_addr_t aperture_start;
	dma_addr_t aperture_end;
	bool force_aperture;
};

struct iommu_dma_cookie;

struct iommu_domain {
	unsigned int type;
	const struct iommu_domain_ops *ops;
	long unsigned int pgsize_bitmap;
	struct iommu_domain_geometry geometry;
	struct iommu_dma_cookie *iova_cookie;
	enum iommu_page_response_code (*iopf_handler)(struct iommu_fault *, void *);
	void *fault_data;
	union {
		struct {
			iommu_fault_handler_t handler;
			void *handler_token;
		};
		struct {
			struct mm_struct *mm;
			int users;
		};
	};
};

typedef int (*iommu_dev_fault_handler_t)(struct iommu_fault *, void *);

struct iommu_iotlb_gather;

struct iommu_domain_ops {
	int (*attach_dev)(struct iommu_domain *, struct device *);
	int (*set_dev_pasid)(struct iommu_domain *, struct device *, ioasid_t);
	int (*map)(struct iommu_domain *, long unsigned int, phys_addr_t, size_t, int, gfp_t);
	int (*map_pages)(struct iommu_domain *, long unsigned int, phys_addr_t, size_t, size_t, int, gfp_t, size_t *);
	size_t (*unmap)(struct iommu_domain *, long unsigned int, size_t, struct iommu_iotlb_gather *);
	size_t (*unmap_pages)(struct iommu_domain *, long unsigned int, size_t, size_t, struct iommu_iotlb_gather *);
	void (*flush_iotlb_all)(struct iommu_domain *);
	void (*iotlb_sync_map)(struct iommu_domain *, long unsigned int, size_t);
	void (*iotlb_sync)(struct iommu_domain *, struct iommu_iotlb_gather *);
	phys_addr_t (*iova_to_phys)(struct iommu_domain *, dma_addr_t);
	bool (*enforce_cache_coherency)(struct iommu_domain *);
	int (*enable_nesting)(struct iommu_domain *);
	int (*set_pgtable_quirks)(struct iommu_domain *, long unsigned int);
	void (*free)(struct iommu_domain *);
};

struct iommu_iotlb_gather {
	long unsigned int start;
	long unsigned int end;
	size_t pgsize;
	struct list_head freelist;
	bool queued;
};

struct iommu_device {
	struct list_head list;
	const struct iommu_ops *ops;
	struct fwnode_handle *fwnode;
	struct device *dev;
	u32 max_pasids;
};

struct iommu_fault_event {
	struct iommu_fault fault;
	struct list_head list;
};

struct iommu_fault_param {
	iommu_dev_fault_handler_t handler;
	void *data;
	struct list_head faults;
	struct mutex lock;
};

struct iommu_fwspec {
	const struct iommu_ops *ops;
	struct fwnode_handle *iommu_fwnode;
	u32 flags;
	unsigned int num_ids;
	u32 ids[0];
};

struct irq_desc;

typedef void (*irq_flow_handler_t)(struct irq_desc *);

struct msi_desc;

struct irq_common_data {
	unsigned int state_use_accessors;
	unsigned int node;
	void *handler_data;
	struct msi_desc *msi_desc;
	cpumask_var_t affinity;
	cpumask_var_t effective_affinity;
};

struct irq_chip;

struct irq_data {
	u32 mask;
	unsigned int irq;
	long unsigned int hwirq;
	struct irq_common_data *common;
	struct irq_chip *chip;
	struct irq_domain *domain;
	struct irq_data *parent_data;
	void *chip_data;
};

struct irq_desc {
	struct irq_common_data irq_common_data;
	struct irq_data irq_data;
	unsigned int *kstat_irqs;
	irq_flow_handler_t handle_irq;
	struct irqaction *action;
	unsigned int status_use_accessors;
	unsigned int core_internal_state__do_not_mess_with_it;
	unsigned int depth;
	unsigned int wake_depth;
	unsigned int tot_count;
	unsigned int irq_count;
	long unsigned int last_unhandled;
	unsigned int irqs_unhandled;
	atomic_t threads_handled;
	int threads_handled_last;
	raw_spinlock_t lock;
	struct cpumask *percpu_enabled;
	const struct cpumask *percpu_affinity;
	const struct cpumask *affinity_hint;
	struct irq_affinity_notify *affinity_notify;
	cpumask_var_t pending_mask;
	long unsigned int threads_oneshot;
	atomic_t threads_active;
	wait_queue_head_t wait_for_threads;
	unsigned int nr_actions;
	unsigned int no_suspend_depth;
	unsigned int cond_suspend_depth;
	unsigned int force_resume_depth;
	struct proc_dir_entry *dir;
	struct callback_head rcu;
	struct kobject kobj;
	struct mutex request_mutex;
	int parent_irq;
	struct module *owner;
	const char *name;
	struct hlist_node resend_node;
	long: 64;
	long: 64;
	long: 64;
};

struct x86_msi_addr_lo {
	union {
		struct {
			u32 reserved_0: 2;
			u32 dest_mode_logical: 1;
			u32 redirect_hint: 1;
			u32 reserved_1: 1;
			u32 virt_destid_8_14: 7;
			u32 destid_0_7: 8;
			u32 base_address: 12;
		};
		struct {
			u32 dmar_reserved_0: 2;
			u32 dmar_index_15: 1;
			u32 dmar_subhandle_valid: 1;
			u32 dmar_format: 1;
			u32 dmar_index_0_14: 15;
			u32 dmar_base_address: 12;
		};
	};
};

typedef struct x86_msi_addr_lo arch_msi_msg_addr_lo_t;

struct x86_msi_addr_hi {
	u32 reserved: 8;
	u32 destid_8_31: 24;
};

typedef struct x86_msi_addr_hi arch_msi_msg_addr_hi_t;

struct x86_msi_data {
	union {
		struct {
			u32 vector: 8;
			u32 delivery_mode: 3;
			u32 dest_mode_logical: 1;
			u32 reserved: 2;
			u32 active_low: 1;
			u32 is_level: 1;
		};
		u32 dmar_subhandle;
	};
};

typedef struct x86_msi_data arch_msi_msg_data_t;

struct msi_msg {
	union {
		u32 address_lo;
		arch_msi_msg_addr_lo_t arch_addr_lo;
	};
	union {
		u32 address_hi;
		arch_msi_msg_addr_hi_t arch_addr_hi;
	};
	union {
		u32 data;
		arch_msi_msg_data_t arch_data;
	};
};

struct pci_msi_desc {
	union {
		u32 msi_mask;
		u32 msix_ctrl;
	};
	struct {
		u8 is_msix: 1;
		u8 multiple: 3;
		u8 multi_cap: 3;
		u8 can_mask: 1;
		u8 is_64: 1;
		u8 is_virtual: 1;
		unsigned int default_irq;
	} msi_attrib;
	union {
		u8 mask_pos;
		void *mask_base;
	};
};

union msi_domain_cookie {
	u64 value;
	void *ptr;
	void *iobase;
};

struct msi_desc_data {
	union msi_domain_cookie dcookie;
	union msi_instance_cookie icookie;
};

struct msi_desc {
	unsigned int irq;
	unsigned int nvec_used;
	struct device *dev;
	struct msi_msg msg;
	struct irq_affinity_desc *affinity;
	const void *iommu_cookie;
	struct device_attribute *sysfs_attrs;
	void (*write_msi_msg)(struct msi_desc *, void *);
	void *write_msi_msg_data;
	u16 msi_index;
	union {
		struct pci_msi_desc pci;
		struct msi_desc_data data;
	};
};

struct irq_chip {
	const char *name;
	unsigned int (*irq_startup)(struct irq_data *);
	void (*irq_shutdown)(struct irq_data *);
	void (*irq_enable)(struct irq_data *);
	void (*irq_disable)(struct irq_data *);
	void (*irq_ack)(struct irq_data *);
	void (*irq_mask)(struct irq_data *);
	void (*irq_mask_ack)(struct irq_data *);
	void (*irq_unmask)(struct irq_data *);
	void (*irq_eoi)(struct irq_data *);
	int (*irq_set_affinity)(struct irq_data *, const struct cpumask *, bool);
	int (*irq_retrigger)(struct irq_data *);
	int (*irq_set_type)(struct irq_data *, unsigned int);
	int (*irq_set_wake)(struct irq_data *, unsigned int);
	void (*irq_bus_lock)(struct irq_data *);
	void (*irq_bus_sync_unlock)(struct irq_data *);
	void (*irq_suspend)(struct irq_data *);
	void (*irq_resume)(struct irq_data *);
	void (*irq_pm_shutdown)(struct irq_data *);
	void (*irq_calc_mask)(struct irq_data *);
	void (*irq_print_chip)(struct irq_data *, struct seq_file *);
	int (*irq_request_resources)(struct irq_data *);
	void (*irq_release_resources)(struct irq_data *);
	void (*irq_compose_msi_msg)(struct irq_data *, struct msi_msg *);
	void (*irq_write_msi_msg)(struct irq_data *, struct msi_msg *);
	int (*irq_get_irqchip_state)(struct irq_data *, enum irqchip_irq_state, bool *);
	int (*irq_set_irqchip_state)(struct irq_data *, enum irqchip_irq_state, bool);
	int (*irq_set_vcpu_affinity)(struct irq_data *, void *);
	void (*ipi_send_single)(struct irq_data *, unsigned int);
	void (*ipi_send_mask)(struct irq_data *, const struct cpumask *);
	int (*irq_nmi_setup)(struct irq_data *);
	void (*irq_nmi_teardown)(struct irq_data *);
	long unsigned int flags;
};

enum irq_alloc_type {
	X86_IRQ_ALLOC_TYPE_IOAPIC = 1,
	X86_IRQ_ALLOC_TYPE_HPET = 2,
	X86_IRQ_ALLOC_TYPE_PCI_MSI = 3,
	X86_IRQ_ALLOC_TYPE_PCI_MSIX = 4,
	X86_IRQ_ALLOC_TYPE_DMAR = 5,
	X86_IRQ_ALLOC_TYPE_AMDVI = 6,
	X86_IRQ_ALLOC_TYPE_UV = 7,
};

struct ioapic_alloc_info {
	int pin;
	int node;
	u32 is_level: 1;
	u32 active_low: 1;
	u32 valid: 1;
};

struct uv_alloc_info {
	int limit;
	int blade;
	long unsigned int offset;
	char *name;
};

struct irq_alloc_info {
	enum irq_alloc_type type;
	u32 flags;
	u32 devid;
	irq_hw_number_t hwirq;
	const struct cpumask *mask;
	struct msi_desc *desc;
	void *data;
	union {
		struct ioapic_alloc_info ioapic;
		struct uv_alloc_info uv;
	};
};

struct irq_chip_regs {
	long unsigned int enable;
	long unsigned int disable;
	long unsigned int mask;
	long unsigned int ack;
	long unsigned int eoi;
	long unsigned int type;
	long unsigned int polarity;
};

struct irq_chip_type {
	struct irq_chip chip;
	struct irq_chip_regs regs;
	irq_flow_handler_t handler;
	u32 type;
	u32 mask_cache_priv;
	u32 *mask_cache;
};

struct irq_chip_generic {
	raw_spinlock_t lock;
	void *reg_base;
	u32 (*reg_readl)(void *);
	void (*reg_writel)(u32, void *);
	void (*suspend)(struct irq_chip_generic *);
	void (*resume)(struct irq_chip_generic *);
	unsigned int irq_base;
	unsigned int irq_cnt;
	u32 mask_cache;
	u32 type_cache;
	u32 polarity_cache;
	u32 wake_enabled;
	u32 wake_active;
	unsigned int num_ct;
	void *private;
	long unsigned int installed;
	long unsigned int unused;
	struct irq_domain *domain;
	struct list_head list;
	struct irq_chip_type chip_types[0];
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

struct irq_domain_chip_generic {
	unsigned int irqs_per_chip;
	unsigned int num_chips;
	unsigned int irq_flags_to_clear;
	unsigned int irq_flags_to_set;
	enum irq_gc_flags gc_flags;
	struct irq_chip_generic *gc[0];
};

struct irq_fwspec {
	struct fwnode_handle *fwnode;
	int param_count;
	u32 param[16];
};

struct irq_domain_ops {
	int (*match)(struct irq_domain *, struct device_node *, enum irq_domain_bus_token);
	int (*select)(struct irq_domain *, struct irq_fwspec *, enum irq_domain_bus_token);
	int (*map)(struct irq_domain *, unsigned int, irq_hw_number_t);
	void (*unmap)(struct irq_domain *, unsigned int);
	int (*xlate)(struct irq_domain *, struct device_node *, const u32 *, unsigned int, long unsigned int *, unsigned int *);
	int (*alloc)(struct irq_domain *, unsigned int, unsigned int, void *);
	void (*free)(struct irq_domain *, unsigned int, unsigned int);
	int (*activate)(struct irq_domain *, struct irq_data *, bool);
	void (*deactivate)(struct irq_domain *, struct irq_data *);
	int (*translate)(struct irq_domain *, struct irq_fwspec *, long unsigned int *, unsigned int *);
};

struct msi_domain_info;

struct msi_parent_ops {
	u32 supported_flags;
	const char *prefix;
	bool (*init_dev_msi_info)(struct device *, struct irq_domain *, struct irq_domain *, struct msi_domain_info *);
};

typedef struct irq_alloc_info msi_alloc_info_t;

struct msi_domain_ops {
	irq_hw_number_t (*get_hwirq)(struct msi_domain_info *, msi_alloc_info_t *);
	int (*msi_init)(struct irq_domain *, struct msi_domain_info *, unsigned int, irq_hw_number_t, msi_alloc_info_t *);
	void (*msi_free)(struct irq_domain *, struct msi_domain_info *, unsigned int);
	int (*msi_prepare)(struct irq_domain *, struct device *, int, msi_alloc_info_t *);
	void (*prepare_desc)(struct irq_domain *, msi_alloc_info_t *, struct msi_desc *);
	void (*set_desc)(msi_alloc_info_t *, struct msi_desc *);
	int (*domain_alloc_irqs)(struct irq_domain *, struct device *, int);
	void (*domain_free_irqs)(struct irq_domain *, struct device *);
	void (*msi_post_free)(struct irq_domain *, struct device *);
};

struct msi_domain_info {
	u32 flags;
	enum irq_domain_bus_token bus_token;
	unsigned int hwsize;
	struct msi_domain_ops *ops;
	struct irq_chip *chip;
	void *chip_data;
	irq_flow_handler_t handler;
	void *handler_data;
	const char *handler_name;
	void *data;
};

struct pcie_device {
	int irq;
	struct pci_dev *port;
	u32 service;
	void *priv_data;
	struct device device;
};

struct pcie_port_service_driver {
	const char *name;
	int (*probe)(struct pcie_device *);
	void (*remove)(struct pcie_device *);
	int (*suspend)(struct pcie_device *);
	int (*resume_noirq)(struct pcie_device *);
	int (*resume)(struct pcie_device *);
	int (*runtime_suspend)(struct pcie_device *);
	int (*runtime_resume)(struct pcie_device *);
	int (*slot_reset)(struct pcie_device *);
	int port_type;
	u32 service;
	struct device_driver driver;
};

struct pci_dynid {
	struct list_head node;
	struct pci_device_id id;
};

struct drv_dev_and_id {
	struct pci_driver *drv;
	struct pci_dev *dev;
	const struct pci_device_id *id;
};

struct pdev_archdata {};

struct platform_device_id {
	char name[20];
	kernel_ulong_t driver_data;
};

struct mfd_cell;

struct platform_device {
	const char *name;
	int id;
	bool id_auto;
	struct device dev;
	u64 platform_dma_mask;
	struct device_dma_parameters dma_parms;
	u32 num_resources;
	struct resource *resource;
	const struct platform_device_id *id_entry;
	const char *driver_override;
	struct mfd_cell *mfd_cell;
	struct pdev_archdata archdata;
};

struct aperture_range {
	struct device *dev;
	resource_size_t base;
	resource_size_t size;
	struct list_head lh;
	void (*detach)(struct device *);
};

typedef unsigned char u_char;

typedef short unsigned int u_short;

struct ld_semaphore {
	atomic_long_t count;
	raw_spinlock_t wait_lock;
	unsigned int wait_readers;
	struct list_head read_wait;
	struct list_head write_wait;
	struct lockdep_map dep_map;
};

typedef unsigned int tcflag_t;

typedef unsigned char cc_t;

typedef unsigned int speed_t;

struct ktermios {
	tcflag_t c_iflag;
	tcflag_t c_oflag;
	tcflag_t c_cflag;
	tcflag_t c_lflag;
	cc_t c_line;
	cc_t c_cc[19];
	speed_t c_ispeed;
	speed_t c_ospeed;
};

struct winsize {
	short unsigned int ws_row;
	short unsigned int ws_col;
	short unsigned int ws_xpixel;
	short unsigned int ws_ypixel;
};

struct tty_port;

struct tty_operations;

struct tty_ldisc;

struct tty_struct {
	struct kref kref;
	int index;
	struct device *dev;
	struct tty_driver *driver;
	struct tty_port *port;
	const struct tty_operations *ops;
	struct tty_ldisc *ldisc;
	struct ld_semaphore ldisc_sem;
	struct mutex atomic_write_lock;
	struct mutex legacy_mutex;
	struct mutex throttle_mutex;
	struct rw_semaphore termios_rwsem;
	struct mutex winsize_mutex;
	struct ktermios termios;
	struct ktermios termios_locked;
	char name[64];
	long unsigned int flags;
	int count;
	unsigned int receive_room;
	struct winsize winsize;
	struct {
		spinlock_t lock;
		bool stopped;
		bool tco_stopped;
		long unsigned int unused[0];
	} flow;
	struct {
		struct pid *pgrp;
		struct pid *session;
		spinlock_t lock;
		unsigned char pktstatus;
		bool packet;
		long unsigned int unused[0];
	} ctrl;
	bool hw_stopped;
	bool closing;
	int flow_change;
	struct tty_struct *link;
	struct fasync_struct *fasync;
	wait_queue_head_t write_wait;
	wait_queue_head_t read_wait;
	struct work_struct hangup_work;
	void *disc_data;
	void *driver_data;
	spinlock_t files_lock;
	int write_cnt;
	unsigned char *write_buf;
	struct list_head tty_files;
	struct work_struct SAK_work;
};

struct fb_fix_screeninfo {
	char id[16];
	long unsigned int smem_start;
	__u32 smem_len;
	__u32 type;
	__u32 type_aux;
	__u32 visual;
	__u16 xpanstep;
	__u16 ypanstep;
	__u16 ywrapstep;
	__u32 line_length;
	long unsigned int mmio_start;
	__u32 mmio_len;
	__u32 accel;
	__u16 capabilities;
	__u16 reserved[2];
};

struct fb_bitfield {
	__u32 offset;
	__u32 length;
	__u32 msb_right;
};

struct fb_var_screeninfo {
	__u32 xres;
	__u32 yres;
	__u32 xres_virtual;
	__u32 yres_virtual;
	__u32 xoffset;
	__u32 yoffset;
	__u32 bits_per_pixel;
	__u32 grayscale;
	struct fb_bitfield red;
	struct fb_bitfield green;
	struct fb_bitfield blue;
	struct fb_bitfield transp;
	__u32 nonstd;
	__u32 activate;
	__u32 height;
	__u32 width;
	__u32 accel_flags;
	__u32 pixclock;
	__u32 left_margin;
	__u32 right_margin;
	__u32 upper_margin;
	__u32 lower_margin;
	__u32 hsync_len;
	__u32 vsync_len;
	__u32 sync;
	__u32 vmode;
	__u32 rotate;
	__u32 colorspace;
	__u32 reserved[4];
};

struct fb_cmap {
	__u32 start;
	__u32 len;
	__u16 *red;
	__u16 *green;
	__u16 *blue;
	__u16 *transp;
};

struct fb_copyarea {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 sx;
	__u32 sy;
};

struct fb_fillrect {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 color;
	__u32 rop;
};

struct fb_image {
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
	__u32 fg_color;
	__u32 bg_color;
	__u8 depth;
	const char *data;
	struct fb_cmap cmap;
};

struct fbcurpos {
	__u16 x;
	__u16 y;
};

struct fb_cursor {
	__u16 set;
	__u16 enable;
	__u16 rop;
	const char *mask;
	struct fbcurpos hot;
	struct fb_image image;
};

struct fb_chroma {
	__u32 redx;
	__u32 greenx;
	__u32 bluex;
	__u32 whitex;
	__u32 redy;
	__u32 greeny;
	__u32 bluey;
	__u32 whitey;
};

struct fb_videomode;

struct fb_monspecs {
	struct fb_chroma chroma;
	struct fb_videomode *modedb;
	__u8 manufacturer[4];
	__u8 monitor[14];
	__u8 serial_no[14];
	__u8 ascii[14];
	__u32 modedb_len;
	__u32 model;
	__u32 serial;
	__u32 year;
	__u32 week;
	__u32 hfmin;
	__u32 hfmax;
	__u32 dclkmin;
	__u32 dclkmax;
	__u16 input;
	__u16 dpms;
	__u16 signal;
	__u16 vfmin;
	__u16 vfmax;
	__u16 gamma;
	__u16 gtf: 1;
	__u16 misc;
	__u8 version;
	__u8 revision;
	__u8 max_x;
	__u8 max_y;
};

struct fb_info;

struct fb_pixmap {
	u8 *addr;
	u32 size;
	u32 offset;
	u32 buf_align;
	u32 scan_align;
	u32 access_align;
	u32 flags;
	u32 blit_x;
	u32 blit_y;
	void (*writeio)(struct fb_info *, void *, void *, unsigned int);
	void (*readio)(struct fb_info *, void *, void *, unsigned int);
};

struct fb_ops;

struct fb_tile_ops;

struct fb_info {
	refcount_t count;
	int node;
	int flags;
	int fbcon_rotate_hint;
	struct mutex lock;
	struct mutex mm_lock;
	struct fb_var_screeninfo var;
	struct fb_fix_screeninfo fix;
	struct fb_monspecs monspecs;
	struct fb_pixmap pixmap;
	struct fb_pixmap sprite;
	struct fb_cmap cmap;
	struct list_head modelist;
	struct fb_videomode *mode;
	const struct fb_ops *fbops;
	struct device *device;
	struct device *dev;
	int class_flag;
	struct fb_tile_ops *tileops;
	union {
		char *screen_base;
		char *screen_buffer;
	};
	long unsigned int screen_size;
	void *pseudo_palette;
	u32 state;
	void *fbcon_par;
	void *par;
	bool skip_vt_switch;
};

struct fb_videomode {
	const char *name;
	u32 refresh;
	u32 xres;
	u32 yres;
	u32 pixclock;
	u32 left_margin;
	u32 right_margin;
	u32 upper_margin;
	u32 lower_margin;
	u32 hsync_len;
	u32 vsync_len;
	u32 sync;
	u32 vmode;
	u32 flag;
};

struct fb_blit_caps {
	u32 x;
	u32 y;
	u32 len;
	u32 flags;
};

struct fb_ops {
	struct module *owner;
	int (*fb_open)(struct fb_info *, int);
	int (*fb_release)(struct fb_info *, int);
	ssize_t (*fb_read)(struct fb_info *, char *, size_t, loff_t *);
	ssize_t (*fb_write)(struct fb_info *, const char *, size_t, loff_t *);
	int (*fb_check_var)(struct fb_var_screeninfo *, struct fb_info *);
	int (*fb_set_par)(struct fb_info *);
	int (*fb_setcolreg)(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int, struct fb_info *);
	int (*fb_setcmap)(struct fb_cmap *, struct fb_info *);
	int (*fb_blank)(int, struct fb_info *);
	int (*fb_pan_display)(struct fb_var_screeninfo *, struct fb_info *);
	void (*fb_fillrect)(struct fb_info *, const struct fb_fillrect *);
	void (*fb_copyarea)(struct fb_info *, const struct fb_copyarea *);
	void (*fb_imageblit)(struct fb_info *, const struct fb_image *);
	int (*fb_cursor)(struct fb_info *, struct fb_cursor *);
	int (*fb_sync)(struct fb_info *);
	int (*fb_ioctl)(struct fb_info *, unsigned int, long unsigned int);
	int (*fb_compat_ioctl)(struct fb_info *, unsigned int, long unsigned int);
	int (*fb_mmap)(struct fb_info *, struct vm_area_struct *);
	void (*fb_get_caps)(struct fb_info *, struct fb_blit_caps *, struct fb_var_screeninfo *);
	void (*fb_destroy)(struct fb_info *);
	int (*fb_debug_enter)(struct fb_info *);
	int (*fb_debug_leave)(struct fb_info *);
};

struct fb_tilemap {
	__u32 width;
	__u32 height;
	__u32 depth;
	__u32 length;
	const __u8 *data;
};

struct fb_tilerect {
	__u32 sx;
	__u32 sy;
	__u32 width;
	__u32 height;
	__u32 index;
	__u32 fg;
	__u32 bg;
	__u32 rop;
};

struct fb_tilearea {
	__u32 sx;
	__u32 sy;
	__u32 dx;
	__u32 dy;
	__u32 width;
	__u32 height;
};

struct fb_tileblit {
	__u32 sx;
	__u32 sy;
	__u32 width;
	__u32 height;
	__u32 fg;
	__u32 bg;
	__u32 length;
	__u32 *indices;
};

struct fb_tilecursor {
	__u32 sx;
	__u32 sy;
	__u32 mode;
	__u32 shape;
	__u32 fg;
	__u32 bg;
};

struct fb_tile_ops {
	void (*fb_settile)(struct fb_info *, struct fb_tilemap *);
	void (*fb_tilecopy)(struct fb_info *, struct fb_tilearea *);
	void (*fb_tilefill)(struct fb_info *, struct fb_tilerect *);
	void (*fb_tileblit)(struct fb_info *, struct fb_tileblit *);
	void (*fb_tilecursor)(struct fb_info *, struct fb_tilecursor *);
	int (*fb_get_tilemax)(struct fb_info *);
};

struct vt_mode {
	char mode;
	char waitv;
	short int relsig;
	short int acqsig;
	short int frsig;
};

struct console_font {
	unsigned int width;
	unsigned int height;
	unsigned int charcount;
	unsigned char *data;
};

struct tty_buffer {
	union {
		struct tty_buffer *next;
		struct llist_node free;
	};
	unsigned int used;
	unsigned int size;
	unsigned int commit;
	unsigned int lookahead;
	unsigned int read;
	bool flags;
	long: 0;
	u8 data[0];
};

struct tty_bufhead {
	struct tty_buffer *head;
	struct work_struct work;
	struct mutex lock;
	atomic_t priority;
	struct tty_buffer sentinel;
	struct llist_head free;
	atomic_t mem_used;
	int mem_limit;
	struct tty_buffer *tail;
};

struct serial_icounter_struct;

struct serial_struct;

struct tty_operations {
	struct tty_struct * (*lookup)(struct tty_driver *, struct file *, int);
	int (*install)(struct tty_driver *, struct tty_struct *);
	void (*remove)(struct tty_driver *, struct tty_struct *);
	int (*open)(struct tty_struct *, struct file *);
	void (*close)(struct tty_struct *, struct file *);
	void (*shutdown)(struct tty_struct *);
	void (*cleanup)(struct tty_struct *);
	ssize_t (*write)(struct tty_struct *, const u8 *, size_t);
	int (*put_char)(struct tty_struct *, u8);
	void (*flush_chars)(struct tty_struct *);
	unsigned int (*write_room)(struct tty_struct *);
	unsigned int (*chars_in_buffer)(struct tty_struct *);
	int (*ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	long int (*compat_ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	void (*set_termios)(struct tty_struct *, const struct ktermios *);
	void (*throttle)(struct tty_struct *);
	void (*unthrottle)(struct tty_struct *);
	void (*stop)(struct tty_struct *);
	void (*start)(struct tty_struct *);
	void (*hangup)(struct tty_struct *);
	int (*break_ctl)(struct tty_struct *, int);
	void (*flush_buffer)(struct tty_struct *);
	void (*set_ldisc)(struct tty_struct *);
	void (*wait_until_sent)(struct tty_struct *, int);
	void (*send_xchar)(struct tty_struct *, char);
	int (*tiocmget)(struct tty_struct *);
	int (*tiocmset)(struct tty_struct *, unsigned int, unsigned int);
	int (*resize)(struct tty_struct *, struct winsize *);
	int (*get_icount)(struct tty_struct *, struct serial_icounter_struct *);
	int (*get_serial)(struct tty_struct *, struct serial_struct *);
	int (*set_serial)(struct tty_struct *, struct serial_struct *);
	void (*show_fdinfo)(struct tty_struct *, struct seq_file *);
	int (*proc_show)(struct seq_file *, void *);
};

struct tty_driver {
	struct kref kref;
	struct cdev **cdevs;
	struct module *owner;
	const char *driver_name;
	const char *name;
	int name_base;
	int major;
	int minor_start;
	unsigned int num;
	short int type;
	short int subtype;
	struct ktermios init_termios;
	long unsigned int flags;
	struct proc_dir_entry *proc_entry;
	struct tty_driver *other;
	struct tty_struct **ttys;
	struct tty_port **ports;
	struct ktermios **termios;
	void *driver_state;
	const struct tty_operations *ops;
	struct list_head tty_drivers;
};

struct tty_port_operations;

struct tty_port_client_operations;

struct tty_port {
	struct tty_bufhead buf;
	struct tty_struct *tty;
	struct tty_struct *itty;
	const struct tty_port_operations *ops;
	const struct tty_port_client_operations *client_ops;
	spinlock_t lock;
	int blocked_open;
	int count;
	wait_queue_head_t open_wait;
	wait_queue_head_t delta_msr_wait;
	long unsigned int flags;
	long unsigned int iflags;
	unsigned char console: 1;
	struct mutex mutex;
	struct mutex buf_mutex;
	unsigned char *xmit_buf;
	struct {
		union {
			struct __kfifo kfifo;
			unsigned char *type;
			const unsigned char *const_type;
			char (*rectype)[0];
			unsigned char *ptr;
			const unsigned char *ptr_const;
		};
		unsigned char buf[0];
	} xmit_fifo;
	unsigned int close_delay;
	unsigned int closing_wait;
	int drain_delay;
	struct kref kref;
	void *client_data;
};

struct tty_ldisc_ops {
	char *name;
	int num;
	int (*open)(struct tty_struct *);
	void (*close)(struct tty_struct *);
	void (*flush_buffer)(struct tty_struct *);
	ssize_t (*read)(struct tty_struct *, struct file *, u8 *, size_t, void **, long unsigned int);
	ssize_t (*write)(struct tty_struct *, struct file *, const u8 *, size_t);
	int (*ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	int (*compat_ioctl)(struct tty_struct *, unsigned int, long unsigned int);
	void (*set_termios)(struct tty_struct *, const struct ktermios *);
	__poll_t (*poll)(struct tty_struct *, struct file *, struct poll_table_struct *);
	void (*hangup)(struct tty_struct *);
	void (*receive_buf)(struct tty_struct *, const u8 *, const u8 *, size_t);
	void (*write_wakeup)(struct tty_struct *);
	void (*dcd_change)(struct tty_struct *, bool);
	size_t (*receive_buf2)(struct tty_struct *, const u8 *, const u8 *, size_t);
	void (*lookahead_buf)(struct tty_struct *, const u8 *, const u8 *, size_t);
	struct module *owner;
};

struct tty_ldisc {
	struct tty_ldisc_ops *ops;
	struct tty_struct *tty;
};

struct tty_port_operations {
	bool (*carrier_raised)(struct tty_port *);
	void (*dtr_rts)(struct tty_port *, bool);
	void (*shutdown)(struct tty_port *);
	int (*activate)(struct tty_port *, struct tty_struct *);
	void (*destruct)(struct tty_port *);
};

struct tty_port_client_operations {
	size_t (*receive_buf)(struct tty_port *, const u8 *, const u8 *, size_t);
	void (*lookahead_buf)(struct tty_port *, const u8 *, const u8 *, size_t);
	void (*write_wakeup)(struct tty_port *);
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

struct vc_state {
	unsigned int x;
	unsigned int y;
	unsigned char color;
	unsigned char Gx_charset[2];
	unsigned int charset: 1;
	enum vc_intensity intensity;
	bool italic;
	bool underline;
	bool blink;
	bool reverse;
};

struct consw;

struct uni_pagedict;

struct vc_data {
	struct tty_port port;
	struct vc_state state;
	struct vc_state saved_state;
	short unsigned int vc_num;
	unsigned int vc_cols;
	unsigned int vc_rows;
	unsigned int vc_size_row;
	unsigned int vc_scan_lines;
	unsigned int vc_cell_height;
	long unsigned int vc_origin;
	long unsigned int vc_scr_end;
	long unsigned int vc_visible_origin;
	unsigned int vc_top;
	unsigned int vc_bottom;
	const struct consw *vc_sw;
	short unsigned int *vc_screenbuf;
	unsigned int vc_screenbuf_size;
	unsigned char vc_mode;
	unsigned char vc_attr;
	unsigned char vc_def_color;
	unsigned char vc_ulcolor;
	unsigned char vc_itcolor;
	unsigned char vc_halfcolor;
	unsigned int vc_cursor_type;
	short unsigned int vc_complement_mask;
	short unsigned int vc_s_complement_mask;
	long unsigned int vc_pos;
	short unsigned int vc_hi_font_mask;
	struct console_font vc_font;
	short unsigned int vc_video_erase_char;
	unsigned int vc_state;
	unsigned int vc_npar;
	unsigned int vc_par[16];
	struct vt_mode vt_mode;
	struct pid *vt_pid;
	int vt_newvt;
	wait_queue_head_t paste_wait;
	unsigned int vc_disp_ctrl: 1;
	unsigned int vc_toggle_meta: 1;
	unsigned int vc_decscnm: 1;
	unsigned int vc_decom: 1;
	unsigned int vc_decawm: 1;
	unsigned int vc_deccm: 1;
	unsigned int vc_decim: 1;
	unsigned int vc_priv: 3;
	unsigned int vc_need_wrap: 1;
	unsigned int vc_can_do_color: 1;
	unsigned int vc_report_mouse: 2;
	unsigned char vc_utf: 1;
	unsigned char vc_utf_count;
	int vc_utf_char;
	long unsigned int vc_tab_stop[4];
	unsigned char vc_palette[48];
	short unsigned int *vc_translate;
	unsigned int vc_resize_user;
	unsigned int vc_bell_pitch;
	unsigned int vc_bell_duration;
	short unsigned int vc_cur_blink_ms;
	struct vc_data **vc_display_fg;
	struct uni_pagedict *uni_pagedict;
	struct uni_pagedict **uni_pagedict_loc;
	u32 **vc_uni_lines;
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

struct consw {
	struct module *owner;
	const char * (*con_startup)();
	void (*con_init)(struct vc_data *, int);
	void (*con_deinit)(struct vc_data *);
	void (*con_clear)(struct vc_data *, int, int, int, int);
	void (*con_putc)(struct vc_data *, int, int, int);
	void (*con_putcs)(struct vc_data *, const short unsigned int *, int, int, int);
	void (*con_cursor)(struct vc_data *, int);
	bool (*con_scroll)(struct vc_data *, unsigned int, unsigned int, enum con_scroll, unsigned int);
	int (*con_switch)(struct vc_data *);
	int (*con_blank)(struct vc_data *, int, int);
	int (*con_font_set)(struct vc_data *, struct console_font *, unsigned int, unsigned int);
	int (*con_font_get)(struct vc_data *, struct console_font *, unsigned int);
	int (*con_font_default)(struct vc_data *, struct console_font *, char *);
	int (*con_resize)(struct vc_data *, unsigned int, unsigned int, unsigned int);
	void (*con_set_palette)(struct vc_data *, const unsigned char *);
	void (*con_scrolldelta)(struct vc_data *, int);
	int (*con_set_origin)(struct vc_data *);
	void (*con_save_screen)(struct vc_data *);
	u8 (*con_build_attr)(struct vc_data *, u8, enum vc_intensity, bool, bool, bool, bool);
	void (*con_invert_region)(struct vc_data *, u16 *, int);
	u16 * (*con_screen_pos)(const struct vc_data *, int);
	long unsigned int (*con_getxy)(struct vc_data *, long unsigned int, int *, int *);
	void (*con_flush_scrollback)(struct vc_data *);
	int (*con_debug_enter)(struct vc_data *);
	int (*con_debug_leave)(struct vc_data *);
};

struct fbcon_display {
	const u_char *fontdata;
	int userfont;
	u_short inverse;
	short int yscroll;
	int vrows;
	int cursor_shape;
	int con_rotate;
	u32 xres_virtual;
	u32 yres_virtual;
	u32 height;
	u32 width;
	u32 bits_per_pixel;
	u32 grayscale;
	u32 nonstd;
	u32 accel_flags;
	u32 rotate;
	struct fb_bitfield red;
	struct fb_bitfield green;
	struct fb_bitfield blue;
	struct fb_bitfield transp;
	const struct fb_videomode *mode;
};

struct fbcon_ops {
	void (*bmove)(struct vc_data *, struct fb_info *, int, int, int, int, int, int);
	void (*clear)(struct vc_data *, struct fb_info *, int, int, int, int);
	void (*putcs)(struct vc_data *, struct fb_info *, const short unsigned int *, int, int, int, int, int);
	void (*clear_margins)(struct vc_data *, struct fb_info *, int, int);
	void (*cursor)(struct vc_data *, struct fb_info *, int, int, int);
	int (*update_start)(struct fb_info *);
	int (*rotate_font)(struct fb_info *, struct vc_data *);
	struct fb_var_screeninfo var;
	struct delayed_work cursor_work;
	struct fb_cursor cursor_state;
	struct fbcon_display *p;
	struct fb_info *info;
	int currcon;
	int cur_blink_jiffies;
	int cursor_flash;
	int cursor_reset;
	int blank_state;
	int graphics;
	int save_graphics;
	bool initialized;
	int rotate;
	int cur_rotate;
	char *cursor_data;
	u8 *fontbuffer;
	u8 *fontdata;
	u8 *cursor_src;
	u32 cursor_size;
	u32 fd_size;
};

typedef u32 acpi_status;

typedef char *acpi_string;

struct acpi_object_list {
	u32 count;
	union acpi_object *pointer;
};

struct acpi_device_physical_node {
	unsigned int node_id;
	struct list_head node;
	struct device *dev;
	bool put_online: 1;
};

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
};

struct find_child_walk_data {
	struct acpi_device *adev;
	u64 address;
	int score;
	bool check_sta;
	bool check_children;
};

typedef struct {
	__u8 b[16];
} guid_t;

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

typedef u64 acpi_size;

struct acpi_buffer {
	acpi_size length;
	void *pointer;
};

typedef void (*acpi_object_handler)(acpi_handle, void *);

struct acpi_hardware_id {
	struct list_head list;
	const char *id;
};

struct acpi_device_properties {
	const guid_t *guid;
	union acpi_object *properties;
	struct list_head list;
	void **bufs;
};

struct acpi_data_node {
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct list_head sibling;
	struct kobject kobj;
	struct completion kobj_done;
};

typedef u64 acpi_physical_address;

typedef u32 acpi_name;

typedef u16 acpi_owner_id;

typedef u32 (*acpi_gpe_handler)(acpi_handle, u32, void *);

typedef void (*acpi_notify_handler)(acpi_handle, u32, void *);

typedef acpi_status (*acpi_exception_handler)(acpi_status, acpi_name, u16, u32, void *);

typedef acpi_status (*acpi_adr_space_handler)(u32, acpi_physical_address, u32, u64 *, void *, void *);

typedef acpi_status (*acpi_adr_space_setup)(acpi_handle, u32, void *, void **);

union acpi_name_union {
	u32 integer;
	char ascii[4];
};

union acpi_operand_object;

struct acpi_namespace_node {
	union acpi_operand_object *object;
	u8 descriptor_type;
	u8 type;
	u16 flags;
	union acpi_name_union name;
	struct acpi_namespace_node *parent;
	struct acpi_namespace_node *child;
	struct acpi_namespace_node *peer;
	acpi_owner_id owner_id;
};

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
};

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
};

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
};

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
};

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
};

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
};

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
};

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
};

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
};

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
};

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
};

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
};

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
};

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
};

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
};

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
	union acpi_operand_object *bank_obj;
};

struct acpi_object_index_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *index_obj;
	union acpi_operand_object *data_obj;
};

struct acpi_object_notify_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	u32 handler_type;
	acpi_notify_handler handler;
	void *context;
	union acpi_operand_object *next[2];
};

struct acpi_object_addr_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	u8 handler_flags;
	acpi_adr_space_handler handler;
	struct acpi_namespace_node *node;
	void *context;
	void *context_mutex;
	acpi_adr_space_setup setup;
	union acpi_operand_object *region_list;
	union acpi_operand_object *next;
};

struct acpi_object_reference {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 class;
	u8 target_type;
	u8 resolved;
	void *object;
	struct acpi_namespace_node *node;
	union acpi_operand_object **where;
	u8 *index_pointer;
	u8 *aml;
	u32 value;
};

struct acpi_object_extra {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *method_REG;
	struct acpi_namespace_node *scope_node;
	void *region_context;
	u8 *aml_start;
	u32 aml_length;
};

struct acpi_object_data {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	acpi_object_handler handler;
	void *pointer;
};

struct acpi_object_cache_list {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *next;
};

union acpi_operand_object {
	struct acpi_object_common common;
	struct acpi_object_integer integer;
	struct acpi_object_string string;
	struct acpi_object_buffer buffer;
	struct acpi_object_package package;
	struct acpi_object_event event;
	struct acpi_object_method method;
	struct acpi_object_mutex mutex;
	struct acpi_object_region region;
	struct acpi_object_notify_common common_notify;
	struct acpi_object_device device;
	struct acpi_object_power_resource power_resource;
	struct acpi_object_processor processor;
	struct acpi_object_thermal_zone thermal_zone;
	struct acpi_object_field_common common_field;
	struct acpi_object_region_field field;
	struct acpi_object_buffer_field buffer_field;
	struct acpi_object_bank_field bank_field;
	struct acpi_object_index_field index_field;
	struct acpi_object_notify_handler notify;
	struct acpi_object_addr_handler address_space;
	struct acpi_object_reference reference;
	struct acpi_object_extra extra;
	struct acpi_object_data data;
	struct acpi_object_cache_list cache;
	struct acpi_namespace_node node;
};

union acpi_parse_object;

union acpi_generic_state;

struct acpi_parse_state {
	u8 *aml_start;
	u8 *aml;
	u8 *aml_end;
	u8 *pkg_start;
	u8 *pkg_end;
	union acpi_parse_object *start_op;
	struct acpi_namespace_node *start_node;
	union acpi_generic_state *scope;
	union acpi_parse_object *start_scope;
	u32 aml_size;
};

typedef acpi_status (*acpi_parse_downwards)(struct acpi_walk_state *, union acpi_parse_object **);

typedef acpi_status (*acpi_parse_upwards)(struct acpi_walk_state *);

struct acpi_opcode_info;

struct acpi_walk_state {
	struct acpi_walk_state *next;
	u8 descriptor_type;
	u8 walk_type;
	u16 opcode;
	u8 next_op_info;
	u8 num_operands;
	u8 operand_index;
	acpi_owner_id owner_id;
	u8 last_predicate;
	u8 current_result;
	u8 return_used;
	u8 scope_depth;
	u8 pass_number;
	u8 namespace_override;
	u8 result_size;
	u8 result_count;
	u8 *aml;
	u32 arg_types;
	u32 method_breakpoint;
	u32 user_breakpoint;
	u32 parse_flags;
	struct acpi_parse_state parser_state;
	u32 prev_arg_types;
	u32 arg_count;
	u16 method_nesting_depth;
	u8 method_is_nested;
	struct acpi_namespace_node arguments[7];
	struct acpi_namespace_node local_variables[8];
	union acpi_operand_object *operands[9];
	union acpi_operand_object **params;
	u8 *aml_last_while;
	union acpi_operand_object **caller_return_desc;
	union acpi_generic_state *control_state;
	struct acpi_namespace_node *deferred_node;
	union acpi_operand_object *implicit_return_obj;
	struct acpi_namespace_node *method_call_node;
	union acpi_parse_object *method_call_op;
	union acpi_operand_object *method_desc;
	struct acpi_namespace_node *method_node;
	char *method_pathname;
	union acpi_parse_object *op;
	const struct acpi_opcode_info *op_info;
	union acpi_parse_object *origin;
	union acpi_operand_object *result_obj;
	union acpi_generic_state *results;
	union acpi_operand_object *return_desc;
	union acpi_generic_state *scope_info;
	union acpi_parse_object *prev_op;
	union acpi_parse_object *next_op;
	struct acpi_thread_state *thread;
	acpi_parse_downwards descending_callback;
	acpi_parse_upwards ascending_callback;
};

struct acpi_name_info {
	char name[4];
	u16 argument_list;
	u8 expected_btypes;
} __attribute__((packed));

struct acpi_package_info {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 object_type2;
	u8 count2;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info2 {
	u8 type;
	u8 count;
	u8 object_type[4];
	u8 reserved;
};

struct acpi_package_info3 {
	u8 type;
	u8 count;
	u8 object_type[2];
	u8 tail_object_type;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info4 {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 sub_object_types;
	u8 pkg_count;
	u16 reserved;
} __attribute__((packed));

union acpi_predefined_info {
	struct acpi_name_info info;
	struct acpi_package_info ret_info;
	struct acpi_package_info2 ret_info2;
	struct acpi_package_info3 ret_info3;
	struct acpi_package_info4 ret_info4;
};

struct acpi_gpe_handler_info {
	acpi_gpe_handler address;
	void *context;
	struct acpi_namespace_node *method_node;
	u8 original_flags;
	u8 originally_enabled;
};

struct acpi_gpe_notify_info {
	struct acpi_namespace_node *device_node;
	struct acpi_gpe_notify_info *next;
};

union acpi_gpe_dispatch_info {
	struct acpi_namespace_node *method_node;
	struct acpi_gpe_handler_info *handler;
	struct acpi_gpe_notify_info *notify_list;
};

struct acpi_gpe_register_info;

struct acpi_gpe_event_info {
	union acpi_gpe_dispatch_info dispatch;
	struct acpi_gpe_register_info *register_info;
	u8 flags;
	u8 gpe_number;
	u8 runtime_count;
	u8 disable_for_dispatch;
};

struct acpi_gpe_address {
	u8 space_id;
	u64 address;
};

struct acpi_gpe_register_info {
	struct acpi_gpe_address status_address;
	struct acpi_gpe_address enable_address;
	u16 base_gpe_number;
	u8 enable_for_wake;
	u8 enable_for_run;
	u8 mask_for_run;
	u8 enable_mask;
};

struct acpi_gpe_xrupt_info;

struct acpi_gpe_block_info {
	struct acpi_namespace_node *node;
	struct acpi_gpe_block_info *previous;
	struct acpi_gpe_block_info *next;
	struct acpi_gpe_xrupt_info *xrupt_block;
	struct acpi_gpe_register_info *register_info;
	struct acpi_gpe_event_info *event_info;
	u64 address;
	u32 register_count;
	u16 gpe_count;
	u16 block_base_number;
	u8 space_id;
	u8 initialized;
};

struct acpi_gpe_xrupt_info {
	struct acpi_gpe_xrupt_info *previous;
	struct acpi_gpe_xrupt_info *next;
	struct acpi_gpe_block_info *gpe_block_list_head;
	u32 interrupt_number;
};

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
};

struct acpi_update_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *object;
};

struct acpi_pkg_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 index;
	union acpi_operand_object *source_object;
	union acpi_operand_object *dest_object;
	struct acpi_walk_state *walk_state;
	void *this_target_obj;
	u32 num_packages;
};

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
};

union acpi_parse_value {
	u64 integer;
	u32 size;
	char *string;
	u8 *buffer;
	char *name;
	union acpi_parse_object *arg;
};

struct acpi_parse_obj_common {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
};

struct acpi_parse_obj_named {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	char *path;
	u8 *data;
	u32 length;
	u32 name;
};

struct acpi_parse_obj_asl {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	union acpi_parse_object *child;
	union acpi_parse_object *parent_method;
	char *filename;
	u8 file_changed;
	char *parent_filename;
	char *external_name;
	char *namepath;
	char name_seg[4];
	u32 extra_value;
	u32 column;
	u32 line_number;
	u32 logical_line_number;
	u32 logical_byte_offset;
	u32 end_line;
	u32 end_logical_line;
	u32 acpi_btype;
	u32 aml_length;
	u32 aml_subtree_length;
	u32 final_aml_length;
	u32 final_aml_offset;
	u32 compile_flags;
	u16 parse_opcode;
	u8 aml_opcode_length;
	u8 aml_pkg_len_bytes;
	u8 extra;
	char parse_op_name[20];
};

union acpi_parse_object {
	struct acpi_parse_obj_common common;
	struct acpi_parse_obj_named named;
	struct acpi_parse_obj_asl asl;
};

struct acpi_scope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	struct acpi_namespace_node *node;
};

struct acpi_pscope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 arg_count;
	union acpi_parse_object *op;
	u8 *arg_end;
	u8 *pkg_end;
	u32 arg_list;
};

struct acpi_thread_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 current_sync_level;
	struct acpi_walk_state *walk_state_list;
	union acpi_operand_object *acquired_mutex_list;
	u64 thread_id;
};

struct acpi_result_values {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *obj_desc[8];
};

struct acpi_global_notify_handler {
	acpi_notify_handler handler;
	void *context;
};

struct acpi_notify_info {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 handler_list_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler_list_head;
	struct acpi_global_notify_handler *global;
};

union acpi_generic_state {
	struct acpi_common_state common;
	struct acpi_control_state control;
	struct acpi_update_state update;
	struct acpi_scope_state scope;
	struct acpi_pscope_state parse_scope;
	struct acpi_pkg_state pkg;
	struct acpi_thread_state thread;
	struct acpi_result_values results;
	struct acpi_notify_info notify;
};

struct acpi_opcode_info {
	u32 parse_args;
	u32 runtime_args;
	u16 flags;
	u8 object_type;
	u8 class;
	u8 type;
};

struct acpi_evaluate_info {
	struct acpi_namespace_node *prefix_node;
	const char *relative_pathname;
	union acpi_operand_object **parameters;
	struct acpi_namespace_node *node;
	union acpi_operand_object *obj_desc;
	char *full_pathname;
	const union acpi_predefined_info *predefined;
	union acpi_operand_object *return_object;
	union acpi_operand_object *parent_package;
	u32 return_flags;
	u32 return_btype;
	u16 param_count;
	u16 node_flags;
	u8 pass_number;
	u8 return_object_type;
	u8 flags;
};

typedef u32 acpi_mutex_handle;

typedef acpi_status (*acpi_table_handler)(u32, void *, void *);

struct acpi_table_header {
	char signature[4];
	u32 length;
	u8 revision;
	u8 checksum;
	char oem_id[6];
	char oem_table_id[8];
	u32 oem_revision;
	char asl_compiler_id[4];
	u32 asl_compiler_revision;
};

struct acpi_table_desc {
	acpi_physical_address address;
	struct acpi_table_header *pointer;
	u32 length;
	union acpi_name_union signature;
	acpi_owner_id owner_id;
	u8 flags;
	u16 validation_count;
};

struct acpi_table_list {
	struct acpi_table_desc *tables;
	u32 current_table_count;
	u32 max_table_count;
	u8 flags;
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
};

union acpi_descriptor {
	struct acpi_common_descriptor common;
	union acpi_operand_object object;
	struct acpi_namespace_node node;
	union acpi_parse_object op;
};

typedef acpi_status (*acpi_pkg_callback)(u8, union acpi_operand_object *, union acpi_generic_state *, void *);

struct acpi_pkg_info {
	u8 *free_space;
	acpi_size length;
	u32 object_space;
	u32 num_packages;
};

struct acpi_fan_fps {
	u64 control;
	u64 trip_point;
	u64 speed;
	u64 noise_level;
	u64 power;
	char name[20];
	struct device_attribute dev_attr;
};

struct acpi_fan_fif {
	u8 revision;
	u8 fine_grain_ctrl;
	u8 step_size;
	u8 low_speed_notification;
};

struct acpi_fan_fst {
	u64 revision;
	u64 control;
	u64 speed;
};

struct thermal_cooling_device;

struct acpi_fan {
	bool acpi4;
	struct acpi_fan_fif fif;
	struct acpi_fan_fps *fps;
	int fps_count;
	struct thermal_cooling_device *cdev;
	struct device_attribute fst_speed;
	struct device_attribute fine_grain_control;
};

struct pnp_device_id {
	__u8 id[8];
	kernel_ulong_t driver_data;
};

struct pnp_card_device_id {
	__u8 id[8];
	kernel_ulong_t driver_data;
	struct {
		__u8 id[8];
	} devs[8];
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

typedef __u32 blk_mq_req_flags_t;

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_BOOT = 30000,
	ATA_TMOUT_BOOT_QUICK = 7000,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_HORKAGE_DIAGNOSTIC = 1,
	ATA_HORKAGE_NODMA = 2,
	ATA_HORKAGE_NONCQ = 4,
	ATA_HORKAGE_MAX_SEC_128 = 8,
	ATA_HORKAGE_BROKEN_HPA = 16,
	ATA_HORKAGE_DISABLE = 32,
	ATA_HORKAGE_HPA_SIZE = 64,
	ATA_HORKAGE_IVB = 256,
	ATA_HORKAGE_STUCK_ERR = 512,
	ATA_HORKAGE_BRIDGE_OK = 1024,
	ATA_HORKAGE_ATAPI_MOD16_DMA = 2048,
	ATA_HORKAGE_FIRMWARE_WARN = 4096,
	ATA_HORKAGE_1_5_GBPS = 8192,
	ATA_HORKAGE_NOSETXFER = 16384,
	ATA_HORKAGE_BROKEN_FPDMA_AA = 32768,
	ATA_HORKAGE_DUMP_ID = 65536,
	ATA_HORKAGE_MAX_SEC_LBA48 = 131072,
	ATA_HORKAGE_ATAPI_DMADIR = 262144,
	ATA_HORKAGE_NO_NCQ_TRIM = 524288,
	ATA_HORKAGE_NOLPM = 1048576,
	ATA_HORKAGE_WD_BROKEN_LPM = 2097152,
	ATA_HORKAGE_ZERO_AFTER_TRIM = 4194304,
	ATA_HORKAGE_NO_DMA_LOG = 8388608,
	ATA_HORKAGE_NOTRIM = 16777216,
	ATA_HORKAGE_MAX_SEC_1024 = 33554432,
	ATA_HORKAGE_MAX_TRIM_128M = 67108864,
	ATA_HORKAGE_NO_NCQ_ON_ATI = 134217728,
	ATA_HORKAGE_NO_ID_DEV_LOG = 268435456,
	ATA_HORKAGE_NO_LOG_DIR = 536870912,
	ATA_HORKAGE_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

struct pnp_protocol;

struct pnp_id;

struct pnp_card {
	struct device dev;
	unsigned char number;
	struct list_head global_list;
	struct list_head protocol_list;
	struct list_head devices;
	struct pnp_protocol *protocol;
	struct pnp_id *id;
	char name[50];
	unsigned char pnpver;
	unsigned char productver;
	unsigned int serial;
	unsigned char checksum;
	struct proc_dir_entry *procdir;
};

struct pnp_dev;

struct pnp_protocol {
	struct list_head protocol_list;
	char *name;
	int (*get)(struct pnp_dev *);
	int (*set)(struct pnp_dev *);
	int (*disable)(struct pnp_dev *);
	bool (*can_wakeup)(struct pnp_dev *);
	int (*suspend)(struct pnp_dev *, pm_message_t);
	int (*resume)(struct pnp_dev *);
	unsigned char number;
	struct device dev;
	struct list_head cards;
	struct list_head devices;
};

struct pnp_id {
	char id[8];
	struct pnp_id *next;
};

struct pnp_card_driver;

struct pnp_card_link {
	struct pnp_card *card;
	struct pnp_card_driver *driver;
	void *driver_data;
	pm_message_t pm_state;
};

struct pnp_driver {
	const char *name;
	const struct pnp_device_id *id_table;
	unsigned int flags;
	int (*probe)(struct pnp_dev *, const struct pnp_device_id *);
	void (*remove)(struct pnp_dev *);
	void (*shutdown)(struct pnp_dev *);
	int (*suspend)(struct pnp_dev *, pm_message_t);
	int (*resume)(struct pnp_dev *);
	struct device_driver driver;
};

struct pnp_card_driver {
	struct list_head global_list;
	char *name;
	const struct pnp_card_device_id *id_table;
	unsigned int flags;
	int (*probe)(struct pnp_card_link *, const struct pnp_card_device_id *);
	void (*remove)(struct pnp_card_link *);
	int (*suspend)(struct pnp_card_link *, pm_message_t);
	int (*resume)(struct pnp_card_link *);
	struct pnp_driver link;
};

struct pnp_dev {
	struct device dev;
	u64 dma_mask;
	unsigned int number;
	int status;
	struct list_head global_list;
	struct list_head protocol_list;
	struct list_head card_list;
	struct list_head rdev_list;
	struct pnp_protocol *protocol;
	struct pnp_card *card;
	struct pnp_driver *driver;
	struct pnp_card_link *card_link;
	struct pnp_id *id;
	int active;
	int capabilities;
	unsigned int num_dependent_sets;
	struct list_head resources;
	struct list_head options;
	char name[50];
	int flags;
	struct proc_dir_entry *procent;
	void *data;
};

struct pnp_port {
	resource_size_t min;
	resource_size_t max;
	resource_size_t align;
	resource_size_t size;
	unsigned char flags;
};

typedef struct {
	long unsigned int bits[4];
} pnp_irq_mask_t;

struct pnp_irq {
	pnp_irq_mask_t map;
	unsigned char flags;
};

struct pnp_dma {
	unsigned char map;
	unsigned char flags;
};

struct pnp_mem {
	resource_size_t min;
	resource_size_t max;
	resource_size_t align;
	resource_size_t size;
	unsigned char flags;
};

struct pnp_option {
	struct list_head list;
	unsigned int flags;
	long unsigned int type;
	union {
		struct pnp_port port;
		struct pnp_irq irq;
		struct pnp_dma dma;
		struct pnp_mem mem;
	} u;
};

struct pnp_resource {
	struct list_head list;
	struct resource res;
};

struct input_id {
	__u16 bustype;
	__u16 vendor;
	__u16 product;
	__u16 version;
};

struct input_absinfo {
	__s32 value;
	__s32 minimum;
	__s32 maximum;
	__s32 fuzz;
	__s32 flat;
	__s32 resolution;
};

struct input_keymap_entry {
	__u8 flags;
	__u8 len;
	__u16 index;
	__u32 keycode;
	__u8 scancode[32];
};

struct ff_replay {
	__u16 length;
	__u16 delay;
};

struct ff_trigger {
	__u16 button;
	__u16 interval;
};

struct ff_envelope {
	__u16 attack_length;
	__u16 attack_level;
	__u16 fade_length;
	__u16 fade_level;
};

struct ff_constant_effect {
	__s16 level;
	struct ff_envelope envelope;
};

struct ff_ramp_effect {
	__s16 start_level;
	__s16 end_level;
	struct ff_envelope envelope;
};

struct ff_condition_effect {
	__u16 right_saturation;
	__u16 left_saturation;
	__s16 right_coeff;
	__s16 left_coeff;
	__u16 deadband;
	__s16 center;
};

struct ff_periodic_effect {
	__u16 waveform;
	__u16 period;
	__s16 magnitude;
	__s16 offset;
	__u16 phase;
	struct ff_envelope envelope;
	__u32 custom_len;
	__s16 *custom_data;
};

struct ff_rumble_effect {
	__u16 strong_magnitude;
	__u16 weak_magnitude;
};

struct ff_effect {
	__u16 type;
	__s16 id;
	__u16 direction;
	struct ff_trigger trigger;
	struct ff_replay replay;
	union {
		struct ff_constant_effect constant;
		struct ff_ramp_effect ramp;
		struct ff_periodic_effect periodic;
		struct ff_condition_effect condition[2];
		struct ff_rumble_effect rumble;
	} u;
};

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block *head;
};

struct input_device_id {
	kernel_ulong_t flags;
	__u16 bustype;
	__u16 vendor;
	__u16 product;
	__u16 version;
	kernel_ulong_t evbit[1];
	kernel_ulong_t keybit[12];
	kernel_ulong_t relbit[1];
	kernel_ulong_t absbit[1];
	kernel_ulong_t mscbit[1];
	kernel_ulong_t ledbit[1];
	kernel_ulong_t sndbit[1];
	kernel_ulong_t ffbit[2];
	kernel_ulong_t swbit[1];
	kernel_ulong_t propbit[1];
	kernel_ulong_t driver_info;
};

struct input_value {
	__u16 type;
	__u16 code;
	__s32 value;
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

struct ff_device;

struct input_dev_poller;

struct input_mt;

struct input_handle;

struct input_dev {
	const char *name;
	const char *phys;
	const char *uniq;
	struct input_id id;
	long unsigned int propbit[1];
	long unsigned int evbit[1];
	long unsigned int keybit[12];
	long unsigned int relbit[1];
	long unsigned int absbit[1];
	long unsigned int mscbit[1];
	long unsigned int ledbit[1];
	long unsigned int sndbit[1];
	long unsigned int ffbit[2];
	long unsigned int swbit[1];
	unsigned int hint_events_per_packet;
	unsigned int keycodemax;
	unsigned int keycodesize;
	void *keycode;
	int (*setkeycode)(struct input_dev *, const struct input_keymap_entry *, unsigned int *);
	int (*getkeycode)(struct input_dev *, struct input_keymap_entry *);
	struct ff_device *ff;
	struct input_dev_poller *poller;
	unsigned int repeat_key;
	struct timer_list timer;
	int rep[2];
	struct input_mt *mt;
	struct input_absinfo *absinfo;
	long unsigned int key[12];
	long unsigned int led[1];
	long unsigned int snd[1];
	long unsigned int sw[1];
	int (*open)(struct input_dev *);
	void (*close)(struct input_dev *);
	int (*flush)(struct input_dev *, struct file *);
	int (*event)(struct input_dev *, unsigned int, unsigned int, int);
	struct input_handle *grab;
	spinlock_t event_lock;
	struct mutex mutex;
	unsigned int users;
	bool going_away;
	struct device dev;
	struct list_head h_list;
	struct list_head node;
	unsigned int num_vals;
	unsigned int max_vals;
	struct input_value *vals;
	bool devres_managed;
	ktime_t timestamp[3];
	bool inhibited;
};

struct ff_device {
	int (*upload)(struct input_dev *, struct ff_effect *, struct ff_effect *);
	int (*erase)(struct input_dev *, int);
	int (*playback)(struct input_dev *, int, int);
	void (*set_gain)(struct input_dev *, u16);
	void (*set_autocenter)(struct input_dev *, u16);
	void (*destroy)(struct ff_device *);
	void *private;
	long unsigned int ffbit[2];
	struct mutex mutex;
	int max_effects;
	struct ff_effect *effects;
	struct file *effect_owners[0];
};

struct input_handler;

struct input_handle {
	void *private;
	int open;
	const char *name;
	struct input_dev *dev;
	struct input_handler *handler;
	struct list_head d_node;
	struct list_head h_node;
};

struct input_handler {
	void *private;
	void (*event)(struct input_handle *, unsigned int, unsigned int, int);
	void (*events)(struct input_handle *, const struct input_value *, unsigned int);
	bool (*filter)(struct input_handle *, unsigned int, unsigned int, int);
	bool (*match)(struct input_handler *, struct input_dev *);
	int (*connect)(struct input_handler *, struct input_dev *, const struct input_device_id *);
	void (*disconnect)(struct input_handle *);
	void (*start)(struct input_handle *);
	bool legacy_minors;
	int minor;
	const char *name;
	const struct input_device_id *id_table;
	struct list_head h_list;
	struct list_head node;
};

struct kbentry {
	unsigned char kb_table;
	unsigned char kb_index;
	short unsigned int kb_value;
};

struct kbsentry {
	unsigned char kb_func;
	unsigned char kb_string[512];
};

struct kbdiacr {
	unsigned char diacr;
	unsigned char base;
	unsigned char result;
};

struct kbdiacrs {
	unsigned int kb_cnt;
	struct kbdiacr kbdiacr[256];
};

struct kbdiacruc {
	unsigned int diacr;
	unsigned int base;
	unsigned int result;
};

struct kbdiacrsuc {
	unsigned int kb_cnt;
	struct kbdiacruc kbdiacruc[256];
};

struct kbkeycode {
	unsigned int scancode;
	unsigned int keycode;
};

struct kbd_repeat {
	int delay;
	int period;
};

struct keyboard_notifier_param {
	struct vc_data *vc;
	int down;
	int shift;
	int ledstate;
	unsigned int value;
};

struct kbd_struct {
	unsigned char lockstate;
	unsigned char slockstate;
	unsigned char ledmode: 1;
	unsigned char ledflagstate: 4;
	char: 3;
	unsigned char default_ledflagstate: 4;
	unsigned char kbdmode: 3;
	int: 1;
	unsigned char modeflags: 5;
};

struct vc {
	struct vc_data *d;
	struct work_struct SAK_work;
};

struct vt_spawn_console {
	spinlock_t lock;
	struct pid *pid;
	int sig;
};

typedef void k_handler_fn(struct vc_data *, unsigned char, char);

typedef void fn_handler_fn(struct vc_data *);

struct getset_keycode_data {
	struct input_keymap_entry ke;
	int error;
};

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_off_t off_t;

enum chipset_type {
	NOT_SUPPORTED = 0,
	SUPPORTED = 1,
};

struct agp_version {
	u16 major;
	u16 minor;
};

struct agp_bridge_data;

struct agp_memory {
	struct agp_memory *next;
	struct agp_memory *prev;
	struct agp_bridge_data *bridge;
	struct page **pages;
	size_t page_count;
	int key;
	int num_scratch_pages;
	off_t pg_start;
	u32 type;
	u32 physical;
	bool is_bound;
	bool is_flushed;
	struct list_head mapped_list;
	struct scatterlist *sg_list;
	int num_sg;
};

struct agp_bridge_driver;

struct agp_bridge_data {
	const struct agp_version *version;
	const struct agp_bridge_driver *driver;
	const struct vm_operations_struct *vm_ops;
	void *previous_size;
	void *current_size;
	void *dev_private_data;
	struct pci_dev *dev;
	u32 *gatt_table;
	u32 *gatt_table_real;
	long unsigned int scratch_page;
	struct page *scratch_page_page;
	dma_addr_t scratch_page_dma;
	long unsigned int gart_bus_addr;
	long unsigned int gatt_bus_addr;
	u32 mode;
	enum chipset_type type;
	long unsigned int *key_list;
	atomic_t current_memory_agp;
	atomic_t agp_in_use;
	int max_memory_agp;
	int aperture_size_idx;
	int capndx;
	int flags;
	char major_version;
	char minor_version;
	struct list_head list;
	u32 apbase_config;
	struct list_head mapped_list;
	spinlock_t mapped_lock;
};

enum aper_size_type {
	U8_APER_SIZE = 0,
	U16_APER_SIZE = 1,
	U32_APER_SIZE = 2,
	LVL2_APER_SIZE = 3,
	FIXED_APER_SIZE = 4,
};

struct gatt_mask {
	long unsigned int mask;
	u32 type;
};

struct agp_bridge_driver {
	struct module *owner;
	const void *aperture_sizes;
	int num_aperture_sizes;
	enum aper_size_type size_type;
	bool cant_use_aperture;
	bool needs_scratch_page;
	const struct gatt_mask *masks;
	int (*fetch_size)();
	int (*configure)();
	void (*agp_enable)(struct agp_bridge_data *, u32);
	void (*cleanup)();
	void (*tlb_flush)(struct agp_memory *);
	long unsigned int (*mask_memory)(struct agp_bridge_data *, dma_addr_t, int);
	void (*cache_flush)();
	int (*create_gatt_table)(struct agp_bridge_data *);
	int (*free_gatt_table)(struct agp_bridge_data *);
	int (*insert_memory)(struct agp_memory *, off_t, int);
	int (*remove_memory)(struct agp_memory *, off_t, int);
	struct agp_memory * (*alloc_by_type)(size_t, int);
	void (*free_by_type)(struct agp_memory *);
	struct page * (*agp_alloc_page)(struct agp_bridge_data *);
	int (*agp_alloc_pages)(struct agp_bridge_data *, struct agp_memory *, size_t);
	void (*agp_destroy_page)(struct page *, int);
	void (*agp_destroy_pages)(struct agp_memory *);
	int (*agp_type_to_mask_type)(struct agp_bridge_data *, int);
};

struct agp_3_5_dev {
	struct list_head list;
	u8 capndx;
	u32 maxbw;
	struct pci_dev *dev;
};

struct isoch_data {
	u32 maxbw;
	u32 n;
	u32 y;
	u32 l;
	u32 rq;
	struct agp_3_5_dev *dev;
};

struct module_version_attribute {
	struct module_attribute mattr;
	const char *module_name;
	const char *version;
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

struct hwrng {
	const char *name;
	int (*init)(struct hwrng *);
	void (*cleanup)(struct hwrng *);
	int (*data_present)(struct hwrng *, int);
	int (*data_read)(struct hwrng *, u32 *);
	int (*read)(struct hwrng *, void *, size_t, bool);
	long unsigned int priv;
	short unsigned int quality;
	struct list_head list;
	struct kref ref;
	struct completion cleanup_done;
	struct completion dying;
};

struct tpm_bank_info {
	u16 alg_id;
	u16 digest_size;
	u16 crypto_id;
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

struct tpm_chip;

struct tpm_class_ops {
	unsigned int flags;
	const u8 req_complete_mask;
	const u8 req_complete_val;
	bool (*req_canceled)(struct tpm_chip *, u8);
	int (*recv)(struct tpm_chip *, u8 *, size_t);
	int (*send)(struct tpm_chip *, u8 *, size_t);
	void (*cancel)(struct tpm_chip *);
	u8 (*status)(struct tpm_chip *);
	void (*update_timeouts)(struct tpm_chip *, long unsigned int *);
	void (*update_durations)(struct tpm_chip *, long unsigned int *);
	int (*go_idle)(struct tpm_chip *);
	int (*cmd_ready)(struct tpm_chip *);
	int (*request_locality)(struct tpm_chip *, int);
	int (*relinquish_locality)(struct tpm_chip *, int);
	void (*clk_enable)(struct tpm_chip *, bool);
};

struct tpm_bios_log {
	void *bios_event_log;
	void *bios_event_log_end;
};

struct tpm_chip_seqops {
	struct tpm_chip *chip;
	const struct seq_operations *seqops;
};

struct tpm_space {
	u32 context_tbl[3];
	u8 *context_buf;
	u32 session_tbl[3];
	u8 *session_buf;
	u32 buf_size;
};

struct tpm_chip {
	struct device dev;
	struct device devs;
	struct cdev cdev;
	struct cdev cdevs;
	struct rw_semaphore ops_sem;
	const struct tpm_class_ops *ops;
	struct tpm_bios_log log;
	struct tpm_chip_seqops bin_log_seqops;
	struct tpm_chip_seqops ascii_log_seqops;
	unsigned int flags;
	int dev_num;
	long unsigned int is_open;
	char hwrng_name[64];
	struct hwrng hwrng;
	struct mutex tpm_mutex;
	long unsigned int timeout_a;
	long unsigned int timeout_b;
	long unsigned int timeout_c;
	long unsigned int timeout_d;
	bool timeout_adjusted;
	long unsigned int duration[4];
	bool duration_adjusted;
	struct dentry *bios_dir[3];
	const struct attribute_group *groups[8];
	unsigned int groups_cnt;
	u32 nr_allocated_banks;
	struct tpm_bank_info *allocated_banks;
	acpi_handle acpi_dev_handle;
	char ppi_version[4];
	struct tpm_space work_space;
	u32 last_cc;
	u32 nr_commands;
	u32 *cc_attrs_tbl;
	int locality;
};

enum tpm2_timeouts {
	TPM2_TIMEOUT_A = 750,
	TPM2_TIMEOUT_B = 2000,
	TPM2_TIMEOUT_C = 200,
	TPM2_TIMEOUT_D = 30,
	TPM2_DURATION_SHORT = 20,
	TPM2_DURATION_MEDIUM = 750,
	TPM2_DURATION_LONG = 2000,
	TPM2_DURATION_LONG_LONG = 300000,
	TPM2_DURATION_DEFAULT = 120000,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed));

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
};

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
};

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
};

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
};

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
};

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} cap_t;

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

enum tis_access {
	TPM_ACCESS_VALID = 128,
	TPM_ACCESS_ACTIVE_LOCALITY = 32,
	TPM_ACCESS_REQUEST_PENDING = 4,
	TPM_ACCESS_REQUEST_USE = 2,
};

enum tis_status {
	TPM_STS_VALID = 128,
	TPM_STS_COMMAND_READY = 64,
	TPM_STS_GO = 32,
	TPM_STS_DATA_AVAIL = 16,
	TPM_STS_DATA_EXPECT = 8,
	TPM_STS_RESPONSE_RETRY = 2,
	TPM_STS_READ_ZERO = 35,
};

enum tis_int_flags {
	TPM_GLOBAL_INT_ENABLE = 2147483648,
	TPM_INTF_BURST_COUNT_STATIC = 256,
	TPM_INTF_CMD_READY_INT = 128,
	TPM_INTF_INT_EDGE_FALLING = 64,
	TPM_INTF_INT_EDGE_RISING = 32,
	TPM_INTF_INT_LEVEL_LOW = 16,
	TPM_INTF_INT_LEVEL_HIGH = 8,
	TPM_INTF_LOCALITY_CHANGE_INT = 4,
	TPM_INTF_STS_VALID_INT = 2,
	TPM_INTF_DATA_AVAIL_INT = 1,
};

enum tis_defaults {
	TIS_MEM_LEN = 20480,
	TIS_SHORT_TIMEOUT = 750,
	TIS_LONG_TIMEOUT = 2000,
	TIS_TIMEOUT_MIN_ATML = 14700,
	TIS_TIMEOUT_MAX_ATML = 15000,
};

enum tpm_tis_flags {
	TPM_TIS_ITPM_WORKAROUND = 0,
	TPM_TIS_INVALID_STATUS = 1,
	TPM_TIS_DEFAULT_CANCELLATION = 2,
	TPM_TIS_IRQ_TESTED = 3,
};

struct tpm_tis_phy_ops;

struct tpm_tis_data {
	struct tpm_chip *chip;
	u16 manufacturer_id;
	struct mutex locality_count_mutex;
	unsigned int locality_count;
	int locality;
	int irq;
	struct work_struct free_irq_work;
	long unsigned int last_unhandled_irq;
	unsigned int unhandled_irqs;
	unsigned int int_mask;
	long unsigned int flags;
	void *ilb_base_addr;
	u16 clkrun_enabled;
	wait_queue_head_t int_queue;
	wait_queue_head_t read_queue;
	const struct tpm_tis_phy_ops *phy_ops;
	short unsigned int rng_quality;
	unsigned int timeout_min;
	unsigned int timeout_max;
};

enum tpm_tis_io_mode {
	TPM_TIS_PHYS_8 = 0,
	TPM_TIS_PHYS_16 = 1,
	TPM_TIS_PHYS_32 = 2,
};

struct tpm_tis_phy_ops {
	int (*read_bytes)(struct tpm_tis_data *, u32, u16, u8 *, enum tpm_tis_io_mode);
	int (*write_bytes)(struct tpm_tis_data *, u32, u16, const u8 *, enum tpm_tis_io_mode);
	int (*verify_crc)(struct tpm_tis_data *, size_t, const u8 *);
};

struct tis_vendor_durations_override {
	u32 did_vid;
	struct tpm1_version version;
	long unsigned int durations[3];
};

struct tis_vendor_timeout_override {
	u32 did_vid;
	long unsigned int timeout_us[4];
};

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
};

struct klist_node {
	void *n_klist;
	struct list_head n_node;
	struct kref n_ref;
};

struct driver_private {
	struct kobject kobj;
	struct klist klist_devices;
	struct klist_node knode_bus;
	struct module_kobject *mkobj;
	struct device_driver *driver;
};

struct device_private {
	struct klist klist_children;
	struct klist_node knode_parent;
	struct klist_node knode_driver;
	struct klist_node knode_bus;
	struct klist_node knode_class;
	struct list_head deferred_probe;
	struct device_driver *async_driver;
	char *deferred_probe_reason;
	struct device *device;
	u8 dead: 1;
};

struct cpu {
	int node_id;
	int hotpluggable;
	struct device dev;
};

typedef u32 note_buf_t[92];

struct cpu_attr {
	struct device_attribute attr;
	const struct cpumask * const map;
};

struct wake_irq {
	struct device *dev;
	unsigned int status;
	int irq;
	const char *name;
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

struct device_link {
	struct device *supplier;
	struct list_head s_node;
	struct device *consumer;
	struct list_head c_node;
	struct device link_dev;
	enum device_link_state status;
	u32 flags;
	refcount_t rpm_active;
	struct kref kref;
	struct work_struct rm_work;
	bool supplier_preactivated;
};

typedef int (*pm_callback_t)(struct device *);

struct dma_fence_ops;

struct dma_fence {
	spinlock_t *lock;
	const struct dma_fence_ops *ops;
	union {
		struct list_head cb_list;
		ktime_t timestamp;
		struct callback_head rcu;
	};
	u64 context;
	u64 seqno;
	long unsigned int flags;
	struct kref refcount;
	int error;
};

struct dma_fence_ops {
	bool use_64bit_seqno;
	const char * (*get_driver_name)(struct dma_fence *);
	const char * (*get_timeline_name)(struct dma_fence *);
	bool (*enable_signaling)(struct dma_fence *);
	bool (*signaled)(struct dma_fence *);
	long int (*wait)(struct dma_fence *, bool, long int);
	void (*release)(struct dma_fence *);
	void (*fence_value_str)(struct dma_fence *, char *, int);
	void (*timeline_value_str)(struct dma_fence *, char *, int);
	void (*set_deadline)(struct dma_fence *, ktime_t);
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

struct dma_fence_cb;

typedef void (*dma_fence_func_t)(struct dma_fence *, struct dma_fence_cb *);

struct dma_fence_cb {
	struct list_head node;
	dma_fence_func_t func;
};

struct dma_fence_chain {
	struct dma_fence base;
	struct dma_fence *prev;
	u64 prev_seqno;
	struct dma_fence *fence;
	union {
		struct dma_fence_cb cb;
		struct irq_work work;
	};
	spinlock_t lock;
};

typedef __u16 __sum16;

struct class_attribute {
	struct attribute attr;
	ssize_t (*show)(const struct class *, const struct class_attribute *, char *);
	ssize_t (*store)(const struct class *, const struct class_attribute *, const char *, size_t);
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	NETIF_F_LLTX_BIT = 12,
	NETIF_F_NETNS_LOCAL_BIT = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	NETIF_F_FCOE_MTU_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

struct ethhdr {
	unsigned char h_dest[6];
	unsigned char h_source[6];
	__be16 h_proto;
};

struct flow_dissector_key_control {
	u16 thoff;
	u16 addr_type;
	u32 flags;
};

struct flow_dissector_key_basic {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
};

struct flow_dissector_key_tags {
	u32 flow_label;
};

struct flow_dissector_key_vlan {
	union {
		struct {
			u16 vlan_id: 12;
			u16 vlan_dei: 1;
			u16 vlan_priority: 3;
		};
		__be16 vlan_tci;
	};
	__be16 vlan_tpid;
	__be16 vlan_eth_type;
	u16 padding;
};

struct flow_dissector_key_keyid {
	__be32 keyid;
};

struct flow_dissector_key_ipv4_addrs {
	__be32 src;
	__be32 dst;
};

struct flow_dissector_key_ipv6_addrs {
	struct in6_addr src;
	struct in6_addr dst;
};

struct flow_dissector_key_tipc {
	__be32 key;
};

struct flow_dissector_key_addrs {
	union {
		struct flow_dissector_key_ipv4_addrs v4addrs;
		struct flow_dissector_key_ipv6_addrs v6addrs;
		struct flow_dissector_key_tipc tipckey;
	};
};

struct flow_dissector_key_ports {
	union {
		__be32 ports;
		struct {
			__be16 src;
			__be16 dst;
		};
	};
};

struct flow_dissector_key_icmp {
	struct {
		u8 type;
		u8 code;
	};
	u16 id;
};

struct flow_dissector_key {
	enum flow_dissector_key_id key_id;
	size_t offset;
};

struct flow_dissector {
	long long unsigned int used_keys;
	short unsigned int offset[33];
};

struct flow_keys {
	struct flow_dissector_key_control control;
	struct flow_dissector_key_basic basic;
	struct flow_dissector_key_tags tags;
	struct flow_dissector_key_vlan vlan;
	struct flow_dissector_key_vlan cvlan;
	struct flow_dissector_key_keyid keyid;
	struct flow_dissector_key_ports ports;
	struct flow_dissector_key_icmp icmp;
	struct flow_dissector_key_addrs addrs;
	long: 0;
};

typedef struct bio_vec skb_frag_t;

struct skb_shared_info {
	__u8 flags;
	__u8 meta_len;
	__u8 nr_frags;
	__u8 tx_flags;
	short unsigned int gso_size;
	short unsigned int gso_segs;
	struct sk_buff *frag_list;
	struct skb_shared_hwtstamps hwtstamps;
	unsigned int gso_type;
	u32 tskey;
	atomic_t dataref;
	unsigned int xdp_frags_size;
	void *destructor_arg;
	skb_frag_t frags[17];
};

struct icmpv6_mib_device {
	atomic_long_t mibs[7];
};

struct icmpv6msg_mib_device {
	atomic_long_t mibs[512];
};

struct ipv4_devconf {
	void *sysctl;
	int data[33];
	long unsigned int state[1];
};

struct ip_ra_chain {
	struct ip_ra_chain *next;
	struct sock *sk;
	union {
		void (*destructor)(struct sock *);
		struct sock *saved_sk;
	};
	struct callback_head rcu;
};

struct fib_table {
	struct hlist_node tb_hlist;
	u32 tb_id;
	int tb_num_default;
	struct callback_head rcu;
	long unsigned int *tb_data;
	long unsigned int __data[0];
};

struct inet_peer_base {
	struct rb_root rb_root;
	seqlock_t lock;
	int total;
};

struct icmpv6_echo {
	__be16 identifier;
	__be16 sequence;
};

struct icmpv6_nd_advt {
	__u32 reserved: 5;
	__u32 override: 1;
	__u32 solicited: 1;
	__u32 router: 1;
	__u32 reserved2: 24;
};

struct icmpv6_nd_ra {
	__u8 hop_limit;
	__u8 reserved: 3;
	__u8 router_pref: 2;
	__u8 home_agent: 1;
	__u8 other: 1;
	__u8 managed: 1;
	__be16 rt_lifetime;
};

struct icmp6hdr {
	__u8 icmp6_type;
	__u8 icmp6_code;
	__sum16 icmp6_cksum;
	union {
		__be32 un_data32[1];
		__be16 un_data16[2];
		__u8 un_data8[4];
		struct icmpv6_echo u_echo;
		struct icmpv6_nd_advt u_nd_advt;
		struct icmpv6_nd_ra u_nd_ra;
	} icmp6_dataun;
};

struct ipv6_stable_secret {
	bool initialized;
	struct in6_addr secret;
};

struct ipv6_devconf {
	__s32 forwarding;
	__s32 hop_limit;
	__s32 mtu6;
	__s32 accept_ra;
	__s32 accept_redirects;
	__s32 autoconf;
	__s32 dad_transmits;
	__s32 rtr_solicits;
	__s32 rtr_solicit_interval;
	__s32 rtr_solicit_max_interval;
	__s32 rtr_solicit_delay;
	__s32 force_mld_version;
	__s32 mldv1_unsolicited_report_interval;
	__s32 mldv2_unsolicited_report_interval;
	__s32 use_tempaddr;
	__s32 temp_valid_lft;
	__s32 temp_prefered_lft;
	__s32 regen_max_retry;
	__s32 max_desync_factor;
	__s32 max_addresses;
	__s32 accept_ra_defrtr;
	__u32 ra_defrtr_metric;
	__s32 accept_ra_min_hop_limit;
	__s32 accept_ra_min_lft;
	__s32 accept_ra_pinfo;
	__s32 ignore_routes_with_linkdown;
	__s32 accept_ra_rtr_pref;
	__s32 rtr_probe_interval;
	__s32 accept_ra_rt_info_min_plen;
	__s32 accept_ra_rt_info_max_plen;
	__s32 proxy_ndp;
	__s32 accept_source_route;
	__s32 accept_ra_from_local;
	__s32 disable_ipv6;
	__s32 drop_unicast_in_l2_multicast;
	__s32 accept_dad;
	__s32 force_tllao;
	__s32 ndisc_notify;
	__s32 suppress_frag_ndisc;
	__s32 accept_ra_mtu;
	__s32 drop_unsolicited_na;
	__s32 accept_untracked_na;
	struct ipv6_stable_secret stable_secret;
	__s32 use_oif_addrs_only;
	__s32 keep_addr_on_down;
	__s32 seg6_enabled;
	__u32 enhanced_dad;
	__u32 addr_gen_mode;
	__s32 disable_policy;
	__s32 ndisc_tclass;
	__s32 rpl_seg_enabled;
	__u32 ioam6_id;
	__u32 ioam6_id_wide;
	__u8 ioam6_enabled;
	__u8 ndisc_evict_nocarrier;
	__u8 ra_honor_pio_life;
	struct ctl_table_header *sysctl_header;
};

struct rt6key {
	struct in6_addr addr;
	int plen;
};

struct rtable;

struct fnhe_hash_bucket;

struct fib_nh_common {
	struct net_device *nhc_dev;
	netdevice_tracker nhc_dev_tracker;
	int nhc_oif;
	unsigned char nhc_scope;
	u8 nhc_family;
	u8 nhc_gw_family;
	unsigned char nhc_flags;
	struct lwtunnel_state *nhc_lwtstate;
	union {
		__be32 ipv4;
		struct in6_addr ipv6;
	} nhc_gw;
	int nhc_weight;
	atomic_t nhc_upper_bound;
	struct rtable **nhc_pcpu_rth_output;
	struct rtable *nhc_rth_input;
	struct fnhe_hash_bucket *nhc_exceptions;
};

struct rt6_exception_bucket;

struct fib6_nh {
	struct fib_nh_common nh_common;
	long unsigned int last_probe;
	struct rt6_info **rt6i_pcpu;
	struct rt6_exception_bucket *rt6i_exception_bucket;
};

struct fib6_node;

struct dst_metrics;

struct nexthop;

struct fib6_info {
	struct fib6_table *fib6_table;
	struct fib6_info *fib6_next;
	struct fib6_node *fib6_node;
	union {
		struct list_head fib6_siblings;
		struct list_head nh_list;
	};
	unsigned int fib6_nsiblings;
	refcount_t fib6_ref;
	long unsigned int expires;
	struct hlist_node gc_link;
	struct dst_metrics *fib6_metrics;
	struct rt6key fib6_dst;
	u32 fib6_flags;
	struct rt6key fib6_src;
	struct rt6key fib6_prefsrc;
	u32 fib6_metric;
	u8 fib6_protocol;
	u8 fib6_type;
	u8 offload;
	u8 trap;
	u8 offload_failed;
	u8 should_flush: 1;
	u8 dst_nocount: 1;
	u8 dst_nopolicy: 1;
	u8 fib6_destroying: 1;
	u8 unused: 4;
	struct callback_head rcu;
	struct nexthop *nh;
	struct fib6_nh fib6_nh[0];
};

struct rt6_info {
	struct dst_entry dst;
	struct fib6_info *from;
	int sernum;
	struct rt6key rt6i_dst;
	struct rt6key rt6i_src;
	struct in6_addr rt6i_gateway;
	struct inet6_dev *rt6i_idev;
	u32 rt6i_flags;
	short unsigned int rt6i_nfheader_len;
};

struct rt6_statistics {
	__u32 fib_nodes;
	__u32 fib_route_nodes;
	__u32 fib_rt_entries;
	__u32 fib_rt_cache;
	__u32 fib_discarded_routes;
	atomic_t fib_rt_alloc;
};

struct fib6_node {
	struct fib6_node *parent;
	struct fib6_node *left;
	struct fib6_node *right;
	struct fib6_node *subtree;
	struct fib6_info *leaf;
	__u16 fn_bit;
	__u16 fn_flags;
	int fn_sernum;
	struct fib6_info *rr_ptr;
	struct callback_head rcu;
};

struct fib6_table {
	struct hlist_node tb6_hlist;
	u32 tb6_id;
	spinlock_t tb6_lock;
	struct fib6_node tb6_root;
	struct inet_peer_base tb6_peers;
	unsigned int flags;
	unsigned int fib_seq;
	struct hlist_head tb6_gc_hlist;
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_RAW = 255,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

struct in_addr {
	__be32 s_addr;
};

struct ip_mreqn {
	struct in_addr imr_multiaddr;
	struct in_addr imr_address;
	int imr_ifindex;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

struct xfrm_id {
	xfrm_address_t daddr;
	__be32 spi;
	__u8 proto;
};

struct xfrm_sec_ctx {
	__u8 ctx_doi;
	__u8 ctx_alg;
	__u16 ctx_len;
	__u32 ctx_sid;
	char ctx_str[0];
};

struct xfrm_selector {
	xfrm_address_t daddr;
	xfrm_address_t saddr;
	__be16 dport;
	__be16 dport_mask;
	__be16 sport;
	__be16 sport_mask;
	__u16 family;
	__u8 prefixlen_d;
	__u8 prefixlen_s;
	__u8 proto;
	int ifindex;
	__kernel_uid32_t user;
};

struct xfrm_lifetime_cfg {
	__u64 soft_byte_limit;
	__u64 hard_byte_limit;
	__u64 soft_packet_limit;
	__u64 hard_packet_limit;
	__u64 soft_add_expires_seconds;
	__u64 hard_add_expires_seconds;
	__u64 soft_use_expires_seconds;
	__u64 hard_use_expires_seconds;
};

struct xfrm_lifetime_cur {
	__u64 bytes;
	__u64 packets;
	__u64 add_time;
	__u64 use_time;
};

struct xfrm_replay_state {
	__u32 oseq;
	__u32 seq;
	__u32 bitmap;
};

struct xfrm_replay_state_esn {
	unsigned int bmp_len;
	__u32 oseq;
	__u32 seq;
	__u32 oseq_hi;
	__u32 seq_hi;
	__u32 replay_window;
	__u32 bmp[0];
};

struct xfrm_algo {
	char alg_name[64];
	unsigned int alg_key_len;
	char alg_key[0];
};

struct xfrm_algo_auth {
	char alg_name[64];
	unsigned int alg_key_len;
	unsigned int alg_trunc_len;
	char alg_key[0];
};

struct xfrm_algo_aead {
	char alg_name[64];
	unsigned int alg_key_len;
	unsigned int alg_icv_len;
	char alg_key[0];
};

struct xfrm_stats {
	__u32 replay_window;
	__u32 replay;
	__u32 integrity_failed;
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

struct xfrm_encap_tmpl {
	__u16 encap_type;
	__be16 encap_sport;
	__be16 encap_dport;
	xfrm_address_t encap_oa;
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	__XFRMA_MAX = 33,
};

struct xfrm_mark {
	__u32 v;
	__u32 m;
};

struct xfrm_address_filter {
	xfrm_address_t saddr;
	xfrm_address_t daddr;
	__u16 family;
	__u8 splen;
	__u8 dplen;
};

struct net_generic {
	union {
		struct {
			unsigned int len;
			struct callback_head rcu;
		} s;
		struct {
			struct {} __empty_ptr;
			void *ptr[0];
		};
	};
};

struct pernet_operations {
	struct list_head list;
	int (*init)(struct net *);
	void (*pre_exit)(struct net *);
	void (*exit)(struct net *);
	void (*exit_batch)(struct list_head *);
	unsigned int *id;
	size_t size;
};

struct ifbond {
	__s32 bond_mode;
	__s32 num_slaves;
	__s32 miimon;
};

typedef struct ifbond ifbond;

struct ifslave {
	__s32 slave_id;
	char slave_name[16];
	__s8 link;
	__s8 state;
	__u32 link_failure_count;
};

typedef struct ifslave ifslave;

struct ad_info {
	__u16 aggregator_id;
	__u16 ports;
	__u16 actor_key;
	__u16 partner_key;
	__u8 partner_system[6];
};

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

struct in_ifaddr;

struct ip_mc_list;

struct in_device {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	refcount_t refcnt;
	int dead;
	struct in_ifaddr *ifa_list;
	struct ip_mc_list *mc_list;
	struct ip_mc_list **mc_hash;
	int mc_count;
	spinlock_t mc_tomb_lock;
	struct ip_mc_list *mc_tomb;
	long unsigned int mr_v1_seen;
	long unsigned int mr_v2_seen;
	long unsigned int mr_maxdelay;
	long unsigned int mr_qi;
	long unsigned int mr_qri;
	unsigned char mr_qrv;
	unsigned char mr_gq_running;
	u32 mr_ifc_count;
	struct timer_list mr_gq_timer;
	struct timer_list mr_ifc_timer;
	struct neigh_parms *arp_parms;
	struct ipv4_devconf cnf;
	struct callback_head callback_head;
};

struct ipv6_devstat {
	struct proc_dir_entry *proc_dir_entry;
	struct ipstats_mib *ipv6;
	struct icmpv6_mib_device *icmpv6dev;
	struct icmpv6msg_mib_device *icmpv6msgdev;
};

struct ifmcaddr6;

struct ifacaddr6;

struct inet6_dev {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct list_head addr_list;
	struct ifmcaddr6 *mc_list;
	struct ifmcaddr6 *mc_tomb;
	unsigned char mc_qrv;
	unsigned char mc_gq_running;
	unsigned char mc_ifc_count;
	unsigned char mc_dad_count;
	long unsigned int mc_v1_seen;
	long unsigned int mc_qi;
	long unsigned int mc_qri;
	long unsigned int mc_maxdelay;
	struct delayed_work mc_gq_work;
	struct delayed_work mc_ifc_work;
	struct delayed_work mc_dad_work;
	struct delayed_work mc_query_work;
	struct delayed_work mc_report_work;
	struct sk_buff_head mc_query_queue;
	struct sk_buff_head mc_report_queue;
	spinlock_t mc_query_lock;
	spinlock_t mc_report_lock;
	struct mutex mc_lock;
	struct ifacaddr6 *ac_list;
	rwlock_t lock;
	refcount_t refcnt;
	__u32 if_flags;
	int dead;
	u32 desync_factor;
	struct list_head tempaddr_list;
	struct in6_addr token;
	struct neigh_parms *nd_parms;
	struct ipv6_devconf cnf;
	struct ipv6_devstat stats;
	struct timer_list rs_timer;
	__s32 rs_interval;
	__u8 rs_probes;
	long unsigned int tstamp;
	struct callback_head rcu;
	unsigned int ra_mtu;
};

struct gpio_desc;

struct reset_control;

struct mii_bus;

struct mdio_device {
	struct device dev;
	struct mii_bus *bus;
	char modalias[32];
	int (*bus_match)(struct device *, struct device_driver *);
	void (*device_free)(struct mdio_device *);
	void (*device_remove)(struct mdio_device *);
	int addr;
	int flags;
	struct gpio_desc *reset_gpio;
	struct reset_control *reset_ctrl;
	unsigned int reset_assert_delay;
	unsigned int reset_deassert_delay;
};

struct phy_c45_device_ids {
	u32 devices_in_package;
	u32 mmds_present;
	u32 device_ids[32];
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_MAX = 33,
} phy_interface_t;

struct phylink;

struct pse_control;

struct phy_driver;

struct phy_package_shared;

struct mii_timestamper;

struct phy_device {
	struct mdio_device mdio;
	struct phy_driver *drv;
	struct device_link *devlink;
	u32 phy_id;
	struct phy_c45_device_ids c45_ids;
	unsigned int is_c45: 1;
	unsigned int is_internal: 1;
	unsigned int is_pseudo_fixed_link: 1;
	unsigned int is_gigabit_capable: 1;
	unsigned int has_fixups: 1;
	unsigned int suspended: 1;
	unsigned int suspended_by_mdio_bus: 1;
	unsigned int sysfs_links: 1;
	unsigned int loopback_enabled: 1;
	unsigned int downshifted_rate: 1;
	unsigned int is_on_sfp_module: 1;
	unsigned int mac_managed_pm: 1;
	unsigned int wol_enabled: 1;
	unsigned int autoneg: 1;
	unsigned int link: 1;
	unsigned int autoneg_complete: 1;
	unsigned int interrupts: 1;
	unsigned int irq_suspended: 1;
	unsigned int irq_rerun: 1;
	int rate_matching;
	enum phy_state state;
	u32 dev_flags;
	phy_interface_t interface;
	int speed;
	int duplex;
	int port;
	int pause;
	int asym_pause;
	u8 master_slave_get;
	u8 master_slave_set;
	u8 master_slave_state;
	long unsigned int supported[2];
	long unsigned int advertising[2];
	long unsigned int lp_advertising[2];
	long unsigned int adv_old[2];
	long unsigned int supported_eee[2];
	long unsigned int advertising_eee[2];
	bool eee_enabled;
	long unsigned int host_interfaces[1];
	u32 eee_broken_modes;
	struct list_head leds;
	int irq;
	void *priv;
	struct phy_package_shared *shared;
	struct sk_buff *skb;
	void *ehdr;
	struct nlattr *nest;
	struct delayed_work state_queue;
	struct mutex lock;
	bool sfp_bus_attached;
	struct sfp_bus *sfp_bus;
	struct phylink *phylink;
	struct net_device *attached_dev;
	struct mii_timestamper *mii_ts;
	struct pse_control *psec;
	u8 mdix;
	u8 mdix_ctrl;
	int pma_extable;
	unsigned int link_down_events;
	void (*phy_link_change)(struct phy_device *, bool);
	void (*adjust_link)(struct net_device *);
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

struct netdev_lag_upper_info {
	enum netdev_lag_tx_type tx_type;
	enum netdev_lag_hash hash_type;
};

struct netdev_lag_lower_state_info {
	u8 link_up: 1;
	u8 tx_enabled: 1;
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

struct netdev_notifier_info {
	struct net_device *dev;
	struct netlink_ext_ack *extack;
};

struct netdev_nested_priv {
	unsigned char flags;
	void *data;
};

struct netdev_bonding_info {
	ifslave slave;
	ifbond master;
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

struct vlan_ethhdr {
	union {
		struct {
			unsigned char h_dest[6];
			unsigned char h_source[6];
		};
		struct {
			unsigned char h_dest[6];
			unsigned char h_source[6];
		} addrs;
	};
	__be16 h_vlan_proto;
	__be16 h_vlan_TCI;
	__be16 h_vlan_encapsulated_proto;
};

struct qdisc_walker {
	int stop;
	int skip;
	int count;
	int (*fn)(struct Qdisc *, long unsigned int, struct qdisc_walker *);
};

struct qdisc_skb_cb {
	struct {
		unsigned int pkt_len;
		u16 slave_dev_queue_mapping;
		u16 tc_classid;
	};
	unsigned char data[20];
};

struct iphdr {
	__u8 ihl: 4;
	__u8 version: 4;
	__u8 tos;
	__be16 tot_len;
	__be16 id;
	__be16 frag_off;
	__u8 ttl;
	__u8 protocol;
	__sum16 check;
	union {
		struct {
			__be32 saddr;
			__be32 daddr;
		};
		struct {
			__be32 saddr;
			__be32 daddr;
		} addrs;
	};
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

struct xfrm_state_walk {
	struct list_head all;
	u8 state;
	u8 dying;
	u8 proto;
	u32 seq;
	struct xfrm_address_filter *filter;
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

struct xfrm_dev_offload {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	struct net_device *real_dev;
	long unsigned int offload_handle;
	u8 dir: 2;
	u8 type: 2;
	u8 flags: 2;
};

struct xfrm_mode {
	u8 encap;
	u8 family;
	u8 flags;
};

struct xfrm_type;

struct xfrm_type_offload;

struct xfrm_state {
	possible_net_t xs_net;
	union {
		struct hlist_node gclist;
		struct hlist_node bydst;
	};
	struct hlist_node bysrc;
	struct hlist_node byspi;
	struct hlist_node byseq;
	refcount_t refcnt;
	spinlock_t lock;
	struct xfrm_id id;
	struct xfrm_selector sel;
	struct xfrm_mark mark;
	u32 if_id;
	u32 tfcpad;
	u32 genid;
	struct xfrm_state_walk km;
	struct {
		u32 reqid;
		u8 mode;
		u8 replay_window;
		u8 aalgo;
		u8 ealgo;
		u8 calgo;
		u8 flags;
		u16 family;
		xfrm_address_t saddr;
		int header_len;
		int trailer_len;
		u32 extra_flags;
		struct xfrm_mark smark;
	} props;
	struct xfrm_lifetime_cfg lft;
	struct xfrm_algo_auth *aalg;
	struct xfrm_algo *ealg;
	struct xfrm_algo *calg;
	struct xfrm_algo_aead *aead;
	const char *geniv;
	__be16 new_mapping_sport;
	u32 new_mapping;
	u32 mapping_maxage;
	struct xfrm_encap_tmpl *encap;
	struct sock *encap_sk;
	xfrm_address_t *coaddr;
	struct xfrm_state *tunnel;
	atomic_t tunnel_users;
	struct xfrm_replay_state replay;
	struct xfrm_replay_state_esn *replay_esn;
	struct xfrm_replay_state preplay;
	struct xfrm_replay_state_esn *preplay_esn;
	enum xfrm_replay_mode repl_mode;
	u32 xflags;
	u32 replay_maxage;
	u32 replay_maxdiff;
	struct timer_list rtimer;
	struct xfrm_stats stats;
	struct xfrm_lifetime_cur curlft;
	struct hrtimer mtimer;
	struct xfrm_dev_offload xso;
	long int saved_tmo;
	time64_t lastused;
	struct page_frag xfrag;
	const struct xfrm_type *type;
	struct xfrm_mode inner_mode;
	struct xfrm_mode inner_mode_iaf;
	struct xfrm_mode outer_mode;
	const struct xfrm_type_offload *type_offload;
	struct xfrm_sec_ctx *security;
	void *data;
};

struct lwtunnel_state {
	__u16 type;
	__u16 flags;
	__u16 headroom;
	atomic_t refcnt;
	int (*orig_output)(struct net *, struct sock *, struct sk_buff *);
	int (*orig_input)(struct sk_buff *);
	struct callback_head rcu;
	__u8 data[0];
};

struct dst_metrics {
	u32 metrics[17];
	refcount_t refcnt;
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_LAST = 65536,
	SOF_TIMESTAMPING_MASK = 131071,
};

struct hwtstamp_config {
	int flags;
	int tx_type;
	int rx_filter;
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

struct xfrm_policy_walk_entry {
	struct list_head all;
	u8 dead;
};

struct xfrm_policy_queue {
	struct sk_buff_head hold_queue;
	struct timer_list hold_timer;
	long unsigned int timeout;
};

struct xfrm_tmpl {
	struct xfrm_id id;
	xfrm_address_t saddr;
	short unsigned int encap_family;
	u32 reqid;
	u8 mode;
	u8 share;
	u8 optional;
	u8 allalgs;
	u32 aalgos;
	u32 ealgos;
	u32 calgos;
};

struct xfrm_policy {
	possible_net_t xp_net;
	struct hlist_node bydst;
	struct hlist_node byidx;
	rwlock_t lock;
	refcount_t refcnt;
	u32 pos;
	struct timer_list timer;
	atomic_t genid;
	u32 priority;
	u32 index;
	u32 if_id;
	struct xfrm_mark mark;
	struct xfrm_selector selector;
	struct xfrm_lifetime_cfg lft;
	struct xfrm_lifetime_cur curlft;
	struct xfrm_policy_walk_entry walk;
	struct xfrm_policy_queue polq;
	bool bydst_reinsert;
	u8 type;
	u8 action;
	u8 flags;
	u8 xfrm_nr;
	u16 family;
	struct xfrm_sec_ctx *security;
	struct xfrm_tmpl xfrm_vec[6];
	struct hlist_node bydst_inexact_list;
	struct callback_head rcu;
	struct xfrm_dev_offload xdo;
};

struct request_sock_ops {
	int family;
	unsigned int obj_size;
	struct kmem_cache *slab;
	char *slab_name;
	int (*rtx_syn_ack)(const struct sock *, struct request_sock *);
	void (*send_ack)(const struct sock *, struct sk_buff *, struct request_sock *);
	void (*send_reset)(const struct sock *, struct sk_buff *);
	void (*destructor)(struct request_sock *);
	void (*syn_ack_timeout)(const struct request_sock *);
};

struct timewait_sock_ops {
	struct kmem_cache *twsk_slab;
	char *twsk_slab_name;
	unsigned int twsk_obj_size;
	int (*twsk_unique)(struct sock *, struct sock *, void *);
	void (*twsk_destructor)(struct sock *);
};

struct saved_syn {
	u32 mac_hdrlen;
	u32 network_hdrlen;
	u32 tcp_hdrlen;
	u8 data[0];
};

struct ip_options {
	__be32 faddr;
	__be32 nexthop;
	unsigned char optlen;
	unsigned char srr;
	unsigned char rr;
	unsigned char ts;
	unsigned char is_strictroute: 1;
	unsigned char srr_is_hit: 1;
	unsigned char is_changed: 1;
	unsigned char rr_needaddr: 1;
	unsigned char ts_needtime: 1;
	unsigned char ts_needaddr: 1;
	unsigned char router_alert;
	unsigned char cipso;
	unsigned char __pad2;
	unsigned char __data[0];
};

struct ip_options_rcu {
	struct callback_head rcu;
	struct ip_options opt;
};

struct ipv6_opt_hdr;

struct ipv6_rt_hdr;

struct ipv6_txoptions {
	refcount_t refcnt;
	int tot_len;
	__u16 opt_flen;
	__u16 opt_nflen;
	struct ipv6_opt_hdr *hopopt;
	struct ipv6_opt_hdr *dst0opt;
	struct ipv6_rt_hdr *srcrt;
	struct ipv6_opt_hdr *dst1opt;
	struct callback_head rcu;
};

struct inet_cork {
	unsigned int flags;
	__be32 addr;
	struct ip_options *opt;
	unsigned int fragsize;
	int length;
	struct dst_entry *dst;
	u8 tx_flags;
	__u8 ttl;
	__s16 tos;
	char priority;
	__u16 gso_size;
	u64 transmit_time;
	u32 mark;
};

struct inet_cork_full {
	struct inet_cork base;
	struct flowi fl;
};

struct ipv6_pinfo;

struct ip_mc_socklist;

struct inet_sock {
	struct sock sk;
	struct ipv6_pinfo *pinet6;
	long unsigned int inet_flags;
	__be32 inet_saddr;
	__s16 uc_ttl;
	__be16 inet_sport;
	struct ip_options_rcu *inet_opt;
	atomic_t inet_id;
	__u8 tos;
	__u8 min_ttl;
	__u8 mc_ttl;
	__u8 pmtudisc;
	__u8 rcv_tos;
	__u8 convert_csum;
	int uc_index;
	int mc_index;
	__be32 mc_addr;
	struct {
		__u16 lo;
		__u16 hi;
	} local_port_range;
	struct ip_mc_socklist *mc_list;
	struct inet_cork_full cork;
};

struct in6_pktinfo {
	struct in6_addr ipi6_addr;
	int ipi6_ifindex;
};

struct inet6_cork {
	struct ipv6_txoptions *opt;
	u8 hop_limit;
	u8 tclass;
};

struct ipv6_mc_socklist;

struct ipv6_ac_socklist;

struct ipv6_fl_socklist;

struct ipv6_pinfo {
	struct in6_addr saddr;
	struct in6_pktinfo sticky_pktinfo;
	const struct in6_addr *daddr_cache;
	const struct in6_addr *saddr_cache;
	__be32 flow_label;
	__u32 frag_size;
	s16 hop_limit;
	u8 mcast_hops;
	int ucast_oif;
	int mcast_oif;
	union {
		struct {
			__u16 srcrt: 1;
			__u16 osrcrt: 1;
			__u16 rxinfo: 1;
			__u16 rxoinfo: 1;
			__u16 rxhlim: 1;
			__u16 rxohlim: 1;
			__u16 hopopts: 1;
			__u16 ohopopts: 1;
			__u16 dstopts: 1;
			__u16 odstopts: 1;
			__u16 rxflow: 1;
			__u16 rxtclass: 1;
			__u16 rxpmtu: 1;
			__u16 rxorigdstaddr: 1;
			__u16 recvfragsize: 1;
		} bits;
		__u16 all;
	} rxopt;
	__u8 srcprefs;
	__u8 pmtudisc;
	__u8 min_hopcount;
	__u8 tclass;
	__be32 rcv_flowinfo;
	__u32 dst_cookie;
	struct ipv6_mc_socklist *ipv6_mc_list;
	struct ipv6_ac_socklist *ipv6_ac_list;
	struct ipv6_fl_socklist *ipv6_fl_list;
	struct ipv6_txoptions *opt;
	struct sk_buff *pktoptions;
	struct sk_buff *rxpmtu;
	struct inet6_cork cork;
};

struct ip_sf_socklist;

struct ip_mc_socklist {
	struct ip_mc_socklist *next_rcu;
	struct ip_mreqn multi;
	unsigned int sfmode;
	struct ip_sf_socklist *sflist;
	struct callback_head rcu;
};

struct ipv6_rt_hdr {
	__u8 nexthdr;
	__u8 hdrlen;
	__u8 type;
	__u8 segments_left;
};

struct ipv6_opt_hdr {
	__u8 nexthdr;
	__u8 hdrlen;
};

struct ipv6hdr {
	__u8 priority: 4;
	__u8 version: 4;
	__u8 flow_lbl[3];
	__be16 payload_len;
	__u8 nexthdr;
	__u8 hop_limit;
	union {
		struct {
			struct in6_addr saddr;
			struct in6_addr daddr;
		};
		struct {
			struct in6_addr saddr;
			struct in6_addr daddr;
		} addrs;
	};
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

struct ip6_sf_socklist;

struct ipv6_mc_socklist {
	struct in6_addr addr;
	int ifindex;
	unsigned int sfmode;
	struct ipv6_mc_socklist *next;
	struct ip6_sf_socklist *sflist;
	struct callback_head rcu;
};

struct ipv6_ac_socklist {
	struct in6_addr acl_addr;
	int acl_ifindex;
	struct ipv6_ac_socklist *acl_next;
};

struct ip6_flowlabel;

struct ipv6_fl_socklist {
	struct ipv6_fl_socklist *next;
	struct ip6_flowlabel *fl;
	struct callback_head rcu;
};

struct ip6_sf_socklist {
	unsigned int sl_max;
	unsigned int sl_count;
	struct callback_head rcu;
	struct in6_addr sl_addr[0];
};

struct ip6_sf_list {
	struct ip6_sf_list *sf_next;
	struct in6_addr sf_addr;
	long unsigned int sf_count[2];
	unsigned char sf_gsresp;
	unsigned char sf_oldin;
	unsigned char sf_crcount;
	struct callback_head rcu;
};

struct ifmcaddr6 {
	struct in6_addr mca_addr;
	struct inet6_dev *idev;
	struct ifmcaddr6 *next;
	struct ip6_sf_list *mca_sources;
	struct ip6_sf_list *mca_tomb;
	unsigned int mca_sfmode;
	unsigned char mca_crcount;
	long unsigned int mca_sfcount[2];
	struct delayed_work mca_work;
	unsigned int mca_flags;
	int mca_users;
	refcount_t mca_refcnt;
	long unsigned int mca_cstamp;
	long unsigned int mca_tstamp;
	struct callback_head rcu;
};

struct ifacaddr6 {
	struct in6_addr aca_addr;
	struct fib6_info *aca_rt;
	struct ifacaddr6 *aca_next;
	struct hlist_node aca_addr_lst;
	int aca_users;
	refcount_t aca_refcnt;
	long unsigned int aca_cstamp;
	long unsigned int aca_tstamp;
	struct callback_head rcu;
};

struct ip6_flowlabel {
	struct ip6_flowlabel *next;
	__be32 label;
	atomic_t users;
	struct in6_addr dst;
	struct ipv6_txoptions *opt;
	long unsigned int linger;
	struct callback_head rcu;
	u8 share;
	union {
		struct pid *pid;
		kuid_t uid;
	} owner;
	long unsigned int lastuse;
	long unsigned int expires;
	struct net *fl_net;
};

struct fib_nh_exception {
	struct fib_nh_exception *fnhe_next;
	int fnhe_genid;
	__be32 fnhe_daddr;
	u32 fnhe_pmtu;
	bool fnhe_mtu_locked;
	__be32 fnhe_gw;
	long unsigned int fnhe_expires;
	struct rtable *fnhe_rth_input;
	struct rtable *fnhe_rth_output;
	long unsigned int fnhe_stamp;
	struct callback_head rcu;
};

struct rtable {
	struct dst_entry dst;
	int rt_genid;
	unsigned int rt_flags;
	__u16 rt_type;
	__u8 rt_is_input;
	__u8 rt_uses_gateway;
	int rt_iif;
	u8 rt_gw_family;
	union {
		__be32 rt_gw4;
		struct in6_addr rt_gw6;
	};
	u32 rt_mtu_locked: 1;
	u32 rt_pmtu: 31;
};

struct fnhe_hash_bucket {
	struct fib_nh_exception *chain;
};

struct fib_info;

struct fib_nh {
	struct fib_nh_common nh_common;
	struct hlist_node nh_hash;
	struct fib_info *nh_parent;
	__be32 nh_saddr;
	int nh_saddr_genid;
};

struct fib_info {
	struct hlist_node fib_hash;
	struct hlist_node fib_lhash;
	struct list_head nh_list;
	struct net *fib_net;
	refcount_t fib_treeref;
	refcount_t fib_clntref;
	unsigned int fib_flags;
	unsigned char fib_dead;
	unsigned char fib_protocol;
	unsigned char fib_scope;
	unsigned char fib_type;
	__be32 fib_prefsrc;
	u32 fib_tb_id;
	u32 fib_priority;
	struct dst_metrics *fib_metrics;
	int fib_nhs;
	bool fib_nh_is_v6;
	bool nh_updated;
	bool pfsrc_removed;
	struct nexthop *nh;
	struct callback_head rcu;
	struct fib_nh fib_nh[0];
};

struct nh_info;

struct nh_group;

struct nexthop {
	struct rb_node rb_node;
	struct list_head fi_list;
	struct list_head f6i_list;
	struct list_head fdb_list;
	struct list_head grp_list;
	struct net *net;
	u32 id;
	u8 protocol;
	u8 nh_flags;
	bool is_group;
	refcount_t refcnt;
	struct callback_head rcu;
	union {
		struct nh_info *nh_info;
		struct nh_group *nh_grp;
	};
};

struct arphdr {
	__be16 ar_hrd;
	__be16 ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	__be16 ar_op;
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

struct nd_opt_hdr {
	__u8 nd_opt_type;
	__u8 nd_opt_len;
};

struct ndisc_options {
	struct nd_opt_hdr *nd_opt_array[15];
	struct nd_opt_hdr *nd_opts_ri;
	struct nd_opt_hdr *nd_opts_ri_end;
	struct nd_opt_hdr *nd_useropts;
	struct nd_opt_hdr *nd_useropts_end;
};

struct prefix_info {
	__u8 type;
	__u8 length;
	__u8 prefix_len;
	__u8 reserved: 6;
	__u8 autoconf: 1;
	__u8 onlink: 1;
	__be32 valid;
	__be32 prefered;
	__be32 reserved2;
	struct in6_addr prefix;
};

struct in_ifaddr {
	struct hlist_node hash;
	struct in_ifaddr *ifa_next;
	struct in_device *ifa_dev;
	struct callback_head callback_head;
	__be32 ifa_local;
	__be32 ifa_address;
	__be32 ifa_mask;
	__u32 ifa_rt_priority;
	__be32 ifa_broadcast;
	unsigned char ifa_scope;
	unsigned char ifa_prefixlen;
	unsigned char ifa_proto;
	__u32 ifa_flags;
	char ifa_label[16];
	__u32 ifa_valid_lft;
	__u32 ifa_preferred_lft;
	long unsigned int ifa_cstamp;
	long unsigned int ifa_tstamp;
};

struct ip_sf_list;

struct ip_mc_list {
	struct in_device *interface;
	__be32 multiaddr;
	unsigned int sfmode;
	struct ip_sf_list *sources;
	struct ip_sf_list *tomb;
	long unsigned int sfcount[2];
	union {
		struct ip_mc_list *next;
		struct ip_mc_list *next_rcu;
	};
	struct ip_mc_list *next_hash;
	struct timer_list timer;
	int users;
	refcount_t refcnt;
	spinlock_t lock;
	char tm_running;
	char reporter;
	char unsolicit_count;
	char loaded;
	unsigned char gsquery;
	unsigned char crcount;
	struct callback_head rcu;
};

struct ip_sf_socklist {
	unsigned int sl_max;
	unsigned int sl_count;
	struct callback_head rcu;
	__be32 sl_addr[0];
};

struct ip_sf_list {
	struct ip_sf_list *sf_next;
	long unsigned int sf_count[2];
	__be32 sf_inaddr;
	unsigned char sf_gsresp;
	unsigned char sf_oldin;
	unsigned char sf_crcount;
};

struct ethtool_drvinfo {
	__u32 cmd;
	char driver[32];
	char version[32];
	char fw_version[32];
	char bus_info[32];
	char erom_version[32];
	char reserved2[12];
	__u32 n_priv_flags;
	__u32 n_stats;
	__u32 testinfo_len;
	__u32 eedump_len;
	__u32 regdump_len;
};

struct ethtool_wolinfo {
	__u32 cmd;
	__u32 supported;
	__u32 wolopts;
	__u8 sopass[6];
};

struct ethtool_tunable {
	__u32 cmd;
	__u32 id;
	__u32 type_id;
	__u32 len;
	void *data[0];
};

struct ethtool_regs {
	__u32 cmd;
	__u32 version;
	__u32 len;
	__u8 data[0];
};

struct ethtool_eeprom {
	__u32 cmd;
	__u32 magic;
	__u32 offset;
	__u32 len;
	__u8 data[0];
};

struct ethtool_eee {
	__u32 cmd;
	__u32 supported;
	__u32 advertised;
	__u32 lp_advertised;
	__u32 eee_active;
	__u32 eee_enabled;
	__u32 tx_lpi_enabled;
	__u32 tx_lpi_timer;
	__u32 reserved[2];
};

struct ethtool_modinfo {
	__u32 cmd;
	__u32 type;
	__u32 eeprom_len;
	__u32 reserved[8];
};

struct ethtool_coalesce {
	__u32 cmd;
	__u32 rx_coalesce_usecs;
	__u32 rx_max_coalesced_frames;
	__u32 rx_coalesce_usecs_irq;
	__u32 rx_max_coalesced_frames_irq;
	__u32 tx_coalesce_usecs;
	__u32 tx_max_coalesced_frames;
	__u32 tx_coalesce_usecs_irq;
	__u32 tx_max_coalesced_frames_irq;
	__u32 stats_block_coalesce_usecs;
	__u32 use_adaptive_rx_coalesce;
	__u32 use_adaptive_tx_coalesce;
	__u32 pkt_rate_low;
	__u32 rx_coalesce_usecs_low;
	__u32 rx_max_coalesced_frames_low;
	__u32 tx_coalesce_usecs_low;
	__u32 tx_max_coalesced_frames_low;
	__u32 pkt_rate_high;
	__u32 rx_coalesce_usecs_high;
	__u32 rx_max_coalesced_frames_high;
	__u32 tx_coalesce_usecs_high;
	__u32 tx_max_coalesced_frames_high;
	__u32 rate_sample_interval;
};

struct ethtool_ringparam {
	__u32 cmd;
	__u32 rx_max_pending;
	__u32 rx_mini_max_pending;
	__u32 rx_jumbo_max_pending;
	__u32 tx_max_pending;
	__u32 rx_pending;
	__u32 rx_mini_pending;
	__u32 rx_jumbo_pending;
	__u32 tx_pending;
};

struct ethtool_channels {
	__u32 cmd;
	__u32 max_rx;
	__u32 max_tx;
	__u32 max_other;
	__u32 max_combined;
	__u32 rx_count;
	__u32 tx_count;
	__u32 other_count;
	__u32 combined_count;
};

struct ethtool_pauseparam {
	__u32 cmd;
	__u32 autoneg;
	__u32 rx_pause;
	__u32 tx_pause;
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

struct ethtool_test {
	__u32 cmd;
	__u32 flags;
	__u32 reserved;
	__u32 len;
	__u64 data[0];
};

struct ethtool_stats {
	__u32 cmd;
	__u32 n_stats;
	__u64 data[0];
};

struct ethtool_tcpip4_spec {
	__be32 ip4src;
	__be32 ip4dst;
	__be16 psrc;
	__be16 pdst;
	__u8 tos;
};

struct ethtool_ah_espip4_spec {
	__be32 ip4src;
	__be32 ip4dst;
	__be32 spi;
	__u8 tos;
};

struct ethtool_usrip4_spec {
	__be32 ip4src;
	__be32 ip4dst;
	__be32 l4_4_bytes;
	__u8 tos;
	__u8 ip_ver;
	__u8 proto;
};

struct ethtool_tcpip6_spec {
	__be32 ip6src[4];
	__be32 ip6dst[4];
	__be16 psrc;
	__be16 pdst;
	__u8 tclass;
};

struct ethtool_ah_espip6_spec {
	__be32 ip6src[4];
	__be32 ip6dst[4];
	__be32 spi;
	__u8 tclass;
};

struct ethtool_usrip6_spec {
	__be32 ip6src[4];
	__be32 ip6dst[4];
	__be32 l4_4_bytes;
	__u8 tclass;
	__u8 l4_proto;
};

union ethtool_flow_union {
	struct ethtool_tcpip4_spec tcp_ip4_spec;
	struct ethtool_tcpip4_spec udp_ip4_spec;
	struct ethtool_tcpip4_spec sctp_ip4_spec;
	struct ethtool_ah_espip4_spec ah_ip4_spec;
	struct ethtool_ah_espip4_spec esp_ip4_spec;
	struct ethtool_usrip4_spec usr_ip4_spec;
	struct ethtool_tcpip6_spec tcp_ip6_spec;
	struct ethtool_tcpip6_spec udp_ip6_spec;
	struct ethtool_tcpip6_spec sctp_ip6_spec;
	struct ethtool_ah_espip6_spec ah_ip6_spec;
	struct ethtool_ah_espip6_spec esp_ip6_spec;
	struct ethtool_usrip6_spec usr_ip6_spec;
	struct ethhdr ether_spec;
	__u8 hdata[52];
};

struct ethtool_flow_ext {
	__u8 padding[2];
	unsigned char h_dest[6];
	__be16 vlan_etype;
	__be16 vlan_tci;
	__be32 data[2];
};

struct ethtool_rx_flow_spec {
	__u32 flow_type;
	union ethtool_flow_union h_u;
	struct ethtool_flow_ext h_ext;
	union ethtool_flow_union m_u;
	struct ethtool_flow_ext m_ext;
	__u64 ring_cookie;
	__u32 location;
};

struct ethtool_rxnfc {
	__u32 cmd;
	__u32 flow_type;
	__u64 data;
	struct ethtool_rx_flow_spec fs;
	union {
		__u32 rule_cnt;
		__u32 rss_context;
	};
	__u32 rule_locs[0];
};

struct ethtool_flash {
	__u32 cmd;
	__u32 region;
	char data[128];
};

struct ethtool_dump {
	__u32 cmd;
	__u32 version;
	__u32 flag;
	__u32 len;
	__u8 data[0];
};

struct ethtool_ts_info {
	__u32 cmd;
	__u32 so_timestamping;
	__s32 phc_index;
	__u32 tx_types;
	__u32 tx_reserved[3];
	__u32 rx_filters;
	__u32 rx_reserved[3];
};

struct ethtool_fecparam {
	__u32 cmd;
	__u32 active_fec;
	__u32 fec;
	__u32 reserved;
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 102,
};

struct ethtool_link_settings {
	__u32 cmd;
	__u32 speed;
	__u8 duplex;
	__u8 port;
	__u8 phy_address;
	__u8 autoneg;
	__u8 mdio_support;
	__u8 eth_tp_mdix;
	__u8 eth_tp_mdix_ctrl;
	__s8 link_mode_masks_nwords;
	__u8 transceiver;
	__u8 master_slave_cfg;
	__u8 master_slave_state;
	__u8 rate_matching;
	__u32 reserved[7];
	__u32 link_mode_masks[0];
};

struct kernel_ethtool_ringparam {
	u32 rx_buf_len;
	u8 tcp_data_split;
	u8 tx_push;
	u8 rx_push;
	u32 cqe_size;
	u32 tx_push_buf_len;
	u32 tx_push_buf_max_len;
};

struct ethtool_link_ext_state_info {
	enum ethtool_link_ext_state link_ext_state;
	union {
		enum ethtool_link_ext_substate_autoneg autoneg;
		enum ethtool_link_ext_substate_link_training link_training;
		enum ethtool_link_ext_substate_link_logical_mismatch link_logical_mismatch;
		enum ethtool_link_ext_substate_bad_signal_integrity bad_signal_integrity;
		enum ethtool_link_ext_substate_cable_issue cable_issue;
		enum ethtool_link_ext_substate_module module;
		u32 __link_ext_substate;
	};
};

struct ethtool_link_ext_stats {
	u64 link_down_events;
};

struct ethtool_link_ksettings {
	struct ethtool_link_settings base;
	struct {
		long unsigned int supported[2];
		long unsigned int advertising[2];
		long unsigned int lp_advertising[2];
	} link_modes;
	u32 lanes;
};

struct kernel_ethtool_coalesce {
	u8 use_cqe_mode_tx;
	u8 use_cqe_mode_rx;
	u32 tx_aggr_max_bytes;
	u32 tx_aggr_max_frames;
	u32 tx_aggr_time_usecs;
};

struct ethtool_eth_mac_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 FramesTransmittedOK;
			u64 SingleCollisionFrames;
			u64 MultipleCollisionFrames;
			u64 FramesReceivedOK;
			u64 FrameCheckSequenceErrors;
			u64 AlignmentErrors;
			u64 OctetsTransmittedOK;
			u64 FramesWithDeferredXmissions;
			u64 LateCollisions;
			u64 FramesAbortedDueToXSColls;
			u64 FramesLostDueToIntMACXmitError;
			u64 CarrierSenseErrors;
			u64 OctetsReceivedOK;
			u64 FramesLostDueToIntMACRcvError;
			u64 MulticastFramesXmittedOK;
			u64 BroadcastFramesXmittedOK;
			u64 FramesWithExcessiveDeferral;
			u64 MulticastFramesReceivedOK;
			u64 BroadcastFramesReceivedOK;
			u64 InRangeLengthErrors;
			u64 OutOfRangeLengthField;
			u64 FrameTooLongErrors;
		};
		struct {
			u64 FramesTransmittedOK;
			u64 SingleCollisionFrames;
			u64 MultipleCollisionFrames;
			u64 FramesReceivedOK;
			u64 FrameCheckSequenceErrors;
			u64 AlignmentErrors;
			u64 OctetsTransmittedOK;
			u64 FramesWithDeferredXmissions;
			u64 LateCollisions;
			u64 FramesAbortedDueToXSColls;
			u64 FramesLostDueToIntMACXmitError;
			u64 CarrierSenseErrors;
			u64 OctetsReceivedOK;
			u64 FramesLostDueToIntMACRcvError;
			u64 MulticastFramesXmittedOK;
			u64 BroadcastFramesXmittedOK;
			u64 FramesWithExcessiveDeferral;
			u64 MulticastFramesReceivedOK;
			u64 BroadcastFramesReceivedOK;
			u64 InRangeLengthErrors;
			u64 OutOfRangeLengthField;
			u64 FrameTooLongErrors;
		} stats;
	};
};

struct ethtool_eth_phy_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 SymbolErrorDuringCarrier;
		};
		struct {
			u64 SymbolErrorDuringCarrier;
		} stats;
	};
};

struct ethtool_eth_ctrl_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 MACControlFramesTransmitted;
			u64 MACControlFramesReceived;
			u64 UnsupportedOpcodesReceived;
		};
		struct {
			u64 MACControlFramesTransmitted;
			u64 MACControlFramesReceived;
			u64 UnsupportedOpcodesReceived;
		} stats;
	};
};

struct ethtool_pause_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 tx_pause_frames;
			u64 rx_pause_frames;
		};
		struct {
			u64 tx_pause_frames;
			u64 rx_pause_frames;
		} stats;
	};
};

struct ethtool_fec_stat {
	u64 total;
	u64 lanes[8];
};

struct ethtool_fec_stats {
	struct ethtool_fec_stat corrected_blocks;
	struct ethtool_fec_stat uncorrectable_blocks;
	struct ethtool_fec_stat corrected_bits;
};

struct ethtool_rmon_hist_range {
	u16 low;
	u16 high;
};

struct ethtool_rmon_stats {
	enum ethtool_mac_stats_src src;
	union {
		struct {
			u64 undersize_pkts;
			u64 oversize_pkts;
			u64 fragments;
			u64 jabbers;
			u64 hist[10];
			u64 hist_tx[10];
		};
		struct {
			u64 undersize_pkts;
			u64 oversize_pkts;
			u64 fragments;
			u64 jabbers;
			u64 hist[10];
			u64 hist_tx[10];
		} stats;
	};
};

struct ethtool_module_eeprom {
	u32 offset;
	u32 length;
	u8 page;
	u8 bank;
	u8 i2c_address;
	u8 *data;
};

struct ethtool_module_power_mode_params {
	enum ethtool_module_power_mode_policy policy;
	enum ethtool_module_power_mode mode;
};

struct ethtool_mm_state {
	u32 verify_time;
	u32 max_verify_time;
	enum ethtool_mm_verify_status verify_status;
	bool tx_enabled;
	bool tx_active;
	bool pmac_enabled;
	bool verify_enabled;
	u32 tx_min_frag_size;
	u32 rx_min_frag_size;
};

struct ethtool_mm_cfg {
	u32 verify_time;
	bool verify_enabled;
	bool tx_enabled;
	bool pmac_enabled;
	u32 tx_min_frag_size;
};

struct ethtool_mm_stats {
	u64 MACMergeFrameAssErrorCount;
	u64 MACMergeFrameSmdErrorCount;
	u64 MACMergeFrameAssOkCount;
	u64 MACMergeFragCountRx;
	u64 MACMergeFragCountTx;
	u64 MACMergeHoldCount;
};

struct phy_plca_cfg {
	int version;
	int enabled;
	int node_id;
	int node_cnt;
	int to_tmr;
	int burst_cnt;
	int burst_tmr;
};

struct phy_plca_status {
	bool pst;
};

struct phy_tdr_config {
	u32 first;
	u32 last;
	u32 step;
	s8 pair;
};

struct mii_ioctl_data {
	__u16 phy_id;
	__u16 reg_num;
	__u16 val_in;
	__u16 val_out;
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

struct mdio_bus_stats {
	u64_stats_t transfers;
	u64_stats_t errors;
	u64_stats_t writes;
	u64_stats_t reads;
	struct u64_stats_sync syncp;
};

struct mii_bus {
	struct module *owner;
	const char *name;
	char id[61];
	void *priv;
	int (*read)(struct mii_bus *, int, int);
	int (*write)(struct mii_bus *, int, int, u16);
	int (*read_c45)(struct mii_bus *, int, int, int);
	int (*write_c45)(struct mii_bus *, int, int, int, u16);
	int (*reset)(struct mii_bus *);
	struct mdio_bus_stats stats[32];
	struct mutex mdio_lock;
	struct device *parent;
	enum {
		MDIOBUS_ALLOCATED = 1,
		MDIOBUS_REGISTERED = 2,
		MDIOBUS_UNREGISTERED = 3,
		MDIOBUS_RELEASED = 4,
	} state;
	struct device dev;
	struct mdio_device *mdio_map[32];
	u32 phy_mask;
	u32 phy_ignore_ta_mask;
	int irq[32];
	int reset_delay_us;
	int reset_post_delay_us;
	struct gpio_desc *reset_gpiod;
	struct mutex shared_lock;
	struct phy_package_shared *shared[32];
};

struct mdio_driver_common {
	struct device_driver driver;
	int flags;
};

struct mii_timestamper {
	bool (*rxtstamp)(struct mii_timestamper *, struct sk_buff *, int);
	void (*txtstamp)(struct mii_timestamper *, struct sk_buff *, int);
	int (*hwtstamp)(struct mii_timestamper *, struct ifreq *);
	void (*link_state)(struct mii_timestamper *, struct phy_device *);
	int (*ts_info)(struct mii_timestamper *, struct ethtool_ts_info *);
	struct device *device;
};

struct phy_package_shared {
	int addr;
	refcount_t refcnt;
	long unsigned int flags;
	size_t priv_size;
	void *priv;
};

struct phy_driver {
	struct mdio_driver_common mdiodrv;
	u32 phy_id;
	char *name;
	u32 phy_id_mask;
	const long unsigned int * const features;
	u32 flags;
	const void *driver_data;
	int (*soft_reset)(struct phy_device *);
	int (*config_init)(struct phy_device *);
	int (*probe)(struct phy_device *);
	int (*get_features)(struct phy_device *);
	int (*get_rate_matching)(struct phy_device *, phy_interface_t);
	int (*suspend)(struct phy_device *);
	int (*resume)(struct phy_device *);
	int (*config_aneg)(struct phy_device *);
	int (*aneg_done)(struct phy_device *);
	int (*read_status)(struct phy_device *);
	int (*config_intr)(struct phy_device *);
	irqreturn_t (*handle_interrupt)(struct phy_device *);
	void (*remove)(struct phy_device *);
	int (*match_phy_device)(struct phy_device *);
	int (*set_wol)(struct phy_device *, struct ethtool_wolinfo *);
	void (*get_wol)(struct phy_device *, struct ethtool_wolinfo *);
	void (*link_change_notify)(struct phy_device *);
	int (*read_mmd)(struct phy_device *, int, u16);
	int (*write_mmd)(struct phy_device *, int, u16, u16);
	int (*read_page)(struct phy_device *);
	int (*write_page)(struct phy_device *, int);
	int (*module_info)(struct phy_device *, struct ethtool_modinfo *);
	int (*module_eeprom)(struct phy_device *, struct ethtool_eeprom *, u8 *);
	int (*cable_test_start)(struct phy_device *);
	int (*cable_test_tdr_start)(struct phy_device *, const struct phy_tdr_config *);
	int (*cable_test_get_status)(struct phy_device *, bool *);
	int (*get_sset_count)(struct phy_device *);
	void (*get_strings)(struct phy_device *, u8 *);
	void (*get_stats)(struct phy_device *, struct ethtool_stats *, u64 *);
	int (*get_tunable)(struct phy_device *, struct ethtool_tunable *, void *);
	int (*set_tunable)(struct phy_device *, struct ethtool_tunable *, const void *);
	int (*set_loopback)(struct phy_device *, bool);
	int (*get_sqi)(struct phy_device *);
	int (*get_sqi_max)(struct phy_device *);
	int (*get_plca_cfg)(struct phy_device *, struct phy_plca_cfg *);
	int (*set_plca_cfg)(struct phy_device *, const struct phy_plca_cfg *);
	int (*get_plca_status)(struct phy_device *, struct phy_plca_status *);
	int (*led_brightness_set)(struct phy_device *, u8, enum led_brightness);
	int (*led_blink_set)(struct phy_device *, u8, long unsigned int *, long unsigned int *);
	int (*led_hw_is_supported)(struct phy_device *, u8, long unsigned int);
	int (*led_hw_control_set)(struct phy_device *, u8, long unsigned int);
	int (*led_hw_control_get)(struct phy_device *, u8, long unsigned int *);
};

struct rt6_exception_bucket {
	struct hlist_head chain;
	int depth;
};

struct xfrm_type {
	struct module *owner;
	u8 proto;
	u8 flags;
	int (*init_state)(struct xfrm_state *, struct netlink_ext_ack *);
	void (*destructor)(struct xfrm_state *);
	int (*input)(struct xfrm_state *, struct sk_buff *);
	int (*output)(struct xfrm_state *, struct sk_buff *);
	int (*reject)(struct xfrm_state *, struct sk_buff *, const struct flowi *);
};

struct xfrm_type_offload {
	struct module *owner;
	u8 proto;
	void (*encap)(struct xfrm_state *, struct sk_buff *);
	int (*input_tail)(struct xfrm_state *, struct sk_buff *);
	int (*xmit)(struct xfrm_state *, struct sk_buff *, netdev_features_t);
};

struct reciprocal_value {
	u32 m;
	u8 sh1;
	u8 sh2;
};

struct mac_addr {
	u8 mac_addr_value[6];
};

enum {
	BOND_AD_STABLE = 0,
	BOND_AD_BANDWIDTH = 1,
	BOND_AD_COUNT = 2,
};

typedef enum {
	AD_RX_DUMMY = 0,
	AD_RX_INITIALIZE = 1,
	AD_RX_PORT_DISABLED = 2,
	AD_RX_LACP_DISABLED = 3,
	AD_RX_EXPIRED = 4,
	AD_RX_DEFAULTED = 5,
	AD_RX_CURRENT = 6,
} rx_states_t;

typedef enum {
	AD_PERIODIC_DUMMY = 0,
	AD_NO_PERIODIC = 1,
	AD_FAST_PERIODIC = 2,
	AD_SLOW_PERIODIC = 3,
	AD_PERIODIC_TX = 4,
} periodic_states_t;

typedef enum {
	AD_MUX_DUMMY = 0,
	AD_MUX_DETACHED = 1,
	AD_MUX_WAITING = 2,
	AD_MUX_ATTACHED = 3,
	AD_MUX_COLLECTING_DISTRIBUTING = 4,
} mux_states_t;

typedef enum {
	AD_TX_DUMMY = 0,
	AD_TRANSMIT = 1,
} tx_states_t;

typedef enum {
	AD_CHURN_MONITOR = 0,
	AD_CHURN = 1,
	AD_NO_CHURN = 2,
} churn_state_t;

struct lacpdu {
	u8 subtype;
	u8 version_number;
	u8 tlv_type_actor_info;
	u8 actor_information_length;
	__be16 actor_system_priority;
	struct mac_addr actor_system;
	__be16 actor_key;
	__be16 actor_port_priority;
	__be16 actor_port;
	u8 actor_state;
	u8 reserved_3_1[3];
	u8 tlv_type_partner_info;
	u8 partner_information_length;
	__be16 partner_system_priority;
	struct mac_addr partner_system;
	__be16 partner_key;
	__be16 partner_port_priority;
	__be16 partner_port;
	u8 partner_state;
	u8 reserved_3_2[3];
	u8 tlv_type_collector_info;
	u8 collector_information_length;
	__be16 collector_max_delay;
	u8 reserved_12[12];
	u8 tlv_type_terminator;
	u8 terminator_length;
	u8 reserved_50[50];
};

struct bond_3ad_stats {
	atomic64_t lacpdu_rx;
	atomic64_t lacpdu_tx;
	atomic64_t lacpdu_unknown_rx;
	atomic64_t lacpdu_illegal_rx;
	atomic64_t marker_rx;
	atomic64_t marker_tx;
	atomic64_t marker_resp_rx;
	atomic64_t marker_resp_tx;
	atomic64_t marker_unknown_rx;
};

struct port;

struct slave;

struct aggregator {
	struct mac_addr aggregator_mac_address;
	u16 aggregator_identifier;
	bool is_individual;
	u16 actor_admin_aggregator_key;
	u16 actor_oper_aggregator_key;
	struct mac_addr partner_system;
	u16 partner_system_priority;
	u16 partner_oper_aggregator_key;
	u16 receive_state;
	u16 transmit_state;
	struct port *lag_ports;
	struct slave *slave;
	u16 is_active;
	u16 num_of_ports;
};

struct port_params {
	struct mac_addr system;
	u16 system_priority;
	u16 key;
	u16 port_number;
	u16 port_priority;
	u16 port_state;
};

struct port {
	u16 actor_port_number;
	u16 actor_port_priority;
	struct mac_addr actor_system;
	u16 actor_system_priority;
	u16 actor_port_aggregator_identifier;
	bool ntt;
	u16 actor_admin_port_key;
	u16 actor_oper_port_key;
	u8 actor_admin_port_state;
	u8 actor_oper_port_state;
	struct port_params partner_admin;
	struct port_params partner_oper;
	bool is_enabled;
	u16 sm_vars;
	rx_states_t sm_rx_state;
	u16 sm_rx_timer_counter;
	periodic_states_t sm_periodic_state;
	u16 sm_periodic_timer_counter;
	mux_states_t sm_mux_state;
	u16 sm_mux_timer_counter;
	tx_states_t sm_tx_state;
	u16 sm_tx_timer_counter;
	u16 sm_churn_actor_timer_counter;
	u16 sm_churn_partner_timer_counter;
	u32 churn_actor_count;
	u32 churn_partner_count;
	churn_state_t sm_churn_actor_state;
	churn_state_t sm_churn_partner_state;
	struct slave *slave;
	struct aggregator *aggregator;
	struct port *next_port_in_aggregator;
	u32 transaction_id;
	struct lacpdu lacpdu;
};

struct tlb_slave_info {
	u32 head;
	u32 load;
};

struct bonding;

struct ad_slave_info;

struct slave {
	struct net_device *dev;
	struct bonding *bond;
	int delay;
	long unsigned int last_link_up;
	long unsigned int last_tx;
	long unsigned int last_rx;
	long unsigned int target_last_arp_rx[16];
	s8 link;
	s8 link_new_state;
	u8 backup: 1;
	u8 inactive: 1;
	u8 should_notify: 1;
	u8 should_notify_link: 1;
	u8 duplex;
	u32 original_mtu;
	u32 link_failure_count;
	u32 speed;
	u16 queue_id;
	u8 perm_hwaddr[32];
	int prio;
	struct ad_slave_info *ad_info;
	struct tlb_slave_info tlb_info;
	struct delayed_work notify_work;
	struct kobject kobj;
	struct rtnl_link_stats64 slave_stats;
};

struct ad_system {
	u16 sys_priority;
	struct mac_addr sys_mac_addr;
};

struct ad_bond_info {
	struct ad_system system;
	struct bond_3ad_stats stats;
	atomic_t agg_select_timer;
	u16 aggregator_identifier;
};

struct ad_slave_info {
	struct aggregator aggregator;
	struct port port;
	struct bond_3ad_stats stats;
	u16 id;
};

struct tlb_client_info {
	struct slave *tx_slave;
	u32 tx_bytes;
	u32 load_history;
	u32 next;
	u32 prev;
};

struct rlb_client_info {
	__be32 ip_src;
	__be32 ip_dst;
	u8 mac_src[6];
	u8 mac_dst[6];
	u32 used_next;
	u32 used_prev;
	u32 src_next;
	u32 src_prev;
	u32 src_first;
	u8 assigned;
	u8 ntt;
	struct slave *slave;
	short unsigned int vlan_id;
};

struct alb_bond_info {
	struct tlb_client_info *tx_hashtbl;
	u32 unbalanced_load;
	atomic_t tx_rebalance_counter;
	int lp_counter;
	int rlb_enabled;
	struct rlb_client_info *rx_hashtbl;
	u32 rx_hashtbl_used_head;
	u8 rx_ntt;
	struct slave *rx_slave;
	u8 primary_is_promisc;
	u32 rlb_promisc_timeout_counter;
	u32 rlb_update_delay_counter;
	u32 rlb_update_retry_counter;
	u8 rlb_rebalance;
};

enum {
	BOND_OPT_MODE = 0,
	BOND_OPT_PACKETS_PER_SLAVE = 1,
	BOND_OPT_XMIT_HASH = 2,
	BOND_OPT_ARP_VALIDATE = 3,
	BOND_OPT_ARP_ALL_TARGETS = 4,
	BOND_OPT_FAIL_OVER_MAC = 5,
	BOND_OPT_ARP_INTERVAL = 6,
	BOND_OPT_ARP_TARGETS = 7,
	BOND_OPT_DOWNDELAY = 8,
	BOND_OPT_UPDELAY = 9,
	BOND_OPT_LACP_RATE = 10,
	BOND_OPT_MINLINKS = 11,
	BOND_OPT_AD_SELECT = 12,
	BOND_OPT_NUM_PEER_NOTIF = 13,
	BOND_OPT_MIIMON = 14,
	BOND_OPT_PRIMARY = 15,
	BOND_OPT_PRIMARY_RESELECT = 16,
	BOND_OPT_USE_CARRIER = 17,
	BOND_OPT_ACTIVE_SLAVE = 18,
	BOND_OPT_QUEUE_ID = 19,
	BOND_OPT_ALL_SLAVES_ACTIVE = 20,
	BOND_OPT_RESEND_IGMP = 21,
	BOND_OPT_LP_INTERVAL = 22,
	BOND_OPT_SLAVES = 23,
	BOND_OPT_TLB_DYNAMIC_LB = 24,
	BOND_OPT_AD_ACTOR_SYS_PRIO = 25,
	BOND_OPT_AD_ACTOR_SYSTEM = 26,
	BOND_OPT_AD_USER_PORT_KEY = 27,
	BOND_OPT_NUM_PEER_NOTIF_ALIAS = 28,
	BOND_OPT_PEER_NOTIF_DELAY = 29,
	BOND_OPT_LACP_ACTIVE = 30,
	BOND_OPT_MISSED_MAX = 31,
	BOND_OPT_NS_TARGETS = 32,
	BOND_OPT_PRIO = 33,
	BOND_OPT_LAST = 34,
};

struct bond_opt_value {
	char *string;
	u64 value;
	u32 flags;
	union {
		char extra[16];
		struct net_device *slave_dev;
	};
};

struct bond_option {
	int id;
	const char *name;
	const char *desc;
	u32 flags;
	long unsigned int unsuppmodes;
	const struct bond_opt_value *values;
	int (*set)(struct bonding *, const struct bond_opt_value *);
};

struct bond_params {
	int mode;
	int xmit_policy;
	int miimon;
	u8 num_peer_notif;
	u8 missed_max;
	int arp_interval;
	int arp_validate;
	int arp_all_targets;
	int use_carrier;
	int fail_over_mac;
	int updelay;
	int downdelay;
	int peer_notif_delay;
	int lacp_active;
	int lacp_fast;
	unsigned int min_links;
	int ad_select;
	char primary[16];
	int primary_reselect;
	__be32 arp_targets[16];
	int tx_queues;
	int all_slaves_active;
	int resend_igmp;
	int lp_interval;
	int packets_per_slave;
	int tlb_dynamic_lb;
	struct reciprocal_value reciprocal_packets_per_slave;
	u16 ad_actor_sys_prio;
	u16 ad_user_port_key;
	struct in6_addr ns_targets[16];
	u8 ad_actor_system[8];
};

struct bond_up_slave;

struct bonding {
	struct net_device *dev;
	struct slave *curr_active_slave;
	struct slave *current_arp_slave;
	struct slave *primary_slave;
	struct bond_up_slave *usable_slaves;
	struct bond_up_slave *all_slaves;
	bool force_primary;
	bool notifier_ctx;
	s32 slave_cnt;
	int (*recv_probe)(const struct sk_buff *, struct bonding *, struct slave *);
	spinlock_t mode_lock;
	spinlock_t stats_lock;
	u32 send_peer_notif;
	u8 igmp_retrans;
	struct proc_dir_entry *proc_entry;
	char proc_file_name[16];
	struct list_head bond_list;
	u32 *rr_tx_counter;
	struct ad_bond_info ad_info;
	struct alb_bond_info alb_info;
	struct bond_params params;
	struct workqueue_struct *wq;
	struct delayed_work mii_work;
	struct delayed_work arp_work;
	struct delayed_work alb_work;
	struct delayed_work ad_work;
	struct delayed_work mcast_work;
	struct delayed_work slave_arr_work;
	struct dentry *debug_dir;
	struct rtnl_link_stats64 bond_stats;
	struct bpf_prog *xdp_prog;
};

struct bond_up_slave {
	unsigned int count;
	struct callback_head rcu;
	struct slave *arr[0];
};

struct bond_vlan_tag {
	__be16 vlan_proto;
	short unsigned int vlan_id;
};

struct bond_net {
	struct net *net;
	struct list_head dev_list;
	struct proc_dir_entry *proc_dir;
	struct class_attribute class_attr_bonding_masters;
};

struct nh_info {
	struct hlist_node dev_hash;
	struct nexthop *nh_parent;
	u8 family;
	bool reject_nh;
	bool fdb_nh;
	union {
		struct fib_nh_common fib_nhc;
		struct fib_nh fib_nh;
		struct fib6_nh fib6_nh;
	};
};

struct nh_grp_entry;

struct nh_res_bucket {
	struct nh_grp_entry *nh_entry;
	atomic_long_t used_time;
	long unsigned int migrated_time;
	bool occupied;
	u8 nh_flags;
};

struct nh_grp_entry {
	struct nexthop *nh;
	u8 weight;
	union {
		struct {
			atomic_t upper_bound;
		} hthr;
		struct {
			struct list_head uw_nh_entry;
			u16 count_buckets;
			u16 wants_buckets;
		} res;
	};
	struct list_head nh_list;
	struct nexthop *nh_parent;
};

struct nh_res_table {
	struct net *net;
	u32 nhg_id;
	struct delayed_work upkeep_dw;
	struct list_head uw_nh_entries;
	long unsigned int unbalanced_since;
	u32 idle_timer;
	u32 unbalanced_timer;
	u16 num_nh_buckets;
	struct nh_res_bucket nh_buckets[0];
};

struct nh_group {
	struct nh_group *spare;
	u16 num_nh;
	bool is_multipath;
	bool hash_threshold;
	bool resilient;
	bool fdb_nh;
	bool has_v4;
	struct nh_res_table *res_table;
	struct nh_grp_entry nh_entries[0];
};

struct debugfs_u32_array {
	u32 *array;
	u32 n_elements;
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

struct udp_hslot;

struct udp_table {
	struct udp_hslot *hash;
	struct udp_hslot *hash2;
	unsigned int mask;
	unsigned int log;
};

struct ip_tunnel_parm {
	char name[16];
	int link;
	__be16 i_flags;
	__be16 o_flags;
	__be32 i_key;
	__be32 o_key;
	struct iphdr iph;
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

struct devlink_port_phys_attrs {
	u32 port_number;
	u32 split_subport_number;
};

struct devlink_port_pci_pf_attrs {
	u32 controller;
	u16 pf;
	u8 external: 1;
};

struct devlink_port_pci_vf_attrs {
	u32 controller;
	u16 pf;
	u16 vf;
	u8 external: 1;
};

struct devlink_port_pci_sf_attrs {
	u32 controller;
	u32 sf;
	u16 pf;
	u8 external: 1;
};

struct devlink_port_attrs {
	u8 split: 1;
	u8 splittable: 1;
	u32 lanes;
	enum devlink_port_flavour flavour;
	struct netdev_phys_item_id switch_id;
	union {
		struct devlink_port_phys_attrs phys;
		struct devlink_port_pci_pf_attrs pci_pf;
		struct devlink_port_pci_vf_attrs pci_vf;
		struct devlink_port_pci_sf_attrs pci_sf;
	};
};

struct devlink;

struct devlink_port_ops;

struct ib_device;

struct devlink_rate;

struct devlink_linecard;

struct devlink_port {
	struct list_head list;
	struct list_head region_list;
	struct devlink *devlink;
	const struct devlink_port_ops *ops;
	unsigned int index;
	spinlock_t type_lock;
	enum devlink_port_type type;
	enum devlink_port_type desired_type;
	union {
		struct {
			struct net_device *netdev;
			int ifindex;
			char ifname[16];
		} type_eth;
		struct {
			struct ib_device *ibdev;
		} type_ib;
	};
	struct devlink_port_attrs attrs;
	u8 attrs_set: 1;
	u8 switch_port: 1;
	u8 registered: 1;
	u8 initialized: 1;
	struct delayed_work type_warn_dw;
	struct list_head reporter_list;
	struct devlink_rate *devlink_rate;
	struct devlink_linecard *linecard;
	u32 rel_index;
};

struct flow_action_cookie {
	u32 cookie_len;
	u8 cookie[0];
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

struct devlink_rate {
	struct list_head list;
	enum devlink_rate_type type;
	struct devlink *devlink;
	void *priv;
	u64 tx_share;
	u64 tx_max;
	struct devlink_rate *parent;
	union {
		struct devlink_port *devlink_port;
		struct {
			char *name;
			refcount_t refcnt;
		};
	};
	u32 tx_priority;
	u32 tx_weight;
};

struct devlink_port_ops {
	int (*port_split)(struct devlink *, struct devlink_port *, unsigned int, struct netlink_ext_ack *);
	int (*port_unsplit)(struct devlink *, struct devlink_port *, struct netlink_ext_ack *);
	int (*port_type_set)(struct devlink_port *, enum devlink_port_type);
	int (*port_del)(struct devlink *, struct devlink_port *, struct netlink_ext_ack *);
	int (*port_fn_hw_addr_get)(struct devlink_port *, u8 *, int *, struct netlink_ext_ack *);
	int (*port_fn_hw_addr_set)(struct devlink_port *, const u8 *, int, struct netlink_ext_ack *);
	int (*port_fn_roce_get)(struct devlink_port *, bool *, struct netlink_ext_ack *);
	int (*port_fn_roce_set)(struct devlink_port *, bool, struct netlink_ext_ack *);
	int (*port_fn_migratable_get)(struct devlink_port *, bool *, struct netlink_ext_ack *);
	int (*port_fn_migratable_set)(struct devlink_port *, bool, struct netlink_ext_ack *);
	int (*port_fn_state_get)(struct devlink_port *, enum devlink_port_fn_state *, enum devlink_port_fn_opstate *, struct netlink_ext_ack *);
	int (*port_fn_state_set)(struct devlink_port *, enum devlink_port_fn_state, struct netlink_ext_ack *);
	int (*port_fn_ipsec_crypto_get)(struct devlink_port *, bool *, struct netlink_ext_ack *);
	int (*port_fn_ipsec_crypto_set)(struct devlink_port *, bool, struct netlink_ext_ack *);
	int (*port_fn_ipsec_packet_get)(struct devlink_port *, bool *, struct netlink_ext_ack *);
	int (*port_fn_ipsec_packet_set)(struct devlink_port *, bool, struct netlink_ext_ack *);
};

struct udp_hslot {
	struct hlist_head head;
	int count;
	spinlock_t lock;
};

struct udp_tunnel_info {
	short unsigned int type;
	sa_family_t sa_family;
	__be16 port;
	u8 hw_priv;
};

struct udp_tunnel_nic_shared {
	struct udp_tunnel_nic *udp_tunnel_nic_info;
	struct list_head devices;
};

struct xdp_attachment_info {
	struct bpf_prog *prog;
	u32 flags;
};

typedef u64 sci_t;

struct nsim_sa {
	struct xfrm_state *xs;
	__be32 ipaddr[4];
	u32 key[4];
	u32 salt;
	bool used;
	bool crypt;
	bool rx;
};

struct nsim_ipsec {
	struct nsim_sa sa[33];
	struct dentry *pfile;
	u32 count;
	u32 tx;
	u32 ok;
};

struct nsim_rxsc {
	sci_t sci;
	bool used;
};

struct nsim_secy {
	sci_t sci;
	struct nsim_rxsc nsim_rxsc[1];
	u8 nsim_rxsc_count;
	bool used;
};

struct nsim_macsec {
	struct nsim_secy nsim_secy[3];
	u8 nsim_secy_count;
};

struct nsim_ethtool_pauseparam {
	bool rx;
	bool tx;
	bool report_stats_rx;
	bool report_stats_tx;
};

struct nsim_ethtool {
	u32 get_err;
	u32 set_err;
	u32 channels;
	struct nsim_ethtool_pauseparam pauseparam;
	struct ethtool_coalesce coalesce;
	struct ethtool_ringparam ring;
	struct ethtool_fecparam fec;
};

struct mock_phc;

struct nsim_dev;

struct nsim_dev_port;

struct nsim_bus_dev;

struct netdevsim {
	struct net_device *netdev;
	struct nsim_dev *nsim_dev;
	struct nsim_dev_port *nsim_dev_port;
	struct mock_phc *phc;
	u64 tx_packets;
	u64 tx_bytes;
	struct u64_stats_sync syncp;
	struct nsim_bus_dev *nsim_bus_dev;
	struct bpf_prog *bpf_offloaded;
	u32 bpf_offloaded_id;
	struct xdp_attachment_info xdp;
	struct xdp_attachment_info xdp_hw;
	bool bpf_tc_accept;
	bool bpf_tc_non_bound_accept;
	bool bpf_xdpdrv_accept;
	bool bpf_xdpoffload_accept;
	bool bpf_map_accept;
	struct nsim_ipsec ipsec;
	struct nsim_macsec macsec;
	struct {
		u32 inject_error;
		u32 sleep;
		u32 __ports[8];
		u32 (*ports)[4];
		struct debugfs_u32_array dfs_ports[2];
	} udp_ports;
	struct nsim_ethtool ethtool;
};

struct devlink_health_reporter;

struct nsim_dev_health {
	struct devlink_health_reporter *empty_reporter;
	struct devlink_health_reporter *dummy_reporter;
	struct dentry *ddir;
	char *recovered_break_msg;
	u32 binary_len;
	bool fail_recover;
};

struct nsim_dev_hwstats {
	struct dentry *ddir;
	struct dentry *l3_ddir;
	struct mutex hwsdev_list_lock;
	struct list_head l3_list;
	struct notifier_block netdevice_nb;
	struct delayed_work traffic_dw;
};

struct nsim_dev_psample;

struct nsim_fib_data;

struct nsim_trap_data;

struct nsim_vf_config;

struct devlink_region;

struct nsim_dev {
	struct nsim_bus_dev *nsim_bus_dev;
	struct nsim_fib_data *fib_data;
	struct nsim_trap_data *trap_data;
	struct dentry *ddir;
	struct dentry *ports_ddir;
	struct dentry *take_snapshot;
	struct dentry *nodes_ddir;
	struct nsim_vf_config *vfconfigs;
	struct bpf_offload_dev *bpf_dev;
	bool bpf_bind_accept;
	bool bpf_bind_verifier_accept;
	u32 bpf_bind_verifier_delay;
	struct dentry *ddir_bpf_bound_progs;
	u32 prog_id_gen;
	struct list_head bpf_bound_progs;
	struct list_head bpf_bound_maps;
	struct netdev_phys_item_id switch_id;
	struct list_head port_list;
	bool fw_update_status;
	u32 fw_update_overwrite_mask;
	u32 max_macs;
	bool test1;
	bool dont_allow_reload;
	bool fail_reload;
	struct devlink_region *dummy_region;
	struct nsim_dev_health health;
	struct nsim_dev_hwstats hwstats;
	struct flow_action_cookie *fa_cookie;
	spinlock_t fa_cookie_lock;
	bool fail_trap_group_set;
	bool fail_trap_policer_set;
	bool fail_trap_policer_counter_get;
	bool fail_trap_drop_counter_get;
	struct {
		struct udp_tunnel_nic_shared utn_shared;
		u32 __ports[8];
		bool sync_all;
		bool open_only;
		bool ipv4_only;
		bool shared;
		bool static_iana_vxlan;
		u32 sleep;
	} udp_ports;
	struct nsim_dev_psample *psample;
	u16 esw_mode;
};

enum nsim_dev_port_type {
	NSIM_DEV_PORT_TYPE_PF = 0,
	NSIM_DEV_PORT_TYPE_VF = 1,
};

struct nsim_dev_port {
	struct list_head list;
	struct devlink_port devlink_port;
	unsigned int port_index;
	enum nsim_dev_port_type port_type;
	struct dentry *ddir;
	struct dentry *rate_parent;
	char *parent_name;
	struct netdevsim *ns;
};

struct nsim_bus_dev {
	struct device dev;
	struct list_head list;
	unsigned int port_count;
	unsigned int num_queues;
	struct net *initial_net;
	unsigned int max_vfs;
	unsigned int num_vfs;
	bool init;
};

struct nsim_vf_config {
	int link_state;
	u16 min_tx_rate;
	u16 max_tx_rate;
	u16 vlan;
	__be16 vlan_proto;
	u16 qos;
	u8 vf_mac[6];
	bool spoofchk_enabled;
	bool trusted;
	bool rss_query_enabled;
};

struct input_event {
	__kernel_ulong_t __sec;
	__kernel_ulong_t __usec;
	__u16 type;
	__u16 code;
	__s32 value;
};

struct serio_device_id {
	__u8 type;
	__u8 extra;
	__u8 id;
	__u8 proto;
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

struct ps2dev;

typedef enum ps2_disposition (*ps2_pre_receive_handler_t)(struct ps2dev *, u8, unsigned int);

typedef void (*ps2_receive_handler_t)(struct ps2dev *, u8);

struct serio;

struct ps2dev {
	struct serio *serio;
	struct mutex cmd_mutex;
	wait_queue_head_t wait;
	long unsigned int flags;
	u8 cmdbuf[8];
	u8 cmdcnt;
	u8 nak;
	ps2_pre_receive_handler_t pre_receive_handler;
	ps2_receive_handler_t receive_handler;
};

struct serio_driver;

struct serio {
	void *port_data;
	char name[32];
	char phys[32];
	char firmware_id[128];
	bool manual_bind;
	struct serio_device_id id;
	spinlock_t lock;
	int (*write)(struct serio *, unsigned char);
	int (*open)(struct serio *);
	void (*close)(struct serio *);
	int (*start)(struct serio *);
	void (*stop)(struct serio *);
	struct serio *parent;
	struct list_head child_node;
	struct list_head children;
	unsigned int depth;
	struct serio_driver *drv;
	struct mutex drv_mutex;
	struct device dev;
	struct list_head node;
	struct mutex *ps2_cmd_mutex;
};

struct serio_driver {
	const char *description;
	const struct serio_device_id *id_table;
	bool manual_bind;
	void (*write_wakeup)(struct serio *);
	irqreturn_t (*interrupt)(struct serio *, unsigned char, unsigned int);
	int (*connect)(struct serio *, struct serio_driver *);
	int (*reconnect)(struct serio *);
	int (*fast_reconnect)(struct serio *);
	void (*disconnect)(struct serio *);
	void (*cleanup)(struct serio *);
	struct device_driver driver;
};

enum psmouse_state {
	PSMOUSE_IGNORE = 0,
	PSMOUSE_INITIALIZING = 1,
	PSMOUSE_RESYNCING = 2,
	PSMOUSE_CMD_MODE = 3,
	PSMOUSE_ACTIVATED = 4,
};

typedef enum {
	PSMOUSE_BAD_DATA = 0,
	PSMOUSE_GOOD_DATA = 1,
	PSMOUSE_FULL_PACKET = 2,
} psmouse_ret_t;

enum psmouse_scale {
	PSMOUSE_SCALE11 = 0,
	PSMOUSE_SCALE21 = 1,
};

enum psmouse_type {
	PSMOUSE_NONE = 0,
	PSMOUSE_PS2 = 1,
	PSMOUSE_PS2PP = 2,
	PSMOUSE_THINKPS = 3,
	PSMOUSE_GENPS = 4,
	PSMOUSE_IMPS = 5,
	PSMOUSE_IMEX = 6,
	PSMOUSE_SYNAPTICS = 7,
	PSMOUSE_ALPS = 8,
	PSMOUSE_LIFEBOOK = 9,
	PSMOUSE_TRACKPOINT = 10,
	PSMOUSE_TOUCHKIT_PS2 = 11,
	PSMOUSE_CORTRON = 12,
	PSMOUSE_HGPK = 13,
	PSMOUSE_ELANTECH = 14,
	PSMOUSE_FSP = 15,
	PSMOUSE_SYNAPTICS_RELATIVE = 16,
	PSMOUSE_CYPRESS = 17,
	PSMOUSE_FOCALTECH = 18,
	PSMOUSE_VMMOUSE = 19,
	PSMOUSE_BYD = 20,
	PSMOUSE_SYNAPTICS_SMBUS = 21,
	PSMOUSE_ELANTECH_SMBUS = 22,
	PSMOUSE_AUTO = 23,
};

struct psmouse;

struct psmouse_protocol {
	enum psmouse_type type;
	bool maxproto;
	bool ignore_parity;
	bool try_passthru;
	bool smbus_companion;
	const char *name;
	const char *alias;
	int (*detect)(struct psmouse *, bool);
	int (*init)(struct psmouse *);
};

struct psmouse {
	void *private;
	struct input_dev *dev;
	struct ps2dev ps2dev;
	struct delayed_work resync_work;
	const char *vendor;
	const char *name;
	const struct psmouse_protocol *protocol;
	unsigned char packet[8];
	unsigned char badbyte;
	unsigned char pktcnt;
	unsigned char pktsize;
	unsigned char oob_data_type;
	unsigned char extra_buttons;
	bool acks_disable_command;
	unsigned int model;
	long unsigned int last;
	long unsigned int out_of_sync_cnt;
	long unsigned int num_resyncs;
	enum psmouse_state state;
	char devname[64];
	char phys[32];
	unsigned int rate;
	unsigned int resolution;
	unsigned int resetafter;
	unsigned int resync_time;
	bool smartscroll;
	psmouse_ret_t (*protocol_handler)(struct psmouse *);
	void (*set_rate)(struct psmouse *, unsigned int);
	void (*set_resolution)(struct psmouse *, unsigned int);
	void (*set_scale)(struct psmouse *, enum psmouse_scale);
	int (*reconnect)(struct psmouse *);
	int (*fast_reconnect)(struct psmouse *);
	void (*disconnect)(struct psmouse *);
	void (*cleanup)(struct psmouse *);
	int (*poll)(struct psmouse *);
	void (*pt_activate)(struct psmouse *);
	void (*pt_deactivate)(struct psmouse *);
};

struct byd_data {
	struct timer_list timer;
	struct psmouse *psmouse;
	s32 abs_x;
	s32 abs_y;
	volatile long unsigned int last_touch_time;
	bool btn_left;
	bool btn_right;
	bool touch;
};

enum rc_proto {
	RC_PROTO_UNKNOWN = 0,
	RC_PROTO_OTHER = 1,
	RC_PROTO_RC5 = 2,
	RC_PROTO_RC5X_20 = 3,
	RC_PROTO_RC5_SZ = 4,
	RC_PROTO_JVC = 5,
	RC_PROTO_SONY12 = 6,
	RC_PROTO_SONY15 = 7,
	RC_PROTO_SONY20 = 8,
	RC_PROTO_NEC = 9,
	RC_PROTO_NECX = 10,
	RC_PROTO_NEC32 = 11,
	RC_PROTO_SANYO = 12,
	RC_PROTO_MCIR2_KBD = 13,
	RC_PROTO_MCIR2_MSE = 14,
	RC_PROTO_RC6_0 = 15,
	RC_PROTO_RC6_6A_20 = 16,
	RC_PROTO_RC6_6A_24 = 17,
	RC_PROTO_RC6_6A_32 = 18,
	RC_PROTO_RC6_MCE = 19,
	RC_PROTO_SHARP = 20,
	RC_PROTO_XMP = 21,
	RC_PROTO_CEC = 22,
	RC_PROTO_IMON = 23,
	RC_PROTO_RCMM12 = 24,
	RC_PROTO_RCMM24 = 25,
	RC_PROTO_RCMM32 = 26,
	RC_PROTO_XBOX_DVD = 27,
	RC_PROTO_MAX = 27,
};

struct rc_map_table {
	u64 scancode;
	u32 keycode;
};

struct rc_map {
	struct rc_map_table *scan;
	unsigned int size;
	unsigned int len;
	unsigned int alloc;
	enum rc_proto rc_proto;
	const char *name;
	spinlock_t lock;
};

struct rc_map_list {
	struct list_head list;
	struct rc_map map;
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
};

struct thermal_trip {
	int temperature;
	int hysteresis;
	enum thermal_trip_type type;
	void *priv;
};

struct thermal_zone_device;

struct thermal_zone_device_ops {
	int (*bind)(struct thermal_zone_device *, struct thermal_cooling_device *);
	int (*unbind)(struct thermal_zone_device *, struct thermal_cooling_device *);
	int (*get_temp)(struct thermal_zone_device *, int *);
	int (*set_trips)(struct thermal_zone_device *, int, int);
	int (*change_mode)(struct thermal_zone_device *, enum thermal_device_mode);
	int (*set_trip_temp)(struct thermal_zone_device *, int, int);
	int (*set_trip_hyst)(struct thermal_zone_device *, int, int);
	int (*get_crit_temp)(struct thermal_zone_device *, int *);
	int (*set_emul_temp)(struct thermal_zone_device *, int);
	int (*get_trend)(struct thermal_zone_device *, const struct thermal_trip *, enum thermal_trend *);
	void (*hot)(struct thermal_zone_device *);
	void (*critical)(struct thermal_zone_device *);
};

struct thermal_attr;

struct thermal_zone_params;

struct thermal_governor;

struct thermal_zone_device {
	int id;
	char type[20];
	struct device device;
	struct attribute_group trips_attribute_group;
	struct thermal_attr *trip_temp_attrs;
	struct thermal_attr *trip_type_attrs;
	struct thermal_attr *trip_hyst_attrs;
	enum thermal_device_mode mode;
	void *devdata;
	struct thermal_trip *trips;
	int num_trips;
	long unsigned int passive_delay_jiffies;
	long unsigned int polling_delay_jiffies;
	int temperature;
	int last_temperature;
	int emul_temperature;
	int passive;
	int prev_low_trip;
	int prev_high_trip;
	atomic_t need_update;
	struct thermal_zone_device_ops *ops;
	struct thermal_zone_params *tzp;
	struct thermal_governor *governor;
	void *governor_data;
	struct list_head thermal_instances;
	struct ida ida;
	struct mutex lock;
	struct list_head node;
	struct delayed_work poll_queue;
	enum thermal_notify_event notify_event;
};

struct thermal_cooling_device_ops;

struct thermal_cooling_device {
	int id;
	char *type;
	long unsigned int max_state;
	struct device device;
	struct device_node *np;
	void *devdata;
	void *stats;
	const struct thermal_cooling_device_ops *ops;
	bool updated;
	struct mutex lock;
	struct list_head thermal_instances;
	struct list_head node;
};

struct thermal_cooling_device_ops {
	int (*get_max_state)(struct thermal_cooling_device *, long unsigned int *);
	int (*get_cur_state)(struct thermal_cooling_device *, long unsigned int *);
	int (*set_cur_state)(struct thermal_cooling_device *, long unsigned int);
	int (*get_requested_power)(struct thermal_cooling_device *, u32 *);
	int (*state2power)(struct thermal_cooling_device *, long unsigned int, u32 *);
	int (*power2state)(struct thermal_cooling_device *, u32, long unsigned int *);
};

struct thermal_attr {
	struct device_attribute attr;
	char name[20];
};

struct thermal_zone_params {
	char governor_name[20];
	bool no_hwmon;
	u32 sustainable_power;
	s32 k_po;
	s32 k_pu;
	s32 k_i;
	s32 k_d;
	s32 integral_cutoff;
	int slope;
	int offset;
};

struct thermal_governor {
	char name[20];
	int (*bind_to_tz)(struct thermal_zone_device *);
	void (*unbind_from_tz)(struct thermal_zone_device *);
	int (*throttle)(struct thermal_zone_device *, const struct thermal_trip *);
	struct list_head governor_list;
};

struct thermal_instance {
	int id;
	char name[20];
	struct thermal_zone_device *tz;
	struct thermal_cooling_device *cdev;
	const struct thermal_trip *trip;
	bool initialized;
	long unsigned int upper;
	long unsigned int lower;
	long unsigned int target;
	char attr_name[20];
	struct device_attribute attr;
	char weight_attr_name[20];
	struct device_attribute weight_attr;
	struct list_head tz_node;
	struct list_head cdev_node;
	unsigned int weight;
	bool upper_no_limit;
};

struct clk;

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

struct cpufreq_cpuinfo {
	unsigned int max_freq;
	unsigned int min_freq;
	unsigned int transition_latency;
};

struct cpufreq_governor;

struct cpufreq_frequency_table;

struct cpufreq_stats;

struct cpufreq_policy {
	cpumask_var_t cpus;
	cpumask_var_t related_cpus;
	cpumask_var_t real_cpus;
	unsigned int shared_type;
	unsigned int cpu;
	struct clk *clk;
	struct cpufreq_cpuinfo cpuinfo;
	unsigned int min;
	unsigned int max;
	unsigned int cur;
	unsigned int suspend_freq;
	unsigned int policy;
	unsigned int last_policy;
	struct cpufreq_governor *governor;
	void *governor_data;
	char last_governor[16];
	struct work_struct update;
	struct freq_constraints constraints;
	struct freq_qos_request *min_freq_req;
	struct freq_qos_request *max_freq_req;
	struct cpufreq_frequency_table *freq_table;
	enum cpufreq_table_sorting freq_table_sorted;
	struct list_head policy_list;
	struct kobject kobj;
	struct completion kobj_unregister;
	struct rw_semaphore rwsem;
	bool fast_switch_possible;
	bool fast_switch_enabled;
	bool strict_target;
	bool efficiencies_available;
	unsigned int transition_delay_us;
	bool dvfs_possible_from_any_cpu;
	bool boost_enabled;
	unsigned int cached_target_freq;
	unsigned int cached_resolved_idx;
	bool transition_ongoing;
	spinlock_t transition_lock;
	wait_queue_head_t transition_wait;
	struct task_struct *transition_task;
	struct cpufreq_stats *stats;
	void *driver_data;
	struct thermal_cooling_device *cdev;
	struct notifier_block nb_min;
	struct notifier_block nb_max;
};

struct cpufreq_governor {
	char name[16];
	int (*init)(struct cpufreq_policy *);
	void (*exit)(struct cpufreq_policy *);
	int (*start)(struct cpufreq_policy *);
	void (*stop)(struct cpufreq_policy *);
	void (*limits)(struct cpufreq_policy *);
	ssize_t (*show_setspeed)(struct cpufreq_policy *, char *);
	int (*store_setspeed)(struct cpufreq_policy *, unsigned int);
	struct list_head governor_list;
	struct module *owner;
	u8 flags;
};

struct cpufreq_frequency_table {
	unsigned int flags;
	unsigned int driver_data;
	unsigned int frequency;
};

struct cpufreq_policy_data {
	struct cpufreq_cpuinfo cpuinfo;
	struct cpufreq_frequency_table *freq_table;
	unsigned int cpu;
	unsigned int min;
	unsigned int max;
};

struct cpufreq_freqs {
	struct cpufreq_policy *policy;
	unsigned int old;
	unsigned int new;
	u8 flags;
};

struct freq_attr {
	struct attribute attr;
	ssize_t (*show)(struct cpufreq_policy *, char *);
	ssize_t (*store)(struct cpufreq_policy *, const char *, size_t);
};

struct cpufreq_driver {
	char name[16];
	u16 flags;
	void *driver_data;
	int (*init)(struct cpufreq_policy *);
	int (*verify)(struct cpufreq_policy_data *);
	int (*setpolicy)(struct cpufreq_policy *);
	int (*target)(struct cpufreq_policy *, unsigned int, unsigned int);
	int (*target_index)(struct cpufreq_policy *, unsigned int);
	unsigned int (*fast_switch)(struct cpufreq_policy *, unsigned int);
	void (*adjust_perf)(unsigned int, long unsigned int, long unsigned int, long unsigned int);
	unsigned int (*get_intermediate)(struct cpufreq_policy *, unsigned int);
	int (*target_intermediate)(struct cpufreq_policy *, unsigned int);
	unsigned int (*get)(unsigned int);
	void (*update_limits)(unsigned int);
	int (*bios_limit)(int, unsigned int *);
	int (*online)(struct cpufreq_policy *);
	int (*offline)(struct cpufreq_policy *);
	int (*exit)(struct cpufreq_policy *);
	int (*suspend)(struct cpufreq_policy *);
	int (*resume)(struct cpufreq_policy *);
	void (*ready)(struct cpufreq_policy *);
	struct freq_attr **attr;
	bool boost_enabled;
	int (*set_boost)(struct cpufreq_policy *, int);
	void (*register_em)(struct cpufreq_policy *);
};

typedef u8 acpi_adr_space_type;

struct acpi_psd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

struct acpi_pct_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_processor_px {
	u64 core_frequency;
	u64 power;
	u64 transition_latency;
	u64 bus_master_latency;
	u64 control;
	u64 status;
};

struct acpi_processor_performance {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_px *states;
	struct acpi_psd_package domain_info;
	cpumask_var_t shared_cpu_map;
	unsigned int shared_type;
};

struct powernow_k8_data {
	unsigned int cpu;
	u32 numps;
	u32 batps;
	u32 rvo;
	u32 irt;
	u32 vidmvs;
	u32 vstable;
	u32 plllock;
	u32 exttype;
	u32 currvid;
	u32 currfid;
	struct cpufreq_frequency_table *powernow_table;
	struct acpi_processor_performance acpi_data;
	struct cpumask *available_cores;
};

struct psb_s {
	u8 signature[10];
	u8 tableversion;
	u8 flags1;
	u16 vstable;
	u8 flags2;
	u8 num_tables;
	u32 cpuid;
	u8 plllocktime;
	u8 maxfid;
	u8 maxvid;
	u8 numps;
};

struct pst_s {
	u8 fid;
	u8 vid;
};

struct powernowk8_target_arg {
	struct cpufreq_policy *pol;
	unsigned int newstate;
};

struct init_on_cpu {
	struct powernow_k8_data *data;
	int rc;
};

typedef long unsigned int efi_status_t;

typedef u8 efi_bool_t;

typedef u16 efi_char16_t;

typedef guid_t efi_guid_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef efi_status_t efi_get_time_t(efi_time_t *, efi_time_cap_t *);

typedef efi_status_t efi_set_time_t(efi_time_t *);

typedef efi_status_t efi_get_wakeup_time_t(efi_bool_t *, efi_bool_t *, efi_time_t *);

typedef efi_status_t efi_set_wakeup_time_t(efi_bool_t, efi_time_t *);

typedef efi_status_t efi_get_variable_t(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);

typedef efi_status_t efi_get_next_variable_t(long unsigned int *, efi_char16_t *, efi_guid_t *);

typedef efi_status_t efi_set_variable_t(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);

typedef efi_status_t efi_get_next_high_mono_count_t(u32 *);

typedef void efi_reset_system_t(int, efi_status_t, long unsigned int, efi_char16_t *);

typedef efi_status_t efi_query_variable_info_t(u32, u64 *, u64 *, u64 *);

typedef efi_status_t efi_update_capsule_t(efi_capsule_header_t **, long unsigned int, long unsigned int);

typedef efi_status_t efi_query_capsule_caps_t(efi_capsule_header_t **, long unsigned int, u64 *, int *);

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_status_t (*get_time)(efi_time_t *, efi_time_cap_t *);
		efi_status_t (*set_time)(efi_time_t *);
		efi_status_t (*get_wakeup_time)(efi_bool_t *, efi_bool_t *, efi_time_t *);
		efi_status_t (*set_wakeup_time)(efi_bool_t, efi_time_t *);
		efi_status_t (*set_virtual_address_map)(long unsigned int, long unsigned int, u32, efi_memory_desc_t *);
		void *convert_pointer;
		efi_status_t (*get_variable)(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);
		efi_status_t (*get_next_variable)(long unsigned int *, efi_char16_t *, efi_guid_t *);
		efi_status_t (*set_variable)(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);
		efi_status_t (*get_next_high_mono_count)(u32 *);
		void (*reset_system)(int, efi_status_t, long unsigned int, efi_char16_t *);
		efi_status_t (*update_capsule)(efi_capsule_header_t **, long unsigned int, long unsigned int);
		efi_status_t (*query_capsule_caps)(efi_capsule_header_t **, long unsigned int, u64 *, int *);
		efi_status_t (*query_variable_info)(u32, u64 *, u64 *, u64 *);
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

struct efi_memory_map_data {
	phys_addr_t phys_map;
	long unsigned int size;
	long unsigned int desc_version;
	long unsigned int desc_size;
	long unsigned int flags;
};

struct efi_memory_map {
	phys_addr_t phys_map;
	void *map;
	void *map_end;
	int nr_map;
	long unsigned int desc_version;
	long unsigned int desc_size;
	long unsigned int flags;
};

struct efi {
	const efi_runtime_services_t *runtime;
	unsigned int runtime_version;
	unsigned int runtime_supported_mask;
	long unsigned int acpi;
	long unsigned int acpi20;
	long unsigned int smbios;
	long unsigned int smbios3;
	long unsigned int esrt;
	long unsigned int tpm_log;
	long unsigned int tpm_final_log;
	long unsigned int mokvar_table;
	long unsigned int coco_secret;
	long unsigned int unaccepted;
	efi_get_time_t *get_time;
	efi_set_time_t *set_time;
	efi_get_wakeup_time_t *get_wakeup_time;
	efi_set_wakeup_time_t *set_wakeup_time;
	efi_get_variable_t *get_variable;
	efi_get_next_variable_t *get_next_variable;
	efi_set_variable_t *set_variable;
	efi_set_variable_t *set_variable_nonblocking;
	efi_query_variable_info_t *query_variable_info;
	efi_query_variable_info_t *query_variable_info_nonblocking;
	efi_update_capsule_t *update_capsule;
	efi_query_capsule_caps_t *query_capsule_caps;
	efi_get_next_high_mono_count_t *get_next_high_mono_count;
	efi_reset_system_t *reset_system;
	struct efi_memory_map memmap;
	long unsigned int flags;
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

struct font_desc {
	int idx;
	const char *name;
	unsigned int width;
	unsigned int height;
	unsigned int charcount;
	const void *data;
	int pref;
};

struct circ_buf {
	char *buf;
	int head;
	int tail;
};

struct serial_icounter_struct {
	int cts;
	int dsr;
	int rng;
	int dcd;
	int rx;
	int tx;
	int frame;
	int overrun;
	int parity;
	int brk;
	int buf_overrun;
	int reserved[9];
};

struct serial_struct {
	int type;
	int line;
	unsigned int port;
	int irq;
	int flags;
	int xmit_fifo_size;
	int custom_divisor;
	int baud_base;
	short unsigned int close_delay;
	char io_type;
	char reserved_char[1];
	int hub6;
	short unsigned int closing_wait;
	short unsigned int closing_wait2;
	unsigned char *iomem_base;
	short unsigned int iomem_reg_shift;
	unsigned int port_high;
	long unsigned int iomap_base;
};

struct serial_rs485 {
	__u32 flags;
	__u32 delay_rts_before_send;
	__u32 delay_rts_after_send;
	union {
		__u32 padding[5];
		struct {
			__u8 addr_recv;
			__u8 addr_dest;
			__u8 padding0[2];
			__u32 padding1[4];
		};
	};
};

struct serial_iso7816 {
	__u32 flags;
	__u32 tg;
	__u32 sc_fi;
	__u32 sc_di;
	__u32 clk;
	__u32 reserved[5];
};

struct uart_port;

struct uart_ops {
	unsigned int (*tx_empty)(struct uart_port *);
	void (*set_mctrl)(struct uart_port *, unsigned int);
	unsigned int (*get_mctrl)(struct uart_port *);
	void (*stop_tx)(struct uart_port *);
	void (*start_tx)(struct uart_port *);
	void (*throttle)(struct uart_port *);
	void (*unthrottle)(struct uart_port *);
	void (*send_xchar)(struct uart_port *, char);
	void (*stop_rx)(struct uart_port *);
	void (*start_rx)(struct uart_port *);
	void (*enable_ms)(struct uart_port *);
	void (*break_ctl)(struct uart_port *, int);
	int (*startup)(struct uart_port *);
	void (*shutdown)(struct uart_port *);
	void (*flush_buffer)(struct uart_port *);
	void (*set_termios)(struct uart_port *, struct ktermios *, const struct ktermios *);
	void (*set_ldisc)(struct uart_port *, struct ktermios *);
	void (*pm)(struct uart_port *, unsigned int, unsigned int);
	const char * (*type)(struct uart_port *);
	void (*release_port)(struct uart_port *);
	int (*request_port)(struct uart_port *);
	void (*config_port)(struct uart_port *, int);
	int (*verify_port)(struct uart_port *, struct serial_struct *);
	int (*ioctl)(struct uart_port *, unsigned int, long unsigned int);
};

struct uart_icount {
	__u32 cts;
	__u32 dsr;
	__u32 rng;
	__u32 dcd;
	__u32 rx;
	__u32 tx;
	__u32 frame;
	__u32 overrun;
	__u32 parity;
	__u32 brk;
	__u32 buf_overrun;
};

typedef u64 upf_t;

typedef unsigned int upstat_t;

struct uart_state;

struct serial_port_device;

struct uart_port {
	spinlock_t lock;
	long unsigned int iobase;
	unsigned char *membase;
	unsigned int (*serial_in)(struct uart_port *, int);
	void (*serial_out)(struct uart_port *, int, int);
	void (*set_termios)(struct uart_port *, struct ktermios *, const struct ktermios *);
	void (*set_ldisc)(struct uart_port *, struct ktermios *);
	unsigned int (*get_mctrl)(struct uart_port *);
	void (*set_mctrl)(struct uart_port *, unsigned int);
	unsigned int (*get_divisor)(struct uart_port *, unsigned int, unsigned int *);
	void (*set_divisor)(struct uart_port *, unsigned int, unsigned int, unsigned int);
	int (*startup)(struct uart_port *);
	void (*shutdown)(struct uart_port *);
	void (*throttle)(struct uart_port *);
	void (*unthrottle)(struct uart_port *);
	int (*handle_irq)(struct uart_port *);
	void (*pm)(struct uart_port *, unsigned int, unsigned int);
	void (*handle_break)(struct uart_port *);
	int (*rs485_config)(struct uart_port *, struct ktermios *, struct serial_rs485 *);
	int (*iso7816_config)(struct uart_port *, struct serial_iso7816 *);
	unsigned int ctrl_id;
	unsigned int port_id;
	unsigned int irq;
	long unsigned int irqflags;
	unsigned int uartclk;
	unsigned int fifosize;
	unsigned char x_char;
	unsigned char regshift;
	unsigned char iotype;
	unsigned char quirks;
	unsigned int read_status_mask;
	unsigned int ignore_status_mask;
	struct uart_state *state;
	struct uart_icount icount;
	struct console *cons;
	upf_t flags;
	upstat_t status;
	bool hw_stopped;
	unsigned int mctrl;
	unsigned int frame_time;
	unsigned int type;
	const struct uart_ops *ops;
	unsigned int custom_divisor;
	unsigned int line;
	unsigned int minor;
	resource_size_t mapbase;
	resource_size_t mapsize;
	struct device *dev;
	struct serial_port_device *port_dev;
	long unsigned int sysrq;
	u8 sysrq_ch;
	unsigned char has_sysrq;
	unsigned char sysrq_seq;
	unsigned char hub6;
	unsigned char suspended;
	unsigned char console_reinit;
	const char *name;
	struct attribute_group *attr_group;
	const struct attribute_group **tty_groups;
	struct serial_rs485 rs485;
	struct serial_rs485 rs485_supported;
	struct gpio_desc *rs485_term_gpio;
	struct gpio_desc *rs485_rx_during_tx_gpio;
	struct serial_iso7816 iso7816;
	void *private_data;
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

struct uart_state {
	struct tty_port port;
	enum uart_pm_state pm_state;
	struct circ_buf xmit;
	atomic_t refcount;
	wait_queue_head_t remove_wait;
	struct uart_port *uart_port;
};

struct earlycon_device {
	struct console *con;
	struct uart_port port;
	char options[32];
	unsigned int baud;
};

struct earlycon_id {
	char name[15];
	char name_term;
	char compatible[128];
	int (*setup)(struct earlycon_device *, const char *);
};

struct semaphore {
	raw_spinlock_t lock;
	unsigned int count;
	struct list_head wait_list;
};

struct hid_device_id {
	__u16 bus;
	__u16 group;
	__u32 vendor;
	__u32 product;
	kernel_ulong_t driver_data;
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

struct hid_report;

struct hid_report_enum {
	unsigned int numbered;
	struct list_head report_list;
	struct hid_report *report_id_hash[256];
};

struct hid_bpf_prog_list;

struct hid_bpf {
	u8 *device_data;
	u32 allocated_data;
	struct hid_bpf_prog_list *progs[2];
	bool destroyed;
	spinlock_t progs_lock;
};

struct hid_collection;

struct hid_driver;

struct hid_ll_driver;

struct hid_field;

struct hid_usage;

struct hid_device {
	__u8 *dev_rdesc;
	unsigned int dev_rsize;
	__u8 *rdesc;
	unsigned int rsize;
	struct hid_collection *collection;
	unsigned int collection_size;
	unsigned int maxcollection;
	unsigned int maxapplication;
	__u16 bus;
	__u16 group;
	__u32 vendor;
	__u32 product;
	__u32 version;
	enum hid_type type;
	unsigned int country;
	struct hid_report_enum report_enum[3];
	struct work_struct led_work;
	struct semaphore driver_input_lock;
	struct device dev;
	struct hid_driver *driver;
	void *devres_group_id;
	const struct hid_ll_driver *ll_driver;
	struct mutex ll_open_lock;
	unsigned int ll_open_count;
	long unsigned int status;
	unsigned int claimed;
	unsigned int quirks;
	unsigned int initial_quirks;
	bool io_started;
	struct list_head inputs;
	void *hiddev;
	void *hidraw;
	char name[128];
	char phys[64];
	char uniq[64];
	void *driver_data;
	int (*ff_init)(struct hid_device *);
	int (*hiddev_connect)(struct hid_device *, unsigned int);
	void (*hiddev_disconnect)(struct hid_device *);
	void (*hiddev_hid_event)(struct hid_device *, struct hid_field *, struct hid_usage *, __s32);
	void (*hiddev_report_event)(struct hid_device *, struct hid_report *);
	short unsigned int debug;
	struct dentry *debug_dir;
	struct dentry *debug_rdesc;
	struct dentry *debug_events;
	struct list_head debug_list;
	spinlock_t debug_list_lock;
	wait_queue_head_t debug_wait;
	unsigned int id;
	struct hid_bpf bpf;
};

enum hid_bpf_prog_type {
	HID_BPF_PROG_TYPE_UNDEF = -1,
	HID_BPF_PROG_TYPE_DEVICE_EVENT = 0,
	HID_BPF_PROG_TYPE_RDESC_FIXUP = 1,
	HID_BPF_PROG_TYPE_MAX = 2,
};

struct hid_field_entry;

struct hid_report {
	struct list_head list;
	struct list_head hidinput_list;
	struct list_head field_entry_list;
	unsigned int id;
	enum hid_report_type type;
	unsigned int application;
	struct hid_field *field[256];
	struct hid_field_entry *field_entries;
	unsigned int maxfield;
	unsigned int size;
	struct hid_device *device;
	bool tool_active;
	unsigned int tool;
};

struct hid_bpf_prog_list {
	u16 prog_idx[64];
	u8 prog_cnt;
};

struct hid_collection {
	int parent_idx;
	unsigned int type;
	unsigned int usage;
	unsigned int level;
};

struct hid_usage {
	unsigned int hid;
	unsigned int collection_index;
	unsigned int usage_index;
	__s8 resolution_multiplier;
	__s8 wheel_factor;
	__u16 code;
	__u8 type;
	__s8 hat_min;
	__s8 hat_max;
	__s8 hat_dir;
	__s16 wheel_accumulated;
};

struct hid_input;

struct hid_field {
	unsigned int physical;
	unsigned int logical;
	unsigned int application;
	struct hid_usage *usage;
	unsigned int maxusage;
	unsigned int flags;
	unsigned int report_offset;
	unsigned int report_size;
	unsigned int report_count;
	unsigned int report_type;
	__s32 *value;
	__s32 *new_value;
	__s32 *usages_priorities;
	__s32 logical_minimum;
	__s32 logical_maximum;
	__s32 physical_minimum;
	__s32 physical_maximum;
	__s32 unit_exponent;
	unsigned int unit;
	bool ignored;
	struct hid_report *report;
	unsigned int index;
	struct hid_input *hidinput;
	__u16 dpad;
	unsigned int slot_idx;
};

struct hid_input {
	struct list_head list;
	struct hid_report *report;
	struct input_dev *input;
	const char *name;
	struct list_head reports;
	unsigned int application;
	bool registered;
};

struct hid_field_entry {
	struct list_head list;
	struct hid_field *field;
	unsigned int index;
	__s32 priority;
};

struct hid_report_id;

struct hid_usage_id;

struct hid_driver {
	char *name;
	const struct hid_device_id *id_table;
	struct list_head dyn_list;
	spinlock_t dyn_lock;
	bool (*match)(struct hid_device *, bool);
	int (*probe)(struct hid_device *, const struct hid_device_id *);
	void (*remove)(struct hid_device *);
	const struct hid_report_id *report_table;
	int (*raw_event)(struct hid_device *, struct hid_report *, u8 *, int);
	const struct hid_usage_id *usage_table;
	int (*event)(struct hid_device *, struct hid_field *, struct hid_usage *, __s32);
	void (*report)(struct hid_device *, struct hid_report *);
	__u8 * (*report_fixup)(struct hid_device *, __u8 *, unsigned int *);
	int (*input_mapping)(struct hid_device *, struct hid_input *, struct hid_field *, struct hid_usage *, long unsigned int **, int *);
	int (*input_mapped)(struct hid_device *, struct hid_input *, struct hid_field *, struct hid_usage *, long unsigned int **, int *);
	int (*input_configured)(struct hid_device *, struct hid_input *);
	void (*feature_mapping)(struct hid_device *, struct hid_field *, struct hid_usage *);
	int (*suspend)(struct hid_device *, pm_message_t);
	int (*resume)(struct hid_device *);
	int (*reset_resume)(struct hid_device *);
	struct device_driver driver;
};

struct hid_ll_driver {
	int (*start)(struct hid_device *);
	void (*stop)(struct hid_device *);
	int (*open)(struct hid_device *);
	void (*close)(struct hid_device *);
	int (*power)(struct hid_device *, int);
	int (*parse)(struct hid_device *);
	void (*request)(struct hid_device *, struct hid_report *, int);
	int (*wait)(struct hid_device *);
	int (*raw_request)(struct hid_device *, unsigned char, __u8 *, size_t, unsigned char, int);
	int (*output_report)(struct hid_device *, __u8 *, size_t);
	int (*idle)(struct hid_device *, int, int, int);
	bool (*may_wakeup)(struct hid_device *);
	unsigned int max_buffer_size;
};

struct hid_report_id {
	__u32 report_type;
};

struct hid_usage_id {
	__u32 usage_hid;
	__u32 usage_type;
	__u32 usage_code;
};

struct idle_inject_thread {
	struct task_struct *tsk;
	int should_run;
};

struct idle_inject_device {
	struct hrtimer timer;
	unsigned int idle_duration_us;
	unsigned int run_duration_us;
	unsigned int latency_us;
	bool (*update)();
	long unsigned int cpumask[0];
};

struct minmax_sample {
	u32 t;
	u32 v;
};

struct minmax {
	struct minmax_sample s[3];
};

struct fastopen_queue {
	struct request_sock *rskq_rst_head;
	struct request_sock *rskq_rst_tail;
	spinlock_t lock;
	int qlen;
	int max_qlen;
	struct tcp_fastopen_context *ctx;
};

struct request_sock_queue {
	spinlock_t rskq_lock;
	u8 rskq_defer_accept;
	u32 synflood_warned;
	atomic_t qlen;
	atomic_t young;
	struct request_sock *rskq_accept_head;
	struct request_sock *rskq_accept_tail;
	struct fastopen_queue fastopenq;
};

struct inet_request_sock {
	struct request_sock req;
	u16 snd_wscale: 4;
	u16 rcv_wscale: 4;
	u16 tstamp_ok: 1;
	u16 sack_ok: 1;
	u16 wscale_ok: 1;
	u16 ecn_ok: 1;
	u16 acked: 1;
	u16 no_srccheck: 1;
	u16 smc_ok: 1;
	u32 ir_mark;
	union {
		struct ip_options_rcu *ireq_opt;
		struct {
			struct ipv6_txoptions *ipv6_opt;
			struct sk_buff *pktopts;
		};
	};
};

struct inet_connection_sock_af_ops {
	int (*queue_xmit)(struct sock *, struct sk_buff *, struct flowi *);
	void (*send_check)(struct sock *, struct sk_buff *);
	int (*rebuild_header)(struct sock *);
	void (*sk_rx_dst_set)(struct sock *, const struct sk_buff *);
	int (*conn_request)(struct sock *, struct sk_buff *);
	struct sock * (*syn_recv_sock)(const struct sock *, struct sk_buff *, struct request_sock *, struct dst_entry *, struct request_sock *, bool *);
	u16 net_header_len;
	u16 sockaddr_len;
	int (*setsockopt)(struct sock *, int, int, sockptr_t, unsigned int);
	int (*getsockopt)(struct sock *, int, int, char *, int *);
	void (*addr2sockaddr)(struct sock *, struct sockaddr *);
	void (*mtu_reduced)(struct sock *);
};

struct inet_bind_bucket;

struct inet_bind2_bucket;

struct tcp_ulp_ops;

struct inet_connection_sock {
	struct inet_sock icsk_inet;
	struct request_sock_queue icsk_accept_queue;
	struct inet_bind_bucket *icsk_bind_hash;
	struct inet_bind2_bucket *icsk_bind2_hash;
	long unsigned int icsk_timeout;
	struct timer_list icsk_retransmit_timer;
	struct timer_list icsk_delack_timer;
	__u32 icsk_rto;
	__u32 icsk_rto_min;
	__u32 icsk_delack_max;
	__u32 icsk_pmtu_cookie;
	const struct tcp_congestion_ops *icsk_ca_ops;
	const struct inet_connection_sock_af_ops *icsk_af_ops;
	const struct tcp_ulp_ops *icsk_ulp_ops;
	void *icsk_ulp_data;
	void (*icsk_clean_acked)(struct sock *, u32);
	unsigned int (*icsk_sync_mss)(struct sock *, u32);
	__u8 icsk_ca_state: 5;
	__u8 icsk_ca_initialized: 1;
	__u8 icsk_ca_setsockopt: 1;
	__u8 icsk_ca_dst_locked: 1;
	__u8 icsk_retransmits;
	__u8 icsk_pending;
	__u8 icsk_backoff;
	__u8 icsk_syn_retries;
	__u8 icsk_probes_out;
	__u16 icsk_ext_hdr_len;
	struct {
		__u8 pending;
		__u8 quick;
		__u8 pingpong;
		__u8 retry;
		__u32 ato: 8;
		__u32 lrcv_flowlabel: 20;
		__u32 unused: 4;
		long unsigned int timeout;
		__u32 lrcvtime;
		__u16 last_seg_size;
		__u16 rcv_mss;
	} icsk_ack;
	struct {
		int search_high;
		int search_low;
		u32 probe_size: 31;
		u32 enabled: 1;
		u32 probe_timestamp;
	} icsk_mtup;
	u32 icsk_probes_tstamp;
	u32 icsk_user_timeout;
	u64 icsk_ca_priv[13];
};

struct tcp_ulp_ops {
	struct list_head list;
	int (*init)(struct sock *);
	void (*update)(struct sock *, struct proto *, void (*)(struct sock *));
	void (*release)(struct sock *);
	int (*get_info)(const struct sock *, struct sk_buff *);
	size_t (*get_info_size)(const struct sock *);
	void (*clone)(const struct request_sock *, struct sock *, const gfp_t);
	char name[16];
	struct module *owner;
};

struct tcp_sack_block {
	u32 start_seq;
	u32 end_seq;
};

struct tcp_options_received {
	int ts_recent_stamp;
	u32 ts_recent;
	u32 rcv_tsval;
	u32 rcv_tsecr;
	u16 saw_tstamp: 1;
	u16 tstamp_ok: 1;
	u16 dsack: 1;
	u16 wscale_ok: 1;
	u16 sack_ok: 3;
	u16 smc_ok: 1;
	u16 snd_wscale: 4;
	u16 rcv_wscale: 4;
	u8 saw_unknown: 1;
	u8 unused: 7;
	u8 num_sacks;
	u16 user_mss;
	u16 mss_clamp;
};

struct tcp_request_sock_ops;

struct tcp_request_sock {
	struct inet_request_sock req;
	const struct tcp_request_sock_ops *af_specific;
	u64 snt_synack;
	bool tfo_listener;
	bool is_mptcp;
	s8 req_usec_ts;
	bool drop_req;
	u32 txhash;
	u32 rcv_isn;
	u32 snt_isn;
	u32 ts_off;
	u32 last_oow_ack_time;
	u32 rcv_nxt;
	u8 syn_tos;
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

struct tcp_md5sig_key;

struct tcp_fastopen_cookie;

struct tcp_request_sock_ops {
	u16 mss_clamp;
	struct tcp_md5sig_key * (*req_md5_lookup)(const struct sock *, const struct sock *);
	int (*calc_md5_hash)(char *, const struct tcp_md5sig_key *, const struct sock *, const struct sk_buff *);
	__u32 (*cookie_init_seq)(const struct sk_buff *, __u16 *);
	struct dst_entry * (*route_req)(const struct sock *, struct sk_buff *, struct flowi *, struct request_sock *);
	u32 (*init_seq)(const struct sk_buff *);
	u32 (*init_ts_off)(const struct net *, const struct sk_buff *);
	int (*send_synack)(const struct sock *, struct dst_entry *, struct flowi *, struct request_sock *, struct tcp_fastopen_cookie *, enum tcp_synack_type, struct sk_buff *);
};

struct tcp_rack {
	u64 mstamp;
	u32 rtt_us;
	u32 end_seq;
	u32 last_delivered;
	u8 reo_wnd_steps;
	u8 reo_wnd_persist: 5;
	u8 dsack_seen: 1;
	u8 advanced: 1;
};

struct tcp_sock_af_ops;

struct tcp_md5sig_info;

struct tcp_fastopen_request;

struct tcp_sock {
	struct inet_connection_sock inet_conn;
	u16 tcp_header_len;
	u16 gso_segs;
	__be32 pred_flags;
	u64 bytes_received;
	u32 segs_in;
	u32 data_segs_in;
	u32 rcv_nxt;
	u32 copied_seq;
	u32 rcv_wup;
	u32 snd_nxt;
	u32 segs_out;
	u32 data_segs_out;
	u64 bytes_sent;
	u64 bytes_acked;
	u32 dsack_dups;
	u32 snd_una;
	u32 snd_sml;
	u32 rcv_tstamp;
	u32 lsndtime;
	u32 last_oow_ack_time;
	u32 compressed_ack_rcv_nxt;
	u32 tsoffset;
	struct list_head tsq_node;
	struct list_head tsorted_sent_queue;
	u32 snd_wl1;
	u32 snd_wnd;
	u32 max_window;
	u32 mss_cache;
	u32 window_clamp;
	u32 rcv_ssthresh;
	u8 scaling_ratio;
	struct tcp_rack rack;
	u16 advmss;
	u8 compressed_ack;
	u8 dup_ack_counter: 2;
	u8 tlp_retrans: 1;
	u8 tcp_usec_ts: 1;
	u8 unused: 4;
	u32 chrono_start;
	u32 chrono_stat[3];
	u8 chrono_type: 2;
	u8 rate_app_limited: 1;
	u8 fastopen_connect: 1;
	u8 fastopen_no_cookie: 1;
	u8 is_sack_reneg: 1;
	u8 fastopen_client_fail: 2;
	u8 nonagle: 4;
	u8 thin_lto: 1;
	u8 recvmsg_inq: 1;
	u8 repair: 1;
	u8 frto: 1;
	u8 repair_queue;
	u8 save_syn: 2;
	u8 syn_data: 1;
	u8 syn_fastopen: 1;
	u8 syn_fastopen_exp: 1;
	u8 syn_fastopen_ch: 1;
	u8 syn_data_acked: 1;
	u8 is_cwnd_limited: 1;
	u32 tlp_high_seq;
	u32 tcp_tx_delay;
	u64 tcp_wstamp_ns;
	u64 tcp_clock_cache;
	u64 tcp_mstamp;
	u32 srtt_us;
	u32 mdev_us;
	u32 mdev_max_us;
	u32 rttvar_us;
	u32 rtt_seq;
	struct minmax rtt_min;
	u32 packets_out;
	u32 retrans_out;
	u32 max_packets_out;
	u32 cwnd_usage_seq;
	u16 urg_data;
	u8 ecn_flags;
	u8 keepalive_probes;
	u32 reordering;
	u32 reord_seen;
	u32 snd_up;
	struct tcp_options_received rx_opt;
	u32 snd_ssthresh;
	u32 snd_cwnd;
	u32 snd_cwnd_cnt;
	u32 snd_cwnd_clamp;
	u32 snd_cwnd_used;
	u32 snd_cwnd_stamp;
	u32 prior_cwnd;
	u32 prr_delivered;
	u32 prr_out;
	u32 delivered;
	u32 delivered_ce;
	u32 lost;
	u32 app_limited;
	u64 first_tx_mstamp;
	u64 delivered_mstamp;
	u32 rate_delivered;
	u32 rate_interval_us;
	u32 rcv_wnd;
	u32 write_seq;
	u32 notsent_lowat;
	u32 pushed_seq;
	u32 lost_out;
	u32 sacked_out;
	struct hrtimer pacing_timer;
	struct hrtimer compressed_ack_timer;
	struct sk_buff *lost_skb_hint;
	struct sk_buff *retransmit_skb_hint;
	struct rb_root out_of_order_queue;
	struct sk_buff *ooo_last_skb;
	struct tcp_sack_block duplicate_sack[1];
	struct tcp_sack_block selective_acks[4];
	struct tcp_sack_block recv_sack_cache[4];
	struct sk_buff *highest_sack;
	int lost_cnt_hint;
	u32 prior_ssthresh;
	u32 high_seq;
	u32 retrans_stamp;
	u32 undo_marker;
	int undo_retrans;
	u64 bytes_retrans;
	u32 total_retrans;
	u32 rto_stamp;
	u16 total_rto;
	u16 total_rto_recoveries;
	u32 total_rto_time;
	u32 urg_seq;
	unsigned int keepalive_time;
	unsigned int keepalive_intvl;
	int linger2;
	u8 bpf_sock_ops_cb_flags;
	u8 bpf_chg_cc_inprogress: 1;
	u16 timeout_rehash;
	u32 rcv_ooopack;
	u32 rcv_rtt_last_tsecr;
	struct {
		u32 rtt_us;
		u32 seq;
		u64 time;
	} rcv_rtt_est;
	struct {
		u32 space;
		u32 seq;
		u64 time;
	} rcvq_space;
	struct {
		u32 probe_seq_start;
		u32 probe_seq_end;
	} mtu_probe;
	u32 plb_rehash;
	u32 mtu_info;
	bool is_mptcp;
	const struct tcp_sock_af_ops *af_specific;
	struct tcp_md5sig_info *md5sig_info;
	struct tcp_fastopen_request *fastopen_req;
	struct request_sock *fastopen_rsk;
	struct saved_syn *saved_syn;
};

struct tcp_sock_af_ops {
	struct tcp_md5sig_key * (*md5_lookup)(const struct sock *, const struct sock *);
	int (*calc_md5_hash)(char *, const struct tcp_md5sig_key *, const struct sock *, const struct sk_buff *);
	int (*md5_parse)(struct sock *, int, sockptr_t, int);
};

struct hlist_nulls_head {
	struct hlist_nulls_node *first;
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

struct scm_creds {
	u32 pid;
	kuid_t uid;
	kgid_t gid;
};

struct netlink_skb_parms {
	struct scm_creds creds;
	__u32 portid;
	__u32 dst_group;
	__u32 flags;
	struct sock *sk;
	bool nsid_is_set;
	int nsid;
};

struct netlink_kernel_cfg {
	unsigned int groups;
	unsigned int flags;
	void (*input)(struct sk_buff *);
	struct mutex *cb_mutex;
	int (*bind)(struct net *, int);
	void (*unbind)(struct net *, int);
	void (*release)(struct sock *, long unsigned int *);
};

struct netlink_dump_control {
	int (*start)(struct netlink_callback *);
	int (*dump)(struct sk_buff *, struct netlink_callback *);
	int (*done)(struct netlink_callback *);
	struct netlink_ext_ack *extack;
	void *data;
	struct module *module;
	u32 min_dump_alloc;
};

struct inet_ehash_bucket;

struct inet_bind_hashbucket;

struct inet_listen_hashbucket;

struct inet_hashinfo {
	struct inet_ehash_bucket *ehash;
	spinlock_t *ehash_locks;
	unsigned int ehash_mask;
	unsigned int ehash_locks_mask;
	struct kmem_cache *bind_bucket_cachep;
	struct inet_bind_hashbucket *bhash;
	struct kmem_cache *bind2_bucket_cachep;
	struct inet_bind_hashbucket *bhash2;
	unsigned int bhash_size;
	unsigned int lhash2_mask;
	struct inet_listen_hashbucket *lhash2;
	bool pernet;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct tcp_fastopen_context {
	siphash_key_t key[2];
	int num;
	struct callback_head rcu;
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

struct rtnl_link_stats {
	__u32 rx_packets;
	__u32 tx_packets;
	__u32 rx_bytes;
	__u32 tx_bytes;
	__u32 rx_errors;
	__u32 tx_errors;
	__u32 rx_dropped;
	__u32 tx_dropped;
	__u32 multicast;
	__u32 collisions;
	__u32 rx_length_errors;
	__u32 rx_over_errors;
	__u32 rx_crc_errors;
	__u32 rx_frame_errors;
	__u32 rx_fifo_errors;
	__u32 rx_missed_errors;
	__u32 tx_aborted_errors;
	__u32 tx_carrier_errors;
	__u32 tx_fifo_errors;
	__u32 tx_heartbeat_errors;
	__u32 tx_window_errors;
	__u32 rx_compressed;
	__u32 tx_compressed;
	__u32 rx_nohandler;
};

struct rtnl_link_ifmap {
	__u64 mem_start;
	__u64 mem_end;
	__u64 base_addr;
	__u16 irq;
	__u8 dma;
	__u8 port;
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	__IFLA_MAX = 66,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

struct ifla_vf_mac {
	__u32 vf;
	__u8 mac[32];
};

struct ifla_vf_broadcast {
	__u8 broadcast[32];
};

struct ifla_vf_vlan {
	__u32 vf;
	__u32 vlan;
	__u32 qos;
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

struct ifla_vf_vlan_info {
	__u32 vf;
	__u32 vlan;
	__u32 qos;
	__be16 vlan_proto;
};

struct ifla_vf_tx_rate {
	__u32 vf;
	__u32 rate;
};

struct ifla_vf_rate {
	__u32 vf;
	__u32 min_tx_rate;
	__u32 max_tx_rate;
};

struct ifla_vf_spoofchk {
	__u32 vf;
	__u32 setting;
};

struct ifla_vf_link_state {
	__u32 vf;
	__u32 link_state;
};

struct ifla_vf_rss_query_en {
	__u32 vf;
	__u32 setting;
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

struct ifla_vf_trust {
	__u32 vf;
	__u32 setting;
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

struct if_stats_msg {
	__u8 family;
	__u8 pad1;
	__u16 pad2;
	__u32 ifindex;
	__u32 filter_mask;
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

struct netdev_hw_addr {
	struct list_head list;
	struct rb_node node;
	unsigned char addr[32];
	unsigned char type;
	bool global_use;
	int sync_cnt;
	int refcount;
	int synced;
	struct callback_head callback_head;
};

struct netdev_name_node {
	struct hlist_node hlist;
	struct list_head list;
	struct net_device *dev;
	const char *name;
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

struct br_port_msg {
	__u8 family;
	__u32 ifindex;
};

struct br_mdb_entry {
	__u32 ifindex;
	__u8 state;
	__u8 flags;
	__u16 vid;
	struct {
		union {
			__be32 ip4;
			struct in6_addr ip6;
			unsigned char mac_addr[6];
		} u;
		__be16 proto;
	} addr;
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_GETMULTICAST = 58,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	__RTA_MAX = 31,
};

struct rta_cacheinfo {
	__u32 rta_clntref;
	__u32 rta_lastuse;
	__s32 rta_expires;
	__u32 rta_error;
	__u32 rta_used;
	__u32 rta_id;
	__u32 rta_ts;
	__u32 rta_tsage;
};

struct rtgenmsg {
	unsigned char rtgen_family;
};

struct ifinfomsg {
	unsigned char ifi_family;
	unsigned char __ifi_pad;
	short unsigned int ifi_type;
	int ifi_index;
	unsigned int ifi_flags;
	unsigned int ifi_change;
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	__RTNLGRP_MAX = 37,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

typedef int (*rtnl_doit_func)(struct sk_buff *, struct nlmsghdr *, struct netlink_ext_ack *);

typedef int (*rtnl_dumpit_func)(struct sk_buff *, struct netlink_callback *);

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

struct rtnl_af_ops {
	struct list_head list;
	int family;
	int (*fill_link_af)(struct sk_buff *, const struct net_device *, u32);
	size_t (*get_link_af_size)(const struct net_device *, u32);
	int (*validate_link_af)(const struct net_device *, const struct nlattr *, struct netlink_ext_ack *);
	int (*set_link_af)(struct net_device *, const struct nlattr *, struct netlink_ext_ack *);
	int (*fill_stats_af)(struct sk_buff *, const struct net_device *);
	size_t (*get_stats_af_size)(const struct net_device *);
};

struct sock_reuseport {
	struct callback_head rcu;
	u16 max_socks;
	u16 num_socks;
	u16 num_closed_socks;
	u16 incoming_cpu;
	unsigned int synq_overflow_ts;
	unsigned int reuseport_id;
	unsigned int bind_inany: 1;
	unsigned int has_conns: 1;
	struct bpf_prog *prog;
	struct sock *socks[0];
};

struct inet_ehash_bucket {
	struct hlist_nulls_head chain;
};

struct inet_bind_hashbucket {
	spinlock_t lock;
	struct hlist_head chain;
};

struct inet_listen_hashbucket {
	spinlock_t lock;
	struct hlist_nulls_head nulls_head;
};

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct rate_sample {
	u64 prior_mstamp;
	u32 prior_delivered;
	u32 prior_delivered_ce;
	s32 delivered;
	s32 delivered_ce;
	long int interval_us;
	u32 snd_interval_us;
	u32 rcv_interval_us;
	long int rtt_us;
	int losses;
	u32 acked_sacked;
	u32 prior_in_flight;
	u32 last_end_seq;
	bool is_app_limited;
	bool is_retrans;
	bool is_ack_delayed;
};

struct dpll_pin;

struct rtnl_link {
	rtnl_doit_func doit;
	rtnl_dumpit_func dumpit;
	struct module *owner;
	unsigned int flags;
	struct callback_head rcu;
};

struct rtnl_newlink_tbs {
	struct nlattr *tb[66];
	struct nlattr *attr[51];
	struct nlattr *slave_attr[45];
};

struct rtnl_offload_xstats_request_used {
	bool request;
	bool used;
};

struct rtnl_stats_dump_filters {
	u32 mask[6];
};

struct rtnl_mdb_dump_ctx {
	long int idx;
};

enum {
	BPF_F_INGRESS = 1,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

struct __una_u32 {
	u32 x;
};

struct bpf_sock_ops_kern {
	struct sock *sk;
	union {
		u32 args[4];
		u32 reply;
		u32 replylong[4];
	};
	struct sk_buff *syn_skb;
	struct sk_buff *skb;
	void *skb_data_end;
	u8 op;
	u8 is_fullsock;
	u8 remaining_opt_len;
	u64 temp;
};

struct sk_psock_progs {
	struct bpf_prog *msg_parser;
	struct bpf_prog *stream_parser;
	struct bpf_prog *stream_verdict;
	struct bpf_prog *skb_verdict;
};

struct strp_stats {
	long long unsigned int msgs;
	long long unsigned int bytes;
	unsigned int mem_fail;
	unsigned int need_more_hdr;
	unsigned int msg_too_big;
	unsigned int msg_timeouts;
	unsigned int bad_hdr_len;
};

struct strparser;

struct strp_callbacks {
	int (*parse_msg)(struct strparser *, struct sk_buff *);
	void (*rcv_msg)(struct strparser *, struct sk_buff *);
	int (*read_sock_done)(struct strparser *, int);
	void (*abort_parser)(struct strparser *, int);
	void (*lock)(struct strparser *);
	void (*unlock)(struct strparser *);
};

struct strparser {
	struct sock *sk;
	u32 stopped: 1;
	u32 paused: 1;
	u32 aborted: 1;
	u32 interrupted: 1;
	u32 unrecov_intr: 1;
	struct sk_buff **skb_nextp;
	struct sk_buff *skb_head;
	unsigned int need_bytes;
	struct delayed_work msg_timer_work;
	struct work_struct work;
	struct strp_stats stats;
	struct strp_callbacks cb;
};

struct sk_psock_work_state {
	u32 len;
	u32 off;
};

struct sk_msg;

struct sk_psock {
	struct sock *sk;
	struct sock *sk_redir;
	u32 apply_bytes;
	u32 cork_bytes;
	u32 eval;
	bool redir_ingress;
	struct sk_msg *cork;
	struct sk_psock_progs progs;
	struct strparser strp;
	struct sk_buff_head ingress_skb;
	struct list_head ingress_msg;
	spinlock_t ingress_lock;
	long unsigned int state;
	struct list_head link;
	spinlock_t link_lock;
	refcount_t refcnt;
	void (*saved_unhash)(struct sock *);
	void (*saved_destroy)(struct sock *);
	void (*saved_close)(struct sock *, long int);
	void (*saved_write_space)(struct sock *);
	void (*saved_data_ready)(struct sock *);
	int (*psock_update_sk_prot)(struct sock *, struct sk_psock *, bool);
	struct proto *sk_proto;
	struct mutex work_mutex;
	struct sk_psock_work_state work_state;
	struct delayed_work work;
	struct rcu_work rwork;
};

struct sk_msg_sg {
	u32 start;
	u32 curr;
	u32 end;
	u32 size;
	u32 copybreak;
	long unsigned int copy[1];
	struct scatterlist data[19];
};

struct sk_msg {
	struct sk_msg_sg sg;
	void *data;
	void *data_end;
	u32 apply_bytes;
	u32 cork_bytes;
	u32 flags;
	struct sk_buff *skb;
	struct sock *sk_redir;
	struct sock *sk;
	struct list_head list;
};

struct sk_psock_link {
	struct list_head list;
	struct bpf_map *map;
	void *link_raw;
};

struct bpf_stab {
	struct bpf_map map;
	struct sock **sks;
	struct sk_psock_progs progs;
	spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
};

typedef u64 (*btf_bpf_sock_map_update)(struct bpf_sock_ops_kern *, struct bpf_map *, void *, u64);

typedef u64 (*btf_bpf_sk_redirect_map)(struct sk_buff *, struct bpf_map *, u32, u64);

typedef u64 (*btf_bpf_msg_redirect_map)(struct sk_msg *, struct bpf_map *, u32, u64);

struct sock_map_seq_info {
	struct bpf_map *map;
	struct sock *sk;
	u32 index;
};

struct bpf_iter__sockmap {
	union {
		struct bpf_iter_meta *meta;
	};
	union {
		struct bpf_map *map;
	};
	union {
		void *key;
	};
	union {
		struct sock *sk;
	};
};

struct bpf_shtab_elem {
	struct callback_head rcu;
	u32 hash;
	struct sock *sk;
	struct hlist_node node;
	u8 key[0];
};

struct bpf_shtab_bucket {
	struct hlist_head head;
	spinlock_t lock;
};

struct bpf_shtab {
	struct bpf_map map;
	struct bpf_shtab_bucket *buckets;
	u32 buckets_num;
	u32 elem_size;
	struct sk_psock_progs progs;
	atomic_t count;
	long: 64;
};

typedef u64 (*btf_bpf_sock_hash_update)(struct bpf_sock_ops_kern *, struct bpf_map *, void *, u64);

typedef u64 (*btf_bpf_sk_redirect_hash)(struct sk_buff *, struct bpf_map *, void *, u64);

typedef u64 (*btf_bpf_msg_redirect_hash)(struct sk_msg *, struct bpf_map *, void *, u64);

struct sock_hash_seq_info {
	struct bpf_map *map;
	struct bpf_shtab *htab;
	u32 bucket_id;
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

struct netlink_policy_dump_state {
	unsigned int policy_idx;
	unsigned int attr_idx;
	unsigned int n_alloc;
	struct {
		const struct nla_policy *policy;
		unsigned int maxtype;
	} policies[0];
};

struct flow_dissector_key_eth_addrs {
	unsigned char dst[6];
	unsigned char src[6];
};

struct flow_dissector_key_ip {
	__u8 tos;
	__u8 ttl;
};

struct xdp_umem;

struct xsk_queue;

struct xdp_buff_xsk;

struct xdp_desc;

struct xsk_buff_pool {
	struct device *dev;
	struct net_device *netdev;
	struct list_head xsk_tx_list;
	spinlock_t xsk_tx_list_lock;
	refcount_t users;
	struct xdp_umem *umem;
	struct work_struct work;
	struct list_head free_list;
	struct list_head xskb_list;
	u32 heads_cnt;
	u16 queue_id;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct xsk_queue *fq;
	struct xsk_queue *cq;
	dma_addr_t *dma_pages;
	struct xdp_buff_xsk *heads;
	struct xdp_desc *tx_descs;
	u64 chunk_mask;
	u64 addrs_cnt;
	u32 free_list_cnt;
	u32 dma_pages_cnt;
	u32 free_heads_cnt;
	u32 headroom;
	u32 chunk_size;
	u32 chunk_shift;
	u32 frame_len;
	u8 cached_need_wakeup;
	bool uses_need_wakeup;
	bool dma_need_sync;
	bool unaligned;
	void *addrs;
	spinlock_t cq_lock;
	struct xdp_buff_xsk *free_heads[0];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ethtool_cmd {
	__u32 cmd;
	__u32 supported;
	__u32 advertising;
	__u16 speed;
	__u8 duplex;
	__u8 port;
	__u8 phy_address;
	__u8 transceiver;
	__u8 autoneg;
	__u8 mdio_support;
	__u32 maxtxpkt;
	__u32 maxrxpkt;
	__u16 speed_hi;
	__u8 eth_tp_mdix;
	__u8 eth_tp_mdix_ctrl;
	__u32 lp_advertising;
	__u32 reserved[2];
};

struct ethtool_value {
	__u32 cmd;
	__u32 data;
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_COUNT = 21,
};

struct ethtool_gstrings {
	__u32 cmd;
	__u32 string_set;
	__u32 len;
	__u8 data[0];
};

struct ethtool_sset_info {
	__u32 cmd;
	__u32 reserved;
	__u64 sset_mask;
	__u32 data[0];
};

struct ethtool_perm_addr {
	__u32 cmd;
	__u32 size;
	__u8 data[0];
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

struct ethtool_rxfh {
	__u32 cmd;
	__u32 rss_context;
	__u32 indir_size;
	__u32 key_size;
	__u8 hfunc;
	__u8 rsvd8[3];
	__u32 rsvd32;
	__u32 rss_config[0];
};

struct ethtool_get_features_block {
	__u32 available;
	__u32 requested;
	__u32 active;
	__u32 never_changed;
};

struct ethtool_gfeatures {
	__u32 cmd;
	__u32 size;
	struct ethtool_get_features_block features[0];
};

struct ethtool_set_features_block {
	__u32 valid;
	__u32 requested;
};

struct ethtool_sfeatures {
	__u32 cmd;
	__u32 size;
	struct ethtool_set_features_block features[0];
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

struct ethtool_per_queue_op {
	__u32 cmd;
	__u32 sub_command;
	__u32 queue_mask[128];
	char data[0];
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

struct flow_rule;

struct ethtool_rx_flow_rule {
	struct flow_rule *rule;
	long unsigned int priv[0];
};

struct flow_match {
	struct flow_dissector *dissector;
	void *mask;
	void *key;
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

typedef void (*action_destr)(void *);

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

struct nf_flowtable;

struct ip_tunnel_info;

struct psample_group;

struct action_gate_entry;

struct flow_action_entry {
	enum flow_action_id id;
	u32 hw_index;
	long unsigned int cookie;
	u64 miss_cookie;
	enum flow_action_hw_stats hw_stats;
	action_destr destructor;
	void *destructor_priv;
	union {
		u32 chain_index;
		struct net_device *dev;
		struct {
			u16 vid;
			__be16 proto;
			u8 prio;
		} vlan;
		struct {
			unsigned char dst[6];
			unsigned char src[6];
		} vlan_push_eth;
		struct {
			enum flow_action_mangle_base htype;
			u32 offset;
			u32 mask;
			u32 val;
		} mangle;
		struct ip_tunnel_info *tunnel;
		u32 csum_flags;
		u32 mark;
		u16 ptype;
		u16 rx_queue;
		u32 priority;
		struct {
			u32 ctx;
			u32 index;
			u8 vf;
		} queue;
		struct {
			struct psample_group *psample_group;
			u32 rate;
			u32 trunc_size;
			bool truncate;
		} sample;
		struct {
			u32 burst;
			u64 rate_bytes_ps;
			u64 peakrate_bytes_ps;
			u32 avrate;
			u16 overhead;
			u64 burst_pkt;
			u64 rate_pkt_ps;
			u32 mtu;
			struct {
				enum flow_action_id act_id;
				u32 extval;
			} exceed;
			struct {
				enum flow_action_id act_id;
				u32 extval;
			} notexceed;
		} police;
		struct {
			int action;
			u16 zone;
			struct nf_flowtable *flow_table;
		} ct;
		struct {
			long unsigned int cookie;
			u32 mark;
			u32 labels[4];
			bool orig_dir;
		} ct_metadata;
		struct {
			u32 label;
			__be16 proto;
			u8 tc;
			u8 bos;
			u8 ttl;
		} mpls_push;
		struct {
			__be16 proto;
		} mpls_pop;
		struct {
			u32 label;
			u8 tc;
			u8 bos;
			u8 ttl;
		} mpls_mangle;
		struct {
			s32 prio;
			u64 basetime;
			u64 cycletime;
			u64 cycletimeext;
			u32 num_entries;
			struct action_gate_entry *entries;
		} gate;
		struct {
			u16 sid;
		} pppoe;
	};
	struct flow_action_cookie *user_cookie;
};

struct flow_action {
	unsigned int num_entries;
	struct flow_action_entry entries[0];
};

struct flow_rule {
	struct flow_match match;
	struct flow_action action;
};

struct ethtool_rx_flow_spec_input {
	const struct ethtool_rx_flow_spec *fs;
	u32 rss_ctx;
};

struct ethtool_phy_ops {
	int (*get_sset_count)(struct phy_device *);
	int (*get_strings)(struct phy_device *, u8 *);
	int (*get_stats)(struct phy_device *, struct ethtool_stats *, u64 *);
	int (*get_plca_cfg)(struct phy_device *, struct phy_plca_cfg *);
	int (*set_plca_cfg)(struct phy_device *, const struct phy_plca_cfg *, struct netlink_ext_ack *);
	int (*get_plca_status)(struct phy_device *, struct phy_plca_status *);
	int (*start_cable_test)(struct phy_device *, struct netlink_ext_ack *);
	int (*start_cable_test_tdr)(struct phy_device *, struct netlink_ext_ack *, const struct phy_tdr_config *);
};

struct xdp_desc {
	__u64 addr;
	__u32 len;
	__u32 options;
};

struct xdp_umem {
	void *addrs;
	u64 size;
	u32 headroom;
	u32 chunk_size;
	u32 chunks;
	u32 npgs;
	struct user_struct *user;
	refcount_t users;
	u8 flags;
	bool zc;
	struct page **pgs;
	int id;
	struct list_head xsk_dma_list;
	struct work_struct work;
};

struct xdp_buff_xsk {
	struct xdp_buff xdp;
	u8 cb[24];
	dma_addr_t dma;
	dma_addr_t frame_dma;
	struct xsk_buff_pool *pool;
	u64 orig_addr;
	struct list_head free_list_node;
	struct list_head xskb_list_node;
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	__ETHTOOL_MSG_KERNEL_CNT = 44,
	ETHTOOL_MSG_KERNEL_MAX = 43,
};

struct ethtool_devlink_compat {
	struct devlink *devlink;
	union {
		struct ethtool_flash efl;
		struct ethtool_drvinfo info;
	};
};

struct ethtool_link_usettings {
	struct ethtool_link_settings base;
	struct {
		__u32 supported[4];
		__u32 advertising[4];
		__u32 lp_advertising[4];
	} link_modes;
};

struct ethtool_rx_flow_key {
	struct flow_dissector_key_basic basic;
	union {
		struct flow_dissector_key_ipv4_addrs ipv4;
		struct flow_dissector_key_ipv6_addrs ipv6;
	};
	struct flow_dissector_key_ports tp;
	struct flow_dissector_key_ip ip;
	struct flow_dissector_key_vlan vlan;
	struct flow_dissector_key_eth_addrs eth_addrs;
};

struct ethtool_rx_flow_match {
	struct flow_dissector dissector;
	struct ethtool_rx_flow_key key;
	struct ethtool_rx_flow_key mask;
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

struct pse_control_config {
	enum ethtool_podl_pse_admin_state admin_cotrol;
};

struct pse_control_status {
	enum ethtool_podl_pse_admin_state podl_admin_state;
	enum ethtool_podl_pse_pw_d_status podl_pw_status;
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	__ETHTOOL_MSG_USER_CNT = 44,
	ETHTOOL_MSG_USER_MAX = 43,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	__ETHTOOL_A_HEADER_CNT = 4,
	ETHTOOL_A_HEADER_MAX = 3,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	__ETHTOOL_A_RINGS_CNT = 17,
	ETHTOOL_A_RINGS_MAX = 16,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	__ETHTOOL_A_COALESCE_CNT = 29,
	ETHTOOL_A_COALESCE_MAX = 28,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	__ETHTOOL_A_TSINFO_CNT = 6,
	ETHTOOL_A_TSINFO_MAX = 5,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	__ETHTOOL_STATS_CNT = 4,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	__ETHTOOL_A_PSE_CNT = 5,
	ETHTOOL_A_PSE_MAX = 4,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	__ETHTOOL_A_RSS_CNT = 6,
	ETHTOOL_A_RSS_MAX = 5,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

struct genlmsghdr {
	__u8 cmd;
	__u8 version;
	__u16 reserved;
};

struct genl_multicast_group {
	char name[16];
	u8 flags;
};

struct genl_split_ops;

struct genl_info;

struct genl_ops;

struct genl_small_ops;

struct genl_family {
	unsigned int hdrsize;
	char name[16];
	unsigned int version;
	unsigned int maxattr;
	u8 netnsok: 1;
	u8 parallel_ops: 1;
	u8 n_ops;
	u8 n_small_ops;
	u8 n_split_ops;
	u8 n_mcgrps;
	u8 resv_start_op;
	const struct nla_policy *policy;
	int (*pre_doit)(const struct genl_split_ops *, struct sk_buff *, struct genl_info *);
	void (*post_doit)(const struct genl_split_ops *, struct sk_buff *, struct genl_info *);
	const struct genl_ops *ops;
	const struct genl_small_ops *small_ops;
	const struct genl_split_ops *split_ops;
	const struct genl_multicast_group *mcgrps;
	struct module *module;
	int id;
	unsigned int mcgrp_offset;
};

struct genl_split_ops {
	union {
		struct {
			int (*pre_doit)(const struct genl_split_ops *, struct sk_buff *, struct genl_info *);
			int (*doit)(struct sk_buff *, struct genl_info *);
			void (*post_doit)(const struct genl_split_ops *, struct sk_buff *, struct genl_info *);
		};
		struct {
			int (*start)(struct netlink_callback *);
			int (*dumpit)(struct sk_buff *, struct netlink_callback *);
			int (*done)(struct netlink_callback *);
		};
	};
	const struct nla_policy *policy;
	unsigned int maxattr;
	u8 cmd;
	u8 internal_flags;
	u8 flags;
	u8 validate;
};

struct genl_info {
	u32 snd_seq;
	u32 snd_portid;
	const struct genl_family *family;
	const struct nlmsghdr *nlhdr;
	struct genlmsghdr *genlhdr;
	struct nlattr **attrs;
	possible_net_t _net;
	void *user_ptr[2];
	struct netlink_ext_ack *extack;
};

struct genl_ops {
	int (*doit)(struct sk_buff *, struct genl_info *);
	int (*start)(struct netlink_callback *);
	int (*dumpit)(struct sk_buff *, struct netlink_callback *);
	int (*done)(struct netlink_callback *);
	const struct nla_policy *policy;
	unsigned int maxattr;
	u8 cmd;
	u8 internal_flags;
	u8 flags;
	u8 validate;
};

struct genl_small_ops {
	int (*doit)(struct sk_buff *, struct genl_info *);
	int (*dumpit)(struct sk_buff *, struct netlink_callback *);
	u8 cmd;
	u8 internal_flags;
	u8 flags;
	u8 validate;
};

struct ethnl_req_info {
	struct net_device *dev;
	netdevice_tracker dev_tracker;
	u32 flags;
};

struct ethnl_reply_data {
	struct net_device *dev;
};

struct ethnl_request_ops {
	u8 request_cmd;
	u8 reply_cmd;
	u16 hdr_attr;
	unsigned int req_info_size;
	unsigned int reply_data_size;
	bool allow_nodev_do;
	u8 set_ntf_cmd;
	int (*parse_request)(struct ethnl_req_info *, struct nlattr **, struct netlink_ext_ack *);
	int (*prepare_data)(const struct ethnl_req_info *, struct ethnl_reply_data *, const struct genl_info *);
	int (*reply_size)(const struct ethnl_req_info *, const struct ethnl_reply_data *);
	int (*fill_reply)(struct sk_buff *, const struct ethnl_req_info *, const struct ethnl_reply_data *);
	void (*cleanup_data)(struct ethnl_reply_data *);
	int (*set_validate)(struct ethnl_req_info *, struct genl_info *);
	int (*set)(struct ethnl_req_info *, struct genl_info *);
};

struct pse_reply_data {
	struct ethnl_reply_data base;
	struct pse_control_status status;
};

typedef u16 u_int16_t;

typedef u32 u_int32_t;

typedef u64 u_int64_t;

struct va_format {
	const char *fmt;
	va_list *va;
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_conntrack_events {
	IPCT_NEW = 0,
	IPCT_RELATED = 1,
	IPCT_DESTROY = 2,
	IPCT_REPLY = 3,
	IPCT_ASSURED = 4,
	IPCT_PROTOINFO = 5,
	IPCT_HELPER = 6,
	IPCT_MARK = 7,
	IPCT_SEQADJ = 8,
	IPCT_NATSEQADJ = 8,
	IPCT_SECMARK = 9,
	IPCT_LABEL = 10,
	IPCT_SYNPROXY = 11,
	__IPCT_MAX = 12,
};

struct nf_conntrack {
	refcount_t use;
};

union nf_inet_addr {
	__u32 all[4];
	__be32 ip;
	__be32 ip6[4];
	struct in_addr in;
	struct in6_addr in6;
};

struct nf_hook_state;

typedef unsigned int nf_hookfn(void *, struct sk_buff *, const struct nf_hook_state *);

struct nf_hook_entry {
	nf_hookfn *hook;
	void *priv;
};

struct nf_hook_entries {
	u16 num_hook_entries;
	struct nf_hook_entry hooks[0];
};

struct ip_ct_tcp_state {
	u_int32_t td_end;
	u_int32_t td_maxend;
	u_int32_t td_maxwin;
	u_int32_t td_maxack;
	u_int8_t td_scale;
	u_int8_t flags;
};

struct ip_ct_tcp {
	struct ip_ct_tcp_state seen[2];
	u_int8_t state;
	u_int8_t last_dir;
	u_int8_t retrans;
	u_int8_t last_index;
	u_int32_t last_seq;
	u_int32_t last_ack;
	u_int32_t last_end;
	u_int16_t last_win;
	u_int8_t last_wscale;
	u_int8_t last_flags;
};

union nf_conntrack_man_proto {
	__be16 all;
	struct {
		__be16 port;
	} tcp;
	struct {
		__be16 port;
	} udp;
	struct {
		__be16 id;
	} icmp;
	struct {
		__be16 port;
	} dccp;
	struct {
		__be16 port;
	} sctp;
	struct {
		__be16 key;
	} gre;
};

struct nf_ct_dccp {
	u_int8_t role[2];
	u_int8_t state;
	u_int8_t last_pkt;
	u_int8_t last_dir;
	u_int64_t handshake_seq;
};

struct ip_ct_sctp {
	enum sctp_conntrack state;
	__be32 vtag[2];
	u8 init[2];
	u8 last_dir;
	u8 flags;
};

struct nf_hook_state {
	u8 hook;
	u8 pf;
	struct net_device *in;
	struct net_device *out;
	struct sock *sk;
	struct net *net;
	int (*okfn)(struct net *, struct sock *, struct sk_buff *);
};

struct nf_conntrack_man {
	union nf_inet_addr u3;
	union nf_conntrack_man_proto u;
	u_int16_t l3num;
};

struct nf_conntrack_tuple {
	struct nf_conntrack_man src;
	struct {
		union nf_inet_addr u3;
		union {
			__be16 all;
			struct {
				__be16 port;
			} tcp;
			struct {
				__be16 port;
			} udp;
			struct {
				u_int8_t type;
				u_int8_t code;
			} icmp;
			struct {
				__be16 port;
			} dccp;
			struct {
				__be16 port;
			} sctp;
			struct {
				__be16 key;
			} gre;
		} u;
		u_int8_t protonum;
		struct {} __nfct_hash_offsetend;
		u_int8_t dir;
	} dst;
};

struct nf_conntrack_tuple_hash {
	struct hlist_nulls_node hnnode;
	struct nf_conntrack_tuple tuple;
};

struct nf_ct_udp {
	long unsigned int stream_ts;
};

struct nf_ct_gre {
	unsigned int stream_timeout;
	unsigned int timeout;
};

union nf_conntrack_proto {
	struct nf_ct_dccp dccp;
	struct ip_ct_sctp sctp;
	struct ip_ct_tcp tcp;
	struct nf_ct_udp udp;
	struct nf_ct_gre gre;
	unsigned int tmpl_padto;
};

struct nf_ct_ext;

struct nf_conn {
	struct nf_conntrack ct_general;
	spinlock_t lock;
	u32 timeout;
	struct nf_conntrack_tuple_hash tuplehash[2];
	long unsigned int status;
	possible_net_t ct_net;
	struct hlist_node nat_bysource;
	struct {} __nfct_init_offset;
	struct nf_conn *master;
	u_int32_t mark;
	struct nf_ct_ext *ext;
	union nf_conntrack_proto proto;
};

struct nf_conntrack_tuple_mask {
	struct {
		union nf_inet_addr u3;
		union nf_conntrack_man_proto u;
	} src;
};

struct nf_ct_ext {
	u8 offset[5];
	u8 len;
	unsigned int gen_id;
	long: 0;
	char data[0];
};

struct nf_conntrack_helper;

struct nf_conntrack_expect {
	struct hlist_node lnode;
	struct hlist_node hnode;
	struct nf_conntrack_tuple tuple;
	struct nf_conntrack_tuple_mask mask;
	refcount_t use;
	unsigned int flags;
	unsigned int class;
	void (*expectfn)(struct nf_conn *, struct nf_conntrack_expect *);
	struct nf_conntrack_helper *helper;
	struct nf_conn *master;
	struct timer_list timeout;
	union nf_inet_addr saved_addr;
	union nf_conntrack_man_proto saved_proto;
	enum ip_conntrack_dir dir;
	struct callback_head rcu;
};

struct nf_conntrack_expect_policy;

struct nf_conntrack_helper {
	struct hlist_node hnode;
	char name[16];
	refcount_t refcnt;
	struct module *me;
	const struct nf_conntrack_expect_policy *expect_policy;
	struct nf_conntrack_tuple tuple;
	int (*help)(struct sk_buff *, unsigned int, struct nf_conn *, enum ip_conntrack_info);
	void (*destroy)(struct nf_conn *);
	int (*from_nlattr)(struct nlattr *, struct nf_conn *);
	int (*to_nlattr)(struct sk_buff *, const struct nf_conn *);
	unsigned int expect_class_max;
	unsigned int flags;
	unsigned int queue_num;
	u16 data_len;
	char nat_mod_name[16];
};

struct nf_conntrack_expect_policy {
	unsigned int max_expected;
	unsigned int timeout;
	char name[16];
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_SYNPROXY = 4,
	NF_CT_EXT_NUM = 5,
};

enum nf_ct_helper_flags {
	NF_CT_HELPER_F_USERSPACE = 1,
	NF_CT_HELPER_F_CONFIGURED = 2,
};

struct nf_conn_help {
	struct nf_conntrack_helper *helper;
	struct hlist_head expectations;
	u8 expecting[4];
	long: 0;
	char data[32];
};

struct nf_ct_helper_expectfn {
	struct list_head head;
	const char *name;
	void (*expectfn)(struct nf_conn *, struct nf_conntrack_expect *);
};

struct nf_conntrack_nat_helper {
	struct list_head list;
	char mod_name[16];
	struct module *module;
};

struct nf_loginfo {
	u_int8_t type;
	union {
		struct {
			u_int32_t copy_len;
			u_int16_t group;
			u_int16_t qthreshold;
			u_int16_t flags;
		} ulog;
		struct {
			u_int8_t level;
			u_int8_t logflags;
		} log;
	} u;
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

struct nf_hook_ops {
	nf_hookfn *hook;
	struct net_device *dev;
	void *priv;
	u8 pf;
	enum nf_hook_ops_type hook_ops_type: 8;
	unsigned int hooknum;
	int priority;
};

struct xt_action_param;

struct xt_mtchk_param;

struct xt_mtdtor_param;

struct xt_match {
	struct list_head list;
	const char name[29];
	u_int8_t revision;
	bool (*match)(const struct sk_buff *, struct xt_action_param *);
	int (*checkentry)(const struct xt_mtchk_param *);
	void (*destroy)(const struct xt_mtdtor_param *);
	struct module *me;
	const char *table;
	unsigned int matchsize;
	unsigned int usersize;
	unsigned int hooks;
	short unsigned int proto;
	short unsigned int family;
};

struct xt_entry_match {
	union {
		struct {
			__u16 match_size;
			char name[29];
			__u8 revision;
		} user;
		struct {
			__u16 match_size;
			struct xt_match *match;
		} kernel;
		__u16 match_size;
	} u;
	unsigned char data[0];
};

struct xt_tgchk_param;

struct xt_tgdtor_param;

struct xt_target {
	struct list_head list;
	const char name[29];
	u_int8_t revision;
	unsigned int (*target)(struct sk_buff *, const struct xt_action_param *);
	int (*checkentry)(const struct xt_tgchk_param *);
	void (*destroy)(const struct xt_tgdtor_param *);
	struct module *me;
	const char *table;
	unsigned int targetsize;
	unsigned int usersize;
	unsigned int hooks;
	short unsigned int proto;
	short unsigned int family;
};

struct xt_entry_target {
	union {
		struct {
			__u16 target_size;
			char name[29];
			__u8 revision;
		} user;
		struct {
			__u16 target_size;
			struct xt_target *target;
		} kernel;
		__u16 target_size;
	} u;
	unsigned char data[0];
};

struct xt_standard_target {
	struct xt_entry_target target;
	int verdict;
};

struct xt_error_target {
	struct xt_entry_target target;
	char errorname[30];
};

struct xt_counters {
	__u64 pcnt;
	__u64 bcnt;
};

struct xt_counters_info {
	char name[32];
	unsigned int num_counters;
	struct xt_counters counters[0];
};

struct xt_action_param {
	union {
		const struct xt_match *match;
		const struct xt_target *target;
	};
	union {
		const void *matchinfo;
		const void *targinfo;
	};
	const struct nf_hook_state *state;
	unsigned int thoff;
	u16 fragoff;
	bool hotdrop;
};

struct xt_mtchk_param {
	struct net *net;
	const char *table;
	const void *entryinfo;
	const struct xt_match *match;
	void *matchinfo;
	unsigned int hook_mask;
	u_int8_t family;
	bool nft_compat;
};

struct xt_mtdtor_param {
	struct net *net;
	const struct xt_match *match;
	void *matchinfo;
	u_int8_t family;
};

struct xt_tgchk_param {
	struct net *net;
	const char *table;
	const void *entryinfo;
	const struct xt_target *target;
	void *targinfo;
	unsigned int hook_mask;
	u_int8_t family;
	bool nft_compat;
};

struct xt_tgdtor_param {
	struct net *net;
	const struct xt_target *target;
	void *targinfo;
	u_int8_t family;
};

struct xt_table_info;

struct xt_table {
	struct list_head list;
	unsigned int valid_hooks;
	struct xt_table_info *private;
	struct nf_hook_ops *ops;
	struct module *me;
	u_int8_t af;
	int priority;
	const char name[32];
};

struct xt_table_info {
	unsigned int size;
	unsigned int number;
	unsigned int initial_entries;
	unsigned int hook_entry[5];
	unsigned int underflow[5];
	unsigned int stacksize;
	void ***jumpstack;
	unsigned char entries[0];
};

struct xt_percpu_counter_alloc_state {
	unsigned int off;
	const char *mem;
};

struct xt_template {
	struct list_head list;
	int (*table_init)(struct net *);
	struct module *me;
	char name[32];
};

struct xt_pernet {
	struct list_head tables[11];
};

struct xt_af {
	struct mutex mutex;
	struct list_head match;
	struct list_head target;
};

struct nf_mttg_trav {
	struct list_head *head;
	struct list_head *curr;
	uint8_t class;
};

enum {
	MTTG_TRAV_INIT = 0,
	MTTG_TRAV_NFP_UNSPEC = 1,
	MTTG_TRAV_NFP_SPEC = 2,
	MTTG_TRAV_DONE = 3,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

struct sk_buff_fclones {
	struct sk_buff skb1;
	struct sk_buff skb2;
	refcount_t fclone_ref;
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

struct inet_bind_bucket {
	possible_net_t ib_net;
	int l3mdev;
	short unsigned int port;
	signed char fastreuse;
	signed char fastreuseport;
	kuid_t fastuid;
	struct in6_addr fast_v6_rcv_saddr;
	__be32 fast_rcv_saddr;
	short unsigned int fast_sk_family;
	bool fast_ipv6_only;
	struct hlist_node node;
	struct hlist_head owners;
};

struct inet_bind2_bucket {
	possible_net_t ib_net;
	int l3mdev;
	short unsigned int port;
	short unsigned int family;
	union {
		struct in6_addr v6_rcv_saddr;
		__be32 rcv_saddr;
	};
	struct hlist_node node;
	struct hlist_head owners;
	struct hlist_head deathrow;
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

struct tcphdr {
	__be16 source;
	__be16 dest;
	__be32 seq;
	__be32 ack_seq;
	__u16 res1: 4;
	__u16 doff: 4;
	__u16 fin: 1;
	__u16 syn: 1;
	__u16 rst: 1;
	__u16 psh: 1;
	__u16 ack: 1;
	__u16 urg: 1;
	__u16 ece: 1;
	__u16 cwr: 1;
	__be16 window;
	__sum16 check;
	__be16 urg_ptr;
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

struct tcp_fastopen_cookie {
	__le64 val[2];
	s8 len;
	bool exp;
};

struct tcp_md5sig_info {
	struct hlist_head head;
	struct callback_head rcu;
};

struct tcp_fastopen_request {
	struct tcp_fastopen_cookie cookie;
	struct msghdr *data;
	size_t size;
	int copied;
	struct ubuf_info *uarg;
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

union tcp_ao_addr {
	struct in_addr a4;
	struct in6_addr a6;
};

struct tcp_md5sig_key {
	struct hlist_node node;
	u8 keylen;
	u8 family;
	u8 prefixlen;
	u8 flags;
	union tcp_ao_addr addr;
	int l3index;
	u8 key[80];
	struct callback_head rcu;
};

struct inet6_skb_parm {
	int iif;
	__be16 ra;
	__u16 dst0;
	__u16 srcrt;
	__u16 dst1;
	__u16 lastopt;
	__u16 nhoff;
	__u16 flags;
	__u16 dsthao;
	__u16 frag_max_size;
	__u16 srhoff;
};

struct static_key_false_deferred {
	struct static_key_false key;
	long unsigned int timeout;
	struct delayed_work work;
};

struct inet_skb_parm {
	int iif;
	struct ip_options opt;
	u16 flags;
	u16 frag_max_size;
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

struct tcp_ao_key {
	struct hlist_node node;
	union tcp_ao_addr addr;
	u8 key[80];
	unsigned int tcp_sigpool_id;
	unsigned int digest_size;
	int l3index;
	u8 prefixlen;
	u8 family;
	u8 keylen;
	u8 keyflags;
	u8 sndid;
	u8 rcvid;
	u8 maclen;
	struct callback_head rcu;
	atomic64_t pkt_good;
	atomic64_t pkt_bad;
	u8 traffic_keys[0];
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

struct mptcp_ext {
	union {
		u64 data_ack;
		u32 data_ack32;
	};
	u64 data_seq;
	u32 subflow_seq;
	u16 data_len;
	__sum16 csum;
	u8 use_map: 1;
	u8 dsn64: 1;
	u8 data_fin: 1;
	u8 use_ack: 1;
	u8 ack64: 1;
	u8 mpc_map: 1;
	u8 frozen: 1;
	u8 reset_transient: 1;
	u8 reset_reason: 4;
	u8 csum_reqd: 1;
	u8 infinite_map: 1;
};

struct mptcp_rm_list {
	u8 ids[8];
	u8 nr;
};

struct mptcp_addr_info {
	u8 id;
	sa_family_t family;
	__be16 port;
	union {
		struct in_addr addr;
		struct in6_addr addr6;
	};
};

struct mptcp_out_options {
	u16 suboptions;
	struct mptcp_rm_list rm_list;
	u8 join_id;
	u8 backup;
	u8 reset_reason: 4;
	u8 reset_transient: 1;
	u8 csum_reqd: 1;
	u8 allow_join_id0: 1;
	union {
		struct {
			u64 sndr_key;
			u64 rcvr_key;
			u64 data_seq;
			u32 subflow_seq;
			u16 data_len;
			__sum16 csum;
		};
		struct {
			struct mptcp_addr_info addr;
			u64 ahmac;
		};
		struct {
			struct mptcp_ext ext_copy;
			u64 fail_seq;
		};
		struct {
			u32 nonce;
			u32 token;
			u64 thmac;
			u8 hmac[20];
		};
	};
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

struct tcp_skb_cb {
	__u32 seq;
	__u32 end_seq;
	union {
		__u32 tcp_tw_isn;
		struct {
			u16 tcp_gso_segs;
			u16 tcp_gso_size;
		};
	};
	__u8 tcp_flags;
	__u8 sacked;
	__u8 ip_dsfield;
	__u8 txstamp_ack: 1;
	__u8 eor: 1;
	__u8 has_rxtstamp: 1;
	__u8 unused: 5;
	__u32 ack_seq;
	union {
		struct {
			__u32 is_app_limited: 1;
			__u32 delivered_ce: 20;
			__u32 unused: 11;
			__u32 delivered;
			u64 first_tx_mstamp;
			u64 delivered_mstamp;
		} tx;
		union {
			struct inet_skb_parm h4;
			struct inet6_skb_parm h6;
		} header;
	};
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

struct tcp_key {
	union {
		struct {
			struct tcp_ao_key *ao_key;
			char *traffic_key;
			u32 sne;
			u8 rcv_next;
		};
		struct tcp_md5sig_key *md5_key;
	};
	enum {
		TCP_KEY_NONE = 0,
		TCP_KEY_MD5 = 1,
		TCP_KEY_AO = 2,
	} type;
};

struct tcp_out_options {
	u16 options;
	u16 mss;
	u8 ws;
	u8 num_sack_blocks;
	u8 hash_size;
	u8 bpf_opt_len;
	__u8 *hash_location;
	__u32 tsval;
	__u32 tsecr;
	struct tcp_fastopen_cookie *fastopen_cookie;
	struct mptcp_out_options mptcp;
};

struct tsq_tasklet {
	struct tasklet_struct tasklet;
	struct list_head head;
};

struct fib_notifier_info {
	int family;
	struct netlink_ext_ack *extack;
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

struct snmp_mib {
	const char *name;
	int entry;
};

struct raw_hashinfo {
	spinlock_t lock;
	struct hlist_head ht[256];
};

struct nf_sockopt_ops {
	struct list_head list;
	u_int8_t pf;
	int set_optmin;
	int set_optmax;
	int (*set)(struct sock *, int, sockptr_t, unsigned int);
	int get_optmin;
	int get_optmax;
	int (*get)(struct sock *, int, void *, int *);
	struct module *owner;
};

struct xt_get_revision {
	char name[29];
	__u8 revision;
};

struct ipt_ip {
	struct in_addr src;
	struct in_addr dst;
	struct in_addr smsk;
	struct in_addr dmsk;
	char iniface[16];
	char outiface[16];
	unsigned char iniface_mask[16];
	unsigned char outiface_mask[16];
	__u16 proto;
	__u8 flags;
	__u8 invflags;
};

struct ipt_entry {
	struct ipt_ip ip;
	unsigned int nfcache;
	__u16 target_offset;
	__u16 next_offset;
	unsigned int comefrom;
	struct xt_counters counters;
	unsigned char elems[0];
};

struct ipt_getinfo {
	char name[32];
	unsigned int valid_hooks;
	unsigned int hook_entry[5];
	unsigned int underflow[5];
	unsigned int num_entries;
	unsigned int size;
};

struct ipt_replace {
	char name[32];
	unsigned int valid_hooks;
	unsigned int num_entries;
	unsigned int size;
	unsigned int hook_entry[5];
	unsigned int underflow[5];
	unsigned int num_counters;
	struct xt_counters *counters;
	struct ipt_entry entries[0];
};

struct ipt_get_entries {
	char name[32];
	unsigned int size;
	struct ipt_entry entrytable[0];
};

struct ipt_standard {
	struct ipt_entry entry;
	struct xt_standard_target target;
};

struct ipt_error {
	struct ipt_entry entry;
	struct xt_error_target target;
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

struct bpf_local_storage_data;

struct bpf_local_storage {
	struct bpf_local_storage_data *cache[16];
	struct bpf_local_storage_map *smap;
	struct hlist_head list;
	void *owner;
	struct callback_head rcu;
	raw_spinlock_t lock;
};

typedef sockptr_t bpfptr_t;

struct btf_id_set8 {
	u32 cnt;
	u32 flags;
	struct {
		u32 id;
		u32 flags;
	} pairs[0];
};

typedef int (*btf_kfunc_filter_t)(const struct bpf_prog *, u32);

struct btf_kfunc_id_set {
	struct module *owner;
	struct btf_id_set8 *set;
	btf_kfunc_filter_t filter;
};

struct btf_struct_meta {
	u32 btf_id;
	struct btf_record *record;
};

struct bpf_mem_caches;

struct bpf_mem_cache;

struct bpf_mem_alloc {
	struct bpf_mem_caches *caches;
	struct bpf_mem_cache *cache;
	bool percpu;
	struct work_struct work;
};

struct bpf_local_storage_map_bucket;

struct bpf_local_storage_map {
	struct bpf_map map;
	struct bpf_local_storage_map_bucket *buckets;
	u32 bucket_log;
	u16 elem_size;
	u16 cache_idx;
	struct bpf_mem_alloc selem_ma;
	struct bpf_mem_alloc storage_ma;
	bool bpf_ma;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_verifier_log {
	u64 start_pos;
	u64 end_pos;
	char *ubuf;
	u32 level;
	u32 len_total;
	u32 len_max;
	char kbuf[1024];
};

struct bpf_subprog_info {
	u32 start;
	u32 linfo_idx;
	u16 stack_depth;
	bool has_tail_call;
	bool tail_call_reachable;
	bool has_ld_abs;
	bool is_cb;
	bool is_async_cb;
	bool is_exception_cb;
};

struct bpf_id_pair {
	u32 old;
	u32 cur;
};

struct bpf_idmap {
	u32 tmp_id_gen;
	struct bpf_id_pair map[600];
};

struct bpf_idset {
	u32 count;
	u32 ids[600];
};

struct backtrack_state {
	struct bpf_verifier_env *env;
	u32 frame;
	u32 reg_masks[8];
	u64 stack_masks[8];
};

struct bpf_verifier_ops;

struct bpf_verifier_stack_elem;

struct bpf_verifier_state;

struct bpf_verifier_state_list;

struct bpf_insn_aux_data;

struct bpf_verifier_env {
	u32 insn_idx;
	u32 prev_insn_idx;
	struct bpf_prog *prog;
	const struct bpf_verifier_ops *ops;
	struct bpf_verifier_stack_elem *head;
	int stack_size;
	bool strict_alignment;
	bool test_state_freq;
	struct bpf_verifier_state *cur_state;
	struct bpf_verifier_state_list **explored_states;
	struct bpf_verifier_state_list *free_list;
	struct bpf_map *used_maps[64];
	struct btf_mod_pair used_btfs[64];
	u32 used_map_cnt;
	u32 used_btf_cnt;
	u32 id_gen;
	u32 hidden_subprog_cnt;
	int exception_callback_subprog;
	bool explore_alu_limits;
	bool allow_ptr_leaks;
	bool allow_uninit_stack;
	bool bpf_capable;
	bool bypass_spec_v1;
	bool bypass_spec_v4;
	bool seen_direct_write;
	bool seen_exception;
	struct bpf_insn_aux_data *insn_aux_data;
	const struct bpf_line_info *prev_linfo;
	struct bpf_verifier_log log;
	struct bpf_subprog_info subprog_info[258];
	union {
		struct bpf_idmap idmap_scratch;
		struct bpf_idset idset_scratch;
	};
	struct {
		int *insn_state;
		int *insn_stack;
		int cur_stack;
	} cfg;
	struct backtrack_state bt;
	u32 pass_cnt;
	u32 subprog_cnt;
	u32 prev_insn_processed;
	u32 insn_processed;
	u32 prev_jmps_processed;
	u32 jmps_processed;
	u64 verification_time;
	u32 max_states_per_insn;
	u32 total_states;
	u32 peak_states;
	u32 longest_mark_read_walk;
	bpfptr_t fd_array;
	u32 scratched_regs;
	u64 scratched_stack_slots;
	u64 prev_log_pos;
	u64 prev_insn_print_pos;
	char tmp_str_buf[320];
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

struct tnum {
	u64 value;
	u64 mask;
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

struct bpf_reg_state {
	enum bpf_reg_type type;
	s32 off;
	union {
		int range;
		struct {
			struct bpf_map *map_ptr;
			u32 map_uid;
		};
		struct {
			struct btf *btf;
			u32 btf_id;
		};
		struct {
			u32 mem_size;
			u32 dynptr_id;
		};
		struct {
			enum bpf_dynptr_type type;
			bool first_slot;
		} dynptr;
		struct {
			struct btf *btf;
			u32 btf_id;
			enum bpf_iter_state state: 2;
			int depth: 30;
		} iter;
		struct {
			long unsigned int raw1;
			long unsigned int raw2;
		} raw;
		u32 subprogno;
	};
	struct tnum var_off;
	s64 smin_value;
	s64 smax_value;
	u64 umin_value;
	u64 umax_value;
	s32 s32_min_value;
	s32 s32_max_value;
	u32 u32_min_value;
	u32 u32_max_value;
	u32 id;
	u32 ref_obj_id;
	struct bpf_reg_state *parent;
	u32 frameno;
	s32 subreg_def;
	enum bpf_reg_liveness live;
	bool precise;
};

struct bpf_reference_state;

struct bpf_stack_state;

struct bpf_func_state {
	struct bpf_reg_state regs[11];
	int callsite;
	u32 frameno;
	u32 subprogno;
	u32 async_entry_cnt;
	bool in_callback_fn;
	struct tnum callback_ret_range;
	bool in_async_callback_fn;
	bool in_exception_callback_fn;
	int acquired_refs;
	struct bpf_reference_state *refs;
	int allocated_stack;
	struct bpf_stack_state *stack;
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

struct bpf_insn_access_aux {
	enum bpf_reg_type reg_type;
	union {
		int ctx_field_size;
		struct {
			struct btf *btf;
			u32 btf_id;
		};
	};
	struct bpf_verifier_log *log;
};

struct bpf_verifier_ops {
	const struct bpf_func_proto * (*get_func_proto)(enum bpf_func_id, const struct bpf_prog *);
	bool (*is_valid_access)(int, int, enum bpf_access_type, const struct bpf_prog *, struct bpf_insn_access_aux *);
	int (*gen_prologue)(struct bpf_insn *, bool, const struct bpf_prog *);
	int (*gen_ld_abs)(const struct bpf_insn *, struct bpf_insn *);
	u32 (*convert_ctx_access)(enum bpf_access_type, const struct bpf_insn *, struct bpf_insn *, struct bpf_prog *, u32 *);
	int (*btf_struct_access)(struct bpf_verifier_log *, const struct bpf_reg_state *, int, int);
};

struct bpf_struct_ops {
	const struct bpf_verifier_ops *verifier_ops;
	int (*init)(struct btf *);
	int (*check_member)(const struct btf_type *, const struct btf_member *, const struct bpf_prog *);
	int (*init_member)(const struct btf_type *, const struct btf_member *, void *, const void *);
	int (*reg)(void *);
	void (*unreg)(void *);
	int (*update)(void *, void *);
	int (*validate)(void *);
	const struct btf_type *type;
	const struct btf_type *value_type;
	const char *name;
	struct btf_func_model func_models[64];
	u32 type_id;
	u32 value_id;
};

struct bpf_active_lock {
	void *ptr;
	u32 id;
};

struct bpf_stack_state {
	struct bpf_reg_state spilled_ptr;
	u8 slot_type[8];
};

struct bpf_reference_state {
	int id;
	int insn_idx;
	int callback_ref;
};

struct bpf_idx_pair {
	u32 prev_idx;
	u32 idx;
};

struct bpf_verifier_state {
	struct bpf_func_state *frame[8];
	struct bpf_verifier_state *parent;
	u32 branches;
	u32 insn_idx;
	u32 curframe;
	struct bpf_active_lock active_lock;
	bool speculative;
	bool active_rcu_lock;
	bool used_as_loop_entry;
	u32 first_insn_idx;
	u32 last_insn_idx;
	struct bpf_verifier_state *loop_entry;
	struct bpf_idx_pair *jmp_history;
	u32 jmp_history_cnt;
	u32 dfs_depth;
};

struct bpf_verifier_state_list {
	struct bpf_verifier_state state;
	struct bpf_verifier_state_list *next;
	int miss_cnt;
	int hit_cnt;
};

struct bpf_loop_inline_state {
	unsigned int initialized: 1;
	unsigned int fit_for_inline: 1;
	u32 callback_subprogno;
};

struct bpf_insn_aux_data {
	union {
		enum bpf_reg_type ptr_type;
		long unsigned int map_ptr_state;
		s32 call_imm;
		u32 alu_limit;
		struct {
			u32 map_index;
			u32 map_off;
		};
		struct {
			enum bpf_reg_type reg_type;
			union {
				struct {
					struct btf *btf;
					u32 btf_id;
				};
				u32 mem_size;
			};
		} btf_var;
		struct bpf_loop_inline_state loop_inline_state;
	};
	union {
		u64 obj_new_size;
		u64 insert_off;
	};
	struct btf_struct_meta *kptr_struct_meta;
	u64 map_key_state;
	int ctx_field_size;
	u32 seen;
	bool sanitize_stack_spill;
	bool zext_dst;
	bool storage_get_func_atomic;
	bool is_iter_next;
	bool call_with_percpu_alloc_ptr;
	u8 alu_state;
	unsigned int orig_idx;
	bool jmp_point;
	bool prune_point;
	bool force_checkpoint;
};

struct bpf_local_storage_map_bucket {
	struct hlist_head list;
	raw_spinlock_t lock;
};

struct bpf_local_storage_data {
	struct bpf_local_storage_map *smap;
	u8 data[0];
};

typedef u64 (*btf_bpf_tcp_send_ack)(struct tcp_sock *, u32);

struct sockaddr_un {
	__kernel_sa_family_t sun_family;
	char sun_path[108];
};

struct unix_address {
	refcount_t refcnt;
	int len;
	struct sockaddr_un name[0];
};

struct scm_stat {
	atomic_t nr_fds;
};

struct unix_sock {
	struct sock sk;
	struct unix_address *addr;
	struct path path;
	struct mutex iolock;
	struct mutex bindlock;
	struct sock *peer;
	struct list_head link;
	atomic_long_t inflight;
	spinlock_t lock;
	long unsigned int gc_flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct socket_wq peer_wq;
	wait_queue_entry_t peer_wake;
	struct scm_stat scm_stat;
	struct sk_buff *oob_skb;
	long: 64;
};

struct seg6_pernet_data {
	struct mutex lock;
	struct in6_addr *tun_src;
};

struct ipv6_destopt_hao {
	__u8 type;
	__u8 length;
	struct in6_addr addr;
} __attribute__((packed));

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

struct sockcm_cookie {
	u64 transmit_time;
	u32 mark;
	u32 tsflags;
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
};

typedef void ip6_icmp_send_t(struct sk_buff *, u8, u8, __u32, const struct in6_addr *, const struct inet6_skb_parm *);

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

struct ipcm6_cookie {
	struct sockcm_cookie sockc;
	__s16 hlimit;
	__s16 tclass;
	__u16 gso_size;
	__s8 dontfrag;
	struct ipv6_txoptions *opt;
};

struct ipv4_addr_key {
	__be32 addr;
	int vif;
};

struct inetpeer_addr {
	union {
		struct ipv4_addr_key a4;
		struct in6_addr a6;
		u32 key[4];
	};
	__u16 family;
};

struct inet_peer {
	struct rb_node rb_node;
	struct inetpeer_addr daddr;
	u32 metrics[17];
	u32 rate_tokens;
	u32 n_redirects;
	long unsigned int rate_last;
	union {
		struct {
			atomic_t rid;
		};
		struct callback_head rcu;
	};
	__u32 dtime;
	refcount_t refcnt;
};

struct icmphdr {
	__u8 type;
	__u8 code;
	__sum16 checksum;
	union {
		struct {
			__be16 id;
			__be16 sequence;
		} echo;
		__be32 gateway;
		struct {
			__be16 __unused;
			__be16 mtu;
		} frag;
		__u8 reserved[4];
	} un;
};

struct inet6_protocol {
	int (*handler)(struct sk_buff *);
	int (*err_handler)(struct sk_buff *, struct inet6_skb_parm *, u8, u8, int, __be32);
	unsigned int flags;
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

struct xfrm_offload {
	struct {
		__u32 low;
		__u32 hi;
	} seq;
	__u32 flags;
	__u32 status;
	__u8 proto;
	__u8 inner_ipproto;
};

struct sec_path {
	int len;
	int olen;
	int verified_cnt;
	struct xfrm_state *xvec[6];
	struct xfrm_offload ovec[1];
};

struct icmpv6_msg {
	struct sk_buff *skb;
	int offset;
	uint8_t type;
};

struct icmp6_err {
	int err;
	int fatal;
};

struct offload_callbacks {
	struct sk_buff * (*gso_segment)(struct sk_buff *, netdev_features_t);
	struct sk_buff * (*gro_receive)(struct list_head *, struct sk_buff *);
	int (*gro_complete)(struct sk_buff *, int);
};

struct udphdr {
	__be16 source;
	__be16 dest;
	__be16 len;
	__sum16 check;
};

struct udp_sock {
	struct inet_sock inet;
	long unsigned int udp_flags;
	int pending;
	__u8 encap_type;
	__u16 len;
	__u16 gso_size;
	__u16 pcslen;
	__u16 pcrlen;
	int (*encap_rcv)(struct sock *, struct sk_buff *);
	void (*encap_err_rcv)(struct sock *, struct sk_buff *, int, __be16, u32, u8 *);
	int (*encap_err_lookup)(struct sock *, struct sk_buff *);
	void (*encap_destroy)(struct sock *);
	struct sk_buff * (*gro_receive)(struct sock *, struct list_head *, struct sk_buff *);
	int (*gro_complete)(struct sock *, struct sk_buff *, int);
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head reader_queue;
	int forward_deficit;
	int forward_threshold;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

struct ip_tunnel;

struct ip6_tnl;

struct xfrm_tunnel_skb_cb {
	union {
		struct inet_skb_parm h4;
		struct inet6_skb_parm h6;
	} header;
	union {
		struct ip_tunnel *ip4;
		struct ip6_tnl *ip6;
	} tunnel;
};

struct xfrm_mode_skb_cb {
	struct xfrm_tunnel_skb_cb header;
	__be16 id;
	__be16 frag_off;
	u8 ihl;
	u8 tos;
	u8 ttl;
	u8 protocol;
	u8 optlen;
	u8 flow_lbl[3];
};

struct xfrm_spi_skb_cb {
	struct xfrm_tunnel_skb_cb header;
	unsigned int daddroff;
	unsigned int family;
	__be32 seq;
};

struct net_offload {
	struct offload_callbacks callbacks;
	unsigned int flags;
};

struct napi_gro_cb {
	union {
		struct {
			void *frag0;
			unsigned int frag0_len;
		};
		struct {
			struct sk_buff *last;
			long unsigned int age;
		};
	};
	int data_offset;
	u16 flush;
	u16 flush_id;
	u16 count;
	u16 proto;
	union {
		struct {
			u16 gro_remcsum_start;
			u8 same_flow: 1;
			u8 encap_mark: 1;
			u8 csum_valid: 1;
			u8 csum_cnt: 3;
			u8 free: 2;
			u8 is_ipv6: 1;
			u8 is_fou: 1;
			u8 is_atomic: 1;
			u8 recursion_counter: 4;
			u8 is_flist: 1;
		};
		struct {
			u16 gro_remcsum_start;
			u8 same_flow: 1;
			u8 encap_mark: 1;
			u8 csum_valid: 1;
			u8 csum_cnt: 3;
			u8 free: 2;
			u8 is_ipv6: 1;
			u8 is_fou: 1;
			u8 is_atomic: 1;
			u8 recursion_counter: 4;
			u8 is_flist: 1;
		} zeroed;
	};
	__wsum csum;
};

typedef struct sk_buff * (*gro_receive_t)(struct list_head *, struct sk_buff *);

struct guehdr {
	union {
		struct {
			__u8 hlen: 5;
			__u8 control: 1;
			__u8 version: 2;
			__u8 proto_ctype;
			__be16 flags;
		};
		__be32 word;
	};
};

enum tunnel_encap_types {
	TUNNEL_ENCAP_NONE = 0,
	TUNNEL_ENCAP_FOU = 1,
	TUNNEL_ENCAP_GUE = 2,
	TUNNEL_ENCAP_MPLS = 3,
};

struct ip_tunnel_encap {
	u16 type;
	u16 flags;
	__be16 sport;
	__be16 dport;
};

struct ip6_tnl_encap_ops {
	size_t (*encap_hlen)(struct ip_tunnel_encap *);
	int (*build_header)(struct sk_buff *, struct ip_tunnel_encap *, u8 *, struct flowi6 *);
	int (*err_handler)(struct sk_buff *, struct inet6_skb_parm *, u8, u8, int, __be32);
};

struct genl_dumpit_info {
	struct genl_split_ops op;
	struct genl_info info;
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	__DEVLINK_CMD_MAX = 84,
	DEVLINK_CMD_MAX = 83,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 5,
};

struct firmware {
	size_t size;
	const u8 *data;
	void *priv;
};

struct devlink_dev_stats {
	u32 reload_stats[6];
	u32 remote_reload_stats[6];
};

struct devlink_dpipe_headers;

struct devlink_ops;

struct devlink_rel;

struct devlink {
	u32 index;
	struct xarray ports;
	struct list_head rate_list;
	struct list_head sb_list;
	struct list_head dpipe_table_list;
	struct list_head resource_list;
	struct xarray params;
	struct list_head region_list;
	struct list_head reporter_list;
	struct devlink_dpipe_headers *dpipe_headers;
	struct list_head trap_list;
	struct list_head trap_group_list;
	struct list_head trap_policer_list;
	struct list_head linecard_list;
	const struct devlink_ops *ops;
	struct xarray snapshot_ids;
	struct devlink_dev_stats stats;
	struct device *dev;
	possible_net_t _net;
	struct mutex lock;
	struct lock_class_key lock_key;
	u8 reload_failed: 1;
	refcount_t refcount;
	struct rcu_work rwork;
	struct devlink_rel *rel;
	struct xarray nested_rels;
	long: 64;
	long: 64;
	long: 64;
	char priv[0];
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

struct ib_mad;

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

struct uverbs_attr_bundle;

struct rdma_cm_id;

struct iw_cm_id;

struct iw_cm_conn_param;

struct ib_qp;

struct ib_send_wr;

struct ib_recv_wr;

struct ib_cq;

struct ib_wc;

struct ib_srq;

struct ib_grh;

struct ib_device_attr;

struct ib_udata;

struct ib_device_modify;

struct ib_port_attr;

struct ib_port_modify;

struct ib_port_immutable;

struct rdma_netdev_alloc_params;

union ib_gid;

struct ib_gid_attr;

struct ib_ucontext;

struct rdma_user_mmap_entry;

struct ib_pd;

struct ib_ah;

struct rdma_ah_init_attr;

struct rdma_ah_attr;

struct ib_srq_init_attr;

struct ib_srq_attr;

struct ib_qp_init_attr;

struct ib_qp_attr;

struct ib_cq_init_attr;

struct ib_mr;

struct ib_sge;

struct ib_mr_status;

struct ib_mw;

struct ib_xrcd;

struct ib_flow;

struct ib_flow_attr;

struct ib_flow_action;

struct ib_wq;

struct ib_wq_init_attr;

struct ib_wq_attr;

struct ib_rwq_ind_table;

struct ib_rwq_ind_table_init_attr;

struct ib_dm;

struct ib_dm_alloc_attr;

struct ib_dm_mr_attr;

struct ib_counters;

struct ib_counters_read_attr;

struct rdma_hw_stats;

struct rdma_counter;

struct ib_device_ops {
	struct module *owner;
	enum rdma_driver_id driver_id;
	u32 uverbs_abi_ver;
	unsigned int uverbs_no_driver_id_binding: 1;
	const struct attribute_group *device_group;
	const struct attribute_group **port_groups;
	int (*post_send)(struct ib_qp *, const struct ib_send_wr *, const struct ib_send_wr **);
	int (*post_recv)(struct ib_qp *, const struct ib_recv_wr *, const struct ib_recv_wr **);
	void (*drain_rq)(struct ib_qp *);
	void (*drain_sq)(struct ib_qp *);
	int (*poll_cq)(struct ib_cq *, int, struct ib_wc *);
	int (*peek_cq)(struct ib_cq *, int);
	int (*req_notify_cq)(struct ib_cq *, enum ib_cq_notify_flags);
	int (*post_srq_recv)(struct ib_srq *, const struct ib_recv_wr *, const struct ib_recv_wr **);
	int (*process_mad)(struct ib_device *, int, u32, const struct ib_wc *, const struct ib_grh *, const struct ib_mad *, struct ib_mad *, size_t *, u16 *);
	int (*query_device)(struct ib_device *, struct ib_device_attr *, struct ib_udata *);
	int (*modify_device)(struct ib_device *, int, struct ib_device_modify *);
	void (*get_dev_fw_str)(struct ib_device *, char *);
	const struct cpumask * (*get_vector_affinity)(struct ib_device *, int);
	int (*query_port)(struct ib_device *, u32, struct ib_port_attr *);
	int (*modify_port)(struct ib_device *, u32, int, struct ib_port_modify *);
	int (*get_port_immutable)(struct ib_device *, u32, struct ib_port_immutable *);
	enum rdma_link_layer (*get_link_layer)(struct ib_device *, u32);
	struct net_device * (*get_netdev)(struct ib_device *, u32);
	struct net_device * (*alloc_rdma_netdev)(struct ib_device *, u32, enum rdma_netdev_t, const char *, unsigned char, void (*)(struct net_device *));
	int (*rdma_netdev_get_params)(struct ib_device *, u32, enum rdma_netdev_t, struct rdma_netdev_alloc_params *);
	int (*query_gid)(struct ib_device *, u32, int, union ib_gid *);
	int (*add_gid)(const struct ib_gid_attr *, void **);
	int (*del_gid)(const struct ib_gid_attr *, void **);
	int (*query_pkey)(struct ib_device *, u32, u16, u16 *);
	int (*alloc_ucontext)(struct ib_ucontext *, struct ib_udata *);
	void (*dealloc_ucontext)(struct ib_ucontext *);
	int (*mmap)(struct ib_ucontext *, struct vm_area_struct *);
	void (*mmap_free)(struct rdma_user_mmap_entry *);
	void (*disassociate_ucontext)(struct ib_ucontext *);
	int (*alloc_pd)(struct ib_pd *, struct ib_udata *);
	int (*dealloc_pd)(struct ib_pd *, struct ib_udata *);
	int (*create_ah)(struct ib_ah *, struct rdma_ah_init_attr *, struct ib_udata *);
	int (*create_user_ah)(struct ib_ah *, struct rdma_ah_init_attr *, struct ib_udata *);
	int (*modify_ah)(struct ib_ah *, struct rdma_ah_attr *);
	int (*query_ah)(struct ib_ah *, struct rdma_ah_attr *);
	int (*destroy_ah)(struct ib_ah *, u32);
	int (*create_srq)(struct ib_srq *, struct ib_srq_init_attr *, struct ib_udata *);
	int (*modify_srq)(struct ib_srq *, struct ib_srq_attr *, enum ib_srq_attr_mask, struct ib_udata *);
	int (*query_srq)(struct ib_srq *, struct ib_srq_attr *);
	int (*destroy_srq)(struct ib_srq *, struct ib_udata *);
	int (*create_qp)(struct ib_qp *, struct ib_qp_init_attr *, struct ib_udata *);
	int (*modify_qp)(struct ib_qp *, struct ib_qp_attr *, int, struct ib_udata *);
	int (*query_qp)(struct ib_qp *, struct ib_qp_attr *, int, struct ib_qp_init_attr *);
	int (*destroy_qp)(struct ib_qp *, struct ib_udata *);
	int (*create_cq)(struct ib_cq *, const struct ib_cq_init_attr *, struct ib_udata *);
	int (*modify_cq)(struct ib_cq *, u16, u16);
	int (*destroy_cq)(struct ib_cq *, struct ib_udata *);
	int (*resize_cq)(struct ib_cq *, int, struct ib_udata *);
	struct ib_mr * (*get_dma_mr)(struct ib_pd *, int);
	struct ib_mr * (*reg_user_mr)(struct ib_pd *, u64, u64, u64, int, struct ib_udata *);
	struct ib_mr * (*reg_user_mr_dmabuf)(struct ib_pd *, u64, u64, u64, int, int, struct ib_udata *);
	struct ib_mr * (*rereg_user_mr)(struct ib_mr *, int, u64, u64, u64, int, struct ib_pd *, struct ib_udata *);
	int (*dereg_mr)(struct ib_mr *, struct ib_udata *);
	struct ib_mr * (*alloc_mr)(struct ib_pd *, enum ib_mr_type, u32);
	struct ib_mr * (*alloc_mr_integrity)(struct ib_pd *, u32, u32);
	int (*advise_mr)(struct ib_pd *, enum ib_uverbs_advise_mr_advice, u32, struct ib_sge *, u32, struct uverbs_attr_bundle *);
	int (*map_mr_sg)(struct ib_mr *, struct scatterlist *, int, unsigned int *);
	int (*check_mr_status)(struct ib_mr *, u32, struct ib_mr_status *);
	int (*alloc_mw)(struct ib_mw *, struct ib_udata *);
	int (*dealloc_mw)(struct ib_mw *);
	int (*attach_mcast)(struct ib_qp *, union ib_gid *, u16);
	int (*detach_mcast)(struct ib_qp *, union ib_gid *, u16);
	int (*alloc_xrcd)(struct ib_xrcd *, struct ib_udata *);
	int (*dealloc_xrcd)(struct ib_xrcd *, struct ib_udata *);
	struct ib_flow * (*create_flow)(struct ib_qp *, struct ib_flow_attr *, struct ib_udata *);
	int (*destroy_flow)(struct ib_flow *);
	int (*destroy_flow_action)(struct ib_flow_action *);
	int (*set_vf_link_state)(struct ib_device *, int, u32, int);
	int (*get_vf_config)(struct ib_device *, int, u32, struct ifla_vf_info *);
	int (*get_vf_stats)(struct ib_device *, int, u32, struct ifla_vf_stats *);
	int (*get_vf_guid)(struct ib_device *, int, u32, struct ifla_vf_guid *, struct ifla_vf_guid *);
	int (*set_vf_guid)(struct ib_device *, int, u32, u64, int);
	struct ib_wq * (*create_wq)(struct ib_pd *, struct ib_wq_init_attr *, struct ib_udata *);
	int (*destroy_wq)(struct ib_wq *, struct ib_udata *);
	int (*modify_wq)(struct ib_wq *, struct ib_wq_attr *, u32, struct ib_udata *);
	int (*create_rwq_ind_table)(struct ib_rwq_ind_table *, struct ib_rwq_ind_table_init_attr *, struct ib_udata *);
	int (*destroy_rwq_ind_table)(struct ib_rwq_ind_table *);
	struct ib_dm * (*alloc_dm)(struct ib_device *, struct ib_ucontext *, struct ib_dm_alloc_attr *, struct uverbs_attr_bundle *);
	int (*dealloc_dm)(struct ib_dm *, struct uverbs_attr_bundle *);
	struct ib_mr * (*reg_dm_mr)(struct ib_pd *, struct ib_dm *, struct ib_dm_mr_attr *, struct uverbs_attr_bundle *);
	int (*create_counters)(struct ib_counters *, struct uverbs_attr_bundle *);
	int (*destroy_counters)(struct ib_counters *);
	int (*read_counters)(struct ib_counters *, struct ib_counters_read_attr *, struct uverbs_attr_bundle *);
	int (*map_mr_sg_pi)(struct ib_mr *, struct scatterlist *, int, unsigned int *, struct scatterlist *, int, unsigned int *);
	struct rdma_hw_stats * (*alloc_hw_device_stats)(struct ib_device *);
	struct rdma_hw_stats * (*alloc_hw_port_stats)(struct ib_device *, u32);
	int (*get_hw_stats)(struct ib_device *, struct rdma_hw_stats *, u32, int);
	int (*modify_hw_stat)(struct ib_device *, u32, unsigned int, bool);
	int (*fill_res_mr_entry)(struct sk_buff *, struct ib_mr *);
	int (*fill_res_mr_entry_raw)(struct sk_buff *, struct ib_mr *);
	int (*fill_res_cq_entry)(struct sk_buff *, struct ib_cq *);
	int (*fill_res_cq_entry_raw)(struct sk_buff *, struct ib_cq *);
	int (*fill_res_qp_entry)(struct sk_buff *, struct ib_qp *);
	int (*fill_res_qp_entry_raw)(struct sk_buff *, struct ib_qp *);
	int (*fill_res_cm_id_entry)(struct sk_buff *, struct rdma_cm_id *);
	int (*enable_driver)(struct ib_device *);
	void (*dealloc_driver)(struct ib_device *);
	void (*iw_add_ref)(struct ib_qp *);
	void (*iw_rem_ref)(struct ib_qp *);
	struct ib_qp * (*iw_get_qp)(struct ib_device *, int);
	int (*iw_connect)(struct iw_cm_id *, struct iw_cm_conn_param *);
	int (*iw_accept)(struct iw_cm_id *, struct iw_cm_conn_param *);
	int (*iw_reject)(struct iw_cm_id *, const void *, u8);
	int (*iw_create_listen)(struct iw_cm_id *, int);
	int (*iw_destroy_listen)(struct iw_cm_id *);
	int (*counter_bind_qp)(struct rdma_counter *, struct ib_qp *);
	int (*counter_unbind_qp)(struct ib_qp *);
	int (*counter_dealloc)(struct rdma_counter *);
	struct rdma_hw_stats * (*counter_alloc_stats)(struct rdma_counter *);
	int (*counter_update_stats)(struct rdma_counter *);
	int (*fill_stat_mr_entry)(struct sk_buff *, struct ib_mr *);
	int (*query_ucontext)(struct ib_ucontext *, struct uverbs_attr_bundle *);
	int (*get_numa_node)(struct ib_device *);
	size_t size_ib_ah;
	size_t size_ib_counters;
	size_t size_ib_cq;
	size_t size_ib_mw;
	size_t size_ib_pd;
	size_t size_ib_qp;
	size_t size_ib_rwq_ind_table;
	size_t size_ib_srq;
	size_t size_ib_ucontext;
	size_t size_ib_xrcd;
};

struct ib_core_device {
	struct device dev;
	possible_net_t rdma_net;
	struct kobject *ports_kobj;
	struct list_head port_list;
	struct ib_device *owner;
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

struct ib_odp_caps {
	uint64_t general_caps;
	struct {
		uint32_t rc_odp_caps;
		uint32_t uc_odp_caps;
		uint32_t ud_odp_caps;
		uint32_t xrc_odp_caps;
	} per_transport_caps;
};

struct ib_rss_caps {
	u32 supported_qpts;
	u32 max_rwq_indirection_tables;
	u32 max_rwq_indirection_table_size;
};

struct ib_tm_caps {
	u32 max_rndv_hdr_size;
	u32 max_num_tags;
	u32 flags;
	u32 max_ops;
	u32 max_sge;
};

struct ib_cq_caps {
	u16 max_cq_moderation_count;
	u16 max_cq_moderation_period;
};

struct ib_device_attr {
	u64 fw_ver;
	__be64 sys_image_guid;
	u64 max_mr_size;
	u64 page_size_cap;
	u32 vendor_id;
	u32 vendor_part_id;
	u32 hw_ver;
	int max_qp;
	int max_qp_wr;
	u64 device_cap_flags;
	u64 kernel_cap_flags;
	int max_send_sge;
	int max_recv_sge;
	int max_sge_rd;
	int max_cq;
	int max_cqe;
	int max_mr;
	int max_pd;
	int max_qp_rd_atom;
	int max_ee_rd_atom;
	int max_res_rd_atom;
	int max_qp_init_rd_atom;
	int max_ee_init_rd_atom;
	enum ib_atomic_cap atomic_cap;
	enum ib_atomic_cap masked_atomic_cap;
	int max_ee;
	int max_rdd;
	int max_mw;
	int max_raw_ipv6_qp;
	int max_raw_ethy_qp;
	int max_mcast_grp;
	int max_mcast_qp_attach;
	int max_total_mcast_qp_attach;
	int max_ah;
	int max_srq;
	int max_srq_wr;
	int max_srq_sge;
	unsigned int max_fast_reg_page_list_len;
	unsigned int max_pi_fast_reg_page_list_len;
	u16 max_pkeys;
	u8 local_ca_ack_delay;
	int sig_prot_cap;
	int sig_guard_cap;
	struct ib_odp_caps odp_caps;
	uint64_t timestamp_mask;
	uint64_t hca_core_clock;
	struct ib_rss_caps rss_caps;
	u32 max_wq_type_rq;
	u32 raw_packet_caps;
	struct ib_tm_caps tm_caps;
	struct ib_cq_caps cq_caps;
	u64 max_dm_size;
	u32 max_sgl_rd;
};

struct hw_stats_device_data;

struct rdma_restrack_root;

struct uapi_definition;

struct ib_port_data;

struct rdma_link_ops;

struct ib_device {
	struct device *dma_device;
	struct ib_device_ops ops;
	char name[64];
	struct callback_head callback_head;
	struct list_head event_handler_list;
	struct rw_semaphore event_handler_rwsem;
	spinlock_t qp_open_list_lock;
	struct rw_semaphore client_data_rwsem;
	struct xarray client_data;
	struct mutex unregistration_lock;
	rwlock_t cache_lock;
	struct ib_port_data *port_data;
	int num_comp_vectors;
	union {
		struct device dev;
		struct ib_core_device coredev;
	};
	const struct attribute_group *groups[4];
	u64 uverbs_cmd_mask;
	char node_desc[64];
	__be64 node_guid;
	u32 local_dma_lkey;
	u16 is_switch: 1;
	u16 kverbs_provider: 1;
	u16 use_cq_dim: 1;
	u8 node_type;
	u32 phys_port_cnt;
	struct ib_device_attr attrs;
	struct hw_stats_device_data *hw_stats_data;
	u32 index;
	spinlock_t cq_pools_lock;
	struct list_head cq_pools[3];
	struct rdma_restrack_root *res;
	const struct uapi_definition *driver_def;
	refcount_t refcount;
	struct completion unreg_completion;
	struct work_struct unregistration_work;
	const struct rdma_link_ops *link_ops;
	struct mutex compat_devs_mutex;
	struct xarray compat_devs;
	char iw_ifname[16];
	u32 iw_driver_flags;
	u32 lag_flags;
};

struct devlink_port_new_attrs {
	enum devlink_port_flavour flavour;
	unsigned int port_index;
	u32 controller;
	u32 sfnum;
	u16 pfnum;
	u8 port_index_valid: 1;
	u8 controller_valid: 1;
	u8 sfnum_valid: 1;
};

struct devlink_sb_pool_info {
	enum devlink_sb_pool_type pool_type;
	u32 size;
	enum devlink_sb_threshold_type threshold_type;
	u32 cell_size;
};

struct devlink_dpipe_field {
	const char *name;
	unsigned int id;
	unsigned int bitwidth;
	enum devlink_dpipe_field_mapping_type mapping_type;
};

struct devlink_dpipe_header {
	const char *name;
	unsigned int id;
	struct devlink_dpipe_field *fields;
	unsigned int fields_count;
	bool global;
};

struct devlink_dpipe_headers {
	struct devlink_dpipe_header **headers;
	unsigned int headers_count;
};

struct devlink_flash_update_params {
	const struct firmware *fw;
	const char *component;
	u32 overwrite_mask;
};

struct devlink_trap_policer {
	u32 id;
	u64 init_rate;
	u64 init_burst;
	u64 max_rate;
	u64 min_rate;
	u64 max_burst;
	u64 min_burst;
};

struct devlink_trap_group {
	const char *name;
	u16 id;
	bool generic;
	u32 init_policer_id;
};

struct devlink_trap {
	enum devlink_trap_type type;
	enum devlink_trap_action init_action;
	bool generic;
	u16 id;
	const char *name;
	u16 init_group_id;
	u32 metadata_cap;
};

struct devlink_info_req;

struct devlink_ops {
	u32 supported_flash_update_params;
	long unsigned int reload_actions;
	long unsigned int reload_limits;
	int (*reload_down)(struct devlink *, bool, enum devlink_reload_action, enum devlink_reload_limit, struct netlink_ext_ack *);
	int (*reload_up)(struct devlink *, enum devlink_reload_action, enum devlink_reload_limit, u32 *, struct netlink_ext_ack *);
	int (*sb_pool_get)(struct devlink *, unsigned int, u16, struct devlink_sb_pool_info *);
	int (*sb_pool_set)(struct devlink *, unsigned int, u16, u32, enum devlink_sb_threshold_type, struct netlink_ext_ack *);
	int (*sb_port_pool_get)(struct devlink_port *, unsigned int, u16, u32 *);
	int (*sb_port_pool_set)(struct devlink_port *, unsigned int, u16, u32, struct netlink_ext_ack *);
	int (*sb_tc_pool_bind_get)(struct devlink_port *, unsigned int, u16, enum devlink_sb_pool_type, u16 *, u32 *);
	int (*sb_tc_pool_bind_set)(struct devlink_port *, unsigned int, u16, enum devlink_sb_pool_type, u16, u32, struct netlink_ext_ack *);
	int (*sb_occ_snapshot)(struct devlink *, unsigned int);
	int (*sb_occ_max_clear)(struct devlink *, unsigned int);
	int (*sb_occ_port_pool_get)(struct devlink_port *, unsigned int, u16, u32 *, u32 *);
	int (*sb_occ_tc_port_bind_get)(struct devlink_port *, unsigned int, u16, enum devlink_sb_pool_type, u32 *, u32 *);
	int (*eswitch_mode_get)(struct devlink *, u16 *);
	int (*eswitch_mode_set)(struct devlink *, u16, struct netlink_ext_ack *);
	int (*eswitch_inline_mode_get)(struct devlink *, u8 *);
	int (*eswitch_inline_mode_set)(struct devlink *, u8, struct netlink_ext_ack *);
	int (*eswitch_encap_mode_get)(struct devlink *, enum devlink_eswitch_encap_mode *);
	int (*eswitch_encap_mode_set)(struct devlink *, enum devlink_eswitch_encap_mode, struct netlink_ext_ack *);
	int (*info_get)(struct devlink *, struct devlink_info_req *, struct netlink_ext_ack *);
	int (*flash_update)(struct devlink *, struct devlink_flash_update_params *, struct netlink_ext_ack *);
	int (*trap_init)(struct devlink *, const struct devlink_trap *, void *);
	void (*trap_fini)(struct devlink *, const struct devlink_trap *, void *);
	int (*trap_action_set)(struct devlink *, const struct devlink_trap *, enum devlink_trap_action, struct netlink_ext_ack *);
	int (*trap_group_init)(struct devlink *, const struct devlink_trap_group *);
	int (*trap_group_set)(struct devlink *, const struct devlink_trap_group *, const struct devlink_trap_policer *, struct netlink_ext_ack *);
	int (*trap_group_action_set)(struct devlink *, const struct devlink_trap_group *, enum devlink_trap_action, struct netlink_ext_ack *);
	int (*trap_drop_counter_get)(struct devlink *, const struct devlink_trap *, u64 *);
	int (*trap_policer_init)(struct devlink *, const struct devlink_trap_policer *);
	void (*trap_policer_fini)(struct devlink *, const struct devlink_trap_policer *);
	int (*trap_policer_set)(struct devlink *, const struct devlink_trap_policer *, u64, u64, struct netlink_ext_ack *);
	int (*trap_policer_counter_get)(struct devlink *, const struct devlink_trap_policer *, u64 *);
	int (*port_new)(struct devlink *, const struct devlink_port_new_attrs *, struct netlink_ext_ack *, struct devlink_port **);
	int (*rate_leaf_tx_share_set)(struct devlink_rate *, void *, u64, struct netlink_ext_ack *);
	int (*rate_leaf_tx_max_set)(struct devlink_rate *, void *, u64, struct netlink_ext_ack *);
	int (*rate_leaf_tx_priority_set)(struct devlink_rate *, void *, u32, struct netlink_ext_ack *);
	int (*rate_leaf_tx_weight_set)(struct devlink_rate *, void *, u32, struct netlink_ext_ack *);
	int (*rate_node_tx_share_set)(struct devlink_rate *, void *, u64, struct netlink_ext_ack *);
	int (*rate_node_tx_max_set)(struct devlink_rate *, void *, u64, struct netlink_ext_ack *);
	int (*rate_node_tx_priority_set)(struct devlink_rate *, void *, u32, struct netlink_ext_ack *);
	int (*rate_node_tx_weight_set)(struct devlink_rate *, void *, u32, struct netlink_ext_ack *);
	int (*rate_node_new)(struct devlink_rate *, void **, struct netlink_ext_ack *);
	int (*rate_node_del)(struct devlink_rate *, void *, struct netlink_ext_ack *);
	int (*rate_leaf_parent_set)(struct devlink_rate *, struct devlink_rate *, void *, void *, struct netlink_ext_ack *);
	int (*rate_node_parent_set)(struct devlink_rate *, struct devlink_rate *, void *, void *, struct netlink_ext_ack *);
	bool (*selftest_check)(struct devlink *, unsigned int, struct netlink_ext_ack *);
	enum devlink_selftest_status (*selftest_run)(struct devlink *, unsigned int, struct netlink_ext_ack *);
};

struct irq_poll;

typedef int irq_poll_fn(struct irq_poll *, int);

struct irq_poll {
	struct list_head list;
	long unsigned int state;
	int weight;
	irq_poll_fn *poll;
};

struct dim_sample {
	ktime_t time;
	u32 pkt_ctr;
	u32 byte_ctr;
	u16 event_ctr;
	u32 comp_ctr;
};

struct dim_stats {
	int ppms;
	int bpms;
	int epms;
	int cpms;
	int cpe_ratio;
};

struct dim {
	u8 state;
	struct dim_stats prev_stats;
	struct dim_sample start_sample;
	struct dim_sample measuring_sample;
	struct work_struct work;
	void *priv;
	u8 profile_ix;
	u8 mode;
	u8 tune_state;
	u8 steps_right;
	u8 steps_left;
	u8 tired;
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

struct rdma_restrack_entry {
	bool valid;
	u8 no_track: 1;
	struct kref kref;
	struct completion comp;
	struct task_struct *task;
	const char *kern_name;
	enum rdma_restrack_type type;
	bool user;
	u32 id;
};

struct rdma_link_ops {
	struct list_head list;
	const char *type;
	int (*newlink)(const char *, struct net_device *);
};

struct auto_mode_param {
	int qp_type;
};

struct rdma_counter_mode {
	enum rdma_nl_counter_mode mode;
	enum rdma_nl_counter_mask mask;
	struct auto_mode_param param;
};

struct rdma_port_counter {
	struct rdma_counter_mode mode;
	struct rdma_hw_stats *hstats;
	unsigned int num_counters;
	struct mutex lock;
};

struct rdma_stat_desc;

struct rdma_hw_stats {
	struct mutex lock;
	long unsigned int timestamp;
	long unsigned int lifespan;
	const struct rdma_stat_desc *descs;
	long unsigned int *is_disabled;
	int num_counters;
	u64 value[0];
};

struct rdma_counter {
	struct rdma_restrack_entry res;
	struct ib_device *device;
	uint32_t id;
	struct kref kref;
	struct rdma_counter_mode mode;
	struct mutex lock;
	struct rdma_hw_stats *stats;
	u32 port;
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

struct ib_t10_dif_domain {
	enum ib_t10_dif_bg_type bg_type;
	u16 pi_interval;
	u16 bg;
	u16 app_tag;
	u32 ref_tag;
	bool ref_remap;
	bool app_escape;
	bool ref_escape;
	u16 apptag_check_mask;
};

struct ib_sig_domain {
	enum ib_signature_type sig_type;
	union {
		struct ib_t10_dif_domain dif;
	} sig;
};

struct ib_sig_attrs {
	u8 check_mask;
	struct ib_sig_domain mem;
	struct ib_sig_domain wire;
	int meta_length;
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

struct ib_sig_err {
	enum ib_sig_err_type err_type;
	u32 expected;
	u32 actual;
	u64 sig_err_offset;
	u32 key;
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

union ib_gid {
	u8 raw[16];
	struct {
		__be64 subnet_prefix;
		__be64 interface_id;
	} global;
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

struct ib_gid_attr {
	struct net_device *ndev;
	struct ib_device *device;
	union ib_gid gid;
	enum ib_gid_type gid_type;
	u16 index;
	u32 port_num;
};

struct ib_cq_init_attr {
	unsigned int cqe;
	u32 comp_vector;
	u32 flags;
};

struct ib_dm_mr_attr {
	u64 length;
	u64 offset;
	u32 access_flags;
};

struct ib_dm_alloc_attr {
	u64 length;
	u32 alignment;
	u32 flags;
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

struct rdma_stat_desc {
	const char *name;
	unsigned int flags;
	const void *priv;
};

struct ib_port_attr {
	u64 subnet_prefix;
	enum ib_port_state state;
	enum ib_mtu max_mtu;
	enum ib_mtu active_mtu;
	u32 phys_mtu;
	int gid_tbl_len;
	unsigned int ip_gids: 1;
	u32 port_cap_flags;
	u32 max_msg_sz;
	u32 bad_pkey_cntr;
	u32 qkey_viol_cntr;
	u16 pkey_tbl_len;
	u32 sm_lid;
	u32 lid;
	u8 lmc;
	u8 max_vl_num;
	u8 sm_sl;
	u8 subnet_timeout;
	u8 init_type_reply;
	u8 active_width;
	u16 active_speed;
	u8 phys_state;
	u16 port_cap_flags2;
};

struct ib_device_modify {
	u64 sys_image_guid;
	char node_desc[64];
};

struct ib_port_modify {
	u32 set_port_cap_mask;
	u32 clr_port_cap_mask;
	u8 init_type;
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

struct ib_ucq_object;

typedef void (*ib_comp_handler)(struct ib_cq *, void *);

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

struct ib_event;

struct ib_cq {
	struct ib_device *device;
	struct ib_ucq_object *uobject;
	ib_comp_handler comp_handler;
	void (*event_handler)(struct ib_event *, void *);
	void *cq_context;
	int cqe;
	unsigned int cqe_used;
	atomic_t usecnt;
	enum ib_poll_context poll_ctx;
	struct ib_wc *wc;
	struct list_head pool_entry;
	union {
		struct irq_poll iop;
		struct work_struct work;
	};
	struct workqueue_struct *comp_wq;
	struct dim *dim;
	ktime_t timestamp;
	u8 interrupt: 1;
	u8 shared: 1;
	unsigned int comp_vector;
	struct rdma_restrack_entry res;
};

struct ib_uqp_object;

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

struct ib_qp_security;

struct ib_qp {
	struct ib_device *device;
	struct ib_pd *pd;
	struct ib_cq *send_cq;
	struct ib_cq *recv_cq;
	spinlock_t mr_lock;
	int mrs_used;
	struct list_head rdma_mrs;
	struct list_head sig_mrs;
	struct ib_srq *srq;
	struct ib_xrcd *xrcd;
	struct list_head xrcd_list;
	atomic_t usecnt;
	struct list_head open_list;
	struct ib_qp *real_qp;
	struct ib_uqp_object *uobject;
	void (*event_handler)(struct ib_event *, void *);
	void *qp_context;
	const struct ib_gid_attr *av_sgid_attr;
	const struct ib_gid_attr *alt_path_sgid_attr;
	u32 qp_num;
	u32 max_write_sge;
	u32 max_read_sge;
	enum ib_qp_type qp_type;
	struct ib_rwq_ind_table *rwq_ind_tbl;
	struct ib_qp_security *qp_sec;
	u32 port;
	bool integrity_en;
	struct rdma_restrack_entry res;
	struct rdma_counter *counter;
};

struct ib_usrq_object;

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

struct ib_srq {
	struct ib_device *device;
	struct ib_pd *pd;
	struct ib_usrq_object *uobject;
	void (*event_handler)(struct ib_event *, void *);
	void *srq_context;
	enum ib_srq_type srq_type;
	atomic_t usecnt;
	struct {
		struct ib_cq *cq;
		union {
			struct {
				struct ib_xrcd *xrcd;
				u32 srq_num;
			} xrc;
		};
	} ext;
	struct rdma_restrack_entry res;
};

struct ib_uwq_object;

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

struct ib_wq {
	struct ib_device *device;
	struct ib_uwq_object *uobject;
	void *wq_context;
	void (*event_handler)(struct ib_event *, void *);
	struct ib_pd *pd;
	struct ib_cq *cq;
	u32 wq_num;
	enum ib_wq_state state;
	enum ib_wq_type wq_type;
	atomic_t usecnt;
};

struct ib_event {
	struct ib_device *device;
	union {
		struct ib_cq *cq;
		struct ib_qp *qp;
		struct ib_srq *srq;
		struct ib_wq *wq;
		u32 port_num;
	} element;
	enum ib_event_type event;
};

struct ib_global_route {
	const struct ib_gid_attr *sgid_attr;
	union ib_gid dgid;
	u32 flow_label;
	u8 sgid_index;
	u8 hop_limit;
	u8 traffic_class;
};

struct ib_grh {
	__be32 version_tclass_flow;
	__be16 paylen;
	u8 next_hdr;
	u8 hop_limit;
	union ib_gid sgid;
	union ib_gid dgid;
};

struct ib_mr_status {
	u32 fail_status;
	struct ib_sig_err sig_err;
};

struct rdma_ah_init_attr {
	struct rdma_ah_attr *ah_attr;
	u32 flags;
	struct net_device *xmit_slave;
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

struct ib_ah_attr {
	u16 dlid;
	u8 src_path_bits;
};

struct roce_ah_attr {
	u8 dmac[6];
};

struct opa_ah_attr {
	u32 dlid;
	u8 src_path_bits;
	bool make_grd;
};

struct rdma_ah_attr {
	struct ib_global_route grh;
	u8 sl;
	u8 static_rate;
	u32 port_num;
	u8 ah_flags;
	enum rdma_ah_attr_type type;
	union {
		struct ib_ah_attr ib;
		struct roce_ah_attr roce;
		struct opa_ah_attr opa;
	};
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

struct ib_cqe {
	void (*done)(struct ib_cq *, struct ib_wc *);
};

struct ib_wc {
	union {
		u64 wr_id;
		struct ib_cqe *wr_cqe;
	};
	enum ib_wc_status status;
	enum ib_wc_opcode opcode;
	u32 vendor_err;
	u32 byte_len;
	struct ib_qp *qp;
	union {
		__be32 imm_data;
		u32 invalidate_rkey;
	} ex;
	u32 src_qp;
	u32 slid;
	int wc_flags;
	u16 pkey_index;
	u8 sl;
	u8 dlid_path_bits;
	u32 port_num;
	u8 smac[6];
	u16 vlan_id;
	u8 network_hdr_type;
};

struct ib_srq_attr {
	u32 max_wr;
	u32 max_sge;
	u32 srq_limit;
};

struct ib_xrcd {
	struct ib_device *device;
	atomic_t usecnt;
	struct inode *inode;
	struct rw_semaphore tgt_qps_rwsem;
	struct xarray tgt_qps;
};

struct ib_srq_init_attr {
	void (*event_handler)(struct ib_event *, void *);
	void *srq_context;
	struct ib_srq_attr attr;
	enum ib_srq_type srq_type;
	struct {
		struct ib_cq *cq;
		union {
			struct {
				struct ib_xrcd *xrcd;
			} xrc;
			struct {
				u32 max_num_tags;
			} tag_matching;
		};
	} ext;
};

struct ib_qp_cap {
	u32 max_send_wr;
	u32 max_recv_wr;
	u32 max_send_sge;
	u32 max_recv_sge;
	u32 max_inline_data;
	u32 max_rdma_ctxs;
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

struct ib_qp_init_attr {
	void (*event_handler)(struct ib_event *, void *);
	void *qp_context;
	struct ib_cq *send_cq;
	struct ib_cq *recv_cq;
	struct ib_srq *srq;
	struct ib_xrcd *xrcd;
	struct ib_qp_cap cap;
	enum ib_sig_type sq_sig_type;
	enum ib_qp_type qp_type;
	u32 create_flags;
	u32 port_num;
	struct ib_rwq_ind_table *rwq_ind_tbl;
	u32 source_qpn;
};

struct ib_uobject;

struct ib_rwq_ind_table {
	struct ib_device *device;
	struct ib_uobject *uobject;
	atomic_t usecnt;
	u32 ind_tbl_num;
	u32 log_ind_tbl_size;
	struct ib_wq **ind_tbl;
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

struct ib_qp_attr {
	enum ib_qp_state qp_state;
	enum ib_qp_state cur_qp_state;
	enum ib_mtu path_mtu;
	enum ib_mig_state path_mig_state;
	u32 qkey;
	u32 rq_psn;
	u32 sq_psn;
	u32 dest_qp_num;
	int qp_access_flags;
	struct ib_qp_cap cap;
	struct rdma_ah_attr ah_attr;
	struct rdma_ah_attr alt_ah_attr;
	u16 pkey_index;
	u16 alt_pkey_index;
	u8 en_sqd_async_notify;
	u8 sq_draining;
	u8 max_rd_atomic;
	u8 max_dest_rd_atomic;
	u8 min_rnr_timer;
	u32 port_num;
	u8 timeout;
	u8 retry_cnt;
	u8 rnr_retry;
	u32 alt_port_num;
	u8 alt_timeout;
	u32 rate_limit;
	struct net_device *xmit_slave;
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

struct ib_sge {
	u64 addr;
	u32 length;
	u32 lkey;
};

struct ib_send_wr {
	struct ib_send_wr *next;
	union {
		u64 wr_id;
		struct ib_cqe *wr_cqe;
	};
	struct ib_sge *sg_list;
	int num_sge;
	enum ib_wr_opcode opcode;
	int send_flags;
	union {
		__be32 imm_data;
		u32 invalidate_rkey;
	} ex;
};

struct ib_ah {
	struct ib_device *device;
	struct ib_pd *pd;
	struct ib_uobject *uobject;
	const struct ib_gid_attr *sgid_attr;
	enum rdma_ah_attr_type type;
};

struct ib_mr {
	struct ib_device *device;
	struct ib_pd *pd;
	u32 lkey;
	u32 rkey;
	u64 iova;
	u64 length;
	unsigned int page_size;
	enum ib_mr_type type;
	bool need_inval;
	union {
		struct ib_uobject *uobject;
		struct list_head qp_entry;
	};
	struct ib_dm *dm;
	struct ib_sig_attrs *sig_attrs;
	struct rdma_restrack_entry res;
};

struct ib_recv_wr {
	struct ib_recv_wr *next;
	union {
		u64 wr_id;
		struct ib_cqe *wr_cqe;
	};
	struct ib_sge *sg_list;
	int num_sge;
};

struct ib_rdmacg_object {};

struct ib_uverbs_file;

struct ib_ucontext {
	struct ib_device *device;
	struct ib_uverbs_file *ufile;
	struct ib_rdmacg_object cg_obj;
	struct rdma_restrack_entry res;
	struct xarray mmap_xa;
};

struct uverbs_api_object;

struct ib_uobject {
	u64 user_handle;
	struct ib_uverbs_file *ufile;
	struct ib_ucontext *context;
	void *object;
	struct list_head list;
	struct ib_rdmacg_object cg_obj;
	int id;
	struct kref ref;
	atomic_t usecnt;
	struct callback_head rcu;
	const struct uverbs_api_object *uapi_object;
};

struct ib_udata {
	const void *inbuf;
	void *outbuf;
	size_t inlen;
	size_t outlen;
};

struct ib_pd {
	u32 local_dma_lkey;
	u32 flags;
	struct ib_device *device;
	struct ib_uobject *uobject;
	atomic_t usecnt;
	u32 unsafe_global_rkey;
	struct ib_mr *__internal_mr;
	struct rdma_restrack_entry res;
};

struct ib_wq_init_attr {
	void *wq_context;
	enum ib_wq_type wq_type;
	u32 max_wr;
	u32 max_sge;
	struct ib_cq *cq;
	void (*event_handler)(struct ib_event *, void *);
	u32 create_flags;
};

struct ib_wq_attr {
	enum ib_wq_state wq_state;
	enum ib_wq_state curr_wq_state;
	u32 flags;
	u32 flags_mask;
};

struct ib_rwq_ind_table_init_attr {
	u32 log_ind_tbl_size;
	struct ib_wq **ind_tbl;
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

struct ib_port_pkey {
	enum port_pkey_state state;
	u16 pkey_index;
	u32 port_num;
	struct list_head qp_list;
	struct list_head to_error_list;
	struct ib_qp_security *sec;
};

struct ib_ports_pkeys;

struct ib_qp_security {
	struct ib_qp *qp;
	struct ib_device *dev;
	struct mutex mutex;
	struct ib_ports_pkeys *ports_pkeys;
	struct list_head shared_qp_list;
	void *security;
	bool destroying;
	atomic_t error_list_count;
	struct completion error_complete;
	int error_comps_pending;
};

struct ib_ports_pkeys {
	struct ib_port_pkey main;
	struct ib_port_pkey alt;
};

struct ib_dm {
	struct ib_device *device;
	u32 length;
	u32 flags;
	struct ib_uobject *uobject;
	atomic_t usecnt;
};

struct ib_mw {
	struct ib_device *device;
	struct ib_pd *pd;
	struct ib_uobject *uobject;
	u32 rkey;
	enum ib_mw_type type;
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

struct ib_flow_eth_filter {
	u8 dst_mac[6];
	u8 src_mac[6];
	__be16 ether_type;
	__be16 vlan_tag;
	u8 real_sz[0];
};

struct ib_flow_spec_eth {
	u32 type;
	u16 size;
	struct ib_flow_eth_filter val;
	struct ib_flow_eth_filter mask;
};

struct ib_flow_ib_filter {
	__be16 dlid;
	__u8 sl;
	u8 real_sz[0];
};

struct ib_flow_spec_ib {
	u32 type;
	u16 size;
	struct ib_flow_ib_filter val;
	struct ib_flow_ib_filter mask;
};

struct ib_flow_ipv4_filter {
	__be32 src_ip;
	__be32 dst_ip;
	u8 proto;
	u8 tos;
	u8 ttl;
	u8 flags;
	u8 real_sz[0];
};

struct ib_flow_spec_ipv4 {
	u32 type;
	u16 size;
	struct ib_flow_ipv4_filter val;
	struct ib_flow_ipv4_filter mask;
};

struct ib_flow_ipv6_filter {
	u8 src_ip[16];
	u8 dst_ip[16];
	__be32 flow_label;
	u8 next_hdr;
	u8 traffic_class;
	u8 hop_limit;
	u8 real_sz[0];
};

struct ib_flow_spec_ipv6 {
	u32 type;
	u16 size;
	struct ib_flow_ipv6_filter val;
	struct ib_flow_ipv6_filter mask;
};

struct ib_flow_tcp_udp_filter {
	__be16 dst_port;
	__be16 src_port;
	u8 real_sz[0];
};

struct ib_flow_spec_tcp_udp {
	u32 type;
	u16 size;
	struct ib_flow_tcp_udp_filter val;
	struct ib_flow_tcp_udp_filter mask;
};

struct ib_flow_tunnel_filter {
	__be32 tunnel_id;
	u8 real_sz[0];
};

struct ib_flow_spec_tunnel {
	u32 type;
	u16 size;
	struct ib_flow_tunnel_filter val;
	struct ib_flow_tunnel_filter mask;
};

struct ib_flow_esp_filter {
	__be32 spi;
	__be32 seq;
	u8 real_sz[0];
};

struct ib_flow_spec_esp {
	u32 type;
	u16 size;
	struct ib_flow_esp_filter val;
	struct ib_flow_esp_filter mask;
};

struct ib_flow_gre_filter {
	__be16 c_ks_res0_ver;
	__be16 protocol;
	__be32 key;
	u8 real_sz[0];
};

struct ib_flow_spec_gre {
	u32 type;
	u16 size;
	struct ib_flow_gre_filter val;
	struct ib_flow_gre_filter mask;
};

struct ib_flow_mpls_filter {
	__be32 tag;
	u8 real_sz[0];
};

struct ib_flow_spec_mpls {
	u32 type;
	u16 size;
	struct ib_flow_mpls_filter val;
	struct ib_flow_mpls_filter mask;
};

struct ib_flow_spec_action_tag {
	enum ib_flow_spec_type type;
	u16 size;
	u32 tag_id;
};

struct ib_flow_spec_action_drop {
	enum ib_flow_spec_type type;
	u16 size;
};

struct ib_flow_spec_action_handle {
	enum ib_flow_spec_type type;
	u16 size;
	struct ib_flow_action *act;
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

struct ib_flow_action {
	struct ib_device *device;
	struct ib_uobject *uobject;
	enum ib_flow_action_type type;
	atomic_t usecnt;
};

struct ib_flow_spec_action_count {
	enum ib_flow_spec_type type;
	u16 size;
	struct ib_counters *counters;
};

struct ib_counters {
	struct ib_device *device;
	struct ib_uobject *uobject;
	atomic_t usecnt;
};

union ib_flow_spec {
	struct {
		u32 type;
		u16 size;
	};
	struct ib_flow_spec_eth eth;
	struct ib_flow_spec_ib ib;
	struct ib_flow_spec_ipv4 ipv4;
	struct ib_flow_spec_tcp_udp tcp_udp;
	struct ib_flow_spec_ipv6 ipv6;
	struct ib_flow_spec_tunnel tunnel;
	struct ib_flow_spec_esp esp;
	struct ib_flow_spec_gre gre;
	struct ib_flow_spec_mpls mpls;
	struct ib_flow_spec_action_tag flow_tag;
	struct ib_flow_spec_action_drop drop;
	struct ib_flow_spec_action_handle action;
	struct ib_flow_spec_action_count flow_count;
};

struct ib_flow_attr {
	enum ib_flow_attr_type type;
	u16 size;
	u16 priority;
	u32 flags;
	u8 num_of_specs;
	u32 port;
	union ib_flow_spec flows[0];
};

struct ib_flow {
	struct ib_qp *qp;
	struct ib_device *device;
	struct ib_uobject *uobject;
};

struct ib_pkey_cache;

struct ib_gid_table;

struct ib_port_cache {
	u64 subnet_prefix;
	struct ib_pkey_cache *pkey;
	struct ib_gid_table *gid;
	u8 lmc;
	enum ib_port_state port_state;
};

struct ib_port_immutable {
	int pkey_tbl_len;
	int gid_tbl_len;
	u32 core_cap_flags;
	u32 max_mad_size;
};

struct ib_port;

struct ib_port_data {
	struct ib_device *ib_dev;
	struct ib_port_immutable immutable;
	spinlock_t pkey_list_lock;
	spinlock_t netdev_lock;
	struct list_head pkey_list;
	struct ib_port_cache cache;
	struct net_device *netdev;
	netdevice_tracker netdev_tracker;
	struct hlist_node ndev_hash_link;
	struct rdma_port_counter port_counter;
	struct ib_port *sysfs;
};

struct rdma_netdev_alloc_params {
	size_t sizeof_priv;
	unsigned int txqs;
	unsigned int rxqs;
	void *param;
	int (*initialize_rdma_netdev)(struct ib_device *, u32, struct net_device *, void *);
};

struct ib_counters_read_attr {
	u64 *counters_buff;
	u32 ncounters;
	u32 flags;
};

struct rdma_user_mmap_entry {
	struct kref ref;
	struct ib_ucontext *ucontext;
	long unsigned int start_pgoff;
	size_t npages;
	bool driver_removed;
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

struct devlink_nl_dump_state {
	long unsigned int instance;
	int idx;
	union {
		struct {
			u64 start_offset;
		};
		struct {
			u64 dump_ts;
		};
	};
};

typedef int devlink_nl_dump_one_func_t(struct sk_buff *, struct devlink *, struct netlink_callback *, int);

struct vlan_group {
	unsigned int nr_vlan_devs;
	struct hlist_node hlist;
	struct net_device **vlan_devices_arrays[16];
};

struct vlan_info {
	struct net_device *real_dev;
	struct vlan_group grp;
	struct list_head vid_list;
	unsigned int nr_vids;
	struct callback_head rcu;
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

struct vlan_hdr {
	__be16 h_vlan_TCI;
	__be16 h_vlan_encapsulated_proto;
};

struct vlan_pcpu_stats {
	u64_stats_t rx_packets;
	u64_stats_t rx_bytes;
	u64_stats_t rx_multicast;
	u64_stats_t tx_packets;
	u64_stats_t tx_bytes;
	struct u64_stats_sync syncp;
	u32 rx_errors;
	u32 tx_dropped;
};

struct vlan_priority_tci_mapping {
	u32 priority;
	u16 vlan_qos;
	struct vlan_priority_tci_mapping *next;
};

struct vlan_dev_priv {
	unsigned int nr_ingress_mappings;
	u32 ingress_priority_map[8];
	unsigned int nr_egress_mappings;
	struct vlan_priority_tci_mapping *egress_priority_map[16];
	__be16 vlan_proto;
	u16 vlan_id;
	u16 flags;
	struct net_device *real_dev;
	netdevice_tracker dev_tracker;
	unsigned char real_dev_addr[6];
	struct proc_dir_entry *dent;
	struct vlan_pcpu_stats *vlan_pcpu_stats;
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

struct mpls_link_stats {
	__u64 rx_packets;
	__u64 tx_packets;
	__u64 rx_bytes;
	__u64 tx_bytes;
	__u64 rx_errors;
	__u64 tx_errors;
	__u64 rx_dropped;
	__u64 tx_dropped;
	__u64 rx_noroute;
};

struct mpls_nh {
	struct net_device *nh_dev;
	unsigned int nh_flags;
	u8 nh_labels;
	u8 nh_via_alen;
	u8 nh_via_table;
	u8 nh_reserved1;
	u32 nh_label[0];
};

struct mpls_route {
	struct callback_head rt_rcu;
	u8 rt_protocol;
	u8 rt_payload_type;
	u8 rt_max_alen;
	u8 rt_ttl_propagate;
	u8 rt_nhn;
	u8 rt_nhn_alive;
	u8 rt_nh_size;
	u8 rt_via_offset;
	u8 rt_reserved1;
	struct mpls_nh rt_nh[0];
};

struct mpls_pcpu_stats;

struct mpls_dev {
	int input_enabled;
	struct net_device *dev;
	struct mpls_pcpu_stats *stats;
	struct ctl_table_header *sysctl;
	struct callback_head rcu;
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_DN_TABLE = 2,
	NEIGH_NR_TABLES = 3,
	NEIGH_LINK_TABLE = 3,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

struct lwtunnel_encap_ops {
	int (*build_state)(struct net *, struct nlattr *, unsigned int, const void *, struct lwtunnel_state **, struct netlink_ext_ack *);
	void (*destroy_state)(struct lwtunnel_state *);
	int (*output)(struct net *, struct sock *, struct sk_buff *);
	int (*input)(struct sk_buff *);
	int (*fill_encap)(struct sk_buff *, struct lwtunnel_state *);
	int (*get_encap_size)(struct lwtunnel_state *);
	int (*cmp_encap)(struct lwtunnel_state *, struct lwtunnel_state *);
	int (*xmit)(struct sk_buff *);
	struct module *owner;
};

struct mpls_iptunnel_encap {
	u8 labels;
	u8 ttl_propagate;
	u8 default_ttl;
	u8 reserved1;
	u32 label[0];
};

enum {
	MPLS_IPTUNNEL_UNSPEC = 0,
	MPLS_IPTUNNEL_DST = 1,
	MPLS_IPTUNNEL_TTL = 2,
	__MPLS_IPTUNNEL_MAX = 3,
};

struct mpls_shim_hdr {
	__be32 label_stack_entry;
};

struct mpls_pcpu_stats {
	struct mpls_link_stats stats;
	struct u64_stats_sync syncp;
};

enum mpls_ttl_propagation {
	MPLS_TTL_PROP_DEFAULT = 0,
	MPLS_TTL_PROP_ENABLED = 1,
	MPLS_TTL_PROP_DISABLED = 2,
};

struct mptcp_mib {
	long unsigned int mibs[58];
};

struct mptcp_subflow_context;

struct mptcp_sched_data {
	bool reinject;
	u8 subflows;
	struct mptcp_subflow_context *contexts[8];
};

struct mptcp_subflow_context {
	struct list_head node;
	union {
		struct {
			long unsigned int avg_pacing_rate;
			u64 local_key;
			u64 remote_key;
			u64 idsn;
			u64 map_seq;
			u32 snd_isn;
			u32 token;
			u32 rel_write_seq;
			u32 map_subflow_seq;
			u32 ssn_offset;
			u32 map_data_len;
			__wsum map_data_csum;
			u32 map_csum_len;
			u32 request_mptcp: 1;
			u32 request_join: 1;
			u32 request_bkup: 1;
			u32 mp_capable: 1;
			u32 mp_join: 1;
			u32 fully_established: 1;
			u32 pm_notified: 1;
			u32 conn_finished: 1;
			u32 map_valid: 1;
			u32 map_csum_reqd: 1;
			u32 map_data_fin: 1;
			u32 mpc_map: 1;
			u32 backup: 1;
			u32 send_mp_prio: 1;
			u32 send_mp_fail: 1;
			u32 send_fastclose: 1;
			u32 send_infinite_map: 1;
			u32 remote_key_valid: 1;
			u32 disposable: 1;
			u32 stale: 1;
			u32 local_id_valid: 1;
			u32 valid_csum_seen: 1;
			u32 is_mptfo: 1;
			u32 __unused: 9;
			bool data_avail;
			bool scheduled;
			u32 remote_nonce;
			u64 thmac;
			u32 local_nonce;
			u32 remote_token;
			union {
				u8 hmac[20];
				u64 iasn;
			};
			u8 local_id;
			u8 remote_id;
			u8 reset_seen: 1;
			u8 reset_transient: 1;
			u8 reset_reason: 4;
			u8 stale_count;
			u32 subflow_id;
			long int delegated_status;
			long unsigned int fail_tout;
		};
		struct {
			long unsigned int avg_pacing_rate;
			u64 local_key;
			u64 remote_key;
			u64 idsn;
			u64 map_seq;
			u32 snd_isn;
			u32 token;
			u32 rel_write_seq;
			u32 map_subflow_seq;
			u32 ssn_offset;
			u32 map_data_len;
			__wsum map_data_csum;
			u32 map_csum_len;
			u32 request_mptcp: 1;
			u32 request_join: 1;
			u32 request_bkup: 1;
			u32 mp_capable: 1;
			u32 mp_join: 1;
			u32 fully_established: 1;
			u32 pm_notified: 1;
			u32 conn_finished: 1;
			u32 map_valid: 1;
			u32 map_csum_reqd: 1;
			u32 map_data_fin: 1;
			u32 mpc_map: 1;
			u32 backup: 1;
			u32 send_mp_prio: 1;
			u32 send_mp_fail: 1;
			u32 send_fastclose: 1;
			u32 send_infinite_map: 1;
			u32 remote_key_valid: 1;
			u32 disposable: 1;
			u32 stale: 1;
			u32 local_id_valid: 1;
			u32 valid_csum_seen: 1;
			u32 is_mptfo: 1;
			u32 __unused: 9;
			bool data_avail;
			bool scheduled;
			u32 remote_nonce;
			u64 thmac;
			u32 local_nonce;
			u32 remote_token;
			union {
				u8 hmac[20];
				u64 iasn;
			};
			u8 local_id;
			u8 remote_id;
			u8 reset_seen: 1;
			u8 reset_transient: 1;
			u8 reset_reason: 4;
			u8 stale_count;
			u32 subflow_id;
			long int delegated_status;
			long unsigned int fail_tout;
		} reset;
	};
	struct list_head delegated_node;
	u32 setsockopt_seq;
	u32 stale_rcv_tstamp;
	int cached_sndbuf;
	struct sock *tcp_sock;
	struct sock *conn;
	const struct inet_connection_sock_af_ops *icsk_af_ops;
	void (*tcp_state_change)(struct sock *);
	void (*tcp_error_report)(struct sock *);
	struct callback_head rcu;
};

struct mptcp_sock;

struct mptcp_sched_ops {
	int (*get_subflow)(struct mptcp_sock *, struct mptcp_sched_data *);
	char name[16];
	struct module *owner;
	struct list_head list;
	void (*init)(struct mptcp_sock *);
	void (*release)(struct mptcp_sock *);
};

struct mptcp_pm_data {
	struct mptcp_addr_info local;
	struct mptcp_addr_info remote;
	struct list_head anno_list;
	struct list_head userspace_pm_local_addr_list;
	spinlock_t lock;
	u8 addr_signal;
	bool server_side;
	bool work_pending;
	bool accept_addr;
	bool accept_subflow;
	bool remote_deny_join_id0;
	u8 add_addr_signaled;
	u8 add_addr_accepted;
	u8 local_addr_used;
	u8 pm_type;
	u8 subflows;
	u8 status;
	long unsigned int id_avail_bitmap[4];
	struct mptcp_rm_list rm_list_tx;
	struct mptcp_rm_list rm_list_rx;
};

struct mptcp_data_frag;

struct mptcp_sock {
	struct inet_connection_sock sk;
	u64 local_key;
	u64 remote_key;
	u64 write_seq;
	u64 bytes_sent;
	u64 snd_nxt;
	u64 bytes_received;
	u64 ack_seq;
	atomic64_t rcv_wnd_sent;
	u64 rcv_data_fin_seq;
	u64 bytes_retrans;
	u64 bytes_consumed;
	int rmem_fwd_alloc;
	int snd_burst;
	int old_wspace;
	u64 recovery_snd_nxt;
	u64 bytes_acked;
	u64 snd_una;
	u64 wnd_end;
	long unsigned int timer_ival;
	u32 token;
	int rmem_released;
	long unsigned int flags;
	long unsigned int cb_flags;
	long unsigned int push_pending;
	bool recovery;
	bool can_ack;
	bool fully_established;
	bool rcv_data_fin;
	bool snd_data_fin_enable;
	bool rcv_fastclose;
	bool use_64bit_ack;
	bool csum_enabled;
	bool allow_infinite_fallback;
	u8 mpc_endpoint_id;
	u8 recvmsg_inq: 1;
	u8 cork: 1;
	u8 nodelay: 1;
	u8 fastopening: 1;
	u8 in_accept_queue: 1;
	u8 free_first: 1;
	struct work_struct work;
	struct sk_buff *ooo_last_skb;
	struct rb_root out_of_order_queue;
	struct sk_buff_head receive_queue;
	struct list_head conn_list;
	struct list_head rtx_queue;
	struct mptcp_data_frag *first_pending;
	struct list_head join_list;
	struct sock *first;
	struct mptcp_pm_data pm;
	struct mptcp_sched_ops *sched;
	struct {
		u32 space;
		u32 copied;
		u64 time;
		u64 rtt_us;
	} rcvq_space;
	u8 scaling_ratio;
	u32 subflow_id;
	u32 setsockopt_seq;
	char ca_name[16];
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

struct mptcp_pm_addr_entry {
	struct list_head list;
	struct mptcp_addr_info addr;
	u8 flags;
	int ifindex;
	struct socket *lsk;
};

struct mptcp_data_frag {
	struct list_head list;
	u64 data_seq;
	u16 data_len;
	u16 offset;
	u16 overhead;
	u16 already_sent;
	struct page *page;
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_TOKENFALLBACKINIT = 7,
	MPTCP_MIB_RETRANSSEGS = 8,
	MPTCP_MIB_JOINNOTOKEN = 9,
	MPTCP_MIB_JOINSYNRX = 10,
	MPTCP_MIB_JOINSYNACKRX = 11,
	MPTCP_MIB_JOINSYNACKMAC = 12,
	MPTCP_MIB_JOINACKRX = 13,
	MPTCP_MIB_JOINACKMAC = 14,
	MPTCP_MIB_DSSNOMATCH = 15,
	MPTCP_MIB_INFINITEMAPTX = 16,
	MPTCP_MIB_INFINITEMAPRX = 17,
	MPTCP_MIB_DSSTCPMISMATCH = 18,
	MPTCP_MIB_DATACSUMERR = 19,
	MPTCP_MIB_OFOQUEUETAIL = 20,
	MPTCP_MIB_OFOQUEUE = 21,
	MPTCP_MIB_OFOMERGE = 22,
	MPTCP_MIB_NODSSWINDOW = 23,
	MPTCP_MIB_DUPDATA = 24,
	MPTCP_MIB_ADDADDR = 25,
	MPTCP_MIB_ADDADDRTX = 26,
	MPTCP_MIB_ADDADDRTXDROP = 27,
	MPTCP_MIB_ECHOADD = 28,
	MPTCP_MIB_ECHOADDTX = 29,
	MPTCP_MIB_ECHOADDTXDROP = 30,
	MPTCP_MIB_PORTADD = 31,
	MPTCP_MIB_ADDADDRDROP = 32,
	MPTCP_MIB_JOINPORTSYNRX = 33,
	MPTCP_MIB_JOINPORTSYNACKRX = 34,
	MPTCP_MIB_JOINPORTACKRX = 35,
	MPTCP_MIB_MISMATCHPORTSYNRX = 36,
	MPTCP_MIB_MISMATCHPORTACKRX = 37,
	MPTCP_MIB_RMADDR = 38,
	MPTCP_MIB_RMADDRDROP = 39,
	MPTCP_MIB_RMADDRTX = 40,
	MPTCP_MIB_RMADDRTXDROP = 41,
	MPTCP_MIB_RMSUBFLOW = 42,
	MPTCP_MIB_MPPRIOTX = 43,
	MPTCP_MIB_MPPRIORX = 44,
	MPTCP_MIB_MPFAILTX = 45,
	MPTCP_MIB_MPFAILRX = 46,
	MPTCP_MIB_MPFASTCLOSETX = 47,
	MPTCP_MIB_MPFASTCLOSERX = 48,
	MPTCP_MIB_MPRSTTX = 49,
	MPTCP_MIB_MPRSTRX = 50,
	MPTCP_MIB_RCVPRUNED = 51,
	MPTCP_MIB_SUBFLOWSTALE = 52,
	MPTCP_MIB_SUBFLOWRECOVER = 53,
	MPTCP_MIB_SNDWNDSHARED = 54,
	MPTCP_MIB_RCVWNDSHARED = 55,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 56,
	MPTCP_MIB_RCVWNDCONFLICT = 57,
	__MPTCP_MIB_MAX = 58,
};

struct mptcp_pm_add_entry {
	struct list_head list;
	struct mptcp_addr_info addr;
	u8 retrans_times;
	struct timer_list add_timer;
	struct mptcp_sock *sock;
};

struct pm_nl_pernet {
	spinlock_t lock;
	struct list_head local_addr_list;
	unsigned int addrs;
	unsigned int stale_loss_cnt;
	unsigned int add_addr_signal_max;
	unsigned int add_addr_accept_max;
	unsigned int local_addr_max;
	unsigned int subflows_max;
	unsigned int next_id;
	long unsigned int id_bitmap[4];
};

struct maple_metadata {
	unsigned char end;
	unsigned char gap;
};

struct maple_pnode;

struct maple_range_64 {
	struct maple_pnode *parent;
	long unsigned int pivot[15];
	union {
		void *slot[16];
		struct {
			void *pad[15];
			struct maple_metadata meta;
		};
	};
};

struct maple_arange_64 {
	struct maple_pnode *parent;
	long unsigned int pivot[9];
	void *slot[10];
	long unsigned int gap[10];
	struct maple_metadata meta;
};

struct maple_topiary {
	struct maple_pnode *parent;
	struct maple_enode *next;
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

struct maple_node {
	union {
		struct {
			struct maple_pnode *parent;
			void *slot[31];
		};
		struct {
			void *pad;
			struct callback_head rcu;
			struct maple_enode *piv_parent;
			unsigned char parent_slot;
			enum maple_type type;
			unsigned char slot_len;
			unsigned int ma_flags;
		};
		struct maple_range_64 mr64;
		struct maple_arange_64 ma64;
		struct maple_alloc alloc;
	};
};

struct ma_topiary {
	struct maple_enode *head;
	struct maple_enode *tail;
	struct maple_tree *mtree;
};

struct ma_wr_state {
	struct ma_state *mas;
	struct maple_node *node;
	long unsigned int r_min;
	long unsigned int r_max;
	enum maple_type type;
	unsigned char offset_end;
	unsigned char node_end;
	long unsigned int *pivots;
	long unsigned int end_piv;
	void **slots;
	void *entry;
	void *content;
};

struct trace_event_raw_ma_op {
	struct trace_entry ent;
	const char *fn;
	long unsigned int min;
	long unsigned int max;
	long unsigned int index;
	long unsigned int last;
	void *node;
	char __data[0];
};

struct trace_event_raw_ma_read {
	struct trace_entry ent;
	const char *fn;
	long unsigned int min;
	long unsigned int max;
	long unsigned int index;
	long unsigned int last;
	void *node;
	char __data[0];
};

struct trace_event_raw_ma_write {
	struct trace_entry ent;
	const char *fn;
	long unsigned int min;
	long unsigned int max;
	long unsigned int index;
	long unsigned int last;
	long unsigned int piv;
	void *val;
	void *node;
	char __data[0];
};

struct trace_event_data_offsets_ma_op {};

struct trace_event_data_offsets_ma_read {};

struct trace_event_data_offsets_ma_write {};

typedef void (*btf_trace_ma_op)(void *, const char *, struct ma_state *);

typedef void (*btf_trace_ma_read)(void *, const char *, struct ma_state *);

typedef void (*btf_trace_ma_write)(void *, const char *, struct ma_state *, long unsigned int, void *);

struct maple_big_node {
	struct maple_pnode *parent;
	long unsigned int pivot[33];
	union {
		struct maple_enode *slot[34];
		struct {
			long unsigned int padding[21];
			long unsigned int gap[21];
		};
	};
	unsigned char b_end;
	enum maple_type type;
};

struct maple_subtree_state {
	struct ma_state *orig_l;
	struct ma_state *orig_r;
	struct ma_state *l;
	struct ma_state *m;
	struct ma_state *r;
	struct ma_topiary *free;
	struct ma_topiary *destroy;
	struct maple_big_node *bn;
};

typedef int (*initcall_t)();

typedef int initcall_entry_t;

struct fixed_percpu_data {
	char gs_base[40];
	long unsigned int stack_canary;
};

struct xbc_node {
	uint16_t next;
	uint16_t child;
	uint16_t parent;
	uint16_t data;
};

struct trace_event_raw_initcall_level {
	struct trace_entry ent;
	u32 __data_loc_level;
	char __data[0];
};

struct trace_event_raw_initcall_start {
	struct trace_entry ent;
	initcall_t func;
	char __data[0];
};

struct trace_event_raw_initcall_finish {
	struct trace_entry ent;
	initcall_t func;
	int ret;
	char __data[0];
};

struct trace_event_data_offsets_initcall_level {
	u32 level;
};

struct trace_event_data_offsets_initcall_start {};

struct trace_event_data_offsets_initcall_finish {};

typedef void (*btf_trace_initcall_level)(void *, const char *);

typedef void (*btf_trace_initcall_start)(void *, initcall_t);

typedef void (*btf_trace_initcall_finish)(void *, initcall_t, int);

struct blacklist_entry {
	struct list_head next;
	char *buf;
};

struct property_entry;

struct platform_device_info {
	struct device *parent;
	struct fwnode_handle *fwnode;
	bool of_node_reused;
	const char *name;
	int id;
	const struct resource *res;
	unsigned int num_res;
	const void *data;
	size_t size_data;
	u64 dma_mask;
	const struct property_entry *properties;
};

struct property_entry {
	const char *name;
	size_t length;
	bool is_inline;
	enum dev_prop_type type;
	union {
		const void *pointer;
		union {
			u8 u8_data[8];
			u16 u16_data[4];
			u32 u32_data[2];
			u64 u64_data[1];
			const char *str[1];
		} value;
	};
};

struct cpio_data {
	void *data;
	size_t size;
	char name[18];
};

struct cpu_signature {
	unsigned int sig;
	unsigned int pf;
	unsigned int rev;
};

struct ucode_cpu_info {
	struct cpu_signature cpu_sig;
	void *mc;
};

enum ucode_state {
	UCODE_OK = 0,
	UCODE_NEW = 1,
	UCODE_UPDATED = 2,
	UCODE_NFOUND = 3,
	UCODE_ERROR = 4,
};

struct microcode_ops {
	enum ucode_state (*request_microcode_fw)(int, struct device *);
	void (*microcode_fini_cpu)(int);
	enum ucode_state (*apply_microcode)(int);
	int (*collect_cpu_info)(int, struct cpu_signature *);
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

struct x86_guest {
	bool (*enc_status_change_prepare)(long unsigned int, int, bool);
	bool (*enc_status_change_finish)(long unsigned int, int, bool);
	bool (*enc_tlb_flush_required)(bool);
	bool (*enc_cache_flush_required)();
};

struct x86_legacy_devices {
	int pnpbios;
};

enum x86_legacy_i8042_state {
	X86_LEGACY_I8042_PLATFORM_ABSENT = 0,
	X86_LEGACY_I8042_FIRMWARE_ABSENT = 1,
	X86_LEGACY_I8042_EXPECTED_PRESENT = 2,
};

struct x86_legacy_features {
	enum x86_legacy_i8042_state i8042;
	int rtc;
	int warm_reset;
	int no_vga;
	int reserve_bios_regions;
	struct x86_legacy_devices devices;
};

struct ghcb;

struct x86_hyper_runtime {
	void (*pin_vcpu)(int);
	void (*sev_es_hcall_prepare)(struct ghcb *, struct pt_regs *);
	bool (*sev_es_hcall_finish)(struct ghcb *, struct pt_regs *);
	bool (*is_private_mmio)(u64);
};

struct x86_platform_ops {
	long unsigned int (*calibrate_cpu)();
	long unsigned int (*calibrate_tsc)();
	void (*get_wallclock)(struct timespec64 *);
	int (*set_wallclock)(const struct timespec64 *);
	void (*iommu_shutdown)();
	bool (*is_untracked_pat_range)(u64, u64);
	void (*nmi_init)();
	unsigned char (*get_nmi_reason)();
	void (*save_sched_clock_state)();
	void (*restore_sched_clock_state)();
	void (*apic_post_init)();
	struct x86_legacy_features legacy;
	void (*set_legacy_features)();
	void (*realmode_reserve)();
	void (*realmode_init)();
	struct x86_hyper_runtime hyper;
	struct x86_guest guest;
};

struct dmi_strmatch {
	unsigned char slot: 7;
	unsigned char exact_match: 1;
	char substr[79];
};

struct dmi_system_id {
	int (*callback)(const struct dmi_system_id *);
	const char *ident;
	struct dmi_strmatch matches[4];
	void *driver_data;
};

struct machine_ops {
	void (*restart)(char *);
	void (*halt)();
	void (*power_off)();
	void (*shutdown)();
	void (*crash_shutdown)(struct pt_regs *);
	void (*emergency_restart)();
};

typedef void (*nmi_shootdown_cb)(int, struct pt_regs *);

struct real_mode_header {
	u32 text_start;
	u32 ro_end;
	u32 trampoline_start;
	u32 trampoline_header;
	u32 trampoline_start64;
	u32 trampoline_pgd;
	u32 wakeup_start;
	u32 wakeup_header;
	u32 machine_real_restart_asm;
	u32 machine_real_restart_seg;
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_MAX = 2,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_TSC = 1,
	VDSO_CLOCKMODE_PVCLOCK = 2,
	VDSO_CLOCKMODE_HVCLOCK = 3,
	VDSO_CLOCKMODE_MAX = 4,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

struct clocksource {
	u64 (*read)(struct clocksource *);
	u64 mask;
	u32 mult;
	u32 shift;
	u64 max_idle_ns;
	u32 maxadj;
	u32 uncertainty_margin;
	u64 max_cycles;
	const char *name;
	struct list_head list;
	int rating;
	enum clocksource_ids id;
	enum vdso_clock_mode vdso_clock_mode;
	long unsigned int flags;
	int (*enable)(struct clocksource *);
	void (*disable)(struct clocksource *);
	void (*suspend)(struct clocksource *);
	void (*resume)(struct clocksource *);
	void (*mark_unstable)(struct clocksource *);
	void (*tick_stable)(struct clocksource *);
	struct list_head wd_list;
	u64 cs_last;
	u64 wd_last;
	struct module *owner;
};

struct hpet_data {
	long unsigned int hd_phys_address;
	void *hd_address;
	short unsigned int hd_nirqs;
	unsigned int hd_state;
	unsigned int hd_irq[32];
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_MOVE_PCNTXT = 16384,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_PCI_IMS = 2097152,
};

enum hpet_mode {
	HPET_MODE_UNUSED = 0,
	HPET_MODE_LEGACY = 1,
	HPET_MODE_CLOCKEVT = 2,
	HPET_MODE_DEVICE = 3,
};

struct hpet_channel {
	struct clock_event_device evt;
	unsigned int num;
	unsigned int cpu;
	unsigned int irq;
	unsigned int in_use;
	enum hpet_mode mode;
	unsigned int boot_cfg;
	char name[10];
	long: 64;
	long: 64;
	long: 64;
};

struct hpet_base {
	unsigned int nr_channels;
	unsigned int nr_clockevents;
	unsigned int boot_cfg;
	struct hpet_channel *channels;
};

union hpet_lock {
	struct {
		arch_spinlock_t lock;
		u32 value;
	};
	u64 lockval;
};

struct x86_init_mpparse {
	void (*setup_ioapic_ids)();
	void (*find_smp_config)();
	void (*get_smp_config)(unsigned int);
};

struct x86_init_resources {
	void (*probe_roms)();
	void (*reserve_resources)();
	char * (*memory_setup)();
};

struct x86_init_irqs {
	void (*pre_vector_init)();
	void (*intr_init)();
	void (*intr_mode_select)();
	void (*intr_mode_init)();
	struct irq_domain * (*create_pci_msi_domain)();
};

struct x86_init_oem {
	void (*arch_setup)();
	void (*banner)();
};

struct x86_init_paging {
	void (*pagetable_init)();
};

struct x86_init_timers {
	void (*setup_percpu_clockev)();
	void (*timer_init)();
	void (*wallclock_init)();
};

struct x86_init_iommu {
	int (*iommu_init)();
};

struct x86_init_pci {
	int (*arch_init)();
	int (*init)();
	void (*init_irq)();
	void (*fixup_irqs)();
};

struct x86_hyper_init {
	void (*init_platform)();
	void (*guest_late_init)();
	bool (*x2apic_available)();
	bool (*msi_ext_dest_id)();
	void (*init_mem_mapping)();
	void (*init_after_bootmem)();
};

struct x86_init_acpi {
	void (*set_root_pointer)(u64);
	u64 (*get_root_pointer)();
	void (*reduced_hw_early_init)();
};

struct x86_init_ops {
	struct x86_init_resources resources;
	struct x86_init_mpparse mpparse;
	struct x86_init_irqs irqs;
	struct x86_init_oem oem;
	struct x86_init_paging paging;
	struct x86_init_timers timers;
	struct x86_init_iommu iommu;
	struct x86_init_pci pci;
	struct x86_hyper_init hyper;
	struct x86_init_acpi acpi;
};

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct *cap_user_data_t;

struct srcu_notifier_head {
	struct mutex mutex;
	struct srcu_usage srcuu;
	struct srcu_struct srcu;
	struct notifier_block *head;
};

enum die_val {
	DIE_OOPS = 1,
	DIE_INT3 = 2,
	DIE_DEBUG = 3,
	DIE_PANIC = 4,
	DIE_NMI = 5,
	DIE_DIE = 6,
	DIE_KERNELDEBUG = 7,
	DIE_TRAP = 8,
	DIE_GPF = 9,
	DIE_CALL = 10,
	DIE_PAGE_FAULT = 11,
	DIE_NMIUNKNOWN = 12,
};

struct die_args {
	struct pt_regs *regs;
	const char *str;
	long int err;
	int trapnr;
	int signr;
};

struct trace_event_raw_notifier_info {
	struct trace_entry ent;
	void *cb;
	char __data[0];
};

struct trace_event_data_offsets_notifier_info {};

typedef void (*btf_trace_notifier_register)(void *, void *);

typedef void (*btf_trace_notifier_unregister)(void *, void *);

typedef void (*btf_trace_notifier_run)(void *, void *);

struct lock_list {
	struct list_head entry;
	struct lock_class *class;
	struct lock_class *links_to;
	const struct lock_trace *trace;
	u16 distance;
	u8 dep;
	u8 only_xr;
	struct lock_list *parent;
};

struct lock_chain {
	unsigned int irq_context: 2;
	unsigned int depth: 6;
	unsigned int base: 24;
	struct hlist_node entry;
	u64 chain_key;
};

enum {
	LOCKF_USED_IN_HARDIRQ = 1,
	LOCKF_USED_IN_HARDIRQ_READ = 2,
	LOCKF_ENABLED_HARDIRQ = 4,
	LOCKF_ENABLED_HARDIRQ_READ = 8,
	LOCKF_USED_IN_SOFTIRQ = 16,
	LOCKF_USED_IN_SOFTIRQ_READ = 32,
	LOCKF_ENABLED_SOFTIRQ = 64,
	LOCKF_ENABLED_SOFTIRQ_READ = 128,
	LOCKF_USED = 256,
	LOCKF_USED_READ = 512,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_MOVE_PCNTXT = 32768,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

struct kobj_attribute {
	struct attribute attr;
	ssize_t (*show)(struct kobject *, struct kobj_attribute *, char *);
	ssize_t (*store)(struct kobject *, struct kobj_attribute *, const char *, size_t);
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_MOVE_PCNTXT = 16384,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2096911,
};

typedef struct elf64_hdr Elf64_Ehdr;

struct elf64_shdr {
	Elf64_Word sh_name;
	Elf64_Word sh_type;
	Elf64_Xword sh_flags;
	Elf64_Addr sh_addr;
	Elf64_Off sh_offset;
	Elf64_Xword sh_size;
	Elf64_Word sh_link;
	Elf64_Word sh_info;
	Elf64_Xword sh_addralign;
	Elf64_Xword sh_entsize;
};

typedef struct elf64_shdr Elf64_Shdr;

struct profile_hit {
	u32 pc;
	u32 hits;
};

typedef struct {
	struct lockdep_map dep_map;
	struct task_struct *owner;
} local_lock_t;

struct radix_tree_preload {
	local_lock_t lock;
	unsigned int nr;
	struct xa_node *nodes;
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

struct kernfs_syscall_ops {
	int (*show_options)(struct seq_file *, struct kernfs_root *);
	int (*mkdir)(struct kernfs_node *, const char *, umode_t);
	int (*rmdir)(struct kernfs_node *);
	int (*rename)(struct kernfs_node *, struct kernfs_node *, const char *);
	int (*show_path)(struct seq_file *, struct kernfs_node *, struct kernfs_root *);
};

struct kernfs_fs_context {
	struct kernfs_root *root;
	void *ns_tag;
	long unsigned int magic;
	bool new_sb_created;
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
	CGRP_KILL = 4,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
};

struct cgroup_taskset {
	struct list_head src_csets;
	struct list_head dst_csets;
	int nr_tasks;
	int ssid;
	struct list_head *csets;
	struct css_set *cur_cset;
	struct task_struct *cur_task;
};

enum {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

struct css_task_iter {
	struct cgroup_subsys *ss;
	unsigned int flags;
	struct list_head *cset_pos;
	struct list_head *cset_head;
	struct list_head *tcset_pos;
	struct list_head *tcset_head;
	struct list_head *task_pos;
	struct list_head *cur_tasks_head;
	struct css_set *cur_cset;
	struct css_set *cur_dcset;
	struct task_struct *cur_task;
	struct list_head iters_node;
};

struct cgroup_fs_context {
	struct kernfs_fs_context kfc;
	struct cgroup_root *root;
	struct cgroup_namespace *ns;
	unsigned int flags;
	bool cpuset_clone_children;
	bool none;
	bool all_ss;
	u16 subsys_mask;
	char *name;
	char *release_agent;
};

struct cgroup_pidlist;

struct cgroup_file_ctx {
	struct cgroup_namespace *ns;
	struct {
		void *trigger;
	} psi;
	struct {
		bool started;
		struct css_task_iter iter;
	} procs;
	struct {
		struct cgroup_pidlist *pidlist;
	} procs1;
};

struct cgrp_cset_link {
	struct cgroup *cgrp;
	struct css_set *cset;
	struct list_head cset_link;
	struct list_head cgrp_link;
};

struct cgroup_mgctx {
	struct list_head preloaded_src_csets;
	struct list_head preloaded_dst_csets;
	struct cgroup_taskset tset;
	u16 ss_mask;
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

struct trace_event_raw_cgroup_root {
	struct trace_entry ent;
	int root;
	u16 ss_mask;
	u32 __data_loc_name;
	char __data[0];
};

struct trace_event_raw_cgroup {
	struct trace_entry ent;
	int root;
	int level;
	u64 id;
	u32 __data_loc_path;
	char __data[0];
};

struct trace_event_raw_cgroup_migrate {
	struct trace_entry ent;
	int dst_root;
	int dst_level;
	u64 dst_id;
	int pid;
	u32 __data_loc_dst_path;
	u32 __data_loc_comm;
	char __data[0];
};

struct trace_event_raw_cgroup_event {
	struct trace_entry ent;
	int root;
	int level;
	u64 id;
	u32 __data_loc_path;
	int val;
	char __data[0];
};

struct trace_event_data_offsets_cgroup_root {
	u32 name;
};

struct trace_event_data_offsets_cgroup {
	u32 path;
};

struct trace_event_data_offsets_cgroup_migrate {
	u32 dst_path;
	u32 comm;
};

struct trace_event_data_offsets_cgroup_event {
	u32 path;
};

typedef void (*btf_trace_cgroup_setup_root)(void *, struct cgroup_root *);

typedef void (*btf_trace_cgroup_destroy_root)(void *, struct cgroup_root *);

typedef void (*btf_trace_cgroup_remount)(void *, struct cgroup_root *);

typedef void (*btf_trace_cgroup_mkdir)(void *, struct cgroup *, const char *);

typedef void (*btf_trace_cgroup_rmdir)(void *, struct cgroup *, const char *);

typedef void (*btf_trace_cgroup_release)(void *, struct cgroup *, const char *);

typedef void (*btf_trace_cgroup_rename)(void *, struct cgroup *, const char *);

typedef void (*btf_trace_cgroup_freeze)(void *, struct cgroup *, const char *);

typedef void (*btf_trace_cgroup_unfreeze)(void *, struct cgroup *, const char *);

typedef void (*btf_trace_cgroup_attach_task)(void *, struct cgroup *, const char *, struct task_struct *, bool);

typedef void (*btf_trace_cgroup_transfer_tasks)(void *, struct cgroup *, const char *, struct task_struct *, bool);

typedef void (*btf_trace_cgroup_notify_populated)(void *, struct cgroup *, const char *, int);

typedef void (*btf_trace_cgroup_notify_frozen)(void *, struct cgroup *, const char *, int);

enum cgroup_opt_features {
	OPT_FEATURE_COUNT = 0,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	nr__cgroup2_params = 4,
};

struct filter_pred;

struct prog_entry {
	int target;
	int when_to_branch;
	struct filter_pred *pred;
};

struct regex;

typedef int (*regex_match_func)(char *, struct regex *, int);

struct regex {
	char pattern[256];
	int len;
	int field_len;
	regex_match_func match;
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

struct filter_pred {
	struct regex *regex;
	struct cpumask *mask;
	short unsigned int *ops;
	struct ftrace_event_field *field;
	u64 val;
	u64 val2;
	enum filter_pred_fn fn_num;
	int offset;
	int not;
	int op;
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

struct filter_parse_error {
	int lasterr;
	int lasterr_pos;
};

typedef int (*parse_pred_fn)(const char *, void *, int, struct filter_parse_error *, struct filter_pred **);

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

struct ustring_buffer {
	char buffer[1024];
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

struct filter_list {
	struct list_head list;
	struct event_filter *filter;
};

struct function_filter_data {
	struct ftrace_ops *ops;
	int first_filter;
	int first_notrace;
};

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct latch_tree_root {
	seqcount_latch_t seq;
	struct rb_root tree[2];
};

struct latch_tree_ops {
	bool (*less)(struct latch_tree_node *, struct latch_tree_node *);
	int (*comp)(void *, struct latch_tree_node *);
};

struct rnd_state {
	__u32 s1;
	__u32 s2;
	__u32 s3;
	__u32 s4;
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

typedef long unsigned int (*bpf_ctx_copy_t)(void *, const void *, long unsigned int, long unsigned int);

struct bpf_empty_prog_array {
	struct bpf_prog_array hdr;
	struct bpf_prog *null_prog;
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

struct bpf_binary_header {
	u32 size;
	long: 0;
	u8 image[0];
};

typedef void (*bpf_jit_fill_hole_t)(void *, unsigned int);

struct bpf_prog_pack {
	struct list_head list;
	void *ptr;
	long unsigned int bitmap[0];
};

struct bpf_prog_dummy {
	struct bpf_prog prog;
};

typedef u64 (*btf_bpf_user_rnd_u32)();

typedef u64 (*btf_bpf_get_raw_cpu_id)();

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

struct _bpf_dtab_netdev {
	struct net_device *dev;
};

struct xdp_mem_allocator {
	struct xdp_mem_info mem;
	union {
		void *allocator;
		struct page_pool *page_pool;
	};
	struct rhash_head node;
	struct callback_head rcu;
};

struct trace_event_raw_xdp_exception {
	struct trace_entry ent;
	int prog_id;
	u32 act;
	int ifindex;
	char __data[0];
};

struct trace_event_raw_xdp_bulk_tx {
	struct trace_entry ent;
	int ifindex;
	u32 act;
	int drops;
	int sent;
	int err;
	char __data[0];
};

struct trace_event_raw_xdp_redirect_template {
	struct trace_entry ent;
	int prog_id;
	u32 act;
	int ifindex;
	int err;
	int to_ifindex;
	u32 map_id;
	int map_index;
	char __data[0];
};

struct trace_event_raw_xdp_cpumap_kthread {
	struct trace_entry ent;
	int map_id;
	u32 act;
	int cpu;
	unsigned int drops;
	unsigned int processed;
	int sched;
	unsigned int xdp_pass;
	unsigned int xdp_drop;
	unsigned int xdp_redirect;
	char __data[0];
};

struct trace_event_raw_xdp_cpumap_enqueue {
	struct trace_entry ent;
	int map_id;
	u32 act;
	int cpu;
	unsigned int drops;
	unsigned int processed;
	int to_cpu;
	char __data[0];
};

struct trace_event_raw_xdp_devmap_xmit {
	struct trace_entry ent;
	int from_ifindex;
	u32 act;
	int to_ifindex;
	int drops;
	int sent;
	int err;
	char __data[0];
};

struct trace_event_raw_mem_disconnect {
	struct trace_entry ent;
	const struct xdp_mem_allocator *xa;
	u32 mem_id;
	u32 mem_type;
	const void *allocator;
	char __data[0];
};

struct trace_event_raw_mem_connect {
	struct trace_entry ent;
	const struct xdp_mem_allocator *xa;
	u32 mem_id;
	u32 mem_type;
	const void *allocator;
	const struct xdp_rxq_info *rxq;
	int ifindex;
	char __data[0];
};

struct trace_event_raw_mem_return_failed {
	struct trace_entry ent;
	const struct page *page;
	u32 mem_id;
	u32 mem_type;
	char __data[0];
};

struct trace_event_raw_bpf_xdp_link_attach_failed {
	struct trace_entry ent;
	u32 __data_loc_msg;
	char __data[0];
};

struct trace_event_data_offsets_xdp_exception {};

struct trace_event_data_offsets_xdp_bulk_tx {};

struct trace_event_data_offsets_xdp_redirect_template {};

struct trace_event_data_offsets_xdp_cpumap_kthread {};

struct trace_event_data_offsets_xdp_cpumap_enqueue {};

struct trace_event_data_offsets_xdp_devmap_xmit {};

struct trace_event_data_offsets_mem_disconnect {};

struct trace_event_data_offsets_mem_connect {};

struct trace_event_data_offsets_mem_return_failed {};

struct trace_event_data_offsets_bpf_xdp_link_attach_failed {
	u32 msg;
};

typedef void (*btf_trace_xdp_exception)(void *, const struct net_device *, const struct bpf_prog *, u32);

typedef void (*btf_trace_xdp_bulk_tx)(void *, const struct net_device *, int, int, int);

typedef void (*btf_trace_xdp_redirect)(void *, const struct net_device *, const struct bpf_prog *, const void *, int, enum bpf_map_type, u32, u32);

typedef void (*btf_trace_xdp_redirect_err)(void *, const struct net_device *, const struct bpf_prog *, const void *, int, enum bpf_map_type, u32, u32);

typedef void (*btf_trace_xdp_redirect_map)(void *, const struct net_device *, const struct bpf_prog *, const void *, int, enum bpf_map_type, u32, u32);

typedef void (*btf_trace_xdp_redirect_map_err)(void *, const struct net_device *, const struct bpf_prog *, const void *, int, enum bpf_map_type, u32, u32);

typedef void (*btf_trace_xdp_cpumap_kthread)(void *, int, unsigned int, unsigned int, int, struct xdp_cpumap_stats *);

typedef void (*btf_trace_xdp_cpumap_enqueue)(void *, int, unsigned int, unsigned int, int);

typedef void (*btf_trace_xdp_devmap_xmit)(void *, const struct net_device *, const struct net_device *, int, int, int);

typedef void (*btf_trace_mem_disconnect)(void *, const struct xdp_mem_allocator *);

typedef void (*btf_trace_mem_connect)(void *, const struct xdp_mem_allocator *, const struct xdp_rxq_info *);

typedef void (*btf_trace_mem_return_failed)(void *, const struct xdp_mem_info *, const struct page *);

typedef void (*btf_trace_bpf_xdp_link_attach_failed)(void *, const char *);

struct bpf_mem_cache {
	struct llist_head free_llist;
	local_t active;
	struct llist_head free_llist_extra;
	struct irq_work refill_work;
	struct obj_cgroup *objcg;
	int unit_size;
	int free_cnt;
	int low_watermark;
	int high_watermark;
	int batch;
	int percpu_size;
	bool draining;
	struct bpf_mem_cache *tgt;
	struct llist_head free_by_rcu;
	struct llist_node *free_by_rcu_tail;
	struct llist_head waiting_for_gp;
	struct llist_node *waiting_for_gp_tail;
	struct callback_head rcu;
	atomic_t call_rcu_in_progress;
	struct llist_head free_llist_extra_rcu;
	struct llist_head free_by_rcu_ttrace;
	struct llist_head waiting_for_gp_ttrace;
	struct callback_head rcu_ttrace;
	atomic_t call_rcu_ttrace_in_progress;
};

struct bpf_mem_caches {
	struct bpf_mem_cache cache[11];
};

struct reuseport_array {
	struct bpf_map map;
	struct sock *ptrs[0];
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

struct pipe_buffer;

struct pipe_inode_info {
	struct mutex mutex;
	wait_queue_head_t rd_wait;
	wait_queue_head_t wr_wait;
	unsigned int head;
	unsigned int tail;
	unsigned int max_usage;
	unsigned int ring_size;
	unsigned int nr_accounted;
	unsigned int readers;
	unsigned int writers;
	unsigned int files;
	unsigned int r_counter;
	unsigned int w_counter;
	bool poll_usage;
	struct page *tmp_page;
	struct fasync_struct *fasync_readers;
	struct fasync_struct *fasync_writers;
	struct pipe_buffer *bufs;
	struct user_struct *user;
};

typedef void (*xa_update_node_t)(struct xa_node *);

struct xa_state {
	struct xarray *xa;
	long unsigned int xa_index;
	unsigned char xa_shift;
	unsigned char xa_sibs;
	unsigned char xa_offset;
	unsigned char xa_pad;
	struct xa_node *xa_node;
	struct xa_node *xa_alloc;
	xa_update_node_t xa_update;
	struct list_lru *xa_lru;
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

struct posix_acl_entry {
	short int e_tag;
	short unsigned int e_perm;
	union {
		kuid_t e_uid;
		kgid_t e_gid;
	};
};

struct posix_acl {
	refcount_t a_refcount;
	struct callback_head a_rcu;
	unsigned int a_count;
	struct posix_acl_entry a_entries[0];
};

struct fileattr {
	u32 flags;
	u32 fsx_xflags;
	u32 fsx_extsize;
	u32 fsx_nextents;
	u32 fsx_projid;
	u32 fsx_cowextsize;
	bool flags_valid: 1;
	bool fsx_valid: 1;
};

struct vm_event_state {
	long unsigned int event[107];
};

struct constant_table {
	const char *name;
	int value;
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_MAX = 6,
};

struct shared_policy {
	struct rb_root root;
	rwlock_t lock;
};

struct simple_xattrs {
	struct rb_root rb_root;
	rwlock_t lock;
};

struct simple_xattr {
	struct rb_node rb_node;
	char *name;
	size_t size;
	char value[0];
};

typedef long unsigned int pte_marker;

typedef unsigned int uffd_flags_t;

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

struct shmem_inode_info {
	spinlock_t lock;
	unsigned int seals;
	long unsigned int flags;
	long unsigned int alloced;
	long unsigned int swapped;
	long unsigned int fallocend;
	struct list_head shrinklist;
	struct list_head swaplist;
	struct shared_policy policy;
	struct simple_xattrs xattrs;
	atomic_t stop_eviction;
	struct timespec64 i_crtime;
	unsigned int fsflags;
	struct offset_ctx dir_offsets;
	struct inode vfs_inode;
};

struct shmem_quota_limits {
	qsize_t usrquota_bhardlimit;
	qsize_t usrquota_ihardlimit;
	qsize_t grpquota_bhardlimit;
	qsize_t grpquota_ihardlimit;
};

struct shmem_sb_info {
	long unsigned int max_blocks;
	struct percpu_counter used_blocks;
	long unsigned int max_inodes;
	long unsigned int free_ispace;
	raw_spinlock_t stat_lock;
	umode_t mode;
	unsigned char huge;
	kuid_t uid;
	kgid_t gid;
	bool full_inums;
	bool noswap;
	ino_t next_ino;
	ino_t *ino_batch;
	struct mempolicy *mpol;
	spinlock_t shrinklist_lock;
	struct list_head shrinklist;
	long unsigned int shrinklist_len;
	struct shmem_quota_limits qlimits;
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

struct fid {
	union {
		struct {
			u32 ino;
			u32 gen;
			u32 parent_ino;
			u32 parent_gen;
		} i32;
		struct {
			u32 block;
			u16 partref;
			u16 parent_partref;
			u32 generation;
			u32 parent_block;
			u32 parent_generation;
		} udf;
		struct {
			struct {} __empty_raw;
			__u32 raw[0];
		};
	};
};

struct folio_batch {
	unsigned char nr;
	bool percpu_pvec_drained;
	struct folio *folios[15];
};

struct pipe_buf_operations;

struct pipe_buffer {
	struct page *page;
	unsigned int offset;
	unsigned int len;
	const struct pipe_buf_operations *ops;
	unsigned int flags;
	long unsigned int private;
};

struct pipe_buf_operations {
	int (*confirm)(struct pipe_inode_info *, struct pipe_buffer *);
	void (*release)(struct pipe_inode_info *, struct pipe_buffer *);
	bool (*try_steal)(struct pipe_inode_info *, struct pipe_buffer *);
	bool (*get)(struct pipe_inode_info *, struct pipe_buffer *);
};

struct shmem_falloc {
	wait_queue_head_t *waitq;
	long unsigned int start;
	long unsigned int next;
	long unsigned int nr_falloced;
	long unsigned int nr_unswapped;
};

struct shmem_options {
	long long unsigned int blocks;
	long long unsigned int inodes;
	struct mempolicy *mpol;
	kuid_t uid;
	kgid_t gid;
	umode_t mode;
	bool full_inums;
	int huge;
	int seen;
	bool noswap;
	short unsigned int quota_types;
	struct shmem_quota_limits qlimits;
};

enum shmem_param {
	Opt_gid = 0,
	Opt_huge = 1,
	Opt_mode = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes = 5,
	Opt_size = 6,
	Opt_uid = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota = 11,
	Opt_usrquota = 12,
	Opt_grpquota = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
};

struct ptdesc {
	long unsigned int __page_flags;
	union {
		struct callback_head pt_rcu_head;
		struct list_head pt_list;
		struct {
			long unsigned int _pt_pad_1;
			pgtable_t pmd_huge_pte;
		};
	};
	long unsigned int __page_mapping;
	union {
		struct mm_struct *pt_mm;
		atomic_t pt_frag_refcount;
	};
	union {
		long unsigned int _pt_pad_2;
		spinlock_t *ptl;
	};
	unsigned int __page_type;
	atomic_t _refcount;
	long unsigned int pt_memcg_data;
};

struct swap_slots_cache {
	bool lock_initialized;
	struct mutex alloc_lock;
	swp_entry_t *slots;
	int nr;
	int cur;
	spinlock_t free_lock;
	swp_entry_t *slots_ret;
	int n_ret;
};

struct swap_cgroup_ctrl {
	struct page **map;
	long unsigned int length;
	spinlock_t lock;
};

struct swap_cgroup {
	short unsigned int id;
};

typedef short unsigned int ushort;

enum syscall_work_bit {
	SYSCALL_WORK_BIT_SECCOMP = 0,
	SYSCALL_WORK_BIT_SYSCALL_TRACEPOINT = 1,
	SYSCALL_WORK_BIT_SYSCALL_TRACE = 2,
	SYSCALL_WORK_BIT_SYSCALL_EMU = 3,
	SYSCALL_WORK_BIT_SYSCALL_AUDIT = 4,
	SYSCALL_WORK_BIT_SYSCALL_USER_DISPATCH = 5,
	SYSCALL_WORK_BIT_SYSCALL_EXIT_TRAP = 6,
};

struct fs_struct {
	int users;
	spinlock_t lock;
	seqcount_spinlock_t seq;
	int umask;
	int in_exec;
	struct path root;
	struct path pwd;
};

struct fdtable {
	unsigned int max_fds;
	struct file **fd;
	long unsigned int *close_on_exec;
	long unsigned int *open_fds;
	long unsigned int *full_fds_bits;
	struct callback_head rcu;
};

struct files_struct {
	atomic_t count;
	bool resize_in_progress;
	wait_queue_head_t resize_wait;
	struct fdtable *fdt;
	struct fdtable fdtab;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t file_lock;
	unsigned int next_fd;
	long unsigned int close_on_exec_init[1];
	long unsigned int open_fds_init[1];
	long unsigned int full_fds_bits_init[1];
	struct file *fd_array[64];
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct encoded_page;

struct core_vma_metadata;

struct coredump_params {
	const kernel_siginfo_t *siginfo;
	struct file *file;
	long unsigned int limit;
	long unsigned int mm_flags;
	int cpu;
	loff_t written;
	loff_t pos;
	loff_t to_skip;
	int vma_count;
	size_t vma_data_size;
	struct core_vma_metadata *vma_meta;
};

struct core_vma_metadata {
	long unsigned int start;
	long unsigned int end;
	long unsigned int flags;
	long unsigned int dump_size;
	long unsigned int pgoff;
	struct file *file;
};

struct mmu_gather_batch {
	struct mmu_gather_batch *next;
	unsigned int nr;
	unsigned int max;
	struct encoded_page *encoded_pages[0];
};

struct mmu_gather {
	struct mm_struct *mm;
	long unsigned int start;
	long unsigned int end;
	unsigned int fullmm: 1;
	unsigned int need_flush_all: 1;
	unsigned int freed_tables: 1;
	unsigned int delayed_rmap: 1;
	unsigned int cleared_ptes: 1;
	unsigned int cleared_pmds: 1;
	unsigned int cleared_puds: 1;
	unsigned int cleared_p4ds: 1;
	unsigned int vma_exec: 1;
	unsigned int vma_huge: 1;
	unsigned int vma_pfn: 1;
	unsigned int batch_count;
	struct mmu_gather_batch *active;
	struct mmu_gather_batch local;
	struct page *__pages[8];
};

struct open_flags {
	int open_flag;
	umode_t mode;
	int acc_mode;
	int intent;
	int lookup_flags;
};

struct user_arg_ptr {
	union {
		const char * const *native;
	} ptr;
};

struct file_lock_context {
	spinlock_t flc_lock;
	struct list_head flc_flock;
	struct list_head flc_posix;
	struct list_head flc_lease;
};

struct nlm_lockowner;

struct nfs_lock_info {
	u32 state;
	struct nlm_lockowner *owner;
	struct list_head list;
};

struct nfs4_lock_state;

struct nfs4_lock_info {
	struct nfs4_lock_state *owner;
};

struct file_lock_operations;

struct lock_manager_operations;

struct file_lock {
	struct file_lock *fl_blocker;
	struct list_head fl_list;
	struct hlist_node fl_link;
	struct list_head fl_blocked_requests;
	struct list_head fl_blocked_member;
	fl_owner_t fl_owner;
	unsigned int fl_flags;
	unsigned char fl_type;
	unsigned int fl_pid;
	int fl_link_cpu;
	wait_queue_head_t fl_wait;
	struct file *fl_file;
	loff_t fl_start;
	loff_t fl_end;
	struct fasync_struct *fl_fasync;
	long unsigned int fl_break_time;
	long unsigned int fl_downgrade_time;
	const struct file_lock_operations *fl_ops;
	const struct lock_manager_operations *fl_lmops;
	union {
		struct nfs_lock_info nfs_fl;
		struct nfs4_lock_info nfs4_fl;
		struct {
			struct list_head link;
			int state;
			unsigned int debug_id;
		} afs;
		struct {
			struct inode *inode;
		} ceph;
	} fl_u;
};

struct file_lock_operations {
	void (*fl_copy_lock)(struct file_lock *, struct file_lock *);
	void (*fl_release_private)(struct file_lock *);
};

struct lock_manager_operations {
	void *lm_mod_owner;
	fl_owner_t (*lm_get_owner)(fl_owner_t);
	void (*lm_put_owner)(fl_owner_t);
	void (*lm_notify)(struct file_lock *);
	int (*lm_grant)(struct file_lock *, int);
	bool (*lm_break)(struct file_lock *);
	int (*lm_change)(struct file_lock *, int, struct list_head *);
	void (*lm_setup)(struct file_lock *, void **);
	bool (*lm_breaker_owns_lease)(struct file_lock *);
	bool (*lm_lock_expirable)(struct file_lock *);
	void (*lm_expire_lock)();
};

struct xattr_name {
	char name[256];
};

struct xattr_ctx {
	union {
		const void *cvalue;
		void *value;
	};
	void *kvalue;
	size_t size;
	struct xattr_name *kname;
	unsigned int flags;
};

struct file_handle {
	__u32 handle_bytes;
	int handle_type;
	unsigned char f_handle[0];
};

struct fsnotify_group;

struct fsnotify_iter_info;

struct fsnotify_mark;

struct fsnotify_event;

struct fsnotify_ops {
	int (*handle_event)(struct fsnotify_group *, u32, const void *, int, struct inode *, const struct qstr *, u32, struct fsnotify_iter_info *);
	int (*handle_inode_event)(struct fsnotify_mark *, u32, struct inode *, struct inode *, const struct qstr *, u32);
	void (*free_group_priv)(struct fsnotify_group *);
	void (*freeing_mark)(struct fsnotify_mark *, struct fsnotify_group *);
	void (*free_event)(struct fsnotify_group *, struct fsnotify_event *);
	void (*free_mark)(struct fsnotify_mark *);
};

struct inotify_group_private_data {
	spinlock_t idr_lock;
	struct idr idr;
	struct ucounts *ucounts;
};

struct fsnotify_group {
	const struct fsnotify_ops *ops;
	refcount_t refcnt;
	spinlock_t notification_lock;
	struct list_head notification_list;
	wait_queue_head_t notification_waitq;
	unsigned int q_len;
	unsigned int max_events;
	unsigned int priority;
	bool shutdown;
	int flags;
	unsigned int owner_flags;
	struct mutex mark_mutex;
	atomic_t user_waits;
	struct list_head marks_list;
	struct fasync_struct *fsn_fa;
	struct fsnotify_event *overflow_event;
	struct mem_cgroup *memcg;
	union {
		void *private;
		struct inotify_group_private_data inotify_data;
	};
};

struct fsnotify_iter_info {
	struct fsnotify_mark *marks[5];
	struct fsnotify_group *current_group;
	unsigned int report_mask;
	int srcu_idx;
};

struct fsnotify_mark {
	__u32 mask;
	refcount_t refcnt;
	struct fsnotify_group *group;
	struct list_head g_list;
	spinlock_t lock;
	struct hlist_node obj_list;
	struct fsnotify_mark_connector *connector;
	__u32 ignore_mask;
	unsigned int flags;
};

struct fsnotify_event {
	struct list_head list;
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

struct inotify_inode_mark {
	struct fsnotify_mark fsn_mark;
	int wd;
};

struct kioctx;

struct kioctx_table {
	struct callback_head rcu;
	unsigned int nr;
	struct kioctx *table[0];
};

struct hrtimer_sleeper {
	struct hrtimer timer;
	struct task_struct *task;
};

typedef __kernel_rwf_t rwf_t;

typedef __kernel_ulong_t aio_context_t;

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

struct io_event {
	__u64 data;
	__u64 obj;
	__s64 res;
	__s64 res2;
};

struct iocb {
	__u64 aio_data;
	__u32 aio_key;
	__kernel_rwf_t aio_rw_flags;
	__u16 aio_lio_opcode;
	__s16 aio_reqprio;
	__u32 aio_fildes;
	__u64 aio_buf;
	__u64 aio_nbytes;
	__s64 aio_offset;
	__u64 aio_reserved2;
	__u32 aio_flags;
	__u32 aio_resfd;
};

typedef int kiocb_cancel_fn(struct kiocb *);

struct pseudo_fs_context {
	const struct super_operations *ops;
	const struct xattr_handler * const *xattr;
	const struct dentry_operations *dops;
	long unsigned int magic;
};

struct aio_ring {
	unsigned int id;
	unsigned int nr;
	unsigned int head;
	unsigned int tail;
	unsigned int magic;
	unsigned int compat_features;
	unsigned int incompat_features;
	unsigned int header_length;
	struct io_event io_events[0];
};

struct kioctx_cpu;

struct ctx_rq_wait;

struct kioctx {
	struct percpu_ref users;
	atomic_t dead;
	struct percpu_ref reqs;
	long unsigned int user_id;
	struct kioctx_cpu *cpu;
	unsigned int req_batch;
	unsigned int max_reqs;
	unsigned int nr_events;
	long unsigned int mmap_base;
	long unsigned int mmap_size;
	struct page **ring_pages;
	long int nr_pages;
	struct rcu_work free_rwork;
	struct ctx_rq_wait *rq_wait;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct {
		atomic_t reqs_available;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		spinlock_t ctx_lock;
		struct list_head active_reqs;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		struct mutex ring_lock;
		wait_queue_head_t wait;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct {
		unsigned int tail;
		unsigned int completed_events;
		spinlock_t completion_lock;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct page *internal_pages[8];
	struct file *aio_ring_file;
	unsigned int id;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct kioctx_cpu {
	unsigned int reqs_available;
};

struct ctx_rq_wait {
	struct completion comp;
	atomic_t count;
};

struct fsync_iocb {
	struct file *file;
	struct work_struct work;
	bool datasync;
	struct cred *creds;
};

struct poll_iocb {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	bool cancelled;
	bool work_scheduled;
	bool work_need_resched;
	struct wait_queue_entry wait;
	struct work_struct work;
};

struct aio_kiocb {
	union {
		struct file *ki_filp;
		struct kiocb rw;
		struct fsync_iocb fsync;
		struct poll_iocb poll;
	};
	struct kioctx *ki_ctx;
	kiocb_cancel_fn *ki_cancel;
	struct io_event ki_res;
	struct list_head ki_list;
	refcount_t ki_refcnt;
	struct eventfd_ctx *ki_eventfd;
};

struct aio_poll_table {
	struct poll_table_struct pt;
	struct aio_kiocb *iocb;
	bool queued;
	int error;
};

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
};

enum {
	PROC_ENTRY_PERMANENT = 1,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

struct proc_fs_info {
	struct pid_namespace *pid_ns;
	struct dentry *proc_self;
	struct dentry *proc_thread_self;
	kgid_t pid_gid;
	enum proc_hidepid hide_pid;
	enum proc_pidonly pidonly;
};

typedef short unsigned int __kernel_uid16_t;

typedef short unsigned int __kernel_gid16_t;

typedef __kernel_uid16_t uid16_t;

typedef __kernel_gid16_t gid16_t;

typedef int get_block_t(struct inode *, sector_t, struct buffer_head *, int);

struct ext4_io_submit {
	struct writeback_control *io_wbc;
	struct bio *io_bio;
	ext4_io_end_t *io_end;
	sector_t io_next_block;
};

struct ext4_group_desc {
	__le32 bg_block_bitmap_lo;
	__le32 bg_inode_bitmap_lo;
	__le32 bg_inode_table_lo;
	__le16 bg_free_blocks_count_lo;
	__le16 bg_free_inodes_count_lo;
	__le16 bg_used_dirs_count_lo;
	__le16 bg_flags;
	__le32 bg_exclude_bitmap_lo;
	__le16 bg_block_bitmap_csum_lo;
	__le16 bg_inode_bitmap_csum_lo;
	__le16 bg_itable_unused_lo;
	__le16 bg_checksum;
	__le32 bg_block_bitmap_hi;
	__le32 bg_inode_bitmap_hi;
	__le32 bg_inode_table_hi;
	__le16 bg_free_blocks_count_hi;
	__le16 bg_free_inodes_count_hi;
	__le16 bg_used_dirs_count_hi;
	__le16 bg_itable_unused_hi;
	__le32 bg_exclude_bitmap_hi;
	__le16 bg_block_bitmap_csum_hi;
	__le16 bg_inode_bitmap_csum_hi;
	__u32 bg_reserved;
};

struct ext4_inode {
	__le16 i_mode;
	__le16 i_uid;
	__le32 i_size_lo;
	__le32 i_atime;
	__le32 i_ctime;
	__le32 i_mtime;
	__le32 i_dtime;
	__le16 i_gid;
	__le16 i_links_count;
	__le32 i_blocks_lo;
	__le32 i_flags;
	union {
		struct {
			__le32 l_i_version;
		} linux1;
		struct {
			__u32 h_i_translator;
		} hurd1;
		struct {
			__u32 m_i_reserved1;
		} masix1;
	} osd1;
	__le32 i_block[15];
	__le32 i_generation;
	__le32 i_file_acl_lo;
	__le32 i_size_high;
	__le32 i_obso_faddr;
	union {
		struct {
			__le16 l_i_blocks_high;
			__le16 l_i_file_acl_high;
			__le16 l_i_uid_high;
			__le16 l_i_gid_high;
			__le16 l_i_checksum_lo;
			__le16 l_i_reserved;
		} linux2;
		struct {
			__le16 h_i_reserved1;
			__u16 h_i_mode_high;
			__u16 h_i_uid_high;
			__u16 h_i_gid_high;
			__u32 h_i_author;
		} hurd2;
		struct {
			__le16 h_i_reserved1;
			__le16 m_i_file_acl_high;
			__u32 m_i_reserved2[2];
		} masix2;
	} osd2;
	__le16 i_extra_isize;
	__le16 i_checksum_hi;
	__le32 i_ctime_extra;
	__le32 i_mtime_extra;
	__le32 i_atime_extra;
	__le32 i_crtime;
	__le32 i_crtime_extra;
	__le32 i_version_hi;
	__le32 i_projid;
};

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

struct ext4_xattr_ibody_header {
	__le32 h_magic;
};

struct ext4_xattr_inode_array {
	unsigned int count;
	struct inode *inodes[0];
};

struct mpage_da_data {
	struct inode *inode;
	struct writeback_control *wbc;
	unsigned int can_map: 1;
	long unsigned int first_page;
	long unsigned int next_page;
	long unsigned int last_page;
	struct ext4_map_blocks map;
	struct ext4_io_submit io_submit;
	unsigned int do_map: 1;
	unsigned int scanned_until_end: 1;
	unsigned int journalled_more_data: 1;
};

struct fsverity_info;

struct fscrypt_inode_info;

struct ipc_ids {
	int in_use;
	short unsigned int seq;
	struct rw_semaphore rwsem;
	struct idr ipcs_idr;
	int max_idx;
	int last_idx;
	struct rhashtable key_ht;
};

struct ipc_namespace {
	struct ipc_ids ids[3];
	int sem_ctls[4];
	int used_sems;
	unsigned int msg_ctlmax;
	unsigned int msg_ctlmnb;
	unsigned int msg_ctlmni;
	struct percpu_counter percpu_msg_bytes;
	struct percpu_counter percpu_msg_hdrs;
	size_t shm_ctlmax;
	size_t shm_ctlall;
	long unsigned int shm_tot;
	int shm_ctlmni;
	int shm_rmid_forced;
	struct notifier_block ipcns_nb;
	struct vfsmount *mq_mnt;
	unsigned int mq_queues_count;
	unsigned int mq_queues_max;
	unsigned int mq_msg_max;
	unsigned int mq_msgsize_max;
	unsigned int mq_msg_default;
	unsigned int mq_msgsize_default;
	struct ctl_table_set mq_set;
	struct ctl_table_header *mq_sysctls;
	struct ctl_table_set ipc_set;
	struct ctl_table_header *ipc_sysctls;
	struct user_namespace *user_ns;
	struct ucounts *ucounts;
	struct llist_node mnt_llist;
	struct ns_common ns;
};

enum {
	SELNL_MSG_SETENFORCE = 16,
	SELNL_MSG_POLICYLOAD = 17,
	SELNL_MSG_MAX = 18,
};

enum selinux_nlgroups {
	SELNLGRP_NONE = 0,
	SELNLGRP_AVC = 1,
	__SELNLGRP_MAX = 2,
};

struct selnl_msg_setenforce {
	__s32 val;
};

struct selnl_msg_policyload {
	__u32 seqno;
};

enum {
	POLICYDB_CAP_NETPEER = 0,
	POLICYDB_CAP_OPENPERM = 1,
	POLICYDB_CAP_EXTSOCKCLASS = 2,
	POLICYDB_CAP_ALWAYSNETWORK = 3,
	POLICYDB_CAP_CGROUPSECLABEL = 4,
	POLICYDB_CAP_NNP_NOSUID_TRANSITION = 5,
	POLICYDB_CAP_GENFS_SECLABEL_SYMLINKS = 6,
	POLICYDB_CAP_IOCTL_SKIP_CLOEXEC = 7,
	__POLICYDB_CAP_MAX = 8,
};

struct ima_queue_entry {
	struct hlist_node hnext;
	struct list_head later;
	struct ima_template_entry *entry;
};

struct ima_h_table {
	atomic_long_t len;
	atomic_long_t violations;
	struct hlist_head queue[1024];
};

struct rtattr {
	short unsigned int rta_len;
	short unsigned int rta_type;
};

struct crypto_sync_skcipher;

struct aead_geniv_ctx {
	spinlock_t lock;
	struct crypto_aead *child;
	struct crypto_sync_skcipher *sknull;
	u8 salt[0];
};

struct crypto_istat_rng {
	atomic64_t generate_cnt;
	atomic64_t generate_tlen;
	atomic64_t seed_cnt;
	atomic64_t err_cnt;
};

struct crypto_rng;

struct rng_alg {
	int (*generate)(struct crypto_rng *, const u8 *, unsigned int, u8 *, unsigned int);
	int (*seed)(struct crypto_rng *, const u8 *, unsigned int);
	void (*set_ent)(struct crypto_rng *, const u8 *, unsigned int);
	unsigned int seedsize;
	struct crypto_alg base;
};

struct crypto_rng {
	struct crypto_tfm base;
};

struct kernel_pkey_query {
	__u32 supported_ops;
	__u32 key_size;
	__u16 max_data_size;
	__u16 max_sig_size;
	__u16 max_enc_size;
	__u16 max_dec_size;
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_md2WithRSAEncryption = 11,
	OID_md3WithRSAEncryption = 12,
	OID_md4WithRSAEncryption = 13,
	OID_sha1WithRSAEncryption = 14,
	OID_sha256WithRSAEncryption = 15,
	OID_sha384WithRSAEncryption = 16,
	OID_sha512WithRSAEncryption = 17,
	OID_sha224WithRSAEncryption = 18,
	OID_data = 19,
	OID_signed_data = 20,
	OID_email_address = 21,
	OID_contentType = 22,
	OID_messageDigest = 23,
	OID_signingTime = 24,
	OID_smimeCapabilites = 25,
	OID_smimeAuthenticatedAttrs = 26,
	OID_md2 = 27,
	OID_md4 = 28,
	OID_md5 = 29,
	OID_mskrb5 = 30,
	OID_krb5 = 31,
	OID_krb5u2u = 32,
	OID_msIndirectData = 33,
	OID_msStatementType = 34,
	OID_msSpOpusInfo = 35,
	OID_msPeImageDataObjId = 36,
	OID_msIndividualSPKeyPurpose = 37,
	OID_msOutlookExpress = 38,
	OID_ntlmssp = 39,
	OID_negoex = 40,
	OID_spnego = 41,
	OID_IAKerb = 42,
	OID_PKU2U = 43,
	OID_Scram = 44,
	OID_certAuthInfoAccess = 45,
	OID_sha1 = 46,
	OID_id_ansip384r1 = 47,
	OID_sha256 = 48,
	OID_sha384 = 49,
	OID_sha512 = 50,
	OID_sha224 = 51,
	OID_commonName = 52,
	OID_surname = 53,
	OID_countryName = 54,
	OID_locality = 55,
	OID_stateOrProvinceName = 56,
	OID_organizationName = 57,
	OID_organizationUnitName = 58,
	OID_title = 59,
	OID_description = 60,
	OID_name = 61,
	OID_givenName = 62,
	OID_initials = 63,
	OID_generationalQualifier = 64,
	OID_subjectKeyIdentifier = 65,
	OID_keyUsage = 66,
	OID_subjectAltName = 67,
	OID_issuerAltName = 68,
	OID_basicConstraints = 69,
	OID_crlDistributionPoints = 70,
	OID_certPolicies = 71,
	OID_authorityKeyIdentifier = 72,
	OID_extKeyUsage = 73,
	OID_NetlogonMechanism = 74,
	OID_appleLocalKdcSupported = 75,
	OID_gostCPSignA = 76,
	OID_gostCPSignB = 77,
	OID_gostCPSignC = 78,
	OID_gost2012PKey256 = 79,
	OID_gost2012PKey512 = 80,
	OID_gost2012Digest256 = 81,
	OID_gost2012Digest512 = 82,
	OID_gost2012Signature256 = 83,
	OID_gost2012Signature512 = 84,
	OID_gostTC26Sign256A = 85,
	OID_gostTC26Sign256B = 86,
	OID_gostTC26Sign256C = 87,
	OID_gostTC26Sign256D = 88,
	OID_gostTC26Sign512A = 89,
	OID_gostTC26Sign512B = 90,
	OID_gostTC26Sign512C = 91,
	OID_sm2 = 92,
	OID_sm3 = 93,
	OID_SM2_with_SM3 = 94,
	OID_sm3WithRSAEncryption = 95,
	OID_TPMLoadableKey = 96,
	OID_TPMImportableKey = 97,
	OID_TPMSealedData = 98,
	OID__NR = 99,
};

struct public_key {
	void *key;
	u32 keyl