/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-application-manifescolt.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_APPLICATION_COLLECTOR_H
#define __UNITY_WEBAPPS_APPLICATION_COLLECTOR_H


#define UNITY_WEBAPPS_TYPE_APPLICATION_COLLECTOR              (unity_webapps_application_collector_get_type())
#define UNITY_WEBAPPS_APPLICATION_COLLECTOR(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_APPLICATION_COLLECTOR, UnityWebappsApplicationCollector))
#define UNITY_WEBAPPS_APPLICATION_COLLECTOR_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_APPLICATION_COLLECTOR, UnityWebappsApplicationCollectorClass))
#define UNITY_WEBAPPS_IS_APPLICATION_COLLECTOR(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_APPLICATION_COLLECTOR))
#define UNITY_WEBAPPS_IS_APPLICATION_COLLECTOR_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_APPLICATION_COLLECTOR))
#define UNITY_WEBAPPS_APPLICATION_COLLECTOR_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_APPLICATION_COLLECTOR, UnityWebappsApplicationCollectorClass))

#include <glib.h>
#include <glib-object.h>

typedef struct _UnityWebappsApplicationCollectorPrivate UnityWebappsApplicationCollectorPrivate;

typedef struct _UnityWebappsApplicationCollector UnityWebappsApplicationCollector;

struct _UnityWebappsApplicationCollector {
	GObject object;

	UnityWebappsApplicationCollectorPrivate *priv;
};

typedef struct _UnityWebappsApplicationCollectorClass UnityWebappsApplicationCollectorClass;

struct _UnityWebappsApplicationCollectorClass
{
	GObjectClass parent_class;
};

GType unity_webapps_application_collector_get_type (void) G_GNUC_CONST;

UnityWebappsApplicationCollector * unity_webapps_application_collector_new (const gchar **path);
UnityWebappsApplicationCollector *unity_webapps_application_collector_new_with_default_path ();
GHashTable * unity_webapps_application_collector_get_applications (UnityWebappsApplicationCollector *collector);
gboolean unity_webapps_application_collector_search_path (UnityWebappsApplicationCollector *collector);


#endif
