.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XAllocClassHint __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAllocClassHint, XSetClassHint, XGetClassHint, XClassHint \- allocate class hints structure and set or read a window's WM_CLASS property
.SH SYNTAX
.HP
XClassHint *XAllocClassHint\^(void\^);
.HP
XSetClassHint\^(\^Display *\fIdisplay\fP, Window \fIw\fP, XClassHint *\fIclass_hints\fP\^);
.HP
Status XGetClassHint\^(\^Display *\fIdisplay\fP, Window \fIw\fP, XClassHint *\fIclass_hints_return\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIclass_hints\fP 1i
Specifies the
.B XClassHint
structure that is to be used.
.IP \fIclass_hints_return\fP 1i
Returns the
.B XClassHint
structure.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The
.B XAllocClassHint
function allocates and returns a pointer to a
.B XClassHint
structure.
Note that the pointer fields in the
.B XClassHint
structure are initially set to NULL.
If insufficient memory is available,
.B XAllocClassHint
returns NULL.
To free the memory allocated to this structure,
use
.BR XFree .
.LP
The
.B XSetClassHint
function sets the class hint for the specified window.
If the strings are not in the Host Portable Character Encoding,
the result is implementation-dependent.
.LP
.B XSetClassHint
can generate
.B BadAlloc
and
.B BadWindow
errors.
.LP
The
.B XGetClassHint
function returns the class hint of the specified window to the members
of the supplied structure.
If the data returned by the server is in the Latin Portable Character Encoding,
then the returned strings are in the Host Portable Character Encoding.
Otherwise, the result is implementation-dependent.
It returns a nonzero status on success;
otherwise, it returns a zero status.
To free res_name and res_class when finished with the strings,
use
.B XFree
on each individually.
.LP
.B XGetClassHint
can generate a
.B BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_CLASS\s+1
Set by application programs to allow window and session
managers to obtain the application's resources from the resource database.
.SH STRUCTURES
The
.B XClassHint
structure contains:
.LP
.IN "XClassHint" "" "@DEF@"
.EX
typedef struct {
        char *res_name;
        char *res_class;
} XClassHint;
.LP
The res_name member contains the application name,
and the res_class member contains the application class.
Note that the name set in this property may differ from the name set as WM_NAME.
That is, WM_NAME specifies what should be displayed in the title bar and,
therefore, can contain temporal information (for example, the name of
a file currently in an editor's buffer).
On the other hand,
the name specified as part of WM_CLASS is the formal name of the application
that should be used when retrieving the application's resources from the
resource database.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.na
XAllocIconSize(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XAllocWMHints(__libmansuffix__),
XFree(__libmansuffix__),
XSetCommand(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMIconName(__libmansuffix__),
XSetWMName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
