/* File automatically generated by u_unfilled_gen.py */

/*
 * Copyright 2009 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * VMWARE AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 */



/**
 * @file
 * Functions to translate and generate index lists
 */

#include "indices/u_indices.h"
#include "indices/u_indices_priv.h"
#include "pipe/p_compiler.h"
#include "util/u_debug.h"
#include "pipe/p_defines.h"
#include "util/u_memory.h"


static unsigned out_size_idx( unsigned index_size )
{
   switch (index_size) {
   case 4: return OUT_UINT;
   case 2: return OUT_USHORT;
   default: assert(0); return OUT_USHORT;
   }
}

static unsigned in_size_idx( unsigned index_size )
{
   switch (index_size) {
   case 4: return IN_UINT;
   case 2: return IN_USHORT;
   case 1: return IN_UBYTE;
   default: assert(0); return IN_UBYTE;
   }
}


static u_generate_func generate_line[OUT_COUNT][PRIM_COUNT];
static u_translate_func translate_line[IN_COUNT][OUT_COUNT][PRIM_COUNT];


static void generate_tris_ushort(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1);
      (out+j+2)[0] = (ushort)(i+1);
      (out+j+2)[1] = (ushort)(i+2);
      (out+j+4)[0] = (ushort)(i+2);
      (out+j+4)[1] = (ushort)(i);
   }
}
static void generate_tristrip_ushort(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)(i+1/*+(i&1)*/);
      (out+j+2)[0] = (ushort)(i+1/*+(i&1)*/);
      (out+j+2)[1] = (ushort)(i+2/*-(i&1)*/);
      (out+j+4)[0] = (ushort)(i+2/*-(i&1)*/);
      (out+j+4)[1] = (ushort)(i);
   }
}
static void generate_trifan_ushort(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)(0);
      (out+j)[1] = (ushort)(i+1);
      (out+j+2)[0] = (ushort)(i+1);
      (out+j+2)[1] = (ushort)(i+2);
      (out+j+4)[0] = (ushort)(i+2);
      (out+j+4)[1] = (ushort)(0);
   }
}
static void generate_quads_ushort(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (ushort)(i+0);
      (out+j)[1] = (ushort)(i+1);
      (out+j+2)[0] = (ushort)(i+1);
      (out+j+2)[1] = (ushort)(i+2);
      (out+j+4)[0] = (ushort)(i+2);
      (out+j+4)[1] = (ushort)(i+3);
      (out+j+6)[0] = (ushort)(i+3);
      (out+j+6)[1] = (ushort)(i+0);
   }
}
static void generate_quadstrip_ushort(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (ushort)(i+2);
      (out+j)[1] = (ushort)(i+0);
      (out+j+2)[0] = (ushort)(i+0);
      (out+j+2)[1] = (ushort)(i+1);
      (out+j+4)[0] = (ushort)(i+1);
      (out+j+4)[1] = (ushort)(i+3);
      (out+j+6)[0] = (ushort)(i+3);
      (out+j+6)[1] = (ushort)(i+2);
   }
}
static void generate_polygon_ushort(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)(i);
      (out+j)[1] = (ushort)((i+1)%(out_nr/2));
   }
}
static void generate_tris_uint(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1);
      (out+j+2)[0] = (uint)(i+1);
      (out+j+2)[1] = (uint)(i+2);
      (out+j+4)[0] = (uint)(i+2);
      (out+j+4)[1] = (uint)(i);
   }
}
static void generate_tristrip_uint(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)(i+1/*+(i&1)*/);
      (out+j+2)[0] = (uint)(i+1/*+(i&1)*/);
      (out+j+2)[1] = (uint)(i+2/*-(i&1)*/);
      (out+j+4)[0] = (uint)(i+2/*-(i&1)*/);
      (out+j+4)[1] = (uint)(i);
   }
}
static void generate_trifan_uint(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)(0);
      (out+j)[1] = (uint)(i+1);
      (out+j+2)[0] = (uint)(i+1);
      (out+j+2)[1] = (uint)(i+2);
      (out+j+4)[0] = (uint)(i+2);
      (out+j+4)[1] = (uint)(0);
   }
}
static void generate_quads_uint(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (uint)(i+0);
      (out+j)[1] = (uint)(i+1);
      (out+j+2)[0] = (uint)(i+1);
      (out+j+2)[1] = (uint)(i+2);
      (out+j+4)[0] = (uint)(i+2);
      (out+j+4)[1] = (uint)(i+3);
      (out+j+6)[0] = (uint)(i+3);
      (out+j+6)[1] = (uint)(i+0);
   }
}
static void generate_quadstrip_uint(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (uint)(i+2);
      (out+j)[1] = (uint)(i+0);
      (out+j+2)[0] = (uint)(i+0);
      (out+j+2)[1] = (uint)(i+1);
      (out+j+4)[0] = (uint)(i+1);
      (out+j+4)[1] = (uint)(i+3);
      (out+j+6)[0] = (uint)(i+3);
      (out+j+6)[1] = (uint)(i+2);
   }
}
static void generate_polygon_uint(
    unsigned start,
    unsigned out_nr,
    void *_out )
{
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)(i);
      (out+j)[1] = (uint)((i+1)%(out_nr/2));
   }
}
static void translate_tris_ubyte2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[i];
   }
}
static void translate_tristrip_ubyte2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (ushort)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (ushort)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (ushort)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (ushort)in[i];
   }
}
static void translate_trifan_ubyte2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)in[0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[0];
   }
}
static void translate_quads_ubyte2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[i+3];
      (out+j+6)[0] = (ushort)in[i+3];
      (out+j+6)[1] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_ubyte2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+0];
      (out+j+2)[0] = (ushort)in[i+0];
      (out+j+2)[1] = (ushort)in[i+1];
      (out+j+4)[0] = (ushort)in[i+1];
      (out+j+4)[1] = (ushort)in[i+3];
      (out+j+6)[0] = (ushort)in[i+3];
      (out+j+6)[1] = (ushort)in[i+2];
   }
}
static void translate_polygon_ubyte2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[(i+1)%(out_nr/2)];
   }
}
static void translate_tris_ubyte2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[i];
   }
}
static void translate_tristrip_ubyte2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint)in[i];
   }
}
static void translate_trifan_ubyte2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)in[0];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[0];
   }
}
static void translate_quads_ubyte2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[i+3];
      (out+j+6)[0] = (uint)in[i+3];
      (out+j+6)[1] = (uint)in[i+0];
   }
}
static void translate_quadstrip_ubyte2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+0];
      (out+j+2)[0] = (uint)in[i+0];
      (out+j+2)[1] = (uint)in[i+1];
      (out+j+4)[0] = (uint)in[i+1];
      (out+j+4)[1] = (uint)in[i+3];
      (out+j+6)[0] = (uint)in[i+3];
      (out+j+6)[1] = (uint)in[i+2];
   }
}
static void translate_polygon_ubyte2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ubyte*in = (const ubyte*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[(i+1)%(out_nr/2)];
   }
}
static void translate_tris_ushort2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[i];
   }
}
static void translate_tristrip_ushort2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (ushort)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (ushort)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (ushort)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (ushort)in[i];
   }
}
static void translate_trifan_ushort2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)in[0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[0];
   }
}
static void translate_quads_ushort2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[i+3];
      (out+j+6)[0] = (ushort)in[i+3];
      (out+j+6)[1] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_ushort2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+0];
      (out+j+2)[0] = (ushort)in[i+0];
      (out+j+2)[1] = (ushort)in[i+1];
      (out+j+4)[0] = (ushort)in[i+1];
      (out+j+4)[1] = (ushort)in[i+3];
      (out+j+6)[0] = (ushort)in[i+3];
      (out+j+6)[1] = (ushort)in[i+2];
   }
}
static void translate_polygon_ushort2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[(i+1)%(out_nr/2)];
   }
}
static void translate_tris_ushort2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[i];
   }
}
static void translate_tristrip_ushort2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint)in[i];
   }
}
static void translate_trifan_ushort2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)in[0];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[0];
   }
}
static void translate_quads_ushort2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[i+3];
      (out+j+6)[0] = (uint)in[i+3];
      (out+j+6)[1] = (uint)in[i+0];
   }
}
static void translate_quadstrip_ushort2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+0];
      (out+j+2)[0] = (uint)in[i+0];
      (out+j+2)[1] = (uint)in[i+1];
      (out+j+4)[0] = (uint)in[i+1];
      (out+j+4)[1] = (uint)in[i+3];
      (out+j+6)[0] = (uint)in[i+3];
      (out+j+6)[1] = (uint)in[i+2];
   }
}
static void translate_polygon_ushort2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const ushort*in = (const ushort*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[(i+1)%(out_nr/2)];
   }
}
static void translate_tris_uint2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[i];
   }
}
static void translate_tristrip_uint2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (ushort)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (ushort)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (ushort)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (ushort)in[i];
   }
}
static void translate_trifan_uint2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (ushort)in[0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[0];
   }
}
static void translate_quads_uint2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (ushort)in[i+0];
      (out+j)[1] = (ushort)in[i+1];
      (out+j+2)[0] = (ushort)in[i+1];
      (out+j+2)[1] = (ushort)in[i+2];
      (out+j+4)[0] = (ushort)in[i+2];
      (out+j+4)[1] = (ushort)in[i+3];
      (out+j+6)[0] = (ushort)in[i+3];
      (out+j+6)[1] = (ushort)in[i+0];
   }
}
static void translate_quadstrip_uint2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (ushort)in[i+2];
      (out+j)[1] = (ushort)in[i+0];
      (out+j+2)[0] = (ushort)in[i+0];
      (out+j+2)[1] = (ushort)in[i+1];
      (out+j+4)[0] = (ushort)in[i+1];
      (out+j+4)[1] = (ushort)in[i+3];
      (out+j+6)[0] = (ushort)in[i+3];
      (out+j+6)[1] = (ushort)in[i+2];
   }
}
static void translate_polygon_uint2ushort(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  ushort *out = (ushort*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (ushort)in[i];
      (out+j)[1] = (ushort)in[(i+1)%(out_nr/2)];
   }
}
static void translate_tris_uint2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i+=3) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[i];
   }
}
static void translate_tristrip_uint2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[i+1/*+(i&1)*/];
      (out+j+2)[0] = (uint)in[i+1/*+(i&1)*/];
      (out+j+2)[1] = (uint)in[i+2/*-(i&1)*/];
      (out+j+4)[0] = (uint)in[i+2/*-(i&1)*/];
      (out+j+4)[1] = (uint)in[i];
   }
}
static void translate_trifan_uint2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=6, i++) { 
      (out+j)[0] = (uint)in[0];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[0];
   }
}
static void translate_quads_uint2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=4) { 
      (out+j)[0] = (uint)in[i+0];
      (out+j)[1] = (uint)in[i+1];
      (out+j+2)[0] = (uint)in[i+1];
      (out+j+2)[1] = (uint)in[i+2];
      (out+j+4)[0] = (uint)in[i+2];
      (out+j+4)[1] = (uint)in[i+3];
      (out+j+6)[0] = (uint)in[i+3];
      (out+j+6)[1] = (uint)in[i+0];
   }
}
static void translate_quadstrip_uint2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=8, i+=2) { 
      (out+j)[0] = (uint)in[i+2];
      (out+j)[1] = (uint)in[i+0];
      (out+j+2)[0] = (uint)in[i+0];
      (out+j+2)[1] = (uint)in[i+1];
      (out+j+4)[0] = (uint)in[i+1];
      (out+j+4)[1] = (uint)in[i+3];
      (out+j+6)[0] = (uint)in[i+3];
      (out+j+6)[1] = (uint)in[i+2];
   }
}
static void translate_polygon_uint2uint(
    const void * _in,
    unsigned start,
    unsigned in_nr,
    unsigned out_nr,
    unsigned restart_index,
    void *_out )
{
  const uint*in = (const uint*)_in;
  uint *out = (uint*)_out;
  unsigned i, j;
  (void)j;
  for (i = start, j = 0; j < out_nr; j+=2, i++) { 
      (out+j)[0] = (uint)in[i];
      (out+j)[1] = (uint)in[(i+1)%(out_nr/2)];
   }
}
void u_unfilled_init( void )
{
  static int firsttime = 1;
  if (!firsttime) return;
  firsttime = 0;
generate_line[OUT_USHORT][PIPE_PRIM_TRIANGLES] = generate_tris_ushort;
generate_line[OUT_USHORT][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_ushort;
generate_line[OUT_USHORT][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_ushort;
generate_line[OUT_USHORT][PIPE_PRIM_QUADS] = generate_quads_ushort;
generate_line[OUT_USHORT][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_ushort;
generate_line[OUT_USHORT][PIPE_PRIM_POLYGON] = generate_polygon_ushort;
generate_line[OUT_UINT][PIPE_PRIM_TRIANGLES] = generate_tris_uint;
generate_line[OUT_UINT][PIPE_PRIM_TRIANGLE_FAN] = generate_trifan_uint;
generate_line[OUT_UINT][PIPE_PRIM_TRIANGLE_STRIP] = generate_tristrip_uint;
generate_line[OUT_UINT][PIPE_PRIM_QUADS] = generate_quads_uint;
generate_line[OUT_UINT][PIPE_PRIM_QUAD_STRIP] = generate_quadstrip_uint;
generate_line[OUT_UINT][PIPE_PRIM_POLYGON] = generate_polygon_uint;
translate_line[IN_UBYTE][OUT_USHORT][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2ushort;
translate_line[IN_UBYTE][OUT_USHORT][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2ushort;
translate_line[IN_UBYTE][OUT_USHORT][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2ushort;
translate_line[IN_UBYTE][OUT_USHORT][PIPE_PRIM_QUADS] = translate_quads_ubyte2ushort;
translate_line[IN_UBYTE][OUT_USHORT][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2ushort;
translate_line[IN_UBYTE][OUT_USHORT][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2ushort;
translate_line[IN_UBYTE][OUT_UINT][PIPE_PRIM_TRIANGLES] = translate_tris_ubyte2uint;
translate_line[IN_UBYTE][OUT_UINT][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ubyte2uint;
translate_line[IN_UBYTE][OUT_UINT][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ubyte2uint;
translate_line[IN_UBYTE][OUT_UINT][PIPE_PRIM_QUADS] = translate_quads_ubyte2uint;
translate_line[IN_UBYTE][OUT_UINT][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ubyte2uint;
translate_line[IN_UBYTE][OUT_UINT][PIPE_PRIM_POLYGON] = translate_polygon_ubyte2uint;
translate_line[IN_USHORT][OUT_USHORT][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2ushort;
translate_line[IN_USHORT][OUT_USHORT][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2ushort;
translate_line[IN_USHORT][OUT_USHORT][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2ushort;
translate_line[IN_USHORT][OUT_USHORT][PIPE_PRIM_QUADS] = translate_quads_ushort2ushort;
translate_line[IN_USHORT][OUT_USHORT][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2ushort;
translate_line[IN_USHORT][OUT_USHORT][PIPE_PRIM_POLYGON] = translate_polygon_ushort2ushort;
translate_line[IN_USHORT][OUT_UINT][PIPE_PRIM_TRIANGLES] = translate_tris_ushort2uint;
translate_line[IN_USHORT][OUT_UINT][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_ushort2uint;
translate_line[IN_USHORT][OUT_UINT][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_ushort2uint;
translate_line[IN_USHORT][OUT_UINT][PIPE_PRIM_QUADS] = translate_quads_ushort2uint;
translate_line[IN_USHORT][OUT_UINT][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_ushort2uint;
translate_line[IN_USHORT][OUT_UINT][PIPE_PRIM_POLYGON] = translate_polygon_ushort2uint;
translate_line[IN_UINT][OUT_USHORT][PIPE_PRIM_TRIANGLES] = translate_tris_uint2ushort;
translate_line[IN_UINT][OUT_USHORT][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2ushort;
translate_line[IN_UINT][OUT_USHORT][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2ushort;
translate_line[IN_UINT][OUT_USHORT][PIPE_PRIM_QUADS] = translate_quads_uint2ushort;
translate_line[IN_UINT][OUT_USHORT][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2ushort;
translate_line[IN_UINT][OUT_USHORT][PIPE_PRIM_POLYGON] = translate_polygon_uint2ushort;
translate_line[IN_UINT][OUT_UINT][PIPE_PRIM_TRIANGLES] = translate_tris_uint2uint;
translate_line[IN_UINT][OUT_UINT][PIPE_PRIM_TRIANGLE_FAN] = translate_trifan_uint2uint;
translate_line[IN_UINT][OUT_UINT][PIPE_PRIM_TRIANGLE_STRIP] = translate_tristrip_uint2uint;
translate_line[IN_UINT][OUT_UINT][PIPE_PRIM_QUADS] = translate_quads_uint2uint;
translate_line[IN_UINT][OUT_UINT][PIPE_PRIM_QUAD_STRIP] = translate_quadstrip_uint2uint;
translate_line[IN_UINT][OUT_UINT][PIPE_PRIM_POLYGON] = translate_polygon_uint2uint;
}
#include "indices/u_unfilled_indices.c"
