// asUintN test specialised when the input is an Int32 value.

const tests = [
  [-0x80000000n, 0, 0n],
  [-0x7fffffffn, 0, 0n],
  [-0x7ffffffen, 0, 0n],
  [-9n, 0, 0n],
  [-8n, 0, 0n],
  [-7n, 0, 0n],
  [-6n, 0, 0n],
  [-5n, 0, 0n],
  [-4n, 0, 0n],
  [-3n, 0, 0n],
  [-2n, 0, 0n],
  [-1n, 0, 0n],
  [0n, 0, 0n],
  [1n, 0, 0n],
  [2n, 0, 0n],
  [3n, 0, 0n],
  [4n, 0, 0n],
  [5n, 0, 0n],
  [6n, 0, 0n],
  [7n, 0, 0n],
  [8n, 0, 0n],
  [9n, 0, 0n],
  [0x7ffffffen, 0, 0n],
  [0x7fffffffn, 0, 0n],
  [-0x80000000n, 1, 0n],
  [-0x7fffffffn, 1, 1n],
  [-0x7ffffffen, 1, 0n],
  [-9n, 1, 1n],
  [-8n, 1, 0n],
  [-7n, 1, 1n],
  [-6n, 1, 0n],
  [-5n, 1, 1n],
  [-4n, 1, 0n],
  [-3n, 1, 1n],
  [-2n, 1, 0n],
  [-1n, 1, 1n],
  [0n, 1, 0n],
  [1n, 1, 1n],
  [2n, 1, 0n],
  [3n, 1, 1n],
  [4n, 1, 0n],
  [5n, 1, 1n],
  [6n, 1, 0n],
  [7n, 1, 1n],
  [8n, 1, 0n],
  [9n, 1, 1n],
  [0x7ffffffen, 1, 0n],
  [0x7fffffffn, 1, 1n],
  [-0x80000000n, 2, 0n],
  [-0x7fffffffn, 2, 1n],
  [-0x7ffffffen, 2, 2n],
  [-9n, 2, 3n],
  [-8n, 2, 0n],
  [-7n, 2, 1n],
  [-6n, 2, 2n],
  [-5n, 2, 3n],
  [-4n, 2, 0n],
  [-3n, 2, 1n],
  [-2n, 2, 2n],
  [-1n, 2, 3n],
  [0n, 2, 0n],
  [1n, 2, 1n],
  [2n, 2, 2n],
  [3n, 2, 3n],
  [4n, 2, 0n],
  [5n, 2, 1n],
  [6n, 2, 2n],
  [7n, 2, 3n],
  [8n, 2, 0n],
  [9n, 2, 1n],
  [0x7ffffffen, 2, 2n],
  [0x7fffffffn, 2, 3n],
  [-0x80000000n, 31, 0n],
  [-0x7fffffffn, 31, 1n],
  [-0x7ffffffen, 31, 2n],
  [-9n, 31, 0x7ffffff7n],
  [-8n, 31, 0x7ffffff8n],
  [-7n, 31, 0x7ffffff9n],
  [-6n, 31, 0x7ffffffan],
  [-5n, 31, 0x7ffffffbn],
  [-4n, 31, 0x7ffffffcn],
  [-3n, 31, 0x7ffffffdn],
  [-2n, 31, 0x7ffffffen],
  [-1n, 31, 0x7fffffffn],
  [0n, 31, 0n],
  [1n, 31, 1n],
  [2n, 31, 2n],
  [3n, 31, 3n],
  [4n, 31, 4n],
  [5n, 31, 5n],
  [6n, 31, 6n],
  [7n, 31, 7n],
  [8n, 31, 8n],
  [9n, 31, 9n],
  [0x7ffffffen, 31, 0x7ffffffen],
  [0x7fffffffn, 31, 0x7fffffffn],
  [0n, 32, 0n],
  [1n, 32, 1n],
  [2n, 32, 2n],
  [3n, 32, 3n],
  [4n, 32, 4n],
  [5n, 32, 5n],
  [6n, 32, 6n],
  [7n, 32, 7n],
  [8n, 32, 8n],
  [9n, 32, 9n],
  [0x7ffffffen, 32, 0x7ffffffen],
  [0x7fffffffn, 32, 0x7fffffffn],
];

function f(tests) {
  for (let test of tests) {
    let input = test[0], bits = test[1], expected = test[2];

    assertEq(BigInt.asUintN(bits, input), expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
