/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * Tests to check representation of ES6 destructuring assignments.
 *
 * @test
 * @option -scripting
 * @run
 */

load(__DIR__ + "utils.js")

var code = <<EOF

var a, b;
[a, b] = [1, 2];
({a, b} = {a:11, b:12});

EOF

parse("destructuring_assign.js", code, "--language=es6", new (Java.extend(visitor_es6, {
    visitAssignment : function (node, obj) {
        obj.push(convert(node))
    },
    visitVariable : function (node, obj) {
        obj.push(convert(node))
    }
})))

