/*
 *  html.c
 *
 *  Copyright (C) 2003 Nadav Rotem <nadav256@hotmail.com>
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libots.h"

static unsigned char *
ots_get_line_HTML (const OtsSentence * aLine, size_t * out_size)
{
  GList *li;
  GString *text;
  unsigned char *utf8_data;
  char *score_str;
  text = g_string_new (NULL);

  score_str=g_new0(char,32);
  sprintf(score_str,"<!--(%ld)-->",aLine->score);
  g_string_append (text,score_str);
  g_free(score_str);

  if ((aLine->selected))
    {
      g_string_append (text,
		       "<FONT COLOR=\"#16569E\"><span style=\'background:yellow;\'>");
    }
  else
    {
      g_string_append (text, "<FONT COLOR=\"#16569E\"><span>");
    }

  for (li = (GList *) aLine->words; li != NULL; li = li->next)
    {
      if (0 == strcmp ((char *) li->data, "\n"))
	g_string_append (text, "<br>");
      else
	g_string_append (text, (char *) li->data);
    }
  g_string_append (text,"</span></FONT>\n");

  if (out_size)
    *out_size = text->len;

  utf8_data = text->str;
  g_string_free (text, FALSE);

  return utf8_data;
}


#if 0
static void
ots_print_line_HTML (FILE * stream, const OtsSentence * aLine)
{
  unsigned char *utf8_txt;
  size_t len;

  utf8_txt = ots_get_line_HTML (aLine, &len);
  fwrite (utf8_txt, 1, len, stream);
  g_free (utf8_txt);
}
#endif


unsigned char *
ots_get_doc_HTML (const OtsArticle * Doc, size_t * out_len)
{
  GList *li;
  GString *text;
  unsigned char *utf8_data;
  size_t line_len;

  text = g_string_new (NULL);


  g_string_append (text,
		   "<html>\n<head>\n<title>OTS</title>\n<meta charset=\"utf-8\">\n</head>\n<body>\n");
  g_string_append (text, "<!-- Generated by OpenTextSummarizer -->\n");
  g_string_append (text, "<!--");
  g_string_append (text, Doc->title);
  g_string_append (text, "-->\n");


  for (li = (GList *) Doc->lines; li != NULL; li = li->next)
    {
      utf8_data = ots_get_line_HTML ((OtsSentence *) li->data, &line_len);
      g_string_append_len (text, utf8_data, line_len);
      g_free (utf8_data);
    }
  g_string_append (text, "</body></html>\n");

  if (out_len)
    *out_len = text->len;
  utf8_data = text->str;

  g_string_free (text, FALSE);
  return utf8_data;

}



void
ots_print_HTML (FILE * stream, const OtsArticle * Doc)
{
  unsigned char *utf8_txt;
  size_t len;

  utf8_txt = ots_get_doc_HTML (Doc, &len);
  fwrite (utf8_txt, 1, len, stream);
  g_free (utf8_txt);

}
