/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#include "timeutils.h"

// Qt
#include <QDateTime>
#include <QLocale>
#include <QRegExp>

// KDE
#include <KDebug>
#include <KGlobal>
#include <KLocale>

namespace TimeUtils
{

QString formatDateTime(const QDateTime& dateTime, const QDateTime& _now)
{
    KLocale* locale = KGlobal::locale();
    QDateTime now = _now.isValid() ? _now : QDateTime::currentDateTime();

    int delta = dateTime.secsTo(now);
    if (delta < 3600) {
        return formatShortDuration(delta / 60);
    }
    if (dateTime.date() == now.date()) {
        return locale->formatTime(dateTime.time());
    }
    if (dateTime.daysTo(now) < 7) {
        return QDate::shortDayName(dateTime.date().dayOfWeek()) + " " + locale->formatTime(dateTime.time());
    }

    return dateTime.toString(TimeUtils::shortDateFormat()) + " " + locale->formatTime(dateTime.time());
}

QString formatShortDuration(int minutes)
{
    return i18ncp("%1 is a number of minutes",
        // xgettext: no-c-format
        "1m", "%1m", minutes);
}

QString shortDateFormat(const QLocale* defaultLocale)
{
    static const QRegExp rx("[^dMy]?yy(yy)?[^dMy]?");
    QLocale locale = defaultLocale ? *defaultLocale : QLocale::system();
    return locale.dateFormat(QLocale::ShortFormat).replace(rx, QString());

}

} // namespace
