RabbitMQ `3.11.4` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Server

#### Enhancements

 * Import of definition files with many streams is now more efficient.

   GitHub issue: [#6436](https://github.com/rabbitmq/rabbitmq-server/pull/6436)

 * Lower CPU throughput in clusters with many mostly idle streams.

   GitHub issue: [#6436](https://github.com/rabbitmq/rabbitmq-server/pull/6436)

 * Streams with `max_age` retention now attempt to reclaim disk space every hour.
   This is relevant in environments with a lot of mostly inactive streams that
   set `max_age`.

   GitHub issue: [#6436](https://github.com/rabbitmq/rabbitmq-server/pull/6436)

 * Quorum queues are now more resilient to WAL log growth with workloads that
   involve clients that register a consumer and then close the channel
   or connection without ever consuming any deliveries or cancelling
   the consumer.

   GitHub issue: [#6447](https://github.com/rabbitmq/rabbitmq-server/issues/6447)

 * Dead-lettering of a large number of messages to a classic mirrored queues now has lower peak memory footprint.

   GitHub issue: [#5312](https://github.com/rabbitmq/rabbitmq-server/issues/5312)

#### Bug Fixes

 * When a node encouters an invalid `definitions.local.file` on boot,
   it will refuse to start instead of ignoring the file.

   GitHub issue: [#2610](https://github.com/rabbitmq/rabbitmq-server/issues/2610)

 * Fixed a type analyzer definition.

   Contributed by @illotum (AWS).

   GitHub issue: [#6401](https://github.com/rabbitmq/rabbitmq-server/pull/6401)


### CLI Tools

#### Enhancements

 * `rabbitmq-diagnostics check_if_node_is_quorum_critical` and
   `rabbitmq-upgrade await_online_quorum_plus_one` now consider
   stream (not just quorum queues) replica placement when determining
   if target node is quorum-critical.

   GitHub issue: [#6448](https://github.com/rabbitmq/rabbitmq-server/pull/6448)

 * Queue info keys now support more inclusive property names related
   to (deprecated) classic mirrored queues. For example, `mirror_pids`
   can now be used instead of `slave_pids`.

   Contributed by @illotum (AWS).

   GitHub issue: [#2635](https://github.com/rabbitmq/rabbitmq-server/issues/2635)

 * `rabbitmq-diagnostics memory_breakdown` now executes significantly faster
   in environments with a large number (say, tens or hundreds of thousands) of
   quorum queues. Two orders of magnitude faster, in fact.

   GitHub issue: [#6388](https://github.com/rabbitmq/rabbitmq-server/issues/6388)

#### Bug Fixes

 * Definition export in JSON failed on nodes that used `definitions.skip_if_unchanged`.

   GitHub issue: [#6424](https://github.com/rabbitmq/rabbitmq-server/issues/6424)

 * Using quorum queue-specific commands on streams now results in clearer error messages.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#6488](https://github.com/rabbitmq/rabbitmq-server/pull/6488)


### LDAP Plugin

#### Bug Fixes

 * LDAP server password could end up in the logs in certain types of exceptions.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#4842](https://github.com/rabbitmq/rabbitmq-server/issues/4842)


### STOMP Plugin

#### Enhancements

  * `x-max-age` [stream setting](https://rabbitmq.com/streams.html) now can be set
    by STOMP clients via a header.

    GitHub issue: [#5003](https://github.com/rabbitmq/rabbitmq-server/issues/5003)


## Dependency Upgrades

 * `osiris` was upgraded [from `1.3.3` to `1.4.0`](https://github.com/rabbitmq/osiris/tags)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.4.tar.xz`
instead of the source tarball produced by GitHub.
