/* gkr-item.c generated by valac 0.22.1, the Vala compiler
 * generated from gkr-item.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <gio/gio.h>
#include <seahorse-internal.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define SEAHORSE_GKR_TYPE_DISPLAY_INFO (seahorse_gkr_display_info_get_type ())
typedef struct _SeahorseGkrDisplayInfo SeahorseGkrDisplayInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SEAHORSE_GKR_TYPE_DISPLAY_ENTRY (seahorse_gkr_display_entry_get_type ())
typedef struct _SeahorseGkrDisplayEntry SeahorseGkrDisplayEntry;
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _seahorse_gkr_display_info_free0(var) ((var == NULL) ? NULL : (var = (seahorse_gkr_display_info_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_ITEM_DELETER (seahorse_gkr_item_deleter_get_type ())
#define SEAHORSE_GKR_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter))
#define SEAHORSE_GKR_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))
#define SEAHORSE_GKR_IS_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_IS_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_ITEM_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))

typedef struct _SeahorseGkrItemDeleter SeahorseGkrItemDeleter;
typedef struct _SeahorseGkrItemDeleterClass SeahorseGkrItemDeleterClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseGkrItemSetSecretData SeahorseGkrItemSetSecretData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_MAPPING_ENTRY (seahorse_gkr_mapping_entry_get_type ())
typedef struct _SeahorseGkrMappingEntry SeahorseGkrMappingEntry;
typedef struct _SeahorseGkrItemDeleterPrivate SeahorseGkrItemDeleterPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _SeahorseGkrItemDeleterDeleteData SeahorseGkrItemDeleterDeleteData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseGkrDisplayInfo {
	gchar* item_type;
	gchar* label;
	gchar* details;
	gchar* description;
};

typedef void (*SeahorseGkrDisplayCustom) (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
struct _SeahorseGkrDisplayEntry {
	gchar* item_type;
	gchar* description;
	SeahorseGkrDisplayCustom custom_func;
};

struct _SeahorseGkrItemPrivate {
	SecretValue* _item_secret;
	SeahorseGkrDisplayInfo* _info;
	GWeakRef _place;
	GCancellable* _req_secret;
};

struct _SeahorseGkrItemSetSecretData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrItem* self;
	SecretValue* value;
	GCancellable* cancellable;
	gboolean result;
	SecretValue* _tmp0_;
	GCancellable* _tmp1_;
	SecretValue* _tmp2_;
	SecretValue* _tmp3_;
	GError * _inner_error_;
};

struct _SeahorseGkrMappingEntry {
	gchar* item_type;
	gchar* mapped_type;
	gchar* match_attribute;
	gchar* match_pattern;
};

struct _SeahorseGkrItemDeleter {
	SeahorseDeleter parent_instance;
	SeahorseGkrItemDeleterPrivate * priv;
};

struct _SeahorseGkrItemDeleterClass {
	SeahorseDeleterClass parent_class;
};

struct _SeahorseGkrItemDeleterPrivate {
	GList* _items;
};

struct _SeahorseGkrItemDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrItemDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	GList* items;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* item_collection;
	GList* item_it;
	SeahorseGkrItem* item;
	SeahorseGkrItem* _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_;
};


static gpointer seahorse_gkr_item_parent_class = NULL;
static SeahorseDeletableIface* seahorse_gkr_item_seahorse_deletable_parent_iface = NULL;
static SeahorseViewableIface* seahorse_gkr_item_seahorse_viewable_parent_iface = NULL;
static gpointer seahorse_gkr_item_deleter_parent_class = NULL;

GType seahorse_gkr_display_info_get_type (void) G_GNUC_CONST;
SeahorseGkrDisplayInfo* seahorse_gkr_display_info_dup (const SeahorseGkrDisplayInfo* self);
void seahorse_gkr_display_info_free (SeahorseGkrDisplayInfo* self);
void seahorse_gkr_display_info_copy (const SeahorseGkrDisplayInfo* self, SeahorseGkrDisplayInfo* dest);
void seahorse_gkr_display_info_destroy (SeahorseGkrDisplayInfo* self);
GType seahorse_gkr_display_entry_get_type (void) G_GNUC_CONST;
SeahorseGkrDisplayEntry* seahorse_gkr_display_entry_dup (const SeahorseGkrDisplayEntry* self);
void seahorse_gkr_display_entry_free (SeahorseGkrDisplayEntry* self);
void seahorse_gkr_display_entry_copy (const SeahorseGkrDisplayEntry* self, SeahorseGkrDisplayEntry* dest);
void seahorse_gkr_display_entry_destroy (SeahorseGkrDisplayEntry* self);
#define SEAHORSE_GKR_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItemPrivate))
enum  {
	SEAHORSE_GKR_ITEM_DUMMY_PROPERTY,
	SEAHORSE_GKR_ITEM_DESCRIPTION,
	SEAHORSE_GKR_ITEM_USE,
	SEAHORSE_GKR_ITEM_HAS_SECRET,
	SEAHORSE_GKR_ITEM_PLACE,
	SEAHORSE_GKR_ITEM_OBJECT_FLAGS,
	SEAHORSE_GKR_ITEM_ICON,
	SEAHORSE_GKR_ITEM_LABEL,
	SEAHORSE_GKR_ITEM_MARKUP,
	SEAHORSE_GKR_ITEM_USAGE,
	SEAHORSE_GKR_ITEM_ACTIONS,
	SEAHORSE_GKR_ITEM_DELETABLE
};
static void seahorse_gkr_item_real_dispose (GObject* base);
static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base);
SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item);
SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type, SeahorseGkrItem* item);
GType seahorse_gkr_item_deleter_get_type (void) G_GNUC_CONST;
static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base, GtkWindow* parent);
static void seahorse_gkr_item_ensure_display_info (SeahorseGkrItem* self);
gchar* seahorse_gkr_get_attribute_string (GHashTable* attrs, const gchar* name);
gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type, GHashTable* attrs);
#define SEAHORSE_GKR_GENERIC_SECRET "org.freedesktop.Secret.Generic"
#define SEAHORSE_GKR_NETWORK_PASSWORD "org.gnome.keyring.NetworkPassword"
void seahorse_gkr_network_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_network_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_KEYRING_NOTE "org.gnome.keyring.Note"
#define SEAHORSE_GKR_CHAINED_KEYRING "org.gnome.keyring.ChainedKeyring"
#define SEAHORSE_GKR_ENCRYPTION_KEY "org.gnome.keyring.EncryptionKey"
#define SEAHORSE_GKR_PK_STORAGE "org.gnome.keyring.PkStorage"
#define SEAHORSE_GKR_CHROME_PASSWORD "x.internal.Chrome"
void seahorse_gkr_chrome_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_GOA_PASSWORD "org.gnome.OnlineAccounts"
#define SEAHORSE_GKR_TELEPATHY_PASSWORD "org.freedesktop.Telepathy"
void seahorse_gkr_telepathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_EMPATHY_PASSWORD "org.freedesktop.Empathy"
void seahorse_gkr_empathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_NETWORK_MANAGER_SECRET "org.freedesktop.NetworkManager"
static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self);
static void ___lambda18_ (SeahorseGkrItem* self, GObject* obj, GAsyncResult* res);
static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_item_set_secret_data_free (gpointer _data);
static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_);
static void seahorse_gkr_item_set_secret_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * seahorse_gkr_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_item___lambda28_ (SeahorseGkrItem* self, GVariant* changed_properties, gchar** invalidated_properties, int invalidated_properties_length1);
static void __seahorse_gkr_item___lambda28__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void seahorse_gkr_item_finalize (GObject* obj);
static void _vala_seahorse_gkr_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gint seahorse_gkr_get_attribute_int (GHashTable* attrs, const gchar* name);
gboolean seahorse_gkr_is_network_item (GHashTable* attrs, const gchar* match);
gboolean seahorse_gkr_is_custom_network_label (const gchar* server, const gchar* user, const gchar* object, gint port, const gchar* display);
gchar* seahorse_gkr_calc_network_label (GHashTable* attrs, gboolean always);
gchar* seahorse_gkr_decode_telepathy_id (const gchar* account);
GType seahorse_gkr_mapping_entry_get_type (void) G_GNUC_CONST;
SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self);
void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self);
void seahorse_gkr_mapping_entry_copy (const SeahorseGkrMappingEntry* self, SeahorseGkrMappingEntry* dest);
void seahorse_gkr_mapping_entry_destroy (SeahorseGkrMappingEntry* self);
#define SEAHORSE_GKR_ITEM_DELETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterPrivate))
enum  {
	SEAHORSE_GKR_ITEM_DELETER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent);
static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base, GObject* obj);
static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data);
static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_);
static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void seahorse_gkr_item_deleter_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

const SeahorseGkrDisplayEntry SEAHORSE_GKR_DISPLAY_ENTRIES[11] = {{SEAHORSE_GKR_GENERIC_SECRET, "Password or secret", NULL}, {SEAHORSE_GKR_NETWORK_PASSWORD, "Network password", _seahorse_gkr_network_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_KEYRING_NOTE, "Stored note", NULL}, {SEAHORSE_GKR_CHAINED_KEYRING, "Keyring password", NULL}, {SEAHORSE_GKR_ENCRYPTION_KEY, "Encryption key password", NULL}, {SEAHORSE_GKR_PK_STORAGE, "Key storage password", NULL}, {SEAHORSE_GKR_CHROME_PASSWORD, "Google Chrome password", _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_GOA_PASSWORD, "Gnome Online Accounts password", NULL}, {SEAHORSE_GKR_TELEPATHY_PASSWORD, "Telepathy password", _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_EMPATHY_PASSWORD, "Instant messaging password", _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "Network Manager secret", NULL}};
const SeahorseGkrMappingEntry SEAHORSE_GKR_MAPPING_ENTRIES[5] = {{SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_CHROME_PASSWORD, "application", "chrome*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_GOA_PASSWORD, "goa-identity", NULL}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_TELEPATHY_PASSWORD, "account", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_EMPATHY_PASSWORD, "account-id", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "connection-uuid", NULL}};

GType seahorse_gkr_use_get_type (void) {
	static volatile gsize seahorse_gkr_use_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_use_type_id__volatile)) {
		static const GEnumValue values[] = {{SEAHORSE_GKR_USE_OTHER, "SEAHORSE_GKR_USE_OTHER", "other"}, {SEAHORSE_GKR_USE_NETWORK, "SEAHORSE_GKR_USE_NETWORK", "network"}, {SEAHORSE_GKR_USE_WEB, "SEAHORSE_GKR_USE_WEB", "web"}, {SEAHORSE_GKR_USE_PGP, "SEAHORSE_GKR_USE_PGP", "pgp"}, {SEAHORSE_GKR_USE_SSH, "SEAHORSE_GKR_USE_SSH", "ssh"}, {0, NULL, NULL}};
		GType seahorse_gkr_use_type_id;
		seahorse_gkr_use_type_id = g_enum_register_static ("SeahorseGkrUse", values);
		g_once_init_leave (&seahorse_gkr_use_type_id__volatile, seahorse_gkr_use_type_id);
	}
	return seahorse_gkr_use_type_id__volatile;
}


void seahorse_gkr_display_info_copy (const SeahorseGkrDisplayInfo* self, SeahorseGkrDisplayInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (*self).item_type;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).item_type);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).item_type = _tmp1_;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*self).label;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).label);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).label = _tmp3_;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = (*self).details;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).details);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).details = _tmp5_;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = (*self).description;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).description);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).description = _tmp7_;
#line 303 "gkr-item.c"
}


void seahorse_gkr_display_info_destroy (SeahorseGkrDisplayInfo* self) {
#line 35 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).item_type);
#line 36 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).label);
#line 37 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).details);
#line 38 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).description);
#line 316 "gkr-item.c"
}


SeahorseGkrDisplayInfo* seahorse_gkr_display_info_dup (const SeahorseGkrDisplayInfo* self) {
	SeahorseGkrDisplayInfo* dup;
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	dup = g_new0 (SeahorseGkrDisplayInfo, 1);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_info_copy (self, dup);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	return dup;
#line 328 "gkr-item.c"
}


void seahorse_gkr_display_info_free (SeahorseGkrDisplayInfo* self) {
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_info_destroy (self);
#line 34 "/data/src/seahorse/gkr/gkr-item.vala"
	g_free (self);
#line 337 "gkr-item.c"
}


GType seahorse_gkr_display_info_get_type (void) {
	static volatile gsize seahorse_gkr_display_info_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_display_info_type_id__volatile)) {
		GType seahorse_gkr_display_info_type_id;
		seahorse_gkr_display_info_type_id = g_boxed_type_register_static ("SeahorseGkrDisplayInfo", (GBoxedCopyFunc) seahorse_gkr_display_info_dup, (GBoxedFreeFunc) seahorse_gkr_display_info_free);
		g_once_init_leave (&seahorse_gkr_display_info_type_id__volatile, seahorse_gkr_display_info_type_id);
	}
	return seahorse_gkr_display_info_type_id__volatile;
}


void seahorse_gkr_display_entry_copy (const SeahorseGkrDisplayEntry* self, SeahorseGkrDisplayEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SeahorseGkrDisplayCustom _tmp4_ = NULL;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (*self).item_type;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).item_type);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).item_type = _tmp1_;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*self).description;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).description);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).description = _tmp3_;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = (*self).custom_func;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).custom_func = _tmp4_;
#line 378 "gkr-item.c"
}


void seahorse_gkr_display_entry_destroy (SeahorseGkrDisplayEntry* self) {
#line 47 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).item_type);
#line 48 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).description);
#line 387 "gkr-item.c"
}


SeahorseGkrDisplayEntry* seahorse_gkr_display_entry_dup (const SeahorseGkrDisplayEntry* self) {
	SeahorseGkrDisplayEntry* dup;
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	dup = g_new0 (SeahorseGkrDisplayEntry, 1);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_entry_copy (self, dup);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	return dup;
#line 399 "gkr-item.c"
}


void seahorse_gkr_display_entry_free (SeahorseGkrDisplayEntry* self) {
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_entry_destroy (self);
#line 46 "/data/src/seahorse/gkr/gkr-item.vala"
	g_free (self);
#line 408 "gkr-item.c"
}


GType seahorse_gkr_display_entry_get_type (void) {
	static volatile gsize seahorse_gkr_display_entry_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_display_entry_type_id__volatile)) {
		GType seahorse_gkr_display_entry_type_id;
		seahorse_gkr_display_entry_type_id = g_boxed_type_register_static ("SeahorseGkrDisplayEntry", (GBoxedCopyFunc) seahorse_gkr_display_entry_dup, (GBoxedFreeFunc) seahorse_gkr_display_entry_free);
		g_once_init_leave (&seahorse_gkr_display_entry_type_id__volatile, seahorse_gkr_display_entry_type_id);
	}
	return seahorse_gkr_display_entry_type_id__volatile;
}


static void seahorse_gkr_item_real_dispose (GObject* base) {
	SeahorseGkrItem * self;
	GCancellable* _tmp0_ = NULL;
#line 137 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 138 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_req_secret;
#line 138 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ != NULL) {
#line 432 "gkr-item.c"
		GCancellable* _tmp1_ = NULL;
#line 139 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = self->priv->_req_secret;
#line 139 "/data/src/seahorse/gkr/gkr-item.vala"
		g_cancellable_cancel (_tmp1_);
#line 438 "gkr-item.c"
	}
#line 140 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (self->priv->_req_secret);
#line 140 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_req_secret = NULL;
#line 141 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 446 "gkr-item.c"
}


static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base) {
	SeahorseGkrItem * self;
	SeahorseDeleter* result = NULL;
	SeahorseGkrItemDeleter* _tmp0_ = NULL;
#line 144 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 145 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = seahorse_gkr_item_deleter_new (self);
#line 145 "/data/src/seahorse/gkr/gkr-item.vala"
	result = (SeahorseDeleter*) _tmp0_;
#line 145 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 462 "gkr-item.c"
}


static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base, GtkWindow* parent) {
	SeahorseGkrItem * self;
	GtkWindow* result = NULL;
	GtkWindow* _tmp0_ = NULL;
	SeahorseGkrItemProperties* _tmp1_ = NULL;
#line 148 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = parent;
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_item_properties_new (self, _tmp0_);
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_ref_sink (_tmp1_);
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	result = (GtkWindow*) _tmp1_;
#line 149 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 483 "gkr-item.c"
}


static gpointer _seahorse_gkr_display_info_dup0 (gpointer self) {
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	return self ? seahorse_gkr_display_info_dup (self) : NULL;
#line 490 "gkr-item.c"
}


static void _seahorse_gkr_network_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_network_custom (label, item_attrs, info);
#line 497 "gkr-item.c"
}


static void _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_chrome_custom (label, item_attrs, info);
#line 504 "gkr-item.c"
}


static void _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_telepathy_custom (label, item_attrs, info);
#line 511 "gkr-item.c"
}


static void _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_empathy_custom (label, item_attrs, info);
#line 518 "gkr-item.c"
}


static void seahorse_gkr_item_ensure_display_info (SeahorseGkrItem* self) {
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	SeahorseGkrDisplayInfo _tmp1_ = {0};
	SeahorseGkrDisplayInfo _tmp2_ = {0};
	SeahorseGkrDisplayInfo* _tmp3_ = NULL;
	GHashTable* attrs = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	gchar* item_type = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SeahorseGkrDisplayInfo* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* label = NULL;
	gchar* _tmp15_ = NULL;
	SeahorseGkrDisplayInfo* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	SeahorseGkrDisplayInfo* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	SeahorseGkrDisplayInfo* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
#line 152 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_info;
#line 153 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ != NULL) {
#line 154 "/data/src/seahorse/gkr/gkr-item.vala"
		return;
#line 556 "gkr-item.c"
	}
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	memset (&_tmp1_, 0, sizeof (SeahorseGkrDisplayInfo));
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _tmp1_;
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = _seahorse_gkr_display_info_dup0 (&_tmp2_);
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_display_info_free0 (self->priv->_info);
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_info = _tmp3_;
#line 156 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_display_info_destroy (&_tmp2_);
#line 158 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_get ((SecretItem*) self, "attributes", &_tmp4_, NULL);
#line 158 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = _tmp4_;
#line 158 "/data/src/seahorse/gkr/gkr-item.vala"
	attrs = _tmp5_;
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = attrs;
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = seahorse_gkr_get_attribute_string (_tmp6_, "xdg:schema");
#line 159 "/data/src/seahorse/gkr/gkr-item.vala"
	item_type = _tmp7_;
#line 160 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = item_type;
#line 160 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = attrs;
#line 160 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = seahorse_gkr_map_item_type_to_specific (_tmp8_, _tmp9_);
#line 160 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (item_type);
#line 160 "/data/src/seahorse/gkr/gkr-item.vala"
	item_type = _tmp10_;
#line 161 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp11_ = item_type;
#line 161 "/data/src/seahorse/gkr/gkr-item.vala"
	_vala_assert (_tmp11_ != NULL, "item_type != null");
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp12_ = self->priv->_info;
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp13_ = item_type;
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*_tmp12_).item_type);
#line 162 "/data/src/seahorse/gkr/gkr-item.vala"
	(*_tmp12_).item_type = _tmp14_;
#line 164 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp15_ = secret_item_get_label (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 164 "/data/src/seahorse/gkr/gkr-item.vala"
	label = _tmp15_;
#line 610 "gkr-item.c"
	{
		SeahorseGkrDisplayEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
		entry_collection = SEAHORSE_GKR_DISPLAY_ENTRIES;
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
		entry_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_DISPLAY_ENTRIES);
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SEAHORSE_GKR_DISPLAY_ENTRIES); entry_it = entry_it + 1) {
#line 622 "gkr-item.c"
			SeahorseGkrDisplayEntry entry = {0};
#line 165 "/data/src/seahorse/gkr/gkr-item.vala"
			entry = entry_collection[entry_it];
#line 626 "gkr-item.c"
			{
				SeahorseGkrDisplayEntry _tmp16_ = {0};
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp16_ = entry;
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp17_ = _tmp16_.item_type;
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp18_ = item_type;
#line 166 "/data/src/seahorse/gkr/gkr-item.vala"
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
#line 639 "gkr-item.c"
					SeahorseGkrDisplayEntry _tmp19_ = {0};
					SeahorseGkrDisplayCustom _tmp20_ = NULL;
					SeahorseGkrDisplayInfo* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp19_ = entry;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp20_ = _tmp19_.custom_func;
#line 167 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp20_ != NULL) {
#line 650 "gkr-item.c"
						SeahorseGkrDisplayEntry _tmp21_ = {0};
						SeahorseGkrDisplayCustom _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
						GHashTable* _tmp24_ = NULL;
#line 168 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp21_ = entry;
#line 168 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp22_ = _tmp21_.custom_func;
#line 168 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp23_ = label;
#line 168 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp24_ = attrs;
#line 168 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp22_ (_tmp23_, _tmp24_, self->priv->_info);
#line 665 "gkr-item.c"
					}
#line 169 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp25_ = self->priv->_info;
#line 169 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp26_ = (*_tmp25_).description;
#line 169 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp26_ == NULL) {
#line 673 "gkr-item.c"
						SeahorseGkrDisplayInfo* _tmp27_ = NULL;
						SeahorseGkrDisplayEntry _tmp28_ = {0};
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp27_ = self->priv->_info;
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp28_ = entry;
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp29_ = _tmp28_.description;
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp30_ = _ (_tmp29_);
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp31_ = g_strdup (_tmp30_);
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						_g_free0 ((*_tmp27_).description);
#line 170 "/data/src/seahorse/gkr/gkr-item.vala"
						(*_tmp27_).description = _tmp31_;
#line 693 "gkr-item.c"
					}
#line 171 "/data/src/seahorse/gkr/gkr-item.vala"
					break;
#line 697 "gkr-item.c"
				}
			}
		}
	}
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp32_ = self->priv->_info;
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp33_ = (*_tmp32_).label;
#line 175 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp33_ == NULL) {
#line 708 "gkr-item.c"
		SeahorseGkrDisplayInfo* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp34_ = self->priv->_info;
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp35_ = label;
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp36_ = g_strdup (_tmp35_);
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*_tmp34_).label);
#line 176 "/data/src/seahorse/gkr/gkr-item.vala"
		(*_tmp34_).label = _tmp36_;
#line 722 "gkr-item.c"
	}
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp37_ = self->priv->_info;
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp38_ = (*_tmp37_).label;
#line 177 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp38_ == NULL) {
#line 730 "gkr-item.c"
		SeahorseGkrDisplayInfo* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 178 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp39_ = self->priv->_info;
#line 178 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp40_ = g_strdup ("");
#line 178 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*_tmp39_).label);
#line 178 "/data/src/seahorse/gkr/gkr-item.vala"
		(*_tmp39_).label = _tmp40_;
#line 741 "gkr-item.c"
	}
#line 179 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp41_ = self->priv->_info;
#line 179 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp42_ = (*_tmp41_).details;
#line 179 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp42_ == NULL) {
#line 749 "gkr-item.c"
		SeahorseGkrDisplayInfo* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
#line 180 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp43_ = self->priv->_info;
#line 180 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp44_ = g_strdup ("");
#line 180 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*_tmp43_).details);
#line 180 "/data/src/seahorse/gkr/gkr-item.vala"
		(*_tmp43_).details = _tmp44_;
#line 760 "gkr-item.c"
	}
#line 152 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (label);
#line 152 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (item_type);
#line 152 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_hash_table_unref0 (attrs);
#line 768 "gkr-item.c"
}


static void ___lambda18_ (SeahorseGkrItem* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (res != NULL);
#line 776 "gkr-item.c"
	{
		GAsyncResult* _tmp0_ = NULL;
		SecretValue* _tmp1_ = NULL;
#line 188 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_object_unref0 (self->priv->_req_secret);
#line 188 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_req_secret = NULL;
#line 189 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp0_ = res;
#line 189 "/data/src/seahorse/gkr/gkr-item.vala"
		secret_item_load_secret_finish ((SecretItem*) self, _tmp0_, &_inner_error_);
#line 189 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 790 "gkr-item.c"
			goto __catch2_g_error;
		}
#line 190 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = secret_item_get_secret (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 190 "/data/src/seahorse/gkr/gkr-item.vala"
		_secret_value_unref0 (self->priv->_item_secret);
#line 190 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_item_secret = _tmp1_;
#line 191 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_notify ((GObject*) self, "has-secret");
#line 801 "gkr-item.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		err = _inner_error_;
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		_inner_error_ = NULL;
#line 193 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = err;
#line 193 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = _tmp2_->message;
#line 193 "/data/src/seahorse/gkr/gkr-item.vala"
		g_warning ("gkr-item.vala:193: Couldn't retrieve secret: %s", _tmp3_);
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_error_free0 (err);
#line 821 "gkr-item.c"
	}
	__finally2:
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_inner_error_ != NULL) {
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		g_clear_error (&_inner_error_);
#line 187 "/data/src/seahorse/gkr/gkr-item.vala"
		return;
#line 832 "gkr-item.c"
	}
}


static void ____lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
	___lambda18_ (self, source_object, res);
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (self);
#line 842 "gkr-item.c"
}


static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self) {
	GCancellable* _tmp0_ = NULL;
#line 183 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_req_secret;
#line 184 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 854 "gkr-item.c"
		GCancellable* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
#line 185 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = g_cancellable_new ();
#line 185 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_object_unref0 (self->priv->_req_secret);
#line 185 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_req_secret = _tmp1_;
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = self->priv->_req_secret;
#line 186 "/data/src/seahorse/gkr/gkr-item.vala"
		secret_item_load_secret ((SecretItem*) self, _tmp2_, ____lambda18__gasync_ready_callback, g_object_ref (self));
#line 867 "gkr-item.c"
	}
}


void seahorse_gkr_item_refresh (SeahorseGkrItem* self) {
	SecretValue* _tmp0_ = NULL;
#line 200 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 201 "/data/src/seahorse/gkr/gkr-item.vala"
	secret_item_refresh (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
#line 202 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_item_secret;
#line 202 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ != NULL) {
#line 203 "/data/src/seahorse/gkr/gkr-item.vala"
		seahorse_gkr_item_load_item_secret (self);
#line 884 "gkr-item.c"
	}
}


static gpointer _secret_value_ref0 (gpointer self) {
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	return self ? secret_value_ref (self) : NULL;
#line 892 "gkr-item.c"
}


SecretValue* seahorse_gkr_item_get_secret (SeahorseGkrItem* self) {
	SecretValue* result = NULL;
	SecretValue* _tmp0_ = NULL;
	SecretValue* _tmp1_ = NULL;
	SecretValue* _tmp2_ = NULL;
#line 206 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 207 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_item_secret;
#line 207 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 208 "/data/src/seahorse/gkr/gkr-item.vala"
		seahorse_gkr_item_load_item_secret (self);
#line 909 "gkr-item.c"
	}
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = self->priv->_item_secret;
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _secret_value_ref0 (_tmp1_);
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp2_;
#line 209 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 919 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_attribute (SeahorseGkrItem* self, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 212 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 213 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_get ((SecretItem*) self, "attributes", &_tmp0_, NULL);
#line 213 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = _tmp0_;
#line 213 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _tmp1_;
#line 213 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 213 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_hash_table_unref0 (_tmp2_);
#line 213 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp3_) {
#line 214 "/data/src/seahorse/gkr/gkr-item.vala"
		result = NULL;
#line 214 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 956 "gkr-item.c"
	}
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_get ((SecretItem*) self, "attributes", &_tmp4_, NULL);
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = _tmp4_;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = _tmp5_;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = name;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = _tmp9_;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_hash_table_unref0 (_tmp6_);
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp10_;
#line 215 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 978 "gkr-item.c"
}


static void seahorse_gkr_item_set_secret_data_free (gpointer _data) {
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = _data;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (_data_->value);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->self);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_slice_free (SeahorseGkrItemSetSecretData, _data_);
#line 993 "gkr-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 1000 "gkr-item.c"
}


void seahorse_gkr_item_set_secret (SeahorseGkrItem* self, SecretValue* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrItemSetSecretData* _data_;
	SeahorseGkrItem* _tmp0_ = NULL;
	SecretValue* _tmp1_ = NULL;
	SecretValue* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_slice_new0 (SeahorseGkrItemSetSecretData);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_item_set_secret);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_item_set_secret_data_free);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->self = _tmp0_;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = value;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _secret_value_ref0 (_tmp1_);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (_data_->value);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->value = _tmp2_;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = cancellable;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->cancellable = _tmp4_;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_set_secret_co (_data_);
#line 1039 "gkr-item.c"
}


gboolean seahorse_gkr_item_set_secret_finish (SeahorseGkrItem* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrItemSetSecretData* _data_;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		return FALSE;
#line 1050 "gkr-item.c"
	}
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _data_->result;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1058 "gkr-item.c"
}


static void seahorse_gkr_item_set_secret_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrItemSetSecretData* _data_;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = _user_data_;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_source_object_ = source_object;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_res_ = _res_;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_set_secret_co (_data_);
#line 1072 "gkr-item.c"
}


static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_) {
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (_data_->_state_) {
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
		case 0:
#line 1081 "gkr-item.c"
		goto _state_0;
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
		case 1:
#line 1085 "gkr-item.c"
		goto _state_1;
		default:
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
		g_assert_not_reached ();
#line 1090 "gkr-item.c"
	}
	_state_0:
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = NULL;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = _data_->value;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = NULL;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_state_ = 1;
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	secret_item_set_secret (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_tmp0_, _data_->_tmp1_, seahorse_gkr_item_set_secret_ready, _data_);
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 1107 "gkr-item.c"
	_state_1:
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	secret_item_set_secret_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_res_, &_data_->_inner_error_);
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_inner_error_ != NULL) {
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		g_error_free (_data_->_inner_error_);
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_data_->_state_ == 0) {
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1121 "gkr-item.c"
		} else {
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1125 "gkr-item.c"
		}
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_unref (_data_->_async_result);
#line 220 "/data/src/seahorse/gkr/gkr-item.vala"
		return FALSE;
#line 1131 "gkr-item.c"
	}
#line 221 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = NULL;
#line 221 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = _data_->value;
#line 221 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp3_ = NULL;
#line 221 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp3_ = _secret_value_ref0 (_data_->_tmp2_);
#line 221 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (_data_->self->priv->_item_secret);
#line 221 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->self->priv->_item_secret = _data_->_tmp3_;
#line 222 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) _data_->self, "has-secret");
#line 223 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->result = TRUE;
#line 223 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 223 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1153 "gkr-item.c"
	} else {
#line 223 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1157 "gkr-item.c"
	}
#line 223 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 223 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1167 "gkr-item.c"
	} else {
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1171 "gkr-item.c"
	}
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 218 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 1177 "gkr-item.c"
}


SeahorseGkrItem* seahorse_gkr_item_construct (GType object_type) {
	SeahorseGkrItem * self = NULL;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) g_object_new (object_type, NULL);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	return self;
#line 1187 "gkr-item.c"
}


SeahorseGkrItem* seahorse_gkr_item_new (void) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	return seahorse_gkr_item_construct (SEAHORSE_GKR_TYPE_ITEM);
#line 1194 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_description (SeahorseGkrItem* self) {
	gchar* result;
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 54 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_ensure_display_info (self);
#line 56 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_info;
#line 56 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = (*_tmp0_).description;
#line 56 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 56 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp2_;
#line 56 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1217 "gkr-item.c"
}


SeahorseGkrUse seahorse_gkr_item_get_use (SeahorseGkrItem* self) {
	SeahorseGkrUse result;
	gchar* schema_name = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 61 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = seahorse_gkr_item_get_attribute (self, "xdg:schema");
#line 62 "/data/src/seahorse/gkr/gkr-item.vala"
	schema_name = _tmp0_;
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = schema_name;
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ != NULL) {
#line 1238 "gkr-item.c"
		const gchar* _tmp3_ = NULL;
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = schema_name;
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, SEAHORSE_GKR_NETWORK_PASSWORD) == 0;
#line 1244 "gkr-item.c"
	} else {
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = FALSE;
#line 1248 "gkr-item.c"
	}
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _tmp1_;
#line 63 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp4_) {
#line 64 "/data/src/seahorse/gkr/gkr-item.vala"
		result = SEAHORSE_GKR_USE_NETWORK;
#line 64 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (schema_name);
#line 64 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1260 "gkr-item.c"
	}
#line 65 "/data/src/seahorse/gkr/gkr-item.vala"
	result = SEAHORSE_GKR_USE_OTHER;
#line 65 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (schema_name);
#line 65 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1268 "gkr-item.c"
}


gboolean seahorse_gkr_item_get_has_secret (SeahorseGkrItem* self) {
	gboolean result;
	SecretValue* _tmp0_ = NULL;
#line 70 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_item_secret;
#line 70 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp0_ != NULL;
#line 70 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1283 "gkr-item.c"
}


SeahorseGkrKeyring* seahorse_gkr_item_get_place (SeahorseGkrItem* self) {
	SeahorseGkrKeyring* result;
	GObject* _tmp0_ = NULL;
#line 74 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 74 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = g_weak_ref_get (&self->priv->_place);
#line 74 "/data/src/seahorse/gkr/gkr-item.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
#line 74 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1298 "gkr-item.c"
}


void seahorse_gkr_item_set_place (SeahorseGkrItem* self, SeahorseGkrKeyring* value) {
	SeahorseGkrKeyring* _tmp0_ = NULL;
#line 75 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (self != NULL);
#line 75 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = value;
#line 75 "/data/src/seahorse/gkr/gkr-item.vala"
	g_weak_ref_set (&self->priv->_place, (GObject*) _tmp0_);
#line 75 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject *) self, "place");
#line 1312 "gkr-item.c"
}


SeahorseFlags seahorse_gkr_item_get_object_flags (SeahorseGkrItem* self) {
	SeahorseFlags result;
#line 79 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 79 "/data/src/seahorse/gkr/gkr-item.vala"
	result = SEAHORSE_FLAG_DELETABLE | SEAHORSE_FLAG_PERSONAL;
#line 79 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1324 "gkr-item.c"
}


GIcon* seahorse_gkr_item_get_icon (SeahorseGkrItem* self) {
	GIcon* result;
	GThemedIcon* _tmp0_ = NULL;
#line 83 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (SEAHORSE_ICON_PASSWORD);
#line 83 "/data/src/seahorse/gkr/gkr-item.vala"
	result = (GIcon*) _tmp0_;
#line 83 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1339 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_label (SeahorseGkrItem* self) {
	gchar* result;
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 87 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_ensure_display_info (self);
#line 89 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_info;
#line 89 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = (*_tmp0_).label;
#line 89 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 89 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp2_;
#line 89 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1362 "gkr-item.c"
}


gchar* seahorse_gkr_item_get_markup (SeahorseGkrItem* self) {
	gchar* result;
	GString* _result_ = NULL;
	GString* _tmp0_ = NULL;
	SeahorseGkrDisplayInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SeahorseGkrDisplayInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 94 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_ensure_display_info (self);
#line 96 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = g_string_new ("");
#line 96 "/data/src/seahorse/gkr/gkr-item.vala"
	_result_ = _tmp0_;
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = self->priv->_info;
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*_tmp1_).label;
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_markup_escape_text (_tmp2_, (gssize) (-1));
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _tmp3_;
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, _tmp4_);
#line 97 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (_tmp4_);
#line 98 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, "<span size='small' rise='0' foreground='#555555'>\n");
#line 99 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = self->priv->_info;
#line 99 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = (*_tmp5_).details;
#line 99 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, _tmp6_);
#line 100 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_result_, "</span>");
#line 101 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = _result_->str;
#line 101 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 101 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp8_;
#line 101 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_string_free0 (_result_);
#line 101 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1418 "gkr-item.c"
}


SeahorseUsage seahorse_gkr_item_get_usage (SeahorseGkrItem* self) {
	SeahorseUsage result;
#line 106 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 106 "/data/src/seahorse/gkr/gkr-item.vala"
	result = SEAHORSE_USAGE_CREDENTIALS;
#line 106 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1430 "gkr-item.c"
}


GtkActionGroup* seahorse_gkr_item_get_actions (SeahorseGkrItem* self) {
	GtkActionGroup* result;
#line 110 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 110 "/data/src/seahorse/gkr/gkr-item.vala"
	result = NULL;
#line 110 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1442 "gkr-item.c"
}


static gboolean seahorse_gkr_item_real_get_deletable (SeahorseDeletable* base) {
	gboolean result;
	SeahorseGkrItem* self;
#line 114 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItem*) base;
#line 114 "/data/src/seahorse/gkr/gkr-item.vala"
	result = TRUE;
#line 114 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1455 "gkr-item.c"
}


static void _seahorse_gkr_item___lambda28_ (SeahorseGkrItem* self, GVariant* changed_properties, gchar** invalidated_properties, int invalidated_properties_length1) {
#line 123 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (changed_properties != NULL);
#line 124 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_display_info_free0 (self->priv->_info);
#line 124 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_info = NULL;
#line 125 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_freeze_notify ((GObject*) self);
#line 126 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "has-secret");
#line 127 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "use");
#line 128 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "label");
#line 129 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "icon");
#line 130 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "markup");
#line 131 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "description");
#line 132 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_notify ((GObject*) self, "object-flags");
#line 133 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_thaw_notify ((GObject*) self);
#line 1484 "gkr-item.c"
}


static void __seahorse_gkr_item___lambda28__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
#line 123 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_item___lambda28_ (self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
#line 1491 "gkr-item.c"
}


static GObject * seahorse_gkr_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItem * self;
#line 122 "/data/src/seahorse/gkr/gkr-item.vala"
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_parent_class);
#line 122 "/data/src/seahorse/gkr/gkr-item.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 122 "/data/src/seahorse/gkr/gkr-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 123 "/data/src/seahorse/gkr/gkr-item.vala"
	g_signal_connect_object ((GDBusProxy*) self, "g-properties-changed", (GCallback) __seahorse_gkr_item___lambda28__g_dbus_proxy_g_properties_changed, self, 0);
#line 122 "/data/src/seahorse/gkr/gkr-item.vala"
	return obj;
#line 1509 "gkr-item.c"
}


static void seahorse_gkr_item_class_init (SeahorseGkrItemClass * klass) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_parent_class = g_type_class_peek_parent (klass);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemPrivate));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->dispose = seahorse_gkr_item_real_dispose;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_get_property;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_set_property;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_constructor;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_finalize;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USE, g_param_spec_enum ("use", "use", "use", SEAHORSE_GKR_TYPE_USE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_HAS_SECRET, g_param_spec_boolean ("has-secret", "has-secret", "has-secret", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_PLACE, g_param_spec_object ("place", "place", "place", SEAHORSE_GKR_TYPE_KEYRING, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_OBJECT_FLAGS, g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_MARKUP, g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USAGE, g_param_spec_enum ("usage", "usage", "usage", SEAHORSE_TYPE_USAGE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ACTIONS, g_param_spec_object ("actions", "actions", "actions", GTK_TYPE_ACTION_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DELETABLE, g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1550 "gkr-item.c"
}


static void seahorse_gkr_item_seahorse_deletable_interface_init (SeahorseDeletableIface * iface) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	iface->create_deleter = (SeahorseDeleter* (*)(SeahorseDeletable*)) seahorse_gkr_item_real_create_deleter;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	iface->get_deletable = seahorse_gkr_item_real_get_deletable;
#line 1561 "gkr-item.c"
}


static void seahorse_gkr_item_seahorse_viewable_interface_init (SeahorseViewableIface * iface) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	iface->create_viewer = (GtkWindow* (*)(SeahorseViewable*, GtkWindow*)) seahorse_gkr_item_real_create_viewer;
#line 1570 "gkr-item.c"
}


static void seahorse_gkr_item_instance_init (SeahorseGkrItem * self) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv = SEAHORSE_GKR_ITEM_GET_PRIVATE (self);
#line 117 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_item_secret = NULL;
#line 118 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_info = NULL;
#line 120 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv->_req_secret = NULL;
#line 1583 "gkr-item.c"
}


static void seahorse_gkr_item_finalize (GObject* obj) {
	SeahorseGkrItem * self;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 117 "/data/src/seahorse/gkr/gkr-item.vala"
	_secret_value_unref0 (self->priv->_item_secret);
#line 118 "/data/src/seahorse/gkr/gkr-item.vala"
	_seahorse_gkr_display_info_free0 (self->priv->_info);
#line 119 "/data/src/seahorse/gkr/gkr-item.vala"
	g_weak_ref_clear (&self->priv->_place);
#line 120 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (self->priv->_req_secret);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->finalize (obj);
#line 1601 "gkr-item.c"
}


GType seahorse_gkr_item_get_type (void) {
	static volatile gsize seahorse_gkr_item_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItem), 0, (GInstanceInitFunc) seahorse_gkr_item_instance_init, NULL };
		static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_item_type_id;
		seahorse_gkr_item_type_id = g_type_register_static (secret_item_get_type (), "SeahorseGkrItem", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
		g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
		g_once_init_leave (&seahorse_gkr_item_type_id__volatile, seahorse_gkr_item_type_id);
	}
	return seahorse_gkr_item_type_id__volatile;
}


static void _vala_seahorse_gkr_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (property_id) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_DESCRIPTION:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_string (value, seahorse_gkr_item_get_description (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_USE:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_enum (value, seahorse_gkr_item_get_use (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_HAS_SECRET:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_boolean (value, seahorse_gkr_item_get_has_secret (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_PLACE:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_object (value, seahorse_gkr_item_get_place (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_OBJECT_FLAGS:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_flags (value, seahorse_gkr_item_get_object_flags (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_ICON:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_object (value, seahorse_gkr_item_get_icon (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_LABEL:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_string (value, seahorse_gkr_item_get_label (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_MARKUP:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_take_string (value, seahorse_gkr_item_get_markup (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_USAGE:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_enum (value, seahorse_gkr_item_get_usage (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_ACTIONS:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_object (value, seahorse_gkr_item_get_actions (self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_DELETABLE:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1692 "gkr-item.c"
		default:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1698 "gkr-item.c"
	}
}


static void _vala_seahorse_gkr_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (property_id) {
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		case SEAHORSE_GKR_ITEM_PLACE:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		seahorse_gkr_item_set_place (self, g_value_get_object (value));
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1714 "gkr-item.c"
		default:
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "/data/src/seahorse/gkr/gkr-item.vala"
		break;
#line 1720 "gkr-item.c"
	}
}


gchar* seahorse_gkr_get_attribute_string (GHashTable* attrs, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 239 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 241 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 241 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 242 "/data/src/seahorse/gkr/gkr-item.vala"
		result = NULL;
#line 242 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1742 "gkr-item.c"
	}
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = attrs;
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = name;
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp4_;
#line 243 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1756 "gkr-item.c"
}


gint seahorse_gkr_get_attribute_int (GHashTable* attrs, const gchar* name) {
	gint result = 0;
	GHashTable* _tmp0_ = NULL;
	gchar* value = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 246 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 249 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 250 "/data/src/seahorse/gkr/gkr-item.vala"
		result = 0;
#line 250 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1779 "gkr-item.c"
	}
#line 252 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = attrs;
#line 252 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = name;
#line 252 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
#line 252 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 252 "/data/src/seahorse/gkr/gkr-item.vala"
	value = _tmp4_;
#line 253 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = value;
#line 253 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp5_ != NULL) {
#line 1795 "gkr-item.c"
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 254 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = value;
#line 254 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = atoi (_tmp6_);
#line 254 "/data/src/seahorse/gkr/gkr-item.vala"
		result = _tmp7_;
#line 254 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (value);
#line 254 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1808 "gkr-item.c"
	}
#line 256 "/data/src/seahorse/gkr/gkr-item.vala"
	result = 0;
#line 256 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (value);
#line 256 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1816 "gkr-item.c"
}


gboolean seahorse_gkr_is_network_item (GHashTable* attrs, const gchar* match) {
	gboolean result = FALSE;
	gchar* protocol = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 259 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 262 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 262 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "protocol");
#line 262 "/data/src/seahorse/gkr/gkr-item.vala"
	protocol = _tmp1_;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = protocol;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp3_ != NULL) {
#line 1840 "gkr-item.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = protocol;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = match;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = g_ascii_strcasecmp (_tmp4_, _tmp5_);
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = _tmp6_ == 0;
#line 1852 "gkr-item.c"
	} else {
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = FALSE;
#line 1856 "gkr-item.c"
	}
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = _tmp2_;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp7_;
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (protocol);
#line 263 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1866 "gkr-item.c"
}


gboolean seahorse_gkr_is_custom_network_label (const gchar* server, const gchar* user, const gchar* object, gint port, const gchar* display) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GString* generated = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GString* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp10_ = NULL;
	GString* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 279 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = server;
#line 279 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 280 "/data/src/seahorse/gkr/gkr-item.vala"
		result = TRUE;
#line 280 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 1891 "gkr-item.c"
	}
#line 282 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_string_new ("");
#line 282 "/data/src/seahorse/gkr/gkr-item.vala"
	generated = _tmp1_;
#line 283 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = user;
#line 283 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ != NULL) {
#line 1901 "gkr-item.c"
		GString* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 284 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = generated;
#line 284 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = user;
#line 284 "/data/src/seahorse/gkr/gkr-item.vala"
		g_string_append_printf (_tmp3_, "%s@", _tmp4_);
#line 1910 "gkr-item.c"
	}
#line 285 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = generated;
#line 285 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = server;
#line 285 "/data/src/seahorse/gkr/gkr-item.vala"
	g_string_append (_tmp5_, _tmp6_);
#line 286 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = port;
#line 286 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp7_ != 0) {
#line 1922 "gkr-item.c"
		GString* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 287 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = generated;
#line 287 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp9_ = port;
#line 287 "/data/src/seahorse/gkr/gkr-item.vala"
		g_string_append_printf (_tmp8_, ":%d", _tmp9_);
#line 1931 "gkr-item.c"
	}
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = object;
#line 288 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp10_ != NULL) {
#line 1937 "gkr-item.c"
		GString* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 289 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = generated;
#line 289 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp12_ = object;
#line 289 "/data/src/seahorse/gkr/gkr-item.vala"
		g_string_append_printf (_tmp11_, "/%s", _tmp12_);
#line 1946 "gkr-item.c"
	}
#line 291 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp13_ = generated;
#line 291 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp14_ = _tmp13_->str;
#line 291 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp15_ = display;
#line 291 "/data/src/seahorse/gkr/gkr-item.vala"
	result = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 291 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_string_free0 (generated);
#line 291 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 1960 "gkr-item.c"
}


gchar* seahorse_gkr_calc_network_label (GHashTable* attrs, gboolean always) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = attrs;
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = seahorse_gkr_is_network_item (_tmp1_, "http");
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_) {
#line 1976 "gkr-item.c"
		GHashTable* _tmp3_ = NULL;
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = attrs;
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 1982 "gkr-item.c"
	} else {
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp0_ = FALSE;
#line 1986 "gkr-item.c"
	}
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = _tmp0_;
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp4_) {
#line 1992 "gkr-item.c"
		gchar* val = NULL;
		GHashTable* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 299 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = attrs;
#line 299 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = seahorse_gkr_get_attribute_string (_tmp5_, "object");
#line 299 "/data/src/seahorse/gkr/gkr-item.vala"
		val = _tmp6_;
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = val;
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp8_ != NULL) {
#line 2010 "gkr-item.c"
			const gchar* _tmp9_ = NULL;
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp9_ = val;
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
#line 2016 "gkr-item.c"
		} else {
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp7_ = FALSE;
#line 2020 "gkr-item.c"
		}
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp10_ = _tmp7_;
#line 300 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp10_) {
#line 301 "/data/src/seahorse/gkr/gkr-item.vala"
			result = val;
#line 301 "/data/src/seahorse/gkr/gkr-item.vala"
			return result;
#line 2030 "gkr-item.c"
		}
#line 304 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = always;
#line 304 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp11_) {
#line 2036 "gkr-item.c"
			GHashTable* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 305 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp12_ = attrs;
#line 305 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp13_ = seahorse_gkr_get_attribute_string (_tmp12_, "server");
#line 305 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (val);
#line 305 "/data/src/seahorse/gkr/gkr-item.vala"
			val = _tmp13_;
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp15_ = val;
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp15_ != NULL) {
#line 2054 "gkr-item.c"
				const gchar* _tmp16_ = NULL;
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp16_ = val;
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
#line 2060 "gkr-item.c"
			} else {
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp14_ = FALSE;
#line 2064 "gkr-item.c"
			}
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp17_ = _tmp14_;
#line 306 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp17_) {
#line 307 "/data/src/seahorse/gkr/gkr-item.vala"
				result = val;
#line 307 "/data/src/seahorse/gkr/gkr-item.vala"
				return result;
#line 2074 "gkr-item.c"
			}
		}
#line 298 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (val);
#line 2079 "gkr-item.c"
	}
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	result = NULL;
#line 311 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 2085 "gkr-item.c"
}


void seahorse_gkr_network_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* server = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* protocol = NULL;
	GHashTable* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* object = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* user = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint port = 0;
	GHashTable* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	SeahorseGkrDisplayInfo _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	gchar* symbol = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp32_ = FALSE;
#line 314 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 318 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 318 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "server");
#line 318 "/data/src/seahorse/gkr/gkr-item.vala"
	server = _tmp1_;
#line 319 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = attrs;
#line 319 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = seahorse_gkr_get_attribute_string (_tmp2_, "protocol");
#line 319 "/data/src/seahorse/gkr/gkr-item.vala"
	protocol = _tmp3_;
#line 320 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = attrs;
#line 320 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = seahorse_gkr_get_attribute_string (_tmp4_, "object");
#line 320 "/data/src/seahorse/gkr/gkr-item.vala"
	object = _tmp5_;
#line 321 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = attrs;
#line 321 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = seahorse_gkr_get_attribute_string (_tmp6_, "user");
#line 321 "/data/src/seahorse/gkr/gkr-item.vala"
	user = _tmp7_;
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp8_ = attrs;
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = seahorse_gkr_get_attribute_int (_tmp8_, "port");
#line 322 "/data/src/seahorse/gkr/gkr-item.vala"
	port = _tmp9_;
#line 324 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = protocol;
#line 324 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp10_ == NULL) {
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (user);
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (object);
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (protocol);
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (server);
#line 325 "/data/src/seahorse/gkr/gkr-item.vala"
		return;
#line 2167 "gkr-item.c"
	}
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp11_ = server;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp12_ = user;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp13_ = object;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp14_ = port;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp15_ = display;
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp16_ = seahorse_gkr_is_custom_network_label (_tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
#line 328 "/data/src/seahorse/gkr/gkr-item.vala"
	if (!_tmp16_) {
#line 2183 "gkr-item.c"
		GHashTable* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 329 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp17_ = attrs;
#line 329 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp18_ = seahorse_gkr_calc_network_label (_tmp17_, TRUE);
#line 329 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 329 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp18_;
#line 2194 "gkr-item.c"
	}
#line 330 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp19_ = *info;
#line 330 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp20_ = _tmp19_.label;
#line 330 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp20_ == NULL) {
#line 2202 "gkr-item.c"
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 331 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp21_ = display;
#line 331 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 331 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 331 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp22_;
#line 2213 "gkr-item.c"
	}
#line 333 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp23_ = g_strdup ("@");
#line 333 "/data/src/seahorse/gkr/gkr-item.vala"
	symbol = _tmp23_;
#line 334 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp24_ = user;
#line 334 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp24_ == NULL) {
#line 2223 "gkr-item.c"
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 335 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp25_ = g_strdup ("");
#line 335 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (user);
#line 335 "/data/src/seahorse/gkr/gkr-item.vala"
		user = _tmp25_;
#line 336 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp26_ = g_strdup ("");
#line 336 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (symbol);
#line 336 "/data/src/seahorse/gkr/gkr-item.vala"
		symbol = _tmp26_;
#line 2238 "gkr-item.c"
	}
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp27_ = object;
#line 339 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp27_ == NULL) {
#line 2244 "gkr-item.c"
		gchar* _tmp28_ = NULL;
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp28_ = g_strdup ("");
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (object);
#line 340 "/data/src/seahorse/gkr/gkr-item.vala"
		object = _tmp28_;
#line 2252 "gkr-item.c"
	}
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp30_ = server;
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp30_ != NULL) {
#line 2258 "gkr-item.c"
		const gchar* _tmp31_ = NULL;
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp31_ = protocol;
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp29_ = _tmp31_ != NULL;
#line 2264 "gkr-item.c"
	} else {
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp29_ = FALSE;
#line 2268 "gkr-item.c"
	}
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp32_ = _tmp29_;
#line 342 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp32_) {
#line 2274 "gkr-item.c"
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp33_ = protocol;
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp34_ = user;
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp35_ = symbol;
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp36_ = server;
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp37_ = object;
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp38_ = g_markup_printf_escaped ("%s://%s%s%s/%s", _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 343 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp38_;
#line 2297 "gkr-item.c"
	}
#line 314 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (symbol);
#line 314 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (user);
#line 314 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (object);
#line 314 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (protocol);
#line 314 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (server);
#line 2309 "gkr-item.c"
}


void seahorse_gkr_chrome_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* origin = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	SeahorseGkrDisplayInfo _tmp18_ = {0};
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 349 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "origin_url");
#line 353 "/data/src/seahorse/gkr/gkr-item.vala"
	origin = _tmp1_;
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = display;
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp3_ != NULL) {
#line 2336 "gkr-item.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = display;
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = origin;
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 2345 "gkr-item.c"
	} else {
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = FALSE;
#line 2349 "gkr-item.c"
	}
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = _tmp2_;
#line 356 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp6_) {
#line 2355 "gkr-item.c"
		{
			GRegex* regex = NULL;
			GRegex* _tmp7_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GMatchInfo* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp7_ = g_regex_new ("[a-z]+://([^/]+)/", G_REGEX_CASELESS, 0, &_inner_error_);
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
			regex = _tmp7_;
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_inner_error_ != NULL) {
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2372 "gkr-item.c"
					goto __catch3_g_regex_error;
				}
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (origin);
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				g_clear_error (&_inner_error_);
#line 358 "/data/src/seahorse/gkr/gkr-item.vala"
				return;
#line 2383 "gkr-item.c"
			}
#line 360 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp8_ = regex;
#line 360 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp9_ = display;
#line 360 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp11_ = g_regex_match (_tmp8_, _tmp9_, G_REGEX_MATCH_ANCHORED, &_tmp10_);
#line 360 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 360 "/data/src/seahorse/gkr/gkr-item.vala"
			match = _tmp10_;
#line 360 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp11_) {
#line 2397 "gkr-item.c"
				GMatchInfo* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
#line 361 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp12_ = match;
#line 361 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp13_ = g_match_info_matches (_tmp12_);
#line 361 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_tmp13_) {
#line 2406 "gkr-item.c"
					GMatchInfo* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp14_ = match;
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp15_ = g_match_info_fetch (_tmp14_, 1);
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 ((*info).label);
#line 362 "/data/src/seahorse/gkr/gkr-item.vala"
					(*info).label = _tmp15_;
#line 2417 "gkr-item.c"
				}
			}
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_regex_unref0 (regex);
#line 2424 "gkr-item.c"
		}
		goto __finally3;
		__catch3_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			err = _inner_error_;
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_inner_error_ = NULL;
#line 365 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp16_ = err;
#line 365 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp17_ = _tmp16_->message;
#line 365 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("gkr-item.vala:365: %s", _tmp17_);
#line 366 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_error_free0 (err);
#line 366 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (origin);
#line 366 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 2448 "gkr-item.c"
		}
		__finally3:
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (origin);
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			g_clear_error (&_inner_error_);
#line 357 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 2461 "gkr-item.c"
		}
	}
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp18_ = *info;
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp19_ = _tmp18_.label;
#line 371 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp19_ == NULL) {
#line 2470 "gkr-item.c"
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 372 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp20_ = display;
#line 372 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp21_ = g_strdup (_tmp20_);
#line 372 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 372 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp21_;
#line 2481 "gkr-item.c"
	}
#line 373 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp22_ = origin;
#line 373 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp22_ != NULL) {
#line 2487 "gkr-item.c"
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 374 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp23_ = origin;
#line 374 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) (-1));
#line 374 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 374 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp24_;
#line 2498 "gkr-item.c"
	} else {
		gchar* _tmp25_ = NULL;
#line 376 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp25_ = g_strdup ("");
#line 376 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 376 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp25_;
#line 2507 "gkr-item.c"
	}
#line 349 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (origin);
#line 2511 "gkr-item.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2524 "gkr-item.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2554 "gkr-item.c"
				goto __catch4_g_regex_error;
			}
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 2563 "gkr-item.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2579 "gkr-item.c"
				goto __catch4_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 2590 "gkr-item.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2598 "gkr-item.c"
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1246 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 2612 "gkr-item.c"
	}
	__finally4:
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return NULL;
#line 2623 "gkr-item.c"
	}
}


gchar* seahorse_gkr_decode_telepathy_id (const gchar* account) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 379 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (account != NULL, NULL);
#line 380 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = account;
#line 380 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = string_replace (_tmp0_, "_", "%");
#line 380 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _tmp1_;
#line 380 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (_tmp2_);
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = account;
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = g_uri_unescape_string (_tmp3_, NULL);
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp4_;
#line 381 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 2653 "gkr-item.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 918 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 919 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 921 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 921 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2678 "gkr-item.c"
		gchar* _tmp4_ = NULL;
#line 922 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 922 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 922 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2686 "gkr-item.c"
	} else {
#line 924 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 924 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2692 "gkr-item.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2728 "gkr-item.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2737 "gkr-item.c"
	}
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2743 "gkr-item.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2752 "gkr-item.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2758 "gkr-item.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2767 "gkr-item.c"
	} else {
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2771 "gkr-item.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 2781 "gkr-item.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 2790 "gkr-item.c"
	} else {
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 2794 "gkr-item.c"
	}
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 2818 "gkr-item.c"
}


void seahorse_gkr_empathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* account = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp9_ = FALSE;
	SeahorseGkrDisplayInfo _tmp34_ = {0};
	const gchar* _tmp35_ = NULL;
	SeahorseGkrDisplayInfo _tmp38_ = {0};
	const gchar* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
#line 384 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 388 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 388 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "account-id");
#line 388 "/data/src/seahorse/gkr/gkr-item.vala"
	account = _tmp1_;
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _ ("IM account password for ");
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 391 "/data/src/seahorse/gkr/gkr-item.vala"
	prefix = _tmp3_;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = display;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp5_ != NULL) {
#line 2855 "gkr-item.c"
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = display;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = prefix;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = g_str_has_prefix (_tmp6_, _tmp7_);
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = _tmp8_;
#line 2867 "gkr-item.c"
	} else {
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = FALSE;
#line 2871 "gkr-item.c"
	}
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp9_ = _tmp4_;
#line 393 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp9_) {
#line 2877 "gkr-item.c"
		gint len = 0;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint pos = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp10_ = prefix;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = strlen (_tmp10_);
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp12_ = _tmp11_;
#line 394 "/data/src/seahorse/gkr/gkr-item.vala"
		len = _tmp12_;
#line 395 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp13_ = display;
#line 395 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp14_ = len;
#line 395 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp15_ = string_index_of_char (_tmp13_, (gunichar) '(', (gint) _tmp14_);
#line 395 "/data/src/seahorse/gkr/gkr-item.vala"
		pos = _tmp15_;
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp16_ = pos;
#line 396 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_tmp16_ != (-1)) {
#line 2907 "gkr-item.c"
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* _tmp20_ = NULL;
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp17_ = display;
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp18_ = len;
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp19_ = pos;
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp20_ = string_slice (_tmp17_, (glong) _tmp18_, (glong) _tmp19_);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 ((*info).label);
#line 397 "/data/src/seahorse/gkr/gkr-item.vala"
			(*info).label = _tmp20_;
#line 2924 "gkr-item.c"
		}
		{
			GRegex* regex = NULL;
			GRegex* _tmp21_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			GMatchInfo* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp21_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error_);
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
			regex = _tmp21_;
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_inner_error_ != NULL) {
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2942 "gkr-item.c"
					goto __catch5_g_regex_error;
				}
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (prefix);
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (account);
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				g_clear_error (&_inner_error_);
#line 400 "/data/src/seahorse/gkr/gkr-item.vala"
				return;
#line 2955 "gkr-item.c"
			}
#line 402 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp22_ = regex;
#line 402 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp23_ = account;
#line 402 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp25_ = g_regex_match (_tmp22_, _tmp23_, G_REGEX_MATCH_ANCHORED, &_tmp24_);
#line 402 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 402 "/data/src/seahorse/gkr/gkr-item.vala"
			match = _tmp24_;
#line 402 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp25_) {
#line 2969 "gkr-item.c"
				GMatchInfo* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
#line 403 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp26_ = match;
#line 403 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp27_ = g_match_info_matches (_tmp26_);
#line 403 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_tmp27_) {
#line 2978 "gkr-item.c"
					GMatchInfo* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp28_ = match;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp29_ = g_match_info_fetch (_tmp28_, 1);
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp30_ = _tmp29_;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp31_ = seahorse_gkr_decode_telepathy_id (_tmp30_);
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 ((*info).details);
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					(*info).details = _tmp31_;
#line 404 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 (_tmp30_);
#line 2997 "gkr-item.c"
				}
			}
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_regex_unref0 (regex);
#line 3004 "gkr-item.c"
		}
		goto __finally5;
		__catch5_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			err = _inner_error_;
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_inner_error_ = NULL;
#line 407 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp32_ = err;
#line 407 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp33_ = _tmp32_->message;
#line 407 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("gkr-item.vala:407: %s", _tmp33_);
#line 408 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_error_free0 (err);
#line 408 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (prefix);
#line 408 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 408 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3030 "gkr-item.c"
		}
		__finally5:
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (prefix);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			g_clear_error (&_inner_error_);
#line 399 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3045 "gkr-item.c"
		}
	}
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp34_ = *info;
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp35_ = _tmp34_.label;
#line 412 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp35_ == NULL) {
#line 3054 "gkr-item.c"
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
#line 413 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp36_ = display;
#line 413 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 413 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 413 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp37_;
#line 3065 "gkr-item.c"
	}
#line 414 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp38_ = *info;
#line 414 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp39_ = _tmp38_.details;
#line 414 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp39_ == NULL) {
#line 3073 "gkr-item.c"
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
#line 415 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp40_ = account;
#line 415 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp41_ = g_markup_escape_text (_tmp40_, (gssize) (-1));
#line 415 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 415 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp41_;
#line 3084 "gkr-item.c"
	}
#line 384 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (prefix);
#line 384 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (account);
#line 3090 "gkr-item.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 3117 "gkr-item.c"
		gchar* _tmp4_ = NULL;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 3125 "gkr-item.c"
	} else {
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 3131 "gkr-item.c"
	}
}


void seahorse_gkr_telepathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* account = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp10_ = FALSE;
	SeahorseGkrDisplayInfo _tmp24_ = {0};
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 418 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_if_fail (info != NULL);
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = attrs;
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "account");
#line 422 "/data/src/seahorse/gkr/gkr-item.vala"
	account = _tmp1_;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = account;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp4_ != NULL) {
#line 3161 "gkr-item.c"
		const gchar* _tmp5_ = NULL;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp5_ = display;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = _tmp5_ != NULL;
#line 3167 "gkr-item.c"
	} else {
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = FALSE;
#line 3171 "gkr-item.c"
	}
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = _tmp3_;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp6_) {
#line 3177 "gkr-item.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = display;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = account;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp9_ = string_index_of (_tmp7_, _tmp8_, 0);
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = _tmp9_ != (-1);
#line 3189 "gkr-item.c"
	} else {
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = FALSE;
#line 3193 "gkr-item.c"
	}
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp10_ = _tmp2_;
#line 423 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp10_) {
#line 3199 "gkr-item.c"
		{
			GRegex* regex = NULL;
			GRegex* _tmp11_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GMatchInfo* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp11_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error_);
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
			regex = _tmp11_;
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_inner_error_ != NULL) {
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3216 "gkr-item.c"
					goto __catch6_g_regex_error;
				}
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				_g_free0 (account);
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				g_clear_error (&_inner_error_);
#line 425 "/data/src/seahorse/gkr/gkr-item.vala"
				return;
#line 3227 "gkr-item.c"
			}
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp12_ = regex;
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp13_ = account;
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp15_ = g_regex_match (_tmp12_, _tmp13_, G_REGEX_MATCH_ANCHORED, &_tmp14_);
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
			match = _tmp14_;
#line 427 "/data/src/seahorse/gkr/gkr-item.vala"
			if (_tmp15_) {
#line 3241 "gkr-item.c"
				GMatchInfo* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 428 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp16_ = match;
#line 428 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp17_ = g_match_info_matches (_tmp16_);
#line 428 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_tmp17_) {
#line 3250 "gkr-item.c"
					gchar* identifier = NULL;
					GMatchInfo* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
#line 429 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp18_ = match;
#line 429 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp19_ = g_match_info_fetch (_tmp18_, 1);
#line 429 "/data/src/seahorse/gkr/gkr-item.vala"
					identifier = _tmp19_;
#line 430 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp20_ = identifier;
#line 430 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp21_ = seahorse_gkr_decode_telepathy_id (_tmp20_);
#line 430 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 ((*info).label);
#line 430 "/data/src/seahorse/gkr/gkr-item.vala"
					(*info).label = _tmp21_;
#line 428 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 (identifier);
#line 3272 "gkr-item.c"
				}
			}
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_match_info_free0 (match);
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_regex_unref0 (regex);
#line 3279 "gkr-item.c"
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			err = _inner_error_;
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_inner_error_ = NULL;
#line 434 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp22_ = err;
#line 434 "/data/src/seahorse/gkr/gkr-item.vala"
			_tmp23_ = _tmp22_->message;
#line 434 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("gkr-item.vala:434: %s", _tmp23_);
#line 435 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_error_free0 (err);
#line 435 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 435 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3303 "gkr-item.c"
		}
		__finally6:
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
		if (_inner_error_ != NULL) {
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			_g_free0 (account);
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			g_clear_error (&_inner_error_);
#line 424 "/data/src/seahorse/gkr/gkr-item.vala"
			return;
#line 3316 "gkr-item.c"
		}
	}
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp24_ = *info;
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp25_ = _tmp24_.label;
#line 439 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp25_ == NULL) {
#line 3325 "gkr-item.c"
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
#line 440 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp26_ = display;
#line 440 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 440 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).label);
#line 440 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).label = _tmp27_;
#line 3336 "gkr-item.c"
	}
#line 441 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp28_ = account;
#line 441 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp28_ != NULL) {
#line 3342 "gkr-item.c"
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 442 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp29_ = account;
#line 442 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp30_ = g_markup_escape_text (_tmp29_, (gssize) (-1));
#line 442 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 ((*info).details);
#line 442 "/data/src/seahorse/gkr/gkr-item.vala"
		(*info).details = _tmp30_;
#line 3353 "gkr-item.c"
	}
#line 418 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 (account);
#line 3357 "gkr-item.c"
}


void seahorse_gkr_mapping_entry_copy (const SeahorseGkrMappingEntry* self, SeahorseGkrMappingEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = (*self).item_type;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).item_type);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).item_type = _tmp1_;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = (*self).mapped_type;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).mapped_type);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).mapped_type = _tmp3_;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp4_ = (*self).match_attribute;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).match_attribute);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).match_attribute = _tmp5_;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp6_ = (*self).match_pattern;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*dest).match_pattern);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	(*dest).match_pattern = _tmp7_;
#line 3402 "gkr-item.c"
}


void seahorse_gkr_mapping_entry_destroy (SeahorseGkrMappingEntry* self) {
#line 461 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).item_type);
#line 462 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).mapped_type);
#line 463 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).match_attribute);
#line 464 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_free0 ((*self).match_pattern);
#line 3415 "gkr-item.c"
}


SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self) {
	SeahorseGkrMappingEntry* dup;
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	dup = g_new0 (SeahorseGkrMappingEntry, 1);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_mapping_entry_copy (self, dup);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	return dup;
#line 3427 "gkr-item.c"
}


void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self) {
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_mapping_entry_destroy (self);
#line 460 "/data/src/seahorse/gkr/gkr-item.vala"
	g_free (self);
#line 3436 "gkr-item.c"
}


GType seahorse_gkr_mapping_entry_get_type (void) {
	static volatile gsize seahorse_gkr_mapping_entry_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_mapping_entry_type_id__volatile)) {
		GType seahorse_gkr_mapping_entry_type_id;
		seahorse_gkr_mapping_entry_type_id = g_boxed_type_register_static ("SeahorseGkrMappingEntry", (GBoxedCopyFunc) seahorse_gkr_mapping_entry_dup, (GBoxedFreeFunc) seahorse_gkr_mapping_entry_free);
		g_once_init_leave (&seahorse_gkr_mapping_entry_type_id__volatile, seahorse_gkr_mapping_entry_type_id);
	}
	return seahorse_gkr_mapping_entry_type_id__volatile;
}


gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type, GHashTable* attrs) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
#line 480 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = item_type;
#line 480 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp0_ == NULL) {
#line 3461 "gkr-item.c"
		gchar* _tmp1_ = NULL;
#line 481 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = g_strdup (SEAHORSE_GKR_GENERIC_SECRET);
#line 481 "/data/src/seahorse/gkr/gkr-item.vala"
		result = _tmp1_;
#line 481 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3469 "gkr-item.c"
	}
#line 482 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = attrs;
#line 482 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ == NULL) {
#line 3475 "gkr-item.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = item_type;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
		result = _tmp4_;
#line 483 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3486 "gkr-item.c"
	}
	{
		SeahorseGkrMappingEntry* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
		mapping_collection = SEAHORSE_GKR_MAPPING_ENTRIES;
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
		mapping_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES);
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
		for (mapping_it = 0; mapping_it < G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES); mapping_it = mapping_it + 1) {
#line 3499 "gkr-item.c"
			SeahorseGkrMappingEntry mapping = {0};
#line 485 "/data/src/seahorse/gkr/gkr-item.vala"
			mapping = mapping_collection[mapping_it];
#line 3503 "gkr-item.c"
			{
				const gchar* _tmp5_ = NULL;
				SeahorseGkrMappingEntry _tmp6_ = {0};
				const gchar* _tmp7_ = NULL;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp5_ = item_type;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp6_ = mapping;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
				_tmp7_ = _tmp6_.item_type;
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
				if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 3516 "gkr-item.c"
					gchar* value = NULL;
					GHashTable* _tmp8_ = NULL;
					SeahorseGkrMappingEntry _tmp9_ = {0};
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp8_ = attrs;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp9_ = mapping;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp10_ = _tmp9_.match_attribute;
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp11_ = seahorse_gkr_get_attribute_string (_tmp8_, _tmp10_);
#line 487 "/data/src/seahorse/gkr/gkr-item.vala"
					value = _tmp11_;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp13_ = value;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp13_ != NULL) {
#line 3539 "gkr-item.c"
						SeahorseGkrMappingEntry _tmp14_ = {0};
						const gchar* _tmp15_ = NULL;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp14_ = mapping;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp15_ = _tmp14_.match_pattern;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp12_ = _tmp15_ != NULL;
#line 3548 "gkr-item.c"
					} else {
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp12_ = FALSE;
#line 3552 "gkr-item.c"
					}
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
					_tmp16_ = _tmp12_;
#line 488 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_tmp16_) {
#line 3558 "gkr-item.c"
						SeahorseGkrMappingEntry _tmp17_ = {0};
						const gchar* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						gboolean _tmp20_ = FALSE;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp17_ = mapping;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp18_ = _tmp17_.match_pattern;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp19_ = value;
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp20_ = g_pattern_match_simple (_tmp18_, _tmp19_);
#line 489 "/data/src/seahorse/gkr/gkr-item.vala"
						if (_tmp20_) {
#line 3573 "gkr-item.c"
							SeahorseGkrMappingEntry _tmp21_ = {0};
							const gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
#line 490 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp21_ = mapping;
#line 490 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp22_ = _tmp21_.mapped_type;
#line 490 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp23_ = g_strdup (_tmp22_);
#line 490 "/data/src/seahorse/gkr/gkr-item.vala"
							result = _tmp23_;
#line 490 "/data/src/seahorse/gkr/gkr-item.vala"
							_g_free0 (value);
#line 490 "/data/src/seahorse/gkr/gkr-item.vala"
							return result;
#line 3589 "gkr-item.c"
						}
					} else {
						const gchar* _tmp24_ = NULL;
#line 491 "/data/src/seahorse/gkr/gkr-item.vala"
						_tmp24_ = value;
#line 491 "/data/src/seahorse/gkr/gkr-item.vala"
						if (_tmp24_ != NULL) {
#line 3597 "gkr-item.c"
							SeahorseGkrMappingEntry _tmp25_ = {0};
							const gchar* _tmp26_ = NULL;
							gchar* _tmp27_ = NULL;
#line 492 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp25_ = mapping;
#line 492 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp26_ = _tmp25_.mapped_type;
#line 492 "/data/src/seahorse/gkr/gkr-item.vala"
							_tmp27_ = g_strdup (_tmp26_);
#line 492 "/data/src/seahorse/gkr/gkr-item.vala"
							result = _tmp27_;
#line 492 "/data/src/seahorse/gkr/gkr-item.vala"
							_g_free0 (value);
#line 492 "/data/src/seahorse/gkr/gkr-item.vala"
							return result;
#line 3613 "gkr-item.c"
						}
					}
#line 486 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_free0 (value);
#line 3618 "gkr-item.c"
				}
			}
		}
	}
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp28_ = item_type;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp29_;
#line 497 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3631 "gkr-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3638 "gkr-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	g_list_free (self);
#line 3647 "gkr-item.c"
}


static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent) {
	SeahorseGkrItemDeleter * self;
	GtkDialog* result = NULL;
	guint num = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
#line 503 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_items;
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 504 "/data/src/seahorse/gkr/gkr-item.vala"
	num = _tmp1_;
#line 505 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = num;
#line 505 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_tmp2_ == ((guint) 1)) {
#line 3670 "gkr-item.c"
		gchar* label = NULL;
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GtkWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		SeahorseDeleteDialog* _tmp10_ = NULL;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp3_ = self->priv->_items;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp4_ = _tmp3_->data;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST ((SeahorseGkrItem*) _tmp4_, secret_item_get_type (), SecretItem), "label", &_tmp5_, NULL);
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp6_ = _tmp5_;
#line 506 "/data/src/seahorse/gkr/gkr-item.vala"
		label = _tmp6_;
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp7_ = parent;
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp8_ = _ ("Are you sure you want to delete the password '%s'?");
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp9_ = label;
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp10_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp7_, _tmp8_, _tmp9_, NULL);
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_ref_sink (_tmp10_);
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		result = (GtkDialog*) _tmp10_;
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		_g_free0 (label);
#line 507 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3706 "gkr-item.c"
	} else {
		GtkWindow* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		const gchar* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		SeahorseDeleteDialog* _tmp15_ = NULL;
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp11_ = parent;
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp12_ = num;
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp13_ = ngettext ("Are you sure you want to delete %d password?", "Are you sure you want to delete %d passwords?", (gulong) _tmp12_);
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp14_ = num;
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp15_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp11_, _tmp13_, _tmp14_, NULL);
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		g_object_ref_sink (_tmp15_);
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		result = (GtkDialog*) _tmp15_;
#line 509 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3729 "gkr-item.c"
	}
}


SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type, SeahorseGkrItem* item) {
	SeahorseGkrItemDeleter * self = NULL;
	SeahorseGkrItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 514 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 514 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) seahorse_deleter_construct (object_type);
#line 515 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = item;
#line 515 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) _tmp0_);
#line 515 "/data/src/seahorse/gkr/gkr-item.vala"
	if (!_tmp1_) {
#line 516 "/data/src/seahorse/gkr/gkr-item.vala"
		g_assert_not_reached ();
#line 3750 "gkr-item.c"
	}
#line 514 "/data/src/seahorse/gkr/gkr-item.vala"
	return self;
#line 3754 "gkr-item.c"
}


SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item) {
#line 514 "/data/src/seahorse/gkr/gkr-item.vala"
	return seahorse_gkr_item_deleter_construct (SEAHORSE_GKR_TYPE_ITEM_DELETER, item);
#line 3761 "gkr-item.c"
}


static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base) {
	SeahorseGkrItemDeleter * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
#line 519 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 520 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = self->priv->_items;
#line 520 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _tmp0_;
#line 520 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3777 "gkr-item.c"
}


static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base, GObject* obj) {
	SeahorseGkrItemDeleter * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
#line 523 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 523 "/data/src/seahorse/gkr/gkr-item.vala"
	g_return_val_if_fail (obj != NULL, FALSE);
#line 524 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = obj;
#line 524 "/data/src/seahorse/gkr/gkr-item.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_ITEM)) {
#line 3793 "gkr-item.c"
		GObject* _tmp1_ = NULL;
		SeahorseGkrItem* _tmp2_ = NULL;
#line 525 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp1_ = obj;
#line 525 "/data/src/seahorse/gkr/gkr-item.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
#line 525 "/data/src/seahorse/gkr/gkr-item.vala"
		self->priv->_items = g_list_append (self->priv->_items, _tmp2_);
#line 526 "/data/src/seahorse/gkr/gkr-item.vala"
		result = TRUE;
#line 526 "/data/src/seahorse/gkr/gkr-item.vala"
		return result;
#line 3806 "gkr-item.c"
	}
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	result = FALSE;
#line 528 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3812 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data) {
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = _data;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->self);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	g_slice_free (SeahorseGkrItemDeleterDeleteData, _data_);
#line 3825 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrItemDeleter * self;
	SeahorseGkrItemDeleterDeleteData* _data_;
	SeahorseGkrItemDeleter* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	self = (SeahorseGkrItemDeleter*) base;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_slice_new0 (SeahorseGkrItemDeleterDeleteData);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_item_deleter_real_delete);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_item_deleter_real_delete_data_free);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->self = _tmp0_;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp1_ = cancellable;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_object_unref0 (_data_->cancellable);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->cancellable = _tmp2_;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_deleter_real_delete_co (_data_);
#line 3857 "gkr-item.c"
}


static gboolean seahorse_gkr_item_deleter_real_delete_finish (SeahorseDeleter* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrItemDeleterDeleteData* _data_;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
		return FALSE;
#line 3868 "gkr-item.c"
	}
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	result = _data_->result;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	return result;
#line 3876 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrItemDeleterDeleteData* _data_;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_ = _user_data_;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_source_object_ = source_object;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_res_ = _res_;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_deleter_real_delete_co (_data_);
#line 3890 "gkr-item.c"
}


static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_) {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	switch (_data_->_state_) {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
		case 0:
#line 3899 "gkr-item.c"
		goto _state_0;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
		case 1:
#line 3903 "gkr-item.c"
		goto _state_1;
		default:
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
		g_assert_not_reached ();
#line 3908 "gkr-item.c"
	}
	_state_0:
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = NULL;
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp0_ = _data_->self->priv->_items;
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = NULL;
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp1_ = g_list_copy (_data_->_tmp0_);
#line 532 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->items = _data_->_tmp1_;
#line 533 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = NULL;
#line 533 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->_tmp2_ = _data_->items;
#line 3925 "gkr-item.c"
	{
#line 533 "/data/src/seahorse/gkr/gkr-item.vala"
		_data_->item_collection = _data_->_tmp2_;
#line 533 "/data/src/seahorse/gkr/gkr-item.vala"
		for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
#line 533 "/data/src/seahorse/gkr/gkr-item.vala"
			_data_->item = (SeahorseGkrItem*) _data_->item_it->data;
#line 3933 "gkr-item.c"
			{
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp3_ = NULL;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp3_ = _data_->item;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp4_ = NULL;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_tmp4_ = _data_->cancellable;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				_data_->_state_ = 1;
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				secret_item_delete ((SecretItem*) _data_->_tmp3_, _data_->_tmp4_, seahorse_gkr_item_deleter_delete_ready, _data_);
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				return FALSE;
#line 3949 "gkr-item.c"
				_state_1:
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				secret_item_delete_finish ((SecretItem*) _data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
				if (_data_->_inner_error_ != NULL) {
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
					g_error_free (_data_->_inner_error_);
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
					_g_list_free0 (_data_->items);
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
					if (_data_->_state_ == 0) {
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3965 "gkr-item.c"
					} else {
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3969 "gkr-item.c"
					}
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
					g_object_unref (_data_->_async_result);
#line 534 "/data/src/seahorse/gkr/gkr-item.vala"
					return FALSE;
#line 3975 "gkr-item.c"
				}
			}
		}
	}
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
	_data_->result = TRUE;
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_list_free0 (_data_->items);
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3988 "gkr-item.c"
	} else {
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3992 "gkr-item.c"
	}
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 535 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	_g_list_free0 (_data_->items);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	if (_data_->_state_ == 0) {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4004 "gkr-item.c"
	} else {
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4008 "gkr-item.c"
	}
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	g_object_unref (_data_->_async_result);
#line 531 "/data/src/seahorse/gkr/gkr-item.vala"
	return FALSE;
#line 4014 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_class_init (SeahorseGkrItemDeleterClass * klass) {
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	seahorse_gkr_item_deleter_parent_class = g_type_class_peek_parent (klass);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemDeleterPrivate));
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->create_confirm = seahorse_gkr_item_deleter_real_create_confirm;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->get_objects = seahorse_gkr_item_deleter_real_get_objects;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->add_object = seahorse_gkr_item_deleter_real_add_object;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->delete = seahorse_gkr_item_deleter_real_delete;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	SEAHORSE_DELETER_CLASS (klass)->delete_finish = seahorse_gkr_item_deleter_real_delete_finish;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_deleter_finalize;
#line 4035 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_instance_init (SeahorseGkrItemDeleter * self) {
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	self->priv = SEAHORSE_GKR_ITEM_DELETER_GET_PRIVATE (self);
#line 4042 "gkr-item.c"
}


static void seahorse_gkr_item_deleter_finalize (GObject* obj) {
	SeahorseGkrItemDeleter * self;
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter);
#line 501 "/data/src/seahorse/gkr/gkr-item.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_items);
#line 500 "/data/src/seahorse/gkr/gkr-item.vala"
	G_OBJECT_CLASS (seahorse_gkr_item_deleter_parent_class)->finalize (obj);
#line 4054 "gkr-item.c"
}


GType seahorse_gkr_item_deleter_get_type (void) {
	static volatile gsize seahorse_gkr_item_deleter_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_deleter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemDeleter), 0, (GInstanceInitFunc) seahorse_gkr_item_deleter_instance_init, NULL };
		GType seahorse_gkr_item_deleter_type_id;
		seahorse_gkr_item_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseGkrItemDeleter", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_item_deleter_type_id__volatile, seahorse_gkr_item_deleter_type_id);
	}
	return seahorse_gkr_item_deleter_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



