// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_4_0_autogen.cpp:
//   Defines the GL 4.0 entry points.

#include "libGL/entry_points_gl_4_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL4_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BeginQueryIndexed(GLenum target, GLuint index, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BeginQueryIndexed, "glBeginQueryIndexed",
          "context = %d, target = %s, index = %u, id = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), index, id);

    if (context)
    {
        QueryID idPacked                                      = FromGL<QueryID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBeginQueryIndexed(context, target, index, idPacked));
        if (isCallValid)
        {
            context->beginQueryIndexed(target, index, idPacked);
        }
        ANGLE_CAPTURE(BeginQueryIndexed, isCallValid, context, target, index, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindTransformFeedback(GLenum target, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindTransformFeedback, "glBindTransformFeedback",
          "context = %d, target = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::BindTransformFeedbackTarget, target), id);

    if (context)
    {
        TransformFeedbackID idPacked                          = FromGL<TransformFeedbackID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindTransformFeedback(context, target, idPacked));
        if (isCallValid)
        {
            context->bindTransformFeedback(target, idPacked);
        }
        ANGLE_CAPTURE(BindTransformFeedback, isCallValid, context, target, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendEquationSeparatei, "glBlendEquationSeparatei",
          "context = %d, buf = %u, modeRGB = %s, modeAlpha = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparatei(context, buf, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparatei(buf, modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparatei, isCallValid, context, buf, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlendEquationi(GLuint buf, GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendEquationi, "glBlendEquationi",
          "context = %d, buf = %u, mode = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendEquationModeEXT, mode));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendEquationi(context, buf, mode));
        if (isCallValid)
        {
            context->blendEquationi(buf, mode);
        }
        ANGLE_CAPTURE(BlendEquationi, isCallValid, context, buf, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
BlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendFuncSeparatei, "glBlendFuncSeparatei",
          "context = %d, buf = %u, srcRGB = %s, dstRGB = %s, srcAlpha = %s, dstAlpha = %s",
          CID(context), buf, GLenumToString(GLenumGroup::BlendingFactor, srcRGB),
          GLenumToString(GLenumGroup::BlendingFactor, dstRGB),
          GLenumToString(GLenumGroup::BlendingFactor, srcAlpha),
          GLenumToString(GLenumGroup::BlendingFactor, dstAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateBlendFuncSeparatei(context, buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
        if (isCallValid)
        {
            context->blendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
        }
        ANGLE_CAPTURE(BlendFuncSeparatei, isCallValid, context, buf, srcRGB, dstRGB, srcAlpha,
                      dstAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BlendFunci(GLuint buf, GLenum src, GLenum dst)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BlendFunci, "glBlendFunci",
          "context = %d, buf = %u, src = %s, dst = %s", CID(context), buf,
          GLenumToString(GLenumGroup::BlendingFactor, src),
          GLenumToString(GLenumGroup::BlendingFactor, dst));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBlendFunci(context, buf, src, dst));
        if (isCallValid)
        {
            context->blendFunci(buf, src, dst);
        }
        ANGLE_CAPTURE(BlendFunci, isCallValid, context, buf, src, dst);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DeleteTransformFeedbacks(GLsizei n, const GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DeleteTransformFeedbacks, "glDeleteTransformFeedbacks",
          "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context), n, (uintptr_t)ids);

    if (context)
    {
        const TransformFeedbackID *idsPacked = FromGL<const TransformFeedbackID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteTransformFeedbacks(context, n, idsPacked));
        if (isCallValid)
        {
            context->deleteTransformFeedbacks(n, idsPacked);
        }
        ANGLE_CAPTURE(DeleteTransformFeedbacks, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawArraysIndirect(GLenum mode, const void *indirect)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawArraysIndirect, "glDrawArraysIndirect",
          "context = %d, mode = %s, indirect = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), (uintptr_t)indirect);

    if (context)
    {
        PrimitiveMode modePacked                              = FromGL<PrimitiveMode>(mode);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawArraysIndirect(context, modePacked, indirect));
        if (isCallValid)
        {
            context->drawArraysIndirect(modePacked, indirect);
        }
        ANGLE_CAPTURE(DrawArraysIndirect, isCallValid, context, modePacked, indirect);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawElementsIndirect(GLenum mode, GLenum type, const void *indirect)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawElementsIndirect, "glDrawElementsIndirect",
          "context = %d, mode = %s, type = %s, indirect = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode),
          GLenumToString(GLenumGroup::DrawElementsType, type), (uintptr_t)indirect);

    if (context)
    {
        PrimitiveMode modePacked                              = FromGL<PrimitiveMode>(mode);
        DrawElementsType typePacked                           = FromGL<DrawElementsType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateDrawElementsIndirect(context, modePacked, typePacked, indirect));
        if (isCallValid)
        {
            context->drawElementsIndirect(modePacked, typePacked, indirect);
        }
        ANGLE_CAPTURE(DrawElementsIndirect, isCallValid, context, modePacked, typePacked, indirect);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawTransformFeedback(GLenum mode, GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawTransformFeedback, "glDrawTransformFeedback",
          "context = %d, mode = %s, id = %u", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), id);

    if (context)
    {
        TransformFeedbackID idPacked                          = FromGL<TransformFeedbackID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDrawTransformFeedback(context, mode, idPacked));
        if (isCallValid)
        {
            context->drawTransformFeedback(mode, idPacked);
        }
        ANGLE_CAPTURE(DrawTransformFeedback, isCallValid, context, mode, idPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DrawTransformFeedbackStream, "glDrawTransformFeedbackStream",
          "context = %d, mode = %s, id = %u, stream = %u", CID(context),
          GLenumToString(GLenumGroup::PrimitiveType, mode), id, stream);

    if (context)
    {
        TransformFeedbackID idPacked                          = FromGL<TransformFeedbackID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDrawTransformFeedbackStream(context, mode, idPacked, stream));
        if (isCallValid)
        {
            context->drawTransformFeedbackStream(mode, idPacked, stream);
        }
        ANGLE_CAPTURE(DrawTransformFeedbackStream, isCallValid, context, mode, idPacked, stream);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY EndQueryIndexed(GLenum target, GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::EndQueryIndexed, "glEndQueryIndexed",
          "context = %d, target = %s, index = %u", CID(context),
          GLenumToString(GLenumGroup::QueryTarget, target), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEndQueryIndexed(context, target, index));
        if (isCallValid)
        {
            context->endQueryIndexed(target, index);
        }
        ANGLE_CAPTURE(EndQueryIndexed, isCallValid, context, target, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenTransformFeedbacks(GLsizei n, GLuint *ids)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenTransformFeedbacks, "glGenTransformFeedbacks",
          "context = %d, n = %d, ids = 0x%016" PRIxPTR "", CID(context), n, (uintptr_t)ids);

    if (context)
    {
        TransformFeedbackID *idsPacked                        = FromGL<TransformFeedbackID *>(ids);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenTransformFeedbacks(context, n, idsPacked));
        if (isCallValid)
        {
            context->genTransformFeedbacks(n, idsPacked);
        }
        ANGLE_CAPTURE(GenTransformFeedbacks, isCallValid, context, n, idsPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetActiveSubroutineName(GLuint program,
                                         GLenum shadertype,
                                         GLuint index,
                                         GLsizei bufsize,
                                         GLsizei *length,
                                         GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetActiveSubroutineName, "glGetActiveSubroutineName",
          "context = %d, program = %u, shadertype = %s, index = %u, bufsize = %d, length = "
          "0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ShaderType, shadertype), index,
          bufsize, (uintptr_t)length, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveSubroutineName(context, programPacked, shadertype,
                                                            index, bufsize, length, name));
        if (isCallValid)
        {
            context->getActiveSubroutineName(programPacked, shadertype, index, bufsize, length,
                                             name);
        }
        ANGLE_CAPTURE(GetActiveSubroutineName, isCallValid, context, programPacked, shadertype,
                      index, bufsize, length, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetActiveSubroutineUniformName(GLuint program,
                                                GLenum shadertype,
                                                GLuint index,
                                                GLsizei bufsize,
                                                GLsizei *length,
                                                GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetActiveSubroutineUniformName,
          "glGetActiveSubroutineUniformName",
          "context = %d, program = %u, shadertype = %s, index = %u, bufsize = %d, length = "
          "0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ShaderType, shadertype), index,
          bufsize, (uintptr_t)length, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveSubroutineUniformName(
                                context, programPacked, shadertype, index, bufsize, length, name));
        if (isCallValid)
        {
            context->getActiveSubroutineUniformName(programPacked, shadertype, index, bufsize,
                                                    length, name);
        }
        ANGLE_CAPTURE(GetActiveSubroutineUniformName, isCallValid, context, programPacked,
                      shadertype, index, bufsize, length, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetActiveSubroutineUniformiv(GLuint program,
                                              GLenum shadertype,
                                              GLuint index,
                                              GLenum pname,
                                              GLint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetActiveSubroutineUniformiv, "glGetActiveSubroutineUniformiv",
          "context = %d, program = %u, shadertype = %s, index = %u, pname = %s, values = "
          "0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ShaderType, shadertype), index,
          GLenumToString(GLenumGroup::SubroutineParameterName, pname), (uintptr_t)values);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveSubroutineUniformiv(context, programPacked, shadertype,
                                                                 index, pname, values));
        if (isCallValid)
        {
            context->getActiveSubroutineUniformiv(programPacked, shadertype, index, pname, values);
        }
        ANGLE_CAPTURE(GetActiveSubroutineUniformiv, isCallValid, context, programPacked, shadertype,
                      index, pname, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetProgramStageiv, "glGetProgramStageiv",
          "context = %d, program = %u, shadertype = %s, pname = %s, values = 0x%016" PRIxPTR "",
          CID(context), program, GLenumToString(GLenumGroup::ShaderType, shadertype),
          GLenumToString(GLenumGroup::ProgramStagePName, pname), (uintptr_t)values);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramStageiv(context, programPacked, shadertype, pname, values));
        if (isCallValid)
        {
            context->getProgramStageiv(programPacked, shadertype, pname, values);
        }
        ANGLE_CAPTURE(GetProgramStageiv, isCallValid, context, programPacked, shadertype, pname,
                      values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetQueryIndexediv, "glGetQueryIndexediv",
          "context = %d, target = %s, index = %u, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::DefaultGroup, target), index,
          GLenumToString(GLenumGroup::QueryParameterName, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetQueryIndexediv(context, target, index, pname, params));
        if (isCallValid)
        {
            context->getQueryIndexediv(target, index, pname, params);
        }
        ANGLE_CAPTURE(GetQueryIndexediv, isCallValid, context, target, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSubroutineIndex, "glGetSubroutineIndex",
          "context = %d, program = %u, shadertype = %s, name = 0x%016" PRIxPTR "", CID(context),
          program, GLenumToString(GLenumGroup::ShaderType, shadertype), (uintptr_t)name);

    GLuint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetSubroutineIndex(context, programPacked, shadertype, name));
        if (isCallValid)
        {
            returnValue = context->getSubroutineIndex(programPacked, shadertype, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetSubroutineIndex, GLuint>();
        }
        ANGLE_CAPTURE(GetSubroutineIndex, isCallValid, context, programPacked, shadertype, name,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::GetSubroutineIndex, GLuint>();
    }
    return returnValue;
}

GLint GL_APIENTRY GetSubroutineUniformLocation(GLuint program,
                                               GLenum shadertype,
                                               const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetSubroutineUniformLocation, "glGetSubroutineUniformLocation",
          "context = %d, program = %u, shadertype = %s, name = 0x%016" PRIxPTR "", CID(context),
          program, GLenumToString(GLenumGroup::ShaderType, shadertype), (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetSubroutineUniformLocation(context, programPacked, shadertype, name));
        if (isCallValid)
        {
            returnValue = context->getSubroutineUniformLocation(programPacked, shadertype, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::GetSubroutineUniformLocation, GLint>();
        }
        ANGLE_CAPTURE(GetSubroutineUniformLocation, isCallValid, context, programPacked, shadertype,
                      name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::GetSubroutineUniformLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetUniformSubroutineuiv, "glGetUniformSubroutineuiv",
          "context = %d, shadertype = %s, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ShaderType, shadertype), location, (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformSubroutineuiv(context, shadertype, location, params));
        if (isCallValid)
        {
            context->getUniformSubroutineuiv(shadertype, location, params);
        }
        ANGLE_CAPTURE(GetUniformSubroutineuiv, isCallValid, context, shadertype, location, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetUniformdv(GLuint program, GLint location, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetUniformdv, "glGetUniformdv",
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformdv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformdv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformdv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY IsTransformFeedback(GLuint id)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsTransformFeedback, "glIsTransformFeedback",
          "context = %d, id = %u", CID(context), id);

    GLboolean returnValue;
    if (context)
    {
        TransformFeedbackID idPacked                          = FromGL<TransformFeedbackID>(id);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsTransformFeedback(context, idPacked));
        if (isCallValid)
        {
            returnValue = context->isTransformFeedback(idPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsTransformFeedback, GLboolean>();
        }
        ANGLE_CAPTURE(IsTransformFeedback, isCallValid, context, idPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsTransformFeedback, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY MinSampleShading(GLfloat value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::MinSampleShading, "glMinSampleShading",
          "context = %d, value = %f", CID(context), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateMinSampleShading(context, value));
        if (isCallValid)
        {
            context->minSampleShading(value);
        }
        ANGLE_CAPTURE(MinSampleShading, isCallValid, context, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PatchParameterfv(GLenum pname, const GLfloat *values)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PatchParameterfv, "glPatchParameterfv",
          "context = %d, pname = %s, values = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), (uintptr_t)values);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameterfv(context, pname, values));
        if (isCallValid)
        {
            context->patchParameterfv(pname, values);
        }
        ANGLE_CAPTURE(PatchParameterfv, isCallValid, context, pname, values);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PatchParameteri(GLenum pname, GLint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PatchParameteri, "glPatchParameteri",
          "context = %d, pname = %s, value = %d", CID(context),
          GLenumToString(GLenumGroup::PatchParameterName, pname), value);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidatePatchParameteri(context, pname, value));
        if (isCallValid)
        {
            context->patchParameteri(pname, value);
        }
        ANGLE_CAPTURE(PatchParameteri, isCallValid, context, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY PauseTransformFeedback()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::PauseTransformFeedback, "glPauseTransformFeedback",
          "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidatePauseTransformFeedback(context));
        if (isCallValid)
        {
            context->pauseTransformFeedback();
        }
        ANGLE_CAPTURE(PauseTransformFeedback, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ResumeTransformFeedback()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ResumeTransformFeedback, "glResumeTransformFeedback",
          "context = %d", CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateResumeTransformFeedback(context));
        if (isCallValid)
        {
            context->resumeTransformFeedback();
        }
        ANGLE_CAPTURE(ResumeTransformFeedback, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform1d(GLint location, GLdouble x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform1d, "glUniform1d", "context = %d, location = %d, x = %f",
          CID(context), location, x);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1d(context, locationPacked, x));
        if (isCallValid)
        {
            context->uniform1d(locationPacked, x);
        }
        ANGLE_CAPTURE(Uniform1d, isCallValid, context, locationPacked, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform1dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform1dv, "glUniform1dv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform1dv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform1dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform1dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform2d(GLint location, GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform2d, "glUniform2d",
          "context = %d, location = %d, x = %f, y = %f", CID(context), location, x, y);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2d(context, locationPacked, x, y));
        if (isCallValid)
        {
            context->uniform2d(locationPacked, x, y);
        }
        ANGLE_CAPTURE(Uniform2d, isCallValid, context, locationPacked, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform2dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform2dv, "glUniform2dv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform2dv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform2dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform2dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform3d, "glUniform3d",
          "context = %d, location = %d, x = %f, y = %f, z = %f", CID(context), location, x, y, z);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3d(context, locationPacked, x, y, z));
        if (isCallValid)
        {
            context->uniform3d(locationPacked, x, y, z);
        }
        ANGLE_CAPTURE(Uniform3d, isCallValid, context, locationPacked, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform3dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform3dv, "glUniform3dv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform3dv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform3dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform3dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform4d, "glUniform4d",
          "context = %d, location = %d, x = %f, y = %f, z = %f, w = %f", CID(context), location, x,
          y, z, w);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform4d(context, locationPacked, x, y, z, w));
        if (isCallValid)
        {
            context->uniform4d(locationPacked, x, y, z, w);
        }
        ANGLE_CAPTURE(Uniform4d, isCallValid, context, locationPacked, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY Uniform4dv(GLint location, GLsizei count, const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::Uniform4dv, "glUniform4dv",
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4dv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform4dv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform4dv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix2dv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix2dv, "glUniformMatrix2dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix2x3dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix2x3dv, "glUniformMatrix2x3dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2x3dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x3dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2x3dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix2x4dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix2x4dv, "glUniformMatrix2x4dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2x4dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x4dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2x4dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix3dv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix3dv, "glUniformMatrix3dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix3x2dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix3x2dv, "glUniformMatrix3x2dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3x2dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3x2dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3x2dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix3x4dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix3x4dv, "glUniformMatrix3x4dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3x4dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3x4dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3x4dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix4dv(GLint location,
                                  GLsizei count,
                                  GLboolean transpose,
                                  const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix4dv, "glUniformMatrix4dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix4x2dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix4x2dv, "glUniformMatrix4x2dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4x2dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4x2dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4x2dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformMatrix4x3dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformMatrix4x3dv, "glUniformMatrix4x3dv",
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4x3dv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4x3dv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4x3dv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UniformSubroutinesuiv, "glUniformSubroutinesuiv",
          "context = %d, shadertype = %s, count = %d, indices = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ShaderType, shadertype), count, (uintptr_t)indices);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniformSubroutinesuiv(context, shadertype, count, indices));
        if (isCallValid)
        {
            context->uniformSubroutinesuiv(shadertype, count, indices);
        }
        ANGLE_CAPTURE(UniformSubroutinesuiv, isCallValid, context, shadertype, count, indices);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}
}  // namespace gl
