/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_pmgr_h__
#define __ls10_dev_pmgr_h__
/* This file is autogenerated.  Do not edit */
#define NV_PMGR_ALL                           0x003FFFFF:0x0000D000 /* RW--D */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK(i)                             (0x0000D7A0 + (i)*0x4) /* RW-4A */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK__SIZE_1                                            10 /*       */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_READ_PROTECTION                                   3:0 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_READ_PROTECTION_ALL_LEVELS_ENABLED         0x0000000F /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION                                  7:4 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION__FUSE_SIGNAL            "opt_secure_pmgr_i2cx_wr_secure" /*       */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_ALL_LEVELS_ENABLED_FUSE0  0x0000000F /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL1_ENABLED_FUSE1      0x0000000E /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL2_ENABLED_FUSE2      0x0000000C /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL3_ENABLED_FUSE3      0x00000008 /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_READ_VIOLATION                                    8:8 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_READ_VIOLATION_REPORT_ERROR                0x00000001 /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_READ_VIOLATION_SOLDIER_ON                  0x00000000 /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_VIOLATION                                   9:9 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_VIOLATION_REPORT_ERROR               0x00000001 /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_VIOLATION_SOLDIER_ON                 0x00000000 /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_READ_CONTROL                             10:10 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_READ_CONTROL_BLOCKED                0x00000001 /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_READ_CONTROL_LOWERED                0x00000000 /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_WRITE_CONTROL                            11:11 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_WRITE_CONTROL_BLOCKED               0x00000001 /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_WRITE_CONTROL_LOWERED               0x00000000 /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_ENABLE                                   31:12 /* RWIVF */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_ENABLE__FUSE_SIGNAL               "opt_secure_pmgr_i2cx_wr_secure"/*       */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_ENABLE_ALL_SOURCES_ENABLED_FUSE0    0x000FFFFF /* RWI-V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_ENABLE_INIT_FUSE1                   0x0008094F /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_ENABLE_INIT_FUSE2                   0x0008094F /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_SOURCE_ENABLE_INIT_FUSE3                   0x0008094F /* RW--V */
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0                           4:4
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_ENABLE             0x00000001
#define NV_PMGR_I2C_PRIV_LEVEL_MASK_WRITE_PROTECTION_LEVEL0_DISABLE            0x00000000
#define NV_PMGR_GPIO_INPUT_CNTL_1                           0x0000D740 /* RW-4R */
#define NV_PMGR_GPIO_INPUT_CNTL_1_PINNUM                           7:0 /* RWIVF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_PINNUM_INIT               0x00000001 /* RWI-V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_INV                              8:8 /* RWIVF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_INV_NO                    0x00000000 /* RWI-V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_INV_YES                   0x00000001 /* RW--V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_READ                             9:9 /* R--VF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_READ_0                    0x00000000 /* R---V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_READ_1                    0x00000001 /* R---V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER                  10:10 /* RWIVF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER_INIT        0x00000000 /* RWI-V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER_NO          0x00000000 /* RW--V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER_YES         0x00000001 /* RW--V */
#define NV_PMGR_GPIO_INPUT_CNTL(i)                          0x0000D740 + ((i)-1) * (0x0000D744 - 0x0000D740) /*       */
#define NV_PMGR_GPIO_INPUT_CNTL__SIZE_1                             25 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_PINNUM                             7:0 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_PINNUM_UNUSED               0x000000FF /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_INV                                8:8 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_INV_NO                      0x00000000 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_INV_YES                     0x00000001 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_READ                               9:9 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_READ_0                      0x00000000 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_READ_1                      0x00000001 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_BYPASS_FILTER                    10:10 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_BYPASS_FILTER_NO            0x00000000 /*       */
#define NV_PMGR_GPIO_INPUT_CNTL_BYPASS_FILTER_YES           0x00000001 /*       */
#endif // __ls10_dev_pmgr_h__
