/*
    Copyright (c) 2008-12 Qtrac Ltd. All rights reserved.
    This program or module is free software: you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, either version 2 of
    the License, or version 3 of the License, or (at your option) any
    later version. This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
*/

#include "mainwindow.hpp"
#include <QApplication>
#include <QTranslator>
#include <QLibraryInfo>
#include <QLocale>
#include <QTextCodec>


int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setCursorFlashTime(0);
    app.setOrganizationName("Qtrac Ltd.");
    app.setOrganizationDomain("qtrac.eu");
    app.setApplicationName("Alt_Key");
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));

    QString language = QLocale::system().name();
    const QString LanguageOption = "--language=";
    if (app.arguments().count() > 1) {
        const QString arg = app.arguments().at(1);
        if (arg.startsWith(LanguageOption))
            language = arg.mid(LanguageOption.length());
    }

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + language,
            QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);
    QTranslator appTranslator;
    appTranslator.load("alt_key_" + language, ":/");
    app.installTranslator(&appTranslator);

    MainWindow window;
    window.show();
    return app.exec();
}
