#ifndef OPTIONS_DLG
#define OPTIONS_DLG

/*
    Copyright (c) 2008-12 Qtrac Ltd. All rights reserved.
    This program or module is free software: you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, either version 2 of
    the License, or version 3 of the License, or (at your option) any
    later version. This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied
    warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
*/

#include <QDialog>

class QCheckBox;
class QLineEdit;
class QTextEdit;


class OptionsDlg : public QDialog
{
    Q_OBJECT

public:
    explicit OptionsDlg(const QString &alphabet,
            bool prompt_to_save_on_exit,
            bool restore_workspace_at_startup,
            bool load_last_file_at_startup,
            const QStringList &predefined_accelerators, QWidget *parent=0);

    QString alphabet() const { return alphabet_; }
    bool prompt_to_save_on_exit() const { return prompt_to_save_on_exit_; }
    bool restore_workspace_at_startup() const
            { return restore_workspace_at_startup_; }
    bool load_last_file_at_startup() const
            { return load_last_file_at_startup_; }
    QStringList predefined_accelerators() const
            { return predefined_accelerators_; }

private slots:
    void accept();
    void fixAlphabet(const QString &alphabet);

private:
    QLineEdit *alphabetEdit;
    QCheckBox *promptToSaveCheckBox;
    QCheckBox *restoreWorkspaceCheckBox;
    QCheckBox *loadLastFileCheckBox;
    QTextEdit *predefinedAcceleratorsText;

    QString alphabet_;
    bool prompt_to_save_on_exit_;
    bool restore_workspace_at_startup_;
    bool load_last_file_at_startup_;
    QStringList predefined_accelerators_;
};


#endif // OPTIONS_DLG
