# server.tcl
# LEG30032005
#

#### this file is not user servicable ##############################

set debug          $conf($server,debug)

if ![info exists conf($server,directoryproc)] {
    set conf($server,directoryproc) _ns_dirlist
}

if ![info exists conf($server,directorylisting)] {
    set conf($server,directorylisting) fancy
}

$ns_section ns/server/${server}/tcl
$ns_param	library		$conf($server,tcllibrary)
$ns_param	autoclose      	on 
$ns_param	debug          	$debug

$ns_section ns/server/${server} 
$ns_param   directoryfile      $conf($server,directoryfile)
$ns_param   pageroot           $conf($server,pageroot)
$ns_param   maxconnections     5
$ns_param   maxdropped         0
$ns_param   maxthreads         5
$ns_param   minthreads         5
$ns_param   threadtimeout      120
$ns_param   globalstats        false    ;# Enable built-in statistics 
$ns_param   urlstats           false    ;# Enable URL statistics 
$ns_param   maxurlstats        1000     ;# Max number of URL's to do stats on
# TODO: make it a parameter.
#$ns_param   directoryadp    [file join $pageroot dirlist.adp] ;# Choose one or the other
$ns_param   directoryproc    $conf($server,directoryproc)
$ns_param   directorylisting $conf($server,directorylisting)

# 
# ADP (AOLserver Dynamic Page) configuration 
# 
$ns_section ns/server/${server}/adp 
$ns_param   map           /*.adp    ;# Extensions to parse as ADP's 
#$ns_param   map          "/*.html" ;# Any extension can be mapped 
$ns_param   enableexpire  false     ;# Set "Expires: now" on all ADP's 
$ns_param   enabledebug   $debug    ;# Allow Tclpro debugging with "?debug"
$ns_param   defaultparser fancy

$ns_section ns/server/${server}/adp/parsers
$ns_param   fancy    ".adp"

$ns_section ns/server/${server}/redirects
#$ns_param   404                "server/file-not-found.html"
#$ns_param   403                "server/forbidden.html"

#
# Fastpath serves HTML
#
$ns_section "ns/server/${server}/fastpath"
$ns_param   cache           true      ;        # Enable cache for normal URLs
$ns_param   cachemaxentry   8192      ;        # Largest file size allowable in cache
$ns_param   cachemaxsize    [expr 5000*1024] ; # Size of fastpath cache
$ns_param   mmap            true      ;        # Use mmap() for cache
$ns_param   topdir           $conf($server,pageroot);
$ns_param   directoryproc    $conf($server,directoryproc)
$ns_param   directorylisting $conf($server,directorylisting)


#
# Database configuration
#

if [info exists conf(${server},database)] {
    $ns_log debug "ns_db: trying: $conf(${server},config_db)"
    source $conf(${server},config_db)
} else {
    $ns_log debug "ns_db: no database config specified"
}


#
# Modules configuration
#


# 
# Access log -- nslog 
# 
$ns_section ns/server/${server}/module/nslog 
$ns_param   file                 /var/log/${package}/${server}/access.log
$ns_param   enablehostnamelookup false
$ns_param   logcombined          true
#$ns_param   logrefer             false
#$ns_param   loguseragent         false
$ns_param   maxbackup            1000
$ns_param   rollday              *
$ns_param   rollfmt              %Y-%m-%d-%H:%M
$ns_param   rollhour             0
$ns_param   rollonsignal         true
$ns_param   rolllog              true

# TODO: default configuration for other modules

#
# SSL configurations
#

if [info exists conf(${server},config_ssl)] {
    $ns_log debug "nsopenssl: trying $conf(${server},config_ssl)"
    source $conf(${server},config_ssl)
} else {
    $ns_log debug "nsopenssl: no ssl config required/specified"
}

set modules $conf(${server},modules)

#
# nsjava - aolserver module that embeds a java virtual machine.  Needed to 
#          support webmail.  See http://nsjava.sourceforge.net for further 
#          details. This may need to be updated for OpenACS4 webmail
#
if {[lsearch $modules nsjava] >= 0} {

    # TODO: untested
    # TODO: This is clearly not cross platform compatible
    set classpath /usr/local/jdk/jdk118_v1/lib/classes.zip

    append classpath ":[file join ${homedir} bin nsjava.jar]"
    append classpath ":[file join $conf(${server},pageroot) webmail java activation.jar]"
    append classpath ":[file join $conf(${server},pageroot) webmail java mail.jar]"
    append classpath ":[file join $conf(${server},pageroot) webmail java]"

    $ns_section ns/server/${server}/module/nsjava
    $ns_param   enablejava         off  ;# Set to on to enable nsjava.
    $ns_param   verbosejvm         off  ;# Same as command line -debug.
    $ns_param   loglevel           Notice
    $ns_param   destroyjvm         off  ;# Destroy jvm on shutdown.
    $ns_param   disablejitcompiler off  
    $ns_param   classpath          $classpath
}


# 
# CGI interface -- nscgi, if you have legacy stuff.
#
if {[lsearch $modules nscgi]} {
    $ns_section "ns/server/${server}/module/nscgi" 
    $ns_param   map "GET  /cgi-bin /usr/lib/cgi-bin"
    $ns_param   map "POST /cgi-bin /usr/lib/cgi-bin" 
    
    if [info exists conf(${server},config_cgi)] {
	source $conf(${server},config_cgi)
    }
    $ns_param   Interps CGIinterps
}

#
# LDAP module -- nsldap
#

if [info exists conf(${server},ldapDefaultPool)] {
    $ns_log debug "nsldap: configuring ldap"
    $ns_section "ns/server/${server}/ldap"
    $ns_param Pools $conf(${server},ldapPools)
    $ns_param DefaultPool $conf(${server},ldapDefaultPool)
} else {
    $ns_log debug "nsldap: no ldap configuration found/specified"
}


#
# WebDAV configuration
#

if [info exists conf(${server},shares)] {
    $ns_log debug "tDAV: trying  [libfile tdav.tcl]"
    source [libfile tdav.tcl]
} else {
    $ns_log debug "tDAV: no DAV configuration found/specified"
}


#
# Basic Authentication -- nsperm
#

$ns_log debug "ns_perm: sourcing permissions from:  [conffile ${permdir} ${server}.tcl]"

if [file exists [conffile ${permdir} ${server}.tcl]] {
    source [conffile ${permdir} ${server}.tcl]
}

#
# nssock
#
if {($conf($server,address) ne "virtual") \
    && ($conf($server,address) ne $conf($defaultserver,address))} {

    ns_log notice "ns_sock: $server"
    ns_section ns/server/${server}/module/nssock
    $ns_param port $conf($server,httpport)
    $ns_param hostname $conf($server,hostname)
    $ns_param address $conf($server,address)

    lappend modules nssock
}

#
# Modules to load 
# 
$ns_section ns/server/${server}/modules 

foreach module $modules {

    switch $module {
	nsdb   {if ![info exists conf(${server},database)] continue}
	nsopenssl 
	       {if ![info exists conf(${server},httpsport)] continue}
	nsldap {if ![info exists ldappools] continue}
    }
    if 0 {
    if {![info exists conf(${server},database)]
	&& ($module == "nsdb")} { continue }

    if {![info exists conf(${server},httpsport)]
	&& ($module == "nsopenssl")} { continue }

    if {![info exists ldappools]
	&& ($module == "nsldap" ) { continue }
    }
    }
    set modulepath [file join ${homedir} bin ${module}${modext}]
    if [file exists $modulepath] {
	$ns_param $module $modulepath
	$ns_log debug "nsd: ${modulepath} loaded."
    }
}

