(* File generated from mpz.idl *)

type mpz_ptr

(** GMP multi-precision integers *)


(** The following operations are mapped as much as possible to their C counterpart. In case of imperative functions (like [set], [add], ...) the first parameter of type [t] is an out-parameter and holds the result when the function returns. For instance, [add x y z] adds the values of [y] and [z] and stores the result in [x].

 These functions are as efficient as their C counterpart: they do not imply additional memory allocation, unlike the corresponding functions in the module {!Mpzf}. *)



(** {2 Pretty printing} *)

val print : Format.formatter -> t -> unit

(** {2 Initialization Functions} *)
(** {{:http://gmplib.org/manual/Initializing-Integers.html#Initializing-Integers}C documentation} *)

external mpz_init : unit -> mpz_ptr
	= "camlidl_mpz_mpz_init"

external mpz_init2 : int -> mpz_ptr
	= "camlidl_mpz_mpz_init2"

external mpz_realloc2 : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_realloc2"


(** {2 Assignement Functions} *)
(** {{:http://gmplib.org/manual/Assigning-Integers.html#Assigning-Integers}C documentation} *)


(** The first parameter holds the result. *)

external mpz_set : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_set"

external mpz_set_si : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_set_si"

external mpz_set_d : mpz_ptr -> float -> unit
	= "camlidl_mpz_mpz_set_d"


(** For [set_q: t -> Mpq.t -> unit], see {!Mpq.get_z} *)


external mpz__set_str : mpz_ptr -> string -> int -> unit
	= "camlidl_mpz_mpz__set_str"

val set_str : t -> string -> base:int -> unit
external mpz_swap : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_swap"


(** {2 Combined Initialization and Assignment Functions} *)
(** {{:http://gmplib.org/manual/Simultaneous-Integer-Init-_0026-Assign.html#Simultaneous-Integer-Init-_0026-Assign}C documentation} *)

external mpz_init_set : mpz_ptr -> mpz_ptr
	= "camlidl_mpz_mpz_init_set"

external mpz_init_set_si : int -> mpz_ptr
	= "camlidl_mpz_mpz_init_set_si"

external mpz_init_set_d : float -> mpz_ptr
	= "camlidl_mpz_mpz_init_set_d"

external mpz__init_set_str : string -> int -> mpz_ptr
	= "camlidl_mpz_mpz__init_set_str"

val init_set_str : string -> base:int -> t

(** {2 Conversion Functions} *)
(** {{:http://gmplib.org/manual/Converting-Integers.html#Converting-Integers}C documentation} *)

external mpz_get_si : mpz_ptr -> nativeint
	= "camlidl_mpz_mpz_get_si"

external mpz_get_int : mpz_ptr -> int
	= "camlidl_mpz_mpz_get_int"

external mpz_get_d : mpz_ptr -> float
	= "camlidl_mpz_mpz_get_d"

external mpz_get_d_2exp : mpz_ptr -> float * int
	= "camlidl_mpz_mpz_get_d_2exp"

external mpz__get_str : int -> mpz_ptr -> string
	= "camlidl_mpz_mpz__get_str"

val get_str : base:int -> t -> string


(** {2 User Conversions} *)

(** These functions are additions to or renaming of functions offered by the C library. *)

val to_string : t -> string
val to_float : t -> float
val of_string : string -> t
val of_float : float -> t
val of_int : int -> t

(** {2 Arithmetic Functions} *)
(** {{:http://gmplib.org/manual/Integer-Arithmetic.html#Integer-Arithmetic}C documentation} *)

(** The first parameter holds the result. *)

external mpz_add : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_add"

external mpz_add_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_add_ui"

external mpz_sub : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_sub"

external mpz_sub_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_sub_ui"

external mpz_ui_sub : mpz_ptr -> int -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_ui_sub"

external mpz_mul : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_mul"

external mpz_mul_si : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_mul_si"

external mpz_addmul : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_addmul"

external mpz_addmul_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_addmul_ui"

external mpz_submul : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_submul"

external mpz_submul_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_submul_ui"

external mpz_mul_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_mul_2exp"

external mpz_neg : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_neg"

external mpz_abs : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_abs"


(** {2 Division Functions} *)
(** {{:http://gmplib.org/manual/Integer-Division.html#Integer-Division}C documentation} *)

(** [c] stands for ceiling, [f] for floor, and [t] for truncate (rounds toward 0).*)
(** {3 Ceiling division} *)

(** The first parameter holds the quotient. *)
external mpz_cdiv_q : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_cdiv_q"

(** The first parameter holds the remainder. *)
external mpz_cdiv_r : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_cdiv_r"

(** The two first parameters hold resp. the quotient and the remainder). *)
external mpz_cdiv_qr : mpz_ptr -> mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_cdiv_qr"

(** The first parameter holds the quotient. *)
external mpz_cdiv_q_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_cdiv_q_ui"

(** The first parameter holds the remainder. *)
external mpz_cdiv_r_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_cdiv_r_ui"

(** The two first parameters hold resp. the quotient and the remainder). *)
external mpz_cdiv_qr_ui : mpz_ptr -> mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_cdiv_qr_ui"

external mpz_cdiv_ui : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_cdiv_ui"

(** The first parameter holds the quotient. *)
external mpz_cdiv_q_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_cdiv_q_2exp"

(** The first parameter holds the remainder. *)
external mpz_cdiv_r_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_cdiv_r_2exp"

(** {3 Floor division} *)

external mpz_fdiv_q : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_fdiv_q"

external mpz_fdiv_r : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_fdiv_r"

external mpz_fdiv_qr : mpz_ptr -> mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_fdiv_qr"

external mpz_fdiv_q_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_fdiv_q_ui"

external mpz_fdiv_r_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_fdiv_r_ui"

external mpz_fdiv_qr_ui : mpz_ptr -> mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_fdiv_qr_ui"

external mpz_fdiv_ui : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_fdiv_ui"

external mpz_fdiv_q_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_fdiv_q_2exp"

external mpz_fdiv_r_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_fdiv_r_2exp"

(** {3 Truncate division} *)

external mpz_tdiv_q : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_tdiv_q"

external mpz_tdiv_r : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_tdiv_r"

external mpz_tdiv_qr : mpz_ptr -> mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_tdiv_qr"

external mpz_tdiv_q_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_tdiv_q_ui"

external mpz_tdiv_r_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_tdiv_r_ui"

external mpz_tdiv_qr_ui : mpz_ptr -> mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_tdiv_qr_ui"

external mpz_tdiv_ui : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_tdiv_ui"

external mpz_tdiv_q_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_tdiv_q_2exp"

external mpz_tdiv_r_2exp : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_tdiv_r_2exp"

(** {3 Other division-related functions} *)

external mpz_gmod : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_gmod"

external mpz_gmod_ui : mpz_ptr -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_gmod_ui"

external mpz_divexact : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_divexact"

external mpz_divexact_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_divexact_ui"

external mpz_divisible_p : mpz_ptr -> mpz_ptr -> bool
	= "camlidl_mpz_mpz_divisible_p"

external mpz_divisible_ui_p : mpz_ptr -> int -> bool
	= "camlidl_mpz_mpz_divisible_ui_p"

external mpz_divisible_2exp_p : mpz_ptr -> int -> bool
	= "camlidl_mpz_mpz_divisible_2exp_p"

external mpz_congruent_p : mpz_ptr -> mpz_ptr -> mpz_ptr -> bool
	= "camlidl_mpz_mpz_congruent_p"

external mpz_congruent_ui_p : mpz_ptr -> int -> int -> bool
	= "camlidl_mpz_mpz_congruent_ui_p"

external mpz_congruent_2exp_p : mpz_ptr -> mpz_ptr -> int -> bool
	= "camlidl_mpz_mpz_congruent_2exp_p"


(** {2 Exponentiation Functions} *)
(** {{:http://gmplib.org/manual/Integer-Exponentiation.html#Integer-Exponentiation}C documentation} *)

external mpz__powm : mpz_ptr -> mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz__powm"

external mpz__powm_ui : mpz_ptr -> mpz_ptr -> int -> mpz_ptr -> unit
	= "camlidl_mpz_mpz__powm_ui"

val powm : t -> t -> t -> modulo:t -> unit
val powm_ui : t -> t -> int -> modulo:t -> unit

external mpz_pow_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_pow_ui"

external mpz_ui_pow_ui : mpz_ptr -> int -> int -> unit
	= "camlidl_mpz_mpz_ui_pow_ui"


(** {2 Root Extraction Functions} *)
(** {{:http://gmplib.org/manual/Integer-Roots.html#Integer-Roots}C documentation} *)

external mpz_root : mpz_ptr -> mpz_ptr -> int -> bool
	= "camlidl_mpz_mpz_root"

external mpz_sqrt : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_sqrt"

external mpz__sqrtrem : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz__sqrtrem"

val sqrtrem : t -> remainder:t -> t -> unit
external mpz_perfect_power_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_perfect_power_p"

external mpz_perfect_square_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_perfect_square_p"


(** {2 Number Theoretic  Functions} *)
(** {{:http://gmplib.org/manual/Number-Theoretic-Functions.html#Number-Theoretic-Functions}C documentation} *)

external mpz_probab_prime_p : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_probab_prime_p"

external mpz_nextprime : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_nextprime"

external mpz_gcd : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_gcd"

external mpz_gcd_ui : mpz_ptr option -> mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_gcd_ui"

external mpz__gcdext : mpz_ptr -> mpz_ptr -> mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz__gcdext"

val gcdext : gcd:t -> alpha:t -> beta:t -> t -> t -> unit
external mpz_lcm : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_lcm"

external mpz_lcm_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_lcm_ui"

external mpz_invert : mpz_ptr -> mpz_ptr -> mpz_ptr -> bool
	= "camlidl_mpz_mpz_invert"

external mpz_jacobi : mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_jacobi"

external mpz_legendre : mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_legendre"

external mpz_kronecker : mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_kronecker"

external mpz_kronecker_si : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_kronecker_si"

external mpz_si_kronecker : int -> mpz_ptr -> int
	= "camlidl_mpz_mpz_si_kronecker"

external mpz_remove : mpz_ptr -> mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_remove"

external mpz_fac_ui : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_fac_ui"

external mpz_bin_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_bin_ui"

external mpz_bin_uiui : mpz_ptr -> int -> int -> unit
	= "camlidl_mpz_mpz_bin_uiui"

external mpz_fib_ui : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_fib_ui"

external mpz_fib2_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_fib2_ui"

external mpz_lucnum_ui : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_lucnum_ui"

external mpz_lucnum2_ui : mpz_ptr -> mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_lucnum2_ui"


(** {2 Comparison Functions} *)
(** {{:http://gmplib.org/manual/Integer-Comparisons.html#Integer-Comparisons}C documentation} *)

external mpz_cmp : mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_cmp"

external mpz_cmp_d : mpz_ptr -> float -> int
	= "camlidl_mpz_mpz_cmp_d"

external mpz_cmp_si : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_cmp_si"

external mpz_cmpabs : mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_cmpabs"

external mpz_cmpabs_d : mpz_ptr -> float -> int
	= "camlidl_mpz_mpz_cmpabs_d"

external mpz_cmpabs_ui : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_cmpabs_ui"

external mpz_sgn : mpz_ptr -> int
	= "camlidl_mpz_mpz_sgn"


(** {2 Logical and Bit Manipulation Functions} *)
(** {{:http://gmplib.org/manual/Integer-Logic-and-Bit-Fiddling.html#Integer-Logic-and-Bit-Fiddling}C documentation} *)

external mpz_gand : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_gand"

external mpz_ior : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_ior"

external mpz_xor : mpz_ptr -> mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_xor"

external mpz_com : mpz_ptr -> mpz_ptr -> unit
	= "camlidl_mpz_mpz_com"

external mpz_popcount : mpz_ptr -> int
	= "camlidl_mpz_mpz_popcount"

external mpz_hamdist : mpz_ptr -> mpz_ptr -> int
	= "camlidl_mpz_mpz_hamdist"

external mpz_scan0 : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_scan0"

external mpz_scan1 : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_scan1"

external mpz_setbit : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_setbit"

external mpz_clrbit : mpz_ptr -> int -> unit
	= "camlidl_mpz_mpz_clrbit"

external mpz_tstbit : mpz_ptr -> int -> bool
	= "camlidl_mpz_mpz_tstbit"


(** {2 Input and Output Functions: not interfaced} *)


(** {2 Random Number Functions: see {!Gmp_random} module} *)


(** {2 Integer Import and Export Functions} *)
(** {{:ttp://gmplib.org/manual/Integer-Import-and-Export.html#Integer-Import-and-Export}C documentation} *)

external mpz__import : mpz_ptr -> (int, Bigarray.int32_elt, Bigarray.c_layout) Bigarray.Array1.t -> int -> int -> unit
	= "camlidl_mpz_mpz__import"

external mpz__export : mpz_ptr -> int -> int -> (int, Bigarray.int32_elt, Bigarray.c_layout) Bigarray.Array1.t
	= "camlidl_mpz_mpz__export"

val import : dest:t -> (int, Bigarray.int32_elt, Bigarray.c_layout) Bigarray.Array1.t -> order:int -> endian:int -> unit
val export : t -> order:int -> endian:int -> (int, Bigarray.int32_elt, Bigarray.c_layout) Bigarray.Array1.t


(** {2 Miscellaneous Functions} *)
(** {{:http://gmplib.org/manual/Miscellaneous-Integer-Functions.html#Miscellaneous-Integer-Functions}C documentation} *)


(* Does it fit in an OCaml integer *)
external mpz_fits_int_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_int_p"

external mpz_odd_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_odd_p"

external mpz_even_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_even_p"

external mpz_size : mpz_ptr -> int
	= "camlidl_mpz_mpz_size"

external mpz_sizeinbase : mpz_ptr -> int -> int
	= "camlidl_mpz_mpz_sizeinbase"


(* Limited relevance here *)
external mpz_fits_ulong_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_ulong_p"

external mpz_fits_slong_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_slong_p"

external mpz_fits_uint_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_uint_p"

external mpz_fits_sint_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_sint_p"

external mpz_fits_ushort_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_ushort_p"

external mpz_fits_sshort_p : mpz_ptr -> bool
	= "camlidl_mpz_mpz_fits_sshort_p"

