#!/usr/bin/env python

from distutils.core import setup
import glob
import os
import re
# Feisty
#from DistUtilsExtra.distutils_extra import build_extra, build_l10n, build_icons, build_help
# Gutsy
from DistUtilsExtra.command import *

#define version
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)
        f=open("APTonCD/core/version.py","w")
        f.write("APP_VERSION=\"%s\"\n" % version)
        f.close()

GETTEXT_NAME="aptoncd"
I18NFILES = []
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

os.system("intltool-merge -d po data/aptoncd.desktop.in build/aptoncd.desktop")

setup(name='aptoncd',
      version=version,
      packages=['APTonCD', 'APTonCD.core', 'APTonCD.create', 'APTonCD.restore', 'APTonCD.ui', 'APTonCD.widgets'],
      scripts=['aptoncd'],
      data_files=[
      		('share/aptoncd/glade/', glob.glob('data/glade/*.glade')),
      		('share/applications', ["build/aptoncd.desktop"]),
      		('share/aptoncd', ["data/loading.gif","restorefiles.py","data/burners"])]+I18NFILES,
      
      cmdclass = { "build" : build_extra.build_extra,
                   #"build_l10n" :  build_l10n.build_extra,
                   "build_help" :  build_help.build_help,
                   "build_icons" :  build_icons.build_icons }
     )
