// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Plan_h__
#define __Plan_h_

#include <string>
#include <set>
using namespace std;

#ifdef ACMODEL
#include "Elements.h"
#else
#include "JoinPointLoc.h"
#endif
#include "JoinPointPlan.h"
#include "Condition.h"
#include "Puma/Array.h"
using namespace Puma;

class AdviceInfo;
class OrderInfo;
class IntroductionInfo;
class AspectInfo;
class CFlow;
#ifdef ACMODEL
class ProjectModel;
#else
class JoinPointModel;
#endif

namespace Puma {
  class ACAspectInfo;
  class ACIntroductionInfo;
  class CT_AdviceDecl;
  class ErrorSink;
} // namespace Puma


class Plan {
public:
  typedef set<AspectInfo> AspectContainer;

  ErrorStream &_err;
#ifdef ACMODEL
  ProjectModel &_jpm;
#else
  JoinPointModel &_jpm;
#endif
  Array<AdviceInfo*> _advice_infos;
  list<IntroductionInfo*>  _introduction_infos;
  list<OrderInfo*>  _order_infos;
  set<AspectInfo> _aspect_infos;
#ifdef ACMODEL
  Array<ACM_Any*> _exec_jpls;
  Array<ACM_Any*> _call_jpls;
  Array<ACM_Any*> _cons_jpls;
  Array<ACM_Any*> _dest_jpls;
  Array<ACM_Any*> _class_jpls;
#else
  Array<JoinPointLoc*> _exec_jpls;
  Array<JoinPointLoc*> _call_jpls;
  Array<JoinPointLoc*> _cons_jpls;
  Array<JoinPointLoc*> _dest_jpls;
  Array<JoinPointLoc*> _class_jpls;
#endif  
  TypeCheckSet _type_checks_false;
  TypeCheckSet _type_checks_true;
    
public:

#ifdef ACMODEL
  Plan (ErrorStream &e, ProjectModel &jpm);
#else
  Plan (ErrorStream &e, JoinPointModel &jpm);
#endif
  ~Plan ();

#ifdef ACMODEL
  // manage advice and aspect ressources
  AspectInfo *addAspect (ACM_Aspect &);
  AspectContainer &aspect_infos () { return _aspect_infos; }
  AdviceInfo *addAdvice (AspectInfo &ai, ACM_AdviceCode &code);
  IntroductionInfo *addIntroduction (ACM_Aspect &jpl_aspect, ACM_Introduction &intro);
  AdviceInfo *addAdvice (AspectInfo *ai, CT_AdviceDecl *ad);
  OrderInfo *addOrder (ACM_Aspect &a, ACM_Order &o);
  const list<OrderInfo*> &order_infos () const { return _order_infos; }
  const list<IntroductionInfo*> &introduction_infos () const { return _introduction_infos; }
  
  // consider a join point and advice/intro in the plan
  void consider (ACM_Any *jpl, const Condition &cond, AdviceInfo *ai);
  JPP_Class *consider (ACM_Any *jpl, ACM_Introduction *intro);
  void consider (ACM_Any *jpl, ACM_Aspect&, ACM_Aspect&);
  void consider (ACM_Any *jpl, const CFlow& cflow);

  // calculate the order for a single join points
  void order (ACM_Any *jpl);
  
  // calculate the order for all join points
  void order ();
  
  // check the plan for a specific join point
  void check (ACM_Any *jpl);

  // check the final plan -> messages to the error sink
  void check ();

  // read the accumulated plans
  int exec_jp_plans () const { return _exec_jpls.length (); }
  ACM_Execution &exec_jp_loc (int i) const {
    return *(ACM_Execution*)_exec_jpls.lookup (i);
  }
  JPP_Code &exec_jp_plan (int i) const {
    return *(JPP_Code*)exec_jp_loc (i).plan ();
  }

  int call_jp_plans () const { return _call_jpls.length (); }
  ACM_Call &call_jp_loc (int i) const {
    return *(ACM_Call*)_call_jpls.lookup (i);
  }
  JPP_Code &call_jp_plan (int i) const {
    return *(JPP_Code*)call_jp_loc (i).plan ();
  }

  int cons_jp_plans () const { return _cons_jpls.length (); }
  ACM_Construction &cons_jp_loc (int i) const {
    return *(ACM_Construction*)_cons_jpls.lookup (i);
  }
  JPP_Code &cons_jp_plan (int i) const {
    return *(JPP_Code*)cons_jp_loc (i).plan ();
  }

  int dest_jp_plans () const { return _dest_jpls.length (); }
  ACM_Destruction &dest_jp_loc (int i) const {
    return *(ACM_Destruction*)_dest_jpls.lookup (i);
  }
  JPP_Code &dest_jp_plan (int i) const {
    return *(JPP_Code*)dest_jp_loc (i).plan ();
  }

  int class_jp_plans () const { return _class_jpls.length (); }
  ACM_Class &class_jp_loc (int i) const {
    return *(ACM_Class*)_class_jpls.lookup (i);
  }
  JPP_Class &class_jp_plan (int i) const {
    return *(JPP_Class*)class_jp_loc (i).plan ();
  }
#else
  // manage advice and aspect ressources
  AspectInfo *addAspect (JPL_Aspect &);
  AspectContainer &aspect_infos () { return _aspect_infos; }
  AdviceInfo *addAdvice (AspectInfo &ai, JPL_AdviceCode &code);
  IntroductionInfo *addIntroduction (JPL_Aspect &jpl_aspect, JPL_Introduction &intro);
  AdviceInfo *addAdvice (AspectInfo *ai, CT_AdviceDecl *ad);
  OrderInfo *addOrder (JPL_Aspect &a, JPL_Order &o);
  const list<OrderInfo*> &order_infos () const { return _order_infos; }
  const list<IntroductionInfo*> &introduction_infos () const { return _introduction_infos; }
  
  // consider a join point and advice/intro in the plan
  void consider (JoinPointLoc *jpl, const Condition &cond, AdviceInfo *ai);
  JPP_Class *consider (JoinPointLoc *jpl, JPL_Introduction *intro);
  void consider (JoinPointLoc *jpl, JPL_Aspect&, JPL_Aspect&);
  void consider (JoinPointLoc *jpl, const CFlow& cflow);

  // calculate the order for a single join points
  void order (JoinPointLoc *jpl);
  
  // calculate the order for all join points
  void order ();
  
  // check the plan for a specific join point
  void check (JoinPointLoc *jpl);

  // check the final plan -> messages to the error sink
  void check ();

  // read the accumulated plans
  int exec_jp_plans () const { return _exec_jpls.length (); }
  JPL_Method &exec_jp_loc (int i) const {
    return *(JPL_Method*)_exec_jpls.lookup (i);
  }
  JPP_Code &exec_jp_plan (int i) const {
    return *(JPP_Code*)exec_jp_loc (i).plan ();
  }

  int call_jp_plans () const { return _call_jpls.length (); }
  JPL_MethodCall &call_jp_loc (int i) const {
    return *(JPL_MethodCall*)_call_jpls.lookup (i);
  }
  JPP_Code &call_jp_plan (int i) const {
    return *(JPP_Code*)call_jp_loc (i).plan ();
  }

  int cons_jp_plans () const { return _cons_jpls.length (); }
  JPL_Construction &cons_jp_loc (int i) const {
    return *(JPL_Construction*)_cons_jpls.lookup (i);
  }
  JPP_Code &cons_jp_plan (int i) const {
    return *(JPP_Code*)cons_jp_loc (i).plan ();
  }

  int dest_jp_plans () const { return _dest_jpls.length (); }
  JPL_Destruction &dest_jp_loc (int i) const {
    return *(JPL_Destruction*)_dest_jpls.lookup (i);
  }
  JPP_Code &dest_jp_plan (int i) const {
    return *(JPP_Code*)dest_jp_loc (i).plan ();
  }

  int class_jp_plans () const { return _class_jpls.length (); }
  JPL_Class &class_jp_loc (int i) const {
    return *(JPL_Class*)_class_jpls.lookup (i);
  }
  JPP_Class &class_jp_plan (int i) const {
    return *(JPP_Class*)class_jp_loc (i).plan ();
  }
#endif
  
  const TypeCheckSet &type_checks_false () const {
    return _type_checks_false;
  }

  const TypeCheckSet &type_checks_true () const {
    return _type_checks_true;
  }
};

#endif // __Plan_h__
