/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.jcraft.jogg.Buffer;

public class Bitwise {
    private static final int fp_bits = 32;
    private static final int fp_cuts_bits_bits = 4;

    static void readbuf(Buffer buffer, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)buffer.read(8);
            ++n2;
        }
    }

    static int read32(Buffer buffer) {
        int n = buffer.read(8);
        n |= buffer.read(8) << 8;
        n |= buffer.read(8) << 16;
        return n |= buffer.read(8) << 24;
    }

    static int read32v(Buffer buffer) {
        int n = buffer.read(4);
        if (n == 15) {
            int n2 = buffer.read(1);
            int n3 = buffer.read(5) + 1;
            n = buffer.read(n3);
            if (n2 != 0) {
                n = -n;
            }
        }
        return n;
    }

    static long read64(Buffer buffer) {
        long l = Bitwise.read32(buffer);
        long l2 = Bitwise.read32(buffer);
        return l | l2 << 32;
    }

    static int skipWarp(Buffer buffer) {
        int n;
        while ((n = Bitwise.read32v(buffer)) != 0) {
            if (n < 0) {
                return -6;
            }
            buffer.adv(n);
        }
        return 0;
    }

    private static int[] readFixed(Buffer buffer, int n) {
        int n2 = buffer.read(4);
        int n3 = buffer.read(4);
        int n4 = 32 - n2 - n3;
        int[] nArray = new int[n];
        int n5 = 0;
        while (n-- > 0) {
            int n6 = 0;
            if (n2 > 0) {
                n6 = buffer.read1();
            }
            int n7 = buffer.read(n4);
            n7 <<= n3;
            if (n6 != 0) {
                n7 = -n7;
            }
            nArray[n5++] = n7;
        }
        return nArray;
    }

    private static double fixedToFloat(int n) {
        return (double)n / 65536.0;
    }

    static double[][] readFloats(Buffer buffer, int n, int n2) {
        if (n * n2 == 0) {
            return null;
        }
        if (n2 > 1 && buffer.read1() != 0) {
            n *= n2;
            n2 = 1;
        }
        double[][] dArrayArray = new double[n2][];
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray = Bitwise.readFixed(buffer, n);
            dArrayArray[n3] = new double[n];
            int n4 = 0;
            while (n4 < n) {
                dArrayArray[n3][n4] = Bitwise.fixedToFloat(nArray[n4]);
                ++n4;
            }
            ++n3;
        }
        return dArrayArray;
    }
}

