//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_11.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot11(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[11] = {8.448394164252124e-01,2.102574184831798e-01,1.915565574736173e+00,3.443537268140795e+00,5.461644772694418e+00,
    8.019112688782045e+00,1.118987571617644e+01,1.508912822002115e+01,1.991025764276847e+01,2.602565538189142e+01,3.439012589988069e+01};
  constexpr double aw[11] = {1.678230401905021e-01,7.824599992321335e-02,1.319638668639710e-01,5.236616050918886e-02,1.130324456601507e-02,
    1.327657922364920e-03,8.111872035223047e-05,2.346871456312215e-06,2.707057663826872e-08,8.870360814858491e-11,3.494169062949084e-14};
  constexpr double x[4224] = {  3.409593792617322e-02, -6.987154848340618e-04,  1.055662393877348e-05, -1.384821596218973e-07,  1.649829484072803e-09,
 -1.808068309075306e-11,  1.813960904650297e-13, -1.626429395668988e-15,  1.216022134867250e-17, -5.761238110677237e-20, -2.687760468536493e-22,  1.252075064261680e-23,
  1.342314375128877e-01, -2.616000650497985e-03,  3.555243277946640e-05, -3.829598186562049e-07,  3.148105216541321e-09, -1.413901948370435e-11, -1.125276001800013e-13,
  3.786101496435379e-15, -5.520769181154719e-17,  5.193596108024787e-19, -2.081199966738336e-21, -3.551548411474326e-23,  2.940380475449568e-01, -5.256869567203616e-03,
  5.861575436054603e-05, -3.915813652056823e-07, -3.371547057143859e-10,  5.003195416970084e-11, -6.950969201338547e-13,  3.547144295889897e-15,  4.803221120671237e-17,
 -1.309456985893276e-18,  1.328636405130138e-20,  5.181286863427874e-25,  5.032025849402552e-01, -7.927641377152166e-03,  6.282109048318517e-05, -7.517419652860185e-09,
 -6.460866534305693e-09,  6.725586951756323e-11,  1.930535947321640e-13, -1.239146231670781e-14,  1.080733158589606e-16,  8.572685682389883e-19, -2.888561958986400e-20,
  1.852560917954872e-22,  7.479380490893902e-01, -9.907278935065773e-03,  4.064089183849041e-05,  5.390443414903280e-07, -7.216941255659818e-09, -3.226603630055762e-11,
  1.256424381270186e-12, -2.127416590571473e-15, -2.019613981562885e-16,  1.606825305729235e-18,  2.743422145403862e-20, -4.773670801904294e-22,  1.011677145008789e+00,
 -1.063719086358318e-02, -8.065243451755393e-07,  8.021491345272586e-07,  5.524659890131860e-11, -1.089462318957073e-10, -3.192687922069292e-17,  1.799586489259278e-14,
 -1.854847922053042e-18, -3.295696411399957e-18,  7.090991154973007e-22,  6.431427102048401e-22,  1.276009426061697e+00, -9.883916832664893e-03, -4.276139833296526e-05,
  5.369704206771718e-07,  7.535283872867945e-09, -3.180789256341679e-11, -1.322983263151967e-12, -2.407672576918385e-15,  2.162978514018398e-16,  1.734592408259960e-18,
 -3.028836572911799e-20, -5.234415476285247e-22,  1.521866457851087e+00, -7.826684959644855e-03, -6.526140356861712e-05, -3.868523246412035e-08,  6.641058354895526e-09,
  7.499154209349510e-11, -1.518280038875618e-13, -1.359419631428419e-14, -1.309240352594516e-16,  8.528611595354495e-19,  3.391500814627326e-20,  2.478408393986790e-22,
  1.730922791021141e+00, -5.032578156069133e-03, -5.936116238474026e-05, -4.365949828995140e-07, -1.967577397233757e-10,  4.995249122578859e-11,  7.952518466587017e-13,
  5.236870070325213e-15, -3.923933844933182e-17, -1.499665980696541e-18, -1.844027753386274e-20, -5.167262660999068e-23,  1.887124356374297e+00, -2.309569663175201e-03,
 -3.327269074883866e-05, -3.867227813122501e-07, -3.581473997128040e-09, -2.213637048020117e-11,  2.313729119151371e-14,  3.320670069503800e-15,  6.112366656047957e-17,
  7.262082136044638e-19,  5.399255972463650e-21, -2.214650061851410e-24,  1.978210164990212e+00, -4.683095061434311e-04, -7.465000376160451e-06, -1.041706726074662e-07,
 -1.335925040633704e-09, -1.603039288379423e-11, -1.808676240431855e-13, -1.911175569872849e-15, -1.864094880889909e-17, -1.620635158240887e-19, -1.140259417641441e-21,
 -3.977426834123683e-24,  3.146005647241151e-02, -6.204869029622191e-04,  9.042014163063764e-06, -1.147559742631114e-07,  1.328281066355527e-09, -1.423165296542206e-11,
  1.409826508317930e-13, -1.271653935257117e-15,  1.000017828017873e-17, -6.002897681090385e-20,  9.240353607146475e-23,  4.833708883220250e-24,  1.243083484277690e-01,
 -2.349129254472951e-03,  3.124941629554634e-05, -3.349664471019730e-07,  2.845944376054264e-09, -1.575054279287366e-11, -2.856755987442824e-14,  2.300228880277769e-15,
 -3.827490109579005e-17,  4.166171912497693e-19, -2.816724217909663e-21, -2.422215517074944e-24,  2.739186247580883e-01, -4.806760805705169e-03,  5.391459477213152e-05,
 -3.898407626438352e-07,  5.054320955576543e-10,  3.467523229029947e-11, -5.806218928580941e-13,  4.430905644211584e-15,  1.022120897260483e-17, -8.030052374932146e-19,
  1.154733879422321e-20, -6.720345510926895e-23,  4.724942407448608e-01, -7.427087536731694e-03,  6.215553783621066e-05, -9.998924876576001e-08, -5.095407077963844e-09,
  6.813739682283121e-11, -1.023378015804739e-13, -8.644271215533245e-15,  1.204092574743565e-16, -1.036529803627690e-19, -1.866480188295521e-20,  2.544171005499307e-22,
  7.089973322474028e-01, -9.558279231264509e-03,  4.640052378964911e-05,  4.200164517931891e-07, -7.569068326811782e-09, -3.496975733628080e-12,  1.116340009061504e-12,
 -7.495099269502202e-15, -1.295798591146219e-16,  2.270658406609594e-18,  5.864540583516634e-21, -4.643107910765914e-22,  9.691762444160894e-01, -1.060528962613277e-02,
  8.753129072935338e-06,  7.857714500476389e-07, -2.083365871370025e-09, -1.030151743842778e-10,  4.855394446548012e-13,  1.609784147206479e-14, -1.133738704261059e-16,
 -2.728160868990979e-18,  2.646419909335429e-20,  4.797603353099504e-22,  1.235833201728723e+00, -1.019824345258596e-02, -3.562097484691675e-05,  6.507123284765905e-07,
  6.580402583151829e-09, -6.353805452138534e-11, -1.286021433983082e-12,  5.237397972305527e-15,  2.519107819341444e-16,  1.244398584680088e-19, -4.815087614354809e-20,
 -2.407918516008776e-22,  1.489515293484139e+00, -8.348714686176439e-03, -6.503960479025925e-05,  7.923488907403339e-08,  8.071328122733422e-09,  6.634479229020082e-11,
 -5.845311638894352e-13, -1.701303449828518e-14, -7.375241341125728e-17,  2.360684603429269e-18,  3.939388578362358e-20, -3.784047067992041e-23,  1.709809551903441e+00,
 -5.528394632499153e-03, -6.458273455450225e-05, -4.306670868997675e-07,  1.004065991566411e-09,  7.060119309693437e-11,  9.151597968873939e-13,  2.973033996021145e-15,
 -1.066697241158869e-16, -2.238692649190026e-18, -1.715576981365570e-20,  1.350809746116859e-22,  1.877322904549740e+00, -2.595321320641864e-03, -3.827160124675957e-05,
 -4.475021004222495e-07, -4.009867023854339e-09, -2.021868123698600e-11,  1.477213901951193e-13,  5.735504306455471e-15,  9.098797667858137e-17,  9.236975886106838e-19,
  3.958967617269990e-21, -7.372189490051359e-23,  1.976209022821870e+00, -5.334190670614102e-04, -8.854694085338690e-06, -1.283656667862458e-07, -1.704648082678877e-09,
 -2.108648942100842e-11, -2.436731937552041e-13, -2.610111964901479e-15, -2.532759247145925e-17, -2.098964233823070e-19, -1.207490531151265e-21,  2.158964426597370e-24,
  2.911454260714966e-02, -5.533182792288544e-04,  7.783628506714893e-06, -9.560818112354515e-08,  1.074778263643937e-09, -1.124114693064692e-11,  1.095386419058301e-13,
 -9.851751191173862e-16,  7.945090758251974e-18, -5.333382182769386e-20,  2.167544805977863e-22,  1.286840256608077e-24,  1.153874257155241e-01, -2.114462300350319e-03,
  2.749256777412503e-05, -2.919690980178947e-07,  2.528634920974511e-09, -1.578860770628960e-11,  2.079173604586601e-14,  1.293759207449448e-15, -2.528473080614122e-17,
  3.066086061871446e-19, -2.592457507675102e-21,  1.026996705470248e-23,  2.555248447896304e-01, -4.393970928253815e-03,  4.930557637979724e-05, -3.769204077068120e-07,
  1.069725566652871e-09,  2.224237528571348e-11, -4.557234443393997e-13,  4.378382148725980e-15, -1.114757441462200e-17, -4.064437502938173e-19,  8.202760334186255e-21,
 -7.841990020952334e-23,  4.437709583786401e-01, -6.935926343915321e-03,  6.051083999048260e-05, -1.708217775973010e-07, -3.774606871966430e-09,  6.320415224091308e-11,
 -2.918968825401106e-13, -4.973389109244731e-15,  1.058817853551800e-16, -6.336191342533794e-19, -8.157239635440470e-21,  2.111998204011523e-22,  6.715356428680125e-01,
 -9.168969280713422e-03,  5.071628494104108e-05,  2.997287421798702e-07, -7.390183354873105e-09,  2.038447710048110e-11,  8.608181092316712e-13, -1.032584484949408e-14,
 -4.813147358925607e-17,  2.142932539452215e-18, -1.090402614438781e-20, -2.817983953589741e-22,  9.269538542213085e-01, -1.049826598194517e-02,  1.791684285763143e-05,
  7.367331043675403e-07, -3.993104223645937e-09, -8.644584073454870e-11,  8.723902832083087e-13,  1.113826254171729e-14, -1.883389090030098e-16, -1.347406968920049e-18,
  3.987865429576371e-20,  1.135309903208439e-22,  1.194522132658461e+00, -1.045029434923204e-02, -2.722789999491916e-05,  7.442218768914178e-07,  5.017550407183425e-09,
 -9.174141272975881e-11, -1.028576256851352e-12,  1.298572505100372e-14,  2.203912555290723e-16, -1.877218232784355e-18, -4.833788838534339e-20,  2.481184604301383e-22,
  1.455089048022044e+00, -8.862937776409782e-03, -6.327307180427287e-05,  2.180634258853283e-07,  9.218344801704407e-09,  4.642215496077768e-11, -1.079049113085542e-12,
 -1.772014756504955e-14,  3.801646465393956e-17,  3.771557931964601e-18,  2.763929632206057e-20, -5.161678696463553e-22,  1.686630455868458e+00, -6.065340247225979e-03,
 -6.960382838016659e-05, -4.020921052601035e-07,  2.640145551146012e-09,  9.309942858027267e-11,  9.376491698486120e-13, -1.845516947894297e-15, -1.973804489969473e-16,
 -2.715745764440644e-18, -4.185510913053646e-21,  4.787942839308042e-22,  1.866293685117660e+00, -2.924094099646012e-03, -4.403912972159537e-05, -5.146414090693818e-07,
 -4.363945260806272e-09, -1.438560313458066e-11,  3.542478989970497e-13,  9.201229558300556e-15,  1.259733366855164e-16,  9.788205099657377e-19, -2.335994805993937e-21,
 -2.299905490631005e-22,  1.973923216056163e+00, -6.109160822687046e-04, -1.057374672366392e-05, -1.593582128643564e-07, -2.191283309165006e-09, -2.791053493702729e-11,
 -3.293033503039772e-13, -3.550405318881274e-15, -3.369472675016359e-17, -2.521595399534993e-19, -7.733171006306395e-22,  2.057623286220629e-23,  2.701893262680144e-02,
 -4.953623072544628e-04,  6.732528150314957e-06, -8.007635813199012e-08,  8.741513961554624e-10, -8.916221107141817e-12,  8.523689402319428e-14, -7.599032370542816e-16,
  6.189614332144058e-18, -4.407712091373386e-20,  2.351998884684329e-22, -2.235022916129963e-25,  1.073482075915024e-01, -1.907872253799477e-03,  2.422138485822971e-05,
 -2.539992086521205e-07,  2.220355257542991e-09, -1.493682547173872e-11,  4.721166958111217e-14,  6.422108718457845e-16, -1.599197530702333e-17,  2.132190171245589e-19,
 -2.057983817349539e-21,  1.297385145246623e-23,  2.387096550807480e-01, -4.017297380452618e-03,  4.489809194276372e-05, -3.567994772083785e-07,  1.414871633531939e-09,
  1.272441914489099e-11, -3.399093772344460e-13,  3.844286601469165e-15, -2.067900373385641e-17, -1.442423695484567e-19,  5.011188912135709e-21, -6.445777400067595e-23,
  4.169811178302050e-01, -6.460972373106556e-03,  5.813898475455904e-05, -2.215242037697647e-07, -2.589976268519988e-09,  5.488753359421840e-11, -3.874963072355051e-13,
 -1.996310262713936e-15,  7.922684089427361e-17, -7.974678061147539e-19, -6.395818839235356e-22,  1.289649766967346e-22,  6.356912172887528e-01, -8.750824371864809e-03,
  5.362038788655846e-05,  1.857692774268485e-07, -6.799926162672485e-09,  3.746832847351053e-11,  5.610075398634090e-13, -1.073627862520113e-14,  1.876374569652772e-17,
  1.523227494241754e-18, -1.852637171851643e-20, -6.986831512439134e-23,  8.853017547965685e-01, -1.032077770619575e-02,  2.632119202686481e-05,  6.602430180245316e-07,
 -5.491055167657903e-09, -6.248074942027709e-11,  1.094811483564760e-12,  4.646123511009712e-15, -2.079599346276731e-16,  2.357124319287568e-19,  3.669191583657337e-20,
 -2.386267506912844e-22,  1.152343602450792e+00, -1.063117761761232e-02, -1.788007637165212e-05,  8.086198303975760e-07,  2.969122754356334e-09, -1.113421990398824e-10,
 -5.788940283391879e-13,  1.861384554313702e-14,  1.219486894728838e-16, -3.450938633896234e-18, -2.718362672068972e-20,  6.778990908541670e-22,  1.418645120944221e+00,
 -9.356087318337064e-03, -5.974572021757283e-05,  3.714128566189136e-07,  9.848893405309481e-09,  1.484029460475642e-11, -1.536550122109151e-12, -1.417113968625559e-14,
  1.868778510667431e-16,  4.277603935602323e-18, -5.628417808120992e-21, -9.617674933734253e-22,  1.661226084846100e+00, -6.640603864244887e-03, -7.411015486515284e-05,
 -3.437627427144169e-07,  4.718911778597025e-09,  1.141788523330900e-10,  7.828953446601293e-13, -9.709643592340340e-15, -2.919521204401453e-16, -2.337297217814758e-18,
  2.618907213147633e-20,  8.970829422544412e-22,  1.853851869664752e+00, -3.302315313503711e-03, -5.064150357059538e-05, -5.862080931866371e-07, -4.543281227502125e-09,
 -2.305171304246812e-12,  6.733523819090920e-13,  1.375419814287168e-14,  1.564476679993026e-16,  6.105610131279208e-19, -1.810662985105394e-20, -5.085635894810351e-22,
  1.971297359439866e+00, -7.037966702946384e-04, -1.271631827401174e-05, -1.993499439703637e-07, -2.837245017197076e-09, -3.713713833370689e-11, -4.452040235633093e-13,
 -4.777475274113445e-15, -4.301621686985174e-17, -2.540543039435131e-19,  1.017937915943777e-21,  6.769618163672173e-23,  2.513943671872792e-02, -4.451208429355830e-04,
  5.849986884509225e-06, -6.741223201313510e-08,  7.146700519272281e-10, -7.104883491784879e-12,  6.650677141383223e-14, -5.854410120180860e-16,  4.767815194320771e-18,
 -3.507527430636535e-20,  2.108939350737625e-22, -7.808855035394450e-25,  1.000857800133737e-01, -1.725711477889167e-03,  2.137690396451537e-05, -2.207966936435525e-07,
  1.934135342099698e-09, -1.363923755568202e-11,  5.907625716054483e-14,  2.384996835302634e-16, -9.662190785285490e-18,  1.420660112511144e-19, -1.510509892190112e-21,
  1.152760222688126e-23,  2.233322836675174e-01, -3.674837537269663e-03,  4.075938488291229e-05, -3.325336624355247e-07,  1.596098411311573e-09,  5.779953192149263e-12,
 -2.420687964397637e-13,  3.132961297819093e-15, -2.289416390388562e-17,  5.324898563649156e-21,  2.613229373357771e-21, -4.453733294357561e-23,  3.920497274712198e-01,
 -6.007118058814166e-03,  5.526660531375148e-05, -2.547013040210055e-07, -1.588384152999488e-09,  4.517689107980356e-11, -4.121932085849739e-13,  8.434560704185708e-17,
  5.121000637542526e-17, -7.329171809515835e-19,  3.324382223614614e-21,  5.469442124189301e-23,  6.015574337641605e-01, -8.314732719039630e-03,  5.522365007646915e-05,
  8.359655443337885e-08, -5.939720926957638e-09,  4.743843371114083e-11,  2.760023820237978e-13, -9.404415284652242e-15,  5.998172140780025e-17,  7.701734474583591e-19,
 -1.805931614702698e-20,  7.630288114983756e-23,  8.444877396239219e-01, -1.008009560232955e-02,  3.368044283411159e-05,  5.638477469257655e-07, -6.471196069970742e-09,
 -3.537878143710935e-11,  1.134891724716780e-12, -1.614377155700344e-15, -1.762193591269255e-16,  1.426948787851163e-18,  2.161720364294422e-20, -4.103093002418671e-22,
  1.109595177805750e+00, -1.073477011318585e-02, -7.967033775045677e-06,  8.377397703472407e-07,  6.473298324985582e-10, -1.186612069169961e-10, -2.288715069192775e-14,
  2.038106255415407e-14, -1.407571994658348e-17, -3.882209824906707e-18,  6.369149321106341e-21,  7.797190902908538e-22,  1.380296862090830e+00, -9.813537438525461e-03,
 -5.434030340327135e-05,  5.292449753720771e-07,  9.748870807206606e-09, -2.598405382745127e-11, -1.827280243501471e-12, -5.857392364217309e-15,  3.260517076935104e-16,
  3.151038743502004e-18, -5.108991419312019e-20, -1.011169280413487e-21,  1.633453829519367e+00, -7.248522525523983e-03, -7.770392754352418e-05, -2.490829802223749e-07,
  7.162609121704965e-09,  1.285817045707507e-10,  3.694990389111864e-13, -2.011321132631981e-14, -3.468728172056828e-16, -4.117789053156115e-19,  7.156057556613421e-20,
  1.091188869340388e-21,  1.839786051327649e+00, -3.736818210111004e-03, -5.811045013313665e-05, -6.582500492266303e-07, -4.393597712248682e-09,  1.905652329066986e-11,
  1.130581670355112e-12,  1.892229836283969e-14,  1.590243868717672e-16, -6.692822287399226e-19, -4.867696204408320e-20, -8.887856127743183e-22,  1.968262392105168e+00,
 -8.159282021933407e-04, -1.540741541293231e-05, -2.513167366086445e-07, -3.698510248669819e-09, -4.959081282860989e-11, -5.995227374367898e-13, -6.285186676979769e-15,
 -5.048320743494141e-17, -1.275818151846467e-19,  6.103119943222234e-21,  1.782306620766634e-22,  2.344769068008083e-02, -4.013726071802852e-04,  5.105225613538792e-06,
 -5.703284531882988e-08,  5.872905832527236e-10, -5.689299018117248e-12,  5.207177424359474e-14, -4.515175519732597e-16,  3.648059035646852e-18, -2.738972568592079e-20,
  1.722916684711054e-22, -9.343137354540991e-25,  9.350890003287193e-02, -1.564788624884143e-03,  1.890427308981207e-05, -1.919540721898731e-07,  1.675907854813064e-09,
 -1.217187746249525e-11,  6.211683467342868e-14,  4.252775101132923e-19, -5.520095986989923e-18,  9.101655644996924e-20, -1.062186399224116e-21,  8.770660137614793e-24,
  2.092604331930592e-01, -3.364283058458654e-03,  3.692507657875363e-05, -3.063586080271994e-07,  1.660281764610562e-09,  9.410013711491850e-13, -1.644503965089812e-13,
  2.420084120167252e-15, -2.124371005896885e-17,  7.603412127318104e-20,  1.046777875955081e-21, -2.746721172397001e-23,  3.688856398376537e-01, -5.577577726151061e-03,
  5.208578998301067e-05, -2.734208157709037e-07, -7.827241876260535e-10,  3.547440476401064e-11, -3.906508267398157e-13,  1.330255850661111e-15,  2.764542642218215e-17,
 -5.682450570755438e-19,  4.550632333615962e-21,  5.427248470115056e-24,  5.691862512647068e-01, -7.870472470843253e-03,  5.568883610701384e-05, -3.574271123004141e-09,
 -4.944828787548682e-09,  5.114032681372065e-11,  4.277024523332318e-14, -7.172748782912929e-15,  7.573250729897725e-17,  1.376651506527961e-19, -1.315840110526526e-20,
  1.327221654703610e-22,  8.047465528561312e-01, -9.785391814670544e-03,  3.980675660245161e-05,  4.561017300390855e-07, -6.913131977568765e-09, -9.268472451275801e-12,
  1.019448241433806e-12, -6.300353282676659e-15, -1.136882452394317e-16,  1.927475509860411e-18,  3.662319401347001e-21, -3.770862070215178e-22,  1.066592304731984e+00,
 -1.075829840571756e-02,  2.070098458862251e-06,  8.292728979949130e-07, -1.685962409165484e-09, -1.125391298154897e-10,  5.211910010274481e-13,  1.780769425334417e-14,
 -1.414788334936062e-16, -3.001028870289853e-18,  3.558664072050145e-20,  4.943765325985185e-22,  1.340217161863871e+00, -1.022025957705232e-02, -4.707843868970823e-05,
  6.786533230218621e-07,  8.783837969904298e-09, -7.053918864515801e-11, -1.831448075972531e-12,  5.916290404574050e-15,  3.930197071144430e-16,  3.405901979853405e-19,
 -8.526688726681051e-20, -4.427622263641201e-22,  1.603200557064910e+00, -7.879964166902254e-03, -7.991946560668517e-05, -1.136403421615911e-07,  9.770844995875423e-09,
  1.294456707046409e-10, -3.468325813881403e-13, -3.080769180694815e-14, -2.992402020472308e-16,  3.328498615049387e-18,  1.118038176522307e-19,  5.845474486377604e-22,
  1.823857348533427e+00, -4.234453392991230e-03, -6.641336702886118e-05, -7.238342374559275e-07, -3.695389880344605e-09,  5.308569600917238e-11,  1.724872987772283e-12,
  2.316693939052527e-14,  8.950911315237797e-17, -3.499396229067879e-18, -9.483943474740488e-20, -1.155424882080335e-21,  1.964731534193550e+00, -9.523374913645512e-04,
 -1.881370703182012e-05, -3.192723619204694e-07, -4.849420676939793e-09, -6.627584945073318e-11, -7.983743495304452e-13, -7.908407931247302e-15, -4.828100490573527e-17,
  3.317752318716809e-19,  1.861130854553530e-20,  4.198602344460017e-22,  2.191976401395183e-02, -3.631168628068555e-04,  4.473665181416217e-06, -4.848265457202930e-08,
  4.850422623491208e-10, -4.578960490334592e-12,  4.092439503101785e-14, -3.493068528914808e-16,  2.776125997800522e-18, -2.132285801305457e-20,  1.313046470502940e-22,
 -8.971830810984438e-25,  8.753824521080736e-02, -1.422330365006291e-03,  1.675393954562964e-05, -1.670063655845304e-07,  1.447287988176366e-09, -1.069813904424967e-11,
  6.009398233174475e-14, -1.312877959175710e-16, -2.922884677464336e-18,  5.541809774554467e-20, -7.371958861771280e-22,  6.121823882536985e-24,  1.963714567421506e-01,
 -3.083135916385801e-03,  3.340814645414251e-05, -2.798362909277980e-07,  1.644737054654483e-09, -2.266713059633998e-12, -1.057486145318680e-13,  1.790038348779637e-15,
 -1.800794169511186e-17,  9.763415015631102e-20,  1.215162295421910e-22, -1.529629848518393e-23,  3.473876880307848e-01, -5.174177825547213e-03,  4.875140009854293e-05,
 -2.807636738735714e-07, -1.635342637960576e-10,  2.662807152948108e-11, -3.438434978922143e-13,  1.922634164652818e-15,  1.043873326177717e-17, -3.903285057660503e-19,
  4.166419987770672e-21, -1.918122020272117e-23,  5.385933148524211e-01, -7.426400563686767e-03,  5.520499991023034e-05, -7.451663949699598e-08, -3.926602772038466e-09,
  5.003185100795313e-11, -1.240509077960344e-13, -4.760055093042856e-15,  7.263530759032503e-17, -2.711302231276526e-19, -7.351766913961654e-21,  1.237755395446933e-22,
  7.662738947019549e-01, -9.446931026971316e-03,  4.461432576177834e-05,  3.452714727773048e-07, -6.869974369639205e-09,  1.273463391499606e-11,  8.025621990146834e-13,
 -8.830043207004685e-15, -4.530549350881586e-17,  1.782324498929225e-18, -9.790017878378494e-21, -2.236217674507033e-22,  1.023654391025795e+00, -1.070255694451132e-02,
  1.178788500428319e-05,  7.851300223179121e-07, -3.774300145171556e-09, -9.464784541361443e-11,  9.423482050359124e-13,  1.186102110198043e-14, -2.198822926118698e-16,
 -1.279031259837650e-18,  4.700608014805402e-20,  1.795709752533730e-23,  1.298637658741461e+00, -1.056204487547982e-02, -3.814542698529800e-05,  8.056020519276765e-07,
  6.954229732276885e-09, -1.110977657963046e-10, -1.492711426139024e-12,  1.800875749499699e-14,  3.416537988724723e-16, -3.186098871723663e-18, -8.393268564530289e-20,
  5.265167694689045e-22,  1.570397358131184e+00, -8.521924668568730e-03, -8.026202398396542e-05,  6.264118716043330e-08,  1.220163971188760e-08,  1.098307049743785e-10,
 -1.319148560246489e-12, -3.757342910772611e-14, -9.594800470136043e-17,  7.946548525539132e-18,  1.083006410102120e-19, -8.890055387581007e-22,  1.805800616805007e+00,
 -4.801413102696717e-03, -7.541120005654399e-05, -7.719929245929437e-07, -2.166088256865364e-09,  1.024453810253272e-10,  2.388919035075289e-12,  2.318560766589725e-14,
 -1.166781111757261e-16, -8.259624819062341e-18, -1.400142775315096e-19, -7.048786055951119e-22,  1.960594896231336e+00, -1.119599152406376e-03, -2.315784700334721e-05,
 -4.085865381652349e-07, -6.385317277491776e-09, -8.825145267352781e-11, -1.038377447984838e-12, -9.075666102776606e-15, -1.742398401028206e-17,  1.566314720760955e-18,
  4.663927545057104e-20,  9.059915578664055e-22,  2.053536802132388e-02, -3.295294063947346e-04,  3.935579463918326e-06, -4.140440018182631e-08,  4.025416758139987e-10,
 -3.704778529799530e-12,  3.227890595113749e-14, -2.718125280153738e-16,  2.094145231068390e-18, -1.678568044809562e-20,  9.832863809567695e-23, -5.067613845264206e-25,
  8.210482925217197e-02, -1.295937250812941e-03,  1.488199204556590e-05, -1.454845157691840e-07,  1.247402501234379e-09, -9.308912936202034e-12,  5.537070880305889e-14,
 -1.980957071566125e-16, -1.398400341186500e-18,  3.083451161112550e-20, -4.993857477376267e-22,  5.148058726818431e-24,  1.845528018674143e-01, -2.828859779553292e-03,
  3.020610684076369e-05, -2.540051570107906e-07,  1.577760208903444e-09, -4.265091705607145e-12, -6.316676451445188e-14,  1.269820885463359e-15, -1.454081158139919e-17,
  9.199989568240971e-20, -3.290857500647084e-22, -4.997039053112561e-24,  3.274496481004018e-01, -4.797650107712633e-03,  4.538271016059922e-05, -2.795492753290472e-07,
  2.910092894485742e-10,  1.904770083508554e-11, -2.872267885943139e-13,  2.062183187571454e-15, -8.415284003337524e-19, -2.429764446082593e-19,  3.180288355357410e-21,
 -2.199194751100013e-23,  5.097639202041190e-01, -6.989330607844731e-03,  5.396623066906585e-05, -1.295396738312340e-07, -2.965221206170112e-09,  4.570710600000547e-11,
 -2.266047340574797e-13, -2.638532283886201e-15,  5.881213903772230e-17, -4.653328178123408e-19, -2.587024047243553e-21,  9.312920553431029e-23,  7.292236359330572e-01,
 -9.075286294027755e-03,  4.810962559147889e-05,  2.383496853432606e-07, -6.443299591295262e-09,  2.892157437239266e-11,  5.440352750632725e-13, -9.344866302303000e-15,
  9.918620389046146e-18,  1.246690227523006e-18, -1.569360570912300e-20, -4.595638152288922e-23,  9.810908109533563e-01, -1.057172961319968e-02,  2.078889851932813e-05,
  7.109245808818001e-07, -5.418435445549309e-09, -6.887095938027490e-11,  1.171584886500696e-12,  4.444695995058827e-15, -2.330632420787959e-16,  4.913620014577512e-19,
  3.880072357655028e-20, -3.510232515478940e-22,  1.255842811156741e+00, -1.082682842118412e-02, -2.788970749743441e-05,  8.973396856468510e-07,  4.420722770594645e-09,
 -1.397641961629824e-10, -8.569242306441633e-13,  2.652027633188325e-14,  1.745744858539637e-16, -5.814698215429337e-18, -4.172125941028284e-20,  1.311576004742710e-21,
  1.535035117075084e+00, -9.157541259218138e-03, -7.827304058578244e-05,  2.733598841831599e-07,  1.399587121061505e-08,  6.549123356386578e-11, -2.365829287002160e-12,
 -3.534047503754093e-14,  2.535797318118390e-16,  1.093703821899982e-17,  2.766442791745892e-20, -2.722017590978161e-21,  1.785329114032060e+00, -5.442170532038086e-03,
 -8.480477850956462e-05, -7.869346959448483e-07,  5.052542239047156e-10,  1.668334488991418e-10,  2.933207854387344e-12,  1.357845678106751e-14, -5.182345219357509e-16,
 -1.400350686746226e-17, -1.315337894752106e-19,  1.456143978111786e-21,  1.955712281068162e+00, -1.326354258709261e-03, -2.873674504708838e-05, -5.263126146497661e-07,
 -8.420191283141096e-09, -1.162178039191166e-10, -1.288744466574622e-12, -8.280230247314583e-15,  8.412893059836774e-17,  4.452272957122184e-18,  1.039280604026501e-19,
  1.766966499983475e-21,  1.927722041382787e-02, -2.999280606704466e-04,  3.475055097375191e-06, -3.551686454974499e-08,  3.356134339884170e-10, -3.014373385441789e-12,
  2.552072370534033e-14, -2.137370549164365e-16,  1.557790519970623e-18, -1.300780718185620e-20,  9.975491498401711e-23,  7.601898820601302e-25,  7.714859622505929e-02,
 -1.183538967862556e-03,  1.325001315402897e-05, -1.269452633886477e-07,  1.074041685248216e-09, -8.050733469130336e-12,  4.933961839029081e-14, -2.284705416252596e-16,
 -5.890389430094754e-19,  1.593062048706816e-20, -2.232747252976813e-22,  8.263436158334127e-24,  1.737019527740430e-01, -2.598980983367005e-03,  2.730645899674348e-05,
 -2.295145968321533e-07,  1.479919199250452e-09, -5.404050990132611e-12, -3.364768578245869e-14,  8.547582008331335e-16, -1.148437872998303e-17,  7.831927512338807e-20,
 -2.448628487697495e-22,  1.019225608993862e-23,  3.089640722592555e-01, -4.447901021086584e-03,  4.206746728559152e-05, -2.722005562953797e-07,  6.076589413384891e-10,
  1.283686098149207e-11, -2.310124903602416e-13,  1.918188768652705e-15, -7.494942542962773e-18, -1.306690639670454e-19,  2.592549866619794e-21, -3.479422706411790e-25,
  4.826591628476166e-01, -6.564557761872634e-03,  5.215624299193417e-05, -1.699870652056388e-07, -2.110416998857950e-09,  3.957870875002792e-11, -2.767519858390232e-13,
 -1.036893263923563e-15,  4.113309361048699e-17, -4.920436640269576e-19,  1.192725605441107e-21,  8.546260531962378e-23,  6.937079483468277e-01, -8.680672949369276e-03,
  5.037241084600562e-05,  1.405059360730688e-07, -5.755148387807645e-09,  3.891150709557007e-11,  2.926975997486998e-13, -8.431514584245558e-15,  4.346361326164249e-17,
  6.278123272307570e-19, -1.405519789886584e-20,  1.183267613584334e-22,  9.391883391356256e-01, -1.037286246826912e-02,  2.875939740141735e-05,  6.147654664121746e-07,
 -6.508843401914900e-09, -4.007601466945883e-11,  1.196228483261996e-12, -2.463977098027129e-15, -1.915872763685623e-16,  1.692635708648187e-18,  2.087534349395373e-20,
 -4.040954854380815e-22,  1.212158869865969e+00, -1.100588975041060e-02, -1.679239430644201e-05,  9.448528124784849e-07,  1.482334145592685e-09, -1.509903119150629e-10,
 -6.922456745818614e-14,  2.855488804495593e-14, -4.992542123343055e-17, -6.233863237819397e-18,  2.186454209218961e-20,  1.464671307634832e-21,  1.497178837213014e+00,
 -9.766719516166662e-03, -7.361675672470005e-05,  5.043721203998817e-07,  1.466403525617718e-08, -1.880901807293707e-12, -3.182511768567190e-12, -2.096856653134019e-14,
  6.352280133072995e-16,  9.331558390307888e-18, -1.119984376404068e-19, -3.251950518220294e-21,  1.762144308660134e+00, -6.157965276289193e-03, -9.407673214386140e-05,
 -7.482431103695246e-07,  4.564908806271294e-09,  2.394210400953897e-10,  2.999255000245138e-12, -1.189516802728278e-14, -1.091389796896080e-15, -1.682784130380161e-17,
  2.275877788945415e-20,  5.882259676262095e-21,  1.949903595904509e+00, -1.583989447506003e-03, -3.594317963493667e-05, -6.813821907631019e-07, -1.107030727612306e-08,
 -1.494447047061787e-10, -1.452107510181133e-12, -2.049365760500488e-15,  3.410149974450816e-16,  1.050146460509629e-17,  2.072246591880799e-19,  2.948387154396377e-21,
  1.813053286626086e-02, -2.737455178806086e-04,  3.079184598262034e-06, -3.059800901091334e-08,  2.809935675694733e-10, -2.468461583005279e-12,  2.016962232899904e-14,
 -1.705088047868073e-16,  1.174931533553833e-18, -7.728981558530229e-21,  1.807860762338028e-22,  3.008592342484257e-24,  7.261718953562006e-02, -1.083351925976135e-03,
  1.182466690026210e-05, -1.109865819426545e-07,  9.243414322223401e-10, -6.944990687296803e-12,  4.275716713118064e-14, -2.390393075332315e-16, -7.053472977317561e-20,
  1.631755328868104e-20,  2.993701416099094e-22,  1.592837766265277e-23,  1.637260462211113e-01, -2.391151935760146e-03,  2.469066778371237e-05, -2.067369912972497e-07,
  1.365497605103717e-09, -5.963358089148622e-12, -1.444217855267007e-14,  5.317282775278645e-16, -8.676021347148439e-18,  8.385326072790329e-20,  6.886014245353869e-22,
  3.285143343796683e-23,  2.918251171179221e-01, -4.124243982871902e-03,  3.886694101489193e-05, -2.607076307624718e-07,  8.131477446957433e-10,  7.906351556192431e-12,
 -1.812222765626011e-13,  1.623753425588240e-15, -1.023048299346238e-17, -1.542348709339087e-20,  3.491236651384992e-21,  4.320946327869321e-23,  4.572217785854915e-01,
 -6.155983454350113e-03,  4.993873014694662e-05, -1.977894285378753e-07, -1.386913928897324e-09,  3.272115304442463e-11, -2.899101845166748e-13,  1.291004315905942e-17,
  2.524862403830007e-17, -3.615216485654742e-19,  5.588236901146978e-21,  1.195934642377614e-22,  6.597997642281065e-01, -8.272453539010268e-03,  5.153269378039615e-05,
  5.495387192348653e-08, -4.924905796201444e-09,  4.327773257346030e-11,  7.878360790650634e-14, -6.774617103042122e-15,  5.761908676133452e-17,  2.155237232556202e-19,
 -5.464372261761156e-21,  2.676056227515694e-22,  8.982011946552513e-01, -1.011509989758756e-02,  3.549024430966149e-05,  5.057365417770927e-07, -7.032180248112053e-09,
 -1.282594685591074e-11,  1.051529320447659e-12, -7.490227652718443e-15, -1.193956321828313e-16,  2.232157265239480e-18,  8.058941550288332e-21, -1.395715599957380e-22,
  1.167938708881511e+00, -1.109470153927431e-02, -5.411073168285581e-06,  9.445874624847500e-07, -1.491104655689974e-09, -1.434360784760691e-10,  6.761191679823879e-13,
  2.365668339339103e-14, -2.438294805440293e-16, -4.159974186037969e-18,  7.886197402887631e-20,  1.063297228586950e-21,  1.456978015584558e+00, -1.032748572228303e-02,
 -6.617166620949671e-05,  7.343910687075484e-07,  1.382811218725887e-08, -8.273670078491641e-11, -3.442228802980289e-12,  3.611435326271134e-15,  8.596740655156646e-16,
  2.431018531453599e-18, -2.168347756788396e-19, -1.043529056106469e-21,  1.735952617039969e+00, -6.944864692879749e-03, -1.024472271327693e-04, -6.331774143148802e-07,
  1.002346955058907e-08,  3.029206764903154e-10,  2.090812753094923e-12, -5.573872013303346e-14, -1.604540561358010e-15, -9.232647087070820e-18,  3.914115913803816e-19,
  1.049599673359724e-20,  1.942936196221151e+00, -1.907491800868152e-03, -4.528727153726323e-05, -8.843040457096664e-07, -1.440427032932608e-08, -1.833376124670747e-10,
 -1.286913869375821e-12,  1.678380850228817e-14,  9.022325121108603e-16,  2.166441032041157e-17,  3.553331886017438e-19,  3.501614899254677e-21,  1.708259546014075e-02,
 -2.505079042194934e-04,  2.737435627094002e-06, -2.647231415020388e-08,  2.360994018507105e-10, -2.037633145449067e-12,  1.589154856288333e-14, -1.356718978101534e-16,
  1.064114305332751e-18,  2.704719565214753e-21,  3.497311673875567e-22,  4.131773522293189e-24,  6.846488299377962e-02, -9.938407312739996e-04,  1.057715539527381e-05,
 -9.725483438602907e-08,  7.951626000853899e-10, -5.998729130864677e-12,  3.614583686896448e-14, -2.280877447491511e-16,  9.200901344677896e-19,  4.423639944214015e-20,
  1.125031344931499e-21,  1.946796370422864e-23,  1.545412894257236e-01, -2.203187717411831e-03,  2.233692739357326e-05, -1.858574636965220e-07,  1.243820916873500e-09,
 -6.159625984610815e-12, -2.930762489300281e-15,  3.108956485779006e-16, -4.760562242981493e-18,  1.457539967625527e-19,  2.493624515680791e-21,  4.397438481553413e-23,
  2.759305247121600e-01, -3.825590688453165e-03,  3.582100497956730e-05, -2.466537681546722e-07,  9.312745849702731e-10,  4.066161288114469e-12, -1.402065265066645e-13,
  1.318902313992390e-15, -7.704804029773457e-18,  1.736403795240464e-19,  6.158086192210249e-21,  6.850110623478229e-23,  4.333813623663104e-01, -5.766297459500968e-03,
  4.745248863610232e-05, -2.151210810702640e-07, -8.016127389581644e-10,  2.584873049871194e-11, -2.798231453159523e-13,  6.667671442487694e-16,  1.762856204947325e-17,
 -2.222233769767603e-20,  1.151803412168291e-20,  1.362034706103744e-22,  6.275368457003880e-01, -7.858827632367418e-03,  5.174807835427180e-05, -1.687811388890677e-08,
 -4.054704247860692e-09,  4.310688708005574e-11, -8.408347153598370e-14, -4.823872532171675e-15,  6.456608866600153e-17,  2.616750216660089e-19,  8.207950054867616e-21,
  3.234733416960666e-22,  8.583443596472875e-01, -9.808826311213168e-03,  4.087975862422023e-05,  3.924625973308079e-07, -7.055228685085062e-09,  9.538599744813055e-12,
  8.007991106734728e-13, -9.968681560138050e-15, -3.376662619582108e-17,  2.534456511327079e-18,  9.350558576288057e-21,  1.663382678498312e-22,  1.123544262666577e+00,
 -1.109326675341838e-02,  5.689592217636949e-06,  8.988694821294689e-07, -4.148962142046707e-09, -1.202567969071497e-10,  1.211576214923499e-12,  1.414781143754303e-14,
 -3.271478612828892e-16, -2.500032144889124e-19,  1.118046449182220e-19,  3.971527724839226e-22,  1.414670247693031e+00, -1.081800155688861e-02, -5.610039118418502e-05,
  9.380050714908276e-07,  1.137162114448727e-08, -1.610081568961470e-10, -2.954946964511331e-12,  3.082418628091447e-14,  7.902290219313783e-16, -6.026738746293380e-18,
 -1.770816498708319e-19,  2.864617600071264e-21,  1.706490355801163e+00, -7.791633557622674e-03, -1.088760510472834e-04, -4.222458819993008e-07,  1.642644114137284e-08,
  3.283938305724987e-10, -2.117510085231819e-13, -1.084505094605087e-13, -1.540526890714488e-15,  1.588559409151816e-17,  8.519721006155771e-19,  8.632584368606685e-21,
  1.934508514475151e+00, -2.316443037944384e-03, -5.740756871629507e-05, -1.145555798585698e-06, -1.832151714810247e-08, -2.044959348037349e-10, -2.743307350143020e-13,
  6.115309982087183e-14,  1.970774388291144e-15,  3.839402268354841e-17,  4.550452774580907e-19, -2.270022833358457e-22,  1.612243765829321e-02, -2.298178399379648e-04,
  2.441152329998016e-06, -2.300124264830096e-08,  1.988736527937640e-10, -1.697779246048363e-12,  1.260522220361420e-14, -9.704712511771970e-17,  1.450273084396932e-18,
  1.945755213556519e-20,  4.500772905763914e-22, -1.159822619393625e-24,  6.465165688156149e-02, -9.136842582373742e-04,  9.482620769982942e-06, -8.544698460830925e-08,
  6.833704105577261e-10, -5.202718914236036e-12,  3.048179560111444e-14, -1.629828258781231e-16,  3.499029832313462e-18,  1.025759854551161e-19,  1.632176307461171e-21,
 -2.868157680296513e-24,  1.460722694958948e-01, -2.033084511017380e-03,  2.022197439650373e-05, -1.669429713217700e-07,  1.120564525533754e-09, -6.137093355792254e-12,
  4.587837525214180e-15,  2.651647810442063e-16,  2.683418267684174e-18,  2.758997280614174e-19,  3.652583715523613e-21, -6.531117307283915e-24,  2.611829166873305e-01,
 -3.550603669453304e-03,  3.295268685379929e-05, -2.312734718386417e-07,  9.818266708637209e-10,  1.124107003012275e-12, -1.054190040496537e-13,  1.225172654739035e-15,
  3.598259500490467e-18,  4.661579698610446e-19,  7.825951717612269e-21, -2.139963868272669e-23,  4.110588041836593e-01, -5.397184445318963e-03,  4.480997918064065e-05,
 -2.241684590233818e-07, -3.499447002003942e-10,  1.942346134534879e-11, -2.526807607710819e-13,  1.317357747915285e-15,  2.633794191716700e-17,  5.297589901420877e-19,
  1.489680064826197e-20, -2.948134215322531e-23,  5.969267499132176e-01, -7.446691434907442e-03,  5.118426968781536e-05, -7.500750866527359e-08, -3.222433161912477e-09,
  3.971315731931464e-11, -1.882070451115179e-13, -2.518005307165735e-15,  8.296003909133001e-17,  8.283079735060833e-19,  1.816427714869914e-20,  4.981646804524175e-23,
  8.197902755708752e-01, -9.464848252951295e-03,  4.492142370933374e-05,  2.820533658220467e-07, -6.695136527040705e-09,  2.537346870678249e-11,  5.208686912186573e-13,
 -9.501881276365375e-15,  6.606238605308599e-17,  3.054908789731752e-18,  1.532482642287519e-20, -2.757132247475012e-23,  1.079328722656004e+00, -1.100590474127992e-02,
  1.600379101683404e-05,  8.149385012999840e-07, -6.237267280430037e-09, -8.758516122401709e-11,  1.466075959121431e-12,  4.416836411375878e-15, -2.538516950600077e-16,
  4.297873341053148e-18,  1.076360308172163e-19, -7.060916325057166e-22,  1.370575938111764e+00, -1.121895547326044e-02, -4.387048268833282e-05,  1.090678317361360e-06,
  7.525941782670730e-09, -2.189547026060990e-10, -1.778512386664600e-12,  5.157320197836011e-14,  4.839910903468051e-16, -9.782647979090046e-18,  1.721223803802581e-21,
  4.506721819876193e-21,  1.673556670963632e+00, -8.677949913571688e-03, -1.121532603972161e-04, -1.082794031694097e-07,  2.267189092556492e-08,  2.820805469657779e-10,
 -3.802253905572900e-12, -1.414663051010483e-13, -2.937735014373998e-16,  5.403631740260304e-17,  9.405686475828152e-19, -7.101516682079129e-21,  1.924229714997436e+00,
 -2.835983404990750e-03, -7.304729254467831e-05, -1.471049198289157e-06, -2.229588443266309e-08, -1.820072367456403e-10,  2.552663664570344e-12,  1.496327208895436e-13,
  3.647309816003403e-15,  5.275231590134578e-17,  1.387835038008796e-19, -1.751527664066236e-20,  1.524054973593713e-02, -2.113410653157574e-04,  2.183159722244746e-06,
 -2.007529175001880e-08,  1.677535004977577e-10, -1.421852573547953e-12,  1.066604136319369e-14, -3.628095641676737e-17,  2.427240169454294e-18,  3.239014965584807e-20,
  7.403619586371310e-23, -1.793610260398987e-23,  6.114240011529220e-02, -8.417465270916662e-04,  8.519551887191391e-06, -7.530702080387250e-08,  5.863434605506698e-10,
 -4.509425634320440e-12,  2.812491688217189e-14,  1.949436541261849e-17,  8.190905697099573e-18,  1.486248497758691e-19,  1.657742166433845e-22, -7.195140566225183e-23,
  1.382512134399882e-01, -1.879026460751881e-03,  1.832220942604031e-05, -1.499870652977014e-07,  9.996177421630266e-10, -5.918053198278986e-12,  1.489522110529499e-14,
  5.354362702306378e-16,  1.483898558958182e-17,  3.774989866986530e-19,  2.545786709879820e-22, -1.671230820792219e-22,  2.474905464370522e-01, -3.297815369273423e-03,
  3.027199008027580e-05, -2.155097376643271e-07,  9.819275033907175e-10, -9.637296093575087e-13, -6.657830328252639e-14,  1.663431822154585e-15,  2.516524911097330e-17,
  6.887888628674023e-19,  1.129984200664794e-21, -3.193000929691471e-22,  3.901698912008811e-01, -5.049532429787999e-03,  4.209815410556046e-05, -2.269747966841364e-07,
 -1.854968570604095e-11,  1.391854211682044e-11, -2.003560068251470e-13,  2.570933970732920e-15,  5.474938103807489e-17,  9.765003512235748e-19,  3.718450045615070e-21,
 -5.391719074850701e-22,  5.679520719627983e-01, -7.041635465846364e-03,  5.000019006006511e-05, -1.204759288301821e-07, -2.477365246474398e-09,  3.468259223464939e-11,
 -2.160923343256252e-13,  7.469873288529395e-16,  1.246074346400531e-16,  1.394700937024711e-18,  4.010166410835752e-21, -7.915734827194869e-22,  7.826685463475510e-01,
 -9.093716825377084e-03,  4.768204373438358e-05,  1.795853297957977e-07, -6.082528660664708e-09,  3.502610029703253e-11,  3.017053200472028e-13, -5.526877445977353e-15,
  1.844767682088160e-16,  3.375457249239790e-18, -7.843225473481434e-21, -1.197302504616796e-21,  1.035620544871056e+00, -1.084057446173254e-02,  2.513274156289673e-05,
  7.030680028398138e-07, -7.631130428624829e-09, -5.166258613578169e-11,  1.504707547076615e-12, -4.909378086558919e-16, -3.381945953999120e-17,  7.449279746677968e-18,
  3.468806693567071e-20, -2.796677749271681e-21,  1.325083515351515e+00, -1.151586504690408e-02, -3.021046663788456e-05,  1.174259826360087e-06,  2.844667717601177e-09,
 -2.428762221490949e-10, -1.684049641566402e-13,  6.179071751326019e-14,  1.747501526508449e-16, -6.507326103019617e-18,  1.319262746500058e-19,  3.968706359588732e-22,
  1.637051412483311e+00, -9.573816780554177e-03, -1.111096700330650e-04,  2.933051257121602e-07,  2.708312683813027e-08,  1.442655993670929e-10, -7.556339008134999e-12,
 -1.135199158588968e-13,  2.187933489807821e-15,  7.815816284069362e-17,  8.171381427560448e-20, -3.191281097566256e-20,  1.911596335698591e+00, -3.497283498054395e-03,
 -9.294511759251298e-05, -1.851891567933694e-06, -2.490842728184427e-08, -5.553302185779144e-11,  8.657885752579663e-12,  2.956957774286933e-13,  5.366669916473435e-15,
  3.212963200649543e-17, -1.493135136110907e-18, -6.187633720829795e-20,  1.442865198856448e-02, -1.947958444687176e-04,  1.957466654191432e-06, -1.760499747865462e-08,
  1.418438751452748e-10, -1.168229087948667e-12,  1.090596578357121e-14,  5.865797548657857e-17,  3.392538355877117e-18,  1.250577363748865e-20, -1.246661779543112e-21,
 -4.204984233857695e-23,  5.790621992664091e-02, -7.770519763209659e-04,  7.669301114747513e-06, -6.660957785018583e-08,  5.031227735372701e-10, -3.793454312851617e-12,
  3.310951626106173e-14,  3.605849943796914e-16,  1.263562101214745e-17,  6.294836702568906e-20, -5.181759482334392e-21, -1.709195828545995e-22,  1.310172361193965e-01,
 -1.739385107920860e-03,  1.661450154583294e-05, -1.349144256499370e-07,  8.863753937741288e-10, -5.314805491054857e-12,  3.848947546142133e-14,  1.211308110221431e-15,
  2.622849935020960e-17,  1.729775402582089e-19, -1.218984569864128e-20, -3.981585718174196e-22,  2.347676325844570e-01, -3.065718774396888e-03,  2.777926882532098e-05,
 -2.000221492428383e-07,  9.510128434318609e-10, -1.889291566214208e-12, -5.133927235387754e-15,  2.839243737633428e-15,  4.624756496190688e-17,  3.266994098918253e-19,
 -2.242939709914911e-20, -7.511395438408575e-22,  3.706281006614093e-01, -4.723627436504616e-03,  3.938109206707262e-05, -2.252774366560346e-07,  2.187269506181741e-10,
  1.020393315869784e-11, -9.868339295439857e-14,  4.855013572208073e-15,  8.492510995393743e-17,  4.364169799302067e-19, -3.613943755051780e-20, -1.271434965834063e-21,
  5.405754929439252e-01, -6.648039676206008e-03,  4.833866982121468e-05, -1.548305355150042e-07, -1.831358370327669e-09,  3.024337701108588e-11, -1.320799955599449e-13,
  5.479822266517869e-15,  1.661309057039601e-16,  5.070096058387731e-19, -5.726893946935413e-20, -1.991574395188682e-21,  7.470679776971310e-01, -8.705239239359846e-03,
  4.927742474562483e-05,  8.822324916678762e-08, -5.318226126395425e-09,  4.118406033742231e-11,  2.466854735233516e-13,  2.125878561254127e-15,  2.828733711031837e-16,
  1.478620596265129e-18, -1.005250469879942e-19, -3.024911335051388e-21,  9.927107862037969e-01, -1.060790673278570e-02,  3.280921660237069e-05,  5.746623812650812e-07,
 -8.303933197169019e-09, -1.558632817880743e-11,  1.516404879790403e-12,  2.696567568260726e-15,  2.223215623438327e-16,  5.565154747219887e-18, -1.490572647149949e-19,
 -5.521974071890192e-21,  1.278626538881534e+00, -1.170077819921759e-02, -1.600564094703598e-05,  1.181291906343331e-06, -1.910657149356235e-09, -2.257060134076244e-10,
  1.611608799921381e-12,  6.455260377170154e-14,  1.899485406715950e-17, -3.185791343783699e-18, -2.612668856447285e-20, -7.745012608671350e-21,  1.597011284497767e+00,
 -1.044109829038297e-02, -1.049292692489836e-04,  7.389587478937195e-07,  2.794921898385576e-08, -6.476968890122239e-11, -9.344802493181831e-12, -9.361103846926496e-16,
  4.673349524839615e-15,  4.835405815233335e-17, -1.646530084381046e-18, -4.175094140288811e-20,  1.895969771103485e+00, -4.336505961175671e-03, -1.175505547228449e-04,
 -2.244849184700261e-06, -2.316771401766630e-08,  2.715204462776508e-10,  1.939709476319182e-11,  4.679813342012032e-13,  4.623944852883137e-15, -1.005493542637781e-16,
 -5.590669714258335e-18, -1.217986256968846e-19,  1.367950234510791e-02, -1.799442492181203e-04,  1.759100792561821e-06, -1.550741042476703e-08,  1.212933664906318e-10,
 -8.745332611375874e-13,  1.404474881853397e-14,  1.608637893771657e-16,  2.453694901731134e-18, -7.891903758741221e-20, -3.373613595092983e-21, -4.781526884986082e-23,
  5.491584448648545e-02, -7.187634428691363e-04,  6.915933524341666e-06, -5.911912684591183e-08,  4.362563412395932e-10, -2.831704728546528e-12,  4.883034698163031e-14,
  7.451732161011652e-16,  9.171172248190004e-18, -3.134679745976195e-19, -1.384285061924792e-20, -1.949571300371680e-22,  1.243156044223484e-01, -1.612711581983265e-03,
  1.507731098059388e-05, -1.215193264466691e-07,  7.925634186132482e-10, -3.887734412165202e-12,  8.420782635671012e-14,  2.018847885117733e-15,  1.901848521059213e-17,
 -7.088854674716179e-19, -3.238495898271985e-20, -4.551150875749665e-22,  2.229343856312013e-01, -2.852829780008554e-03,  2.546911290207748e-05, -1.850848217998297e-07,
  9.193166346529616e-10, -8.883234180842331e-13,  9.521411944644151e-14,  4.263857831270404e-15,  3.307280654862617e-17, -1.313766276829616e-18, -6.050201382344897e-20,
 -8.586906636933289e-22,  3.523466709967800e-01, -4.419317597074827e-03,  3.670521812540060e-05, -2.202220494318238e-07,  4.117358428953234e-10,  9.775550568700933e-12,
  7.499349094958188e-14,  7.425922282363651e-15,  5.973813685407183e-17, -2.267905301512014e-18, -1.006449748618629e-19, -1.458130582033990e-21,  5.147443421603313e-01,
 -6.269215158796518e-03,  4.632446436368536e-05, -1.794025606448798e-07, -1.242657722403054e-09,  2.951191219354026e-11,  9.430015356038363e-14,  1.045861709336874e-14,
  1.197261587850318e-16, -3.768172805966560e-18, -1.592128437687096e-19, -2.320193549790781e-21,  7.130402076820707e-01, -8.308166816827452e-03,  4.985387782765201e-05,
  1.008170276921836e-08, -4.425147095549517e-09,  4.885618867280931e-11,  4.337732352100861e-13,  1.096830224407814e-14,  2.280502572649597e-16, -5.567117409140977e-18,
 -2.561316646620745e-19, -3.554650387466946e-21,  9.508445775501670e-01, -1.032011852680893e-02,  3.890421504276795e-05,  4.413250333293578e-07, -8.240856170255553e-09,
  2.264890134952704e-11,  1.710499126488390e-12,  1.135671721265161e-14,  2.519502495103681e-16, -5.735670954500241e-18, -4.204551102333307e-19, -6.029959884955313e-21,
  1.231655948926082e+00, -1.177296738292866e-02, -2.154040954213728e-06,  1.117324169694590e-06, -5.891767026542310e-09, -1.654010676244085e-10,  3.404437370730999e-12,
  6.233481622300526e-14, -2.146450205804079e-16, -1.291521014494865e-17, -4.912283390634537e-19, -1.177888149354620e-20,  1.553634688347878e+00, -1.123763660943082e-02,
 -9.346011749849570e-05,  1.163908053848535e-06,  2.450118014922720e-08, -2.713915917881490e-10, -7.125971315132355e-12,  1.604027000766961e-13,  4.826321097150307e-15,
 -4.924723797436385e-17, -3.039837149789155e-18, -1.531762284526938e-20,  1.876564212764348e+00, -5.390364595563833e-03, -1.464389394381403e-04, -2.542099625240524e-06,
 -1.195488116905107e-08,  9.058577463088090e-10,  3.365769019491228e-11,  5.040828617620126e-13, -4.344385579015071e-15, -4.321273623507866e-16, -1.062377226376185e-17,
 -6.621071857480511e-20,  1.298673738156839e-02, -1.665840089813609e-04,  1.584142639138850e-06, -1.368667998216606e-08,  1.075693050118381e-10, -4.781841926518279e-13,
  1.901448492552741e-14,  1.643972209550118e-16, -3.218754372742649e-18, -2.429437642055221e-19, -4.305034582279321e-21,  2.532169352299005e-23,  5.214711501171655e-02,
 -6.661588844832694e-04,  6.246742392045326e-06, -5.252090675413108e-08,  3.931435928767309e-10, -1.390855939857858e-12,  7.126018303763707e-14,  7.370172610506105e-16,
 -1.372216129999982e-17, -9.858646072577394e-19, -1.764831036453383e-20,  1.029773529869720e-22,  1.180970571740576e-01, -1.497715541400387e-03,  1.369300958367603e-05,
 -1.093304823565922e-07,  7.398173108919957e-10, -1.153032591850229e-12,  1.434375799259195e-13,  1.935900555553077e-15, -3.365697448931435e-17, -2.282053218701027e-18,
 -4.132680386498856e-20,  2.373133327977448e-22,  2.119168583778794e-01, -2.657711229931309e-03,  2.333627984163855e-05, -1.703517216248513e-07,  9.344384111744313e-10,
  2.887017326515612e-12,  2.186019229627868e-13,  4.035587692748150e-15, -6.504881776961847e-17, -4.260648576966386e-18, -7.760928718827065e-20,  4.339262238668783e-22,
  3.352401261615948e-01, -4.136118661608656e-03,  3.410904862548602e-05, -2.118990767904097e-07,  6.427732276854647e-10,  1.418049850698174e-11,  2.912272060556586e-13,
  7.147252775927520e-15, -1.067658250753181e-16, -7.195345601827263e-18, -1.303022447314201e-19,  7.018538977150963e-22,  4.903946219602308e-01, -5.907522593734874e-03,
  4.407250103723902e-05, -1.943349287831360e-07, -6.045363838187834e-10,  3.554838453041630e-11,  4.105985396170702e-13,  1.071935049711738e-14, -1.503860651209605e-16,
 -1.158283475085166e-17, -2.072931880213015e-19,  1.073621695701088e-21,  6.806043726414857e-01, -7.909977008015373e-03,  4.958443582224357e-05, -5.222188714296978e-08,
 -3.315845492232346e-09,  6.351399636758898e-11,  7.972557017860582e-13,  1.281982366754450e-14, -1.871855611711047e-16, -1.803060651820122e-17, -3.298604148593958e-19,
  1.656557615688992e-21,  9.102170114596632e-01, -9.989893208983153e-03,  4.343149373112578e-05,  3.154464797436189e-07, -7.348163033917650e-09,  6.810933914284038e-11,
  2.084516154066484e-12,  1.242476631610185e-14, -3.089443526034896e-16, -2.634424113373140e-17, -5.497007232344166e-19,  2.412193502078463e-21,  1.184611977303009e+00,
 -1.173839041253592e-02,  1.059502787011751e-05,  1.001603553434162e-06, -8.247752920572322e-09, -6.411503831802913e-11,  4.951267876173347e-12,  4.331484326638882e-14,
 -1.142104609490190e-15, -4.084859880003157e-17, -8.119077161263484e-19,  1.330376879289984e-21,  1.507286036224565e+00, -1.192324977043010e-02, -7.734546059033405e-05,
  1.505023657625631e-06,  1.780703590128042e-08, -3.735617479435158e-10, -9.097664206362762e-13,  2.625594137925240e-13,  8.362871980803871e-16, -1.692513908962167e-16,
 -2.543515654965269e-18,  4.180395811690447e-20,  1.852464142472232e+00, -6.685464621769682e-03, -1.773397964426319e-04, -2.540248034144731e-06,  1.523031609315819e-08,
  1.849946738694051e-09,  4.289380882547730e-11,  3.362089322841682e-14, -2.742090987149164e-14, -8.165394252314554e-16, -5.183501370453618e-18,  4.033018088760857e-19,
  1.234474799944841e-02, -1.545391288795399e-04,  1.429997372485371e-06, -1.201604441011599e-08,  1.028435039619966e-10,  1.259914098254643e-14,  2.065072582993133e-14,
 -1.066336700503936e-16, -1.433251681917077e-17, -3.398254238494365e-19,  1.035261902740815e-21,  2.393739250802105e-22,  4.957858473979182e-02, -6.186004945880173e-04,
  5.653632349025199e-06, -4.635456390260695e-08,  3.836884602986139e-10,  4.801768460674198e-13,  7.955178107890950e-14, -3.852537333480609e-16, -5.893757245181516e-17,
 -1.384739754706816e-18,  4.133316451711344e-21,  9.771426357790085e-22,  1.123172574517358e-01, -1.393218556079608e-03,  1.245195388755848e-05, -9.747568467211832e-08,
  7.545827263685202e-10,  2.731918703355469e-12,  1.681931267414364e-13, -7.260759995283421e-16, -1.386464904133784e-16, -3.222072529868195e-18,  9.318181951417849e-21,
  2.276235277888569e-21,  2.016468143516776e-01, -2.478937299693966e-03,  2.138468450135619e-05, -1.546215522850898e-07,  1.051906553135981e-09,  9.092920136932180e-12,
  2.755959853272020e-13, -1.009277086909339e-15, -2.614691976866137e-16, -6.039266569916762e-18,  1.678577507896611e-20,  4.257326460947963e-21,  3.192255706786502e-01,
 -3.873218274418840e-03,  3.163871703919120e-05, -1.989083652253409e-07,  1.009355161196870e-09,  2.291312107720536e-11,  3.981809498241062e-13, -1.271034836297246e-15,
 -4.383493932697796e-16, -1.020560347696001e-17,  2.706280858881961e-20,  7.134413147876459e-21,  4.674547661747593e-01, -5.564377135658157e-03,  4.170788614218686e-05,
 -1.976975458631901e-07,  2.246472113076236e-10,  4.802292561550546e-11,  5.704793756955032e-13, -2.132886850178917e-15, -6.833406929586819e-16, -1.641909830398461e-17,
  4.063498902198867e-20,  1.130439119620766e-20,  6.497527098706289e-01, -7.516606259210720e-03,  4.868502454020429e-05, -9.397220883116355e-08, -1.831501205477197e-09,
  8.559529521920811e-11,  9.584805225087774e-13, -5.743469678351291e-15, -1.022322814483160e-15, -2.587657904615275e-17,  5.450427753842350e-20,  1.758517791451603e-20,
  8.709736540667037e-01, -9.629176879985131e-03,  4.656543245648458e-05,  2.115771279325825e-07, -5.467523606353159e-09,  1.201785174158719e-10,  2.124025519945010e-12,
 -1.632864049676805e-14, -1.573739829210699e-15, -4.003317677746998e-17,  5.117703199532267e-20,  2.775876553775207e-20,  1.137900817244128e+00, -1.160785043706120e-02,
  2.180199004929802e-05,  8.661560983428204e-07, -8.271398350025416e-09,  6.356958163512536e-11,  5.390110086400700e-12, -2.233497300688813e-14, -3.092090336403666e-15,
 -6.168074664290286e-17,  8.859485552619497e-20,  4.475165669176878e-20,  1.458475986225903e+00, -1.246549196604083e-02, -5.781930384313708e-05,  1.731455855605508e-06,
  1.070247791007530e-08, -3.103715788514932e-10,  5.787701606502270e-12,  1.770842093001404e-13, -6.446239859567447e-15, -2.120167580034349e-16,  1.002005233481753e-18,
  1.235326916256712e-19,  1.822701793771537e+00, -8.218803822731283e-03, -2.049627055859834e-04, -1.946455202049639e-06,  6.197061025267995e-08,  2.764061487286287e-09,
  2.711489494116799e-11, -1.305673504917962e-12, -5.416574738273606e-14, -4.378516674946435e-16,  2.959386933094221e-17,  1.121593226509745e-18,  1.174859794883973e-02,
 -1.436477618034495e-04,  1.295768040089865e-06, -1.034368886321618e-08,  1.074969307704126e-10,  4.101369975837629e-13,  9.603334573892062e-15, -7.279667405104217e-16,
 -2.261896918959514e-17, -1.771475534233476e-20,  1.635529022934165e-20,  4.026788069796092e-22,  4.719126703676263e-02, -5.754907235160723e-04,  5.134844137091556e-06,
 -4.004304647927932e-08,  4.102256470430841e-10,  2.004360337174575e-12,  3.567168075890648e-14, -2.934629977465571e-15, -9.273361623736668e-17, -7.258567017957064e-20,
  6.675262575686312e-20,  1.648161147377409e-21,  1.069365032763008e-01, -1.298071009417065e-03,  1.135715566533739e-05, -8.476316578843817e-08,  8.449222145388602e-10,
  5.924293287407800e-12,  7.017132511403676e-14, -6.708145220987551e-15, -2.174294460212212e-16, -1.735961750642364e-19,  1.555388924657437e-19,  3.857851089938982e-21,
  1.920618938120565e-01, -2.314979508888484e-03,  1.963730177770788e-05, -1.360058667231310e-07,  1.291930668984374e-09,  1.423696362567660e-11,  1.009598964773694e-13,
 -1.227838323401583e-14, -4.096382762010791e-16, -3.506106161793225e-19,  2.913016585659680e-19,  7.269154877003940e-21,  3.042242375495070e-01, -3.629343584103483e-03,
  2.936540853583958e-05, -1.786181094327232e-07,  1.550749540895900e-09,  3.014308543407490e-11,  1.167033653404085e-13, -2.021707746094215e-14, -6.902162567210677e-16,
 -6.846265817608165e-19,  4.895841769622395e-19,  1.230992610028898e-20,  4.458497470225010e-01, -5.240064901468928e-03,  3.939100943100985e-05, -1.857470437256657e-07,
  1.302225980393174e-09,  5.802008632807705e-11,  1.247246213117334e-13, -3.195077505108831e-14, -1.092451154447537e-15, -1.360943717029099e-18,  7.785918814388594e-19,
  1.977174859793231e-20,  6.204575811084587e-01, -7.131997250652312e-03,  4.744174281303441e-05, -1.084628436184964e-07,  7.485058355583955e-11,  1.021705734222457e-10,
  2.131080773247388e-13, -5.108102455995592e-14, -1.676172013659337e-15, -2.693558475108453e-18,  1.211512031190915e-18,  3.125368813247079e-20,  8.332162358013301e-01,
 -9.247785463469067e-03,  4.866705830434468e-05,  1.458208357908421e-07, -2.626008772610933e-09,  1.587301769584583e-10,  7.645632376908881e-13, -8.640217152346435e-14,
 -2.599634451960972e-15, -4.592582119866504e-18,  1.897544013000616e-18,  5.041091839415883e-20,  1.091881081537677e+00, -1.139396851434544e-02,  3.146541230472449e-05,
  7.505746160485674e-07, -5.823077499429547e-09,  1.723331755835995e-10,  3.077729133078231e-12, -1.512869101649882e-13, -4.625914787448502e-15, -2.879872773869148e-18,
  3.172698861853975e-18,  8.607322799483375e-20,  1.407824057507295e+00, -1.284244180596007e-02, -3.619138423711399e-05,  1.861764364818333e-06,  6.137267571744681e-09,
 -1.417596083733222e-10,  6.835144147641560e-12, -1.313999461767121e-13, -1.181638454878765e-14, -3.882697134728203e-17,  8.102069717046624e-18,  1.792223514006207e-19,
  1.786428777174862e+00, -9.930724592487375e-03, -2.204748303928889e-04, -4.933587478361028e-07,  1.197616284387533e-07,  2.776264842651899e-09, -3.388925920448389e-11,
 -2.966579777301061e-12, -3.700331623391619e-14,  1.664258634376994e-15,  6.865330962413870e-17,  1.453941808103149e-19,  1.119399522422064e-02, -1.337482108707213e-04,
  1.182252340972070e-06, -8.553951863693792e-09,  1.159472651708918e-10,  3.189484044931957e-13, -1.992648438864853e-14, -1.305200927204528e-15, -7.926593335636445e-18,
  8.974301373504289e-19,  2.516249474191101e-20, -1.830241398832233e-22,  4.496858010376077e-02, -5.362192691200089e-04,  4.695092285537194e-06, -3.314601694321735e-08,
  4.505527565867061e-10,  1.558380018511255e-12, -8.401491370459011e-14, -5.303563848631092e-15, -3.271741399423337e-17,  3.667682145849837e-18,  1.029597031927448e-19,
 -7.425483979176842e-22,  1.019198283464127e-01, -1.211043351088275e-03,  1.042510890844700e-05, -7.028261762499196e-08,  9.611284675802469e-10,  4.613015627443056e-12,
 -2.056939749477283e-13, -1.227196519255282e-14, -7.751403161947125e-17,  8.561554725652626e-18,  2.409233554763194e-19, -1.712213421200087e-21,  1.831063610349621e-01,
 -2.164036161944999e-03,  1.813869752173694e-05, -1.130681937034410e-07,  1.565687792986347e-09,  1.113632919619846e-11, -4.089130020539595e-13, -2.278611076130253e-14,
 -1.479079030056046e-16,  1.606147526443211e-17,  4.539182035620420e-19, -3.156778636776072e-21,  2.901637905354449e-01, -3.402526509297822e-03,  2.739061900539670e-05,
 -1.490671792451012e-07,  2.123343958525235e-09,  2.379197070609409e-11, -7.297388038345439e-13, -3.797762673499032e-14, -2.524384763765838e-16,  2.701425135448070e-17,
  7.689220535963042e-19, -5.189774421908514e-21,  4.255062422716946e-01, -4.933411024883168e-03,  3.732488009974290e-05, -1.558389679765856e-07,  2.400400133300224e-09,
  4.653667294759886e-11, -1.214780026522834e-12, -6.016382587151203e-14, -4.032455348982701e-16,  4.293273930520999e-17,  1.235556659013409e-18, -8.011769417000081e-21,
  5.926806491193746e-01, -6.757494910247848e-03,  4.621412094862364e-05, -9.123274744740246e-08,  2.023272716693640e-09,  8.436812666485927e-11, -1.901611608425762e-12,
 -9.450257510990828e-14, -6.179408082314677e-16,  6.678809312403529e-17,  1.950786509277479e-18, -1.200272598256621e-20,  7.970141613475267e-01, -8.851920883398919e-03,
  5.027015596301645e-05,  1.292108441685934e-07,  4.891362810312666e-10,  1.391204918595711e-10, -2.716427535218357e-12, -1.536631515401782e-13, -9.380054741480226e-16,
  1.056943724882374e-16,  3.124330772807931e-18, -1.804070141843721e-20,  1.046863829744621e+00, -1.110752183715139e-02,  4.003539008196535e-05,  6.872596174989452e-07,
 -2.063978630211259e-09,  1.795928128204965e-10, -3.031568902449150e-12, -2.697256657248212e-13, -1.650374288439373e-15,  1.835554222089409e-16,  5.315692614444399e-18,
 -3.004274277102148e-20,  1.356018856528917e+00, -1.304110573564441e-02, -1.333097875175556e-05,  1.944180745159876e-06,  4.427482924513451e-09, -6.329743294635325e-11,
 -1.821080529055832e-12, -4.558033407021852e-13, -5.806564260269494e-15,  4.002408252642536e-16,  1.188308539530825e-17, -9.480519290456296e-20,  1.743191797618831e+00,
 -1.168184344406075e-02, -2.132898784526224e-04,  1.793079906861526e-06,  1.600358323124304e-07,  9.059693843060269e-10, -1.209414362469704e-10, -2.705059777478238e-12,
  6.526695251981222e-14,  3.567703277415152e-15,  3.197020972115977e-19, -3.309676758015353e-18,  1.067731319218504e-02, -1.246689904525185e-04,  1.090827961684666e-06,
 -6.686244420705231e-09,  1.145851095567489e-10, -5.904878673682343e-13, -5.397900453760620e-14, -8.851980672322106e-16,  3.722599769931113e-17,  1.375614050325571e-18,
 -1.015373908344339e-20, -1.350997248942722e-21,  4.289648033654054e-02, -5.001255854236703e-04,  4.341127648488527e-06, -2.584818771903978e-08,  4.495282604887414e-10,
 -2.211072501632376e-12, -2.224613628571251e-13, -3.596119347870561e-15,  1.519360808278731e-16,  5.628505872069092e-18, -4.140878421406156e-20, -5.531094214045743e-21,
  9.723749061366467e-02, -1.130749935346449e-03,  9.675839388581648e-06, -5.455233042687981e-08,  9.761687022618521e-10, -4.383483518570952e-12, -5.263131436866762e-13,
 -8.317142213304547e-15,  3.540550803017593e-16,  1.316673416252163e-17, -9.633332147287913e-20, -1.295456976950989e-20,  1.747324602143851e-01, -2.023915613835779e-03,
  1.693720930719985e-05, -8.698717346425573e-08,  1.638513178268729e-09, -6.222913476418152e-12, -1.004775747063742e-12, -1.542901286143130e-14,  6.633462016072715e-16,
  2.478455192434791e-17, -1.799359364229311e-19, -2.443893191988128e-20,  2.769814583377355e-01, -3.189951066583123e-03,  2.581727576086429e-05, -1.126030859562575e-07,
  2.337710380195475e-09, -6.307482660132735e-12, -1.723532525027871e-12, -2.567431688334552e-14,  1.116284765495243e-15,  4.189699065551872e-17, -3.012512261698623e-19,
 -4.147117913708017e-20,  4.063589510325323e-01, -4.641581778577154e-03,  3.570925192098136e-05, -1.121483916782107e-07,  2.902789241057269e-09, -2.558794796101546e-12,
 -2.788913277482638e-12, -4.056615015331228e-14,  1.781931493774867e-15,  6.706056068351693e-17, -4.772374170134386e-19, -6.681144468193319e-20,  5.663840819338068e-01,
 -6.391503171074781e-03,  4.535872975125017e-05, -4.874772025040616e-08,  3.039584374285616e-09,  7.445476075473862e-12, -4.370012052399322e-12, -6.348841835405206e-14,
  2.801593492622950e-15,  1.052496528815440e-16, -7.440251647544173e-19, -1.059917215438329e-19,  7.624210490300352e-01, -8.443243350323561e-03,  5.194395870485835e-05,
  1.542830412411574e-07,  2.271355983503856e-09,  2.319286213109802e-11, -6.717747415515528e-12, -1.030038713182031e-13,  4.499651780191486e-15,  1.676387274233761e-16,
 -1.198593089293999e-18, -1.716939387060565e-19,  1.003126059653786e+00, -1.075457723070109e-02,  4.818301260857505e-05,  6.764339994018004e-07,  1.885123071952409e-10,
  1.766022689192800e-11, -1.007592123666157e-11, -1.832155396361560e-13,  7.719963536053317e-15,  2.869541523124636e-16, -2.211532627638902e-18, -3.006532906764001e-19,
  1.303790422237959e+00, -1.305336264843021e-02,  1.036242604551466e-05,  1.998001010066868e-06,  1.649424090560662e-09, -2.649536997182906e-10, -1.446431442423859e-11,
 -3.382108629315976e-13,  1.451027491580188e-14,  6.107022294534086e-16, -5.780643033797248e-18, -6.713078521157499e-19,  1.693249909106436e+00, -1.325831792037979e-02,
 -1.763793343694896e-04,  4.320854966879520e-06,  1.446932425592430e-07, -2.558422989066477e-09, -1.499206965289430e-10,  1.127906385546211e-12,  1.552402473597990e-13,
  3.945614453756828e-16, -1.495798258012145e-16, -1.952292859632907e-18,  1.019562452736326e-02, -1.162335243079985e-04,  1.020959452814813e-06, -5.023219688745452e-09,
  8.868284479367061e-11, -2.008813837093819e-12, -5.589463453686542e-14,  9.008471866295101e-16,  6.493499965982425e-17, -1.935021019702379e-19, -6.180033710354418e-20,
 -4.537333642497437e-22,  4.096363723826559e-02, -4.665203731818101e-04,  4.071640200381696e-06, -1.932175828399286e-08,  3.473131621004118e-10, -8.045400232038435e-12,
 -2.297425135580734e-13,  3.700135387080456e-15,  2.653422450608034e-16, -7.922785778066207e-19, -2.530422357258043e-19, -1.861048850422392e-21,  9.286551842597887e-02,
 -1.055707617514590e-03,  9.109657762374966e-06, -4.037232446634385e-08,  7.516071011995154e-10, -1.814639686212465e-11, -5.412751715560095e-13,  8.709037036835661e-15,
  6.194365838021152e-16, -1.857912417279797e-18, -5.927377602857553e-19, -4.371225125022824e-21,  1.669017874373150e-01, -1.892166139354450e-03,  1.604203299243533e-05,
 -6.317094149322880e-08,  1.253456627830476e-09, -3.240204361767482e-11, -1.027945006810671e-12,  1.652451250210877e-14,  1.162986582834706e-15, -3.520406134541315e-18,
 -1.118303842121561e-18, -8.274053201102789e-21,  2.646270382347142e-01, -2.988207001539327e-03,  2.467855869880944e-05, -7.861189415988897e-08,  1.765861467333245e-09,
 -5.104321785751287e-11, -1.753502333688731e-12,  2.818275246783095e-14,  1.960573547440004e-15, -6.041459831949075e-18, -1.897531509414215e-18, -1.407991441490322e-20,
  3.883565267812558e-01, -4.360530198779914e-03,  3.462795119837700e-05, -6.999407140329374e-08,  2.132082234997295e-09, -7.472791216784421e-11, -2.824241947677377e-12,
  4.547426484787653e-14,  3.130824375326922e-15, -9.976721492103017e-18, -3.055637663654174e-18, -2.267968019081190e-20,  5.415412369741326e-01, -6.030174278265079e-03,
  4.505088985458895e-05, -5.002773673002349e-09,  2.061409743902704e-09, -1.055748994773912e-10, -4.418647340198448e-12,  7.162798321922736e-14,  4.907752815941734e-15,
 -1.663825771681033e-17, -4.842353886730314e-18, -3.565441302455686e-20,  7.294917472140001e-01, -8.019693395032694e-03,  5.399850585059486e-05,  1.849529433068632e-07,
  9.946655497424119e-10, -1.515059329402835e-10, -6.833485711569264e-12,  1.130235005899916e-13,  7.811423696655906e-15, -2.963749266999622e-17, -7.828128649675237e-18,
 -5.575784530074239e-20,  9.609300804930820e-01, -1.033665776997209e-02,  5.628410077696574e-05,  6.680058376560228e-07, -2.111623939524522e-09, -2.495362189823325e-10,
 -1.047129231397265e-11,  1.853662617146248e-13,  1.321277053696460e-14, -6.130610691025476e-17, -1.364907488655974e-17, -8.601849785641751e-20,  1.251894552621119e+00,
 -1.287464714672504e-02,  3.425480529332176e-05,  1.961094871813354e-06, -7.541286782222903e-09, -6.560042333424951e-10, -1.478586641034848e-11,  3.752064646128994e-13,
  2.532140096210942e-14, -1.740712154191287e-16, -2.926113683574202e-17, -9.711013433118873e-20,  1.637771901216779e+00, -1.442766031151913e-02, -1.129071834267242e-04,
  6.051684379709661e-06,  6.290159986961701e-08, -5.246223956759524e-09, -5.524707270828259e-11,  5.126626000676379e-12,  6.053663278753116e-14, -5.139012789672057e-15,
 -7.265544748349501e-17,  5.154041712004889e-18,  9.746673520116602e-03, -1.082863095050477e-04,  9.676655337836453e-07, -3.986042266414766e-09,  3.825848613082824e-11,
 -2.836376194101197e-12, -6.019570343085323e-15,  2.399288073510435e-15,  1.601538829413803e-17, -2.256324877882652e-18, -2.210913520055890e-20,  2.065262829561458e-21,
  3.916134862140207e-02, -4.347941604943028e-04,  3.866976433391127e-06, -1.530013938908098e-08,  1.442490828156543e-10, -1.145304974870973e-11, -2.544311467176276e-14,
  9.818452415977416e-15,  6.505578922448886e-17, -9.235907694195161e-18, -9.026353066960181e-20,  8.469172833542751e-21,  8.878562134638299e-02, -9.845953905137797e-04,
  8.683399722032824e-06, -3.183506462057151e-08,  2.892377702948324e-10, -2.619711974603408e-11, -6.250543940299195e-14,  2.297236127409008e-14,  1.502808155712460e-16,
 -2.162450423447081e-17, -2.102979868196706e-19,  1.989206633843609e-20,  1.595854011406108e-01, -1.766578026587391e-03,  1.537918864755933e-05, -4.941199391167063e-08,
  4.162892143788425e-10, -4.774245740324642e-11, -1.246726438620286e-13,  4.324550422889773e-14,  2.775988073734469e-16, -4.077247528012069e-17, -3.932286552332757e-19,
  3.768434175711857e-20,  2.530636519622427e-01, -2.794162204777127e-03,  2.386466736345928e-05, -6.042351809944486e-08,  4.219369881061642e-10, -7.729570289962109e-11,
 -2.228671251031438e-13,  7.308075968764966e-14,  4.568240439624029e-16, -6.912748548902070e-17, -6.576138122167301e-19,  6.432385760781451e-20,  3.714637760384161e-01,
 -4.086420955620052e-03,  3.393309922053745e-05, -5.089605833086027e-08,  1.168442680064653e-10, -1.170882991720181e-10, -3.699127385783103e-13,  1.168106364145097e-13,
  7.036641495194496e-16, -1.112082543906370e-16, -1.033753707532133e-18,  1.044643336319693e-19,  5.181415123364062e-01, -5.669639880945312e-03,  4.510299764227964e-05,
  6.306719924583302e-09, -8.636483662929247e-10, -1.717033573680931e-10, -5.695859984092969e-13,  1.825558397654242e-13,  1.042311829719042e-15, -1.759919903624394e-16,
 -1.570051900343195e-18,  1.675740146414185e-19,  6.982910204000722e-01, -7.578837943933252e-03,  5.618866305188102e-05,  1.692659408244459e-07, -3.285264798988102e-09,
 -2.524347759658620e-10, -7.567867704890901e-13,  2.871394299386314e-13,  1.502238197141174e-15, -2.837012551153728e-16, -2.334758800705594e-18,  2.757375495719794e-19,
  9.205333553844328e-01, -9.855351005558725e-03,  6.389528938604391e-05,  5.832006000350893e-07, -8.970474564802032e-09, -3.965640943657102e-10, -4.308608240502942e-13,
  4.716756814258517e-13,  2.031787672852169e-15, -4.898454962055635e-16, -3.328628404663716e-18,  4.932350320702205e-19,  1.201088744853851e+00, -1.250962584601231e-02,
  5.658196812459052e-05,  1.721260230574657e-06, -2.293904887740286e-08, -8.068237055903420e-10,  4.591535842908051e-12,  8.771034079024234e-13,  9.096554194016465e-16,
 -1.002640198226590e-15, -2.980960656768097e-18,  1.093372953759908e-18,  1.578728029416201e+00, -1.503151966373219e-02, -3.780645419232542e-05,  6.197122350993550e-06,
 -4.328433322750659e-08, -4.809948563813392e-09,  8.636346438091746e-11,  4.018935183175773e-12, -1.183864289535957e-13, -3.301735797544221e-15,  1.445920367128014e-16,
  2.563884929918107e-18,  9.328717073649106e-03, -1.007301570370441e-04,  9.216711750562107e-07, -3.812677736296620e-09, -1.449873912527982e-11, -2.193322435315806e-12,
  5.598512085656324e-14,  1.627131652450150e-15, -5.844572889890029e-17, -1.307582669067673e-18,  6.123216712348711e-20,  9.754398572620640e-22,  3.748291352988629e-02,
 -4.045706769200629e-04,  3.689812976408133e-06, -1.476414556054230e-08, -6.876787151479320e-11, -8.842688705905649e-12,  2.280845091833696e-13,  6.644680554366162e-15,
 -2.394417100781977e-16, -5.334250789831604e-18,  2.510910803522244e-19,  3.979386408974510e-21,  8.498381394900041e-02, -9.166168596552722e-04,  8.312192152167319e-06,
 -3.126126402519322e-08, -1.979172082816988e-10, -2.016813232899208e-11,  5.298132696288919e-13,  1.548878971543741e-14, -5.613977791305249e-16, -1.241346714352547e-17,
  5.897118443044252e-19,  9.259357273143385e-21,  1.527614660970339e-01, -1.645874631705371e-03,  1.479530142246175e-05, -5.014074643924599e-08, -4.710930385444031e-10,
 -3.658114523206484e-11,  9.878969421471719e-13,  2.898918830316329e-14, -1.060496986450871e-15, -2.318190754670122e-17,  1.117016297066836e-18,  1.728105826218711e-20,
  2.422642546112610e-01, -2.606146335365956e-03,  2.313004134064023e-05, -6.563510694704540e-08, -1.013138764556221e-09, -5.877532474345487e-11,  1.651207700062451e-12,
  4.856663465072076e-14, -1.802105447777521e-15, -3.873606236410488e-17,  1.906099647774527e-18,  2.882432305714801e-20,  3.556569667350339e-01, -3.817542960433080e-03,
  3.325776589105106e-05, -6.713356838036400e-08, -2.051613770370441e-09, -8.792592395357382e-11,  2.611501991620343e-12,  7.662284801412381e-14, -2.906255168926414e-15,
 -6.094485574700615e-17,  3.093692903363922e-18,  4.514882787377135e-20,  4.961844088105544e-01, -5.309005266011720e-03,  4.498478312254852e-05, -3.399747976451360e-08,
 -4.026126291869062e-09, -1.261822897928613e-10,  4.056702646903533e-12,  1.173156767066994e-13, -4.609563986476743e-15, -9.307815398242561e-17,  4.955886766460091e-18,
  6.822171092248200e-20,  6.688857924692873e-01, -7.122474036594031e-03,  5.774210221358174e-05,  7.803421280207335e-08, -7.876721047557292e-09, -1.781617546842458e-10,
  6.433757362696798e-12,  1.780724416842873e-13, -7.440083352606542e-15, -1.410275675056073e-16,  8.127141087043679e-18,  1.006137883014860e-19,  8.821743822319711e-01,
 -9.319219357661493e-03,  6.978110868623044e-05,  3.800742514241312e-07, -1.596646956005603e-08, -2.572180251337714e-10,  1.110120181954657e-11,  2.714872717469925e-13,
 -1.284393894293531e-14, -2.143797216199489e-16,  1.439597951562600e-17,  1.407761324269380e-19,  1.152076041396682e+00, -1.198173626656944e-02,  7.454387703858598e-05,
  1.239123265188038e-06, -3.610441860460002e-08, -4.305249870748285e-10,  2.449577120475483e-11,  3.953198177792511e-13, -2.663857905476090e-14, -2.947309798411082e-16,
  3.081185631606173e-17,  1.120800193336983e-19,  1.518442880290589e+00, -1.505470715448420e-02,  2.967772277318713e-05,  4.877168560171988e-06, -1.121644199134018e-07,
 -1.882069539123532e-09,  1.365167260434623e-10, -4.774280993961443e-13, -1.274933630316662e-13,  2.424915074536493e-15,  9.330938460928709e-17, -3.817573388201722e-18,
  8.940244129086377e-03, -9.354653930513407e-05,  8.733483620052202e-07, -4.311277751753740e-09, -4.244988410074772e-11, -5.398141552934904e-13,  7.187656636696464e-14,
 -4.932232932121134e-16, -5.917455998735897e-17,  1.127534672117351e-18,  4.168009260004250e-20, -1.514694323405223e-21,  3.592250436223494e-02, -3.757908204163754e-04,
  3.501300603775236e-06, -1.693571119258151e-08, -1.807710635191705e-10, -2.105607683456864e-12,  2.927154337827950e-13, -2.028972344365591e-15, -2.416702072412625e-16,
  4.632118201518388e-18,  1.700460299536386e-19, -6.219750565385558e-21,  8.144785566636545e-02, -8.516992930520922e-04,  7.907290736370658e-06, -3.685663068438353e-08,
 -4.506113873158946e-10, -4.518424058406235e-12,  6.793331825375033e-13, -4.793676315810156e-15, -5.634968581224410e-16,  1.091342287102128e-17,  3.957553027779275e-19,
 -1.464206476809204e-20,  1.464106393391243e-01, -1.530093281936836e-03,  1.412898973004221e-05, -6.204269334289403e-08, -9.217757277384572e-10, -7.410231426360420e-12,
  1.264283325198475e-12, -9.169840484339411e-15, -1.055455415264251e-15,  2.076820051367557e-17,  7.390965982368422e-19, -2.782971657881827e-20,  2.322042746382581e-01,
 -2.424605634367351e-03,  2.221429777397093e-05, -8.876214495059628e-08, -1.719328947233312e-09, -1.007655407342627e-11,  2.105086752358137e-12, -1.589427882115107e-14,
 -1.771305756911265e-15,  3.566673723001199e-17,  1.234827933106161e-18, -4.770967192058760e-20,  3.409128842707352e-01, -3.555370015948353e-03,  3.220970708813520e-05,
 -1.100989128110489e-07, -3.069234469295352e-09, -1.114159797388253e-11,  3.304403745375998e-12, -2.644123600710390e-14, -2.804805530558543e-15,  5.838686527688782e-17,
  1.941658130257932e-18, -7.790113691450501e-20,  4.756638100594786e-01, -4.952007183048853e-03,  4.412643193400760e-05, -1.125233752521806e-07, -5.404162019945513e-09,
 -7.736144569647664e-12,  5.057829685054232e-12, -4.405247428426867e-14, -4.327040737211986e-15,  9.460559202140019e-17,  2.960667083721345e-18, -1.257288231915341e-19,
  6.413223952822905e-01, -6.659144032101079e-03,  5.783531876067725e-05, -6.693561015314626e-08, -9.642465746167973e-09,  6.809445091022184e-12,  7.785256530229356e-12,
 -7.702586868919781e-14, -6.675756116115148e-15,  1.575650299436575e-16,  4.468337191255596e-18, -2.079792166446519e-19,  8.460363714437797e-01, -8.747357483109047e-03,
  7.269127772780629e-05,  9.962927582441275e-08, -1.808635547822593e-08,  5.089136506809962e-11,  1.258822642000709e-11, -1.523885514693030e-13, -1.058964130852605e-14,
  2.854497672373167e-16,  6.728306331630806e-18, -3.712442124634984e-19,  1.105421520469937e+00, -1.133616314279234e-02,  8.577265899391432e-05,  6.264979979119090e-07,
 -3.844848499723809e-08,  1.923203020963460e-10,  2.365727825078802e-11, -4.053113054090832e-13, -1.770106189558631e-14,  6.385504253187355e-16,  9.093442967061642e-18,
 -7.890209488903777e-19,  1.459024111431453e+00, -1.461544624846374e-02,  7.674069622406352e-05,  2.947805002060740e-06, -1.200979533471878e-07,  8.709983616789590e-10,
  8.235175400439501e-11, -2.772619344514876e-12, -1.335840135370285e-14,  2.930486249908197e-15, -5.122664576033795e-17, -1.716898551403109e-18,  8.579687228309527e-03,
 -8.677848869391971e-05,  8.174642980702758e-07, -4.991097734138399e-09, -3.803010384030035e-11,  8.511544750085041e-13,  3.916133059463058e-14, -1.551923671392026e-15,
 -5.254963860339178e-18,  1.440946084174135e-18, -2.095858705818815e-20, -8.854430713872564e-22,  3.447400408069964e-02, -3.486433718749080e-04,  3.280479180037891e-06,
 -1.981595807161615e-08, -1.609694206447513e-10,  3.551096044527922e-12,  1.588197294996009e-13, -6.340676080520446e-15, -2.086647219855594e-17,  5.886750468782030e-18,
 -8.635625156525786e-20, -3.607192029827473e-21,  7.816459877059531e-02, -7.903341211472736e-04,  7.421438699843248e-06, -4.398034126754964e-08, -3.975092141074695e-10,
  8.576957365785539e-12,  3.658869787336120e-13, -1.479729261029569e-14, -4.619156554527236e-17,  1.373390177494861e-17, -2.044945949196056e-19, -8.373320575712060e-21,
  1.405112586639931e-01, -1.420291365656541e-03,  1.329605512633683e-05, -7.647371610003297e-08, -8.035983434321353e-10,  1.686803354972296e-11,  6.733188484299712e-13,
 -2.776270454292735e-14, -7.939415353259451e-17,  2.574728254054261e-17, -3.920704876027205e-19, -1.557352392054751e-20,  2.228538755899349e-01, -2.251618133159477e-03,
  2.098568530513151e-05, -1.153874665017142e-07, -1.478853544559161e-09,  3.012178307771754e-11,  1.102849944746501e-12, -4.673925381693453e-14, -1.155689893949750e-16,
  4.326761704319701e-17, -6.802777804159854e-19, -2.585671245928587e-20,  3.271972240634821e-01, -3.303802771135684e-03,  3.059941325932735e-05, -1.570857904604799e-07,
 -2.601752845585814e-09,  5.144456559378120e-11,  1.690381965081271e-12, -7.444415700034130e-14, -1.416510195920317e-16,  6.864737063357278e-17, -1.128922449059655e-18,
 -4.026734595210693e-20,  4.565512120234442e-01, -4.605838757402408e-03,  4.227188678111058e-05, -1.942870697266428e-07, -4.510333768935283e-09,  8.689382620855120e-11,
  2.496932001612342e-12, -1.161279158689918e-13, -1.211572557020548e-16,  1.062160722752335e-16, -1.862127022597582e-18, -6.045102228713196e-20,  6.156024849375694e-01,
 -6.202225978794710e-03,  5.614090900088212e-05, -2.110654840910177e-07, -7.911976679927050e-09,  1.496631497029271e-10,  3.632454340254736e-12, -1.831980104079567e-13,
  5.940921250034932e-17,  1.646303706075750e-16, -3.173319723952094e-18, -8.873976234475028e-20,  8.122108533744455e-01, -8.165790081623299e-03,  7.223196791655500e-05,
 -1.672007870476218e-07, -1.454633380709507e-08,  2.740879444447482e-10,  5.311693842356037e-12, -3.056751567744295e-13,  8.315342774574302e-16,  2.632616499603846e-16,
 -5.912666207228104e-18, -1.258758428968385e-19,  1.061482690181182e+00, -1.062989805141339e-02,  8.981374442813958e-05,  6.821647529707944e-08, -3.008020724626307e-08,
  5.820835877783948e-10,  7.972817579907228e-12, -5.947988155508108e-13,  4.607470633496294e-15,  4.481881883936077e-16, -1.354817852850820e-17, -1.365310847069338e-19,
  1.401970558010299e+00, -1.389080180059546e-02,  1.014358568878505e-04,  1.246808931800731e-06, -8.909739388435664e-08,  1.948493753055356e-09,  1.125465290851702e-11,
 -1.987879372754391e-12,  4.708847882707393e-14,  4.315366030524575e-16, -5.319472807354851e-17,  1.054346691692688e-18,  8.245260810125336e-03, -8.048713847118877e-05,
  7.546074261123794e-07, -5.426898885616338e-09, -1.504847746855158e-11,  1.291363137205852e-12, -3.041379793648758e-16, -1.099991733537075e-15,  2.636369350324167e-17,
  2.768124632594614e-19, -2.762983898202096e-20,  4.038695804493273e-22,  3.313035888356798e-02, -3.233880422512587e-04,  3.030085906337223e-06, -2.167568603561663e-08,
 -6.587570125493590e-11,  5.323297243465939e-12, -2.188847153736487e-15, -4.479505478508258e-15,  1.079428002271269e-16,  1.115882153059656e-18, -1.128603803708119e-19,
  1.665299376374606e-21,  7.511853040287102e-02, -7.331663469220496e-04,  6.862339320409909e-06, -4.862974531010837e-08, -1.708903272675842e-10,  1.260694150128175e-11,
 -8.892623795351288e-15, -1.039349458912843e-14,  2.528269455590985e-16,  2.541769406770143e-18, -2.632322146092556e-19,  3.948206305750544e-21,  1.350367489036370e-01,
 -1.317782196858885e-03,  1.231448890599688e-05, -8.601415561423849e-08, -3.659293423992627e-10,  2.413695954592182e-11, -2.706746319085417e-14, -1.932808261065080e-14,
  4.768940085961971e-16,  4.588808526142358e-18, -4.932597531092106e-19,  7.581827014280198e-21,  2.141739061660251e-01, -2.089620550966849e-03,  1.948240657628518e-05,
 -1.332277367671013e-07, -7.146044104896419e-10,  4.168060900133842e-11, -6.946987121914370e-14, -3.212078848072982e-14,  8.087535399013190e-16,  7.280705054592565e-18,
 -8.282864968360630e-19,  1.317947886016104e-20,  3.144587829042053e-01, -3.067166208260222e-03,  2.850380714004081e-05, -1.889706897945659e-07, -1.330300379756185e-09,
  6.840078796584089e-11, -1.612137054642702e-13, -5.020860198917235e-14,  1.300693679262883e-15,  1.056445213185213e-17, -1.312500285086653e-18,  2.191045422302999e-20,
  4.387879036124100e-01, -4.278068401676783e-03,  3.957239431397789e-05, -2.503673557102105e-07, -2.426006643022730e-09,  1.102955304650201e-10, -3.556023729205796e-13,
 -7.616724163814754e-14,  2.054907174632059e-15,  1.408552539538053e-17, -2.026378008267582e-18,  3.617652018884988e-20,  5.916730847931985e-01, -5.765132074141649e-03,
  5.295807223788745e-05, -3.106539769011014e-07, -4.441669249553208e-09,  1.799814739756191e-10, -7.804890248834318e-13, -1.150107056805842e-13,  3.295766263175055e-15,
  1.632773985645283e-17, -3.127887357382048e-18,  6.154867026499379e-20,  7.806857004812280e-01, -7.599468855528094e-03,  6.902483385948103e-05, -3.519227618842668e-07,
 -8.436808095519938e-09,  3.088408346546794e-10, -1.807738383353075e-12, -1.778338335392693e-13,  5.616918547337144e-15,  1.054136842893475e-17, -4.957486082848164e-18,
  1.135852958717568e-19,  1.020394970933773e+00, -9.915369555650203e-03,  8.814808511621658e-05, -3.147462768110020e-07, -1.773861176033343e-08,  6.013341938264585e-10,
 -4.948864199979169e-12, -2.942920650993462e-13,  1.118829174798088e-14, -4.374135692905913e-17, -8.234950118021868e-18,  2.505729334985454e-19,  1.348094794031108e+00,
 -1.304072681229985e-02,  1.091335715728933e-04,  1.318830908285699e-07, -5.103976887699806e-08,  1.723021813244782e-09, -2.334005114519375e-11, -5.458534656059220e-13,
  3.629019469007998e-14, -7.153742023149092e-16, -6.638872648988433e-18,  7.712202501128776e-19,  7.934970281909886e-03, -7.471294792190700e-05,  6.888666373715051e-07,
 -5.470158971283352e-09,  8.718189516066733e-12,  1.012380030279682e-12, -1.907879154940615e-14, -2.687171874060436e-16,  2.163791894483192e-17, -3.889596993809166e-19,
 -5.590981815729580e-21,  4.345353595192657e-22,  3.188362586192326e-02, -3.001978156494549e-04,  2.767058601593747e-06, -2.191624488818358e-08,  3.197983872908284e-11,
  4.166054703891106e-12, -7.845574582849803e-14, -1.083349815883680e-15,  8.822263034531986e-17, -1.595227941998209e-18, -2.254653687649478e-20,  1.773593850954414e-21,
  7.229192561382622e-02, -6.806296777422271e-04,  6.270430229706669e-06, -4.944052877970025e-08,  6.039185002260852e-11,  9.837130157045714e-12, -1.850799874046488e-13,
 -2.469202366843211e-15,  2.051200611480091e-16, -3.747151649005154e-18, -5.139479415252895e-20,  4.131012616796905e-21,  1.299560214673547e-01, -1.223458823423756e-03,
  1.126257964678831e-05, -8.819462322760381e-08,  7.560083754070428e-11,  1.875256582951008e-11, -3.525438077109609e-13, -4.467125901830282e-15,  3.825988274532968e-16,
 -7.097672307330471e-18, -9.291406371242939e-20,  7.724470319028615e-21,  2.061168239464817e-01, -1.940289136030374e-03,  1.784158131354671e-05, -1.383351678292641e-07,
  4.489608766476392e-11,  3.219064447192324e-11, -6.051904098831043e-13, -7.127256025879214e-15,  6.384460349970906e-16, -1.210508414930595e-17, -1.478024063868200e-19,
  1.292996271896688e-20,  3.026314392548091e-01, -2.848467606086356e-03,  2.615181466946203e-05, -1.999136068023955e-07, -9.020233827915255e-11,  5.240632796581474e-11,
 -9.870783184524215e-13, -1.048477341263220e-14,  1.003398297683513e-15, -1.961226695026541e-17, -2.155818883949692e-19,  2.039223773806084e-20,  4.222890423100854e-01,
 -3.974005168673553e-03,  3.640472621730251e-05, -2.725901351717514e-07, -4.395625741208527e-10,  8.359348505990357e-11, -1.583027222197530e-12, -1.447106575501852e-14,
  1.533037426512894e-15, -3.127632302617641e-17, -2.908454097010582e-19,  3.125560737281484e-20,  5.694349171127393e-01, -5.357324625444629e-03,  4.891683990968940e-05,
 -3.548223103289878e-07, -1.228997431146269e-09,  1.343441936304453e-10, -2.575042264134718e-12, -1.856796367386041e-14,  2.336707888873901e-15, -5.074849990382304e-17,
 -3.489918372967229e-19,  4.767159810271467e-20,  7.513628276561382e-01, -7.066010107253742e-03,  6.418426648729331e-05, -4.411889720015175e-07, -2.994895258307003e-09,
  2.252465240745161e-10, -4.427971785074991e-12, -2.021234628345380e-14,  3.659332262451363e-15, -8.765850686864534e-17, -2.801653715566166e-19,  7.389446672640899e-20,
  9.821142684050966e-01, -9.229256572109339e-03,  8.303821886140766e-05, -5.109145019722526e-07, -7.370791198048285e-09,  4.209283646521604e-10, -8.745940243670987e-12,
 -4.454081528792095e-15,  6.164057312546702e-15, -1.763938239735314e-16,  5.504610479420683e-19,  1.164497556727212e-19,  1.297671630309216e+00, -1.217280670580624e-02,
  1.068457613630663e-04, -4.426523683696058e-07, -2.284392812467686e-08,  1.086413114215183e-09, -2.629296097607281e-11,  2.034602053474820e-13,  1.167391006593906e-14,
 -5.453522879494733e-16,  9.883806916018545e-18,  6.052415947386509e-20,  7.646729787935607e-03, -6.946084151138388e-05,  6.246452769634386e-07, -5.194890708327868e-09,
  2.412390242360461e-11,  5.287648062072598e-13, -1.913794933486347e-14,  1.872186844877896e-16,  7.200177022729140e-18, -3.419274571144473e-19,  5.257039060455169e-21,
  7.503801788785549e-23,  3.072546165650670e-02, -2.790989907168775e-04,  2.509536007116703e-06, -2.084559312648400e-08,  9.542609588331938e-11,  2.182114125327623e-12,
 -7.839031460764277e-14,  7.721094089943508e-16,  2.919155907565735e-17, -1.394679308410329e-18,  2.158168820661263e-20,  3.018269612146806e-22,  6.966601715066863e-02,
 -6.328096385713572e-04,  5.688616477765473e-06, -4.715349880702077e-08,  2.103927112850554e-10,  5.176060374684623e-12, -1.836891707296404e-13,  1.830561511490628e-15,
  6.719938090724954e-17, -3.244886750417548e-18,  5.077870999970669e-20,  6.848414120874339e-22,  1.252357473552171e-01, -1.137545568587964e-03,  1.022232622940659e-05,
 -8.446511296474402e-08,  3.620114104131197e-10,  9.926503444592085e-12, -3.464960921814945e-13,  3.512800721231262e-15,  1.234509695472666e-16, -6.058413497620573e-18,
  9.640849181727611e-20,  1.229062067524854e-21,  1.986306942904365e-01, -1.804140746017206e-03,  1.620446172174204e-05, -1.332871768536813e-07,  5.374502004418519e-10,
  1.716017115785411e-11, -5.869616237327003e-13,  6.092632207867285e-15,  2.014846554682921e-16, -1.012271472502314e-17,  1.649282441996362e-19,  1.933198705119703e-21,
  2.916408639577691e-01, -2.648802442215162e-03,  2.377447629581507e-05, -1.943021562328298e-07,  7.131340472840914e-10,  2.814712768665378e-11, -9.406484212880800e-13,
  1.007702093221018e-14,  3.066174181225394e-16, -1.593464703131033e-17,  2.682163045171259e-19,  2.769734738312406e-21,  4.069547618324772e-01, -3.695857922082642e-03,
  3.313976545637445e-05, -2.683641287105405e-07,  8.436875416803531e-10,  4.521785928085736e-11, -1.473801345252329e-12,  1.646949603527351e-14,  4.464214694908580e-16,
 -2.439218779254884e-17,  4.295849669073457e-19,  3.622246717390327e-21,  5.487610909395557e-01, -4.983173613219427e-03,  4.461861381606895e-05, -3.563956729908966e-07,
  8.341973893965793e-10,  7.305452693338596e-11, -2.322582131051172e-12,  2.749573173437892e-14,  6.299225372467180e-16, -3.725753149029943e-17,  7.001035263480306e-19,
  4.063365649342600e-21,  7.240914590627697e-01, -6.574222914160592e-03,  5.873241413995634e-05, -4.588333321310123e-07,  4.576346782752280e-10,  1.225517038303306e-10,
 -3.815094390069356e-12,  4.906498350192096e-14,  8.562266113469168e-16, -5.844991100410145e-17,  1.212528781502372e-18,  2.394623046801409e-21,  9.464849453228579e-01,
 -8.590912690934174e-03,  7.644121029944505e-05, -5.726167825276954e-07, -9.698670926163195e-10,  2.262952826811947e-10, -6.990139623948669e-12,  1.025190148244239e-13,
  1.006599538866002e-15, -9.836077623839083e-17,  2.423942584345825e-18, -1.021432484661944e-20,  1.250649433140648e+00, -1.134406090661326e-02,  9.995355523921673e-05,
 -6.661240309107310e-07, -6.813331316611243e-09,  5.505605836064409e-10, -1.777291732972231e-11,  3.386110890447124e-13, -1.041155730224547e-15, -1.821430073934057e-16,
  6.991004321677368e-18, -1.229796336140863e-19,  7.378496066125018e-03, -6.470582047160096e-05,  5.648963390415659e-07, -4.747141710740870e-09,  3.062257120822657e-11,
  1.485568172584486e-13, -1.221365946987284e-14,  2.637989745518913e-16, -1.102095708951002e-18, -1.249038087397242e-19,  4.583472589105499e-21, -6.605981917421255e-23,
  2.964767423614946e-02, -2.599946402118507e-04,  2.269682352453026e-06, -1.906314137633372e-08,  1.223773701777748e-10,  6.256316967771845e-13, -4.998356050952212e-14,
  1.079541466125172e-15, -4.612546946161568e-18, -5.070686412956913e-19,  1.869558628162316e-20, -2.712092245221822e-22,  6.722230211893007e-02, -5.895004365645452e-04,
  5.145667903759433e-06, -4.317801577595421e-08,  2.748316572454542e-10,  1.532405105252402e-12, -1.169397730057719e-13,  2.525854268907586e-15, -1.120639550951400e-17,
 -1.170005186338713e-18,  4.349752400718070e-20, -6.381508466773447e-22,  1.208428583909736e-01, -1.059710473787313e-03,  9.248691488159836e-06, -7.749735554579755e-08,
  4.869027540458070e-10,  3.063672380648995e-12, -2.200473937179275e-13,  4.754950157825640e-15, -2.225135857212911e-17, -2.157040097378715e-18,  8.120976893431996e-20,
 -1.211576351856181e-21,  1.916635077728680e-01, -1.680735211921311e-03,  1.466563876715542e-05, -1.226404822239487e-07,  7.561099514290740e-10,  5.559504265606873e-12,
 -3.714203891970992e-13,  8.035243748660957e-15, -4.032217707620137e-17, -3.538691050967882e-18,  1.356725539239426e-19, -2.072247670455243e-21,  2.814115997096994e-01,
 -2.467703812422934e-03,  2.152621193599566e-05, -1.795052338960720e-07,  1.076934972165516e-09,  9.612630442075612e-12, -5.921164975574040e-13,  1.284245690339301e-14,
 -7.037660384360286e-17, -5.425543393223231e-18,  2.135012811526848e-19, -3.367887749568203e-21,  3.926815706333505e-01, -3.443334684591093e-03,  3.002448640821213e-05,
 -2.493754763541074e-07,  1.437026318054470e-09,  1.630439559273447e-11, -9.205622881056103e-13,  2.006774407351368e-14, -1.226702016016511e-16, -7.988845267248821e-18,
  3.265876846636525e-19, -5.385865292542448e-21,  5.295156519079791e-01, -4.643012010625469e-03,  4.046113718680934e-05, -3.340996557785082e-07,  1.807450526734857e-09,
  2.778386610795869e-11, -1.433558621200579e-12,  3.155607042293220e-14, -2.210506356834720e-16, -1.148374077127450e-17,  4.980594469083790e-19, -8.746924742971747e-21,
  6.986997983169345e-01, -6.126106698540099e-03,  5.333647884824220e-05, -4.363766362851151e-07,  2.113278272803906e-09,  4.895571125207267e-11, -2.308987890553020e-12,
  5.179322455272633e-14, -4.320433883845851e-16, -1.619330358938600e-17,  7.785226964388901e-19, -1.502672846167920e-20,  9.133008475931856e-01, -8.006842684385083e-03,
  6.959927586170779e-05, -5.600366986937591e-07,  2.118165730011670e-09,  9.397812023828217e-11, -4.076647097748126e-12,  9.513095428498645e-14, -1.008239247949719e-15,
 -2.135329125122284e-17,  1.297402445722622e-18, -2.940261080823194e-20,  1.206820137235014e+00, -1.057755785260540e-02,  9.160279414103649e-05, -7.071283824423282e-07,
  6.613759973863334e-10,  2.296318481363396e-10, -9.419264866720358e-12,  2.440683249305270e-13, -3.813177449936076e-15, -3.114528396749564e-18,  2.312481674725814e-18,
 -7.798993958811311e-20,  7.128362284004351e-03, -6.040604886279999e-05,  5.109234584474769e-07, -4.246940369639804e-09,  3.122663504086179e-11, -6.295575250023448e-14,
 -5.778990508775195e-15,  1.860549930371022e-16, -3.025967049510361e-18, -1.351710575494496e-21,  1.701840957309060e-21, -5.350816800857739e-23,  2.864260956749747e-02,
 -2.427183488378676e-04,  2.052901650355341e-06, -1.706037387583791e-08,  1.252014376379799e-10, -2.402334414968118e-13, -2.367846824738819e-14,  7.599564038569357e-16,
 -1.238557258429234e-17, -3.981603082099572e-21,  6.911274195854529e-21, -2.182020054288749e-22,  6.494345702864376e-02, -5.503314303193713e-04,  4.654496063888051e-06,
 -3.866508850127715e-08,  2.828074675873086e-10, -4.943051799471557e-13, -5.550361972864279e-14,  1.772286182397308e-15, -2.898997349548983e-17, -3.052960748182503e-21,
  1.595654077649765e-20, -5.074516593784945e-22,  1.167462967865300e-01, -9.893053685767115e-04,  8.366677029474141e-06, -6.946056605523087e-08,  5.055018072976452e-10,
 -7.522604213272934e-13, -1.047039424245219e-13,  3.320031583611850e-15, -5.460830993858562e-17,  1.170396447727281e-20,  2.944444627088109e-20, -9.467644461878171e-22,
  1.851661944379251e-01, -1.569085514337845e-03,  1.326884001109246e-05, -1.100648378623407e-07,  7.952518307867697e-10, -8.853370261941999e-13, -1.772397571115249e-13,
  5.571732755494213e-15, -9.237408357244453e-17,  6.081251153227205e-20,  4.836814287400699e-20, -1.580086927412070e-21,  2.718719886513240e-01, -2.303807265089529e-03,
  1.947969717294718e-05, -1.613924822126546e-07,  1.154316358673430e-09, -6.664260207666579e-13, -2.833730023325592e-13,  8.820107147800613e-15, -1.478732258727151e-16,
  1.864521946232975e-19,  7.430030241197623e-20, -2.482693455010027e-21,  3.793702469161155e-01, -3.214700054651587e-03,  2.717730464063022e-05, -2.247943106699048e-07,
  1.584563820603785e-09,  3.229386991973405e-13, -4.415766141272013e-13,  1.359891428394640e-14, -2.316447569579436e-16,  4.817443922813241e-19,  1.097215485638708e-19,
 -3.788755161045557e-21,  5.115663266610319e-01, -4.334836563907354e-03,  3.663851655484056e-05, -3.023220456327253e-07,  2.085331891475547e-09,  2.918965062967259e-12,
 -6.880630653532476e-13,  2.097439866784959e-14, -3.656921439431152e-16,  1.177001686751881e-18,  1.584900497475495e-19, -5.755844595397499e-21,  6.750164783521633e-01,
 -5.719728968062854e-03,  4.832665984733878e-05, -3.972822628066617e-07,  2.646024550763627e-09,  9.025371269992107e-12, -1.104351353477214e-12,  3.341522333448351e-14,
 -6.040210984768273e-16,  2.951825068789847e-18,  2.257141043766519e-19, -8.935403989053528e-21,  8.823454658214005e-01, -7.476241580834734e-03,  6.312928818394978e-05,
 -5.155914938950309e-07,  3.214346803128797e-09,  2.404570243166251e-11, -1.922460746366612e-12,  5.826667060834918e-14, -1.121053793422016e-15,  8.514181872990616e-18,
  3.071634110137374e-19, -1.467556892709284e-20,  1.165922435281397e+00, -9.878217987735151e-03,  8.329827472732257e-05, -6.700087723064658e-07,  3.477085043295810e-09,
  7.217695704423318e-11, -4.216681993404843e-12,  1.324882196801717e-13, -2.922741056492291e-15,  3.846080651423100e-17,  1.545421129489659e-19, -2.502911816249192e-20,
  6.894601909393389e-03, -5.651415733656203e-05,  4.628963419787016e-07, -3.763345334304467e-09,  2.894717345269439e-11, -1.497561317568724e-13, -1.862189710810785e-15,
  9.763108185126527e-17, -2.317812560117225e-18,  3.040779464258399e-20,  1.376115619101099e-22, -1.945349209752503e-23,  2.770333339331442e-02, -2.270805118606243e-04,
  1.859955785952427e-06, -1.512002224161857e-08,  1.162110873349769e-10, -5.965979333864650e-13, -7.685184133361965e-15,  3.985730539711437e-16, -9.461656988647479e-18,
  1.245516688581133e-19,  5.431652500918277e-22, -7.899855099750449e-23,  6.281377180595002e-02, -5.148756077838099e-04,  4.217145460284721e-06, -3.427661423569781e-08,
  2.630907385842652e-10, -1.332394409387539e-12, -1.822749042496259e-14,  9.286227568222791e-16, -2.204361748333042e-17,  2.918939928130697e-19,  1.190214393722304e-21,
 -1.823765728706476e-22,  1.129178548038534e-01, -9.255704507968917e-04,  7.580817601798412e-06, -6.160130840097725e-08,  4.718623527075624e-10, -2.340370297569633e-12,
 -3.493731510810620e-14,  1.736954299203474e-15, -4.123755466507442e-17,  5.508690750972307e-19,  2.016217581446365e-21, -3.365023055856887e-22,  1.790940908965976e-01,
 -1.468004205896482e-03,  1.202320388970026e-05, -9.766641696421568e-08,  7.459653919358876e-10, -3.588636057083595e-12, -6.031234748410604e-14,  2.908244007431762e-15,
 -6.908403199280084e-17,  9.342870416029771e-19,  2.880803850769724e-21, -5.526901120563037e-22,  2.629566082776028e-01, -2.155405587916449e-03,  1.765237172604630e-05,
 -1.433249768282049e-07,  1.090304571688510e-09, -5.016514519761450e-12, -9.863737458468568e-14,  4.587673365690154e-15, -1.091288127730425e-16,  1.501000364644514e-18,
  3.463274642252426e-21, -8.488573821513751e-22,  3.669298043238737e-01, -3.007643410252367e-03,  2.463055735490818e-05, -1.998505986229667e-07,  1.511712600951081e-09,
 -6.504114761213802e-12, -1.575760987549756e-13,  7.035366873495472e-15, -1.678416844456424e-16,  2.362860282106734e-18,  2.989725873928404e-21, -1.253301844939349e-21,
  4.947910205658780e-01, -4.055673174301783e-03,  3.321035411809213e-05, -2.692102057071219e-07,  2.019602255779486e-09, -7.797363992119457e-12, -2.519886799931900e-13,
  1.075866326051186e-14, -2.581561937572946e-16,  3.755288364261750e-18, -5.962154323573836e-22, -1.810297540450208e-21,  6.528816197027298e-01, -5.351459731109293e-03,
  4.381536134069855e-05, -3.546613321372102e-07,  2.626574931005947e-09, -8.291747277510604e-12, -4.147225900077586e-13,  1.689329775602351e-14, -4.100320057970818e-16,
  6.260917477508120e-18, -1.371090068168767e-20, -2.580414131171522e-21,  8.534126481580563e-01, -6.995058630100210e-03,  5.725986648820665e-05, -4.623355115943069e-07,
  3.346492152304959e-09, -6.228159506772064e-12, -7.363413775471320e-13,  2.864958546519271e-14, -7.125367305189585e-16,  1.177445549502407e-17, -6.296488750914855e-20,
 -3.537399120077155e-21,  1.127692856685286e+00, -9.242966911703699e-03,  7.562481964037548e-05, -6.072380539815970e-07,  4.159927190753025e-09,  6.203250731126530e-12,
 -1.609444587134556e-12,  6.070660416418447e-14, -1.610474386589427e-15,  3.120258608110419e-17, -3.538584720074942e-19, -2.293833013738055e-21,  6.675676407954046e-03,
 -5.298399290398831e-05,  4.204106267686055e-07, -3.325788125011279e-09,  2.568755703710468e-11, -1.690101059540065e-13, -2.421574296260458e-18,  4.077074047788074e-17,
 -1.270051897207654e-18,  2.515042410188199e-20, -2.758282989324724e-22, -2.212105851662341e-24,  2.682366488442718e-02, -2.128959726386507e-04,  1.689254569117688e-06,
 -1.336288970659920e-08,  1.031795061511031e-10, -6.771789879617910e-13, -9.108429829978914e-17,  1.665927371452047e-16, -5.178853512778672e-18,  1.026515481391046e-19,
 -1.130927474456248e-21, -8.830400376043967e-24,  6.081923688879132e-02, -4.827143020659734e-04,  3.830147403199979e-06, -3.029658276685449e-08,  2.338037798853368e-10,
 -1.527824059195779e-12, -5.280259921540325e-16,  3.886962496989833e-16, -1.204241413082741e-17,  2.390942964449870e-19, -2.654919076016228e-21, -1.976493447151719e-23,
  1.093323606031360e-01, -8.677562075591553e-04,  6.885247704821208e-06, -5.445743984027630e-08,  4.199166312301845e-10, -2.726064507817007e-12, -1.816676972128844e-15,
  7.284139065963282e-16, -2.246252620331442e-17,  4.471242455982842e-19, -5.022973341480507e-21, -3.471902697388303e-23,  1.734073014504838e-01, -1.376309505312672e-03,
  1.092026200417740e-05, -8.636020960459643e-08,  6.651542097408304e-10, -4.277848280860940e-12, -4.832201490200976e-15,  1.222275145633158e-15, -3.747401869391151e-17,
  7.487373628326959e-19, -8.548317235775628e-21, -5.284572335891604e-23,  2.546069389791780e-01, -2.020777920695315e-03,  1.603351733483903e-05, -1.267741571091406e-07,
  9.748773252956255e-10, -6.187532585948098e-12, -1.108825031513509e-14,  1.932400867044783e-15, -5.884805237945958e-17,  1.182184420709929e-18, -1.379602847080778e-20,
 -7.187452699510299e-23,  3.552786970935143e-01, -2.819791523912961e-03,  2.237267516211549e-05, -1.768522798807183e-07,  1.356961139803430e-09, -8.451684013926878e-12,
 -2.331027705673791e-14,  2.968809710892836e-15, -8.975143989677220e-17,  1.817318854403128e-18, -2.184703365090267e-20, -8.571592160949552e-23,  4.790799913163004e-01,
 -3.802376640487999e-03,  3.016774567074562e-05, -2.383855402117277e-07,  1.823273345517831e-09, -1.104197366493772e-11, -4.679979530406360e-14,  4.542575834890293e-15,
 -1.363452670729932e-16,  2.793883773369262e-18, -3.499178849228411e-20, -7.700970913275096e-23,  6.321508607158964e-01, -5.017261573769666e-03,  3.980473309948280e-05,
 -3.143668671651993e-07,  2.392713777873318e-09, -1.385140568153168e-11, -9.323838340801529e-14,  7.115003806715878e-15, -2.123776798097682e-16,  4.435631539142680e-18,
 -5.893373724679198e-20,  1.097312070215964e-23,  8.263147001627229e-01, -6.558276079369378e-03,  5.202652686170661e-05, -4.105171437552956e-07,  3.098448629512183e-09,
 -1.648191894083835e-11, -1.943623803165397e-13,  1.194187413327458e-14, -3.565177165589995e-16,  7.703356489905379e-18, -1.122865372572252e-19,  4.198366347783382e-22,
  1.091886431770579e+00, -8.665986000336466e-03,  6.873596577939446e-05, -5.412999433401747e-07,  4.009353498280084e-09, -1.691107462113876e-11, -4.821131794819134e-13,
  2.437086218427935e-14, -7.436066305294126e-16,  1.735045753344733e-17, -3.014549325194599e-19,  3.015172235488250e-21  };
  constexpr double w[4224] = {  4.358786931872724e-03, -1.680823644922114e-04,  4.592632342334975e-06, -1.080959176965074e-07,  2.324687350321602e-09,
 -4.687587243266272e-11,  8.989812422733138e-13, -1.654684161652163e-14,  2.941594792313995e-16, -5.074159712310583e-18,  8.522889262940078e-20, -1.397449918783613e-21,
  1.598288903610141e-02, -9.602695847974504e-04,  4.029271038381483e-05, -1.399480601227076e-06,  4.281748058598985e-08, -1.192043485616412e-09,  3.079698888073209e-11,
 -7.480118406003576e-13,  1.723701550960656e-14, -3.793984658019891e-16,  8.017591767210354e-18, -1.632670793912228e-19,  3.121674248187837e-02, -2.948120505378151e-03,
  1.792434576522037e-04, -8.572889974001591e-06,  3.488841031643617e-07, -1.258499642711770e-08,  4.124471469742035e-10, -1.248364467521839e-11,  3.530216466021383e-13,
 -9.407419717824137e-15,  2.377947622706604e-16, -5.728263455398368e-18,  4.581439092064545e-02, -6.379411669201796e-03,  5.305031167466242e-04, -3.326599887224334e-05,
  1.722995991553770e-06, -7.731009627206469e-08,  3.093413907436163e-09, -1.125321664810229e-10,  3.773160189892941e-12, -1.178003757616902e-13,  3.451461961729658e-15,
 -9.542878221785011e-17,  5.644065181726715e-02, -1.078346772156483e-02,  1.167616731075512e-03, -9.218659092099042e-05,  5.864406168490832e-06, -3.169003358333092e-07,
  1.502564919359119e-08, -6.388433333712520e-10,  2.473664317230382e-11, -8.824674247876079e-13,  2.926509187770119e-14, -9.078717865823301e-16,  6.135059074668093e-02,
 -1.507121393452461e-02,  2.031648092220805e-03, -1.947104266550709e-04,  1.473805479599835e-05, -9.322465478702015e-07,  5.103263585351744e-08, -2.475472461641423e-09,
  1.082260041216188e-10, -4.319149307947488e-12,  1.589088308181472e-13, -5.427298979070666e-15,  6.024484639334641e-02, -1.798741767419126e-02,  2.896040901159317e-03,
 -3.255634155984617e-04,  2.846193321385331e-05, -2.052168709785220e-06,  1.266049775438207e-07, -6.852681135104763e-09,  3.313655227425193e-10, -1.451192017914955e-11,
  5.817538697140232e-13, -2.150671045845740e-14,  5.374019851762449e-02, -1.858111585817264e-02,  3.438306706187157e-03, -4.388391745201505e-04,  4.306207385519812e-05,
 -3.449727694669838e-06,  2.343425177938465e-07, -1.385509891715079e-08,  7.265922435488245e-10, -3.428765066842780e-11,  1.472451705437929e-12, -5.799565544059285e-14,
  4.287283198458525e-02, -1.646769246504932e-02,  3.379347674828620e-03, -4.746196093555243e-04,  5.084009353693280e-05, -4.413057932823724e-06,  3.226431886838409e-07,
 -2.040584284181501e-08,  1.138464576250186e-09, -5.687008529070475e-11,  2.573558989786574e-12, -1.063628895718509e-13,  2.880637518808880e-02, -1.185659535789273e-02,
  2.609608936236343e-03, -3.913214285340284e-04,  4.452529366524243e-05, -4.085124939833967e-06,  3.142436652295302e-07, -2.082377164910761e-08,  1.212629180530575e-09,
 -6.300646970006568e-11,  2.956303851374958e-12, -1.263056416913370e-13,  1.273705445772852e-02, -5.440583323974252e-03,  1.244266849499596e-03, -1.934479971341480e-04,
  2.275910499117882e-05, -2.153334753600004e-06,  1.703890738071041e-07, -1.158773881218592e-08,  6.910503758831308e-10, -3.669996122060367e-11,  1.756937472788746e-12,
 -7.645916484874319e-14,  3.752531767148218e-03, -1.359619412106744e-04,  3.491121895642153e-06, -7.736912935493022e-08,  1.570255168414114e-09, -2.994430730395604e-11,
  5.440689274438744e-13, -9.502184927086527e-15,  1.604995629280807e-16, -2.633608577664199e-18,  4.212440415193734e-20, -6.583852066997491e-22,  1.269447698568339e-02,
 -6.950389114169495e-04,  2.693568769334322e-05, -8.711106545087479e-07,  2.494703643988908e-08, -6.526298862252631e-10,  1.589302462651273e-11, -3.648035139672242e-13,
  7.962358407830385e-15, -1.663296588391453e-16,  3.341896389707660e-18, -6.481135626597650e-20,  2.175314625959674e-02, -1.846918967808153e-03,  1.030206853603653e-04,
 -4.565838684128381e-06,  1.733328776466095e-07, -5.861967905661140e-09,  1.808445795291948e-10, -5.170082393151432e-12,  1.384991176955874e-13, -3.505315999608718e-15,
  8.434833044683528e-17, -1.938426314339855e-18,  2.679081827538926e-02, -3.359275079649076e-03,  2.563310931463263e-04, -1.490192350293509e-05,  7.207868645030667e-07,
 -3.037137367573784e-08,  1.146411193419563e-09, -3.949214105844056e-11,  1.258066045028097e-12, -3.742587302877107e-14,  1.047576859612690e-15, -2.773741879572270e-17,
  2.672935943067081e-02, -4.651520934411388e-03,  4.652459373054724e-04, -3.424883817890637e-05,  2.045573576785666e-06, -1.043553269143652e-07,  4.692404147473335e-09,
 -1.899324603949609e-10,  7.024892161061460e-12, -2.400890920855800e-13,  7.647926023595602e-15, -2.284528575504715e-16,  2.299509933429659e-02, -5.233738461666206e-03,
  6.595197627057983e-04, -5.952606989405383e-05,  4.268475681632751e-06, -2.570338830654605e-07,  1.344967282898290e-08, -6.258244511103296e-10,  2.632630002895117e-11,
 -1.013677159350713e-12,  3.607010930556700e-14, -1.194140454960193e-15,  1.774576198235649e-02, -5.005009155114763e-03,  7.647335272271065e-04, -8.201189542427388e-05,
  6.870764644004210e-06, -4.765711071258154e-07,  2.837787996563132e-08, -1.486818686319179e-09,  6.977121430514027e-11, -2.971974360069729e-12,  1.161148558662614e-13,
 -4.191422503884444e-15,  1.258258504837361e-02, -4.187930194971454e-03,  7.472771211771912e-04, -9.226652485662546e-05,  8.785219901945026e-06, -6.847479391370124e-07,
  4.536429732356069e-08, -2.621185558994422e-09,  1.345888995293849e-10, -6.228808466609749e-12,  2.627250194623782e-13, -1.017759905015975e-14,  8.226218374379174e-03,
 -3.091107603195825e-03,  6.207067793706466e-04, -8.544590081096713e-05,  8.986504101784145e-06, -7.671001774576850e-07,  5.523095863633827e-08, -3.444420695633076e-09,
  1.897047400354024e-10, -9.364481139155128e-12,  4.191549436129580e-13, -1.714912527157218e-14,  4.753088564193229e-03, -1.936735754430671e-03,  4.219112880575677e-04,
 -6.266094909178503e-05,  7.066612276604801e-06, -6.430736152817713e-07,  4.909723724110799e-08, -3.231042486370386e-09,  1.869547644086262e-10, -9.656699412180999e-12,
  4.506270327312231e-13, -1.915546487623803e-14,  1.923064514245757e-03, -8.187433782492290e-04,  1.865997693316942e-04, -2.891450365371744e-05,  3.391111706287100e-06,
 -3.199018330065492e-07,  2.524316973642073e-08, -1.712264762438278e-09,  1.018636783194465e-10, -5.397274952559513e-12,  2.578228130741275e-13, -1.119709313561585e-14,
  3.259210173384088e-03, -1.113608911247469e-04,  2.695747471136523e-06, -5.640770722000279e-08,  1.083060515782885e-09, -1.957625949203292e-11,  3.376861903770047e-13,
 -5.607127866071516e-15,  9.015256464727667e-17, -1.409660329488771e-18,  2.150696432532188e-20, -3.209276919841148e-22,  1.028751055700459e-02, -5.154538385451405e-04,
  1.850529122022939e-05, -5.586720611693673e-07,  1.500967606768006e-08, -3.697111070770528e-10,  8.501530935212468e-12, -1.847106607541960e-13,  3.824036468788820e-15,
 -7.590986884734754e-17,  1.451748396437406e-18, -2.684058935648603e-20,  1.572328028343879e-02, -1.202357608211832e-03,  6.164991945093893e-05, -2.536108681941863e-06,
  8.993712831409129e-08, -2.854905321842780e-09,  8.298707575858716e-11, -2.242604530954207e-12,  5.694475231587927e-14, -1.369444288799363e-15,  3.138009666789498e-17,
 -6.881277675848647e-19,  1.654868536664834e-02, -1.865898711123989e-03,  1.306407989373525e-04, -7.041463878466919e-06,  3.180477193307553e-07, -1.258331500070930e-08,
  4.479594121554619e-10, -1.460797280331652e-11,  4.419321148455669e-13, -1.252052535648209e-14,  3.346044245772577e-16, -8.478546921304221e-18,  1.358165915999529e-02,
 -2.143389627906151e-03,  1.975531158169451e-04, -1.353360371784019e-05,  7.576361103706032e-07, -3.643100139066989e-08,  1.551155129622595e-09, -5.968250482193854e-11,
  2.105395953767373e-12, -6.883317083058026e-14,  2.103044414454022e-15, -6.040057128137381e-17,  9.326764013429689e-03, -1.954423573911730e-03,  2.292161373410551e-04,
 -1.941367688972580e-05,  1.314717238511928e-06, -7.515398452099212e-08,  3.749268131415787e-09, -1.669394840586051e-10,  6.741544288825315e-12, -2.498968079491914e-13,
  8.582174439133867e-15, -2.748568492531517e-16,  5.646769242993347e-03, -1.494271899341657e-03,  2.155270227979359e-04, -2.195176465569651e-05,  1.755534306260182e-06,
 -1.167344863941180e-07,  6.688054201124698e-09, -3.382158456578164e-10,  1.536125898509008e-11, -6.348508343662834e-13,  2.411788312141604e-14, -8.482281558368310e-16,
  3.143012664201385e-03, -1.001176654005144e-03,  1.714175352281756e-04, -2.038764597550464e-05,  1.876586872922985e-06, -1.418367634106709e-07,  9.136711634564096e-09,
 -5.145429595627938e-10,  2.580424123360537e-11, -1.168567218796773e-12,  4.831040775461337e-14, -1.837143321188961e-15,  1.650394182209965e-03, -6.043161188855677e-04,
  1.183200664729268e-04, -1.591424522496541e-05,  1.638751813668738e-06, -1.372222812273918e-07,  9.708185588501072e-09, -5.958067860309977e-10,  3.233555675889801e-11,
 -1.574765498860996e-12,  6.961458792445333e-14, -2.815721004438545e-15,  8.026771744077343e-04, -3.231706595739015e-04,  6.955402708352831e-05, -1.021406992147516e-05,
  1.140024552322532e-06, -1.027644540908083e-07,  7.777906452969263e-09, -5.077869241540177e-10,  2.916665567023017e-11, -1.496372834174940e-12,  6.939274626259312e-14,
 -2.932811839050199e-15,  2.926826713360766e-04, -1.241377916447291e-04,  2.817971153168335e-05, -4.349973226207236e-06,  5.083453756501378e-07, -4.779473921014664e-08,
  3.759659929350131e-09, -2.542753543200221e-10,  1.508555788086085e-11, -7.972569819235197e-13,  3.799213470632337e-14, -1.646227923388285e-15,  2.852991553842676e-03,
 -9.223502699594311e-05,  2.111201912817955e-06, -4.181865979465381e-08,  7.613684451220509e-10, -1.307136654541584e-11,  2.144871429868759e-13, -3.392288223515925e-15,
  5.200920509327691e-17, -7.762537734865581e-19,  1.131462261451266e-20, -1.614399045242634e-22,  8.484424767624702e-03, -3.906428929650258e-04,  1.302978729458434e-05,
 -3.681235057754287e-07,  9.298940670695867e-09, -2.160843257962433e-10,  4.700256187643553e-12, -9.681722710049589e-14,  1.903960760113890e-15, -3.596262567184817e-17,
  6.554344837167621e-19, -1.156475635679586e-20,  1.173709113232640e-02, -8.101577037472777e-04,  3.826634170075121e-05, -1.463837967095881e-06,  4.856797109227442e-08,
 -1.448979444064389e-09,  3.972991483967349e-11, -1.015810038610338e-12,  2.446801770311787e-14, -5.594641849014929e-16,  1.221404342761562e-17, -2.556704244165155e-19,
  1.074116429792624e-02, -1.088174899582667e-03,  6.994218557122130e-05, -3.496760930144300e-06,  1.475384792453756e-07, -5.482000344063829e-09,  1.840682815862486e-10,
 -5.681817940705869e-12,  1.632126897617470e-13, -4.402548138118504e-15,  1.122932747651204e-16, -2.721832149812139e-18,  7.371995926360163e-03, -1.051085808255855e-03,
  8.911365685981876e-05, -5.673386408671498e-06,  2.973257564681111e-07, -1.345983990696318e-08,  5.420223499130655e-10, -1.980082415717867e-11,  6.654199910027040e-13,
 -2.078562031473667e-14,  6.083556078808177e-16, -1.677824758399787e-17,  4.087480081487955e-03, -7.838367078187440e-04,  8.522062975689912e-05, -6.751593354924402e-06,
  4.306103684085749e-07, -2.330837134729659e-08,  1.106016531853028e-09, -4.702022477504918e-11,  1.818995335122029e-12, -6.478061873404591e-14,  2.143006074822374e-15,
 -6.626975702887698e-17,  1.945777741491680e-03, -4.797098143550613e-04,  6.496967089467431e-05, -6.256982689029065e-06,  4.758312249793257e-07, -3.022904656303013e-08,
  1.661204954760115e-09, -8.085212629309192e-11,  3.544757889205207e-12, -1.417855117463054e-13,  5.225348970980059e-15, -1.786652277035323e-16,  8.422216529896396e-04,
 -2.550987645169651e-04,  4.168529764741158e-05, -4.753952771498440e-06,  4.213207451038492e-07, -3.077043385980946e-08,  1.921179598535944e-09, -1.051461472367796e-10,
  5.136607309319094e-12, -2.270681867653942e-13,  9.180520226043846e-15, -3.420079459707614e-16,  3.483114055862136e-04, -1.237068050923783e-04,  2.351865299971240e-05,
 -3.079581389608797e-06,  3.095027627383279e-07, -2.535135957164360e-08,  1.757940987596500e-09, -1.059311531216781e-10,  5.653606616050257e-12, -2.711367254490431e-13,
  1.181778652236554e-14, -4.718270016028099e-16,  1.392805669091434e-04, -5.527908884590571e-05,  1.172804039145672e-05, -1.699574991848635e-06,  1.874095382751774e-07,
 -1.670782448680638e-08,  1.251863959146043e-09, -8.097797896997750e-11,  4.612076539941212e-12, -2.347859912535162e-13,  1.081025580906620e-14, -4.538816170748800e-16,
  4.495883437718038e-05, -1.898446792244778e-05,  4.289673355025897e-06, -6.592754804307117e-07,  7.672855045061035e-08, -7.186530628711766e-09,  5.633051455456274e-10,
 -3.797174647591386e-11,  2.245817847313617e-12, -1.183464622897309e-13,  5.624364886351954e-15, -2.430902256175794e-16,  2.514920737408618e-03, -7.716381414181171e-05,
  1.674667498063539e-06, -3.147770569281930e-08,  5.445970532471972e-10, -8.898428983305758e-12,  1.391528536750447e-13, -2.099963837484121e-15,  3.075167180319455e-17,
 -4.388094092598136e-19,  6.119764499078464e-21, -8.361697700426753e-23,  7.105535290113931e-03, -3.018379598147482e-04,  9.379991336331061e-06, -2.485963697063460e-07,
  5.916826604846126e-09, -1.299612822622445e-10,  2.678755275962362e-12, -5.239496976022183e-14,  9.801641263405790e-16, -1.763942326206115e-17,  3.067413865342328e-19,
 -5.170891080140292e-21,  9.013588733290705e-03, -5.629888450692379e-04,  2.455125203115902e-05, -8.750671274280768e-07,  2.720872088663188e-08, -7.640104701727008e-10,
  1.978441700749904e-11, -4.791010430016371e-13,  1.095692071391139e-14, -2.383829123057224e-16,  4.961532269034605e-18, -9.919013022515909e-20,  7.289136275674403e-03,
 -6.633558053665256e-04,  3.917834196379401e-05, -1.818324642664508e-06,  7.171385603075928e-08, -2.503680642635963e-09,  7.931606138603517e-11, -2.318001799424218e-12,
  6.322890543868154e-14, -1.623811360242794e-15,  3.952473555834355e-17, -9.162140359232044e-19,  4.254315088996731e-03, -5.462798852777623e-04,  4.255498886873450e-05,
 -2.515615989216300e-06,  1.233208383958511e-07, -5.251678228560466e-09,  1.998537289073341e-10, -6.925934402933238e-12,  2.215255432134432e-13, -6.605154627207973e-15,
  1.850092341179524e-16, -4.894797623843431e-18,  1.930757696116775e-03, -3.369031815372506e-04,  3.383985505783894e-05, -2.500955377692409e-06,  1.498674921680511e-07,
 -7.664792433303032e-09,  3.452390271521860e-10, -1.398647020395891e-11,  5.173525225798139e-13, -1.766940055948799e-14,  5.620466005586933e-16, -1.675313118011758e-17,
  7.270429608441520e-04, -1.657942861475913e-04,  2.097539324797762e-05, -1.901984001031558e-06,  1.370394870973922e-07, -8.290307552349158e-09,  4.356770845445204e-10,
 -2.035179589814214e-11,  8.590863602336127e-13, -3.317629754298223e-14,  1.183403008590613e-15, -3.925254840586296e-17,  2.433525190496485e-04, -6.958734846120048e-05,
  1.079061434696191e-05, -1.174306120741659e-06,  9.978708124135256e-08, -7.015875254671692e-09,  4.231550724309223e-10, -2.243897423343315e-11,  1.064870683743909e-12,
 -4.583407402632183e-14,  1.808017118300153e-15, -6.584051991906609e-17,  7.783644518736675e-05, -2.666786965204082e-05,  4.899657961942783e-06, -6.220278289274879e-07,
  6.079482862148273e-08, -4.855674322315016e-09,  3.290894959735440e-10, -1.942156298761682e-11,  1.016997840122600e-12, -4.793033749588116e-14,  2.055908517068381e-15,
 -8.088405488303547e-17,  2.494887295588386e-05, -9.732943028615618e-06,  2.030065281210114e-06, -2.896176786942390e-07,  3.148455527836537e-08, -2.770873808343366e-09,
  2.051888706827591e-10, -1.313151807886784e-11,  7.406218151628224e-13, -3.736633350192258e-14,  1.706359154659873e-15, -7.110426688533537e-17,  6.980795398914348e-06,
 -2.932378057877762e-06,  6.590204685103850e-07, -1.007686174695767e-07,  1.167229358511116e-08, -1.088458027482639e-09,  8.497083027010122e-11, -5.706214257235428e-12,
  3.363091763128505e-13, -1.766445750334246e-14,  8.369384406274147e-16, -3.607041043134601e-17,  2.230860520980357e-03, -6.514171207096580e-05,  1.343880980111611e-06,
 -2.402460888608045e-08,  3.957808115512735e-10, -6.166219951551826e-12,  9.205514502639107e-14, -1.327770151639825e-15,  1.860032042559405e-17, -2.541503073706991e-19,
  3.395929969967829e-21, -4.450155448412299e-23,  6.031407455730975e-03, -2.372983659685332e-04,  6.889166600715227e-06, -1.716696493841820e-07,  3.857774151556837e-09,
 -8.024351941028495e-11,  1.569962826740789e-12, -2.920449187881347e-14,  5.204568901065941e-16, -8.935873880425847e-18,  1.484439674788576e-19, -2.393476920992797e-21,
  7.097051960512259e-03, -4.021950262180266e-04,  1.623086239727193e-05, -5.401082210528952e-07,  1.576566786038395e-08, -4.172874003932184e-10,  1.021871033204280e-11,
 -2.346414048863958e-13,  5.100035287035398e-15, -1.056690447294603e-16,  2.098288849079509e-18, -4.008888490551962e-20,  5.147624881949590e-03, -4.209310776626785e-04,
  2.287386509603904e-05, -9.866159152806220e-07,  3.640553022018404e-08, -1.195090940100966e-09,  3.574131858773285e-11, -9.893494879202703e-13,  2.563380897112192e-14,
 -6.268715116346479e-16,  1.456216084086907e-17, -3.228206574620214e-19,  2.597512870124255e-03, -2.996129206102026e-04,  2.143374175503321e-05, -1.176049190063168e-06,
  5.390885012589352e-08, -2.158711039578800e-09,  7.759522748055563e-11, -2.549532051779256e-12,  7.756557443748054e-14, -2.206090768320530e-15,  5.909191146243450e-17,
 -1.498567735950333e-18,  9.797139987443703e-04, -1.547383844416123e-04,  1.431858830188257e-05, -9.849901289594106e-07,  5.534996772988446e-08, -2.669929609708848e-09,
  1.139592553191252e-10, -4.392244238769142e-12,  1.550942502599903e-13, -5.071818068583765e-15,  1.548841693428991e-16, -4.443151599157444e-18,  2.946296907529937e-04,
 -6.169760138759116e-05,  7.255787689659459e-06, -6.170212774302284e-07,  4.197597618020215e-08, -2.410704471124374e-09,  1.208117406039563e-10, -5.402294017937925e-12,
  2.190190081707329e-13, -8.147187449775041e-15,  2.806555282393393e-16, -9.011657803548134e-18,  7.615680332723814e-05, -2.040080537612928e-05,  2.984034026935944e-06,
 -3.083464751640331e-07,  2.501480401575795e-08, -1.686692761920312e-09,  9.793726975954202e-11, -5.016203440878809e-12,  2.305887106845619e-13, -9.638196110343092e-15,
  3.700423139799878e-16, -1.314249585788464e-17,  1.854559823935883e-05, -6.090559598110448e-06,  1.075584253388618e-06, -1.317788785339665e-07,  1.247506791874077e-08,
 -9.681385091592295e-10,  6.392919566289696e-11, -3.684663848473388e-12,  1.888277107720029e-13, -8.725401448027968e-15,  3.675495140945279e-16, -1.422196643171051e-17,
  4.638924516358994e-06, -1.772463767869886e-06,  3.622587119603563e-07, -5.073238511079836e-08,  5.423582977351125e-09, -4.701495775319767e-10,  3.434189344179946e-11,
 -2.170615733747520e-12,  1.210442087278163e-13, -6.044131715423197e-15,  2.734062998578701e-16, -1.129444681732477e-17,  1.097686195021662e-06, -4.582374244997877e-07,
  1.023291373945380e-07, -1.555350707402875e-08,  1.791682844846732e-09, -1.662296775583009e-10,  1.291612015520849e-11, -8.636379968415124e-13,  5.069719003304147e-14,
 -2.652971853075555e-15,  1.252639135518194e-16, -5.381323136345979e-18,  1.990110432163917e-03, -5.544484403007612e-05,  1.089867923118330e-06, -1.857020125602726e-08,
  2.918531246534827e-10, -4.343371876855327e-12,  6.200195248727734e-14, -8.561299390378434e-16,  1.148886159195269e-17, -1.505639332063866e-19,  1.929579322763936e-21,
 -2.428822660775404e-23,  5.180729562496573e-03, -1.894857860913437e-04,  5.152462201303880e-06, -1.209846037513606e-07,  2.572058334481233e-09, -5.075599227491978e-11,
  9.441571135012030e-13, -1.672908115294872e-14,  2.844081796454605e-16, -4.664787937171520e-18,  7.411679925897069e-20, -1.144317185208031e-21,  5.712232172655219e-03,
 -2.945426471711366e-04,  1.102542929878343e-05, -3.432402564362528e-07,  9.422501300489904e-09, -2.354471694613836e-10,  5.459880711725341e-12, -1.190197671631427e-13,
  2.461258124060371e-15, -4.861023600089558e-17,  9.216825271813389e-19, -1.684064941878350e-20,  3.766815880664577e-03, -2.769499624757217e-04,  1.386938347516308e-05,
 -5.567186844956996e-07,  1.924103734523464e-08, -5.944564788346850e-10,  1.679591764086096e-11, -4.406268185942040e-13,  1.084925408135060e-14, -2.527335413551385e-16,
  5.604405763711939e-18, -1.188321610593774e-19,  1.669698496786990e-03, -1.726568375410523e-04,  1.134347316391068e-05, -5.777443145423355e-07,  2.476382413660717e-08,
 -9.323744248521199e-10,  3.165051455378815e-11, -9.857091384977845e-13,  2.851452890150633e-14, -7.732628962369908e-16,  1.979731448441832e-17, -4.809636765682427e-19,
  5.319067963391401e-04, -7.567986028247524e-05,  6.437561074788434e-06, -4.115060374847844e-07,  2.165233020819805e-08, -9.837242786462486e-10,  3.973440595247511e-11,
 -1.455029555949002e-12,  4.898160118480306e-14, -1.531631679792499e-15,  4.484458763909831e-17, -1.236437572409567e-18,  1.293610188731997e-04, -2.469916254853989e-05,
  2.687961024007768e-06, -2.135996791144103e-07,  1.367792617784486e-08, -7.436562964382160e-10,  3.544800046844383e-11, -1.513716535703227e-12,  5.880654187134062e-14,
 -2.102521871383464e-15,  6.980102277986535e-17, -2.165303882432934e-18,  2.590423993176422e-05, -6.447055599785106e-06,  8.841089604959298e-07, -8.631066417551302e-08,
  6.656013359316155e-09, -4.287711513433824e-10,  2.388560549201908e-11, -1.177936558600944e-12,  5.229940985703728e-14, -2.117170609602295e-15,  7.891666117962959e-17,
 -2.727211539396295e-18,  4.744868086730169e-06, -1.482690348543910e-06,  2.501585018109657e-07, -2.942745491061579e-08,  2.686411899197215e-09, -2.017884275327503e-10,
  1.293781980163701e-11, -7.260214047693657e-13,  3.631127265703439e-14, -1.640948149831123e-15,  6.772740812090993e-17, -2.572065632982482e-18,  9.011578081392033e-07,
 -3.357360420127993e-07,  6.697075769523858e-08, -9.174973312913023e-09,  9.616861395460739e-10, -8.189859362796599e-11,  5.887284706627125e-12, -3.667630296993043e-13,
  2.018543397887956e-14, -9.959320813335855e-16,  4.456123815839443e-17, -1.822541644929851e-18,  1.752051270947804e-07, -7.259430123488874e-08,  1.608824834595230e-08,
 -2.428097080706962e-09,  2.778961035891881e-10, -2.563024889442833e-11,  1.980683746351628e-12, -1.317789913967512e-13,  7.700184406994373e-15, -4.012411191528695e-16,
  1.887082008159254e-17, -8.077411185239646e-19,  1.784461590717206e-03, -4.754400053665917e-05,  8.924180782657735e-07, -1.452210244613384e-08,  2.181196893611466e-10,
 -3.105964177676597e-12,  4.245770722162446e-14, -5.621764822278604e-16,  7.234471519258072e-18, -9.110497997393982e-20,  1.121116015432288e-21, -1.354352504450516e-23,
  4.496926132839271e-03, -1.534436216787502e-04,  3.917659139717297e-06, -8.686401072910125e-08,  1.750318556659452e-09, -3.282568103510162e-11,  5.814848610696246e-13,
 -9.828408241839117e-15,  1.596157215144020e-16, -2.504206637063373e-18,  3.810057016269357e-20, -5.638702731746863e-22,  4.687580704334391e-03, -2.205684883758153e-04,
  7.676022620576767e-06, -2.240235137788112e-07,  5.793949820399766e-09, -1.368950970998027e-10,  3.010314236517277e-12, -6.237554572849969e-14,  1.228585072082306e-15,
 -2.315275326218184e-17,  4.195449849639911e-19, -7.336977640228612e-21,  2.844969689258780e-03, -1.882633999401770e-04,  8.704533308320021e-06, -3.256564662109399e-07,
  1.055557741413449e-08, -3.072543816704839e-10,  8.208955741399837e-12, -2.042531703507408e-13,  4.782245076146889e-15, -1.061715951501939e-16,  2.248349903231897e-18,
 -4.561028931248401e-20,  1.124587743568688e-03, -1.040941396345681e-04,  6.284394315121819e-06, -2.972425461686141e-07,  1.191763932504786e-08, -4.219844518989510e-10,
  1.352945464968955e-11, -3.993795422879365e-13,  1.098407176418045e-14, -2.839501823563905e-16,  6.946576553067671e-18, -1.616127273635819e-19,  3.076103025570622e-04,
 -3.925863233332263e-05,  3.065302099987229e-06, -1.818652467246078e-07,  8.951112699364894e-09, -3.826494758561263e-10,  1.461182584601417e-11, -5.078495911194220e-13,
  1.628149030703692e-14, -4.862986330781273e-16,  1.363622123640697e-17, -3.609493250171661e-19,  6.140669598954433e-05, -1.061653087855254e-05,  1.064967636951860e-06,
 -7.883604884686901e-08,  4.739128163699883e-09, -2.433338960063630e-10,  1.100756419335636e-11, -4.479133562929534e-13,  1.664020225873013e-14, -5.706911140262663e-16,
  1.822403507772503e-17, -5.451542896571157e-19,  9.599241096532999e-06, -2.200475047082769e-06,  2.812020372759784e-07, -2.580902762220228e-08,  1.884026381168602e-09,
 -1.155185666460310e-10,  6.153127415500645e-12, -2.912701152691248e-13,  1.245484496062915e-14, -4.870112153759749e-16,  1.758017033550475e-17, -5.897626685552976e-19,
  1.312699967155808e-06, -3.870324205113502e-07,  6.197158004807232e-08, -6.960722502693103e-09,  6.098560080136165e-10, -4.415377189758921e-11,  2.738587868895848e-12,
 -1.491288028313564e-13,  7.257275549388046e-15, -3.198713643934385e-16,  1.290333368839736e-17, -4.798474149744727e-19,  1.842742454345611e-07, -6.657433962273494e-08,
  1.289879743633982e-08, -1.721606204731299e-09,  1.762987871039721e-10, -1.470436609659631e-11,  1.037436023204471e-12, -6.354884106109569e-14,  3.444547343050765e-15,
 -1.676121428466764e-16,  7.405451560286950e-18, -2.994171981156328e-19,  2.846977995500802e-08, -1.168874106130472e-08,  2.566817077430594e-09, -3.841355288343123e-10,
  4.362785533347917e-11, -3.995780593351789e-12,  3.068333485718337e-13, -2.029606342920584e-14,  1.179658983420170e-15, -6.116987660646128e-17,  2.863952374200953e-18,
 -1.220794269087400e-19,  1.607538554483837e-03, -4.104677442164504e-05,  7.372081747564991e-07, -1.147869409460479e-08,  1.650386179012371e-10, -2.252458249411568e-12,
  2.952032281552648e-14, -3.755359978714960e-16,  4.636893180502976e-18, -5.618732461551133e-20,  6.675875899427164e-22, -7.629400007285873e-24,  3.939844552606809e-03,
 -1.258411288949170e-04,  3.023880039094205e-06, -6.343692130894025e-08,  1.213734653535395e-09, -2.166908919105959e-11,  3.660908890526409e-13, -5.911423062055362e-15,
  9.182583629918574e-17, -1.379773147939787e-18,  2.012950500179909e-20, -2.857285011233055e-22,  3.913076746032904e-03, -1.685227134876089e-04,  5.464874890565455e-06,
 -1.498208091983801e-07,  3.657123653749844e-09, -8.183143170802626e-11,  1.708793022102751e-12, -3.369807294066948e-14,  6.329156495346769e-16, -1.139241027159496e-17,
  1.974766227687610e-19, -3.308171733170167e-21,  2.209953509416977e-03, -1.317935378443422e-04,  5.637226065726618e-06, -1.968966510155851e-07,  5.993759678091779e-09,
 -1.645720059516396e-10,  4.161938281090710e-12, -9.830277739631470e-14,  2.190201317239978e-15, -4.637055518888611e-17,  9.382265106323475e-19, -1.821729489649470e-20,
  7.900261691794936e-04, -6.538816765152368e-05,  3.631316774162092e-06, -1.596274734004971e-07,  5.990431874909365e-09, -1.995744771113673e-10,  6.045476597827287e-12,
 -1.691868722106030e-13,  4.424351358728605e-15, -1.090303122669621e-16,  2.548511425593274e-18, -5.676945881034507e-20,  1.886003083041608e-04, -2.150920299230355e-05,
  1.540349682293134e-06, -8.476854799340071e-08,  3.900367662094234e-09, -1.567903312947703e-10,  5.656495882825688e-12, -1.864641305288551e-13,  5.688806799437692e-15,
 -1.621678774354217e-16,  4.351293255307007e-18, -1.104762467368721e-19,  3.141675343967202e-05, -4.885977566829177e-06,  4.502959287752973e-07, -3.097272021609805e-08,
  1.743983035388213e-09, -8.439448862669271e-11,  3.616064419579149e-12, -1.399540922666576e-13,  4.963110517369185e-15, -1.629907322275088e-16,  4.997848659677944e-18,
 -1.439276471237748e-19,  3.879150308406744e-06, -8.117698606087506e-07,  9.611024320038002e-08, -8.254695607272449e-09,  5.681422145731676e-10, -3.304008310794889e-11,
  1.677345702131019e-12, -7.598848695640382e-14,  3.120725858002743e-15, -1.175626764914385e-16,  4.099782185456449e-18, -1.332026475217855e-19,  3.952640377926740e-07,
 -1.089220008371623e-07,  1.643322444909796e-08, -1.752062721936848e-09,  1.465855752066818e-10, -1.018446020902537e-11,  6.086852164571186e-13, -3.205144823068166e-14,
  1.512851774519058e-15, -6.484628609384354e-17,  2.549841439620463e-18, -9.262690387908392e-20,  4.000689769841739e-08, -1.392085504011189e-08,  2.604682916368138e-09,
 -3.370452090436455e-10,  3.358009229100541e-11, -2.733179826634988e-12,  1.886657423636673e-13, -1.133214390320133e-14,  6.034519517726793e-16, -2.889670788084982e-17,
  1.258240612600190e-18, -5.020334637287461e-20,  4.727234935636944e-09, -1.919032148727822e-09,  4.167363604607361e-10, -6.173443078084833e-11,  6.947305887324422e-12,
 -6.310371600990052e-13,  4.809506601334392e-14, -3.159767367248160e-15,  1.825190439832138e-16, -9.410844970183007e-18,  4.383283725048199e-19, -1.859534609598667e-20,
  1.454333562511195e-03, -3.565838607855812e-05,  6.139365332565413e-07, -9.163270718834690e-09,  1.263019603921625e-10, -1.655083279021199e-12,  2.081184847355350e-14,
 -2.549516654288470e-16,  3.024461723438131e-18, -3.506741055891535e-20,  4.128676804175332e-22, -4.256149185431076e-24,  3.480467153804665e-03, -1.043950174956064e-04,
  2.366259710756320e-06, -4.705767921198940e-08,  8.563472915649287e-10, -1.457799712115099e-11,  2.352220562492593e-13, -3.633952548513304e-15,  5.406230724384683e-17,
 -7.786590904744374e-19,  1.091747746275549e-20, -1.485382935845976e-22,  3.316294329418610e-03, -1.311117232940291e-04,  3.970531204929285e-06, -1.024555932448601e-07,
  2.364575938791403e-09, -5.018507739690859e-11,  9.965557402279188e-13, -1.872730545487996e-14,  3.357916355291841e-16, -5.779290033600365e-18,  9.591503135583567e-20,
 -1.540705092201372e-21,  1.760021998723561e-03, -9.473548454703826e-05,  3.756577132269113e-06, -1.227116936522622e-07,  3.513450915676270e-09, -9.111308019611010e-11,
  2.183509026861169e-12, -4.900340202457808e-14,  1.039827801754553e-15, -2.100957867390654e-17,  4.063909370492925e-19, -7.556819773119612e-21,  5.763992491006874e-04,
 -4.262946067675466e-05,  2.180888448981184e-06, -8.919239506707836e-08,  3.135653343878279e-09, -9.835926362481279e-11,  2.816572669283918e-12, -7.475915786939767e-14,
  1.859428697042520e-15, -4.368954738989270e-17,  9.758043217529940e-19, -2.081211147161513e-20,  1.220013800622931e-04, -1.239231369720572e-05,  8.138843625473603e-07,
 -4.153701162435075e-08,  1.786361456633827e-09, -6.750874993751815e-11,  2.300208147164566e-12, -7.188704956169924e-14,  2.086073873215637e-15, -5.672371564666943e-17,
  1.455490328461453e-18, -3.542108474034565e-20,  1.725605928005657e-05, -2.399090665426908e-06,  2.026281572466872e-07, -1.292421671269184e-08,  6.804639219611530e-10,
 -3.098441332167415e-11,  1.255519473688311e-12, -4.614848676760804e-14,  1.559822064736099e-15, -4.897796633661488e-17,  1.439963439638435e-18, -3.986166041510168e-20,
  1.708764764228420e-06, -3.235013124360715e-07,  3.529582835515174e-08, -2.824828173036061e-09,  1.826485204675421e-10, -1.004184109508883e-11,  4.844430619753730e-13,
 -2.094556639247794e-14,  8.240154627811858e-16, -2.983267922709527e-17,  1.002704202720494e-18, -3.148124673334254e-20,  1.302626465184901e-07, -3.320113136448177e-08,
  4.684417178985207e-09, -4.711997176825611e-10,  3.745155096934889e-11, -2.485756220548700e-12,  1.425800550157696e-13, -7.233599981506245e-15,  3.300672741201458e-16,
 -1.371707755013977e-17,  5.242996454443067e-19, -1.855703544347820e-20,  9.310405852502532e-09, -3.094254075689402e-09,  5.552845387133181e-10, -6.926662285912509e-11,
  6.681878647217407e-12, -5.285282280437419e-13,  3.556554439746396e-14, -2.088037052457398e-15,  1.089307910579896e-16, -5.120340145313324e-18,  2.192343741091340e-19,
 -8.614850120345106e-21,  8.059111715007264e-10, -3.225602774413922e-10,  6.908981781766348e-11, -1.010857053978451e-11,  1.125024288384992e-12, -1.011792005487315e-13,
  7.643068724915505e-15, -4.981197408053169e-16,  2.856459105086420e-17, -1.463109045271585e-18,  6.773716469962250e-20, -2.857838270723148e-21,  1.320871985625950e-03,
 -3.115472738196109e-05,  5.150916384928912e-07, -7.382358294017517e-09,  9.766886723365051e-11, -1.231387066630490e-12,  1.485917701341893e-14, -1.755068128985982e-16,
  2.020117704307729e-18, -2.166394230962897e-20,  2.705696710447267e-22, -2.431954111118631e-24,  3.097472795247061e-03, -8.751110624192668e-05,  1.875062271664379e-06,
 -3.541325511843111e-08,  6.139092798145826e-10, -9.981362732747974e-12,  1.540115214995542e-13, -2.279467434230112e-15,  3.253980443324249e-17, -4.488286854936102e-19,
  6.075477357548844e-21, -7.918493751932017e-23,  2.848406389141309e-03, -1.036908202010787e-04,  2.938711235839911e-06, -7.151114642061037e-08,  1.563120560630083e-09,
 -3.151460599500387e-11,  5.959484695782414e-13, -1.068514942954696e-14,  1.831107997690378e-16, -3.017036844097645e-18,  4.797362266244171e-20, -7.397434219531240e-22,
  1.433046553011274e-03, -6.973943272646304e-05,  2.569287245522832e-06, -7.863410518896566e-08,  2.120920586128773e-09, -5.201490775986570e-11,  1.182648133063979e-12,
 -2.524458645929848e-14,  5.106177850852608e-16, -9.854559403988616e-18,  1.823321813070813e-19, -3.249160779250902e-21,  4.350302460873936e-04, -2.873943397236922e-05,
  1.356893208128004e-06, -5.169363284961261e-08,  1.704328813657344e-09, -5.037939443578472e-11,  1.364753858743184e-12, -3.437580258527864e-14,  8.135622627049150e-16,
 -1.823262629520752e-17,  3.891990002180964e-19, -7.949156279540487e-21,  8.286911257745656e-05, -7.475170801378719e-06,  4.505022233036603e-07, -2.132655356646155e-08,
  8.574266662076499e-10, -3.046412199566174e-11,  9.802934568608751e-13, -2.904093007349510e-14,  8.013764391747324e-16, -2.077895836319195e-17,  5.096627746993492e-19,
 -1.188317395330751e-20,  1.012986913304222e-05, -1.251632357234388e-06,  9.672079560867497e-08, -5.712502579837027e-09,  2.808865022831422e-10, -1.202041342680442e-11,
  4.600937944767330e-13, -1.604163719633348e-14,  5.161685468712626e-16, -1.547755214575087e-17,  4.357560996194924e-19, -1.158091118879730e-20,  8.189975691174848e-07,
 -1.390147784196952e-07,  1.391192170641878e-08, -1.033668554481675e-09,  6.258902923852283e-11, -3.243902380430507e-12,  1.483185562169743e-13, -6.105003109095071e-15,
  2.295270512458249e-16, -7.967957150532136e-18,  2.575539516268555e-19, -7.797588763974739e-21,  4.718654951230363e-08, -1.099832817276784e-08,  1.440176609913256e-09,
 -1.358454637889124e-10,  1.020458230313975e-11, -6.441159776955568e-13,  3.531458029366913e-14, -1.719878352019261e-15,  7.561127057574481e-17, -3.037190458870438e-18,
  1.125215032214569e-19, -3.870033393718846e-21,  2.346686332857796e-09, -7.373554590148075e-10,  1.259026115655144e-10, -1.504102020684538e-11,  1.397145853249786e-12,
 -1.068914633215146e-13,  6.983224650200773e-15, -3.992879266854908e-16,  2.034191138045240e-17, -9.359341101596931e-19,  3.930449568529906e-20, -1.517602007188766e-21,
  1.419371771479472e-10, -5.579509180695448e-11,  1.174748293872973e-11, -1.692714065438162e-12,  1.858602917217787e-13, -1.651626832583305e-14,  1.234390036803269e-15,
 -7.968335152339206e-17,  4.530305271911250e-18, -2.302507998309924e-19,  1.058494026377845e-20, -4.437261331087494e-22,  1.203968669292096e-03, -2.736353515296119e-05,
  4.351253322671520e-07, -5.998849920719803e-09,  7.624422913058897e-11, -9.270831713863877e-13,  1.074651791559520e-14, -1.214453087158991e-16,  1.411667666866356e-18,
 -1.273241750610641e-20,  1.798766085299112e-22, -1.899813825719844e-24,  2.774955219507244e-03, -7.405742763235433e-05,  1.503046762448436e-06, -2.700665325269832e-08,
  4.466253130723354e-10, -6.946730563296666e-12,  1.026339455520587e-13, -1.455864706085512e-15,  2.003101448733164e-17, -2.633010025127317e-19,  3.457390555435192e-21,
 -4.372589759807968e-23,  2.475770520977813e-03, -8.323181061639435e-05,  2.212102869165823e-06, -5.085741447000826e-08,  1.054661860034808e-09, -2.022846177954706e-11,
  3.647826720943658e-13, -6.248460760060464e-15,  1.024248009223549e-16, -1.618316301357831e-18,  2.466512702122904e-20, -3.652287612055514e-22,  1.189942733171088e-03,
 -5.245279613246860e-05,  1.799367071702215e-06, -5.169045117562725e-08,  1.315517918842579e-09, -3.055076119455288e-11,  6.598445656499329e-13, -1.341205250035462e-14,
  2.587689894166427e-16, -4.776226560110947e-18,  8.457035526783948e-20, -1.444802447330166e-21,  3.384203986204555e-04, -1.996845360067255e-05,  8.719176765046188e-07,
 -3.098659866931161e-08,  9.592906860788598e-10, -2.674759582981710e-11,  6.860540601275107e-13, -1.641096533855392e-14,  3.697498169570782e-16, -7.908313405602642e-18,
  1.613900568641241e-19, -3.157327547659455e-21,  5.883285705986367e-05, -4.700795821029740e-06,  2.602842015790557e-07, -1.143566629309629e-08,  4.300341396536905e-10,
 -1.436931932852720e-11,  4.367751633427241e-13, -1.226670167946498e-14,  3.218727852146066e-16, -7.957678470094873e-18,  1.865389763033859e-19, -4.165738116140875e-21,
  6.324618563216219e-06, -6.906796760521198e-07,  4.879706408585765e-08, -2.666340785257313e-09,  1.223496810563339e-10, -4.917055556397047e-12,  1.776349426102076e-13,
 -5.869868895729474e-15,  1.796394899854422e-16, -5.139094352667897e-18,  1.384162500820719e-19, -3.528041504554517e-21,  4.257953258410387e-07, -6.422332641389133e-08,
  5.872897324139708e-09, -4.038569766944798e-10,  2.283989388430534e-11, -1.113240596088060e-12,  4.813167966752112e-14, -1.882007994060287e-15,  6.747847475359495e-17,
 -2.241571855260248e-18,  6.954337050026862e-20, -2.026390878853106e-21,  1.883674461183626e-08, -3.966746744658935e-09,  4.785145874074113e-10, -4.207821123001568e-11,
  2.972627258163425e-12, -1.776617817686031e-13,  9.273980558141490e-15, -4.320131258594886e-16,  1.823836963397621e-17, -7.059270066757041e-19,  2.527670150634649e-20,
 -8.425239205649448e-22,  6.474829368355029e-10, -1.900080741122802e-10,  3.058927991352328e-11, -3.474229513266232e-12,  3.088502234157157e-13, -2.273520210093866e-14,
  1.435416737900748e-15, -7.961273658648169e-17,  3.946674505353599e-18, -1.771766461346936e-19,  7.276946709057189e-21, -2.753754363658001e-22,  2.603149114021268e-11,
 -9.997540639654554e-12,  2.059843641050851e-12, -2.912187197378211e-13,  3.144897295171174e-14, -2.754194766328218e-15,  2.032059701449030e-16, -1.296809081125160e-17,
  7.297758762477369e-19, -3.675102139821363e-20,  1.675532026242135e-21, -6.971415449178740e-23,  1.101048149423445e-03, -2.415106236705634e-05,  3.698891487414353e-07,
 -4.914331393751785e-09,  6.003104356715301e-11, -7.052457908328979e-13,  7.918498203090374e-15, -8.238591860882728e-17,  1.061777591780021e-18, -7.321809217168024e-21,
  8.602889179411458e-23, -2.523782738653979e-24,  2.500880351685783e-03, -6.321764419973842e-05,  1.217656676957552e-06, -2.085095064932842e-08,  3.293613174284351e-10,
 -4.908144259646439e-12,  6.958908212636758e-14, -9.432163681364435e-16,  1.263589570297987e-17, -1.573010470426216e-19,  1.971937746421751e-21, -2.583787285902143e-23,
  2.174739775730387e-03, -6.771720282574658e-05,  1.691103616472028e-06, -3.679715221850009e-08,  7.251771416857644e-10, -1.325051981249555e-11,  2.281489707423667e-13,
 -3.740082679225870e-15,  5.864043930142066e-17, -8.904472671037422e-19,  1.303332836523263e-20, -1.845267067581221e-22,  1.005443225438123e-03, -4.022259925976179e-05,
  1.287682689752463e-06, -3.478252486572380e-08,  8.366846108321582e-10, -1.842351125126018e-11,  3.784092554503579e-13, -7.336387894549038e-15,  1.350139076184001e-16,
 -2.387377403911382e-18,  4.050927291949899e-20, -6.622403946810669e-22,  2.704635307828918e-04, -1.425507440547551e-05,  5.770393404726252e-07, -1.915810586692430e-08,
  5.577082179427711e-10, -1.468379244495918e-11,  3.569198179658879e-13, -8.116880983894312e-15,  1.741541352608947e-16, -3.557913619064053e-18,  6.945884251332432e-20,
 -1.301319783610579e-21,  4.346549073432982e-05, -3.069111042477129e-06,  1.564255008704355e-07, -6.383442238585348e-09,  2.247072683540129e-10, -7.065320165514317e-12,
  2.029477039962126e-13, -5.405519473693573e-15,  1.348836164753385e-16, -3.180085274746973e-18,  7.124447985069055e-20, -1.523572890944657e-21,  4.178745683382758e-06,
 -4.012139805947619e-07,  2.592294366156265e-08, -1.309899345674451e-09,  5.607806619624021e-11, -2.115634056911142e-12,  7.210367940632312e-14, -2.256996459945111e-15,
  6.565373349988243e-17, -1.790717190640192e-18,  4.610686147426287e-20, -1.126179140277316e-21,  2.391379476633601e-07, -3.177113011434150e-08,  2.647666231195794e-09,
 -1.680960084923052e-10,  8.861070079702766e-12, -4.053881395740856e-13,  1.654340097975069e-14, -6.133866253050765e-16,  2.093641980050414e-17, -6.643604348326400e-19,
  1.974859106585193e-20, -5.528833920161118e-22,  8.292294551343159e-09, -1.557774478255292e-09,  1.719426940080130e-10, -1.401919443175216e-11,  9.271577583055541e-13,
 -5.225509711516484e-14,  2.587494092203294e-15, -1.148990725646823e-16,  4.643282146158764e-18, -1.726600496506709e-19,  5.958397060572970e-21, -1.919650720375808e-22,
  1.975974994703361e-10, -5.337881925025423e-11,  8.021082752029533e-12, -8.592103848237924e-13,  7.261527436056670e-14, -5.113954879637912e-15,  3.104894065071323e-16,
 -1.663116444853093e-17,  7.991341919041525e-19, -3.488168110414367e-20,  1.396746994137204e-21, -5.165579953904744e-23,  5.023363637141032e-12, -1.871243997149393e-12,
  3.750328228552088e-13, -5.177229158839690e-14,  5.476986289814695e-15, -4.711455561774767e-16,  3.422059591517100e-17, -2.153881815503490e-18,  1.197307783413239e-19,
 -5.963881731483542e-21,  2.692434155426242e-22, -1.110391597534047e-23,  1.010010355837616e-03, -2.141251715185026e-05,  3.162461545521941e-07, -4.057066471413937e-09,
  4.765859316467869e-11, -5.392696527821893e-13,  6.051126376184153e-15, -5.219859003613706e-17,  8.304572246170162e-19, -6.421124402892040e-21, -4.862403116905561e-23,
 -3.539334754022542e-24,  2.266024940310617e-03, -5.439456241659638e-05,  9.960958324080393e-07, -1.628394794633665e-08,  2.459763483964000e-10, -3.513975180336720e-12,
  4.808521305643196e-14, -6.162796708753320e-16,  8.147780161142107e-18, -9.807837301951255e-20,  1.054353105252268e-21, -1.679998284317833e-23,  1.928386188986612e-03,
 -5.577575942503086e-05,  1.311284288133583e-06, -2.704903241966606e-08,  5.074221137968268e-10, -8.845947373991119e-12,  1.455135601070384e-13, -2.289800111538991e-15,
  3.430238578115318e-17, -5.005286679396228e-19,  7.111446849137626e-21, -9.475691240156749e-23,  8.628002999944654e-04, -3.138823287449016e-05,  9.398812900299084e-07,
 -2.391186360584731e-08,  5.446164360690968e-10, -1.138800070303570e-11,  2.224947643828388e-13, -4.127501749233290e-15,  7.237766397854376e-17, -1.226197234590921e-18,
  2.007898324881092e-20, -3.114403899893084e-22,  2.214079706875600e-04, -1.042629003392644e-05,  3.923115573368146e-07, -1.218604789134289e-08,  3.340982557039944e-10,
 -8.316873543914684e-12,  1.916728993921622e-13, -4.151929327249138e-15,  8.482419351469943e-17, -1.656037475811570e-18,  3.099935425759443e-20, -5.551371403299405e-22,
  3.328073352169691e-05, -2.072235826562253e-06,  9.746813662870764e-08, -3.697803425711499e-09,  1.219828236141903e-10, -3.612028801449608e-12,  9.808430515266884e-14,
 -2.479727957415972e-15,  5.884728139535357e-17, -1.323358353017533e-18,  2.834933278031075e-20, -5.803325796311037e-22,  2.907056112733259e-06, -2.441489091826692e-07,
  1.444602185937778e-08, -6.749985121827109e-10,  2.696521980668526e-11, -9.549805975036749e-13,  3.069803337478784e-14, -9.101149168694177e-16,  2.515383610284853e-17,
 -6.538352473029395e-19,  1.608606730760966e-20, -3.762792541639190e-22,  1.443778430084518e-07, -1.674853302420983e-08,  1.270298446550752e-09, -7.432332288121871e-11,
  3.646670055515439e-12, -1.563715822004668e-13,  6.014550924978677e-15, -2.111664449823358e-16,  6.851577995773972e-18, -2.073847495827808e-19,  5.898008315955207e-21,
 -1.584125335873602e-22,  4.020332194430428e-09, -6.648913324538112e-10,  6.676598568379598e-11, -5.023297489147544e-12,  3.097582493502304e-13, -1.640398704210533e-14,
  7.679452546839557e-16, -3.240560709726856e-17,  1.249879610221369e-18, -4.452588354528987e-20,  1.476960172262515e-21, -4.587610731366436e-23,  6.731256749217831e-11,
 -1.646060506732270e-11,  2.284297058286070e-12, -2.288545817943868e-13,  1.826046911007364e-14, -1.223005511884216e-15,  7.103268988436911e-17, -3.657536263166204e-18,
  1.696393146627776e-19, -7.172601227051016e-21,  2.790601965090526e-22, -1.005504242541101e-23,  1.033703888677412e-12, -3.697194247314833e-13,  7.150933175809829e-14,
 -9.578630766867914e-15,  9.876313861329922e-16, -8.310230777128304e-17,  5.921277981821808e-18, -3.664880217401208e-19,  2.007330235345356e-20, -9.868338530274259e-22,
  4.403301636936007e-23, -1.797069600484851e-24,  9.291291706734500e-04, -1.906509465121651e-05,  2.718049897420033e-07, -3.373367288656413e-09,  3.822162366665692e-11,
 -4.088130970362245e-13,  4.922387664877359e-15, -3.000799634019136e-17,  5.261315471717645e-19, -1.151145818251282e-20, -2.013983811976567e-22, -2.857982479048664e-24,
  2.063234536881911e-03, -4.714548066854323e-05,  8.221712342301617e-07, -1.285323539762208e-08,  1.859789455703399e-10, -2.540542851497115e-12,  3.399899716126960e-14,
 -4.052382204828329e-16,  5.214875640327480e-18, -6.884090405192115e-20,  4.523976020184639e-22, -1.054125711832992e-23,  1.724386527191824e-03, -4.645813275794343e-05,
  1.030130126524824e-06, -2.017564324779777e-08,  3.608100966356939e-10, -6.013827524692629e-12,  9.440682505778078e-14, -1.432703740126042e-15,  2.054478665455292e-17,
 -2.839170646634009e-19,  4.043132983138151e-21, -4.997802735360445e-23,  7.506566360761487e-04, -2.488441874241894e-05,  6.985487730665571e-07, -1.676500553660395e-08,
  3.620917445697117e-10, -7.209091408059374e-12,  1.336814985796278e-13, -2.385919844192018e-15,  3.992158790067786e-17, -6.405746112515058e-19,  1.036184167120478e-20,
 -1.507500288628155e-22,  1.851671128842668e-04, -7.793046985459189e-06,  2.733768029335248e-07, -7.955872089429425e-09,  2.057248841348281e-10, -4.852626849544525e-12,
  1.059224850862812e-13, -2.192820954140542e-15,  4.268969802514569e-17, -7.935430315470880e-19,  1.435816506981477e-20, -2.448697214604269e-22,  2.631077054942912e-05,
 -1.441568684554712e-06,  6.277883702006284e-08, -2.216375234772239e-09,  6.859636958029389e-11, -1.915677708029658e-12,  4.916574872916353e-14, -1.181733210735104e-15,
  2.668147795330972e-17, -5.718753546447715e-19,  1.173892663840183e-20, -2.298322858996187e-22,  2.119019876972770e-06, -1.548748392388592e-07,  8.413816953569740e-09,
 -3.635900707736525e-10,  1.356069839188277e-11, -4.510676205223899e-13,  1.367279643071124e-14, -3.840624893390256e-16,  1.008386424357580e-17, -2.496929289642607e-19,
  5.870173102440948e-21, -1.314271970579871e-22,  9.320072886755036e-08, -9.356934932532218e-09,  6.461143073074484e-10, -3.479232426086676e-11,  1.587572983483696e-12,
 -6.375349265033989e-14,  2.308727431579201e-15, -7.668148185061820e-17,  2.362522014783026e-18, -6.813042933736458e-20,  1.851702179923114e-21, -4.765421444614306e-23,
  2.139981638680945e-09, -3.073123664868148e-10,  2.795861248948056e-11, -1.933213949356689e-12,  1.107832968586645e-13, -5.495792129957459e-15,  2.425416512400907e-16,
 -9.699394225206352e-18,  3.561140430067360e-19, -1.212295846063380e-20,  3.855844625526789e-22, -1.151942533107244e-23,  2.577750437828853e-11, -5.598321873173598e-12,
  7.099217370490409e-13, -6.596491604784295e-14,  4.934842772888368e-15, -3.124408833336177e-16,  1.726750776808524e-17, -8.506411436256439e-19,  3.791878362491975e-20,
 -1.546946432161477e-21,  5.826971136371972e-23, -2.038877382272788e-24,  2.307318856004897e-13, -7.811582689397976e-14,  1.442917595163396e-14, -1.860298967841364e-15,
  1.857455029129853e-16, -1.520733042116013e-17,  1.058343116561160e-18, -6.417789446652822e-20,  3.452753784520076e-21, -1.670837127614511e-22,  7.351707984837914e-24,
 -2.963233127915747e-25,  8.569752047784272e-04, -1.704276107305326e-05,  2.347441236181644e-07, -2.821069550603036e-09,  3.116666529199359e-11, -2.992994289705970e-13,
  4.243377213121241e-15, -2.153623240554124e-17, -5.282356761688627e-20, -2.079639816737261e-20, -2.173734015890695e-22,  3.457258815245101e-24,  1.886897173740878e-03,
 -4.113807128012448e-05,  6.842434555140998e-07, -1.024327130385582e-08,  1.424968952175836e-10, -1.844055082385422e-12,  2.463631797033830e-14, -2.752954488467825e-16,
  2.971352486657480e-18, -5.765718470207516e-20,  1.761142341248459e-22, -9.257216268002388e-25,  1.553630159614249e-03, -3.909578615438777e-05,  8.190555317416682e-07,
 -1.525420116095264e-08,  2.602894233346655e-10, -4.163588216919044e-12,  6.215856056406144e-14, -9.114324314471983e-16,  1.277347074723361e-17, -1.589334968590349e-19,
  2.348467437664035e-21, -3.029878864384435e-23,  6.611474979532677e-04, -2.001218822707344e-05,  5.278798305981254e-07, -1.197103553750252e-08,  2.452473146680843e-10,
 -4.676786655238162e-12,  8.179708895164051e-14, -1.408761082887804e-15,  2.296332876427307e-17, -3.333342539033369e-19,  5.509216269953469e-21, -8.025914584071189e-23,
  1.578345974129017e-04, -5.938529299165431e-06,  1.948495891097975e-07, -5.320972646764104e-09,  1.298191160861667e-10, -2.915807503787459e-12,  6.003699793279621e-14,
 -1.191067960292780e-15,  2.230774431982789e-17, -3.877035683060774e-19,  6.879292327581298e-21, -1.135994441571033e-22,  2.140347877003879e-05, -1.029610647405919e-06,
  4.168387971157987e-08, -1.370959214638221e-09,  3.983072200716434e-11, -1.052494632579578e-12,  2.548280003574954e-14, -5.833405259519565e-16,  1.257421324411956e-17,
 -2.555024691754981e-19,  5.049186207821047e-21, -9.482805402907338e-23,  1.610938686280028e-06, -1.019137181954418e-07,  5.103997620986546e-09, -2.040530711223575e-10,
  7.108076072425265e-12, -2.224296057522661e-13,  6.352906594339633e-15, -1.691925335831183e-16,  4.223611161984469e-18, -9.949034157748518e-20,  2.237181600028737e-21,
 -4.794371576108188e-23,  6.396932760226951e-08, -5.506665430743145e-09,  3.470089858875180e-10, -1.718215128807302e-11,  7.287979815335838e-13, -2.740730975040347e-14,
  9.335779457452419e-16, -2.931847185161016e-17,  8.571796008510543e-19, -2.352640840289297e-20,  6.106264470073410e-22, -1.504278034384279e-23,  1.244796535097904e-09,
 -1.529830166632377e-10,  1.258650618474384e-11, -7.971897047040519e-13,  4.234409904733800e-14, -1.963213084606052e-15,  8.147931408507482e-17, -3.081013183076224e-18,
  1.074390513875083e-19, -3.487281610046576e-21,  1.061244863654092e-22, -3.042901886413988e-24,  1.114344961721008e-11, -2.103678541540076e-12,  2.414518881177613e-13,
 -2.064213731249337e-14,  1.438328972324025e-15, -8.559039791212559e-17,  4.477831487195145e-18, -2.100538904907784e-19,  8.960650699789183e-21, -3.513259987512740e-22,
  1.276543623360858e-23, -4.322917526926241e-25,  5.705357246298119e-14, -1.792155424879183e-14,  3.119185392212643e-15, -3.831366811418603e-16,  3.674862275711320e-17,
 -2.908435546213594e-18,  1.966360589906678e-19, -1.162989715052404e-20,  6.122336067521657e-22, -2.906777831984832e-23,  1.257671681730790e-24, -4.994406419972596e-26,
  7.923570773715370e-04, -1.529216213903616e-05,  2.037030864410470e-07, -2.364975276535383e-09,  2.614613684174889e-11, -2.056260689666116e-13,  3.494954364615013e-15,
 -3.636944804604035e-17, -8.877068923280439e-19, -2.264039961366883e-20,  2.327370747453459e-22,  1.801726051624908e-23,  1.732565566501123e-03, -3.611964805826564e-05,
  5.738841409993782e-07, -8.228695612402788e-09,  1.109517142239704e-10, -1.336404827084119e-12,  1.795767993627403e-14, -2.118796772644272e-16,  1.053392425536555e-18,
 -4.684419962312776e-20,  4.910186440283715e-22,  1.624515025651882e-23,  1.409284806118018e-03, -3.321058679984071e-05,  6.584856483822635e-07, -1.168259741993503e-08,
  1.900870217407642e-10, -2.936535595071070e-12,  4.161568443500602e-14, -5.785654324264339e-16,  8.441527372380462e-18, -8.963560012209560e-20,  1.144963232270705e-21,
 -2.616653795960743e-23,  5.887206247679862e-04, -1.630352871677477e-05,  4.049966474194046e-07, -8.700746814922811e-09,  1.685349204535456e-10, -3.113691699581738e-12,
  5.110160670108296e-14, -8.297073344859841e-16,  1.416752190098192e-17, -1.743862867236154e-19,  2.602179125336228e-21, -5.724134972480864e-23,  1.368382654621249e-04,
 -4.603802789846206e-06,  1.417619011604708e-07, -3.642143737981364e-09,  8.357886856149032e-11, -1.805669823924475e-12,  3.491094467152748e-14, -6.559626290701369e-16,
  1.228316163990815e-17, -1.930648426461446e-19,  3.236687550774791e-21, -6.018357374402816e-23,  1.786121304422385e-05, -7.525201861293024e-07,  2.845569403319265e-08,
 -8.736692110340783e-10,  2.377709967715423e-11, -5.987255075423917e-13,  1.363654315842593e-14, -2.960832925500644e-16,  6.188766160752200e-18, -1.177002854163010e-19,
  2.223053483982101e-21, -4.164386937531955e-23,  1.271782717223763e-06, -6.923417057509403e-08,  3.213945992667995e-09, -1.190013817829722e-10,  3.867299259425155e-12,
 -1.143166568839863e-13,  3.072015231387053e-15, -7.749479051249654e-17,  1.848385823194594e-18, -4.125596215077230e-20,  8.867118738500221e-22, -1.832214406983400e-23,
  4.642240785096248e-08, -3.392043190801393e-09,  1.959950384734568e-10, -8.921104163760178e-12,  3.514387819673086e-13, -1.239423988823134e-14,  3.967062518748837e-16,
 -1.177302614843939e-17,  3.268365234953204e-19, -8.524817629653389e-21,  2.111900307185245e-22, -4.981272508368829e-24,  7.867086219851130e-10, -8.145390647743989e-11,
  6.067648001012388e-12, -3.511328969544415e-13,  1.725169598319428e-14, -7.465379518599276e-16,  2.907892596583942e-17, -1.037841310373378e-18,  3.431572763922012e-20,
 -1.059895598474390e-21,  3.080540993217305e-23, -8.462046588095334e-25,  5.441953106096974e-12, -8.718133007650826e-13,  8.992143522337115e-14, -7.022189358732321e-15,
  4.530473203393440e-16, -2.520718398494978e-17,  1.242360287246540e-18, -5.525005719834078e-20,  2.246213314933495e-21, -8.431236777426614e-23,  2.944466865295758e-24,
 -9.617677371772184e-26,  1.601924463973773e-14, -4.540349931269838e-15,  7.323400290743540e-16, -8.464387191942124e-17,  7.723480446226065e-18, -5.862695166937896e-19,
  3.825658008531035e-20, -2.194851259293799e-21,  1.125387514223023e-22, -5.221680601003469e-24,  2.214087024043586e-25, -8.637326395254673e-27,  7.342776030066730e-04,
 -1.376922943810952e-05,  1.777113575362885e-07, -1.975392502469878e-09,  2.277050525448532e-11, -1.378228625635217e-13,  1.979453562054221e-15, -7.421604455635727e-17,
 -1.307026121747259e-18,  6.319439984938565e-21,  1.267285907816945e-21,  2.425937409799381e-23,  1.596683846650516e-03, -3.189526245163468e-05,  4.849795975487101e-07,
 -6.645843019779836e-09,  8.806661310945475e-11, -9.741853796990439e-13,  1.228007338789572e-14, -1.996650734425548e-16, -6.313202641926245e-20, -8.356135396773392e-21,
  1.502740498153721e-21,  2.480676430811061e-23,  1.286157873777274e-03, -2.845589882433201e-05,  5.347666990465335e-07, -9.061778209350391e-09,  1.401779618283554e-10,
 -2.104353890631356e-12,  2.876255193112331e-14, -3.534717997080383e-16,  5.763275062522699e-18, -6.656068365703566e-20,  3.452773907275897e-23, -2.208570257412921e-23,
  5.293841787892368e-04, -1.343968547582208e-05,  3.149083413758344e-07, -6.442787581387359e-09,  1.168860735914024e-10, -2.120006831750456e-12,  3.338849533697005e-14,
 -4.614816979554893e-16,  9.179038344958925e-18, -1.180954739169748e-19,  2.919688313383163e-22, -4.526998562393781e-23,  1.204432558438936e-04, -3.624273899851196e-06,
  1.050201665714405e-07, -2.553785240517725e-09,  5.456153861901484e-11, -1.149442404416555e-12,  2.115257384369432e-14, -3.538087121644209e-16,  7.098179439941666e-18,
 -1.087564493736378e-19,  1.147407778705867e-21, -3.637752099159409e-23,  1.524808533240896e-05, -5.611504352879518e-07,  1.990987599834102e-08, -5.737104982862129e-10,
  1.450486069075995e-11, -3.519348849932968e-13,  7.585838782949214e-15, -1.517689349727989e-16,  3.183475174297639e-18, -5.771183317417745e-20,  9.323435357134253e-22,
 -1.988441685100578e-23,  1.038509854172056e-06, -4.833372757492658e-08,  2.092956983827995e-09, -7.204230130727241e-11,  2.171990618262982e-12, -6.110453011933704e-14,
  1.547916691408337e-15, -3.658489769311072e-17,  8.452661297642566e-19, -1.791540421698256e-20,  3.586190025923384e-22, -7.396983764239074e-24,  3.542591121295514e-08,
 -2.172664038234853e-09,  1.159134343512778e-10, -4.857806792150792e-12,  1.771493963052846e-13, -5.881567760439802e-15,  1.768854214889798e-16, -4.943876015599676e-18,
  1.308311383867317e-19, -3.240031182248203e-21,  7.624570544426288e-23, -1.732687540773526e-24,  5.366775859131917e-10, -4.600435436579344e-11,  3.117867780213690e-12,
 -1.646610685596998e-13,  7.463753751308703e-15, -3.015378640155404e-16,  1.100678083284093e-17, -3.700718993351237e-19,  1.159576424668187e-20, -3.402054824046408e-22,
  9.425725817530842e-24, -2.478687044488885e-25,  2.993870177546504e-12, -3.961896978582800e-13,  3.660841542433757e-14, -2.595697924331281e-15,  1.542510394851615e-16,
 -7.990976234132688e-18,  3.694294929110345e-19, -1.551294508089188e-20,  5.988403822667549e-22, -2.144036322510006e-23,  7.172058950488137e-25, -2.252296633578703e-26,
  5.243161916219658e-15, -1.290996279885921e-15,  1.893860091118832e-16, -2.030200185082602e-17,  1.742644396906871e-18, -1.257175391197709e-19,  7.857927282288598e-21,
 -4.345224267025591e-22,  2.158228042353518e-23, -9.740649299423248e-25,  4.031344654126152e-26, -1.539525838138402e-27,  6.819024212827496e-04, -1.243636039350386e-05,
  1.561078924372871e-07, -1.631319944590057e-09,  2.029868146555307e-11, -1.193742456502577e-13, -5.700946031638036e-16, -1.009620349072803e-16,  1.847958229936302e-20,
  6.947626808402728e-20,  1.541740664438096e-21, -2.352960968246005e-23,  1.476389371175107e-03, -2.831185819489520e-05,  4.130875824412314e-07, -5.378537685350011e-09,
  7.107658490052497e-11, -7.465966053908108e-13,  6.709084264853712e-15, -1.931847874492543e-16,  9.104233774801401e-19,  6.472921357347871e-20,  1.791843122427555e-21,
 -2.456610011955825e-23,  1.180251750013024e-03, -2.457757240486137e-05,  4.382067100574131e-07, -7.121139786640884e-09,  1.042904312609103e-10, -1.514224779399314e-12,
  2.107959716462417e-14, -2.086720088695116e-16,  3.213795025513987e-18, -7.793579925783884e-20, -3.714770947405001e-22,  9.609070986990810e-24,  4.802152866601708e-04,
 -1.120083864027751e-05,  2.475471058864068e-07, -4.872119266601564e-09,  8.160741658673163e-11, -1.444482896779096e-12,  2.393651914066022e-14, -2.367977058249891e-16,
  4.757377707953164e-18, -1.344014331235672e-19, -6.961729500980311e-22,  1.120400446118497e-23,  1.074512507832448e-04, -2.893436468129657e-06,  7.893518033120026e-08,
 -1.840078714101626e-09,  3.596509581471676e-11, -7.383639053992018e-13,  1.388448161883055e-14, -1.831415234462644e-16,  3.692205226949801e-18, -8.701863619224951e-20,
  1.724509805505140e-22, -4.227596457498136e-24,  1.328337731727139e-05, -4.259412935148007e-07,  1.421408381129726e-08, -3.893104753442202e-10,  8.994712737652267e-12,
 -2.110578874311717e-13,  4.492778672834695e-15, -7.740962070965272e-17,  1.603064002448178e-18, -3.392122402868101e-20,  3.515114206459810e-22, -6.799882346919262e-24,
  8.739132805195164e-07, -3.453861532025799e-08,  1.402335698654484e-09, -4.534876374324883e-11,  1.252008226139128e-12, -3.370139044191262e-14,  8.218122116302038e-16,
 -1.762354012599858e-17,  3.949708641735183e-19, -8.501080904246609e-21,  1.444831146408026e-22, -2.886158436139671e-24,  2.827855439144477e-08, -1.437991397471833e-09,
  7.138066877211864e-11, -2.773562538235636e-12,  9.281168844465317e-14, -2.914293310018929e-15,  8.299973205989014e-17, -2.157587004893784e-18,  5.462199393204131e-20,
 -1.304512974513980e-21,  2.845436246859801e-23, -6.245477612671418e-25,  3.923928850602325e-10, -2.731495319223787e-11,  1.697850991203442e-12, -8.202594770916418e-14,
  3.411996490356325e-15, -1.289497573777988e-16,  4.415307573120964e-18, -1.392388773032313e-19,  4.137939058844565e-21, -1.154333068035843e-22,  3.032109723946654e-24,
 -7.640335865522019e-26,  1.843997075806720e-12, -1.955777285018345e-13,  1.622820179962198e-14, -1.040738138308367e-15,  5.666778918782888e-17, -2.726190396146747e-18,
  1.178206044418203e-19, -4.653507907258904e-21,  1.700713673389372e-22, -5.789623438483266e-24,  1.848615195282328e-25, -5.566264550271924e-27,  2.047875918007972e-15,
 -4.169249790824910e-16,  5.462545066295099e-17, -5.347379676656095e-18,  4.265200348675772e-19, -2.895362865713384e-20,  1.718811006143558e-21, -9.094746080445448e-23,
  4.348756933475049e-24, -1.898861680460925e-25,  7.634773081719894e-27, -2.842602953264991e-28,  6.345382693761979e-04, -1.126047030154672e-05,  1.383969800543067e-07,
 -1.327311085515085e-09,  1.755685230268289e-11, -1.642540492874864e-13, -2.946960633775262e-15, -5.196865298023130e-17,  3.153640689874026e-18,  8.581513912703820e-20,
 -1.275063710004258e-21, -9.521406535837014e-23,  1.369368428959341e-03, -2.524708128168750e-05,  3.548992540768033e-07, -4.353767209837462e-09,  5.734438698877898e-11,
 -6.446309076633377e-13,  2.136553982291314e-15, -1.166614869232161e-16,  4.025093218237915e-18,  8.803512227830229e-20, -1.236700446156127e-21, -1.041552668732979e-22,
  1.088448787958851e-03, -2.138749860344835e-05,  3.618495672222084e-07, -5.669092475999233e-09,  7.864056837181298e-11, -1.069465668829479e-12,  1.624336926509684e-14,
 -1.518999818446039e-16,  3.727542115025973e-19, -7.028258041405481e-20,  1.055993692695057e-21,  4.893220895845332e-23,  4.390310902953651e-04, -9.434129263237629e-06,
  1.960581932372905e-07, -3.768308217270754e-09,  5.799486394454202e-11, -9.369770814095142e-13,  1.868528985166557e-14, -1.647769951396542e-16, -2.192145855106796e-19,
 -1.258050869458254e-19,  1.725984752528955e-21,  8.973406535132332e-23,  9.701309136240690e-05, -2.341508789292492e-06,  5.987394726525830e-08, -1.366209926146104e-09,
  2.417163194034258e-11, -4.561622572158537e-13,  9.950962599095962e-15, -1.133534200159435e-16,  7.592447017987248e-19, -7.071717316620336e-20,  9.439750302005596e-22,
  3.551377288615684e-23,  1.178052483212786e-05, -3.287549918138311e-07,  1.028373751262172e-08, -2.739519861215670e-10,  5.701745400345212e-12, -1.244858579045700e-13,
  2.876952550324959e-15, -4.329980690345922e-17,  5.964363785853433e-19, -2.220429989103784e-20,  3.169157977916817e-22,  4.263559020498176e-24,  7.551707834354105e-07,
 -2.520112797589633e-08,  9.591679784648603e-10, -2.978256467328633e-11,  7.415545921274205e-13, -1.871929631067905e-14,  4.660561402375898e-16, -8.963732249455428e-18,
  1.698861191270278e-19, -4.456143277938857e-21,  7.492392057872669e-23, -5.359244155260791e-25,  2.348846478853670e-08, -9.786480866140053e-10,  4.538635385501622e-11,
 -1.664105462403919e-12,  5.041384296225882e-14, -1.486422130853726e-15,  4.130117073695352e-17, -9.854865705089800e-19,  2.295835821268424e-20, -5.646171938936630e-22,
  1.153905758793601e-23, -2.074169774925879e-25,  3.051567303084437e-10, -1.690556134090811e-11,  9.715679753401081e-13, -4.340684214338669e-14,  1.640512913789504e-15,
 -5.794494563165055e-17,  1.880941079917800e-18, -5.519881604745590e-20,  1.544330504283189e-21, -4.161683463464233e-23,  1.030036429343539e-24, -2.430443353383508e-26,
  1.259572617680543e-12, -1.036218050202679e-13,  7.778903753990708e-15, -4.518885202691275e-16,  2.238154143597582e-17, -9.984510949600378e-19,  4.032198413409709e-20,
 -1.490723223478146e-21,  5.143483948386263e-23, -1.663897410533645e-24,  5.049058904179918e-26, -1.452157438316968e-27,  9.677442829518945e-16, -1.534081667185905e-16,
  1.772666842881136e-17, -1.561371368288716e-18,  1.142505089422666e-19, -7.225775568473318e-21,  4.038150681325743e-22, -2.028456165124625e-23,  9.274792691220590e-25,
 -3.894843831793100e-26,  1.513246157125367e-27, -5.467713181389639e-29,  5.916162435522039e-04, -1.021250607317668e-05,  1.240330610596364e-07, -1.076783013467899e-09,
  1.351575230130722e-11, -2.387373963083777e-13, -2.641671661073444e-15,  8.058386188544840e-17,  4.371228734904197e-18, -3.963378852823563e-20, -4.360333313660768e-21,
 -8.567844592320913e-24,  1.273748351472591e-03, -2.260223647518524e-05,  3.077403446127149e-07, -3.537428272446755e-09,  4.478564132206085e-11, -6.156317644572605e-13,
  1.030115993881475e-15,  4.450714697071248e-17,  5.245553609289305e-18, -4.453307853563613e-20, -4.733974915475925e-21, -1.440056100656806e-23,  1.008285754965421e-03,
 -1.874492341783447e-05,  3.007287658589973e-07, -4.562224636740315e-09,  6.080359153159722e-11, -7.312598023156324e-13,  1.185852584226320e-14, -1.682962351633144e-16,
 -9.197093557902020e-19,  8.722410915690152e-21,  2.520146170549699e-21, -1.656290340869493e-24,  4.041656948839981e-04, -8.032041825780815e-06,  1.558620982207415e-07,
 -2.967571436762636e-09,  4.334657719935975e-11, -5.482046735740323e-13,  1.343200412211019e-14, -2.233324174988360e-16, -2.591924684211816e-18,  1.476885003559633e-20,
  4.703613807277718e-21,  8.105928733216519e-24,  8.850967495636916e-05, -1.922134917879773e-06,  4.553798153542803e-08, -1.040530401691895e-09,  1.718493889712396e-11,
 -2.546944162597102e-13,  6.804594427502438e-15, -1.193933318818517e-16, -7.307036942820081e-19, -3.209686503076895e-21,  2.206613611611683e-21,  4.724511454148099e-24,
  1.061119267466951e-05, -2.582506762048732e-07,  7.472621154569429e-09, -1.992721820459278e-10,  3.812656668110286e-12, -6.847175860827345e-14,  1.831481398143540e-15,
 -3.413233371173582e-17,  7.750127196527475e-20, -5.304324994287820e-21,  5.009157543504441e-22,  5.068782779984526e-25,  6.677012313556467e-07, -1.878053407295249e-08,
  6.623700243043595e-10, -2.038102568467383e-11,  4.613110062972597e-13, -1.005975743690649e-14,  2.710210782096881e-16, -5.542291225873039e-18,  6.049633994678784e-20,
 -1.661504353238882e-21,  6.699028506813155e-23, -2.391798382336861e-25,  2.019035253105150e-08, -6.836724711977167e-10,  2.942772816106157e-11, -1.049555328769204e-12,
  2.872232607423674e-14, -7.592685841725687e-16,  2.148724332853571e-17, -5.011649677108333e-19,  9.275463263674765e-21, -2.301372180829929e-22,  6.149781690062294e-24,
 -7.365515597945992e-26,  2.503118025109530e-10, -1.084472235523077e-11,  5.766488233029587e-13, -2.441739967368797e-14,  8.317264205055704e-16, -2.690890448898932e-17,
  8.486250429449937e-19, -2.348474823838275e-20,  5.899357658299162e-22, -1.554118073715580e-23,  3.907153984858014e-25, -7.940760057831326e-27,  9.421560644046341e-13,
 -5.822845227277843e-14,  3.984179422069738e-15, -2.123946794799072e-16,  9.477507093437678e-18, -3.896017142779718e-19,  1.481143567817380e-20, -5.112643369570257e-22,
  1.647067263610312e-23, -5.085115895496834e-25,  1.474230109191732e-26, -3.982942094781889e-28,  5.518426629547988e-16, -6.378746256976598e-17,  6.483178401604389e-18,
 -5.089384908608695e-19,  3.369518577783760e-20, -1.967060378197915e-21,  1.027093478798957e-22, -4.857026138553966e-24,  2.107975932120682e-25, -8.465031654852103e-27,
  3.160033852265075e-28, -1.101800766037151e-29,  5.526736020632765e-04, -9.268631276377601e-06,  1.122431725221384e-07, -9.011505896691656e-10,  8.361605532325996e-12,
 -2.617315471284228e-13,  1.131144271968478e-15,  1.666732128618264e-16,  2.347887252674049e-19, -1.651419314388786e-19, -6.728976883402829e-22,  1.537476550637354e-22,
  1.188010385582779e-03, -2.029885222927935e-05,  2.691905734466676e-07, -2.917282440674872e-09,  3.290826399243844e-11, -5.597356720739939e-13,  4.136132749576119e-15,
  1.527049546825993e-16,  6.543476464001533e-19, -1.842263305955020e-19, -8.531275556886109e-22,  1.682498682765034e-22,  9.377929922148568e-04, -1.654256071024112e-05,
  2.513821736260446e-07, -3.692556944761049e-09,  4.862921232227931e-11, -5.055801781754711e-13,  6.910260478661979e-15, -1.752197544058171e-16,  9.152671612141607e-19,
  7.834618403593112e-20,  3.314593136109336e-22, -8.386101170489233e-23,  3.743214619377362e-04, -6.916528855290179e-06,  1.241012578077622e-07, -2.346499608995535e-09,
  3.505789185811453e-11, -3.085056370970030e-13,  6.343385342514006e-15, -2.642131767985018e-16,  8.881922737947076e-19,  1.530918694932570e-19,  9.426541454046219e-22,
 -1.577631274461691e-22,  8.147681681161157e-05, -1.603437531210168e-06,  3.455880395269344e-08, -7.986289480383254e-10,  1.344143036117517e-11, -1.336580192242361e-13,
  3.233233968119435e-15, -1.286980086663435e-16,  5.619768212542052e-19,  6.401175489496417e-20,  5.755738874560158e-22, -7.085517140090108e-23,  9.683951663750947e-06,
 -2.070878863585653e-07,  5.409036877444543e-09, -1.471577304786829e-10,  2.806556586855482e-12, -3.574667610708539e-14,  9.082352056990245e-16, -3.107898699620442e-17,
  2.093915712698567e-19,  1.041965016860479e-20,  1.712910355755826e-22, -1.434605605010554e-23,  6.017876308863324e-07, -1.434762914494986e-08,  4.564530436066243e-10,
 -1.430555899827231e-11,  3.135516424855069e-13, -5.236369008050786e-15,  1.374140924153394e-16, -4.087786063933743e-18,  4.312492659217112e-20,  4.414391719265529e-22,
  2.854038824995034e-23, -1.479751190605128e-24,  1.785645089468471e-08, -4.918104065453040e-10,  1.916828605438072e-11, -6.877119723169902e-13,  1.770379405114680e-14,
 -3.845370086466869e-16,  1.066719592697229e-17, -2.956309219280705e-19,  4.650147907436780e-21, -4.886264685400771e-23,  2.779369022974855e-24, -8.798776628959305e-26,
  2.145768944895201e-10, -7.212023552713658e-12,  3.487794433367400e-13, -1.449947153832867e-14,  4.531306173709947e-16, -1.272342571138105e-17,  3.893521886161979e-19,
 -1.111265822597316e-20,  2.440568809564812e-22, -5.199929399274099e-24,  1.555199800365184e-25, -3.775862556187631e-27,  7.598387572822108e-13, -3.445925070462737e-14,
  2.139587566198081e-15, -1.077549174498411e-16,  4.329185031910486e-18, -1.599113286519105e-19,  5.771718148566574e-21, -1.904271779280617e-22,  5.603734847432506e-24,
 -1.603742723196145e-25,  4.630326252894196e-27, -1.207714764143679e-28,  3.716116818292329e-16, -2.948997577238626e-17,  2.646473037825161e-18, -1.860419403522696e-19,
  1.098859257937470e-20, -5.849908175205590e-22,  2.843789694193132e-23, -1.258894949563969e-24,  5.133652061087612e-26, -1.958281843156198e-27,  7.007532871557313e-29,
 -2.343832913056119e-30,  5.173291880866452e-04, -8.412047319852150e-06,  1.020683347345824e-07, -8.062344875408050e-10,  3.757927744424275e-12, -1.830829131232846e-13,
  5.048925747243384e-15,  8.694655221725962e-17, -4.617285494660819e-18, -6.737270126643402e-20,  4.717647421947534e-21,  4.310268008016866e-23,  1.110911880267538e-03,
 -1.827721478946961e-05,  2.369943271472787e-07, -2.473495992785909e-09,  2.303909546233999e-11, -4.127941392130949e-13,  7.745548023192317e-15,  7.540707277213598e-17,
 -4.843110665802912e-18, -7.955812159359219e-20,  5.201490888091187e-21,  5.213937735308875e-23,  8.753819543295563e-04, -1.469623677188343e-05,  2.114310581958874e-07,
 -2.987947080079726e-09,  3.980659841290432e-11, -3.927770546522537e-13,  2.815430946755966e-15, -1.052236506309900e-16,  3.136466382448126e-18,  2.590983659189179e-20,
 -2.458433973762077e-21, -1.899427319376506e-23,  3.484755296712428e-04, -6.027242240950163e-06,  9.912540961589549e-08, -1.829054919979599e-09,  2.984901689517979e-11,
 -2.368147263784218e-13,  1.448221996030059e-16, -1.538309159701824e-16,  5.447326842430962e-18,  6.153231932351135e-20, -4.684213819895948e-21, -4.800310789298812e-23,
  7.556023278596688e-05, -1.361826826390070e-06,  2.618787743983590e-08, -6.018962473402544e-10,  1.127197873306398e-11, -9.513662198424766e-14,  2.236777384517214e-16,
 -7.555230939947933e-17,  2.534958839432783e-18,  2.755652505529509e-20, -2.049912945573579e-21, -2.507419628800772e-23,  8.931974788582171e-06, -1.701638168205694e-07,
  3.892051640221896e-09, -1.070655511751473e-10,  2.244566908720480e-12, -2.327203986413902e-14,  1.902933101930034e-16, -1.831843810336209e-17,  5.539778347110049e-19,
  4.916684856468797e-21, -3.831418939566860e-22, -6.003744685140349e-24,  5.507242960914928e-07, -1.130436168106179e-08,  3.119126666966268e-10, -9.983234418988251e-12,
  2.334189543650310e-13, -3.136689102299465e-15,  4.547308757951020e-17, -2.364525812289068e-18,  6.352579580331107e-20,  2.860581412351547e-22, -3.075052931742094e-23,
 -7.405078323957059e-25,  1.614976158318247e-08, -3.671657819791763e-10,  1.239957565665197e-11, -4.545938352257222e-13,  1.198487922785686e-14, -2.120884934958673e-16,
  4.317247273861442e-18, -1.610882999963526e-19,  3.968856427684480e-21, -1.236214556523378e-23, -6.689068520452485e-25, -4.908766616543278e-26,  1.903593997470369e-10,
 -5.011019443067540e-12,  2.112785478472951e-13, -8.869183371632986e-15,  2.708621223818478e-16, -6.367838307845892e-18,  1.662225951400052e-19, -5.391473480527108e-21,
  1.335030227108948e-22, -1.780534898648925e-24,  2.924276362842131e-26, -1.845475912923664e-27,  6.494398714133295e-13, -2.153913877501484e-14,  1.176765588931419e-15,
 -5.805332188466344e-17,  2.170300370483818e-18, -6.938779999957838e-20,  2.286568609712833e-21, -7.621456085836576e-23,  2.165828496535456e-24, -5.188523078076739e-26,
  1.356668378349355e-27, -4.145272707358261e-29,  2.851477175571519e-16, -1.495591350218163e-17,  1.176695032700907e-18, -7.606238061989462e-20,  3.998796476930581e-21,
 -1.896844075038181e-22,  8.524881190531313e-24, -3.560001596435713e-25,  1.356970641618367e-26, -4.821107775228669e-28,  1.643531974677863e-29, -5.337592892141619e-31,
  4.852539518587786e-04, -7.633410422837432e-06,  9.265627611960123e-08, -7.683054283246173e-10,  1.414237572171650e-12, -5.030939005049993e-14,  5.312486624783755e-15,
 -6.329674191212333e-17, -3.759559274597964e-18,  9.848760309904106e-20,  2.360037416539840e-21, -1.179228037257272e-22,  1.041415049818768e-03, -1.649428096186762e-05,
  2.092855596723961e-07, -2.160433978935936e-09,  1.671678310776020e-11, -2.202561798796695e-13,  7.547858089529243e-15, -8.500891698556185e-17, -4.046750325676423e-18,
  1.063274491917147e-19,  2.713057870961712e-21, -1.304886633316072e-22,  8.197673437930848e-04, -1.313795966707746e-05,  1.791475508113352e-07, -2.411007890344375e-09,
  3.244789286823235e-11, -3.490401914443201e-13,  1.279621384202646e-15, -8.561406666476365e-18,  2.393846286548045e-18, -5.775554900949197e-20, -1.115263837362647e-21,
  6.195208079822304e-23,  3.258245409866138e-04, -5.314279179232099e-06,  7.988345278918676e-08, -1.390269047500310e-09,  2.490425298383099e-11, -2.646035748726712e-13,
 -1.651332467091827e-15,  1.955369984259001e-17,  4.368176615510588e-18, -1.054228375361246e-19, -2.398586354034102e-21,  1.195054462595685e-22,  7.049032404809485e-05,
 -1.178294439155104e-06,  1.998383281055382e-08, -4.370231311399514e-10,  9.300704390278890e-12, -1.056566461695385e-13, -7.234463598547759e-16,  5.247115937264674e-18,
  2.054150071888566e-18, -4.770950387950294e-20, -1.119781254698548e-21,  5.342898890536098e-23,  8.306271796132079e-06, -1.435905047928061e-07,  2.807800324921706e-09,
 -7.476521649322111e-11,  1.793890462047064e-12, -2.280503119457777e-14, -7.011398364363211e-17, -8.696751012552942e-19,  4.462619515057227e-19, -9.799475189079487e-21,
 -2.281420825653390e-22,  1.044270102645944e-23,  5.098224423421222e-07, -9.229242990976567e-09,  2.125924614291508e-10, -6.709451610687247e-12,  1.774294587109494e-13,
 -2.609992167314474e-15,  7.389044933161423e-18, -4.322251873038236e-19,  4.924506456142443e-20, -1.010384897549615e-21, -2.131719409775738e-23,  9.424199609313300e-25,
  1.484915771095690e-08, -2.868221830980132e-10,  7.969670668687299e-12, -2.924232965375433e-13,  8.485408261151658e-15, -1.489176032531092e-16,  1.465070941493957e-18,
 -4.887831671881622e-20,  2.781827358623998e-21, -5.403839110498018e-23, -7.780220953929967e-25,  3.505874519385935e-26,  1.731144730270704e-10, -3.681330255280904e-12,
  1.272295816866734e-13, -5.380836127619461e-15,  1.734335097856214e-16, -3.761585394911662e-18,  6.633355135665945e-20, -2.035515456196348e-21,  7.732369465953715e-23,
 -1.536518458631193e-24, -1.271961481273067e-27,  2.604062224543526e-28,  5.784144678655403e-13, -1.441044663825552e-14,  6.506517997199583e-16, -3.205257299721946e-17,
  1.192737802100631e-18, -3.371230870232326e-20,  8.997704429162251e-22, -2.914364665589112e-23,  9.459838615873775e-25, -2.234104163257409e-26,  3.598874471339868e-28,
 -8.520873763936217e-30,  2.395998809085144e-16, -8.335611398352017e-18,  5.511403261197674e-19, -3.398946541705202e-20,  1.642681978294439e-21, -6.806460327995564e-23,
  2.719977690117009e-24, -1.077210406798684e-25,  3.967998786181624e-27, -1.307487687822313e-28,  4.020556873612769e-30, -1.242556470081142e-31,  4.561449136717642e-04,
 -6.928689489848329e-06,  8.355947895131031e-08, -7.476004681862746e-10,  1.484691463980575e-12,  4.600360856384447e-14,  2.460186884374593e-15, -1.186803061910073e-16,
  2.726871471837127e-19,  9.635526470993323e-20, -1.932888503533455e-21, -4.984974073169190e-23,  9.786283543773413e-04, -1.491942610771791e-05,  1.848489406372157e-07,
 -1.919386163760108e-09,  1.387155017573021e-11, -7.829825309196930e-14,  4.014153956069298e-15, -1.434916111140747e-16,  3.808783621639325e-19,  1.068368488873668e-19,
 -2.112856114773184e-21, -5.735313342728282e-23,  7.699104036605100e-04, -1.181220137662616e-05,  1.531055868166286e-07, -1.945971762008907e-09,  2.579066665792808e-11,
 -3.146479259190672e-13,  1.768794779742803e-15,  3.135495333206112e-17,  1.374987122109277e-19, -5.278568248806591e-20,  1.067315246092871e-21,  2.399804888611124e-23,
  3.057489167126151e-04, -4.735584793922274e-06,  6.541050437592524e-08, -1.035869951979637e-09,  1.932537794281819e-11, -2.857826146807257e-13,  2.102425947032917e-16,
  9.031163662798315e-17,  8.283210457483119e-20, -1.027407235640689e-19,  2.000393224890898e-21,  5.174304315743989e-23,  6.606702673029822e-05, -1.037037109156570e-06,
  1.556004308088084e-08, -3.058991501514756e-10,  7.056746161989909e-12, -1.156088717704688e-13,  5.087044413262958e-17,  3.947855534248825e-17,  9.143426263161790e-20,
 -4.759734970134437e-20,  8.974089551719709e-22,  2.452612240489926e-23,  7.771794901731900e-06, -1.242640911264193e-07,  2.067520981360752e-09, -4.978706104719071e-11,
  1.325791106912800e-12, -2.353231474029841e-14,  4.521873472094964e-17,  6.923937951917475e-18,  4.106207743232771e-20, -9.931653316213551e-21,  1.794998885315985e-22,
  5.148728419034705e-24,  4.758600014576911e-07, -7.806209796140779e-09,  1.474163314519075e-10, -4.279926270587874e-12,  1.267857458744279e-13, -2.437191498278615e-15,
  1.120173118243453e-17,  4.823213612675798e-19,  7.947178683399282e-21, -1.018816747532221e-21,  1.744643549193813e-23,  5.139259788192401e-25,  1.381013309881985e-08,
 -2.350087074571331e-10,  5.182204110749014e-12, -1.788819543896028e-13,  5.791659168465086e-15, -1.220495358023208e-16,  1.026896362873861e-18,  6.380016258047878e-21,
  6.924647821515541e-22, -5.098943928850930e-23,  8.267728037505881e-25,  2.277203380658813e-26,  1.600755542868568e-10, -2.879833497251673e-12,  7.706444980517891e-14,
 -3.136254047833708e-15,  1.107348004693328e-16, -2.624534885410733e-18,  3.579632864483066e-20, -4.198730249425662e-22,  2.574017140802160e-23, -1.184424928540757e-24,
  1.917647153191182e-26,  3.373695694543645e-28,  5.291457511319915e-13, -1.046410880589247e-14,  3.614453107065299e-16, -1.741399418700294e-17,  6.831818252738927e-19,
 -1.914637324586602e-20,  4.035021477732023e-22, -9.439770557735355e-24,  3.474163385467881e-25, -1.171019890762304e-26,  2.250080111317857e-28, -8.787743353169669e-31,
  2.130107436771652e-16, -5.195796166424948e-18,  2.652472054934695e-19, -1.586396727132277e-20,  7.489058578156657e-22, -2.808592575565494e-23,  9.461177390499469e-25,
 -3.315304214468698e-26,  1.212227042918583e-27, -4.064340701336711e-29,  1.153782641790691e-30, -2.930622981313498e-32,  4.297109717004332e-04, -6.295609288787089e-06,
  7.476859139661885e-08, -7.143536157617917e-10,  2.742565679676719e-12,  6.876130134863530e-14, -3.403399981562589e-16, -7.163206737581229e-17,  2.124592149866740e-18,
  7.384012242809275e-21, -1.874321888069008e-21,  3.657071533380937e-23,  9.217675642656653e-04, -1.352908360495209e-05,  1.631096680287985e-07, -1.706036779934651e-09,
  1.296334986862048e-11, -2.590305778498424e-14,  6.116997571820611e-16, -8.872873765485683e-17,  2.438567575265289e-18,  8.095517987281312e-21, -2.097921370314659e-21,
  4.043220783938807e-23,  7.249726873973095e-04, -1.067421009515791e-05,  1.320304278604710e-07, -1.581070131894007e-09,  1.998963056872893e-11, -2.625941616784372e-13,
  2.488183392734755e-15,  1.461522366128004e-17, -8.947671898162834e-19, -5.383281970189862e-21,  9.806733877893742e-22, -1.948417084647359e-23,  2.877812750451383e-04,
 -4.257194465568005e-06,  5.464985153361493e-08, -7.712875482496867e-10,  1.385430689927141e-11, -2.528871174518761e-13,  2.345537094649620e-15,  5.158835319591035e-17,
 -1.939038646646782e-18, -1.035901970090851e-20,  1.955506399113194e-21, -3.756535337391563e-23,  6.214707153187863e-05, -9.254939553686313e-07,  1.249161639064102e-08,
 -2.110580632049295e-10,  4.842322654901277e-12, -1.020939467018063e-13,  9.964798694923883e-16,  2.306629089483721e-17, -8.594481996375008e-19, -5.400162519233616e-21,
  9.039124606138733e-22, -1.697002526983938e-23,  7.304497880564869e-06, -1.097881479811071e-07,  1.582190276115947e-09, -3.221570327880638e-11,  8.812713160581744e-13,
 -2.024565778105714e-14,  2.152114418749013e-16,  4.150860604412145e-18, -1.618642573303025e-19, -1.337600928623168e-21,  1.865418848028802e-22, -3.399575188070015e-24,
  4.467124990393985e-07, -6.801415961716843e-09,  1.066803686751871e-10, -2.621969627489773e-12,  8.184897416318584e-14, -2.005885553060719e-15,  2.387614329962618e-17,
  3.098445533182814e-19, -1.354766082079276e-20, -1.712338279749591e-22,  1.865813046850155e-23, -3.267258709644260e-25,  1.294140938117210e-08, -2.007384758195218e-10,
  3.515636918640724e-12, -1.043176724297865e-13,  3.618279484292356e-15, -9.419108588580519e-17,  1.292602482405517e-18,  6.690601689674315e-21, -4.298524371590732e-22,
 -1.113843370601145e-23,  8.847164348467053e-25, -1.474595207266841e-26,  1.495885228460084e-10, -2.387438880152380e-12,  4.847107370598155e-14, -1.740515576713793e-15,
  6.621767240402442e-17, -1.847055719396468e-18,  3.031983828761537e-20, -1.145753123230892e-22, -1.517261087858859e-24, -3.373722390583943e-25,  1.839452433543478e-26,
 -2.954686444837414e-28,  4.919768030652115e-13, -8.248646482176379e-15,  2.069297940578096e-16, -9.091999312958382e-18,  3.807439784819017e-19, -1.170754760439289e-20,
  2.432843302509849e-22, -3.431233745694911e-24,  7.448291729836255e-26, -3.957600524764459e-27,  1.487839853889067e-28, -2.580430344146680e-30,  1.955056553824547e-16,
 -3.667560075876481e-18,  1.315294312161978e-19, -7.392851173406306e-21,  3.569703911202172e-22, -1.322083371134474e-23,  3.925121153585958e-25, -1.086024003243668e-26,
  3.458903490861187e-28, -1.236515013907339e-29,  3.959123997041456e-31, -9.827107679924076e-33,  4.056717249804021e-04, -5.730904746564231e-06,  6.650204647498737e-08,
 -6.604595516648239e-10,  3.912780920385107e-12,  4.401960503201652e-14, -1.437688377314934e-15, -1.044136899994675e-17,  1.463177526395942e-18, -3.274843370982749e-20,
 -1.977280795069648e-22,  2.928043555827382e-23,  8.701362539333102e-04, -1.230260773809987e-05,  1.438652673869378e-07, -1.502657570569290e-09,  1.243576529872254e-11,
 -3.243366644521338e-14, -8.299491174900461e-16, -1.842299236835307e-17,  1.689658654224322e-18, -3.697491418055038e-20, -2.240624114118682e-22,  3.293454299923662e-23,
  6.842753494256886e-04, -9.688798468751983e-06,  1.148140284940146e-07, -1.299925575605821e-09,  1.535142087933467e-11, -2.011552015392631e-13,  2.511007136150535e-15,
 -1.134532626344695e-17, -6.040004326187887e-19,  1.562315862723549e-20,  1.083604323862112e-22, -1.503502985660046e-23,  2.715731176153932e-04, -3.853611676191984e-06,
  4.656845449237767e-08, -5.866568161211643e-10,  9.440484872394038e-12, -1.861634509476434e-13,  2.952569488056879e-15, -4.854564209151890e-18, -1.339213981965961e-18,
  3.192509899270174e-20,  2.237430982889536e-22, -3.037898881898181e-23,  5.863058770733412e-05, -8.345205783513782e-07,  1.036107447542991e-08, -1.484530040935434e-10,
  3.075872007553125e-12, -7.350540434008432e-14,  1.268580925274358e-15, -2.173405995240940e-18, -6.015646371956616e-19,  1.433056050596616e-20,  1.096091445706056e-22,
 -1.406798163901248e-23,  6.888512259829766e-06, -9.846607104363102e-08,  1.267833083820740e-09, -2.104517252013300e-11,  5.343713787877840e-13, -1.427214312760508e-14,
  2.600802646574112e-16, -6.837550483270570e-19, -1.159192520658080e-19,  2.789348143498608e-21,  2.463945331627614e-23, -2.899803797267158e-24,  4.210421298775640e-07,
 -6.054400350976413e-09,  8.185707247065664e-11, -1.600153302253479e-12,  4.790320435321626e-14, -1.379054529225749e-15,  2.640141558241668e-17, -1.098009870752781e-19,
 -1.019104007131153e-20,  2.497368065523748e-22,  2.788153315498785e-24, -2.881072606820315e-25,  1.218799221931107e-08, -1.767684834924613e-10,  2.554574199469025e-12,
 -5.977711237532272e-14,  2.051028699458685e-15, -6.263619800199243e-17,  1.267544072525604e-18, -8.084370856272935e-21, -3.720448926490242e-22,  9.398749760468807e-24,
  1.572267202694487e-25, -1.338997409344594e-26,  1.407040674767564e-10, -2.067760664039059e-12,  3.284735629328782e-14, -9.383134364636979e-16,  3.623375822968046e-17,
 -1.170200569769054e-18,  2.545568019659651e-20, -2.437789781244759e-22, -3.934046139576534e-24,  1.059702232212348e-25,  4.096520212943314e-27, -2.637215513936908e-28,
  4.617272621089397e-13, -6.941943341258988e-15,  1.275973373588978e-16, -4.585207498414506e-18,  1.981640121971896e-19, -6.848476376111921e-21,  1.660378395098734e-22,
 -2.404527390383990e-24,  1.148769797628106e-26, -2.627751422669420e-28,  4.166158695439711e-29, -1.858415487555521e-30,  1.824922650831084e-16, -2.890293177448273e-18,
  6.977865468775297e-20, -3.370053025119987e-21,  1.671822689853494e-22, -6.519244778132541e-24,  1.940352106071158e-25, -4.567583098434100e-27,  1.017692565266381e-28,
 -3.038613547365301e-30,  1.141959729740600e-31, -3.728217191996913e-33,  3.837635189931090e-04, -5.229471582953868e-06,  5.897506580143257e-08, -5.927049373296592e-10,
  4.447141328554536e-12,  1.020618250525769e-14, -1.250704160047403e-15,  1.797541956557140e-17,  3.714153987081241e-19, -2.366972767250930e-20,  4.529820687489394e-22,
  2.532859558932910e-24,  8.231181661683163e-04, -1.122048744428351e-05,  1.270020487983827e-07, -1.310038306738352e-09,  1.157244641965897e-11, -5.366547632793366e-14,
 -7.878050236569388e-16,  1.485354744020256e-17,  4.557615897749229e-19, -2.679878046074591e-20,  5.095173609065610e-22,  2.877997007691930e-24,  6.472639034745500e-04,
 -8.828792237004495e-06,  1.005661270444172e-07, -1.083353892501965e-09,  1.189616576678786e-11, -1.463644377112595e-13,  2.007130824564257e-15, -2.185553813084393e-17,
 -8.123550569688787e-20,  1.124892479245060e-20, -2.252828210007566e-22, -1.319056949283888e-24,  2.568624632040653e-04, -3.506914245236379e-06,  4.032415706928919e-08,
 -4.616646376435749e-10,  6.394347741695187e-12, -1.207063065259430e-13,  2.389344520315907e-15, -2.965587462598375e-17, -2.674806134407243e-19,  2.319773766695538e-20,
 -4.548032462144020e-22, -2.745493705572427e-24,  5.544804723633583e-05, -7.580223104766459e-07,  8.831629842333943e-09, -1.093993178754509e-10,  1.896102145814117e-12,
 -4.548332197890463e-14,  1.016050688353552e-15, -1.328018392011585e-17, -1.175687070102502e-19,  1.049958844475209e-20, -2.063919931238217e-22, -1.320265998912721e-24,
  6.513513173771743e-06, -8.920777462693402e-08,  1.058236337495178e-09, -1.445246687243108e-11,  3.080321030660472e-13, -8.584760067649620e-15,  2.042643010288377e-16,
 -2.794204929855339e-18, -2.069015929749993e-20,  2.073152723685159e-21, -4.102093565478986e-23, -2.880275886778146e-25,  3.980285338567063e-07, -5.465201449537805e-09,
  6.645107123956511e-11, -1.021521907224013e-12,  2.625532320967680e-14, -8.106082686300580e-16,  2.014767117946535e-17, -2.902884640080447e-19, -1.483069244004062e-21,
  1.909660773279675e-22, -3.814300744488253e-24, -3.121080594018906e-26,  1.151792344557278e-08, -1.587282456069010e-10,  1.997902485888282e-12, -3.542650247316716e-14,
  1.078632317948088e-15, -3.594506924451996e-17,  9.284774522583671e-19, -1.428569176596884e-20, -2.773752681777004e-23,  7.688093407997125e-24, -1.553673690058695e-25,
 -1.658180502147760e-27,  1.328990959689493e-10, -1.841740702204088e-12,  2.439438443230314e-14, -5.151355730165768e-16,  1.833020008341789e-17, -6.512252505574796e-19,
  1.755638931568729e-20, -2.953408743639104e-22,  6.952503055334005e-25,  1.098044389082493e-25, -2.238702084985187e-27, -4.001159125070539e-29,  4.357165778607876e-13,
 -6.096467734981939e-15,  8.771912520672350e-17, -2.315996686862688e-18,  9.579842107019849e-20, -3.630598863807845e-21,  1.039490968996944e-22, -1.996796440503880e-24,
  1.681972102269954e-26,  2.561637469747255e-28, -4.699239699184720e-30, -3.722796884298492e-31,  1.718443954249675e-16, -2.456810988840339e-18,  4.179924046859348e-20,
 -1.523096376821568e-21,  7.457228099387877e-23, -3.105387547583829e-24,  1.000398158387842e-25, -2.435941158376990e-27,  4.465281857481785e-29, -7.374922068286813e-31,
  2.113662928534532e-32, -9.287131449014707e-34,  3.637459040629345e-04, -4.784905437178770e-06,  5.229149146327499e-08, -5.213621622960272e-10,  4.395922539940476e-12,
 -1.308970273822108e-14, -6.841654659455700e-16,  1.969295582902953e-17, -1.639048481441187e-19, -7.024540989159632e-21,  3.209865708550318e-22, -5.693532628300946e-24,
  7.801730150848569e-04, -1.026429264594294e-05,  1.123542327138302e-07, -1.134331906361457e-09,  1.034900178072218e-11, -6.668410185278642e-14, -2.847043071934245e-16,
  1.790199930231146e-17, -1.524931202917337e-19, -8.064579289831727e-21,  3.613813171954626e-22, -6.408463499053922e-24,  6.134797526290713e-04, -8.073234959615029e-06,
  8.861921782555718e-08, -9.140254251930443e-10,  9.400861541073464e-12, -1.055188513843453e-13,  1.407245945491089e-15, -1.970173769234536e-17,  1.659569311305176e-19,
  2.960526117566855e-21, -1.594708808599138e-22,  2.868419297799527e-24,  2.434471434995482e-04, -3.204906301568469e-06,  3.532767098518397e-08, -3.758434650992485e-10,
  4.484219409385852e-12, -7.364833508938520e-14,  1.539601791613853e-15, -2.834250779961893e-17,  2.486273771511377e-19,  6.430979163660915e-21, -3.229640880368255e-22,
  5.800827241755901e-24,  5.254959673556649e-05, -6.921658708109885e-07,  7.674781402297159e-09, -8.514425374972541e-11,  1.199243728158419e-12, -2.569356685166024e-14,
  6.369479764206204e-16, -1.258166187898242e-17,  1.152619663600267e-19,  2.866860176976344e-21, -1.470589840920506e-22,  2.655506295597557e-24,  6.172618565214912e-06,
 -8.136327072176141e-08,  9.095004643668455e-10, -1.065833061917649e-11,  1.788872680062425e-13, -4.638578699633641e-15,  1.257013541651661e-16, -2.578850721088661e-18,
  2.495889317333874e-20,  5.477221780712341e-22, -2.941117682145156e-23,  5.353692776197798e-25,  3.771619652324188e-07, -4.976559778407688e-09,  5.625579471446901e-11,
 -7.076507104706606e-13,  1.421555796857089e-14, -4.246830518087716e-16,  1.217565571678970e-17, -2.574205580589531e-19,  2.672847199444802e-21,  4.762050695679245e-23,
 -2.769782859285999e-24,  5.098281636120219e-26,  1.091263573811584e-08, -1.441995527681119e-10,  1.656161630553429e-12, -2.284382500291774e-14,  5.505714021954502e-16,
 -1.835037235452578e-17,  5.488577704067360e-19, -1.197325644431347e-20,  1.361653843875541e-22,  1.713088114080639e-24, -1.161897342338098e-25,  2.171712748375884e-27,
  1.258891974764601e-10, -1.667181076937009e-12,  1.960932184744086e-14, -3.058809713595838e-16,  8.875488319988986e-18, -3.236005425160855e-19,  1.006050603809615e-20,
 -2.283790463129176e-22,  2.931721644808832e-24,  1.785455009352498e-26, -1.826724083059660e-27,  3.485821766800720e-29,  4.125887079939517e-13, -5.484552862093768e-15,
  6.711759650865643e-17, -1.246391437599715e-18,  4.394951657750441e-20, -1.739216533629425e-21,  5.658845600293915e-23, -1.365025260562604e-24,  2.079990987719600e-26,
 -4.430717859847726e-29, -6.745423338485841e-30,  1.309478504006319e-31,  1.625935367223275e-16, -2.179218968483530e-18,  2.899707022278812e-20, -7.169048064520024e-22,
  3.169590176521961e-23, -1.381683861934149e-24,  4.866119943576598e-26, -1.325976509850733e-27,  2.678449767213994e-29, -3.669133717383186e-31,  3.323156172148789e-33,
 -9.268001483938668e-35,  3.454049782283399e-04, -4.390428011466909e-06,  4.644610658824471e-08, -4.538393104116421e-10,  4.010821533607981e-12, -2.364263831005273e-14,
 -2.293488684829399e-16,  1.239851266871477e-17, -2.442503324053721e-19,  1.078381628626991e-21,  9.938296144306607e-23, -3.757752121250990e-24,  7.408311413158965e-04,
 -9.417194762509891e-06,  9.969097596963251e-08, -9.796306462685164e-10,  8.983923754024036e-12, -6.823542572053407e-14,  1.213201250728778e-16,  1.062508091695929e-17,
 -2.485476447143203e-19,  1.059939610047004e-21,  1.120186414621890e-22, -4.224973805079960e-24,  5.825386667532319e-04, -7.405746753688943e-06,  7.848921267656580e-08,
 -7.788354947275776e-10,  7.586918612262791e-12, -7.770409488352841e-14,  9.386062836194715e-16, -1.367426203794717e-17,  1.872528422862062e-19, -1.029372788031557e-21,
 -4.766656415279359e-23,  1.897190748779176e-24,  2.311657861584833e-04, -2.939205881075160e-06,  3.120523593364731e-08, -3.141237312515943e-10,  3.321745475161054e-12,
 -4.518487482384912e-14,  8.772872968232157e-16, -1.868463025286787e-17,  3.073370231362176e-19, -1.657350949633141e-21, -9.700123706964047e-23,  3.825839033975761e-24,
  4.989767392353535e-05, -6.345625685356329e-07,  6.753603191979995e-09, -6.934815603572346e-11,  8.121337316600426e-13, -1.415706645065386e-14,  3.450310974697836e-16,
 -8.152431170119164e-18,  1.399462189762381e-19, -8.029319325073682e-22, -4.357044742268992e-23,  1.749483717926118e-24,  5.860968055040913e-06, -7.455630993802211e-08,
  7.961803684270527e-10, -8.397156627738222e-12,  1.109530340699687e-13, -2.386751499472415e-15,  6.628519325197904e-17, -1.646350507683742e-18,  2.902392192560001e-20,
 -1.820406550966943e-22, -8.520201319991287e-24,  3.525373063887952e-25,  3.581067610924094e-07, -4.557167799740955e-09,  4.889357223294830e-11, -5.345371327781136e-13,
  8.114462214412062e-15, -2.083676885000436e-16,  6.295841791744017e-18, -1.615106158890633e-19,  2.920304958913717e-21, -2.050811434281687e-23, -7.742242118687277e-25,
  3.361017164795305e-26,  1.036077983989163e-08, -1.319207787988070e-10,  1.424808617885181e-12, -1.635970686483502e-14,  2.908191162579656e-16, -8.678874926852337e-18,
  2.785657769238256e-19, -7.340680670835326e-21,  1.367793432919818e-22, -1.104804693990186e-24, -3.053541915197068e-26,  1.440488676844943e-27,  1.195138301980839e-10,
 -1.522991302751410e-12,  1.661424256597426e-14, -2.045105338421709e-16,  4.355750216497884e-18, -1.481176110305855e-19,  4.992969429779481e-21, -1.353604626890756e-22,
  2.627997875724601e-24, -2.528434487598918e-26, -4.210178699010925e-28,  2.368573855063955e-29,  3.916435752183723e-13, -4.997707938155281e-15,  5.543887634090295e-17,
 -7.593591506633297e-19,  2.002717178641431e-20, -7.675665537750780e-22,  2.714510350586989e-23, -7.649043784061105e-25,  1.584013026213957e-26, -1.915677398457859e-28,
 -8.893534609102103e-31,  1.013491571902753e-31,  1.542959822518067e-16, -1.974776566413081e-18,  2.270003104735886e-20, -3.784147550560904e-22,  1.318527708527764e-23,
 -5.739023299061412e-25,  2.170322353856133e-26, -6.588496871739272e-28,  1.551109849941595e-29, -2.633870478698028e-31,  2.508267854029457e-33,  6.419329088166078e-36,
  3.285534030686535e-04, -4.039589858326871e-06,  4.136878651595307e-08, -3.936452432117565e-10,  3.506709519250189e-12, -2.580803932321457e-14,  1.807999674796271e-17,
  5.700357788052799e-18, -1.657580212163480e-19,  2.606116074185377e-21, -3.867935653537753e-24, -1.154496938086884e-24,  7.046862808667777e-04, -8.664347849701968e-06,
  8.875358090138071e-08, -8.465616604646528e-10,  7.668021355748588e-12, -6.259417908525120e-14,  3.175637254621356e-16,  3.842846656906798e-18, -1.655646742665424e-19,
  2.790972147103475e-21, -3.925474345674258e-24, -1.293237131601518e-24,  5.541150825869516e-04, -6.813264271176403e-06,  6.982388336430580e-08, -6.687720455430285e-10,
  6.230406728534847e-12, -5.913884327165029e-14,  6.322351240581931e-16, -8.506537999770201e-18,  1.319660043968305e-19, -1.701231940456350e-21,  4.382572590816034e-24,
  5.784402202695691e-25,  2.198855663839804e-04, -2.703800471571837e-06,  2.772808251408266e-08, -2.672201955868030e-10,  2.591655558575418e-12, -2.937144829313127e-14,
  4.791346398598118e-16, -1.027835187532000e-17,  2.102264568058884e-19, -3.052744586486602e-21,  7.603201019428705e-24,  1.154695488740004e-24,  4.746249758383557e-05,
 -5.836604995686154e-07,  5.991312826520013e-09, -5.823816689963502e-11,  5.957789793578443e-13, -8.144964402214634e-15,  1.734637495010849e-16, -4.347436703641891e-18,
  9.445772819636304e-20, -1.412287632071820e-21,  4.074718336118058e-24,  5.209337931376353e-25,  5.574881961459760e-06, -6.856288804738570e-08,  7.047322276343988e-10,
 -6.931232824650287e-12,  7.590280890734270e-14, -1.251880851031790e-15,  3.188650916032273e-17, -8.629617059005615e-19,  1.930856539393073e-20, -2.952112763204986e-22,
  1.027330256915477e-24,  1.029293150520419e-25,  3.406225193702294e-07, -4.189740148452317e-09,  4.314341976651246e-11, -4.311927156216134e-13,  5.142909904502105e-15,
 -1.018086562796051e-16,  2.942559822154121e-18, -8.344946949798569e-20,  1.906983239002970e-21, -2.988046877033297e-23,  1.285864821319005e-25,  9.525249359898745e-27,
  9.854747197627931e-09, -1.212396175049120e-10,  1.251688697122237e-12, -1.279348792757438e-14,  1.698269457216218e-16, -4.007680826978873e-18,  1.272556573059735e-19,
 -3.733369991161594e-21,  8.705951838222418e-23, -1.407593949741013e-24,  7.663947187888029e-27,  3.888006079428579e-28,  1.136735721119324e-10, -1.398897685362569e-12,
  1.449846629548825e-14, -1.531357381350592e-16,  2.329975588749291e-18, -6.517823223862726e-20,  2.230205756310491e-21, -6.740572561333542e-23,  1.610749853972486e-24,
 -2.721791491758289e-26,  1.928778109294397e-28,  5.818765391901670e-30,  3.724884566798147e-13, -4.586167757696266e-15,  4.783964591643378e-17, -5.326717444749305e-19,
  9.724552446920383e-21, -3.222470810884069e-22,  1.178067447851845e-23, -3.681842071585639e-25,  9.125158426015768e-27, -1.652777367420319e-28,  1.594813895405518e-30,
  1.882181690052356e-32,  1.467354281014844e-16, -1.808469703102333e-18,  1.912279962363977e-20, -2.363421798769851e-22,  5.676976733633462e-24, -2.263707333753204e-25,
  8.918813566905789e-27, -2.945841179414956e-28,  7.856205029060436e-30, -1.628502839134207e-31,  2.360353270396682e-33, -1.382520548541172e-35,  3.130283225120189e-04,
 -3.726619558524105e-06,  3.696485546521121e-08, -3.415990332054898e-10,  3.005076277842427e-12, -2.397448600037902e-14,  1.168860386504680e-16,  1.795866512708099e-18,
 -8.284892759517181e-20,  1.867164363932071e-21, -2.489009653266384e-23, -1.712031057832381e-26,  6.713874307208388e-04, -7.992960771205135e-06,  7.929107682754718e-08,
 -7.334473108874077e-10,  6.498357468753127e-12, -5.419053758881865e-14,  3.653914459333790e-16,  4.207400665432357e-20, -7.700589549424054e-20,  1.980766869272014e-21,
 -2.739804901817378e-23, -1.720267676572376e-26,  5.279306612181669e-04, -6.285164496208109e-06,  6.236017464072970e-08, -5.777964201773809e-10,  5.182307086965631e-12,
 -4.640062605412222e-14,  4.444242872089486e-16, -5.194087968479964e-18,  7.791755686066636e-20, -1.236503038857693e-21,  1.468363063665697e-23, -6.132606691593555e-28,
  2.094946460003458e-04, -2.494138470569362e-06,  2.475264060589377e-08, -2.299137842678730e-10,  2.099419371308770e-12, -2.066309609651414e-14,  2.698519306453187e-16,
 -5.179914887162178e-18,  1.138366405300937e-19, -2.173876172785979e-21,  2.798575813472748e-23, -5.778821556393151e-27,  4.521950457470694e-05, -5.383744704026020e-07,
  5.344907070323860e-09, -4.981852684096968e-11,  4.662238164115980e-13, -5.146006981191637e-15,  8.682777048932165e-17, -2.075028709122024e-18,  5.014593397186887e-20,
 -9.928684249273572e-22,  1.308277631549220e-23, -8.903929763580860e-27,  5.311406285263251e-06, -6.323875266409878e-08,  6.281328609994218e-10, -5.882589646335710e-12,
  5.688151554714422e-14, -7.161074179533338e-16,  1.487075858306188e-17, -4.009769679449054e-19,  1.012283740812041e-20, -2.043173034358198e-22,  2.750162660904089e-24,
 -3.699168511200754e-27,  3.245228808426192e-07, -3.864024472061526e-09,  3.840616331965259e-11, -3.620410748214446e-13,  3.655288068669820e-15, -5.327357597272214e-17,
  1.309148316222634e-18, -3.807723559661592e-20,  9.876142993851904e-22, -2.025500270790101e-23,  2.796701397566078e-25, -6.274309676740310e-28,  9.388901791786099e-09,
 -1.117991714407181e-10,  1.112277952283692e-12, -1.058199600315031e-14,  1.131854399944658e-16, -1.937237367651755e-18,  5.466691915597895e-20, -1.676522785565473e-21,
  4.441847600257717e-23, -9.270703797483276e-25,  1.323800224873840e-26, -4.591159655757544e-29,  1.082991029862716e-10, -1.289709692427702e-12,  1.284939264245213e-14,
 -1.239243687068031e-16,  1.435267389321306e-18, -2.932038527156698e-20,  9.297577371681762e-22, -2.973190704284399e-23,  8.046130084488269e-25, -1.718558691158059e-26,
  2.573657232663689e-28, -1.337751437034820e-30,  3.548719324806866e-13, -4.226778987138787e-15,  4.220992784949470e-17, -4.162537822229929e-19,  5.420817604406430e-21,
 -1.352575509422977e-22,  4.758121763579341e-24, -1.582704096429707e-25,  4.402146220619089e-27, -9.747693294610909e-29,  1.572281552597417e-30, -1.231343603501797e-32,
  1.397913588048152e-16, -1.665568186039014e-18,  1.671338024973044e-20, -1.724563250857740e-22,  2.748054999018832e-24, -8.769075929623229e-26,  3.430602342727548e-27,
 -1.201732401387652e-28,  3.515110977627300e-30, -8.374063612657969e-32,  1.554614983525869e-33, -1.960160004868361e-35  };
  int offset = -11;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 11;
    if (std::isnan(t)) {
      fill_n(rr+offset, 11, 0.5);
      fill_n(ww+offset, 11, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 11; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=11; ++j) {
        const int boxof = it*132+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
