local briefingtext01 =
   "Level One: First Strike\n"..
   "June 21st, Year 8\n"..   
   "As part of the ongoing Vespollan campaign, "..
   "you've been reassigned. Your first mission is to sabotage "..
   "the enemy's air base on Red Island. "..
   "Though small and relatively undefended, the base has proven "..
   "to be a problem for our forces. "..
   "We have allotted you a small strike force. You are to neutralise "..
   "all enemy units and emplacements."
local briefingtext02 =
   "Level Two: Sabotage\n"..
   "July 4th, Year 8\n"..
   "Your second assignment is another relatively easy sabotage "..
   "mission. You've been given an elite sabotage team to "..
   "eliminate all enemy forces on Grendi Island, so our forces can "..
   "begin harvesting  resources from the resource rich island. "..
   "The enemy is not yet aware of your presence. Use this to "..
   "your advantage."
local briefingtext03 =
   "Level Three: Sprekt Assault\n"..
   "November 30th, Year 8\n"..
   "All available troops have been recalled to Korla for "..
   "a massive invasion to retake the city. We can only offer you the "..
   "men you need to train your own troops for this assault. "..
   "Sprekt Island is a heavily fortified complex. Scouts "..
   "report several gun turrets and plenty of armour. "..
   "The island's commander, your old rival Commander Petch, is  "..
   "not present for some reason though, so his troops will be in disarray, "..
   "and will likely only work to defend themselves."
local briefingtext04 =
   "Level Four: Assault on Aether\n"..
   "January 5th, Year 9\n"..
   "The invasion of Korla was a resounding success, and now we can "..
   "put our entire military might into conquering the Vespollan Ilses. "..
   "Your fourth assignment is to conquer Aether island, a large base "..
   "supporting the enemy on the main islands. You now have control "..
   "of a large invasion force. Our aim is to use Aether island as "..
   "a base of operations for when we invade the larger islands. "..
   "But first we need to capture it."
local briefingtext05 =
   "Level Five: Defense of Aether\n"..
   "January 10th, Year 9\n"..
   "Having captured Aether Island for our own uses, the enemy seeks "..
   "to take it back. Commander Petch, angry at your sabotage of his "..
   "base, is leading the attack. Beware, as he is a skilled commander, "..
   "and has already established a working base on the north-western "..
   "corner of the island."
local briefingtext06 =
   "Level Six: Pebble Beach\n"..
   "February 12th, Year 9\n"..
   "This is the last island before the invasion of Vespollan. "..
   "Taking Triton Island is going to be a big operation, "..
   "but it is imperative. The south side of the island has several "..
   "cannon emplacements that are blocking our boats from reaching "..
   "Vespollan, and so they must be eliminated. Because of Triton's "..
   "rocky shores, vehicles cannot make it ashore, so a small group "..
   "of foot soldiers and engineers are all that can be landed. "..
   "You will need to build your own invasion force."
local briefingtext07 =
   "Level Seven: Meltdown\n"..
   "February 15th, Year 9\n"..
   "Scouts report that the north side of Triton island has several "..
   "nuclear missile silos. This poses a severe threat to our forces "..
   "and must be eliminated at all costs. Commander Petch is "..
   "organising the defences of the silos, and should not be taken "..
   "lightly. He will do everything in his power to stop you."
local briefingtext08 =
   "Level Eight: Korla\n"..
   "April 19th, Year 9\n"..
   "Korla is our largest and most militarily powerful city. "..
   "After its recapture earlier this year, the enemy has been attacking "..
   "our many smaller bases surrounding it, systematically eliminating "..
   "them. Despite concerted defence efforts, we have not been able "..
   "to stop their advance, and now they are at the last base before "..
   "they reach Korla again. Their invasion must be stopped, but we "..
   "cannot afford to divert troops away from the Vespollan Isles, "..
   "so you are ordered to build your own counter-invasion force "..
   "and eliminate the enemy before they can move on and take "..
   "back Korla."
local briefingtext09 =
   "Level Nine: Red Skirmish\n"..
   "May 1st, Year 9\n"..
   "It is two days before the planned invasion of Vespollan. A significant "..
   "portion of the invasion force has stopped at Red Island to refuel, "..
   "rearm, and resupply. What they discover is that the enemy has "..
   "covertly recaptured the island, and has a huge occupying battalion "..
   "stationed there. They know that this force needs to be eliminated "..
   "as fast as possible before they move on and attempt to retake "..
   "the other islands we now occupy."
local briefingtext10 =
   "Level Ten: Fenrir Beach\n"..
   "June 8th, Year 9\n"..
   "After the Red Island attack the invasion was postponed, "..
   "but now our campaign can continue into the last enemy stronghold: "..
   "Vespollan Island. The enemy's military capital is in the heart "..
   "of the island, and capturing that will end the war at last, "..
   "bringing their nation to its knees.\n"..
   "First though, we need to actually move our troops onto Vespollan. "..
   "The enemy believes their fortifications to be impassible, but "..
   "we're determined to show them otherwise. All over the island, "..
   "we're landing thousands of tanks and infantrymen on their beaches.\n"..
   "You've been assigned Fenrir Beach, and have been given over "..
   "100 armoured vehicles with which to capture the beach. "..
   "Smash through the enemy's fortifications, and clear all the turrets "..
   "and cannons off the beach, then destroy all enemy buildings. "..
   "If all goes well you should have no trouble establishing a beachhead."
local briefingtext11 =
   "Level Eleven: Lake Manticore\n"..  
   "July 21st, Year 9\n"..
   "The beach landings of Vespollan island were a success, but as our "..
   "troops move further inland, they are sustaining heavy casualties. "..
   "It has been determined we need to establish a base at "..
   "Lake Manticore, in the mid-south portion of Vespollan. "..
   "However, as with every strategically important location in "..
   "this campaign, the enemy has already established a presence here."
local briefingtext12 =
   "Level Twelve: Wetlands\n"..
   "August 3rd, Year 9\n"..
   "Pushing deeper into the island, our advance troops have "..
   "scouted out several more strategic locations where bases should "..
   "be established. Here, in the mid south-eastern area of the island "..
   "lies the defunct Morchella military base, now reclaimed by nature. "..
   "It is your job to build our own base here, in preparation for "..
   "the attack on the Ascocarp air base to the north. Beware of "..
   "any enemy forces seeking to sabotage your efforts."
local briefingtext13 =
   "Level Thirteen: Detour\n"..
   "August 20th, Year 9\n"..
   "A large strike force has been deployed to destroy the Ascocarp "..
   "air base. However the main roads are crawling with enemy troops "..
   "so the strike force is circling around them. On their detour, they "..
   "encounter an enemy strike force led by Commander Petch attempting "..
   "to reach our base near the old Morchella base without being detected. "..
   "Commander Petch is not happy to see you."
local briefingtext14 =
   "Level Fourteen: Ascocarp\n"..
   "September 6th, Year 9\n"..
   "So far, all attempts at taking the Ascocarp air base have been "..
   "unsuccessful, and now the enemy has launched a huge attack on "..
   "our base near Morchella, despite our pre-emptive defense efforts. "..
   "Desperate to take the air base but short on troops, you have been "..
   "given only a small force and a handful of engineers. "..
   "You'll have to train your own attack force. Be careful of "..
   "the enemy's defenses."
local briefingtext15 =
   "Level Fifteen: Prisoners of War\n"..
   "October 15th, Year 9\n"..
   "Though we captured the Ascocarp air base, the past month saw "..
   "several crushing defeats at the hands of the enemy. "..
   "In particular, our best leader, Commander Willis, was captured "..
   "and killed. A small group of his men are all that remain. "..
   "They are being held in a POW camp, and it's up to you to "..
   "free them. Do so, and you will have the men you need to build "..
   "your base and clear the enemy from this portion of the island. "..
   "Be careful though, the enemy's main base here is heavily fortified."
local briefingtext16 =
   "Level Sixteen: Anti-Armour\n"..
   "November 7th, Year 9\n"..
   "On the edge of the Black Forest, allied troops encountered "..
   "an unexpected enemy stronghold. After a huge firefight, little "..
   "remained of either party, and our troops retreated to Lake Manticore. "..
   "The enemy needs to be eliminated from the edge of the forest before "..
   "we can secure it. This is your next objective. "..
   "They have no doubt rebuilt their base by "..
   "now. Keep in mind their commander, Colonel Gillian, likes to use "..
   "tanks. A lot. Unfortunately, we cannot counter his armour with "..
   "our own, because demand for vehicle and factory cpus has outstripped "..
   "supply, and they cannot be constructed on site. You will need "..
   "to defeat him with only infantrymen."
local briefingtext17 =
   "Level Seventeen: Black Forest\n"..
   "November 21st, Year 9\n"..
   "Despite huge losses on our side, the enemy's hold on the "..
   "island is finally starting to weaken. They're on the retreat "..
   "and our troops are closing in on their capital in the heart of "..
   "Vespollan island. Governments around the world are calling for "..
   "an end to hostilities; our enemy's nation is on the verge "..
   "of total annihilation. But neither side is willing to give up. "..
   "The horrors both sides have experienced in this long "..
   "war have steeled their resolve to win or die trying. "..
   "At last you have Commander Petch backed into a corner with no "..
   "escape. Recalling vividly the destruction of the nuclear strikes "..
   "he ordered on your home town several years ago, you can see "..
   "your revenge is finally within your grasp. Between you two however "..
   "is the sprawling Black Forest. The thick trees will make it difficult "..
   "to build a base, so it may be necessary to clear them first. "..
   "Just be careful Commander Petch doesn't take you out before you "..
   "build your fortifications."
local briefingtext18 =
   "Level Eighteen: Liberation\n"..
   "December 19th, Year 9\n"..
   "Commander Petch is dead. But you aren't done yet.\n"..
   "Right now our troops are pushing towards the enemy's capital. "..
   "Though enduring intense fighting, they are making huge gains. "..
   "However, a few days ago, we lost contact with a large tank battalion, "..
   "among them some of our best tank crews. They were to take part "..
   "in the final push to the capital. It is likely they were captured "..
   "and are being held in an internment camp on the far shore "..
   "of Lake Elixer. The fastest way to rescue them is via air, "..
   "so that's the way we've decided to go. We can only spare one "..
   "chopper for the rescue, so be careful. After the tanks are "..
   "liberated, move west and you should find an enemy base. "..
   "This base is the largest for several dozen kilometers around, "..
   "and was the tank battalion's initial target. Destroy it."
local briefingtext19 =
   "Level Nineteen: Penultimate Assault\n"..
   "December 28th, Year 9\n"..
   "Last night the advance strike forces, which were supposed to "..   
   "attack the enemy's capital today, were annihilated by a massive "..
   "series of explosions. Nuclear weapons. The enemy has unexpectedly "..
   "constructed somewhere in the range of a dozen nuclear missile "..
   "silos right under our noses. As we speak they are destroying our "..
   "already weakened invasion force with nuclear strikes all over "..
   "their own island. This needs to be dealt with swiftly and without "..
   "hesitation. If we are to win this war their nuclear capabilities "..
   "must be eliminated. This is all that stands between us and "..
   "total victory."
local briefingtext20 =
   "Level Twenty: Battle of Survival\n"..
   "January 1st, Year 10\n"..
   "We've crushed the enemy's military, destroyed their nation and "..
   "culture. All that remains of them is their capital city, surrounded "..
   "by the wreckage that used to be their civilisation. "..
   "Their attempts to defend it are fanatical and determined, but "..
   "even now they are already losing the battle. Your final objective "..
   "is to completely destroy their largest base, stationed right outside "..
   "the capital, to prevent it from sending reinforcements to aid "..
   "their dying city. Complete this, and we will finally, after "..
   "a full decade of fighting, have won the war. We are supplying "..
   "you with a huge attack force, but their base is enormous, and "..
   "you may need to train more troops before you can raze the "..
   "last shreds of their military at last."


function DisplayEnding()
  t = 
   "Looking at the smoking wreckage that once was your most hated enemy's "..
   "civilisation, you finally, after ten long years, relax a bit. "..
   "You recall the early years of the war, when your people fought "..
   "for their very survival amidst the radioactive wreckage of their "..
   "cities; which are still uninhabitable years later.\n".. 
   "You can't remember why the war started, and can hardly even "..
   "remember what the enemy had called themselves now, having known them "..
   "as simply 'the enemy' for as long as you can recall. "..
   "Already your people, escaping their nuked out cities, are moving "..
   "into territory their mortal foes once held.\n"..
   "You have proved to the world that, when their very survival "..
   "is at stake, your nation will win the battle."
obj = {_("nil")}
  RunBriefingMenu(obj, t, nil, "campaigns/islands/crescents.png")
end

campaign_steps = {
  CreateMapStep("campaigns/islands/level01.smp",
      {"Sabotage the enemy's undefended airbase. Kill all enemy units."}, 
      briefingtext01,
      nil,
      "campaigns/islands/crescents.png"),
  CreateMapStep("campaigns/islands/level02.smp", 
      {"Clear the island of enemy units and emplacements."}, 
      briefingtext02,
      nil,
      "campaigns/islands/crescents.png"),
  CreateMapStep("campaigns/islands/level03.smp",
      {"Build your base and destroy the enemy's military presence."},
      briefingtext03,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level04.smp",
      {"Wipe the enemy off of Aether Island."},
      briefingtext04,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level05.smp",
      {"Defend Aether Island at all costs. Kill all enemy units."},
      briefingtext05,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level06.smp",
      {"Clear the way for the supply ships, eliminate all enemy forces."},
      briefingtext06,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level07.smp",
      {"Destroy the SRBM silos, clear the rest the island."},
      briefingtext07,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level08.smp",
      {"Retake the base, eliminate all enemies."},
      briefingtext08,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level09.smp",
      {"Eliminate the occupying battalion, retake Red Island."},
      briefingtext09,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level10.smp",
      {"Annihilate enemy fortifications, clear all enemies off the beach."},
      briefingtext10,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level11.smp",
      {"Build your base at Lake Manticore, eliminate the enemy presence."},
      briefingtext11,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level12.smp",
      {"Build your base, kill all enemies."},
      briefingtext12,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level13.smp",
      {"Neutralise the enemy strike force."},
      briefingtext13,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level14.smp",
      {"Destroy the air base and all enemy units."},
      briefingtext14,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level15.smp",
      {"Rescue the POWs, destroy the POW camp, build your base, and destroy the enemy's base."},
      briefingtext15,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level16.smp",
      {"Defeat the enemy's armoured battalion with just infantry."},
      briefingtext16,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level17.smp",
      {"Defeat Commander Petch once and for all."},
      briefingtext17,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level18.smp",
      {"Rescue the tank battalion, destroy the Lake Elixer base."},
      briefingtext18,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level19.smp",
      {"Destroy the enemy's missile silos, clear the way for the final assault."},
      briefingtext19,
      nil,
      "campaigns/islands/crescents.png"),
CreateMapStep("campaigns/islands/level20.smp",
      {"Annihilate the enemy's last stronghold. Leave no survivors."},
      briefingtext20,
      nil,
      "campaigns/islands/crescents.png"),
DisplayEnding,
}