/*
 * widgets/SelectionControl.cpp is is part of Brewtarget, and is copyright the following
 * authors 2018-2021:
 * - Iman Ahmadvand <iman72411@gmail.com>
 * - Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Brewtarget is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "widgets/SelectionControl.h"

SelectionControl::SelectionControl(QWidget * parent) : QAbstractButton(parent) {
   setObjectName("SelectionControl");
   setCheckable(true);
   return;
}

SelectionControl::~SelectionControl() = default;

void SelectionControl::enterEvent(QEvent * e) {
   setCursor(Qt::PointingHandCursor);
   QAbstractButton::enterEvent(e);
   return;
}

Qt::CheckState SelectionControl::checkState() const {
   return isChecked() ? Qt::Checked : Qt::Unchecked;
}

void SelectionControl::checkStateSet() {
   const auto state = checkState();
   emit stateChanged(state);
   toggle(state);
   return;
}

void SelectionControl::nextCheckState() {
   QAbstractButton::nextCheckState();
   SelectionControl::checkStateSet();
   return;
}
