# Change Log

## [Unreleased]

## [0.4.6] - 2018-10-27

### Improved

* Support 2018-style macro import for the `log_enabled!` macro.

## [0.4.5] - 2018-09-03

### Improved

* Make `log`'s internal helper macros less likely to conflict with user-defined
  macros.

## [0.4.4] - 2018-08-17

### Improved

* Support 2018-style imports of the log macros.

## [0.4.3] - 2018-06-29

### Improved

* More code generation improvements.

## [0.4.2] - 2018-06-05

### Improved

* Log invocations now generate less code.

### Fixed

* Example Logger implementations now properly set the max log level.

## [0.4.1] - 2017-12-30

### Fixed

* Some doc links were fixed.

## [0.4.0] - 2017-12-24

The changes in this release include cleanup of some obscure functionality and a more robust public
API designed to support bridges to other logging systems, and provide more flexibility to new
features in the future.

### Compatibility

Vast portions of the Rust ecosystem use the 0.3.x release series of log, and we don't want to force
the community to go through the pain of upgrading every crate to 0.4.x at the exact same time. Along
with 0.4.0, we've published a new 0.3.9 release which acts as a "shim" over 0.4.0. This will allow
crates using either version to coexist without losing messages from one side or the other.

There is one caveat - a log message generated by a crate using 0.4.x but consumed by a logging
implementation using 0.3.x will not have a file name or module path. Applications affected by this
can upgrade their logging implementations to one using 0.4.x to avoid losing this information. The
other direction does not lose any information, fortunately!

**TL;DR** Libraries should feel comfortable upgrading to 0.4.0 without treating that as a breaking
change. Applications may need to update their logging implementation (e.g. env-logger) to a newer
version using log 0.4.x to avoid losing module and file information.

### New

* The crate is now `no_std` by default.
* `Level` and `LevelFilter` now implement `Serialize` and `Deserialize` when the `serde` feature is
    enabled.
* The `Record` and `Metadata` types can now be constructed by third-party code via a builder API.
* The `logger` free function returns a reference to the logger implementation. This, along with the
    ability to construct `Record`s, makes it possible to bridge from another logging framework to
    this one without digging into the private internals of the crate. The standard `error!` `warn!`,
    etc, macros now exclusively use the public API of the crate rather than "secret" internal APIs.
* `Log::flush` has been added to allow crates to tell the logging implementation to ensure that all
    "in flight" log events have been persisted. This can be used, for example, just before an
    application exits to ensure that asynchronous log sinks finish their work.

### Removed

* The `shutdown` and `shutdown_raw` functions have been removed. Supporting shutdown significantly
    complicated the implementation and imposed a performance cost on each logging operation.
* The `log_panics` function and its associated `nightly` Cargo feature have been removed. Use the
    [log-panics](https://crates.io/crates/log-panics) instead.

### Changed

* The `Log` prefix has been removed from type names. For example, `LogLevelFilter` is now
    `LevelFilter`, and `LogRecord` is now `Record`.
* The `MaxLogLevelFilter` object has been removed in favor of a `set_max_level` free function.
* The `set_logger` free functions have been restructured. The logger is now directly passed to the
    functions rather than a closure which returns the logger. `set_logger` now takes a `&'static
    Log` and is usable in `no_std` contexts in place of the old `set_logger_raw`. `set_boxed_logger`
    is a convenience function which takes a `Box<Log>` but otherwise acts like `set_logger`. It
    requires the `std` feature.
* The `file` and `module_path` values in `Record` no longer have the `'static` lifetime to support
    integration with other logging frameworks that don't provide a `'static` lifetime for the
    equivalent values.
* The `file`, `line`, and `module_path` values in `Record` are now `Option`s to support integration
    with other logging frameworks that don't provide those values.

### In the Future

* We're looking to add support for *structured* logging - the inclusion of extra key-value pairs of
    information in a log event in addition to the normal string message. This should be able to be
    added in a backwards compatible manner to the 0.4.x series when the design is worked out.

## Older

Look at the [release tags] for information about older releases.

[Unreleased]: https://github.com/rust-lang-nursery/log/compare/0.4.6...HEAD
[0.4.6]: https://github.com/rust-lang-nursery/log/compare/0.4.5...0.4.6
[0.4.5]: https://github.com/rust-lang-nursery/log/compare/0.4.4...0.4.5
[0.4.4]: https://github.com/rust-lang-nursery/log/compare/0.4.3...0.4.4
[0.4.3]: https://github.com/rust-lang-nursery/log/compare/0.4.2...0.4.3
[0.4.2]: https://github.com/rust-lang-nursery/log/compare/0.4.1...0.4.2
[0.4.1]: https://github.com/rust-lang-nursery/log/compare/0.4.0...0.4.1
[0.4.0]: https://github.com/rust-lang-nursery/log/compare/0.3.8...0.4.0
[release tags]: https://github.com/rust-lang-nursery/log/releases
