/* 
 
Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package rene.zirkel.tools;

// file: Hider.java
import java.awt.event.MouseEvent;
import java.util.Vector;

import rene.gui.Global;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;

public class EditTool extends ObjectConstructor {

	boolean Other;
	Vector V;

	public void mousePressed(final MouseEvent e, ConstructionObject o,
			final ZirkelCanvas zc) {
		zc.y(e.getY());
		Other = (e.isShiftDown() && o == null);
		if (o == null) {
			o = zc.selectObject(e.getX(), e.getY());
			if (o == null) {
				return;
			}
		}
		if (o.isKeep()) {
			return;
		}
		if (Other) {
			if (V == null) {
				V = new Vector();
			}
			V.addElement(o);
			o.setSelected(true);
			zc.repaint();
			return;
		}
		if (V != null) {
			V.addElement(o);
			o.setSelected(true);
			zc.clearSelected();
                                eric.bar.JPropertiesBar.EditObject(o, true, false);
		} else {
			final String oldname = o.getName();
			eric.bar.JPropertiesBar.EditObject(o, true, false);
			if (!oldname.equals(o.getName())) {
				zc.updateTexts(o, oldname);
			}
		}
		V = null;
		Other = false;
		zc.validate();
		zc.repaint();
	}

	@Override
	public void mouseMoved(final MouseEvent e, final ZirkelCanvas zc,
			final boolean simple) {
		zc.indicateObjects(e.getX(), e.getY(), true);
	}

	@Override
	public void mousePressed(final MouseEvent e, final ZirkelCanvas zc) {
		mousePressed(e, null, zc);
	}

	@Override
	public void showStatus(final ZirkelCanvas zc) {
		zc.showStatus(Global.name("message.edit"));
	}

	@Override
	public void reset(final ZirkelCanvas zc) {
		zc.clearSelected();
		V = null;
		Other = false;
	}
}
