/*
 * pic18f4450.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F4450_H__
#define __PIC18F4450_H__ 1



// Configuration Bits
#define	__CONFIG1L          	0x300000
#define	__CONFIG1H          	0x300001
#define	__CONFIG2L          	0x300002
#define	__CONFIG2H          	0x300003
#define	__CONFIG3H          	0x300005
#define	__CONFIG4L          	0x300006
#define	__CONFIG5L          	0x300008
#define	__CONFIG5H          	0x300009
#define	__CONFIG6L          	0x30000A
#define	__CONFIG6H          	0x30000B
#define	__CONFIG7L          	0x30000C
#define	__CONFIG7H          	0x30000D

// CONFIG1L Options
#define	_PLLDIV_1_1L        	0xF8	 // No divide (4 MHz input)
#define	_PLLDIV_2_1L        	0xF9	 // Divide by 2 (8 MHz input)
#define	_PLLDIV_3_1L        	0xFA	 // Divide by 3 (12 MHz input)
#define	_PLLDIV_4_1L        	0xFB	 // Divide by 4 (16 MHz input)
#define	_PLLDIV_5_1L        	0xFC	 // Divide by 5 (20 MHz input)
#define	_PLLDIV_6_1L        	0xFD	 // Divide by 6 (24 MHz input)
#define	_PLLDIV_10_1L       	0xFE	 // Divide by 10 (40 MHz input)
#define	_PLLDIV_12_1L       	0xFF	 // Divide by 12 (48 MHz input)
#define	_CPUDIV_OSC1_PLL2_1L	0xE7	 // [OSC1/OSC2 Src: /1][96 MHz PLL Src: /2]
#define	_CPUDIV_OSC2_PLL3_1L	0xEF	 // [OSC1/OSC2 Src: /2][96 MHz PLL Src: /3]
#define	_CPUDIV_OSC3_PLL4_1L	0xF7	 // [OSC1/OSC2 Src: /3][96 MHz PLL Src: /4]
#define	_CPUDIV_OSC4_PLL6_1L	0xFF	 // [OSC1/OSC2 Src: /4][96 MHz PLL Src: /6]
#define	_USBDIV_1_1L        	0xDF	 // Clock source from OSC1/OSC2
#define	_USBDIV_2_1L        	0xFF	 // Clock source from 96 MHz PLL/2

// CONFIG1H Options
#define	_FOSC_XT_XT_1H      	0xF0	 // XT oscillator, XT used by USB
#define	_FOSC_XTPLL_XT_1H   	0xF2	 // XT oscillator, PLL enabled, XT used by USB
#define	_FOSC_ECIO_EC_1H    	0xF4	 // External clock, port function on RA6, EC used by USB
#define	_FOSC_EC_EC_1H      	0xF5	 // External clock, CLKOUT on RA6, EC used by USB
#define	_FOSC_ECPLLIO_EC_1H 	0xF6	 // External clock, PLL enabled, port function on RA6, EC used by USB
#define	_FOSC_ECPLL_EC_1H   	0xF7	 // External clock, PLL enabled, CLKOUT on RA6, EC used by USB
#define	_FOSC_INTOSCIO_EC_1H	0xF8	 // Internal oscillator, port function on RA6, EC used by USB
#define	_FOSC_INTOSC_EC_1H  	0xF9	 // Internal oscillator, CLKOUT on RA6, EC used by USB
#define	_FOSC_INTOSC_XT_1H  	0xFA	 // Internal oscillator, XT used by USB
#define	_FOSC_INTOSC_HS_1H  	0xFB	 // Internal oscillator, HS used by USB
#define	_FOSC_HS_1H         	0xFC	 // HS oscillator, HS used by USB
#define	_FOSC_HSPLL_HS_1H   	0xFE	 // HS oscillator, PLL enabled, HS used by USB
#define	_FCMEM_OFF_1H       	0xBF	 // Disabled
#define	_FCMEM_ON_1H        	0xFF	 // Enabled
#define	_IESO_OFF_1H        	0x7F	 // Disabled
#define	_IESO_ON_1H         	0xFF	 // Enabled

// CONFIG2L Options
#define	_PWRT_ON_2L         	0xFE	 // Enabled
#define	_PWRT_OFF_2L        	0xFF	 // Disabled
#define	_BOR_OFF_2L         	0xF9	 // Disabled
#define	_BOR_SOFT_2L        	0xFB	 // Controlled by SBOREN
#define	_BOR_ON_ACTIVE_2L   	0xFD	 // Enabled when the device is not in Sleep, SBOREN bit is disabled
#define	_BOR_ON_2L          	0xFF	 // Enabled, SBOREN bit is disabled
#define	_BORV_46_2L         	0xE7	 // 4.6V
#define	_BORV_43_2L         	0xEF	 // 4.3V
#define	_BORV_28_2L         	0xF7	 // 2.8V
#define	_BORV_21_2L         	0xFF	 // 2.1V
#define	_VREGEN_OFF_2L      	0xDF	 // Disabled
#define	_VREGEN_ON_2L       	0xFF	 // Enabled

// CONFIG2H Options
#define	_WDT_OFF_2H         	0xFE	 // HW Disabled - SW Controlled
#define	_WDT_ON_2H          	0xFF	 // HW Enabled - SW Disabled
#define	_WDTPS_1_2H         	0xE1	 // 1:1
#define	_WDTPS_2_2H         	0xE3	 // 1:2
#define	_WDTPS_4_2H         	0xE5	 // 1:4
#define	_WDTPS_8_2H         	0xE7	 // 1:8
#define	_WDTPS_16_2H        	0xE9	 // 1:16
#define	_WDTPS_32_2H        	0xEB	 // 1:32
#define	_WDTPS_64_2H        	0xED	 // 1:64
#define	_WDTPS_128_2H       	0xEF	 // 1:128
#define	_WDTPS_256_2H       	0xF1	 // 1:256
#define	_WDTPS_512_2H       	0xF3	 // 1:512
#define	_WDTPS_1024_2H      	0xF5	 // 1:1024
#define	_WDTPS_2048_2H      	0xF7	 // 1:2048
#define	_WDTPS_4096_2H      	0xF9	 // 1:4096
#define	_WDTPS_8192_2H      	0xFB	 // 1:8192
#define	_WDTPS_16384_2H     	0xFD	 // 1:16384
#define	_WDTPS_32768_2H     	0xFF	 // 1:32768

// CONFIG3H Options
#define	_MCLRE_OFF_3H       	0x7F	 // Disabled
#define	_MCLRE_ON_3H        	0xFF	 // Enabled
#define	_LPT1OSC_OFF_3H     	0xFB	 // Timer1 oscillator configured for high power
#define	_LPT1OSC_ON_3H      	0xFF	 // Timer1 oscillator configured for low power
#define	_PBADEN_OFF_3H      	0xFD	 // PORTB<4:0> pins are configured as digital I/O on Reset
#define	_PBADEN_ON_3H       	0xFF	 // PORTB<4:0> pins are configured as analog input on Reset

// CONFIG4L Options
#define	_STVREN_OFF_4L      	0xFE	 // Disabled
#define	_STVREN_ON_4L       	0xFF	 // Enabled
#define	_LVP_OFF_4L         	0xFB	 // Disabled
#define	_LVP_ON_4L          	0xFF	 // Enabled
#define	_BBSIZ_BB2K_4L      	0xF7	 // 2KW Boot Block Size
#define	_BBSIZ_BB1K_4L      	0xFF	 // 1KW Boot Block Size
#define	_ICPRT_OFF_4L       	0xDF	 // Disabled
#define	_ICPRT_ON_4L        	0xFF	 // Enabled
#define	_XINST_OFF_4L       	0xBF	 // Disabled
#define	_XINST_ON_4L        	0xFF	 // Enabled
#define	_DEBUG_ON_4L        	0x7F	 // Enabled
#define	_DEBUG_OFF_4L       	0xFF	 // Disabled

// CONFIG5L Options
#define	_CP0_ON_5L          	0xFE	 // Enabled
#define	_CP0_OFF_5L         	0xFF	 // Disabled
#define	_CP1_ON_5L          	0xFD	 // Enabled
#define	_CP1_OFF_5L         	0xFF	 // Disabled

// CONFIG5H Options
#define	_CPB_ON_5H          	0xBF	 // Enabled
#define	_CPB_OFF_5H         	0xFF	 // Disabled

// CONFIG6L Options
#define	_WRT0_ON_6L         	0xFE	 // Enabled
#define	_WRT0_OFF_6L        	0xFF	 // Disabled
#define	_WRT1_ON_6L         	0xFD	 // Enabled
#define	_WRT1_OFF_6L        	0xFF	 // Disabled

// CONFIG6H Options
#define	_WRTB_ON_6H         	0xBF	 // Enabled
#define	_WRTB_OFF_6H        	0xFF	 // Disabled
#define	_WRTC_ON_6H         	0xDF	 // Enabled
#define	_WRTC_OFF_6H        	0xFF	 // Disabled

// CONFIG7L Options
#define	_EBTR0_ON_7L        	0xFE	 // Enabled
#define	_EBTR0_OFF_7L       	0xFF	 // Disabled
#define	_EBTR1_ON_7L        	0xFD	 // Enabled
#define	_EBTR1_OFF_7L       	0xFF	 // Disabled

// CONFIG7H Options
#define	_EBTRB_ON_7H        	0xBF	 // Enabled
#define	_EBTRB_OFF_7H       	0xFF	 // Disabled
#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF
#define	_IDLOC0             	0x200000
#define	_IDLOC1             	0x200001
#define	_IDLOC2             	0x200002
#define	_IDLOC3             	0x200003
#define	_IDLOC4             	0x200004
#define	_IDLOC5             	0x200005
#define	_IDLOC6             	0x200006
#define	_IDLOC7             	0x200007

extern __sfr __at (0xF66) UFRM;

extern __sfr __at (0xF66) UFRML;

extern __sfr __at (0xF67) UFRMH;

extern __sfr __at (0xF68) UIR;
typedef union {
	struct {
		unsigned URSTIF    	: 1;
		unsigned UERRIF    	: 1;
		unsigned ACTVIF    	: 1;
		unsigned TRNIF     	: 1;
		unsigned IDLEIF    	: 1;
		unsigned STALLIF   	: 1;
		unsigned SOFIF     	: 1;
		unsigned           	: 1;
	};
} __UIRbits_t;
extern volatile __UIRbits_t __at (0xF68) UIRbits;

extern __sfr __at (0xF69) UIE;
typedef union {
	struct {
		unsigned URSTIE    	: 1;
		unsigned UERRIE    	: 1;
		unsigned ACTVIE    	: 1;
		unsigned TRNIE     	: 1;
		unsigned IDLEIE    	: 1;
		unsigned STALLIE   	: 1;
		unsigned SOFIE     	: 1;
		unsigned           	: 1;
	};
} __UIEbits_t;
extern volatile __UIEbits_t __at (0xF69) UIEbits;

extern __sfr __at (0xF6A) UEIR;
typedef union {
	struct {
		unsigned PIDEF     	: 1;
		unsigned CRC5EF    	: 1;
		unsigned CRC16EF   	: 1;
		unsigned DFN8EF    	: 1;
		unsigned BTOEF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEF     	: 1;
	};
} __UEIRbits_t;
extern volatile __UEIRbits_t __at (0xF6A) UEIRbits;

extern __sfr __at (0xF6B) UEIE;
typedef union {
	struct {
		unsigned PIDEE     	: 1;
		unsigned CRC5EE    	: 1;
		unsigned CRC16EE   	: 1;
		unsigned DFN8EE    	: 1;
		unsigned BTOEE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEE     	: 1;
	};
} __UEIEbits_t;
extern volatile __UEIEbits_t __at (0xF6B) UEIEbits;

extern __sfr __at (0xF6C) USTAT;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned PPBI      	: 1;
		unsigned DIR       	: 1;
		unsigned ENDP0     	: 1;
		unsigned ENDP1     	: 1;
		unsigned ENDP2     	: 1;
		unsigned ENDP3     	: 1;
		unsigned           	: 1;
	};
} __USTATbits_t;
extern volatile __USTATbits_t __at (0xF6C) USTATbits;

extern __sfr __at (0xF6D) UCON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned SUSPND    	: 1;
		unsigned RESUME    	: 1;
		unsigned USBEN     	: 1;
		unsigned PKTDIS    	: 1;
		unsigned SE0       	: 1;
		unsigned PPBRST    	: 1;
		unsigned           	: 1;
	};
} __UCONbits_t;
extern volatile __UCONbits_t __at (0xF6D) UCONbits;

extern __sfr __at (0xF6E) UADDR;
typedef union {
	struct {
		unsigned ADDR0     	: 1;
		unsigned ADDR1     	: 1;
		unsigned ADDR2     	: 1;
		unsigned ADDR3     	: 1;
		unsigned ADDR4     	: 1;
		unsigned ADDR5     	: 1;
		unsigned ADDR6     	: 1;
		unsigned           	: 1;
	};
} __UADDRbits_t;
extern volatile __UADDRbits_t __at (0xF6E) UADDRbits;

extern __sfr __at (0xF6F) UCFG;
typedef union {
	struct {
		unsigned PPB0      	: 1;
		unsigned PPB1      	: 1;
		unsigned FSEN      	: 1;
		unsigned UTRDIS    	: 1;
		unsigned UPUEN     	: 1;
		unsigned           	: 1;
		unsigned UOEMON    	: 1;
		unsigned UTEYE     	: 1;
	};
} __UCFGbits_t;
extern volatile __UCFGbits_t __at (0xF6F) UCFGbits;

extern __sfr __at (0xF70) UEP0;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP0bits_t;
extern volatile __UEP0bits_t __at (0xF70) UEP0bits;

extern __sfr __at (0xF71) UEP1;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP1bits_t;
extern volatile __UEP1bits_t __at (0xF71) UEP1bits;

extern __sfr __at (0xF72) UEP2;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP2bits_t;
extern volatile __UEP2bits_t __at (0xF72) UEP2bits;

extern __sfr __at (0xF73) UEP3;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP3bits_t;
extern volatile __UEP3bits_t __at (0xF73) UEP3bits;

extern __sfr __at (0xF74) UEP4;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP4bits_t;
extern volatile __UEP4bits_t __at (0xF74) UEP4bits;

extern __sfr __at (0xF75) UEP5;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP5bits_t;
extern volatile __UEP5bits_t __at (0xF75) UEP5bits;

extern __sfr __at (0xF76) UEP6;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP6bits_t;
extern volatile __UEP6bits_t __at (0xF76) UEP6bits;

extern __sfr __at (0xF77) UEP7;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP7bits_t;
extern volatile __UEP7bits_t __at (0xF77) UEP7bits;

extern __sfr __at (0xF78) UEP8;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP8bits_t;
extern volatile __UEP8bits_t __at (0xF78) UEP8bits;

extern __sfr __at (0xF79) UEP9;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP9bits_t;
extern volatile __UEP9bits_t __at (0xF79) UEP9bits;

extern __sfr __at (0xF7A) UEP10;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP10bits_t;
extern volatile __UEP10bits_t __at (0xF7A) UEP10bits;

extern __sfr __at (0xF7B) UEP11;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP11bits_t;
extern volatile __UEP11bits_t __at (0xF7B) UEP11bits;

extern __sfr __at (0xF7C) UEP12;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP12bits_t;
extern volatile __UEP12bits_t __at (0xF7C) UEP12bits;

extern __sfr __at (0xF7D) UEP13;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP13bits_t;
extern volatile __UEP13bits_t __at (0xF7D) UEP13bits;

extern __sfr __at (0xF7E) UEP14;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP14bits_t;
extern volatile __UEP14bits_t __at (0xF7E) UEP14bits;

extern __sfr __at (0xF7F) UEP15;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP15bits_t;
extern volatile __UEP15bits_t __at (0xF7F) UEP15bits;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned AN0       	: 1;
		unsigned AN1       	: 1;
		unsigned AN2       	: 1;
		unsigned AN3       	: 1;
		unsigned T0CKI     	: 1;
		unsigned AN4       	: 1;
		unsigned OSC2      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned VREFM     	: 1;
		unsigned VREFP     	: 1;
		unsigned RCV       	: 1;
		unsigned LVDIN     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
	struct {
		unsigned INT0      	: 1;
		unsigned INT1      	: 1;
		unsigned INT2      	: 1;
		unsigned AN9       	: 1;
		unsigned AN11      	: 1;
		unsigned PGM       	: 1;
		unsigned PGC       	: 1;
		unsigned PGD       	: 1;
	};
	struct {
		unsigned AN12      	: 1;
		unsigned AN10      	: 1;
		unsigned AN8       	: 1;
		unsigned VPO       	: 1;
		unsigned KBI0      	: 1;
		unsigned KBI1      	: 1;
		unsigned KBI2      	: 1;
		unsigned KBI3      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned VMO       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned           	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned T1OSO     	: 1;
		unsigned T1OSI     	: 1;
		unsigned CCP1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX        	: 1;
		unsigned RX        	: 1;
	};
	struct {
		unsigned T1CKI     	: 1;
		unsigned NOT_UOE   	: 1;
		unsigned P1A       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CK        	: 1;
		unsigned DT        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned UOE       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;

extern __sfr __at (0xF83) PORTD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
} __PORTDbits_t;
extern volatile __PORTDbits_t __at (0xF83) PORTDbits;

extern __sfr __at (0xF84) PORTE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned RE3       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned AN5       	: 1;
		unsigned AN6       	: 1;
		unsigned AN7       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTEbits_t;
extern volatile __PORTEbits_t __at (0xF84) PORTEbits;

extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned LATA0     	: 1;
		unsigned LATA1     	: 1;
		unsigned LATA2     	: 1;
		unsigned LATA3     	: 1;
		unsigned LATA4     	: 1;
		unsigned LATA5     	: 1;
		unsigned LATA6     	: 1;
		unsigned           	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned LATB0     	: 1;
		unsigned LATB1     	: 1;
		unsigned LATB2     	: 1;
		unsigned LATB3     	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF8C) LATD;
typedef union {
	struct {
		unsigned LATD0     	: 1;
		unsigned LATD1     	: 1;
		unsigned LATD2     	: 1;
		unsigned LATD3     	: 1;
		unsigned LATD4     	: 1;
		unsigned LATD5     	: 1;
		unsigned LATD6     	: 1;
		unsigned LATD7     	: 1;
	};
} __LATDbits_t;
extern volatile __LATDbits_t __at (0xF8C) LATDbits;

extern __sfr __at (0xF8D) LATE;
typedef union {
	struct {
		unsigned LATE0     	: 1;
		unsigned LATE1     	: 1;
		unsigned LATE2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATEbits_t;
extern volatile __LATEbits_t __at (0xF8D) LATEbits;

extern __sfr __at (0xF92) DDRA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned           	: 1;
	};
} __DDRAbits_t;
extern volatile __DDRAbits_t __at (0xF92) DDRAbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned TRISA0    	: 1;
		unsigned TRISA1    	: 1;
		unsigned TRISA2    	: 1;
		unsigned TRISA3    	: 1;
		unsigned TRISA4    	: 1;
		unsigned TRISA5    	: 1;
		unsigned TRISA6    	: 1;
		unsigned           	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) DDRB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __DDRBbits_t;
extern volatile __DDRBbits_t __at (0xF93) DDRBbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned TRISB0    	: 1;
		unsigned TRISB1    	: 1;
		unsigned TRISB2    	: 1;
		unsigned TRISB3    	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) DDRC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
} __DDRCbits_t;
extern volatile __DDRCbits_t __at (0xF94) DDRCbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF95) DDRD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
} __DDRDbits_t;
extern volatile __DDRDbits_t __at (0xF95) DDRDbits;

extern __sfr __at (0xF95) TRISD;
typedef union {
	struct {
		unsigned TRISD0    	: 1;
		unsigned TRISD1    	: 1;
		unsigned TRISD2    	: 1;
		unsigned TRISD3    	: 1;
		unsigned TRISD4    	: 1;
		unsigned TRISD5    	: 1;
		unsigned TRISD6    	: 1;
		unsigned TRISD7    	: 1;
	};
} __TRISDbits_t;
extern volatile __TRISDbits_t __at (0xF95) TRISDbits;

extern __sfr __at (0xF96) DDRE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDREbits_t;
extern volatile __DDREbits_t __at (0xF96) DDREbits;

extern __sfr __at (0xF96) TRISE;
typedef union {
	struct {
		unsigned TRISE0    	: 1;
		unsigned TRISE1    	: 1;
		unsigned TRISE2    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISEbits_t;
extern volatile __TRISEbits_t __at (0xF96) TRISEbits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned           	: 1;
		unsigned TXIE      	: 1;
		unsigned RCIE      	: 1;
		unsigned ADIE      	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned           	: 1;
		unsigned TXIF      	: 1;
		unsigned RCIF      	: 1;
		unsigned ADIF      	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned           	: 1;
		unsigned TXIP      	: 1;
		unsigned RCIP      	: 1;
		unsigned ADIP      	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LVDIE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned USBIE     	: 1;
		unsigned           	: 1;
		unsigned OSCFIE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LVDIF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned USBIF     	: 1;
		unsigned           	: 1;
		unsigned OSCFIF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIF    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LVDIP     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned USBIP     	: 1;
		unsigned           	: 1;
		unsigned OSCFIP    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned           	: 1;
		unsigned CFGS      	: 1;
		unsigned           	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFAB) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ADEN      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAB) RCSTAbits;

extern __sfr __at (0xFAC) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAC) TXSTAbits;

extern __sfr __at (0xFAD) TXREG;

extern __sfr __at (0xFAE) RCREG;

extern __sfr __at (0xFAF) SPBRG;

extern __sfr __at (0xFB0) SPBRGH;

extern __sfr __at (0xFB8) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RCMT      	: 1;
		unsigned           	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xFB8) BAUDCONbits;

extern __sfr __at (0xFBD) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBD) CCP1CONbits;

extern __sfr __at (0xFBE) CCPR1;

extern __sfr __at (0xFBE) CCPR1L;

extern __sfr __at (0xFBF) CCPR1H;

extern __sfr __at (0xFC0) ADCON2;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned           	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON2bits_t;
extern volatile __ADCON2bits_t __at (0xFC0) ADCON2bits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned PCFG0     	: 1;
		unsigned PCFG1     	: 1;
		unsigned PCFG2     	: 1;
		unsigned PCFG3     	: 1;
		unsigned VCFG0     	: 1;
		unsigned VCFG1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned GO_DONE   	: 1;
		unsigned CHS0      	: 1;
		unsigned CHS1      	: 1;
		unsigned CHS2      	: 1;
		unsigned CHS3      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned DONE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned TMR1CS    	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned T1RUN     	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T1SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned           	: 1;
		unsigned SBOREN    	: 1;
		unsigned NOT_IPEN  	: 1;
	};
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IPEN      	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) WDTCON;
typedef union {
	struct {
		unsigned SWDTEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned SWDTE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFD1) WDTCONbits;

extern __sfr __at (0xFD2) HLVDCON;
typedef union {
	struct {
		unsigned LVDL0     	: 1;
		unsigned LVDL1     	: 1;
		unsigned LVDL2     	: 1;
		unsigned LVDL3     	: 1;
		unsigned LVDEN     	: 1;
		unsigned IRVST     	: 1;
		unsigned           	: 1;
		unsigned VDIRMAG   	: 1;
	};
	struct {
		unsigned LVV0      	: 1;
		unsigned LVV1      	: 1;
		unsigned LVV2      	: 1;
		unsigned LVV3      	: 1;
		unsigned HLVDEN    	: 1;
		unsigned BGST      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned HLVDL0    	: 1;
		unsigned HLVDL1    	: 1;
		unsigned HLVDL2    	: 1;
		unsigned HLVDL3    	: 1;
		unsigned           	: 1;
		unsigned IVRST     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __HLVDCONbits_t;
extern volatile __HLVDCONbits_t __at (0xFD2) HLVDCONbits;

extern __sfr __at (0xFD2) LVDCON;
typedef union {
	struct {
		unsigned LVDL0     	: 1;
		unsigned LVDL1     	: 1;
		unsigned LVDL2     	: 1;
		unsigned LVDL3     	: 1;
		unsigned LVDEN     	: 1;
		unsigned IRVST     	: 1;
		unsigned           	: 1;
		unsigned VDIRMAG   	: 1;
	};
	struct {
		unsigned LVV0      	: 1;
		unsigned LVV1      	: 1;
		unsigned LVV2      	: 1;
		unsigned LVV3      	: 1;
		unsigned HLVDEN    	: 1;
		unsigned BGST      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned HLVDL0    	: 1;
		unsigned HLVDL1    	: 1;
		unsigned HLVDL2    	: 1;
		unsigned HLVDL3    	: 1;
		unsigned           	: 1;
		unsigned IVRST     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LVDCONbits_t;
extern volatile __LVDCONbits_t __at (0xFD2) LVDCONbits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned           	: 1;
		unsigned OSTS      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IDLEN     	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T08BIT    	: 1;
		unsigned TMR0ON    	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned           	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned           	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned           	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned           	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RBIP      	: 1;
		unsigned           	: 1;
		unsigned TMR0IP    	: 1;
		unsigned           	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned NOT_RBPU  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T0IP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RBPU      	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RBIF      	: 1;
		unsigned INT0IF    	: 1;
		unsigned TMR0IF    	: 1;
		unsigned RBIE      	: 1;
		unsigned INT0IE    	: 1;
		unsigned TMR0IE    	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0F     	: 1;
		unsigned T0IF      	: 1;
		unsigned           	: 1;
		unsigned INT0E     	: 1;
		unsigned T0IE      	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned STKPTR0   	: 1;
		unsigned STKPTR1   	: 1;
		unsigned STKPTR2   	: 1;
		unsigned STKPTR3   	: 1;
		unsigned STKPTR4   	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKFUL    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned STKOVF    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

