/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: ArrayView.H,v 1.3 2000/10/02 20:53:07 lijewski Exp $
//

// ---------------------------------------------------------------
// ArrayView.H
// ---------------------------------------------------------------
#ifndef _ARRAYVIEW_H_
#define _ARRAYVIEW_H_

#include "FArrayBox.H"
#include "MultiFab.H"
#ifdef BL_ARRAYVIEW_TAGBOX
#include "TagBox.H"
#endif
#include "DatasetClient.H"

// -------------------------------------------------------------
void NeverCalled() {
  ArrayView(NULL);
  ArrayViewFab(NULL);
  ArrayViewFabFormatLabel(NULL, "%7.5f", "FabLabel");

  ArrayViewMultiFabElement(NULL, 0);
  ArrayViewMultiFabElementFormatLabel(NULL, 0, "%7.5f", "MultiFabLabel");

  ArrayViewMultiFab(NULL);
  ArrayViewMultiFabFormatLabel(NULL, "%7.5f", "MultiFabLabel");

  ArrayViewReal(NULL, NULL, NULL);
  ArrayViewRealFormatLabel(NULL, NULL, NULL, "%7.5f", "RealLabel");

  ArrayViewRealNVar(NULL, 0, NULL, NULL);
  ArrayViewRealNVarFormatLabel(NULL, 0, NULL, NULL, "%7.5f", "RealLabel");

#if (BL_SPACEDIM == 2)
  ArrayViewRealDims(NULL, 0, 0, 1, 1);
  ArrayViewRealDimsFormatLabel(NULL, 0, 0, 1, 1, "%7.5f", "RealLabel");

  ArrayViewRealNVarDims(NULL, 1, 0, 0, 1, 1);
  ArrayViewRealNVarDimsFormatLabel(NULL, 1, 0, 0, 1, 1, "%7.5f", "RealLabel");
#else
  ArrayViewRealDims(NULL, 0, 0, 0, 1, 1, 1);
  ArrayViewRealDimsFormatLabel(NULL, 0, 0, 0, 1, 1, 1, "%7.5f", "RealLabel");
  ArrayViewRealNVarDims(NULL, 1, 0, 0, 0, 1, 1, 1);
  ArrayViewRealNVarDimsFormatLabel(NULL, 1, 0, 0, 0, 1, 1, 1, "%7.5f", "RealLabel");
#endif

  ArrayViewRealPtrArrayNVarDims(NULL, 1, NULL, NULL, "%7.5f", "RealLabel");

#ifdef BL_ARRAYVIEW_TAGBOX
  ArrayViewTagBox(NULL);
  ArrayViewTagBoxArray(NULL);
#endif

}
// -------------------------------------------------------------
// -------------------------------------------------------------
#endif
