/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#  define FORT_RHSHG       rhshg
#  define FORT_ADJUSTRHS   adjustrhs
#  define FORT_RESIDUAL    reshg
#  define FORT_RELAX       relax
#  define FORT_GRADHG      gradhg
#  define FORT_COARSIG     coarsigb
#  define FORT_RESTRICT    coarsresb
#  define FORT_INTERP      interphg
#  define FORT_PROJUHG     projuhg
#  define FORT_PROJHGD     projhgd
#  define FORT_SOLVEHG     solvehg
#  define FORT_MAKESUM     makesum
#  define FORT_MKCOEFF     mkcoeff
#else
#if defined(BL_FORT_USE_UNDERSCORE)
#  define FORT_RHSHG       rhshg_
#  define FORT_ADJUSTRHS   adjustrhs_
#  define FORT_RESIDUAL    reshg_
#  define FORT_RELAX       relax_
#  define FORT_GRADHG      gradhg_
#  define FORT_COARSIG     coarsigb_
#  define FORT_RESTRICT    coarsresb_
#  define FORT_INTERP      interphg_
#  define FORT_PROJUHG     projuhg_
#  define FORT_PROJHGD     projhgd_
#  define FORT_SOLVEHG     solvehg_
#  define FORT_MAKESUM     makesum_
#  define FORT_MKCOEFF     mkcoeff_
#elif defined(BL_FORT_USE_UPPERCASE)
#  define FORT_RHSHG       RHSHG
#  define FORT_ADJUSTRHS   ADJUSTRHS
#  define FORT_RESIDUAL    RESHG
#  define FORT_RELAX       RELAX
#  define FORT_GRADHG      GRADHG
#  define FORT_COARSIG     COARSIGB
#  define FORT_RESTRICT    COARSRESB
#  define FORT_INTERP      INTERPHG
#  define FORT_PROJUHG     PROJUHG
#  define FORT_PROJHGD     PROJHGD
#  define FORT_SOLVEHG     SOLVEHG
#  define FORT_MAKESUM     MAKESUM
#  define FORT_MKCOEFF     MKCOEFF
#elif defined(BL_FORT_USE_LOWERCASE)
#  define FORT_RHSHG       rhshg
#  define FORT_ADJUSTRHS   adjustrhs
#  define FORT_RESIDUAL    reshg
#  define FORT_RELAX       relax
#  define FORT_GRADHG      gradhg
#  define FORT_COARSIG     coarsigb
#  define FORT_RESTRICT    coarsresb
#  define FORT_INTERP      interphg
#  define FORT_PROJUHG     projuhg
#  define FORT_PROJHGD     projhgd
#  define FORT_SOLVEHG     solvehg
#  define FORT_MAKESUM     makesum
#  define FORT_MKCOEFF     mkcoeff
#endif

#include <ArrayLim.H>

extern "C" {

  void FORT_RHSHG(Real* source, Real* state, Real* divu_src,
                  const Real* volume, 
                  ARLIM_P(lo), ARLIM_P(hi),
                  const Real* dx, int* bc,
                  Real* rhsnorm, int* ng,
                  int* is_singular, Real* ss, Real* sf);

  void FORT_ADJUSTRHS(Real* source, 
                      ARLIM_P(lo), ARLIM_P(hi),
                      int* bc, int* ng, Real* sum_src);

  void FORT_GRADHG(Real* gradp, 
                   ARLIM_P(glo), ARLIM_P(ghi),
                   Real* pressure, 
                   ARLIM_P(plo), ARLIM_P(phi),
                   ARLIM_P( lo), ARLIM_P( hi),
                   const Real* dx);

  void FORT_RESIDUAL(Real* resid, Real* phi, Real* source, 
                     Real* sigma,  Real* dgphi,
                     ARLIM_P(lo), ARLIM_P(hi),
		     const Real* dx, Real * rnorm, int * bc, int* ng);

  void FORT_RELAX(Real* phi, Real* source, Real* sigma, 
                  Real* dgphi, 
                  ARLIM_P(lo), ARLIM_P(hi),
		  const Real* dx, int* bc, int* nngsrb, int* ng);

  void FORT_RESTRICT(Real* resid, Real* resid_crse, 
                     ARLIM_P(lo), ARLIM_P(hi),
                     ARLIM_P(loc), ARLIM_P(hic),
                     int* bc, int* ng);

  void FORT_COARSIG(Real* sigma, Real* sigmac, 
                    ARLIM_P(lo), ARLIM_P(hi),
                    ARLIM_P(loc), ARLIM_P(hic), int* ng);

  void FORT_INTERP(Real* temp, Real* phi_crse, 
                   ARLIM_P(lo ), ARLIM_P(hi ),
                   ARLIM_P(loc), ARLIM_P(hic), int* ng);

  void FORT_PROJUHG(Real* state, Real* pressure, Real* phi, 
                    Real* gradphi, Real* rho,
                    ARLIM_P(lo), ARLIM_P(hi), int* ng);

  void FORT_SOLVEHG(Real* dest, Real* dest0, Real* source, 
                    Real* sigma,  Real* sum, 
		    Real* r, Real* w, Real* z, Real* work, 
                    ARLIM_P(lo), ARLIM_P(hi),
		    const Real* dx, int* bc, int* maxiter,
                    Real* norm, Real* norm0, int* ng);

#if (BL_SPACEDIM == 3)
  void FORT_MAKESUM(Real*, Real*, 
                    ARLIM_P(lo), ARLIM_P(hi),
		    const Real* dx, int* bc, int* ng);

  void FORT_MKCOEFF(Real* coeff, Real* sigma,
                    ARLIM_P(lo),ARLIM_P(hi), int* ng);
#endif
};
#endif
