

Needs[ "Graphics`Graphics3D`"]

Needs[ "Graphics`Polyhedra`"]

Needs[ "Utilities`FilterOptions`"]

MultipleScatterPlot3D::usage =
        "MultipleScatterPlot3D[ data1, data2, ... , size] will plot the 3D data sets
        using different 3D symbols for each data set.  The size of the"

Options[ MultipleScatterPlot3D] =
        Append[ Options[ ScatterPlot3D], SymbolSize -> Automatic];

objects = {Tetrahedron[], Cube[], Octahedron[], Dodecahedron[], Icosahedron[]} ;

MultipleScatterPlot3D[ input__] :=
    Block[{data, opts, res, size, rng, dfun, nopts, join, fun},
    	opts = {input} //. {x_List, y___} -> {y} ;
	data = {input} //. {{x___, y_Rule} -> {x}, {x___, y_RuleDelayed} -> {x}} ;
        size = SymbolSize /. opts /. Options[ MultipleScatterPlot3D] ;
        join = PlotJoined /. opts /. Options[ MultipleScatterPlot3D] ;
        dfun = DisplayFunction /. opts /. Options[ MultipleScatterPlot3D] ;
	nopts = FilterOptions[ ScatterPlot3D, Sequence @@ opts] ;
        res = Map[ ScatterPlot3D[#, DisplayFunction -> Identity, nopts]&, data] ;
	rng = Map[ Flatten[ FullOptions[ #, PlotRange]]&, res] ;
	rng = Transpose[ rng] ;
	rng = {
		{Min[ rng[[1]]], Max[ rng[[2]]]}, 
		{Min[ rng[[3]]], Max[ rng[[4]]]},
		{Min[ rng[[5]]], Max[ rng[[6]]]}
	       } ;
	If[ size === Automatic,
		size = Min[ Map[ (Last[#] - First[#])&, rng]] ;
		size = size/40.;
		(*rng = Map[ (# + {-size, size})&, rng]*)] ;
	fun = If[ join === True, LineSubstitute, PointSubstitute] ;
        res = Table[ 
	           fun[ Part[ res, i], 
		        Part[ objects, Mod[ i-1, Length[objects]]+1], 
			size], 
                   {i, Length[ res]}] ;
        Show[ res, PlotRange -> rng, DisplayFunction -> dfun]
        ]

PointSubstitute[ obj_Graphics3D, 
		shape_ /; VectorQ[ shape, (Head[#] === Polygon)&], 
		size_:Automatic] :=
    Block[{rng, nsize},
	nsize =
	    If[ !NumberQ[ size],
		rng = FullOptions[ obj, PlotRange] ;
		rng = Min[ Map[ (Last[#] - First[#])&, rng]] ;
		rng/40.,
		size] ;
	obj /. Point[ pt_] :>
	    Map[
		Polygon[ Map[ Function[ {p1}, pt + nsize p1], First[#]]]&,
                shape]
	]

LineSubstitute[ obj_Graphics3D, 
		shape_ /; VectorQ[ shape, (Head[#] === Polygon)&], 
		size_:Automatic] :=
    Block[{rng, nsize},
	nsize =
	    If[ !NumberQ[ size],
		rng = FullOptions[ obj, PlotRange] ;
		rng = Min[ Map[ (Last[#] - First[#])&, rng]] ;
		rng/40.,
		size] ;
	obj /. Line[ pt_] :>
	    {
	    Line[ pt], 
	    Map[ Function[{lpt},  
	    Map[
		Polygon[ Map[ Function[ {p1}, lpt + nsize p1], First[#]]]&,
			shape]], pt]
	    }
    ]

(*

Then try...

d1 = Table[N[{t, 0, Sin[t]}], {t,0,4Pi,1}];

d1 = Table[N[{t, 0, Sin[t]}], {t,0,4Pi,Pi/10}];

MultipleScatterPlot3D[ d1]

MultipleScatterPlot3D[ d1, SymbolSize -> 0.2]
MultipleScatterPlot3D[ d1, SymbolSize -> 0.2]

d2 = Table[N[{t, 3, Sin[t]^2}], {t,0,4Pi,1}];

MultipleScatterPlot3D[ d1, d2]

<</twj/og/part2/chap7/MultipleScatterPlot3D.m

d = Table[ {t, Sin[t], Cos[t]}, {t,0,4Pi,.25}];

p = ScatterPlot3D[ d]

PointSubstitute[ p, Octahedron[]]

Show[%]


*)
