(*:Name: Ticks *)

(* :Title: Ticks *)

(* :Author: Tom Wickham-Jones*)

(* :Summary: *)

(* :Context: ExtendGraphics`NormalDisplay` *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.3 *)

(*:Summary:
	This package provides functions for using the
	Ticks option of graphics objects.  It allows the
	length and style of tick marks and the text labels 
	to be altered.
*)


(* :History:
	Created summer 1992 by Tom Wickham-Jones.
*)

(*:Warnings:
	This package resets $DisplayFunction and only runs in Version 2.3
*)


BeginPackage[ "ExtendGraphics`NormalDisplay`"]


SetOldDisplayFunction::usage =
	"SetOldDisplayFunction[] will restore $DisplayFunction to the value
	prior to the loading of the package ExtendGraphics`NormalDisplay`."
	
SetNormalDisplayFunction::usage =
	"SetNormalDisplayFunction[] will set $DisplayFunction to insert
	normal vectors into polygon primitives when they are rendered."

SetOldLights::usage	=
	"SetOldLights[] will restore the LightSource options of ParametricPlot3D
	and Graphics3D to their values prior to the loading of the package
	ExtendGraphics`NormalDisplay`."
	
SetWhiteLights::usage	=
	"SetWhiteLights[] will set the LightSource options of ParametricPlot3D
	and Graphics3D to use six white lights shining into each face of the
	bounding box."
	
SetColorLights::usage	=
	"SetColorLights[] will set the LightSource options of ParametricPlot3D
	and Graphics3D to use six colored lights shining into each face of the
	bounding box."

NormalDisplayFunction::usage =
	"NormalDisplayFunction is a setting for the DisplayFunction option
	that inserts normals into Polygon primitives."
	
WhiteLights::usage	=
	"WhiteLights are a set of six white light sources shining 
	into each face of the bounding box."
	
ColorLights::usage	=
	"ColorLights are a set of six colored light sources shining 
	into each face of the bounding box."
	

Begin["`Private`"]

oldDisplayFunction = $DisplayFunction

SetOldDisplayFunction[] :=
	($DisplayFunction = oldDisplayFunction;)
	

fixPoly[ {a_, b_, c_, d___}] :=
    Block[{norm},
		norm = Cross[ b-a, c-b] ;
		len = Sqrt[ norm.norm] ;
		If[ len > 0, 
			Polygon[ {a,b,c,d}, norm/len],
			Polygon[ {a,b,c,d}, {0,0,0}]]
		]


fixPoly[ pts_, norm_] := 
	If[ norm === Automatic, fixPoly[ pts], Polygon[pts, norm]]

fixPoly[ pts_, norm_, style_] :=
	If[ norm === Automatic, 
		Append[ fixPoly[ pts], style], Polygon[pts, norm, style]]


NormalDisplayFunction[ g_Graphics3D] :=
	(oldDisplayFunction[ g /. Polygon[ arg__] :> fixPoly[ arg]] ;g)

NormalDisplayFunction[ g_] := oldDisplayFunction[g]


SetNormalDisplayFunction[] :=
	($DisplayFunction = NormalDisplayFunction;)

oldLightsG3D = LightSources /. Options[ Graphics3D, LightSources]

oldLightsPP3D = LightSources /. Options[ ParametricPlot3D, LightSources]


SetOldLights[] := 
	(SetOptions[ Graphics3D, LightSources -> oldLightsG3D];
	 SetOptions[ ParametricPlot3D, LightSources -> oldLightsPP3D];)


WhiteLights =
  {{{1, 0, 0}, RGBColor[1, 1, 1]}, {{0, 1, 0}, RGBColor[1, 1, 1]}, 
   {{0, 0, 1}, RGBColor[1, 1, 1]}, {{-1, 0, 0}, RGBColor[1, 1, 1]}, 
   {{0, -1, 0}, RGBColor[1, 1, 1]}, {{0, 0, -1}, RGBColor[1, 1, 1]}}


SetWhiteLights[] :=
	(SetOptions[ Graphics3D, LightSources -> WhiteLights];
	 SetOptions[ ParametricPlot3D, LightSources -> WhiteLights];)

ColorLights =
  {{{1,0,0}, RGBColor[1,0,0]},
   {{0,1,0}, RGBColor[0,1,0]},
   {{0,0,1}, RGBColor[0,0,1]},
   {{-1,0,0}, RGBColor[1,0,0]},
   {{0,-1,0}, RGBColor[0,1,0]},
   {{0,0,-1}, RGBColor[0,0,1]}} ;

SetColorLights[] :=
	(SetOptions[ Graphics3D, LightSources -> ColorLights];
	 SetOptions[ ParametricPlot3D, LightSources -> ColorLights];)

End[]

EndPackage[]

(*

<<ExtendGraphics/NormalDisplay.m

SetNormalDisplayFunction[]

SetOldDisplayFunction[]

SetWhiteLights[]

SetOldLights[]

*)




