#!/bin/sh

set -e
cd `dirname $0`

subdir=`basename $PWD`

export QT_SELECT=5

ALL=moc_all.cpp

echo "// This file is automatically generated by cpp/update-moc.sh" > $ALL

for file in `grep -l Q_''OBJECT *`; do
	mocfile=`echo $file | awk -F. '{print("moc_"$1".cpp")}'`
	mochack=`sed -n 's,^ *// MOC HACK: \(.*\),\1,p' $file`
	moc $file | sed "$mochack" > $mocfile
	echo "#include \"$subdir/$mocfile\"" >> $ALL
done
