<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2015                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2015
 *
 * Generated from xml/schema/CRM/PCP/PCP.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_PCP_DAO_PCP extends CRM_Core_DAO
{
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_pcp';
  /**
   * static instance to hold the field values
   *
   * @var array
   */
  static $_fields = null;
  /**
   * static instance to hold the keys used in $_fields for each field.
   *
   * @var array
   */
  static $_fieldKeys = null;
  /**
   * static instance to hold the FK relationships
   *
   * @var string
   */
  static $_links = null;
  /**
   * static instance to hold the values that can
   * be imported
   *
   * @var array
   */
  static $_import = null;
  /**
   * static instance to hold the values that can
   * be exported
   *
   * @var array
   */
  static $_export = null;
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Personal Campaign Page ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * FK to Contact ID
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   *
   * @var int unsigned
   */
  public $status_id;
  /**
   *
   * @var string
   */
  public $title;
  /**
   *
   * @var text
   */
  public $intro_text;
  /**
   *
   * @var text
   */
  public $page_text;
  /**
   *
   * @var string
   */
  public $donate_link_text;
  /**
   * The Contribution or Event Page which triggered this pcp
   *
   * @var int unsigned
   */
  public $page_id;
  /**
   * The type of PCP this is: contribute or event
   *
   * @var string
   */
  public $page_type;
  /**
   * The pcp block that this pcp page was created from
   *
   * @var int unsigned
   */
  public $pcp_block_id;
  /**
   *
   * @var int unsigned
   */
  public $is_thermometer;
  /**
   *
   * @var int unsigned
   */
  public $is_honor_roll;
  /**
   * Goal amount of this Personal Campaign Page.
   *
   * @var float
   */
  public $goal_amount;
  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;
  /**
   * Is Personal Campaign Page enabled/active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Notify owner via email when someone donates to page?
   *
   * @var boolean
   */
  public $is_notify;
  /**
   * class constructor
   *
   * @return civicrm_pcp
   */
  function __construct()
  {
    $this->__table = 'civicrm_pcp';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns()
  {
    if (!self::$_links) {
      self::$_links = static ::createReferenceColumns(__CLASS__);
      self::$_links[] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
    }
    return self::$_links;
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields()
  {
    if (!(self::$_fields)) {
      self::$_fields = array(
        'pcp_id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Personal Campaign Page ID') ,
          'description' => 'Personal Campaign Page ID',
          'required' => true,
        ) ,
        'pcp_contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID') ,
          'description' => 'FK to Contact ID',
          'required' => true,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => array(
            'type' => 'EntityRef',
          ) ,
        ) ,
        'status_id' => array(
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Personal Campaign Page Status') ,
          'required' => true,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'pcp_status',
            'optionEditPath' => 'civicrm/admin/options/pcp_status',
          )
        ) ,
        'title' => array(
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Personal Campaign Page Title') ,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'intro_text' => array(
          'name' => 'intro_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Intro Text') ,
          'default' => 'NULL',
          'html' => array(
            'type' => 'TexArea',
          ) ,
        ) ,
        'page_text' => array(
          'name' => 'page_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Page Text') ,
          'default' => 'NULL',
          'html' => array(
            'type' => 'TexArea',
          ) ,
        ) ,
        'donate_link_text' => array(
          'name' => 'donate_link_text',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Donate Link Text') ,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'page_id' => array(
          'name' => 'page_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contribution Page') ,
          'description' => 'The Contribution or Event Page which triggered this pcp',
          'required' => true,
        ) ,
        'page_type' => array(
          'name' => 'page_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('PCP Page Type') ,
          'description' => 'The type of PCP this is: contribute or event',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'default' => 'contribute',
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'pcp_block_id' => array(
          'name' => 'pcp_block_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('PCP Block') ,
          'description' => 'The pcp block that this pcp page was created from',
          'required' => true,
        ) ,
        'is_thermometer' => array(
          'name' => 'is_thermometer',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Use Thermometer?') ,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'is_honor_roll' => array(
          'name' => 'is_honor_roll',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Show Honor Roll?') ,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'goal_amount' => array(
          'name' => 'goal_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Goal Amount') ,
          'description' => 'Goal amount of this Personal Campaign Page.',
          'precision' => array(
            20,
            2
          ) ,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'currency' => array(
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Currency') ,
          'description' => '3 character string, value from config setting or input via user.',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'default' => 'NULL',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'numeric_code',
          )
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Enabled?') ,
          'description' => 'Is Personal Campaign Page enabled/active?',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'is_notify' => array(
          'name' => 'is_notify',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Notify Owner?') ,
          'description' => 'Notify owner via email when someone donates to page?',
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
      );
    }
    return self::$_fields;
  }
  /**
   * Returns an array containing, for each field, the arary key used for that
   * field in self::$_fields.
   *
   * @return array
   */
  static function &fieldKeys()
  {
    if (!(self::$_fieldKeys)) {
      self::$_fieldKeys = array(
        'id' => 'pcp_id',
        'contact_id' => 'pcp_contact_id',
        'status_id' => 'status_id',
        'title' => 'title',
        'intro_text' => 'intro_text',
        'page_text' => 'page_text',
        'donate_link_text' => 'donate_link_text',
        'page_id' => 'page_id',
        'page_type' => 'page_type',
        'pcp_block_id' => 'pcp_block_id',
        'is_thermometer' => 'is_thermometer',
        'is_honor_roll' => 'is_honor_roll',
        'goal_amount' => 'goal_amount',
        'currency' => 'currency',
        'is_active' => 'is_active',
        'is_notify' => 'is_notify',
      );
    }
    return self::$_fieldKeys;
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName()
  {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog()
  {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false)
  {
    if (!(self::$_import)) {
      self::$_import = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('import', $field)) {
          if ($prefix) {
            self::$_import['pcp'] = & $fields[$name];
          } else {
            self::$_import[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_import;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false)
  {
    if (!(self::$_export)) {
      self::$_export = array();
      $fields = self::fields();
      foreach($fields as $name => $field) {
        if (CRM_Utils_Array::value('export', $field)) {
          if ($prefix) {
            self::$_export['pcp'] = & $fields[$name];
          } else {
            self::$_export[$name] = & $fields[$name];
          }
        }
      }
    }
    return self::$_export;
  }
}
