/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import java.util.HashMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class XSLDecimalFormat
extends StyleElement {
    boolean prepared = false;
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;
    static int[] zeroDigits = new int[]{48, 1632, 1776, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3664, 3792, 3872, 4160, 6112, 6160, 6470, 6608, 65296, 66720, 120782, 120792, 120802, 120812, 120822};

    public void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "name") {
                this.name = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string == "decimal-separator") {
                this.decimalSeparator = attributeCollection.getValue(i);
                continue;
            }
            if (string == "grouping-separator") {
                this.groupingSeparator = attributeCollection.getValue(i);
                continue;
            }
            if (string == "infinity") {
                this.infinity = attributeCollection.getValue(i);
                continue;
            }
            if (string == "minus-sign") {
                this.minusSign = attributeCollection.getValue(i);
                continue;
            }
            if (string == "NaN") {
                this.NaN = attributeCollection.getValue(i);
                continue;
            }
            if (string == "percent") {
                this.percent = attributeCollection.getValue(i);
                continue;
            }
            if (string == "per-mille") {
                this.perMille = attributeCollection.getValue(i);
                continue;
            }
            if (string == "zero-digit") {
                this.zeroDigit = attributeCollection.getValue(i);
                continue;
            }
            if (string == "digit") {
                this.digit = attributeCollection.getValue(i);
                continue;
            }
            if (string == "pattern-separator") {
                this.patternSeparator = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public DecimalSymbols makeDecimalFormatSymbols() throws XPathException {
        DecimalSymbols decimalSymbols = new DecimalSymbols();
        DecimalFormatManager.setDefaults(decimalSymbols);
        if (this.decimalSeparator != null) {
            decimalSymbols.decimalSeparator = this.toChar(this.decimalSeparator);
        }
        if (this.groupingSeparator != null) {
            decimalSymbols.groupingSeparator = this.toChar(this.groupingSeparator);
        }
        if (this.infinity != null) {
            decimalSymbols.infinity = this.infinity;
        }
        if (this.minusSign != null) {
            decimalSymbols.minusSign = this.toChar(this.minusSign);
        }
        if (this.NaN != null) {
            decimalSymbols.NaN = this.NaN;
        }
        if (this.percent != null) {
            decimalSymbols.percent = this.toChar(this.percent);
        }
        if (this.perMille != null) {
            decimalSymbols.permill = this.toChar(this.perMille);
        }
        if (this.zeroDigit != null) {
            decimalSymbols.zeroDigit = this.toChar(this.zeroDigit);
            this.checkZeroDigit();
        }
        if (this.digit != null) {
            decimalSymbols.digit = this.toChar(this.digit);
        }
        if (this.patternSeparator != null) {
            decimalSymbols.patternSeparator = this.toChar(this.patternSeparator);
        }
        this.checkDistinctRoles(decimalSymbols);
        return decimalSymbols;
    }

    private void checkDistinctRoles(DecimalSymbols decimalSymbols) throws XPathException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(20);
        Integer n = new Integer(decimalSymbols.decimalSeparator);
        hashMap.put(n, "decimal-separator");
        n = new Integer(decimalSymbols.groupingSeparator);
        if (hashMap.get(n) != null) {
            this.duplicate("grouping-separator", (String)hashMap.get(n));
        }
        hashMap.put(n, "grouping-separator");
        n = new Integer(decimalSymbols.percent);
        if (hashMap.get(n) != null) {
            this.duplicate("percent", (String)hashMap.get(n));
        }
        hashMap.put(n, "percent");
        n = new Integer(decimalSymbols.permill);
        if (hashMap.get(n) != null) {
            this.duplicate("per-mille", (String)hashMap.get(n));
        }
        hashMap.put(n, "per-mille");
        n = new Integer(decimalSymbols.zeroDigit);
        if (hashMap.get(n) != null) {
            this.duplicate("zero-digit", (String)hashMap.get(n));
        }
        hashMap.put(n, "zero-digit");
        n = new Integer(decimalSymbols.digit);
        if (hashMap.get(n) != null) {
            this.duplicate("digit", (String)hashMap.get(n));
        }
        hashMap.put(n, "digit");
        n = new Integer(decimalSymbols.patternSeparator);
        if (hashMap.get(n) != null) {
            this.duplicate("pattern-separator", (String)hashMap.get(n));
        }
        hashMap.put(n, "pattern-separator");
    }

    private void duplicate(String string, String string2) throws XPathException {
        this.compileError("The same character is used as the " + string + " and as the " + string2, "XTSE1300");
    }

    public void checkZeroDigit() throws XPathException {
        int n = this.zeroDigit.length() == 1 ? this.zeroDigit.charAt(0) : StringValue.expand(this.zeroDigit)[0];
        if (Arrays.binarySearch(zeroDigits, n) < 0) {
            this.compileError("The value of the zero-digit attribute must be a Unicode digit with value zero", "XTSE1295");
        }
    }

    public void register() throws XPathException {
        this.prepareAttributes();
        DecimalSymbols decimalSymbols = this.makeDecimalFormatSymbols();
        DecimalFormatManager decimalFormatManager = this.getPrincipalStylesheet().getDecimalFormatManager();
        if (this.name == null) {
            try {
                decimalFormatManager.setDefaultDecimalFormat(decimalSymbols, this.getPrecedence());
            }
            catch (StaticError staticError) {
                this.compileError(staticError.getMessage(), staticError.getErrorCodeLocalPart());
            }
        } else {
            try {
                this.makeNameCode(this.name);
                String[] stringArray = this.getConfiguration().getNameChecker().getQNameParts(this.name);
                String string = this.getURIForPrefix(stringArray[0], false);
                try {
                    decimalFormatManager.setNamedDecimalFormat(string, stringArray[1], decimalSymbols, this.getPrecedence());
                }
                catch (StaticError staticError) {
                    this.compileError(staticError.getMessage(), staticError.getErrorCodeLocalPart());
                }
            }
            catch (XPathException xPathException) {
                this.compileError("Invalid decimal format name. " + xPathException.getMessage(), "XTSE0020");
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid decimal format name. " + qNameException.getMessage(), "XTSE0020");
            }
            catch (NamespaceException namespaceException) {
                this.compileError("Invalid decimal format name. " + namespaceException.getMessage(), "XTSE0280");
            }
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }

    private int toChar(String string) throws XPathException {
        int[] nArray = StringValue.expand(string);
        if (nArray.length != 1) {
            this.compileError("Attribute \"" + string + "\" should be a single character", "XTSE0020");
        }
        return nArray[0];
    }
}

