# Process this file with automake to produce Makefile.in

#   This file is part of the FORS Pipeline
#   Copyright (C) 2000-2004 European Southern Observatory

#   This library is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# Template SExtractor configuration file 
#
# The actual configuration file was created by replacing occurences of
# 'FORS_SXTRACTOR_CONFIG' (intentional typo) with the config installation 
# directory
#

#-------------------------------- Catalog ------------------------------------
 
CATALOG_NAME    test.cat        # name of the output catalog
CATALOG_TYPE    ASCII_SKYCAT    # "NONE","ASCII_HEAD","ASCII","FITS_1.0"
                                # or "FITS_LDAC"
 
PARAMETERS_NAME FORS_SEXTRACTOR_CONFIG/fors.param   # name of the file containing catalog contents
 
#------------------------------- Extraction ----------------------------------
 
DETECT_TYPE     CCD             # "CCD" or "PHOTO"
FLAG_IMAGE      flag.fits       # filename for an input FLAG-image
DETECT_MINAREA  5               # minimum number of pixels above threshold
DETECT_THRESH   1.5            # <sigmas> or <threshold>,<ZP> in mag.arcsec-2
WEIGHT_GAIN N   #  Assume that bkg noise changes
                # are due to local gain changes,
                # default is Yes, set to No

ANALYSIS_THRESH 1.5            # <sigmas> or <threshold>,<ZP> in mag.arcsec-2
 
FILTER          Y               # apply filter for detection ("Y" or "N")?
FILTER_NAME     FORS_SEXTRACTOR_CONFIG/fors.conv    # name of the file containing the filter
 
DEBLEND_NTHRESH 32              # Number of deblending sub-thresholds
DEBLEND_MINCONT 0.005           # Minimum contrast parameter for deblending
 
#DEBLEND_MINCONT 1    # Disable post-detection deblending,
                     # which makes sextractor detect an
                     # unfocused std star as a double source

CLEAN           Y               # Clean spurious detections? (Y or N)?
CLEAN_PARAM     1.0             # Cleaning efficiency
 
MASK_TYPE       CORRECT         # type of detection MASKing: can be one of
                                # "NONE", "BLANK" or "CORRECT"

#------------------------------ Photometry -----------------------------------
 
PHOT_APERTURES  40              # MAG_APER aperture diameter(s) in pixels
PHOT_AUTOPARAMS 2.5, 3.5        # MAG_AUTO parameters: <Kron_fact>,<min_radius>
 
SATUR_LEVEL     60000.0         # level (in ADUs) at which arises saturation
 
MAG_ZEROPOINT   0.0             # magnitude zero-point
MAG_GAMMA       4.0             # gamma of emulsion (for photographic scans)
#GAIN            0.0             # detector gain in e-/ADU
#As gain is used the header value, given on the command line
#PIXEL_SCALE     0.126           # size of pixel in arcsec (0=use FITS WCS info)
 
#------------------------- Star/Galaxy Separation ----------------------------
 
SEEING_FWHM     0.8             # stellar FWHM in arcsec
STARNNW_NAME    FORS_SEXTRACTOR_CONFIG/fors.nnw     # Neural-Network_Weight table filename
 
#------------------------------ Background -----------------------------------
 
BACK_SIZE       64              # Background mesh: <size> or <width>,<height>
BACK_FILTERSIZE 3               # Background filter: <size> or <width>,<height>
 
BACKPHOTO_TYPE  LOCAL          # can be "GLOBAL" or "LOCAL"
BACKPHOTO_THICK 30
 
#------------------------------ Check Image ----------------------------------
 
CHECKIMAGE_TYPE -BACKGROUND     # can be one of "NONE", "BACKGROUND",
                                # "MINIBACKGROUND", "-BACKGROUND", "OBJECTS",
                                # "-OBJECTS", "SEGMENTATION", "APERTURES",
                                # or "FILTERED"
CHECKIMAGE_NAME check.fits      # Filename for the check-image
 
#--------------------- Memory (change with caution!) -------------------------
 
MEMORY_OBJSTACK 3000            # number of objects in stack
MEMORY_PIXSTACK 300000          # number of pixels in stack
MEMORY_BUFSIZE  1024            # number of lines in buffer
 
#----------------------------- Miscellaneous ---------------------------------
 
VERBOSE_TYPE    NORMAL          # can be "QUIET", "NORMAL" or "FULL"
