<CsoundSynthesizer>

; Id: H00_b.CSD mg (2006, rev.2009)
; author: marco gasperini (marcogsp at yahoo dot it)

; G.M. Koenig
; ESSAY (1957)

<CsOptions>
-W -f -oH00_b.wav
</CsOptions>

<CsInstruments>

sr     = 192000
kr     = 192000
ksmps  = 1
nchnls = 1

;=============================================
; SINUS TONES (S)
;=============================================
	instr 1	
iamp	= ampdb(90+p4)
ifreq	= p5

a1	oscili iamp , ifreq , 1
aenv	expseg .001 , .005, 1 , p3-.01 ,1, .005,.001

aout	= a1 * aenv

	out aout
	endin
;=============================================

;=============================================
; FILTERED NOISE (N)
;=============================================
	instr 2
iamp	= ampdb(89+p4)
ifreq	= p5
ibw	= ifreq * .05		; filtered noise's bandwidth 5% of central frequency

a1	rnd31 iamp , 1 
k1	rms a1

afilt	butterbp a1 , ifreq , ibw
afilt	butterbp afilt , ifreq , ibw

aenv	expseg .001 , .005, .8 , p3-.01 ,.8 ,.005,.001

aout	gain afilt , k1
aout	= aout * aenv 

	out aout
	endin
;=============================================

;=============================================
; FILTERED IMPULSES (I)
;=============================================
	instr 3
iamp	= ampdb(90+p4)
ifreq	= p5
ibw	= ifreq * .01		; filtered pulse's bandwidth 1% of central frequency

if1	= ifreq-(ibw/3)
if2	= ifreq+((2*ibw)/3)

				
a1	mpulse iamp , 0 

afilt	atonex a1 , if1 , 2
afilt	tonex afilt*300 , if2 , 2  
afilt	butterbp afilt*2500 , ifreq , ibw*.05


aenv	linseg 1 , p3-.01, 1 , .01 , 0

aout	= afilt * aenv 

	out aout*(sr/192000)
	endin
;=============================================
</CsInstruments>
<CsScore>
;functions--------------------------------------------------
f1	0	8192	10	1	; sinusoid
;/functions--------------------------------------------------

t0	4572	; 76.2 cm/sec. tape speed (durations in cm)

;test--------------------------------------------------
;mute-------------------------------------------------
q 1 0 1
q 2 0 1
q 3 0 1
;/mute-------------------------------------------------
;/test-------------------------------------------------

;====================================================
; 180. MATERIAL H
; 181. total length: 171 cm, 5 sections
;
; sequence b
;
; length    sequence 	
; 16.9   cm (5)
; 23.1   cm (4)
; 28.9   cm (2)
; 42.6   cm (1)
; 59.5   cm (3)
;==================================================

;************************************************** b1
;==================================181.21
; 59.5 cm 
;----------------------------------------
;			p4	p5
;			iamp	ifreq	timbre
;			[dB]	[Hz]
i3	0	3.5	1	200	; I
i2	3.5	4.4	-4	264     ; R
i3	7.9	6.3	0	214     ; I
i2	14.2	7.1	-4	348     ; R
i3	21.3	12.5	-2	283     ; I
i2	33.8	8.4	-5	230     ; R
i3	42.2	10.9	-6	459     ; I
i2	53.1	6.4	-4	373     ; R
s                                   
t0	4572
;==================================181.22
; 42.6 cm
;----------------------------------------
i3	0	7.3	-2.5	303	; I
i2	7.3	9.6	-5	246     ; R
i3	16.9	4.9	-9	606     ; I
i2	21.8	5.6	-5	492     ; R
i3	27.4	2.5	-5	400     ; I
i2	29.9	4.2	-5	325     ; R
i3	34.1	5.1	-9	650     ; I
i2	39.2	3.4	-5	528     ; R
s                                   
t0	4572
;==================================181.23
; 23.1 cm
;----------------------------------------
i3	0	3.7	-5.5	429	; I
i2	3.7	4.6	-4	696     ; R
i3	8.3	2.7	-8	566     ; I
i2	11	3	-4	746     ; R
;************************************************** b2
i3	14	1.9	-11	800	; I
i3	+	3	-9	606     ; I
i3	+	1.7	-10.5	746     ; I
i3	+	2.5	-6.5	459     ; I
s                                   
t0	4572
;==================================181.24
; 16.9 cm 
;----------------------------------------
i1	0	2.7	0	566	; S
i3	2.7	3.3	-9.5	696     ; I
i3	6	2	-3.5	348     ; I
i3	+	2.3	-6	429     ; I
i1	10.3	1.4	0	528     ; S
i1	+	2.1	0	650     ; S
i3	13.8	1.3	-1.5	264     ; I
i3	+	1.8	-3	325     ; I
s                                   
t0 4572
;==================================181.25
; 28.9 cm
;----------------------------------------
i1	0	2	0	400	; S
i1	+	1.2	0	492     ; S
i1	+	1.5	0	246     ; S
i3	4.7	1.7	-3	303     ; I
i1	6.4	5.6	0	373     ; S
i1	+	3.9	0	230     ; S
i1	+	5	0	283     ; S
i1	+	8	0	214     ; S

; total length: 171 cm
e                                   
</CsScore>
</CsoundSynthesizer>