/*
 * Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#include "Icons.h"
#include <KIcon>

struct Icons::Private {
  static Icons::Private* s_instance;
  QImage dcraw;
  QImage documentOpen;
  QImage systemRun;
  QImage documentSave;
  QImage dialogOkApply;
  QImage editDelete;
  static Icons::Private* instance();
  void init();
};

Icons::Private* Icons::Private::s_instance = 0;

Icons::Private* Icons::Private::instance()
{
  if(not s_instance) {
    s_instance = new Private;
    s_instance->init();
  }
  return s_instance;
}

void Icons::Private::init() {
  dcraw = KIcon("image-x-dcraw").pixmap(100).toImage();
  documentOpen = KIcon("document-open").pixmap(32).toImage();
  systemRun = KIcon("system-run").pixmap(32).toImage();
  documentSave = KIcon("document-save").pixmap(32).toImage();
  dialogOkApply = KIcon("dialog-ok-apply").pixmap(32).toImage();
  editDelete = KIcon("edit-delete").pixmap(32).toImage();
}

void Icons::init() {
  Private::instance();
}

const QImage& Icons::dcraw()
{
  return Private::instance()->dcraw;
}

const QImage& Icons::documentOpen()
{
  return Private::instance()->documentOpen;
}

const QImage& Icons::systemRun()
{
  return Private::instance()->systemRun;
}

const QImage& Icons::documentSave()
{
  return Private::instance()->documentSave;
}

const QImage& Icons::dialogOkApply()
{
  return Private::instance()->dialogOkApply;
}

const QImage& Icons::editDelete()
{
  return Private::instance()->editDelete;
}
