/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KGRADIENTSLIDER_H
#define KGRADIENTSLIDER_H

// Qt includes.

#include <qwidget.h>
#include <qcolor.h>
#include <qlist.h>
#include <qpair.h>

class KGradientSlider : public QWidget
{
  Q_OBJECT
  public:
    KGradientSlider(QWidget *parent = 0);

    virtual ~KGradientSlider();

  public slots:
    void setLeftValue(double);
    void setRightValue(double);
    void setMiddleValue(double);

  signals:

    void leftValueChanged(double);
    void rightValueChanged(double);
    void middleValueChanged(double);

  protected:
    void paintEvent(QPaintEvent *);
    void mousePressEvent (QMouseEvent * e);
    void mouseReleaseEvent ( QMouseEvent * e );
    void mouseMoveEvent ( QMouseEvent * e );
    void leaveEvent ( QEvent * );

  public:
    void showMiddleCursor(bool b);
    double leftValue() const;
    double rightValue() const;
    double middleValue() const;
  private:
    void adjustMiddleValue( double _newLeftValue, double _newRightValue );
  private:
    struct Private;
    Private* const d;
};


#endif
