/*

 Derby - Class org.apache.derbyTesting.functionTests.util.ThreadDump

 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 */

package org.apache.derbyTesting.functionTests.util;

import java.util.Map;

public class ThreadDump {

    /**
     * 
     * @return A string representation of a full thread dump
     */
    public static String getStackDumpString() {
        StringBuffer sb = new StringBuffer();
        Map<Thread, StackTraceElement[]> st = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : st.entrySet()) {
            StackTraceElement[] lines = e.getValue();
            Thread t = e.getKey();
            sb.append("Thread name=" + t.getName() + " id=" + t.getId()
                    + " priority=" + t.getPriority() + " state=" + t.getState()
                    + " isdaemon=" + t.isDaemon() + "\n");
            for (int i = 0; i < lines.length; i++) {
                sb.append("\t" + lines[i] + "\n");

            }
            sb.append("\n");
        }
        return sb.toString();
    }

}
