dojo.provide("dojox.date.tests.umalqura.Date");
dojo.require("dojox.date.umalqura.Date");
dojo.require("dojox.date.umalqura.locale");
dojo.require("dojox.date.umalqura");
dojo.require("dojox.date.islamic.Date");
dojo.require("dojox.date.islamic.locale");
dojo.require("dojox.date.islamic");

dojo.require("dojo.date");

dojo.requireLocalization("dojo.cldr", "gregorian");
dojo.requireLocalization("dojo.cldr", "islamic");

tests.register("dojox.date.tests.umalqura.Date",
	[
		{
		    // Test formatting and parsing of dates in various locales pre-built in dojo.cldr
		    // NOTE: we can't set djConfig.extraLocale before bootstrapping unit tests, so directly
		    // load resources here for specific locales:

		    name: "setup",
		    setUp: function () {
		        var partLocaleList = ["ar", "en"];

		        dojo.forEach(partLocaleList, function (locale) {
		            dojo.requireLocalization("dojo.cldr", "islamic", locale);
		        });
		    },
		    runTest: function (t) {
		    },
		    tearDown: function () {
		        //Clean up bundles that should not exist if
		        //the test is re-run.
		        //				delete dojo.cldr.nls.islamic;
		    }
		},
		{
		    name: "conversion",
		    runTest: function (t) {
		        var dates = [

                [1400, 0, 1, 1979, 10, 20],
                [1400, 1, 1, 1979, 11, 19],
                [1400, 2, 1, 1980, 0, 18],
                [1400, 3, 1, 1980, 1, 16],
                [1400, 4, 1, 1980, 2, 17],
                [1400, 5, 1, 1980, 3, 15]
		        ];

		        var idate1, idate2, gdate1, gdate2;
		        var diff;
		        idate1 = new dojox.date.umalqura.Date(1400, 0, 1);
		        gdate1 = new Date(1979, 10, 20);
		        idate2 = new dojox.date.umalqura.Date();

		        gdate2 = idate1.toGregorian();
		        diff = dojo.date.compare(gdate1, gdate2, "date");
		        t.is(diff, 0, "error in converting to Gregorian");

		        idate2.fromGregorian(gdate1);

		        var errMsg = "error in converting from Gregorian";
		        diff = idate1.getFullYear() - idate2.getFullYear();
		        t.is(diff, 0, errMsg + " error in year");
		        diff = idate1.getMonth() - idate2.getMonth();
		        t.is(diff, 0, errMsg + " error in Month");
		        diff = idate1.getDate() - idate2.getDate();
		        t.is(diff, 0, errMsg + " error in Date");

		        //Case 2
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1400, 0, 1);
		            gdate1 = new Date(1979, 10, 20);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 3
		        {

		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1400, 0, 2);
		            gdate1 = new Date(1979, 10, 21);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 4
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1405, 0, 1);
		            gdate1 = new Date(1984, 8, 26);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 5
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1410, 0, 1);
		            gdate1 = new Date(1989, 7, 3);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 6
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1400, 0, 1);
		            gdate1 = new Date(1979, 10, 20);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            diff = idate1.getMonth() - idate2.getMonth();
		            diff = idate1.getDate() - idate2.getDate();

		            dates = [
                                [1400, 0, 1, 1979, 10, 20],
                                [1400, 0, 2, 1979, 10, 21],
		            ];
		            dojo.forEach(dates, function (d, i) {
		                idate1 = new dojox.date.umalqura.Date(d[0], d[1], d[2]);
		                gdate1 = new Date(d[3], d[4], d[5]);
		                idate2 = new dojox.date.umalqura.Date();
		                idate2.fromGregorian(gdate1);
		                var errMsg = "error in converting from Gregorian at Year : " + d[0] + " Month: " + d[1] + " Day: " + d[2];
		                diff = idate1.getFullYear() - idate2.getFullYear();
		                t.is(diff, 0, errMsg + " error in year");
		                diff = idate1.getMonth() - idate2.getMonth();
		                t.is(diff, 0, errMsg + " error in Month");
		                diff = idate1.getDate() - idate2.getDate();
		                t.is(diff, 0, errMsg + " error in Date");
		            });

		        }

		        //Case 7
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1405, 0, 2);
		            gdate1 = new Date(1984, 8, 27);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 8
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1410, 0, 2);
		            gdate1 = new Date(1989, 7, 4);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 9
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1415, 0, 2);
		            gdate1 = new Date(1994, 5, 11);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");

		            idate2.fromGregorian(gdate1);

		            var errMsg = "error in converting from Gregorian";
		            diff = idate1.getFullYear() - idate2.getFullYear();
		            t.is(diff, 0, errMsg + " error in year");
		            diff = idate1.getMonth() - idate2.getMonth();
		            t.is(diff, 0, errMsg + " error in Month");
		            diff = idate1.getDate() - idate2.getDate();
		            t.is(diff, 0, errMsg + " error in Date");
		        }

		        //Case 10
		        {

		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1400, 2, 2);
		            gdate1 = new Date(1980, 0, 19);
		            idate2 = new dojox.date.umalqura.Date();

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");
		            t.is(diff, 0, "error in converting to Gregorian");
		        }

		        //Case 11
		        {
		            var idate1, idate2, gdate1, gdate2;
		            var diff;
		            idate1 = new dojox.date.umalqura.Date(1400, 3, 1);
		            gdate1 = new Date(1980, 1, 16);

		            gdate2 = idate1.toGregorian();
		            diff = dojo.date.compare(gdate1, gdate2, "date");
		            t.is(diff, 0, "error in converting to Gregorian");
		        }
		    }
		},

		{
		    name: "toGregorian",
		    runTest: function (t) {

		        var dateIslamic = new dojox.date.umalqura.Date(1431, 3, 6); // March 22 2010
		        var dateGregorian = dateIslamic.toGregorian();
		        t.is(0, dojo.date.compare(new Date(2010, 2, 22), dateGregorian, "date"));
		        var dates = [

				           		[1400, 1, 1, 1979, 11, 19],
								[1400, 2, 1, 1980, 0, 18],
								[1400, 3, 1, 1980, 1, 16],
								[1400, 4, 1, 1980, 2, 17],
								[1400, 5, 1, 1980, 3, 15],
								[1400, 6, 1, 1980, 4, 14],
								[1400, 7, 1, 1980, 5, 13],
								[1400, 8, 1, 1980, 6, 12],
								[1400, 9, 1, 1980, 7, 11],
								[1400, 10, 1, 1980, 8, 9],
								[1400, 11, 1, 1980, 9, 9],
								[1401, 0, 1, 1980, 10, 8],
								[1401, 1, 1, 1980, 11, 7],
								[1401, 2, 1, 1981, 0, 6],
								[1401, 3, 1, 1981, 1, 5],
								[1401, 4, 1, 1981, 2, 6],
								[1401, 5, 1, 1981, 3, 5],
								[1401, 6, 1, 1981, 4, 4],
								[1401, 7, 1, 1981, 5, 2],
								[1401, 8, 1, 1981, 6, 2],
								[1401, 9, 1, 1981, 6, 31],
								[1401, 10, 1, 1981, 7, 29],
								[1401, 11, 1, 1981, 8, 28],
								[1402, 0, 1, 1981, 9, 28],
								[1402, 1, 1, 1981, 10, 26],
								[1402, 2, 1, 1981, 11, 26],
								[1405, 4, 1, 1985, 0, 22],
								[1405, 5, 1, 1985, 1, 21],
								[1406, 2, 1, 1985, 10, 14],
								[1406, 3, 1, 1985, 11, 13],
								[1406, 4, 1, 1986, 0, 12],
								[1406, 5, 1, 1986, 1, 10],
								[1406, 6, 1, 1986, 2, 12],
								[1406, 7, 1, 1986, 3, 10],
								[1406, 8, 1, 1986, 4, 10],
								[1406, 9, 1, 1986, 5, 8],
								[1406, 10, 1, 1986, 6, 8],
								[1406, 11, 1, 1986, 7, 7],
								[1407, 0, 1, 1986, 8, 5],
								[1407, 1, 1, 1986, 9, 5],
								[1407, 2, 1, 1986, 10, 3],
								[1407, 3, 1, 1986, 11, 3],
								[1407, 4, 1, 1987, 0, 1],
								[1407, 5, 1, 1987, 0, 31],
								[1407, 6, 1, 1987, 2, 1],
								[1407, 7, 1, 1987, 2, 30],
								[1407, 8, 1, 1987, 3, 29],
								[1407, 9, 1, 1987, 4, 28],
								[1408, 5, 1, 1988, 0, 20],
								[1408, 6, 1, 1988, 1, 19],
								[1408, 7, 1, 1988, 2, 19],
								[1408, 8, 1, 1988, 3, 17],
								[1408, 9, 1, 1988, 4, 17],
								[1408, 10, 1, 1988, 5, 15],
								[1408, 11, 1, 1988, 6, 15],
								[1409, 0, 1, 1988, 7, 13],
								[1409, 1, 1, 1988, 8, 12],
								[1409, 2, 1, 1988, 9, 12],
								[1409, 3, 1, 1988, 10, 11],
								[1409, 4, 1, 1988, 11, 10],
								[1409, 5, 1, 1989, 0, 9],
								[1411, 1, 1, 1990, 7, 22],
								[1411, 2, 1, 1990, 8, 20],
								[1411, 8, 1, 1991, 2, 17],
								[1411, 9, 1, 1991, 3, 16],
								[1411, 10, 1, 1991, 4, 15],
								[1411, 11, 1, 1991, 5, 13],
								[1412, 0, 1, 1991, 6, 13],
								[1412, 1, 1, 1991, 7, 11],
								[1412, 2, 1, 1991, 8, 10],
								[1412, 3, 1, 1991, 9, 9],
								[1412, 4, 1, 1991, 10, 8],
								[1412, 5, 1, 1991, 11, 7],
								[1412, 6, 1, 1992, 0, 6],
								[1412, 7, 1, 1992, 1, 5],
								[1412, 8, 1, 1992, 2, 6],
								[1412, 9, 1, 1992, 3, 4],
								[1412, 10, 1, 1992, 4, 4],
								[1412, 11, 1, 1992, 5, 2],
								[1413, 0, 1, 1992, 6, 1],
								[1413, 1, 1, 1992, 6, 31],
								[1413, 2, 1, 1992, 7, 29],
								[1413, 3, 1, 1992, 8, 28],
								[1413, 4, 1, 1992, 9, 27],
								[1413, 5, 1, 1992, 10, 25],
								[1414, 2, 1, 1993, 7, 19],
								[1414, 3, 1, 1993, 8, 17],
								[1414, 4, 1, 1993, 9, 17],
								[1414, 5, 1, 1993, 10, 15],
								[1414, 6, 1, 1993, 11, 14],
								[1414, 7, 1, 1994, 0, 13],
								[1414, 8, 1, 1994, 1, 12],
								[1414, 9, 1, 1994, 2, 13],
								[1414, 10, 1, 1994, 3, 12],
								[1414, 11, 1, 1994, 4, 12],
								[1415, 0, 1, 1994, 5, 10],
								[1415, 1, 1, 1994, 6, 10],
								[1415, 2, 1, 1994, 7, 9],
								[1415, 3, 1, 1994, 8, 7],
								[1415, 4, 1, 1994, 9, 6],
								[1415, 5, 1, 1994, 10, 5],
								[1415, 6, 1, 1994, 11, 4],
								[1415, 7, 1, 1995, 0, 2],
								[1415, 8, 1, 1995, 1, 1],
								[1415, 9, 1, 1995, 2, 2],
								[1415, 10, 1, 1995, 3, 1],
								[1415, 11, 1, 1995, 4, 1],
								[1416, 0, 1, 1995, 4, 30],
								[1416, 1, 1, 1995, 5, 29],
								[1416, 2, 1, 1995, 6, 29],
								[1416, 3, 1, 1995, 7, 27],
								[1416, 4, 1, 1995, 8, 26],
								[1416, 5, 1, 1995, 9, 25],
								[1416, 6, 1, 1995, 10, 24],
								[1416, 7, 1, 1995, 11, 23],
								[1416, 8, 1, 1996, 0, 21],
								[1416, 9, 1, 1996, 1, 20],
								[1416, 10, 1, 1996, 2, 20],
								[1416, 11, 1, 1996, 3, 19],
								[1417, 0, 1, 1996, 4, 18],
								[1417, 1, 1, 1996, 5, 17],
								[1417, 2, 1, 1996, 6, 17],
								[1417, 3, 1, 1996, 7, 16],
								[1417, 4, 1, 1996, 8, 14],
								[1417, 5, 1, 1996, 9, 13],
								[1417, 6, 1, 1996, 10, 12],
								[1417, 7, 1, 1996, 11, 12],
								[1417, 8, 1, 1997, 0, 10],
								[1417, 9, 1, 1997, 1, 9],
								[1417, 10, 1, 1997, 2, 10],
								[1417, 11, 1, 1997, 3, 8],
								[1418, 0, 1, 1997, 4, 8],
								[1418, 1, 1, 1997, 5, 6],
								[1418, 2, 1, 1997, 6, 6],
								[1418, 3, 1, 1997, 7, 5],
								[1418, 4, 1, 1997, 8, 3],
								[1418, 5, 1, 1997, 9, 3],
								[1418, 6, 1, 1997, 10, 1],
								[1418, 7, 1, 1997, 11, 1],
								[1418, 8, 1, 1997, 11, 31],
								[1418, 9, 1, 1998, 0, 29],
								[1418, 10, 1, 1998, 1, 28],
								[1418, 11, 1, 1998, 2, 29],
								[1419, 0, 1, 1998, 3, 27],
								[1419, 1, 1, 1998, 4, 27],
								[1419, 2, 1, 1998, 5, 25],
								[1419, 3, 1, 1998, 6, 25],
								[1419, 4, 1, 1998, 7, 23],
								[1419, 5, 1, 1998, 8, 22],
								[1419, 6, 1, 1998, 9, 21],
								[1419, 7, 1, 1998, 10, 20],
								[1419, 8, 1, 1998, 11, 20],
								[1419, 9, 1, 1999, 0, 19],
								[1419, 10, 1, 1999, 1, 17],
								[1419, 11, 1, 1999, 2, 19],
								[1420, 0, 1, 1999, 3, 17],
								[1420, 1, 1, 1999, 4, 16],
								[1420, 2, 1, 1999, 5, 15],
								[1420, 3, 1, 1999, 6, 14],
								[1420, 4, 1, 1999, 7, 12],
								[1420, 5, 1, 1999, 8, 11],
								[1420, 6, 1, 1999, 9, 10],
								[1420, 7, 1, 1999, 10, 9],
								[1420, 8, 1, 1999, 11, 9],
								[1420, 9, 1, 2000, 0, 8],
								[1420, 10, 1, 2000, 1, 7],
								[1420, 11, 1, 2000, 2, 7],
								[1421, 0, 1, 2000, 3, 6],
								[1421, 1, 1, 2000, 4, 5],
								[1421, 2, 1, 2000, 5, 3],
								[1421, 3, 1, 2000, 6, 3],
								[1421, 4, 1, 2000, 7, 1],
								[1421, 5, 1, 2000, 7, 30],
								[1421, 6, 1, 2000, 8, 28],
								[1421, 7, 1, 2000, 9, 28],
								[1421, 8, 1, 2000, 10, 27],
								[1421, 9, 1, 2000, 11, 27],
								[1421, 10, 1, 2001, 0, 26],
								[1421, 11, 1, 2001, 1, 24],
								[1422, 0, 1, 2001, 2, 26],
								[1422, 1, 1, 2001, 3, 25],
								[1422, 2, 1, 2001, 4, 24],
								[1422, 3, 1, 2001, 5, 22],
								[1422, 4, 1, 2001, 6, 22],
								[1422, 5, 1, 2001, 7, 20],
								[1423, 9, 1, 2002, 11, 5],
								[1423, 10, 1, 2003, 0, 4],
								[1423, 11, 1, 2003, 1, 2],
								[1424, 0, 1, 2003, 2, 4],
								[1424, 1, 1, 2003, 3, 3],
								[1424, 2, 1, 2003, 4, 2],
								[1424, 3, 1, 2003, 5, 1],
								[1424, 4, 1, 2003, 6, 1],
								[1424, 5, 1, 2003, 6, 30],
								[1424, 6, 1, 2003, 7, 29],
								[1424, 7, 1, 2003, 8, 27],
								[1424, 8, 1, 2003, 9, 26],
								[1424, 9, 1, 2003, 10, 25],
								[1424, 10, 1, 2003, 11, 24],
								[1424, 11, 1, 2004, 0, 23],
								[1425, 0, 1, 2004, 1, 21],
								[1425, 1, 1, 2004, 2, 22],
								[1425, 2, 1, 2004, 3, 20],
								[1425, 3, 1, 2004, 4, 20],
								[1426, 2, 1, 2005, 3, 10],
								[1426, 3, 1, 2005, 4, 9],
								[1426, 4, 1, 2005, 5, 8],
								[1426, 5, 1, 2005, 6, 7],
								[1426, 6, 1, 2005, 7, 6],
								[1428, 9, 1, 2007, 9, 13],
								[1428, 10, 1, 2007, 10, 11],
								[1428, 11, 1, 2007, 11, 11],
								[1429, 0, 1, 2008, 0, 10],
								[1429, 1, 1, 2008, 1, 8],
								[1429, 2, 1, 2008, 2, 9],
								[1480, 0, 1, 2057, 6, 3],
								[1480, 1, 1, 2057, 7, 1],
								[1480, 2, 1, 2057, 7, 31],
								[1480, 3, 1, 2057, 8, 30],
								[1480, 4, 1, 2057, 9, 29],
								[1480, 5, 1, 2057, 10, 27],
								[1480, 6, 1, 2057, 11, 27],
								[1480, 7, 1, 2058, 0, 25],
								[1480, 8, 1, 2058, 1, 24],
								[1480, 9, 1, 2058, 2, 25],
								[1480, 10, 1, 2058, 3, 24],
								[1480, 11, 1, 2058, 4, 23]
		        ];
		        var idate, gdate;
		        var dateIslamic;
		        var diff;
		        dojo.forEach(dates, function (d, i) {
		            idate = new dojox.date.umalqura.Date(d[0], d[1], d[2]);
		            gdate = new Date(d[3], d[4], d[5]);

		            t.is(0, dojo.date.compare(idate.toGregorian(), gdate, "date"));

		            dateIslamic = new dojox.date.umalqura.Date();
		            dateIslamic.fromGregorian(gdate);

		            diff = dojox.date.umalqura.compare(dateIslamic, idate, "date");

		            var errorMsg = "year: " + d[0] + " month: " + d[1] + " day: " + d[2] + ",";

		            var yearDiff = dateIslamic.getFullYear() - idate.getFullYear();
		            t.is(dateIslamic.getFullYear(), idate.getFullYear(), "error at year " + errorMsg);

		            var monthDiff = dateIslamic.getMonth() - idate.getMonth();
		            t.is(0, monthDiff, "error at month " + errorMsg);

		            var dayDiff = dateIslamic.getDate() - idate.getDate();
		            t.is(0, dayDiff, "error at day " + errorMsg + dateIslamic);
		        });
		    }
		},

		{
		    name: "fromGregorian",
		    runTest: function (t) {
		        var dateIslamic = new dojox.date.umalqura.Date();
		        var dateGregorian = new Date(2010, 2, 22);
		        var iDate, gDate;
		        dateIslamic.fromGregorian(dateGregorian);
		        var inputDate = new dojox.date.umalqura.Date(1431, 3, 6);
		        t.is(0, dojox.date.umalqura.compare(inputDate, dateIslamic, "date"));

		        t.is(0, dojo.date.compare(new Date(2010, 2, 22), dateGregorian, "date"));
		        var dates = [
			 	         [1431, 3, 6, 2010, 2, 22],
			 	         [1400, 0, 1, 1979, 10, 20],
			 	         [1400, 1, 1, 1979, 11, 19],
			 	         [1400, 2, 1, 1980, 0, 18],
			 	         [1400, 3, 1, 1980, 1, 16],
			 	         [1400, 4, 1, 1980, 2, 17],
			 	         [1400, 5, 1, 1980, 3, 15],
			 	         [1400, 6, 1, 1980, 4, 14],
			 	         [1400, 7, 1, 1980, 5, 13],
			 	         [1400, 8, 1, 1980, 6, 12],
			 	         [1400, 9, 1, 1980, 7, 11],
			 	         [1400, 10, 1, 1980, 8, 9],
			 	         [1400, 11, 1, 1980, 9, 9],
			 	         [1401, 0, 1, 1980, 10, 8],
			 	         [1401, 1, 1, 1980, 11, 7],
			 	         [1401, 2, 1, 1981, 0, 6],
			 	         [1401, 3, 1, 1981, 1, 5],
			 	         [1401, 4, 1, 1981, 2, 6],
			 	         [1401, 5, 1, 1981, 3, 5],
			 	         [1401, 6, 1, 1981, 4, 4],
			 	         [1401, 7, 1, 1981, 5, 2],
			 	         [1401, 8, 1, 1981, 6, 2],
			 	         [1401, 9, 1, 1981, 6, 31],
			 	         [1401, 10, 1, 1981, 7, 29],
			 	         [1401, 11, 1, 1981, 8, 28],
			 	         [1402, 0, 1, 1981, 9, 28],
			 	         [1402, 1, 1, 1981, 10, 26],
			 	         [1402, 2, 1, 1981, 11, 26],
			 	         [1402, 3, 1, 1982, 0, 24],
			 	         [1402, 4, 1, 1982, 1, 23],
			 	         [1402, 5, 1, 1982, 2, 25],
			 	         [1402, 6, 1, 1982, 3, 23],
			 	         [1402, 7, 1, 1982, 4, 23],
			 	         [1402, 8, 1, 1982, 5, 22],
			 	         [1402, 9, 1, 1982, 6, 21],
			 	         [1402, 10, 1, 1982, 7, 20],
			 	         [1402, 11, 1, 1982, 8, 18],
			 	         [1403, 0, 1, 1982, 9, 18],
			 	         [1403, 1, 1, 1982, 10, 16],
			 	         [1403, 2, 1, 1982, 11, 15],
			 	         [1403, 3, 1, 1983, 0, 14],
			 	         [1403, 4, 1, 1983, 1, 12],
			 	         [1403, 5, 1, 1983, 2, 14],
			 	         [1403, 6, 1, 1983, 3, 12],
			 	         [1403, 7, 1, 1983, 4, 12],
			 	         [1403, 8, 1, 1983, 5, 11],
			 	         [1403, 9, 1, 1983, 6, 10],
			 	         [1403, 10, 1, 1983, 7, 9],
			 	         [1403, 11, 1, 1983, 8, 8],
			 	         [1404, 0, 1, 1983, 9, 7],
			 	         [1404, 1, 1, 1983, 10, 6],
			 	         [1404, 2, 1, 1983, 11, 5],
			 	         [1404, 3, 1, 1984, 0, 4],
			 	         [1404, 4, 1, 1984, 1, 3],
			 	         [1404, 5, 1, 1984, 2, 4],
			 	         [1404, 6, 1, 1984, 3, 2],
			 	         [1404, 7, 1, 1984, 4, 2],
			 	         [1404, 8, 1, 1984, 5, 1],
			 	         [1404, 9, 1, 1984, 5, 30],
			 	         [1404, 10, 1, 1984, 6, 29],
			 	         [1404, 11, 1, 1984, 7, 28],
			 	         [1405, 0, 1, 1984, 8, 26],
			 	         [1405, 1, 1, 1984, 9, 25],
			 	         [1405, 2, 1, 1984, 10, 24],
			 	         [1405, 3, 1, 1984, 11, 24],
			 	         [1405, 4, 1, 1985, 0, 22],
			 	         [1405, 5, 1, 1985, 1, 21],
			 	         [1405, 6, 1, 1985, 2, 22],
			 	         [1405, 7, 1, 1985, 3, 21],
			 	         [1405, 8, 1, 1985, 4, 21],
			 	         [1405, 9, 1, 1985, 5, 19],
			 	         [1405, 10, 1, 1985, 6, 19],
			 	         [1405, 11, 1, 1985, 7, 17],
			 	         [1406, 0, 1, 1985, 8, 16],
			 	         [1406, 1, 1, 1985, 9, 15],
			 	         [1406, 2, 1, 1985, 10, 14],
			 	         [1406, 3, 1, 1985, 11, 13],
			 	         [1406, 4, 1, 1986, 0, 12],
			 	         [1406, 5, 1, 1986, 1, 10],
			 	         [1406, 6, 1, 1986, 2, 12],
			 	         [1406, 7, 1, 1986, 3, 10],
			 	         [1406, 8, 1, 1986, 4, 10],
			 	         [1406, 9, 1, 1986, 5, 8],
			 	         [1406, 10, 1, 1986, 6, 8],
			 	         [1406, 11, 1, 1986, 7, 7],
			 	         [1407, 0, 1, 1986, 8, 5],
			 	         [1407, 1, 1, 1986, 9, 5],
			 	         [1407, 2, 1, 1986, 10, 3],
			 	         [1407, 3, 1, 1986, 11, 3],
			 	         [1407, 4, 1, 1987, 0, 1],
			 	         [1407, 5, 1, 1987, 0, 31],
			 	         [1407, 6, 1, 1987, 2, 1],
			 	         [1407, 7, 1, 1987, 2, 30],
			 	         [1407, 8, 1, 1987, 3, 29],
			 	         [1407, 9, 1, 1987, 4, 28],
			 	         [1407, 10, 1, 1987, 5, 27],
			 	         [1407, 11, 1, 1987, 6, 27],
			 	         [1408, 0, 1, 1987, 7, 25],
			 	         [1408, 1, 1, 1987, 8, 24],
			 	         [1408, 2, 1, 1987, 9, 24],
			 	         [1408, 3, 1, 1987, 10, 22],
			 	         [1408, 4, 1, 1987, 11, 22],
			 	         [1408, 5, 1, 1988, 0, 20],
			 	         [1408, 6, 1, 1988, 1, 19],
			 	         [1408, 7, 1, 1988, 2, 19],
			 	         [1408, 8, 1, 1988, 3, 17],
			 	         [1408, 9, 1, 1988, 4, 17],
			 	         [1408, 10, 1, 1988, 5, 15],
			 	         [1408, 11, 1, 1988, 6, 15],
			 	         [1409, 0, 1, 1988, 7, 13],
			 	         [1409, 1, 1, 1988, 8, 12],
			 	         [1409, 2, 1, 1988, 9, 12],
			 	         [1409, 3, 1, 1988, 10, 11],
			 	         [1409, 4, 1, 1988, 11, 10],
			 	         [1409, 5, 1, 1989, 0, 9],
			 	         [1409, 6, 1, 1989, 1, 7],
			 	         [1409, 7, 1, 1989, 2, 9],
			 	         [1409, 8, 1, 1989, 3, 7],
			 	         [1409, 9, 1, 1989, 4, 6],
			 	         [1409, 10, 1, 1989, 5, 5],
			 	         [1409, 11, 1, 1989, 6, 4],
			 	         [1410, 0, 1, 1989, 7, 3],
			 	         [1410, 1, 1, 1989, 8, 1],
			 	         [1410, 2, 1, 1989, 9, 1],
			 	         [1410, 3, 1, 1989, 9, 31],
			 	         [1410, 4, 1, 1989, 10, 30],
			 	         [1410, 5, 1, 1989, 11, 29],
			 	         [1410, 6, 1, 1990, 0, 28],
			 	         [1410, 7, 1, 1990, 1, 26],
			 	         [1410, 8, 1, 1990, 2, 28],
			 	         [1410, 9, 1, 1990, 3, 26],
			 	         [1410, 10, 1, 1990, 4, 25],
			 	         [1410, 11, 1, 1990, 5, 24],
			 	         [1411, 0, 1, 1990, 6, 23],
			 	         [1411, 1, 1, 1990, 7, 22],
			 	         [1411, 2, 1, 1990, 8, 20],
			 	         [1411, 3, 1, 1990, 9, 20],
			 	         [1411, 4, 1, 1990, 10, 19],
			 	         [1411, 5, 1, 1990, 11, 18],
			 	         [1411, 6, 1, 1991, 0, 17],
			 	         [1411, 7, 1, 1991, 1, 16],
			 	         [1411, 8, 1, 1991, 2, 17],
			 	         [1411, 9, 1, 1991, 3, 16],
			 	         [1411, 10, 1, 1991, 4, 15],
			 	         [1411, 11, 1, 1991, 5, 13],
			 	         [1412, 0, 1, 1991, 6, 13],
			 	         [1412, 1, 1, 1991, 7, 11],
			 	         [1412, 2, 1, 1991, 8, 10],
			 	         [1412, 3, 1, 1991, 9, 9],
			 	         [1412, 4, 1, 1991, 10, 8],
			 	         [1412, 5, 1, 1991, 11, 7],
			 	         [1412, 6, 1, 1992, 0, 6],
			 	         [1412, 7, 1, 1992, 1, 5],
			 	         [1412, 8, 1, 1992, 2, 6],
			 	         [1412, 9, 1, 1992, 3, 4],
			 	         [1412, 10, 1, 1992, 4, 4],
			 	         [1412, 11, 1, 1992, 5, 2],
			 	         [1413, 0, 1, 1992, 6, 1],
			 	         [1413, 1, 1, 1992, 6, 31],
			 	         [1413, 2, 1, 1992, 7, 29],
			 	         [1413, 3, 1, 1992, 8, 28],
			 	         [1413, 4, 1, 1992, 9, 27],
			 	         [1413, 5, 1, 1992, 10, 25],
			 	         [1413, 6, 1, 1992, 11, 25],
			 	         [1413, 7, 1, 1993, 0, 24],
			 	         [1413, 8, 1, 1993, 1, 22],
			 	         [1413, 9, 1, 1993, 2, 24],
			 	         [1413, 10, 1, 1993, 3, 23],
			 	         [1413, 11, 1, 1993, 4, 22],
			 	         [1414, 0, 1, 1993, 5, 21],
			 	         [1414, 1, 1, 1993, 6, 21],
			 	         [1414, 2, 1, 1993, 7, 19],
			 	         [1414, 3, 1, 1993, 8, 17],
			 	         [1414, 4, 1, 1993, 9, 17],
			 	         [1414, 5, 1, 1993, 10, 15],
			 	         [1414, 6, 1, 1993, 11, 14],
			 	         [1414, 7, 1, 1994, 0, 13],
			 	         [1414, 8, 1, 1994, 1, 12],
			 	         [1414, 9, 1, 1994, 2, 13],
			 	         [1414, 10, 1, 1994, 3, 12],
			 	         [1414, 11, 1, 1994, 4, 12],
			 	         [1415, 0, 1, 1994, 5, 10],
			 	         [1415, 1, 1, 1994, 6, 10],
			 	         [1415, 2, 1, 1994, 7, 9],
			 	         [1415, 3, 1, 1994, 8, 7],
			 	         [1415, 4, 1, 1994, 9, 6],
			 	         [1415, 5, 1, 1994, 10, 5],
			 	         [1415, 6, 1, 1994, 11, 4],
			 	         [1415, 7, 1, 1995, 0, 2],
			 	         [1415, 8, 1, 1995, 1, 1],
			 	         [1415, 9, 1, 1995, 2, 2],
			 	         [1415, 10, 1, 1995, 3, 1],
			 	         [1415, 11, 1, 1995, 4, 1],
			 	         [1416, 0, 1, 1995, 4, 30],
			 	         [1416, 1, 1, 1995, 5, 29],
			 	         [1416, 2, 1, 1995, 6, 29],
			 	         [1416, 3, 1, 1995, 7, 27],
			 	         [1416, 4, 1, 1995, 8, 26],
			 	         [1416, 5, 1, 1995, 9, 25],
			 	         [1416, 6, 1, 1995, 10, 24],
			 	         [1416, 7, 1, 1995, 11, 23],
			 	         [1416, 8, 1, 1996, 0, 21],
			 	         [1416, 9, 1, 1996, 1, 20],
			 	         [1416, 10, 1, 1996, 2, 20],
			 	         [1416, 11, 1, 1996, 3, 19],
			 	         [1417, 0, 1, 1996, 4, 18],
			 	         [1417, 1, 1, 1996, 5, 17],
			 	         [1417, 2, 1, 1996, 6, 17],
			 	         [1417, 3, 1, 1996, 7, 16],
			 	         [1417, 4, 1, 1996, 8, 14],
			 	         [1417, 5, 1, 1996, 9, 13],
			 	         [1417, 6, 1, 1996, 10, 12],
			 	         [1417, 7, 1, 1996, 11, 12],
			 	         [1417, 8, 1, 1997, 0, 10],
			 	         [1417, 9, 1, 1997, 1, 9],
			 	         [1417, 10, 1, 1997, 2, 10],
			 	         [1417, 11, 1, 1997, 3, 8],
			 	         [1418, 0, 1, 1997, 4, 8],
			 	         [1418, 1, 1, 1997, 5, 6],
			 	         [1418, 2, 1, 1997, 6, 6],
			 	         [1418, 3, 1, 1997, 7, 5],
			 	         [1418, 4, 1, 1997, 8, 3],
			 	         [1418, 5, 1, 1997, 9, 3],
			 	         [1418, 6, 1, 1997, 10, 1],
			 	         [1423, 7, 1, 2002, 9, 7],
			 	         [1423, 8, 1, 2002, 10, 6],
			 	         [1423, 9, 1, 2002, 11, 5],
			 	         [1423, 10, 1, 2003, 0, 4],
			 	         [1423, 11, 1, 2003, 1, 2],
			 	         [1424, 0, 1, 2003, 2, 4],
			 	         [1424, 1, 1, 2003, 3, 3],
			 	         [1424, 2, 1, 2003, 4, 2],
			 	         [1424, 3, 1, 2003, 5, 1],
			 	         [1424, 4, 1, 2003, 6, 1],
			 	         [1424, 5, 1, 2003, 6, 30],
			 	         [1424, 6, 1, 2003, 7, 29],
			 	         [1424, 7, 1, 2003, 8, 27],
			 	         [1424, 8, 1, 2003, 9, 26],
			 	         [1424, 9, 1, 2003, 10, 25],
			 	         [1424, 10, 1, 2003, 11, 24],
			 	         [1424, 11, 1, 2004, 0, 23],
			 	         [1425, 0, 1, 2004, 1, 21],
			 	         [1425, 1, 1, 2004, 2, 22],
			 	         [1425, 2, 1, 2004, 3, 20],
			 	         [1425, 3, 1, 2004, 4, 20],
			 	         [1425, 4, 1, 2004, 5, 19],
			 	         [1425, 5, 1, 2004, 6, 18],
			 	         [1425, 6, 1, 2004, 7, 17],
			 	         [1425, 7, 1, 2004, 8, 15],
			 	         [1425, 8, 1, 2004, 9, 15],
			 	         [1425, 9, 1, 2004, 10, 14],
			 	         [1425, 10, 1, 2004, 11, 13],
			 	         [1425, 11, 1, 2005, 0, 12],
			 	         [1426, 0, 1, 2005, 1, 10],
			 	         [1426, 1, 1, 2005, 2, 11],
			 	         [1426, 2, 1, 2005, 3, 10],
			 	         [1426, 3, 1, 2005, 4, 9],
			 	         [1426, 4, 1, 2005, 5, 8],
			 	         [1426, 5, 1, 2005, 6, 7],
			 	         [1426, 6, 1, 2005, 7, 6],
			 	         [1426, 7, 1, 2005, 8, 5],
			 	         [1426, 8, 1, 2005, 9, 4],
			 	         [1426, 9, 1, 2005, 10, 3],
			 	         [1426, 10, 1, 2005, 11, 3],
			 	         [1426, 11, 1, 2006, 0, 1],
			 	         [1427, 0, 1, 2006, 0, 31],
			 	         [1427, 1, 1, 2006, 2, 1],
			 	         [1427, 2, 1, 2006, 2, 30],
			 	         [1427, 3, 1, 2006, 3, 29],
			 	         [1427, 4, 1, 2006, 4, 28],
			 	         [1427, 5, 1, 2006, 5, 27],
			 	         [1427, 6, 1, 2006, 6, 26],
			 	         [1427, 7, 1, 2006, 7, 25],
			 	         [1427, 8, 1, 2006, 8, 24],
			 	         [1427, 9, 1, 2006, 9, 23],
			 	         [1427, 10, 1, 2006, 10, 22],
			 	         [1427, 11, 1, 2006, 11, 22],
			 	         [1428, 0, 1, 2007, 0, 20],
			 	         [1428, 1, 1, 2007, 1, 19],
			 	         [1428, 2, 1, 2007, 2, 20],
			 	         [1428, 3, 1, 2007, 3, 18],
			 	         [1428, 4, 1, 2007, 4, 18],
			 	         [1428, 5, 1, 2007, 5, 16],
			 	         [1428, 6, 1, 2007, 6, 15],
			 	         [1428, 7, 1, 2007, 7, 14],
			 	         [1428, 8, 1, 2007, 8, 13],
			 	         [1428, 9, 1, 2007, 9, 13],
			 	         [1428, 10, 1, 2007, 10, 11],
			 	         [1428, 11, 1, 2007, 11, 11],
			 	         [1429, 0, 1, 2008, 0, 10],
			 	         [1429, 1, 1, 2008, 1, 8],
			 	         [1429, 2, 1, 2008, 2, 9],
			 	         [1429, 3, 1, 2008, 3, 7],
			 	         [1429, 4, 1, 2008, 4, 6],
			 	         [1429, 5, 1, 2008, 5, 5],
			 	         [1429, 6, 1, 2008, 6, 4],
			 	         [1429, 7, 1, 2008, 7, 2],
			 	         [1429, 8, 1, 2008, 8, 1],
			 	         [1429, 9, 1, 2008, 9, 1],
			 	         [1429, 10, 1, 2008, 9, 30],
			 	         [1429, 11, 1, 2008, 10, 29],
			 	         [1430, 0, 1, 2008, 11, 29],
			 	         [1430, 1, 1, 2009, 0, 27],
			 	         [1430, 2, 1, 2009, 1, 26],
			 	         [1430, 3, 1, 2009, 2, 28],
			 	         [1430, 4, 1, 2009, 3, 26],
			 	         [1430, 5, 1, 2009, 4, 25],
			 	         [1430, 6, 1, 2009, 5, 24],
			 	         [1430, 7, 1, 2009, 6, 23],
			 	         [1430, 8, 1, 2009, 7, 22],
			 	         [1430, 9, 1, 2009, 8, 20],
			 	         [1430, 10, 1, 2009, 9, 20],
			 	         [1430, 11, 1, 2009, 10, 18],
			 	         [1431, 0, 1, 2009, 11, 18],
			 	         [1431, 1, 1, 2010, 0, 16],
			 	         [1431, 2, 1, 2010, 1, 15],
			 	         [1431, 3, 1, 2010, 2, 17],
			 	         [1431, 4, 1, 2010, 3, 15],
			 	         [1431, 5, 1, 2010, 4, 15],
			 	         [1431, 6, 1, 2010, 5, 13],
			 	         [1431, 7, 1, 2010, 6, 13],
			 	         [1431, 8, 1, 2010, 7, 11],
			 	         [1431, 9, 1, 2010, 8, 10],
			 	         [1431, 10, 1, 2010, 9, 9],
			 	         [1431, 11, 1, 2010, 10, 7],
			 	         [1432, 0, 1, 2010, 11, 7],
			 	         [1432, 1, 1, 2011, 0, 5],
			 	         [1432, 2, 1, 2011, 1, 4],
			 	         [1432, 3, 1, 2011, 2, 6],
			 	         [1432, 4, 1, 2011, 3, 5],
			 	         [1432, 5, 1, 2011, 4, 4],
			 	         [1432, 6, 1, 2011, 5, 3],
			 	         [1432, 7, 1, 2011, 6, 2],
			 	         [1432, 8, 1, 2011, 7, 1],
			 	         [1432, 9, 1, 2011, 7, 30],
			 	         [1432, 10, 1, 2011, 8, 29],
			 	         [1432, 11, 1, 2011, 9, 28],
			 	         [1433, 0, 1, 2011, 10, 26],
			 	         [1433, 1, 1, 2011, 11, 26],
			 	         [1433, 2, 1, 2012, 0, 24],
			 	         [1433, 3, 1, 2012, 1, 23],
			 	         [1433, 4, 1, 2012, 2, 24],
			 	         [1433, 5, 1, 2012, 3, 22],
			 	         [1433, 6, 1, 2012, 4, 22],
			 	         [1433, 7, 1, 2012, 5, 21],
			 	         [1433, 8, 1, 2012, 6, 20],
			 	         [1433, 9, 1, 2012, 7, 19],
			 	         [1433, 10, 1, 2012, 8, 17],
			 	         [1433, 11, 1, 2012, 9, 17],
			 	         [1434, 0, 1, 2012, 10, 15],
			 	         [1434, 1, 1, 2012, 11, 14],
			 	         [1434, 2, 1, 2013, 0, 13],
			 	         [1434, 3, 1, 2013, 1, 11],
			 	         [1434, 4, 1, 2013, 2, 13],
			 	         [1434, 5, 1, 2013, 3, 11],
			 	         [1434, 6, 1, 2013, 4, 11],
			 	         [1434, 7, 1, 2013, 5, 10],
			 	         [1434, 8, 1, 2013, 6, 9],
			 	         [1434, 9, 1, 2013, 7, 8],
			 	         [1434, 10, 1, 2013, 8, 7],
			 	         [1434, 11, 1, 2013, 9, 6],
			 	         [1435, 0, 1, 2013, 10, 4],
			 	         [1435, 1, 1, 2013, 11, 4],
			 	         [1435, 2, 1, 2014, 0, 2],
			 	         [1435, 3, 1, 2014, 1, 1],
			 	         [1435, 4, 1, 2014, 2, 2],
			 	         [1435, 5, 1, 2014, 3, 1],
			 	         [1435, 6, 1, 2014, 3, 30],
			 	         [1435, 7, 1, 2014, 4, 30],
			 	         [1435, 8, 1, 2014, 5, 28],
			 	         [1435, 9, 1, 2014, 6, 28],
			 	         [1435, 10, 1, 2014, 7, 27],
			 	         [1435, 11, 1, 2014, 8, 25],
			 	         [1436, 0, 1, 2014, 9, 25],
			 	         [1436, 1, 1, 2014, 10, 23],
			 	         [1436, 2, 1, 2014, 11, 23],
			 	         [1436, 3, 1, 2015, 0, 21],
			 	         [1436, 4, 1, 2015, 1, 20],
			 	         [1436, 5, 1, 2015, 2, 21],
			 	         [1436, 6, 1, 2015, 3, 20],
			 	         [1436, 7, 1, 2015, 4, 19],
			 	         [1436, 8, 1, 2015, 5, 18],
			 	         [1436, 9, 1, 2015, 6, 17],
			 	         [1436, 10, 1, 2015, 7, 16],
			 	         [1436, 11, 1, 2015, 8, 14],
			 	         [1437, 0, 1, 2015, 9, 14],
			 	         [1437, 1, 1, 2015, 10, 13],
			 	         [1437, 2, 1, 2015, 11, 12],
			 	         [1437, 3, 1, 2016, 0, 11],
			 	         [1437, 4, 1, 2016, 1, 10],
			 	         [1437, 5, 1, 2016, 2, 10],
			 	         [1437, 6, 1, 2016, 3, 8],
			 	         [1437, 7, 1, 2016, 4, 8],
			 	         [1437, 8, 1, 2016, 5, 6],
			 	         [1437, 9, 1, 2016, 6, 6],
			 	         [1437, 10, 1, 2016, 7, 4],
			 	         [1437, 11, 1, 2016, 8, 2],
			 	         [1438, 0, 1, 2016, 9, 2],
			 	         [1438, 1, 1, 2016, 10, 1],
			 	         [1438, 2, 1, 2016, 10, 30],
			 	         [1438, 3, 1, 2016, 11, 30],
			 	         [1438, 4, 1, 2017, 0, 29],
			 	         [1444, 10, 1, 2023, 4, 21],
			 	         [1444, 11, 1, 2023, 5, 19],
			 	         [1445, 0, 1, 2023, 6, 19],
			 	         [1445, 1, 1, 2023, 7, 17],
			 	         [1445, 2, 1, 2023, 8, 16],
			 	         [1445, 3, 1, 2023, 9, 16],
			 	         [1445, 4, 1, 2023, 10, 15],
			 	         [1445, 5, 1, 2023, 11, 14],
			 	         [1445, 6, 1, 2024, 0, 13],
			 	         [1445, 7, 1, 2024, 1, 11],
			 	         [1445, 8, 1, 2024, 2, 11],
			 	         [1445, 9, 1, 2024, 3, 10],
			 	         [1445, 10, 1, 2024, 4, 9],
			 	         [1445, 11, 1, 2024, 5, 7],
			 	         [1446, 0, 1, 2024, 6, 7],
			 	         [1446, 1, 1, 2024, 7, 5],
			 	         [1446, 2, 1, 2024, 8, 4],
			 	         [1446, 3, 1, 2024, 9, 4],
			 	         [1446, 4, 1, 2024, 10, 3],
			 	         [1446, 5, 1, 2024, 11, 2],
			 	         [1446, 6, 1, 2025, 0, 1],
			 	         [1446, 7, 1, 2025, 0, 31],
			 	         [1446, 8, 1, 2025, 2, 1],
			 	         [1446, 9, 1, 2025, 2, 30],
			 	         [1446, 10, 1, 2025, 3, 29],
			 	         [1446, 11, 1, 2025, 4, 28],
			 	         [1447, 0, 1, 2025, 5, 26],
			 	         [1447, 1, 1, 2025, 6, 26],
			 	         [1447, 2, 1, 2025, 7, 24],
			 	         [1447, 3, 1, 2025, 8, 23],
			 	         [1447, 4, 1, 2025, 9, 23],
			 	         [1451, 11, 1, 2030, 3, 4],
			 	         [1452, 0, 1, 2030, 4, 3],
			 	         [1452, 1, 1, 2030, 5, 2],
			 	         [1452, 2, 1, 2030, 6, 2],
			 	         [1452, 3, 1, 2030, 7, 1],
			 	         [1452, 4, 1, 2030, 7, 30],
			 	         [1452, 5, 1, 2030, 8, 29],
			 	         [1452, 6, 1, 2030, 9, 28],
			 	         [1452, 7, 1, 2030, 10, 26],
			 	         [1452, 8, 1, 2030, 11, 26],
			 	         [1452, 9, 1, 2031, 0, 24],
			 	         [1452, 10, 1, 2031, 1, 23],
			 	         [1452, 11, 1, 2031, 2, 24],
			 	         [1453, 0, 1, 2031, 3, 23],
			 	         [1453, 1, 1, 2031, 4, 22],
			 	         [1453, 2, 1, 2031, 5, 21],
			 	         [1453, 3, 1, 2031, 6, 21],
			 	         [1453, 4, 1, 2031, 7, 20],
			 	         [1453, 5, 1, 2031, 8, 18],
			 	         [1453, 6, 1, 2031, 9, 17],
			 	         [1453, 7, 1, 2031, 10, 16],
			 	         [1453, 8, 1, 2031, 11, 15],
			 	         [1453, 9, 1, 2032, 0, 14],
			 	         [1453, 10, 1, 2032, 1, 12],
			 	         [1453, 11, 1, 2032, 2, 13],
			 	         [1454, 0, 1, 2032, 3, 11],
			 	         [1454, 1, 1, 2032, 4, 10],
			 	         [1454, 2, 1, 2032, 5, 9],
			 	         [1454, 3, 1, 2032, 6, 9],
			 	         [1454, 4, 1, 2032, 7, 8],
			 	         [1454, 5, 1, 2032, 8, 6],
			 	         [1454, 6, 1, 2032, 9, 6],
			 	         [1454, 7, 1, 2032, 10, 4],
			 	         [1454, 8, 1, 2032, 11, 4],
			 	         [1454, 9, 1, 2033, 0, 2],
			 	         [1454, 10, 1, 2033, 1, 1],
			 	         [1454, 11, 1, 2033, 2, 2],
			 	         [1455, 0, 1, 2033, 3, 1],
			 	         [1455, 1, 1, 2033, 3, 30],
			 	         [1455, 2, 1, 2033, 4, 29],
			 	         [1455, 3, 1, 2033, 5, 28],
			 	         [1455, 4, 1, 2033, 6, 28],
			 	         [1455, 5, 1, 2033, 7, 26],
			 	         [1455, 6, 1, 2033, 8, 25],
			 	         [1455, 7, 1, 2033, 9, 24],
			 	         [1455, 8, 1, 2033, 10, 23],
			 	         [1455, 9, 1, 2033, 11, 23],
			 	         [1455, 10, 1, 2034, 0, 21],
			 	         [1455, 11, 1, 2034, 1, 20],
			 	         [1456, 0, 1, 2034, 2, 21],
			 	         [1456, 1, 1, 2034, 3, 20],
			 	         [1456, 2, 1, 2034, 4, 19],
			 	         [1456, 3, 1, 2034, 5, 17],
			 	         [1456, 4, 1, 2034, 6, 17],
			 	         [1456, 5, 1, 2034, 7, 15],
			 	         [1456, 6, 1, 2034, 8, 14],
			 	         [1456, 7, 1, 2034, 9, 13],
			 	         [1456, 8, 1, 2034, 10, 12],
			 	         [1456, 9, 1, 2034, 11, 12],
			 	         [1456, 10, 1, 2035, 0, 11],
			 	         [1456, 11, 1, 2035, 1, 9],
			 	         [1457, 0, 1, 2035, 2, 11],
			 	         [1457, 1, 1, 2035, 3, 9],
			 	         [1458, 9, 1, 2036, 10, 19],
			 	         [1458, 10, 1, 2036, 11, 19],
			 	         [1458, 11, 1, 2037, 0, 17],
			 	         [1459, 0, 1, 2037, 1, 16],
			 	         [1459, 1, 1, 2037, 2, 18],
			 	         [1459, 2, 1, 2037, 3, 17],
			 	         [1459, 3, 1, 2037, 4, 16],
			 	         [1459, 4, 1, 2037, 5, 15],
			 	         [1459, 5, 1, 2037, 6, 14],
			 	         [1459, 6, 1, 2037, 7, 12],
			 	         [1459, 7, 1, 2037, 8, 11],
			 	         [1459, 8, 1, 2037, 9, 10],
			 	         [1468, 1, 1, 2045, 11, 10],
			 	         [1468, 2, 1, 2046, 0, 8],
			 	         [1468, 3, 1, 2046, 1, 7],
			 	         [1468, 4, 1, 2046, 2, 9],
			 	         [1468, 5, 1, 2046, 3, 7],
			 	         [1468, 6, 1, 2046, 4, 7],
			 	         [1468, 7, 1, 2046, 5, 5],
			 	         [1468, 8, 1, 2046, 6, 5],
			 	         [1468, 9, 1, 2046, 7, 3],
			 	         [1468, 10, 1, 2046, 8, 2],
			 	         [1468, 11, 1, 2046, 9, 1],
			 	         [1469, 0, 1, 2046, 9, 31],
			 	         [1469, 1, 1, 2046, 10, 29],
			 	         [1469, 2, 1, 2046, 11, 28],
			 	         [1469, 3, 1, 2047, 0, 27],
			 	         [1469, 4, 1, 2047, 1, 26],
			 	         [1469, 5, 1, 2047, 2, 27],
			 	         [1469, 6, 1, 2047, 3, 26],
			 	         [1469, 7, 1, 2047, 4, 26],
			 	         [1469, 8, 1, 2047, 5, 24],
			 	         [1469, 9, 1, 2047, 6, 24],
			 	         [1469, 10, 1, 2047, 7, 23],
			 	         [1469, 11, 1, 2047, 8, 21],
			 	         [1470, 0, 1, 2047, 9, 20],
			 	         [1470, 1, 1, 2047, 10, 19],
			 	         [1470, 2, 1, 2047, 11, 18],
			 	         [1470, 3, 1, 2048, 0, 16],
			 	         [1470, 4, 1, 2048, 1, 15],
			 	         [1470, 5, 1, 2048, 2, 16],
			 	         [1470, 6, 1, 2048, 3, 14],
			 	         [1470, 7, 1, 2048, 4, 14],
			 	         [1470, 8, 1, 2048, 5, 12],
			 	         [1470, 9, 1, 2048, 6, 12],
			 	         [1470, 10, 1, 2048, 7, 11],
			 	         [1470, 11, 1, 2048, 8, 10],
			 	         [1471, 0, 1, 2048, 9, 9],
			 	         [1471, 1, 1, 2048, 10, 7],
			 	         [1471, 2, 1, 2048, 11, 7],
			 	         [1471, 3, 1, 2049, 0, 5],
			 	         [1471, 4, 1, 2049, 1, 3],
			 	         [1471, 5, 1, 2049, 2, 5],
			 	         [1471, 6, 1, 2049, 3, 3],
			 	         [1471, 7, 1, 2049, 4, 3],
			 	         [1471, 8, 1, 2049, 5, 2],
			 	         [1471, 9, 1, 2049, 6, 1],
			 	         [1471, 10, 1, 2049, 6, 31],
			 	         [1471, 11, 1, 2049, 7, 30],
			 	         [1472, 0, 1, 2049, 8, 28],
			 	         [1472, 1, 1, 2049, 9, 28],
			 	         [1472, 2, 1, 2049, 10, 26],
			 	         [1473, 10, 1, 2051, 6, 9],
			 	         [1473, 11, 1, 2051, 7, 8],
			 	         [1474, 0, 1, 2051, 8, 6],
			 	         [1474, 1, 1, 2051, 9, 6],
			 	         [1474, 2, 1, 2051, 10, 5],
			 	         [1474, 3, 1, 2051, 11, 4],
			 	         [1474, 4, 1, 2052, 0, 3],
			 	         [1474, 5, 1, 2052, 1, 2],
			 	         [1474, 6, 1, 2052, 2, 2],
			 	         [1474, 7, 1, 2052, 3, 1],
			 	         [1474, 8, 1, 2052, 3, 30],
			 	         [1474, 9, 1, 2052, 4, 29],
			 	         [1474, 10, 1, 2052, 5, 28],
			 	         [1474, 11, 1, 2052, 6, 27],
			 	         [1475, 0, 1, 2052, 7, 26],
			 	         [1475, 1, 1, 2052, 8, 24],
			 	         [1475, 2, 1, 2052, 9, 24],
			 	         [1475, 3, 1, 2052, 10, 22],
			 	         [1475, 4, 1, 2052, 11, 22],
			 	         [1475, 5, 1, 2053, 0, 21],
			 	         [1475, 6, 1, 2053, 1, 20],
			 	         [1475, 7, 1, 2053, 2, 21],
			 	         [1475, 8, 1, 2053, 3, 20],
			 	         [1475, 9, 1, 2053, 4, 19],
			 	         [1475, 10, 1, 2053, 5, 17],
			 	         [1475, 11, 1, 2053, 6, 17],
			 	         [1476, 0, 1, 2053, 7, 15],
			 	         [1476, 1, 1, 2053, 8, 13],
			 	         [1476, 2, 1, 2053, 9, 13],
			 	         [1476, 3, 1, 2053, 10, 11],
			 	         [1476, 4, 1, 2053, 11, 11],
			 	         [1477, 3, 1, 2054, 10, 1],
			 	         [1477, 4, 1, 2054, 10, 30],
			 	         [1477, 5, 1, 2054, 11, 30],
			 	         [1477, 6, 1, 2055, 0, 29],
			 	         [1477, 7, 1, 2055, 1, 27],
			 	         [1477, 8, 1, 2055, 2, 29],
			 	         [1477, 9, 1, 2055, 3, 28],
			 	         [1477, 10, 1, 2055, 4, 28],
			 	         [1477, 11, 1, 2055, 5, 26],
			 	         [1478, 0, 1, 2055, 6, 25],
			 	         [1478, 1, 1, 2055, 7, 24],
			 	         [1479, 7, 1, 2057, 1, 5],
			 	         [1479, 8, 1, 2057, 2, 6],
			 	         [1479, 9, 1, 2057, 3, 5],
			 	         [1479, 10, 1, 2057, 4, 5],
			 	         [1479, 11, 1, 2057, 5, 3],
			 	         [1480, 0, 1, 2057, 6, 3],
			 	         [1480, 1, 1, 2057, 7, 1],
			 	         [1480, 2, 1, 2057, 7, 31],
			 	         [1480, 3, 1, 2057, 8, 30],
			 	         [1480, 4, 1, 2057, 9, 29],
			 	         [1480, 5, 1, 2057, 10, 27],
			 	         [1480, 6, 1, 2057, 11, 27],
			 	         [1480, 7, 1, 2058, 0, 25],
			 	         [1480, 8, 1, 2058, 1, 24],
			 	         [1480, 9, 1, 2058, 2, 25],
			 	         [1480, 10, 1, 2058, 3, 24],
			 	         [1480, 11, 1, 2058, 4, 23],

			 	         //Special Case #1
						 [1475, 5, 1, 2053, 0, 21],
						 [1475, 5, 11, 2053, 0, 31],
						 [1475, 5, 12, 2053, 1, 1],
						 [1475, 5, 22, 2053, 1, 11],
						 [1475, 5, 29, 2053, 1, 18],
						 [1475, 5, 30, 2053, 1, 19]
		        ];
		        var idate, gdate, idate_expected;
		        dateIslamic.fromGregorian(dateGregorian);
		        var inputDate = new dojox.date.umalqura.Date(1431, 3, 6);
		        t.is(0, dojox.date.umalqura.compare(inputDate, dateIslamic, "date"));
		        dojo.forEach(dates, function (d, i) {

		            idate = new dojox.date.umalqura.Date();
		            idate_expected = new dojox.date.umalqura.Date(d[0], d[1], d[2]);
		            gdate = new Date(d[3], d[4], d[5]);
		            idate = new dojox.date.umalqura.Date();
		            idate.fromGregorian(gdate);
		            var errorMsg = "error at date Year=" + d[0] + " month= " + d[1] + " day= " + d[2];

		            t.is(idate.getFullYear(), d[0], errorMsg + " error at Year");
		            t.is(idate.getMonth(), d[1], errorMsg + " error at Month");
		            t.is(idate.getDate(), d[2], errorMsg + " error at Day");

		            t.is(0, dojo.date.compare(idate.fromGregorian(gdate), idate_expected, "date"), "year: " + d[0] + " month:" + d[1] + " day:" + d[2]);
		        });

		        //Special Case #2
		        {
		            var hYear, hMonth, hDay;
		            var gYear, gMonth, gDay;
		            hYear = 1400;
		            hMonth = 0;
		            hDay = 1;

		            gYear = 1979;
		            gMonth = 10;
		            gDay = 20;

		            var dateIslamic = new dojox.date.umalqura.Date();
		            var dateGregorian = new Date(gYear, gMonth, gDay);
		            var iDate, gDate;
		            dateIslamic.fromGregorian(dateGregorian);
		            var inputDate = new dojox.date.umalqura.Date(hYear, hMonth, hDay);

		            t.is(inputDate.getFullYear(), hYear, "error in year");
		            t.is(inputDate.getMonth(), hMonth, "error in month");
		            t.is(inputDate.getDate(), hDay, "error in day");

		            t.is(dateIslamic.getFullYear(), hYear, "error in conversion in year");
		            t.is(dateIslamic.getMonth(), hMonth, "error in conversion in month");
		            t.is(dateIslamic.getDate(), hDay, "error in conversion in Day");
		            t.is(0, dojox.date.umalqura.compare(inputDate, dateIslamic, "date"));

		        }
		    }
		},
		{
		    name: "getDay",
		    runTest: function (t) {
		        var dateTable = [
					[1431, 0, 11, 1],
					[1431, 1, 3, 1],
					[1431, 2, 10, 3],
					[1431, 3, 23, 4],
					[1431, 6, 21, 6],
					[1431, 6, 22, 0],
					[1431, 7, 15, 2]
		        ];
		        dojo.forEach(dateTable, function (d, i) {
		            var date = new dojox.date.umalqura.Date(d[0], d[1], d[2]);
		            var gday = date.getDay();
		            t.is(d[3], gday);
		        });

		    }
		},
		{
		    name: "getDaysInIslamicMonth",
		    runTest: function (t) {

		        var dateTable = [
					[1399, 11, 29]
		        ];

		        dojo.forEach(dateTable, function (d, i) {
		            var date = new dojox.date.umalqura.Date(d[0], d[1], 1);
		            t.is(d[2], dojox.date.umalqura.getDaysInMonth(date));
		        });
		    }
		},
		{
		    name: "add_month",
		    runTest: function (t) {
		        var start = [
						[1420, 1, 1422, 1],
						[1430, 2, 1435, 2],
						[1433, 0, 1434, 0],
						[1422, 2, 1420, 2],
						[1429, 3, 1427, 3],
						[1431, 4, 1431, 6],
						[1429, 7, 1429, 5],
						[1431, 3, 1431, 5],
						[1431, 3, 1431, 0],
						[1431, 1, 1431, 2],
						[1431, 9, 1431, 8]
		        ];
		        var add = [24, 60, 12, -24, -24, 2, -2, 2, -3, 1, -1];

		        var dateHijriStart, dateHijriEnd, res, dateHijriRes;
		        dojo.forEach(start, function (s, i) {
		            dateHijriStart = new dojox.date.umalqura.Date(s[0], s[1], 1);
		            dateHijriRes = dojox.date.umalqura.add(dateHijriStart, "month", add[i]);

		            t.is(0, dateHijriRes.getMonth() - s[3]);
		            t.is(0, dateHijriRes.getFullYear() - s[2]);
		        });
		    }
		},
        {
	    name: "difference_month",
		runTest: function (t) {
		    var start = [
                    [1420, 1, 1422, 1],
                    [1430, 2, 1435, 2],
                    [1433, 0, 1434, 0],
                    [1422, 2, 1420, 2],
                    [1429, 3, 1427, 3],
                    [1431, 4, 1431, 6],
                    [1429, 7, 1429, 5],
                    [1431, 3, 1431, 5],
                    [1431, 3, 1431, 0],
                    [1431, 1, 1431, 2],
                    [1431, 9, 1431, 8]
		    ];
		    var add = [24, 60, 12, -24, -24, 2, -2, 2, -3, 1, -1];

		    var dateHijriStart, dateHijriEnd, res, dateHijriRes;
		    dojo.forEach(start, function (s, i) {
		        dateHijriStart = new dojox.date.umalqura.Date(s[0], s[1], 1);
		        dateHijriRes = new dojox.date.umalqura.Date(s[2], s[3], 1);		        
		        t.is(dojox.date.umalqura.difference(dateHijriStart, dateHijriRes, "month"), add[i]);
		    });
		}
		},

		{
		    name: "getters",
		    runTest: function (t) {

		        var dates = [
				           [1400, 1, 1],
			 	           [1400, 0, 1, 1979, 10, 20],
				           [1400, 1, 0, 1979, 11, 19],
 				           [1400, 2, 0, 1980, 0, 18],
				           [1400, 3, 0, 1980, 1, 16],
				           [1400, 4, 0, 1980, 2, 17],
				           [1400, 5, 0, 1980, 3, 15],
				           [1400, 6, 0, 1980, 4, 14],
				           [1400, 7, 0, 1980, 5, 13],
				           [1400, 8, 0, 1980, 6, 12],
				           [1400, 9, 0, 1980, 7, 11],
				           [1400, 10, 0, 1980, 8, 9],
				           [1400, 11, 0, 1980, 9, 9],
				           [1401, 0, 0, 1980, 10, 8],
				           [1401, 1, 0, 1980, 11, 7],
				           [1401, 2, 0, 1981, 0, 6],
				           [1401, 3, 0, 1981, 1, 5],
				           [1401, 4, 0, 1981, 2, 6],
				           [1401, 5, 0, 1981, 3, 5],
				           [1401, 6, 0, 1981, 4, 4],
				           [1401, 7, 0, 1981, 5, 2],
				           [1401, 8, 0, 1981, 6, 2],
				           [1401, 9, 0, 1981, 6, 31],
				           [1401, 10, 0, 1981, 7, 29],
				           [1401, 11, 0, 1981, 8, 28],
				           [1402, 0, 0, 1981, 9, 28],
				           [1402, 1, 0, 1981, 10, 26],
				           [1402, 2, 0, 1981, 11, 26],
				           [1402, 3, 0, 1982, 0, 24],
				           [1402, 4, 0, 1982, 1, 23],
				           [1402, 5, 0, 1982, 2, 25],
				           [1402, 6, 0, 1982, 3, 23],
				           [1402, 7, 0, 1982, 4, 23],
				           [1402, 8, 0, 1982, 5, 22],
				           [1402, 9, 0, 1982, 6, 21],
				           [1402, 10, 0, 1982, 7, 20],
				           [1402, 11, 0, 1982, 8, 18],
				           [1403, 0, 0, 1982, 9, 18],
				           [1403, 1, 0, 1982, 10, 16],
				           [1403, 2, 0, 1982, 11, 15],
				           [1403, 3, 0, 1983, 0, 14],
				           [1403, 4, 0, 1983, 1, 12],
				           [1403, 5, 0, 1983, 2, 14],
				           [1403, 6, 0, 1983, 3, 12],
				           [1403, 7, 0, 1983, 4, 12],
				           [1403, 8, 0, 1983, 5, 11],
				           [1403, 9, 0, 1983, 6, 10],
				           [1403, 10, 0, 1983, 7, 9],
				           [1403, 11, 0, 1983, 8, 8],
				           [1404, 0, 0, 1983, 9, 7],
				           [1404, 1, 0, 1983, 10, 6],
				           [1404, 2, 0, 1983, 11, 5],
                           [1404, 3, 0, 1984, 0, 4],
				           [1404, 4, 0, 1984, 1, 3],
				           [1404, 5, 0, 1984, 2, 4],
				           [1404, 6, 0, 1984, 3, 2],
				           [1404, 7, 0, 1984, 4, 2],
				           [1404, 8, 0, 1984, 5, 1],
				           [1404, 9, 0, 1984, 5, 30],
				           [1404, 10, 0, 1984, 6, 29],
				           [1404, 11, 0, 1984, 7, 28],
		                   [1405, 0, 0, 1984, 8, 26],
				           [1405, 1, 0, 1984, 9, 25],
				           [1405, 2, 0, 1984, 10, 24],
				           [1405, 3, 0, 1984, 11, 24],
				           [1405, 4, 0, 1985, 0, 22],
				           [1405, 5, 0, 1985, 1, 21],
				           [1405, 6, 0, 1985, 2, 22],
				           [1405, 7, 0, 1985, 3, 21],
				           [1405, 8, 0, 1985, 4, 21],
				           [1405, 9, 0, 1985, 5, 19],
				           [1405, 10, 0, 1985, 6, 19],
				           [1405, 11, 0, 1985, 7, 17],
				           [1406, 0, 0, 1985, 8, 16],
				           [1406, 1, 0, 1985, 9, 15],
				           [1406, 2, 0, 1985, 10, 14],
				           [1406, 3, 0, 1985, 11, 13],
				           [1406, 4, 0, 1986, 0, 12],
				           [1406, 5, 0, 1986, 1, 10],
				           [1406, 6, 0, 1986, 2, 12],
				           [1406, 7, 0, 1986, 3, 10],
				           [1406, 8, 0, 1986, 4, 10],
				           [1406, 9, 0, 1986, 5, 8],
				           [1406, 10, 0, 1986, 6, 8],
				           [1406, 11, 0, 1986, 7, 7],
				           [1407, 0, 0, 1986, 8, 5],
				           [1407, 1, 0, 1986, 9, 5],
				           [1407, 2, 0, 1986, 10, 3],
				           [1407, 3, 0, 1986, 11, 3],
				           [1407, 4, 0, 1987, 0, 1],
				           [1407, 5, 0, 1987, 0, 31],
				           [1407, 6, 0, 1987, 2, 1],
				           [1407, 7, 0, 1987, 2, 30],
				           [1407, 8, 0, 1987, 3, 29],
				           [1407, 9, 0, 1987, 4, 28],
				           [1407, 10, 0, 1987, 5, 27],
				           [1407, 11, 0, 1987, 6, 27],
				           [1408, 0, 0, 1987, 7, 25],
				           [1408, 1, 0, 1987, 8, 24],
				           [1408, 2, 0, 1987, 9, 24],
				           [1408, 3, 0, 1987, 10, 22],
				           [1408, 4, 0, 1987, 11, 22],
				           [1408, 5, 0, 1988, 0, 20],
				           [1408, 6, 0, 1988, 1, 19],
				           [1408, 7, 0, 1988, 2, 19],
				           [1408, 8, 0, 1988, 3, 17],
				           [1408, 9, 0, 1988, 4, 17],
				           [1408, 10, 0, 1988, 5, 15],
				           [1408, 11, 0, 1988, 6, 15],
				           [1409, 0, 0, 1988, 7, 13],
				           [1409, 1, 0, 1988, 8, 12],
				           [1409, 2, 0, 1988, 9, 12],
				           [1409, 3, 0, 1988, 10, 11],
				           [1409, 4, 0, 1988, 11, 10],
				           [1409, 5, 0, 1989, 0, 9],
				           [1409, 6, 0, 1989, 1, 7],
				           [1409, 7, 0, 1989, 2, 9],
				           [1409, 8, 0, 1989, 3, 7],
				           [1409, 9, 0, 1989, 4, 6],
				           [1409, 10, 0, 1989, 5, 5],
				           [1409, 11, 0, 1989, 6, 4],
				           [1410, 0, 0, 1989, 7, 3],
				           [1410, 1, 0, 1989, 8, 1],
				           [1410, 2, 0, 1989, 9, 1],
				           [1410, 3, 0, 1989, 9, 31],
				           [1410, 4, 0, 1989, 10, 30],
				           [1410, 5, 0, 1989, 11, 29],
				           [1410, 6, 0, 1990, 0, 28],
				           [1410, 7, 0, 1990, 1, 26],
				           [1410, 8, 0, 1990, 2, 28],
				           [1410, 9, 0, 1990, 3, 26],
				           [1410, 10, 0, 1990, 4, 25],
				           [1410, 11, 0, 1990, 5, 24],
				           [1411, 0, 0, 1990, 6, 23],
				           [1411, 1, 0, 1990, 7, 22],
				           [1411, 2, 0, 1990, 8, 20],
				           [1411, 3, 0, 1990, 9, 20],
				           [1411, 4, 0, 1990, 10, 19],
				           [1411, 5, 0, 1990, 11, 18],
				           [1411, 6, 0, 1991, 0, 17],
				           [1411, 7, 0, 1991, 1, 16],
				           [1411, 8, 0, 1991, 2, 17],
				           [1411, 9, 0, 1991, 3, 16],
				           [1411, 10, 0, 1991, 4, 15],
				           [1411, 11, 0, 1991, 5, 13],
				           [1412, 0, 0, 1991, 6, 13],
				           [1412, 1, 0, 1991, 7, 11],
				           [1412, 2, 0, 1991, 8, 10],
				           [1412, 3, 0, 1991, 9, 9],
				           [1412, 4, 0, 1991, 10, 8],
				           [1412, 5, 0, 1991, 11, 7],
				           [1412, 6, 0, 1992, 0, 6],
				           [1412, 7, 0, 1992, 1, 5],
				           [1412, 8, 0, 1992, 2, 6],
				           [1412, 9, 0, 1992, 3, 4],
				           [1412, 10, 0, 1992, 4, 4],
				           [1412, 11, 0, 1992, 5, 2],
				           [1413, 0, 0, 1992, 6, 1],
				           [1413, 1, 0, 1992, 6, 31],
				           [1413, 2, 0, 1992, 7, 29],
				           [1413, 3, 0, 1992, 8, 28],
				           [1413, 4, 0, 1992, 9, 27],
				           [1413, 5, 0, 1992, 10, 25],
				           [1413, 6, 0, 1992, 11, 25],
				           [1413, 7, 0, 1993, 0, 24],
				           [1413, 8, 0, 1993, 1, 22],
				           [1413, 9, 0, 1993, 2, 24],
				           [1413, 10, 0, 1993, 3, 23],
				           [1413, 11, 0, 1993, 4, 22],
				           [1414, 0, 0, 1993, 5, 21],
				           [1414, 1, 0, 1993, 6, 21],
				           [1414, 2, 0, 1993, 7, 19],
				           [1414, 3, 0, 1993, 8, 17],
				           [1414, 4, 0, 1993, 9, 17],
				           [1414, 5, 0, 1993, 10, 15],
				           [1414, 6, 0, 1993, 11, 14],
				           [1414, 7, 0, 1994, 0, 13],
				           [1414, 8, 0, 1994, 1, 12],
				           [1414, 9, 0, 1994, 2, 13],
				           [1414, 10, 0, 1994, 3, 12],
				           [1414, 11, 0, 1994, 4, 12],
				           [1415, 0, 0, 1994, 5, 10],
				           [1415, 1, 0, 1994, 6, 10],
				           [1415, 2, 0, 1994, 7, 9],
				           [1415, 3, 0, 1994, 8, 7],
				           [1415, 4, 0, 1994, 9, 6],
				           [1415, 5, 0, 1994, 10, 5],
				           [1415, 6, 0, 1994, 11, 4],
				           [1415, 7, 0, 1995, 0, 2],
				           [1415, 8, 0, 1995, 1, 1],
				           [1415, 9, 0, 1995, 2, 2],
				           [1415, 10, 0, 1995, 3, 1],
				           [1415, 11, 0, 1995, 4, 1],
				           [1416, 0, 0, 1995, 4, 30],
				           [1416, 1, 0, 1995, 5, 29],
				           [1416, 2, 0, 1995, 6, 29],
				           [1416, 3, 0, 1995, 7, 27],
				           [1416, 4, 0, 1995, 8, 26],
				           [1416, 5, 0, 1995, 9, 25],
				           [1416, 6, 0, 1995, 10, 24],
				           [1416, 7, 0, 1995, 11, 23],
				           [1416, 8, 0, 1996, 0, 21],
				           [1416, 9, 0, 1996, 1, 20],
				           [1416, 10, 0, 1996, 2, 20],
				           [1416, 11, 0, 1996, 3, 19],
				           [1417, 0, 0, 1996, 4, 18],
				           [1417, 1, 0, 1996, 5, 17],
				           [1417, 2, 0, 1996, 6, 17],
				           [1417, 3, 0, 1996, 7, 16],
				           [1417, 4, 0, 1996, 8, 14],
				           [1417, 5, 0, 1996, 9, 13],
				           [1417, 6, 0, 1996, 10, 12],
				           [1417, 7, 0, 1996, 11, 12],
				           [1417, 8, 0, 1997, 0, 10],
				           [1417, 9, 0, 1997, 1, 9],
				           [1417, 10, 0, 1997, 2, 10],
				           [1417, 11, 0, 1997, 3, 8],
				           [1418, 0, 0, 1997, 4, 8],
				           [1418, 1, 0, 1997, 5, 6],
				           [1418, 2, 0, 1997, 6, 6],
				           [1418, 3, 0, 1997, 7, 5],
				           [1418, 4, 0, 1997, 8, 3],
				           [1418, 5, 0, 1997, 9, 3],
				           [1418, 6, 0, 1997, 10, 1],
				           [1418, 7, 0, 1997, 11, 1],
				           [1418, 8, 0, 1997, 11, 31],
				           [1418, 9, 0, 1998, 0, 29],
				           [1418, 10, 0, 1998, 1, 28],
				           [1418, 11, 0, 1998, 2, 29],
				           [1419, 0, 0, 1998, 3, 27],
				           [1419, 1, 0, 1998, 4, 27],
				           [1419, 2, 0, 1998, 5, 25],
				           [1419, 3, 0, 1998, 6, 25],
				           [1419, 4, 0, 1998, 7, 23],
				           [1419, 5, 0, 1998, 8, 22],
				           [1419, 6, 0, 1998, 9, 21],
				           [1419, 7, 0, 1998, 10, 20],
				           [1419, 8, 0, 1998, 11, 20],
				           [1419, 9, 0, 1999, 0, 19],
				           [1419, 10, 0, 1999, 1, 17],
				           [1419, 11, 0, 1999, 2, 19],
				           [1420, 0, 0, 1999, 3, 17],
				           [1420, 1, 0, 1999, 4, 16],
				           [1420, 2, 0, 1999, 5, 15],
				           [1420, 3, 0, 1999, 6, 14],
				           [1420, 4, 0, 1999, 7, 12],
				           [1420, 5, 0, 1999, 8, 11],
				           [1420, 6, 0, 1999, 9, 10],
				           [1420, 7, 0, 1999, 10, 9],
				           [1420, 8, 0, 1999, 11, 9],
				           [1420, 9, 0, 2000, 0, 8],
				           [1420, 10, 0, 2000, 1, 7],
				           [1420, 11, 0, 2000, 2, 7],
				           [1421, 0, 0, 2000, 3, 6],
				           [1421, 1, 0, 2000, 4, 5],
				           [1421, 2, 0, 2000, 5, 3],
				           [1421, 3, 0, 2000, 6, 3],
				           [1421, 4, 0, 2000, 7, 1],
				           [1421, 5, 0, 2000, 7, 30],
				           [1421, 6, 0, 2000, 8, 28],
				           [1421, 7, 0, 2000, 9, 28],
				           [1421, 8, 0, 2000, 10, 27],
				           [1421, 9, 0, 2000, 11, 27],
				           [1421, 10, 0, 2001, 0, 26],
				           [1421, 11, 0, 2001, 1, 24],
				           [1422, 0, 0, 2001, 2, 26],
				           [1422, 1, 0, 2001, 3, 25],
				           [1422, 2, 0, 2001, 4, 24],
				           [1422, 3, 0, 2001, 5, 22],
				           [1422, 4, 0, 2001, 6, 22],
				           [1422, 5, 0, 2001, 7, 20],
				           [1422, 6, 0, 2001, 8, 18],
				           [1422, 7, 0, 2001, 9, 17],
				           [1422, 8, 0, 2001, 10, 16],
				           [1422, 9, 0, 2001, 11, 16],
				           [1422, 10, 0, 2002, 0, 15],
				           [1422, 11, 0, 2002, 1, 13],
				           [1423, 0, 0, 2002, 2, 15],
				           [1423, 1, 0, 2002, 3, 14],
				           [1423, 2, 0, 2002, 4, 13],
				           [1423, 3, 0, 2002, 5, 12],
				           [1423, 4, 0, 2002, 6, 11],
				           [1423, 5, 0, 2002, 7, 10],
				           [1423, 6, 0, 2002, 8, 8],
				           [1423, 7, 0, 2002, 9, 7],
				           [1423, 8, 0, 2002, 10, 6],
				           [1423, 9, 0, 2002, 11, 5],
				           [1423, 10, 0, 2003, 0, 4],
				           [1423, 11, 0, 2003, 1, 2],
				           [1424, 0, 0, 2003, 2, 4],
				           [1424, 1, 0, 2003, 3, 3],
				           [1424, 2, 0, 2003, 4, 2],
				           [1424, 3, 0, 2003, 5, 1],
				           [1424, 4, 0, 2003, 6, 1],
				           [1424, 5, 0, 2003, 6, 30],
				           [1424, 6, 0, 2003, 7, 29],
				           [1424, 7, 0, 2003, 8, 27],
				           [1424, 8, 0, 2003, 9, 26],
				           [1424, 9, 0, 2003, 10, 25],
				           [1424, 10, 0, 2003, 11, 24],
				           [1424, 11, 0, 2004, 0, 23],
				           [1425, 0, 0, 2004, 1, 21],
				           [1425, 1, 0, 2004, 2, 22],
				           [1425, 2, 0, 2004, 3, 20],
				           [1425, 3, 0, 2004, 4, 20],
				           [1425, 4, 0, 2004, 5, 19],
				           [1425, 5, 0, 2004, 6, 18],
				           [1425, 6, 0, 2004, 7, 17],
				           [1425, 7, 0, 2004, 8, 15],
				           [1425, 8, 0, 2004, 9, 15],
				           [1425, 9, 0, 2004, 10, 14],
				           [1425, 10, 0, 2004, 11, 13],
				           [1425, 11, 0, 2005, 0, 12],
				           [1426, 0, 0, 2005, 1, 10],
				           [1426, 1, 0, 2005, 2, 11],
				           [1426, 2, 0, 2005, 3, 10],
				           [1426, 3, 0, 2005, 4, 9],
				           [1426, 4, 0, 2005, 5, 8],
				           [1426, 5, 0, 2005, 6, 7],
				           [1426, 6, 0, 2005, 7, 6],
				           [1426, 7, 0, 2005, 8, 5],
				           [1426, 8, 0, 2005, 9, 4],
				           [1426, 9, 0, 2005, 10, 3],
				           [1426, 10, 0, 2005, 11, 3],
				           [1426, 11, 0, 2006, 0, 1],
				           [1427, 0, 0, 2006, 0, 31],
				           [1427, 1, 0, 2006, 2, 1],
				           [1427, 2, 0, 2006, 2, 30],
				           [1427, 3, 0, 2006, 3, 29],
				           [1427, 4, 0, 2006, 4, 28],
				           [1427, 5, 0, 2006, 5, 27],
				           [1427, 6, 0, 2006, 6, 26],
				           [1427, 7, 0, 2006, 7, 25],
				           [1427, 8, 0, 2006, 8, 24],
				           [1427, 9, 0, 2006, 9, 23],
				           [1427, 10, 0, 2006, 10, 22],
				           [1427, 11, 0, 2006, 11, 22],
				           [1428, 0, 0, 2007, 0, 20],
				           [1428, 1, 0, 2007, 1, 19],
				           [1428, 2, 0, 2007, 2, 20],
				           [1428, 3, 0, 2007, 3, 18],
				           [1428, 4, 0, 2007, 4, 18],
				           [1428, 5, 0, 2007, 5, 16],
				           [1428, 6, 0, 2007, 6, 15],
				           [1428, 7, 0, 2007, 7, 14],
				           [1428, 8, 0, 2007, 8, 13],
				           [1428, 9, 0, 2007, 9, 13],
				           [1428, 10, 0, 2007, 10, 11],
				           [1428, 11, 0, 2007, 11, 11],
				           [1429, 0, 0, 2008, 0, 10],
				           [1429, 1, 0, 2008, 1, 8],
				           [1429, 2, 0, 2008, 2, 9],
				           [1429, 3, 0, 2008, 3, 7],
				           [1429, 4, 0, 2008, 4, 6],
				           [1429, 5, 0, 2008, 5, 5],
				           [1429, 6, 0, 2008, 6, 4],
				           [1429, 7, 0, 2008, 7, 2],
				           [1429, 8, 0, 2008, 8, 1],
				           [1429, 9, 0, 2008, 9, 1],
				           [1429, 10, 0, 2008, 9, 30],
				           [1429, 11, 0, 2008, 10, 29],
				           [1430, 0, 0, 2008, 11, 29],
				           [1430, 1, 0, 2009, 0, 27],
				           [1430, 2, 0, 2009, 1, 26],
				           [1430, 3, 0, 2009, 2, 28],
				           [1430, 4, 0, 2009, 3, 26],
				           [1430, 5, 0, 2009, 4, 25],
				           [1430, 6, 0, 2009, 5, 24],
				           [1430, 7, 0, 2009, 6, 23],
				           [1430, 8, 0, 2009, 7, 22],
				           [1430, 9, 0, 2009, 8, 20],
				           [1430, 10, 0, 2009, 9, 20],
				           [1430, 11, 0, 2009, 10, 18],
				           [1431, 0, 0, 2009, 11, 18],
				           [1431, 1, 0, 2010, 0, 16],
				           [1431, 2, 0, 2010, 1, 15],
				           [1431, 3, 0, 2010, 2, 17],
				           [1431, 4, 0, 2010, 3, 15],
				           [1431, 5, 0, 2010, 4, 15],
				           [1431, 6, 0, 2010, 5, 13],
				           [1431, 7, 0, 2010, 6, 13],
				           [1431, 8, 0, 2010, 7, 11],
				           [1431, 9, 0, 2010, 8, 10],
				           [1431, 10, 0, 2010, 9, 9],
				           [1431, 11, 0, 2010, 10, 7],
				           [1432, 0, 0, 2010, 11, 7],
				           [1432, 1, 0, 2011, 0, 5],
				           [1432, 2, 0, 2011, 1, 4],
				           [1432, 3, 0, 2011, 2, 6],
				           [1432, 4, 0, 2011, 3, 5],
				           [1432, 5, 0, 2011, 4, 4],
				           [1432, 6, 0, 2011, 5, 3],
				           [1432, 7, 0, 2011, 6, 2],
				           [1432, 8, 0, 2011, 7, 1],
				           [1432, 9, 0, 2011, 7, 30],
				           [1432, 10, 0, 2011, 8, 29],
				           [1432, 11, 0, 2011, 9, 28],
				           [1433, 0, 0, 2011, 10, 26],
				           [1433, 1, 0, 2011, 11, 26],
				           [1433, 2, 0, 2012, 0, 24],
				           [1433, 3, 0, 2012, 1, 23],
				           [1433, 4, 0, 2012, 2, 24],
				           [1433, 5, 0, 2012, 3, 22],
				           [1433, 6, 0, 2012, 4, 22],
				           [1433, 7, 0, 2012, 5, 21],
				           [1433, 8, 0, 2012, 6, 20],
				           [1433, 9, 0, 2012, 7, 19],
				           [1433, 10, 0, 2012, 8, 17],
				           [1433, 11, 0, 2012, 9, 17],
				           [1434, 0, 0, 2012, 10, 15],
				           [1434, 1, 0, 2012, 11, 14],
				           [1434, 2, 0, 2013, 0, 13],
				           [1434, 3, 0, 2013, 1, 11],
				           [1434, 4, 0, 2013, 2, 13],
				           [1434, 5, 0, 2013, 3, 11],
				           [1434, 6, 0, 2013, 4, 11],
				           [1434, 7, 0, 2013, 5, 10],
				           [1434, 8, 0, 2013, 6, 9],
				           [1434, 9, 0, 2013, 7, 8],
				           [1434, 10, 0, 2013, 8, 7],
				           [1434, 11, 0, 2013, 9, 6],
				           [1435, 0, 0, 2013, 10, 4],
				           [1435, 1, 0, 2013, 11, 4],
				           [1435, 2, 0, 2014, 0, 2],
				           [1435, 3, 0, 2014, 1, 1],
				           [1435, 4, 0, 2014, 2, 2],
				           [1435, 5, 0, 2014, 3, 1],
				           [1435, 6, 0, 2014, 3, 30],
				           [1435, 7, 0, 2014, 4, 30],
				           [1435, 8, 0, 2014, 5, 28],
				           [1435, 9, 0, 2014, 6, 28],
				           [1435, 10, 0, 2014, 7, 27],
				           [1435, 11, 0, 2014, 8, 25],
				           [1436, 0, 0, 2014, 9, 25],
				           [1436, 1, 0, 2014, 10, 23],
				           [1436, 2, 0, 2014, 11, 23],
				           [1436, 3, 0, 2015, 0, 21],
				           [1436, 4, 0, 2015, 1, 20],
				           [1436, 5, 0, 2015, 2, 21],
				           [1436, 6, 0, 2015, 3, 20],
				           [1436, 7, 0, 2015, 4, 19],
				           [1436, 8, 0, 2015, 5, 18],
				           [1436, 9, 0, 2015, 6, 17],
				           [1436, 10, 0, 2015, 7, 16],
				           [1436, 11, 0, 2015, 8, 14],
				           [1437, 0, 0, 2015, 9, 14],
				           [1437, 1, 0, 2015, 10, 13],
				           [1437, 2, 0, 2015, 11, 12],
				           [1437, 3, 0, 2016, 0, 11],
				           [1437, 4, 0, 2016, 1, 10],
				           [1437, 5, 0, 2016, 2, 10],
				           [1437, 6, 0, 2016, 3, 8],
				           [1437, 7, 0, 2016, 4, 8],
				           [1437, 8, 0, 2016, 5, 6],
				           [1437, 9, 0, 2016, 6, 6],
				           [1437, 10, 0, 2016, 7, 4],
				           [1437, 11, 0, 2016, 8, 2],
				           [1438, 0, 0, 2016, 9, 2],
				           [1438, 1, 0, 2016, 10, 1],
				           [1438, 2, 0, 2016, 10, 30],
				           [1438, 3, 0, 2016, 11, 30],
				           [1438, 4, 0, 2017, 0, 29],
				           [1438, 5, 0, 2017, 1, 28],
				           [1438, 6, 0, 2017, 2, 29],
				           [1438, 7, 0, 2017, 3, 27],
				           [1438, 8, 0, 2017, 4, 27],
				           [1438, 9, 0, 2017, 5, 25],
				           [1438, 10, 0, 2017, 6, 24],
				           [1438, 11, 0, 2017, 7, 23],
				           [1439, 0, 0, 2017, 8, 21],
				           [1439, 1, 0, 2017, 9, 21],
				           [1439, 2, 0, 2017, 10, 19],
				           [1439, 3, 0, 2017, 11, 19],
				           [1439, 4, 0, 2018, 0, 18],
				           [1439, 5, 0, 2018, 1, 17],
				           [1439, 6, 0, 2018, 2, 18],
				           [1439, 7, 0, 2018, 3, 17],
				           [1439, 8, 0, 2018, 4, 16],
				           [1439, 9, 0, 2018, 5, 15],
				           [1439, 10, 0, 2018, 6, 14],
				           [1439, 11, 0, 2018, 7, 12],
				           [1440, 0, 0, 2018, 8, 11],
				           [1440, 1, 0, 2018, 9, 10],
				           [1440, 2, 0, 2018, 10, 9],
				           [1440, 3, 0, 2018, 11, 8],
				           [1440, 4, 0, 2019, 0, 7],
				           [1440, 5, 0, 2019, 1, 6],
				           [1440, 6, 0, 2019, 2, 8],
				           [1440, 7, 0, 2019, 3, 6],
				           [1440, 8, 0, 2019, 4, 6],
				           [1440, 9, 0, 2019, 5, 4],
				           [1440, 10, 0, 2019, 6, 4],
				           [1440, 11, 0, 2019, 7, 2],
				           [1441, 0, 0, 2019, 7, 31],
				           [1441, 1, 0, 2019, 8, 30],
				           [1441, 2, 0, 2019, 9, 29],
				           [1441, 3, 0, 2019, 10, 28],
				           [1441, 4, 0, 2019, 11, 27],
				           [1441, 5, 0, 2020, 0, 26],
				           [1441, 6, 0, 2020, 1, 25],
				           [1441, 7, 0, 2020, 2, 25],
				           [1441, 8, 0, 2020, 3, 24],
				           [1441, 9, 0, 2020, 4, 24],
				           [1441, 10, 0, 2020, 5, 22],
				           [1441, 11, 0, 2020, 6, 22],
				           [1442, 0, 0, 2020, 7, 20],
				           [1442, 1, 0, 2020, 8, 18],
				           [1442, 2, 0, 2020, 9, 18],
				           [1442, 3, 0, 2020, 10, 16],
				           [1442, 4, 0, 2020, 11, 16],
				           [1442, 5, 0, 2021, 0, 14],
				           [1442, 6, 0, 2021, 1, 13],
				           [1442, 7, 0, 2021, 2, 14],
				           [1442, 8, 0, 2021, 3, 13],
				           [1442, 9, 0, 2021, 4, 13],
				           [1442, 10, 0, 2021, 5, 11],
				           [1442, 11, 0, 2021, 6, 11],
				           [1443, 0, 0, 2021, 7, 9],
				           [1443, 1, 0, 2021, 8, 8],
				           [1443, 2, 0, 2021, 9, 7],
				           [1443, 3, 0, 2021, 10, 6],
				           [1443, 4, 0, 2021, 11, 5],
				           [1443, 5, 0, 2022, 0, 4],
				           [1443, 6, 0, 2022, 1, 2],
				           [1443, 7, 0, 2022, 2, 4],
				           [1443, 8, 0, 2022, 3, 2],
				           [1443, 9, 0, 2022, 4, 2],
				           [1443, 10, 0, 2022, 4, 31],
				           [1443, 11, 0, 2022, 5, 30],
				           [1444, 0, 0, 2022, 6, 30],
				           [1444, 1, 0, 2022, 7, 28],
				           [1444, 2, 0, 2022, 8, 27],
				           [1444, 3, 0, 2022, 9, 26],
				           [1444, 4, 0, 2022, 10, 25],
				           [1444, 5, 0, 2022, 11, 25],
				           [1444, 6, 0, 2023, 0, 23],
				           [1444, 7, 0, 2023, 1, 21],
				           [1444, 8, 0, 2023, 2, 23],
				           [1444, 9, 0, 2023, 3, 21],
				           [1444, 10, 0, 2023, 4, 21],
				           [1444, 11, 0, 2023, 5, 19],
				           [1445, 0, 0, 2023, 6, 19],
				           [1445, 1, 0, 2023, 7, 17],
				           [1445, 2, 0, 2023, 8, 16],
				           [1445, 3, 0, 2023, 9, 16],
				           [1445, 4, 0, 2023, 10, 15],
				           [1445, 5, 0, 2023, 11, 14],
				           [1445, 6, 0, 2024, 0, 13],
				           [1445, 7, 0, 2024, 1, 11],
				           [1445, 8, 0, 2024, 2, 11],
				           [1445, 9, 0, 2024, 3, 10],
				           [1445, 10, 0, 2024, 4, 9],
				           [1445, 11, 0, 2024, 5, 7],
				           [1446, 0, 0, 2024, 6, 7],
				           [1446, 1, 0, 2024, 7, 5],
				           [1446, 2, 0, 2024, 8, 4],
				           [1446, 3, 0, 2024, 9, 4],
				           [1446, 4, 0, 2024, 10, 3],
				           [1446, 5, 0, 2024, 11, 2],
				           [1446, 6, 0, 2025, 0, 1],
				           [1446, 7, 0, 2025, 0, 31],
				           [1446, 8, 0, 2025, 2, 1],
				           [1446, 9, 0, 2025, 2, 30],
				           [1446, 10, 0, 2025, 3, 29],
				           [1446, 11, 0, 2025, 4, 28],
				           [1447, 0, 0, 2025, 5, 26],
				           [1447, 1, 0, 2025, 6, 26],
				           [1447, 2, 0, 2025, 7, 24],
				           [1447, 3, 0, 2025, 8, 23],
				           [1447, 4, 0, 2025, 9, 23],
				           [1447, 5, 0, 2025, 10, 22],
				           [1447, 6, 0, 2025, 11, 21],
				           [1447, 7, 0, 2026, 0, 20],
				           [1447, 8, 0, 2026, 1, 18],
				           [1447, 9, 0, 2026, 2, 20],
				           [1447, 10, 0, 2026, 3, 18],
				           [1447, 11, 0, 2026, 4, 18],
				           [1448, 0, 0, 2026, 5, 16],
				           [1448, 1, 0, 2026, 6, 15],
				           [1448, 2, 0, 2026, 7, 14],
				           [1448, 3, 0, 2026, 8, 12],
				           [1448, 4, 0, 2026, 9, 12],
				           [1448, 5, 0, 2026, 10, 11],
				           [1448, 6, 0, 2026, 11, 10],
				           [1448, 7, 0, 2027, 0, 9],
				           [1448, 8, 0, 2027, 1, 8],
				           [1448, 9, 0, 2027, 2, 9],
				           [1448, 10, 0, 2027, 3, 8],
				           [1448, 11, 0, 2027, 4, 7],
				           [1449, 0, 0, 2027, 5, 6],
				           [1449, 1, 0, 2027, 6, 5],
				           [1449, 2, 0, 2027, 7, 3],
				           [1449, 3, 0, 2027, 8, 2],
				           [1449, 4, 0, 2027, 9, 1],
				           [1449, 5, 0, 2027, 9, 31],
				           [1449, 6, 0, 2027, 10, 29],
				           [1449, 7, 0, 2027, 11, 29],
				           [1449, 8, 0, 2028, 0, 28],
				           [1449, 9, 0, 2028, 1, 26],
				           [1449, 10, 0, 2028, 2, 27],
				           [1449, 11, 0, 2028, 3, 26],
				           [1450, 0, 0, 2028, 4, 25],
				           [1450, 1, 0, 2028, 5, 24],
				           [1450, 2, 0, 2028, 6, 23],
				           [1450, 3, 0, 2028, 7, 22],
				           [1450, 4, 0, 2028, 8, 20],
				           [1450, 5, 0, 2028, 9, 19],
				           [1450, 6, 0, 2028, 10, 18],
				           [1450, 7, 0, 2028, 11, 17],
				           [1450, 8, 0, 2029, 0, 16],
				           [1450, 9, 0, 2029, 1, 14],
				           [1450, 10, 0, 2029, 2, 16],
				           [1450, 11, 0, 2029, 3, 15],
				           [1451, 0, 0, 2029, 4, 14],
				           [1451, 1, 0, 2029, 5, 13],
				           [1451, 2, 0, 2029, 6, 13],
				           [1451, 3, 0, 2029, 7, 11],
				           [1451, 4, 0, 2029, 8, 10],
				           [1451, 5, 0, 2029, 9, 9],
				           [1451, 6, 0, 2029, 10, 7],
				           [1451, 7, 0, 2029, 11, 7],
				           [1451, 8, 0, 2030, 0, 5],
				           [1451, 9, 0, 2030, 1, 4],
				           [1451, 10, 0, 2030, 2, 5],
				           [1451, 11, 0, 2030, 3, 4],
				           [1452, 0, 0, 2030, 4, 3],
				           [1452, 1, 0, 2030, 5, 2],
				           [1452, 2, 0, 2030, 6, 2],
				           [1452, 3, 0, 2030, 7, 1],
				           [1452, 4, 0, 2030, 7, 30],
				           [1452, 5, 0, 2030, 8, 29],
				           [1452, 6, 0, 2030, 9, 28],
				           [1452, 7, 0, 2030, 10, 26],
				           [1452, 8, 0, 2030, 11, 26],
				           [1452, 9, 0, 2031, 0, 24],
				           [1452, 10, 0, 2031, 1, 23],
				           [1452, 11, 0, 2031, 2, 24],
				           [1453, 0, 0, 2031, 3, 23],
				           [1453, 1, 0, 2031, 4, 22],
				           [1453, 2, 0, 2031, 5, 21],
				           [1453, 3, 0, 2031, 6, 21],
				           [1453, 4, 0, 2031, 7, 20],
				           [1453, 5, 0, 2031, 8, 18],
				           [1453, 6, 0, 2031, 9, 17],
				           [1453, 7, 0, 2031, 10, 16],
				           [1453, 8, 0, 2031, 11, 15],
				           [1453, 9, 0, 2032, 0, 14],
				           [1453, 10, 0, 2032, 1, 12],
				           [1453, 11, 0, 2032, 2, 13],
				           [1454, 0, 0, 2032, 3, 11],
				           [1454, 1, 0, 2032, 4, 10],
				           [1454, 2, 0, 2032, 5, 9],
				           [1454, 3, 0, 2032, 6, 9],
				           [1454, 4, 0, 2032, 7, 8],
				           [1454, 5, 0, 2032, 8, 6],
				           [1454, 6, 0, 2032, 9, 6],
				           [1454, 7, 0, 2032, 10, 4],
				           [1454, 8, 0, 2032, 11, 4],
				           [1454, 9, 0, 2033, 0, 2],
				           [1454, 10, 0, 2033, 1, 1],
				           [1454, 11, 0, 2033, 2, 2],
				           [1455, 0, 0, 2033, 3, 1],
				           [1455, 1, 0, 2033, 3, 30],
				           [1455, 2, 0, 2033, 4, 29],
				           [1455, 3, 0, 2033, 5, 28],
				           [1455, 4, 0, 2033, 6, 28],
				           [1455, 5, 0, 2033, 7, 26],
				           [1455, 6, 0, 2033, 8, 25],
				           [1455, 7, 0, 2033, 9, 24],
				           [1455, 8, 0, 2033, 10, 23],
				           [1455, 9, 0, 2033, 11, 23],
				           [1455, 10, 0, 2034, 0, 21],
				           [1455, 11, 0, 2034, 1, 20],
				           [1456, 0, 0, 2034, 2, 21],
				           [1456, 1, 0, 2034, 3, 20],
				           [1456, 2, 0, 2034, 4, 19],
				           [1456, 3, 0, 2034, 5, 17],
				           [1456, 4, 0, 2034, 6, 17],
				           [1456, 5, 0, 2034, 7, 15],
				           [1456, 6, 0, 2034, 8, 14],
				           [1456, 7, 0, 2034, 9, 13],
				           [1456, 8, 0, 2034, 10, 12],
				           [1456, 9, 0, 2034, 11, 12],
				           [1456, 10, 0, 2035, 0, 11],
				           [1456, 11, 0, 2035, 1, 9],
				           [1457, 0, 0, 2035, 2, 11],
				           [1457, 1, 0, 2035, 3, 9],
				           [1457, 2, 0, 2035, 4, 9],
				           [1457, 3, 0, 2035, 5, 7],
				           [1457, 4, 0, 2035, 6, 6],
				           [1457, 5, 0, 2035, 7, 5],
				           [1457, 6, 0, 2035, 8, 3],
				           [1457, 7, 0, 2035, 9, 2],
				           [1457, 8, 0, 2035, 10, 1],
				           [1457, 9, 0, 2035, 11, 1],
				           [1457, 10, 0, 2035, 11, 30],
				           [1457, 11, 0, 2036, 0, 29],
				           [1458, 0, 0, 2036, 1, 28],
				           [1458, 1, 0, 2036, 2, 29],
				           [1458, 2, 0, 2036, 3, 27],
				           [1458, 3, 0, 2036, 4, 27],
				           [1458, 4, 0, 2036, 5, 25],
				           [1458, 5, 0, 2036, 6, 24],
				           [1458, 6, 0, 2036, 7, 23],
				           [1458, 7, 0, 2036, 8, 21],
				           [1458, 8, 0, 2036, 9, 20],
				           [1458, 9, 0, 2036, 10, 19],
				           [1458, 10, 0, 2036, 11, 19],
				           [1458, 11, 0, 2037, 0, 17],
				           [1459, 0, 0, 2037, 1, 16],
				           [1459, 1, 0, 2037, 2, 18],
				           [1459, 2, 0, 2037, 3, 17],
				           [1459, 3, 0, 2037, 4, 16],
				           [1459, 4, 0, 2037, 5, 15],
				           [1459, 5, 0, 2037, 6, 14],
				           [1459, 6, 0, 2037, 7, 12],
				           [1459, 7, 0, 2037, 8, 11],
				           [1459, 8, 0, 2037, 9, 10],
				           [1459, 9, 0, 2037, 10, 8],
				           [1459, 10, 0, 2037, 11, 8],
				           [1459, 11, 0, 2038, 0, 7],
				           [1460, 0, 0, 2038, 1, 5],
				           [1460, 1, 0, 2038, 2, 7],
				           [1460, 2, 0, 2038, 3, 6],
				           [1460, 3, 0, 2038, 4, 5],
				           [1460, 4, 0, 2038, 5, 4],
				           [1460, 5, 0, 2038, 6, 3],
				           [1460, 6, 0, 2038, 7, 2],
				           [1460, 7, 0, 2038, 7, 31],
				           [1460, 8, 0, 2038, 8, 30],
				           [1460, 9, 0, 2038, 9, 29],
				           [1460, 10, 0, 2038, 10, 27],
				           [1460, 11, 0, 2038, 11, 27],
				           [1461, 0, 0, 2039, 0, 26],
				           [1461, 1, 0, 2039, 1, 24],
				           [1461, 2, 0, 2039, 2, 26],
				           [1461, 3, 0, 2039, 3, 24],
				           [1461, 4, 0, 2039, 4, 24],
				           [1461, 5, 0, 2039, 5, 23],
				           [1461, 6, 0, 2039, 6, 22],
				           [1461, 7, 0, 2039, 7, 21],
				           [1461, 8, 0, 2039, 8, 19],
				           [1461, 9, 0, 2039, 9, 19],
				           [1461, 10, 0, 2039, 10, 17],
				           [1461, 11, 0, 2039, 11, 17],
				           [1462, 0, 0, 2040, 0, 15],
				           [1462, 1, 0, 2040, 1, 14],
				           [1462, 2, 0, 2040, 2, 14],
				           [1462, 3, 0, 2040, 3, 13],
				           [1462, 4, 0, 2040, 4, 12],
				           [1462, 5, 0, 2040, 5, 11],
				           [1462, 6, 0, 2040, 6, 10],
				           [1462, 7, 0, 2040, 7, 9],
				           [1462, 8, 0, 2040, 8, 7],
				           [1462, 9, 0, 2040, 9, 7],
				           [1462, 10, 0, 2040, 10, 6],
				           [1462, 11, 0, 2040, 11, 5],
				           [1463, 0, 0, 2041, 0, 4],
				           [1463, 1, 0, 2041, 1, 2],
				           [1463, 2, 0, 2041, 2, 4],
				           [1463, 3, 0, 2041, 3, 2],
				           [1463, 4, 0, 2041, 4, 1],
				           [1463, 5, 0, 2041, 4, 31],
				           [1463, 6, 0, 2041, 5, 29],
				           [1463, 7, 0, 2041, 6, 29],
				           [1463, 8, 0, 2041, 7, 28],
				           [1463, 9, 0, 2041, 8, 26],
				           [1463, 10, 0, 2041, 9, 26],
				           [1463, 11, 0, 2041, 10, 25],
				           [1464, 0, 0, 2041, 11, 24],
				           [1464, 1, 0, 2042, 0, 23],
				           [1464, 2, 0, 2042, 1, 21],
				           [1464, 3, 0, 2042, 2, 23],
				           [1464, 4, 0, 2042, 3, 21],
				           [1464, 5, 0, 2042, 4, 20],
				           [1464, 6, 0, 2042, 5, 19],
				           [1464, 7, 0, 2042, 6, 18],
				           [1464, 8, 0, 2042, 7, 17],
				           [1464, 9, 0, 2042, 8, 15],
				           [1464, 10, 0, 2042, 9, 15],
				           [1464, 11, 0, 2042, 10, 14],
				           [1465, 0, 0, 2042, 11, 14],
				           [1465, 1, 0, 2043, 0, 12],
				           [1465, 2, 0, 2043, 1, 11],
				           [1465, 3, 0, 2043, 2, 12],
				           [1465, 4, 0, 2043, 3, 11],
				           [1465, 5, 0, 2043, 4, 10],
				           [1465, 6, 0, 2043, 5, 8],
				           [1465, 7, 0, 2043, 6, 8],
				           [1465, 8, 0, 2043, 7, 6],
				           [1465, 9, 0, 2043, 8, 4],
				           [1465, 10, 0, 2043, 9, 4],
				           [1465, 11, 0, 2043, 10, 3],
				           [1466, 0, 0, 2043, 11, 3],
				           [1466, 1, 0, 2044, 0, 2],
				           [1466, 2, 0, 2044, 0, 31],
				           [1466, 3, 0, 2044, 2, 1],
				           [1466, 4, 0, 2044, 2, 30],
				           [1466, 5, 0, 2044, 3, 29],
				           [1466, 6, 0, 2044, 4, 28],
				           [1466, 7, 0, 2044, 5, 26],
				           [1466, 8, 0, 2044, 6, 26],
				           [1466, 9, 0, 2044, 7, 24],
				           [1466, 10, 0, 2044, 8, 23],
				           [1466, 11, 0, 2044, 9, 22],
				           [1467, 0, 0, 2044, 10, 21],
				           [1467, 1, 0, 2044, 11, 21],
				           [1467, 2, 0, 2045, 0, 19],
				           [1467, 3, 0, 2045, 1, 18],
				           [1467, 4, 0, 2045, 2, 20],
				           [1467, 5, 0, 2045, 3, 18],
				           [1467, 6, 0, 2045, 4, 18],
				           [1467, 7, 0, 2045, 5, 16],
				           [1467, 8, 0, 2045, 6, 15],
				           [1467, 9, 0, 2045, 7, 14],
				           [1467, 10, 0, 2045, 8, 12],
				           [1467, 11, 0, 2045, 9, 12],
				           [1468, 0, 0, 2045, 10, 10],
				           [1468, 1, 0, 2045, 11, 10],
				           [1468, 2, 0, 2046, 0, 8],
				           [1468, 3, 0, 2046, 1, 7],
				           [1468, 4, 0, 2046, 2, 9],
				           [1468, 5, 0, 2046, 3, 7],
				           [1468, 6, 0, 2046, 4, 7],
				           [1468, 7, 0, 2046, 5, 5],
				           [1468, 8, 0, 2046, 6, 5],
				           [1468, 9, 0, 2046, 7, 3],
				           [1468, 10, 0, 2046, 8, 2],
				           [1468, 11, 0, 2046, 9, 1],
				           [1469, 0, 0, 2046, 9, 31],
				           [1469, 1, 0, 2046, 10, 29],
				           [1469, 2, 0, 2046, 11, 28],
				           [1469, 3, 0, 2047, 0, 27],
				           [1469, 4, 0, 2047, 1, 26],
				           [1469, 5, 0, 2047, 2, 27],
				           [1469, 6, 0, 2047, 3, 26],
				           [1469, 7, 0, 2047, 4, 26],
				           [1469, 8, 0, 2047, 5, 24],
				           [1469, 9, 0, 2047, 6, 24],
				           [1469, 10, 0, 2047, 7, 23],
				           [1469, 11, 0, 2047, 8, 21],
				           [1470, 0, 0, 2047, 9, 20],
				           [1470, 1, 0, 2047, 10, 19],
				           [1470, 2, 0, 2047, 11, 18],
				           [1470, 3, 0, 2048, 0, 16],
				           [1470, 4, 0, 2048, 1, 15],
				           [1470, 5, 0, 2048, 2, 16],
				           [1470, 6, 0, 2048, 3, 14],
				           [1470, 7, 0, 2048, 4, 14],
				           [1470, 8, 0, 2048, 5, 12],
				           [1470, 9, 0, 2048, 6, 12],
				           [1470, 10, 0, 2048, 7, 11],
				           [1470, 11, 0, 2048, 8, 10],
				           [1471, 0, 0, 2048, 9, 9],
				           [1471, 1, 0, 2048, 10, 7],
				           [1471, 2, 0, 2048, 11, 7],
				           [1471, 3, 0, 2049, 0, 5],
				           [1471, 4, 0, 2049, 1, 3],
				           [1471, 5, 0, 2049, 2, 5],
				           [1471, 6, 0, 2049, 3, 3],
				           [1471, 7, 0, 2049, 4, 3],
				           [1471, 8, 0, 2049, 5, 2],
				           [1471, 9, 0, 2049, 6, 1],
				           [1471, 10, 0, 2049, 6, 31],
				           [1471, 11, 0, 2049, 7, 30],
				           [1472, 0, 0, 2049, 8, 28],
				           [1472, 1, 0, 2049, 9, 28],
				           [1472, 2, 0, 2049, 10, 26],
				           [1472, 3, 0, 2049, 11, 26],
				           [1472, 4, 0, 2050, 0, 24],
				           [1472, 5, 0, 2050, 1, 23],
				           [1472, 6, 0, 2050, 2, 24],
				           [1472, 7, 0, 2050, 3, 22],
				           [1472, 8, 0, 2050, 4, 22],
				           [1472, 9, 0, 2050, 5, 20],
				           [1472, 10, 0, 2050, 6, 20],
				           [1472, 11, 0, 2050, 7, 19],
				           [1473, 0, 0, 2050, 8, 17],
				           [1473, 1, 0, 2050, 9, 17],
				           [1473, 2, 0, 2050, 10, 15],
				           [1473, 3, 0, 2050, 11, 15],
				           [1473, 4, 0, 2051, 0, 14],
				           [1473, 5, 0, 2051, 1, 12],
				           [1473, 6, 0, 2051, 2, 14],
				           [1473, 7, 0, 2051, 3, 12],
				           [1473, 8, 0, 2051, 4, 11],
				           [1473, 9, 0, 2051, 5, 10],
				           [1473, 10, 0, 2051, 6, 9],
				           [1473, 11, 0, 2051, 7, 8],
				           [1474, 0, 0, 2051, 8, 6],
				           [1474, 1, 0, 2051, 9, 6],
				           [1474, 2, 0, 2051, 10, 5],
				           [1474, 3, 0, 2051, 11, 4],
				           [1474, 4, 0, 2052, 0, 3],
				           [1474, 5, 0, 2052, 1, 2],
				           [1474, 6, 0, 2052, 2, 2],
				           [1474, 7, 0, 2052, 3, 1],
				           [1474, 8, 0, 2052, 3, 30],
				           [1474, 9, 0, 2052, 4, 29],
				           [1474, 10, 0, 2052, 5, 28],
				           [1474, 11, 0, 2052, 6, 27],
				           [1475, 0, 0, 2052, 7, 26],
				           [1475, 1, 0, 2052, 8, 24],
				           [1475, 2, 0, 2052, 9, 24],
				           [1475, 3, 0, 2052, 10, 22],
				           [1475, 4, 0, 2052, 11, 22],
				           [1475, 5, 0, 2053, 0, 21],
				           [1475, 6, 0, 2053, 1, 20],
				           [1475, 7, 0, 2053, 2, 21],
				           [1475, 8, 0, 2053, 3, 20],
				           [1475, 9, 0, 2053, 4, 19],
				           [1475, 10, 0, 2053, 5, 17],
				           [1475, 11, 0, 2053, 6, 17],
				           [1476, 0, 0, 2053, 7, 15],
				           [1476, 1, 0, 2053, 8, 13],
				           [1476, 2, 0, 2053, 9, 13],
				           [1476, 3, 0, 2053, 10, 11],
				           [1476, 4, 0, 2053, 11, 11],
				           [1476, 5, 0, 2054, 0, 10],
				           [1476, 6, 0, 2054, 1, 9],
				           [1476, 7, 0, 2054, 2, 10],
				           [1476, 8, 0, 2054, 3, 9],
				           [1476, 9, 0, 2054, 4, 9],
				           [1476, 10, 0, 2054, 5, 7],
				           [1476, 11, 0, 2054, 6, 6],
				           [1477, 0, 0, 2054, 7, 5],
				           [1477, 1, 0, 2054, 8, 3],
				           [1477, 2, 0, 2054, 9, 2],
				           [1477, 3, 0, 2054, 10, 1],
				           [1477, 4, 0, 2054, 10, 30],
				           [1477, 5, 0, 2054, 11, 30],
				           [1477, 6, 0, 2055, 0, 29],
				           [1477, 7, 0, 2055, 1, 27],
				           [1477, 8, 0, 2055, 2, 29],
				           [1477, 9, 0, 2055, 3, 28],
				           [1477, 10, 0, 2055, 4, 28],
				           [1477, 11, 0, 2055, 5, 26],
				           [1478, 0, 0, 2055, 6, 25],
				           [1478, 1, 0, 2055, 7, 24],
				           [1478, 2, 0, 2055, 8, 22],
				           [1478, 3, 0, 2055, 9, 21],
				           [1478, 4, 0, 2055, 10, 20],
				           [1478, 5, 0, 2055, 11, 19],
				           [1478, 6, 0, 2056, 0, 18],
				           [1478, 7, 0, 2056, 1, 17],
				           [1478, 8, 0, 2056, 2, 17],
				           [1478, 9, 0, 2056, 3, 16],
				           [1478, 10, 0, 2056, 4, 16],
				           [1478, 11, 0, 2056, 5, 14],
				           [1479, 0, 0, 2056, 6, 14],
				           [1479, 1, 0, 2056, 7, 12],
				           [1479, 2, 0, 2056, 8, 11],
				           [1479, 3, 0, 2056, 9, 10],
				           [1479, 4, 0, 2056, 10, 8],
				           [1479, 5, 0, 2056, 11, 8],
				           [1479, 6, 0, 2057, 0, 6],
				           [1479, 7, 0, 2057, 1, 5],
				           [1479, 8, 0, 2057, 2, 6],
				           [1479, 9, 0, 2057, 3, 5],
				           [1479, 10, 0, 2057, 4, 5],
				           [1479, 11, 0, 2057, 5, 3],
				           [1480, 0, 1, 2057, 6, 3]
		        ];
		        var iDate;
		        var iDate2;
		        var diffDay, diffMonth, diffYear;
		        diffDay = 0;
		        diffMonth = 0;
		        diffYear = 0;
		        dojo.forEach(dates, function (d, i) {
		            if (d[2] == 0) {
		                d[2] = 1;
		            }

		            iDate = new dojox.date.umalqura.Date(d[0], d[1], d[2]);
		            t.is(iDate.getFullYear(), d[0]);
		            t.is(iDate.getDate(), d[2]);
		            iDate2 = new dojox.date.umalqura.Date(0, 0, 0);
		            iDate2.setFullYear(d[0]);
		            iDate2.setMonth(d[1]);
		            iDate2.setDate(d[2]);
		            diffDay = dojox.date.umalqura.difference(iDate, iDate2, "year");
		            diffMonth = dojox.date.umalqura.difference(iDate, iDate2, "month");
		            diffYear = dojox.date.umalqura.difference(iDate, iDate2, "day");
		        });


		        //Special Case #1
		        {
		            var iDate, iDate2, year, month, day;
		            year = 1202;
		            month = 1;
		            day = 29;
		            weekday = 1;
		            iDate = new dojox.date.umalqura.Date(year, month, day);
		            iDate.setFullYear(year);
		            iDate.setMonth(month);
		            iDate.setDate(day);

		            t.is(year, iDate.getFullYear());
		            t.is(month, iDate.getMonth());
		            t.is(day, iDate.getDate());
		        }
		        //Special Case #2
		        {
		            var iDate, iDate2, year, month, day;
		            year = 1202;
		            month = 1;
		            day = 29;
		            weekday = 1;
		            iDate = new dojox.date.umalqura.Date(year, month, day);
		            iDate.setFullYear(year);
		            iDate.setMonth(month);
		            iDate.setDate(day);

		            t.is(year, iDate.getFullYear());
		            t.is(month, iDate.getMonth());
		            t.is(day, iDate.getDate());
		        }
		        //Special Case #3
		        {
		            var iDate, iDate2, year, month, day;
		            year = 1202;
		            month = 1;
		            day = 29;
		            weekday = 1;
		            iDate = new dojox.date.umalqura.Date(year, month, day);
		            iDate.setFullYear(year);
		            iDate.setMonth(month);
		            iDate.setDate(day);

		            t.is(year, iDate.getFullYear());
		            t.is(month, iDate.getMonth());
		            t.is(day, iDate.getDate());
		        }
		        //Special Case #4
		        {
		            var iDate, iDate2, year, month, day;
		            year = 1202;
		            month = 1;
		            day = 29;
		            weekday = 1;
		            iDate = new dojox.date.umalqura.Date(year, month, day);
		            iDate.setFullYear(year);
		            iDate.setMonth(month);
		            iDate.setDate(day);

		            t.is(year, iDate.getFullYear());
		            t.is(month, iDate.getMonth());
		            t.is(day, iDate.getDate());
		        }
		    }
		},

		{
		    name: "consistency_of_add_and_difference",
		    runTest: function (t) {
		        var dateIslamicAdd;
		        var dateDiff;
		        var dateIslamicAdd;
		        var dateIslamic;
		        var dateIslamicAdd2;
		        var inputDates = [];
		        var tmpDate1;
		        tmpDate1 = new dojox.date.umalqura.Date(1420, 11, 30);

		        var tmpDate2 = new dojox.date.umalqura.Date(1421, 0, 1);
		        var tmpDateDiff = dojox.date.umalqura.difference(tmpDate1, tmpDate2, "day");

		        dateIslamic = new dojox.date.umalqura.Date(1480, 11, 30);
		        dateIslamic = tmpDate1;
		        dateIslamicAdd = dojox.date.umalqura.add(dateIslamic, "day", 0);
		        dateDiff = dojox.date.umalqura.difference(dateIslamicAdd, dateIslamic, "day");
		        var dateDiff2 = dojox.date.umalqura.difference(dateIslamic, dateIslamic, "day");
		        var amounts = [-1, 0, 1, 2, 5, 6, 7, 8, 12, 18, 20, 24, 50, -3, -4, -5, -6, -7, -8, -9, -10,
				              -50, 200, -200];
		        var units = [
				           "year",
				           "month",
				           "day",
    			           "weekday",
				           "hour",
				           "minute",
				           "second",
				           "millisecond"
		        ];
		        dojo.forEach(inputDates, function (inDate, i) {
		            dojo.forEach(amounts, function (amount, j) {
		                dojo.forEach(units, function (unit, k) {
		                    dateIslamic = new dojox.date.umalqura.Date(inDate[0], inDate[1], inDate[2]);
		                    dateIslamicAdd = dojox.date.umalqura.add(dateIslamic, unit, amount);
		                    dateDiff = dojox.date.umalqura.difference(dateIslamicAdd, dateIslamic, unit);
		                    t.is(dateDiff, amount);
		                });

		                dateIslamic = new dojox.date.umalqura.Date(inDate[0], inDate[1], inDate[2]);

		                dateIslamicAdd = dojox.date.umalqura.add(dateIslamic, "month", amount);
		                dateDiff = dojox.date.umalqura.difference(dateIslamicAdd, dateIslamic, "month");
		                t.is(dateDiff, amount);

		                dateIslamicAdd = dojox.date.umalqura.add(dateIslamic, "year", amount);
		                dateDiff = dojox.date.umalqura.difference(dateIslamicAdd, dateIslamic, "year");
		                t.is(dateDiff, amount);

		                dateIslamicAdd = dojox.date.umalqura.add(dateIslamic, "day", amount);
		                dateDiff = dojox.date.umalqura.difference(dateIslamicAdd, dateIslamic, "day");
		                t.is(dateDiff, amount);

		                dateIslamicAdd = dojox.date.umalqura.add(dateIslamic, "weekday", amount);
		                dateDiff = dojox.date.umalqura.difference(dateIslamicAdd, dateIslamic, "weekday");
		                t.is(dateDiff, amount);
		            });
		        });

		        var tmpDate1;
		        var x = 9;
		        var month = 4;
		        var year = 1480 + x;
		        var day1 = 3;
		        var day2 = 4;
		        var tmpDate1 = new dojox.date.umalqura.Date(year, month, 3);
		        var tmpDate2 = new dojox.date.umalqura.Date(year, month, 4);

		        var tmpDateDiff = dojox.date.umalqura.difference(tmpDate1, tmpDate2, "day");
		        t.is(tmpDate2.getFullYear(), year);
		        t.is(tmpDate2.getMonth(), month);
		    }

		},
		{
		    name: "set_get_date_after_1480",
		    runTest: function (t) {
		        var tmpDate1;
		        var x = 9;
		        var month = 4;
		        var year = 1480 + x;
		        var day1 = 3;
		        var day2 = 4;
		        var tmpDate2 = new dojox.date.umalqura.Date(year, month, day2);

		        t.is(tmpDate2.getFullYear(), year);
		        t.is(tmpDate2.getMonth(), month);
		        t.is(tmpDate2.getDate(), day2);
		    }
		},

		{
		    name: "get_date",
		    runTest: function (t) {
		        dates = [
                        [1350, 2, 16],
                        [1351, 11, 18],
                        [1352, 4, 12],
                        [1353, 3, 15],
                        [1354, 9, 14],
                        [1355, 9, 17],
                        [1356, 11, 18],
                        [1357, 11, 16],
                        [1358, 1, 10],
                        [1359, 0, 16],
                        [1360, 7, 15],
                        [1361, 10, 14],
                        [1362, 10, 21],
                        [1363, 4, 19],
                        [1364, 4, 14],
                        [1365, 3, 20],
                        [1366, 11, 16],
                        [1367, 0, 20],
                        [1368, 3, 10],
                        [1369, 9, 21],
                        [1370, 6, 21],
                        [1371, 4, 11],
                        [1372, 0, 19],
                        [1373, 8, 14],
                        [1374, 4, 18],
                        [1375, 4, 13],
                        [1376, 3, 13],
                        [1377, 11, 16],
                        [1378, 4, 15],
                        [1379, 6, 11],
                        [1380, 11, 11],
                        [1381, 3, 19],
                        [1382, 6, 13],
                        [1383, 6, 17],
                        [1384, 6, 19],
                        [1385, 10, 18],
                        [1386, 1, 14],
                        [1387, 5, 16],
                        [1388, 11, 12],
                        [1389, 9, 13],
                        [1390, 3, 16],
                        [1391, 10, 14],
                        [1392, 2, 10],
                        [1393, 8, 14],
                        [1394, 0, 13],
                        [1395, 1, 21],
                        [1396, 5, 10],
                        [1397, 7, 14],
                        [1398, 5, 17],
                        [1399, 7, 13],
                        [1400, 5, 13],
                        [1401, 6, 11],
                        [1402, 2, 11],
                        [1403, 4, 10],
                        [1404, 8, 13],
                        [1405, 11, 17],
                        [1406, 11, 21],
                        [1407, 0, 17],
                        [1408, 7, 19],
                        [1409, 6, 13],
                        [1410, 0, 13],
                        [1411, 4, 18],
                        [1412, 10, 19],
                        [1413, 2, 18],
                        [1414, 3, 19],
                        [1415, 8, 14],
                        [1416, 11, 16],
                        [1417, 2, 16],
                        [1418, 10, 20],
                        [1419, 7, 15],
                        [1420, 4, 16],
                        [1421, 7, 20],
                        [1422, 3, 13],
                        [1423, 6, 15],
                        [1424, 10, 17],
                        [1425, 7, 13],
                        [1426, 9, 10],
                        [1427, 9, 19],
                        [1428, 11, 18],
                        [1429, 10, 18],
                        [1430, 0, 21],
                        [1431, 4, 10],
                        [1432, 1, 17],
                        [1433, 10, 18],
                        [1434, 11, 19],
                        [1435, 7, 15],
                        [1436, 2, 15],
                        [1437, 5, 16],
                        [1438, 4, 21],
                        [1439, 3, 17],
                        [1440, 1, 16],
                        [1441, 5, 20],
                        [1442, 5, 21],
                        [1443, 11, 11],
                        [1444, 2, 10],
                        [1445, 2, 12],
                        [1446, 2, 14],
                        [1447, 1, 10],
                        [1448, 0, 15],
                        [1449, 4, 13],
                        [1450, 10, 11],
                        [1451, 2, 16],
                        [1452, 10, 20],
                        [1453, 7, 11],
                        [1454, 7, 11],
                        [1455, 1, 15],
                        [1456, 3, 13],
                        [1457, 1, 13],
                        [1458, 2, 13],
                        [1459, 7, 12],
                        [1460, 4, 10],
                        [1461, 4, 21],
                        [1462, 7, 18],
                        [1463, 7, 16],
                        [1464, 9, 10],
                        [1465, 6, 21],
                        [1466, 1, 21],
                        [1467, 0, 16],
                        [1468, 9, 17],
                        [1469, 7, 16],
                        [1470, 10, 19],
                        [1471, 10, 21],
                        [1472, 8, 16],
                        [1473, 10, 16],
                        [1474, 3, 12],
                        [1475, 6, 21],
                        [1476, 2, 10],
                        [1477, 0, 12],
                        [1478, 0, 14],
                        [1479, 7, 20],
                        [1480, 0, 1],
                        [1480, 11, 29],
                        [1480, 11, 30],
                        [1481, 0, 1],
                        [1480, 0, 2],
                        [1481, 0, 11],
                        [1482, 7, 18],
                        [1483, 7, 21],
                        [1484, 1, 10],
                        [1485, 3, 15],
                        [1486, 10, 16],
                        [1487, 5, 10],
                        [1488, 4, 21],
                        [1489, 5, 19],
                        [1490, 1, 21],
                        [1491, 0, 19],
                        [1492, 1, 18],
                        [1493, 2, 13],
                        [1494, 4, 17],
                        [1495, 3, 19],
                        [1496, 9, 10],
                        [1497, 3, 14],
                        [1498, 1, 13],
                        [1499, 3, 13]
		        ];
		        var currentDate;
		        dojo.forEach(dates, function (cDate, i) {
		            currentDate = new dojox.date.umalqura.Date(cDate[0], cDate[1], cDate[2]);
		            t.is(currentDate.getFullYear(), cDate[0]);
		            t.is(currentDate.getMonth(), cDate[1]);
		            t.is(currentDate.getDate(), cDate[2]);
		        });
		    }
		},

		{
		    name: "getMonth_setMonth",
		    runTest: function (t) {
		        var dateIslamic = new dojox.date.umalqura.Date(1420, 1, 1);
		        for (var year = 1420; year < 1430; year++) {
		            dateIslamic.setFullYear(year);
		            t.is(year, dateIslamic.getFullYear());
		            dateIslamic.setMonth(11);
		            t.is(11, dateIslamic.getMonth());
		            dateIslamic.setMonth(6);
		            t.is(6, dateIslamic.getMonth());

		        }
		    }
		},
		{
		    name: "parse_and_format",
		    runTest: function (t) {

		        //test Islamic and English locale
		        var dates = [
							[1430, 5, 1],
							[1428, 1, 28],
							[1431, 5, 16],
							[1431, 11, 2],
							[1433, 0, 2]
		        ];

		        var dateIslamic, dateIslamic1;
		        dojo.forEach(dates, function (date, i) {
		            dateIslamic = new dojox.date.umalqura.Date(date[0], date[1], date[2]);

		            var options = [{ formatLength: 'full', locale: 'ar' }, { formatLength: 'long', locale: 'ar' }, { formatLength: 'medium', locale: 'ar' }, { formatLength: 'short', locale: 'ar' },
						{ formatLength: 'full', locale: 'en' }, { formatLength: 'long', locale: 'en' }, { formatLength: 'medium', locale: 'en' }, { formatLength: 'short', locale: 'en' }];
		            dojo.forEach(options, function (opt, i) {
		                str = dojox.date.umalqura.locale.format(dateIslamic, opt);
		                var option = "{" + opt + ", locale:'ar'}";
		                dateIslamic1 = dojox.date.umalqura.locale.parse(str, opt);
		                t.is(0, dojo.date.compare(dateIslamic.toGregorian(), dateIslamic1.toGregorian(), 'date'));
		            });

		            var pattern = ['d M yy', 'dd/MM/yy h:m:s', 'dd#MM#yy HH$mm$ss', 'dd MMMM yyyy'];
		            dojo.forEach(pattern, function (pat, i) {
		                options = { datePattern: pat, selector: 'date', locale: 'ar' };
		                str = dojox.date.umalqura.locale.format(dateIslamic, options);
		                dateIslamic1 = dojox.date.umalqura.locale.parse(str, options);
		                t.is(0, dojo.date.compare(dateIslamic.toGregorian(), dateIslamic1.toGregorian(), 'date'));
		            });
		        });

		        dateIslamic = new dojox.date.umalqura.Date(1431, 6, 3, 15, 3, 59);
		        pattern = 'HH$mm$ss';
		        options = { timePattern: pattern, selector: 'time' };
		        str = dojox.date.umalqura.locale.format(dateIslamic, options);
		        dateIslamic1 = dojox.date.umalqura.locale.parse(str, options);
		        var gregDate = dojo.date.locale.parse(str, options);
		        t.is(0, dojo.date.compare(gregDate, dateIslamic1.toGregorian(), 'time'));

		        pattern = "h:m:s";
		        options = { timePattern: pattern, selector: 'time' };
		        str = dojox.date.umalqura.locale.format(dateIslamic, options);
		        t.is(str, "3:3:59");
		    }
		},
	]
);
