/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSYSLOG_OUTPUT_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_OUTPUT_INCLUDE_RECURSION_GUARD

#include "dsyslog_event.h"

/* A syslog output. */
typedef struct dsyslog_output_ dsyslog_output_t;
typedef void (*dsyslog_output_handler_t)(dsyslog_event_t *event, dsyslog_output_t *output);
typedef void (*dsyslog_output_destructor_t)(dsyslog_output_t *output);

struct dsyslog_output_ {
	gchar *type;
	gchar *path;
	gchar *host;
	gint port;
	gchar *dbuser;
	gchar *dbpass;
	gchar *dbhost;
	gchar *dbname;
	gint dbport;
	gpointer opaque;
	dsyslog_output_handler_t handler;
	dsyslog_output_destructor_t destructor;
	GList *conditions;
};

extern void dsyslog_output_type_register(gchar *type, dsyslog_output_handler_t hdl);
extern void dsyslog_output_type_unregister(gchar *type);
extern void dsyslog_output_add(dsyslog_output_t *output);
extern void dsyslog_output_remove(dsyslog_output_t *output);
extern void dsyslog_output_process(dsyslog_event_t *event);
extern void dsyslog_output_clear(void);

#endif
