/////////////////////////////////////////////////////////////////////////////
// Name:        CellPropDlg.h
// Purpose:     DVD cell properties dialog
// Author:      Alex Thuering
// Created:     23.04.2011
// RCS-ID:      $Id: CellPropDlg.h,v 1.5 2013/06/30 13:24:47 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
#ifndef CELL_PROP_DLG_H
#define CELL_PROP_DLG_H

#include <wx/wx.h>
#include <wx/image.h>
#include "DVD.h"

//(*Headers(CellPropDlg)
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/spinctrl.h>
#include <wx/radiobut.h>
#include <wx/slider.h>
#include <wx/choice.h>
#include <wx/dialog.h>
#include <wx/spinbutt.h>
#include <wx/combobox.h>
//*)
#include "mediactrl_ffmpeg.h"

class CellPropDlg: public wxDialog {
public:
	/** Constructor */
    CellPropDlg(wxWindow* parent, DVD* dvd, int tsi, int pgci, Vob* vob, Cell* cell);
    /** Destructor */
	virtual ~CellPropDlg();

private:
    DVD* m_dvd;
    int m_tsi;
    int m_pgci;
    Vob* m_vob;
    Cell* m_cell;
    
	//(*Declarations(CellPropDlg)
	wxSpinCtrl* m_pauseSpin;
	wxRadioButton* m_regularBt;
	wxSlider* m_slider;
	wxStaticText* StaticText2;
	wxSpinButton* m_frameSpinBt;
	wxComboBox* m_commandsCtrl;
	MediaCtrlFF* m_mediaCtrl;
	wxTextCtrl* m_timeCtrl;
	wxSpinButton* m_endSpinBt;
	wxTextCtrl* m_endCtrl;
	wxRadioButton* m_programBt;
	wxRadioButton* m_chapterBt;
	wxSpinButton* m_endFrameSpinBt;
	wxChoice* m_endChoice;
	wxSpinButton* m_timeSpinBt;
	//*)
	
	//(*Identifiers(CellPropDlg)
	static const long ID_MEDIA_CTRL;
	static const long ID_SLIDER;
	static const long ID_TIME_CTRL;
	static const long ID_TIME_SPINB;
	static const long ID_FRAME_SPINBT;
	static const long ID_DURATION_CTRL;
	static const long ID_STATICTEXT1;
	static const long ID_CHOICE1;
	static const long ID_END_CTRL;
	static const long ID_END_SPIN;
	static const long ID_END_FRAME_SPINBT;
	static const long ID_RADIOBUTTON1;
	static const long ID_RADIOBUTTON2;
	static const long ID_RADIOBUTTON3;
	static const long ID_COMMANDS_CTRL;
	//*)
	
	void SeekVideo(long pos, bool updateTimeCtrl = true);
	//(*Handlers(CellPropDlg)
	void OnChangeTime(wxCommandEvent& event);
	void OnTimeSpin(wxSpinEvent& event);
	void OnSliderScroll(wxScrollEvent& event);
	void OnEndChoice(wxCommandEvent& event);
	void OnChangeEnd(wxCommandEvent& event);
	void OnEndSpin(wxSpinEvent& event);
	void OnFrameSpin(wxSpinEvent& event);
	void OnEndFrameSpin(wxSpinEvent& event);
	void OnFrameSpinDown(wxSpinEvent& event);
	void OnEndFrameSpinDown(wxSpinEvent& event);
	//*)
	void OnOkBt(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()
};

#endif // CELL_PROP_DLG_H
